// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)`.
    func teamsList(_ input: Operations.TeamsList.Input) async throws -> Operations.TeamsList.Output
    /// Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/articles/setting-team-creation-permissions-in-your-organization)."
    ///
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)`.
    func teamsCreate(_ input: Operations.TeamsCreate.Input) async throws -> Operations.TeamsCreate.Output
    /// Get a team by name
    ///
    /// Gets a team using the team's `slug`. To create the `slug`, GitHub replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)`.
    func teamsGetByName(_ input: Operations.TeamsGetByName.Input) async throws -> Operations.TeamsGetByName.Output
    /// Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)`.
    func teamsUpdateInOrg(_ input: Operations.TeamsUpdateInOrg.Input) async throws -> Operations.TeamsUpdateInOrg.Output
    /// Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)`.
    func teamsDeleteInOrg(_ input: Operations.TeamsDeleteInOrg.Input) async throws -> Operations.TeamsDeleteInOrg.Output
    /// List discussions
    ///
    /// List all discussions on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/get(teams/list-discussions-in-org)`.
    func teamsListDiscussionsInOrg(_ input: Operations.TeamsListDiscussionsInOrg.Input) async throws -> Operations.TeamsListDiscussionsInOrg.Output
    /// Create a discussion
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/post(teams/create-discussion-in-org)`.
    func teamsCreateDiscussionInOrg(_ input: Operations.TeamsCreateDiscussionInOrg.Input) async throws -> Operations.TeamsCreateDiscussionInOrg.Output
    /// Get a discussion
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/get(teams/get-discussion-in-org)`.
    func teamsGetDiscussionInOrg(_ input: Operations.TeamsGetDiscussionInOrg.Input) async throws -> Operations.TeamsGetDiscussionInOrg.Output
    /// Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/patch(teams/update-discussion-in-org)`.
    func teamsUpdateDiscussionInOrg(_ input: Operations.TeamsUpdateDiscussionInOrg.Input) async throws -> Operations.TeamsUpdateDiscussionInOrg.Output
    /// Delete a discussion
    ///
    /// Delete a discussion from a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)`.
    func teamsDeleteDiscussionInOrg(_ input: Operations.TeamsDeleteDiscussionInOrg.Input) async throws -> Operations.TeamsDeleteDiscussionInOrg.Output
    /// List discussion comments
    ///
    /// List all comments on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-in-org)`.
    func teamsListDiscussionCommentsInOrg(_ input: Operations.TeamsListDiscussionCommentsInOrg.Input) async throws -> Operations.TeamsListDiscussionCommentsInOrg.Output
    /// Create a discussion comment
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-in-org)`.
    func teamsCreateDiscussionCommentInOrg(_ input: Operations.TeamsCreateDiscussionCommentInOrg.Input) async throws -> Operations.TeamsCreateDiscussionCommentInOrg.Output
    /// Get a discussion comment
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-in-org)`.
    func teamsGetDiscussionCommentInOrg(_ input: Operations.TeamsGetDiscussionCommentInOrg.Input) async throws -> Operations.TeamsGetDiscussionCommentInOrg.Output
    /// Update a discussion comment
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-in-org)`.
    func teamsUpdateDiscussionCommentInOrg(_ input: Operations.TeamsUpdateDiscussionCommentInOrg.Input) async throws -> Operations.TeamsUpdateDiscussionCommentInOrg.Output
    /// Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)`.
    func teamsDeleteDiscussionCommentInOrg(_ input: Operations.TeamsDeleteDiscussionCommentInOrg.Input) async throws -> Operations.TeamsDeleteDiscussionCommentInOrg.Output
    /// List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/invitations/get(teams/list-pending-invitations-in-org)`.
    func teamsListPendingInvitationsInOrg(_ input: Operations.TeamsListPendingInvitationsInOrg.Input) async throws -> Operations.TeamsListPendingInvitationsInOrg.Output
    /// List team members
    ///
    /// Team members will include the members of child teams.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/members/get(teams/list-members-in-org)`.
    func teamsListMembersInOrg(_ input: Operations.TeamsListMembersInOrg.Input) async throws -> Operations.TeamsListMembersInOrg.Output
    /// Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// > [!NOTE]
    /// > The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)`.
    func teamsGetMembershipForUserInOrg(_ input: Operations.TeamsGetMembershipForUserInOrg.Input) async throws -> Operations.TeamsGetMembershipForUserInOrg.Output
    /// Add or update team membership for a user
    ///
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)`.
    func teamsAddOrUpdateMembershipForUserInOrg(_ input: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input) async throws -> Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output
    /// Remove team membership for a user
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)`.
    func teamsRemoveMembershipForUserInOrg(_ input: Operations.TeamsRemoveMembershipForUserInOrg.Input) async throws -> Operations.TeamsRemoveMembershipForUserInOrg.Output
    /// List team projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/get(teams/list-projects-in-org)`.
    @available(*, deprecated)
    func teamsListProjectsInOrg(_ input: Operations.TeamsListProjectsInOrg.Input) async throws -> Operations.TeamsListProjectsInOrg.Output
    /// Check team permissions for a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)`.
    @available(*, deprecated)
    func teamsCheckPermissionsForProjectInOrg(_ input: Operations.TeamsCheckPermissionsForProjectInOrg.Input) async throws -> Operations.TeamsCheckPermissionsForProjectInOrg.Output
    /// Add or update team project permissions
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)`.
    @available(*, deprecated)
    func teamsAddOrUpdateProjectPermissionsInOrg(_ input: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output
    /// Remove a project from a team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)`.
    @available(*, deprecated)
    func teamsRemoveProjectInOrg(_ input: Operations.TeamsRemoveProjectInOrg.Input) async throws -> Operations.TeamsRemoveProjectInOrg.Output
    /// List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/get(teams/list-repos-in-org)`.
    func teamsListReposInOrg(_ input: Operations.TeamsListReposInOrg.Input) async throws -> Operations.TeamsListReposInOrg.Output
    /// Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    ///
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    ///
    /// If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)`.
    func teamsCheckPermissionsForRepoInOrg(_ input: Operations.TeamsCheckPermissionsForRepoInOrg.Input) async throws -> Operations.TeamsCheckPermissionsForRepoInOrg.Output
    /// Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)`.
    func teamsAddOrUpdateRepoPermissionsInOrg(_ input: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Output
    /// Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)`.
    func teamsRemoveRepoInOrg(_ input: Operations.TeamsRemoveRepoInOrg.Input) async throws -> Operations.TeamsRemoveRepoInOrg.Output
    /// List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/teams/get(teams/list-child-in-org)`.
    func teamsListChildInOrg(_ input: Operations.TeamsListChildInOrg.Input) async throws -> Operations.TeamsListChildInOrg.Output
    /// Get a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/teams/teams#get-a-team-by-name) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)`.
    @available(*, deprecated)
    func teamsGetLegacy(_ input: Operations.TeamsGetLegacy.Input) async throws -> Operations.TeamsGetLegacy.Output
    /// Update a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/teams/teams#update-a-team) endpoint.
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > With nested teams, the `privacy` for parent teams cannot be `secret`.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)`.
    @available(*, deprecated)
    func teamsUpdateLegacy(_ input: Operations.TeamsUpdateLegacy.Input) async throws -> Operations.TeamsUpdateLegacy.Output
    /// Delete a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/teams/teams#delete-a-team) endpoint.
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)`.
    @available(*, deprecated)
    func teamsDeleteLegacy(_ input: Operations.TeamsDeleteLegacy.Input) async throws -> Operations.TeamsDeleteLegacy.Output
    /// List discussions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/teams/discussions#list-discussions) endpoint.
    ///
    /// List all discussions on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/get(teams/list-discussions-legacy)`.
    @available(*, deprecated)
    func teamsListDiscussionsLegacy(_ input: Operations.TeamsListDiscussionsLegacy.Input) async throws -> Operations.TeamsListDiscussionsLegacy.Output
    /// Create a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/teams/discussions#create-a-discussion) endpoint.
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/post(teams/create-discussion-legacy)`.
    @available(*, deprecated)
    func teamsCreateDiscussionLegacy(_ input: Operations.TeamsCreateDiscussionLegacy.Input) async throws -> Operations.TeamsCreateDiscussionLegacy.Output
    /// Get a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion) endpoint.
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/get(teams/get-discussion-legacy)`.
    @available(*, deprecated)
    func teamsGetDiscussionLegacy(_ input: Operations.TeamsGetDiscussionLegacy.Input) async throws -> Operations.TeamsGetDiscussionLegacy.Output
    /// Update a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/teams/discussions#update-a-discussion) endpoint.
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/patch(teams/update-discussion-legacy)`.
    @available(*, deprecated)
    func teamsUpdateDiscussionLegacy(_ input: Operations.TeamsUpdateDiscussionLegacy.Input) async throws -> Operations.TeamsUpdateDiscussionLegacy.Output
    /// Delete a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/teams/discussions#delete-a-discussion) endpoint.
    ///
    /// Delete a discussion from a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)`.
    @available(*, deprecated)
    func teamsDeleteDiscussionLegacy(_ input: Operations.TeamsDeleteDiscussionLegacy.Input) async throws -> Operations.TeamsDeleteDiscussionLegacy.Output
    /// List discussion comments (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments) endpoint.
    ///
    /// List all comments on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-legacy)`.
    @available(*, deprecated)
    func teamsListDiscussionCommentsLegacy(_ input: Operations.TeamsListDiscussionCommentsLegacy.Input) async throws -> Operations.TeamsListDiscussionCommentsLegacy.Output
    /// Create a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment) endpoint.
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-legacy)`.
    @available(*, deprecated)
    func teamsCreateDiscussionCommentLegacy(_ input: Operations.TeamsCreateDiscussionCommentLegacy.Input) async throws -> Operations.TeamsCreateDiscussionCommentLegacy.Output
    /// Get a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment) endpoint.
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-legacy)`.
    @available(*, deprecated)
    func teamsGetDiscussionCommentLegacy(_ input: Operations.TeamsGetDiscussionCommentLegacy.Input) async throws -> Operations.TeamsGetDiscussionCommentLegacy.Output
    /// Update a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment) endpoint.
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-legacy)`.
    @available(*, deprecated)
    func teamsUpdateDiscussionCommentLegacy(_ input: Operations.TeamsUpdateDiscussionCommentLegacy.Input) async throws -> Operations.TeamsUpdateDiscussionCommentLegacy.Output
    /// Delete a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)`.
    @available(*, deprecated)
    func teamsDeleteDiscussionCommentLegacy(_ input: Operations.TeamsDeleteDiscussionCommentLegacy.Input) async throws -> Operations.TeamsDeleteDiscussionCommentLegacy.Output
    /// List pending team invitations (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/teams/members#list-pending-team-invitations) endpoint.
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/invitations`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/invitations/get(teams/list-pending-invitations-legacy)`.
    @available(*, deprecated)
    func teamsListPendingInvitationsLegacy(_ input: Operations.TeamsListPendingInvitationsLegacy.Input) async throws -> Operations.TeamsListPendingInvitationsLegacy.Output
    /// List team members (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/teams/members#list-team-members) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)`.
    @available(*, deprecated)
    func teamsListMembersLegacy(_ input: Operations.TeamsListMembersLegacy.Input) async throws -> Operations.TeamsListMembersLegacy.Output
    /// Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)`.
    @available(*, deprecated)
    func teamsGetMemberLegacy(_ input: Operations.TeamsGetMemberLegacy.Input) async throws -> Operations.TeamsGetMemberLegacy.Output
    /// Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)`.
    @available(*, deprecated)
    func teamsAddMemberLegacy(_ input: Operations.TeamsAddMemberLegacy.Input) async throws -> Operations.TeamsAddMemberLegacy.Output
    /// Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)`.
    @available(*, deprecated)
    func teamsRemoveMemberLegacy(_ input: Operations.TeamsRemoveMemberLegacy.Input) async throws -> Operations.TeamsRemoveMemberLegacy.Output
    /// Get team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)`.
    @available(*, deprecated)
    func teamsGetMembershipForUserLegacy(_ input: Operations.TeamsGetMembershipForUserLegacy.Input) async throws -> Operations.TeamsGetMembershipForUserLegacy.Output
    /// Add or update team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)`.
    @available(*, deprecated)
    func teamsAddOrUpdateMembershipForUserLegacy(_ input: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input) async throws -> Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output
    /// Remove team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)`.
    @available(*, deprecated)
    func teamsRemoveMembershipForUserLegacy(_ input: Operations.TeamsRemoveMembershipForUserLegacy.Input) async throws -> Operations.TeamsRemoveMembershipForUserLegacy.Output
    /// List team projects (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)`.
    @available(*, deprecated)
    func teamsListProjectsLegacy(_ input: Operations.TeamsListProjectsLegacy.Input) async throws -> Operations.TeamsListProjectsLegacy.Output
    /// Check team permissions for a project (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)`.
    @available(*, deprecated)
    func teamsCheckPermissionsForProjectLegacy(_ input: Operations.TeamsCheckPermissionsForProjectLegacy.Input) async throws -> Operations.TeamsCheckPermissionsForProjectLegacy.Output
    /// Add or update team project permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)`.
    @available(*, deprecated)
    func teamsAddOrUpdateProjectPermissionsLegacy(_ input: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output
    /// Remove a project from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)`.
    @available(*, deprecated)
    func teamsRemoveProjectLegacy(_ input: Operations.TeamsRemoveProjectLegacy.Input) async throws -> Operations.TeamsRemoveProjectLegacy.Output
    /// List team repositories (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/teams/teams#list-team-repositories) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)`.
    @available(*, deprecated)
    func teamsListReposLegacy(_ input: Operations.TeamsListReposLegacy.Input) async throws -> Operations.TeamsListReposLegacy.Output
    /// Check team permissions for a repository (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository) endpoint.
    ///
    /// > [!NOTE]
    /// > Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)`.
    @available(*, deprecated)
    func teamsCheckPermissionsForRepoLegacy(_ input: Operations.TeamsCheckPermissionsForRepoLegacy.Input) async throws -> Operations.TeamsCheckPermissionsForRepoLegacy.Output
    /// Add or update team repository permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)`.
    @available(*, deprecated)
    func teamsAddOrUpdateRepoPermissionsLegacy(_ input: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Output
    /// Remove a repository from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team) endpoint.
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)`.
    @available(*, deprecated)
    func teamsRemoveRepoLegacy(_ input: Operations.TeamsRemoveRepoLegacy.Input) async throws -> Operations.TeamsRemoveRepoLegacy.Output
    /// List child teams (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/teams/teams#list-child-teams) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/teams`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)`.
    @available(*, deprecated)
    func teamsListChildLegacy(_ input: Operations.TeamsListChildLegacy.Input) async throws -> Operations.TeamsListChildLegacy.Output
    /// List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated
    /// user belongs.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.
    ///
    /// When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.
    ///
    /// - Remark: HTTP `GET /user/teams`.
    /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)`.
    func teamsListForAuthenticatedUser(_ input: Operations.TeamsListForAuthenticatedUser.Input) async throws -> Operations.TeamsListForAuthenticatedUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)`.
    public func teamsList(
        path: Operations.TeamsList.Input.Path,
        query: Operations.TeamsList.Input.Query = .init(),
        headers: Operations.TeamsList.Input.Headers = .init()
    ) async throws -> Operations.TeamsList.Output {
        try await teamsList(Operations.TeamsList.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/articles/setting-team-creation-permissions-in-your-organization)."
    ///
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)`.
    public func teamsCreate(
        path: Operations.TeamsCreate.Input.Path,
        headers: Operations.TeamsCreate.Input.Headers = .init(),
        body: Operations.TeamsCreate.Input.Body
    ) async throws -> Operations.TeamsCreate.Output {
        try await teamsCreate(Operations.TeamsCreate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a team by name
    ///
    /// Gets a team using the team's `slug`. To create the `slug`, GitHub replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)`.
    public func teamsGetByName(
        path: Operations.TeamsGetByName.Input.Path,
        headers: Operations.TeamsGetByName.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetByName.Output {
        try await teamsGetByName(Operations.TeamsGetByName.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)`.
    public func teamsUpdateInOrg(
        path: Operations.TeamsUpdateInOrg.Input.Path,
        headers: Operations.TeamsUpdateInOrg.Input.Headers = .init(),
        body: Operations.TeamsUpdateInOrg.Input.Body? = nil
    ) async throws -> Operations.TeamsUpdateInOrg.Output {
        try await teamsUpdateInOrg(Operations.TeamsUpdateInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)`.
    public func teamsDeleteInOrg(path: Operations.TeamsDeleteInOrg.Input.Path) async throws -> Operations.TeamsDeleteInOrg.Output {
        try await teamsDeleteInOrg(Operations.TeamsDeleteInOrg.Input(path: path))
    }
    /// List discussions
    ///
    /// List all discussions on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/get(teams/list-discussions-in-org)`.
    public func teamsListDiscussionsInOrg(
        path: Operations.TeamsListDiscussionsInOrg.Input.Path,
        query: Operations.TeamsListDiscussionsInOrg.Input.Query = .init(),
        headers: Operations.TeamsListDiscussionsInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListDiscussionsInOrg.Output {
        try await teamsListDiscussionsInOrg(Operations.TeamsListDiscussionsInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a discussion
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/post(teams/create-discussion-in-org)`.
    public func teamsCreateDiscussionInOrg(
        path: Operations.TeamsCreateDiscussionInOrg.Input.Path,
        headers: Operations.TeamsCreateDiscussionInOrg.Input.Headers = .init(),
        body: Operations.TeamsCreateDiscussionInOrg.Input.Body
    ) async throws -> Operations.TeamsCreateDiscussionInOrg.Output {
        try await teamsCreateDiscussionInOrg(Operations.TeamsCreateDiscussionInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a discussion
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/get(teams/get-discussion-in-org)`.
    public func teamsGetDiscussionInOrg(
        path: Operations.TeamsGetDiscussionInOrg.Input.Path,
        headers: Operations.TeamsGetDiscussionInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetDiscussionInOrg.Output {
        try await teamsGetDiscussionInOrg(Operations.TeamsGetDiscussionInOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/patch(teams/update-discussion-in-org)`.
    public func teamsUpdateDiscussionInOrg(
        path: Operations.TeamsUpdateDiscussionInOrg.Input.Path,
        headers: Operations.TeamsUpdateDiscussionInOrg.Input.Headers = .init(),
        body: Operations.TeamsUpdateDiscussionInOrg.Input.Body? = nil
    ) async throws -> Operations.TeamsUpdateDiscussionInOrg.Output {
        try await teamsUpdateDiscussionInOrg(Operations.TeamsUpdateDiscussionInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a discussion
    ///
    /// Delete a discussion from a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)`.
    public func teamsDeleteDiscussionInOrg(path: Operations.TeamsDeleteDiscussionInOrg.Input.Path) async throws -> Operations.TeamsDeleteDiscussionInOrg.Output {
        try await teamsDeleteDiscussionInOrg(Operations.TeamsDeleteDiscussionInOrg.Input(path: path))
    }
    /// List discussion comments
    ///
    /// List all comments on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-in-org)`.
    public func teamsListDiscussionCommentsInOrg(
        path: Operations.TeamsListDiscussionCommentsInOrg.Input.Path,
        query: Operations.TeamsListDiscussionCommentsInOrg.Input.Query = .init(),
        headers: Operations.TeamsListDiscussionCommentsInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListDiscussionCommentsInOrg.Output {
        try await teamsListDiscussionCommentsInOrg(Operations.TeamsListDiscussionCommentsInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a discussion comment
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-in-org)`.
    public func teamsCreateDiscussionCommentInOrg(
        path: Operations.TeamsCreateDiscussionCommentInOrg.Input.Path,
        headers: Operations.TeamsCreateDiscussionCommentInOrg.Input.Headers = .init(),
        body: Operations.TeamsCreateDiscussionCommentInOrg.Input.Body
    ) async throws -> Operations.TeamsCreateDiscussionCommentInOrg.Output {
        try await teamsCreateDiscussionCommentInOrg(Operations.TeamsCreateDiscussionCommentInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a discussion comment
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-in-org)`.
    public func teamsGetDiscussionCommentInOrg(
        path: Operations.TeamsGetDiscussionCommentInOrg.Input.Path,
        headers: Operations.TeamsGetDiscussionCommentInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetDiscussionCommentInOrg.Output {
        try await teamsGetDiscussionCommentInOrg(Operations.TeamsGetDiscussionCommentInOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a discussion comment
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-in-org)`.
    public func teamsUpdateDiscussionCommentInOrg(
        path: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Path,
        headers: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Headers = .init(),
        body: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Body
    ) async throws -> Operations.TeamsUpdateDiscussionCommentInOrg.Output {
        try await teamsUpdateDiscussionCommentInOrg(Operations.TeamsUpdateDiscussionCommentInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)`.
    public func teamsDeleteDiscussionCommentInOrg(path: Operations.TeamsDeleteDiscussionCommentInOrg.Input.Path) async throws -> Operations.TeamsDeleteDiscussionCommentInOrg.Output {
        try await teamsDeleteDiscussionCommentInOrg(Operations.TeamsDeleteDiscussionCommentInOrg.Input(path: path))
    }
    /// List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/invitations/get(teams/list-pending-invitations-in-org)`.
    public func teamsListPendingInvitationsInOrg(
        path: Operations.TeamsListPendingInvitationsInOrg.Input.Path,
        query: Operations.TeamsListPendingInvitationsInOrg.Input.Query = .init(),
        headers: Operations.TeamsListPendingInvitationsInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListPendingInvitationsInOrg.Output {
        try await teamsListPendingInvitationsInOrg(Operations.TeamsListPendingInvitationsInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List team members
    ///
    /// Team members will include the members of child teams.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/members/get(teams/list-members-in-org)`.
    public func teamsListMembersInOrg(
        path: Operations.TeamsListMembersInOrg.Input.Path,
        query: Operations.TeamsListMembersInOrg.Input.Query = .init(),
        headers: Operations.TeamsListMembersInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListMembersInOrg.Output {
        try await teamsListMembersInOrg(Operations.TeamsListMembersInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// > [!NOTE]
    /// > The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)`.
    public func teamsGetMembershipForUserInOrg(
        path: Operations.TeamsGetMembershipForUserInOrg.Input.Path,
        headers: Operations.TeamsGetMembershipForUserInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetMembershipForUserInOrg.Output {
        try await teamsGetMembershipForUserInOrg(Operations.TeamsGetMembershipForUserInOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team membership for a user
    ///
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)`.
    public func teamsAddOrUpdateMembershipForUserInOrg(
        path: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Path,
        headers: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Headers = .init(),
        body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output {
        try await teamsAddOrUpdateMembershipForUserInOrg(Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove team membership for a user
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)`.
    public func teamsRemoveMembershipForUserInOrg(path: Operations.TeamsRemoveMembershipForUserInOrg.Input.Path) async throws -> Operations.TeamsRemoveMembershipForUserInOrg.Output {
        try await teamsRemoveMembershipForUserInOrg(Operations.TeamsRemoveMembershipForUserInOrg.Input(path: path))
    }
    /// List team projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/get(teams/list-projects-in-org)`.
    @available(*, deprecated)
    public func teamsListProjectsInOrg(
        path: Operations.TeamsListProjectsInOrg.Input.Path,
        query: Operations.TeamsListProjectsInOrg.Input.Query = .init(),
        headers: Operations.TeamsListProjectsInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListProjectsInOrg.Output {
        try await teamsListProjectsInOrg(Operations.TeamsListProjectsInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check team permissions for a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForProjectInOrg(
        path: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Path,
        headers: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsCheckPermissionsForProjectInOrg.Output {
        try await teamsCheckPermissionsForProjectInOrg(Operations.TeamsCheckPermissionsForProjectInOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team project permissions
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateProjectPermissionsInOrg(
        path: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Path,
        headers: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Headers = .init(),
        body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output {
        try await teamsAddOrUpdateProjectPermissionsInOrg(Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove a project from a team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)`.
    @available(*, deprecated)
    public func teamsRemoveProjectInOrg(path: Operations.TeamsRemoveProjectInOrg.Input.Path) async throws -> Operations.TeamsRemoveProjectInOrg.Output {
        try await teamsRemoveProjectInOrg(Operations.TeamsRemoveProjectInOrg.Input(path: path))
    }
    /// List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/get(teams/list-repos-in-org)`.
    public func teamsListReposInOrg(
        path: Operations.TeamsListReposInOrg.Input.Path,
        query: Operations.TeamsListReposInOrg.Input.Query = .init(),
        headers: Operations.TeamsListReposInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListReposInOrg.Output {
        try await teamsListReposInOrg(Operations.TeamsListReposInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    ///
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    ///
    /// If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)`.
    public func teamsCheckPermissionsForRepoInOrg(
        path: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Path,
        headers: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsCheckPermissionsForRepoInOrg.Output {
        try await teamsCheckPermissionsForRepoInOrg(Operations.TeamsCheckPermissionsForRepoInOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)`.
    public func teamsAddOrUpdateRepoPermissionsInOrg(
        path: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Path,
        body: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Output {
        try await teamsAddOrUpdateRepoPermissionsInOrg(Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input(
            path: path,
            body: body
        ))
    }
    /// Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)`.
    public func teamsRemoveRepoInOrg(path: Operations.TeamsRemoveRepoInOrg.Input.Path) async throws -> Operations.TeamsRemoveRepoInOrg.Output {
        try await teamsRemoveRepoInOrg(Operations.TeamsRemoveRepoInOrg.Input(path: path))
    }
    /// List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/teams/get(teams/list-child-in-org)`.
    public func teamsListChildInOrg(
        path: Operations.TeamsListChildInOrg.Input.Path,
        query: Operations.TeamsListChildInOrg.Input.Query = .init(),
        headers: Operations.TeamsListChildInOrg.Input.Headers = .init()
    ) async throws -> Operations.TeamsListChildInOrg.Output {
        try await teamsListChildInOrg(Operations.TeamsListChildInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/teams/teams#get-a-team-by-name) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)`.
    @available(*, deprecated)
    public func teamsGetLegacy(
        path: Operations.TeamsGetLegacy.Input.Path,
        headers: Operations.TeamsGetLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetLegacy.Output {
        try await teamsGetLegacy(Operations.TeamsGetLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/teams/teams#update-a-team) endpoint.
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > With nested teams, the `privacy` for parent teams cannot be `secret`.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateLegacy(
        path: Operations.TeamsUpdateLegacy.Input.Path,
        headers: Operations.TeamsUpdateLegacy.Input.Headers = .init(),
        body: Operations.TeamsUpdateLegacy.Input.Body
    ) async throws -> Operations.TeamsUpdateLegacy.Output {
        try await teamsUpdateLegacy(Operations.TeamsUpdateLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/teams/teams#delete-a-team) endpoint.
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteLegacy(
        path: Operations.TeamsDeleteLegacy.Input.Path,
        headers: Operations.TeamsDeleteLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsDeleteLegacy.Output {
        try await teamsDeleteLegacy(Operations.TeamsDeleteLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// List discussions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/teams/discussions#list-discussions) endpoint.
    ///
    /// List all discussions on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/get(teams/list-discussions-legacy)`.
    @available(*, deprecated)
    public func teamsListDiscussionsLegacy(
        path: Operations.TeamsListDiscussionsLegacy.Input.Path,
        query: Operations.TeamsListDiscussionsLegacy.Input.Query = .init(),
        headers: Operations.TeamsListDiscussionsLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListDiscussionsLegacy.Output {
        try await teamsListDiscussionsLegacy(Operations.TeamsListDiscussionsLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/teams/discussions#create-a-discussion) endpoint.
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/post(teams/create-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsCreateDiscussionLegacy(
        path: Operations.TeamsCreateDiscussionLegacy.Input.Path,
        headers: Operations.TeamsCreateDiscussionLegacy.Input.Headers = .init(),
        body: Operations.TeamsCreateDiscussionLegacy.Input.Body
    ) async throws -> Operations.TeamsCreateDiscussionLegacy.Output {
        try await teamsCreateDiscussionLegacy(Operations.TeamsCreateDiscussionLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion) endpoint.
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/get(teams/get-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsGetDiscussionLegacy(
        path: Operations.TeamsGetDiscussionLegacy.Input.Path,
        headers: Operations.TeamsGetDiscussionLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetDiscussionLegacy.Output {
        try await teamsGetDiscussionLegacy(Operations.TeamsGetDiscussionLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/teams/discussions#update-a-discussion) endpoint.
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/patch(teams/update-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateDiscussionLegacy(
        path: Operations.TeamsUpdateDiscussionLegacy.Input.Path,
        headers: Operations.TeamsUpdateDiscussionLegacy.Input.Headers = .init(),
        body: Operations.TeamsUpdateDiscussionLegacy.Input.Body? = nil
    ) async throws -> Operations.TeamsUpdateDiscussionLegacy.Output {
        try await teamsUpdateDiscussionLegacy(Operations.TeamsUpdateDiscussionLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/teams/discussions#delete-a-discussion) endpoint.
    ///
    /// Delete a discussion from a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteDiscussionLegacy(path: Operations.TeamsDeleteDiscussionLegacy.Input.Path) async throws -> Operations.TeamsDeleteDiscussionLegacy.Output {
        try await teamsDeleteDiscussionLegacy(Operations.TeamsDeleteDiscussionLegacy.Input(path: path))
    }
    /// List discussion comments (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments) endpoint.
    ///
    /// List all comments on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-legacy)`.
    @available(*, deprecated)
    public func teamsListDiscussionCommentsLegacy(
        path: Operations.TeamsListDiscussionCommentsLegacy.Input.Path,
        query: Operations.TeamsListDiscussionCommentsLegacy.Input.Query = .init(),
        headers: Operations.TeamsListDiscussionCommentsLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListDiscussionCommentsLegacy.Output {
        try await teamsListDiscussionCommentsLegacy(Operations.TeamsListDiscussionCommentsLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment) endpoint.
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsCreateDiscussionCommentLegacy(
        path: Operations.TeamsCreateDiscussionCommentLegacy.Input.Path,
        headers: Operations.TeamsCreateDiscussionCommentLegacy.Input.Headers = .init(),
        body: Operations.TeamsCreateDiscussionCommentLegacy.Input.Body
    ) async throws -> Operations.TeamsCreateDiscussionCommentLegacy.Output {
        try await teamsCreateDiscussionCommentLegacy(Operations.TeamsCreateDiscussionCommentLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment) endpoint.
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsGetDiscussionCommentLegacy(
        path: Operations.TeamsGetDiscussionCommentLegacy.Input.Path,
        headers: Operations.TeamsGetDiscussionCommentLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetDiscussionCommentLegacy.Output {
        try await teamsGetDiscussionCommentLegacy(Operations.TeamsGetDiscussionCommentLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment) endpoint.
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateDiscussionCommentLegacy(
        path: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Path,
        headers: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Headers = .init(),
        body: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Body
    ) async throws -> Operations.TeamsUpdateDiscussionCommentLegacy.Output {
        try await teamsUpdateDiscussionCommentLegacy(Operations.TeamsUpdateDiscussionCommentLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteDiscussionCommentLegacy(path: Operations.TeamsDeleteDiscussionCommentLegacy.Input.Path) async throws -> Operations.TeamsDeleteDiscussionCommentLegacy.Output {
        try await teamsDeleteDiscussionCommentLegacy(Operations.TeamsDeleteDiscussionCommentLegacy.Input(path: path))
    }
    /// List pending team invitations (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/teams/members#list-pending-team-invitations) endpoint.
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/invitations`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/invitations/get(teams/list-pending-invitations-legacy)`.
    @available(*, deprecated)
    public func teamsListPendingInvitationsLegacy(
        path: Operations.TeamsListPendingInvitationsLegacy.Input.Path,
        query: Operations.TeamsListPendingInvitationsLegacy.Input.Query = .init(),
        headers: Operations.TeamsListPendingInvitationsLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListPendingInvitationsLegacy.Output {
        try await teamsListPendingInvitationsLegacy(Operations.TeamsListPendingInvitationsLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List team members (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/teams/members#list-team-members) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)`.
    @available(*, deprecated)
    public func teamsListMembersLegacy(
        path: Operations.TeamsListMembersLegacy.Input.Path,
        query: Operations.TeamsListMembersLegacy.Input.Query = .init(),
        headers: Operations.TeamsListMembersLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListMembersLegacy.Output {
        try await teamsListMembersLegacy(Operations.TeamsListMembersLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)`.
    @available(*, deprecated)
    public func teamsGetMemberLegacy(path: Operations.TeamsGetMemberLegacy.Input.Path) async throws -> Operations.TeamsGetMemberLegacy.Output {
        try await teamsGetMemberLegacy(Operations.TeamsGetMemberLegacy.Input(path: path))
    }
    /// Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)`.
    @available(*, deprecated)
    public func teamsAddMemberLegacy(
        path: Operations.TeamsAddMemberLegacy.Input.Path,
        headers: Operations.TeamsAddMemberLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsAddMemberLegacy.Output {
        try await teamsAddMemberLegacy(Operations.TeamsAddMemberLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveMemberLegacy(path: Operations.TeamsRemoveMemberLegacy.Input.Path) async throws -> Operations.TeamsRemoveMemberLegacy.Output {
        try await teamsRemoveMemberLegacy(Operations.TeamsRemoveMemberLegacy.Input(path: path))
    }
    /// Get team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsGetMembershipForUserLegacy(
        path: Operations.TeamsGetMembershipForUserLegacy.Input.Path,
        headers: Operations.TeamsGetMembershipForUserLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsGetMembershipForUserLegacy.Output {
        try await teamsGetMembershipForUserLegacy(Operations.TeamsGetMembershipForUserLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateMembershipForUserLegacy(
        path: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Path,
        headers: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Headers = .init(),
        body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output {
        try await teamsAddOrUpdateMembershipForUserLegacy(Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveMembershipForUserLegacy(path: Operations.TeamsRemoveMembershipForUserLegacy.Input.Path) async throws -> Operations.TeamsRemoveMembershipForUserLegacy.Output {
        try await teamsRemoveMembershipForUserLegacy(Operations.TeamsRemoveMembershipForUserLegacy.Input(path: path))
    }
    /// List team projects (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)`.
    @available(*, deprecated)
    public func teamsListProjectsLegacy(
        path: Operations.TeamsListProjectsLegacy.Input.Path,
        query: Operations.TeamsListProjectsLegacy.Input.Query = .init(),
        headers: Operations.TeamsListProjectsLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListProjectsLegacy.Output {
        try await teamsListProjectsLegacy(Operations.TeamsListProjectsLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check team permissions for a project (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForProjectLegacy(
        path: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Path,
        headers: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsCheckPermissionsForProjectLegacy.Output {
        try await teamsCheckPermissionsForProjectLegacy(Operations.TeamsCheckPermissionsForProjectLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team project permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateProjectPermissionsLegacy(
        path: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Path,
        headers: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Headers = .init(),
        body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output {
        try await teamsAddOrUpdateProjectPermissionsLegacy(Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove a project from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveProjectLegacy(
        path: Operations.TeamsRemoveProjectLegacy.Input.Path,
        headers: Operations.TeamsRemoveProjectLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsRemoveProjectLegacy.Output {
        try await teamsRemoveProjectLegacy(Operations.TeamsRemoveProjectLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// List team repositories (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/teams/teams#list-team-repositories) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)`.
    @available(*, deprecated)
    public func teamsListReposLegacy(
        path: Operations.TeamsListReposLegacy.Input.Path,
        query: Operations.TeamsListReposLegacy.Input.Query = .init(),
        headers: Operations.TeamsListReposLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListReposLegacy.Output {
        try await teamsListReposLegacy(Operations.TeamsListReposLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check team permissions for a repository (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository) endpoint.
    ///
    /// > [!NOTE]
    /// > Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForRepoLegacy(
        path: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Path,
        headers: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsCheckPermissionsForRepoLegacy.Output {
        try await teamsCheckPermissionsForRepoLegacy(Operations.TeamsCheckPermissionsForRepoLegacy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add or update team repository permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateRepoPermissionsLegacy(
        path: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Path,
        headers: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Headers = .init(),
        body: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body? = nil
    ) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Output {
        try await teamsAddOrUpdateRepoPermissionsLegacy(Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove a repository from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team) endpoint.
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveRepoLegacy(path: Operations.TeamsRemoveRepoLegacy.Input.Path) async throws -> Operations.TeamsRemoveRepoLegacy.Output {
        try await teamsRemoveRepoLegacy(Operations.TeamsRemoveRepoLegacy.Input(path: path))
    }
    /// List child teams (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/teams/teams#list-child-teams) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/teams`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)`.
    @available(*, deprecated)
    public func teamsListChildLegacy(
        path: Operations.TeamsListChildLegacy.Input.Path,
        query: Operations.TeamsListChildLegacy.Input.Query = .init(),
        headers: Operations.TeamsListChildLegacy.Input.Headers = .init()
    ) async throws -> Operations.TeamsListChildLegacy.Output {
        try await teamsListChildLegacy(Operations.TeamsListChildLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated
    /// user belongs.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.
    ///
    /// When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.
    ///
    /// - Remark: HTTP `GET /user/teams`.
    /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)`.
    public func teamsListForAuthenticatedUser(
        query: Operations.TeamsListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.TeamsListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.TeamsListForAuthenticatedUser.Output {
        try await teamsListForAuthenticatedUser(Operations.TeamsListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            public var _type: Components.Schemas.NullableTeamSimple._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil,
                _type: Components.Schemas.NullableTeamSimple._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            public var _type: Components.Schemas.Team._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                _type: Components.Schemas.Team._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
                case parent
            }
        }
        /// Organization Invitation
        ///
        /// - Remark: Generated from `#/components/schemas/organization-invitation`.
        public struct OrganizationInvitation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/organization-invitation/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/organization-invitation/login`.
            public var login: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/role`.
            public var role: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/failed_at`.
            public var failedAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/failed_reason`.
            public var failedReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-invitation/inviter`.
            public var inviter: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/organization-invitation/team_count`.
            public var teamCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/organization-invitation/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/invitation_teams_url`.
            public var invitationTeamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-invitation/invitation_source`.
            public var invitationSource: Swift.String?
            /// Creates a new `OrganizationInvitation`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - login:
            ///   - email:
            ///   - role:
            ///   - createdAt:
            ///   - failedAt:
            ///   - failedReason:
            ///   - inviter:
            ///   - teamCount:
            ///   - nodeId:
            ///   - invitationTeamsUrl:
            ///   - invitationSource:
            public init(
                id: Swift.Int64,
                login: Swift.String? = nil,
                email: Swift.String? = nil,
                role: Swift.String,
                createdAt: Swift.String,
                failedAt: Swift.String? = nil,
                failedReason: Swift.String? = nil,
                inviter: Components.Schemas.SimpleUser,
                teamCount: Swift.Int,
                nodeId: Swift.String,
                invitationTeamsUrl: Swift.String,
                invitationSource: Swift.String? = nil
            ) {
                self.id = id
                self.login = login
                self.email = email
                self.role = role
                self.createdAt = createdAt
                self.failedAt = failedAt
                self.failedReason = failedReason
                self.inviter = inviter
                self.teamCount = teamCount
                self.nodeId = nodeId
                self.invitationTeamsUrl = invitationTeamsUrl
                self.invitationSource = invitationSource
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case login
                case email
                case role
                case createdAt = "created_at"
                case failedAt = "failed_at"
                case failedReason = "failed_reason"
                case inviter
                case teamCount = "team_count"
                case nodeId = "node_id"
                case invitationTeamsUrl = "invitation_teams_url"
                case invitationSource = "invitation_source"
            }
        }
        /// Team Organization
        ///
        /// - Remark: Generated from `#/components/schemas/team-organization`.
        public struct TeamOrganization: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team-organization/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-organization/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/public_members_url`.
            public var publicMembersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/twitter_username`.
            public var twitterUsername: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/is_verified`.
            public var isVerified: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/has_organization_projects`.
            public var hasOrganizationProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-organization/has_repository_projects`.
            public var hasRepositoryProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-organization/public_repos`.
            public var publicRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-organization/public_gists`.
            public var publicGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-organization/followers`.
            public var followers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-organization/following`.
            public var following: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-organization/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-organization/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-organization/total_private_repos`.
            public var totalPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-organization/owned_private_repos`.
            public var ownedPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-organization/private_gists`.
            public var privateGists: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-organization/disk_usage`.
            public var diskUsage: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-organization/collaborators`.
            public var collaborators: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-organization/billing_email`.
            public var billingEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/plan`.
            public struct PlanPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team-organization/plan/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/team-organization/plan/space`.
                public var space: Swift.Int
                /// - Remark: Generated from `#/components/schemas/team-organization/plan/private_repos`.
                public var privateRepos: Swift.Int
                /// - Remark: Generated from `#/components/schemas/team-organization/plan/filled_seats`.
                public var filledSeats: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/team-organization/plan/seats`.
                public var seats: Swift.Int?
                /// Creates a new `PlanPayload`.
                ///
                /// - Parameters:
                ///   - name:
                ///   - space:
                ///   - privateRepos:
                ///   - filledSeats:
                ///   - seats:
                public init(
                    name: Swift.String,
                    space: Swift.Int,
                    privateRepos: Swift.Int,
                    filledSeats: Swift.Int? = nil,
                    seats: Swift.Int? = nil
                ) {
                    self.name = name
                    self.space = space
                    self.privateRepos = privateRepos
                    self.filledSeats = filledSeats
                    self.seats = seats
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case space
                    case privateRepos = "private_repos"
                    case filledSeats = "filled_seats"
                    case seats
                }
            }
            /// - Remark: Generated from `#/components/schemas/team-organization/plan`.
            public var plan: Components.Schemas.TeamOrganization.PlanPayload?
            /// - Remark: Generated from `#/components/schemas/team-organization/default_repository_permission`.
            public var defaultRepositoryPermission: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_repositories`.
            public var membersCanCreateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/two_factor_requirement_enabled`.
            public var twoFactorRequirementEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_allowed_repository_creation_type`.
            public var membersAllowedRepositoryCreationType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_public_repositories`.
            public var membersCanCreatePublicRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_private_repositories`.
            public var membersCanCreatePrivateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_internal_repositories`.
            public var membersCanCreateInternalRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_pages`.
            public var membersCanCreatePages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_public_pages`.
            public var membersCanCreatePublicPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_create_private_pages`.
            public var membersCanCreatePrivatePages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/members_can_fork_private_repositories`.
            public var membersCanForkPrivateRepositories: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-organization/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-organization/archived_at`.
            public var archivedAt: Foundation.Date?
            /// Creates a new `TeamOrganization`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - hooksUrl:
            ///   - issuesUrl:
            ///   - membersUrl:
            ///   - publicMembersUrl:
            ///   - avatarUrl:
            ///   - description:
            ///   - name:
            ///   - company:
            ///   - blog:
            ///   - location:
            ///   - email:
            ///   - twitterUsername:
            ///   - isVerified:
            ///   - hasOrganizationProjects:
            ///   - hasRepositoryProjects:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - _type:
            ///   - totalPrivateRepos:
            ///   - ownedPrivateRepos:
            ///   - privateGists:
            ///   - diskUsage:
            ///   - collaborators:
            ///   - billingEmail:
            ///   - plan:
            ///   - defaultRepositoryPermission:
            ///   - membersCanCreateRepositories:
            ///   - twoFactorRequirementEnabled:
            ///   - membersAllowedRepositoryCreationType:
            ///   - membersCanCreatePublicRepositories:
            ///   - membersCanCreatePrivateRepositories:
            ///   - membersCanCreateInternalRepositories:
            ///   - membersCanCreatePages:
            ///   - membersCanCreatePublicPages:
            ///   - membersCanCreatePrivatePages:
            ///   - membersCanForkPrivateRepositories:
            ///   - webCommitSignoffRequired:
            ///   - updatedAt:
            ///   - archivedAt:
            public init(
                login: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                hooksUrl: Swift.String,
                issuesUrl: Swift.String,
                membersUrl: Swift.String,
                publicMembersUrl: Swift.String,
                avatarUrl: Swift.String,
                description: Swift.String? = nil,
                name: Swift.String? = nil,
                company: Swift.String? = nil,
                blog: Swift.String? = nil,
                location: Swift.String? = nil,
                email: Swift.String? = nil,
                twitterUsername: Swift.String? = nil,
                isVerified: Swift.Bool? = nil,
                hasOrganizationProjects: Swift.Bool,
                hasRepositoryProjects: Swift.Bool,
                publicRepos: Swift.Int,
                publicGists: Swift.Int,
                followers: Swift.Int,
                following: Swift.Int,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                _type: Swift.String,
                totalPrivateRepos: Swift.Int? = nil,
                ownedPrivateRepos: Swift.Int? = nil,
                privateGists: Swift.Int? = nil,
                diskUsage: Swift.Int? = nil,
                collaborators: Swift.Int? = nil,
                billingEmail: Swift.String? = nil,
                plan: Components.Schemas.TeamOrganization.PlanPayload? = nil,
                defaultRepositoryPermission: Swift.String? = nil,
                membersCanCreateRepositories: Swift.Bool? = nil,
                twoFactorRequirementEnabled: Swift.Bool? = nil,
                membersAllowedRepositoryCreationType: Swift.String? = nil,
                membersCanCreatePublicRepositories: Swift.Bool? = nil,
                membersCanCreatePrivateRepositories: Swift.Bool? = nil,
                membersCanCreateInternalRepositories: Swift.Bool? = nil,
                membersCanCreatePages: Swift.Bool? = nil,
                membersCanCreatePublicPages: Swift.Bool? = nil,
                membersCanCreatePrivatePages: Swift.Bool? = nil,
                membersCanForkPrivateRepositories: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                updatedAt: Foundation.Date,
                archivedAt: Foundation.Date? = nil
            ) {
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.hooksUrl = hooksUrl
                self.issuesUrl = issuesUrl
                self.membersUrl = membersUrl
                self.publicMembersUrl = publicMembersUrl
                self.avatarUrl = avatarUrl
                self.description = description
                self.name = name
                self.company = company
                self.blog = blog
                self.location = location
                self.email = email
                self.twitterUsername = twitterUsername
                self.isVerified = isVerified
                self.hasOrganizationProjects = hasOrganizationProjects
                self.hasRepositoryProjects = hasRepositoryProjects
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self._type = _type
                self.totalPrivateRepos = totalPrivateRepos
                self.ownedPrivateRepos = ownedPrivateRepos
                self.privateGists = privateGists
                self.diskUsage = diskUsage
                self.collaborators = collaborators
                self.billingEmail = billingEmail
                self.plan = plan
                self.defaultRepositoryPermission = defaultRepositoryPermission
                self.membersCanCreateRepositories = membersCanCreateRepositories
                self.twoFactorRequirementEnabled = twoFactorRequirementEnabled
                self.membersAllowedRepositoryCreationType = membersAllowedRepositoryCreationType
                self.membersCanCreatePublicRepositories = membersCanCreatePublicRepositories
                self.membersCanCreatePrivateRepositories = membersCanCreatePrivateRepositories
                self.membersCanCreateInternalRepositories = membersCanCreateInternalRepositories
                self.membersCanCreatePages = membersCanCreatePages
                self.membersCanCreatePublicPages = membersCanCreatePublicPages
                self.membersCanCreatePrivatePages = membersCanCreatePrivatePages
                self.membersCanForkPrivateRepositories = membersCanForkPrivateRepositories
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.updatedAt = updatedAt
                self.archivedAt = archivedAt
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case nodeId = "node_id"
                case url
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case hooksUrl = "hooks_url"
                case issuesUrl = "issues_url"
                case membersUrl = "members_url"
                case publicMembersUrl = "public_members_url"
                case avatarUrl = "avatar_url"
                case description
                case name
                case company
                case blog
                case location
                case email
                case twitterUsername = "twitter_username"
                case isVerified = "is_verified"
                case hasOrganizationProjects = "has_organization_projects"
                case hasRepositoryProjects = "has_repository_projects"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case _type = "type"
                case totalPrivateRepos = "total_private_repos"
                case ownedPrivateRepos = "owned_private_repos"
                case privateGists = "private_gists"
                case diskUsage = "disk_usage"
                case collaborators
                case billingEmail = "billing_email"
                case plan
                case defaultRepositoryPermission = "default_repository_permission"
                case membersCanCreateRepositories = "members_can_create_repositories"
                case twoFactorRequirementEnabled = "two_factor_requirement_enabled"
                case membersAllowedRepositoryCreationType = "members_allowed_repository_creation_type"
                case membersCanCreatePublicRepositories = "members_can_create_public_repositories"
                case membersCanCreatePrivateRepositories = "members_can_create_private_repositories"
                case membersCanCreateInternalRepositories = "members_can_create_internal_repositories"
                case membersCanCreatePages = "members_can_create_pages"
                case membersCanCreatePublicPages = "members_can_create_public_pages"
                case membersCanCreatePrivatePages = "members_can_create_private_pages"
                case membersCanForkPrivateRepositories = "members_can_fork_private_repositories"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case updatedAt = "updated_at"
                case archivedAt = "archived_at"
            }
        }
        /// The [distinguished name](https://www.ldap.com/ldap-dns-and-rdns) (DN) of the LDAP entry to map to a team.
        ///
        /// - Remark: Generated from `#/components/schemas/ldap-dn`.
        public typealias LdapDn = Swift.String
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team-full`.
        public struct TeamFull: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-full/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/html_url`.
            public var htmlUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/description`.
            public var description: Swift.String?
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/privacy`.
            @frozen public enum PrivacyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case closed = "closed"
                case secret = "secret"
            }
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/privacy`.
            public var privacy: Components.Schemas.TeamFull.PrivacyPayload?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/notification_setting`.
            @frozen public enum NotificationSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case notificationsEnabled = "notifications_enabled"
                case notificationsDisabled = "notifications_disabled"
            }
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/notification_setting`.
            public var notificationSetting: Components.Schemas.TeamFull.NotificationSettingPayload?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-full/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// - Remark: Generated from `#/components/schemas/team-full/members_count`.
            public var membersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-full/repos_count`.
            public var reposCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-full/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-full/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-full/organization`.
            public var organization: Components.Schemas.TeamOrganization
            /// - Remark: Generated from `#/components/schemas/team-full/ldap_dn`.
            public var ldapDn: Components.Schemas.LdapDn?
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/type`.
            public var _type: Components.Schemas.TeamFull._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team-full/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// Creates a new `TeamFull`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - htmlUrl:
            ///   - name: Name of the team
            ///   - slug:
            ///   - description:
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - permission: Permission that the team will have for its repositories
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            ///   - membersCount:
            ///   - reposCount:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - organization:
            ///   - ldapDn:
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                htmlUrl: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Components.Schemas.TeamFull.PrivacyPayload? = nil,
                notificationSetting: Components.Schemas.TeamFull.NotificationSettingPayload? = nil,
                permission: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil,
                membersCount: Swift.Int,
                reposCount: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                organization: Components.Schemas.TeamOrganization,
                ldapDn: Components.Schemas.LdapDn? = nil,
                _type: Components.Schemas.TeamFull._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.htmlUrl = htmlUrl
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
                self.membersCount = membersCount
                self.reposCount = reposCount
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.organization = organization
                self.ldapDn = ldapDn
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case htmlUrl = "html_url"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
                case membersCount = "members_count"
                case reposCount = "repos_count"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case organization
                case ldapDn = "ldap_dn"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
            }
        }
        /// A team discussion is a persistent record of a free-form conversation within a team.
        ///
        /// - Remark: Generated from `#/components/schemas/team-discussion`.
        public struct TeamDiscussion: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team-discussion/author`.
            public var author: Components.Schemas.NullableSimpleUser?
            /// The main text of the discussion.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/body_html`.
            public var bodyHtml: Swift.String
            /// The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/body_version`.
            public var bodyVersion: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/comments_count`.
            public var commentsCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-discussion/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-discussion/last_edited_at`.
            public var lastEditedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/team-discussion/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/node_id`.
            public var nodeId: Swift.String
            /// The unique sequence number of a team discussion.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/number`.
            public var number: Swift.Int
            /// Whether or not this discussion should be pinned for easy retrieval.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/pinned`.
            public var pinned: Swift.Bool
            /// Whether or not this discussion should be restricted to team members and organization owners.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-discussion/team_url`.
            public var teamUrl: Swift.String
            /// The title of the discussion.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-discussion/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `TeamDiscussion`.
            ///
            /// - Parameters:
            ///   - author:
            ///   - body: The main text of the discussion.
            ///   - bodyHtml:
            ///   - bodyVersion: The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
            ///   - commentsCount:
            ///   - commentsUrl:
            ///   - createdAt:
            ///   - lastEditedAt:
            ///   - htmlUrl:
            ///   - nodeId:
            ///   - number: The unique sequence number of a team discussion.
            ///   - pinned: Whether or not this discussion should be pinned for easy retrieval.
            ///   - _private: Whether or not this discussion should be restricted to team members and organization owners.
            ///   - teamUrl:
            ///   - title: The title of the discussion.
            ///   - updatedAt:
            ///   - url:
            ///   - reactions:
            public init(
                author: Components.Schemas.NullableSimpleUser? = nil,
                body: Swift.String,
                bodyHtml: Swift.String,
                bodyVersion: Swift.String,
                commentsCount: Swift.Int,
                commentsUrl: Swift.String,
                createdAt: Foundation.Date,
                lastEditedAt: Foundation.Date? = nil,
                htmlUrl: Swift.String,
                nodeId: Swift.String,
                number: Swift.Int,
                pinned: Swift.Bool,
                _private: Swift.Bool,
                teamUrl: Swift.String,
                title: Swift.String,
                updatedAt: Foundation.Date,
                url: Swift.String,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.author = author
                self.body = body
                self.bodyHtml = bodyHtml
                self.bodyVersion = bodyVersion
                self.commentsCount = commentsCount
                self.commentsUrl = commentsUrl
                self.createdAt = createdAt
                self.lastEditedAt = lastEditedAt
                self.htmlUrl = htmlUrl
                self.nodeId = nodeId
                self.number = number
                self.pinned = pinned
                self._private = _private
                self.teamUrl = teamUrl
                self.title = title
                self.updatedAt = updatedAt
                self.url = url
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case author
                case body
                case bodyHtml = "body_html"
                case bodyVersion = "body_version"
                case commentsCount = "comments_count"
                case commentsUrl = "comments_url"
                case createdAt = "created_at"
                case lastEditedAt = "last_edited_at"
                case htmlUrl = "html_url"
                case nodeId = "node_id"
                case number
                case pinned
                case _private = "private"
                case teamUrl = "team_url"
                case title
                case updatedAt = "updated_at"
                case url
                case reactions
            }
        }
        /// A reply to a discussion within a team.
        ///
        /// - Remark: Generated from `#/components/schemas/team-discussion-comment`.
        public struct TeamDiscussionComment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/author`.
            public var author: Components.Schemas.NullableSimpleUser?
            /// The main text of the comment.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/body_html`.
            public var bodyHtml: Swift.String
            /// The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/body_version`.
            public var bodyVersion: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/last_edited_at`.
            public var lastEditedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/discussion_url`.
            public var discussionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/node_id`.
            public var nodeId: Swift.String
            /// The unique sequence number of a team discussion comment.
            ///
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-discussion-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `TeamDiscussionComment`.
            ///
            /// - Parameters:
            ///   - author:
            ///   - body: The main text of the comment.
            ///   - bodyHtml:
            ///   - bodyVersion: The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
            ///   - createdAt:
            ///   - lastEditedAt:
            ///   - discussionUrl:
            ///   - htmlUrl:
            ///   - nodeId:
            ///   - number: The unique sequence number of a team discussion comment.
            ///   - updatedAt:
            ///   - url:
            ///   - reactions:
            public init(
                author: Components.Schemas.NullableSimpleUser? = nil,
                body: Swift.String,
                bodyHtml: Swift.String,
                bodyVersion: Swift.String,
                createdAt: Foundation.Date,
                lastEditedAt: Foundation.Date? = nil,
                discussionUrl: Swift.String,
                htmlUrl: Swift.String,
                nodeId: Swift.String,
                number: Swift.Int,
                updatedAt: Foundation.Date,
                url: Swift.String,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.author = author
                self.body = body
                self.bodyHtml = bodyHtml
                self.bodyVersion = bodyVersion
                self.createdAt = createdAt
                self.lastEditedAt = lastEditedAt
                self.discussionUrl = discussionUrl
                self.htmlUrl = htmlUrl
                self.nodeId = nodeId
                self.number = number
                self.updatedAt = updatedAt
                self.url = url
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case author
                case body
                case bodyHtml = "body_html"
                case bodyVersion = "body_version"
                case createdAt = "created_at"
                case lastEditedAt = "last_edited_at"
                case discussionUrl = "discussion_url"
                case htmlUrl = "html_url"
                case nodeId = "node_id"
                case number
                case updatedAt = "updated_at"
                case url
                case reactions
            }
        }
        /// Team Membership
        ///
        /// - Remark: Generated from `#/components/schemas/team-membership`.
        public struct TeamMembership: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team-membership/url`.
            public var url: Swift.String
            /// The role of the user in the team.
            ///
            /// - Remark: Generated from `#/components/schemas/team-membership/role`.
            @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case member = "member"
                case maintainer = "maintainer"
            }
            /// The role of the user in the team.
            ///
            /// - Remark: Generated from `#/components/schemas/team-membership/role`.
            public var role: Components.Schemas.TeamMembership.RolePayload
            /// The state of the user's membership in the team.
            ///
            /// - Remark: Generated from `#/components/schemas/team-membership/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case active = "active"
                case pending = "pending"
            }
            /// The state of the user's membership in the team.
            ///
            /// - Remark: Generated from `#/components/schemas/team-membership/state`.
            public var state: Components.Schemas.TeamMembership.StatePayload
            /// Creates a new `TeamMembership`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - role: The role of the user in the team.
            ///   - state: The state of the user's membership in the team.
            public init(
                url: Swift.String,
                role: Components.Schemas.TeamMembership.RolePayload,
                state: Components.Schemas.TeamMembership.StatePayload
            ) {
                self.url = url
                self.role = role
                self.state = state
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case role
                case state
            }
        }
        /// A team's access to a project.
        ///
        /// - Remark: Generated from `#/components/schemas/team-project`.
        public struct TeamProject: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team-project/owner_url`.
            public var ownerUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/columns_url`.
            public var columnsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-project/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-project/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-project/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/creator`.
            public var creator: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/team-project/created_at`.
            public var createdAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-project/updated_at`.
            public var updatedAt: Swift.String
            /// The organization permission for this project. Only present when owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/team-project/organization_permission`.
            public var organizationPermission: Swift.String?
            /// Whether the project is private or not. Only present when owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/team-project/private`.
            public var _private: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-project/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team-project/permissions/read`.
                public var read: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-project/permissions/write`.
                public var write: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-project/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - read:
                ///   - write:
                ///   - admin:
                public init(
                    read: Swift.Bool,
                    write: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.read = read
                    self.write = write
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case read
                    case write
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team-project/permissions`.
            public var permissions: Components.Schemas.TeamProject.PermissionsPayload
            /// Creates a new `TeamProject`.
            ///
            /// - Parameters:
            ///   - ownerUrl:
            ///   - url:
            ///   - htmlUrl:
            ///   - columnsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - body:
            ///   - number:
            ///   - state:
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - organizationPermission: The organization permission for this project. Only present when owner is an organization.
            ///   - _private: Whether the project is private or not. Only present when owner is an organization.
            ///   - permissions:
            public init(
                ownerUrl: Swift.String,
                url: Swift.String,
                htmlUrl: Swift.String,
                columnsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                body: Swift.String? = nil,
                number: Swift.Int,
                state: Swift.String,
                creator: Components.Schemas.SimpleUser,
                createdAt: Swift.String,
                updatedAt: Swift.String,
                organizationPermission: Swift.String? = nil,
                _private: Swift.Bool? = nil,
                permissions: Components.Schemas.TeamProject.PermissionsPayload
            ) {
                self.ownerUrl = ownerUrl
                self.url = url
                self.htmlUrl = htmlUrl
                self.columnsUrl = columnsUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.body = body
                self.number = number
                self.state = state
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.organizationPermission = organizationPermission
                self._private = _private
                self.permissions = permissions
            }
            public enum CodingKeys: String, CodingKey {
                case ownerUrl = "owner_url"
                case url
                case htmlUrl = "html_url"
                case columnsUrl = "columns_url"
                case id
                case nodeId = "node_id"
                case name
                case body
                case number
                case state
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case organizationPermission = "organization_permission"
                case _private = "private"
                case permissions
            }
        }
        /// A team's access to a repository.
        ///
        /// - Remark: Generated from `#/components/schemas/team-repository`.
        public struct TeamRepository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/team-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/team-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/team-repository/permissions`.
            public var permissions: Components.Schemas.TeamRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/owner`.
            public var owner: Components.Schemas.NullableSimpleUser?
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/team-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/has_downloads`.
            public var hasDownloads: Swift.Bool
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/team-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/team-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/team-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/team-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// Creates a new `TeamRepository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - roleName:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size:
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.TeamRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                owner: Components.Schemas.NullableSimpleUser? = nil,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.roleName = roleName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case roleName = "role_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The slug of the team name.
        ///
        /// - Remark: Generated from `#/components/parameters/team-slug`.
        public typealias TeamSlug = Swift.String
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The number that identifies the discussion.
        ///
        /// - Remark: Generated from `#/components/parameters/discussion-number`.
        public typealias DiscussionNumber = Swift.Int
        /// The number that identifies the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-number`.
        public typealias CommentNumber = Swift.Int
        /// The unique identifier of the project.
        ///
        /// - Remark: Generated from `#/components/parameters/project-id`.
        public typealias ProjectId = Swift.Int
        /// The unique identifier of the team.
        ///
        /// - Remark: Generated from `#/components/parameters/team-id`.
        public typealias TeamId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)`.
    public enum TeamsList {
        public static let id: Swift.String = "teams/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.TeamsList.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsList.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsList.Input.Path,
                query: Operations.TeamsList.Input.Query = .init(),
                headers: Operations.TeamsList.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Team])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Team] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsList.Output.Ok.Headers = .init(),
                    body: Operations.TeamsList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/articles/setting-team-creation-permissions-in-your-organization)."
    ///
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)`.
    public enum TeamsCreate {
        public static let id: Swift.String = "teams/create"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.TeamsCreate.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCreate.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/description`.
                    public var description: Swift.String?
                    /// List GitHub usernames for organization members who will become team maintainers.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/maintainers`.
                    public var maintainers: [Swift.String]?
                    /// The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/repo_names`.
                    public var repoNames: [Swift.String]?
                    /// The level of privacy this team should have. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// Default: `secret`  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.  
                    /// Default for child team: `closed`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/privacy`.
                    @frozen public enum PrivacyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case secret = "secret"
                        case closed = "closed"
                    }
                    /// The level of privacy this team should have. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// Default: `secret`  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.  
                    /// Default for child team: `closed`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/privacy`.
                    public var privacy: Operations.TeamsCreate.Input.Body.JsonPayload.PrivacyPayload?
                    /// The notification setting the team has chosen. The options are:  
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.  
                    /// Default: `notifications_enabled`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/notification_setting`.
                    @frozen public enum NotificationSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case notificationsEnabled = "notifications_enabled"
                        case notificationsDisabled = "notifications_disabled"
                    }
                    /// The notification setting the team has chosen. The options are:  
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.  
                    /// Default: `notifications_enabled`
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/notification_setting`.
                    public var notificationSetting: Operations.TeamsCreate.Input.Body.JsonPayload.NotificationSettingPayload?
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case pull = "pull"
                        case push = "push"
                    }
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/permission`.
                    public var permission: Operations.TeamsCreate.Input.Body.JsonPayload.PermissionPayload?
                    /// The ID of a team to set as the parent team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/json/parent_team_id`.
                    public var parentTeamId: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the team.
                    ///   - description: The description of the team.
                    ///   - maintainers: List GitHub usernames for organization members who will become team maintainers.
                    ///   - repoNames: The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
                    ///   - privacy: The level of privacy this team should have. The options are:  
                    ///   - notificationSetting: The notification setting the team has chosen. The options are:  
                    ///   - permission: **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///   - parentTeamId: The ID of a team to set as the parent team.
                    public init(
                        name: Swift.String,
                        description: Swift.String? = nil,
                        maintainers: [Swift.String]? = nil,
                        repoNames: [Swift.String]? = nil,
                        privacy: Operations.TeamsCreate.Input.Body.JsonPayload.PrivacyPayload? = nil,
                        notificationSetting: Operations.TeamsCreate.Input.Body.JsonPayload.NotificationSettingPayload? = nil,
                        permission: Operations.TeamsCreate.Input.Body.JsonPayload.PermissionPayload? = nil,
                        parentTeamId: Swift.Int? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.maintainers = maintainers
                        self.repoNames = repoNames
                        self.privacy = privacy
                        self.notificationSetting = notificationSetting
                        self.permission = permission
                        self.parentTeamId = parentTeamId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case maintainers
                        case repoNames = "repo_names"
                        case privacy
                        case notificationSetting = "notification_setting"
                        case permission
                        case parentTeamId = "parent_team_id"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/requestBody/content/application\/json`.
                case json(Operations.TeamsCreate.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsCreate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsCreate.Input.Path,
                headers: Operations.TeamsCreate.Input.Headers = .init(),
                body: Operations.TeamsCreate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCreate.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCreate.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsCreate.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsCreate.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a team by name
    ///
    /// Gets a team using the team's `slug`. To create the `slug`, GitHub replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)`.
    public enum TeamsGetByName {
        public static let id: Swift.String = "teams/get-by-name"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsGetByName.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetByName.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetByName.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetByName.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetByName.Input.Path,
                headers: Operations.TeamsGetByName.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetByName.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetByName.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetByName.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetByName.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)`.
    public enum TeamsUpdateInOrg {
        public static let id: Swift.String = "teams/update-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsUpdateInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// The description of the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/privacy`.
                    @frozen public enum PrivacyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case secret = "secret"
                        case closed = "closed"
                    }
                    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/privacy`.
                    public var privacy: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.PrivacyPayload?
                    /// The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/notification_setting`.
                    @frozen public enum NotificationSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case notificationsEnabled = "notifications_enabled"
                        case notificationsDisabled = "notifications_disabled"
                    }
                    /// The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/notification_setting`.
                    public var notificationSetting: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.NotificationSettingPayload?
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case pull = "pull"
                        case push = "push"
                        case admin = "admin"
                    }
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/permission`.
                    public var permission: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.PermissionPayload?
                    /// The ID of a team to set as the parent team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/json/parent_team_id`.
                    public var parentTeamId: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the team.
                    ///   - description: The description of the team.
                    ///   - privacy: The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:  
                    ///   - notificationSetting: The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///   - permission: **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///   - parentTeamId: The ID of a team to set as the parent team.
                    public init(
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        privacy: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.PrivacyPayload? = nil,
                        notificationSetting: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.NotificationSettingPayload? = nil,
                        permission: Operations.TeamsUpdateInOrg.Input.Body.JsonPayload.PermissionPayload? = nil,
                        parentTeamId: Swift.Int? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.privacy = privacy
                        self.notificationSetting = notificationSetting
                        self.permission = permission
                        self.parentTeamId = parentTeamId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case privacy
                        case notificationSetting = "notification_setting"
                        case permission
                        case parentTeamId = "parent_team_id"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateInOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateInOrg.Input.Path,
                headers: Operations.TeamsUpdateInOrg.Input.Headers = .init(),
                body: Operations.TeamsUpdateInOrg.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when the updated information already exists
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/PATCH/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateInOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateInOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsUpdateInOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsUpdateInOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)`.
    public enum TeamsDeleteInOrg {
        public static let id: Swift.String = "teams/delete-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsDeleteInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsDeleteInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List discussions
    ///
    /// List all discussions on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/get(teams/list-discussions-in-org)`.
    public enum TeamsListDiscussionsInOrg {
        public static let id: Swift.String = "teams/list-discussions-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListDiscussionsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Pinned discussions only filter
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/query/pinned`.
                public var pinned: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - pinned: Pinned discussions only filter
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    pinned: Swift.String? = nil
                ) {
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                    self.pinned = pinned
                }
            }
            public var query: Operations.TeamsListDiscussionsInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionsInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionsInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListDiscussionsInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListDiscussionsInOrg.Input.Path,
                query: Operations.TeamsListDiscussionsInOrg.Input.Query = .init(),
                headers: Operations.TeamsListDiscussionsInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListDiscussionsInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamDiscussion])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamDiscussion] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListDiscussionsInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListDiscussionsInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListDiscussionsInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/get(teams/list-discussions-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListDiscussionsInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListDiscussionsInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a discussion
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/post(teams/create-discussion-in-org)`.
    public enum TeamsCreateDiscussionInOrg {
        public static let id: Swift.String = "teams/create-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsCreateDiscussionInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCreateDiscussionInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion post's title.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody/json/title`.
                    public var title: Swift.String
                    /// The discussion post's body text.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody/json/private`.
                    public var _private: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The discussion post's title.
                    ///   - body: The discussion post's body text.
                    ///   - _private: Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
                    public init(
                        title: Swift.String,
                        body: Swift.String,
                        _private: Swift.Bool? = nil
                    ) {
                        self.title = title
                        self.body = body
                        self._private = _private
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                        case _private = "private"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/requestBody/content/application\/json`.
                case json(Operations.TeamsCreateDiscussionInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsCreateDiscussionInOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsCreateDiscussionInOrg.Input.Path,
                headers: Operations.TeamsCreateDiscussionInOrg.Input.Headers = .init(),
                body: Operations.TeamsCreateDiscussionInOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCreateDiscussionInOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCreateDiscussionInOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/post(teams/create-discussion-in-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsCreateDiscussionInOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsCreateDiscussionInOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a discussion
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/get(teams/get-discussion-in-org)`.
    public enum TeamsGetDiscussionInOrg {
        public static let id: Swift.String = "teams/get-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsGetDiscussionInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetDiscussionInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetDiscussionInOrg.Input.Path,
                headers: Operations.TeamsGetDiscussionInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetDiscussionInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetDiscussionInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/get(teams/get-discussion-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetDiscussionInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetDiscussionInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/patch(teams/update-discussion-in-org)`.
    public enum TeamsUpdateDiscussionInOrg {
        public static let id: Swift.String = "teams/update-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsUpdateDiscussionInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateDiscussionInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion post's title.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The discussion post's body text.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The discussion post's title.
                    ///   - body: The discussion post's body text.
                    public init(
                        title: Swift.String? = nil,
                        body: Swift.String? = nil
                    ) {
                        self.title = title
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateDiscussionInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateDiscussionInOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateDiscussionInOrg.Input.Path,
                headers: Operations.TeamsUpdateDiscussionInOrg.Input.Headers = .init(),
                body: Operations.TeamsUpdateDiscussionInOrg.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateDiscussionInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateDiscussionInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/patch(teams/update-discussion-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateDiscussionInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateDiscussionInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a discussion
    ///
    /// Delete a discussion from a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)`.
    public enum TeamsDeleteDiscussionInOrg {
        public static let id: Swift.String = "teams/delete-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsDeleteDiscussionInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsDeleteDiscussionInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteDiscussionInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteDiscussionInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List discussion comments
    ///
    /// List all comments on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-in-org)`.
    public enum TeamsListDiscussionCommentsInOrg {
        public static let id: Swift.String = "teams/list-discussion-comments-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsListDiscussionCommentsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListDiscussionCommentsInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionCommentsInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionCommentsInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListDiscussionCommentsInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListDiscussionCommentsInOrg.Input.Path,
                query: Operations.TeamsListDiscussionCommentsInOrg.Input.Query = .init(),
                headers: Operations.TeamsListDiscussionCommentsInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamDiscussionComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamDiscussionComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListDiscussionCommentsInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a discussion comment
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-in-org)`.
    public enum TeamsCreateDiscussionCommentInOrg {
        public static let id: Swift.String = "teams/create-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsCreateDiscussionCommentInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionCommentInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionCommentInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCreateDiscussionCommentInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion comment's body text.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The discussion comment's body text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/requestBody/content/application\/json`.
                case json(Operations.TeamsCreateDiscussionCommentInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsCreateDiscussionCommentInOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsCreateDiscussionCommentInOrg.Input.Path,
                headers: Operations.TeamsCreateDiscussionCommentInOrg.Input.Headers = .init(),
                body: Operations.TeamsCreateDiscussionCommentInOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCreateDiscussionCommentInOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCreateDiscussionCommentInOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-in-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsCreateDiscussionCommentInOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsCreateDiscussionCommentInOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a discussion comment
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-in-org)`.
    public enum TeamsGetDiscussionCommentInOrg {
        public static let id: Swift.String = "teams/get-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsGetDiscussionCommentInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionCommentInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionCommentInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetDiscussionCommentInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetDiscussionCommentInOrg.Input.Path,
                headers: Operations.TeamsGetDiscussionCommentInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetDiscussionCommentInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetDiscussionCommentInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetDiscussionCommentInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetDiscussionCommentInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a discussion comment
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-in-org)`.
    public enum TeamsUpdateDiscussionCommentInOrg {
        public static let id: Swift.String = "teams/update-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionCommentInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionCommentInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion comment's body text.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The discussion comment's body text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateDiscussionCommentInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Path,
                headers: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Headers = .init(),
                body: Operations.TeamsUpdateDiscussionCommentInOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateDiscussionCommentInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateDiscussionCommentInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateDiscussionCommentInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateDiscussionCommentInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)`.
    public enum TeamsDeleteDiscussionCommentInOrg {
        public static let id: Swift.String = "teams/delete-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsDeleteDiscussionCommentInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsDeleteDiscussionCommentInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteDiscussionCommentInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteDiscussionCommentInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/invitations/get(teams/list-pending-invitations-in-org)`.
    public enum TeamsListPendingInvitationsInOrg {
        public static let id: Swift.String = "teams/list-pending-invitations-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListPendingInvitationsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListPendingInvitationsInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListPendingInvitationsInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListPendingInvitationsInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListPendingInvitationsInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListPendingInvitationsInOrg.Input.Path,
                query: Operations.TeamsListPendingInvitationsInOrg.Input.Query = .init(),
                headers: Operations.TeamsListPendingInvitationsInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/invitations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationInvitation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationInvitation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/invitations/get(teams/list-pending-invitations-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListPendingInvitationsInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListPendingInvitationsInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List team members
    ///
    /// Team members will include the members of child teams.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/members/get(teams/list-members-in-org)`.
    public enum TeamsListMembersInOrg {
        public static let id: Swift.String = "teams/list-members-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListMembersInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/query/role`.
                @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case member = "member"
                    case maintainer = "maintainer"
                    case all = "all"
                }
                /// Filters members returned by their role in the team.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/query/role`.
                public var role: Operations.TeamsListMembersInOrg.Input.Query.RolePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - role: Filters members returned by their role in the team.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    role: Operations.TeamsListMembersInOrg.Input.Query.RolePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.role = role
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListMembersInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListMembersInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListMembersInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListMembersInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListMembersInOrg.Input.Path,
                query: Operations.TeamsListMembersInOrg.Input.Query = .init(),
                headers: Operations.TeamsListMembersInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListMembersInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/members/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListMembersInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListMembersInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListMembersInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/members/get(teams/list-members-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListMembersInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListMembersInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// > [!NOTE]
    /// > The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)`.
    public enum TeamsGetMembershipForUserInOrg {
        public static let id: Swift.String = "teams/get-membership-for-user-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.username = username
                }
            }
            public var path: Operations.TeamsGetMembershipForUserInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetMembershipForUserInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetMembershipForUserInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetMembershipForUserInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetMembershipForUserInOrg.Input.Path,
                headers: Operations.TeamsGetMembershipForUserInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamMembership)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamMembership {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetMembershipForUserInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetMembershipForUserInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetMembershipForUserInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetMembershipForUserInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// if user has no team membership
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsGetMembershipForUserInOrg.Output.NotFound)
            /// if user has no team membership
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsGetMembershipForUserInOrg.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team membership for a user
    ///
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)`.
    public enum TeamsAddOrUpdateMembershipForUserInOrg {
        public static let id: Swift.String = "teams/add-or-update-membership-for-user-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.username = username
                }
            }
            public var path: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateMembershipForUserInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateMembershipForUserInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The role that this user should have in the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/requestBody/json/role`.
                    @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case member = "member"
                        case maintainer = "maintainer"
                    }
                    /// The role that this user should have in the team.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/requestBody/json/role`.
                    public var role: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body.JsonPayload.RolePayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - role: The role that this user should have in the team.
                    public init(role: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body.JsonPayload.RolePayload? = nil) {
                        self.role = role
                    }
                    public enum CodingKeys: String, CodingKey {
                        case role
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Path,
                headers: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Headers = .init(),
                body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamMembership)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamMembership {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// Creates a new `Forbidden`.
                public init() {}
            }
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Forbidden)
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            public static var forbidden: Self {
                .forbidden(.init())
            }
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity if you attempt to add an organization to a team
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.UnprocessableContent)
            /// Unprocessable Entity if you attempt to add an organization to a team
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove team membership for a user
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)`.
    public enum TeamsRemoveMembershipForUserInOrg {
        public static let id: Swift.String = "teams/remove-membership-for-user-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/memberships/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.username = username
                }
            }
            public var path: Operations.TeamsRemoveMembershipForUserInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveMembershipForUserInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveMembershipForUserInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveMembershipForUserInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// Creates a new `Forbidden`.
                public init() {}
            }
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsRemoveMembershipForUserInOrg.Output.Forbidden)
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            public static var forbidden: Self {
                .forbidden(.init())
            }
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsRemoveMembershipForUserInOrg.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List team projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/get(teams/list-projects-in-org)`.
    public enum TeamsListProjectsInOrg {
        public static let id: Swift.String = "teams/list-projects-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListProjectsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListProjectsInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListProjectsInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListProjectsInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListProjectsInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListProjectsInOrg.Input.Path,
                query: Operations.TeamsListProjectsInOrg.Input.Query = .init(),
                headers: Operations.TeamsListProjectsInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListProjectsInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamProject])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamProject] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListProjectsInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListProjectsInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListProjectsInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/get(teams/list-projects-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListProjectsInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListProjectsInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check team permissions for a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)`.
    public enum TeamsCheckPermissionsForProjectInOrg {
        public static let id: Swift.String = "teams/check-permissions-for-project-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - projectId: The unique identifier of the project.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForProjectInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForProjectInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Path,
                headers: Operations.TeamsCheckPermissionsForProjectInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamProject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamProject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCheckPermissionsForProjectInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCheckPermissionsForProjectInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsCheckPermissionsForProjectInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsCheckPermissionsForProjectInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if project is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsCheckPermissionsForProjectInOrg.Output.NotFound)
            /// Not Found if project is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsCheckPermissionsForProjectInOrg.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team project permissions
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)`.
    public enum TeamsAddOrUpdateProjectPermissionsInOrg {
        public static let id: Swift.String = "teams/add-or-update-project-permissions-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - projectId: The unique identifier of the project.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateProjectPermissionsInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateProjectPermissionsInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                    }
                    /// The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/requestBody/json/permission`.
                    public var permission: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body.JsonPayload.PermissionPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    public init(permission: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body.JsonPayload.PermissionPayload? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Path,
                headers: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Headers = .init(),
                body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/PUT/responses/403/content/application\/json`.
                    case json(Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden if the project is not owned by the organization
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a project from a team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)`.
    public enum TeamsRemoveProjectInOrg {
        public static let id: Swift.String = "teams/remove-project-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/projects/{project_id}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - projectId: The unique identifier of the project.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsRemoveProjectInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveProjectInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveProjectInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveProjectInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/get(teams/list-repos-in-org)`.
    public enum TeamsListReposInOrg {
        public static let id: Swift.String = "teams/list-repos-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListReposInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListReposInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListReposInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListReposInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListReposInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListReposInOrg.Input.Path,
                query: Operations.TeamsListReposInOrg.Input.Query = .init(),
                headers: Operations.TeamsListReposInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListReposInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListReposInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListReposInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListReposInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/get(teams/list-repos-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListReposInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListReposInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    ///
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    ///
    /// If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)`.
    public enum TeamsCheckPermissionsForRepoInOrg {
        public static let id: Swift.String = "teams/check-permissions-for-repo-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForRepoInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForRepoInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Path,
                headers: Operations.TeamsCheckPermissionsForRepoInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamRepository)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamRepository {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCheckPermissionsForRepoInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCheckPermissionsForRepoInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Alternative response with repository permissions
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsCheckPermissionsForRepoInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsCheckPermissionsForRepoInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if team has permission for the repository. This is the response when the repository media type hasn't been provded in the Accept header.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsCheckPermissionsForRepoInOrg.Output.NoContent)
            /// Response if team has permission for the repository. This is the response when the repository media type hasn't been provded in the Accept header.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsCheckPermissionsForRepoInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if team does not have permission for the repository
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsCheckPermissionsForRepoInOrg.Output.NotFound)
            /// Not Found if team does not have permission for the repository
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsCheckPermissionsForRepoInOrg.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)`.
    public enum TeamsAddOrUpdateRepoPermissionsInOrg {
        public static let id: Swift.String = "teams/add-or-update-repo-permissions-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant the team on this repository. We accept the following permissions to be set: `pull`, `triage`, `push`, `maintain`, `admin` and you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/requestBody/json/permission`.
                    public var permission: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant the team on this repository. We accept the following permissions to be set: `pull`, `triage`, `push`, `maintain`, `admin` and you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
                    public init(permission: Swift.String? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Path,
                body: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input.Body? = nil
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)`.
    public enum TeamsRemoveRepoInOrg {
        public static let id: Swift.String = "teams/remove-repo-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsRemoveRepoInOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveRepoInOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveRepoInOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveRepoInOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/teams/get(teams/list-child-in-org)`.
    public enum TeamsListChildInOrg {
        public static let id: Swift.String = "teams/list-child-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                }
            }
            public var path: Operations.TeamsListChildInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListChildInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListChildInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListChildInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListChildInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListChildInOrg.Input.Path,
                query: Operations.TeamsListChildInOrg.Input.Query = .init(),
                headers: Operations.TeamsListChildInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListChildInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/teams/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Team])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Team] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListChildInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListChildInOrg.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListChildInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// if child teams exist
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/teams/get(teams/list-child-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListChildInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListChildInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/teams/teams#get-a-team-by-name) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)`.
    public enum TeamsGetLegacy {
        public static let id: Swift.String = "teams/get-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsGetLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetLegacy.Input.Path,
                headers: Operations.TeamsGetLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/teams/teams#update-a-team) endpoint.
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > With nested teams, the `privacy` for parent teams cannot be `secret`.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)`.
    public enum TeamsUpdateLegacy {
        public static let id: Swift.String = "teams/update-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsUpdateLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the team.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the team.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/privacy`.
                    @frozen public enum PrivacyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case secret = "secret"
                        case closed = "closed"
                    }
                    /// The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:  
                    /// **For a non-nested team:**  
                    ///  * `secret` - only visible to organization owners and members of this team.  
                    ///  * `closed` - visible to all members of this organization.  
                    /// **For a parent or child team:**  
                    ///  * `closed` - visible to all members of this organization.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/privacy`.
                    public var privacy: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.PrivacyPayload?
                    /// The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/notification_setting`.
                    @frozen public enum NotificationSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case notificationsEnabled = "notifications_enabled"
                        case notificationsDisabled = "notifications_disabled"
                    }
                    /// The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///  * `notifications_enabled` - team members receive notifications when the team is @mentioned.  
                    ///  * `notifications_disabled` - no one receives notifications.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/notification_setting`.
                    public var notificationSetting: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.NotificationSettingPayload?
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case pull = "pull"
                        case push = "push"
                        case admin = "admin"
                    }
                    /// **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/permission`.
                    public var permission: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.PermissionPayload?
                    /// The ID of a team to set as the parent team.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/json/parent_team_id`.
                    public var parentTeamId: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the team.
                    ///   - description: The description of the team.
                    ///   - privacy: The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:  
                    ///   - notificationSetting: The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: 
                    ///   - permission: **Closing down notice**. The permission that new repositories will be added to the team with when none is specified.
                    ///   - parentTeamId: The ID of a team to set as the parent team.
                    public init(
                        name: Swift.String,
                        description: Swift.String? = nil,
                        privacy: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.PrivacyPayload? = nil,
                        notificationSetting: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.NotificationSettingPayload? = nil,
                        permission: Operations.TeamsUpdateLegacy.Input.Body.JsonPayload.PermissionPayload? = nil,
                        parentTeamId: Swift.Int? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.privacy = privacy
                        self.notificationSetting = notificationSetting
                        self.permission = permission
                        self.parentTeamId = parentTeamId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case privacy
                        case notificationSetting = "notification_setting"
                        case permission
                        case parentTeamId = "parent_team_id"
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateLegacy.Input.Path,
                headers: Operations.TeamsUpdateLegacy.Input.Headers = .init(),
                body: Operations.TeamsUpdateLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when the updated information already exists
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/PATCH/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamFull)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamFull {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateLegacy.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateLegacy.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsUpdateLegacy.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsUpdateLegacy.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/teams/teams#delete-a-team) endpoint.
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)`.
    public enum TeamsDeleteLegacy {
        public static let id: Swift.String = "teams/delete-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsDeleteLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsDeleteLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsDeleteLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsDeleteLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsDeleteLegacy.Input.Path,
                headers: Operations.TeamsDeleteLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List discussions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/teams/discussions#list-discussions) endpoint.
    ///
    /// List all discussions on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/get(teams/list-discussions-legacy)`.
    public enum TeamsListDiscussionsLegacy {
        public static let id: Swift.String = "teams/list-discussions-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListDiscussionsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListDiscussionsLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListDiscussionsLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListDiscussionsLegacy.Input.Path,
                query: Operations.TeamsListDiscussionsLegacy.Input.Query = .init(),
                headers: Operations.TeamsListDiscussionsLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListDiscussionsLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamDiscussion])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamDiscussion] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListDiscussionsLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListDiscussionsLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListDiscussionsLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/get(teams/list-discussions-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListDiscussionsLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListDiscussionsLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/teams/discussions#create-a-discussion) endpoint.
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/post(teams/create-discussion-legacy)`.
    public enum TeamsCreateDiscussionLegacy {
        public static let id: Swift.String = "teams/create-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsCreateDiscussionLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCreateDiscussionLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion post's title.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody/json/title`.
                    public var title: Swift.String
                    /// The discussion post's body text.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody/json/private`.
                    public var _private: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The discussion post's title.
                    ///   - body: The discussion post's body text.
                    ///   - _private: Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
                    public init(
                        title: Swift.String,
                        body: Swift.String,
                        _private: Swift.Bool? = nil
                    ) {
                        self.title = title
                        self.body = body
                        self._private = _private
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                        case _private = "private"
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/requestBody/content/application\/json`.
                case json(Operations.TeamsCreateDiscussionLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsCreateDiscussionLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsCreateDiscussionLegacy.Input.Path,
                headers: Operations.TeamsCreateDiscussionLegacy.Input.Headers = .init(),
                body: Operations.TeamsCreateDiscussionLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCreateDiscussionLegacy.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCreateDiscussionLegacy.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/post(teams/create-discussion-legacy)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsCreateDiscussionLegacy.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsCreateDiscussionLegacy.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion) endpoint.
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/get(teams/get-discussion-legacy)`.
    public enum TeamsGetDiscussionLegacy {
        public static let id: Swift.String = "teams/get-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsGetDiscussionLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetDiscussionLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetDiscussionLegacy.Input.Path,
                headers: Operations.TeamsGetDiscussionLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetDiscussionLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetDiscussionLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/get(teams/get-discussion-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetDiscussionLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetDiscussionLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/teams/discussions#update-a-discussion) endpoint.
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/patch(teams/update-discussion-legacy)`.
    public enum TeamsUpdateDiscussionLegacy {
        public static let id: Swift.String = "teams/update-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsUpdateDiscussionLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateDiscussionLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion post's title.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The discussion post's body text.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The discussion post's title.
                    ///   - body: The discussion post's body text.
                    public init(
                        title: Swift.String? = nil,
                        body: Swift.String? = nil
                    ) {
                        self.title = title
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateDiscussionLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateDiscussionLegacy.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateDiscussionLegacy.Input.Path,
                headers: Operations.TeamsUpdateDiscussionLegacy.Input.Headers = .init(),
                body: Operations.TeamsUpdateDiscussionLegacy.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateDiscussionLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateDiscussionLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/patch(teams/update-discussion-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateDiscussionLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateDiscussionLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/teams/discussions#delete-a-discussion) endpoint.
    ///
    /// Delete a discussion from a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)`.
    public enum TeamsDeleteDiscussionLegacy {
        public static let id: Swift.String = "teams/delete-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsDeleteDiscussionLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsDeleteDiscussionLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteDiscussionLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteDiscussionLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List discussion comments (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments) endpoint.
    ///
    /// List all comments on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-legacy)`.
    public enum TeamsListDiscussionCommentsLegacy {
        public static let id: Swift.String = "teams/list-discussion-comments-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsListDiscussionCommentsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListDiscussionCommentsLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionCommentsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListDiscussionCommentsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListDiscussionCommentsLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListDiscussionCommentsLegacy.Input.Path,
                query: Operations.TeamsListDiscussionCommentsLegacy.Input.Query = .init(),
                headers: Operations.TeamsListDiscussionCommentsLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamDiscussionComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamDiscussionComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListDiscussionCommentsLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment) endpoint.
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-legacy)`.
    public enum TeamsCreateDiscussionCommentLegacy {
        public static let id: Swift.String = "teams/create-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.TeamsCreateDiscussionCommentLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionCommentLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCreateDiscussionCommentLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCreateDiscussionCommentLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion comment's body text.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The discussion comment's body text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/requestBody/content/application\/json`.
                case json(Operations.TeamsCreateDiscussionCommentLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsCreateDiscussionCommentLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsCreateDiscussionCommentLegacy.Input.Path,
                headers: Operations.TeamsCreateDiscussionCommentLegacy.Input.Headers = .init(),
                body: Operations.TeamsCreateDiscussionCommentLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCreateDiscussionCommentLegacy.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCreateDiscussionCommentLegacy.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-legacy)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.TeamsCreateDiscussionCommentLegacy.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.TeamsCreateDiscussionCommentLegacy.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment) endpoint.
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-legacy)`.
    public enum TeamsGetDiscussionCommentLegacy {
        public static let id: Swift.String = "teams/get-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsGetDiscussionCommentLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionCommentLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetDiscussionCommentLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetDiscussionCommentLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetDiscussionCommentLegacy.Input.Path,
                headers: Operations.TeamsGetDiscussionCommentLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetDiscussionCommentLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetDiscussionCommentLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetDiscussionCommentLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetDiscussionCommentLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment) endpoint.
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-legacy)`.
    public enum TeamsUpdateDiscussionCommentLegacy {
        public static let id: Swift.String = "teams/update-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionCommentLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsUpdateDiscussionCommentLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The discussion comment's body text.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The discussion comment's body text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.TeamsUpdateDiscussionCommentLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Path,
                headers: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Headers = .init(),
                body: Operations.TeamsUpdateDiscussionCommentLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamDiscussionComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamDiscussionComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsUpdateDiscussionCommentLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsUpdateDiscussionCommentLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsUpdateDiscussionCommentLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsUpdateDiscussionCommentLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)`.
    public enum TeamsDeleteDiscussionCommentLegacy {
        public static let id: Swift.String = "teams/delete-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/DELETE/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.TeamsDeleteDiscussionCommentLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsDeleteDiscussionCommentLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsDeleteDiscussionCommentLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsDeleteDiscussionCommentLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List pending team invitations (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/teams/members#list-pending-team-invitations) endpoint.
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/invitations`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/invitations/get(teams/list-pending-invitations-legacy)`.
    public enum TeamsListPendingInvitationsLegacy {
        public static let id: Swift.String = "teams/list-pending-invitations-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListPendingInvitationsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListPendingInvitationsLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListPendingInvitationsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListPendingInvitationsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListPendingInvitationsLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListPendingInvitationsLegacy.Input.Path,
                query: Operations.TeamsListPendingInvitationsLegacy.Input.Query = .init(),
                headers: Operations.TeamsListPendingInvitationsLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/invitations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationInvitation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationInvitation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/invitations/get(teams/list-pending-invitations-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListPendingInvitationsLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListPendingInvitationsLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List team members (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/teams/members#list-team-members) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)`.
    public enum TeamsListMembersLegacy {
        public static let id: Swift.String = "teams/list-members-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListMembersLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/query/role`.
                @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case member = "member"
                    case maintainer = "maintainer"
                    case all = "all"
                }
                /// Filters members returned by their role in the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/query/role`.
                public var role: Operations.TeamsListMembersLegacy.Input.Query.RolePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - role: Filters members returned by their role in the team.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    role: Operations.TeamsListMembersLegacy.Input.Query.RolePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.role = role
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListMembersLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListMembersLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListMembersLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListMembersLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListMembersLegacy.Input.Path,
                query: Operations.TeamsListMembersLegacy.Input.Query = .init(),
                headers: Operations.TeamsListMembersLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListMembersLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/members/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListMembersLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListMembersLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListMembersLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListMembersLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListMembersLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)`.
    public enum TeamsGetMemberLegacy {
        public static let id: Swift.String = "teams/get-member-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsGetMemberLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsGetMemberLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// if user is a member
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsGetMemberLegacy.Output.NoContent)
            /// if user is a member
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsGetMemberLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// if user is not a member
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsGetMemberLegacy.Output.NotFound)
            /// if user is not a member
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsGetMemberLegacy.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)`.
    public enum TeamsAddMemberLegacy {
        public static let id: Swift.String = "teams/add-member-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/PUT/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsAddMemberLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddMemberLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddMemberLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddMemberLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsAddMemberLegacy.Input.Path,
                headers: Operations.TeamsAddMemberLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsAddMemberLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsAddMemberLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsAddMemberLegacy.Output.NotFound)
            /// Not Found if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsAddMemberLegacy.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity if you attempt to add an organization to a team or you attempt to add a user to a team when they are not a member of at least one other team in the same organization
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.TeamsAddMemberLegacy.Output.UnprocessableContent)
            /// Unprocessable Entity if you attempt to add an organization to a team or you attempt to add a user to a team when they are not a member of at least one other team in the same organization
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.TeamsAddMemberLegacy.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)`.
    public enum TeamsRemoveMemberLegacy {
        public static let id: Swift.String = "teams/remove-member-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/members/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsRemoveMemberLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveMemberLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveMemberLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveMemberLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if team synchronization is setup
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsRemoveMemberLegacy.Output.NotFound)
            /// Not Found if team synchronization is setup
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsRemoveMemberLegacy.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)`.
    public enum TeamsGetMembershipForUserLegacy {
        public static let id: Swift.String = "teams/get-membership-for-user-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsGetMembershipForUserLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetMembershipForUserLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsGetMembershipForUserLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsGetMembershipForUserLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsGetMembershipForUserLegacy.Input.Path,
                headers: Operations.TeamsGetMembershipForUserLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamMembership)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamMembership {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsGetMembershipForUserLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsGetMembershipForUserLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsGetMembershipForUserLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsGetMembershipForUserLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)`.
    public enum TeamsAddOrUpdateMembershipForUserLegacy {
        public static let id: Swift.String = "teams/add-or-update-membership-for-user-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateMembershipForUserLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateMembershipForUserLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The role that this user should have in the team.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/requestBody/json/role`.
                    @frozen public enum RolePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case member = "member"
                        case maintainer = "maintainer"
                    }
                    /// The role that this user should have in the team.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/requestBody/json/role`.
                    public var role: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body.JsonPayload.RolePayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - role: The role that this user should have in the team.
                    public init(role: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body.JsonPayload.RolePayload? = nil) {
                        self.role = role
                    }
                    public enum CodingKeys: String, CodingKey {
                        case role
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Path,
                headers: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Headers = .init(),
                body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamMembership)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamMembership {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// Creates a new `Forbidden`.
                public init() {}
            }
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Forbidden)
            /// Forbidden if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            public static var forbidden: Self {
                .forbidden(.init())
            }
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity if you attempt to add an organization to a team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.UnprocessableContent)
            /// Unprocessable Entity if you attempt to add an organization to a team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)`.
    public enum TeamsRemoveMembershipForUserLegacy {
        public static let id: Swift.String = "teams/remove-membership-for-user-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/memberships/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - username: The handle for the GitHub user account.
                public init(
                    teamId: Components.Parameters.TeamId,
                    username: Components.Parameters.Username
                ) {
                    self.teamId = teamId
                    self.username = username
                }
            }
            public var path: Operations.TeamsRemoveMembershipForUserLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveMembershipForUserLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveMembershipForUserLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveMembershipForUserLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// Creates a new `Forbidden`.
                public init() {}
            }
            /// if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsRemoveMembershipForUserLegacy.Output.Forbidden)
            /// if team synchronization is set up
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            public static var forbidden: Self {
                .forbidden(.init())
            }
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsRemoveMembershipForUserLegacy.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List team projects (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)`.
    public enum TeamsListProjectsLegacy {
        public static let id: Swift.String = "teams/list-projects-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListProjectsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListProjectsLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListProjectsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListProjectsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListProjectsLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListProjectsLegacy.Input.Path,
                query: Operations.TeamsListProjectsLegacy.Input.Query = .init(),
                headers: Operations.TeamsListProjectsLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListProjectsLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamProject])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamProject] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListProjectsLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListProjectsLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListProjectsLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListProjectsLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListProjectsLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check team permissions for a project (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)`.
    public enum TeamsCheckPermissionsForProjectLegacy {
        public static let id: Swift.String = "teams/check-permissions-for-project-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - projectId: The unique identifier of the project.
                public init(
                    teamId: Components.Parameters.TeamId,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.teamId = teamId
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForProjectLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForProjectLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Path,
                headers: Operations.TeamsCheckPermissionsForProjectLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamProject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamProject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCheckPermissionsForProjectLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCheckPermissionsForProjectLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsCheckPermissionsForProjectLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsCheckPermissionsForProjectLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if project is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsCheckPermissionsForProjectLegacy.Output.NotFound)
            /// Not Found if project is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsCheckPermissionsForProjectLegacy.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team project permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)`.
    public enum TeamsAddOrUpdateProjectPermissionsLegacy {
        public static let id: Swift.String = "teams/add-or-update-project-permissions-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - projectId: The unique identifier of the project.
                public init(
                    teamId: Components.Parameters.TeamId,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.teamId = teamId
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateProjectPermissionsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateProjectPermissionsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                    }
                    /// The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/requestBody/json/permission`.
                    public var permission: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body.JsonPayload.PermissionPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
                    public init(permission: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body.JsonPayload.PermissionPayload? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Path,
                headers: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Headers = .init(),
                body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                        }
                    }
                    /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/PUT/responses/403/content/application\/json`.
                    case json(Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden if the project is not owned by the organization
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a project from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)`.
    public enum TeamsRemoveProjectLegacy {
        public static let id: Swift.String = "teams/remove-project-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - projectId: The unique identifier of the project.
                public init(
                    teamId: Components.Parameters.TeamId,
                    projectId: Components.Parameters.ProjectId
                ) {
                    self.teamId = teamId
                    self.projectId = projectId
                }
            }
            public var path: Operations.TeamsRemoveProjectLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/projects/{project_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsRemoveProjectLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsRemoveProjectLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsRemoveProjectLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsRemoveProjectLegacy.Input.Path,
                headers: Operations.TeamsRemoveProjectLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveProjectLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveProjectLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List team repositories (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/teams/teams#list-team-repositories) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)`.
    public enum TeamsListReposLegacy {
        public static let id: Swift.String = "teams/list-repos-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListReposLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListReposLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListReposLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListReposLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListReposLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListReposLegacy.Input.Path,
                query: Operations.TeamsListReposLegacy.Input.Query = .init(),
                headers: Operations.TeamsListReposLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListReposLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/repos/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListReposLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListReposLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListReposLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListReposLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListReposLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check team permissions for a repository (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository) endpoint.
    ///
    /// > [!NOTE]
    /// > Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)`.
    public enum TeamsCheckPermissionsForRepoLegacy {
        public static let id: Swift.String = "teams/check-permissions-for-repo-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    teamId: Components.Parameters.TeamId,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.teamId = teamId
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForRepoLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsCheckPermissionsForRepoLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Path,
                headers: Operations.TeamsCheckPermissionsForRepoLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.TeamRepository)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.TeamRepository {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsCheckPermissionsForRepoLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.TeamsCheckPermissionsForRepoLegacy.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Alternative response with extra repository information
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsCheckPermissionsForRepoLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsCheckPermissionsForRepoLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if repository is managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsCheckPermissionsForRepoLegacy.Output.NoContent)
            /// Response if repository is managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsCheckPermissionsForRepoLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if repository is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.TeamsCheckPermissionsForRepoLegacy.Output.NotFound)
            /// Not Found if repository is not managed by this team
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.TeamsCheckPermissionsForRepoLegacy.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add or update team repository permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)`.
    public enum TeamsAddOrUpdateRepoPermissionsLegacy {
        public static let id: Swift.String = "teams/add-or-update-repo-permissions-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    teamId: Components.Parameters.TeamId,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.teamId = teamId
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateRepoPermissionsLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsAddOrUpdateRepoPermissionsLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant the team on this repository. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case pull = "pull"
                        case push = "push"
                        case admin = "admin"
                    }
                    /// The permission to grant the team on this repository. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/requestBody/json/permission`.
                    public var permission: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body.JsonPayload.PermissionPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant the team on this repository. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
                    public init(permission: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body.JsonPayload.PermissionPayload? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/PUT/requestBody/content/application\/json`.
                case json(Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Path,
                headers: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Headers = .init(),
                body: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a repository from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team) endpoint.
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)`.
    public enum TeamsRemoveRepoLegacy {
        public static let id: Swift.String = "teams/remove-repo-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/DELETE/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/repos/{owner}/{repo}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    teamId: Components.Parameters.TeamId,
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.teamId = teamId
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.TeamsRemoveRepoLegacy.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.TeamsRemoveRepoLegacy.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.TeamsRemoveRepoLegacy.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.TeamsRemoveRepoLegacy.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List child teams (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/teams/teams#list-child-teams) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/teams`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)`.
    public enum TeamsListChildLegacy {
        public static let id: Swift.String = "teams/list-child-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                public init(teamId: Components.Parameters.TeamId) {
                    self.teamId = teamId
                }
            }
            public var path: Operations.TeamsListChildLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListChildLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListChildLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListChildLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListChildLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.TeamsListChildLegacy.Input.Path,
                query: Operations.TeamsListChildLegacy.Input.Query = .init(),
                headers: Operations.TeamsListChildLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListChildLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/teams/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Team])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Team] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListChildLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListChildLegacy.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListChildLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// if child teams exist
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListChildLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListChildLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated
    /// user belongs.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.
    ///
    /// When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.
    ///
    /// - Remark: HTTP `GET /user/teams`.
    /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)`.
    public enum TeamsListForAuthenticatedUser {
        public static let id: Swift.String = "teams/list-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/teams/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/teams/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/teams/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.TeamsListForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/teams/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.TeamsListForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.TeamsListForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.TeamsListForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.TeamsListForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/teams/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/teams/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.TeamsListForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/teams/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/teams/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.TeamFull])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.TeamFull] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.TeamsListForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.TeamsListForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.TeamsListForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.TeamsListForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.TeamsListForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
