// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// List teams
    ///
    /// Lists all teams in an organization that are visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/get(teams/list)`.
    public func teamsList(_ input: Operations.TeamsList.Input) async throws -> Operations.TeamsList.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsList.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsList.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsList.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Team].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a team
    ///
    /// To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/articles/setting-team-creation-permissions-in-your-organization)."
    ///
    /// When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/about-teams)".
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/post(teams/create)`.
    public func teamsCreate(_ input: Operations.TeamsCreate.Input) async throws -> Operations.TeamsCreate.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCreate.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams",
                    parameters: [
                        input.path.org
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCreate.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a team by name
    ///
    /// Gets a team using the team's `slug`. To create the `slug`, GitHub replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/get(teams/get-by-name)`.
    public func teamsGetByName(_ input: Operations.TeamsGetByName.Input) async throws -> Operations.TeamsGetByName.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetByName.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetByName.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a team
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/patch(teams/update-in-org)`.
    public func teamsUpdateInOrg(_ input: Operations.TeamsUpdateInOrg.Input) async throws -> Operations.TeamsUpdateInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateInOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a team
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/delete(teams/delete-in-org)`.
    public func teamsDeleteInOrg(_ input: Operations.TeamsDeleteInOrg.Input) async throws -> Operations.TeamsDeleteInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List discussions
    ///
    /// List all discussions on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/get(teams/list-discussions-in-org)`.
    public func teamsListDiscussionsInOrg(_ input: Operations.TeamsListDiscussionsInOrg.Input) async throws -> Operations.TeamsListDiscussionsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListDiscussionsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "pinned",
                    value: input.query.pinned
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListDiscussionsInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListDiscussionsInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamDiscussion].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a discussion
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/post(teams/create-discussion-in-org)`.
    public func teamsCreateDiscussionInOrg(_ input: Operations.TeamsCreateDiscussionInOrg.Input) async throws -> Operations.TeamsCreateDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCreateDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCreateDiscussionInOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a discussion
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/get(teams/get-discussion-in-org)`.
    public func teamsGetDiscussionInOrg(_ input: Operations.TeamsGetDiscussionInOrg.Input) async throws -> Operations.TeamsGetDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetDiscussionInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a discussion
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/patch(teams/update-discussion-in-org)`.
    public func teamsUpdateDiscussionInOrg(_ input: Operations.TeamsUpdateDiscussionInOrg.Input) async throws -> Operations.TeamsUpdateDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateDiscussionInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a discussion
    ///
    /// Delete a discussion from a team's page.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/delete(teams/delete-discussion-in-org)`.
    public func teamsDeleteDiscussionInOrg(_ input: Operations.TeamsDeleteDiscussionInOrg.Input) async throws -> Operations.TeamsDeleteDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List discussion comments
    ///
    /// List all comments on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-in-org)`.
    public func teamsListDiscussionCommentsInOrg(_ input: Operations.TeamsListDiscussionCommentsInOrg.Input) async throws -> Operations.TeamsListDiscussionCommentsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListDiscussionCommentsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListDiscussionCommentsInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamDiscussionComment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a discussion comment
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-in-org)`.
    public func teamsCreateDiscussionCommentInOrg(_ input: Operations.TeamsCreateDiscussionCommentInOrg.Input) async throws -> Operations.TeamsCreateDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCreateDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCreateDiscussionCommentInOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a discussion comment
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-in-org)`.
    public func teamsGetDiscussionCommentInOrg(_ input: Operations.TeamsGetDiscussionCommentInOrg.Input) async throws -> Operations.TeamsGetDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetDiscussionCommentInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a discussion comment
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-in-org)`.
    public func teamsUpdateDiscussionCommentInOrg(_ input: Operations.TeamsUpdateDiscussionCommentInOrg.Input) async throws -> Operations.TeamsUpdateDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateDiscussionCommentInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a discussion comment
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-in-org)`.
    public func teamsDeleteDiscussionCommentInOrg(_ input: Operations.TeamsDeleteDiscussionCommentInOrg.Input) async throws -> Operations.TeamsDeleteDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List pending team invitations
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/invitations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/invitations/get(teams/list-pending-invitations-in-org)`.
    public func teamsListPendingInvitationsInOrg(_ input: Operations.TeamsListPendingInvitationsInOrg.Input) async throws -> Operations.TeamsListPendingInvitationsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListPendingInvitationsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/invitations",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListPendingInvitationsInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationInvitation].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team members
    ///
    /// Team members will include the members of child teams.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/members`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/members/get(teams/list-members-in-org)`.
    public func teamsListMembersInOrg(_ input: Operations.TeamsListMembersInOrg.Input) async throws -> Operations.TeamsListMembersInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListMembersInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/members",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "role",
                    value: input.query.role
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListMembersInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListMembersInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get team membership for a user
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// > [!NOTE]
    /// > The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/get(teams/get-membership-for-user-in-org)`.
    public func teamsGetMembershipForUserInOrg(_ input: Operations.TeamsGetMembershipForUserInOrg.Input) async throws -> Operations.TeamsGetMembershipForUserInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetMembershipForUserInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetMembershipForUserInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team membership for a user
    ///
    /// Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/put(teams/add-or-update-membership-for-user-in-org)`.
    public func teamsAddOrUpdateMembershipForUserInOrg(_ input: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Input) async throws -> Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateMembershipForUserInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsAddOrUpdateMembershipForUserInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    return .forbidden(.init())
                case 422:
                    return .unprocessableContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove team membership for a user
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/memberships/{username}/delete(teams/remove-membership-for-user-in-org)`.
    public func teamsRemoveMembershipForUserInOrg(_ input: Operations.TeamsRemoveMembershipForUserInOrg.Input) async throws -> Operations.TeamsRemoveMembershipForUserInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveMembershipForUserInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    return .forbidden(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/get(teams/list-projects-in-org)`.
    @available(*, deprecated)
    public func teamsListProjectsInOrg(_ input: Operations.TeamsListProjectsInOrg.Input) async throws -> Operations.TeamsListProjectsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListProjectsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/projects",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListProjectsInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListProjectsInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamProject].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check team permissions for a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/get(teams/check-permissions-for-project-in-org)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForProjectInOrg(_ input: Operations.TeamsCheckPermissionsForProjectInOrg.Input) async throws -> Operations.TeamsCheckPermissionsForProjectInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCheckPermissionsForProjectInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/projects/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCheckPermissionsForProjectInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamProject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team project permissions
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/put(teams/add-or-update-project-permissions-in-org)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateProjectPermissionsInOrg(_ input: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Input) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/projects/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.TeamsAddOrUpdateProjectPermissionsInOrg.Output.Forbidden.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a project from a team
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/projects/{project_id}/delete(teams/remove-project-in-org)`.
    @available(*, deprecated)
    public func teamsRemoveProjectInOrg(_ input: Operations.TeamsRemoveProjectInOrg.Input) async throws -> Operations.TeamsRemoveProjectInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveProjectInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/projects/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team repositories
    ///
    /// Lists a team's repositories visible to the authenticated user.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/get(teams/list-repos-in-org)`.
    public func teamsListReposInOrg(_ input: Operations.TeamsListReposInOrg.Input) async throws -> Operations.TeamsListReposInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListReposInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/repos",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListReposInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListReposInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.MinimalRepository].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check team permissions for a repository
    ///
    /// Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.
    ///
    /// If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
    ///
    /// If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-in-org)`.
    public func teamsCheckPermissionsForRepoInOrg(_ input: Operations.TeamsCheckPermissionsForRepoInOrg.Input) async throws -> Operations.TeamsCheckPermissionsForRepoInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCheckPermissionsForRepoInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCheckPermissionsForRepoInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamRepository.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team repository permissions
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-in-org)`.
    public func teamsAddOrUpdateRepoPermissionsInOrg(_ input: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Input) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateRepoPermissionsInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a repository from a team
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}/delete(teams/remove-repo-in-org)`.
    public func teamsRemoveRepoInOrg(_ input: Operations.TeamsRemoveRepoInOrg.Input) async throws -> Operations.TeamsRemoveRepoInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveRepoInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List child teams
    ///
    /// Lists the child teams of the team specified by `{team_slug}`.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/teams`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/teams/get(teams/list-child-in-org)`.
    public func teamsListChildInOrg(_ input: Operations.TeamsListChildInOrg.Input) async throws -> Operations.TeamsListChildInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListChildInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/teams",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListChildInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListChildInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Team].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/teams/teams#get-a-team-by-name) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/get(teams/get-legacy)`.
    @available(*, deprecated)
    public func teamsGetLegacy(_ input: Operations.TeamsGetLegacy.Input) async throws -> Operations.TeamsGetLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/teams/teams#update-a-team) endpoint.
    ///
    /// To edit a team, the authenticated user must either be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > With nested teams, the `privacy` for parent teams cannot be `secret`.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/patch(teams/update-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateLegacy(_ input: Operations.TeamsUpdateLegacy.Input) async throws -> Operations.TeamsUpdateLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateLegacy.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamFull.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/teams/teams#delete-a-team) endpoint.
    ///
    /// To delete a team, the authenticated user must be an organization owner or team maintainer.
    ///
    /// If you are an organization owner, deleting a parent team will delete all of its child teams as well.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/delete(teams/delete-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteLegacy(_ input: Operations.TeamsDeleteLegacy.Input) async throws -> Operations.TeamsDeleteLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List discussions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/teams/discussions#list-discussions) endpoint.
    ///
    /// List all discussions on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/get(teams/list-discussions-legacy)`.
    @available(*, deprecated)
    public func teamsListDiscussionsLegacy(_ input: Operations.TeamsListDiscussionsLegacy.Input) async throws -> Operations.TeamsListDiscussionsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListDiscussionsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListDiscussionsLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListDiscussionsLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamDiscussion].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/teams/discussions#create-a-discussion) endpoint.
    ///
    /// Creates a new discussion post on a team's page.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/post(teams/create-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsCreateDiscussionLegacy(_ input: Operations.TeamsCreateDiscussionLegacy.Input) async throws -> Operations.TeamsCreateDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCreateDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCreateDiscussionLegacy.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion) endpoint.
    ///
    /// Get a specific discussion on a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/get(teams/get-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsGetDiscussionLegacy(_ input: Operations.TeamsGetDiscussionLegacy.Input) async throws -> Operations.TeamsGetDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetDiscussionLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/teams/discussions#update-a-discussion) endpoint.
    ///
    /// Edits the title and body text of a discussion post. Only the parameters you provide are updated.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/patch(teams/update-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateDiscussionLegacy(_ input: Operations.TeamsUpdateDiscussionLegacy.Input) async throws -> Operations.TeamsUpdateDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateDiscussionLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussion.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/teams/discussions#delete-a-discussion) endpoint.
    ///
    /// Delete a discussion from a team's page.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/delete(teams/delete-discussion-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteDiscussionLegacy(_ input: Operations.TeamsDeleteDiscussionLegacy.Input) async throws -> Operations.TeamsDeleteDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List discussion comments (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments) endpoint.
    ///
    /// List all comments on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/get(teams/list-discussion-comments-legacy)`.
    @available(*, deprecated)
    public func teamsListDiscussionCommentsLegacy(_ input: Operations.TeamsListDiscussionCommentsLegacy.Input) async throws -> Operations.TeamsListDiscussionCommentsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListDiscussionCommentsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "direction",
                    value: input.query.direction
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListDiscussionCommentsLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamDiscussionComment].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment) endpoint.
    ///
    /// Creates a new comment on a team discussion.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/post(teams/create-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsCreateDiscussionCommentLegacy(_ input: Operations.TeamsCreateDiscussionCommentLegacy.Input) async throws -> Operations.TeamsCreateDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCreateDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCreateDiscussionCommentLegacy.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment) endpoint.
    ///
    /// Get a specific comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/get(teams/get-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsGetDiscussionCommentLegacy(_ input: Operations.TeamsGetDiscussionCommentLegacy.Input) async throws -> Operations.TeamsGetDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetDiscussionCommentLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Update a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment) endpoint.
    ///
    /// Edits the body text of a discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/patch(teams/update-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsUpdateDiscussionCommentLegacy(_ input: Operations.TeamsUpdateDiscussionCommentLegacy.Input) async throws -> Operations.TeamsUpdateDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsUpdateDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .patch
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsUpdateDiscussionCommentLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamDiscussionComment.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.
    ///
    /// Deletes a comment on a team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/delete(teams/delete-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func teamsDeleteDiscussionCommentLegacy(_ input: Operations.TeamsDeleteDiscussionCommentLegacy.Input) async throws -> Operations.TeamsDeleteDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsDeleteDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List pending team invitations (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/teams/members#list-pending-team-invitations) endpoint.
    ///
    /// The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/invitations`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/invitations/get(teams/list-pending-invitations-legacy)`.
    @available(*, deprecated)
    public func teamsListPendingInvitationsLegacy(_ input: Operations.TeamsListPendingInvitationsLegacy.Input) async throws -> Operations.TeamsListPendingInvitationsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListPendingInvitationsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/invitations",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListPendingInvitationsLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.OrganizationInvitation].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team members (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/teams/members#list-team-members) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/get(teams/list-members-legacy)`.
    @available(*, deprecated)
    public func teamsListMembersLegacy(_ input: Operations.TeamsListMembersLegacy.Input) async throws -> Operations.TeamsListMembersLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListMembersLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/members",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "role",
                    value: input.query.role
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListMembersLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListMembersLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get team member (Legacy)
    ///
    /// The "Get team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
    ///
    /// To list members in a team, the team must be visible to the authenticated user.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/get(teams/get-member-legacy)`.
    @available(*, deprecated)
    public func teamsGetMemberLegacy(_ input: Operations.TeamsGetMemberLegacy.Input) async throws -> Operations.TeamsGetMemberLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetMemberLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/members/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add team member (Legacy)
    ///
    /// The "Add team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/put(teams/add-member-legacy)`.
    @available(*, deprecated)
    public func teamsAddMemberLegacy(_ input: Operations.TeamsAddMemberLegacy.Input) async throws -> Operations.TeamsAddMemberLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddMemberLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/members/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                case 422:
                    return .unprocessableContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove team member (Legacy)
    ///
    /// The "Remove team member" endpoint (described below) is closing down.
    ///
    /// We recommend using the [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/members/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/members/{username}/delete(teams/remove-member-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveMemberLegacy(_ input: Operations.TeamsRemoveMemberLegacy.Input) async throws -> Operations.TeamsRemoveMemberLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveMemberLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/members/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/teams/members#get-team-membership-for-a-user) endpoint.
    ///
    /// Team members will include the members of child teams.
    ///
    /// To get a user's membership with a team, the team must be visible to the authenticated user.
    ///
    /// **Note:**
    /// The response contains the `state` of the membership and the member's `role`.
    ///
    /// The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/teams/teams#create-a-team).
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/get(teams/get-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsGetMembershipForUserLegacy(_ input: Operations.TeamsGetMembershipForUserLegacy.Input) async throws -> Operations.TeamsGetMembershipForUserLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsGetMembershipForUserLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/memberships/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsGetMembershipForUserLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
    ///
    /// If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/put(teams/add-or-update-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateMembershipForUserLegacy(_ input: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Input) async throws -> Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateMembershipForUserLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/memberships/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsAddOrUpdateMembershipForUserLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamMembership.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 403:
                    return .forbidden(.init())
                case 422:
                    return .unprocessableContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove team membership for a user (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user) endpoint.
    ///
    /// Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
    ///
    /// > [!NOTE]
    /// > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/memberships/{username}/delete(teams/remove-membership-for-user-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveMembershipForUserLegacy(_ input: Operations.TeamsRemoveMembershipForUserLegacy.Input) async throws -> Operations.TeamsRemoveMembershipForUserLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveMembershipForUserLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/memberships/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    return .forbidden(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team projects (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/get(teams/list-projects-legacy)`.
    @available(*, deprecated)
    public func teamsListProjectsLegacy(_ input: Operations.TeamsListProjectsLegacy.Input) async throws -> Operations.TeamsListProjectsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListProjectsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/projects",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListProjectsLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListProjectsLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamProject].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check team permissions for a project (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/get(teams/check-permissions-for-project-legacy)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForProjectLegacy(_ input: Operations.TeamsCheckPermissionsForProjectLegacy.Input) async throws -> Operations.TeamsCheckPermissionsForProjectLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCheckPermissionsForProjectLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/projects/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCheckPermissionsForProjectLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamProject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team project permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/put(teams/add-or-update-project-permissions-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateProjectPermissionsLegacy(_ input: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Input) async throws -> Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/projects/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Operations.TeamsAddOrUpdateProjectPermissionsLegacy.Output.Forbidden.Body.JsonPayload.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a project from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/projects/{project_id}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/projects/{project_id}/delete(teams/remove-project-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveProjectLegacy(_ input: Operations.TeamsRemoveProjectLegacy.Input) async throws -> Operations.TeamsRemoveProjectLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveProjectLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/projects/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.projectId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List team repositories (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/teams/teams#list-team-repositories) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/get(teams/list-repos-legacy)`.
    @available(*, deprecated)
    public func teamsListReposLegacy(_ input: Operations.TeamsListReposLegacy.Input) async throws -> Operations.TeamsListReposLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListReposLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/repos",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListReposLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListReposLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.MinimalRepository].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Check team permissions for a repository (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository) endpoint.
    ///
    /// > [!NOTE]
    /// > Repositories inherited through a parent team will also be checked.
    ///
    /// You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/get(teams/check-permissions-for-repo-legacy)`.
    @available(*, deprecated)
    public func teamsCheckPermissionsForRepoLegacy(_ input: Operations.TeamsCheckPermissionsForRepoLegacy.Input) async throws -> Operations.TeamsCheckPermissionsForRepoLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsCheckPermissionsForRepoLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsCheckPermissionsForRepoLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.TeamRepository.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 204:
                    return .noContent(.init())
                case 404:
                    return .notFound(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add or update team repository permissions (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.
    ///
    /// To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/put(teams/add-or-update-repo-permissions-legacy)`.
    @available(*, deprecated)
    public func teamsAddOrUpdateRepoPermissionsLegacy(_ input: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Input) async throws -> Operations.TeamsAddOrUpdateRepoPermissionsLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsAddOrUpdateRepoPermissionsLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove a repository from a team (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team) endpoint.
    ///
    /// If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
    ///
    /// - Remark: HTTP `DELETE /teams/{team_id}/repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/repos/{owner}/{repo}/delete(teams/remove-repo-legacy)`.
    @available(*, deprecated)
    public func teamsRemoveRepoLegacy(_ input: Operations.TeamsRemoveRepoLegacy.Input) async throws -> Operations.TeamsRemoveRepoLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsRemoveRepoLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/repos/{}/{}",
                    parameters: [
                        input.path.teamId,
                        input.path.owner,
                        input.path.repo
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List child teams (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/teams/teams#list-child-teams) endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/teams`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/teams/get(teams/list-child-legacy)`.
    @available(*, deprecated)
    public func teamsListChildLegacy(_ input: Operations.TeamsListChildLegacy.Input) async throws -> Operations.TeamsListChildLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListChildLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/teams",
                    parameters: [
                        input.path.teamId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListChildLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListChildLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Team].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List teams for the authenticated user
    ///
    /// List all of the teams across all of the organizations to which the authenticated
    /// user belongs.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.
    ///
    /// When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.
    ///
    /// - Remark: HTTP `GET /user/teams`.
    /// - Remark: Generated from `#/paths//user/teams/get(teams/list-for-authenticated-user)`.
    public func teamsListForAuthenticatedUser(_ input: Operations.TeamsListForAuthenticatedUser.Input) async throws -> Operations.TeamsListForAuthenticatedUser.Output {
        try await client.send(
            input: input,
            forOperation: Operations.TeamsListForAuthenticatedUser.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/user/teams",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.TeamsListForAuthenticatedUser.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.TeamsListForAuthenticatedUser.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.TeamFull].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
