// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-in-org)`.
    func reactionsListForTeamDiscussionCommentInOrg(_ input: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input) async throws -> Operations.ReactionsListForTeamDiscussionCommentInOrg.Output
    /// Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)`.
    func reactionsCreateForTeamDiscussionCommentInOrg(_ input: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output
    /// Delete team discussion comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)`.
    func reactionsDeleteForTeamDiscussionComment(_ input: Operations.ReactionsDeleteForTeamDiscussionComment.Input) async throws -> Operations.ReactionsDeleteForTeamDiscussionComment.Output
    /// List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-in-org)`.
    func reactionsListForTeamDiscussionInOrg(_ input: Operations.ReactionsListForTeamDiscussionInOrg.Input) async throws -> Operations.ReactionsListForTeamDiscussionInOrg.Output
    /// Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)`.
    func reactionsCreateForTeamDiscussionInOrg(_ input: Operations.ReactionsCreateForTeamDiscussionInOrg.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionInOrg.Output
    /// Delete team discussion reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)`.
    func reactionsDeleteForTeamDiscussion(_ input: Operations.ReactionsDeleteForTeamDiscussion.Input) async throws -> Operations.ReactionsDeleteForTeamDiscussion.Output
    /// List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)`.
    func reactionsListForCommitComment(_ input: Operations.ReactionsListForCommitComment.Input) async throws -> Operations.ReactionsListForCommitComment.Output
    /// Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)`.
    func reactionsCreateForCommitComment(_ input: Operations.ReactionsCreateForCommitComment.Input) async throws -> Operations.ReactionsCreateForCommitComment.Output
    /// Delete a commit comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)`.
    func reactionsDeleteForCommitComment(_ input: Operations.ReactionsDeleteForCommitComment.Input) async throws -> Operations.ReactionsDeleteForCommitComment.Output
    /// List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)`.
    func reactionsListForIssueComment(_ input: Operations.ReactionsListForIssueComment.Input) async throws -> Operations.ReactionsListForIssueComment.Output
    /// Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)`.
    func reactionsCreateForIssueComment(_ input: Operations.ReactionsCreateForIssueComment.Input) async throws -> Operations.ReactionsCreateForIssueComment.Output
    /// Delete an issue comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)`.
    func reactionsDeleteForIssueComment(_ input: Operations.ReactionsDeleteForIssueComment.Input) async throws -> Operations.ReactionsDeleteForIssueComment.Output
    /// List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)`.
    func reactionsListForIssue(_ input: Operations.ReactionsListForIssue.Input) async throws -> Operations.ReactionsListForIssue.Output
    /// Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)`.
    func reactionsCreateForIssue(_ input: Operations.ReactionsCreateForIssue.Input) async throws -> Operations.ReactionsCreateForIssue.Output
    /// Delete an issue reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)`.
    func reactionsDeleteForIssue(_ input: Operations.ReactionsDeleteForIssue.Input) async throws -> Operations.ReactionsDeleteForIssue.Output
    /// List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)`.
    func reactionsListForPullRequestReviewComment(_ input: Operations.ReactionsListForPullRequestReviewComment.Input) async throws -> Operations.ReactionsListForPullRequestReviewComment.Output
    /// Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)`.
    func reactionsCreateForPullRequestReviewComment(_ input: Operations.ReactionsCreateForPullRequestReviewComment.Input) async throws -> Operations.ReactionsCreateForPullRequestReviewComment.Output
    /// Delete a pull request comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    ///
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)`.
    func reactionsDeleteForPullRequestComment(_ input: Operations.ReactionsDeleteForPullRequestComment.Input) async throws -> Operations.ReactionsDeleteForPullRequestComment.Output
    /// List reactions for a release
    ///
    /// List the reactions to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)`.
    func reactionsListForRelease(_ input: Operations.ReactionsListForRelease.Input) async throws -> Operations.ReactionsListForRelease.Output
    /// Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)`.
    func reactionsCreateForRelease(_ input: Operations.ReactionsCreateForRelease.Input) async throws -> Operations.ReactionsCreateForRelease.Output
    /// Delete a release reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)`.
    func reactionsDeleteForRelease(_ input: Operations.ReactionsDeleteForRelease.Input) async throws -> Operations.ReactionsDeleteForRelease.Output
    /// List reactions for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    func reactionsListForTeamDiscussionCommentLegacy(_ input: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input) async throws -> Operations.ReactionsListForTeamDiscussionCommentLegacy.Output
    /// Create reaction for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    func reactionsCreateForTeamDiscussionCommentLegacy(_ input: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output
    /// List reactions for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-legacy)`.
    @available(*, deprecated)
    func reactionsListForTeamDiscussionLegacy(_ input: Operations.ReactionsListForTeamDiscussionLegacy.Input) async throws -> Operations.ReactionsListForTeamDiscussionLegacy.Output
    /// Create reaction for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-legacy)`.
    @available(*, deprecated)
    func reactionsCreateForTeamDiscussionLegacy(_ input: Operations.ReactionsCreateForTeamDiscussionLegacy.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionLegacy.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-in-org)`.
    public func reactionsListForTeamDiscussionCommentInOrg(
        path: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Path,
        query: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Query = .init(),
        headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForTeamDiscussionCommentInOrg.Output {
        try await reactionsListForTeamDiscussionCommentInOrg(Operations.ReactionsListForTeamDiscussionCommentInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)`.
    public func reactionsCreateForTeamDiscussionCommentInOrg(
        path: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Path,
        headers: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Headers = .init(),
        body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body
    ) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output {
        try await reactionsCreateForTeamDiscussionCommentInOrg(Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete team discussion comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)`.
    public func reactionsDeleteForTeamDiscussionComment(path: Operations.ReactionsDeleteForTeamDiscussionComment.Input.Path) async throws -> Operations.ReactionsDeleteForTeamDiscussionComment.Output {
        try await reactionsDeleteForTeamDiscussionComment(Operations.ReactionsDeleteForTeamDiscussionComment.Input(path: path))
    }
    /// List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-in-org)`.
    public func reactionsListForTeamDiscussionInOrg(
        path: Operations.ReactionsListForTeamDiscussionInOrg.Input.Path,
        query: Operations.ReactionsListForTeamDiscussionInOrg.Input.Query = .init(),
        headers: Operations.ReactionsListForTeamDiscussionInOrg.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForTeamDiscussionInOrg.Output {
        try await reactionsListForTeamDiscussionInOrg(Operations.ReactionsListForTeamDiscussionInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)`.
    public func reactionsCreateForTeamDiscussionInOrg(
        path: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Path,
        headers: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Headers = .init(),
        body: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body
    ) async throws -> Operations.ReactionsCreateForTeamDiscussionInOrg.Output {
        try await reactionsCreateForTeamDiscussionInOrg(Operations.ReactionsCreateForTeamDiscussionInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete team discussion reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)`.
    public func reactionsDeleteForTeamDiscussion(path: Operations.ReactionsDeleteForTeamDiscussion.Input.Path) async throws -> Operations.ReactionsDeleteForTeamDiscussion.Output {
        try await reactionsDeleteForTeamDiscussion(Operations.ReactionsDeleteForTeamDiscussion.Input(path: path))
    }
    /// List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)`.
    public func reactionsListForCommitComment(
        path: Operations.ReactionsListForCommitComment.Input.Path,
        query: Operations.ReactionsListForCommitComment.Input.Query = .init(),
        headers: Operations.ReactionsListForCommitComment.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForCommitComment.Output {
        try await reactionsListForCommitComment(Operations.ReactionsListForCommitComment.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)`.
    public func reactionsCreateForCommitComment(
        path: Operations.ReactionsCreateForCommitComment.Input.Path,
        headers: Operations.ReactionsCreateForCommitComment.Input.Headers = .init(),
        body: Operations.ReactionsCreateForCommitComment.Input.Body
    ) async throws -> Operations.ReactionsCreateForCommitComment.Output {
        try await reactionsCreateForCommitComment(Operations.ReactionsCreateForCommitComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a commit comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)`.
    public func reactionsDeleteForCommitComment(path: Operations.ReactionsDeleteForCommitComment.Input.Path) async throws -> Operations.ReactionsDeleteForCommitComment.Output {
        try await reactionsDeleteForCommitComment(Operations.ReactionsDeleteForCommitComment.Input(path: path))
    }
    /// List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)`.
    public func reactionsListForIssueComment(
        path: Operations.ReactionsListForIssueComment.Input.Path,
        query: Operations.ReactionsListForIssueComment.Input.Query = .init(),
        headers: Operations.ReactionsListForIssueComment.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForIssueComment.Output {
        try await reactionsListForIssueComment(Operations.ReactionsListForIssueComment.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)`.
    public func reactionsCreateForIssueComment(
        path: Operations.ReactionsCreateForIssueComment.Input.Path,
        headers: Operations.ReactionsCreateForIssueComment.Input.Headers = .init(),
        body: Operations.ReactionsCreateForIssueComment.Input.Body
    ) async throws -> Operations.ReactionsCreateForIssueComment.Output {
        try await reactionsCreateForIssueComment(Operations.ReactionsCreateForIssueComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an issue comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)`.
    public func reactionsDeleteForIssueComment(path: Operations.ReactionsDeleteForIssueComment.Input.Path) async throws -> Operations.ReactionsDeleteForIssueComment.Output {
        try await reactionsDeleteForIssueComment(Operations.ReactionsDeleteForIssueComment.Input(path: path))
    }
    /// List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)`.
    public func reactionsListForIssue(
        path: Operations.ReactionsListForIssue.Input.Path,
        query: Operations.ReactionsListForIssue.Input.Query = .init(),
        headers: Operations.ReactionsListForIssue.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForIssue.Output {
        try await reactionsListForIssue(Operations.ReactionsListForIssue.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)`.
    public func reactionsCreateForIssue(
        path: Operations.ReactionsCreateForIssue.Input.Path,
        headers: Operations.ReactionsCreateForIssue.Input.Headers = .init(),
        body: Operations.ReactionsCreateForIssue.Input.Body
    ) async throws -> Operations.ReactionsCreateForIssue.Output {
        try await reactionsCreateForIssue(Operations.ReactionsCreateForIssue.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an issue reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)`.
    public func reactionsDeleteForIssue(path: Operations.ReactionsDeleteForIssue.Input.Path) async throws -> Operations.ReactionsDeleteForIssue.Output {
        try await reactionsDeleteForIssue(Operations.ReactionsDeleteForIssue.Input(path: path))
    }
    /// List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)`.
    public func reactionsListForPullRequestReviewComment(
        path: Operations.ReactionsListForPullRequestReviewComment.Input.Path,
        query: Operations.ReactionsListForPullRequestReviewComment.Input.Query = .init(),
        headers: Operations.ReactionsListForPullRequestReviewComment.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForPullRequestReviewComment.Output {
        try await reactionsListForPullRequestReviewComment(Operations.ReactionsListForPullRequestReviewComment.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)`.
    public func reactionsCreateForPullRequestReviewComment(
        path: Operations.ReactionsCreateForPullRequestReviewComment.Input.Path,
        headers: Operations.ReactionsCreateForPullRequestReviewComment.Input.Headers = .init(),
        body: Operations.ReactionsCreateForPullRequestReviewComment.Input.Body
    ) async throws -> Operations.ReactionsCreateForPullRequestReviewComment.Output {
        try await reactionsCreateForPullRequestReviewComment(Operations.ReactionsCreateForPullRequestReviewComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a pull request comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    ///
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)`.
    public func reactionsDeleteForPullRequestComment(path: Operations.ReactionsDeleteForPullRequestComment.Input.Path) async throws -> Operations.ReactionsDeleteForPullRequestComment.Output {
        try await reactionsDeleteForPullRequestComment(Operations.ReactionsDeleteForPullRequestComment.Input(path: path))
    }
    /// List reactions for a release
    ///
    /// List the reactions to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)`.
    public func reactionsListForRelease(
        path: Operations.ReactionsListForRelease.Input.Path,
        query: Operations.ReactionsListForRelease.Input.Query = .init(),
        headers: Operations.ReactionsListForRelease.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForRelease.Output {
        try await reactionsListForRelease(Operations.ReactionsListForRelease.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)`.
    public func reactionsCreateForRelease(
        path: Operations.ReactionsCreateForRelease.Input.Path,
        headers: Operations.ReactionsCreateForRelease.Input.Headers = .init(),
        body: Operations.ReactionsCreateForRelease.Input.Body
    ) async throws -> Operations.ReactionsCreateForRelease.Output {
        try await reactionsCreateForRelease(Operations.ReactionsCreateForRelease.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a release reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)`.
    public func reactionsDeleteForRelease(path: Operations.ReactionsDeleteForRelease.Input.Path) async throws -> Operations.ReactionsDeleteForRelease.Output {
        try await reactionsDeleteForRelease(Operations.ReactionsDeleteForRelease.Input(path: path))
    }
    /// List reactions for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func reactionsListForTeamDiscussionCommentLegacy(
        path: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Path,
        query: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Query = .init(),
        headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForTeamDiscussionCommentLegacy.Output {
        try await reactionsListForTeamDiscussionCommentLegacy(Operations.ReactionsListForTeamDiscussionCommentLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func reactionsCreateForTeamDiscussionCommentLegacy(
        path: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Path,
        headers: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Headers = .init(),
        body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body
    ) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output {
        try await reactionsCreateForTeamDiscussionCommentLegacy(Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List reactions for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-legacy)`.
    @available(*, deprecated)
    public func reactionsListForTeamDiscussionLegacy(
        path: Operations.ReactionsListForTeamDiscussionLegacy.Input.Path,
        query: Operations.ReactionsListForTeamDiscussionLegacy.Input.Query = .init(),
        headers: Operations.ReactionsListForTeamDiscussionLegacy.Input.Headers = .init()
    ) async throws -> Operations.ReactionsListForTeamDiscussionLegacy.Output {
        try await reactionsListForTeamDiscussionLegacy(Operations.ReactionsListForTeamDiscussionLegacy.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create reaction for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-legacy)`.
    @available(*, deprecated)
    public func reactionsCreateForTeamDiscussionLegacy(
        path: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Path,
        headers: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Headers = .init(),
        body: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body
    ) async throws -> Operations.ReactionsCreateForTeamDiscussionLegacy.Output {
        try await reactionsCreateForTeamDiscussionLegacy(Operations.ReactionsCreateForTeamDiscussionLegacy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Reactions to conversations provide a way to help people express their feelings more simply and effectively.
        ///
        /// - Remark: Generated from `#/components/schemas/reaction`.
        public struct Reaction: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// The reaction to use
            ///
            /// - Remark: Generated from `#/components/schemas/reaction/content`.
            @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh = "laugh"
                case confused = "confused"
                case heart = "heart"
                case hooray = "hooray"
                case rocket = "rocket"
                case eyes = "eyes"
            }
            /// The reaction to use
            ///
            /// - Remark: Generated from `#/components/schemas/reaction/content`.
            public var content: Components.Schemas.Reaction.ContentPayload
            /// - Remark: Generated from `#/components/schemas/reaction/created_at`.
            public var createdAt: Foundation.Date
            /// Creates a new `Reaction`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - user:
            ///   - content: The reaction to use
            ///   - createdAt:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                content: Components.Schemas.Reaction.ContentPayload,
                createdAt: Foundation.Date
            ) {
                self.id = id
                self.nodeId = nodeId
                self.user = user
                self.content = content
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case user
                case content
                case createdAt = "created_at"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The slug of the team name.
        ///
        /// - Remark: Generated from `#/components/parameters/team-slug`.
        public typealias TeamSlug = Swift.String
        /// The unique identifier of the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-id`.
        public typealias CommentId = Swift.Int64
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The number that identifies the discussion.
        ///
        /// - Remark: Generated from `#/components/parameters/discussion-number`.
        public typealias DiscussionNumber = Swift.Int
        /// The number that identifies the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-number`.
        public typealias CommentNumber = Swift.Int
        /// The unique identifier of the reaction.
        ///
        /// - Remark: Generated from `#/components/parameters/reaction-id`.
        public typealias ReactionId = Swift.Int
        /// The number that identifies the issue.
        ///
        /// - Remark: Generated from `#/components/parameters/issue-number`.
        public typealias IssueNumber = Swift.Int
        /// The unique identifier of the release.
        ///
        /// - Remark: Generated from `#/components/parameters/release-id`.
        public typealias ReleaseId = Swift.Int
        /// The unique identifier of the team.
        ///
        /// - Remark: Generated from `#/components/parameters/team-id`.
        public typealias TeamId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Gone: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/gone/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/gone/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Gone.Body
            /// Creates a new `Gone`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Gone.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-in-org)`.
    public enum ReactionsListForTeamDiscussionCommentInOrg {
        public static let id: Swift.String = "reactions/list-for-team-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion comment.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionCommentInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionCommentInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Path,
                query: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Query = .init(),
                headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)`.
    public enum ReactionsCreateForTeamDiscussionCommentInOrg {
        public static let id: Swift.String = "reactions/create-for-team-discussion-comment-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionCommentInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionCommentInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    public init(content: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Path,
                headers: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Headers = .init(),
                body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when the reaction type has already been added to this team discussion comment
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete team discussion comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)`.
    public enum ReactionsDeleteForTeamDiscussionComment {
        public static let id: Swift.String = "reactions/delete-for-team-discussion-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForTeamDiscussionComment.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForTeamDiscussionComment.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForTeamDiscussionComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForTeamDiscussionComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-in-org)`.
    public enum ReactionsListForTeamDiscussionInOrg {
        public static let id: Swift.String = "reactions/list-for-team-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.ReactionsListForTeamDiscussionInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForTeamDiscussionInOrg.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForTeamDiscussionInOrg.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForTeamDiscussionInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForTeamDiscussionInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForTeamDiscussionInOrg.Input.Path,
                query: Operations.ReactionsListForTeamDiscussionInOrg.Input.Query = .init(),
                headers: Operations.ReactionsListForTeamDiscussionInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)`.
    public enum ReactionsCreateForTeamDiscussionInOrg {
        public static let id: Swift.String = "reactions/create-for-team-discussion-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    public init(content: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Path,
                headers: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Headers = .init(),
                body: Operations.ReactionsCreateForTeamDiscussionInOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete team discussion reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)`.
    public enum ReactionsDeleteForTeamDiscussion {
        public static let id: Swift.String = "reactions/delete-for-team-discussion"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The slug of the team name.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/DELETE/path/team_slug`.
                public var teamSlug: Components.Parameters.TeamSlug
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/DELETE/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - teamSlug: The slug of the team name.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    org: Components.Parameters.Org,
                    teamSlug: Components.Parameters.TeamSlug,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.org = org
                    self.teamSlug = teamSlug
                    self.discussionNumber = discussionNumber
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForTeamDiscussion.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForTeamDiscussion.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForTeamDiscussion.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForTeamDiscussion.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)`.
    public enum ReactionsListForCommitComment {
        public static let id: Swift.String = "reactions/list-for-commit-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsListForCommitComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a commit comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForCommitComment.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a commit comment.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForCommitComment.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForCommitComment.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForCommitComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForCommitComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForCommitComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForCommitComment.Input.Path,
                query: Operations.ReactionsListForCommitComment.Input.Query = .init(),
                headers: Operations.ReactionsListForCommitComment.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForCommitComment.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForCommitComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForCommitComment.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForCommitComment.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForCommitComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForCommitComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)`.
    public enum ReactionsCreateForCommitComment {
        public static let id: Swift.String = "reactions/create-for-commit-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsCreateForCommitComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForCommitComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForCommitComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForCommitComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the commit comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the commit comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForCommitComment.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the commit comment.
                    public init(content: Operations.ReactionsCreateForCommitComment.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForCommitComment.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForCommitComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForCommitComment.Input.Path,
                headers: Operations.ReactionsCreateForCommitComment.Input.Headers = .init(),
                body: Operations.ReactionsCreateForCommitComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForCommitComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForCommitComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Reaction exists
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForCommitComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForCommitComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForCommitComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForCommitComment.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Reaction created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForCommitComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForCommitComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a commit comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)`.
    public enum ReactionsDeleteForCommitComment {
        public static let id: Swift.String = "reactions/delete-for-commit-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForCommitComment.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForCommitComment.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForCommitComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForCommitComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)`.
    public enum ReactionsListForIssueComment {
        public static let id: Swift.String = "reactions/list-for-issue-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsListForIssueComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to an issue comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForIssueComment.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to an issue comment.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForIssueComment.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForIssueComment.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForIssueComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForIssueComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForIssueComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForIssueComment.Input.Path,
                query: Operations.ReactionsListForIssueComment.Input.Query = .init(),
                headers: Operations.ReactionsListForIssueComment.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForIssueComment.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForIssueComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForIssueComment.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForIssueComment.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForIssueComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForIssueComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)`.
    public enum ReactionsCreateForIssueComment {
        public static let id: Swift.String = "reactions/create-for-issue-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsCreateForIssueComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForIssueComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForIssueComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForIssueComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForIssueComment.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue comment.
                    public init(content: Operations.ReactionsCreateForIssueComment.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForIssueComment.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForIssueComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForIssueComment.Input.Path,
                headers: Operations.ReactionsCreateForIssueComment.Input.Headers = .init(),
                body: Operations.ReactionsCreateForIssueComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForIssueComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForIssueComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Reaction exists
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForIssueComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForIssueComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForIssueComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForIssueComment.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Reaction created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForIssueComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForIssueComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an issue comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)`.
    public enum ReactionsDeleteForIssueComment {
        public static let id: Swift.String = "reactions/delete-for-issue-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForIssueComment.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForIssueComment.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForIssueComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForIssueComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)`.
    public enum ReactionsListForIssue {
        public static let id: Swift.String = "reactions/list-for-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.ReactionsListForIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to an issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForIssue.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to an issue.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForIssue.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForIssue.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForIssue.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForIssue.Input.Path,
                query: Operations.ReactionsListForIssue.Input.Query = .init(),
                headers: Operations.ReactionsListForIssue.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForIssue.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForIssue.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForIssue.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForIssue.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForIssue.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForIssue.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)`.
    public enum ReactionsCreateForIssue {
        public static let id: Swift.String = "reactions/create-for-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                }
            }
            public var path: Operations.ReactionsCreateForIssue.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForIssue.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForIssue.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForIssue.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForIssue.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue.
                    public init(content: Operations.ReactionsCreateForIssue.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForIssue.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForIssue.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForIssue.Input.Path,
                headers: Operations.ReactionsCreateForIssue.Input.Headers = .init(),
                body: Operations.ReactionsCreateForIssue.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForIssue.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForIssue.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForIssue.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForIssue.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForIssue.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForIssue.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForIssue.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForIssue.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an issue reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)`.
    public enum ReactionsDeleteForIssue {
        public static let id: Swift.String = "reactions/delete-for-issue"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the issue.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/DELETE/path/issue_number`.
                public var issueNumber: Components.Parameters.IssueNumber
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - issueNumber: The number that identifies the issue.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    issueNumber: Components.Parameters.IssueNumber,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.issueNumber = issueNumber
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForIssue.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForIssue.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForIssue.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForIssue.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)`.
    public enum ReactionsListForPullRequestReviewComment {
        public static let id: Swift.String = "reactions/list-for-pull-request-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsListForPullRequestReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a pull request review comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForPullRequestReviewComment.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a pull request review comment.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForPullRequestReviewComment.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForPullRequestReviewComment.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForPullRequestReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForPullRequestReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForPullRequestReviewComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForPullRequestReviewComment.Input.Path,
                query: Operations.ReactionsListForPullRequestReviewComment.Input.Query = .init(),
                headers: Operations.ReactionsListForPullRequestReviewComment.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForPullRequestReviewComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForPullRequestReviewComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)`.
    public enum ReactionsCreateForPullRequestReviewComment {
        public static let id: Swift.String = "reactions/create-for-pull-request-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.ReactionsCreateForPullRequestReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForPullRequestReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForPullRequestReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForPullRequestReviewComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the pull request review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the pull request review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForPullRequestReviewComment.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the pull request review comment.
                    public init(content: Operations.ReactionsCreateForPullRequestReviewComment.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForPullRequestReviewComment.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForPullRequestReviewComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForPullRequestReviewComment.Input.Path,
                headers: Operations.ReactionsCreateForPullRequestReviewComment.Input.Headers = .init(),
                body: Operations.ReactionsCreateForPullRequestReviewComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Reaction exists
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForPullRequestReviewComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForPullRequestReviewComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Reaction created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForPullRequestReviewComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForPullRequestReviewComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a pull request comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    ///
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)`.
    public enum ReactionsDeleteForPullRequestComment {
        public static let id: Swift.String = "reactions/delete-for-pull-request-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForPullRequestComment.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForPullRequestComment.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForPullRequestComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForPullRequestComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for a release
    ///
    /// List the reactions to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)`.
    public enum ReactionsListForRelease {
        public static let id: Swift.String = "reactions/list-for-release"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the release.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/path/release_id`.
                public var releaseId: Components.Parameters.ReleaseId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - releaseId: The unique identifier of the release.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    releaseId: Components.Parameters.ReleaseId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.releaseId = releaseId
                }
            }
            public var path: Operations.ReactionsListForRelease.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case laugh = "laugh"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a release.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForRelease.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a release.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForRelease.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForRelease.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForRelease.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForRelease.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForRelease.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForRelease.Input.Path,
                query: Operations.ReactionsListForRelease.Input.Query = .init(),
                headers: Operations.ReactionsListForRelease.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForRelease.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForRelease.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForRelease.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForRelease.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForRelease.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForRelease.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)`.
    public enum ReactionsCreateForRelease {
        public static let id: Swift.String = "reactions/create-for-release"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the release.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/path/release_id`.
                public var releaseId: Components.Parameters.ReleaseId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - releaseId: The unique identifier of the release.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    releaseId: Components.Parameters.ReleaseId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.releaseId = releaseId
                }
            }
            public var path: Operations.ReactionsCreateForRelease.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForRelease.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForRelease.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForRelease.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the release.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case laugh = "laugh"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the release.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForRelease.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the release.
                    public init(content: Operations.ReactionsCreateForRelease.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForRelease.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForRelease.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForRelease.Input.Path,
                headers: Operations.ReactionsCreateForRelease.Input.Headers = .init(),
                body: Operations.ReactionsCreateForRelease.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForRelease.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForRelease.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Reaction exists
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsCreateForRelease.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsCreateForRelease.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForRelease.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForRelease.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Reaction created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForRelease.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForRelease.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a release reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)`.
    public enum ReactionsDeleteForRelease {
        public static let id: Swift.String = "reactions/delete-for-release"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the release.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/DELETE/path/release_id`.
                public var releaseId: Components.Parameters.ReleaseId
                /// The unique identifier of the reaction.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/DELETE/path/reaction_id`.
                public var reactionId: Components.Parameters.ReactionId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - releaseId: The unique identifier of the release.
                ///   - reactionId: The unique identifier of the reaction.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    releaseId: Components.Parameters.ReleaseId,
                    reactionId: Components.Parameters.ReactionId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.releaseId = releaseId
                    self.reactionId = reactionId
                }
            }
            public var path: Operations.ReactionsDeleteForRelease.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ReactionsDeleteForRelease.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ReactionsDeleteForRelease.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ReactionsDeleteForRelease.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List reactions for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-legacy)`.
    public enum ReactionsListForTeamDiscussionCommentLegacy {
        public static let id: Swift.String = "reactions/list-for-team-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion comment.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionCommentLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionCommentLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Path,
                query: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Query = .init(),
                headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-legacy)`.
    public enum ReactionsCreateForTeamDiscussionCommentLegacy {
        public static let id: Swift.String = "reactions/create-for-team-discussion-comment-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// The number that identifies the comment.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/path/comment_number`.
                public var commentNumber: Components.Parameters.CommentNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                ///   - commentNumber: The number that identifies the comment.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber,
                    commentNumber: Components.Parameters.CommentNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                    self.commentNumber = commentNumber
                }
            }
            public var path: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionCommentLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionCommentLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.
                    public init(content: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Path,
                headers: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Headers = .init(),
                body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-legacy)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List reactions for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-legacy)`.
    public enum ReactionsListForTeamDiscussionLegacy {
        public static let id: Swift.String = "reactions/list-for-team-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.ReactionsListForTeamDiscussionLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/query/content`.
                @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case _plus_1 = "+1"
                    case _hyphen_1 = "-1"
                    case laugh = "laugh"
                    case confused = "confused"
                    case heart = "heart"
                    case hooray = "hooray"
                    case rocket = "rocket"
                    case eyes = "eyes"
                }
                /// Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/query/content`.
                public var content: Operations.ReactionsListForTeamDiscussionLegacy.Input.Query.ContentPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - content: Returns a single [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions). Omit this parameter to list all reactions to a team discussion.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    content: Operations.ReactionsListForTeamDiscussionLegacy.Input.Query.ContentPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.content = content
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ReactionsListForTeamDiscussionLegacy.Input.Query
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsListForTeamDiscussionLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsListForTeamDiscussionLegacy.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ReactionsListForTeamDiscussionLegacy.Input.Path,
                query: Operations.ReactionsListForTeamDiscussionLegacy.Input.Query = .init(),
                headers: Operations.ReactionsListForTeamDiscussionLegacy.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Reaction])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Reaction] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Headers = .init(),
                    body: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-legacy)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create reaction for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-legacy)`.
    public enum ReactionsCreateForTeamDiscussionLegacy {
        public static let id: Swift.String = "reactions/create-for-team-discussion-legacy"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the team.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/path/team_id`.
                public var teamId: Components.Parameters.TeamId
                /// The number that identifies the discussion.
                ///
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/path/discussion_number`.
                public var discussionNumber: Components.Parameters.DiscussionNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - teamId: The unique identifier of the team.
                ///   - discussionNumber: The number that identifies the discussion.
                public init(
                    teamId: Components.Parameters.TeamId,
                    discussionNumber: Components.Parameters.DiscussionNumber
                ) {
                    self.teamId = teamId
                    self.discussionNumber = discussionNumber
                }
            }
            public var path: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Path
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionLegacy.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ReactionsCreateForTeamDiscussionLegacy.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Headers
            /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/requestBody/json/content`.
                    @frozen public enum ContentPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _plus_1 = "+1"
                        case _hyphen_1 = "-1"
                        case laugh = "laugh"
                        case confused = "confused"
                        case heart = "heart"
                        case hooray = "hooray"
                        case rocket = "rocket"
                        case eyes = "eyes"
                    }
                    /// The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    ///
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/requestBody/json/content`.
                    public var content: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body.JsonPayload.ContentPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.
                    public init(content: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body.JsonPayload.ContentPayload) {
                        self.content = content
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                    }
                }
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/requestBody/content/application\/json`.
                case json(Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body.JsonPayload)
            }
            public var body: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Path,
                headers: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Headers = .init(),
                body: Operations.ReactionsCreateForTeamDiscussionLegacy.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/teams/{team_id}/discussions/{discussion_number}/reactions/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Reaction)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Reaction {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ReactionsCreateForTeamDiscussionLegacy.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ReactionsCreateForTeamDiscussionLegacy.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-legacy)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ReactionsCreateForTeamDiscussionLegacy.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ReactionsCreateForTeamDiscussionLegacy.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
