// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// List reactions for a team discussion comment
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-in-org)`.
    public func reactionsListForTeamDiscussionCommentInOrg(_ input: Operations.ReactionsListForTeamDiscussionCommentInOrg.Input) async throws -> Operations.ReactionsListForTeamDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForTeamDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForTeamDiscussionCommentInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a team discussion comment
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-in-org)`.
    public func reactionsCreateForTeamDiscussionCommentInOrg(_ input: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionCommentInOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete team discussion comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion-comment)`.
    public func reactionsDeleteForTeamDiscussionComment(_ input: Operations.ReactionsDeleteForTeamDiscussionComment.Input) async throws -> Operations.ReactionsDeleteForTeamDiscussionComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForTeamDiscussionComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/comments/{}/reactions/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.commentNumber,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a team discussion
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-in-org)`.
    public func reactionsListForTeamDiscussionInOrg(_ input: Operations.ReactionsListForTeamDiscussionInOrg.Input) async throws -> Operations.ReactionsListForTeamDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForTeamDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/reactions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForTeamDiscussionInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a team discussion
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// > [!NOTE]
    /// > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-in-org)`.
    public func reactionsCreateForTeamDiscussionInOrg(_ input: Operations.ReactionsCreateForTeamDiscussionInOrg.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionInOrg.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForTeamDiscussionInOrg.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/reactions",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionInOrg.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete team discussion reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}/delete(reactions/delete-for-team-discussion)`.
    public func reactionsDeleteForTeamDiscussion(_ input: Operations.ReactionsDeleteForTeamDiscussion.Input) async throws -> Operations.ReactionsDeleteForTeamDiscussion.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForTeamDiscussion.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/orgs/{}/teams/{}/discussions/{}/reactions/{}",
                    parameters: [
                        input.path.org,
                        input.path.teamSlug,
                        input.path.discussionNumber,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a commit comment
    ///
    /// List the reactions to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/get(reactions/list-for-commit-comment)`.
    public func reactionsListForCommitComment(_ input: Operations.ReactionsListForCommitComment.Input) async throws -> Operations.ReactionsListForCommitComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForCommitComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForCommitComment.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForCommitComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a commit comment
    ///
    /// Create a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/post(reactions/create-for-commit-comment)`.
    public func reactionsCreateForCommitComment(_ input: Operations.ReactionsCreateForCommitComment.Input) async throws -> Operations.ReactionsCreateForCommitComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForCommitComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForCommitComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForCommitComment.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a commit comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-commit-comment)`.
    public func reactionsDeleteForCommitComment(_ input: Operations.ReactionsDeleteForCommitComment.Input) async throws -> Operations.ReactionsDeleteForCommitComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForCommitComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/comments/{}/reactions/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for an issue comment
    ///
    /// List the reactions to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/get(reactions/list-for-issue-comment)`.
    public func reactionsListForIssueComment(_ input: Operations.ReactionsListForIssueComment.Input) async throws -> Operations.ReactionsListForIssueComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForIssueComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForIssueComment.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForIssueComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for an issue comment
    ///
    /// Create a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/post(reactions/create-for-issue-comment)`.
    public func reactionsCreateForIssueComment(_ input: Operations.ReactionsCreateForIssueComment.Input) async throws -> Operations.ReactionsCreateForIssueComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForIssueComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForIssueComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForIssueComment.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an issue comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-issue-comment)`.
    public func reactionsDeleteForIssueComment(_ input: Operations.ReactionsDeleteForIssueComment.Input) async throws -> Operations.ReactionsDeleteForIssueComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForIssueComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/comments/{}/reactions/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for an issue
    ///
    /// List the reactions to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/get(reactions/list-for-issue)`.
    public func reactionsListForIssue(_ input: Operations.ReactionsListForIssue.Input) async throws -> Operations.ReactionsListForIssue.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForIssue.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.issueNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForIssue.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForIssue.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                case 410:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Gone.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .gone(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for an issue
    ///
    /// Create a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/issues/{issue_number}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/post(reactions/create-for-issue)`.
    public func reactionsCreateForIssue(_ input: Operations.ReactionsCreateForIssue.Input) async throws -> Operations.ReactionsCreateForIssue.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForIssue.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.issueNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForIssue.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForIssue.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an issue reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
    ///
    /// Delete a reaction to an [issue](https://docs.github.com/rest/issues/issues#get-an-issue).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}/delete(reactions/delete-for-issue)`.
    public func reactionsDeleteForIssue(_ input: Operations.ReactionsDeleteForIssue.Input) async throws -> Operations.ReactionsDeleteForIssue.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForIssue.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/issues/{}/reactions/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.issueNumber,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a pull request review comment
    ///
    /// List the reactions to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/get(reactions/list-for-pull-request-review-comment)`.
    public func reactionsListForPullRequestReviewComment(_ input: Operations.ReactionsListForPullRequestReviewComment.Input) async throws -> Operations.ReactionsListForPullRequestReviewComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForPullRequestReviewComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/pulls/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForPullRequestReviewComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a pull request review comment
    ///
    /// Create a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/post(reactions/create-for-pull-request-review-comment)`.
    public func reactionsCreateForPullRequestReviewComment(_ input: Operations.ReactionsCreateForPullRequestReviewComment.Input) async throws -> Operations.ReactionsCreateForPullRequestReviewComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForPullRequestReviewComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/pulls/comments/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForPullRequestReviewComment.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a pull request comment reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
    ///
    /// Delete a reaction to a [pull request review comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}/delete(reactions/delete-for-pull-request-comment)`.
    public func reactionsDeleteForPullRequestComment(_ input: Operations.ReactionsDeleteForPullRequestComment.Input) async throws -> Operations.ReactionsDeleteForPullRequestComment.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForPullRequestComment.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/pulls/comments/{}/reactions/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.commentId,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a release
    ///
    /// List the reactions to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/get(reactions/list-for-release)`.
    public func reactionsListForRelease(_ input: Operations.ReactionsListForRelease.Input) async throws -> Operations.ReactionsListForRelease.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForRelease.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/releases/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.releaseId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForRelease.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForRelease.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 404:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.NotFound.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .notFound(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a release
    ///
    /// Create a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/reactions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/post(reactions/create-for-release)`.
    public func reactionsCreateForRelease(_ input: Operations.ReactionsCreateForRelease.Input) async throws -> Operations.ReactionsCreateForRelease.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForRelease.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/releases/{}/reactions",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.releaseId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForRelease.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForRelease.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                case 422:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.ValidationFailed.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ValidationError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .unprocessableContent(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a release reaction
    ///
    /// > [!NOTE]
    /// > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
    ///
    /// Delete a reaction to a [release](https://docs.github.com/rest/releases/releases#get-a-release).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}/delete(reactions/delete-for-release)`.
    public func reactionsDeleteForRelease(_ input: Operations.ReactionsDeleteForRelease.Input) async throws -> Operations.ReactionsDeleteForRelease.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsDeleteForRelease.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/repos/{}/{}/releases/{}/reactions/{}",
                    parameters: [
                        input.path.owner,
                        input.path.repo,
                        input.path.releaseId,
                        input.path.reactionId
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
    ///
    /// List the reactions to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/get(reactions/list-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func reactionsListForTeamDiscussionCommentLegacy(_ input: Operations.ReactionsListForTeamDiscussionCommentLegacy.Input) async throws -> Operations.ReactionsListForTeamDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForTeamDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments/{}/reactions",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForTeamDiscussionCommentLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a team discussion comment (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
    ///
    /// Create a reaction to a [team discussion comment](https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions/post(reactions/create-for-team-discussion-comment-legacy)`.
    @available(*, deprecated)
    public func reactionsCreateForTeamDiscussionCommentLegacy(_ input: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/comments/{}/reactions",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber,
                        input.path.commentNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionCommentLegacy.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List reactions for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.
    ///
    /// List the reactions to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/get(reactions/list-for-team-discussion-legacy)`.
    @available(*, deprecated)
    public func reactionsListForTeamDiscussionLegacy(_ input: Operations.ReactionsListForTeamDiscussionLegacy.Input) async throws -> Operations.ReactionsListForTeamDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsListForTeamDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/reactions",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "content",
                    value: input.query.content
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsListForTeamDiscussionLegacy.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.Reaction].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create reaction for a team discussion (Legacy)
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.
    ///
    /// Create a reaction to a [team discussion](https://docs.github.com/rest/teams/discussions#get-a-discussion).
    ///
    /// A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /teams/{team_id}/discussions/{discussion_number}/reactions`.
    /// - Remark: Generated from `#/paths//teams/{team_id}/discussions/{discussion_number}/reactions/post(reactions/create-for-team-discussion-legacy)`.
    @available(*, deprecated)
    public func reactionsCreateForTeamDiscussionLegacy(_ input: Operations.ReactionsCreateForTeamDiscussionLegacy.Input) async throws -> Operations.ReactionsCreateForTeamDiscussionLegacy.Output {
        try await client.send(
            input: input,
            forOperation: Operations.ReactionsCreateForTeamDiscussionLegacy.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/teams/{}/discussions/{}/reactions",
                    parameters: [
                        input.path.teamId,
                        input.path.discussionNumber
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.ReactionsCreateForTeamDiscussionLegacy.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Reaction.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
