// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get rate limit status for the authenticated user
    ///
    /// > [!NOTE]
    /// > Accessing this endpoint does not count against your REST API rate limit.
    ///
    /// Some categories of endpoints have custom rate limits that are separate from the rate limit governing the other REST API endpoints. For this reason, the API response categorizes your rate limit. Under `resources`, you'll see objects relating to different categories:
    /// * The `core` object provides your rate limit status for all non-search-related resources in the REST API.
    /// * The `search` object provides your rate limit status for the REST API for searching (excluding code searches). For more information, see "[Search](https://docs.github.com/rest/search/search)."
    /// * The `code_search` object provides your rate limit status for the REST API for searching code. For more information, see "[Search code](https://docs.github.com/rest/search/search#search-code)."
    /// * The `graphql` object provides your rate limit status for the GraphQL API. For more information, see "[Resource limitations](https://docs.github.com/graphql/overview/resource-limitations#rate-limit)."
    /// * The `integration_manifest` object provides your rate limit status for the `POST /app-manifests/{code}/conversions` operation. For more information, see "[Creating a GitHub App from a manifest](https://docs.github.com/apps/creating-github-apps/setting-up-a-github-app/creating-a-github-app-from-a-manifest#3-you-exchange-the-temporary-code-to-retrieve-the-app-configuration)."
    /// * The `dependency_snapshots` object provides your rate limit status for submitting snapshots to the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `dependency_sbom` object provides your rate limit status for requesting SBOMs from the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `code_scanning_upload` object provides your rate limit status for uploading SARIF results to code scanning. For more information, see "[Uploading a SARIF file to GitHub](https://docs.github.com/code-security/code-scanning/integrating-with-code-scanning/uploading-a-sarif-file-to-github)."
    /// * The `actions_runner_registration` object provides your rate limit status for registering self-hosted runners in GitHub Actions. For more information, see "[Self-hosted runners](https://docs.github.com/rest/actions/self-hosted-runners)."
    /// * The `source_import` object is no longer in use for any API endpoints, and it will be removed in the next API version. For more information about API versions, see "[API Versions](https://docs.github.com/rest/about-the-rest-api/api-versions)."
    ///
    /// > [!NOTE]
    /// > The `rate` object is closing down. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
    ///
    /// - Remark: HTTP `GET /rate_limit`.
    /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)`.
    func rateLimitGet(_ input: Operations.RateLimitGet.Input) async throws -> Operations.RateLimitGet.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get rate limit status for the authenticated user
    ///
    /// > [!NOTE]
    /// > Accessing this endpoint does not count against your REST API rate limit.
    ///
    /// Some categories of endpoints have custom rate limits that are separate from the rate limit governing the other REST API endpoints. For this reason, the API response categorizes your rate limit. Under `resources`, you'll see objects relating to different categories:
    /// * The `core` object provides your rate limit status for all non-search-related resources in the REST API.
    /// * The `search` object provides your rate limit status for the REST API for searching (excluding code searches). For more information, see "[Search](https://docs.github.com/rest/search/search)."
    /// * The `code_search` object provides your rate limit status for the REST API for searching code. For more information, see "[Search code](https://docs.github.com/rest/search/search#search-code)."
    /// * The `graphql` object provides your rate limit status for the GraphQL API. For more information, see "[Resource limitations](https://docs.github.com/graphql/overview/resource-limitations#rate-limit)."
    /// * The `integration_manifest` object provides your rate limit status for the `POST /app-manifests/{code}/conversions` operation. For more information, see "[Creating a GitHub App from a manifest](https://docs.github.com/apps/creating-github-apps/setting-up-a-github-app/creating-a-github-app-from-a-manifest#3-you-exchange-the-temporary-code-to-retrieve-the-app-configuration)."
    /// * The `dependency_snapshots` object provides your rate limit status for submitting snapshots to the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `dependency_sbom` object provides your rate limit status for requesting SBOMs from the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `code_scanning_upload` object provides your rate limit status for uploading SARIF results to code scanning. For more information, see "[Uploading a SARIF file to GitHub](https://docs.github.com/code-security/code-scanning/integrating-with-code-scanning/uploading-a-sarif-file-to-github)."
    /// * The `actions_runner_registration` object provides your rate limit status for registering self-hosted runners in GitHub Actions. For more information, see "[Self-hosted runners](https://docs.github.com/rest/actions/self-hosted-runners)."
    /// * The `source_import` object is no longer in use for any API endpoints, and it will be removed in the next API version. For more information about API versions, see "[API Versions](https://docs.github.com/rest/about-the-rest-api/api-versions)."
    ///
    /// > [!NOTE]
    /// > The `rate` object is closing down. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
    ///
    /// - Remark: HTTP `GET /rate_limit`.
    /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)`.
    public func rateLimitGet(headers: Operations.RateLimitGet.Input.Headers = .init()) async throws -> Operations.RateLimitGet.Output {
        try await rateLimitGet(Operations.RateLimitGet.Input(headers: headers))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// - Remark: Generated from `#/components/schemas/rate-limit`.
        public struct RateLimit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/rate-limit/limit`.
            public var limit: Swift.Int
            /// - Remark: Generated from `#/components/schemas/rate-limit/remaining`.
            public var remaining: Swift.Int
            /// - Remark: Generated from `#/components/schemas/rate-limit/reset`.
            public var reset: Swift.Int
            /// - Remark: Generated from `#/components/schemas/rate-limit/used`.
            public var used: Swift.Int
            /// Creates a new `RateLimit`.
            ///
            /// - Parameters:
            ///   - limit:
            ///   - remaining:
            ///   - reset:
            ///   - used:
            public init(
                limit: Swift.Int,
                remaining: Swift.Int,
                reset: Swift.Int,
                used: Swift.Int
            ) {
                self.limit = limit
                self.remaining = remaining
                self.reset = reset
                self.used = used
            }
            public enum CodingKeys: String, CodingKey {
                case limit
                case remaining
                case reset
                case used
            }
        }
        /// Rate Limit Overview
        ///
        /// - Remark: Generated from `#/components/schemas/rate-limit-overview`.
        public struct RateLimitOverview: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources`.
            public struct ResourcesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/core`.
                public var core: Components.Schemas.RateLimit
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/graphql`.
                public var graphql: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/search`.
                public var search: Components.Schemas.RateLimit
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/code_search`.
                public var codeSearch: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/source_import`.
                public var sourceImport: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/integration_manifest`.
                public var integrationManifest: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/code_scanning_upload`.
                public var codeScanningUpload: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/actions_runner_registration`.
                public var actionsRunnerRegistration: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/scim`.
                public var scim: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/dependency_snapshots`.
                public var dependencySnapshots: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/dependency_sbom`.
                public var dependencySbom: Components.Schemas.RateLimit?
                /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources/code_scanning_autofix`.
                public var codeScanningAutofix: Components.Schemas.RateLimit?
                /// Creates a new `ResourcesPayload`.
                ///
                /// - Parameters:
                ///   - core:
                ///   - graphql:
                ///   - search:
                ///   - codeSearch:
                ///   - sourceImport:
                ///   - integrationManifest:
                ///   - codeScanningUpload:
                ///   - actionsRunnerRegistration:
                ///   - scim:
                ///   - dependencySnapshots:
                ///   - dependencySbom:
                ///   - codeScanningAutofix:
                public init(
                    core: Components.Schemas.RateLimit,
                    graphql: Components.Schemas.RateLimit? = nil,
                    search: Components.Schemas.RateLimit,
                    codeSearch: Components.Schemas.RateLimit? = nil,
                    sourceImport: Components.Schemas.RateLimit? = nil,
                    integrationManifest: Components.Schemas.RateLimit? = nil,
                    codeScanningUpload: Components.Schemas.RateLimit? = nil,
                    actionsRunnerRegistration: Components.Schemas.RateLimit? = nil,
                    scim: Components.Schemas.RateLimit? = nil,
                    dependencySnapshots: Components.Schemas.RateLimit? = nil,
                    dependencySbom: Components.Schemas.RateLimit? = nil,
                    codeScanningAutofix: Components.Schemas.RateLimit? = nil
                ) {
                    self.core = core
                    self.graphql = graphql
                    self.search = search
                    self.codeSearch = codeSearch
                    self.sourceImport = sourceImport
                    self.integrationManifest = integrationManifest
                    self.codeScanningUpload = codeScanningUpload
                    self.actionsRunnerRegistration = actionsRunnerRegistration
                    self.scim = scim
                    self.dependencySnapshots = dependencySnapshots
                    self.dependencySbom = dependencySbom
                    self.codeScanningAutofix = codeScanningAutofix
                }
                public enum CodingKeys: String, CodingKey {
                    case core
                    case graphql
                    case search
                    case codeSearch = "code_search"
                    case sourceImport = "source_import"
                    case integrationManifest = "integration_manifest"
                    case codeScanningUpload = "code_scanning_upload"
                    case actionsRunnerRegistration = "actions_runner_registration"
                    case scim
                    case dependencySnapshots = "dependency_snapshots"
                    case dependencySbom = "dependency_sbom"
                    case codeScanningAutofix = "code_scanning_autofix"
                }
            }
            /// - Remark: Generated from `#/components/schemas/rate-limit-overview/resources`.
            public var resources: Components.Schemas.RateLimitOverview.ResourcesPayload
            /// - Remark: Generated from `#/components/schemas/rate-limit-overview/rate`.
            public var rate: Components.Schemas.RateLimit
            /// Creates a new `RateLimitOverview`.
            ///
            /// - Parameters:
            ///   - resources:
            ///   - rate:
            public init(
                resources: Components.Schemas.RateLimitOverview.ResourcesPayload,
                rate: Components.Schemas.RateLimit
            ) {
                self.resources = resources
                self.rate = rate
            }
            public enum CodingKeys: String, CodingKey {
                case resources
                case rate
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {}
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/x-rate-limit-limit`.
        public typealias XRateLimitLimit = Swift.Int
        /// - Remark: Generated from `#/components/headers/x-rate-limit-remaining`.
        public typealias XRateLimitRemaining = Swift.Int
        /// - Remark: Generated from `#/components/headers/x-rate-limit-reset`.
        public typealias XRateLimitReset = Swift.Int
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get rate limit status for the authenticated user
    ///
    /// > [!NOTE]
    /// > Accessing this endpoint does not count against your REST API rate limit.
    ///
    /// Some categories of endpoints have custom rate limits that are separate from the rate limit governing the other REST API endpoints. For this reason, the API response categorizes your rate limit. Under `resources`, you'll see objects relating to different categories:
    /// * The `core` object provides your rate limit status for all non-search-related resources in the REST API.
    /// * The `search` object provides your rate limit status for the REST API for searching (excluding code searches). For more information, see "[Search](https://docs.github.com/rest/search/search)."
    /// * The `code_search` object provides your rate limit status for the REST API for searching code. For more information, see "[Search code](https://docs.github.com/rest/search/search#search-code)."
    /// * The `graphql` object provides your rate limit status for the GraphQL API. For more information, see "[Resource limitations](https://docs.github.com/graphql/overview/resource-limitations#rate-limit)."
    /// * The `integration_manifest` object provides your rate limit status for the `POST /app-manifests/{code}/conversions` operation. For more information, see "[Creating a GitHub App from a manifest](https://docs.github.com/apps/creating-github-apps/setting-up-a-github-app/creating-a-github-app-from-a-manifest#3-you-exchange-the-temporary-code-to-retrieve-the-app-configuration)."
    /// * The `dependency_snapshots` object provides your rate limit status for submitting snapshots to the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `dependency_sbom` object provides your rate limit status for requesting SBOMs from the dependency graph. For more information, see "[Dependency graph](https://docs.github.com/rest/dependency-graph)."
    /// * The `code_scanning_upload` object provides your rate limit status for uploading SARIF results to code scanning. For more information, see "[Uploading a SARIF file to GitHub](https://docs.github.com/code-security/code-scanning/integrating-with-code-scanning/uploading-a-sarif-file-to-github)."
    /// * The `actions_runner_registration` object provides your rate limit status for registering self-hosted runners in GitHub Actions. For more information, see "[Self-hosted runners](https://docs.github.com/rest/actions/self-hosted-runners)."
    /// * The `source_import` object is no longer in use for any API endpoints, and it will be removed in the next API version. For more information about API versions, see "[API Versions](https://docs.github.com/rest/about-the-rest-api/api-versions)."
    ///
    /// > [!NOTE]
    /// > The `rate` object is closing down. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
    ///
    /// - Remark: HTTP `GET /rate_limit`.
    /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)`.
    public enum RateLimitGet {
        public static let id: Swift.String = "rate-limit/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/rate_limit/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.RateLimitGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.RateLimitGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.RateLimitGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.RateLimitGet.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/headers/X-RateLimit-Limit`.
                    public var xRateLimitLimit: Components.Headers.XRateLimitLimit?
                    /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/headers/X-RateLimit-Remaining`.
                    public var xRateLimitRemaining: Components.Headers.XRateLimitRemaining?
                    /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/headers/X-RateLimit-Reset`.
                    public var xRateLimitReset: Components.Headers.XRateLimitReset?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - xRateLimitLimit:
                    ///   - xRateLimitRemaining:
                    ///   - xRateLimitReset:
                    public init(
                        xRateLimitLimit: Components.Headers.XRateLimitLimit? = nil,
                        xRateLimitRemaining: Components.Headers.XRateLimitRemaining? = nil,
                        xRateLimitReset: Components.Headers.XRateLimitReset? = nil
                    ) {
                        self.xRateLimitLimit = xRateLimitLimit
                        self.xRateLimitRemaining = xRateLimitRemaining
                        self.xRateLimitReset = xRateLimitReset
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.RateLimitGet.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/rate_limit/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RateLimitOverview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RateLimitOverview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.RateLimitGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.RateLimitGet.Output.Ok.Headers = .init(),
                    body: Operations.RateLimitGet.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.RateLimitGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.RateLimitGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//rate_limit/get(rate-limit/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
