// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List pull requests
    ///
    /// Lists pull requests in a specified repository.
    ///
    /// Draft pull requests are available in public repositories with GitHub
    /// Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
    /// plans, and in public and private repositories with GitHub Team and GitHub Enterprise
    /// Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)
    /// in the GitHub Help documentation.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)`.
    func pullsList(_ input: Operations.PullsList.Input) async throws -> Operations.PullsList.Output
    /// Create a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)`.
    func pullsCreate(_ input: Operations.PullsCreate.Input) async throws -> Operations.PullsCreate.Output
    /// List review comments in a repository
    ///
    /// Lists review comments for all pull requests in a repository. By default,
    /// review comments are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/get(pulls/list-review-comments-for-repo)`.
    func pullsListReviewCommentsForRepo(_ input: Operations.PullsListReviewCommentsForRepo.Input) async throws -> Operations.PullsListReviewCommentsForRepo.Output
    /// Get a review comment for a pull request
    ///
    /// Provides details for a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/get(pulls/get-review-comment)`.
    func pullsGetReviewComment(_ input: Operations.PullsGetReviewComment.Input) async throws -> Operations.PullsGetReviewComment.Output
    /// Update a review comment for a pull request
    ///
    /// Edits the content of a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/patch(pulls/update-review-comment)`.
    func pullsUpdateReviewComment(_ input: Operations.PullsUpdateReviewComment.Input) async throws -> Operations.PullsUpdateReviewComment.Output
    /// Delete a review comment for a pull request
    ///
    /// Deletes a review comment.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)`.
    func pullsDeleteReviewComment(_ input: Operations.PullsDeleteReviewComment.Input) async throws -> Operations.PullsDeleteReviewComment.Output
    /// Get a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists details of a pull request by providing its number.
    ///
    /// When you get, [create](https://docs.github.com/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
    ///
    /// The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
    ///
    /// *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
    /// *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
    /// *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
    ///
    /// Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    /// - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)`.
    func pullsGet(_ input: Operations.PullsGet.Input) async throws -> Operations.PullsGet.Output
    /// Update a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)`.
    func pullsUpdate(_ input: Operations.PullsUpdate.Input) async throws -> Operations.PullsUpdate.Output
    /// List review comments on a pull request
    ///
    /// Lists all review comments for a specified pull request. By default, review comments
    /// are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/get(pulls/list-review-comments)`.
    func pullsListReviewComments(_ input: Operations.PullsListReviewComments.Input) async throws -> Operations.PullsListReviewComments.Output
    /// Create a review comment for a pull request
    ///
    /// Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/issues/comments#create-an-issue-comment)."
    ///
    /// If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.
    ///
    /// The `position` parameter is closing down. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)`.
    func pullsCreateReviewComment(_ input: Operations.PullsCreateReviewComment.Input) async throws -> Operations.PullsCreateReviewComment.Output
    /// Create a reply for a review comment
    ///
    /// Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/post(pulls/create-reply-for-review-comment)`.
    func pullsCreateReplyForReviewComment(_ input: Operations.PullsCreateReplyForReviewComment.Input) async throws -> Operations.PullsCreateReplyForReviewComment.Output
    /// List commits on a pull request
    ///
    /// Lists a maximum of 250 commits for a pull request. To receive a complete
    /// commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/commits/commits#list-commits)
    /// endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/commits/get(pulls/list-commits)`.
    func pullsListCommits(_ input: Operations.PullsListCommits.Input) async throws -> Operations.PullsListCommits.Output
    /// List pull requests files
    ///
    /// Lists the files in a specified pull request.
    ///
    /// > [!NOTE]
    /// > Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)`.
    func pullsListFiles(_ input: Operations.PullsListFiles.Input) async throws -> Operations.PullsListFiles.Output
    /// Check if a pull request has been merged
    ///
    /// Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)`.
    func pullsCheckIfMerged(_ input: Operations.PullsCheckIfMerged.Input) async throws -> Operations.PullsCheckIfMerged.Output
    /// Merge a pull request
    ///
    /// Merges a pull request into the base branch.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)`.
    func pullsMerge(_ input: Operations.PullsMerge.Input) async throws -> Operations.PullsMerge.Output
    /// Get all requested reviewers for a pull request
    ///
    /// Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/get(pulls/list-requested-reviewers)`.
    func pullsListRequestedReviewers(_ input: Operations.PullsListRequestedReviewers.Input) async throws -> Operations.PullsListRequestedReviewers.Output
    /// Request reviewers for a pull request
    ///
    /// Requests reviews for a pull request from a given set of users and/or teams.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)`.
    func pullsRequestReviewers(_ input: Operations.PullsRequestReviewers.Input) async throws -> Operations.PullsRequestReviewers.Output
    /// Remove requested reviewers from a pull request
    ///
    /// Removes review requests from a pull request for a given set of users and/or teams.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/delete(pulls/remove-requested-reviewers)`.
    func pullsRemoveRequestedReviewers(_ input: Operations.PullsRemoveRequestedReviewers.Input) async throws -> Operations.PullsRemoveRequestedReviewers.Output
    /// List reviews for a pull request
    ///
    /// Lists all reviews for a specified pull request. The list of reviews returns in chronological order.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/get(pulls/list-reviews)`.
    func pullsListReviews(_ input: Operations.PullsListReviews.Input) async throws -> Operations.PullsListReviews.Output
    /// Create a review for a pull request
    ///
    /// Creates a review on a specified pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request)."
    ///
    /// > [!NOTE]
    /// > To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) endpoint.
    ///
    /// The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)`.
    func pullsCreateReview(_ input: Operations.PullsCreateReview.Input) async throws -> Operations.PullsCreateReview.Output
    /// Get a review for a pull request
    ///
    /// Retrieves a pull request review by its ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/get(pulls/get-review)`.
    func pullsGetReview(_ input: Operations.PullsGetReview.Input) async throws -> Operations.PullsGetReview.Output
    /// Update a review for a pull request
    ///
    /// Updates the contents of a specified review summary comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/put(pulls/update-review)`.
    func pullsUpdateReview(_ input: Operations.PullsUpdateReview.Input) async throws -> Operations.PullsUpdateReview.Output
    /// Delete a pending review for a pull request
    ///
    /// Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)`.
    func pullsDeletePendingReview(_ input: Operations.PullsDeletePendingReview.Input) async throws -> Operations.PullsDeletePendingReview.Output
    /// List comments for a pull request review
    ///
    /// Lists comments for a specific pull request review.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/get(pulls/list-comments-for-review)`.
    func pullsListCommentsForReview(_ input: Operations.PullsListCommentsForReview.Input) async throws -> Operations.PullsListCommentsForReview.Output
    /// Dismiss a review for a pull request
    ///
    /// Dismisses a specified review on a pull request.
    ///
    /// > [!NOTE]
    /// > To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/branches/branch-protection), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)`.
    func pullsDismissReview(_ input: Operations.PullsDismissReview.Input) async throws -> Operations.PullsDismissReview.Output
    /// Submit a review for a pull request
    ///
    /// Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)`.
    func pullsSubmitReview(_ input: Operations.PullsSubmitReview.Input) async throws -> Operations.PullsSubmitReview.Output
    /// Update a pull request branch
    ///
    /// Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
    /// Note: If making a request on behalf of a GitHub App you must also have permissions to write the contents of the head repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/update-branch`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)`.
    func pullsUpdateBranch(_ input: Operations.PullsUpdateBranch.Input) async throws -> Operations.PullsUpdateBranch.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List pull requests
    ///
    /// Lists pull requests in a specified repository.
    ///
    /// Draft pull requests are available in public repositories with GitHub
    /// Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
    /// plans, and in public and private repositories with GitHub Team and GitHub Enterprise
    /// Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)
    /// in the GitHub Help documentation.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)`.
    public func pullsList(
        path: Operations.PullsList.Input.Path,
        query: Operations.PullsList.Input.Query = .init(),
        headers: Operations.PullsList.Input.Headers = .init()
    ) async throws -> Operations.PullsList.Output {
        try await pullsList(Operations.PullsList.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)`.
    public func pullsCreate(
        path: Operations.PullsCreate.Input.Path,
        headers: Operations.PullsCreate.Input.Headers = .init(),
        body: Operations.PullsCreate.Input.Body
    ) async throws -> Operations.PullsCreate.Output {
        try await pullsCreate(Operations.PullsCreate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List review comments in a repository
    ///
    /// Lists review comments for all pull requests in a repository. By default,
    /// review comments are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/get(pulls/list-review-comments-for-repo)`.
    public func pullsListReviewCommentsForRepo(
        path: Operations.PullsListReviewCommentsForRepo.Input.Path,
        query: Operations.PullsListReviewCommentsForRepo.Input.Query = .init(),
        headers: Operations.PullsListReviewCommentsForRepo.Input.Headers = .init()
    ) async throws -> Operations.PullsListReviewCommentsForRepo.Output {
        try await pullsListReviewCommentsForRepo(Operations.PullsListReviewCommentsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a review comment for a pull request
    ///
    /// Provides details for a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/get(pulls/get-review-comment)`.
    public func pullsGetReviewComment(
        path: Operations.PullsGetReviewComment.Input.Path,
        headers: Operations.PullsGetReviewComment.Input.Headers = .init()
    ) async throws -> Operations.PullsGetReviewComment.Output {
        try await pullsGetReviewComment(Operations.PullsGetReviewComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a review comment for a pull request
    ///
    /// Edits the content of a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/patch(pulls/update-review-comment)`.
    public func pullsUpdateReviewComment(
        path: Operations.PullsUpdateReviewComment.Input.Path,
        headers: Operations.PullsUpdateReviewComment.Input.Headers = .init(),
        body: Operations.PullsUpdateReviewComment.Input.Body
    ) async throws -> Operations.PullsUpdateReviewComment.Output {
        try await pullsUpdateReviewComment(Operations.PullsUpdateReviewComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a review comment for a pull request
    ///
    /// Deletes a review comment.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)`.
    public func pullsDeleteReviewComment(
        path: Operations.PullsDeleteReviewComment.Input.Path,
        headers: Operations.PullsDeleteReviewComment.Input.Headers = .init()
    ) async throws -> Operations.PullsDeleteReviewComment.Output {
        try await pullsDeleteReviewComment(Operations.PullsDeleteReviewComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists details of a pull request by providing its number.
    ///
    /// When you get, [create](https://docs.github.com/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
    ///
    /// The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
    ///
    /// *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
    /// *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
    /// *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
    ///
    /// Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    /// - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)`.
    public func pullsGet(
        path: Operations.PullsGet.Input.Path,
        headers: Operations.PullsGet.Input.Headers = .init()
    ) async throws -> Operations.PullsGet.Output {
        try await pullsGet(Operations.PullsGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)`.
    public func pullsUpdate(
        path: Operations.PullsUpdate.Input.Path,
        headers: Operations.PullsUpdate.Input.Headers = .init(),
        body: Operations.PullsUpdate.Input.Body? = nil
    ) async throws -> Operations.PullsUpdate.Output {
        try await pullsUpdate(Operations.PullsUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List review comments on a pull request
    ///
    /// Lists all review comments for a specified pull request. By default, review comments
    /// are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/get(pulls/list-review-comments)`.
    public func pullsListReviewComments(
        path: Operations.PullsListReviewComments.Input.Path,
        query: Operations.PullsListReviewComments.Input.Query = .init(),
        headers: Operations.PullsListReviewComments.Input.Headers = .init()
    ) async throws -> Operations.PullsListReviewComments.Output {
        try await pullsListReviewComments(Operations.PullsListReviewComments.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a review comment for a pull request
    ///
    /// Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/issues/comments#create-an-issue-comment)."
    ///
    /// If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.
    ///
    /// The `position` parameter is closing down. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)`.
    public func pullsCreateReviewComment(
        path: Operations.PullsCreateReviewComment.Input.Path,
        headers: Operations.PullsCreateReviewComment.Input.Headers = .init(),
        body: Operations.PullsCreateReviewComment.Input.Body
    ) async throws -> Operations.PullsCreateReviewComment.Output {
        try await pullsCreateReviewComment(Operations.PullsCreateReviewComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a reply for a review comment
    ///
    /// Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/post(pulls/create-reply-for-review-comment)`.
    public func pullsCreateReplyForReviewComment(
        path: Operations.PullsCreateReplyForReviewComment.Input.Path,
        headers: Operations.PullsCreateReplyForReviewComment.Input.Headers = .init(),
        body: Operations.PullsCreateReplyForReviewComment.Input.Body
    ) async throws -> Operations.PullsCreateReplyForReviewComment.Output {
        try await pullsCreateReplyForReviewComment(Operations.PullsCreateReplyForReviewComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List commits on a pull request
    ///
    /// Lists a maximum of 250 commits for a pull request. To receive a complete
    /// commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/commits/commits#list-commits)
    /// endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/commits/get(pulls/list-commits)`.
    public func pullsListCommits(
        path: Operations.PullsListCommits.Input.Path,
        query: Operations.PullsListCommits.Input.Query = .init(),
        headers: Operations.PullsListCommits.Input.Headers = .init()
    ) async throws -> Operations.PullsListCommits.Output {
        try await pullsListCommits(Operations.PullsListCommits.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List pull requests files
    ///
    /// Lists the files in a specified pull request.
    ///
    /// > [!NOTE]
    /// > Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)`.
    public func pullsListFiles(
        path: Operations.PullsListFiles.Input.Path,
        query: Operations.PullsListFiles.Input.Query = .init(),
        headers: Operations.PullsListFiles.Input.Headers = .init()
    ) async throws -> Operations.PullsListFiles.Output {
        try await pullsListFiles(Operations.PullsListFiles.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if a pull request has been merged
    ///
    /// Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)`.
    public func pullsCheckIfMerged(path: Operations.PullsCheckIfMerged.Input.Path) async throws -> Operations.PullsCheckIfMerged.Output {
        try await pullsCheckIfMerged(Operations.PullsCheckIfMerged.Input(path: path))
    }
    /// Merge a pull request
    ///
    /// Merges a pull request into the base branch.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)`.
    public func pullsMerge(
        path: Operations.PullsMerge.Input.Path,
        headers: Operations.PullsMerge.Input.Headers = .init(),
        body: Operations.PullsMerge.Input.Body? = nil
    ) async throws -> Operations.PullsMerge.Output {
        try await pullsMerge(Operations.PullsMerge.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get all requested reviewers for a pull request
    ///
    /// Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/get(pulls/list-requested-reviewers)`.
    public func pullsListRequestedReviewers(
        path: Operations.PullsListRequestedReviewers.Input.Path,
        headers: Operations.PullsListRequestedReviewers.Input.Headers = .init()
    ) async throws -> Operations.PullsListRequestedReviewers.Output {
        try await pullsListRequestedReviewers(Operations.PullsListRequestedReviewers.Input(
            path: path,
            headers: headers
        ))
    }
    /// Request reviewers for a pull request
    ///
    /// Requests reviews for a pull request from a given set of users and/or teams.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)`.
    public func pullsRequestReviewers(
        path: Operations.PullsRequestReviewers.Input.Path,
        headers: Operations.PullsRequestReviewers.Input.Headers = .init(),
        body: Operations.PullsRequestReviewers.Input.Body? = nil
    ) async throws -> Operations.PullsRequestReviewers.Output {
        try await pullsRequestReviewers(Operations.PullsRequestReviewers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove requested reviewers from a pull request
    ///
    /// Removes review requests from a pull request for a given set of users and/or teams.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/delete(pulls/remove-requested-reviewers)`.
    public func pullsRemoveRequestedReviewers(
        path: Operations.PullsRemoveRequestedReviewers.Input.Path,
        headers: Operations.PullsRemoveRequestedReviewers.Input.Headers = .init(),
        body: Operations.PullsRemoveRequestedReviewers.Input.Body
    ) async throws -> Operations.PullsRemoveRequestedReviewers.Output {
        try await pullsRemoveRequestedReviewers(Operations.PullsRemoveRequestedReviewers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List reviews for a pull request
    ///
    /// Lists all reviews for a specified pull request. The list of reviews returns in chronological order.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/get(pulls/list-reviews)`.
    public func pullsListReviews(
        path: Operations.PullsListReviews.Input.Path,
        query: Operations.PullsListReviews.Input.Query = .init(),
        headers: Operations.PullsListReviews.Input.Headers = .init()
    ) async throws -> Operations.PullsListReviews.Output {
        try await pullsListReviews(Operations.PullsListReviews.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a review for a pull request
    ///
    /// Creates a review on a specified pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request)."
    ///
    /// > [!NOTE]
    /// > To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) endpoint.
    ///
    /// The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)`.
    public func pullsCreateReview(
        path: Operations.PullsCreateReview.Input.Path,
        headers: Operations.PullsCreateReview.Input.Headers = .init(),
        body: Operations.PullsCreateReview.Input.Body? = nil
    ) async throws -> Operations.PullsCreateReview.Output {
        try await pullsCreateReview(Operations.PullsCreateReview.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a review for a pull request
    ///
    /// Retrieves a pull request review by its ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/get(pulls/get-review)`.
    public func pullsGetReview(
        path: Operations.PullsGetReview.Input.Path,
        headers: Operations.PullsGetReview.Input.Headers = .init()
    ) async throws -> Operations.PullsGetReview.Output {
        try await pullsGetReview(Operations.PullsGetReview.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a review for a pull request
    ///
    /// Updates the contents of a specified review summary comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/put(pulls/update-review)`.
    public func pullsUpdateReview(
        path: Operations.PullsUpdateReview.Input.Path,
        headers: Operations.PullsUpdateReview.Input.Headers = .init(),
        body: Operations.PullsUpdateReview.Input.Body
    ) async throws -> Operations.PullsUpdateReview.Output {
        try await pullsUpdateReview(Operations.PullsUpdateReview.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a pending review for a pull request
    ///
    /// Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)`.
    public func pullsDeletePendingReview(
        path: Operations.PullsDeletePendingReview.Input.Path,
        headers: Operations.PullsDeletePendingReview.Input.Headers = .init()
    ) async throws -> Operations.PullsDeletePendingReview.Output {
        try await pullsDeletePendingReview(Operations.PullsDeletePendingReview.Input(
            path: path,
            headers: headers
        ))
    }
    /// List comments for a pull request review
    ///
    /// Lists comments for a specific pull request review.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/get(pulls/list-comments-for-review)`.
    public func pullsListCommentsForReview(
        path: Operations.PullsListCommentsForReview.Input.Path,
        query: Operations.PullsListCommentsForReview.Input.Query = .init(),
        headers: Operations.PullsListCommentsForReview.Input.Headers = .init()
    ) async throws -> Operations.PullsListCommentsForReview.Output {
        try await pullsListCommentsForReview(Operations.PullsListCommentsForReview.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Dismiss a review for a pull request
    ///
    /// Dismisses a specified review on a pull request.
    ///
    /// > [!NOTE]
    /// > To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/branches/branch-protection), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)`.
    public func pullsDismissReview(
        path: Operations.PullsDismissReview.Input.Path,
        headers: Operations.PullsDismissReview.Input.Headers = .init(),
        body: Operations.PullsDismissReview.Input.Body
    ) async throws -> Operations.PullsDismissReview.Output {
        try await pullsDismissReview(Operations.PullsDismissReview.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Submit a review for a pull request
    ///
    /// Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)`.
    public func pullsSubmitReview(
        path: Operations.PullsSubmitReview.Input.Path,
        headers: Operations.PullsSubmitReview.Input.Headers = .init(),
        body: Operations.PullsSubmitReview.Input.Body
    ) async throws -> Operations.PullsSubmitReview.Output {
        try await pullsSubmitReview(Operations.PullsSubmitReview.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update a pull request branch
    ///
    /// Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
    /// Note: If making a request on behalf of a GitHub App you must also have permissions to write the contents of the head repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/update-branch`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)`.
    public func pullsUpdateBranch(
        path: Operations.PullsUpdateBranch.Input.Path,
        headers: Operations.PullsUpdateBranch.Input.Headers = .init(),
        body: Operations.PullsUpdateBranch.Input.Body? = nil
    ) async throws -> Operations.PullsUpdateBranch.Output {
        try await pullsUpdateBranch(Operations.PullsUpdateBranch.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-milestone`.
        public struct NullableMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            public var state: Components.Schemas.NullableMilestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `NullableMilestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.NullableMilestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            public var _type: Components.Schemas.NullableTeamSimple._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil,
                _type: Components.Schemas.NullableTeamSimple._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            public var _type: Components.Schemas.Team._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                _type: Components.Schemas.Team._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
                case parent
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team-simple`.
        public struct TeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/type`.
            public var _type: Components.Schemas.TeamSimple._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team-simple/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// Creates a new `TeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil,
                _type: Components.Schemas.TeamSimple._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
            }
        }
        /// Hypermedia Link
        ///
        /// - Remark: Generated from `#/components/schemas/link`.
        public struct Link: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/link/href`.
            public var href: Swift.String
            /// Creates a new `Link`.
            ///
            /// - Parameters:
            ///   - href:
            public init(href: Swift.String) {
                self.href = href
            }
            public enum CodingKeys: String, CodingKey {
                case href
            }
        }
        /// The status of auto merging a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/auto-merge`.
        public struct AutoMerge: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/auto-merge/enabled_by`.
            public var enabledBy: Components.Schemas.SimpleUser
            /// The merge method to use.
            ///
            /// - Remark: Generated from `#/components/schemas/auto-merge/merge_method`.
            @frozen public enum MergeMethodPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case merge = "merge"
                case squash = "squash"
                case rebase = "rebase"
            }
            /// The merge method to use.
            ///
            /// - Remark: Generated from `#/components/schemas/auto-merge/merge_method`.
            public var mergeMethod: Components.Schemas.AutoMerge.MergeMethodPayload
            /// Title for the merge commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/auto-merge/commit_title`.
            public var commitTitle: Swift.String
            /// Commit message for the merge commit.
            ///
            /// - Remark: Generated from `#/components/schemas/auto-merge/commit_message`.
            public var commitMessage: Swift.String
            /// Creates a new `AutoMerge`.
            ///
            /// - Parameters:
            ///   - enabledBy:
            ///   - mergeMethod: The merge method to use.
            ///   - commitTitle: Title for the merge commit message.
            ///   - commitMessage: Commit message for the merge commit.
            public init(
                enabledBy: Components.Schemas.SimpleUser,
                mergeMethod: Components.Schemas.AutoMerge.MergeMethodPayload,
                commitTitle: Swift.String,
                commitMessage: Swift.String
            ) {
                self.enabledBy = enabledBy
                self.mergeMethod = mergeMethod
                self.commitTitle = commitTitle
                self.commitMessage = commitMessage
            }
            public enum CodingKeys: String, CodingKey {
                case enabledBy = "enabled_by"
                case mergeMethod = "merge_method"
                case commitTitle = "commit_title"
                case commitMessage = "commit_message"
            }
        }
        /// Pull Request Simple
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-simple`.
        public struct PullRequestSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/diff_url`.
            public var diffUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/patch_url`.
            public var patchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/issue_url`.
            public var issueUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/review_comments_url`.
            public var reviewCommentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/review_comment_url`.
            public var reviewCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/locked`.
            public var locked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload`.
            public struct LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/id`.
                public var id: Swift.Int64
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/node_id`.
                public var nodeId: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/description`.
                public var description: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/color`.
                public var color: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/LabelsPayload/default`.
                public var _default: Swift.Bool
                /// Creates a new `LabelsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - nodeId:
                ///   - url:
                ///   - name:
                ///   - description:
                ///   - color:
                ///   - _default:
                public init(
                    id: Swift.Int64,
                    nodeId: Swift.String,
                    url: Swift.String,
                    name: Swift.String,
                    description: Swift.String,
                    color: Swift.String,
                    _default: Swift.Bool
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.url = url
                    self.name = name
                    self.description = description
                    self.color = color
                    self._default = _default
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case url
                    case name
                    case description
                    case color
                    case _default = "default"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/labels`.
            public typealias LabelsPayload = [Components.Schemas.PullRequestSimple.LabelsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/labels`.
            public var labels: Components.Schemas.PullRequestSimple.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/merged_at`.
            public var mergedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/merge_commit_sha`.
            public var mergeCommitSha: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/requested_reviewers`.
            public var requestedReviewers: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/requested_teams`.
            public var requestedTeams: [Components.Schemas.Team]?
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/head`.
            public struct HeadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/head/label`.
                public var label: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/head/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/head/repo`.
                public var repo: Components.Schemas.Repository
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/head/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/head/user`.
                public var user: Components.Schemas.NullableSimpleUser?
                /// Creates a new `HeadPayload`.
                ///
                /// - Parameters:
                ///   - label:
                ///   - ref:
                ///   - repo:
                ///   - sha:
                ///   - user:
                public init(
                    label: Swift.String,
                    ref: Swift.String,
                    repo: Components.Schemas.Repository,
                    sha: Swift.String,
                    user: Components.Schemas.NullableSimpleUser? = nil
                ) {
                    self.label = label
                    self.ref = ref
                    self.repo = repo
                    self.sha = sha
                    self.user = user
                }
                public enum CodingKeys: String, CodingKey {
                    case label
                    case ref
                    case repo
                    case sha
                    case user
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/head`.
            public var head: Components.Schemas.PullRequestSimple.HeadPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/base`.
            public struct BasePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/base/label`.
                public var label: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/base/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/base/repo`.
                public var repo: Components.Schemas.Repository
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/base/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/base/user`.
                public var user: Components.Schemas.NullableSimpleUser?
                /// Creates a new `BasePayload`.
                ///
                /// - Parameters:
                ///   - label:
                ///   - ref:
                ///   - repo:
                ///   - sha:
                ///   - user:
                public init(
                    label: Swift.String,
                    ref: Swift.String,
                    repo: Components.Schemas.Repository,
                    sha: Swift.String,
                    user: Components.Schemas.NullableSimpleUser? = nil
                ) {
                    self.label = label
                    self.ref = ref
                    self.repo = repo
                    self.sha = sha
                    self.user = user
                }
                public enum CodingKeys: String, CodingKey {
                    case label
                    case ref
                    case repo
                    case sha
                    case user
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/base`.
            public var base: Components.Schemas.PullRequestSimple.BasePayload
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/comments`.
                public var comments: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/commits`.
                public var commits: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/statuses`.
                public var statuses: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/html`.
                public var html: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/issue`.
                public var issue: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/review_comments`.
                public var reviewComments: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/review_comment`.
                public var reviewComment: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links/self`.
                public var _self: Components.Schemas.Link
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - comments:
                ///   - commits:
                ///   - statuses:
                ///   - html:
                ///   - issue:
                ///   - reviewComments:
                ///   - reviewComment:
                ///   - _self:
                public init(
                    comments: Components.Schemas.Link,
                    commits: Components.Schemas.Link,
                    statuses: Components.Schemas.Link,
                    html: Components.Schemas.Link,
                    issue: Components.Schemas.Link,
                    reviewComments: Components.Schemas.Link,
                    reviewComment: Components.Schemas.Link,
                    _self: Components.Schemas.Link
                ) {
                    self.comments = comments
                    self.commits = commits
                    self.statuses = statuses
                    self.html = html
                    self.issue = issue
                    self.reviewComments = reviewComments
                    self.reviewComment = reviewComment
                    self._self = _self
                }
                public enum CodingKeys: String, CodingKey {
                    case comments
                    case commits
                    case statuses
                    case html
                    case issue
                    case reviewComments = "review_comments"
                    case reviewComment = "review_comment"
                    case _self = "self"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/_links`.
            public var _links: Components.Schemas.PullRequestSimple._LinksPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/auto_merge`.
            public var autoMerge: Components.Schemas.AutoMerge?
            /// Indicates whether or not the pull request is a draft.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-simple/draft`.
            public var draft: Swift.Bool?
            /// Creates a new `PullRequestSimple`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - diffUrl:
            ///   - patchUrl:
            ///   - issueUrl:
            ///   - commitsUrl:
            ///   - reviewCommentsUrl:
            ///   - reviewCommentUrl:
            ///   - commentsUrl:
            ///   - statusesUrl:
            ///   - number:
            ///   - state:
            ///   - locked:
            ///   - title:
            ///   - user:
            ///   - body:
            ///   - labels:
            ///   - milestone:
            ///   - activeLockReason:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - mergedAt:
            ///   - mergeCommitSha:
            ///   - assignee:
            ///   - assignees:
            ///   - requestedReviewers:
            ///   - requestedTeams:
            ///   - head:
            ///   - base:
            ///   - _links:
            ///   - authorAssociation:
            ///   - autoMerge:
            ///   - draft: Indicates whether or not the pull request is a draft.
            public init(
                url: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                diffUrl: Swift.String,
                patchUrl: Swift.String,
                issueUrl: Swift.String,
                commitsUrl: Swift.String,
                reviewCommentsUrl: Swift.String,
                reviewCommentUrl: Swift.String,
                commentsUrl: Swift.String,
                statusesUrl: Swift.String,
                number: Swift.Int,
                state: Swift.String,
                locked: Swift.Bool,
                title: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                body: Swift.String? = nil,
                labels: Components.Schemas.PullRequestSimple.LabelsPayload,
                milestone: Components.Schemas.NullableMilestone? = nil,
                activeLockReason: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                mergedAt: Foundation.Date? = nil,
                mergeCommitSha: Swift.String? = nil,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                requestedReviewers: [Components.Schemas.SimpleUser]? = nil,
                requestedTeams: [Components.Schemas.Team]? = nil,
                head: Components.Schemas.PullRequestSimple.HeadPayload,
                base: Components.Schemas.PullRequestSimple.BasePayload,
                _links: Components.Schemas.PullRequestSimple._LinksPayload,
                authorAssociation: Components.Schemas.AuthorAssociation,
                autoMerge: Components.Schemas.AutoMerge? = nil,
                draft: Swift.Bool? = nil
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.diffUrl = diffUrl
                self.patchUrl = patchUrl
                self.issueUrl = issueUrl
                self.commitsUrl = commitsUrl
                self.reviewCommentsUrl = reviewCommentsUrl
                self.reviewCommentUrl = reviewCommentUrl
                self.commentsUrl = commentsUrl
                self.statusesUrl = statusesUrl
                self.number = number
                self.state = state
                self.locked = locked
                self.title = title
                self.user = user
                self.body = body
                self.labels = labels
                self.milestone = milestone
                self.activeLockReason = activeLockReason
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.mergedAt = mergedAt
                self.mergeCommitSha = mergeCommitSha
                self.assignee = assignee
                self.assignees = assignees
                self.requestedReviewers = requestedReviewers
                self.requestedTeams = requestedTeams
                self.head = head
                self.base = base
                self._links = _links
                self.authorAssociation = authorAssociation
                self.autoMerge = autoMerge
                self.draft = draft
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case diffUrl = "diff_url"
                case patchUrl = "patch_url"
                case issueUrl = "issue_url"
                case commitsUrl = "commits_url"
                case reviewCommentsUrl = "review_comments_url"
                case reviewCommentUrl = "review_comment_url"
                case commentsUrl = "comments_url"
                case statusesUrl = "statuses_url"
                case number
                case state
                case locked
                case title
                case user
                case body
                case labels
                case milestone
                case activeLockReason = "active_lock_reason"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case mergedAt = "merged_at"
                case mergeCommitSha = "merge_commit_sha"
                case assignee
                case assignees
                case requestedReviewers = "requested_reviewers"
                case requestedTeams = "requested_teams"
                case head
                case base
                case _links
                case authorAssociation = "author_association"
                case autoMerge = "auto_merge"
                case draft
            }
        }
        /// Metaproperties for Git author/committer information.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-git-user`.
        public struct NullableGitUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/date`.
            public var date: Swift.String?
            /// Creates a new `NullableGitUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - date:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                date: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.date = date
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case date
            }
        }
        /// - Remark: Generated from `#/components/schemas/verification`.
        public struct Verification: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/verification/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/verification/reason`.
            public var reason: Swift.String
            /// - Remark: Generated from `#/components/schemas/verification/payload`.
            public var payload: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/signature`.
            public var signature: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/verified_at`.
            public var verifiedAt: Swift.String?
            /// Creates a new `Verification`.
            ///
            /// - Parameters:
            ///   - verified:
            ///   - reason:
            ///   - payload:
            ///   - signature:
            ///   - verifiedAt:
            public init(
                verified: Swift.Bool,
                reason: Swift.String,
                payload: Swift.String? = nil,
                signature: Swift.String? = nil,
                verifiedAt: Swift.String? = nil
            ) {
                self.verified = verified
                self.reason = reason
                self.payload = payload
                self.signature = signature
                self.verifiedAt = verifiedAt
            }
            public enum CodingKeys: String, CodingKey {
                case verified
                case reason
                case payload
                case signature
                case verifiedAt = "verified_at"
            }
        }
        /// Diff Entry
        ///
        /// - Remark: Generated from `#/components/schemas/diff-entry`.
        public struct DiffEntry: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/diff-entry/sha`.
            public var sha: Swift.String?
            /// - Remark: Generated from `#/components/schemas/diff-entry/filename`.
            public var filename: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case added = "added"
                case removed = "removed"
                case modified = "modified"
                case renamed = "renamed"
                case copied = "copied"
                case changed = "changed"
                case unchanged = "unchanged"
            }
            /// - Remark: Generated from `#/components/schemas/diff-entry/status`.
            public var status: Components.Schemas.DiffEntry.StatusPayload
            /// - Remark: Generated from `#/components/schemas/diff-entry/additions`.
            public var additions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/deletions`.
            public var deletions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/changes`.
            public var changes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/blob_url`.
            public var blobUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/raw_url`.
            public var rawUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/patch`.
            public var patch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/diff-entry/previous_filename`.
            public var previousFilename: Swift.String?
            /// Creates a new `DiffEntry`.
            ///
            /// - Parameters:
            ///   - sha:
            ///   - filename:
            ///   - status:
            ///   - additions:
            ///   - deletions:
            ///   - changes:
            ///   - blobUrl:
            ///   - rawUrl:
            ///   - contentsUrl:
            ///   - patch:
            ///   - previousFilename:
            public init(
                sha: Swift.String? = nil,
                filename: Swift.String,
                status: Components.Schemas.DiffEntry.StatusPayload,
                additions: Swift.Int,
                deletions: Swift.Int,
                changes: Swift.Int,
                blobUrl: Swift.String,
                rawUrl: Swift.String,
                contentsUrl: Swift.String,
                patch: Swift.String? = nil,
                previousFilename: Swift.String? = nil
            ) {
                self.sha = sha
                self.filename = filename
                self.status = status
                self.additions = additions
                self.deletions = deletions
                self.changes = changes
                self.blobUrl = blobUrl
                self.rawUrl = rawUrl
                self.contentsUrl = contentsUrl
                self.patch = patch
                self.previousFilename = previousFilename
            }
            public enum CodingKeys: String, CodingKey {
                case sha
                case filename
                case status
                case additions
                case deletions
                case changes
                case blobUrl = "blob_url"
                case rawUrl = "raw_url"
                case contentsUrl = "contents_url"
                case patch
                case previousFilename = "previous_filename"
            }
        }
        /// Commit
        ///
        /// - Remark: Generated from `#/components/schemas/commit`.
        public struct Commit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/commit/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/commit`.
            public struct CommitPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/commit/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/commit/author`.
                public var author: Components.Schemas.NullableGitUser?
                /// - Remark: Generated from `#/components/schemas/commit/commit/committer`.
                public var committer: Components.Schemas.NullableGitUser?
                /// - Remark: Generated from `#/components/schemas/commit/commit/message`.
                public var message: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/commit/comment_count`.
                public var commentCount: Swift.Int
                /// - Remark: Generated from `#/components/schemas/commit/commit/tree`.
                public struct TreePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/commit/commit/tree/sha`.
                    public var sha: Swift.String
                    /// - Remark: Generated from `#/components/schemas/commit/commit/tree/url`.
                    public var url: Swift.String
                    /// Creates a new `TreePayload`.
                    ///
                    /// - Parameters:
                    ///   - sha:
                    ///   - url:
                    public init(
                        sha: Swift.String,
                        url: Swift.String
                    ) {
                        self.sha = sha
                        self.url = url
                    }
                    public enum CodingKeys: String, CodingKey {
                        case sha
                        case url
                    }
                }
                /// - Remark: Generated from `#/components/schemas/commit/commit/tree`.
                public var tree: Components.Schemas.Commit.CommitPayload.TreePayload
                /// - Remark: Generated from `#/components/schemas/commit/commit/verification`.
                public var verification: Components.Schemas.Verification?
                /// Creates a new `CommitPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - author:
                ///   - committer:
                ///   - message:
                ///   - commentCount:
                ///   - tree:
                ///   - verification:
                public init(
                    url: Swift.String,
                    author: Components.Schemas.NullableGitUser? = nil,
                    committer: Components.Schemas.NullableGitUser? = nil,
                    message: Swift.String,
                    commentCount: Swift.Int,
                    tree: Components.Schemas.Commit.CommitPayload.TreePayload,
                    verification: Components.Schemas.Verification? = nil
                ) {
                    self.url = url
                    self.author = author
                    self.committer = committer
                    self.message = message
                    self.commentCount = commentCount
                    self.tree = tree
                    self.verification = verification
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case author
                    case committer
                    case message
                    case commentCount = "comment_count"
                    case tree
                    case verification
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/commit`.
            public var commit: Components.Schemas.Commit.CommitPayload
            /// - Remark: Generated from `#/components/schemas/commit/author`.
            @frozen public enum AuthorPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/author/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/commit/author/case2`.
                case EmptyObject(Components.Schemas.EmptyObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .EmptyObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .EmptyObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/author`.
            public var author: Components.Schemas.Commit.AuthorPayload?
            /// - Remark: Generated from `#/components/schemas/commit/committer`.
            @frozen public enum CommitterPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/committer/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/commit/committer/case2`.
                case EmptyObject(Components.Schemas.EmptyObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .EmptyObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .EmptyObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/committer`.
            public var committer: Components.Schemas.Commit.CommitterPayload?
            /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload`.
            public struct ParentsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// Creates a new `ParentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - sha:
                ///   - url:
                ///   - htmlUrl:
                public init(
                    sha: Swift.String,
                    url: Swift.String,
                    htmlUrl: Swift.String? = nil
                ) {
                    self.sha = sha
                    self.url = url
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                    case htmlUrl = "html_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/parents`.
            public typealias ParentsPayload = [Components.Schemas.Commit.ParentsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/commit/parents`.
            public var parents: Components.Schemas.Commit.ParentsPayload
            /// - Remark: Generated from `#/components/schemas/commit/stats`.
            public struct StatsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/stats/additions`.
                public var additions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/commit/stats/deletions`.
                public var deletions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/commit/stats/total`.
                public var total: Swift.Int?
                /// Creates a new `StatsPayload`.
                ///
                /// - Parameters:
                ///   - additions:
                ///   - deletions:
                ///   - total:
                public init(
                    additions: Swift.Int? = nil,
                    deletions: Swift.Int? = nil,
                    total: Swift.Int? = nil
                ) {
                    self.additions = additions
                    self.deletions = deletions
                    self.total = total
                }
                public enum CodingKeys: String, CodingKey {
                    case additions
                    case deletions
                    case total
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/stats`.
            public var stats: Components.Schemas.Commit.StatsPayload?
            /// - Remark: Generated from `#/components/schemas/commit/files`.
            public var files: [Components.Schemas.DiffEntry]?
            /// Creates a new `Commit`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - sha:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - commentsUrl:
            ///   - commit:
            ///   - author:
            ///   - committer:
            ///   - parents:
            ///   - stats:
            ///   - files:
            public init(
                url: Swift.String,
                sha: Swift.String,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                commentsUrl: Swift.String,
                commit: Components.Schemas.Commit.CommitPayload,
                author: Components.Schemas.Commit.AuthorPayload? = nil,
                committer: Components.Schemas.Commit.CommitterPayload? = nil,
                parents: Components.Schemas.Commit.ParentsPayload,
                stats: Components.Schemas.Commit.StatsPayload? = nil,
                files: [Components.Schemas.DiffEntry]? = nil
            ) {
                self.url = url
                self.sha = sha
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.commentsUrl = commentsUrl
                self.commit = commit
                self.author = author
                self.committer = committer
                self.parents = parents
                self.stats = stats
                self.files = files
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case sha
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case commentsUrl = "comments_url"
                case commit
                case author
                case committer
                case parents
                case stats
                case files
            }
        }
        /// Pull Request Review Comments are comments on a portion of the Pull Request's diff.
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-review-comment`.
        public struct PullRequestReviewComment: Codable, Hashable, Sendable {
            /// URL for the pull request review comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/url`.
            public var url: Swift.String
            /// The ID of the pull request review to which the comment belongs.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/pull_request_review_id`.
            public var pullRequestReviewId: Swift.Int64?
            /// The ID of the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/id`.
            public var id: Swift.Int64
            /// The node ID of the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/node_id`.
            public var nodeId: Swift.String
            /// The diff of the line that the comment refers to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/diff_hunk`.
            public var diffHunk: Swift.String
            /// The relative path of the file to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/path`.
            public var path: Swift.String
            /// The line index in the diff to which the comment applies. This field is closing down; use `line` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/position`.
            public var position: Swift.Int?
            /// The index of the original line in the diff to which the comment applies. This field is closing down; use `original_line` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_position`.
            public var originalPosition: Swift.Int?
            /// The SHA of the commit to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/commit_id`.
            public var commitId: Swift.String
            /// The SHA of the original commit to which the comment applies.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_commit_id`.
            public var originalCommitId: Swift.String
            /// The comment ID to reply to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/in_reply_to_id`.
            public var inReplyToId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/user`.
            public var user: Components.Schemas.SimpleUser
            /// The text of the comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// HTML URL for the pull request review comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/html_url`.
            public var htmlUrl: Swift.String
            /// URL for the pull request that the review comment belongs to.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/pull_request_url`.
            public var pullRequestUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self`.
                public struct _SelfPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self/href`.
                    public var href: Swift.String
                    /// Creates a new `_SelfPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/self`.
                public var _self: Components.Schemas.PullRequestReviewComment._LinksPayload._SelfPayload
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html`.
                public struct HtmlPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html/href`.
                    public var href: Swift.String
                    /// Creates a new `HtmlPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/html`.
                public var html: Components.Schemas.PullRequestReviewComment._LinksPayload.HtmlPayload
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request`.
                public struct PullRequestPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request/href`.
                    public var href: Swift.String
                    /// Creates a new `PullRequestPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links/pull_request`.
                public var pullRequest: Components.Schemas.PullRequestReviewComment._LinksPayload.PullRequestPayload
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - _self:
                ///   - html:
                ///   - pullRequest:
                public init(
                    _self: Components.Schemas.PullRequestReviewComment._LinksPayload._SelfPayload,
                    html: Components.Schemas.PullRequestReviewComment._LinksPayload.HtmlPayload,
                    pullRequest: Components.Schemas.PullRequestReviewComment._LinksPayload.PullRequestPayload
                ) {
                    self._self = _self
                    self.html = html
                    self.pullRequest = pullRequest
                }
                public enum CodingKeys: String, CodingKey {
                    case _self = "self"
                    case html
                    case pullRequest = "pull_request"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/_links`.
            public var _links: Components.Schemas.PullRequestReviewComment._LinksPayload
            /// The first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_line`.
            public var startLine: Swift.Int?
            /// The first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_start_line`.
            public var originalStartLine: Swift.Int?
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_side`.
            @frozen public enum StartSidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/start_side`.
            public var startSide: Components.Schemas.PullRequestReviewComment.StartSidePayload?
            /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/line`.
            public var line: Swift.Int?
            /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/original_line`.
            public var originalLine: Swift.Int?
            /// The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/side`.
            @frozen public enum SidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/side`.
            public var side: Components.Schemas.PullRequestReviewComment.SidePayload?
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/subject_type`.
            @frozen public enum SubjectTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case line = "line"
                case file = "file"
            }
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/subject_type`.
            public var subjectType: Components.Schemas.PullRequestReviewComment.SubjectTypePayload?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-review-comment/body_text`.
            public var bodyText: Swift.String?
            /// Creates a new `PullRequestReviewComment`.
            ///
            /// - Parameters:
            ///   - url: URL for the pull request review comment
            ///   - pullRequestReviewId: The ID of the pull request review to which the comment belongs.
            ///   - id: The ID of the pull request review comment.
            ///   - nodeId: The node ID of the pull request review comment.
            ///   - diffHunk: The diff of the line that the comment refers to.
            ///   - path: The relative path of the file to which the comment applies.
            ///   - position: The line index in the diff to which the comment applies. This field is closing down; use `line` instead.
            ///   - originalPosition: The index of the original line in the diff to which the comment applies. This field is closing down; use `original_line` instead.
            ///   - commitId: The SHA of the commit to which the comment applies.
            ///   - originalCommitId: The SHA of the original commit to which the comment applies.
            ///   - inReplyToId: The comment ID to reply to.
            ///   - user:
            ///   - body: The text of the comment.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - htmlUrl: HTML URL for the pull request review comment.
            ///   - pullRequestUrl: URL for the pull request that the review comment belongs to.
            ///   - authorAssociation:
            ///   - _links:
            ///   - startLine: The first line of the range for a multi-line comment.
            ///   - originalStartLine: The first line of the range for a multi-line comment.
            ///   - startSide: The side of the first line of the range for a multi-line comment.
            ///   - line: The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - originalLine: The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - side: The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
            ///   - subjectType: The level at which the comment is targeted, can be a diff line or a file.
            ///   - reactions:
            ///   - bodyHtml:
            ///   - bodyText:
            public init(
                url: Swift.String,
                pullRequestReviewId: Swift.Int64? = nil,
                id: Swift.Int64,
                nodeId: Swift.String,
                diffHunk: Swift.String,
                path: Swift.String,
                position: Swift.Int? = nil,
                originalPosition: Swift.Int? = nil,
                commitId: Swift.String,
                originalCommitId: Swift.String,
                inReplyToId: Swift.Int? = nil,
                user: Components.Schemas.SimpleUser,
                body: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                htmlUrl: Swift.String,
                pullRequestUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                _links: Components.Schemas.PullRequestReviewComment._LinksPayload,
                startLine: Swift.Int? = nil,
                originalStartLine: Swift.Int? = nil,
                startSide: Components.Schemas.PullRequestReviewComment.StartSidePayload? = nil,
                line: Swift.Int? = nil,
                originalLine: Swift.Int? = nil,
                side: Components.Schemas.PullRequestReviewComment.SidePayload? = nil,
                subjectType: Components.Schemas.PullRequestReviewComment.SubjectTypePayload? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil
            ) {
                self.url = url
                self.pullRequestReviewId = pullRequestReviewId
                self.id = id
                self.nodeId = nodeId
                self.diffHunk = diffHunk
                self.path = path
                self.position = position
                self.originalPosition = originalPosition
                self.commitId = commitId
                self.originalCommitId = originalCommitId
                self.inReplyToId = inReplyToId
                self.user = user
                self.body = body
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.htmlUrl = htmlUrl
                self.pullRequestUrl = pullRequestUrl
                self.authorAssociation = authorAssociation
                self._links = _links
                self.startLine = startLine
                self.originalStartLine = originalStartLine
                self.startSide = startSide
                self.line = line
                self.originalLine = originalLine
                self.side = side
                self.subjectType = subjectType
                self.reactions = reactions
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case pullRequestReviewId = "pull_request_review_id"
                case id
                case nodeId = "node_id"
                case diffHunk = "diff_hunk"
                case path
                case position
                case originalPosition = "original_position"
                case commitId = "commit_id"
                case originalCommitId = "original_commit_id"
                case inReplyToId = "in_reply_to_id"
                case user
                case body
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case htmlUrl = "html_url"
                case pullRequestUrl = "pull_request_url"
                case authorAssociation = "author_association"
                case _links
                case startLine = "start_line"
                case originalStartLine = "original_start_line"
                case startSide = "start_side"
                case line
                case originalLine = "original_line"
                case side
                case subjectType = "subject_type"
                case reactions
                case bodyHtml = "body_html"
                case bodyText = "body_text"
            }
        }
        /// Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request`.
        public struct PullRequest: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/pull-request/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/diff_url`.
            public var diffUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/patch_url`.
            public var patchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/issue_url`.
            public var issueUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/review_comments_url`.
            public var reviewCommentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/review_comment_url`.
            public var reviewCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/statuses_url`.
            public var statusesUrl: Swift.String
            /// Number uniquely identifying the pull request within its repository.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/number`.
            public var number: Swift.Int
            /// State of this Pull Request. Either `open` or `closed`.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// State of this Pull Request. Either `open` or `closed`.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/state`.
            public var state: Components.Schemas.PullRequest.StatePayload
            /// - Remark: Generated from `#/components/schemas/pull-request/locked`.
            public var locked: Swift.Bool
            /// The title of the pull request.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/user`.
            public var user: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/pull-request/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload`.
            public struct LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/id`.
                public var id: Swift.Int64
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/node_id`.
                public var nodeId: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/description`.
                public var description: Swift.String?
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/color`.
                public var color: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/LabelsPayload/default`.
                public var _default: Swift.Bool
                /// Creates a new `LabelsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - nodeId:
                ///   - url:
                ///   - name:
                ///   - description:
                ///   - color:
                ///   - _default:
                public init(
                    id: Swift.Int64,
                    nodeId: Swift.String,
                    url: Swift.String,
                    name: Swift.String,
                    description: Swift.String? = nil,
                    color: Swift.String,
                    _default: Swift.Bool
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.url = url
                    self.name = name
                    self.description = description
                    self.color = color
                    self._default = _default
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case url
                    case name
                    case description
                    case color
                    case _default = "default"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request/labels`.
            public typealias LabelsPayload = [Components.Schemas.PullRequest.LabelsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/pull-request/labels`.
            public var labels: Components.Schemas.PullRequest.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/pull-request/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/pull-request/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/pull-request/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/pull-request/merged_at`.
            public var mergedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/pull-request/merge_commit_sha`.
            public var mergeCommitSha: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/pull-request/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/pull-request/requested_reviewers`.
            public var requestedReviewers: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/pull-request/requested_teams`.
            public var requestedTeams: [Components.Schemas.TeamSimple]?
            /// - Remark: Generated from `#/components/schemas/pull-request/head`.
            public struct HeadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request/head/label`.
                public var label: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/head/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/head/repo`.
                public var repo: Components.Schemas.Repository
                /// - Remark: Generated from `#/components/schemas/pull-request/head/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/head/user`.
                public var user: Components.Schemas.SimpleUser
                /// Creates a new `HeadPayload`.
                ///
                /// - Parameters:
                ///   - label:
                ///   - ref:
                ///   - repo:
                ///   - sha:
                ///   - user:
                public init(
                    label: Swift.String,
                    ref: Swift.String,
                    repo: Components.Schemas.Repository,
                    sha: Swift.String,
                    user: Components.Schemas.SimpleUser
                ) {
                    self.label = label
                    self.ref = ref
                    self.repo = repo
                    self.sha = sha
                    self.user = user
                }
                public enum CodingKeys: String, CodingKey {
                    case label
                    case ref
                    case repo
                    case sha
                    case user
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request/head`.
            public var head: Components.Schemas.PullRequest.HeadPayload
            /// - Remark: Generated from `#/components/schemas/pull-request/base`.
            public struct BasePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request/base/label`.
                public var label: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/base/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/base/repo`.
                public var repo: Components.Schemas.Repository
                /// - Remark: Generated from `#/components/schemas/pull-request/base/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request/base/user`.
                public var user: Components.Schemas.SimpleUser
                /// Creates a new `BasePayload`.
                ///
                /// - Parameters:
                ///   - label:
                ///   - ref:
                ///   - repo:
                ///   - sha:
                ///   - user:
                public init(
                    label: Swift.String,
                    ref: Swift.String,
                    repo: Components.Schemas.Repository,
                    sha: Swift.String,
                    user: Components.Schemas.SimpleUser
                ) {
                    self.label = label
                    self.ref = ref
                    self.repo = repo
                    self.sha = sha
                    self.user = user
                }
                public enum CodingKeys: String, CodingKey {
                    case label
                    case ref
                    case repo
                    case sha
                    case user
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request/base`.
            public var base: Components.Schemas.PullRequest.BasePayload
            /// - Remark: Generated from `#/components/schemas/pull-request/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/comments`.
                public var comments: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/commits`.
                public var commits: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/statuses`.
                public var statuses: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/html`.
                public var html: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/issue`.
                public var issue: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/review_comments`.
                public var reviewComments: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/review_comment`.
                public var reviewComment: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/pull-request/_links/self`.
                public var _self: Components.Schemas.Link
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - comments:
                ///   - commits:
                ///   - statuses:
                ///   - html:
                ///   - issue:
                ///   - reviewComments:
                ///   - reviewComment:
                ///   - _self:
                public init(
                    comments: Components.Schemas.Link,
                    commits: Components.Schemas.Link,
                    statuses: Components.Schemas.Link,
                    html: Components.Schemas.Link,
                    issue: Components.Schemas.Link,
                    reviewComments: Components.Schemas.Link,
                    reviewComment: Components.Schemas.Link,
                    _self: Components.Schemas.Link
                ) {
                    self.comments = comments
                    self.commits = commits
                    self.statuses = statuses
                    self.html = html
                    self.issue = issue
                    self.reviewComments = reviewComments
                    self.reviewComment = reviewComment
                    self._self = _self
                }
                public enum CodingKeys: String, CodingKey {
                    case comments
                    case commits
                    case statuses
                    case html
                    case issue
                    case reviewComments = "review_comments"
                    case reviewComment = "review_comment"
                    case _self = "self"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request/_links`.
            public var _links: Components.Schemas.PullRequest._LinksPayload
            /// - Remark: Generated from `#/components/schemas/pull-request/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/pull-request/auto_merge`.
            public var autoMerge: Components.Schemas.AutoMerge?
            /// Indicates whether or not the pull request is a draft.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/draft`.
            public var draft: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/pull-request/merged`.
            public var merged: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/pull-request/mergeable`.
            public var mergeable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/pull-request/rebaseable`.
            public var rebaseable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/pull-request/mergeable_state`.
            public var mergeableState: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request/merged_by`.
            public var mergedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/pull-request/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request/review_comments`.
            public var reviewComments: Swift.Int
            /// Indicates whether maintainers can modify the pull request.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request/maintainer_can_modify`.
            public var maintainerCanModify: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/pull-request/commits`.
            public var commits: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request/additions`.
            public var additions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request/deletions`.
            public var deletions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request/changed_files`.
            public var changedFiles: Swift.Int
            /// Creates a new `PullRequest`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - diffUrl:
            ///   - patchUrl:
            ///   - issueUrl:
            ///   - commitsUrl:
            ///   - reviewCommentsUrl:
            ///   - reviewCommentUrl:
            ///   - commentsUrl:
            ///   - statusesUrl:
            ///   - number: Number uniquely identifying the pull request within its repository.
            ///   - state: State of this Pull Request. Either `open` or `closed`.
            ///   - locked:
            ///   - title: The title of the pull request.
            ///   - user:
            ///   - body:
            ///   - labels:
            ///   - milestone:
            ///   - activeLockReason:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - mergedAt:
            ///   - mergeCommitSha:
            ///   - assignee:
            ///   - assignees:
            ///   - requestedReviewers:
            ///   - requestedTeams:
            ///   - head:
            ///   - base:
            ///   - _links:
            ///   - authorAssociation:
            ///   - autoMerge:
            ///   - draft: Indicates whether or not the pull request is a draft.
            ///   - merged:
            ///   - mergeable:
            ///   - rebaseable:
            ///   - mergeableState:
            ///   - mergedBy:
            ///   - comments:
            ///   - reviewComments:
            ///   - maintainerCanModify: Indicates whether maintainers can modify the pull request.
            ///   - commits:
            ///   - additions:
            ///   - deletions:
            ///   - changedFiles:
            public init(
                url: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                diffUrl: Swift.String,
                patchUrl: Swift.String,
                issueUrl: Swift.String,
                commitsUrl: Swift.String,
                reviewCommentsUrl: Swift.String,
                reviewCommentUrl: Swift.String,
                commentsUrl: Swift.String,
                statusesUrl: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.PullRequest.StatePayload,
                locked: Swift.Bool,
                title: Swift.String,
                user: Components.Schemas.SimpleUser,
                body: Swift.String? = nil,
                labels: Components.Schemas.PullRequest.LabelsPayload,
                milestone: Components.Schemas.NullableMilestone? = nil,
                activeLockReason: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                mergedAt: Foundation.Date? = nil,
                mergeCommitSha: Swift.String? = nil,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                requestedReviewers: [Components.Schemas.SimpleUser]? = nil,
                requestedTeams: [Components.Schemas.TeamSimple]? = nil,
                head: Components.Schemas.PullRequest.HeadPayload,
                base: Components.Schemas.PullRequest.BasePayload,
                _links: Components.Schemas.PullRequest._LinksPayload,
                authorAssociation: Components.Schemas.AuthorAssociation,
                autoMerge: Components.Schemas.AutoMerge? = nil,
                draft: Swift.Bool? = nil,
                merged: Swift.Bool,
                mergeable: Swift.Bool? = nil,
                rebaseable: Swift.Bool? = nil,
                mergeableState: Swift.String,
                mergedBy: Components.Schemas.NullableSimpleUser? = nil,
                comments: Swift.Int,
                reviewComments: Swift.Int,
                maintainerCanModify: Swift.Bool,
                commits: Swift.Int,
                additions: Swift.Int,
                deletions: Swift.Int,
                changedFiles: Swift.Int
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.diffUrl = diffUrl
                self.patchUrl = patchUrl
                self.issueUrl = issueUrl
                self.commitsUrl = commitsUrl
                self.reviewCommentsUrl = reviewCommentsUrl
                self.reviewCommentUrl = reviewCommentUrl
                self.commentsUrl = commentsUrl
                self.statusesUrl = statusesUrl
                self.number = number
                self.state = state
                self.locked = locked
                self.title = title
                self.user = user
                self.body = body
                self.labels = labels
                self.milestone = milestone
                self.activeLockReason = activeLockReason
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.mergedAt = mergedAt
                self.mergeCommitSha = mergeCommitSha
                self.assignee = assignee
                self.assignees = assignees
                self.requestedReviewers = requestedReviewers
                self.requestedTeams = requestedTeams
                self.head = head
                self.base = base
                self._links = _links
                self.authorAssociation = authorAssociation
                self.autoMerge = autoMerge
                self.draft = draft
                self.merged = merged
                self.mergeable = mergeable
                self.rebaseable = rebaseable
                self.mergeableState = mergeableState
                self.mergedBy = mergedBy
                self.comments = comments
                self.reviewComments = reviewComments
                self.maintainerCanModify = maintainerCanModify
                self.commits = commits
                self.additions = additions
                self.deletions = deletions
                self.changedFiles = changedFiles
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case diffUrl = "diff_url"
                case patchUrl = "patch_url"
                case issueUrl = "issue_url"
                case commitsUrl = "commits_url"
                case reviewCommentsUrl = "review_comments_url"
                case reviewCommentUrl = "review_comment_url"
                case commentsUrl = "comments_url"
                case statusesUrl = "statuses_url"
                case number
                case state
                case locked
                case title
                case user
                case body
                case labels
                case milestone
                case activeLockReason = "active_lock_reason"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case mergedAt = "merged_at"
                case mergeCommitSha = "merge_commit_sha"
                case assignee
                case assignees
                case requestedReviewers = "requested_reviewers"
                case requestedTeams = "requested_teams"
                case head
                case base
                case _links
                case authorAssociation = "author_association"
                case autoMerge = "auto_merge"
                case draft
                case merged
                case mergeable
                case rebaseable
                case mergeableState = "mergeable_state"
                case mergedBy = "merged_by"
                case comments
                case reviewComments = "review_comments"
                case maintainerCanModify = "maintainer_can_modify"
                case commits
                case additions
                case deletions
                case changedFiles = "changed_files"
            }
        }
        /// Pull Request Merge Result
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-merge-result`.
        public struct PullRequestMergeResult: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request-merge-result/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-merge-result/merged`.
            public var merged: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/pull-request-merge-result/message`.
            public var message: Swift.String
            /// Creates a new `PullRequestMergeResult`.
            ///
            /// - Parameters:
            ///   - sha:
            ///   - merged:
            ///   - message:
            public init(
                sha: Swift.String,
                merged: Swift.Bool,
                message: Swift.String
            ) {
                self.sha = sha
                self.merged = merged
                self.message = message
            }
            public enum CodingKeys: String, CodingKey {
                case sha
                case merged
                case message
            }
        }
        /// Pull Request Review Request
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-review-request`.
        public struct PullRequestReviewRequest: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request-review-request/users`.
            public var users: [Components.Schemas.SimpleUser]
            /// - Remark: Generated from `#/components/schemas/pull-request-review-request/teams`.
            public var teams: [Components.Schemas.Team]
            /// Creates a new `PullRequestReviewRequest`.
            ///
            /// - Parameters:
            ///   - users:
            ///   - teams:
            public init(
                users: [Components.Schemas.SimpleUser],
                teams: [Components.Schemas.Team]
            ) {
                self.users = users
                self.teams = teams
            }
            public enum CodingKeys: String, CodingKey {
                case users
                case teams
            }
        }
        /// Pull Request Reviews are reviews on pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/pull-request-review`.
        public struct PullRequestReview: Codable, Hashable, Sendable {
            /// Unique identifier of the review
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/pull-request-review/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// The text of the review.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review/pull_request_url`.
            public var pullRequestUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-review/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/html`.
                public struct HtmlPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/html/href`.
                    public var href: Swift.String
                    /// Creates a new `HtmlPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/html`.
                public var html: Components.Schemas.PullRequestReview._LinksPayload.HtmlPayload
                /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/pull_request`.
                public struct PullRequestPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/pull_request/href`.
                    public var href: Swift.String
                    /// Creates a new `PullRequestPayload`.
                    ///
                    /// - Parameters:
                    ///   - href:
                    public init(href: Swift.String) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-review/_links/pull_request`.
                public var pullRequest: Components.Schemas.PullRequestReview._LinksPayload.PullRequestPayload
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - html:
                ///   - pullRequest:
                public init(
                    html: Components.Schemas.PullRequestReview._LinksPayload.HtmlPayload,
                    pullRequest: Components.Schemas.PullRequestReview._LinksPayload.PullRequestPayload
                ) {
                    self.html = html
                    self.pullRequest = pullRequest
                }
                public enum CodingKeys: String, CodingKey {
                    case html
                    case pullRequest = "pull_request"
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-review/_links`.
            public var _links: Components.Schemas.PullRequestReview._LinksPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-review/submitted_at`.
            public var submittedAt: Foundation.Date?
            /// A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.
            ///
            /// - Remark: Generated from `#/components/schemas/pull-request-review/commit_id`.
            public var commitId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-review/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-review/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/pull-request-review/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// Creates a new `PullRequestReview`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the review
            ///   - nodeId:
            ///   - user:
            ///   - body: The text of the review.
            ///   - state:
            ///   - htmlUrl:
            ///   - pullRequestUrl:
            ///   - _links:
            ///   - submittedAt:
            ///   - commitId: A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - authorAssociation:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                body: Swift.String,
                state: Swift.String,
                htmlUrl: Swift.String,
                pullRequestUrl: Swift.String,
                _links: Components.Schemas.PullRequestReview._LinksPayload,
                submittedAt: Foundation.Date? = nil,
                commitId: Swift.String? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation
            ) {
                self.id = id
                self.nodeId = nodeId
                self.user = user
                self.body = body
                self.state = state
                self.htmlUrl = htmlUrl
                self.pullRequestUrl = pullRequestUrl
                self._links = _links
                self.submittedAt = submittedAt
                self.commitId = commitId
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.authorAssociation = authorAssociation
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case user
                case body
                case state
                case htmlUrl = "html_url"
                case pullRequestUrl = "pull_request_url"
                case _links
                case submittedAt = "submitted_at"
                case commitId = "commit_id"
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case authorAssociation = "author_association"
            }
        }
        /// Legacy Review Comment
        ///
        /// - Remark: Generated from `#/components/schemas/review-comment`.
        public struct ReviewComment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/review-comment/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/pull_request_review_id`.
            public var pullRequestReviewId: Swift.Int64?
            /// - Remark: Generated from `#/components/schemas/review-comment/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/review-comment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/diff_hunk`.
            public var diffHunk: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/position`.
            public var position: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/review-comment/original_position`.
            public var originalPosition: Swift.Int
            /// - Remark: Generated from `#/components/schemas/review-comment/commit_id`.
            public var commitId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/original_commit_id`.
            public var originalCommitId: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/in_reply_to_id`.
            public var inReplyToId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/review-comment/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/review-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/review-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/review-comment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/pull_request_url`.
            public var pullRequestUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/review-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/review-comment/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/review-comment/_links/self`.
                public var _self: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/review-comment/_links/html`.
                public var html: Components.Schemas.Link
                /// - Remark: Generated from `#/components/schemas/review-comment/_links/pull_request`.
                public var pullRequest: Components.Schemas.Link
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - _self:
                ///   - html:
                ///   - pullRequest:
                public init(
                    _self: Components.Schemas.Link,
                    html: Components.Schemas.Link,
                    pullRequest: Components.Schemas.Link
                ) {
                    self._self = _self
                    self.html = html
                    self.pullRequest = pullRequest
                }
                public enum CodingKeys: String, CodingKey {
                    case _self = "self"
                    case html
                    case pullRequest = "pull_request"
                }
            }
            /// - Remark: Generated from `#/components/schemas/review-comment/_links`.
            public var _links: Components.Schemas.ReviewComment._LinksPayload
            /// - Remark: Generated from `#/components/schemas/review-comment/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-comment/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/review-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/side`.
            @frozen public enum SidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/side`.
            public var side: Components.Schemas.ReviewComment.SidePayload?
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/start_side`.
            @frozen public enum StartSidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case left = "LEFT"
                case right = "RIGHT"
            }
            /// The side of the first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/start_side`.
            public var startSide: Components.Schemas.ReviewComment.StartSidePayload?
            /// The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/line`.
            public var line: Swift.Int?
            /// The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/original_line`.
            public var originalLine: Swift.Int?
            /// The first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/start_line`.
            public var startLine: Swift.Int?
            /// The original first line of the range for a multi-line comment.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/original_start_line`.
            public var originalStartLine: Swift.Int?
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/subject_type`.
            @frozen public enum SubjectTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case line = "line"
                case file = "file"
            }
            /// The level at which the comment is targeted, can be a diff line or a file.
            ///
            /// - Remark: Generated from `#/components/schemas/review-comment/subject_type`.
            public var subjectType: Components.Schemas.ReviewComment.SubjectTypePayload?
            /// Creates a new `ReviewComment`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - pullRequestReviewId:
            ///   - id:
            ///   - nodeId:
            ///   - diffHunk:
            ///   - path:
            ///   - position:
            ///   - originalPosition:
            ///   - commitId:
            ///   - originalCommitId:
            ///   - inReplyToId:
            ///   - user:
            ///   - body:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - htmlUrl:
            ///   - pullRequestUrl:
            ///   - authorAssociation:
            ///   - _links:
            ///   - bodyText:
            ///   - bodyHtml:
            ///   - reactions:
            ///   - side: The side of the first line of the range for a multi-line comment.
            ///   - startSide: The side of the first line of the range for a multi-line comment.
            ///   - line: The line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - originalLine: The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
            ///   - startLine: The first line of the range for a multi-line comment.
            ///   - originalStartLine: The original first line of the range for a multi-line comment.
            ///   - subjectType: The level at which the comment is targeted, can be a diff line or a file.
            public init(
                url: Swift.String,
                pullRequestReviewId: Swift.Int64? = nil,
                id: Swift.Int64,
                nodeId: Swift.String,
                diffHunk: Swift.String,
                path: Swift.String,
                position: Swift.Int? = nil,
                originalPosition: Swift.Int,
                commitId: Swift.String,
                originalCommitId: Swift.String,
                inReplyToId: Swift.Int? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                body: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                htmlUrl: Swift.String,
                pullRequestUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                _links: Components.Schemas.ReviewComment._LinksPayload,
                bodyText: Swift.String? = nil,
                bodyHtml: Swift.String? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil,
                side: Components.Schemas.ReviewComment.SidePayload? = nil,
                startSide: Components.Schemas.ReviewComment.StartSidePayload? = nil,
                line: Swift.Int? = nil,
                originalLine: Swift.Int? = nil,
                startLine: Swift.Int? = nil,
                originalStartLine: Swift.Int? = nil,
                subjectType: Components.Schemas.ReviewComment.SubjectTypePayload? = nil
            ) {
                self.url = url
                self.pullRequestReviewId = pullRequestReviewId
                self.id = id
                self.nodeId = nodeId
                self.diffHunk = diffHunk
                self.path = path
                self.position = position
                self.originalPosition = originalPosition
                self.commitId = commitId
                self.originalCommitId = originalCommitId
                self.inReplyToId = inReplyToId
                self.user = user
                self.body = body
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.htmlUrl = htmlUrl
                self.pullRequestUrl = pullRequestUrl
                self.authorAssociation = authorAssociation
                self._links = _links
                self.bodyText = bodyText
                self.bodyHtml = bodyHtml
                self.reactions = reactions
                self.side = side
                self.startSide = startSide
                self.line = line
                self.originalLine = originalLine
                self.startLine = startLine
                self.originalStartLine = originalStartLine
                self.subjectType = subjectType
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case pullRequestReviewId = "pull_request_review_id"
                case id
                case nodeId = "node_id"
                case diffHunk = "diff_hunk"
                case path
                case position
                case originalPosition = "original_position"
                case commitId = "commit_id"
                case originalCommitId = "original_commit_id"
                case inReplyToId = "in_reply_to_id"
                case user
                case body
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case htmlUrl = "html_url"
                case pullRequestUrl = "pull_request_url"
                case authorAssociation = "author_association"
                case _links
                case bodyText = "body_text"
                case bodyHtml = "body_html"
                case reactions
                case side
                case startSide = "start_side"
                case line
                case originalLine = "original_line"
                case startLine = "start_line"
                case originalStartLine = "original_start_line"
                case subjectType = "subject_type"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/since`.
        public typealias Since = Foundation.Date
        /// The unique identifier of the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-id`.
        public typealias CommentId = Swift.Int64
        /// The property to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/sort`.
        @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
        }
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The number that identifies the pull request.
        ///
        /// - Remark: Generated from `#/components/parameters/pull-number`.
        public typealias PullNumber = Swift.Int
        /// The unique identifier of the review.
        ///
        /// - Remark: Generated from `#/components/parameters/review-id`.
        public typealias ReviewId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
        public struct Unacceptable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/unacceptable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/unacceptable/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Unacceptable.Body
            /// Creates a new `Unacceptable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Unacceptable.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List pull requests
    ///
    /// Lists pull requests in a specified repository.
    ///
    /// Draft pull requests are available in public repositories with GitHub
    /// Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
    /// plans, and in public and private repositories with GitHub Team and GitHub Enterprise
    /// Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)
    /// in the GitHub Help documentation.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)`.
    public enum PullsList {
        public static let id: Swift.String = "pulls/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.PullsList.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Either `open`, `closed`, or `all` to filter by state.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/state`.
                public var state: Operations.PullsList.Input.Query.StatePayload?
                /// Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/head`.
                public var head: Swift.String?
                /// Filter pulls by base branch name. Example: `gh-pages`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/base`.
                public var base: Swift.String?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case popularity = "popularity"
                    case longRunning = "long-running"
                }
                /// What to sort results by. `popularity` will sort by the number of comments. `long-running` will sort by date created and will limit the results to pull requests that have been open for more than a month and have had activity within the past month.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/sort`.
                public var sort: Operations.PullsList.Input.Query.SortPayload?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction of the sort. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/direction`.
                public var direction: Operations.PullsList.Input.Query.DirectionPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Either `open`, `closed`, or `all` to filter by state.
                ///   - head: Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
                ///   - base: Filter pulls by base branch name. Example: `gh-pages`.
                ///   - sort: What to sort results by. `popularity` will sort by the number of comments. `long-running` will sort by date created and will limit the results to pull requests that have been open for more than a month and have had activity within the past month.
                ///   - direction: The direction of the sort. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.PullsList.Input.Query.StatePayload? = nil,
                    head: Swift.String? = nil,
                    base: Swift.String? = nil,
                    sort: Operations.PullsList.Input.Query.SortPayload? = nil,
                    direction: Operations.PullsList.Input.Query.DirectionPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.head = head
                    self.base = base
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsList.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsList.Input.Path,
                query: Operations.PullsList.Input.Query = .init(),
                headers: Operations.PullsList.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PullRequestSimple])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PullRequestSimple] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsList.Output.Ok.Headers = .init(),
                    body: Operations.PullsList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/get(pulls/list)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)`.
    public enum PullsCreate {
        public static let id: Swift.String = "pulls/create"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.PullsCreate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsCreate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the new pull request. Required unless `issue` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/head`.
                    public var head: Swift.String
                    /// The name of the repository where the changes in the pull request were made. This field is required for cross-repository pull requests if both repositories are owned by the same organization.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/head_repo`.
                    public var headRepo: Swift.String?
                    /// The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/base`.
                    public var base: Swift.String
                    /// The contents of the pull request.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/maintainer_can_modify`.
                    public var maintainerCanModify: Swift.Bool?
                    /// Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://docs.github.com/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/draft`.
                    public var draft: Swift.Bool?
                    /// An issue in the repository to convert to a pull request. The issue title, body, and comments will become the title, body, and comments on the new pull request. Required unless `title` is specified.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/json/issue`.
                    public var issue: Swift.Int64?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the new pull request. Required unless `issue` is specified.
                    ///   - head: The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
                    ///   - headRepo: The name of the repository where the changes in the pull request were made. This field is required for cross-repository pull requests if both repositories are owned by the same organization.
                    ///   - base: The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
                    ///   - body: The contents of the pull request.
                    ///   - maintainerCanModify: Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
                    ///   - draft: Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://docs.github.com/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
                    ///   - issue: An issue in the repository to convert to a pull request. The issue title, body, and comments will become the title, body, and comments on the new pull request. Required unless `title` is specified.
                    public init(
                        title: Swift.String? = nil,
                        head: Swift.String,
                        headRepo: Swift.String? = nil,
                        base: Swift.String,
                        body: Swift.String? = nil,
                        maintainerCanModify: Swift.Bool? = nil,
                        draft: Swift.Bool? = nil,
                        issue: Swift.Int64? = nil
                    ) {
                        self.title = title
                        self.head = head
                        self.headRepo = headRepo
                        self.base = base
                        self.body = body
                        self.maintainerCanModify = maintainerCanModify
                        self.draft = draft
                        self.issue = issue
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case head
                        case headRepo = "head_repo"
                        case base
                        case body
                        case maintainerCanModify = "maintainer_can_modify"
                        case draft
                        case issue
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/requestBody/content/application\/json`.
                case json(Operations.PullsCreate.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsCreate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsCreate.Input.Path,
                headers: Operations.PullsCreate.Input.Headers = .init(),
                body: Operations.PullsCreate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsCreate.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.PullRequest)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequest {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsCreate.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsCreate.Output.Created.Headers = .init(),
                    body: Operations.PullsCreate.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.PullsCreate.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.PullsCreate.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/post(pulls/create)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List review comments in a repository
    ///
    /// Lists review comments for all pull requests in a repository. By default,
    /// review comments are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/get(pulls/list-review-comments-for-repo)`.
    public enum PullsListReviewCommentsForRepo {
        public static let id: Swift.String = "pulls/list-review-comments-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.PullsListReviewCommentsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case createdAt = "created_at"
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/sort`.
                public var sort: Operations.PullsListReviewCommentsForRepo.Input.Query.SortPayload?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort results. Ignored without `sort` parameter.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/direction`.
                public var direction: Operations.PullsListReviewCommentsForRepo.Input.Query.DirectionPayload?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort:
                ///   - direction: The direction to sort results. Ignored without `sort` parameter.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Operations.PullsListReviewCommentsForRepo.Input.Query.SortPayload? = nil,
                    direction: Operations.PullsListReviewCommentsForRepo.Input.Query.DirectionPayload? = nil,
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListReviewCommentsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviewCommentsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviewCommentsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListReviewCommentsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListReviewCommentsForRepo.Input.Path,
                query: Operations.PullsListReviewCommentsForRepo.Input.Query = .init(),
                headers: Operations.PullsListReviewCommentsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListReviewCommentsForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PullRequestReviewComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PullRequestReviewComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListReviewCommentsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListReviewCommentsForRepo.Output.Ok.Headers = .init(),
                    body: Operations.PullsListReviewCommentsForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/get(pulls/list-review-comments-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListReviewCommentsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListReviewCommentsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a review comment for a pull request
    ///
    /// Provides details for a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/get(pulls/get-review-comment)`.
    public enum PullsGetReviewComment {
        public static let id: Swift.String = "pulls/get-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.PullsGetReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGetReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGetReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsGetReviewComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsGetReviewComment.Input.Path,
                headers: Operations.PullsGetReviewComment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReviewComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReviewComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsGetReviewComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsGetReviewComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/get(pulls/get-review-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsGetReviewComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsGetReviewComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/get(pulls/get-review-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a review comment for a pull request
    ///
    /// Edits the content of a specified review comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/patch(pulls/update-review-comment)`.
    public enum PullsUpdateReviewComment {
        public static let id: Swift.String = "pulls/update-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.PullsUpdateReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsUpdateReviewComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The text of the reply to the review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The text of the reply to the review comment.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.PullsUpdateReviewComment.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsUpdateReviewComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsUpdateReviewComment.Input.Path,
                headers: Operations.PullsUpdateReviewComment.Input.Headers = .init(),
                body: Operations.PullsUpdateReviewComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReviewComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReviewComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsUpdateReviewComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsUpdateReviewComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/patch(pulls/update-review-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsUpdateReviewComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsUpdateReviewComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a review comment for a pull request
    ///
    /// Deletes a review comment.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)`.
    public enum PullsDeleteReviewComment {
        public static let id: Swift.String = "pulls/delete-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commentId = commentId
                }
            }
            public var path: Operations.PullsDeleteReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/comments/{comment_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDeleteReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDeleteReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsDeleteReviewComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsDeleteReviewComment.Input.Path,
                headers: Operations.PullsDeleteReviewComment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PullsDeleteReviewComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PullsDeleteReviewComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/comments/{comment_id}/delete(pulls/delete-review-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists details of a pull request by providing its number.
    ///
    /// When you get, [create](https://docs.github.com/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
    ///
    /// The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
    ///
    /// *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
    /// *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
    /// *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
    ///
    /// Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    /// - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)`.
    public enum PullsGet {
        public static let id: Swift.String = "pulls/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsGet.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsGet.Input.Path,
                headers: Operations.PullsGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequest)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequest {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Unacceptable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/406`.
            ///
            /// HTTP response code: `406 notAcceptable`.
            case notAcceptable(Components.Responses.Unacceptable)
            /// The associated value of the enum case if `self` is `.notAcceptable`.
            ///
            /// - Throws: An error if `self` is not `.notAcceptable`.
            /// - SeeAlso: `.notAcceptable`.
            public var notAcceptable: Components.Responses.Unacceptable {
                get throws {
                    switch self {
                    case let .notAcceptable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notAcceptable",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/get(pulls/get)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a pull request
    ///
    /// Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/pulls/{pull_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)`.
    public enum PullsUpdate {
        public static let id: Swift.String = "pulls/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsUpdate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The title of the pull request.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The contents of the pull request.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// State of this Pull Request. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/state`.
                    @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case open = "open"
                        case closed = "closed"
                    }
                    /// State of this Pull Request. Either `open` or `closed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/state`.
                    public var state: Operations.PullsUpdate.Input.Body.JsonPayload.StatePayload?
                    /// The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/base`.
                    public var base: Swift.String?
                    /// Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/json/maintainer_can_modify`.
                    public var maintainerCanModify: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: The title of the pull request.
                    ///   - body: The contents of the pull request.
                    ///   - state: State of this Pull Request. Either `open` or `closed`.
                    ///   - base: The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
                    ///   - maintainerCanModify: Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
                    public init(
                        title: Swift.String? = nil,
                        body: Swift.String? = nil,
                        state: Operations.PullsUpdate.Input.Body.JsonPayload.StatePayload? = nil,
                        base: Swift.String? = nil,
                        maintainerCanModify: Swift.Bool? = nil
                    ) {
                        self.title = title
                        self.body = body
                        self.state = state
                        self.base = base
                        self.maintainerCanModify = maintainerCanModify
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case body
                        case state
                        case base
                        case maintainerCanModify = "maintainer_can_modify"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.PullsUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsUpdate.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsUpdate.Input.Path,
                headers: Operations.PullsUpdate.Input.Headers = .init(),
                body: Operations.PullsUpdate.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequest)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequest {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/patch(pulls/update)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List review comments on a pull request
    ///
    /// Lists all review comments for a specified pull request. By default, review comments
    /// are in ascending order by ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/get(pulls/list-review-comments)`.
    public enum PullsListReviewComments {
        public static let id: Swift.String = "pulls/list-review-comments"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsListReviewComments.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort`.
                @frozen public enum Sort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/sort`.
                public var sort: Components.Parameters.Sort?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/direction`.
                @frozen public enum DirectionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort results. Ignored without `sort` parameter.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/direction`.
                public var direction: Operations.PullsListReviewComments.Input.Query.DirectionPayload?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by.
                ///   - direction: The direction to sort results. Ignored without `sort` parameter.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.Sort? = nil,
                    direction: Operations.PullsListReviewComments.Input.Query.DirectionPayload? = nil,
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListReviewComments.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviewComments.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviewComments.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListReviewComments.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListReviewComments.Input.Path,
                query: Operations.PullsListReviewComments.Input.Query = .init(),
                headers: Operations.PullsListReviewComments.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListReviewComments.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PullRequestReviewComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PullRequestReviewComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListReviewComments.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListReviewComments.Output.Ok.Headers = .init(),
                    body: Operations.PullsListReviewComments.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/get(pulls/list-review-comments)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListReviewComments.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListReviewComments.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a review comment for a pull request
    ///
    /// Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/issues/comments#create-an-issue-comment)."
    ///
    /// If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.
    ///
    /// The `position` parameter is closing down. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)`.
    public enum PullsCreateReviewComment {
        public static let id: Swift.String = "pulls/create-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsCreateReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsCreateReviewComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The text of the review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/commit_id`.
                    public var commitId: Swift.String
                    /// The relative path to the file that necessitates a comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/path`.
                    public var path: Swift.String
                    /// **This parameter is closing down. Use `line` instead**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/position`.
                    @available(*, deprecated)
                    public var position: Swift.Int?
                    /// In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://docs.github.com/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/side`.
                    @frozen public enum SidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case left = "LEFT"
                        case right = "RIGHT"
                    }
                    /// In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://docs.github.com/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/side`.
                    public var side: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.SidePayload?
                    /// **Required unless using `subject_type:file`**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/line`.
                    public var line: Swift.Int?
                    /// **Required when using multi-line comments unless using `in_reply_to`**. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/start_line`.
                    public var startLine: Swift.Int?
                    /// **Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/start_side`.
                    @frozen public enum StartSidePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case left = "LEFT"
                        case right = "RIGHT"
                        case side = "side"
                    }
                    /// **Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/start_side`.
                    public var startSide: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.StartSidePayload?
                    /// The ID of the review comment to reply to. To find the ID of a review comment with ["List review comments on a pull request"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/in_reply_to`.
                    public var inReplyTo: Swift.Int?
                    /// The level at which the comment is targeted.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/subject_type`.
                    @frozen public enum SubjectTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case line = "line"
                        case file = "file"
                    }
                    /// The level at which the comment is targeted.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/json/subject_type`.
                    public var subjectType: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.SubjectTypePayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The text of the review comment.
                    ///   - commitId: The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
                    ///   - path: The relative path to the file that necessitates a comment.
                    ///   - position: **This parameter is closing down. Use `line` instead**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
                    ///   - side: In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://docs.github.com/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
                    ///   - line: **Required unless using `subject_type:file`**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
                    ///   - startLine: **Required when using multi-line comments unless using `in_reply_to`**. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
                    ///   - startSide: **Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
                    ///   - inReplyTo: The ID of the review comment to reply to. To find the ID of a review comment with ["List review comments on a pull request"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.
                    ///   - subjectType: The level at which the comment is targeted.
                    public init(
                        body: Swift.String,
                        commitId: Swift.String,
                        path: Swift.String,
                        position: Swift.Int? = nil,
                        side: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.SidePayload? = nil,
                        line: Swift.Int? = nil,
                        startLine: Swift.Int? = nil,
                        startSide: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.StartSidePayload? = nil,
                        inReplyTo: Swift.Int? = nil,
                        subjectType: Operations.PullsCreateReviewComment.Input.Body.JsonPayload.SubjectTypePayload? = nil
                    ) {
                        self.body = body
                        self.commitId = commitId
                        self.path = path
                        self.position = position
                        self.side = side
                        self.line = line
                        self.startLine = startLine
                        self.startSide = startSide
                        self.inReplyTo = inReplyTo
                        self.subjectType = subjectType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                        case commitId = "commit_id"
                        case path
                        case position
                        case side
                        case line
                        case startLine = "start_line"
                        case startSide = "start_side"
                        case inReplyTo = "in_reply_to"
                        case subjectType = "subject_type"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/requestBody/content/application\/json`.
                case json(Operations.PullsCreateReviewComment.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsCreateReviewComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsCreateReviewComment.Input.Path,
                headers: Operations.PullsCreateReviewComment.Input.Headers = .init(),
                body: Operations.PullsCreateReviewComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsCreateReviewComment.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.PullRequestReviewComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReviewComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsCreateReviewComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsCreateReviewComment.Output.Created.Headers = .init(),
                    body: Operations.PullsCreateReviewComment.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.PullsCreateReviewComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.PullsCreateReviewComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/post(pulls/create-review-comment)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a reply for a review comment
    ///
    /// Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
    /// and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/post(pulls/create-reply-for-review-comment)`.
    public enum PullsCreateReplyForReviewComment {
        public static let id: Swift.String = "pulls/create-reply-for-review-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.commentId = commentId
                }
            }
            public var path: Operations.PullsCreateReplyForReviewComment.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReplyForReviewComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReplyForReviewComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsCreateReplyForReviewComment.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The text of the review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The text of the review comment.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/requestBody/content/application\/json`.
                case json(Operations.PullsCreateReplyForReviewComment.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsCreateReplyForReviewComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsCreateReplyForReviewComment.Input.Path,
                headers: Operations.PullsCreateReplyForReviewComment.Input.Headers = .init(),
                body: Operations.PullsCreateReplyForReviewComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsCreateReplyForReviewComment.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.PullRequestReviewComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReviewComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsCreateReplyForReviewComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsCreateReplyForReviewComment.Output.Created.Headers = .init(),
                    body: Operations.PullsCreateReplyForReviewComment.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/post(pulls/create-reply-for-review-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.PullsCreateReplyForReviewComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.PullsCreateReplyForReviewComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies/post(pulls/create-reply-for-review-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List commits on a pull request
    ///
    /// Lists a maximum of 250 commits for a pull request. To receive a complete
    /// commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/commits/commits#list-commits)
    /// endpoint.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/commits/get(pulls/list-commits)`.
    public enum PullsListCommits {
        public static let id: Swift.String = "pulls/list-commits"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsListCommits.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListCommits.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListCommits.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListCommits.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListCommits.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListCommits.Input.Path,
                query: Operations.PullsListCommits.Input.Query = .init(),
                headers: Operations.PullsListCommits.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListCommits.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/commits/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Commit])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Commit] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListCommits.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListCommits.Output.Ok.Headers = .init(),
                    body: Operations.PullsListCommits.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/commits/get(pulls/list-commits)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListCommits.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListCommits.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List pull requests files
    ///
    /// Lists the files in a specified pull request.
    ///
    /// > [!NOTE]
    /// > Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)`.
    public enum PullsListFiles {
        public static let id: Swift.String = "pulls/list-files"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsListFiles.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListFiles.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListFiles.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListFiles.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListFiles.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListFiles.Input.Path,
                query: Operations.PullsListFiles.Input.Query = .init(),
                headers: Operations.PullsListFiles.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListFiles.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/files/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.DiffEntry])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.DiffEntry] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListFiles.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListFiles.Output.Ok.Headers = .init(),
                    body: Operations.PullsListFiles.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListFiles.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListFiles.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/files/get(pulls/list-files)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a pull request has been merged
    ///
    /// Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)`.
    public enum PullsCheckIfMerged {
        public static let id: Swift.String = "pulls/check-if-merged"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsCheckIfMerged.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.PullsCheckIfMerged.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if pull request has been merged
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.PullsCheckIfMerged.Output.NoContent)
            /// Response if pull request has been merged
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.PullsCheckIfMerged.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if pull request has not been merged
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.PullsCheckIfMerged.Output.NotFound)
            /// Not Found if pull request has not been merged
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/get(pulls/check-if-merged)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.PullsCheckIfMerged.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Merge a pull request
    ///
    /// Merges a pull request into the base branch.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/merge`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)`.
    public enum PullsMerge {
        public static let id: Swift.String = "pulls/merge"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsMerge.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsMerge.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsMerge.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsMerge.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Title for the automatic commit message.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json/commit_title`.
                    public var commitTitle: Swift.String?
                    /// Extra detail to append to automatic commit message.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json/commit_message`.
                    public var commitMessage: Swift.String?
                    /// SHA that pull request head must match to allow merge.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json/sha`.
                    public var sha: Swift.String?
                    /// The merge method to use.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json/merge_method`.
                    @frozen public enum MergeMethodPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case merge = "merge"
                        case squash = "squash"
                        case rebase = "rebase"
                    }
                    /// The merge method to use.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/json/merge_method`.
                    public var mergeMethod: Operations.PullsMerge.Input.Body.JsonPayload.MergeMethodPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - commitTitle: Title for the automatic commit message.
                    ///   - commitMessage: Extra detail to append to automatic commit message.
                    ///   - sha: SHA that pull request head must match to allow merge.
                    ///   - mergeMethod: The merge method to use.
                    public init(
                        commitTitle: Swift.String? = nil,
                        commitMessage: Swift.String? = nil,
                        sha: Swift.String? = nil,
                        mergeMethod: Operations.PullsMerge.Input.Body.JsonPayload.MergeMethodPayload? = nil
                    ) {
                        self.commitTitle = commitTitle
                        self.commitMessage = commitMessage
                        self.sha = sha
                        self.mergeMethod = mergeMethod
                    }
                    public enum CodingKeys: String, CodingKey {
                        case commitTitle = "commit_title"
                        case commitMessage = "commit_message"
                        case sha
                        case mergeMethod = "merge_method"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/requestBody/content/application\/json`.
                case json(Operations.PullsMerge.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsMerge.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsMerge.Input.Path,
                headers: Operations.PullsMerge.Input.Headers = .init(),
                body: Operations.PullsMerge.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestMergeResult)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestMergeResult {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsMerge.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsMerge.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// if merge was successful
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsMerge.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsMerge.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct MethodNotAllowed: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/405/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/405/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/405/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/405/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/405/content/application\/json`.
                    case json(Operations.PullsMerge.Output.MethodNotAllowed.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.PullsMerge.Output.MethodNotAllowed.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsMerge.Output.MethodNotAllowed.Body
                /// Creates a new `MethodNotAllowed`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsMerge.Output.MethodNotAllowed.Body) {
                    self.body = body
                }
            }
            /// Method Not Allowed if merge cannot be performed
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/405`.
            ///
            /// HTTP response code: `405 methodNotAllowed`.
            case methodNotAllowed(Operations.PullsMerge.Output.MethodNotAllowed)
            /// The associated value of the enum case if `self` is `.methodNotAllowed`.
            ///
            /// - Throws: An error if `self` is not `.methodNotAllowed`.
            /// - SeeAlso: `.methodNotAllowed`.
            public var methodNotAllowed: Operations.PullsMerge.Output.MethodNotAllowed {
                get throws {
                    switch self {
                    case let .methodNotAllowed(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "methodNotAllowed",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/409/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/409/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/409/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/409/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/merge/PUT/responses/409/content/application\/json`.
                    case json(Operations.PullsMerge.Output.Conflict.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.PullsMerge.Output.Conflict.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsMerge.Output.Conflict.Body
                /// Creates a new `Conflict`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsMerge.Output.Conflict.Body) {
                    self.body = body
                }
            }
            /// Conflict if sha was provided and pull request head did not match
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.PullsMerge.Output.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.PullsMerge.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/merge/put(pulls/merge)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get all requested reviewers for a pull request
    ///
    /// Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/get(pulls/list-requested-reviewers)`.
    public enum PullsListRequestedReviewers {
        public static let id: Swift.String = "pulls/list-requested-reviewers"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsListRequestedReviewers.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListRequestedReviewers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListRequestedReviewers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListRequestedReviewers.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsListRequestedReviewers.Input.Path,
                headers: Operations.PullsListRequestedReviewers.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListRequestedReviewers.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReviewRequest)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReviewRequest {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListRequestedReviewers.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListRequestedReviewers.Output.Ok.Headers = .init(),
                    body: Operations.PullsListRequestedReviewers.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/get(pulls/list-requested-reviewers)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListRequestedReviewers.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListRequestedReviewers.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Request reviewers for a pull request
    ///
    /// Requests reviews for a pull request from a given set of users and/or teams.
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)`.
    public enum PullsRequestReviewers {
        public static let id: Swift.String = "pulls/request-reviewers"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsRequestReviewers.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsRequestReviewers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsRequestReviewers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsRequestReviewers.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/json/value1`.
                    public struct Value1Payload: Codable, Hashable, Sendable {
                        /// Creates a new `Value1Payload`.
                        public init() {}
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/json/value1`.
                    public var value1: Operations.PullsRequestReviewers.Input.Body.JsonPayload.Value1Payload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/json/value2`.
                    public struct Value2Payload: Codable, Hashable, Sendable {
                        /// Creates a new `Value2Payload`.
                        public init() {}
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/json/value2`.
                    public var value2: Operations.PullsRequestReviewers.Input.Body.JsonPayload.Value2Payload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - value1:
                    ///   - value2:
                    public init(
                        value1: Operations.PullsRequestReviewers.Input.Body.JsonPayload.Value1Payload? = nil,
                        value2: Operations.PullsRequestReviewers.Input.Body.JsonPayload.Value2Payload? = nil
                    ) {
                        self.value1 = value1
                        self.value2 = value2
                    }
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self.value1 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self.value2 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                            [
                                self.value1,
                                self.value2
                            ],
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try self.value1?.encode(to: encoder)
                        try self.value2?.encode(to: encoder)
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/requestBody/content/application\/json`.
                case json(Operations.PullsRequestReviewers.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsRequestReviewers.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsRequestReviewers.Input.Path,
                headers: Operations.PullsRequestReviewers.Input.Headers = .init(),
                body: Operations.PullsRequestReviewers.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.PullRequestSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsRequestReviewers.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsRequestReviewers.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.PullsRequestReviewers.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.PullsRequestReviewers.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity if user is not a collaborator
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.PullsRequestReviewers.Output.UnprocessableContent)
            /// Unprocessable Entity if user is not a collaborator
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.PullsRequestReviewers.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/post(pulls/request-reviewers)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove requested reviewers from a pull request
    ///
    /// Removes review requests from a pull request for a given set of users and/or teams.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/delete(pulls/remove-requested-reviewers)`.
    public enum PullsRemoveRequestedReviewers {
        public static let id: Swift.String = "pulls/remove-requested-reviewers"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsRemoveRequestedReviewers.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsRemoveRequestedReviewers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsRemoveRequestedReviewers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsRemoveRequestedReviewers.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// An array of user `login`s that will be removed.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/requestBody/json/reviewers`.
                    public var reviewers: [Swift.String]
                    /// An array of team `slug`s that will be removed.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/requestBody/json/team_reviewers`.
                    public var teamReviewers: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - reviewers: An array of user `login`s that will be removed.
                    ///   - teamReviewers: An array of team `slug`s that will be removed.
                    public init(
                        reviewers: [Swift.String],
                        teamReviewers: [Swift.String]? = nil
                    ) {
                        self.reviewers = reviewers
                        self.teamReviewers = teamReviewers
                    }
                    public enum CodingKeys: String, CodingKey {
                        case reviewers
                        case teamReviewers = "team_reviewers"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/requestBody/content/application\/json`.
                case json(Operations.PullsRemoveRequestedReviewers.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsRemoveRequestedReviewers.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsRemoveRequestedReviewers.Input.Path,
                headers: Operations.PullsRemoveRequestedReviewers.Input.Headers = .init(),
                body: Operations.PullsRemoveRequestedReviewers.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsRemoveRequestedReviewers.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsRemoveRequestedReviewers.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/delete(pulls/remove-requested-reviewers)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsRemoveRequestedReviewers.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsRemoveRequestedReviewers.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers/delete(pulls/remove-requested-reviewers)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List reviews for a pull request
    ///
    /// Lists all reviews for a specified pull request. The list of reviews returns in chronological order.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/get(pulls/list-reviews)`.
    public enum PullsListReviews {
        public static let id: Swift.String = "pulls/list-reviews"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsListReviews.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListReviews.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviews.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListReviews.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListReviews.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListReviews.Input.Path,
                query: Operations.PullsListReviews.Input.Query = .init(),
                headers: Operations.PullsListReviews.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListReviews.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PullRequestReview])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PullRequestReview] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListReviews.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListReviews.Output.Ok.Headers = .init(),
                    body: Operations.PullsListReviews.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// The list of reviews returns in chronological order.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/get(pulls/list-reviews)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListReviews.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListReviews.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a review for a pull request
    ///
    /// Creates a review on a specified pull request.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request)."
    ///
    /// > [!NOTE]
    /// > To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) endpoint.
    ///
    /// The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)`.
    public enum PullsCreateReview {
        public static let id: Swift.String = "pulls/create-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsCreateReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsCreateReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsCreateReview.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/commit_id`.
                    public var commitId: Swift.String?
                    /// **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request) when you are ready.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/event`.
                    @frozen public enum EventPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case approve = "APPROVE"
                        case requestChanges = "REQUEST_CHANGES"
                        case comment = "COMMENT"
                    }
                    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request) when you are ready.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/event`.
                    public var event: Operations.PullsCreateReview.Input.Body.JsonPayload.EventPayload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload`.
                    public struct CommentsPayloadPayload: Codable, Hashable, Sendable {
                        /// The relative path to the file that necessitates a review comment.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/path`.
                        public var path: Swift.String
                        /// The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/position`.
                        public var position: Swift.Int?
                        /// Text of the review comment.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/body`.
                        public var body: Swift.String
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/line`.
                        public var line: Swift.Int?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/side`.
                        public var side: Swift.String?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/start_line`.
                        public var startLine: Swift.Int?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/CommentsPayload/start_side`.
                        public var startSide: Swift.String?
                        /// Creates a new `CommentsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - path: The relative path to the file that necessitates a review comment.
                        ///   - position: The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
                        ///   - body: Text of the review comment.
                        ///   - line:
                        ///   - side:
                        ///   - startLine:
                        ///   - startSide:
                        public init(
                            path: Swift.String,
                            position: Swift.Int? = nil,
                            body: Swift.String,
                            line: Swift.Int? = nil,
                            side: Swift.String? = nil,
                            startLine: Swift.Int? = nil,
                            startSide: Swift.String? = nil
                        ) {
                            self.path = path
                            self.position = position
                            self.body = body
                            self.line = line
                            self.side = side
                            self.startLine = startLine
                            self.startSide = startSide
                        }
                        public enum CodingKeys: String, CodingKey {
                            case path
                            case position
                            case body
                            case line
                            case side
                            case startLine = "start_line"
                            case startSide = "start_side"
                        }
                    }
                    /// Use the following table to specify the location, destination, and contents of the draft review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/comments`.
                    public typealias CommentsPayload = [Operations.PullsCreateReview.Input.Body.JsonPayload.CommentsPayloadPayload]
                    /// Use the following table to specify the location, destination, and contents of the draft review comment.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/json/comments`.
                    public var comments: Operations.PullsCreateReview.Input.Body.JsonPayload.CommentsPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - commitId: The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
                    ///   - body: **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
                    ///   - event: The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request) when you are ready.
                    ///   - comments: Use the following table to specify the location, destination, and contents of the draft review comment.
                    public init(
                        commitId: Swift.String? = nil,
                        body: Swift.String? = nil,
                        event: Operations.PullsCreateReview.Input.Body.JsonPayload.EventPayload? = nil,
                        comments: Operations.PullsCreateReview.Input.Body.JsonPayload.CommentsPayload? = nil
                    ) {
                        self.commitId = commitId
                        self.body = body
                        self.event = event
                        self.comments = comments
                    }
                    public enum CodingKeys: String, CodingKey {
                        case commitId = "commit_id"
                        case body
                        case event
                        case comments
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/requestBody/content/application\/json`.
                case json(Operations.PullsCreateReview.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsCreateReview.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsCreateReview.Input.Path,
                headers: Operations.PullsCreateReview.Input.Headers = .init(),
                body: Operations.PullsCreateReview.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsCreateReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsCreateReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsCreateReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsCreateReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/post(pulls/create-review)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a review for a pull request
    ///
    /// Retrieves a pull request review by its ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/get(pulls/get-review)`.
    public enum PullsGetReview {
        public static let id: Swift.String = "pulls/get-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsGetReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGetReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsGetReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsGetReview.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsGetReview.Input.Path,
                headers: Operations.PullsGetReview.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsGetReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsGetReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/get(pulls/get-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsGetReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsGetReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/get(pulls/get-review)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a review for a pull request
    ///
    /// Updates the contents of a specified review summary comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/put(pulls/update-review)`.
    public enum PullsUpdateReview {
        public static let id: Swift.String = "pulls/update-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsUpdateReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsUpdateReview.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The body text of the pull request review.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The body text of the pull request review.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/requestBody/content/application\/json`.
                case json(Operations.PullsUpdateReview.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsUpdateReview.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsUpdateReview.Input.Path,
                headers: Operations.PullsUpdateReview.Input.Headers = .init(),
                body: Operations.PullsUpdateReview.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsUpdateReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsUpdateReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/put(pulls/update-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsUpdateReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsUpdateReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/put(pulls/update-review)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a pending review for a pull request
    ///
    /// Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)`.
    public enum PullsDeletePendingReview {
        public static let id: Swift.String = "pulls/delete-pending-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsDeletePendingReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDeletePendingReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDeletePendingReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsDeletePendingReview.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.PullsDeletePendingReview.Input.Path,
                headers: Operations.PullsDeletePendingReview.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsDeletePendingReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsDeletePendingReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsDeletePendingReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsDeletePendingReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/delete(pulls/delete-pending-review)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List comments for a pull request review
    ///
    /// Lists comments for a specific pull request review.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/get(pulls/list-comments-for-review)`.
    public enum PullsListCommentsForReview {
        public static let id: Swift.String = "pulls/list-comments-for-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsListCommentsForReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.PullsListCommentsForReview.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListCommentsForReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsListCommentsForReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsListCommentsForReview.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.PullsListCommentsForReview.Input.Path,
                query: Operations.PullsListCommentsForReview.Input.Query = .init(),
                headers: Operations.PullsListCommentsForReview.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.PullsListCommentsForReview.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ReviewComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ReviewComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsListCommentsForReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.PullsListCommentsForReview.Output.Ok.Headers = .init(),
                    body: Operations.PullsListCommentsForReview.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/get(pulls/list-comments-for-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsListCommentsForReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsListCommentsForReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments/get(pulls/list-comments-for-review)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Dismiss a review for a pull request
    ///
    /// Dismisses a specified review on a pull request.
    ///
    /// > [!NOTE]
    /// > To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/branches/branch-protection), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)`.
    public enum PullsDismissReview {
        public static let id: Swift.String = "pulls/dismiss-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsDismissReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDismissReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsDismissReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsDismissReview.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The message for the pull request review dismissal
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody/json/message`.
                    public var message: Swift.String
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody/json/event`.
                    @frozen public enum EventPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case dismiss = "DISMISS"
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody/json/event`.
                    public var event: Operations.PullsDismissReview.Input.Body.JsonPayload.EventPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - message: The message for the pull request review dismissal
                    ///   - event:
                    public init(
                        message: Swift.String,
                        event: Operations.PullsDismissReview.Input.Body.JsonPayload.EventPayload? = nil
                    ) {
                        self.message = message
                        self.event = event
                    }
                    public enum CodingKeys: String, CodingKey {
                        case message
                        case event
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/requestBody/content/application\/json`.
                case json(Operations.PullsDismissReview.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsDismissReview.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsDismissReview.Input.Path,
                headers: Operations.PullsDismissReview.Input.Headers = .init(),
                body: Operations.PullsDismissReview.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsDismissReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsDismissReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsDismissReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsDismissReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals/put(pulls/dismiss-review)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Submit a review for a pull request
    ///
    /// Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)`.
    public enum PullsSubmitReview {
        public static let id: Swift.String = "pulls/submit-review"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// The unique identifier of the review.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/path/review_id`.
                public var reviewId: Components.Parameters.ReviewId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                ///   - reviewId: The unique identifier of the review.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber,
                    reviewId: Components.Parameters.ReviewId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                    self.reviewId = reviewId
                }
            }
            public var path: Operations.PullsSubmitReview.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsSubmitReview.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsSubmitReview.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsSubmitReview.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The body text of the pull request review
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody/json/event`.
                    @frozen public enum EventPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case approve = "APPROVE"
                        case requestChanges = "REQUEST_CHANGES"
                        case comment = "COMMENT"
                    }
                    /// The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody/json/event`.
                    public var event: Operations.PullsSubmitReview.Input.Body.JsonPayload.EventPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The body text of the pull request review
                    ///   - event: The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
                    public init(
                        body: Swift.String? = nil,
                        event: Operations.PullsSubmitReview.Input.Body.JsonPayload.EventPayload
                    ) {
                        self.body = body
                        self.event = event
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                        case event
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/requestBody/content/application\/json`.
                case json(Operations.PullsSubmitReview.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsSubmitReview.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsSubmitReview.Input.Path,
                headers: Operations.PullsSubmitReview.Input.Headers = .init(),
                body: Operations.PullsSubmitReview.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.PullRequestReview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PullRequestReview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsSubmitReview.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsSubmitReview.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.PullsSubmitReview.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.PullsSubmitReview.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events/post(pulls/submit-review)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a pull request branch
    ///
    /// Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
    /// Note: If making a request on behalf of a GitHub App you must also have permissions to write the contents of the head repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pulls/{pull_number}/update-branch`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)`.
    public enum PullsUpdateBranch {
        public static let id: Swift.String = "pulls/update-branch"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.PullsUpdateBranch.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateBranch.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.PullsUpdateBranch.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.PullsUpdateBranch.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits](https://docs.github.com/rest/commits/commits#list-commits)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/requestBody/json/expected_head_sha`.
                    public var expectedHeadSha: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - expectedHeadSha: The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits](https://docs.github.com/rest/commits/commits#list-commits)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
                    public init(expectedHeadSha: Swift.String? = nil) {
                        self.expectedHeadSha = expectedHeadSha
                    }
                    public enum CodingKeys: String, CodingKey {
                        case expectedHeadSha = "expected_head_sha"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/requestBody/content/application\/json`.
                case json(Operations.PullsUpdateBranch.Input.Body.JsonPayload)
            }
            public var body: Operations.PullsUpdateBranch.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.PullsUpdateBranch.Input.Path,
                headers: Operations.PullsUpdateBranch.Input.Headers = .init(),
                body: Operations.PullsUpdateBranch.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/responses/202/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/responses/202/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/responses/202/content/json/url`.
                        public var url: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - url:
                        public init(
                            message: Swift.String? = nil,
                            url: Swift.String? = nil
                        ) {
                            self.message = message
                            self.url = url
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case url
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/update-branch/PUT/responses/202/content/application\/json`.
                    case json(Operations.PullsUpdateBranch.Output.Accepted.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.PullsUpdateBranch.Output.Accepted.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.PullsUpdateBranch.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.PullsUpdateBranch.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.PullsUpdateBranch.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.PullsUpdateBranch.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/update-branch/put(pulls/update-branch)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
