// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects-classic/list-for-org)`.
    @available(*, deprecated)
    func projectsClassicListForOrg(_ input: Operations.ProjectsClassicListForOrg.Input) async throws -> Operations.ProjectsClassicListForOrg.Output
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)`.
    @available(*, deprecated)
    func projectsClassicCreateForOrg(_ input: Operations.ProjectsClassicCreateForOrg.Input) async throws -> Operations.ProjectsClassicCreateForOrg.Output
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)`.
    @available(*, deprecated)
    func projectsClassicGetColumn(_ input: Operations.ProjectsClassicGetColumn.Input) async throws -> Operations.ProjectsClassicGetColumn.Output
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)`.
    @available(*, deprecated)
    func projectsClassicUpdateColumn(_ input: Operations.ProjectsClassicUpdateColumn.Input) async throws -> Operations.ProjectsClassicUpdateColumn.Output
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)`.
    @available(*, deprecated)
    func projectsClassicDeleteColumn(_ input: Operations.ProjectsClassicDeleteColumn.Input) async throws -> Operations.ProjectsClassicDeleteColumn.Output
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)`.
    @available(*, deprecated)
    func projectsClassicMoveColumn(_ input: Operations.ProjectsClassicMoveColumn.Input) async throws -> Operations.ProjectsClassicMoveColumn.Output
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)`.
    @available(*, deprecated)
    func projectsClassicGet(_ input: Operations.ProjectsClassicGet.Input) async throws -> Operations.ProjectsClassicGet.Output
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)`.
    @available(*, deprecated)
    func projectsClassicUpdate(_ input: Operations.ProjectsClassicUpdate.Input) async throws -> Operations.ProjectsClassicUpdate.Output
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)`.
    @available(*, deprecated)
    func projectsClassicDelete(_ input: Operations.ProjectsClassicDelete.Input) async throws -> Operations.ProjectsClassicDelete.Output
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)`.
    @available(*, deprecated)
    func projectsClassicListCollaborators(_ input: Operations.ProjectsClassicListCollaborators.Input) async throws -> Operations.ProjectsClassicListCollaborators.Output
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)`.
    @available(*, deprecated)
    func projectsClassicAddCollaborator(_ input: Operations.ProjectsClassicAddCollaborator.Input) async throws -> Operations.ProjectsClassicAddCollaborator.Output
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)`.
    @available(*, deprecated)
    func projectsClassicRemoveCollaborator(_ input: Operations.ProjectsClassicRemoveCollaborator.Input) async throws -> Operations.ProjectsClassicRemoveCollaborator.Output
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)`.
    @available(*, deprecated)
    func projectsClassicGetPermissionForUser(_ input: Operations.ProjectsClassicGetPermissionForUser.Input) async throws -> Operations.ProjectsClassicGetPermissionForUser.Output
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)`.
    @available(*, deprecated)
    func projectsClassicListColumns(_ input: Operations.ProjectsClassicListColumns.Input) async throws -> Operations.ProjectsClassicListColumns.Output
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)`.
    @available(*, deprecated)
    func projectsClassicCreateColumn(_ input: Operations.ProjectsClassicCreateColumn.Input) async throws -> Operations.ProjectsClassicCreateColumn.Output
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)`.
    @available(*, deprecated)
    func projectsClassicListForRepo(_ input: Operations.ProjectsClassicListForRepo.Input) async throws -> Operations.ProjectsClassicListForRepo.Output
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)`.
    @available(*, deprecated)
    func projectsClassicCreateForRepo(_ input: Operations.ProjectsClassicCreateForRepo.Input) async throws -> Operations.ProjectsClassicCreateForRepo.Output
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)`.
    @available(*, deprecated)
    func projectsClassicCreateForAuthenticatedUser(_ input: Operations.ProjectsClassicCreateForAuthenticatedUser.Input) async throws -> Operations.ProjectsClassicCreateForAuthenticatedUser.Output
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects-classic/list-for-user)`.
    @available(*, deprecated)
    func projectsClassicListForUser(_ input: Operations.ProjectsClassicListForUser.Input) async throws -> Operations.ProjectsClassicListForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects-classic/list-for-org)`.
    @available(*, deprecated)
    public func projectsClassicListForOrg(
        path: Operations.ProjectsClassicListForOrg.Input.Path,
        query: Operations.ProjectsClassicListForOrg.Input.Query = .init(),
        headers: Operations.ProjectsClassicListForOrg.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicListForOrg.Output {
        try await projectsClassicListForOrg(Operations.ProjectsClassicListForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)`.
    @available(*, deprecated)
    public func projectsClassicCreateForOrg(
        path: Operations.ProjectsClassicCreateForOrg.Input.Path,
        headers: Operations.ProjectsClassicCreateForOrg.Input.Headers = .init(),
        body: Operations.ProjectsClassicCreateForOrg.Input.Body
    ) async throws -> Operations.ProjectsClassicCreateForOrg.Output {
        try await projectsClassicCreateForOrg(Operations.ProjectsClassicCreateForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)`.
    @available(*, deprecated)
    public func projectsClassicGetColumn(
        path: Operations.ProjectsClassicGetColumn.Input.Path,
        headers: Operations.ProjectsClassicGetColumn.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicGetColumn.Output {
        try await projectsClassicGetColumn(Operations.ProjectsClassicGetColumn.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)`.
    @available(*, deprecated)
    public func projectsClassicUpdateColumn(
        path: Operations.ProjectsClassicUpdateColumn.Input.Path,
        headers: Operations.ProjectsClassicUpdateColumn.Input.Headers = .init(),
        body: Operations.ProjectsClassicUpdateColumn.Input.Body
    ) async throws -> Operations.ProjectsClassicUpdateColumn.Output {
        try await projectsClassicUpdateColumn(Operations.ProjectsClassicUpdateColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)`.
    @available(*, deprecated)
    public func projectsClassicDeleteColumn(
        path: Operations.ProjectsClassicDeleteColumn.Input.Path,
        headers: Operations.ProjectsClassicDeleteColumn.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicDeleteColumn.Output {
        try await projectsClassicDeleteColumn(Operations.ProjectsClassicDeleteColumn.Input(
            path: path,
            headers: headers
        ))
    }
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)`.
    @available(*, deprecated)
    public func projectsClassicMoveColumn(
        path: Operations.ProjectsClassicMoveColumn.Input.Path,
        headers: Operations.ProjectsClassicMoveColumn.Input.Headers = .init(),
        body: Operations.ProjectsClassicMoveColumn.Input.Body
    ) async throws -> Operations.ProjectsClassicMoveColumn.Output {
        try await projectsClassicMoveColumn(Operations.ProjectsClassicMoveColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)`.
    @available(*, deprecated)
    public func projectsClassicGet(
        path: Operations.ProjectsClassicGet.Input.Path,
        headers: Operations.ProjectsClassicGet.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicGet.Output {
        try await projectsClassicGet(Operations.ProjectsClassicGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)`.
    @available(*, deprecated)
    public func projectsClassicUpdate(
        path: Operations.ProjectsClassicUpdate.Input.Path,
        headers: Operations.ProjectsClassicUpdate.Input.Headers = .init(),
        body: Operations.ProjectsClassicUpdate.Input.Body? = nil
    ) async throws -> Operations.ProjectsClassicUpdate.Output {
        try await projectsClassicUpdate(Operations.ProjectsClassicUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)`.
    @available(*, deprecated)
    public func projectsClassicDelete(
        path: Operations.ProjectsClassicDelete.Input.Path,
        headers: Operations.ProjectsClassicDelete.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicDelete.Output {
        try await projectsClassicDelete(Operations.ProjectsClassicDelete.Input(
            path: path,
            headers: headers
        ))
    }
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)`.
    @available(*, deprecated)
    public func projectsClassicListCollaborators(
        path: Operations.ProjectsClassicListCollaborators.Input.Path,
        query: Operations.ProjectsClassicListCollaborators.Input.Query = .init(),
        headers: Operations.ProjectsClassicListCollaborators.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicListCollaborators.Output {
        try await projectsClassicListCollaborators(Operations.ProjectsClassicListCollaborators.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)`.
    @available(*, deprecated)
    public func projectsClassicAddCollaborator(
        path: Operations.ProjectsClassicAddCollaborator.Input.Path,
        headers: Operations.ProjectsClassicAddCollaborator.Input.Headers = .init(),
        body: Operations.ProjectsClassicAddCollaborator.Input.Body? = nil
    ) async throws -> Operations.ProjectsClassicAddCollaborator.Output {
        try await projectsClassicAddCollaborator(Operations.ProjectsClassicAddCollaborator.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)`.
    @available(*, deprecated)
    public func projectsClassicRemoveCollaborator(
        path: Operations.ProjectsClassicRemoveCollaborator.Input.Path,
        headers: Operations.ProjectsClassicRemoveCollaborator.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicRemoveCollaborator.Output {
        try await projectsClassicRemoveCollaborator(Operations.ProjectsClassicRemoveCollaborator.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)`.
    @available(*, deprecated)
    public func projectsClassicGetPermissionForUser(
        path: Operations.ProjectsClassicGetPermissionForUser.Input.Path,
        headers: Operations.ProjectsClassicGetPermissionForUser.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicGetPermissionForUser.Output {
        try await projectsClassicGetPermissionForUser(Operations.ProjectsClassicGetPermissionForUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)`.
    @available(*, deprecated)
    public func projectsClassicListColumns(
        path: Operations.ProjectsClassicListColumns.Input.Path,
        query: Operations.ProjectsClassicListColumns.Input.Query = .init(),
        headers: Operations.ProjectsClassicListColumns.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicListColumns.Output {
        try await projectsClassicListColumns(Operations.ProjectsClassicListColumns.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)`.
    @available(*, deprecated)
    public func projectsClassicCreateColumn(
        path: Operations.ProjectsClassicCreateColumn.Input.Path,
        headers: Operations.ProjectsClassicCreateColumn.Input.Headers = .init(),
        body: Operations.ProjectsClassicCreateColumn.Input.Body
    ) async throws -> Operations.ProjectsClassicCreateColumn.Output {
        try await projectsClassicCreateColumn(Operations.ProjectsClassicCreateColumn.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)`.
    @available(*, deprecated)
    public func projectsClassicListForRepo(
        path: Operations.ProjectsClassicListForRepo.Input.Path,
        query: Operations.ProjectsClassicListForRepo.Input.Query = .init(),
        headers: Operations.ProjectsClassicListForRepo.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicListForRepo.Output {
        try await projectsClassicListForRepo(Operations.ProjectsClassicListForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)`.
    @available(*, deprecated)
    public func projectsClassicCreateForRepo(
        path: Operations.ProjectsClassicCreateForRepo.Input.Path,
        headers: Operations.ProjectsClassicCreateForRepo.Input.Headers = .init(),
        body: Operations.ProjectsClassicCreateForRepo.Input.Body
    ) async throws -> Operations.ProjectsClassicCreateForRepo.Output {
        try await projectsClassicCreateForRepo(Operations.ProjectsClassicCreateForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)`.
    @available(*, deprecated)
    public func projectsClassicCreateForAuthenticatedUser(
        headers: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Body
    ) async throws -> Operations.ProjectsClassicCreateForAuthenticatedUser.Output {
        try await projectsClassicCreateForAuthenticatedUser(Operations.ProjectsClassicCreateForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects-classic/list-for-user)`.
    @available(*, deprecated)
    public func projectsClassicListForUser(
        path: Operations.ProjectsClassicListForUser.Input.Path,
        query: Operations.ProjectsClassicListForUser.Input.Query = .init(),
        headers: Operations.ProjectsClassicListForUser.Input.Headers = .init()
    ) async throws -> Operations.ProjectsClassicListForUser.Output {
        try await projectsClassicListForUser(Operations.ProjectsClassicListForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Projects are a way to organize columns and cards of work.
        ///
        /// - Remark: Generated from `#/components/schemas/project`.
        public struct Project: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project/owner_url`.
            public var ownerUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/columns_url`.
            public var columnsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/project/node_id`.
            public var nodeId: Swift.String
            /// Name of the project
            ///
            /// - Remark: Generated from `#/components/schemas/project/name`.
            public var name: Swift.String
            /// Body of the project
            ///
            /// - Remark: Generated from `#/components/schemas/project/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/project/number`.
            public var number: Swift.Int
            /// State of the project; either 'open' or 'closed'
            ///
            /// - Remark: Generated from `#/components/schemas/project/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/project/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/project/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/project/updated_at`.
            public var updatedAt: Foundation.Date
            /// The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/organization_permission`.
            @frozen public enum OrganizationPermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case read = "read"
                case write = "write"
                case admin = "admin"
                case none = "none"
            }
            /// The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/organization_permission`.
            public var organizationPermission: Components.Schemas.Project.OrganizationPermissionPayload?
            /// Whether or not this project can be seen by everyone. Only present if owner is an organization.
            ///
            /// - Remark: Generated from `#/components/schemas/project/private`.
            public var _private: Swift.Bool?
            /// Creates a new `Project`.
            ///
            /// - Parameters:
            ///   - ownerUrl:
            ///   - url:
            ///   - htmlUrl:
            ///   - columnsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - name: Name of the project
            ///   - body: Body of the project
            ///   - number:
            ///   - state: State of the project; either 'open' or 'closed'
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - organizationPermission: The baseline permission that all organization members have on this project. Only present if owner is an organization.
            ///   - _private: Whether or not this project can be seen by everyone. Only present if owner is an organization.
            public init(
                ownerUrl: Swift.String,
                url: Swift.String,
                htmlUrl: Swift.String,
                columnsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                body: Swift.String? = nil,
                number: Swift.Int,
                state: Swift.String,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                organizationPermission: Components.Schemas.Project.OrganizationPermissionPayload? = nil,
                _private: Swift.Bool? = nil
            ) {
                self.ownerUrl = ownerUrl
                self.url = url
                self.htmlUrl = htmlUrl
                self.columnsUrl = columnsUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.body = body
                self.number = number
                self.state = state
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.organizationPermission = organizationPermission
                self._private = _private
            }
            public enum CodingKeys: String, CodingKey {
                case ownerUrl = "owner_url"
                case url
                case htmlUrl = "html_url"
                case columnsUrl = "columns_url"
                case id
                case nodeId = "node_id"
                case name
                case body
                case number
                case state
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case organizationPermission = "organization_permission"
                case _private = "private"
            }
        }
        /// Project columns contain cards of work.
        ///
        /// - Remark: Generated from `#/components/schemas/project-column`.
        public struct ProjectColumn: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project-column/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/project_url`.
            public var projectUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/cards_url`.
            public var cardsUrl: Swift.String
            /// The unique identifier of the project column
            ///
            /// - Remark: Generated from `#/components/schemas/project-column/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/project-column/node_id`.
            public var nodeId: Swift.String
            /// Name of the project column
            ///
            /// - Remark: Generated from `#/components/schemas/project-column/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-column/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/project-column/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `ProjectColumn`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - projectUrl:
            ///   - cardsUrl:
            ///   - id: The unique identifier of the project column
            ///   - nodeId:
            ///   - name: Name of the project column
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                url: Swift.String,
                projectUrl: Swift.String,
                cardsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.url = url
                self.projectUrl = projectUrl
                self.cardsUrl = cardsUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case projectUrl = "project_url"
                case cardsUrl = "cards_url"
                case id
                case nodeId = "node_id"
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Project Collaborator Permission
        ///
        /// - Remark: Generated from `#/components/schemas/project-collaborator-permission`.
        public struct ProjectCollaboratorPermission: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/project-collaborator-permission/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/project-collaborator-permission/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// Creates a new `ProjectCollaboratorPermission`.
            ///
            /// - Parameters:
            ///   - permission:
            ///   - user:
            public init(
                permission: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil
            ) {
                self.permission = permission
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case permission
                case user
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The unique identifier of the project.
        ///
        /// - Remark: Generated from `#/components/parameters/project-id`.
        public typealias ProjectId = Swift.Int
        /// The unique identifier of the column.
        ///
        /// - Remark: Generated from `#/components/parameters/column-id`.
        public typealias ColumnId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Gone: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/gone/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/gone/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Gone.Body
            /// Creates a new `Gone`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Gone.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List organization projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects-classic/list-for-org)`.
    public enum ProjectsClassicListForOrg {
        public static let id: Swift.String = "projects-classic/list-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ProjectsClassicListForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/state`.
                public var state: Operations.ProjectsClassicListForOrg.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsClassicListForOrg.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsClassicListForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicListForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicListForOrg.Input.Path,
                query: Operations.ProjectsClassicListForOrg.Input.Query = .init(),
                headers: Operations.ProjectsClassicListForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsClassicListForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicListForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsClassicListForOrg.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsClassicListForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects-classic/list-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicListForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicListForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/get(projects-classic/list-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an organization project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/projects`.
    /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)`.
    public enum ProjectsClassicCreateForOrg {
        public static let id: Swift.String = "projects-classic/create-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ProjectsClassicCreateForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicCreateForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the project.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the project.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the project.
                    ///   - body: The description of the project.
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicCreateForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicCreateForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicCreateForOrg.Input.Path,
                headers: Operations.ProjectsClassicCreateForOrg.Input.Headers = .init(),
                body: Operations.ProjectsClassicCreateForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicCreateForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicCreateForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsClassicCreateForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsClassicCreateForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/projects/post(projects-classic/create-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)`.
    public enum ProjectsClassicGetColumn {
        public static let id: Swift.String = "projects-classic/get-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsClassicGetColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGetColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGetColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicGetColumn.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicGetColumn.Input.Path,
                headers: Operations.ProjectsClassicGetColumn.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicGetColumn.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicGetColumn.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicGetColumn.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicGetColumn.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/get(projects-classic/get-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an existing project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)`.
    public enum ProjectsClassicUpdateColumn {
        public static let id: Swift.String = "projects-classic/update-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsClassicUpdateColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicUpdateColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicUpdateColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicUpdateColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project column
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project column
                    public init(name: Swift.String) {
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicUpdateColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicUpdateColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicUpdateColumn.Input.Path,
                headers: Operations.ProjectsClassicUpdateColumn.Input.Headers = .init(),
                body: Operations.ProjectsClassicUpdateColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicUpdateColumn.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicUpdateColumn.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicUpdateColumn.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicUpdateColumn.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/patch(projects-classic/update-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/columns/{column_id}`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)`.
    public enum ProjectsClassicDeleteColumn {
        public static let id: Swift.String = "projects-classic/delete-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsClassicDeleteColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicDeleteColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicDeleteColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicDeleteColumn.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicDeleteColumn.Input.Path,
                headers: Operations.ProjectsClassicDeleteColumn.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsClassicDeleteColumn.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsClassicDeleteColumn.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/delete(projects-classic/delete-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Move a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/columns/{column_id}/moves`.
    /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)`.
    public enum ProjectsClassicMoveColumn {
        public static let id: Swift.String = "projects-classic/move-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the column.
                ///
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/path/column_id`.
                public var columnId: Components.Parameters.ColumnId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - columnId: The unique identifier of the column.
                public init(columnId: Components.Parameters.ColumnId) {
                    self.columnId = columnId
                }
            }
            public var path: Operations.ProjectsClassicMoveColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicMoveColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicMoveColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicMoveColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.
                    ///
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/json/position`.
                    public var position: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - position: The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.
                    public init(position: Swift.String) {
                        self.position = position
                    }
                    public enum CodingKeys: String, CodingKey {
                        case position
                    }
                }
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicMoveColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicMoveColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicMoveColumn.Input.Path,
                headers: Operations.ProjectsClassicMoveColumn.Input.Headers = .init(),
                body: Operations.ProjectsClassicMoveColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Creates a new `JsonPayload`.
                        public init() {}
                        public init(from decoder: any Decoder) throws {
                            try decoder.ensureNoAdditionalProperties(knownKeys: [])
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/columns/{column_id}/moves/POST/responses/201/content/application\/json`.
                    case json(Operations.ProjectsClassicMoveColumn.Output.Created.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsClassicMoveColumn.Output.Created.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicMoveColumn.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicMoveColumn.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsClassicMoveColumn.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsClassicMoveColumn.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/columns/{column_id}/moves/post(projects-classic/move-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)`.
    public enum ProjectsClassicGet {
        public static let id: Swift.String = "projects-classic/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicGet.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicGet.Input.Path,
                headers: Operations.ProjectsClassicGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/get(projects-classic/get)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PATCH /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)`.
    public enum ProjectsClassicUpdate {
        public static let id: Swift.String = "projects-classic/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicUpdate.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// Body of the project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/body`.
                    public var body: Swift.String?
                    /// State of the project; either 'open' or 'closed'
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/state`.
                    public var state: Swift.String?
                    /// The baseline permission that all organization members have on this project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/organization_permission`.
                    @frozen public enum OrganizationPermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                        case none = "none"
                    }
                    /// The baseline permission that all organization members have on this project
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/organization_permission`.
                    public var organizationPermission: Operations.ProjectsClassicUpdate.Input.Body.JsonPayload.OrganizationPermissionPayload?
                    /// Whether or not this project can be seen by everyone.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/json/private`.
                    public var _private: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project
                    ///   - body: Body of the project
                    ///   - state: State of the project; either 'open' or 'closed'
                    ///   - organizationPermission: The baseline permission that all organization members have on this project
                    ///   - _private: Whether or not this project can be seen by everyone.
                    public init(
                        name: Swift.String? = nil,
                        body: Swift.String? = nil,
                        state: Swift.String? = nil,
                        organizationPermission: Operations.ProjectsClassicUpdate.Input.Body.JsonPayload.OrganizationPermissionPayload? = nil,
                        _private: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.body = body
                        self.state = state
                        self.organizationPermission = organizationPermission
                        self._private = _private
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                        case state
                        case organizationPermission = "organization_permission"
                        case _private = "private"
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicUpdate.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicUpdate.Input.Path,
                headers: Operations.ProjectsClassicUpdate.Input.Headers = .init(),
                body: Operations.ProjectsClassicUpdate.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if the authenticated user does not have access to the project
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.ProjectsClassicUpdate.Output.NotFound)
            /// Not Found if the authenticated user does not have access to the project
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.ProjectsClassicUpdate.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/json/errors`.
                        public var errors: [Swift.String]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: [Swift.String]? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/{project_id}/PATCH/responses/403/content/application\/json`.
                    case json(Operations.ProjectsClassicUpdate.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsClassicUpdate.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicUpdate.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicUpdate.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsClassicUpdate.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsClassicUpdate.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/patch(projects-classic/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)`.
    public enum ProjectsClassicDelete {
        public static let id: Swift.String = "projects-classic/delete"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicDelete.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicDelete.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicDelete.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicDelete.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicDelete.Input.Path,
                headers: Operations.ProjectsClassicDelete.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Delete Success
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsClassicDelete.Output.NoContent)
            /// Delete Success
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsClassicDelete.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/documentation_url`.
                        public var documentationUrl: Swift.String?
                        /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/json/errors`.
                        public var errors: [Swift.String]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - documentationUrl:
                        ///   - errors:
                        public init(
                            message: Swift.String? = nil,
                            documentationUrl: Swift.String? = nil,
                            errors: [Swift.String]? = nil
                        ) {
                            self.message = message
                            self.documentationUrl = documentationUrl
                            self.errors = errors
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case documentationUrl = "documentation_url"
                            case errors
                        }
                    }
                    /// - Remark: Generated from `#/paths/projects/{project_id}/DELETE/responses/403/content/application\/json`.
                    case json(Operations.ProjectsClassicDelete.Output.Forbidden.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ProjectsClassicDelete.Output.Forbidden.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicDelete.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicDelete.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ProjectsClassicDelete.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ProjectsClassicDelete.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/delete(projects-classic/delete)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List project collaborators
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)`.
    public enum ProjectsClassicListCollaborators {
        public static let id: Swift.String = "projects-classic/list-collaborators"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicListCollaborators.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/affiliation`.
                @frozen public enum AffiliationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case outside = "outside"
                    case direct = "direct"
                    case all = "all"
                }
                /// Filters the collaborators by their affiliation. `outside` means outside collaborators of a project that are not a member of the project's organization. `direct` means collaborators with permissions to a project, regardless of organization membership status. `all` means all collaborators the authenticated user can see.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/affiliation`.
                public var affiliation: Operations.ProjectsClassicListCollaborators.Input.Query.AffiliationPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - affiliation: Filters the collaborators by their affiliation. `outside` means outside collaborators of a project that are not a member of the project's organization. `direct` means collaborators with permissions to a project, regardless of organization membership status. `all` means all collaborators the authenticated user can see.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    affiliation: Operations.ProjectsClassicListCollaborators.Input.Query.AffiliationPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.affiliation = affiliation
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsClassicListCollaborators.Input.Query
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListCollaborators.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListCollaborators.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicListCollaborators.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicListCollaborators.Input.Path,
                query: Operations.ProjectsClassicListCollaborators.Input.Query = .init(),
                headers: Operations.ProjectsClassicListCollaborators.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsClassicListCollaborators.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicListCollaborators.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsClassicListCollaborators.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsClassicListCollaborators.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicListCollaborators.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicListCollaborators.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/get(projects-classic/list-collaborators)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add project collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `PUT /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)`.
    public enum ProjectsClassicAddCollaborator {
        public static let id: Swift.String = "projects-classic/add-collaborator"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsClassicAddCollaborator.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicAddCollaborator.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicAddCollaborator.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicAddCollaborator.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The permission to grant the collaborator.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json/permission`.
                    @frozen public enum PermissionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case read = "read"
                        case write = "write"
                        case admin = "admin"
                    }
                    /// The permission to grant the collaborator.
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/json/permission`.
                    public var permission: Operations.ProjectsClassicAddCollaborator.Input.Body.JsonPayload.PermissionPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - permission: The permission to grant the collaborator.
                    public init(permission: Operations.ProjectsClassicAddCollaborator.Input.Body.JsonPayload.PermissionPayload? = nil) {
                        self.permission = permission
                    }
                    public enum CodingKeys: String, CodingKey {
                        case permission
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/PUT/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicAddCollaborator.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicAddCollaborator.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicAddCollaborator.Input.Path,
                headers: Operations.ProjectsClassicAddCollaborator.Input.Headers = .init(),
                body: Operations.ProjectsClassicAddCollaborator.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsClassicAddCollaborator.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsClassicAddCollaborator.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/put(projects-classic/add-collaborator)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove user as a collaborator
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `DELETE /projects/{project_id}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)`.
    public enum ProjectsClassicRemoveCollaborator {
        public static let id: Swift.String = "projects-classic/remove-collaborator"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsClassicRemoveCollaborator.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicRemoveCollaborator.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicRemoveCollaborator.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicRemoveCollaborator.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicRemoveCollaborator.Input.Path,
                headers: Operations.ProjectsClassicRemoveCollaborator.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ProjectsClassicRemoveCollaborator.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ProjectsClassicRemoveCollaborator.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/delete(projects-classic/remove-collaborator)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get project permission for a user
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)`.
    public enum ProjectsClassicGetPermissionForUser {
        public static let id: Swift.String = "projects-classic/get-permission-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                ///   - username: The handle for the GitHub user account.
                public init(
                    projectId: Components.Parameters.ProjectId,
                    username: Components.Parameters.Username
                ) {
                    self.projectId = projectId
                    self.username = username
                }
            }
            public var path: Operations.ProjectsClassicGetPermissionForUser.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGetPermissionForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicGetPermissionForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicGetPermissionForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicGetPermissionForUser.Input.Path,
                headers: Operations.ProjectsClassicGetPermissionForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/collaborators/{username}/permission/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ProjectCollaboratorPermission)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectCollaboratorPermission {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicGetPermissionForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicGetPermissionForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicGetPermissionForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicGetPermissionForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/collaborators/{username}/permission/get(projects-classic/get-permission-for-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List project columns
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)`.
    public enum ProjectsClassicListColumns {
        public static let id: Swift.String = "projects-classic/list-columns"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicListColumns.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsClassicListColumns.Input.Query
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListColumns.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListColumns.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicListColumns.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicListColumns.Input.Path,
                query: Operations.ProjectsClassicListColumns.Input.Query = .init(),
                headers: Operations.ProjectsClassicListColumns.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsClassicListColumns.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ProjectColumn])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ProjectColumn] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicListColumns.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsClassicListColumns.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsClassicListColumns.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicListColumns.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicListColumns.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/get(projects-classic/list-columns)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a project column
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /projects/{project_id}/columns`.
    /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)`.
    public enum ProjectsClassicCreateColumn {
        public static let id: Swift.String = "projects-classic/create-column"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the project.
                ///
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/path/project_id`.
                public var projectId: Components.Parameters.ProjectId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - projectId: The unique identifier of the project.
                public init(projectId: Components.Parameters.ProjectId) {
                    self.projectId = projectId
                }
            }
            public var path: Operations.ProjectsClassicCreateColumn.Input.Path
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateColumn.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateColumn.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicCreateColumn.Input.Headers
            /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project column
                    ///
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project column
                    public init(name: Swift.String) {
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                    }
                }
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicCreateColumn.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicCreateColumn.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicCreateColumn.Input.Path,
                headers: Operations.ProjectsClassicCreateColumn.Input.Headers = .init(),
                body: Operations.ProjectsClassicCreateColumn.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/projects/{project_id}/columns/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.ProjectColumn)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ProjectColumn {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicCreateColumn.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicCreateColumn.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsClassicCreateColumn.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsClassicCreateColumn.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//projects/{project_id}/columns/post(projects-classic/create-column)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)`.
    public enum ProjectsClassicListForRepo {
        public static let id: Swift.String = "projects-classic/list-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ProjectsClassicListForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/state`.
                public var state: Operations.ProjectsClassicListForRepo.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsClassicListForRepo.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsClassicListForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicListForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicListForRepo.Input.Path,
                query: Operations.ProjectsClassicListForRepo.Input.Query = .init(),
                headers: Operations.ProjectsClassicListForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsClassicListForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicListForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsClassicListForRepo.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsClassicListForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicListForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicListForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/get(projects-classic/list-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a repository project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/projects`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)`.
    public enum ProjectsClassicCreateForRepo {
        public static let id: Swift.String = "projects-classic/create-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ProjectsClassicCreateForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicCreateForRepo.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the project.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// The description of the project.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the project.
                    ///   - body: The description of the project.
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicCreateForRepo.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicCreateForRepo.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ProjectsClassicCreateForRepo.Input.Path,
                headers: Operations.ProjectsClassicCreateForRepo.Input.Headers = .init(),
                body: Operations.ProjectsClassicCreateForRepo.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicCreateForRepo.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicCreateForRepo.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsClassicCreateForRepo.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsClassicCreateForRepo.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Gone
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/410`.
            ///
            /// HTTP response code: `410 gone`.
            case gone(Components.Responses.Gone)
            /// The associated value of the enum case if `self` is `.gone`.
            ///
            /// - Throws: An error if `self` is not `.gone`.
            /// - SeeAlso: `.gone`.
            public var gone: Components.Responses.Gone {
                get throws {
                    switch self {
                    case let .gone(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "gone",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/projects/post(projects-classic/create-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a user project
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `POST /user/projects`.
    /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)`.
    public enum ProjectsClassicCreateForAuthenticatedUser {
        public static let id: Swift.String = "projects-classic/create-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/projects/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicCreateForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/projects/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Name of the project
                    ///
                    /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// Body of the project
                    ///
                    /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/json/body`.
                    public var body: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: Name of the project
                    ///   - body: Body of the project
                    public init(
                        name: Swift.String,
                        body: Swift.String? = nil
                    ) {
                        self.name = name
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/user/projects/POST/requestBody/content/application\/json`.
                case json(Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.ProjectsClassicCreateForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/projects/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/projects/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Project)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Project {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicCreateForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ProjectsClassicCreateForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ProjectsClassicCreateForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ProjectsClassicCreateForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/projects/post(projects-classic/create-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List user projects
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
    /// > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.
    ///
    /// - Remark: HTTP `GET /users/{username}/projects`.
    /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects-classic/list-for-user)`.
    public enum ProjectsClassicListForUser {
        public static let id: Swift.String = "projects-classic/list-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ProjectsClassicListForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case closed = "closed"
                    case all = "all"
                }
                /// Indicates the state of the projects to return.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/state`.
                public var state: Operations.ProjectsClassicListForUser.Input.Query.StatePayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Indicates the state of the projects to return.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Operations.ProjectsClassicListForUser.Input.Query.StatePayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.state = state
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ProjectsClassicListForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/projects/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ProjectsClassicListForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ProjectsClassicListForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ProjectsClassicListForUser.Input.Path,
                query: Operations.ProjectsClassicListForUser.Input.Query = .init(),
                headers: Operations.ProjectsClassicListForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ProjectsClassicListForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/projects/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Project])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Project] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ProjectsClassicListForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ProjectsClassicListForUser.Output.Ok.Headers = .init(),
                    body: Operations.ProjectsClassicListForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects-classic/list-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ProjectsClassicListForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ProjectsClassicListForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/projects/get(projects-classic/list-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
