// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get the customization template for an OIDC subject claim for an organization
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/get(oidc/get-oidc-custom-sub-template-for-org)`.
    func oidcGetOidcCustomSubTemplateForOrg(_ input: Operations.OidcGetOidcCustomSubTemplateForOrg.Input) async throws -> Operations.OidcGetOidcCustomSubTemplateForOrg.Output
    /// Set the customization template for an OIDC subject claim for an organization
    ///
    /// Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)`.
    func oidcUpdateOidcCustomSubTemplateForOrg(_ input: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input) async throws -> Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get the customization template for an OIDC subject claim for an organization
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/get(oidc/get-oidc-custom-sub-template-for-org)`.
    public func oidcGetOidcCustomSubTemplateForOrg(
        path: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Path,
        headers: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Headers = .init()
    ) async throws -> Operations.OidcGetOidcCustomSubTemplateForOrg.Output {
        try await oidcGetOidcCustomSubTemplateForOrg(Operations.OidcGetOidcCustomSubTemplateForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set the customization template for an OIDC subject claim for an organization
    ///
    /// Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)`.
    public func oidcUpdateOidcCustomSubTemplateForOrg(
        path: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Path,
        headers: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Headers = .init(),
        body: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Body
    ) async throws -> Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output {
        try await oidcUpdateOidcCustomSubTemplateForOrg(Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Actions OIDC Subject customization
        ///
        /// - Remark: Generated from `#/components/schemas/oidc-custom-sub`.
        public struct OidcCustomSub: Codable, Hashable, Sendable {
            /// Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
            ///
            /// - Remark: Generated from `#/components/schemas/oidc-custom-sub/include_claim_keys`.
            public var includeClaimKeys: [Swift.String]
            /// Creates a new `OidcCustomSub`.
            ///
            /// - Parameters:
            ///   - includeClaimKeys: Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
            public init(includeClaimKeys: [Swift.String]) {
                self.includeClaimKeys = includeClaimKeys
            }
            public enum CodingKeys: String, CodingKey {
                case includeClaimKeys = "include_claim_keys"
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get the customization template for an OIDC subject claim for an organization
    ///
    /// Gets the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/get(oidc/get-oidc-custom-sub-template-for-org)`.
    public enum OidcGetOidcCustomSubTemplateForOrg {
        public static let id: Swift.String = "oidc/get-oidc-custom-sub-template-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OidcGetOidcCustomSubTemplateForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OidcGetOidcCustomSubTemplateForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Path,
                headers: Operations.OidcGetOidcCustomSubTemplateForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OidcCustomSub)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OidcCustomSub {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OidcGetOidcCustomSubTemplateForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OidcGetOidcCustomSubTemplateForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// A JSON serialized template for OIDC subject claim customization
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/get(oidc/get-oidc-custom-sub-template-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.OidcGetOidcCustomSubTemplateForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.OidcGetOidcCustomSubTemplateForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set the customization template for an OIDC subject claim for an organization
    ///
    /// Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/actions/oidc/customization/sub`.
    /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)`.
    public enum OidcUpdateOidcCustomSubTemplateForOrg {
        public static let id: Swift.String = "oidc/update-oidc-custom-sub-template-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OidcUpdateOidcCustomSubTemplateForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.OidcUpdateOidcCustomSubTemplateForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.OidcCustomSub)
            }
            public var body: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Path,
                headers: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Headers = .init(),
                body: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/actions/oidc/customization/sub/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Empty response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.OidcUpdateOidcCustomSubTemplateForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/actions/oidc/customization/sub/put(oidc/update-oidc-custom-sub-template-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
