// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Create a blob
    ///
    ///
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/blobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)`.
    func gitCreateBlob(_ input: Operations.GitCreateBlob.Input) async throws -> Operations.GitCreateBlob.Output
    /// Get a blob
    ///
    /// The `content` in the response will always be Base64 encoded.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw blob data.
    /// - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.
    ///
    /// **Note** This endpoint supports blobs up to 100 megabytes in size.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/blobs/{file_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)`.
    func gitGetBlob(_ input: Operations.GitGetBlob.Input) async throws -> Operations.GitGetBlob.Output
    /// Create a commit
    ///
    /// Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)`.
    func gitCreateCommit(_ input: Operations.GitCreateCommit.Input) async throws -> Operations.GitCreateCommit.Output
    /// Get a commit object
    ///
    /// Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/commits/{commit_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)`.
    func gitGetCommit(_ input: Operations.GitGetCommit.Input) async throws -> Operations.GitGetCommit.Output
    /// List matching references
    ///
    /// Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
    ///
    /// When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/matching-refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/matching-refs/{ref}/get(git/list-matching-refs)`.
    func gitListMatchingRefs(_ input: Operations.GitListMatchingRefs.Input) async throws -> Operations.GitListMatchingRefs.Output
    /// Get a reference
    ///
    /// Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/ref/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)`.
    func gitGetRef(_ input: Operations.GitGetRef.Input) async throws -> Operations.GitGetRef.Output
    /// Create a reference
    ///
    /// Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/refs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)`.
    func gitCreateRef(_ input: Operations.GitCreateRef.Input) async throws -> Operations.GitCreateRef.Output
    /// Update a reference
    ///
    /// Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)`.
    func gitUpdateRef(_ input: Operations.GitUpdateRef.Input) async throws -> Operations.GitUpdateRef.Output
    /// Delete a reference
    ///
    /// Deletes the provided reference.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)`.
    func gitDeleteRef(_ input: Operations.GitDeleteRef.Input) async throws -> Operations.GitDeleteRef.Output
    /// Create a tag object
    ///
    /// Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/tags`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)`.
    func gitCreateTag(_ input: Operations.GitCreateTag.Input) async throws -> Operations.GitCreateTag.Output
    /// Get a tag
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/tags/{tag_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)`.
    func gitGetTag(_ input: Operations.GitGetTag.Input) async throws -> Operations.GitGetTag.Output
    /// Create a tree
    ///
    /// The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
    ///
    /// If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/git/refs#update-a-reference)."
    ///
    /// Returns an error if you try to delete a file that does not exist.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/trees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)`.
    func gitCreateTree(_ input: Operations.GitCreateTree.Input) async throws -> Operations.GitCreateTree.Output
    /// Get a tree
    ///
    /// Returns a single tree using the SHA1 value or ref name for that tree.
    ///
    /// If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
    ///
    /// > [!NOTE]
    /// > The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/trees/{tree_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)`.
    func gitGetTree(_ input: Operations.GitGetTree.Input) async throws -> Operations.GitGetTree.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Create a blob
    ///
    ///
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/blobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)`.
    public func gitCreateBlob(
        path: Operations.GitCreateBlob.Input.Path,
        headers: Operations.GitCreateBlob.Input.Headers = .init(),
        body: Operations.GitCreateBlob.Input.Body
    ) async throws -> Operations.GitCreateBlob.Output {
        try await gitCreateBlob(Operations.GitCreateBlob.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a blob
    ///
    /// The `content` in the response will always be Base64 encoded.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw blob data.
    /// - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.
    ///
    /// **Note** This endpoint supports blobs up to 100 megabytes in size.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/blobs/{file_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)`.
    public func gitGetBlob(
        path: Operations.GitGetBlob.Input.Path,
        headers: Operations.GitGetBlob.Input.Headers = .init()
    ) async throws -> Operations.GitGetBlob.Output {
        try await gitGetBlob(Operations.GitGetBlob.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a commit
    ///
    /// Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)`.
    public func gitCreateCommit(
        path: Operations.GitCreateCommit.Input.Path,
        headers: Operations.GitCreateCommit.Input.Headers = .init(),
        body: Operations.GitCreateCommit.Input.Body
    ) async throws -> Operations.GitCreateCommit.Output {
        try await gitCreateCommit(Operations.GitCreateCommit.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a commit object
    ///
    /// Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/commits/{commit_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)`.
    public func gitGetCommit(
        path: Operations.GitGetCommit.Input.Path,
        headers: Operations.GitGetCommit.Input.Headers = .init()
    ) async throws -> Operations.GitGetCommit.Output {
        try await gitGetCommit(Operations.GitGetCommit.Input(
            path: path,
            headers: headers
        ))
    }
    /// List matching references
    ///
    /// Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
    ///
    /// When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/matching-refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/matching-refs/{ref}/get(git/list-matching-refs)`.
    public func gitListMatchingRefs(
        path: Operations.GitListMatchingRefs.Input.Path,
        headers: Operations.GitListMatchingRefs.Input.Headers = .init()
    ) async throws -> Operations.GitListMatchingRefs.Output {
        try await gitListMatchingRefs(Operations.GitListMatchingRefs.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a reference
    ///
    /// Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/ref/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)`.
    public func gitGetRef(
        path: Operations.GitGetRef.Input.Path,
        headers: Operations.GitGetRef.Input.Headers = .init()
    ) async throws -> Operations.GitGetRef.Output {
        try await gitGetRef(Operations.GitGetRef.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a reference
    ///
    /// Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/refs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)`.
    public func gitCreateRef(
        path: Operations.GitCreateRef.Input.Path,
        headers: Operations.GitCreateRef.Input.Headers = .init(),
        body: Operations.GitCreateRef.Input.Body
    ) async throws -> Operations.GitCreateRef.Output {
        try await gitCreateRef(Operations.GitCreateRef.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update a reference
    ///
    /// Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)`.
    public func gitUpdateRef(
        path: Operations.GitUpdateRef.Input.Path,
        headers: Operations.GitUpdateRef.Input.Headers = .init(),
        body: Operations.GitUpdateRef.Input.Body
    ) async throws -> Operations.GitUpdateRef.Output {
        try await gitUpdateRef(Operations.GitUpdateRef.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a reference
    ///
    /// Deletes the provided reference.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)`.
    public func gitDeleteRef(
        path: Operations.GitDeleteRef.Input.Path,
        headers: Operations.GitDeleteRef.Input.Headers = .init()
    ) async throws -> Operations.GitDeleteRef.Output {
        try await gitDeleteRef(Operations.GitDeleteRef.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a tag object
    ///
    /// Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/tags`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)`.
    public func gitCreateTag(
        path: Operations.GitCreateTag.Input.Path,
        headers: Operations.GitCreateTag.Input.Headers = .init(),
        body: Operations.GitCreateTag.Input.Body
    ) async throws -> Operations.GitCreateTag.Output {
        try await gitCreateTag(Operations.GitCreateTag.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a tag
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/tags/{tag_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)`.
    public func gitGetTag(
        path: Operations.GitGetTag.Input.Path,
        headers: Operations.GitGetTag.Input.Headers = .init()
    ) async throws -> Operations.GitGetTag.Output {
        try await gitGetTag(Operations.GitGetTag.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a tree
    ///
    /// The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
    ///
    /// If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/git/refs#update-a-reference)."
    ///
    /// Returns an error if you try to delete a file that does not exist.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/trees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)`.
    public func gitCreateTree(
        path: Operations.GitCreateTree.Input.Path,
        headers: Operations.GitCreateTree.Input.Headers = .init(),
        body: Operations.GitCreateTree.Input.Body
    ) async throws -> Operations.GitCreateTree.Output {
        try await gitCreateTree(Operations.GitCreateTree.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a tree
    ///
    /// Returns a single tree using the SHA1 value or ref name for that tree.
    ///
    /// If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
    ///
    /// > [!NOTE]
    /// > The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/trees/{tree_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)`.
    public func gitGetTree(
        path: Operations.GitGetTree.Input.Path,
        query: Operations.GitGetTree.Input.Query = .init(),
        headers: Operations.GitGetTree.Input.Headers = .init()
    ) async throws -> Operations.GitGetTree.Output {
        try await gitGetTree(Operations.GitGetTree.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// - Remark: Generated from `#/components/schemas/verification`.
        public struct Verification: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/verification/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/verification/reason`.
            public var reason: Swift.String
            /// - Remark: Generated from `#/components/schemas/verification/payload`.
            public var payload: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/signature`.
            public var signature: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/verified_at`.
            public var verifiedAt: Swift.String?
            /// Creates a new `Verification`.
            ///
            /// - Parameters:
            ///   - verified:
            ///   - reason:
            ///   - payload:
            ///   - signature:
            ///   - verifiedAt:
            public init(
                verified: Swift.Bool,
                reason: Swift.String,
                payload: Swift.String? = nil,
                signature: Swift.String? = nil,
                verifiedAt: Swift.String? = nil
            ) {
                self.verified = verified
                self.reason = reason
                self.payload = payload
                self.signature = signature
                self.verifiedAt = verifiedAt
            }
            public enum CodingKeys: String, CodingKey {
                case verified
                case reason
                case payload
                case signature
                case verifiedAt = "verified_at"
            }
        }
        /// The ID of the push protection bypass placeholder. This value is returned on any push protected routes.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass-placeholder-id`.
        public typealias SecretScanningPushProtectionBypassPlaceholderId = Swift.String
        /// Repository rule violation was detected
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error`.
        public struct RepositoryRuleViolationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/status`.
            public var status: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata`.
            public struct MetadataPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning`.
                public struct SecretScanningPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning/BypassPlaceholdersPayload`.
                    public struct BypassPlaceholdersPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning/BypassPlaceholdersPayload/placeholder_id`.
                        public var placeholderId: Components.Schemas.SecretScanningPushProtectionBypassPlaceholderId?
                        /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning/BypassPlaceholdersPayload/token_type`.
                        public var tokenType: Swift.String?
                        /// Creates a new `BypassPlaceholdersPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - placeholderId:
                        ///   - tokenType:
                        public init(
                            placeholderId: Components.Schemas.SecretScanningPushProtectionBypassPlaceholderId? = nil,
                            tokenType: Swift.String? = nil
                        ) {
                            self.placeholderId = placeholderId
                            self.tokenType = tokenType
                        }
                        public enum CodingKeys: String, CodingKey {
                            case placeholderId = "placeholder_id"
                            case tokenType = "token_type"
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning/bypass_placeholders`.
                    public typealias BypassPlaceholdersPayload = [Components.Schemas.RepositoryRuleViolationError.MetadataPayload.SecretScanningPayload.BypassPlaceholdersPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning/bypass_placeholders`.
                    public var bypassPlaceholders: Components.Schemas.RepositoryRuleViolationError.MetadataPayload.SecretScanningPayload.BypassPlaceholdersPayload?
                    /// Creates a new `SecretScanningPayload`.
                    ///
                    /// - Parameters:
                    ///   - bypassPlaceholders:
                    public init(bypassPlaceholders: Components.Schemas.RepositoryRuleViolationError.MetadataPayload.SecretScanningPayload.BypassPlaceholdersPayload? = nil) {
                        self.bypassPlaceholders = bypassPlaceholders
                    }
                    public enum CodingKeys: String, CodingKey {
                        case bypassPlaceholders = "bypass_placeholders"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata/secret_scanning`.
                public var secretScanning: Components.Schemas.RepositoryRuleViolationError.MetadataPayload.SecretScanningPayload?
                /// Creates a new `MetadataPayload`.
                ///
                /// - Parameters:
                ///   - secretScanning:
                public init(secretScanning: Components.Schemas.RepositoryRuleViolationError.MetadataPayload.SecretScanningPayload? = nil) {
                    self.secretScanning = secretScanning
                }
                public enum CodingKeys: String, CodingKey {
                    case secretScanning = "secret_scanning"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-violation-error/metadata`.
            public var metadata: Components.Schemas.RepositoryRuleViolationError.MetadataPayload?
            /// Creates a new `RepositoryRuleViolationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - status:
            ///   - metadata:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                status: Swift.String? = nil,
                metadata: Components.Schemas.RepositoryRuleViolationError.MetadataPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.status = status
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case status
                case metadata
            }
        }
        /// Short Blob
        ///
        /// - Remark: Generated from `#/components/schemas/short-blob`.
        public struct ShortBlob: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/short-blob/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/short-blob/sha`.
            public var sha: Swift.String
            /// Creates a new `ShortBlob`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - sha:
            public init(
                url: Swift.String,
                sha: Swift.String
            ) {
                self.url = url
                self.sha = sha
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case sha
            }
        }
        /// Blob
        ///
        /// - Remark: Generated from `#/components/schemas/blob`.
        public struct Blob: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/blob/content`.
            public var content: Swift.String
            /// - Remark: Generated from `#/components/schemas/blob/encoding`.
            public var encoding: Swift.String
            /// - Remark: Generated from `#/components/schemas/blob/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/blob/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/blob/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/blob/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/blob/highlighted_content`.
            public var highlightedContent: Swift.String?
            /// Creates a new `Blob`.
            ///
            /// - Parameters:
            ///   - content:
            ///   - encoding:
            ///   - url:
            ///   - sha:
            ///   - size:
            ///   - nodeId:
            ///   - highlightedContent:
            public init(
                content: Swift.String,
                encoding: Swift.String,
                url: Swift.String,
                sha: Swift.String,
                size: Swift.Int? = nil,
                nodeId: Swift.String,
                highlightedContent: Swift.String? = nil
            ) {
                self.content = content
                self.encoding = encoding
                self.url = url
                self.sha = sha
                self.size = size
                self.nodeId = nodeId
                self.highlightedContent = highlightedContent
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case encoding
                case url
                case sha
                case size
                case nodeId = "node_id"
                case highlightedContent = "highlighted_content"
            }
        }
        /// Low-level Git commit operations within a repository
        ///
        /// - Remark: Generated from `#/components/schemas/git-commit`.
        public struct GitCommit: Codable, Hashable, Sendable {
            /// SHA for the commit
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-commit/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-commit/url`.
            public var url: Swift.String
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/author`.
            public struct AuthorPayload: Codable, Hashable, Sendable {
                /// Timestamp of the commit
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/author/date`.
                public var date: Foundation.Date
                /// Git email address of the user
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/author/email`.
                public var email: Swift.String
                /// Name of the git user
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/author/name`.
                public var name: Swift.String
                /// Creates a new `AuthorPayload`.
                ///
                /// - Parameters:
                ///   - date: Timestamp of the commit
                ///   - email: Git email address of the user
                ///   - name: Name of the git user
                public init(
                    date: Foundation.Date,
                    email: Swift.String,
                    name: Swift.String
                ) {
                    self.date = date
                    self.email = email
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case email
                    case name
                }
            }
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/author`.
            public var author: Components.Schemas.GitCommit.AuthorPayload
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/committer`.
            public struct CommitterPayload: Codable, Hashable, Sendable {
                /// Timestamp of the commit
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/committer/date`.
                public var date: Foundation.Date
                /// Git email address of the user
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/committer/email`.
                public var email: Swift.String
                /// Name of the git user
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/committer/name`.
                public var name: Swift.String
                /// Creates a new `CommitterPayload`.
                ///
                /// - Parameters:
                ///   - date: Timestamp of the commit
                ///   - email: Git email address of the user
                ///   - name: Name of the git user
                public init(
                    date: Foundation.Date,
                    email: Swift.String,
                    name: Swift.String
                ) {
                    self.date = date
                    self.email = email
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case email
                    case name
                }
            }
            /// Identifying information for the git-user
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/committer`.
            public var committer: Components.Schemas.GitCommit.CommitterPayload
            /// Message describing the purpose of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/git-commit/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-commit/tree`.
            public struct TreePayload: Codable, Hashable, Sendable {
                /// SHA for the commit
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/tree/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-commit/tree/url`.
                public var url: Swift.String
                /// Creates a new `TreePayload`.
                ///
                /// - Parameters:
                ///   - sha: SHA for the commit
                ///   - url:
                public init(
                    sha: Swift.String,
                    url: Swift.String
                ) {
                    self.sha = sha
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-commit/tree`.
            public var tree: Components.Schemas.GitCommit.TreePayload
            /// - Remark: Generated from `#/components/schemas/git-commit/ParentsPayload`.
            public struct ParentsPayloadPayload: Codable, Hashable, Sendable {
                /// SHA for the commit
                ///
                /// - Remark: Generated from `#/components/schemas/git-commit/ParentsPayload/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-commit/ParentsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-commit/ParentsPayload/html_url`.
                public var htmlUrl: Swift.String
                /// Creates a new `ParentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - sha: SHA for the commit
                ///   - url:
                ///   - htmlUrl:
                public init(
                    sha: Swift.String,
                    url: Swift.String,
                    htmlUrl: Swift.String
                ) {
                    self.sha = sha
                    self.url = url
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                    case htmlUrl = "html_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-commit/parents`.
            public typealias ParentsPayload = [Components.Schemas.GitCommit.ParentsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/git-commit/parents`.
            public var parents: Components.Schemas.GitCommit.ParentsPayload
            /// - Remark: Generated from `#/components/schemas/git-commit/verification`.
            public struct VerificationPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/git-commit/verification/verified`.
                public var verified: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/git-commit/verification/reason`.
                public var reason: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-commit/verification/signature`.
                public var signature: Swift.String?
                /// - Remark: Generated from `#/components/schemas/git-commit/verification/payload`.
                public var payload: Swift.String?
                /// - Remark: Generated from `#/components/schemas/git-commit/verification/verified_at`.
                public var verifiedAt: Swift.String?
                /// Creates a new `VerificationPayload`.
                ///
                /// - Parameters:
                ///   - verified:
                ///   - reason:
                ///   - signature:
                ///   - payload:
                ///   - verifiedAt:
                public init(
                    verified: Swift.Bool,
                    reason: Swift.String,
                    signature: Swift.String? = nil,
                    payload: Swift.String? = nil,
                    verifiedAt: Swift.String? = nil
                ) {
                    self.verified = verified
                    self.reason = reason
                    self.signature = signature
                    self.payload = payload
                    self.verifiedAt = verifiedAt
                }
                public enum CodingKeys: String, CodingKey {
                    case verified
                    case reason
                    case signature
                    case payload
                    case verifiedAt = "verified_at"
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-commit/verification`.
            public var verification: Components.Schemas.GitCommit.VerificationPayload
            /// - Remark: Generated from `#/components/schemas/git-commit/html_url`.
            public var htmlUrl: Swift.String
            /// Creates a new `GitCommit`.
            ///
            /// - Parameters:
            ///   - sha: SHA for the commit
            ///   - nodeId:
            ///   - url:
            ///   - author: Identifying information for the git-user
            ///   - committer: Identifying information for the git-user
            ///   - message: Message describing the purpose of the commit
            ///   - tree:
            ///   - parents:
            ///   - verification:
            ///   - htmlUrl:
            public init(
                sha: Swift.String,
                nodeId: Swift.String,
                url: Swift.String,
                author: Components.Schemas.GitCommit.AuthorPayload,
                committer: Components.Schemas.GitCommit.CommitterPayload,
                message: Swift.String,
                tree: Components.Schemas.GitCommit.TreePayload,
                parents: Components.Schemas.GitCommit.ParentsPayload,
                verification: Components.Schemas.GitCommit.VerificationPayload,
                htmlUrl: Swift.String
            ) {
                self.sha = sha
                self.nodeId = nodeId
                self.url = url
                self.author = author
                self.committer = committer
                self.message = message
                self.tree = tree
                self.parents = parents
                self.verification = verification
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case sha
                case nodeId = "node_id"
                case url
                case author
                case committer
                case message
                case tree
                case parents
                case verification
                case htmlUrl = "html_url"
            }
        }
        /// Git references within a repository
        ///
        /// - Remark: Generated from `#/components/schemas/git-ref`.
        public struct GitRef: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/git-ref/ref`.
            public var ref: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-ref/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-ref/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-ref/object`.
            public struct ObjectPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/git-ref/object/type`.
                public var _type: Swift.String
                /// SHA for the reference
                ///
                /// - Remark: Generated from `#/components/schemas/git-ref/object/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-ref/object/url`.
                public var url: Swift.String
                /// Creates a new `ObjectPayload`.
                ///
                /// - Parameters:
                ///   - _type:
                ///   - sha: SHA for the reference
                ///   - url:
                public init(
                    _type: Swift.String,
                    sha: Swift.String,
                    url: Swift.String
                ) {
                    self._type = _type
                    self.sha = sha
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case sha
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-ref/object`.
            public var object: Components.Schemas.GitRef.ObjectPayload
            /// Creates a new `GitRef`.
            ///
            /// - Parameters:
            ///   - ref:
            ///   - nodeId:
            ///   - url:
            ///   - object:
            public init(
                ref: Swift.String,
                nodeId: Swift.String,
                url: Swift.String,
                object: Components.Schemas.GitRef.ObjectPayload
            ) {
                self.ref = ref
                self.nodeId = nodeId
                self.url = url
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case ref
                case nodeId = "node_id"
                case url
                case object
            }
        }
        /// Metadata for a Git tag
        ///
        /// - Remark: Generated from `#/components/schemas/git-tag`.
        public struct GitTag: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/git-tag/node_id`.
            public var nodeId: Swift.String
            /// Name of the tag
            ///
            /// - Remark: Generated from `#/components/schemas/git-tag/tag`.
            public var tag: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-tag/sha`.
            public var sha: Swift.String
            /// URL for the tag
            ///
            /// - Remark: Generated from `#/components/schemas/git-tag/url`.
            public var url: Swift.String
            /// Message describing the purpose of the tag
            ///
            /// - Remark: Generated from `#/components/schemas/git-tag/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-tag/tagger`.
            public struct TaggerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/git-tag/tagger/date`.
                public var date: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tag/tagger/email`.
                public var email: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tag/tagger/name`.
                public var name: Swift.String
                /// Creates a new `TaggerPayload`.
                ///
                /// - Parameters:
                ///   - date:
                ///   - email:
                ///   - name:
                public init(
                    date: Swift.String,
                    email: Swift.String,
                    name: Swift.String
                ) {
                    self.date = date
                    self.email = email
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case date
                    case email
                    case name
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-tag/tagger`.
            public var tagger: Components.Schemas.GitTag.TaggerPayload
            /// - Remark: Generated from `#/components/schemas/git-tag/object`.
            public struct ObjectPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/git-tag/object/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tag/object/type`.
                public var _type: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tag/object/url`.
                public var url: Swift.String
                /// Creates a new `ObjectPayload`.
                ///
                /// - Parameters:
                ///   - sha:
                ///   - _type:
                ///   - url:
                public init(
                    sha: Swift.String,
                    _type: Swift.String,
                    url: Swift.String
                ) {
                    self.sha = sha
                    self._type = _type
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case _type = "type"
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/git-tag/object`.
            public var object: Components.Schemas.GitTag.ObjectPayload
            /// - Remark: Generated from `#/components/schemas/git-tag/verification`.
            public var verification: Components.Schemas.Verification?
            /// Creates a new `GitTag`.
            ///
            /// - Parameters:
            ///   - nodeId:
            ///   - tag: Name of the tag
            ///   - sha:
            ///   - url: URL for the tag
            ///   - message: Message describing the purpose of the tag
            ///   - tagger:
            ///   - object:
            ///   - verification:
            public init(
                nodeId: Swift.String,
                tag: Swift.String,
                sha: Swift.String,
                url: Swift.String,
                message: Swift.String,
                tagger: Components.Schemas.GitTag.TaggerPayload,
                object: Components.Schemas.GitTag.ObjectPayload,
                verification: Components.Schemas.Verification? = nil
            ) {
                self.nodeId = nodeId
                self.tag = tag
                self.sha = sha
                self.url = url
                self.message = message
                self.tagger = tagger
                self.object = object
                self.verification = verification
            }
            public enum CodingKeys: String, CodingKey {
                case nodeId = "node_id"
                case tag
                case sha
                case url
                case message
                case tagger
                case object
                case verification
            }
        }
        /// The hierarchy between files in a Git repository.
        ///
        /// - Remark: Generated from `#/components/schemas/git-tree`.
        public struct GitTree: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/git-tree/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/git-tree/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/git-tree/truncated`.
            public var truncated: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload`.
            public struct TreePayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/path`.
                public var path: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/mode`.
                public var mode: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/type`.
                public var _type: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/size`.
                public var size: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/git-tree/TreePayload/url`.
                public var url: Swift.String?
                /// Creates a new `TreePayloadPayload`.
                ///
                /// - Parameters:
                ///   - path:
                ///   - mode:
                ///   - _type:
                ///   - sha:
                ///   - size:
                ///   - url:
                public init(
                    path: Swift.String,
                    mode: Swift.String,
                    _type: Swift.String,
                    sha: Swift.String,
                    size: Swift.Int? = nil,
                    url: Swift.String? = nil
                ) {
                    self.path = path
                    self.mode = mode
                    self._type = _type
                    self.sha = sha
                    self.size = size
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case path
                    case mode
                    case _type = "type"
                    case sha
                    case size
                    case url
                }
            }
            /// Objects specifying a tree structure
            ///
            /// - Remark: Generated from `#/components/schemas/git-tree/tree`.
            public typealias TreePayload = [Components.Schemas.GitTree.TreePayloadPayload]
            /// Objects specifying a tree structure
            ///
            /// - Remark: Generated from `#/components/schemas/git-tree/tree`.
            public var tree: Components.Schemas.GitTree.TreePayload
            /// Creates a new `GitTree`.
            ///
            /// - Parameters:
            ///   - sha:
            ///   - url:
            ///   - truncated:
            ///   - tree: Objects specifying a tree structure
            public init(
                sha: Swift.String,
                url: Swift.String? = nil,
                truncated: Swift.Bool,
                tree: Components.Schemas.GitTree.TreePayload
            ) {
                self.sha = sha
                self.url = url
                self.truncated = truncated
                self.tree = tree
            }
            public enum CodingKeys: String, CodingKey {
                case sha
                case url
                case truncated
                case tree
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The SHA of the commit.
        ///
        /// - Remark: Generated from `#/components/parameters/commit-sha`.
        public typealias CommitSha = Swift.String
        /// The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
        ///
        /// - Remark: Generated from `#/components/parameters/git-ref-only`.
        public typealias GitRefOnly = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Create a blob
    ///
    ///
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/blobs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)`.
    public enum GitCreateBlob {
        public static let id: Swift.String = "git/create-blob"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.GitCreateBlob.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateBlob.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateBlob.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitCreateBlob.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The new blob's content.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/requestBody/json/content`.
                    public var content: Swift.String
                    /// The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/requestBody/json/encoding`.
                    public var encoding: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - content: The new blob's content.
                    ///   - encoding: The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    public init(
                        content: Swift.String,
                        encoding: Swift.String? = nil
                    ) {
                        self.content = content
                        self.encoding = encoding
                    }
                    public enum CodingKeys: String, CodingKey {
                        case content
                        case encoding
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/requestBody/content/application\/json`.
                case json(Operations.GitCreateBlob.Input.Body.JsonPayload)
            }
            public var body: Operations.GitCreateBlob.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitCreateBlob.Input.Path,
                headers: Operations.GitCreateBlob.Input.Headers = .init(),
                body: Operations.GitCreateBlob.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitCreateBlob.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.ShortBlob)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ShortBlob {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateBlob.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitCreateBlob.Output.Created.Headers = .init(),
                    body: Operations.GitCreateBlob.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GitCreateBlob.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GitCreateBlob.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/422/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/422/content/json/case1`.
                        case ValidationError(Components.Schemas.ValidationError)
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/422/content/json/case2`.
                        case RepositoryRuleViolationError(Components.Schemas.RepositoryRuleViolationError)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .ValidationError(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .RepositoryRuleViolationError(try .init(from: decoder))
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .ValidationError(value):
                                try value.encode(to: encoder)
                            case let .RepositoryRuleViolationError(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/POST/responses/422/content/application\/json`.
                    case json(Operations.GitCreateBlob.Output.UnprocessableContent.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.GitCreateBlob.Output.UnprocessableContent.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateBlob.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitCreateBlob.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Validation failed
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/post(git/create-blob)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.GitCreateBlob.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.GitCreateBlob.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a blob
    ///
    /// The `content` in the response will always be Base64 encoded.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw blob data.
    /// - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.
    ///
    /// **Note** This endpoint supports blobs up to 100 megabytes in size.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/blobs/{file_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)`.
    public enum GitGetBlob {
        public static let id: Swift.String = "git/get-blob"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/path/file_sha`.
                public var fileSha: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - fileSha:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    fileSha: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.fileSha = fileSha
                }
            }
            public var path: Operations.GitGetBlob.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetBlob.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetBlob.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitGetBlob.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitGetBlob.Input.Path,
                headers: Operations.GitGetBlob.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/blobs/{file_sha}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Blob)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Blob {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitGetBlob.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitGetBlob.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitGetBlob.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitGetBlob.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/blobs/{file_sha}/get(git/get-blob)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a commit
    ///
    /// Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)`.
    public enum GitCreateCommit {
        public static let id: Swift.String = "git/create-commit"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.GitCreateCommit.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateCommit.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateCommit.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitCreateCommit.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The commit message
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/message`.
                    public var message: Swift.String
                    /// The SHA of the tree object this commit points to
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/tree`.
                    public var tree: Swift.String
                    /// The full SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/parents`.
                    public var parents: [Swift.String]?
                    /// Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/author`.
                    public struct AuthorPayload: Codable, Hashable, Sendable {
                        /// The name of the author (or committer) of the commit
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/author/name`.
                        public var name: Swift.String
                        /// The email of the author (or committer) of the commit
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/author/email`.
                        public var email: Swift.String
                        /// Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/author/date`.
                        public var date: Foundation.Date?
                        /// Creates a new `AuthorPayload`.
                        ///
                        /// - Parameters:
                        ///   - name: The name of the author (or committer) of the commit
                        ///   - email: The email of the author (or committer) of the commit
                        ///   - date: Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        public init(
                            name: Swift.String,
                            email: Swift.String,
                            date: Foundation.Date? = nil
                        ) {
                            self.name = name
                            self.email = email
                            self.date = date
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                            case email
                            case date
                        }
                    }
                    /// Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/author`.
                    public var author: Operations.GitCreateCommit.Input.Body.JsonPayload.AuthorPayload?
                    /// Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/committer`.
                    public struct CommitterPayload: Codable, Hashable, Sendable {
                        /// The name of the author (or committer) of the commit
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/committer/name`.
                        public var name: Swift.String?
                        /// The email of the author (or committer) of the commit
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/committer/email`.
                        public var email: Swift.String?
                        /// Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/committer/date`.
                        public var date: Foundation.Date?
                        /// Creates a new `CommitterPayload`.
                        ///
                        /// - Parameters:
                        ///   - name: The name of the author (or committer) of the commit
                        ///   - email: The email of the author (or committer) of the commit
                        ///   - date: Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        public init(
                            name: Swift.String? = nil,
                            email: Swift.String? = nil,
                            date: Foundation.Date? = nil
                        ) {
                            self.name = name
                            self.email = email
                            self.date = date
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                            case email
                            case date
                        }
                    }
                    /// Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/committer`.
                    public var committer: Operations.GitCreateCommit.Input.Body.JsonPayload.CommitterPayload?
                    /// The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/json/signature`.
                    public var signature: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - message: The commit message
                    ///   - tree: The SHA of the tree object this commit points to
                    ///   - parents: The full SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
                    ///   - author: Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
                    ///   - committer: Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
                    ///   - signature: The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
                    public init(
                        message: Swift.String,
                        tree: Swift.String,
                        parents: [Swift.String]? = nil,
                        author: Operations.GitCreateCommit.Input.Body.JsonPayload.AuthorPayload? = nil,
                        committer: Operations.GitCreateCommit.Input.Body.JsonPayload.CommitterPayload? = nil,
                        signature: Swift.String? = nil
                    ) {
                        self.message = message
                        self.tree = tree
                        self.parents = parents
                        self.author = author
                        self.committer = committer
                        self.signature = signature
                    }
                    public enum CodingKeys: String, CodingKey {
                        case message
                        case tree
                        case parents
                        case author
                        case committer
                        case signature
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/requestBody/content/application\/json`.
                case json(Operations.GitCreateCommit.Input.Body.JsonPayload)
            }
            public var body: Operations.GitCreateCommit.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitCreateCommit.Input.Path,
                headers: Operations.GitCreateCommit.Input.Headers = .init(),
                body: Operations.GitCreateCommit.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitCreateCommit.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GitCommit)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitCommit {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateCommit.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitCreateCommit.Output.Created.Headers = .init(),
                    body: Operations.GitCreateCommit.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GitCreateCommit.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GitCreateCommit.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/post(git/create-commit)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a commit object
    ///
    /// Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).
    ///
    /// To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/commits/{commit_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)`.
    public enum GitGetCommit {
        public static let id: Swift.String = "git/get-commit"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The SHA of the commit.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/path/commit_sha`.
                public var commitSha: Components.Parameters.CommitSha
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - commitSha: The SHA of the commit.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    commitSha: Components.Parameters.CommitSha
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.commitSha = commitSha
                }
            }
            public var path: Operations.GitGetCommit.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetCommit.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetCommit.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitGetCommit.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitGetCommit.Input.Path,
                headers: Operations.GitGetCommit.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/commits/{commit_sha}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GitCommit)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitCommit {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitGetCommit.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitGetCommit.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitGetCommit.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitGetCommit.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/commits/{commit_sha}/get(git/get-commit)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List matching references
    ///
    /// Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
    ///
    /// When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/matching-refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/matching-refs/{ref}/get(git/list-matching-refs)`.
    public enum GitListMatchingRefs {
        public static let id: Swift.String = "git/list-matching-refs"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/path/ref`.
                public var ref: Components.Parameters.GitRefOnly
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.GitRefOnly
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.GitListMatchingRefs.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitListMatchingRefs.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitListMatchingRefs.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitListMatchingRefs.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitListMatchingRefs.Input.Path,
                headers: Operations.GitListMatchingRefs.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitListMatchingRefs.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/matching-refs/{ref}/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GitRef])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GitRef] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitListMatchingRefs.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitListMatchingRefs.Output.Ok.Headers = .init(),
                    body: Operations.GitListMatchingRefs.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/matching-refs/{ref}/get(git/list-matching-refs)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitListMatchingRefs.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitListMatchingRefs.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/matching-refs/{ref}/get(git/list-matching-refs)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a reference
    ///
    /// Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
    ///
    /// > [!NOTE]
    /// > You need to explicitly [request a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/ref/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)`.
    public enum GitGetRef {
        public static let id: Swift.String = "git/get-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/path/ref`.
                public var ref: Components.Parameters.GitRefOnly
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.GitRefOnly
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.GitGetRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitGetRef.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitGetRef.Input.Path,
                headers: Operations.GitGetRef.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/ref/{ref}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GitRef)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitRef {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitGetRef.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitGetRef.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitGetRef.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitGetRef.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/ref/{ref}/get(git/get-ref)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a reference
    ///
    /// Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/refs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)`.
    public enum GitCreateRef {
        public static let id: Swift.String = "git/create-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.GitCreateRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitCreateRef.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/requestBody/json/ref`.
                    public var ref: Swift.String
                    /// The SHA1 value for this reference.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/requestBody/json/sha`.
                    public var sha: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - ref: The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
                    ///   - sha: The SHA1 value for this reference.
                    public init(
                        ref: Swift.String,
                        sha: Swift.String
                    ) {
                        self.ref = ref
                        self.sha = sha
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ref
                        case sha
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/requestBody/content/application\/json`.
                case json(Operations.GitCreateRef.Input.Body.JsonPayload)
            }
            public var body: Operations.GitCreateRef.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitCreateRef.Input.Path,
                headers: Operations.GitCreateRef.Input.Headers = .init(),
                body: Operations.GitCreateRef.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitCreateRef.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GitRef)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitRef {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateRef.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitCreateRef.Output.Created.Headers = .init(),
                    body: Operations.GitCreateRef.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GitCreateRef.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GitCreateRef.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/post(git/create-ref)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a reference
    ///
    /// Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)`.
    public enum GitUpdateRef {
        public static let id: Swift.String = "git/update-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/path/ref`.
                public var ref: Components.Parameters.GitRefOnly
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.GitRefOnly
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.GitUpdateRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitUpdateRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitUpdateRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitUpdateRef.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The SHA1 value to set this reference to
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/requestBody/json/sha`.
                    public var sha: Swift.String
                    /// Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/requestBody/json/force`.
                    public var force: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - sha: The SHA1 value to set this reference to
                    ///   - force: Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
                    public init(
                        sha: Swift.String,
                        force: Swift.Bool? = nil
                    ) {
                        self.sha = sha
                        self.force = force
                    }
                    public enum CodingKeys: String, CodingKey {
                        case sha
                        case force
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/requestBody/content/application\/json`.
                case json(Operations.GitUpdateRef.Input.Body.JsonPayload)
            }
            public var body: Operations.GitUpdateRef.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitUpdateRef.Input.Path,
                headers: Operations.GitUpdateRef.Input.Headers = .init(),
                body: Operations.GitUpdateRef.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.GitRef)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitRef {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitUpdateRef.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitUpdateRef.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitUpdateRef.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitUpdateRef.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/patch(git/update-ref)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a reference
    ///
    /// Deletes the provided reference.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/git/refs/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)`.
    public enum GitDeleteRef {
        public static let id: Swift.String = "git/delete-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/DELETE/path/ref`.
                public var ref: Components.Parameters.GitRefOnly
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The Git reference. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.GitRefOnly
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.GitDeleteRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/refs/{ref}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitDeleteRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitDeleteRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitDeleteRef.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitDeleteRef.Input.Path,
                headers: Operations.GitDeleteRef.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GitDeleteRef.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GitDeleteRef.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Validation failed, an attempt was made to delete the default branch, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.GitDeleteRef.Output.UnprocessableContent)
            /// Validation failed, an attempt was made to delete the default branch, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.GitDeleteRef.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/refs/{ref}/delete(git/delete-ref)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a tag object
    ///
    /// Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/tags`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)`.
    public enum GitCreateTag {
        public static let id: Swift.String = "git/create-tag"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.GitCreateTag.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateTag.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateTag.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitCreateTag.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The tag's name. This is typically a version (e.g., "v0.0.1").
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tag`.
                    public var tag: Swift.String
                    /// The tag message.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/message`.
                    public var message: Swift.String
                    /// The SHA of the git object this is tagging.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/object`.
                    public var object: Swift.String
                    /// The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/type`.
                    @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case commit = "commit"
                        case tree = "tree"
                        case blob = "blob"
                    }
                    /// The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/type`.
                    public var _type: Operations.GitCreateTag.Input.Body.JsonPayload._TypePayload
                    /// An object with information about the individual creating the tag.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tagger`.
                    public struct TaggerPayload: Codable, Hashable, Sendable {
                        /// The name of the author of the tag
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tagger/name`.
                        public var name: Swift.String
                        /// The email of the author of the tag
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tagger/email`.
                        public var email: Swift.String
                        /// When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tagger/date`.
                        public var date: Foundation.Date?
                        /// Creates a new `TaggerPayload`.
                        ///
                        /// - Parameters:
                        ///   - name: The name of the author of the tag
                        ///   - email: The email of the author of the tag
                        ///   - date: When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                        public init(
                            name: Swift.String,
                            email: Swift.String,
                            date: Foundation.Date? = nil
                        ) {
                            self.name = name
                            self.email = email
                            self.date = date
                        }
                        public enum CodingKeys: String, CodingKey {
                            case name
                            case email
                            case date
                        }
                    }
                    /// An object with information about the individual creating the tag.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/json/tagger`.
                    public var tagger: Operations.GitCreateTag.Input.Body.JsonPayload.TaggerPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - tag: The tag's name. This is typically a version (e.g., "v0.0.1").
                    ///   - message: The tag message.
                    ///   - object: The SHA of the git object this is tagging.
                    ///   - _type: The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
                    ///   - tagger: An object with information about the individual creating the tag.
                    public init(
                        tag: Swift.String,
                        message: Swift.String,
                        object: Swift.String,
                        _type: Operations.GitCreateTag.Input.Body.JsonPayload._TypePayload,
                        tagger: Operations.GitCreateTag.Input.Body.JsonPayload.TaggerPayload? = nil
                    ) {
                        self.tag = tag
                        self.message = message
                        self.object = object
                        self._type = _type
                        self.tagger = tagger
                    }
                    public enum CodingKeys: String, CodingKey {
                        case tag
                        case message
                        case object
                        case _type = "type"
                        case tagger
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/requestBody/content/application\/json`.
                case json(Operations.GitCreateTag.Input.Body.JsonPayload)
            }
            public var body: Operations.GitCreateTag.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitCreateTag.Input.Path,
                headers: Operations.GitCreateTag.Input.Headers = .init(),
                body: Operations.GitCreateTag.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitCreateTag.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GitTag)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitTag {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateTag.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitCreateTag.Output.Created.Headers = .init(),
                    body: Operations.GitCreateTag.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GitCreateTag.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GitCreateTag.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/post(git/create-tag)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a tag
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/tags/{tag_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)`.
    public enum GitGetTag {
        public static let id: Swift.String = "git/get-tag"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/path/tag_sha`.
                public var tagSha: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - tagSha:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    tagSha: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.tagSha = tagSha
                }
            }
            public var path: Operations.GitGetTag.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetTag.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetTag.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitGetTag.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GitGetTag.Input.Path,
                headers: Operations.GitGetTag.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/tags/{tag_sha}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GitTag)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitTag {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitGetTag.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitGetTag.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitGetTag.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitGetTag.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/tags/{tag_sha}/get(git/get-tag)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a tree
    ///
    /// The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
    ///
    /// If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/git/refs#update-a-reference)."
    ///
    /// Returns an error if you try to delete a file that does not exist.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/git/trees`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)`.
    public enum GitCreateTree {
        public static let id: Swift.String = "git/create-tree"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.GitCreateTree.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateTree.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitCreateTree.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitCreateTree.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload`.
                    public struct TreePayloadPayload: Codable, Hashable, Sendable {
                        /// The file referenced in the tree.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/path`.
                        public var path: Swift.String?
                        /// The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/mode`.
                        @frozen public enum ModePayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case _100644 = "100644"
                            case _100755 = "100755"
                            case _040000 = "040000"
                            case _160000 = "160000"
                            case _120000 = "120000"
                        }
                        /// The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/mode`.
                        public var mode: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayloadPayload.ModePayload?
                        /// Either `blob`, `tree`, or `commit`.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/type`.
                        @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case blob = "blob"
                            case tree = "tree"
                            case commit = "commit"
                        }
                        /// Either `blob`, `tree`, or `commit`.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/type`.
                        public var _type: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayloadPayload._TypePayload?
                        /// The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.  
                        ///   
                        /// **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/sha`.
                        public var sha: Swift.String?
                        /// The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.  
                        ///   
                        /// **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/TreePayload/content`.
                        public var content: Swift.String?
                        /// Creates a new `TreePayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - path: The file referenced in the tree.
                        ///   - mode: The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
                        ///   - _type: Either `blob`, `tree`, or `commit`.
                        ///   - sha: The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.  
                        ///   - content: The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.  
                        public init(
                            path: Swift.String? = nil,
                            mode: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayloadPayload.ModePayload? = nil,
                            _type: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayloadPayload._TypePayload? = nil,
                            sha: Swift.String? = nil,
                            content: Swift.String? = nil
                        ) {
                            self.path = path
                            self.mode = mode
                            self._type = _type
                            self.sha = sha
                            self.content = content
                        }
                        public enum CodingKeys: String, CodingKey {
                            case path
                            case mode
                            case _type = "type"
                            case sha
                            case content
                        }
                    }
                    /// Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/tree`.
                    public typealias TreePayload = [Operations.GitCreateTree.Input.Body.JsonPayload.TreePayloadPayload]
                    /// Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/tree`.
                    public var tree: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayload
                    /// The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you're creating new changes on a branch, then normally you'd set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you're working on.
                    /// If not provided, GitHub will create a new Git tree object from only the entries defined in the `tree` parameter. If you create a new commit pointing to such a tree, then all files which were a part of the parent commit's tree and were not defined in the `tree` parameter will be listed as deleted by the new commit.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/json/base_tree`.
                    public var baseTree: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - tree: Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
                    ///   - baseTree: The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you're creating new changes on a branch, then normally you'd set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you're working on.
                    public init(
                        tree: Operations.GitCreateTree.Input.Body.JsonPayload.TreePayload,
                        baseTree: Swift.String? = nil
                    ) {
                        self.tree = tree
                        self.baseTree = baseTree
                    }
                    public enum CodingKeys: String, CodingKey {
                        case tree
                        case baseTree = "base_tree"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/requestBody/content/application\/json`.
                case json(Operations.GitCreateTree.Input.Body.JsonPayload)
            }
            public var body: Operations.GitCreateTree.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GitCreateTree.Input.Path,
                headers: Operations.GitCreateTree.Input.Headers = .init(),
                body: Operations.GitCreateTree.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GitCreateTree.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GitTree)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitTree {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitCreateTree.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GitCreateTree.Output.Created.Headers = .init(),
                    body: Operations.GitCreateTree.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GitCreateTree.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GitCreateTree.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/post(git/create-tree)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a tree
    ///
    /// Returns a single tree using the SHA1 value or ref name for that tree.
    ///
    /// If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
    ///
    /// > [!NOTE]
    /// > The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/git/trees/{tree_sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)`.
    public enum GitGetTree {
        public static let id: Swift.String = "git/get-tree"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The SHA1 value or ref (branch or tag) name of the tree.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/path/tree_sha`.
                public var treeSha: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - treeSha: The SHA1 value or ref (branch or tag) name of the tree.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    treeSha: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.treeSha = treeSha
                }
            }
            public var path: Operations.GitGetTree.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `"true"`, and `"false"`. Omit this parameter to prevent recursively returning objects or subtrees.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/query/recursive`.
                public var recursive: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - recursive: Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `"true"`, and `"false"`. Omit this parameter to prevent recursively returning objects or subtrees.
                public init(recursive: Swift.String? = nil) {
                    self.recursive = recursive
                }
            }
            public var query: Operations.GitGetTree.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetTree.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GitGetTree.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GitGetTree.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.GitGetTree.Input.Path,
                query: Operations.GitGetTree.Input.Query = .init(),
                headers: Operations.GitGetTree.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/git/trees/{tree_sha}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GitTree)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GitTree {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GitGetTree.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GitGetTree.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GitGetTree.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GitGetTree.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/git/trees/{tree_sha}/get(git/get-tree)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
