// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List gists for the authenticated user
    ///
    /// Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
    ///
    /// - Remark: HTTP `GET /gists`.
    /// - Remark: Generated from `#/paths//gists/get(gists/list)`.
    func gistsList(_ input: Operations.GistsList.Input) async throws -> Operations.GistsList.Output
    /// Create a gist
    ///
    /// Allows you to add a new gist with one or more files.
    ///
    /// > [!NOTE]
    /// > Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
    ///
    /// - Remark: HTTP `POST /gists`.
    /// - Remark: Generated from `#/paths//gists/post(gists/create)`.
    func gistsCreate(_ input: Operations.GistsCreate.Input) async throws -> Operations.GistsCreate.Output
    /// List public gists
    ///
    /// List public gists sorted by most recently updated to least recently updated.
    ///
    /// Note: With [pagination](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
    ///
    /// - Remark: HTTP `GET /gists/public`.
    /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)`.
    func gistsListPublic(_ input: Operations.GistsListPublic.Input) async throws -> Operations.GistsListPublic.Output
    /// List starred gists
    ///
    /// List the authenticated user's starred gists:
    ///
    /// - Remark: HTTP `GET /gists/starred`.
    /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)`.
    func gistsListStarred(_ input: Operations.GistsListStarred.Input) async throws -> Operations.GistsListStarred.Output
    /// Get a gist
    ///
    /// Gets a specified gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)`.
    func gistsGet(_ input: Operations.GistsGet.Input) async throws -> Operations.GistsGet.Output
    /// Update a gist
    ///
    /// Allows you to update a gist's description and to update, delete, or rename gist files. Files
    /// from the previous version of the gist that aren't explicitly changed during an edit
    /// are unchanged.
    ///
    /// At least one of `description` or `files` is required.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)`.
    func gistsUpdate(_ input: Operations.GistsUpdate.Input) async throws -> Operations.GistsUpdate.Output
    /// Delete a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)`.
    func gistsDelete(_ input: Operations.GistsDelete.Input) async throws -> Operations.GistsDelete.Output
    /// List gist comments
    ///
    /// Lists the comments on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)`.
    func gistsListComments(_ input: Operations.GistsListComments.Input) async throws -> Operations.GistsListComments.Output
    /// Create a gist comment
    ///
    /// Creates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)`.
    func gistsCreateComment(_ input: Operations.GistsCreateComment.Input) async throws -> Operations.GistsCreateComment.Output
    /// Get a gist comment
    ///
    /// Gets a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)`.
    func gistsGetComment(_ input: Operations.GistsGetComment.Input) async throws -> Operations.GistsGetComment.Output
    /// Update a gist comment
    ///
    /// Updates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/patch(gists/update-comment)`.
    func gistsUpdateComment(_ input: Operations.GistsUpdateComment.Input) async throws -> Operations.GistsUpdateComment.Output
    /// Delete a gist comment
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)`.
    func gistsDeleteComment(_ input: Operations.GistsDeleteComment.Input) async throws -> Operations.GistsDeleteComment.Output
    /// List gist commits
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/commits`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)`.
    func gistsListCommits(_ input: Operations.GistsListCommits.Input) async throws -> Operations.GistsListCommits.Output
    /// List gist forks
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)`.
    func gistsListForks(_ input: Operations.GistsListForks.Input) async throws -> Operations.GistsListForks.Output
    /// Fork a gist
    ///
    ///
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)`.
    func gistsFork(_ input: Operations.GistsFork.Input) async throws -> Operations.GistsFork.Output
    /// Check if a gist is starred
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)`.
    func gistsCheckIsStarred(_ input: Operations.GistsCheckIsStarred.Input) async throws -> Operations.GistsCheckIsStarred.Output
    /// Star a gist
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)`.
    func gistsStar(_ input: Operations.GistsStar.Input) async throws -> Operations.GistsStar.Output
    /// Unstar a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)`.
    func gistsUnstar(_ input: Operations.GistsUnstar.Input) async throws -> Operations.GistsUnstar.Output
    /// Get a gist revision
    ///
    /// Gets a specified gist revision.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/{sha}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)`.
    func gistsGetRevision(_ input: Operations.GistsGetRevision.Input) async throws -> Operations.GistsGetRevision.Output
    /// List gists for a user
    ///
    /// Lists public gists for the specified user:
    ///
    /// - Remark: HTTP `GET /users/{username}/gists`.
    /// - Remark: Generated from `#/paths//users/{username}/gists/get(gists/list-for-user)`.
    func gistsListForUser(_ input: Operations.GistsListForUser.Input) async throws -> Operations.GistsListForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List gists for the authenticated user
    ///
    /// Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
    ///
    /// - Remark: HTTP `GET /gists`.
    /// - Remark: Generated from `#/paths//gists/get(gists/list)`.
    public func gistsList(
        query: Operations.GistsList.Input.Query = .init(),
        headers: Operations.GistsList.Input.Headers = .init()
    ) async throws -> Operations.GistsList.Output {
        try await gistsList(Operations.GistsList.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a gist
    ///
    /// Allows you to add a new gist with one or more files.
    ///
    /// > [!NOTE]
    /// > Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
    ///
    /// - Remark: HTTP `POST /gists`.
    /// - Remark: Generated from `#/paths//gists/post(gists/create)`.
    public func gistsCreate(
        headers: Operations.GistsCreate.Input.Headers = .init(),
        body: Operations.GistsCreate.Input.Body
    ) async throws -> Operations.GistsCreate.Output {
        try await gistsCreate(Operations.GistsCreate.Input(
            headers: headers,
            body: body
        ))
    }
    /// List public gists
    ///
    /// List public gists sorted by most recently updated to least recently updated.
    ///
    /// Note: With [pagination](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
    ///
    /// - Remark: HTTP `GET /gists/public`.
    /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)`.
    public func gistsListPublic(
        query: Operations.GistsListPublic.Input.Query = .init(),
        headers: Operations.GistsListPublic.Input.Headers = .init()
    ) async throws -> Operations.GistsListPublic.Output {
        try await gistsListPublic(Operations.GistsListPublic.Input(
            query: query,
            headers: headers
        ))
    }
    /// List starred gists
    ///
    /// List the authenticated user's starred gists:
    ///
    /// - Remark: HTTP `GET /gists/starred`.
    /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)`.
    public func gistsListStarred(
        query: Operations.GistsListStarred.Input.Query = .init(),
        headers: Operations.GistsListStarred.Input.Headers = .init()
    ) async throws -> Operations.GistsListStarred.Output {
        try await gistsListStarred(Operations.GistsListStarred.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a gist
    ///
    /// Gets a specified gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)`.
    public func gistsGet(
        path: Operations.GistsGet.Input.Path,
        headers: Operations.GistsGet.Input.Headers = .init()
    ) async throws -> Operations.GistsGet.Output {
        try await gistsGet(Operations.GistsGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a gist
    ///
    /// Allows you to update a gist's description and to update, delete, or rename gist files. Files
    /// from the previous version of the gist that aren't explicitly changed during an edit
    /// are unchanged.
    ///
    /// At least one of `description` or `files` is required.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)`.
    public func gistsUpdate(
        path: Operations.GistsUpdate.Input.Path,
        headers: Operations.GistsUpdate.Input.Headers = .init(),
        body: Operations.GistsUpdate.Input.Body
    ) async throws -> Operations.GistsUpdate.Output {
        try await gistsUpdate(Operations.GistsUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)`.
    public func gistsDelete(
        path: Operations.GistsDelete.Input.Path,
        headers: Operations.GistsDelete.Input.Headers = .init()
    ) async throws -> Operations.GistsDelete.Output {
        try await gistsDelete(Operations.GistsDelete.Input(
            path: path,
            headers: headers
        ))
    }
    /// List gist comments
    ///
    /// Lists the comments on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)`.
    public func gistsListComments(
        path: Operations.GistsListComments.Input.Path,
        query: Operations.GistsListComments.Input.Query = .init(),
        headers: Operations.GistsListComments.Input.Headers = .init()
    ) async throws -> Operations.GistsListComments.Output {
        try await gistsListComments(Operations.GistsListComments.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a gist comment
    ///
    /// Creates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)`.
    public func gistsCreateComment(
        path: Operations.GistsCreateComment.Input.Path,
        headers: Operations.GistsCreateComment.Input.Headers = .init(),
        body: Operations.GistsCreateComment.Input.Body
    ) async throws -> Operations.GistsCreateComment.Output {
        try await gistsCreateComment(Operations.GistsCreateComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a gist comment
    ///
    /// Gets a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)`.
    public func gistsGetComment(
        path: Operations.GistsGetComment.Input.Path,
        headers: Operations.GistsGetComment.Input.Headers = .init()
    ) async throws -> Operations.GistsGetComment.Output {
        try await gistsGetComment(Operations.GistsGetComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a gist comment
    ///
    /// Updates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/patch(gists/update-comment)`.
    public func gistsUpdateComment(
        path: Operations.GistsUpdateComment.Input.Path,
        headers: Operations.GistsUpdateComment.Input.Headers = .init(),
        body: Operations.GistsUpdateComment.Input.Body
    ) async throws -> Operations.GistsUpdateComment.Output {
        try await gistsUpdateComment(Operations.GistsUpdateComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a gist comment
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)`.
    public func gistsDeleteComment(
        path: Operations.GistsDeleteComment.Input.Path,
        headers: Operations.GistsDeleteComment.Input.Headers = .init()
    ) async throws -> Operations.GistsDeleteComment.Output {
        try await gistsDeleteComment(Operations.GistsDeleteComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// List gist commits
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/commits`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)`.
    public func gistsListCommits(
        path: Operations.GistsListCommits.Input.Path,
        query: Operations.GistsListCommits.Input.Query = .init(),
        headers: Operations.GistsListCommits.Input.Headers = .init()
    ) async throws -> Operations.GistsListCommits.Output {
        try await gistsListCommits(Operations.GistsListCommits.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List gist forks
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)`.
    public func gistsListForks(
        path: Operations.GistsListForks.Input.Path,
        query: Operations.GistsListForks.Input.Query = .init(),
        headers: Operations.GistsListForks.Input.Headers = .init()
    ) async throws -> Operations.GistsListForks.Output {
        try await gistsListForks(Operations.GistsListForks.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Fork a gist
    ///
    ///
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)`.
    public func gistsFork(
        path: Operations.GistsFork.Input.Path,
        headers: Operations.GistsFork.Input.Headers = .init()
    ) async throws -> Operations.GistsFork.Output {
        try await gistsFork(Operations.GistsFork.Input(
            path: path,
            headers: headers
        ))
    }
    /// Check if a gist is starred
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)`.
    public func gistsCheckIsStarred(
        path: Operations.GistsCheckIsStarred.Input.Path,
        headers: Operations.GistsCheckIsStarred.Input.Headers = .init()
    ) async throws -> Operations.GistsCheckIsStarred.Output {
        try await gistsCheckIsStarred(Operations.GistsCheckIsStarred.Input(
            path: path,
            headers: headers
        ))
    }
    /// Star a gist
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)`.
    public func gistsStar(
        path: Operations.GistsStar.Input.Path,
        headers: Operations.GistsStar.Input.Headers = .init()
    ) async throws -> Operations.GistsStar.Output {
        try await gistsStar(Operations.GistsStar.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unstar a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)`.
    public func gistsUnstar(
        path: Operations.GistsUnstar.Input.Path,
        headers: Operations.GistsUnstar.Input.Headers = .init()
    ) async throws -> Operations.GistsUnstar.Output {
        try await gistsUnstar(Operations.GistsUnstar.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a gist revision
    ///
    /// Gets a specified gist revision.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/{sha}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)`.
    public func gistsGetRevision(
        path: Operations.GistsGetRevision.Input.Path,
        headers: Operations.GistsGetRevision.Input.Headers = .init()
    ) async throws -> Operations.GistsGetRevision.Output {
        try await gistsGetRevision(Operations.GistsGetRevision.Input(
            path: path,
            headers: headers
        ))
    }
    /// List gists for a user
    ///
    /// Lists public gists for the specified user:
    ///
    /// - Remark: HTTP `GET /users/{username}/gists`.
    /// - Remark: Generated from `#/paths//users/{username}/gists/get(gists/list-for-user)`.
    public func gistsListForUser(
        path: Operations.GistsListForUser.Input.Path,
        query: Operations.GistsListForUser.Input.Query = .init(),
        headers: Operations.GistsListForUser.Input.Headers = .init()
    ) async throws -> Operations.GistsListForUser.Output {
        try await gistsListForUser(Operations.GistsListForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// Base Gist
        ///
        /// - Remark: Generated from `#/components/schemas/base-gist`.
        public struct BaseGist: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/base-gist/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/git_pull_url`.
            public var gitPullUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/git_push_url`.
            public var gitPushUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/files`.
            public struct FilesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties`.
                public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/filename`.
                    public var filename: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/type`.
                    public var _type: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/language`.
                    public var language: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/raw_url`.
                    public var rawUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/size`.
                    public var size: Swift.Int?
                    /// The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    ///
                    /// - Remark: Generated from `#/components/schemas/base-gist/files/additionalProperties/encoding`.
                    public var encoding: Swift.String?
                    /// Creates a new `AdditionalPropertiesPayload`.
                    ///
                    /// - Parameters:
                    ///   - filename:
                    ///   - _type:
                    ///   - language:
                    ///   - rawUrl:
                    ///   - size:
                    ///   - encoding: The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    public init(
                        filename: Swift.String? = nil,
                        _type: Swift.String? = nil,
                        language: Swift.String? = nil,
                        rawUrl: Swift.String? = nil,
                        size: Swift.Int? = nil,
                        encoding: Swift.String? = nil
                    ) {
                        self.filename = filename
                        self._type = _type
                        self.language = language
                        self.rawUrl = rawUrl
                        self.size = size
                        self.encoding = encoding
                    }
                    public enum CodingKeys: String, CodingKey {
                        case filename
                        case _type = "type"
                        case language
                        case rawUrl = "raw_url"
                        case size
                        case encoding
                    }
                }
                /// A container of undocumented properties.
                public var additionalProperties: [String: Components.Schemas.BaseGist.FilesPayload.AdditionalPropertiesPayload]
                /// Creates a new `FilesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Components.Schemas.BaseGist.FilesPayload.AdditionalPropertiesPayload] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// - Remark: Generated from `#/components/schemas/base-gist/files`.
            public var files: Components.Schemas.BaseGist.FilesPayload
            /// - Remark: Generated from `#/components/schemas/base-gist/public`.
            public var _public: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/base-gist/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/base-gist/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/base-gist/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/base-gist/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/base-gist/comments_enabled`.
            public var commentsEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/base-gist/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/base-gist/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/base-gist/owner`.
            public var owner: Components.Schemas.SimpleUser?
            /// - Remark: Generated from `#/components/schemas/base-gist/truncated`.
            public var truncated: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/base-gist/forks`.
            public var forks: [OpenAPIRuntime.OpenAPIValueContainer]?
            /// - Remark: Generated from `#/components/schemas/base-gist/history`.
            public var history: [OpenAPIRuntime.OpenAPIValueContainer]?
            /// Creates a new `BaseGist`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - forksUrl:
            ///   - commitsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - gitPullUrl:
            ///   - gitPushUrl:
            ///   - htmlUrl:
            ///   - files:
            ///   - _public:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - description:
            ///   - comments:
            ///   - commentsEnabled:
            ///   - user:
            ///   - commentsUrl:
            ///   - owner:
            ///   - truncated:
            ///   - forks:
            ///   - history:
            public init(
                url: Swift.String,
                forksUrl: Swift.String,
                commitsUrl: Swift.String,
                id: Swift.String,
                nodeId: Swift.String,
                gitPullUrl: Swift.String,
                gitPushUrl: Swift.String,
                htmlUrl: Swift.String,
                files: Components.Schemas.BaseGist.FilesPayload,
                _public: Swift.Bool,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                description: Swift.String? = nil,
                comments: Swift.Int,
                commentsEnabled: Swift.Bool? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                commentsUrl: Swift.String,
                owner: Components.Schemas.SimpleUser? = nil,
                truncated: Swift.Bool? = nil,
                forks: [OpenAPIRuntime.OpenAPIValueContainer]? = nil,
                history: [OpenAPIRuntime.OpenAPIValueContainer]? = nil
            ) {
                self.url = url
                self.forksUrl = forksUrl
                self.commitsUrl = commitsUrl
                self.id = id
                self.nodeId = nodeId
                self.gitPullUrl = gitPullUrl
                self.gitPushUrl = gitPushUrl
                self.htmlUrl = htmlUrl
                self.files = files
                self._public = _public
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.description = description
                self.comments = comments
                self.commentsEnabled = commentsEnabled
                self.user = user
                self.commentsUrl = commentsUrl
                self.owner = owner
                self.truncated = truncated
                self.forks = forks
                self.history = history
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case forksUrl = "forks_url"
                case commitsUrl = "commits_url"
                case id
                case nodeId = "node_id"
                case gitPullUrl = "git_pull_url"
                case gitPushUrl = "git_push_url"
                case htmlUrl = "html_url"
                case files
                case _public = "public"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case description
                case comments
                case commentsEnabled = "comments_enabled"
                case user
                case commentsUrl = "comments_url"
                case owner
                case truncated
                case forks
                case history
            }
        }
        /// Public User
        ///
        /// - Remark: Generated from `#/components/schemas/public-user`.
        public struct PublicUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/public-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/public-user/user_view_type`.
            public var userViewType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/public-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/notification_email`.
            public var notificationEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/hireable`.
            public var hireable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/public-user/bio`.
            public var bio: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/twitter_username`.
            public var twitterUsername: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/public_repos`.
            public var publicRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/public_gists`.
            public var publicGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/followers`.
            public var followers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/following`.
            public var following: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/public-user/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/public-user/plan`.
            public struct PlanPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/public-user/plan/collaborators`.
                public var collaborators: Swift.Int
                /// - Remark: Generated from `#/components/schemas/public-user/plan/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/public-user/plan/space`.
                public var space: Swift.Int
                /// - Remark: Generated from `#/components/schemas/public-user/plan/private_repos`.
                public var privateRepos: Swift.Int
                /// Creates a new `PlanPayload`.
                ///
                /// - Parameters:
                ///   - collaborators:
                ///   - name:
                ///   - space:
                ///   - privateRepos:
                public init(
                    collaborators: Swift.Int,
                    name: Swift.String,
                    space: Swift.Int,
                    privateRepos: Swift.Int
                ) {
                    self.collaborators = collaborators
                    self.name = name
                    self.space = space
                    self.privateRepos = privateRepos
                }
                public enum CodingKeys: String, CodingKey {
                    case collaborators
                    case name
                    case space
                    case privateRepos = "private_repos"
                }
            }
            /// - Remark: Generated from `#/components/schemas/public-user/plan`.
            public var plan: Components.Schemas.PublicUser.PlanPayload?
            /// - Remark: Generated from `#/components/schemas/public-user/private_gists`.
            public var privateGists: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/total_private_repos`.
            public var totalPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/owned_private_repos`.
            public var ownedPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/disk_usage`.
            public var diskUsage: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/collaborators`.
            public var collaborators: Swift.Int?
            /// Creates a new `PublicUser`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - userViewType:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - name:
            ///   - company:
            ///   - blog:
            ///   - location:
            ///   - email:
            ///   - notificationEmail:
            ///   - hireable:
            ///   - bio:
            ///   - twitterUsername:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - plan:
            ///   - privateGists:
            ///   - totalPrivateRepos:
            ///   - ownedPrivateRepos:
            ///   - diskUsage:
            ///   - collaborators:
            public init(
                login: Swift.String,
                id: Swift.Int64,
                userViewType: Swift.String? = nil,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                name: Swift.String? = nil,
                company: Swift.String? = nil,
                blog: Swift.String? = nil,
                location: Swift.String? = nil,
                email: Swift.String? = nil,
                notificationEmail: Swift.String? = nil,
                hireable: Swift.Bool? = nil,
                bio: Swift.String? = nil,
                twitterUsername: Swift.String? = nil,
                publicRepos: Swift.Int,
                publicGists: Swift.Int,
                followers: Swift.Int,
                following: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                plan: Components.Schemas.PublicUser.PlanPayload? = nil,
                privateGists: Swift.Int? = nil,
                totalPrivateRepos: Swift.Int? = nil,
                ownedPrivateRepos: Swift.Int? = nil,
                diskUsage: Swift.Int? = nil,
                collaborators: Swift.Int? = nil
            ) {
                self.login = login
                self.id = id
                self.userViewType = userViewType
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.name = name
                self.company = company
                self.blog = blog
                self.location = location
                self.email = email
                self.notificationEmail = notificationEmail
                self.hireable = hireable
                self.bio = bio
                self.twitterUsername = twitterUsername
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.plan = plan
                self.privateGists = privateGists
                self.totalPrivateRepos = totalPrivateRepos
                self.ownedPrivateRepos = ownedPrivateRepos
                self.diskUsage = diskUsage
                self.collaborators = collaborators
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case userViewType = "user_view_type"
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case name
                case company
                case blog
                case location
                case email
                case notificationEmail = "notification_email"
                case hireable
                case bio
                case twitterUsername = "twitter_username"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case plan
                case privateGists = "private_gists"
                case totalPrivateRepos = "total_private_repos"
                case ownedPrivateRepos = "owned_private_repos"
                case diskUsage = "disk_usage"
                case collaborators
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.login = try container.decode(
                    Swift.String.self,
                    forKey: .login
                )
                self.id = try container.decode(
                    Swift.Int64.self,
                    forKey: .id
                )
                self.userViewType = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .userViewType
                )
                self.nodeId = try container.decode(
                    Swift.String.self,
                    forKey: .nodeId
                )
                self.avatarUrl = try container.decode(
                    Swift.String.self,
                    forKey: .avatarUrl
                )
                self.gravatarId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .gravatarId
                )
                self.url = try container.decode(
                    Swift.String.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Swift.String.self,
                    forKey: .htmlUrl
                )
                self.followersUrl = try container.decode(
                    Swift.String.self,
                    forKey: .followersUrl
                )
                self.followingUrl = try container.decode(
                    Swift.String.self,
                    forKey: .followingUrl
                )
                self.gistsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .gistsUrl
                )
                self.starredUrl = try container.decode(
                    Swift.String.self,
                    forKey: .starredUrl
                )
                self.subscriptionsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .subscriptionsUrl
                )
                self.organizationsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .organizationsUrl
                )
                self.reposUrl = try container.decode(
                    Swift.String.self,
                    forKey: .reposUrl
                )
                self.eventsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .eventsUrl
                )
                self.receivedEventsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .receivedEventsUrl
                )
                self._type = try container.decode(
                    Swift.String.self,
                    forKey: ._type
                )
                self.siteAdmin = try container.decode(
                    Swift.Bool.self,
                    forKey: .siteAdmin
                )
                self.name = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .name
                )
                self.company = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .company
                )
                self.blog = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .blog
                )
                self.location = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .location
                )
                self.email = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .email
                )
                self.notificationEmail = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .notificationEmail
                )
                self.hireable = try container.decodeIfPresent(
                    Swift.Bool.self,
                    forKey: .hireable
                )
                self.bio = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .bio
                )
                self.twitterUsername = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .twitterUsername
                )
                self.publicRepos = try container.decode(
                    Swift.Int.self,
                    forKey: .publicRepos
                )
                self.publicGists = try container.decode(
                    Swift.Int.self,
                    forKey: .publicGists
                )
                self.followers = try container.decode(
                    Swift.Int.self,
                    forKey: .followers
                )
                self.following = try container.decode(
                    Swift.Int.self,
                    forKey: .following
                )
                self.createdAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.plan = try container.decodeIfPresent(
                    Components.Schemas.PublicUser.PlanPayload.self,
                    forKey: .plan
                )
                self.privateGists = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .privateGists
                )
                self.totalPrivateRepos = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalPrivateRepos
                )
                self.ownedPrivateRepos = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .ownedPrivateRepos
                )
                self.diskUsage = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .diskUsage
                )
                self.collaborators = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .collaborators
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "login",
                    "id",
                    "user_view_type",
                    "node_id",
                    "avatar_url",
                    "gravatar_id",
                    "url",
                    "html_url",
                    "followers_url",
                    "following_url",
                    "gists_url",
                    "starred_url",
                    "subscriptions_url",
                    "organizations_url",
                    "repos_url",
                    "events_url",
                    "received_events_url",
                    "type",
                    "site_admin",
                    "name",
                    "company",
                    "blog",
                    "location",
                    "email",
                    "notification_email",
                    "hireable",
                    "bio",
                    "twitter_username",
                    "public_repos",
                    "public_gists",
                    "followers",
                    "following",
                    "created_at",
                    "updated_at",
                    "plan",
                    "private_gists",
                    "total_private_repos",
                    "owned_private_repos",
                    "disk_usage",
                    "collaborators"
                ])
            }
        }
        /// Gist History
        ///
        /// - Remark: Generated from `#/components/schemas/gist-history`.
        public struct GistHistory: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/gist-history/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/gist-history/version`.
            public var version: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-history/committed_at`.
            public var committedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/gist-history/change_status`.
            public struct ChangeStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gist-history/change_status/total`.
                public var total: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/gist-history/change_status/additions`.
                public var additions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/gist-history/change_status/deletions`.
                public var deletions: Swift.Int?
                /// Creates a new `ChangeStatusPayload`.
                ///
                /// - Parameters:
                ///   - total:
                ///   - additions:
                ///   - deletions:
                public init(
                    total: Swift.Int? = nil,
                    additions: Swift.Int? = nil,
                    deletions: Swift.Int? = nil
                ) {
                    self.total = total
                    self.additions = additions
                    self.deletions = deletions
                }
                public enum CodingKeys: String, CodingKey {
                    case total
                    case additions
                    case deletions
                }
            }
            /// - Remark: Generated from `#/components/schemas/gist-history/change_status`.
            public var changeStatus: Components.Schemas.GistHistory.ChangeStatusPayload?
            /// - Remark: Generated from `#/components/schemas/gist-history/url`.
            public var url: Swift.String?
            /// Creates a new `GistHistory`.
            ///
            /// - Parameters:
            ///   - user:
            ///   - version:
            ///   - committedAt:
            ///   - changeStatus:
            ///   - url:
            public init(
                user: Components.Schemas.NullableSimpleUser? = nil,
                version: Swift.String? = nil,
                committedAt: Foundation.Date? = nil,
                changeStatus: Components.Schemas.GistHistory.ChangeStatusPayload? = nil,
                url: Swift.String? = nil
            ) {
                self.user = user
                self.version = version
                self.committedAt = committedAt
                self.changeStatus = changeStatus
                self.url = url
            }
            public enum CodingKeys: String, CodingKey {
                case user
                case version
                case committedAt = "committed_at"
                case changeStatus = "change_status"
                case url
            }
        }
        /// Gist Simple
        ///
        /// - Remark: Generated from `#/components/schemas/gist-simple`.
        public struct GistSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload`.
            public struct ForksPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload/id`.
                public var id: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload/user`.
                public var user: Components.Schemas.PublicUser?
                /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload/created_at`.
                public var createdAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/gist-simple/ForksPayload/updated_at`.
                public var updatedAt: Foundation.Date?
                /// Creates a new `ForksPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - url:
                ///   - user:
                ///   - createdAt:
                ///   - updatedAt:
                public init(
                    id: Swift.String? = nil,
                    url: Swift.String? = nil,
                    user: Components.Schemas.PublicUser? = nil,
                    createdAt: Foundation.Date? = nil,
                    updatedAt: Foundation.Date? = nil
                ) {
                    self.id = id
                    self.url = url
                    self.user = user
                    self.createdAt = createdAt
                    self.updatedAt = updatedAt
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case url
                    case user
                    case createdAt = "created_at"
                    case updatedAt = "updated_at"
                }
            }
            /// - Remark: Generated from `#/components/schemas/gist-simple/forks`.
            public typealias ForksPayload = [Components.Schemas.GistSimple.ForksPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/gist-simple/forks`.
            @available(*, deprecated)
            public var forks: Components.Schemas.GistSimple.ForksPayload?
            /// - Remark: Generated from `#/components/schemas/gist-simple/history`.
            @available(*, deprecated)
            public var history: [Components.Schemas.GistHistory]?
            /// Gist
            ///
            /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of`.
            public struct ForkOfPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/forks_url`.
                public var forksUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/commits_url`.
                public var commitsUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/id`.
                public var id: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/node_id`.
                public var nodeId: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/git_pull_url`.
                public var gitPullUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/git_push_url`.
                public var gitPushUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/html_url`.
                public var htmlUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files`.
                public struct FilesPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties`.
                    public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties/filename`.
                        public var filename: Swift.String?
                        /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties/type`.
                        public var _type: Swift.String?
                        /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties/language`.
                        public var language: Swift.String?
                        /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties/raw_url`.
                        public var rawUrl: Swift.String?
                        /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files/additionalProperties/size`.
                        public var size: Swift.Int?
                        /// Creates a new `AdditionalPropertiesPayload`.
                        ///
                        /// - Parameters:
                        ///   - filename:
                        ///   - _type:
                        ///   - language:
                        ///   - rawUrl:
                        ///   - size:
                        public init(
                            filename: Swift.String? = nil,
                            _type: Swift.String? = nil,
                            language: Swift.String? = nil,
                            rawUrl: Swift.String? = nil,
                            size: Swift.Int? = nil
                        ) {
                            self.filename = filename
                            self._type = _type
                            self.language = language
                            self.rawUrl = rawUrl
                            self.size = size
                        }
                        public enum CodingKeys: String, CodingKey {
                            case filename
                            case _type = "type"
                            case language
                            case rawUrl = "raw_url"
                            case size
                        }
                    }
                    /// A container of undocumented properties.
                    public var additionalProperties: [String: Components.Schemas.GistSimple.ForkOfPayload.FilesPayload.AdditionalPropertiesPayload]
                    /// Creates a new `FilesPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: [String: Components.Schemas.GistSimple.ForkOfPayload.FilesPayload.AdditionalPropertiesPayload] = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/files`.
                public var files: Components.Schemas.GistSimple.ForkOfPayload.FilesPayload
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/public`.
                public var _public: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/created_at`.
                public var createdAt: Foundation.Date
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/updated_at`.
                public var updatedAt: Foundation.Date
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/description`.
                public var description: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/comments`.
                public var comments: Swift.Int
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/comments_enabled`.
                public var commentsEnabled: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/user`.
                public var user: Components.Schemas.NullableSimpleUser?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/comments_url`.
                public var commentsUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/owner`.
                public var owner: Components.Schemas.NullableSimpleUser?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/truncated`.
                public var truncated: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/forks`.
                public var forks: [OpenAPIRuntime.OpenAPIValueContainer]?
                /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of/history`.
                public var history: [OpenAPIRuntime.OpenAPIValueContainer]?
                /// Creates a new `ForkOfPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - forksUrl:
                ///   - commitsUrl:
                ///   - id:
                ///   - nodeId:
                ///   - gitPullUrl:
                ///   - gitPushUrl:
                ///   - htmlUrl:
                ///   - files:
                ///   - _public:
                ///   - createdAt:
                ///   - updatedAt:
                ///   - description:
                ///   - comments:
                ///   - commentsEnabled:
                ///   - user:
                ///   - commentsUrl:
                ///   - owner:
                ///   - truncated:
                ///   - forks:
                ///   - history:
                public init(
                    url: Swift.String,
                    forksUrl: Swift.String,
                    commitsUrl: Swift.String,
                    id: Swift.String,
                    nodeId: Swift.String,
                    gitPullUrl: Swift.String,
                    gitPushUrl: Swift.String,
                    htmlUrl: Swift.String,
                    files: Components.Schemas.GistSimple.ForkOfPayload.FilesPayload,
                    _public: Swift.Bool,
                    createdAt: Foundation.Date,
                    updatedAt: Foundation.Date,
                    description: Swift.String? = nil,
                    comments: Swift.Int,
                    commentsEnabled: Swift.Bool? = nil,
                    user: Components.Schemas.NullableSimpleUser? = nil,
                    commentsUrl: Swift.String,
                    owner: Components.Schemas.NullableSimpleUser? = nil,
                    truncated: Swift.Bool? = nil,
                    forks: [OpenAPIRuntime.OpenAPIValueContainer]? = nil,
                    history: [OpenAPIRuntime.OpenAPIValueContainer]? = nil
                ) {
                    self.url = url
                    self.forksUrl = forksUrl
                    self.commitsUrl = commitsUrl
                    self.id = id
                    self.nodeId = nodeId
                    self.gitPullUrl = gitPullUrl
                    self.gitPushUrl = gitPushUrl
                    self.htmlUrl = htmlUrl
                    self.files = files
                    self._public = _public
                    self.createdAt = createdAt
                    self.updatedAt = updatedAt
                    self.description = description
                    self.comments = comments
                    self.commentsEnabled = commentsEnabled
                    self.user = user
                    self.commentsUrl = commentsUrl
                    self.owner = owner
                    self.truncated = truncated
                    self.forks = forks
                    self.history = history
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case forksUrl = "forks_url"
                    case commitsUrl = "commits_url"
                    case id
                    case nodeId = "node_id"
                    case gitPullUrl = "git_pull_url"
                    case gitPushUrl = "git_push_url"
                    case htmlUrl = "html_url"
                    case files
                    case _public = "public"
                    case createdAt = "created_at"
                    case updatedAt = "updated_at"
                    case description
                    case comments
                    case commentsEnabled = "comments_enabled"
                    case user
                    case commentsUrl = "comments_url"
                    case owner
                    case truncated
                    case forks
                    case history
                }
            }
            /// Gist
            ///
            /// - Remark: Generated from `#/components/schemas/gist-simple/fork_of`.
            public var forkOf: Components.Schemas.GistSimple.ForkOfPayload?
            /// - Remark: Generated from `#/components/schemas/gist-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/forks_url`.
            public var forksUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/commits_url`.
            public var commitsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/id`.
            public var id: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/git_pull_url`.
            public var gitPullUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/git_push_url`.
            public var gitPushUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/files`.
            public struct FilesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties`.
                public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/filename`.
                    public var filename: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/type`.
                    public var _type: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/language`.
                    public var language: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/raw_url`.
                    public var rawUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/size`.
                    public var size: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/truncated`.
                    public var truncated: Swift.Bool?
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/content`.
                    public var content: Swift.String?
                    /// The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    ///
                    /// - Remark: Generated from `#/components/schemas/gist-simple/files/additionalProperties/encoding`.
                    public var encoding: Swift.String?
                    /// Creates a new `AdditionalPropertiesPayload`.
                    ///
                    /// - Parameters:
                    ///   - filename:
                    ///   - _type:
                    ///   - language:
                    ///   - rawUrl:
                    ///   - size:
                    ///   - truncated:
                    ///   - content:
                    ///   - encoding: The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
                    public init(
                        filename: Swift.String? = nil,
                        _type: Swift.String? = nil,
                        language: Swift.String? = nil,
                        rawUrl: Swift.String? = nil,
                        size: Swift.Int? = nil,
                        truncated: Swift.Bool? = nil,
                        content: Swift.String? = nil,
                        encoding: Swift.String? = nil
                    ) {
                        self.filename = filename
                        self._type = _type
                        self.language = language
                        self.rawUrl = rawUrl
                        self.size = size
                        self.truncated = truncated
                        self.content = content
                        self.encoding = encoding
                    }
                    public enum CodingKeys: String, CodingKey {
                        case filename
                        case _type = "type"
                        case language
                        case rawUrl = "raw_url"
                        case size
                        case truncated
                        case content
                        case encoding
                    }
                }
                /// A container of undocumented properties.
                public var additionalProperties: [String: Components.Schemas.GistSimple.FilesPayload.AdditionalPropertiesPayload?]
                /// Creates a new `FilesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Components.Schemas.GistSimple.FilesPayload.AdditionalPropertiesPayload?] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// - Remark: Generated from `#/components/schemas/gist-simple/files`.
            public var files: Components.Schemas.GistSimple.FilesPayload?
            /// - Remark: Generated from `#/components/schemas/gist-simple/public`.
            public var _public: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/gist-simple/created_at`.
            public var createdAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/updated_at`.
            public var updatedAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/comments`.
            public var comments: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/gist-simple/comments_enabled`.
            public var commentsEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/gist-simple/user`.
            public var user: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/comments_url`.
            public var commentsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gist-simple/owner`.
            public var owner: Components.Schemas.SimpleUser?
            /// - Remark: Generated from `#/components/schemas/gist-simple/truncated`.
            public var truncated: Swift.Bool?
            /// Creates a new `GistSimple`.
            ///
            /// - Parameters:
            ///   - forks:
            ///   - history:
            ///   - forkOf: Gist
            ///   - url:
            ///   - forksUrl:
            ///   - commitsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - gitPullUrl:
            ///   - gitPushUrl:
            ///   - htmlUrl:
            ///   - files:
            ///   - _public:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - description:
            ///   - comments:
            ///   - commentsEnabled:
            ///   - user:
            ///   - commentsUrl:
            ///   - owner:
            ///   - truncated:
            public init(
                forks: Components.Schemas.GistSimple.ForksPayload? = nil,
                history: [Components.Schemas.GistHistory]? = nil,
                forkOf: Components.Schemas.GistSimple.ForkOfPayload? = nil,
                url: Swift.String? = nil,
                forksUrl: Swift.String? = nil,
                commitsUrl: Swift.String? = nil,
                id: Swift.String? = nil,
                nodeId: Swift.String? = nil,
                gitPullUrl: Swift.String? = nil,
                gitPushUrl: Swift.String? = nil,
                htmlUrl: Swift.String? = nil,
                files: Components.Schemas.GistSimple.FilesPayload? = nil,
                _public: Swift.Bool? = nil,
                createdAt: Swift.String? = nil,
                updatedAt: Swift.String? = nil,
                description: Swift.String? = nil,
                comments: Swift.Int? = nil,
                commentsEnabled: Swift.Bool? = nil,
                user: Swift.String? = nil,
                commentsUrl: Swift.String? = nil,
                owner: Components.Schemas.SimpleUser? = nil,
                truncated: Swift.Bool? = nil
            ) {
                self.forks = forks
                self.history = history
                self.forkOf = forkOf
                self.url = url
                self.forksUrl = forksUrl
                self.commitsUrl = commitsUrl
                self.id = id
                self.nodeId = nodeId
                self.gitPullUrl = gitPullUrl
                self.gitPushUrl = gitPushUrl
                self.htmlUrl = htmlUrl
                self.files = files
                self._public = _public
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.description = description
                self.comments = comments
                self.commentsEnabled = commentsEnabled
                self.user = user
                self.commentsUrl = commentsUrl
                self.owner = owner
                self.truncated = truncated
            }
            public enum CodingKeys: String, CodingKey {
                case forks
                case history
                case forkOf = "fork_of"
                case url
                case forksUrl = "forks_url"
                case commitsUrl = "commits_url"
                case id
                case nodeId = "node_id"
                case gitPullUrl = "git_pull_url"
                case gitPushUrl = "git_push_url"
                case htmlUrl = "html_url"
                case files
                case _public = "public"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case description
                case comments
                case commentsEnabled = "comments_enabled"
                case user
                case commentsUrl = "comments_url"
                case owner
                case truncated
            }
        }
        /// A comment made to a gist.
        ///
        /// - Remark: Generated from `#/components/schemas/gist-comment`.
        public struct GistComment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/gist-comment/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/gist-comment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/gist-comment/url`.
            public var url: Swift.String
            /// The comment text.
            ///
            /// - Remark: Generated from `#/components/schemas/gist-comment/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/gist-comment/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/gist-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/gist-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/gist-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// Creates a new `GistComment`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url:
            ///   - body: The comment text.
            ///   - user:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - authorAssociation:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                body: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                authorAssociation: Components.Schemas.AuthorAssociation
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.body = body
                self.user = user
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.authorAssociation = authorAssociation
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case body
                case user
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case authorAssociation = "author_association"
            }
        }
        /// Gist Commit
        ///
        /// - Remark: Generated from `#/components/schemas/gist-commit`.
        public struct GistCommit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/gist-commit/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/gist-commit/version`.
            public var version: Swift.String
            /// - Remark: Generated from `#/components/schemas/gist-commit/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/gist-commit/change_status`.
            public struct ChangeStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gist-commit/change_status/total`.
                public var total: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/gist-commit/change_status/additions`.
                public var additions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/gist-commit/change_status/deletions`.
                public var deletions: Swift.Int?
                /// Creates a new `ChangeStatusPayload`.
                ///
                /// - Parameters:
                ///   - total:
                ///   - additions:
                ///   - deletions:
                public init(
                    total: Swift.Int? = nil,
                    additions: Swift.Int? = nil,
                    deletions: Swift.Int? = nil
                ) {
                    self.total = total
                    self.additions = additions
                    self.deletions = deletions
                }
                public enum CodingKeys: String, CodingKey {
                    case total
                    case additions
                    case deletions
                }
            }
            /// - Remark: Generated from `#/components/schemas/gist-commit/change_status`.
            public var changeStatus: Components.Schemas.GistCommit.ChangeStatusPayload
            /// - Remark: Generated from `#/components/schemas/gist-commit/committed_at`.
            public var committedAt: Foundation.Date
            /// Creates a new `GistCommit`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - version:
            ///   - user:
            ///   - changeStatus:
            ///   - committedAt:
            public init(
                url: Swift.String,
                version: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                changeStatus: Components.Schemas.GistCommit.ChangeStatusPayload,
                committedAt: Foundation.Date
            ) {
                self.url = url
                self.version = version
                self.user = user
                self.changeStatus = changeStatus
                self.committedAt = committedAt
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case version
                case user
                case changeStatus = "change_status"
                case committedAt = "committed_at"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/since`.
        public typealias Since = Foundation.Date
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The unique identifier of the gist.
        ///
        /// - Remark: Generated from `#/components/parameters/gist-id`.
        public typealias GistId = Swift.String
        /// The unique identifier of the comment.
        ///
        /// - Remark: Generated from `#/components/parameters/comment-id`.
        public typealias CommentId = Swift.Int64
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct ForbiddenGist: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden_gist/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/block`.
                    public struct BlockPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/block/reason`.
                        public var reason: Swift.String?
                        /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/block/created_at`.
                        public var createdAt: Swift.String?
                        /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/block/html_url`.
                        public var htmlUrl: Swift.String?
                        /// Creates a new `BlockPayload`.
                        ///
                        /// - Parameters:
                        ///   - reason:
                        ///   - createdAt:
                        ///   - htmlUrl:
                        public init(
                            reason: Swift.String? = nil,
                            createdAt: Swift.String? = nil,
                            htmlUrl: Swift.String? = nil
                        ) {
                            self.reason = reason
                            self.createdAt = createdAt
                            self.htmlUrl = htmlUrl
                        }
                        public enum CodingKeys: String, CodingKey {
                            case reason
                            case createdAt = "created_at"
                            case htmlUrl = "html_url"
                        }
                    }
                    /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/block`.
                    public var block: Components.Responses.ForbiddenGist.Body.JsonPayload.BlockPayload?
                    /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/forbidden_gist/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - block:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        block: Components.Responses.ForbiddenGist.Body.JsonPayload.BlockPayload? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.block = block
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case block
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/forbidden_gist/content/application\/json`.
                case json(Components.Responses.ForbiddenGist.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ForbiddenGist.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ForbiddenGist.Body
            /// Creates a new `ForbiddenGist`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ForbiddenGist.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List gists for the authenticated user
    ///
    /// Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
    ///
    /// - Remark: HTTP `GET /gists`.
    /// - Remark: Generated from `#/paths//gists/get(gists/list)`.
    public enum GistsList {
        public static let id: Swift.String = "gists/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/gists/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsList.Input.Query
            /// - Remark: Generated from `#/paths/gists/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.GistsList.Input.Query = .init(),
                headers: Operations.GistsList.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.BaseGist])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.BaseGist] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsList.Output.Ok.Headers = .init(),
                    body: Operations.GistsList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/get(gists/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/get(gists/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/get(gists/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/get(gists/list)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a gist
    ///
    /// Allows you to add a new gist with one or more files.
    ///
    /// > [!NOTE]
    /// > Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
    ///
    /// - Remark: HTTP `POST /gists`.
    /// - Remark: Generated from `#/paths//gists/post(gists/create)`.
    public enum GistsCreate {
        public static let id: Swift.String = "gists/create"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCreate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCreate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsCreate.Input.Headers
            /// - Remark: Generated from `#/paths/gists/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Description of the gist
                    ///
                    /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/description`.
                    public var description: Swift.String?
                    /// Names and content for the files that make up the gist
                    ///
                    /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/files`.
                    public struct FilesPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/files/additionalProperties`.
                        public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                            /// Content of the file
                            ///
                            /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/files/additionalProperties/content`.
                            public var content: Swift.String
                            /// Creates a new `AdditionalPropertiesPayload`.
                            ///
                            /// - Parameters:
                            ///   - content: Content of the file
                            public init(content: Swift.String) {
                                self.content = content
                            }
                            public enum CodingKeys: String, CodingKey {
                                case content
                            }
                        }
                        /// A container of undocumented properties.
                        public var additionalProperties: [String: Operations.GistsCreate.Input.Body.JsonPayload.FilesPayload.AdditionalPropertiesPayload]
                        /// Creates a new `FilesPayload`.
                        ///
                        /// - Parameters:
                        ///   - additionalProperties: A container of undocumented properties.
                        public init(additionalProperties: [String: Operations.GistsCreate.Input.Body.JsonPayload.FilesPayload.AdditionalPropertiesPayload] = .init()) {
                            self.additionalProperties = additionalProperties
                        }
                        public init(from decoder: any Decoder) throws {
                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeAdditionalProperties(additionalProperties)
                        }
                    }
                    /// Names and content for the files that make up the gist
                    ///
                    /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/files`.
                    public var files: Operations.GistsCreate.Input.Body.JsonPayload.FilesPayload
                    /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/public`.
                    @frozen public enum PublicPayload: Codable, Hashable, Sendable {
                        /// Flag indicating whether the gist is public
                        ///
                        /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/public/case1`.
                        case case1(Swift.Bool)
                        /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/public/case2`.
                        @frozen public enum Case2Payload: String, Codable, Hashable, Sendable, CaseIterable {
                            case _true = "true"
                            case _false = "false"
                        }
                        /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/public/case2`.
                        case case2(Operations.GistsCreate.Input.Body.JsonPayload.PublicPayload.Case2Payload)
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self = .case1(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self = .case2(try decoder.decodeFromSingleValueContainer())
                                return
                            } catch {
                                errors.append(error)
                            }
                            throw Swift.DecodingError.failedToDecodeOneOfSchema(
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let .case1(value):
                                try encoder.encodeToSingleValueContainer(value)
                            case let .case2(value):
                                try encoder.encodeToSingleValueContainer(value)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/gists/POST/requestBody/json/public`.
                    public var _public: Operations.GistsCreate.Input.Body.JsonPayload.PublicPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - description: Description of the gist
                    ///   - files: Names and content for the files that make up the gist
                    ///   - _public:
                    public init(
                        description: Swift.String? = nil,
                        files: Operations.GistsCreate.Input.Body.JsonPayload.FilesPayload,
                        _public: Operations.GistsCreate.Input.Body.JsonPayload.PublicPayload? = nil
                    ) {
                        self.description = description
                        self.files = files
                        self._public = _public
                    }
                    public enum CodingKeys: String, CodingKey {
                        case description
                        case files
                        case _public = "public"
                    }
                }
                /// - Remark: Generated from `#/paths/gists/POST/requestBody/content/application\/json`.
                case json(Operations.GistsCreate.Input.Body.JsonPayload)
            }
            public var body: Operations.GistsCreate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.GistsCreate.Input.Headers = .init(),
                body: Operations.GistsCreate.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsCreate.Output.Created.Headers
                /// - Remark: Generated from `#/paths/gists/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GistSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsCreate.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsCreate.Output.Created.Headers = .init(),
                    body: Operations.GistsCreate.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GistsCreate.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GistsCreate.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/post(gists/create)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public gists
    ///
    /// List public gists sorted by most recently updated to least recently updated.
    ///
    /// Note: With [pagination](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
    ///
    /// - Remark: HTTP `GET /gists/public`.
    /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)`.
    public enum GistsListPublic {
        public static let id: Swift.String = "gists/list-public"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/public/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/gists/public/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/public/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/public/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListPublic.Input.Query
            /// - Remark: Generated from `#/paths/gists/public/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListPublic.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListPublic.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListPublic.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.GistsListPublic.Input.Query = .init(),
                headers: Operations.GistsListPublic.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/public/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/public/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListPublic.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/public/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/public/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.BaseGist])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.BaseGist] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListPublic.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListPublic.Output.Ok.Headers = .init(),
                    body: Operations.GistsListPublic.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListPublic.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListPublic.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/public/get(gists/list-public)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List starred gists
    ///
    /// List the authenticated user's starred gists:
    ///
    /// - Remark: HTTP `GET /gists/starred`.
    /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)`.
    public enum GistsListStarred {
        public static let id: Swift.String = "gists/list-starred"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/starred/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/gists/starred/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/starred/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/starred/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListStarred.Input.Query
            /// - Remark: Generated from `#/paths/gists/starred/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListStarred.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListStarred.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListStarred.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.GistsListStarred.Input.Query = .init(),
                headers: Operations.GistsListStarred.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/starred/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/starred/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListStarred.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/starred/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/starred/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.BaseGist])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.BaseGist] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListStarred.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListStarred.Output.Ok.Headers = .init(),
                    body: Operations.GistsListStarred.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListStarred.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListStarred.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/starred/get(gists/list-starred)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a gist
    ///
    /// Gets a specified gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)`.
    public enum GistsGet {
        public static let id: Swift.String = "gists/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsGet.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsGet.Input.Path,
                headers: Operations.GistsGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GistSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden Gist
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.ForbiddenGist)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.ForbiddenGist {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/get(gists/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a gist
    ///
    /// Allows you to update a gist's description and to update, delete, or rename gist files. Files
    /// from the previous version of the gist that aren't explicitly changed during an edit
    /// are unchanged.
    ///
    /// At least one of `description` or `files` is required.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)`.
    public enum GistsUpdate {
        public static let id: Swift.String = "gists/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsUpdate.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The description of the gist.
                    ///
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The gist files to be updated, renamed, or deleted. Each `key` must match the current filename
                    /// (including extension) of the targeted gist file. For example: `hello.py`.
                    ///
                    /// To delete a file, set the whole file to null. For example: `hello.py : null`. The file will also be
                    /// deleted if the specified object does not contain at least one of `content` or `filename`.
                    ///
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/files`.
                    public struct FilesPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/files/additionalProperties`.
                        public struct AdditionalPropertiesPayload: Codable, Hashable, Sendable {
                            /// The new content of the file.
                            ///
                            /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/files/additionalProperties/content`.
                            public var content: Swift.String?
                            /// The new filename for the file.
                            ///
                            /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/files/additionalProperties/filename`.
                            public var filename: Swift.String?
                            /// Creates a new `AdditionalPropertiesPayload`.
                            ///
                            /// - Parameters:
                            ///   - content: The new content of the file.
                            ///   - filename: The new filename for the file.
                            public init(
                                content: Swift.String? = nil,
                                filename: Swift.String? = nil
                            ) {
                                self.content = content
                                self.filename = filename
                            }
                            public enum CodingKeys: String, CodingKey {
                                case content
                                case filename
                            }
                        }
                        /// A container of undocumented properties.
                        public var additionalProperties: [String: Operations.GistsUpdate.Input.Body.JsonPayload.FilesPayload.AdditionalPropertiesPayload?]
                        /// Creates a new `FilesPayload`.
                        ///
                        /// - Parameters:
                        ///   - additionalProperties: A container of undocumented properties.
                        public init(additionalProperties: [String: Operations.GistsUpdate.Input.Body.JsonPayload.FilesPayload.AdditionalPropertiesPayload?] = .init()) {
                            self.additionalProperties = additionalProperties
                        }
                        public init(from decoder: any Decoder) throws {
                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeAdditionalProperties(additionalProperties)
                        }
                    }
                    /// The gist files to be updated, renamed, or deleted. Each `key` must match the current filename
                    /// (including extension) of the targeted gist file. For example: `hello.py`.
                    ///
                    /// To delete a file, set the whole file to null. For example: `hello.py : null`. The file will also be
                    /// deleted if the specified object does not contain at least one of `content` or `filename`.
                    ///
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/json/files`.
                    public var files: Operations.GistsUpdate.Input.Body.JsonPayload.FilesPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - description: The description of the gist.
                    ///   - files: The gist files to be updated, renamed, or deleted. Each `key` must match the current filename
                    public init(
                        description: Swift.String? = nil,
                        files: Operations.GistsUpdate.Input.Body.JsonPayload.FilesPayload? = nil
                    ) {
                        self.description = description
                        self.files = files
                    }
                    public enum CodingKeys: String, CodingKey {
                        case description
                        case files
                    }
                }
                /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.GistsUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.GistsUpdate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GistsUpdate.Input.Path,
                headers: Operations.GistsUpdate.Input.Headers = .init(),
                body: Operations.GistsUpdate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.GistSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/patch(gists/update)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)`.
    public enum GistsDelete {
        public static let id: Swift.String = "gists/delete"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/DELETE/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsDelete.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsDelete.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsDelete.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsDelete.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsDelete.Input.Path,
                headers: Operations.GistsDelete.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GistsDelete.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GistsDelete.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/delete(gists/delete)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List gist comments
    ///
    /// Lists the comments on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)`.
    public enum GistsListComments {
        public static let id: Swift.String = "gists/list-comments"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsListComments.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListComments.Input.Query
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListComments.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListComments.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListComments.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.GistsListComments.Input.Path,
                query: Operations.GistsListComments.Input.Query = .init(),
                headers: Operations.GistsListComments.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListComments.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GistComment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GistComment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListComments.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListComments.Output.Ok.Headers = .init(),
                    body: Operations.GistsListComments.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListComments.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListComments.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/get(gists/list-comments)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a gist comment
    ///
    /// Creates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/comments`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)`.
    public enum GistsCreateComment {
        public static let id: Swift.String = "gists/create-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsCreateComment.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCreateComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCreateComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsCreateComment.Input.Headers
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The comment text.
                    ///
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The comment text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/requestBody/content/application\/json`.
                case json(Operations.GistsCreateComment.Input.Body.JsonPayload)
            }
            public var body: Operations.GistsCreateComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GistsCreateComment.Input.Path,
                headers: Operations.GistsCreateComment.Input.Headers = .init(),
                body: Operations.GistsCreateComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsCreateComment.Output.Created.Headers
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GistComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsCreateComment.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsCreateComment.Output.Created.Headers = .init(),
                    body: Operations.GistsCreateComment.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GistsCreateComment.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GistsCreateComment.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/post(gists/create-comment)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a gist comment
    ///
    /// Gets a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)`.
    public enum GistsGetComment {
        public static let id: Swift.String = "gists/get-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    gistId: Components.Parameters.GistId,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.gistId = gistId
                    self.commentId = commentId
                }
            }
            public var path: Operations.GistsGetComment.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGetComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGetComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsGetComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsGetComment.Input.Path,
                headers: Operations.GistsGetComment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GistComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsGetComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsGetComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsGetComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsGetComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden Gist
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/get(gists/get-comment)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.ForbiddenGist)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.ForbiddenGist {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a gist comment
    ///
    /// Updates a comment on a gist.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `PATCH /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/patch(gists/update-comment)`.
    public enum GistsUpdateComment {
        public static let id: Swift.String = "gists/update-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    gistId: Components.Parameters.GistId,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.gistId = gistId
                    self.commentId = commentId
                }
            }
            public var path: Operations.GistsUpdateComment.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUpdateComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUpdateComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsUpdateComment.Input.Headers
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The comment text.
                    ///
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/requestBody/json/body`.
                    public var body: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - body: The comment text.
                    public init(body: Swift.String) {
                        self.body = body
                    }
                    public enum CodingKeys: String, CodingKey {
                        case body
                    }
                }
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.GistsUpdateComment.Input.Body.JsonPayload)
            }
            public var body: Operations.GistsUpdateComment.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.GistsUpdateComment.Input.Path,
                headers: Operations.GistsUpdateComment.Input.Headers = .init(),
                body: Operations.GistsUpdateComment.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.GistComment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistComment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsUpdateComment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsUpdateComment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/patch(gists/update-comment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsUpdateComment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsUpdateComment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/patch(gists/update-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a gist comment
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)`.
    public enum GistsDeleteComment {
        public static let id: Swift.String = "gists/delete-comment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/DELETE/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// The unique identifier of the comment.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/DELETE/path/comment_id`.
                public var commentId: Components.Parameters.CommentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                ///   - commentId: The unique identifier of the comment.
                public init(
                    gistId: Components.Parameters.GistId,
                    commentId: Components.Parameters.CommentId
                ) {
                    self.gistId = gistId
                    self.commentId = commentId
                }
            }
            public var path: Operations.GistsDeleteComment.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/comments/{comment_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsDeleteComment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsDeleteComment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsDeleteComment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsDeleteComment.Input.Path,
                headers: Operations.GistsDeleteComment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GistsDeleteComment.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GistsDeleteComment.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/comments/{comment_id}/delete(gists/delete-comment)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List gist commits
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/commits`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)`.
    public enum GistsListCommits {
        public static let id: Swift.String = "gists/list-commits"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsListCommits.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListCommits.Input.Query
            /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListCommits.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListCommits.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListCommits.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.GistsListCommits.Input.Path,
                query: Operations.GistsListCommits.Input.Query = .init(),
                headers: Operations.GistsListCommits.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/responses/200/headers/Link`.
                    public var link: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Swift.String? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListCommits.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/commits/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GistCommit])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GistCommit] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListCommits.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListCommits.Output.Ok.Headers = .init(),
                    body: Operations.GistsListCommits.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListCommits.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListCommits.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/commits/get(gists/list-commits)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List gist forks
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)`.
    public enum GistsListForks {
        public static let id: Swift.String = "gists/list-forks"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsListForks.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListForks.Input.Query
            /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListForks.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListForks.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListForks.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.GistsListForks.Input.Path,
                query: Operations.GistsListForks.Input.Query = .init(),
                headers: Operations.GistsListForks.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListForks.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GistSimple])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GistSimple] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListForks.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListForks.Output.Ok.Headers = .init(),
                    body: Operations.GistsListForks.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListForks.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListForks.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/get(gists/list-forks)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Fork a gist
    ///
    ///
    ///
    /// - Remark: HTTP `POST /gists/{gist_id}/forks`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)`.
    public enum GistsFork {
        public static let id: Swift.String = "gists/fork"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsFork.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsFork.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsFork.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsFork.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsFork.Input.Path,
                headers: Operations.GistsFork.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsFork.Output.Created.Headers
                /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/forks/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.BaseGist)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BaseGist {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsFork.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsFork.Output.Created.Headers = .init(),
                    body: Operations.GistsFork.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.GistsFork.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.GistsFork.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/forks/post(gists/fork)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a gist is starred
    ///
    ///
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)`.
    public enum GistsCheckIsStarred {
        public static let id: Swift.String = "gists/check-is-starred"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsCheckIsStarred.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCheckIsStarred.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsCheckIsStarred.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsCheckIsStarred.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsCheckIsStarred.Input.Path,
                headers: Operations.GistsCheckIsStarred.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if gist is starred
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GistsCheckIsStarred.Output.NoContent)
            /// Response if gist is starred
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GistsCheckIsStarred.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/responses/404/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Creates a new `JsonPayload`.
                        public init() {}
                        public init(from decoder: any Decoder) throws {
                            try decoder.ensureNoAdditionalProperties(knownKeys: [])
                        }
                    }
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/star/GET/responses/404/content/application\/json`.
                    case json(Operations.GistsCheckIsStarred.Output.NotFound.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.GistsCheckIsStarred.Output.NotFound.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsCheckIsStarred.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsCheckIsStarred.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// Not Found if gist is not starred
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.GistsCheckIsStarred.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.GistsCheckIsStarred.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/get(gists/check-is-starred)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Star a gist
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)`.
    public enum GistsStar {
        public static let id: Swift.String = "gists/star"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/star/PUT/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsStar.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsStar.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsStar.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsStar.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsStar.Input.Path,
                headers: Operations.GistsStar.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GistsStar.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GistsStar.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/put(gists/star)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unstar a gist
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /gists/{gist_id}/star`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)`.
    public enum GistsUnstar {
        public static let id: Swift.String = "gists/unstar"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/star/DELETE/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                public init(gistId: Components.Parameters.GistId) {
                    self.gistId = gistId
                }
            }
            public var path: Operations.GistsUnstar.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/star/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUnstar.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsUnstar.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsUnstar.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsUnstar.Input.Path,
                headers: Operations.GistsUnstar.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.GistsUnstar.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.GistsUnstar.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/star/delete(gists/unstar)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a gist revision
    ///
    /// Gets a specified gist revision.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.
    ///
    /// - Remark: HTTP `GET /gists/{gist_id}/{sha}`.
    /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)`.
    public enum GistsGetRevision {
        public static let id: Swift.String = "gists/get-revision"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the gist.
                ///
                /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/path/gist_id`.
                public var gistId: Components.Parameters.GistId
                /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/path/sha`.
                public var sha: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gistId: The unique identifier of the gist.
                ///   - sha:
                public init(
                    gistId: Components.Parameters.GistId,
                    sha: Swift.String
                ) {
                    self.gistId = gistId
                    self.sha = sha
                }
            }
            public var path: Operations.GistsGetRevision.Input.Path
            /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGetRevision.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsGetRevision.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsGetRevision.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.GistsGetRevision.Input.Path,
                headers: Operations.GistsGetRevision.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/gists/{gist_id}/{sha}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GistSimple)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GistSimple {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsGetRevision.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.GistsGetRevision.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsGetRevision.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsGetRevision.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//gists/{gist_id}/{sha}/get(gists/get-revision)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List gists for a user
    ///
    /// Lists public gists for the specified user:
    ///
    /// - Remark: HTTP `GET /users/{username}/gists`.
    /// - Remark: Generated from `#/paths//users/{username}/gists/get(gists/list-for-user)`.
    public enum GistsListForUser {
        public static let id: Swift.String = "gists/list-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/gists/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.GistsListForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/gists/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.Since? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.GistsListForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/gists/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.GistsListForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.GistsListForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.GistsListForUser.Input.Path,
                query: Operations.GistsListForUser.Input.Query = .init(),
                headers: Operations.GistsListForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/gists/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.GistsListForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/gists/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/gists/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.BaseGist])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.BaseGist] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.GistsListForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.GistsListForUser.Output.Ok.Headers = .init(),
                    body: Operations.GistsListForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/gists/get(gists/list-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.GistsListForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.GistsListForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/gists/get(gists/list-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
