// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List members in an enterprise team
    ///
    /// Lists all team members in an enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/get(enterprise-team-memberships/list)`.
    func enterpriseTeamMembershipsList(_ input: Operations.EnterpriseTeamMembershipsList.Input) async throws -> Operations.EnterpriseTeamMembershipsList.Output
    /// Bulk add team members
    ///
    /// Add multiple team members to an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/post(enterprise-team-memberships/bulk-add)`.
    func enterpriseTeamMembershipsBulkAdd(_ input: Operations.EnterpriseTeamMembershipsBulkAdd.Input) async throws -> Operations.EnterpriseTeamMembershipsBulkAdd.Output
    /// Bulk remove team members
    ///
    /// Remove multiple team members from an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/post(enterprise-team-memberships/bulk-remove)`.
    func enterpriseTeamMembershipsBulkRemove(_ input: Operations.EnterpriseTeamMembershipsBulkRemove.Input) async throws -> Operations.EnterpriseTeamMembershipsBulkRemove.Output
    /// Get enterprise team membership
    ///
    /// Returns whether the user is a member of the enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/get(enterprise-team-memberships/get)`.
    func enterpriseTeamMembershipsGet(_ input: Operations.EnterpriseTeamMembershipsGet.Input) async throws -> Operations.EnterpriseTeamMembershipsGet.Output
    /// Add team member
    ///
    /// Add a team member to an enterprise team.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/put(enterprise-team-memberships/add)`.
    func enterpriseTeamMembershipsAdd(_ input: Operations.EnterpriseTeamMembershipsAdd.Input) async throws -> Operations.EnterpriseTeamMembershipsAdd.Output
    /// Remove team membership
    ///
    /// Remove membership of a specific user from a particular team in an enterprise.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)`.
    func enterpriseTeamMembershipsRemove(_ input: Operations.EnterpriseTeamMembershipsRemove.Input) async throws -> Operations.EnterpriseTeamMembershipsRemove.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List members in an enterprise team
    ///
    /// Lists all team members in an enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/get(enterprise-team-memberships/list)`.
    public func enterpriseTeamMembershipsList(
        path: Operations.EnterpriseTeamMembershipsList.Input.Path,
        query: Operations.EnterpriseTeamMembershipsList.Input.Query = .init(),
        headers: Operations.EnterpriseTeamMembershipsList.Input.Headers = .init()
    ) async throws -> Operations.EnterpriseTeamMembershipsList.Output {
        try await enterpriseTeamMembershipsList(Operations.EnterpriseTeamMembershipsList.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Bulk add team members
    ///
    /// Add multiple team members to an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/post(enterprise-team-memberships/bulk-add)`.
    public func enterpriseTeamMembershipsBulkAdd(
        path: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Path,
        headers: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Headers = .init(),
        body: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Body
    ) async throws -> Operations.EnterpriseTeamMembershipsBulkAdd.Output {
        try await enterpriseTeamMembershipsBulkAdd(Operations.EnterpriseTeamMembershipsBulkAdd.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Bulk remove team members
    ///
    /// Remove multiple team members from an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/post(enterprise-team-memberships/bulk-remove)`.
    public func enterpriseTeamMembershipsBulkRemove(
        path: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Path,
        headers: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Headers = .init(),
        body: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Body
    ) async throws -> Operations.EnterpriseTeamMembershipsBulkRemove.Output {
        try await enterpriseTeamMembershipsBulkRemove(Operations.EnterpriseTeamMembershipsBulkRemove.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get enterprise team membership
    ///
    /// Returns whether the user is a member of the enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/get(enterprise-team-memberships/get)`.
    public func enterpriseTeamMembershipsGet(
        path: Operations.EnterpriseTeamMembershipsGet.Input.Path,
        headers: Operations.EnterpriseTeamMembershipsGet.Input.Headers = .init()
    ) async throws -> Operations.EnterpriseTeamMembershipsGet.Output {
        try await enterpriseTeamMembershipsGet(Operations.EnterpriseTeamMembershipsGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add team member
    ///
    /// Add a team member to an enterprise team.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/put(enterprise-team-memberships/add)`.
    public func enterpriseTeamMembershipsAdd(
        path: Operations.EnterpriseTeamMembershipsAdd.Input.Path,
        headers: Operations.EnterpriseTeamMembershipsAdd.Input.Headers = .init()
    ) async throws -> Operations.EnterpriseTeamMembershipsAdd.Output {
        try await enterpriseTeamMembershipsAdd(Operations.EnterpriseTeamMembershipsAdd.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove team membership
    ///
    /// Remove membership of a specific user from a particular team in an enterprise.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)`.
    public func enterpriseTeamMembershipsRemove(
        path: Operations.EnterpriseTeamMembershipsRemove.Input.Path,
        headers: Operations.EnterpriseTeamMembershipsRemove.Input.Headers = .init()
    ) async throws -> Operations.EnterpriseTeamMembershipsRemove.Output {
        try await enterpriseTeamMembershipsRemove(Operations.EnterpriseTeamMembershipsRemove.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The slug version of the enterprise name.
        ///
        /// - Remark: Generated from `#/components/parameters/enterprise`.
        public typealias Enterprise = Swift.String
        /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
        ///
        /// - Remark: Generated from `#/components/parameters/enterprise-team`.
        public typealias EnterpriseTeam = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List members in an enterprise team
    ///
    /// Lists all team members in an enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/get(enterprise-team-memberships/list)`.
    public enum EnterpriseTeamMembershipsList {
        public static let id: Swift.String = "enterprise-team-memberships/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsList.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.EnterpriseTeamMembershipsList.Input.Query
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.EnterpriseTeamMembershipsList.Input.Path,
                query: Operations.EnterpriseTeamMembershipsList.Input.Query = .init(),
                headers: Operations.EnterpriseTeamMembershipsList.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.EnterpriseTeamMembershipsList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.EnterpriseTeamMembershipsList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.EnterpriseTeamMembershipsList.Output.Ok.Headers = .init(),
                    body: Operations.EnterpriseTeamMembershipsList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/get(enterprise-team-memberships/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.EnterpriseTeamMembershipsList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.EnterpriseTeamMembershipsList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Bulk add team members
    ///
    /// Add multiple team members to an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/post(enterprise-team-memberships/bulk-add)`.
    public enum EnterpriseTeamMembershipsBulkAdd {
        public static let id: Swift.String = "enterprise-team-memberships/bulk-add"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsBulkAdd.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsBulkAdd.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The GitHub user handles to add to the team.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/requestBody/json/usernames`.
                    public var usernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - usernames: The GitHub user handles to add to the team.
                    public init(usernames: [Swift.String]) {
                        self.usernames = usernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case usernames
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/requestBody/content/application\/json`.
                case json(Operations.EnterpriseTeamMembershipsBulkAdd.Input.Body.JsonPayload)
            }
            public var body: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Path,
                headers: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Headers = .init(),
                body: Operations.EnterpriseTeamMembershipsBulkAdd.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/POST/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.EnterpriseTeamMembershipsBulkAdd.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.EnterpriseTeamMembershipsBulkAdd.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Successfully added team members.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/post(enterprise-team-memberships/bulk-add)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.EnterpriseTeamMembershipsBulkAdd.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.EnterpriseTeamMembershipsBulkAdd.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Bulk remove team members
    ///
    /// Remove multiple team members from an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/post(enterprise-team-memberships/bulk-remove)`.
    public enum EnterpriseTeamMembershipsBulkRemove {
        public static let id: Swift.String = "enterprise-team-memberships/bulk-remove"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsBulkRemove.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsBulkRemove.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Headers
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The GitHub user handles to be removed from the team.
                    ///
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/requestBody/json/usernames`.
                    public var usernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - usernames: The GitHub user handles to be removed from the team.
                    public init(usernames: [Swift.String]) {
                        self.usernames = usernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case usernames
                    }
                }
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/requestBody/content/application\/json`.
                case json(Operations.EnterpriseTeamMembershipsBulkRemove.Input.Body.JsonPayload)
            }
            public var body: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Path,
                headers: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Headers = .init(),
                body: Operations.EnterpriseTeamMembershipsBulkRemove.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/POST/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.EnterpriseTeamMembershipsBulkRemove.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.EnterpriseTeamMembershipsBulkRemove.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Successfully removed team members.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/post(enterprise-team-memberships/bulk-remove)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.EnterpriseTeamMembershipsBulkRemove.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.EnterpriseTeamMembershipsBulkRemove.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get enterprise team membership
    ///
    /// Returns whether the user is a member of the enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/get(enterprise-team-memberships/get)`.
    public enum EnterpriseTeamMembershipsGet {
        public static let id: Swift.String = "enterprise-team-memberships/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///   - username: The handle for the GitHub user account.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam,
                    username: Components.Parameters.Username
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                    self.username = username
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsGet.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.EnterpriseTeamMembershipsGet.Input.Path,
                headers: Operations.EnterpriseTeamMembershipsGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SimpleUser)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SimpleUser {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.EnterpriseTeamMembershipsGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.EnterpriseTeamMembershipsGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// User is a member of the enterprise team.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/get(enterprise-team-memberships/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.EnterpriseTeamMembershipsGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.EnterpriseTeamMembershipsGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add team member
    ///
    /// Add a team member to an enterprise team.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/put(enterprise-team-memberships/add)`.
    public enum EnterpriseTeamMembershipsAdd {
        public static let id: Swift.String = "enterprise-team-memberships/add"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///   - username: The handle for the GitHub user account.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam,
                    username: Components.Parameters.Username
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                    self.username = username
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsAdd.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsAdd.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsAdd.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsAdd.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.EnterpriseTeamMembershipsAdd.Input.Path,
                headers: Operations.EnterpriseTeamMembershipsAdd.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.SimpleUser)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SimpleUser {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.EnterpriseTeamMembershipsAdd.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.EnterpriseTeamMembershipsAdd.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Successfully added team member
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/put(enterprise-team-memberships/add)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.EnterpriseTeamMembershipsAdd.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.EnterpriseTeamMembershipsAdd.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove team membership
    ///
    /// Remove membership of a specific user from a particular team in an enterprise.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)`.
    public enum EnterpriseTeamMembershipsRemove {
        public static let id: Swift.String = "enterprise-team-memberships/remove"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/DELETE/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/DELETE/path/enterprise-team`.
                public var enterpriseTeam: Components.Parameters.EnterpriseTeam
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                ///   - enterpriseTeam: The slug version of the enterprise team name. You can also substitute this value with the enterprise team id.
                ///   - username: The handle for the GitHub user account.
                public init(
                    enterprise: Components.Parameters.Enterprise,
                    enterpriseTeam: Components.Parameters.EnterpriseTeam,
                    username: Components.Parameters.Username
                ) {
                    self.enterprise = enterprise
                    self.enterpriseTeam = enterpriseTeam
                    self.username = username
                }
            }
            public var path: Operations.EnterpriseTeamMembershipsRemove.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsRemove.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.EnterpriseTeamMembershipsRemove.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.EnterpriseTeamMembershipsRemove.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.EnterpriseTeamMembershipsRemove.Input.Path,
                headers: Operations.EnterpriseTeamMembershipsRemove.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.EnterpriseTeamMembershipsRemove.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.EnterpriseTeamMembershipsRemove.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
