// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// List members in an enterprise team
    ///
    /// Lists all team members in an enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/get(enterprise-team-memberships/list)`.
    public func enterpriseTeamMembershipsList(_ input: Operations.EnterpriseTeamMembershipsList.Input) async throws -> Operations.EnterpriseTeamMembershipsList.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsList.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "per_page",
                    value: input.query.perPage
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "page",
                    value: input.query.page
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.EnterpriseTeamMembershipsList.Output.Ok.Headers = .init(link: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Link",
                        as: Components.Headers.Link.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.EnterpriseTeamMembershipsList.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Bulk add team members
    ///
    /// Add multiple team members to an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/add/post(enterprise-team-memberships/bulk-add)`.
    public func enterpriseTeamMembershipsBulkAdd(_ input: Operations.EnterpriseTeamMembershipsBulkAdd.Input) async throws -> Operations.EnterpriseTeamMembershipsBulkAdd.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsBulkAdd.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships/add",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.EnterpriseTeamMembershipsBulkAdd.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Bulk remove team members
    ///
    /// Remove multiple team members from an enterprise team.
    ///
    /// - Remark: HTTP `POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove/post(enterprise-team-memberships/bulk-remove)`.
    public func enterpriseTeamMembershipsBulkRemove(_ input: Operations.EnterpriseTeamMembershipsBulkRemove.Input) async throws -> Operations.EnterpriseTeamMembershipsBulkRemove.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsBulkRemove.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships/remove",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.EnterpriseTeamMembershipsBulkRemove.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            [Components.Schemas.SimpleUser].self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get enterprise team membership
    ///
    /// Returns whether the user is a member of the enterprise team.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/get(enterprise-team-memberships/get)`.
    public func enterpriseTeamMembershipsGet(_ input: Operations.EnterpriseTeamMembershipsGet.Input) async throws -> Operations.EnterpriseTeamMembershipsGet.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsGet.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.EnterpriseTeamMembershipsGet.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.SimpleUser.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Add team member
    ///
    /// Add a team member to an enterprise team.
    ///
    /// - Remark: HTTP `PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/put(enterprise-team-memberships/add)`.
    public func enterpriseTeamMembershipsAdd(_ input: Operations.EnterpriseTeamMembershipsAdd.Input) async throws -> Operations.EnterpriseTeamMembershipsAdd.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsAdd.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .put
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 201:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.EnterpriseTeamMembershipsAdd.Output.Created.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.SimpleUser.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .created(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Remove team membership
    ///
    /// Remove membership of a specific user from a particular team in an enterprise.
    ///
    /// - Remark: HTTP `DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}/delete(enterprise-team-memberships/remove)`.
    public func enterpriseTeamMembershipsRemove(_ input: Operations.EnterpriseTeamMembershipsRemove.Input) async throws -> Operations.EnterpriseTeamMembershipsRemove.Output {
        try await client.send(
            input: input,
            forOperation: Operations.EnterpriseTeamMembershipsRemove.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/enterprises/{}/teams/{}/memberships/{}",
                    parameters: [
                        input.path.enterprise,
                        input.path.enterpriseTeam,
                        input.path.username
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 204:
                    return .noContent(.init())
                case 403:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Components.Responses.Forbidden.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.BasicError.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .forbidden(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
