// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List code scanning alerts for an organization
    ///
    /// Lists code scanning alerts for the default branch for all eligible repositories in an organization. Eligible repositories are repositories that are owned by organizations that you own or for which you are a security manager. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` or `repo`s cope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)`.
    func codeScanningListAlertsForOrg(_ input: Operations.CodeScanningListAlertsForOrg.Input) async throws -> Operations.CodeScanningListAlertsForOrg.Output
    /// List code scanning alerts for a repository
    ///
    /// Lists code scanning alerts.
    ///
    /// The response includes a `most_recent_instance` object.
    /// This provides details of the most recent instance of this alert
    /// for the default branch (or for the specified Git reference if you used `ref` in the request).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)`.
    func codeScanningListAlertsForRepo(_ input: Operations.CodeScanningListAlertsForRepo.Input) async throws -> Operations.CodeScanningListAlertsForRepo.Output
    /// Get a code scanning alert
    ///
    /// Gets a single code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)`.
    func codeScanningGetAlert(_ input: Operations.CodeScanningGetAlert.Input) async throws -> Operations.CodeScanningGetAlert.Output
    /// Update a code scanning alert
    ///
    /// Updates the status of a single code scanning alert.
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)`.
    func codeScanningUpdateAlert(_ input: Operations.CodeScanningUpdateAlert.Input) async throws -> Operations.CodeScanningUpdateAlert.Output
    /// Get the status of an autofix for a code scanning alert
    ///
    /// Gets the status and description of an autofix for a code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)`.
    func codeScanningGetAutofix(_ input: Operations.CodeScanningGetAutofix.Input) async throws -> Operations.CodeScanningGetAutofix.Output
    /// Create an autofix for a code scanning alert
    ///
    /// Creates an autofix for a code scanning alert.
    ///
    /// If a new autofix is to be created as a result of this request or is currently being generated, then this endpoint will return a 202 Accepted response.
    ///
    /// If an autofix already exists for a given alert, then this endpoint will return a 200 OK response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)`.
    func codeScanningCreateAutofix(_ input: Operations.CodeScanningCreateAutofix.Input) async throws -> Operations.CodeScanningCreateAutofix.Output
    /// Commit an autofix for a code scanning alert
    ///
    /// Commits an autofix for a code scanning alert.
    ///
    /// If an autofix is committed as a result of this request, then this endpoint will return a 201 Created response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)`.
    func codeScanningCommitAutofix(_ input: Operations.CodeScanningCommitAutofix.Input) async throws -> Operations.CodeScanningCommitAutofix.Output
    /// List instances of a code scanning alert
    ///
    /// Lists all instances of the specified code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)`.
    func codeScanningListAlertInstances(_ input: Operations.CodeScanningListAlertInstances.Input) async throws -> Operations.CodeScanningListAlertInstances.Output
    /// List code scanning analyses for a repository
    ///
    /// Lists the details of all code scanning analyses for a repository,
    /// starting with the most recent.
    /// The response is paginated and you can use the `page` and `per_page` parameters
    /// to list the analyses you're interested in.
    /// By default 30 analyses are listed per page.
    ///
    /// The `rules_count` field in the response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The `tool_name` field is closing down and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)`.
    func codeScanningListRecentAnalyses(_ input: Operations.CodeScanningListRecentAnalyses.Input) async throws -> Operations.CodeScanningListRecentAnalyses.Output
    /// Get a code scanning analysis for a repository
    ///
    /// Gets a specified code scanning analysis for a repository.
    ///
    /// The default JSON response contains fields that describe the analysis.
    /// This includes the Git reference and commit SHA to which the analysis relates,
    /// the datetime of the analysis, the name of the code scanning tool,
    /// and the number of alerts.
    ///
    /// The `rules_count` field in the default response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/sarif+json`**: Instead of returning a summary of the analysis, this endpoint returns a subset of the analysis data that was uploaded. The data is formatted as [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html). It also returns additional data such as the `github/alertNumber` and `github/alertUrl` properties.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)`.
    func codeScanningGetAnalysis(_ input: Operations.CodeScanningGetAnalysis.Input) async throws -> Operations.CodeScanningGetAnalysis.Output
    /// Delete a code scanning analysis from a repository
    ///
    /// Deletes a specified code scanning analysis from a repository.
    ///
    /// You can delete one analysis at a time.
    /// To delete a series of analyses, start with the most recent analysis and work backwards.
    /// Conceptually, the process is similar to the undo function in a text editor.
    ///
    /// When you list the analyses for a repository,
    /// one or more will be identified as deletable in the response:
    ///
    /// ```
    /// "deletable": true
    /// ```
    ///
    /// An analysis is deletable when it's the most recent in a set of analyses.
    /// Typically, a repository will have multiple sets of analyses
    /// for each enabled code scanning tool,
    /// where a set is determined by a unique combination of analysis values:
    ///
    /// * `ref`
    /// * `tool`
    /// * `category`
    ///
    /// If you attempt to delete an analysis that is not the most recent in a set,
    /// you'll get a 400 response with the message:
    ///
    /// ```
    /// Analysis specified is not deletable.
    /// ```
    ///
    /// The response from a successful `DELETE` operation provides you with
    /// two alternative URLs for deleting the next analysis in the set:
    /// `next_analysis_url` and `confirm_delete_url`.
    /// Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
    /// in a set. This is a useful option if you want to preserve at least one analysis
    /// for the specified tool in your repository.
    /// Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
    /// When you delete the last analysis in a set, the value of `next_analysis_url` and `confirm_delete_url`
    /// in the 200 response is `null`.
    ///
    /// As an example of the deletion process,
    /// let's imagine that you added a workflow that configured a particular code scanning tool
    /// to analyze the code in a repository. This tool has added 15 analyses:
    /// 10 on the default branch, and another 5 on a topic branch.
    /// You therefore have two separate sets of analyses for this tool.
    /// You've now decided that you want to remove all of the analyses for the tool.
    /// To do this you must make 15 separate deletion requests.
    /// To start, you must find an analysis that's identified as deletable.
    /// Each set of analyses always has one that's identified as deletable.
    /// Having found the deletable analysis for one of the two sets,
    /// delete this analysis and then continue deleting the next analysis in the set until they're all deleted.
    /// Then repeat the process for the second set.
    /// The procedure therefore consists of a nested loop:
    ///
    /// **Outer loop**:
    /// * List the analyses for the repository, filtered by tool.
    /// * Parse this list to find a deletable analysis. If found:
    ///
    ///   **Inner loop**:
    ///   * Delete the identified analysis.
    ///   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
    ///
    /// The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)`.
    func codeScanningDeleteAnalysis(_ input: Operations.CodeScanningDeleteAnalysis.Input) async throws -> Operations.CodeScanningDeleteAnalysis.Output
    /// List CodeQL databases for a repository
    ///
    /// Lists the CodeQL databases that are available in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)`.
    func codeScanningListCodeqlDatabases(_ input: Operations.CodeScanningListCodeqlDatabases.Input) async throws -> Operations.CodeScanningListCodeqlDatabases.Output
    /// Get a CodeQL database for a repository
    ///
    /// Gets a CodeQL database for a language in a repository.
    ///
    /// By default this endpoint returns JSON metadata about the CodeQL database. To
    /// download the CodeQL database binary content, set the `Accept` header of the request
    /// to [`application/zip`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types), and make sure
    /// your HTTP client is configured to follow redirects or use the `Location` header
    /// to make a second request to get the redirect URL.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)`.
    func codeScanningGetCodeqlDatabase(_ input: Operations.CodeScanningGetCodeqlDatabase.Input) async throws -> Operations.CodeScanningGetCodeqlDatabase.Output
    /// Delete a CodeQL database
    ///
    /// Deletes a CodeQL database for a language in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)`.
    func codeScanningDeleteCodeqlDatabase(_ input: Operations.CodeScanningDeleteCodeqlDatabase.Input) async throws -> Operations.CodeScanningDeleteCodeqlDatabase.Output
    /// Create a CodeQL variant analysis
    ///
    /// Creates a new CodeQL variant analysis, which will run a CodeQL query against one or more repositories.
    ///
    /// Get started by learning more about [running CodeQL queries at scale with Multi-Repository Variant Analysis](https://docs.github.com/code-security/codeql-for-vs-code/getting-started-with-codeql-for-vs-code/running-codeql-queries-at-scale-with-multi-repository-variant-analysis).
    ///
    /// Use the `owner` and `repo` parameters in the URL to specify the controller repository that
    /// will be used for running GitHub Actions workflows and storing the results of the CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)`.
    func codeScanningCreateVariantAnalysis(_ input: Operations.CodeScanningCreateVariantAnalysis.Input) async throws -> Operations.CodeScanningCreateVariantAnalysis.Output
    /// Get the summary of a CodeQL variant analysis
    ///
    /// Gets the summary of a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)`.
    func codeScanningGetVariantAnalysis(_ input: Operations.CodeScanningGetVariantAnalysis.Input) async throws -> Operations.CodeScanningGetVariantAnalysis.Output
    /// Get the analysis status of a repository in a CodeQL variant analysis
    ///
    /// Gets the analysis status of a repository in a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)`.
    func codeScanningGetVariantAnalysisRepoTask(_ input: Operations.CodeScanningGetVariantAnalysisRepoTask.Input) async throws -> Operations.CodeScanningGetVariantAnalysisRepoTask.Output
    /// Get a code scanning default setup configuration
    ///
    /// Gets a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)`.
    func codeScanningGetDefaultSetup(_ input: Operations.CodeScanningGetDefaultSetup.Input) async throws -> Operations.CodeScanningGetDefaultSetup.Output
    /// Update a code scanning default setup configuration
    ///
    /// Updates a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)`.
    func codeScanningUpdateDefaultSetup(_ input: Operations.CodeScanningUpdateDefaultSetup.Input) async throws -> Operations.CodeScanningUpdateDefaultSetup.Output
    /// Upload an analysis as SARIF data
    ///
    /// Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. For troubleshooting information, see "[Troubleshooting SARIF uploads](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif)."
    ///
    /// There are two places where you can upload code scanning results.
    ///  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
    ///  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
    ///
    /// You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
    ///
    /// ```
    /// gzip -c analysis-data.sarif | base64 -w0
    /// ```
    ///
    /// SARIF upload supports a maximum number of entries per the following data objects, and an analysis will be rejected if any of these objects is above its maximum value. For some objects, there are additional values over which the entries will be ignored while keeping the most important entries whenever applicable.
    /// To get the most out of your analysis when it includes data above the supported limits, try to optimize the analysis configuration. For example, for the CodeQL tool, identify and remove the most noisy queries. For more information, see "[SARIF results exceed one or more limits](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif/results-exceed-limit)."
    ///
    ///
    /// | **SARIF data**                   | **Maximum values** | **Additional limits**                                                            |
    /// |----------------------------------|:------------------:|----------------------------------------------------------------------------------|
    /// | Runs per file                    |         20         |                                                                                  |
    /// | Results per run                  |       25,000       | Only the top 5,000 results will be included, prioritized by severity.            |
    /// | Rules per run                    |       25,000       |                                                                                  |
    /// | Tool extensions per run          |        100         |                                                                                  |
    /// | Thread Flow Locations per result |       10,000       | Only the top 1,000 Thread Flow Locations will be included, using prioritization. |
    /// | Location per result	             |       1,000        | Only 100 locations will be included.                                             |
    /// | Tags per rule	                   |         20         | Only 10 tags will be included.                                                   |
    ///
    ///
    /// The `202 Accepted` response includes an `id` value.
    /// You can use this ID to check the status of the upload by using it in the `/sarifs/{sarif_id}` endpoint.
    /// For more information, see "[Get information about a SARIF upload](/rest/code-scanning/code-scanning#get-information-about-a-sarif-upload)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// This endpoint is limited to 1,000 requests per hour for each user or app installation calling it.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/sarifs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)`.
    func codeScanningUploadSarif(_ input: Operations.CodeScanningUploadSarif.Input) async throws -> Operations.CodeScanningUploadSarif.Output
    /// Get information about a SARIF upload
    ///
    /// Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository)."
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)`.
    func codeScanningGetSarif(_ input: Operations.CodeScanningGetSarif.Input) async throws -> Operations.CodeScanningGetSarif.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List code scanning alerts for an organization
    ///
    /// Lists code scanning alerts for the default branch for all eligible repositories in an organization. Eligible repositories are repositories that are owned by organizations that you own or for which you are a security manager. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` or `repo`s cope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)`.
    public func codeScanningListAlertsForOrg(
        path: Operations.CodeScanningListAlertsForOrg.Input.Path,
        query: Operations.CodeScanningListAlertsForOrg.Input.Query = .init(),
        headers: Operations.CodeScanningListAlertsForOrg.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningListAlertsForOrg.Output {
        try await codeScanningListAlertsForOrg(Operations.CodeScanningListAlertsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List code scanning alerts for a repository
    ///
    /// Lists code scanning alerts.
    ///
    /// The response includes a `most_recent_instance` object.
    /// This provides details of the most recent instance of this alert
    /// for the default branch (or for the specified Git reference if you used `ref` in the request).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)`.
    public func codeScanningListAlertsForRepo(
        path: Operations.CodeScanningListAlertsForRepo.Input.Path,
        query: Operations.CodeScanningListAlertsForRepo.Input.Query = .init(),
        headers: Operations.CodeScanningListAlertsForRepo.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningListAlertsForRepo.Output {
        try await codeScanningListAlertsForRepo(Operations.CodeScanningListAlertsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a code scanning alert
    ///
    /// Gets a single code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)`.
    public func codeScanningGetAlert(
        path: Operations.CodeScanningGetAlert.Input.Path,
        headers: Operations.CodeScanningGetAlert.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetAlert.Output {
        try await codeScanningGetAlert(Operations.CodeScanningGetAlert.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a code scanning alert
    ///
    /// Updates the status of a single code scanning alert.
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)`.
    public func codeScanningUpdateAlert(
        path: Operations.CodeScanningUpdateAlert.Input.Path,
        headers: Operations.CodeScanningUpdateAlert.Input.Headers = .init(),
        body: Operations.CodeScanningUpdateAlert.Input.Body
    ) async throws -> Operations.CodeScanningUpdateAlert.Output {
        try await codeScanningUpdateAlert(Operations.CodeScanningUpdateAlert.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get the status of an autofix for a code scanning alert
    ///
    /// Gets the status and description of an autofix for a code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)`.
    public func codeScanningGetAutofix(
        path: Operations.CodeScanningGetAutofix.Input.Path,
        headers: Operations.CodeScanningGetAutofix.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetAutofix.Output {
        try await codeScanningGetAutofix(Operations.CodeScanningGetAutofix.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create an autofix for a code scanning alert
    ///
    /// Creates an autofix for a code scanning alert.
    ///
    /// If a new autofix is to be created as a result of this request or is currently being generated, then this endpoint will return a 202 Accepted response.
    ///
    /// If an autofix already exists for a given alert, then this endpoint will return a 200 OK response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)`.
    public func codeScanningCreateAutofix(
        path: Operations.CodeScanningCreateAutofix.Input.Path,
        headers: Operations.CodeScanningCreateAutofix.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningCreateAutofix.Output {
        try await codeScanningCreateAutofix(Operations.CodeScanningCreateAutofix.Input(
            path: path,
            headers: headers
        ))
    }
    /// Commit an autofix for a code scanning alert
    ///
    /// Commits an autofix for a code scanning alert.
    ///
    /// If an autofix is committed as a result of this request, then this endpoint will return a 201 Created response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)`.
    public func codeScanningCommitAutofix(
        path: Operations.CodeScanningCommitAutofix.Input.Path,
        headers: Operations.CodeScanningCommitAutofix.Input.Headers = .init(),
        body: Operations.CodeScanningCommitAutofix.Input.Body? = nil
    ) async throws -> Operations.CodeScanningCommitAutofix.Output {
        try await codeScanningCommitAutofix(Operations.CodeScanningCommitAutofix.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List instances of a code scanning alert
    ///
    /// Lists all instances of the specified code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)`.
    public func codeScanningListAlertInstances(
        path: Operations.CodeScanningListAlertInstances.Input.Path,
        query: Operations.CodeScanningListAlertInstances.Input.Query = .init(),
        headers: Operations.CodeScanningListAlertInstances.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningListAlertInstances.Output {
        try await codeScanningListAlertInstances(Operations.CodeScanningListAlertInstances.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List code scanning analyses for a repository
    ///
    /// Lists the details of all code scanning analyses for a repository,
    /// starting with the most recent.
    /// The response is paginated and you can use the `page` and `per_page` parameters
    /// to list the analyses you're interested in.
    /// By default 30 analyses are listed per page.
    ///
    /// The `rules_count` field in the response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The `tool_name` field is closing down and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)`.
    public func codeScanningListRecentAnalyses(
        path: Operations.CodeScanningListRecentAnalyses.Input.Path,
        query: Operations.CodeScanningListRecentAnalyses.Input.Query = .init(),
        headers: Operations.CodeScanningListRecentAnalyses.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningListRecentAnalyses.Output {
        try await codeScanningListRecentAnalyses(Operations.CodeScanningListRecentAnalyses.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a code scanning analysis for a repository
    ///
    /// Gets a specified code scanning analysis for a repository.
    ///
    /// The default JSON response contains fields that describe the analysis.
    /// This includes the Git reference and commit SHA to which the analysis relates,
    /// the datetime of the analysis, the name of the code scanning tool,
    /// and the number of alerts.
    ///
    /// The `rules_count` field in the default response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/sarif+json`**: Instead of returning a summary of the analysis, this endpoint returns a subset of the analysis data that was uploaded. The data is formatted as [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html). It also returns additional data such as the `github/alertNumber` and `github/alertUrl` properties.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)`.
    public func codeScanningGetAnalysis(
        path: Operations.CodeScanningGetAnalysis.Input.Path,
        headers: Operations.CodeScanningGetAnalysis.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetAnalysis.Output {
        try await codeScanningGetAnalysis(Operations.CodeScanningGetAnalysis.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a code scanning analysis from a repository
    ///
    /// Deletes a specified code scanning analysis from a repository.
    ///
    /// You can delete one analysis at a time.
    /// To delete a series of analyses, start with the most recent analysis and work backwards.
    /// Conceptually, the process is similar to the undo function in a text editor.
    ///
    /// When you list the analyses for a repository,
    /// one or more will be identified as deletable in the response:
    ///
    /// ```
    /// "deletable": true
    /// ```
    ///
    /// An analysis is deletable when it's the most recent in a set of analyses.
    /// Typically, a repository will have multiple sets of analyses
    /// for each enabled code scanning tool,
    /// where a set is determined by a unique combination of analysis values:
    ///
    /// * `ref`
    /// * `tool`
    /// * `category`
    ///
    /// If you attempt to delete an analysis that is not the most recent in a set,
    /// you'll get a 400 response with the message:
    ///
    /// ```
    /// Analysis specified is not deletable.
    /// ```
    ///
    /// The response from a successful `DELETE` operation provides you with
    /// two alternative URLs for deleting the next analysis in the set:
    /// `next_analysis_url` and `confirm_delete_url`.
    /// Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
    /// in a set. This is a useful option if you want to preserve at least one analysis
    /// for the specified tool in your repository.
    /// Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
    /// When you delete the last analysis in a set, the value of `next_analysis_url` and `confirm_delete_url`
    /// in the 200 response is `null`.
    ///
    /// As an example of the deletion process,
    /// let's imagine that you added a workflow that configured a particular code scanning tool
    /// to analyze the code in a repository. This tool has added 15 analyses:
    /// 10 on the default branch, and another 5 on a topic branch.
    /// You therefore have two separate sets of analyses for this tool.
    /// You've now decided that you want to remove all of the analyses for the tool.
    /// To do this you must make 15 separate deletion requests.
    /// To start, you must find an analysis that's identified as deletable.
    /// Each set of analyses always has one that's identified as deletable.
    /// Having found the deletable analysis for one of the two sets,
    /// delete this analysis and then continue deleting the next analysis in the set until they're all deleted.
    /// Then repeat the process for the second set.
    /// The procedure therefore consists of a nested loop:
    ///
    /// **Outer loop**:
    /// * List the analyses for the repository, filtered by tool.
    /// * Parse this list to find a deletable analysis. If found:
    ///
    ///   **Inner loop**:
    ///   * Delete the identified analysis.
    ///   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
    ///
    /// The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)`.
    public func codeScanningDeleteAnalysis(
        path: Operations.CodeScanningDeleteAnalysis.Input.Path,
        query: Operations.CodeScanningDeleteAnalysis.Input.Query = .init(),
        headers: Operations.CodeScanningDeleteAnalysis.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningDeleteAnalysis.Output {
        try await codeScanningDeleteAnalysis(Operations.CodeScanningDeleteAnalysis.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List CodeQL databases for a repository
    ///
    /// Lists the CodeQL databases that are available in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)`.
    public func codeScanningListCodeqlDatabases(
        path: Operations.CodeScanningListCodeqlDatabases.Input.Path,
        headers: Operations.CodeScanningListCodeqlDatabases.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningListCodeqlDatabases.Output {
        try await codeScanningListCodeqlDatabases(Operations.CodeScanningListCodeqlDatabases.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a CodeQL database for a repository
    ///
    /// Gets a CodeQL database for a language in a repository.
    ///
    /// By default this endpoint returns JSON metadata about the CodeQL database. To
    /// download the CodeQL database binary content, set the `Accept` header of the request
    /// to [`application/zip`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types), and make sure
    /// your HTTP client is configured to follow redirects or use the `Location` header
    /// to make a second request to get the redirect URL.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)`.
    public func codeScanningGetCodeqlDatabase(
        path: Operations.CodeScanningGetCodeqlDatabase.Input.Path,
        headers: Operations.CodeScanningGetCodeqlDatabase.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetCodeqlDatabase.Output {
        try await codeScanningGetCodeqlDatabase(Operations.CodeScanningGetCodeqlDatabase.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a CodeQL database
    ///
    /// Deletes a CodeQL database for a language in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)`.
    public func codeScanningDeleteCodeqlDatabase(
        path: Operations.CodeScanningDeleteCodeqlDatabase.Input.Path,
        headers: Operations.CodeScanningDeleteCodeqlDatabase.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningDeleteCodeqlDatabase.Output {
        try await codeScanningDeleteCodeqlDatabase(Operations.CodeScanningDeleteCodeqlDatabase.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a CodeQL variant analysis
    ///
    /// Creates a new CodeQL variant analysis, which will run a CodeQL query against one or more repositories.
    ///
    /// Get started by learning more about [running CodeQL queries at scale with Multi-Repository Variant Analysis](https://docs.github.com/code-security/codeql-for-vs-code/getting-started-with-codeql-for-vs-code/running-codeql-queries-at-scale-with-multi-repository-variant-analysis).
    ///
    /// Use the `owner` and `repo` parameters in the URL to specify the controller repository that
    /// will be used for running GitHub Actions workflows and storing the results of the CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)`.
    public func codeScanningCreateVariantAnalysis(
        path: Operations.CodeScanningCreateVariantAnalysis.Input.Path,
        headers: Operations.CodeScanningCreateVariantAnalysis.Input.Headers = .init(),
        body: Operations.CodeScanningCreateVariantAnalysis.Input.Body
    ) async throws -> Operations.CodeScanningCreateVariantAnalysis.Output {
        try await codeScanningCreateVariantAnalysis(Operations.CodeScanningCreateVariantAnalysis.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get the summary of a CodeQL variant analysis
    ///
    /// Gets the summary of a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)`.
    public func codeScanningGetVariantAnalysis(
        path: Operations.CodeScanningGetVariantAnalysis.Input.Path,
        headers: Operations.CodeScanningGetVariantAnalysis.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetVariantAnalysis.Output {
        try await codeScanningGetVariantAnalysis(Operations.CodeScanningGetVariantAnalysis.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the analysis status of a repository in a CodeQL variant analysis
    ///
    /// Gets the analysis status of a repository in a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)`.
    public func codeScanningGetVariantAnalysisRepoTask(
        path: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Path,
        headers: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetVariantAnalysisRepoTask.Output {
        try await codeScanningGetVariantAnalysisRepoTask(Operations.CodeScanningGetVariantAnalysisRepoTask.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a code scanning default setup configuration
    ///
    /// Gets a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)`.
    public func codeScanningGetDefaultSetup(
        path: Operations.CodeScanningGetDefaultSetup.Input.Path,
        headers: Operations.CodeScanningGetDefaultSetup.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetDefaultSetup.Output {
        try await codeScanningGetDefaultSetup(Operations.CodeScanningGetDefaultSetup.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a code scanning default setup configuration
    ///
    /// Updates a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)`.
    public func codeScanningUpdateDefaultSetup(
        path: Operations.CodeScanningUpdateDefaultSetup.Input.Path,
        headers: Operations.CodeScanningUpdateDefaultSetup.Input.Headers = .init(),
        body: Operations.CodeScanningUpdateDefaultSetup.Input.Body
    ) async throws -> Operations.CodeScanningUpdateDefaultSetup.Output {
        try await codeScanningUpdateDefaultSetup(Operations.CodeScanningUpdateDefaultSetup.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Upload an analysis as SARIF data
    ///
    /// Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. For troubleshooting information, see "[Troubleshooting SARIF uploads](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif)."
    ///
    /// There are two places where you can upload code scanning results.
    ///  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
    ///  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
    ///
    /// You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
    ///
    /// ```
    /// gzip -c analysis-data.sarif | base64 -w0
    /// ```
    ///
    /// SARIF upload supports a maximum number of entries per the following data objects, and an analysis will be rejected if any of these objects is above its maximum value. For some objects, there are additional values over which the entries will be ignored while keeping the most important entries whenever applicable.
    /// To get the most out of your analysis when it includes data above the supported limits, try to optimize the analysis configuration. For example, for the CodeQL tool, identify and remove the most noisy queries. For more information, see "[SARIF results exceed one or more limits](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif/results-exceed-limit)."
    ///
    ///
    /// | **SARIF data**                   | **Maximum values** | **Additional limits**                                                            |
    /// |----------------------------------|:------------------:|----------------------------------------------------------------------------------|
    /// | Runs per file                    |         20         |                                                                                  |
    /// | Results per run                  |       25,000       | Only the top 5,000 results will be included, prioritized by severity.            |
    /// | Rules per run                    |       25,000       |                                                                                  |
    /// | Tool extensions per run          |        100         |                                                                                  |
    /// | Thread Flow Locations per result |       10,000       | Only the top 1,000 Thread Flow Locations will be included, using prioritization. |
    /// | Location per result	             |       1,000        | Only 100 locations will be included.                                             |
    /// | Tags per rule	                   |         20         | Only 10 tags will be included.                                                   |
    ///
    ///
    /// The `202 Accepted` response includes an `id` value.
    /// You can use this ID to check the status of the upload by using it in the `/sarifs/{sarif_id}` endpoint.
    /// For more information, see "[Get information about a SARIF upload](/rest/code-scanning/code-scanning#get-information-about-a-sarif-upload)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// This endpoint is limited to 1,000 requests per hour for each user or app installation calling it.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/sarifs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)`.
    public func codeScanningUploadSarif(
        path: Operations.CodeScanningUploadSarif.Input.Path,
        headers: Operations.CodeScanningUploadSarif.Input.Headers = .init(),
        body: Operations.CodeScanningUploadSarif.Input.Body
    ) async throws -> Operations.CodeScanningUploadSarif.Output {
        try await codeScanningUploadSarif(Operations.CodeScanningUploadSarif.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get information about a SARIF upload
    ///
    /// Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository)."
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)`.
    public func codeScanningGetSarif(
        path: Operations.CodeScanningGetSarif.Input.Path,
        headers: Operations.CodeScanningGetSarif.Input.Headers = .init()
    ) async throws -> Operations.CodeScanningGetSarif.Output {
        try await codeScanningGetSarif(Operations.CodeScanningGetSarif.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-repository`.
        public struct SimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `SimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// The security alert number.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-number`.
        public typealias AlertNumber = Swift.Int
        /// The REST API URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-url`.
        public typealias AlertUrl = Swift.String
        /// The GitHub URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-html-url`.
        public typealias AlertHtmlUrl = Swift.String
        /// The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-created-at`.
        public typealias AlertCreatedAt = Foundation.Date
        /// The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-updated-at`.
        public typealias AlertUpdatedAt = Foundation.Date
        /// The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-dismissed-at`.
        public typealias AlertDismissedAt = Foundation.Date
        /// The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-fixed-at`.
        public typealias AlertFixedAt = Foundation.Date
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// The name of the tool used to generate the code scanning analysis.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool-name`.
        public typealias CodeScanningAnalysisToolName = Swift.String
        /// The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool-guid`.
        public typealias CodeScanningAnalysisToolGuid = Swift.String
        /// State of a code scanning alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-state-query`.
        @frozen public enum CodeScanningAlertStateQuery: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case closed = "closed"
            case dismissed = "dismissed"
            case fixed = "fixed"
        }
        /// Severity of a code scanning alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-severity`.
        @frozen public enum CodeScanningAlertSeverity: String, Codable, Hashable, Sendable, CaseIterable {
            case critical = "critical"
            case high = "high"
            case medium = "medium"
            case low = "low"
            case warning = "warning"
            case note = "note"
            case error = "error"
        }
        /// The REST API URL for fetching the list of instances for an alert.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-instances-url`.
        public typealias AlertInstancesUrl = Swift.String
        /// State of a code scanning alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-state`.
        @frozen public enum CodeScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case dismissed = "dismissed"
            case fixed = "fixed"
        }
        /// **Required when the state is dismissed.** The reason for dismissing or closing the alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-dismissed-reason`.
        @frozen public enum CodeScanningAlertDismissedReason: String, Codable, Hashable, Sendable, CaseIterable {
            case falsePositive = "false positive"
            case won_apos_tFix = "won't fix"
            case usedInTests = "used in tests"
        }
        /// The dismissal comment associated with the dismissal of the alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-dismissed-comment`.
        public typealias CodeScanningAlertDismissedComment = Swift.String
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary`.
        public struct CodeScanningAlertRuleSummary: Codable, Hashable, Sendable {
            /// A unique identifier for the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/id`.
            public var id: Swift.String?
            /// The name of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/name`.
            public var name: Swift.String?
            /// The severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case note = "note"
                case warning = "warning"
                case error = "error"
            }
            /// The severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/severity`.
            public var severity: Components.Schemas.CodeScanningAlertRuleSummary.SeverityPayload?
            /// The security severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/security_severity_level`.
            @frozen public enum SecuritySeverityLevelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case low = "low"
                case medium = "medium"
                case high = "high"
                case critical = "critical"
            }
            /// The security severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/security_severity_level`.
            public var securitySeverityLevel: Components.Schemas.CodeScanningAlertRuleSummary.SecuritySeverityLevelPayload?
            /// A short description of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/description`.
            public var description: Swift.String?
            /// A description of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/full_description`.
            public var fullDescription: Swift.String?
            /// A set of tags applicable for the rule.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/tags`.
            public var tags: [Swift.String]?
            /// Detailed documentation for the rule as GitHub Flavored Markdown.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/help`.
            public var help: Swift.String?
            /// A link to the documentation for the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule-summary/help_uri`.
            public var helpUri: Swift.String?
            /// Creates a new `CodeScanningAlertRuleSummary`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the rule used to detect the alert.
            ///   - name: The name of the rule used to detect the alert.
            ///   - severity: The severity of the alert.
            ///   - securitySeverityLevel: The security severity of the alert.
            ///   - description: A short description of the rule used to detect the alert.
            ///   - fullDescription: A description of the rule used to detect the alert.
            ///   - tags: A set of tags applicable for the rule.
            ///   - help: Detailed documentation for the rule as GitHub Flavored Markdown.
            ///   - helpUri: A link to the documentation for the rule used to detect the alert.
            public init(
                id: Swift.String? = nil,
                name: Swift.String? = nil,
                severity: Components.Schemas.CodeScanningAlertRuleSummary.SeverityPayload? = nil,
                securitySeverityLevel: Components.Schemas.CodeScanningAlertRuleSummary.SecuritySeverityLevelPayload? = nil,
                description: Swift.String? = nil,
                fullDescription: Swift.String? = nil,
                tags: [Swift.String]? = nil,
                help: Swift.String? = nil,
                helpUri: Swift.String? = nil
            ) {
                self.id = id
                self.name = name
                self.severity = severity
                self.securitySeverityLevel = securitySeverityLevel
                self.description = description
                self.fullDescription = fullDescription
                self.tags = tags
                self.help = help
                self.helpUri = helpUri
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case severity
                case securitySeverityLevel = "security_severity_level"
                case description
                case fullDescription = "full_description"
                case tags
                case help
                case helpUri = "help_uri"
            }
        }
        /// The version of the tool used to generate the code scanning analysis.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool-version`.
        public typealias CodeScanningAnalysisToolVersion = Swift.String
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool`.
        public struct CodeScanningAnalysisTool: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool/name`.
            public var name: Components.Schemas.CodeScanningAnalysisToolName?
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool/version`.
            public var version: Components.Schemas.CodeScanningAnalysisToolVersion?
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-tool/guid`.
            public var guid: Components.Schemas.CodeScanningAnalysisToolGuid?
            /// Creates a new `CodeScanningAnalysisTool`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - version:
            ///   - guid:
            public init(
                name: Components.Schemas.CodeScanningAnalysisToolName? = nil,
                version: Components.Schemas.CodeScanningAnalysisToolVersion? = nil,
                guid: Components.Schemas.CodeScanningAnalysisToolGuid? = nil
            ) {
                self.name = name
                self.version = version
                self.guid = guid
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case version
                case guid
            }
        }
        /// The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`,
        /// `refs/heads/<branch name>` or simply `<branch name>`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-ref`.
        public typealias CodeScanningRef = Swift.String
        /// Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-analysis-key`.
        public typealias CodeScanningAnalysisAnalysisKey = Swift.String
        /// Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-environment`.
        public typealias CodeScanningAlertEnvironment = Swift.String
        /// Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-category`.
        public typealias CodeScanningAnalysisCategory = Swift.String
        /// Describe a region within a file for the alert.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location`.
        public struct CodeScanningAlertLocation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location/path`.
            public var path: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location/start_line`.
            public var startLine: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location/end_line`.
            public var endLine: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location/start_column`.
            public var startColumn: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-location/end_column`.
            public var endColumn: Swift.Int?
            /// Creates a new `CodeScanningAlertLocation`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - startLine:
            ///   - endLine:
            ///   - startColumn:
            ///   - endColumn:
            public init(
                path: Swift.String? = nil,
                startLine: Swift.Int? = nil,
                endLine: Swift.Int? = nil,
                startColumn: Swift.Int? = nil,
                endColumn: Swift.Int? = nil
            ) {
                self.path = path
                self.startLine = startLine
                self.endLine = endLine
                self.startColumn = startColumn
                self.endColumn = endColumn
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case startLine = "start_line"
                case endLine = "end_line"
                case startColumn = "start_column"
                case endColumn = "end_column"
            }
        }
        /// A classification of the file. For example to identify it as generated.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-classification`.
        @frozen public enum CodeScanningAlertClassification: String, Codable, Hashable, Sendable, CaseIterable {
            case source = "source"
            case generated = "generated"
            case test = "test"
            case library = "library"
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance`.
        public struct CodeScanningAlertInstance: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/ref`.
            public var ref: Components.Schemas.CodeScanningRef?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/analysis_key`.
            public var analysisKey: Components.Schemas.CodeScanningAnalysisAnalysisKey?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/environment`.
            public var environment: Components.Schemas.CodeScanningAlertEnvironment?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/category`.
            public var category: Components.Schemas.CodeScanningAnalysisCategory?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/state`.
            public var state: Components.Schemas.CodeScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/commit_sha`.
            public var commitSha: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/message`.
            public struct MessagePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/message/text`.
                public var text: Swift.String?
                /// Creates a new `MessagePayload`.
                ///
                /// - Parameters:
                ///   - text:
                public init(text: Swift.String? = nil) {
                    self.text = text
                }
                public enum CodingKeys: String, CodingKey {
                    case text
                }
            }
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/message`.
            public var message: Components.Schemas.CodeScanningAlertInstance.MessagePayload?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/location`.
            public var location: Components.Schemas.CodeScanningAlertLocation?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/html_url`.
            public var htmlUrl: Swift.String?
            /// Classifications that have been applied to the file that triggered the alert.
            /// For example identifying it as documentation, or a generated file.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-instance/classifications`.
            public var classifications: [Components.Schemas.CodeScanningAlertClassification]?
            /// Creates a new `CodeScanningAlertInstance`.
            ///
            /// - Parameters:
            ///   - ref:
            ///   - analysisKey:
            ///   - environment:
            ///   - category:
            ///   - state:
            ///   - commitSha:
            ///   - message:
            ///   - location:
            ///   - htmlUrl:
            ///   - classifications: Classifications that have been applied to the file that triggered the alert.
            public init(
                ref: Components.Schemas.CodeScanningRef? = nil,
                analysisKey: Components.Schemas.CodeScanningAnalysisAnalysisKey? = nil,
                environment: Components.Schemas.CodeScanningAlertEnvironment? = nil,
                category: Components.Schemas.CodeScanningAnalysisCategory? = nil,
                state: Components.Schemas.CodeScanningAlertState? = nil,
                commitSha: Swift.String? = nil,
                message: Components.Schemas.CodeScanningAlertInstance.MessagePayload? = nil,
                location: Components.Schemas.CodeScanningAlertLocation? = nil,
                htmlUrl: Swift.String? = nil,
                classifications: [Components.Schemas.CodeScanningAlertClassification]? = nil
            ) {
                self.ref = ref
                self.analysisKey = analysisKey
                self.environment = environment
                self.category = category
                self.state = state
                self.commitSha = commitSha
                self.message = message
                self.location = location
                self.htmlUrl = htmlUrl
                self.classifications = classifications
            }
            public enum CodingKeys: String, CodingKey {
                case ref
                case analysisKey = "analysis_key"
                case environment
                case category
                case state
                case commitSha = "commit_sha"
                case message
                case location
                case htmlUrl = "html_url"
                case classifications
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items`.
        public struct CodeScanningOrganizationAlertItems: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/number`.
            public var number: Components.Schemas.AlertNumber
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/updated_at`.
            public var updatedAt: Components.Schemas.AlertUpdatedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/url`.
            public var url: Components.Schemas.AlertUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/instances_url`.
            public var instancesUrl: Components.Schemas.AlertInstancesUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/state`.
            public var state: Components.Schemas.CodeScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/fixed_at`.
            public var fixedAt: Components.Schemas.AlertFixedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/dismissed_by`.
            public var dismissedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/dismissed_at`.
            public var dismissedAt: Components.Schemas.AlertDismissedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/dismissed_reason`.
            public var dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/dismissed_comment`.
            public var dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/rule`.
            public var rule: Components.Schemas.CodeScanningAlertRuleSummary
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/tool`.
            public var tool: Components.Schemas.CodeScanningAnalysisTool
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/most_recent_instance`.
            public var mostRecentInstance: Components.Schemas.CodeScanningAlertInstance
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/repository`.
            public var repository: Components.Schemas.SimpleRepository
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/dismissal_approved_by`.
            public var dismissalApprovedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-organization-alert-items/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// Creates a new `CodeScanningOrganizationAlertItems`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - instancesUrl:
            ///   - state:
            ///   - fixedAt:
            ///   - dismissedBy:
            ///   - dismissedAt:
            ///   - dismissedReason:
            ///   - dismissedComment:
            ///   - rule:
            ///   - tool:
            ///   - mostRecentInstance:
            ///   - repository:
            ///   - dismissalApprovedBy:
            ///   - assignees:
            public init(
                number: Components.Schemas.AlertNumber,
                createdAt: Components.Schemas.AlertCreatedAt,
                updatedAt: Components.Schemas.AlertUpdatedAt? = nil,
                url: Components.Schemas.AlertUrl,
                htmlUrl: Components.Schemas.AlertHtmlUrl,
                instancesUrl: Components.Schemas.AlertInstancesUrl,
                state: Components.Schemas.CodeScanningAlertState? = nil,
                fixedAt: Components.Schemas.AlertFixedAt? = nil,
                dismissedBy: Components.Schemas.NullableSimpleUser? = nil,
                dismissedAt: Components.Schemas.AlertDismissedAt? = nil,
                dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason? = nil,
                dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment? = nil,
                rule: Components.Schemas.CodeScanningAlertRuleSummary,
                tool: Components.Schemas.CodeScanningAnalysisTool,
                mostRecentInstance: Components.Schemas.CodeScanningAlertInstance,
                repository: Components.Schemas.SimpleRepository,
                dismissalApprovedBy: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.instancesUrl = instancesUrl
                self.state = state
                self.fixedAt = fixedAt
                self.dismissedBy = dismissedBy
                self.dismissedAt = dismissedAt
                self.dismissedReason = dismissedReason
                self.dismissedComment = dismissedComment
                self.rule = rule
                self.tool = tool
                self.mostRecentInstance = mostRecentInstance
                self.repository = repository
                self.dismissalApprovedBy = dismissalApprovedBy
                self.assignees = assignees
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case instancesUrl = "instances_url"
                case state
                case fixedAt = "fixed_at"
                case dismissedBy = "dismissed_by"
                case dismissedAt = "dismissed_at"
                case dismissedReason = "dismissed_reason"
                case dismissedComment = "dismissed_comment"
                case rule
                case tool
                case mostRecentInstance = "most_recent_instance"
                case repository
                case dismissalApprovedBy = "dismissal_approved_by"
                case assignees
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items`.
        public struct CodeScanningAlertItems: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/number`.
            public var number: Components.Schemas.AlertNumber
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/updated_at`.
            public var updatedAt: Components.Schemas.AlertUpdatedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/url`.
            public var url: Components.Schemas.AlertUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/instances_url`.
            public var instancesUrl: Components.Schemas.AlertInstancesUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/state`.
            public var state: Components.Schemas.CodeScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/fixed_at`.
            public var fixedAt: Components.Schemas.AlertFixedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/dismissed_by`.
            public var dismissedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/dismissed_at`.
            public var dismissedAt: Components.Schemas.AlertDismissedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/dismissed_reason`.
            public var dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/dismissed_comment`.
            public var dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/rule`.
            public var rule: Components.Schemas.CodeScanningAlertRuleSummary
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/tool`.
            public var tool: Components.Schemas.CodeScanningAnalysisTool
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/most_recent_instance`.
            public var mostRecentInstance: Components.Schemas.CodeScanningAlertInstance
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/dismissal_approved_by`.
            public var dismissalApprovedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-items/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// Creates a new `CodeScanningAlertItems`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - instancesUrl:
            ///   - state:
            ///   - fixedAt:
            ///   - dismissedBy:
            ///   - dismissedAt:
            ///   - dismissedReason:
            ///   - dismissedComment:
            ///   - rule:
            ///   - tool:
            ///   - mostRecentInstance:
            ///   - dismissalApprovedBy:
            ///   - assignees:
            public init(
                number: Components.Schemas.AlertNumber,
                createdAt: Components.Schemas.AlertCreatedAt,
                updatedAt: Components.Schemas.AlertUpdatedAt? = nil,
                url: Components.Schemas.AlertUrl,
                htmlUrl: Components.Schemas.AlertHtmlUrl,
                instancesUrl: Components.Schemas.AlertInstancesUrl,
                state: Components.Schemas.CodeScanningAlertState? = nil,
                fixedAt: Components.Schemas.AlertFixedAt? = nil,
                dismissedBy: Components.Schemas.NullableSimpleUser? = nil,
                dismissedAt: Components.Schemas.AlertDismissedAt? = nil,
                dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason? = nil,
                dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment? = nil,
                rule: Components.Schemas.CodeScanningAlertRuleSummary,
                tool: Components.Schemas.CodeScanningAnalysisTool,
                mostRecentInstance: Components.Schemas.CodeScanningAlertInstance,
                dismissalApprovedBy: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.instancesUrl = instancesUrl
                self.state = state
                self.fixedAt = fixedAt
                self.dismissedBy = dismissedBy
                self.dismissedAt = dismissedAt
                self.dismissedReason = dismissedReason
                self.dismissedComment = dismissedComment
                self.rule = rule
                self.tool = tool
                self.mostRecentInstance = mostRecentInstance
                self.dismissalApprovedBy = dismissalApprovedBy
                self.assignees = assignees
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case instancesUrl = "instances_url"
                case state
                case fixedAt = "fixed_at"
                case dismissedBy = "dismissed_by"
                case dismissedAt = "dismissed_at"
                case dismissedReason = "dismissed_reason"
                case dismissedComment = "dismissed_comment"
                case rule
                case tool
                case mostRecentInstance = "most_recent_instance"
                case dismissalApprovedBy = "dismissal_approved_by"
                case assignees
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule`.
        public struct CodeScanningAlertRule: Codable, Hashable, Sendable {
            /// A unique identifier for the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/id`.
            public var id: Swift.String?
            /// The name of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/name`.
            public var name: Swift.String?
            /// The severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case note = "note"
                case warning = "warning"
                case error = "error"
            }
            /// The severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/severity`.
            public var severity: Components.Schemas.CodeScanningAlertRule.SeverityPayload?
            /// The security severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/security_severity_level`.
            @frozen public enum SecuritySeverityLevelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case low = "low"
                case medium = "medium"
                case high = "high"
                case critical = "critical"
            }
            /// The security severity of the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/security_severity_level`.
            public var securitySeverityLevel: Components.Schemas.CodeScanningAlertRule.SecuritySeverityLevelPayload?
            /// A short description of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/description`.
            public var description: Swift.String?
            /// A description of the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/full_description`.
            public var fullDescription: Swift.String?
            /// A set of tags applicable for the rule.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/tags`.
            public var tags: [Swift.String]?
            /// Detailed documentation for the rule as GitHub Flavored Markdown.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/help`.
            public var help: Swift.String?
            /// A link to the documentation for the rule used to detect the alert.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert-rule/help_uri`.
            public var helpUri: Swift.String?
            /// Creates a new `CodeScanningAlertRule`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the rule used to detect the alert.
            ///   - name: The name of the rule used to detect the alert.
            ///   - severity: The severity of the alert.
            ///   - securitySeverityLevel: The security severity of the alert.
            ///   - description: A short description of the rule used to detect the alert.
            ///   - fullDescription: A description of the rule used to detect the alert.
            ///   - tags: A set of tags applicable for the rule.
            ///   - help: Detailed documentation for the rule as GitHub Flavored Markdown.
            ///   - helpUri: A link to the documentation for the rule used to detect the alert.
            public init(
                id: Swift.String? = nil,
                name: Swift.String? = nil,
                severity: Components.Schemas.CodeScanningAlertRule.SeverityPayload? = nil,
                securitySeverityLevel: Components.Schemas.CodeScanningAlertRule.SecuritySeverityLevelPayload? = nil,
                description: Swift.String? = nil,
                fullDescription: Swift.String? = nil,
                tags: [Swift.String]? = nil,
                help: Swift.String? = nil,
                helpUri: Swift.String? = nil
            ) {
                self.id = id
                self.name = name
                self.severity = severity
                self.securitySeverityLevel = securitySeverityLevel
                self.description = description
                self.fullDescription = fullDescription
                self.tags = tags
                self.help = help
                self.helpUri = helpUri
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case severity
                case securitySeverityLevel = "security_severity_level"
                case description
                case fullDescription = "full_description"
                case tags
                case help
                case helpUri = "help_uri"
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert`.
        public struct CodeScanningAlert: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/number`.
            public var number: Components.Schemas.AlertNumber
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/updated_at`.
            public var updatedAt: Components.Schemas.AlertUpdatedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/url`.
            public var url: Components.Schemas.AlertUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/instances_url`.
            public var instancesUrl: Components.Schemas.AlertInstancesUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/state`.
            public var state: Components.Schemas.CodeScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/fixed_at`.
            public var fixedAt: Components.Schemas.AlertFixedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/dismissed_by`.
            public var dismissedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/dismissed_at`.
            public var dismissedAt: Components.Schemas.AlertDismissedAt?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/dismissed_reason`.
            public var dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/dismissed_comment`.
            public var dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/rule`.
            public var rule: Components.Schemas.CodeScanningAlertRule
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/tool`.
            public var tool: Components.Schemas.CodeScanningAnalysisTool
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/most_recent_instance`.
            public var mostRecentInstance: Components.Schemas.CodeScanningAlertInstance
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/dismissal_approved_by`.
            public var dismissalApprovedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/code-scanning-alert/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// Creates a new `CodeScanningAlert`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - instancesUrl:
            ///   - state:
            ///   - fixedAt:
            ///   - dismissedBy:
            ///   - dismissedAt:
            ///   - dismissedReason:
            ///   - dismissedComment:
            ///   - rule:
            ///   - tool:
            ///   - mostRecentInstance:
            ///   - dismissalApprovedBy:
            ///   - assignees:
            public init(
                number: Components.Schemas.AlertNumber,
                createdAt: Components.Schemas.AlertCreatedAt,
                updatedAt: Components.Schemas.AlertUpdatedAt? = nil,
                url: Components.Schemas.AlertUrl,
                htmlUrl: Components.Schemas.AlertHtmlUrl,
                instancesUrl: Components.Schemas.AlertInstancesUrl,
                state: Components.Schemas.CodeScanningAlertState? = nil,
                fixedAt: Components.Schemas.AlertFixedAt? = nil,
                dismissedBy: Components.Schemas.NullableSimpleUser? = nil,
                dismissedAt: Components.Schemas.AlertDismissedAt? = nil,
                dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason? = nil,
                dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment? = nil,
                rule: Components.Schemas.CodeScanningAlertRule,
                tool: Components.Schemas.CodeScanningAnalysisTool,
                mostRecentInstance: Components.Schemas.CodeScanningAlertInstance,
                dismissalApprovedBy: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.instancesUrl = instancesUrl
                self.state = state
                self.fixedAt = fixedAt
                self.dismissedBy = dismissedBy
                self.dismissedAt = dismissedAt
                self.dismissedReason = dismissedReason
                self.dismissedComment = dismissedComment
                self.rule = rule
                self.tool = tool
                self.mostRecentInstance = mostRecentInstance
                self.dismissalApprovedBy = dismissalApprovedBy
                self.assignees = assignees
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case instancesUrl = "instances_url"
                case state
                case fixedAt = "fixed_at"
                case dismissedBy = "dismissed_by"
                case dismissedAt = "dismissed_at"
                case dismissedReason = "dismissed_reason"
                case dismissedComment = "dismissed_comment"
                case rule
                case tool
                case mostRecentInstance = "most_recent_instance"
                case dismissalApprovedBy = "dismissal_approved_by"
                case assignees
            }
        }
        /// Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-set-state`.
        @frozen public enum CodeScanningAlertSetState: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case dismissed = "dismissed"
        }
        /// If `true`, attempt to create an alert dismissal request.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-alert-create-request`.
        public typealias CodeScanningAlertCreateRequest = Swift.Bool
        /// The status of an autofix.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-status`.
        @frozen public enum CodeScanningAutofixStatus: String, Codable, Hashable, Sendable, CaseIterable {
            case pending = "pending"
            case error = "error"
            case success = "success"
            case outdated = "outdated"
        }
        /// The description of an autofix.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-description`.
        public typealias CodeScanningAutofixDescription = Swift.String
        /// The start time of an autofix in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-started-at`.
        public typealias CodeScanningAutofixStartedAt = Foundation.Date
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix`.
        public struct CodeScanningAutofix: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix/status`.
            public var status: Components.Schemas.CodeScanningAutofixStatus
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix/description`.
            public var description: Components.Schemas.CodeScanningAutofixDescription?
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix/started_at`.
            public var startedAt: Components.Schemas.CodeScanningAutofixStartedAt
            /// Creates a new `CodeScanningAutofix`.
            ///
            /// - Parameters:
            ///   - status:
            ///   - description:
            ///   - startedAt:
            public init(
                status: Components.Schemas.CodeScanningAutofixStatus,
                description: Components.Schemas.CodeScanningAutofixDescription? = nil,
                startedAt: Components.Schemas.CodeScanningAutofixStartedAt
            ) {
                self.status = status
                self.description = description
                self.startedAt = startedAt
            }
            public enum CodingKeys: String, CodingKey {
                case status
                case description
                case startedAt = "started_at"
            }
        }
        /// Commit an autofix for a code scanning alert
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits`.
        public struct CodeScanningAutofixCommits: Codable, Hashable, Sendable {
            /// The Git reference of target branch for the commit. Branch needs to already exist.  For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits/target_ref`.
            public var targetRef: Swift.String?
            /// Commit message to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits/message`.
            public var message: Swift.String?
            /// Creates a new `CodeScanningAutofixCommits`.
            ///
            /// - Parameters:
            ///   - targetRef: The Git reference of target branch for the commit. Branch needs to already exist.  For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
            ///   - message: Commit message to be used.
            public init(
                targetRef: Swift.String? = nil,
                message: Swift.String? = nil
            ) {
                self.targetRef = targetRef
                self.message = message
            }
            public enum CodingKeys: String, CodingKey {
                case targetRef = "target_ref"
                case message
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits-response`.
        public struct CodeScanningAutofixCommitsResponse: Codable, Hashable, Sendable {
            /// The Git reference of target branch for the commit. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits-response/target_ref`.
            public var targetRef: Swift.String?
            /// SHA of commit with autofix.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-autofix-commits-response/sha`.
            public var sha: Swift.String?
            /// Creates a new `CodeScanningAutofixCommitsResponse`.
            ///
            /// - Parameters:
            ///   - targetRef: The Git reference of target branch for the commit. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
            ///   - sha: SHA of commit with autofix.
            public init(
                targetRef: Swift.String? = nil,
                sha: Swift.String? = nil
            ) {
                self.targetRef = targetRef
                self.sha = sha
            }
            public enum CodingKeys: String, CodingKey {
                case targetRef = "target_ref"
                case sha
            }
        }
        /// An identifier for the upload.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-sarif-id`.
        public typealias CodeScanningAnalysisSarifId = Swift.String
        /// The SHA of the commit to which the analysis you are uploading relates.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-commit-sha`.
        public typealias CodeScanningAnalysisCommitSha = Swift.String
        /// Identifies the variable values associated with the environment in which this analysis was performed.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-environment`.
        public typealias CodeScanningAnalysisEnvironment = Swift.String
        /// The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-created-at`.
        public typealias CodeScanningAnalysisCreatedAt = Foundation.Date
        /// The REST API URL of the analysis resource.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-url`.
        public typealias CodeScanningAnalysisUrl = Swift.String
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis`.
        public struct CodeScanningAnalysis: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/ref`.
            public var ref: Components.Schemas.CodeScanningRef
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/commit_sha`.
            public var commitSha: Components.Schemas.CodeScanningAnalysisCommitSha
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/analysis_key`.
            public var analysisKey: Components.Schemas.CodeScanningAnalysisAnalysisKey
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/environment`.
            public var environment: Components.Schemas.CodeScanningAnalysisEnvironment
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/category`.
            public var category: Components.Schemas.CodeScanningAnalysisCategory?
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/error`.
            public var error: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/created_at`.
            public var createdAt: Components.Schemas.CodeScanningAnalysisCreatedAt
            /// The total number of results in the analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/results_count`.
            public var resultsCount: Swift.Int
            /// The total number of rules used in the analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/rules_count`.
            public var rulesCount: Swift.Int
            /// Unique identifier for this analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/url`.
            public var url: Components.Schemas.CodeScanningAnalysisUrl
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/sarif_id`.
            public var sarifId: Components.Schemas.CodeScanningAnalysisSarifId
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/tool`.
            public var tool: Components.Schemas.CodeScanningAnalysisTool
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/deletable`.
            public var deletable: Swift.Bool
            /// Warning generated when processing the analysis
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis/warning`.
            public var warning: Swift.String
            /// Creates a new `CodeScanningAnalysis`.
            ///
            /// - Parameters:
            ///   - ref:
            ///   - commitSha:
            ///   - analysisKey:
            ///   - environment:
            ///   - category:
            ///   - error:
            ///   - createdAt:
            ///   - resultsCount: The total number of results in the analysis.
            ///   - rulesCount: The total number of rules used in the analysis.
            ///   - id: Unique identifier for this analysis.
            ///   - url:
            ///   - sarifId:
            ///   - tool:
            ///   - deletable:
            ///   - warning: Warning generated when processing the analysis
            public init(
                ref: Components.Schemas.CodeScanningRef,
                commitSha: Components.Schemas.CodeScanningAnalysisCommitSha,
                analysisKey: Components.Schemas.CodeScanningAnalysisAnalysisKey,
                environment: Components.Schemas.CodeScanningAnalysisEnvironment,
                category: Components.Schemas.CodeScanningAnalysisCategory? = nil,
                error: Swift.String,
                createdAt: Components.Schemas.CodeScanningAnalysisCreatedAt,
                resultsCount: Swift.Int,
                rulesCount: Swift.Int,
                id: Swift.Int,
                url: Components.Schemas.CodeScanningAnalysisUrl,
                sarifId: Components.Schemas.CodeScanningAnalysisSarifId,
                tool: Components.Schemas.CodeScanningAnalysisTool,
                deletable: Swift.Bool,
                warning: Swift.String
            ) {
                self.ref = ref
                self.commitSha = commitSha
                self.analysisKey = analysisKey
                self.environment = environment
                self.category = category
                self.error = error
                self.createdAt = createdAt
                self.resultsCount = resultsCount
                self.rulesCount = rulesCount
                self.id = id
                self.url = url
                self.sarifId = sarifId
                self.tool = tool
                self.deletable = deletable
                self.warning = warning
            }
            public enum CodingKeys: String, CodingKey {
                case ref
                case commitSha = "commit_sha"
                case analysisKey = "analysis_key"
                case environment
                case category
                case error
                case createdAt = "created_at"
                case resultsCount = "results_count"
                case rulesCount = "rules_count"
                case id
                case url
                case sarifId = "sarif_id"
                case tool
                case deletable
                case warning
            }
        }
        /// Successful deletion of a code scanning analysis
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-deletion`.
        public struct CodeScanningAnalysisDeletion: Codable, Hashable, Sendable {
            /// Next deletable analysis in chain, without last analysis deletion confirmation
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-deletion/next_analysis_url`.
            public var nextAnalysisUrl: Swift.String?
            /// Next deletable analysis in chain, with last analysis deletion confirmation
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-deletion/confirm_delete_url`.
            public var confirmDeleteUrl: Swift.String?
            /// Creates a new `CodeScanningAnalysisDeletion`.
            ///
            /// - Parameters:
            ///   - nextAnalysisUrl: Next deletable analysis in chain, without last analysis deletion confirmation
            ///   - confirmDeleteUrl: Next deletable analysis in chain, with last analysis deletion confirmation
            public init(
                nextAnalysisUrl: Swift.String? = nil,
                confirmDeleteUrl: Swift.String? = nil
            ) {
                self.nextAnalysisUrl = nextAnalysisUrl
                self.confirmDeleteUrl = confirmDeleteUrl
            }
            public enum CodingKeys: String, CodingKey {
                case nextAnalysisUrl = "next_analysis_url"
                case confirmDeleteUrl = "confirm_delete_url"
            }
        }
        /// A CodeQL database.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database`.
        public struct CodeScanningCodeqlDatabase: Codable, Hashable, Sendable {
            /// The ID of the CodeQL database.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/id`.
            public var id: Swift.Int
            /// The name of the CodeQL database.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/name`.
            public var name: Swift.String
            /// The language of the CodeQL database.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/language`.
            public var language: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/uploader`.
            public var uploader: Components.Schemas.SimpleUser
            /// The MIME type of the CodeQL database file.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/content_type`.
            public var contentType: Swift.String
            /// The size of the CodeQL database file in bytes.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/size`.
            public var size: Swift.Int
            /// The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/updated_at`.
            public var updatedAt: Foundation.Date
            /// The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/url`.
            public var url: Swift.String
            /// The commit SHA of the repository at the time the CodeQL database was created.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-codeql-database/commit_oid`.
            public var commitOid: Swift.String?
            /// Creates a new `CodeScanningCodeqlDatabase`.
            ///
            /// - Parameters:
            ///   - id: The ID of the CodeQL database.
            ///   - name: The name of the CodeQL database.
            ///   - language: The language of the CodeQL database.
            ///   - uploader:
            ///   - contentType: The MIME type of the CodeQL database file.
            ///   - size: The size of the CodeQL database file in bytes.
            ///   - createdAt: The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - url: The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.
            ///   - commitOid: The commit SHA of the repository at the time the CodeQL database was created.
            public init(
                id: Swift.Int,
                name: Swift.String,
                language: Swift.String,
                uploader: Components.Schemas.SimpleUser,
                contentType: Swift.String,
                size: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                url: Swift.String,
                commitOid: Swift.String? = nil
            ) {
                self.id = id
                self.name = name
                self.language = language
                self.uploader = uploader
                self.contentType = contentType
                self.size = size
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.commitOid = commitOid
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case language
                case uploader
                case contentType = "content_type"
                case size
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case commitOid = "commit_oid"
            }
        }
        /// The language targeted by the CodeQL query
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-language`.
        @frozen public enum CodeScanningVariantAnalysisLanguage: String, Codable, Hashable, Sendable, CaseIterable {
            case cpp = "cpp"
            case csharp = "csharp"
            case go = "go"
            case java = "java"
            case javascript = "javascript"
            case python = "python"
            case ruby = "ruby"
            case rust = "rust"
            case swift = "swift"
        }
        /// Repository Identifier
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository`.
        public struct CodeScanningVariantAnalysisRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/id`.
            public var id: Swift.Int
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/full_name`.
            public var fullName: Swift.String
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Creates a new `CodeScanningVariantAnalysisRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - _private: Whether the repository is private.
            ///   - stargazersCount:
            ///   - updatedAt:
            public init(
                id: Swift.Int,
                name: Swift.String,
                fullName: Swift.String,
                _private: Swift.Bool,
                stargazersCount: Swift.Int,
                updatedAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.fullName = fullName
                self._private = _private
                self.stargazersCount = stargazersCount
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case fullName = "full_name"
                case _private = "private"
                case stargazersCount = "stargazers_count"
                case updatedAt = "updated_at"
            }
        }
        /// The new status of the CodeQL variant analysis repository task.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-status`.
        @frozen public enum CodeScanningVariantAnalysisStatus: String, Codable, Hashable, Sendable, CaseIterable {
            case pending = "pending"
            case inProgress = "in_progress"
            case succeeded = "succeeded"
            case failed = "failed"
            case canceled = "canceled"
            case timedOut = "timed_out"
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-skipped-repo-group`.
        public struct CodeScanningVariantAnalysisSkippedRepoGroup: Codable, Hashable, Sendable {
            /// The total number of repositories that were skipped for this reason.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-skipped-repo-group/repository_count`.
            public var repositoryCount: Swift.Int
            /// A list of repositories that were skipped. This list may not include all repositories that were skipped. This is only available when the repository was found and the user has access to it.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-skipped-repo-group/repositories`.
            public var repositories: [Components.Schemas.CodeScanningVariantAnalysisRepository]
            /// Creates a new `CodeScanningVariantAnalysisSkippedRepoGroup`.
            ///
            /// - Parameters:
            ///   - repositoryCount: The total number of repositories that were skipped for this reason.
            ///   - repositories: A list of repositories that were skipped. This list may not include all repositories that were skipped. This is only available when the repository was found and the user has access to it.
            public init(
                repositoryCount: Swift.Int,
                repositories: [Components.Schemas.CodeScanningVariantAnalysisRepository]
            ) {
                self.repositoryCount = repositoryCount
                self.repositories = repositories
            }
            public enum CodingKeys: String, CodingKey {
                case repositoryCount = "repository_count"
                case repositories
            }
        }
        /// A run of a CodeQL query against one or more repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis`.
        public struct CodeScanningVariantAnalysis: Codable, Hashable, Sendable {
            /// The ID of the variant analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/controller_repo`.
            public var controllerRepo: Components.Schemas.SimpleRepository
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/actor`.
            public var actor: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/query_language`.
            public var queryLanguage: Components.Schemas.CodeScanningVariantAnalysisLanguage
            /// The download url for the query pack.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/query_pack_url`.
            public var queryPackUrl: Swift.String
            /// The date and time at which the variant analysis was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/created_at`.
            public var createdAt: Foundation.Date?
            /// The date and time at which the variant analysis was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The date and time at which the variant analysis was completed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the variant analysis has not yet completed or this information is not available.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/completed_at`.
            public var completedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case inProgress = "in_progress"
                case succeeded = "succeeded"
                case failed = "failed"
                case cancelled = "cancelled"
            }
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/status`.
            public var status: Components.Schemas.CodeScanningVariantAnalysis.StatusPayload
            /// The GitHub Actions workflow run used to execute this variant analysis. This is only available if the workflow run has started.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/actions_workflow_run_id`.
            public var actionsWorkflowRunId: Swift.Int?
            /// The reason for a failure of the variant analysis. This is only available if the variant analysis has failed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/failure_reason`.
            @frozen public enum FailureReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case noReposQueried = "no_repos_queried"
                case actionsWorkflowRunFailed = "actions_workflow_run_failed"
                case internalError = "internal_error"
            }
            /// The reason for a failure of the variant analysis. This is only available if the variant analysis has failed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/failure_reason`.
            public var failureReason: Components.Schemas.CodeScanningVariantAnalysis.FailureReasonPayload?
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload`.
            public struct ScannedRepositoriesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload/repository`.
                public var repository: Components.Schemas.CodeScanningVariantAnalysisRepository
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload/analysis_status`.
                public var analysisStatus: Components.Schemas.CodeScanningVariantAnalysisStatus
                /// The number of results in the case of a successful analysis. This is only available for successful analyses.
                ///
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload/result_count`.
                public var resultCount: Swift.Int?
                /// The size of the artifact. This is only available for successful analyses.
                ///
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload/artifact_size_in_bytes`.
                public var artifactSizeInBytes: Swift.Int?
                /// The reason of the failure of this repo task. This is only available if the repository task has failed.
                ///
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/ScannedRepositoriesPayload/failure_message`.
                public var failureMessage: Swift.String?
                /// Creates a new `ScannedRepositoriesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - repository:
                ///   - analysisStatus:
                ///   - resultCount: The number of results in the case of a successful analysis. This is only available for successful analyses.
                ///   - artifactSizeInBytes: The size of the artifact. This is only available for successful analyses.
                ///   - failureMessage: The reason of the failure of this repo task. This is only available if the repository task has failed.
                public init(
                    repository: Components.Schemas.CodeScanningVariantAnalysisRepository,
                    analysisStatus: Components.Schemas.CodeScanningVariantAnalysisStatus,
                    resultCount: Swift.Int? = nil,
                    artifactSizeInBytes: Swift.Int? = nil,
                    failureMessage: Swift.String? = nil
                ) {
                    self.repository = repository
                    self.analysisStatus = analysisStatus
                    self.resultCount = resultCount
                    self.artifactSizeInBytes = artifactSizeInBytes
                    self.failureMessage = failureMessage
                }
                public enum CodingKeys: String, CodingKey {
                    case repository
                    case analysisStatus = "analysis_status"
                    case resultCount = "result_count"
                    case artifactSizeInBytes = "artifact_size_in_bytes"
                    case failureMessage = "failure_message"
                }
            }
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/scanned_repositories`.
            public typealias ScannedRepositoriesPayload = [Components.Schemas.CodeScanningVariantAnalysis.ScannedRepositoriesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/scanned_repositories`.
            public var scannedRepositories: Components.Schemas.CodeScanningVariantAnalysis.ScannedRepositoriesPayload?
            /// Information about repositories that were skipped from processing. This information is only available to the user that initiated the variant analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories`.
            public struct SkippedRepositoriesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/access_mismatch_repos`.
                public var accessMismatchRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/not_found_repos`.
                public struct NotFoundReposPayload: Codable, Hashable, Sendable {
                    /// The total number of repositories that were skipped for this reason.
                    ///
                    /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/not_found_repos/repository_count`.
                    public var repositoryCount: Swift.Int
                    /// A list of full repository names that were skipped. This list may not include all repositories that were skipped.
                    ///
                    /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/not_found_repos/repository_full_names`.
                    public var repositoryFullNames: [Swift.String]
                    /// Creates a new `NotFoundReposPayload`.
                    ///
                    /// - Parameters:
                    ///   - repositoryCount: The total number of repositories that were skipped for this reason.
                    ///   - repositoryFullNames: A list of full repository names that were skipped. This list may not include all repositories that were skipped.
                    public init(
                        repositoryCount: Swift.Int,
                        repositoryFullNames: [Swift.String]
                    ) {
                        self.repositoryCount = repositoryCount
                        self.repositoryFullNames = repositoryFullNames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case repositoryCount = "repository_count"
                        case repositoryFullNames = "repository_full_names"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/not_found_repos`.
                public var notFoundRepos: Components.Schemas.CodeScanningVariantAnalysis.SkippedRepositoriesPayload.NotFoundReposPayload
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/no_codeql_db_repos`.
                public var noCodeqlDbRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup
                /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories/over_limit_repos`.
                public var overLimitRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup
                /// Creates a new `SkippedRepositoriesPayload`.
                ///
                /// - Parameters:
                ///   - accessMismatchRepos:
                ///   - notFoundRepos:
                ///   - noCodeqlDbRepos:
                ///   - overLimitRepos:
                public init(
                    accessMismatchRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup,
                    notFoundRepos: Components.Schemas.CodeScanningVariantAnalysis.SkippedRepositoriesPayload.NotFoundReposPayload,
                    noCodeqlDbRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup,
                    overLimitRepos: Components.Schemas.CodeScanningVariantAnalysisSkippedRepoGroup
                ) {
                    self.accessMismatchRepos = accessMismatchRepos
                    self.notFoundRepos = notFoundRepos
                    self.noCodeqlDbRepos = noCodeqlDbRepos
                    self.overLimitRepos = overLimitRepos
                }
                public enum CodingKeys: String, CodingKey {
                    case accessMismatchRepos = "access_mismatch_repos"
                    case notFoundRepos = "not_found_repos"
                    case noCodeqlDbRepos = "no_codeql_db_repos"
                    case overLimitRepos = "over_limit_repos"
                }
            }
            /// Information about repositories that were skipped from processing. This information is only available to the user that initiated the variant analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis/skipped_repositories`.
            public var skippedRepositories: Components.Schemas.CodeScanningVariantAnalysis.SkippedRepositoriesPayload?
            /// Creates a new `CodeScanningVariantAnalysis`.
            ///
            /// - Parameters:
            ///   - id: The ID of the variant analysis.
            ///   - controllerRepo:
            ///   - actor:
            ///   - queryLanguage:
            ///   - queryPackUrl: The download url for the query pack.
            ///   - createdAt: The date and time at which the variant analysis was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the variant analysis was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - completedAt: The date and time at which the variant analysis was completed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the variant analysis has not yet completed or this information is not available.
            ///   - status:
            ///   - actionsWorkflowRunId: The GitHub Actions workflow run used to execute this variant analysis. This is only available if the workflow run has started.
            ///   - failureReason: The reason for a failure of the variant analysis. This is only available if the variant analysis has failed.
            ///   - scannedRepositories:
            ///   - skippedRepositories: Information about repositories that were skipped from processing. This information is only available to the user that initiated the variant analysis.
            public init(
                id: Swift.Int,
                controllerRepo: Components.Schemas.SimpleRepository,
                actor: Components.Schemas.SimpleUser,
                queryLanguage: Components.Schemas.CodeScanningVariantAnalysisLanguage,
                queryPackUrl: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                completedAt: Foundation.Date? = nil,
                status: Components.Schemas.CodeScanningVariantAnalysis.StatusPayload,
                actionsWorkflowRunId: Swift.Int? = nil,
                failureReason: Components.Schemas.CodeScanningVariantAnalysis.FailureReasonPayload? = nil,
                scannedRepositories: Components.Schemas.CodeScanningVariantAnalysis.ScannedRepositoriesPayload? = nil,
                skippedRepositories: Components.Schemas.CodeScanningVariantAnalysis.SkippedRepositoriesPayload? = nil
            ) {
                self.id = id
                self.controllerRepo = controllerRepo
                self.actor = actor
                self.queryLanguage = queryLanguage
                self.queryPackUrl = queryPackUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.completedAt = completedAt
                self.status = status
                self.actionsWorkflowRunId = actionsWorkflowRunId
                self.failureReason = failureReason
                self.scannedRepositories = scannedRepositories
                self.skippedRepositories = skippedRepositories
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case controllerRepo = "controller_repo"
                case actor
                case queryLanguage = "query_language"
                case queryPackUrl = "query_pack_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case completedAt = "completed_at"
                case status
                case actionsWorkflowRunId = "actions_workflow_run_id"
                case failureReason = "failure_reason"
                case scannedRepositories = "scanned_repositories"
                case skippedRepositories = "skipped_repositories"
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task`.
        public struct CodeScanningVariantAnalysisRepoTask: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/repository`.
            public var repository: Components.Schemas.SimpleRepository
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/analysis_status`.
            public var analysisStatus: Components.Schemas.CodeScanningVariantAnalysisStatus
            /// The size of the artifact. This is only available for successful analyses.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/artifact_size_in_bytes`.
            public var artifactSizeInBytes: Swift.Int?
            /// The number of results in the case of a successful analysis. This is only available for successful analyses.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/result_count`.
            public var resultCount: Swift.Int?
            /// The reason of the failure of this repo task. This is only available if the repository task has failed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/failure_message`.
            public var failureMessage: Swift.String?
            /// The SHA of the commit the CodeQL database was built against. This is only available for successful analyses.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/database_commit_sha`.
            public var databaseCommitSha: Swift.String?
            /// The source location prefix to use. This is only available for successful analyses.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/source_location_prefix`.
            public var sourceLocationPrefix: Swift.String?
            /// The URL of the artifact. This is only available for successful analyses.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-variant-analysis-repo-task/artifact_url`.
            public var artifactUrl: Swift.String?
            /// Creates a new `CodeScanningVariantAnalysisRepoTask`.
            ///
            /// - Parameters:
            ///   - repository:
            ///   - analysisStatus:
            ///   - artifactSizeInBytes: The size of the artifact. This is only available for successful analyses.
            ///   - resultCount: The number of results in the case of a successful analysis. This is only available for successful analyses.
            ///   - failureMessage: The reason of the failure of this repo task. This is only available if the repository task has failed.
            ///   - databaseCommitSha: The SHA of the commit the CodeQL database was built against. This is only available for successful analyses.
            ///   - sourceLocationPrefix: The source location prefix to use. This is only available for successful analyses.
            ///   - artifactUrl: The URL of the artifact. This is only available for successful analyses.
            public init(
                repository: Components.Schemas.SimpleRepository,
                analysisStatus: Components.Schemas.CodeScanningVariantAnalysisStatus,
                artifactSizeInBytes: Swift.Int? = nil,
                resultCount: Swift.Int? = nil,
                failureMessage: Swift.String? = nil,
                databaseCommitSha: Swift.String? = nil,
                sourceLocationPrefix: Swift.String? = nil,
                artifactUrl: Swift.String? = nil
            ) {
                self.repository = repository
                self.analysisStatus = analysisStatus
                self.artifactSizeInBytes = artifactSizeInBytes
                self.resultCount = resultCount
                self.failureMessage = failureMessage
                self.databaseCommitSha = databaseCommitSha
                self.sourceLocationPrefix = sourceLocationPrefix
                self.artifactUrl = artifactUrl
            }
            public enum CodingKeys: String, CodingKey {
                case repository
                case analysisStatus = "analysis_status"
                case artifactSizeInBytes = "artifact_size_in_bytes"
                case resultCount = "result_count"
                case failureMessage = "failure_message"
                case databaseCommitSha = "database_commit_sha"
                case sourceLocationPrefix = "source_location_prefix"
                case artifactUrl = "artifact_url"
            }
        }
        /// Configuration for code scanning default setup.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup`.
        public struct CodeScanningDefaultSetup: Codable, Hashable, Sendable {
            /// Code scanning default setup has been configured or not.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case configured = "configured"
                case notConfigured = "not-configured"
            }
            /// Code scanning default setup has been configured or not.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/state`.
            public var state: Components.Schemas.CodeScanningDefaultSetup.StatePayload?
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/LanguagesPayload`.
            @frozen public enum LanguagesPayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case actions = "actions"
                case cCpp = "c-cpp"
                case csharp = "csharp"
                case go = "go"
                case javaKotlin = "java-kotlin"
                case javascriptTypescript = "javascript-typescript"
                case javascript = "javascript"
                case python = "python"
                case ruby = "ruby"
                case typescript = "typescript"
                case swift = "swift"
            }
            /// Languages to be analyzed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/languages`.
            public typealias LanguagesPayload = [Components.Schemas.CodeScanningDefaultSetup.LanguagesPayloadPayload]
            /// Languages to be analyzed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/languages`.
            public var languages: Components.Schemas.CodeScanningDefaultSetup.LanguagesPayload?
            /// Runner type to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/runner_type`.
            @frozen public enum RunnerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case standard = "standard"
                case labeled = "labeled"
            }
            /// Runner type to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/runner_type`.
            public var runnerType: Components.Schemas.CodeScanningDefaultSetup.RunnerTypePayload?
            /// Runner label to be used if the runner type is labeled.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/runner_label`.
            public var runnerLabel: Swift.String?
            /// CodeQL query suite to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/query_suite`.
            @frozen public enum QuerySuitePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case _default = "default"
                case extended = "extended"
            }
            /// CodeQL query suite to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/query_suite`.
            public var querySuite: Components.Schemas.CodeScanningDefaultSetup.QuerySuitePayload?
            /// Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/threat_model`.
            @frozen public enum ThreatModelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case remote = "remote"
                case remoteAndLocal = "remote_and_local"
            }
            /// Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/threat_model`.
            public var threatModel: Components.Schemas.CodeScanningDefaultSetup.ThreatModelPayload?
            /// Timestamp of latest configuration update.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The frequency of the periodic analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/schedule`.
            @frozen public enum SchedulePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case weekly = "weekly"
            }
            /// The frequency of the periodic analysis.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup/schedule`.
            public var schedule: Components.Schemas.CodeScanningDefaultSetup.SchedulePayload?
            /// Creates a new `CodeScanningDefaultSetup`.
            ///
            /// - Parameters:
            ///   - state: Code scanning default setup has been configured or not.
            ///   - languages: Languages to be analyzed.
            ///   - runnerType: Runner type to be used.
            ///   - runnerLabel: Runner label to be used if the runner type is labeled.
            ///   - querySuite: CodeQL query suite to be used.
            ///   - threatModel: Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///   - updatedAt: Timestamp of latest configuration update.
            ///   - schedule: The frequency of the periodic analysis.
            public init(
                state: Components.Schemas.CodeScanningDefaultSetup.StatePayload? = nil,
                languages: Components.Schemas.CodeScanningDefaultSetup.LanguagesPayload? = nil,
                runnerType: Components.Schemas.CodeScanningDefaultSetup.RunnerTypePayload? = nil,
                runnerLabel: Swift.String? = nil,
                querySuite: Components.Schemas.CodeScanningDefaultSetup.QuerySuitePayload? = nil,
                threatModel: Components.Schemas.CodeScanningDefaultSetup.ThreatModelPayload? = nil,
                updatedAt: Foundation.Date? = nil,
                schedule: Components.Schemas.CodeScanningDefaultSetup.SchedulePayload? = nil
            ) {
                self.state = state
                self.languages = languages
                self.runnerType = runnerType
                self.runnerLabel = runnerLabel
                self.querySuite = querySuite
                self.threatModel = threatModel
                self.updatedAt = updatedAt
                self.schedule = schedule
            }
            public enum CodingKeys: String, CodingKey {
                case state
                case languages
                case runnerType = "runner_type"
                case runnerLabel = "runner_label"
                case querySuite = "query_suite"
                case threatModel = "threat_model"
                case updatedAt = "updated_at"
                case schedule
            }
        }
        /// Configuration for code scanning default setup.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update`.
        public struct CodeScanningDefaultSetupUpdate: Codable, Hashable, Sendable {
            /// The desired state of code scanning default setup.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case configured = "configured"
                case notConfigured = "not-configured"
            }
            /// The desired state of code scanning default setup.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/state`.
            public var state: Components.Schemas.CodeScanningDefaultSetupUpdate.StatePayload?
            /// Runner type to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/runner_type`.
            @frozen public enum RunnerTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case standard = "standard"
                case labeled = "labeled"
            }
            /// Runner type to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/runner_type`.
            public var runnerType: Components.Schemas.CodeScanningDefaultSetupUpdate.RunnerTypePayload?
            /// Runner label to be used if the runner type is labeled.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/runner_label`.
            public var runnerLabel: Swift.String?
            /// CodeQL query suite to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/query_suite`.
            @frozen public enum QuerySuitePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case _default = "default"
                case extended = "extended"
            }
            /// CodeQL query suite to be used.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/query_suite`.
            public var querySuite: Components.Schemas.CodeScanningDefaultSetupUpdate.QuerySuitePayload?
            /// Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/threat_model`.
            @frozen public enum ThreatModelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case remote = "remote"
                case remoteAndLocal = "remote_and_local"
            }
            /// Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/threat_model`.
            public var threatModel: Components.Schemas.CodeScanningDefaultSetupUpdate.ThreatModelPayload?
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/LanguagesPayload`.
            @frozen public enum LanguagesPayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case actions = "actions"
                case cCpp = "c-cpp"
                case csharp = "csharp"
                case go = "go"
                case javaKotlin = "java-kotlin"
                case javascriptTypescript = "javascript-typescript"
                case python = "python"
                case ruby = "ruby"
                case swift = "swift"
            }
            /// CodeQL languages to be analyzed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/languages`.
            public typealias LanguagesPayload = [Components.Schemas.CodeScanningDefaultSetupUpdate.LanguagesPayloadPayload]
            /// CodeQL languages to be analyzed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update/languages`.
            public var languages: Components.Schemas.CodeScanningDefaultSetupUpdate.LanguagesPayload?
            /// Creates a new `CodeScanningDefaultSetupUpdate`.
            ///
            /// - Parameters:
            ///   - state: The desired state of code scanning default setup.
            ///   - runnerType: Runner type to be used.
            ///   - runnerLabel: Runner label to be used if the runner type is labeled.
            ///   - querySuite: CodeQL query suite to be used.
            ///   - threatModel: Threat model to be used for code scanning analysis. Use `remote` to analyze only network sources and `remote_and_local` to include local sources like filesystem access, command-line arguments, database reads, environment variable and standard input.
            ///   - languages: CodeQL languages to be analyzed.
            public init(
                state: Components.Schemas.CodeScanningDefaultSetupUpdate.StatePayload? = nil,
                runnerType: Components.Schemas.CodeScanningDefaultSetupUpdate.RunnerTypePayload? = nil,
                runnerLabel: Swift.String? = nil,
                querySuite: Components.Schemas.CodeScanningDefaultSetupUpdate.QuerySuitePayload? = nil,
                threatModel: Components.Schemas.CodeScanningDefaultSetupUpdate.ThreatModelPayload? = nil,
                languages: Components.Schemas.CodeScanningDefaultSetupUpdate.LanguagesPayload? = nil
            ) {
                self.state = state
                self.runnerType = runnerType
                self.runnerLabel = runnerLabel
                self.querySuite = querySuite
                self.threatModel = threatModel
                self.languages = languages
            }
            public enum CodingKeys: String, CodingKey {
                case state
                case runnerType = "runner_type"
                case runnerLabel = "runner_label"
                case querySuite = "query_suite"
                case threatModel = "threat_model"
                case languages
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.state = try container.decodeIfPresent(
                    Components.Schemas.CodeScanningDefaultSetupUpdate.StatePayload.self,
                    forKey: .state
                )
                self.runnerType = try container.decodeIfPresent(
                    Components.Schemas.CodeScanningDefaultSetupUpdate.RunnerTypePayload.self,
                    forKey: .runnerType
                )
                self.runnerLabel = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .runnerLabel
                )
                self.querySuite = try container.decodeIfPresent(
                    Components.Schemas.CodeScanningDefaultSetupUpdate.QuerySuitePayload.self,
                    forKey: .querySuite
                )
                self.threatModel = try container.decodeIfPresent(
                    Components.Schemas.CodeScanningDefaultSetupUpdate.ThreatModelPayload.self,
                    forKey: .threatModel
                )
                self.languages = try container.decodeIfPresent(
                    Components.Schemas.CodeScanningDefaultSetupUpdate.LanguagesPayload.self,
                    forKey: .languages
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "state",
                    "runner_type",
                    "runner_label",
                    "query_suite",
                    "threat_model",
                    "languages"
                ])
            }
        }
        /// You can use `run_url` to track the status of the run. This includes a property status and conclusion.
        /// You should not rely on this always being an actions workflow run object.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update-response`.
        public struct CodeScanningDefaultSetupUpdateResponse: Codable, Hashable, Sendable {
            /// ID of the corresponding run.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update-response/run_id`.
            public var runId: Swift.Int?
            /// URL of the corresponding run.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-default-setup-update-response/run_url`.
            public var runUrl: Swift.String?
            /// Creates a new `CodeScanningDefaultSetupUpdateResponse`.
            ///
            /// - Parameters:
            ///   - runId: ID of the corresponding run.
            ///   - runUrl: URL of the corresponding run.
            public init(
                runId: Swift.Int? = nil,
                runUrl: Swift.String? = nil
            ) {
                self.runId = runId
                self.runUrl = runUrl
            }
            public enum CodingKeys: String, CodingKey {
                case runId = "run_id"
                case runUrl = "run_url"
            }
        }
        /// The full Git reference, formatted as `refs/heads/<branch name>`,
        /// `refs/tags/<tag>`, `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-ref-full`.
        public typealias CodeScanningRefFull = Swift.String
        /// A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)."
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-analysis-sarif-file`.
        public typealias CodeScanningAnalysisSarifFile = Swift.String
        /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-receipt`.
        public struct CodeScanningSarifsReceipt: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-receipt/id`.
            public var id: Components.Schemas.CodeScanningAnalysisSarifId?
            /// The REST API URL for checking the status of the upload.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-receipt/url`.
            public var url: Swift.String?
            /// Creates a new `CodeScanningSarifsReceipt`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - url: The REST API URL for checking the status of the upload.
            public init(
                id: Components.Schemas.CodeScanningAnalysisSarifId? = nil,
                url: Swift.String? = nil
            ) {
                self.id = id
                self.url = url
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case url
            }
        }
        /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-status`.
        public struct CodeScanningSarifsStatus: Codable, Hashable, Sendable {
            /// `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-status/processing_status`.
            @frozen public enum ProcessingStatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pending = "pending"
                case complete = "complete"
                case failed = "failed"
            }
            /// `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-status/processing_status`.
            public var processingStatus: Components.Schemas.CodeScanningSarifsStatus.ProcessingStatusPayload?
            /// The REST API URL for getting the analyses associated with the upload.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-status/analyses_url`.
            public var analysesUrl: Swift.String?
            /// Any errors that ocurred during processing of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/code-scanning-sarifs-status/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `CodeScanningSarifsStatus`.
            ///
            /// - Parameters:
            ///   - processingStatus: `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
            ///   - analysesUrl: The REST API URL for getting the analyses associated with the upload.
            ///   - errors: Any errors that ocurred during processing of the delivery.
            public init(
                processingStatus: Components.Schemas.CodeScanningSarifsStatus.ProcessingStatusPayload? = nil,
                analysesUrl: Swift.String? = nil,
                errors: [Swift.String]? = nil
            ) {
                self.processingStatus = processingStatus
                self.analysesUrl = analysesUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case processingStatus = "processing_status"
                case analysesUrl = "analyses_url"
                case errors
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
        ///
        /// - Remark: Generated from `#/components/parameters/tool-name`.
        public typealias ToolName = Components.Schemas.CodeScanningAnalysisToolName
        /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
        ///
        /// - Remark: Generated from `#/components/parameters/tool-guid`.
        public typealias ToolGuid = Components.Schemas.CodeScanningAnalysisToolGuid
        /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
        ///
        /// - Remark: Generated from `#/components/parameters/git-ref`.
        public typealias GitRef = Components.Schemas.CodeScanningRef
        /// The number of the pull request for the results you want to list.
        ///
        /// - Remark: Generated from `#/components/parameters/pr-alias`.
        public typealias PrAlias = Swift.Int
        /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
        ///
        /// - Remark: Generated from `#/components/parameters/alert-number`.
        public typealias AlertNumber = Components.Schemas.AlertNumber
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
        public struct CodeScanningForbiddenRead: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_forbidden_read/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_forbidden_read/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningForbiddenRead.Body
            /// Creates a new `CodeScanningForbiddenRead`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningForbiddenRead.Body) {
                self.body = body
            }
        }
        public struct CodeScanningForbiddenWrite: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_forbidden_write/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_forbidden_write/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningForbiddenWrite.Body
            /// Creates a new `CodeScanningForbiddenWrite`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningForbiddenWrite.Body) {
                self.body = body
            }
        }
        public struct CodeScanningBadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningBadRequest.Body
            /// Creates a new `CodeScanningBadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningBadRequest.Body) {
                self.body = body
            }
        }
        public struct CodeScanningAutofixCreateForbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_autofix_create_forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_autofix_create_forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningAutofixCreateForbidden.Body
            /// Creates a new `CodeScanningAutofixCreateForbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningAutofixCreateForbidden.Body) {
                self.body = body
            }
        }
        public struct UnprocessableAnalysis: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/unprocessable_analysis/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/unprocessable_analysis/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.UnprocessableAnalysis.Body
            /// Creates a new `UnprocessableAnalysis`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.UnprocessableAnalysis.Body) {
                self.body = body
            }
        }
        public struct Found: Sendable, Hashable {
            /// Creates a new `Found`.
            public init() {}
        }
        public struct CodeScanningConflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningConflict.Body
            /// Creates a new `CodeScanningConflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningConflict.Body) {
                self.body = body
            }
        }
        public struct CodeScanningInvalidState: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/code_scanning_invalid_state/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/code_scanning_invalid_state/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.CodeScanningInvalidState.Body
            /// Creates a new `CodeScanningInvalidState`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.CodeScanningInvalidState.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List code scanning alerts for an organization
    ///
    /// Lists code scanning alerts for the default branch for all eligible repositories in an organization. Eligible repositories are repositories that are owned by organizations that you own or for which you are a security manager. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` or `repo`s cope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)`.
    public enum CodeScanningListAlertsForOrg {
        public static let id: Swift.String = "code-scanning/list-alerts-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodeScanningListAlertsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/tool_name`.
                public var toolName: Components.Parameters.ToolName?
                /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/tool_guid`.
                public var toolGuid: Components.Parameters.ToolGuid?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// If specified, only code scanning alerts with this state will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/state`.
                public var state: Components.Schemas.CodeScanningAlertStateQuery?
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property by which to sort the results.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/sort`.
                public var sort: Operations.CodeScanningListAlertsForOrg.Input.Query.SortPayload?
                /// If specified, only code scanning alerts with this severity will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/query/severity`.
                public var severity: Components.Schemas.CodeScanningAlertSeverity?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - toolName: The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///   - toolGuid: The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - state: If specified, only code scanning alerts with this state will be returned.
                ///   - sort: The property by which to sort the results.
                ///   - severity: If specified, only code scanning alerts with this severity will be returned.
                public init(
                    toolName: Components.Parameters.ToolName? = nil,
                    toolGuid: Components.Parameters.ToolGuid? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    state: Components.Schemas.CodeScanningAlertStateQuery? = nil,
                    sort: Operations.CodeScanningListAlertsForOrg.Input.Query.SortPayload? = nil,
                    severity: Components.Schemas.CodeScanningAlertSeverity? = nil
                ) {
                    self.toolName = toolName
                    self.toolGuid = toolGuid
                    self.before = before
                    self.after = after
                    self.page = page
                    self.perPage = perPage
                    self.direction = direction
                    self.state = state
                    self.sort = sort
                    self.severity = severity
                }
            }
            public var query: Operations.CodeScanningListAlertsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningListAlertsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeScanningListAlertsForOrg.Input.Path,
                query: Operations.CodeScanningListAlertsForOrg.Input.Query = .init(),
                headers: Operations.CodeScanningListAlertsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CodeScanningListAlertsForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/code-scanning/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeScanningOrganizationAlertItems])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeScanningOrganizationAlertItems] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningListAlertsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CodeScanningListAlertsForOrg.Output.Ok.Headers = .init(),
                    body: Operations.CodeScanningListAlertsForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningListAlertsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningListAlertsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/code-scanning/alerts/get(code-scanning/list-alerts-for-org)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List code scanning alerts for a repository
    ///
    /// Lists code scanning alerts.
    ///
    /// The response includes a `most_recent_instance` object.
    /// This provides details of the most recent instance of this alert
    /// for the default branch (or for the specified Git reference if you used `ref` in the request).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)`.
    public enum CodeScanningListAlertsForRepo {
        public static let id: Swift.String = "code-scanning/list-alerts-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningListAlertsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/tool_name`.
                public var toolName: Components.Parameters.ToolName?
                /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/tool_guid`.
                public var toolGuid: Components.Parameters.ToolGuid?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/ref`.
                public var ref: Components.Parameters.GitRef?
                /// The number of the pull request for the results you want to list.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/pr`.
                public var pr: Components.Parameters.PrAlias?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property by which to sort the results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/sort`.
                public var sort: Operations.CodeScanningListAlertsForRepo.Input.Query.SortPayload?
                /// If specified, only code scanning alerts with this state will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/state`.
                public var state: Components.Schemas.CodeScanningAlertStateQuery?
                /// If specified, only code scanning alerts with this severity will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/query/severity`.
                public var severity: Components.Schemas.CodeScanningAlertSeverity?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - toolName: The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///   - toolGuid: The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - ref: The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///   - pr: The number of the pull request for the results you want to list.
                ///   - direction: The direction to sort the results by.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - sort: The property by which to sort the results.
                ///   - state: If specified, only code scanning alerts with this state will be returned.
                ///   - severity: If specified, only code scanning alerts with this severity will be returned.
                public init(
                    toolName: Components.Parameters.ToolName? = nil,
                    toolGuid: Components.Parameters.ToolGuid? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    ref: Components.Parameters.GitRef? = nil,
                    pr: Components.Parameters.PrAlias? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    sort: Operations.CodeScanningListAlertsForRepo.Input.Query.SortPayload? = nil,
                    state: Components.Schemas.CodeScanningAlertStateQuery? = nil,
                    severity: Components.Schemas.CodeScanningAlertSeverity? = nil
                ) {
                    self.toolName = toolName
                    self.toolGuid = toolGuid
                    self.page = page
                    self.perPage = perPage
                    self.ref = ref
                    self.pr = pr
                    self.direction = direction
                    self.before = before
                    self.after = after
                    self.sort = sort
                    self.state = state
                    self.severity = severity
                }
            }
            public var query: Operations.CodeScanningListAlertsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningListAlertsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeScanningListAlertsForRepo.Input.Path,
                query: Operations.CodeScanningListAlertsForRepo.Input.Query = .init(),
                headers: Operations.CodeScanningListAlertsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeScanningAlertItems])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeScanningAlertItems] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningListAlertsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningListAlertsForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningListAlertsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningListAlertsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/get(code-scanning/list-alerts-for-repo)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a code scanning alert
    ///
    /// Gets a single code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)`.
    public enum CodeScanningGetAlert {
        public static let id: Swift.String = "code-scanning/get-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningGetAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetAlert.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetAlert.Input.Path,
                headers: Operations.CodeScanningGetAlert.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/get(code-scanning/get-alert)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a code scanning alert
    ///
    /// Updates the status of a single code scanning alert.
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)`.
    public enum CodeScanningUpdateAlert {
        public static let id: Swift.String = "code-scanning/update-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningUpdateAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUpdateAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUpdateAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningUpdateAlert.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/json/state`.
                    public var state: Components.Schemas.CodeScanningAlertSetState
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/json/dismissed_reason`.
                    public var dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/json/dismissed_comment`.
                    public var dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/json/create_request`.
                    public var createRequest: Components.Schemas.CodeScanningAlertCreateRequest?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - state:
                    ///   - dismissedReason:
                    ///   - dismissedComment:
                    ///   - createRequest:
                    public init(
                        state: Components.Schemas.CodeScanningAlertSetState,
                        dismissedReason: Components.Schemas.CodeScanningAlertDismissedReason? = nil,
                        dismissedComment: Components.Schemas.CodeScanningAlertDismissedComment? = nil,
                        createRequest: Components.Schemas.CodeScanningAlertCreateRequest? = nil
                    ) {
                        self.state = state
                        self.dismissedReason = dismissedReason
                        self.dismissedComment = dismissedComment
                        self.createRequest = createRequest
                    }
                    public enum CodingKeys: String, CodingKey {
                        case state
                        case dismissedReason = "dismissed_reason"
                        case dismissedComment = "dismissed_comment"
                        case createRequest = "create_request"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.CodeScanningUpdateAlert.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeScanningUpdateAlert.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeScanningUpdateAlert.Input.Path,
                headers: Operations.CodeScanningUpdateAlert.Input.Headers = .init(),
                body: Operations.CodeScanningUpdateAlert.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningUpdateAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningUpdateAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningUpdateAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningUpdateAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/patch(code-scanning/update-alert)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get the status of an autofix for a code scanning alert
    ///
    /// Gets the status and description of an autofix for a code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)`.
    public enum CodeScanningGetAutofix {
        public static let id: Swift.String = "code-scanning/get-autofix"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningGetAutofix.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAutofix.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAutofix.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetAutofix.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetAutofix.Input.Path,
                headers: Operations.CodeScanningGetAutofix.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAutofix)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAutofix {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetAutofix.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetAutofix.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetAutofix.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetAutofix.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.CodeScanningBadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.CodeScanningBadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/get(code-scanning/get-autofix)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an autofix for a code scanning alert
    ///
    /// Creates an autofix for a code scanning alert.
    ///
    /// If a new autofix is to be created as a result of this request or is currently being generated, then this endpoint will return a 202 Accepted response.
    ///
    /// If an autofix already exists for a given alert, then this endpoint will return a 200 OK response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)`.
    public enum CodeScanningCreateAutofix {
        public static let id: Swift.String = "code-scanning/create-autofix"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningCreateAutofix.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCreateAutofix.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCreateAutofix.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningCreateAutofix.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningCreateAutofix.Input.Path,
                headers: Operations.CodeScanningCreateAutofix.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAutofix)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAutofix {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningCreateAutofix.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningCreateAutofix.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningCreateAutofix.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningCreateAutofix.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAutofix)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAutofix {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningCreateAutofix.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningCreateAutofix.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodeScanningCreateAutofix.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodeScanningCreateAutofix.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.CodeScanningBadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.CodeScanningBadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived, if GitHub Advanced Security is not enabled for this repository or if rate limit is exceeded
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningAutofixCreateForbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningAutofixCreateForbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CodeScanningCreateAutofix.Output.UnprocessableContent)
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CodeScanningCreateAutofix.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/post(code-scanning/create-autofix)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Commit an autofix for a code scanning alert
    ///
    /// Commits an autofix for a code scanning alert.
    ///
    /// If an autofix is committed as a result of this request, then this endpoint will return a 201 Created response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)`.
    public enum CodeScanningCommitAutofix {
        public static let id: Swift.String = "code-scanning/commit-autofix"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningCommitAutofix.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCommitAutofix.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCommitAutofix.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningCommitAutofix.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CodeScanningAutofixCommits)
            }
            public var body: Operations.CodeScanningCommitAutofix.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeScanningCommitAutofix.Input.Path,
                headers: Operations.CodeScanningCommitAutofix.Input.Headers = .init(),
                body: Operations.CodeScanningCommitAutofix.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAutofixCommitsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAutofixCommitsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningCommitAutofix.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningCommitAutofix.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodeScanningCommitAutofix.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodeScanningCommitAutofix.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.CodeScanningBadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.CodeScanningBadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CodeScanningCommitAutofix.Output.UnprocessableContent)
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CodeScanningCommitAutofix.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits/post(code-scanning/commit-autofix)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List instances of a code scanning alert
    ///
    /// Lists all instances of the specified code scanning alert.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)`.
    public enum CodeScanningListAlertInstances {
        public static let id: Swift.String = "code-scanning/list-alert-instances"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.CodeScanningListAlertInstances.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/query/ref`.
                public var ref: Components.Parameters.GitRef?
                /// The number of the pull request for the results you want to list.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/query/pr`.
                public var pr: Components.Parameters.PrAlias?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - ref: The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///   - pr: The number of the pull request for the results you want to list.
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    ref: Components.Parameters.GitRef? = nil,
                    pr: Components.Parameters.PrAlias? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                    self.ref = ref
                    self.pr = pr
                }
            }
            public var query: Operations.CodeScanningListAlertInstances.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertInstances.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListAlertInstances.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningListAlertInstances.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeScanningListAlertInstances.Input.Path,
                query: Operations.CodeScanningListAlertInstances.Input.Query = .init(),
                headers: Operations.CodeScanningListAlertInstances.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeScanningAlertInstance])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeScanningAlertInstance] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningListAlertInstances.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningListAlertInstances.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningListAlertInstances.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningListAlertInstances.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances/get(code-scanning/list-alert-instances)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List code scanning analyses for a repository
    ///
    /// Lists the details of all code scanning analyses for a repository,
    /// starting with the most recent.
    /// The response is paginated and you can use the `page` and `per_page` parameters
    /// to list the analyses you're interested in.
    /// By default 30 analyses are listed per page.
    ///
    /// The `rules_count` field in the response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** The `tool_name` field is closing down and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)`.
    public enum CodeScanningListRecentAnalyses {
        public static let id: Swift.String = "code-scanning/list-recent-analyses"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningListRecentAnalyses.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/tool_name`.
                public var toolName: Components.Parameters.ToolName?
                /// The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/tool_guid`.
                public var toolGuid: Components.Parameters.ToolGuid?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The number of the pull request for the results you want to list.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/pr`.
                public var pr: Components.Parameters.PrAlias?
                /// The Git reference for the analyses you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/ref`.
                public var ref: Components.Schemas.CodeScanningRef?
                /// Filter analyses belonging to the same SARIF upload.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/sarif_id`.
                public var sarifId: Components.Schemas.CodeScanningAnalysisSarifId?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                }
                /// The property by which to sort the results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/query/sort`.
                public var sort: Operations.CodeScanningListRecentAnalyses.Input.Query.SortPayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - toolName: The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both.
                ///   - toolGuid: The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - pr: The number of the pull request for the results you want to list.
                ///   - ref: The Git reference for the analyses you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///   - sarifId: Filter analyses belonging to the same SARIF upload.
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property by which to sort the results.
                public init(
                    toolName: Components.Parameters.ToolName? = nil,
                    toolGuid: Components.Parameters.ToolGuid? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    pr: Components.Parameters.PrAlias? = nil,
                    ref: Components.Schemas.CodeScanningRef? = nil,
                    sarifId: Components.Schemas.CodeScanningAnalysisSarifId? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    sort: Operations.CodeScanningListRecentAnalyses.Input.Query.SortPayload? = nil
                ) {
                    self.toolName = toolName
                    self.toolGuid = toolGuid
                    self.page = page
                    self.perPage = perPage
                    self.pr = pr
                    self.ref = ref
                    self.sarifId = sarifId
                    self.direction = direction
                    self.sort = sort
                }
            }
            public var query: Operations.CodeScanningListRecentAnalyses.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListRecentAnalyses.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListRecentAnalyses.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningListRecentAnalyses.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeScanningListRecentAnalyses.Input.Path,
                query: Operations.CodeScanningListRecentAnalyses.Input.Query = .init(),
                headers: Operations.CodeScanningListRecentAnalyses.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeScanningAnalysis])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeScanningAnalysis] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningListRecentAnalyses.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningListRecentAnalyses.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningListRecentAnalyses.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningListRecentAnalyses.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/get(code-scanning/list-recent-analyses)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a code scanning analysis for a repository
    ///
    /// Gets a specified code scanning analysis for a repository.
    ///
    /// The default JSON response contains fields that describe the analysis.
    /// This includes the Git reference and commit SHA to which the analysis relates,
    /// the datetime of the analysis, the name of the code scanning tool,
    /// and the number of alerts.
    ///
    /// The `rules_count` field in the default response give the number of rules
    /// that were run in the analysis.
    /// For very old analyses this data is not available,
    /// and `0` is returned in this field.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/sarif+json`**: Instead of returning a summary of the analysis, this endpoint returns a subset of the analysis data that was uploaded. The data is formatted as [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html). It also returns additional data such as the `github/alertNumber` and `github/alertUrl` properties.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)`.
    public enum CodeScanningGetAnalysis {
        public static let id: Swift.String = "code-scanning/get-analysis"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The ID of the analysis, as returned from the `GET /repos/{owner}/{repo}/code-scanning/analyses` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/path/analysis_id`.
                public var analysisId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - analysisId: The ID of the analysis, as returned from the `GET /repos/{owner}/{repo}/code-scanning/analyses` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    analysisId: Swift.Int
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.analysisId = analysisId
                }
            }
            public var path: Operations.CodeScanningGetAnalysis.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAnalysis.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetAnalysis.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetAnalysis.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetAnalysis.Input.Path,
                headers: Operations.CodeScanningGetAnalysis.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAnalysis)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAnalysis {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "application/json",
                                    body: self
                                )
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/GET/responses/200/content/application\/json+sarif`.
                    case applicationJsonSarif(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.applicationJsonSarif`.
                    ///
                    /// - Throws: An error if `self` is not `.applicationJsonSarif`.
                    /// - SeeAlso: `.applicationJsonSarif`.
                    public var applicationJsonSarif: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .applicationJsonSarif(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "application/json+sarif",
                                    body: self
                                )
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetAnalysis.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetAnalysis.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetAnalysis.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetAnalysis.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Response if analysis could not be processed
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.UnprocessableAnalysis)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.UnprocessableAnalysis {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/get(code-scanning/get-analysis)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationJsonSarif
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/json+sarif":
                    self = .applicationJsonSarif
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationJsonSarif:
                    return "application/json+sarif"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationJsonSarif
                ]
            }
        }
    }
    /// Delete a code scanning analysis from a repository
    ///
    /// Deletes a specified code scanning analysis from a repository.
    ///
    /// You can delete one analysis at a time.
    /// To delete a series of analyses, start with the most recent analysis and work backwards.
    /// Conceptually, the process is similar to the undo function in a text editor.
    ///
    /// When you list the analyses for a repository,
    /// one or more will be identified as deletable in the response:
    ///
    /// ```
    /// "deletable": true
    /// ```
    ///
    /// An analysis is deletable when it's the most recent in a set of analyses.
    /// Typically, a repository will have multiple sets of analyses
    /// for each enabled code scanning tool,
    /// where a set is determined by a unique combination of analysis values:
    ///
    /// * `ref`
    /// * `tool`
    /// * `category`
    ///
    /// If you attempt to delete an analysis that is not the most recent in a set,
    /// you'll get a 400 response with the message:
    ///
    /// ```
    /// Analysis specified is not deletable.
    /// ```
    ///
    /// The response from a successful `DELETE` operation provides you with
    /// two alternative URLs for deleting the next analysis in the set:
    /// `next_analysis_url` and `confirm_delete_url`.
    /// Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
    /// in a set. This is a useful option if you want to preserve at least one analysis
    /// for the specified tool in your repository.
    /// Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
    /// When you delete the last analysis in a set, the value of `next_analysis_url` and `confirm_delete_url`
    /// in the 200 response is `null`.
    ///
    /// As an example of the deletion process,
    /// let's imagine that you added a workflow that configured a particular code scanning tool
    /// to analyze the code in a repository. This tool has added 15 analyses:
    /// 10 on the default branch, and another 5 on a topic branch.
    /// You therefore have two separate sets of analyses for this tool.
    /// You've now decided that you want to remove all of the analyses for the tool.
    /// To do this you must make 15 separate deletion requests.
    /// To start, you must find an analysis that's identified as deletable.
    /// Each set of analyses always has one that's identified as deletable.
    /// Having found the deletable analysis for one of the two sets,
    /// delete this analysis and then continue deleting the next analysis in the set until they're all deleted.
    /// Then repeat the process for the second set.
    /// The procedure therefore consists of a nested loop:
    ///
    /// **Outer loop**:
    /// * List the analyses for the repository, filtered by tool.
    /// * Parse this list to find a deletable analysis. If found:
    ///
    ///   **Inner loop**:
    ///   * Delete the identified analysis.
    ///   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
    ///
    /// The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)`.
    public enum CodeScanningDeleteAnalysis {
        public static let id: Swift.String = "code-scanning/delete-analysis"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The ID of the analysis, as returned from the `GET /repos/{owner}/{repo}/code-scanning/analyses` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/path/analysis_id`.
                public var analysisId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - analysisId: The ID of the analysis, as returned from the `GET /repos/{owner}/{repo}/code-scanning/analyses` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    analysisId: Swift.Int
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.analysisId = analysisId
                }
            }
            public var path: Operations.CodeScanningDeleteAnalysis.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/query`.
            public struct Query: Sendable, Hashable {
                /// Allow deletion if the specified analysis is the last in a set. If you attempt to delete the final analysis in a set without setting this parameter to `true`, you'll get a 400 response with the message: `Analysis is last of its type and deletion may result in the loss of historical alert data. Please specify confirm_delete.`
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/query/confirm_delete`.
                public var confirmDelete: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - confirmDelete: Allow deletion if the specified analysis is the last in a set. If you attempt to delete the final analysis in a set without setting this parameter to `true`, you'll get a 400 response with the message: `Analysis is last of its type and deletion may result in the loss of historical alert data. Please specify confirm_delete.`
                public init(confirmDelete: Swift.String? = nil) {
                    self.confirmDelete = confirmDelete
                }
            }
            public var query: Operations.CodeScanningDeleteAnalysis.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningDeleteAnalysis.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningDeleteAnalysis.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningDeleteAnalysis.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodeScanningDeleteAnalysis.Input.Path,
                query: Operations.CodeScanningDeleteAnalysis.Input.Query = .init(),
                headers: Operations.CodeScanningDeleteAnalysis.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningAnalysisDeletion)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningAnalysisDeletion {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningDeleteAnalysis.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningDeleteAnalysis.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningDeleteAnalysis.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningDeleteAnalysis.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}/delete(code-scanning/delete-analysis)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List CodeQL databases for a repository
    ///
    /// Lists the CodeQL databases that are available in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)`.
    public enum CodeScanningListCodeqlDatabases {
        public static let id: Swift.String = "code-scanning/list-codeql-databases"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningListCodeqlDatabases.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListCodeqlDatabases.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningListCodeqlDatabases.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningListCodeqlDatabases.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningListCodeqlDatabases.Input.Path,
                headers: Operations.CodeScanningListCodeqlDatabases.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CodeScanningCodeqlDatabase])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CodeScanningCodeqlDatabase] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningListCodeqlDatabases.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningListCodeqlDatabases.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningListCodeqlDatabases.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningListCodeqlDatabases.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/get(code-scanning/list-codeql-databases)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a CodeQL database for a repository
    ///
    /// Gets a CodeQL database for a language in a repository.
    ///
    /// By default this endpoint returns JSON metadata about the CodeQL database. To
    /// download the CodeQL database binary content, set the `Accept` header of the request
    /// to [`application/zip`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types), and make sure
    /// your HTTP client is configured to follow redirects or use the `Location` header
    /// to make a second request to get the redirect URL.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)`.
    public enum CodeScanningGetCodeqlDatabase {
        public static let id: Swift.String = "code-scanning/get-codeql-database"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The language of the CodeQL database.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/path/language`.
                public var language: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - language: The language of the CodeQL database.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    language: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.language = language
                }
            }
            public var path: Operations.CodeScanningGetCodeqlDatabase.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetCodeqlDatabase.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetCodeqlDatabase.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetCodeqlDatabase.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetCodeqlDatabase.Input.Path,
                headers: Operations.CodeScanningGetCodeqlDatabase.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningCodeqlDatabase)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningCodeqlDatabase {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetCodeqlDatabase.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetCodeqlDatabase.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetCodeqlDatabase.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetCodeqlDatabase.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            case found(Components.Responses.Found)
            /// Found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            public static var found: Self {
                .found(.init())
            }
            /// The associated value of the enum case if `self` is `.found`.
            ///
            /// - Throws: An error if `self` is not `.found`.
            /// - SeeAlso: `.found`.
            public var found: Components.Responses.Found {
                get throws {
                    switch self {
                    case let .found(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "found",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/get(code-scanning/get-codeql-database)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a CodeQL database
    ///
    /// Deletes a CodeQL database for a language in a repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/code-scanning/codeql/databases/{language}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)`.
    public enum CodeScanningDeleteCodeqlDatabase {
        public static let id: Swift.String = "code-scanning/delete-codeql-database"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The language of the CodeQL database.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/DELETE/path/language`.
                public var language: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - language: The language of the CodeQL database.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    language: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.language = language
                }
            }
            public var path: Operations.CodeScanningDeleteCodeqlDatabase.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningDeleteCodeqlDatabase.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningDeleteCodeqlDatabase.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningDeleteCodeqlDatabase.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningDeleteCodeqlDatabase.Input.Path,
                headers: Operations.CodeScanningDeleteCodeqlDatabase.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodeScanningDeleteCodeqlDatabase.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodeScanningDeleteCodeqlDatabase.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/databases/{language}/delete(code-scanning/delete-codeql-database)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a CodeQL variant analysis
    ///
    /// Creates a new CodeQL variant analysis, which will run a CodeQL query against one or more repositories.
    ///
    /// Get started by learning more about [running CodeQL queries at scale with Multi-Repository Variant Analysis](https://docs.github.com/code-security/codeql-for-vs-code/getting-started-with-codeql-for-vs-code/running-codeql-queries-at-scale-with-multi-repository-variant-analysis).
    ///
    /// Use the `owner` and `repo` parameters in the URL to specify the controller repository that
    /// will be used for running GitHub Actions workflows and storing the results of the CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)`.
    public enum CodeScanningCreateVariantAnalysis {
        public static let id: Swift.String = "code-scanning/create-variant-analysis"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningCreateVariantAnalysis.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCreateVariantAnalysis.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningCreateVariantAnalysis.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningCreateVariantAnalysis.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// Creates a new `Case1Payload`.
                        public init() {}
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case1`.
                    case case1(Operations.CodeScanningCreateVariantAnalysis.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case2`.
                    public struct Case2Payload: Codable, Hashable, Sendable {
                        /// Creates a new `Case2Payload`.
                        public init() {}
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case2`.
                    case case2(Operations.CodeScanningCreateVariantAnalysis.Input.Body.JsonPayload.Case2Payload)
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case3`.
                    public struct Case3Payload: Codable, Hashable, Sendable {
                        /// Creates a new `Case3Payload`.
                        public init() {}
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/json/case3`.
                    case case3(Operations.CodeScanningCreateVariantAnalysis.Input.Body.JsonPayload.Case3Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try value.encode(to: encoder)
                        case let .case3(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/requestBody/content/application\/json`.
                case json(Operations.CodeScanningCreateVariantAnalysis.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeScanningCreateVariantAnalysis.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeScanningCreateVariantAnalysis.Input.Path,
                headers: Operations.CodeScanningCreateVariantAnalysis.Input.Headers = .init(),
                body: Operations.CodeScanningCreateVariantAnalysis.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CodeScanningVariantAnalysis)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningVariantAnalysis {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningCreateVariantAnalysis.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningCreateVariantAnalysis.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Variant analysis submitted for processing
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodeScanningCreateVariantAnalysis.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodeScanningCreateVariantAnalysis.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/POST/responses/422/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningCreateVariantAnalysis.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningCreateVariantAnalysis.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Unable to process variant analysis submission
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CodeScanningCreateVariantAnalysis.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CodeScanningCreateVariantAnalysis.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/post(code-scanning/create-variant-analysis)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get the summary of a CodeQL variant analysis
    ///
    /// Gets the summary of a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)`.
    public enum CodeScanningGetVariantAnalysis {
        public static let id: Swift.String = "code-scanning/get-variant-analysis"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the variant analysis.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/path/codeql_variant_analysis_id`.
                public var codeqlVariantAnalysisId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - codeqlVariantAnalysisId: The unique identifier of the variant analysis.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    codeqlVariantAnalysisId: Swift.Int
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.codeqlVariantAnalysisId = codeqlVariantAnalysisId
                }
            }
            public var path: Operations.CodeScanningGetVariantAnalysis.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetVariantAnalysis.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetVariantAnalysis.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetVariantAnalysis.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetVariantAnalysis.Input.Path,
                headers: Operations.CodeScanningGetVariantAnalysis.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningVariantAnalysis)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningVariantAnalysis {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetVariantAnalysis.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetVariantAnalysis.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetVariantAnalysis.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetVariantAnalysis.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/get(code-scanning/get-variant-analysis)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get the analysis status of a repository in a CodeQL variant analysis
    ///
    /// Gets the analysis status of a repository in a CodeQL variant analysis.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)`.
    public enum CodeScanningGetVariantAnalysisRepoTask {
        public static let id: Swift.String = "code-scanning/get-variant-analysis-repo-task"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the controller repository.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path/repo`.
                public var repo: Swift.String
                /// The ID of the variant analysis.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path/codeql_variant_analysis_id`.
                public var codeqlVariantAnalysisId: Swift.Int
                /// The account owner of the variant analysis repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path/repo_owner`.
                public var repoOwner: Swift.String
                /// The name of the variant analysis repository.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/path/repo_name`.
                public var repoName: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the controller repository.
                ///   - codeqlVariantAnalysisId: The ID of the variant analysis.
                ///   - repoOwner: The account owner of the variant analysis repository. The name is not case sensitive.
                ///   - repoName: The name of the variant analysis repository.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Swift.String,
                    codeqlVariantAnalysisId: Swift.Int,
                    repoOwner: Swift.String,
                    repoName: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.codeqlVariantAnalysisId = codeqlVariantAnalysisId
                    self.repoOwner = repoOwner
                    self.repoName = repoName
                }
            }
            public var path: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetVariantAnalysisRepoTask.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetVariantAnalysisRepoTask.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Path,
                headers: Operations.CodeScanningGetVariantAnalysisRepoTask.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningVariantAnalysisRepoTask)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningVariantAnalysisRepoTask {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetVariantAnalysisRepoTask.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetVariantAnalysisRepoTask.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetVariantAnalysisRepoTask.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetVariantAnalysisRepoTask.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}/get(code-scanning/get-variant-analysis-repo-task)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a code scanning default setup configuration
    ///
    /// Gets a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)`.
    public enum CodeScanningGetDefaultSetup {
        public static let id: Swift.String = "code-scanning/get-default-setup"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningGetDefaultSetup.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetDefaultSetup.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetDefaultSetup.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetDefaultSetup.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetDefaultSetup.Input.Path,
                headers: Operations.CodeScanningGetDefaultSetup.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningDefaultSetup)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningDefaultSetup {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetDefaultSetup.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetDefaultSetup.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetDefaultSetup.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetDefaultSetup.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/get(code-scanning/get-default-setup)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a code scanning default setup configuration
    ///
    /// Updates a code scanning default setup configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/code-scanning/default-setup`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)`.
    public enum CodeScanningUpdateDefaultSetup {
        public static let id: Swift.String = "code-scanning/update-default-setup"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningUpdateDefaultSetup.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUpdateDefaultSetup.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUpdateDefaultSetup.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningUpdateDefaultSetup.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/requestBody/content/application\/json`.
                case json(Components.Schemas.CodeScanningDefaultSetupUpdate)
            }
            public var body: Operations.CodeScanningUpdateDefaultSetup.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeScanningUpdateDefaultSetup.Input.Path,
                headers: Operations.CodeScanningUpdateDefaultSetup.Input.Headers = .init(),
                body: Operations.CodeScanningUpdateDefaultSetup.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningUpdateDefaultSetup.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningUpdateDefaultSetup.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningUpdateDefaultSetup.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningUpdateDefaultSetup.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/default-setup/PATCH/responses/202/content/application\/json`.
                    case json(Components.Schemas.CodeScanningDefaultSetupUpdateResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningDefaultSetupUpdateResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningUpdateDefaultSetup.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningUpdateDefaultSetup.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodeScanningUpdateDefaultSetup.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodeScanningUpdateDefaultSetup.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Response if there is already a validation run in progress with a different default setup configuration
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.CodeScanningConflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.CodeScanningConflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Response if the configuration change cannot be made because the repository is not in the required state
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.CodeScanningInvalidState)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.CodeScanningInvalidState {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/default-setup/patch(code-scanning/update-default-setup)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Upload an analysis as SARIF data
    ///
    /// Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. For troubleshooting information, see "[Troubleshooting SARIF uploads](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif)."
    ///
    /// There are two places where you can upload code scanning results.
    ///  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
    ///  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
    ///
    /// You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
    ///
    /// ```
    /// gzip -c analysis-data.sarif | base64 -w0
    /// ```
    ///
    /// SARIF upload supports a maximum number of entries per the following data objects, and an analysis will be rejected if any of these objects is above its maximum value. For some objects, there are additional values over which the entries will be ignored while keeping the most important entries whenever applicable.
    /// To get the most out of your analysis when it includes data above the supported limits, try to optimize the analysis configuration. For example, for the CodeQL tool, identify and remove the most noisy queries. For more information, see "[SARIF results exceed one or more limits](https://docs.github.com/code-security/code-scanning/troubleshooting-sarif/results-exceed-limit)."
    ///
    ///
    /// | **SARIF data**                   | **Maximum values** | **Additional limits**                                                            |
    /// |----------------------------------|:------------------:|----------------------------------------------------------------------------------|
    /// | Runs per file                    |         20         |                                                                                  |
    /// | Results per run                  |       25,000       | Only the top 5,000 results will be included, prioritized by severity.            |
    /// | Rules per run                    |       25,000       |                                                                                  |
    /// | Tool extensions per run          |        100         |                                                                                  |
    /// | Thread Flow Locations per result |       10,000       | Only the top 1,000 Thread Flow Locations will be included, using prioritization. |
    /// | Location per result	             |       1,000        | Only 100 locations will be included.                                             |
    /// | Tags per rule	                   |         20         | Only 10 tags will be included.                                                   |
    ///
    ///
    /// The `202 Accepted` response includes an `id` value.
    /// You can use this ID to check the status of the upload by using it in the `/sarifs/{sarif_id}` endpoint.
    /// For more information, see "[Get information about a SARIF upload](/rest/code-scanning/code-scanning#get-information-about-a-sarif-upload)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// This endpoint is limited to 1,000 requests per hour for each user or app installation calling it.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/code-scanning/sarifs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)`.
    public enum CodeScanningUploadSarif {
        public static let id: Swift.String = "code-scanning/upload-sarif"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodeScanningUploadSarif.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUploadSarif.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningUploadSarif.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningUploadSarif.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/commit_sha`.
                    public var commitSha: Components.Schemas.CodeScanningAnalysisCommitSha
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/ref`.
                    public var ref: Components.Schemas.CodeScanningRefFull
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/sarif`.
                    public var sarif: Components.Schemas.CodeScanningAnalysisSarifFile
                    /// The base directory used in the analysis, as it appears in the SARIF file.
                    /// This property is used to convert file paths from absolute to relative, so that alerts can be mapped to their correct location in the repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/checkout_uri`.
                    public var checkoutUri: Swift.String?
                    /// The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/started_at`.
                    public var startedAt: Foundation.Date?
                    /// The name of the tool used to generate the code scanning analysis. If this parameter is not used, the tool name defaults to "API". If the uploaded SARIF contains a tool GUID, this will be available for filtering using the `tool_guid` parameter of operations such as `GET /repos/{owner}/{repo}/code-scanning/alerts`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/tool_name`.
                    public var toolName: Swift.String?
                    /// Whether the SARIF file will be validated according to the code scanning specifications.
                    /// This parameter is intended to help integrators ensure that the uploaded SARIF files are correctly rendered by code scanning.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/json/validate`.
                    public var validate: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - commitSha:
                    ///   - ref:
                    ///   - sarif:
                    ///   - checkoutUri: The base directory used in the analysis, as it appears in the SARIF file.
                    ///   - startedAt: The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                    ///   - toolName: The name of the tool used to generate the code scanning analysis. If this parameter is not used, the tool name defaults to "API". If the uploaded SARIF contains a tool GUID, this will be available for filtering using the `tool_guid` parameter of operations such as `GET /repos/{owner}/{repo}/code-scanning/alerts`.
                    ///   - validate: Whether the SARIF file will be validated according to the code scanning specifications.
                    public init(
                        commitSha: Components.Schemas.CodeScanningAnalysisCommitSha,
                        ref: Components.Schemas.CodeScanningRefFull,
                        sarif: Components.Schemas.CodeScanningAnalysisSarifFile,
                        checkoutUri: Swift.String? = nil,
                        startedAt: Foundation.Date? = nil,
                        toolName: Swift.String? = nil,
                        validate: Swift.Bool? = nil
                    ) {
                        self.commitSha = commitSha
                        self.ref = ref
                        self.sarif = sarif
                        self.checkoutUri = checkoutUri
                        self.startedAt = startedAt
                        self.toolName = toolName
                        self.validate = validate
                    }
                    public enum CodingKeys: String, CodingKey {
                        case commitSha = "commit_sha"
                        case ref
                        case sarif
                        case checkoutUri = "checkout_uri"
                        case startedAt = "started_at"
                        case toolName = "tool_name"
                        case validate
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.commitSha = try container.decode(
                            Components.Schemas.CodeScanningAnalysisCommitSha.self,
                            forKey: .commitSha
                        )
                        self.ref = try container.decode(
                            Components.Schemas.CodeScanningRefFull.self,
                            forKey: .ref
                        )
                        self.sarif = try container.decode(
                            Components.Schemas.CodeScanningAnalysisSarifFile.self,
                            forKey: .sarif
                        )
                        self.checkoutUri = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .checkoutUri
                        )
                        self.startedAt = try container.decodeIfPresent(
                            Foundation.Date.self,
                            forKey: .startedAt
                        )
                        self.toolName = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .toolName
                        )
                        self.validate = try container.decodeIfPresent(
                            Swift.Bool.self,
                            forKey: .validate
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "commit_sha",
                            "ref",
                            "sarif",
                            "checkout_uri",
                            "started_at",
                            "tool_name",
                            "validate"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/requestBody/content/application\/json`.
                case json(Operations.CodeScanningUploadSarif.Input.Body.JsonPayload)
            }
            public var body: Operations.CodeScanningUploadSarif.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodeScanningUploadSarif.Input.Path,
                headers: Operations.CodeScanningUploadSarif.Input.Headers = .init(),
                body: Operations.CodeScanningUploadSarif.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.CodeScanningSarifsReceipt)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningSarifsReceipt {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningUploadSarif.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningUploadSarif.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodeScanningUploadSarif.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodeScanningUploadSarif.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// Creates a new `BadRequest`.
                public init() {}
            }
            /// Bad Request if the sarif field is invalid
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CodeScanningUploadSarif.Output.BadRequest)
            /// Bad Request if the sarif field is invalid
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CodeScanningUploadSarif.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Response if the repository is archived or if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenWrite)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenWrite {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct ContentTooLarge: Sendable, Hashable {
                /// Creates a new `ContentTooLarge`.
                public init() {}
            }
            /// Payload Too Large if the sarif field is too large
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/413`.
            ///
            /// HTTP response code: `413 contentTooLarge`.
            case contentTooLarge(Operations.CodeScanningUploadSarif.Output.ContentTooLarge)
            /// Payload Too Large if the sarif field is too large
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/413`.
            ///
            /// HTTP response code: `413 contentTooLarge`.
            public static var contentTooLarge: Self {
                .contentTooLarge(.init())
            }
            /// The associated value of the enum case if `self` is `.contentTooLarge`.
            ///
            /// - Throws: An error if `self` is not `.contentTooLarge`.
            /// - SeeAlso: `.contentTooLarge`.
            public var contentTooLarge: Operations.CodeScanningUploadSarif.Output.ContentTooLarge {
                get throws {
                    switch self {
                    case let .contentTooLarge(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "contentTooLarge",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/post(code-scanning/upload-sarif)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get information about a SARIF upload
    ///
    /// Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository)."
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint with private or public repositories, or the `public_repo` scope to use this endpoint with only public repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)`.
    public enum CodeScanningGetSarif {
        public static let id: Swift.String = "code-scanning/get-sarif"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The SARIF ID obtained after uploading.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/path/sarif_id`.
                public var sarifId: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - sarifId: The SARIF ID obtained after uploading.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    sarifId: Swift.String
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.sarifId = sarifId
                }
            }
            public var path: Operations.CodeScanningGetSarif.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetSarif.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodeScanningGetSarif.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodeScanningGetSarif.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodeScanningGetSarif.Input.Path,
                headers: Operations.CodeScanningGetSarif.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodeScanningSarifsStatus)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodeScanningSarifsStatus {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodeScanningGetSarif.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodeScanningGetSarif.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodeScanningGetSarif.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodeScanningGetSarif.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Response if GitHub Advanced Security is not enabled for this repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.CodeScanningForbiddenRead)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.CodeScanningForbiddenRead {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if the sarif id does not match any upload
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.CodeScanningGetSarif.Output.NotFound)
            /// Not Found if the sarif id does not match any upload
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.CodeScanningGetSarif.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}/get(code-scanning/get-sarif)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
