// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get an assignment
    ///
    /// Gets a GitHub Classroom assignment. Assignment will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/get(classroom/get-an-assignment)`.
    func classroomGetAnAssignment(_ input: Operations.ClassroomGetAnAssignment.Input) async throws -> Operations.ClassroomGetAnAssignment.Output
    /// List accepted assignments for an assignment
    ///
    /// Lists any assignment repositories that have been created by students accepting a GitHub Classroom assignment. Accepted assignments will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/accepted_assignments`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/accepted_assignments/get(classroom/list-accepted-assignments-for-an-assignment)`.
    func classroomListAcceptedAssignmentsForAnAssignment(_ input: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input) async throws -> Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output
    /// Get assignment grades
    ///
    /// Gets grades for a GitHub Classroom assignment. Grades will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/grades`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/grades/get(classroom/get-assignment-grades)`.
    func classroomGetAssignmentGrades(_ input: Operations.ClassroomGetAssignmentGrades.Input) async throws -> Operations.ClassroomGetAssignmentGrades.Output
    /// List classrooms
    ///
    /// Lists GitHub Classroom classrooms for the current user. Classrooms will only be returned if the current user is an administrator of one or more GitHub Classrooms.
    ///
    /// - Remark: HTTP `GET /classrooms`.
    /// - Remark: Generated from `#/paths//classrooms/get(classroom/list-classrooms)`.
    func classroomListClassrooms(_ input: Operations.ClassroomListClassrooms.Input) async throws -> Operations.ClassroomListClassrooms.Output
    /// Get a classroom
    ///
    /// Gets a GitHub Classroom classroom for the current user. Classroom will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/get(classroom/get-a-classroom)`.
    func classroomGetAClassroom(_ input: Operations.ClassroomGetAClassroom.Input) async throws -> Operations.ClassroomGetAClassroom.Output
    /// List assignments for a classroom
    ///
    /// Lists GitHub Classroom assignments for a classroom. Assignments will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}/assignments`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/assignments/get(classroom/list-assignments-for-a-classroom)`.
    func classroomListAssignmentsForAClassroom(_ input: Operations.ClassroomListAssignmentsForAClassroom.Input) async throws -> Operations.ClassroomListAssignmentsForAClassroom.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get an assignment
    ///
    /// Gets a GitHub Classroom assignment. Assignment will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/get(classroom/get-an-assignment)`.
    public func classroomGetAnAssignment(
        path: Operations.ClassroomGetAnAssignment.Input.Path,
        headers: Operations.ClassroomGetAnAssignment.Input.Headers = .init()
    ) async throws -> Operations.ClassroomGetAnAssignment.Output {
        try await classroomGetAnAssignment(Operations.ClassroomGetAnAssignment.Input(
            path: path,
            headers: headers
        ))
    }
    /// List accepted assignments for an assignment
    ///
    /// Lists any assignment repositories that have been created by students accepting a GitHub Classroom assignment. Accepted assignments will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/accepted_assignments`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/accepted_assignments/get(classroom/list-accepted-assignments-for-an-assignment)`.
    public func classroomListAcceptedAssignmentsForAnAssignment(
        path: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Path,
        query: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Query = .init(),
        headers: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Headers = .init()
    ) async throws -> Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output {
        try await classroomListAcceptedAssignmentsForAnAssignment(Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get assignment grades
    ///
    /// Gets grades for a GitHub Classroom assignment. Grades will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/grades`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/grades/get(classroom/get-assignment-grades)`.
    public func classroomGetAssignmentGrades(
        path: Operations.ClassroomGetAssignmentGrades.Input.Path,
        headers: Operations.ClassroomGetAssignmentGrades.Input.Headers = .init()
    ) async throws -> Operations.ClassroomGetAssignmentGrades.Output {
        try await classroomGetAssignmentGrades(Operations.ClassroomGetAssignmentGrades.Input(
            path: path,
            headers: headers
        ))
    }
    /// List classrooms
    ///
    /// Lists GitHub Classroom classrooms for the current user. Classrooms will only be returned if the current user is an administrator of one or more GitHub Classrooms.
    ///
    /// - Remark: HTTP `GET /classrooms`.
    /// - Remark: Generated from `#/paths//classrooms/get(classroom/list-classrooms)`.
    public func classroomListClassrooms(
        query: Operations.ClassroomListClassrooms.Input.Query = .init(),
        headers: Operations.ClassroomListClassrooms.Input.Headers = .init()
    ) async throws -> Operations.ClassroomListClassrooms.Output {
        try await classroomListClassrooms(Operations.ClassroomListClassrooms.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a classroom
    ///
    /// Gets a GitHub Classroom classroom for the current user. Classroom will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/get(classroom/get-a-classroom)`.
    public func classroomGetAClassroom(
        path: Operations.ClassroomGetAClassroom.Input.Path,
        headers: Operations.ClassroomGetAClassroom.Input.Headers = .init()
    ) async throws -> Operations.ClassroomGetAClassroom.Output {
        try await classroomGetAClassroom(Operations.ClassroomGetAClassroom.Input(
            path: path,
            headers: headers
        ))
    }
    /// List assignments for a classroom
    ///
    /// Lists GitHub Classroom assignments for a classroom. Assignments will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}/assignments`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/assignments/get(classroom/list-assignments-for-a-classroom)`.
    public func classroomListAssignmentsForAClassroom(
        path: Operations.ClassroomListAssignmentsForAClassroom.Input.Path,
        query: Operations.ClassroomListAssignmentsForAClassroom.Input.Query = .init(),
        headers: Operations.ClassroomListAssignmentsForAClassroom.Input.Headers = .init()
    ) async throws -> Operations.ClassroomListAssignmentsForAClassroom.Output {
        try await classroomListAssignmentsForAClassroom(Operations.ClassroomListAssignmentsForAClassroom.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// A GitHub repository view for Classroom
        ///
        /// - Remark: Generated from `#/components/schemas/simple-classroom-repository`.
        public struct SimpleClassroomRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/id`.
            public var id: Swift.Int
            /// The full, globally unique name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/full_name`.
            public var fullName: Swift.String
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/node_id`.
            public var nodeId: Swift.String
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/private`.
            public var _private: Swift.Bool
            /// The default branch for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// Creates a new `SimpleClassroomRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - fullName: The full, globally unique name of the repository.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - _private: Whether the repository is private.
            ///   - defaultBranch: The default branch for the repository.
            public init(
                id: Swift.Int,
                fullName: Swift.String,
                htmlUrl: Swift.String,
                nodeId: Swift.String,
                _private: Swift.Bool,
                defaultBranch: Swift.String
            ) {
                self.id = id
                self.fullName = fullName
                self.htmlUrl = htmlUrl
                self.nodeId = nodeId
                self._private = _private
                self.defaultBranch = defaultBranch
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case fullName = "full_name"
                case htmlUrl = "html_url"
                case nodeId = "node_id"
                case _private = "private"
                case defaultBranch = "default_branch"
            }
        }
        /// A GitHub organization.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-classroom-organization`.
        public struct SimpleClassroomOrganization: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-classroom-organization/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `SimpleClassroomOrganization`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - login:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - name:
            ///   - avatarUrl:
            public init(
                id: Swift.Int,
                login: Swift.String,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                name: Swift.String? = nil,
                avatarUrl: Swift.String
            ) {
                self.id = id
                self.login = login
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.name = name
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case login
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case name
                case avatarUrl = "avatar_url"
            }
        }
        /// A GitHub Classroom classroom
        ///
        /// - Remark: Generated from `#/components/schemas/classroom`.
        public struct Classroom: Codable, Hashable, Sendable {
            /// Unique identifier of the classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom/id`.
            public var id: Swift.Int
            /// The name of the classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom/name`.
            public var name: Swift.String
            /// Whether classroom is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom/archived`.
            public var archived: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/classroom/organization`.
            public var organization: Components.Schemas.SimpleClassroomOrganization
            /// The URL of the classroom on GitHub Classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom/url`.
            public var url: Swift.String
            /// Creates a new `Classroom`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the classroom.
            ///   - name: The name of the classroom.
            ///   - archived: Whether classroom is archived.
            ///   - organization:
            ///   - url: The URL of the classroom on GitHub Classroom.
            public init(
                id: Swift.Int,
                name: Swift.String,
                archived: Swift.Bool,
                organization: Components.Schemas.SimpleClassroomOrganization,
                url: Swift.String
            ) {
                self.id = id
                self.name = name
                self.archived = archived
                self.organization = organization
                self.url = url
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case archived
                case organization
                case url
            }
        }
        /// A GitHub Classroom assignment
        ///
        /// - Remark: Generated from `#/components/schemas/classroom-assignment`.
        public struct ClassroomAssignment: Codable, Hashable, Sendable {
            /// Unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/id`.
            public var id: Swift.Int
            /// Whether an accepted assignment creates a public repository.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/public_repo`.
            public var publicRepo: Swift.Bool
            /// Assignment title.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/title`.
            public var title: Swift.String
            /// Whether it's a group assignment or individual assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case individual = "individual"
                case group = "group"
            }
            /// Whether it's a group assignment or individual assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/type`.
            public var _type: Components.Schemas.ClassroomAssignment._TypePayload
            /// The link that a student can use to accept the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/invite_link`.
            public var inviteLink: Swift.String
            /// Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/invitations_enabled`.
            public var invitationsEnabled: Swift.Bool
            /// Sluggified name of the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/slug`.
            public var slug: Swift.String
            /// Whether students are admins on created repository when a student accepts the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/students_are_repo_admins`.
            public var studentsAreRepoAdmins: Swift.Bool
            /// Whether feedback pull request will be created when a student accepts the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/feedback_pull_requests_enabled`.
            public var feedbackPullRequestsEnabled: Swift.Bool
            /// The maximum allowable teams for the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/max_teams`.
            public var maxTeams: Swift.Int?
            /// The maximum allowable members per team.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/max_members`.
            public var maxMembers: Swift.Int?
            /// The selected editor for the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/editor`.
            public var editor: Swift.String
            /// The number of students that have accepted the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/accepted`.
            public var accepted: Swift.Int
            /// The number of students that have submitted the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/submitted`.
            public var submitted: Swift.Int
            /// The number of students that have passed the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/passing`.
            public var passing: Swift.Int
            /// The programming language used in the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/language`.
            public var language: Swift.String
            /// The time at which the assignment is due.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/deadline`.
            public var deadline: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/starter_code_repository`.
            public var starterCodeRepository: Components.Schemas.SimpleClassroomRepository
            /// - Remark: Generated from `#/components/schemas/classroom-assignment/classroom`.
            public var classroom: Components.Schemas.Classroom
            /// Creates a new `ClassroomAssignment`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository.
            ///   - publicRepo: Whether an accepted assignment creates a public repository.
            ///   - title: Assignment title.
            ///   - _type: Whether it's a group assignment or individual assignment.
            ///   - inviteLink: The link that a student can use to accept the assignment.
            ///   - invitationsEnabled: Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.
            ///   - slug: Sluggified name of the assignment.
            ///   - studentsAreRepoAdmins: Whether students are admins on created repository when a student accepts the assignment.
            ///   - feedbackPullRequestsEnabled: Whether feedback pull request will be created when a student accepts the assignment.
            ///   - maxTeams: The maximum allowable teams for the assignment.
            ///   - maxMembers: The maximum allowable members per team.
            ///   - editor: The selected editor for the assignment.
            ///   - accepted: The number of students that have accepted the assignment.
            ///   - submitted: The number of students that have submitted the assignment.
            ///   - passing: The number of students that have passed the assignment.
            ///   - language: The programming language used in the assignment.
            ///   - deadline: The time at which the assignment is due.
            ///   - starterCodeRepository:
            ///   - classroom:
            public init(
                id: Swift.Int,
                publicRepo: Swift.Bool,
                title: Swift.String,
                _type: Components.Schemas.ClassroomAssignment._TypePayload,
                inviteLink: Swift.String,
                invitationsEnabled: Swift.Bool,
                slug: Swift.String,
                studentsAreRepoAdmins: Swift.Bool,
                feedbackPullRequestsEnabled: Swift.Bool,
                maxTeams: Swift.Int? = nil,
                maxMembers: Swift.Int? = nil,
                editor: Swift.String,
                accepted: Swift.Int,
                submitted: Swift.Int,
                passing: Swift.Int,
                language: Swift.String,
                deadline: Foundation.Date? = nil,
                starterCodeRepository: Components.Schemas.SimpleClassroomRepository,
                classroom: Components.Schemas.Classroom
            ) {
                self.id = id
                self.publicRepo = publicRepo
                self.title = title
                self._type = _type
                self.inviteLink = inviteLink
                self.invitationsEnabled = invitationsEnabled
                self.slug = slug
                self.studentsAreRepoAdmins = studentsAreRepoAdmins
                self.feedbackPullRequestsEnabled = feedbackPullRequestsEnabled
                self.maxTeams = maxTeams
                self.maxMembers = maxMembers
                self.editor = editor
                self.accepted = accepted
                self.submitted = submitted
                self.passing = passing
                self.language = language
                self.deadline = deadline
                self.starterCodeRepository = starterCodeRepository
                self.classroom = classroom
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case publicRepo = "public_repo"
                case title
                case _type = "type"
                case inviteLink = "invite_link"
                case invitationsEnabled = "invitations_enabled"
                case slug
                case studentsAreRepoAdmins = "students_are_repo_admins"
                case feedbackPullRequestsEnabled = "feedback_pull_requests_enabled"
                case maxTeams = "max_teams"
                case maxMembers = "max_members"
                case editor
                case accepted
                case submitted
                case passing
                case language
                case deadline
                case starterCodeRepository = "starter_code_repository"
                case classroom
            }
        }
        /// A GitHub user simplified for Classroom.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-classroom-user`.
        public struct SimpleClassroomUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-classroom-user/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/simple-classroom-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-classroom-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-classroom-user/html_url`.
            public var htmlUrl: Swift.String
            /// Creates a new `SimpleClassroomUser`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - login:
            ///   - avatarUrl:
            ///   - htmlUrl:
            public init(
                id: Swift.Int,
                login: Swift.String,
                avatarUrl: Swift.String,
                htmlUrl: Swift.String
            ) {
                self.id = id
                self.login = login
                self.avatarUrl = avatarUrl
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case login
                case avatarUrl = "avatar_url"
                case htmlUrl = "html_url"
            }
        }
        /// A GitHub Classroom classroom
        ///
        /// - Remark: Generated from `#/components/schemas/simple-classroom`.
        public struct SimpleClassroom: Codable, Hashable, Sendable {
            /// Unique identifier of the classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom/id`.
            public var id: Swift.Int
            /// The name of the classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom/name`.
            public var name: Swift.String
            /// Returns whether classroom is archived or not.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom/archived`.
            public var archived: Swift.Bool
            /// The url of the classroom on GitHub Classroom.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom/url`.
            public var url: Swift.String
            /// Creates a new `SimpleClassroom`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the classroom.
            ///   - name: The name of the classroom.
            ///   - archived: Returns whether classroom is archived or not.
            ///   - url: The url of the classroom on GitHub Classroom.
            public init(
                id: Swift.Int,
                name: Swift.String,
                archived: Swift.Bool,
                url: Swift.String
            ) {
                self.id = id
                self.name = name
                self.archived = archived
                self.url = url
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case archived
                case url
            }
        }
        /// A GitHub Classroom assignment
        ///
        /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment`.
        public struct SimpleClassroomAssignment: Codable, Hashable, Sendable {
            /// Unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/id`.
            public var id: Swift.Int
            /// Whether an accepted assignment creates a public repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/public_repo`.
            public var publicRepo: Swift.Bool
            /// Assignment title.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/title`.
            public var title: Swift.String
            /// Whether it's a Group Assignment or Individual Assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case individual = "individual"
                case group = "group"
            }
            /// Whether it's a Group Assignment or Individual Assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/type`.
            public var _type: Components.Schemas.SimpleClassroomAssignment._TypePayload
            /// The link that a student can use to accept the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/invite_link`.
            public var inviteLink: Swift.String
            /// Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/invitations_enabled`.
            public var invitationsEnabled: Swift.Bool
            /// Sluggified name of the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/slug`.
            public var slug: Swift.String
            /// Whether students are admins on created repository on accepted assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/students_are_repo_admins`.
            public var studentsAreRepoAdmins: Swift.Bool
            /// Whether feedback pull request will be created on assignment acceptance.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/feedback_pull_requests_enabled`.
            public var feedbackPullRequestsEnabled: Swift.Bool
            /// The maximum allowable teams for the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/max_teams`.
            public var maxTeams: Swift.Int?
            /// The maximum allowable members per team.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/max_members`.
            public var maxMembers: Swift.Int?
            /// The selected editor for the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/editor`.
            public var editor: Swift.String
            /// The number of students that have accepted the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/accepted`.
            public var accepted: Swift.Int
            /// The number of students that have submitted the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/submitted`.
            public var submitted: Swift.Int
            /// The number of students that have passed the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/passing`.
            public var passing: Swift.Int
            /// The programming language used in the assignment.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/language`.
            public var language: Swift.String
            /// The time at which the assignment is due.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/deadline`.
            public var deadline: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/simple-classroom-assignment/classroom`.
            public var classroom: Components.Schemas.SimpleClassroom
            /// Creates a new `SimpleClassroomAssignment`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository.
            ///   - publicRepo: Whether an accepted assignment creates a public repository.
            ///   - title: Assignment title.
            ///   - _type: Whether it's a Group Assignment or Individual Assignment.
            ///   - inviteLink: The link that a student can use to accept the assignment.
            ///   - invitationsEnabled: Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.
            ///   - slug: Sluggified name of the assignment.
            ///   - studentsAreRepoAdmins: Whether students are admins on created repository on accepted assignment.
            ///   - feedbackPullRequestsEnabled: Whether feedback pull request will be created on assignment acceptance.
            ///   - maxTeams: The maximum allowable teams for the assignment.
            ///   - maxMembers: The maximum allowable members per team.
            ///   - editor: The selected editor for the assignment.
            ///   - accepted: The number of students that have accepted the assignment.
            ///   - submitted: The number of students that have submitted the assignment.
            ///   - passing: The number of students that have passed the assignment.
            ///   - language: The programming language used in the assignment.
            ///   - deadline: The time at which the assignment is due.
            ///   - classroom:
            public init(
                id: Swift.Int,
                publicRepo: Swift.Bool,
                title: Swift.String,
                _type: Components.Schemas.SimpleClassroomAssignment._TypePayload,
                inviteLink: Swift.String,
                invitationsEnabled: Swift.Bool,
                slug: Swift.String,
                studentsAreRepoAdmins: Swift.Bool,
                feedbackPullRequestsEnabled: Swift.Bool,
                maxTeams: Swift.Int? = nil,
                maxMembers: Swift.Int? = nil,
                editor: Swift.String,
                accepted: Swift.Int,
                submitted: Swift.Int,
                passing: Swift.Int,
                language: Swift.String,
                deadline: Foundation.Date? = nil,
                classroom: Components.Schemas.SimpleClassroom
            ) {
                self.id = id
                self.publicRepo = publicRepo
                self.title = title
                self._type = _type
                self.inviteLink = inviteLink
                self.invitationsEnabled = invitationsEnabled
                self.slug = slug
                self.studentsAreRepoAdmins = studentsAreRepoAdmins
                self.feedbackPullRequestsEnabled = feedbackPullRequestsEnabled
                self.maxTeams = maxTeams
                self.maxMembers = maxMembers
                self.editor = editor
                self.accepted = accepted
                self.submitted = submitted
                self.passing = passing
                self.language = language
                self.deadline = deadline
                self.classroom = classroom
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case publicRepo = "public_repo"
                case title
                case _type = "type"
                case inviteLink = "invite_link"
                case invitationsEnabled = "invitations_enabled"
                case slug
                case studentsAreRepoAdmins = "students_are_repo_admins"
                case feedbackPullRequestsEnabled = "feedback_pull_requests_enabled"
                case maxTeams = "max_teams"
                case maxMembers = "max_members"
                case editor
                case accepted
                case submitted
                case passing
                case language
                case deadline
                case classroom
            }
        }
        /// A GitHub Classroom accepted assignment
        ///
        /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment`.
        public struct ClassroomAcceptedAssignment: Codable, Hashable, Sendable {
            /// Unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/id`.
            public var id: Swift.Int
            /// Whether an accepted assignment has been submitted.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/submitted`.
            public var submitted: Swift.Bool
            /// Whether a submission passed.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/passing`.
            public var passing: Swift.Bool
            /// Count of student commits.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/commit_count`.
            public var commitCount: Swift.Int
            /// Most recent grade.
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/grade`.
            public var grade: Swift.String
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/students`.
            public var students: [Components.Schemas.SimpleClassroomUser]
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/repository`.
            public var repository: Components.Schemas.SimpleClassroomRepository
            /// - Remark: Generated from `#/components/schemas/classroom-accepted-assignment/assignment`.
            public var assignment: Components.Schemas.SimpleClassroomAssignment
            /// Creates a new `ClassroomAcceptedAssignment`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository.
            ///   - submitted: Whether an accepted assignment has been submitted.
            ///   - passing: Whether a submission passed.
            ///   - commitCount: Count of student commits.
            ///   - grade: Most recent grade.
            ///   - students:
            ///   - repository:
            ///   - assignment:
            public init(
                id: Swift.Int,
                submitted: Swift.Bool,
                passing: Swift.Bool,
                commitCount: Swift.Int,
                grade: Swift.String,
                students: [Components.Schemas.SimpleClassroomUser],
                repository: Components.Schemas.SimpleClassroomRepository,
                assignment: Components.Schemas.SimpleClassroomAssignment
            ) {
                self.id = id
                self.submitted = submitted
                self.passing = passing
                self.commitCount = commitCount
                self.grade = grade
                self.students = students
                self.repository = repository
                self.assignment = assignment
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case submitted
                case passing
                case commitCount = "commit_count"
                case grade
                case students
                case repository
                case assignment
            }
        }
        /// Grade for a student or groups GitHub Classroom assignment
        ///
        /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade`.
        public struct ClassroomAssignmentGrade: Codable, Hashable, Sendable {
            /// Name of the assignment
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/assignment_name`.
            public var assignmentName: Swift.String
            /// URL of the assignment
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/assignment_url`.
            public var assignmentUrl: Swift.String
            /// URL of the starter code for the assignment
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/starter_code_url`.
            public var starterCodeUrl: Swift.String
            /// GitHub username of the student
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/github_username`.
            public var githubUsername: Swift.String
            /// Roster identifier of the student
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/roster_identifier`.
            public var rosterIdentifier: Swift.String
            /// Name of the student's assignment repository
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/student_repository_name`.
            public var studentRepositoryName: Swift.String
            /// URL of the student's assignment repository
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/student_repository_url`.
            public var studentRepositoryUrl: Swift.String
            /// Timestamp of the student's assignment submission
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/submission_timestamp`.
            public var submissionTimestamp: Swift.String
            /// Number of points awarded to the student
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/points_awarded`.
            public var pointsAwarded: Swift.Int
            /// Number of points available for the assignment
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/points_available`.
            public var pointsAvailable: Swift.Int
            /// If a group assignment, name of the group the student is in
            ///
            /// - Remark: Generated from `#/components/schemas/classroom-assignment-grade/group_name`.
            public var groupName: Swift.String?
            /// Creates a new `ClassroomAssignmentGrade`.
            ///
            /// - Parameters:
            ///   - assignmentName: Name of the assignment
            ///   - assignmentUrl: URL of the assignment
            ///   - starterCodeUrl: URL of the starter code for the assignment
            ///   - githubUsername: GitHub username of the student
            ///   - rosterIdentifier: Roster identifier of the student
            ///   - studentRepositoryName: Name of the student's assignment repository
            ///   - studentRepositoryUrl: URL of the student's assignment repository
            ///   - submissionTimestamp: Timestamp of the student's assignment submission
            ///   - pointsAwarded: Number of points awarded to the student
            ///   - pointsAvailable: Number of points available for the assignment
            ///   - groupName: If a group assignment, name of the group the student is in
            public init(
                assignmentName: Swift.String,
                assignmentUrl: Swift.String,
                starterCodeUrl: Swift.String,
                githubUsername: Swift.String,
                rosterIdentifier: Swift.String,
                studentRepositoryName: Swift.String,
                studentRepositoryUrl: Swift.String,
                submissionTimestamp: Swift.String,
                pointsAwarded: Swift.Int,
                pointsAvailable: Swift.Int,
                groupName: Swift.String? = nil
            ) {
                self.assignmentName = assignmentName
                self.assignmentUrl = assignmentUrl
                self.starterCodeUrl = starterCodeUrl
                self.githubUsername = githubUsername
                self.rosterIdentifier = rosterIdentifier
                self.studentRepositoryName = studentRepositoryName
                self.studentRepositoryUrl = studentRepositoryUrl
                self.submissionTimestamp = submissionTimestamp
                self.pointsAwarded = pointsAwarded
                self.pointsAvailable = pointsAvailable
                self.groupName = groupName
            }
            public enum CodingKeys: String, CodingKey {
                case assignmentName = "assignment_name"
                case assignmentUrl = "assignment_url"
                case starterCodeUrl = "starter_code_url"
                case githubUsername = "github_username"
                case rosterIdentifier = "roster_identifier"
                case studentRepositoryName = "student_repository_name"
                case studentRepositoryUrl = "student_repository_url"
                case submissionTimestamp = "submission_timestamp"
                case pointsAwarded = "points_awarded"
                case pointsAvailable = "points_available"
                case groupName = "group_name"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The unique identifier of the classroom assignment.
        ///
        /// - Remark: Generated from `#/components/parameters/assignment-id`.
        public typealias AssignmentId = Swift.Int
        /// The unique identifier of the classroom.
        ///
        /// - Remark: Generated from `#/components/parameters/classroom-id`.
        public typealias ClassroomId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get an assignment
    ///
    /// Gets a GitHub Classroom assignment. Assignment will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/get(classroom/get-an-assignment)`.
    public enum ClassroomGetAnAssignment {
        public static let id: Swift.String = "classroom/get-an-assignment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the classroom assignment.
                ///
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/GET/path/assignment_id`.
                public var assignmentId: Components.Parameters.AssignmentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assignmentId: The unique identifier of the classroom assignment.
                public init(assignmentId: Components.Parameters.AssignmentId) {
                    self.assignmentId = assignmentId
                }
            }
            public var path: Operations.ClassroomGetAnAssignment.Input.Path
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAnAssignment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAnAssignment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomGetAnAssignment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ClassroomGetAnAssignment.Input.Path,
                headers: Operations.ClassroomGetAnAssignment.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assignments/{assignment_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ClassroomAssignment)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ClassroomAssignment {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomGetAnAssignment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomGetAnAssignment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//assignments/{assignment_id}/get(classroom/get-an-assignment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomGetAnAssignment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomGetAnAssignment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//assignments/{assignment_id}/get(classroom/get-an-assignment)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List accepted assignments for an assignment
    ///
    /// Lists any assignment repositories that have been created by students accepting a GitHub Classroom assignment. Accepted assignments will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/accepted_assignments`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/accepted_assignments/get(classroom/list-accepted-assignments-for-an-assignment)`.
    public enum ClassroomListAcceptedAssignmentsForAnAssignment {
        public static let id: Swift.String = "classroom/list-accepted-assignments-for-an-assignment"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the classroom assignment.
                ///
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/path/assignment_id`.
                public var assignmentId: Components.Parameters.AssignmentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assignmentId: The unique identifier of the classroom assignment.
                public init(assignmentId: Components.Parameters.AssignmentId) {
                    self.assignmentId = assignmentId
                }
            }
            public var path: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Path
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Query
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListAcceptedAssignmentsForAnAssignment.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListAcceptedAssignmentsForAnAssignment.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Path,
                query: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Query = .init(),
                headers: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assignments/{assignment_id}/accepted_assignments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ClassroomAcceptedAssignment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ClassroomAcceptedAssignment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//assignments/{assignment_id}/accepted_assignments/get(classroom/list-accepted-assignments-for-an-assignment)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomListAcceptedAssignmentsForAnAssignment.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get assignment grades
    ///
    /// Gets grades for a GitHub Classroom assignment. Grades will only be returned if the current user is an administrator of the GitHub Classroom for the assignment.
    ///
    /// - Remark: HTTP `GET /assignments/{assignment_id}/grades`.
    /// - Remark: Generated from `#/paths//assignments/{assignment_id}/grades/get(classroom/get-assignment-grades)`.
    public enum ClassroomGetAssignmentGrades {
        public static let id: Swift.String = "classroom/get-assignment-grades"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/grades/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the classroom assignment.
                ///
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/grades/GET/path/assignment_id`.
                public var assignmentId: Components.Parameters.AssignmentId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assignmentId: The unique identifier of the classroom assignment.
                public init(assignmentId: Components.Parameters.AssignmentId) {
                    self.assignmentId = assignmentId
                }
            }
            public var path: Operations.ClassroomGetAssignmentGrades.Input.Path
            /// - Remark: Generated from `#/paths/assignments/{assignment_id}/grades/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAssignmentGrades.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAssignmentGrades.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomGetAssignmentGrades.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ClassroomGetAssignmentGrades.Input.Path,
                headers: Operations.ClassroomGetAssignmentGrades.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assignments/{assignment_id}/grades/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assignments/{assignment_id}/grades/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.ClassroomAssignmentGrade])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.ClassroomAssignmentGrade] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomGetAssignmentGrades.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomGetAssignmentGrades.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//assignments/{assignment_id}/grades/get(classroom/get-assignment-grades)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomGetAssignmentGrades.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomGetAssignmentGrades.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//assignments/{assignment_id}/grades/get(classroom/get-assignment-grades)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List classrooms
    ///
    /// Lists GitHub Classroom classrooms for the current user. Classrooms will only be returned if the current user is an administrator of one or more GitHub Classrooms.
    ///
    /// - Remark: HTTP `GET /classrooms`.
    /// - Remark: Generated from `#/paths//classrooms/get(classroom/list-classrooms)`.
    public enum ClassroomListClassrooms {
        public static let id: Swift.String = "classroom/list-classrooms"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/classrooms/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/classrooms/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/classrooms/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.ClassroomListClassrooms.Input.Query
            /// - Remark: Generated from `#/paths/classrooms/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListClassrooms.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListClassrooms.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomListClassrooms.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.ClassroomListClassrooms.Input.Query = .init(),
                headers: Operations.ClassroomListClassrooms.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/classrooms/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/classrooms/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleClassroom])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleClassroom] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomListClassrooms.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomListClassrooms.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//classrooms/get(classroom/list-classrooms)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomListClassrooms.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomListClassrooms.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a classroom
    ///
    /// Gets a GitHub Classroom classroom for the current user. Classroom will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/get(classroom/get-a-classroom)`.
    public enum ClassroomGetAClassroom {
        public static let id: Swift.String = "classroom/get-a-classroom"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the classroom.
                ///
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/GET/path/classroom_id`.
                public var classroomId: Components.Parameters.ClassroomId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - classroomId: The unique identifier of the classroom.
                public init(classroomId: Components.Parameters.ClassroomId) {
                    self.classroomId = classroomId
                }
            }
            public var path: Operations.ClassroomGetAClassroom.Input.Path
            /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAClassroom.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomGetAClassroom.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomGetAClassroom.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ClassroomGetAClassroom.Input.Path,
                headers: Operations.ClassroomGetAClassroom.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Classroom)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Classroom {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomGetAClassroom.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomGetAClassroom.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/get(classroom/get-a-classroom)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomGetAClassroom.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomGetAClassroom.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/get(classroom/get-a-classroom)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List assignments for a classroom
    ///
    /// Lists GitHub Classroom assignments for a classroom. Assignments will only be returned if the current user is an administrator of the GitHub Classroom.
    ///
    /// - Remark: HTTP `GET /classrooms/{classroom_id}/assignments`.
    /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/assignments/get(classroom/list-assignments-for-a-classroom)`.
    public enum ClassroomListAssignmentsForAClassroom {
        public static let id: Swift.String = "classroom/list-assignments-for-a-classroom"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the classroom.
                ///
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/path/classroom_id`.
                public var classroomId: Components.Parameters.ClassroomId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - classroomId: The unique identifier of the classroom.
                public init(classroomId: Components.Parameters.ClassroomId) {
                    self.classroomId = classroomId
                }
            }
            public var path: Operations.ClassroomListAssignmentsForAClassroom.Input.Path
            /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.ClassroomListAssignmentsForAClassroom.Input.Query
            /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListAssignmentsForAClassroom.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ClassroomListAssignmentsForAClassroom.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ClassroomListAssignmentsForAClassroom.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ClassroomListAssignmentsForAClassroom.Input.Path,
                query: Operations.ClassroomListAssignmentsForAClassroom.Input.Query = .init(),
                headers: Operations.ClassroomListAssignmentsForAClassroom.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/classrooms/{classroom_id}/assignments/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleClassroomAssignment])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleClassroomAssignment] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ClassroomListAssignmentsForAClassroom.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ClassroomListAssignmentsForAClassroom.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//classrooms/{classroom_id}/assignments/get(classroom/list-assignments-for-a-classroom)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ClassroomListAssignmentsForAClassroom.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ClassroomListAssignmentsForAClassroom.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
