// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Create a check run
    ///
    /// Creates a new check run for a specific commit in a repository.
    ///
    /// To create a check run, you must use a GitHub App. OAuth apps and authenticated users are not able to create a check suite.
    ///
    /// In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/post(checks/create)`.
    func checksCreate(_ input: Operations.ChecksCreate.Input) async throws -> Operations.ChecksCreate.Output
    /// Get a check run
    ///
    /// Gets a single check run using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/get(checks/get)`.
    func checksGet(_ input: Operations.ChecksGet.Input) async throws -> Operations.ChecksGet.Output
    /// Update a check run
    ///
    /// Updates a check run for a specific commit in a repository.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/patch(checks/update)`.
    func checksUpdate(_ input: Operations.ChecksUpdate.Input) async throws -> Operations.ChecksUpdate.Output
    /// List check run annotations
    ///
    /// Lists annotations for a check run using the annotation `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}/annotations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/get(checks/list-annotations)`.
    func checksListAnnotations(_ input: Operations.ChecksListAnnotations.Input) async throws -> Operations.ChecksListAnnotations.Output
    /// Rerequest a check run
    ///
    /// Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, the `status` of the check suite it belongs to is reset to `queued` and the `conclusion` is cleared. The check run itself is not updated. GitHub apps recieving the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) with the `rerequested` action should then decide if the check run should be reset or updated and call the [update `check_run` endpoint](https://docs.github.com/rest/checks/runs#update-a-check-run) to update the check_run if desired.
    ///
    /// For more information about how to re-run GitHub Actions jobs, see "[Re-run a job from a workflow run](https://docs.github.com/rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run)".
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)`.
    func checksRerequestRun(_ input: Operations.ChecksRerequestRun.Input) async throws -> Operations.ChecksRerequestRun.Output
    /// Create a check suite
    ///
    /// Creates a check suite manually. By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/checks/runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/checks/suites#update-repository-preferences-for-check-suites)".
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/post(checks/create-suite)`.
    func checksCreateSuite(_ input: Operations.ChecksCreateSuite.Input) async throws -> Operations.ChecksCreateSuite.Output
    /// Update repository preferences for check suites
    ///
    /// Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/checks/suites#create-a-check-suite).
    /// You must have admin permissions in the repository to set preferences for check suites.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-suites/preferences`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/preferences/patch(checks/set-suites-preferences)`.
    func checksSetSuitesPreferences(_ input: Operations.ChecksSetSuitesPreferences.Input) async throws -> Operations.ChecksSetSuitesPreferences.Output
    /// Get a check suite
    ///
    /// Gets a single check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/get(checks/get-suite)`.
    func checksGetSuite(_ input: Operations.ChecksGetSuite.Input) async throws -> Operations.ChecksGetSuite.Output
    /// List check runs in a check suite
    ///
    /// Lists check runs for a check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/get(checks/list-for-suite)`.
    func checksListForSuite(_ input: Operations.ChecksListForSuite.Input) async throws -> Operations.ChecksListForSuite.Output
    /// Rerequest a check suite
    ///
    /// Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/post(checks/rerequest-suite)`.
    func checksRerequestSuite(_ input: Operations.ChecksRerequestSuite.Input) async throws -> Operations.ChecksRerequestSuite.Output
    /// List check runs for a Git reference
    ///
    /// Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// If there are more than 1000 check suites on a single git reference, this endpoint will limit check runs to the 1000 most recent check suites. To iterate over all possible check runs, use the [List check suites for a Git reference](https://docs.github.com/rest/reference/checks#list-check-suites-for-a-git-reference) endpoint and provide the `check_suite_id` parameter to the [List check runs in a check suite](https://docs.github.com/rest/reference/checks#list-check-runs-in-a-check-suite) endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-runs/get(checks/list-for-ref)`.
    func checksListForRef(_ input: Operations.ChecksListForRef.Input) async throws -> Operations.ChecksListForRef.Output
    /// List check suites for a Git reference
    ///
    /// Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-suites/get(checks/list-suites-for-ref)`.
    func checksListSuitesForRef(_ input: Operations.ChecksListSuitesForRef.Input) async throws -> Operations.ChecksListSuitesForRef.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Create a check run
    ///
    /// Creates a new check run for a specific commit in a repository.
    ///
    /// To create a check run, you must use a GitHub App. OAuth apps and authenticated users are not able to create a check suite.
    ///
    /// In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/post(checks/create)`.
    public func checksCreate(
        path: Operations.ChecksCreate.Input.Path,
        headers: Operations.ChecksCreate.Input.Headers = .init(),
        body: Operations.ChecksCreate.Input.Body
    ) async throws -> Operations.ChecksCreate.Output {
        try await checksCreate(Operations.ChecksCreate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a check run
    ///
    /// Gets a single check run using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/get(checks/get)`.
    public func checksGet(
        path: Operations.ChecksGet.Input.Path,
        headers: Operations.ChecksGet.Input.Headers = .init()
    ) async throws -> Operations.ChecksGet.Output {
        try await checksGet(Operations.ChecksGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a check run
    ///
    /// Updates a check run for a specific commit in a repository.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/patch(checks/update)`.
    public func checksUpdate(
        path: Operations.ChecksUpdate.Input.Path,
        headers: Operations.ChecksUpdate.Input.Headers = .init(),
        body: Operations.ChecksUpdate.Input.Body
    ) async throws -> Operations.ChecksUpdate.Output {
        try await checksUpdate(Operations.ChecksUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List check run annotations
    ///
    /// Lists annotations for a check run using the annotation `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}/annotations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/get(checks/list-annotations)`.
    public func checksListAnnotations(
        path: Operations.ChecksListAnnotations.Input.Path,
        query: Operations.ChecksListAnnotations.Input.Query = .init(),
        headers: Operations.ChecksListAnnotations.Input.Headers = .init()
    ) async throws -> Operations.ChecksListAnnotations.Output {
        try await checksListAnnotations(Operations.ChecksListAnnotations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Rerequest a check run
    ///
    /// Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, the `status` of the check suite it belongs to is reset to `queued` and the `conclusion` is cleared. The check run itself is not updated. GitHub apps recieving the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) with the `rerequested` action should then decide if the check run should be reset or updated and call the [update `check_run` endpoint](https://docs.github.com/rest/checks/runs#update-a-check-run) to update the check_run if desired.
    ///
    /// For more information about how to re-run GitHub Actions jobs, see "[Re-run a job from a workflow run](https://docs.github.com/rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run)".
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)`.
    public func checksRerequestRun(
        path: Operations.ChecksRerequestRun.Input.Path,
        headers: Operations.ChecksRerequestRun.Input.Headers = .init()
    ) async throws -> Operations.ChecksRerequestRun.Output {
        try await checksRerequestRun(Operations.ChecksRerequestRun.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a check suite
    ///
    /// Creates a check suite manually. By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/checks/runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/checks/suites#update-repository-preferences-for-check-suites)".
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/post(checks/create-suite)`.
    public func checksCreateSuite(
        path: Operations.ChecksCreateSuite.Input.Path,
        headers: Operations.ChecksCreateSuite.Input.Headers = .init(),
        body: Operations.ChecksCreateSuite.Input.Body
    ) async throws -> Operations.ChecksCreateSuite.Output {
        try await checksCreateSuite(Operations.ChecksCreateSuite.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update repository preferences for check suites
    ///
    /// Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/checks/suites#create-a-check-suite).
    /// You must have admin permissions in the repository to set preferences for check suites.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-suites/preferences`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/preferences/patch(checks/set-suites-preferences)`.
    public func checksSetSuitesPreferences(
        path: Operations.ChecksSetSuitesPreferences.Input.Path,
        headers: Operations.ChecksSetSuitesPreferences.Input.Headers = .init(),
        body: Operations.ChecksSetSuitesPreferences.Input.Body
    ) async throws -> Operations.ChecksSetSuitesPreferences.Output {
        try await checksSetSuitesPreferences(Operations.ChecksSetSuitesPreferences.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a check suite
    ///
    /// Gets a single check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/get(checks/get-suite)`.
    public func checksGetSuite(
        path: Operations.ChecksGetSuite.Input.Path,
        headers: Operations.ChecksGetSuite.Input.Headers = .init()
    ) async throws -> Operations.ChecksGetSuite.Output {
        try await checksGetSuite(Operations.ChecksGetSuite.Input(
            path: path,
            headers: headers
        ))
    }
    /// List check runs in a check suite
    ///
    /// Lists check runs for a check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/get(checks/list-for-suite)`.
    public func checksListForSuite(
        path: Operations.ChecksListForSuite.Input.Path,
        query: Operations.ChecksListForSuite.Input.Query = .init(),
        headers: Operations.ChecksListForSuite.Input.Headers = .init()
    ) async throws -> Operations.ChecksListForSuite.Output {
        try await checksListForSuite(Operations.ChecksListForSuite.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Rerequest a check suite
    ///
    /// Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/post(checks/rerequest-suite)`.
    public func checksRerequestSuite(
        path: Operations.ChecksRerequestSuite.Input.Path,
        headers: Operations.ChecksRerequestSuite.Input.Headers = .init()
    ) async throws -> Operations.ChecksRerequestSuite.Output {
        try await checksRerequestSuite(Operations.ChecksRerequestSuite.Input(
            path: path,
            headers: headers
        ))
    }
    /// List check runs for a Git reference
    ///
    /// Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// If there are more than 1000 check suites on a single git reference, this endpoint will limit check runs to the 1000 most recent check suites. To iterate over all possible check runs, use the [List check suites for a Git reference](https://docs.github.com/rest/reference/checks#list-check-suites-for-a-git-reference) endpoint and provide the `check_suite_id` parameter to the [List check runs in a check suite](https://docs.github.com/rest/reference/checks#list-check-runs-in-a-check-suite) endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-runs/get(checks/list-for-ref)`.
    public func checksListForRef(
        path: Operations.ChecksListForRef.Input.Path,
        query: Operations.ChecksListForRef.Input.Query = .init(),
        headers: Operations.ChecksListForRef.Input.Headers = .init()
    ) async throws -> Operations.ChecksListForRef.Output {
        try await checksListForRef(Operations.ChecksListForRef.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List check suites for a Git reference
    ///
    /// Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-suites/get(checks/list-suites-for-ref)`.
    public func checksListSuitesForRef(
        path: Operations.ChecksListSuitesForRef.Input.Path,
        query: Operations.ChecksListSuitesForRef.Input.Query = .init(),
        headers: Operations.ChecksListSuitesForRef.Input.Headers = .init()
    ) async throws -> Operations.ChecksListSuitesForRef.Output {
        try await checksListSuitesForRef(Operations.ChecksListSuitesForRef.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// - Remark: Generated from `#/components/schemas/pull-request-minimal`.
        public struct PullRequestMinimal: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/number`.
            public var number: Swift.Int
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head`.
            public struct HeadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo`.
                public struct RepoPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/id`.
                    public var id: Swift.Int64
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/url`.
                    public var url: Swift.String
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo/name`.
                    public var name: Swift.String
                    /// Creates a new `RepoPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - url:
                    ///   - name:
                    public init(
                        id: Swift.Int64,
                        url: Swift.String,
                        name: Swift.String
                    ) {
                        self.id = id
                        self.url = url
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case url
                        case name
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head/repo`.
                public var repo: Components.Schemas.PullRequestMinimal.HeadPayload.RepoPayload
                /// Creates a new `HeadPayload`.
                ///
                /// - Parameters:
                ///   - ref:
                ///   - sha:
                ///   - repo:
                public init(
                    ref: Swift.String,
                    sha: Swift.String,
                    repo: Components.Schemas.PullRequestMinimal.HeadPayload.RepoPayload
                ) {
                    self.ref = ref
                    self.sha = sha
                    self.repo = repo
                }
                public enum CodingKeys: String, CodingKey {
                    case ref
                    case sha
                    case repo
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/head`.
            public var head: Components.Schemas.PullRequestMinimal.HeadPayload
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base`.
            public struct BasePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/ref`.
                public var ref: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo`.
                public struct RepoPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/id`.
                    public var id: Swift.Int64
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/url`.
                    public var url: Swift.String
                    /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo/name`.
                    public var name: Swift.String
                    /// Creates a new `RepoPayload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - url:
                    ///   - name:
                    public init(
                        id: Swift.Int64,
                        url: Swift.String,
                        name: Swift.String
                    ) {
                        self.id = id
                        self.url = url
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case url
                        case name
                    }
                }
                /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base/repo`.
                public var repo: Components.Schemas.PullRequestMinimal.BasePayload.RepoPayload
                /// Creates a new `BasePayload`.
                ///
                /// - Parameters:
                ///   - ref:
                ///   - sha:
                ///   - repo:
                public init(
                    ref: Swift.String,
                    sha: Swift.String,
                    repo: Components.Schemas.PullRequestMinimal.BasePayload.RepoPayload
                ) {
                    self.ref = ref
                    self.sha = sha
                    self.repo = repo
                }
                public enum CodingKeys: String, CodingKey {
                    case ref
                    case sha
                    case repo
                }
            }
            /// - Remark: Generated from `#/components/schemas/pull-request-minimal/base`.
            public var base: Components.Schemas.PullRequestMinimal.BasePayload
            /// Creates a new `PullRequestMinimal`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - number:
            ///   - url:
            ///   - head:
            ///   - base:
            public init(
                id: Swift.Int64,
                number: Swift.Int,
                url: Swift.String,
                head: Components.Schemas.PullRequestMinimal.HeadPayload,
                base: Components.Schemas.PullRequestMinimal.BasePayload
            ) {
                self.id = id
                self.number = number
                self.url = url
                self.head = head
                self.base = base
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case number
                case url
                case head
                case base
            }
        }
        /// A deployment created as the result of an Actions check run from a workflow that references an environment
        ///
        /// - Remark: Generated from `#/components/schemas/deployment-simple`.
        public struct DeploymentSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/deployment-simple/url`.
            public var url: Swift.String
            /// Unique identifier of the deployment
            ///
            /// - Remark: Generated from `#/components/schemas/deployment-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/deployment-simple/node_id`.
            public var nodeId: Swift.String
            /// Parameter to specify a task to execute
            ///
            /// - Remark: Generated from `#/components/schemas/deployment-simple/task`.
            public var task: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment-simple/original_environment`.
            public var originalEnvironment: Swift.String?
            /// Name for the target deployment environment.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment-simple/environment`.
            public var environment: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment-simple/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/deployment-simple/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment-simple/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment-simple/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment-simple/repository_url`.
            public var repositoryUrl: Swift.String
            /// Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment-simple/transient_environment`.
            public var transientEnvironment: Swift.Bool?
            /// Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment-simple/production_environment`.
            public var productionEnvironment: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/deployment-simple/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// Creates a new `DeploymentSimple`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id: Unique identifier of the deployment
            ///   - nodeId:
            ///   - task: Parameter to specify a task to execute
            ///   - originalEnvironment:
            ///   - environment: Name for the target deployment environment.
            ///   - description:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - statusesUrl:
            ///   - repositoryUrl:
            ///   - transientEnvironment: Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///   - productionEnvironment: Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///   - performedViaGithubApp:
            public init(
                url: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                task: Swift.String,
                originalEnvironment: Swift.String? = nil,
                environment: Swift.String,
                description: Swift.String? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                statusesUrl: Swift.String,
                repositoryUrl: Swift.String,
                transientEnvironment: Swift.Bool? = nil,
                productionEnvironment: Swift.Bool? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.task = task
                self.originalEnvironment = originalEnvironment
                self.environment = environment
                self.description = description
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.statusesUrl = statusesUrl
                self.repositoryUrl = repositoryUrl
                self.transientEnvironment = transientEnvironment
                self.productionEnvironment = productionEnvironment
                self.performedViaGithubApp = performedViaGithubApp
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case task
                case originalEnvironment = "original_environment"
                case environment
                case description
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case statusesUrl = "statuses_url"
                case repositoryUrl = "repository_url"
                case transientEnvironment = "transient_environment"
                case productionEnvironment = "production_environment"
                case performedViaGithubApp = "performed_via_github_app"
            }
        }
        /// A check performed on the code of a given code change
        ///
        /// - Remark: Generated from `#/components/schemas/check-run`.
        public struct CheckRun: Codable, Hashable, Sendable {
            /// The id of the check.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/id`.
            public var id: Swift.Int64
            /// The SHA of the commit that is being checked.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/head_sha`.
            public var headSha: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-run/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-run/external_id`.
            public var externalId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-run/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-run/html_url`.
            public var htmlUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-run/details_url`.
            public var detailsUrl: Swift.String?
            /// The phase of the lifecycle that the check is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check runs.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case queued = "queued"
                case inProgress = "in_progress"
                case completed = "completed"
                case waiting = "waiting"
                case requested = "requested"
                case pending = "pending"
            }
            /// The phase of the lifecycle that the check is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check runs.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/status`.
            public var status: Components.Schemas.CheckRun.StatusPayload
            /// - Remark: Generated from `#/components/schemas/check-run/conclusion`.
            @frozen public enum ConclusionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case success = "success"
                case failure = "failure"
                case neutral = "neutral"
                case cancelled = "cancelled"
                case skipped = "skipped"
                case timedOut = "timed_out"
                case actionRequired = "action_required"
            }
            /// - Remark: Generated from `#/components/schemas/check-run/conclusion`.
            public var conclusion: Components.Schemas.CheckRun.ConclusionPayload?
            /// - Remark: Generated from `#/components/schemas/check-run/started_at`.
            public var startedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/check-run/completed_at`.
            public var completedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/check-run/output`.
            public struct OutputPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/check-run/output/title`.
                public var title: Swift.String?
                /// - Remark: Generated from `#/components/schemas/check-run/output/summary`.
                public var summary: Swift.String?
                /// - Remark: Generated from `#/components/schemas/check-run/output/text`.
                public var text: Swift.String?
                /// - Remark: Generated from `#/components/schemas/check-run/output/annotations_count`.
                public var annotationsCount: Swift.Int
                /// - Remark: Generated from `#/components/schemas/check-run/output/annotations_url`.
                public var annotationsUrl: Swift.String
                /// Creates a new `OutputPayload`.
                ///
                /// - Parameters:
                ///   - title:
                ///   - summary:
                ///   - text:
                ///   - annotationsCount:
                ///   - annotationsUrl:
                public init(
                    title: Swift.String? = nil,
                    summary: Swift.String? = nil,
                    text: Swift.String? = nil,
                    annotationsCount: Swift.Int,
                    annotationsUrl: Swift.String
                ) {
                    self.title = title
                    self.summary = summary
                    self.text = text
                    self.annotationsCount = annotationsCount
                    self.annotationsUrl = annotationsUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case title
                    case summary
                    case text
                    case annotationsCount = "annotations_count"
                    case annotationsUrl = "annotations_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/check-run/output`.
            public var output: Components.Schemas.CheckRun.OutputPayload
            /// The name of the check.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-run/check_suite`.
            public struct CheckSuitePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/check-run/check_suite/id`.
                public var id: Swift.Int
                /// Creates a new `CheckSuitePayload`.
                ///
                /// - Parameters:
                ///   - id:
                public init(id: Swift.Int) {
                    self.id = id
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                }
            }
            /// - Remark: Generated from `#/components/schemas/check-run/check_suite`.
            public var checkSuite: Components.Schemas.CheckRun.CheckSuitePayload?
            /// - Remark: Generated from `#/components/schemas/check-run/app`.
            public var app: Components.Schemas.NullableIntegration?
            /// Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check.
            ///
            /// - Remark: Generated from `#/components/schemas/check-run/pull_requests`.
            public var pullRequests: [Components.Schemas.PullRequestMinimal]
            /// - Remark: Generated from `#/components/schemas/check-run/deployment`.
            public var deployment: Components.Schemas.DeploymentSimple?
            /// Creates a new `CheckRun`.
            ///
            /// - Parameters:
            ///   - id: The id of the check.
            ///   - headSha: The SHA of the commit that is being checked.
            ///   - nodeId:
            ///   - externalId:
            ///   - url:
            ///   - htmlUrl:
            ///   - detailsUrl:
            ///   - status: The phase of the lifecycle that the check is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check runs.
            ///   - conclusion:
            ///   - startedAt:
            ///   - completedAt:
            ///   - output:
            ///   - name: The name of the check.
            ///   - checkSuite:
            ///   - app:
            ///   - pullRequests: Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check.
            ///   - deployment:
            public init(
                id: Swift.Int64,
                headSha: Swift.String,
                nodeId: Swift.String,
                externalId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String? = nil,
                detailsUrl: Swift.String? = nil,
                status: Components.Schemas.CheckRun.StatusPayload,
                conclusion: Components.Schemas.CheckRun.ConclusionPayload? = nil,
                startedAt: Foundation.Date? = nil,
                completedAt: Foundation.Date? = nil,
                output: Components.Schemas.CheckRun.OutputPayload,
                name: Swift.String,
                checkSuite: Components.Schemas.CheckRun.CheckSuitePayload? = nil,
                app: Components.Schemas.NullableIntegration? = nil,
                pullRequests: [Components.Schemas.PullRequestMinimal],
                deployment: Components.Schemas.DeploymentSimple? = nil
            ) {
                self.id = id
                self.headSha = headSha
                self.nodeId = nodeId
                self.externalId = externalId
                self.url = url
                self.htmlUrl = htmlUrl
                self.detailsUrl = detailsUrl
                self.status = status
                self.conclusion = conclusion
                self.startedAt = startedAt
                self.completedAt = completedAt
                self.output = output
                self.name = name
                self.checkSuite = checkSuite
                self.app = app
                self.pullRequests = pullRequests
                self.deployment = deployment
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case headSha = "head_sha"
                case nodeId = "node_id"
                case externalId = "external_id"
                case url
                case htmlUrl = "html_url"
                case detailsUrl = "details_url"
                case status
                case conclusion
                case startedAt = "started_at"
                case completedAt = "completed_at"
                case output
                case name
                case checkSuite = "check_suite"
                case app
                case pullRequests = "pull_requests"
                case deployment
            }
        }
        /// Check Annotation
        ///
        /// - Remark: Generated from `#/components/schemas/check-annotation`.
        public struct CheckAnnotation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/check-annotation/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-annotation/start_line`.
            public var startLine: Swift.Int
            /// - Remark: Generated from `#/components/schemas/check-annotation/end_line`.
            public var endLine: Swift.Int
            /// - Remark: Generated from `#/components/schemas/check-annotation/start_column`.
            public var startColumn: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/check-annotation/end_column`.
            public var endColumn: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/check-annotation/annotation_level`.
            public var annotationLevel: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-annotation/title`.
            public var title: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-annotation/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-annotation/raw_details`.
            public var rawDetails: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-annotation/blob_href`.
            public var blobHref: Swift.String
            /// Creates a new `CheckAnnotation`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - startLine:
            ///   - endLine:
            ///   - startColumn:
            ///   - endColumn:
            ///   - annotationLevel:
            ///   - title:
            ///   - message:
            ///   - rawDetails:
            ///   - blobHref:
            public init(
                path: Swift.String,
                startLine: Swift.Int,
                endLine: Swift.Int,
                startColumn: Swift.Int? = nil,
                endColumn: Swift.Int? = nil,
                annotationLevel: Swift.String? = nil,
                title: Swift.String? = nil,
                message: Swift.String? = nil,
                rawDetails: Swift.String? = nil,
                blobHref: Swift.String
            ) {
                self.path = path
                self.startLine = startLine
                self.endLine = endLine
                self.startColumn = startColumn
                self.endColumn = endColumn
                self.annotationLevel = annotationLevel
                self.title = title
                self.message = message
                self.rawDetails = rawDetails
                self.blobHref = blobHref
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case startLine = "start_line"
                case endLine = "end_line"
                case startColumn = "start_column"
                case endColumn = "end_column"
                case annotationLevel = "annotation_level"
                case title
                case message
                case rawDetails = "raw_details"
                case blobHref = "blob_href"
            }
        }
        /// A commit.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-commit`.
        public struct SimpleCommit: Codable, Hashable, Sendable {
            /// SHA for the commit
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/id`.
            public var id: Swift.String
            /// SHA for the commit's tree
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/tree_id`.
            public var treeId: Swift.String
            /// Message describing the purpose of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/message`.
            public var message: Swift.String
            /// Timestamp of the commit
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/timestamp`.
            public var timestamp: Foundation.Date
            /// Information about the Git author
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/author`.
            public struct AuthorPayload: Codable, Hashable, Sendable {
                /// Name of the commit's author
                ///
                /// - Remark: Generated from `#/components/schemas/simple-commit/author/name`.
                public var name: Swift.String
                /// Git email address of the commit's author
                ///
                /// - Remark: Generated from `#/components/schemas/simple-commit/author/email`.
                public var email: Swift.String
                /// Creates a new `AuthorPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the commit's author
                ///   - email: Git email address of the commit's author
                public init(
                    name: Swift.String,
                    email: Swift.String
                ) {
                    self.name = name
                    self.email = email
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case email
                }
            }
            /// Information about the Git author
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/author`.
            public var author: Components.Schemas.SimpleCommit.AuthorPayload?
            /// Information about the Git committer
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/committer`.
            public struct CommitterPayload: Codable, Hashable, Sendable {
                /// Name of the commit's committer
                ///
                /// - Remark: Generated from `#/components/schemas/simple-commit/committer/name`.
                public var name: Swift.String
                /// Git email address of the commit's committer
                ///
                /// - Remark: Generated from `#/components/schemas/simple-commit/committer/email`.
                public var email: Swift.String
                /// Creates a new `CommitterPayload`.
                ///
                /// - Parameters:
                ///   - name: Name of the commit's committer
                ///   - email: Git email address of the commit's committer
                public init(
                    name: Swift.String,
                    email: Swift.String
                ) {
                    self.name = name
                    self.email = email
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case email
                }
            }
            /// Information about the Git committer
            ///
            /// - Remark: Generated from `#/components/schemas/simple-commit/committer`.
            public var committer: Components.Schemas.SimpleCommit.CommitterPayload?
            /// Creates a new `SimpleCommit`.
            ///
            /// - Parameters:
            ///   - id: SHA for the commit
            ///   - treeId: SHA for the commit's tree
            ///   - message: Message describing the purpose of the commit
            ///   - timestamp: Timestamp of the commit
            ///   - author: Information about the Git author
            ///   - committer: Information about the Git committer
            public init(
                id: Swift.String,
                treeId: Swift.String,
                message: Swift.String,
                timestamp: Foundation.Date,
                author: Components.Schemas.SimpleCommit.AuthorPayload? = nil,
                committer: Components.Schemas.SimpleCommit.CommitterPayload? = nil
            ) {
                self.id = id
                self.treeId = treeId
                self.message = message
                self.timestamp = timestamp
                self.author = author
                self.committer = committer
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case treeId = "tree_id"
                case message
                case timestamp
                case author
                case committer
            }
        }
        /// A suite of checks performed on the code of a given code change
        ///
        /// - Remark: Generated from `#/components/schemas/check-suite`.
        public struct CheckSuite: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/check-suite/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/check-suite/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-suite/head_branch`.
            public var headBranch: Swift.String?
            /// The SHA of the head commit that is being checked.
            ///
            /// - Remark: Generated from `#/components/schemas/check-suite/head_sha`.
            public var headSha: Swift.String
            /// The phase of the lifecycle that the check suite is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check suites.
            ///
            /// - Remark: Generated from `#/components/schemas/check-suite/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case queued = "queued"
                case inProgress = "in_progress"
                case completed = "completed"
                case waiting = "waiting"
                case requested = "requested"
                case pending = "pending"
            }
            /// The phase of the lifecycle that the check suite is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check suites.
            ///
            /// - Remark: Generated from `#/components/schemas/check-suite/status`.
            public var status: Components.Schemas.CheckSuite.StatusPayload?
            /// - Remark: Generated from `#/components/schemas/check-suite/conclusion`.
            @frozen public enum ConclusionPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case success = "success"
                case failure = "failure"
                case neutral = "neutral"
                case cancelled = "cancelled"
                case skipped = "skipped"
                case timedOut = "timed_out"
                case actionRequired = "action_required"
                case startupFailure = "startup_failure"
                case stale = "stale"
                case _empty_ = ""
            }
            /// - Remark: Generated from `#/components/schemas/check-suite/conclusion`.
            public var conclusion: Components.Schemas.CheckSuite.ConclusionPayload?
            /// - Remark: Generated from `#/components/schemas/check-suite/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-suite/before`.
            public var before: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-suite/after`.
            public var after: Swift.String?
            /// - Remark: Generated from `#/components/schemas/check-suite/pull_requests`.
            public var pullRequests: [Components.Schemas.PullRequestMinimal]?
            /// - Remark: Generated from `#/components/schemas/check-suite/app`.
            public var app: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/check-suite/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/check-suite/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/check-suite/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/check-suite/head_commit`.
            public var headCommit: Components.Schemas.SimpleCommit
            /// - Remark: Generated from `#/components/schemas/check-suite/latest_check_runs_count`.
            public var latestCheckRunsCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/check-suite/check_runs_url`.
            public var checkRunsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/check-suite/rerequestable`.
            public var rerequestable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/check-suite/runs_rerequestable`.
            public var runsRerequestable: Swift.Bool?
            /// Creates a new `CheckSuite`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - headBranch:
            ///   - headSha: The SHA of the head commit that is being checked.
            ///   - status: The phase of the lifecycle that the check suite is currently in. Statuses of waiting, requested, and pending are reserved for GitHub Actions check suites.
            ///   - conclusion:
            ///   - url:
            ///   - before:
            ///   - after:
            ///   - pullRequests:
            ///   - app:
            ///   - repository:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - headCommit:
            ///   - latestCheckRunsCount:
            ///   - checkRunsUrl:
            ///   - rerequestable:
            ///   - runsRerequestable:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                headBranch: Swift.String? = nil,
                headSha: Swift.String,
                status: Components.Schemas.CheckSuite.StatusPayload? = nil,
                conclusion: Components.Schemas.CheckSuite.ConclusionPayload? = nil,
                url: Swift.String? = nil,
                before: Swift.String? = nil,
                after: Swift.String? = nil,
                pullRequests: [Components.Schemas.PullRequestMinimal]? = nil,
                app: Components.Schemas.NullableIntegration? = nil,
                repository: Components.Schemas.MinimalRepository,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                headCommit: Components.Schemas.SimpleCommit,
                latestCheckRunsCount: Swift.Int,
                checkRunsUrl: Swift.String,
                rerequestable: Swift.Bool? = nil,
                runsRerequestable: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.headBranch = headBranch
                self.headSha = headSha
                self.status = status
                self.conclusion = conclusion
                self.url = url
                self.before = before
                self.after = after
                self.pullRequests = pullRequests
                self.app = app
                self.repository = repository
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.headCommit = headCommit
                self.latestCheckRunsCount = latestCheckRunsCount
                self.checkRunsUrl = checkRunsUrl
                self.rerequestable = rerequestable
                self.runsRerequestable = runsRerequestable
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case headBranch = "head_branch"
                case headSha = "head_sha"
                case status
                case conclusion
                case url
                case before
                case after
                case pullRequests = "pull_requests"
                case app
                case repository
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case headCommit = "head_commit"
                case latestCheckRunsCount = "latest_check_runs_count"
                case checkRunsUrl = "check_runs_url"
                case rerequestable
                case runsRerequestable = "runs_rerequestable"
            }
        }
        /// Check suite configuration preferences for a repository.
        ///
        /// - Remark: Generated from `#/components/schemas/check-suite-preference`.
        public struct CheckSuitePreference: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences`.
            public struct PreferencesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences/AutoTriggerChecksPayload`.
                public struct AutoTriggerChecksPayloadPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences/AutoTriggerChecksPayload/app_id`.
                    public var appId: Swift.Int
                    /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences/AutoTriggerChecksPayload/setting`.
                    public var setting: Swift.Bool
                    /// Creates a new `AutoTriggerChecksPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - appId:
                    ///   - setting:
                    public init(
                        appId: Swift.Int,
                        setting: Swift.Bool
                    ) {
                        self.appId = appId
                        self.setting = setting
                    }
                    public enum CodingKeys: String, CodingKey {
                        case appId = "app_id"
                        case setting
                    }
                }
                /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences/auto_trigger_checks`.
                public typealias AutoTriggerChecksPayload = [Components.Schemas.CheckSuitePreference.PreferencesPayload.AutoTriggerChecksPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences/auto_trigger_checks`.
                public var autoTriggerChecks: Components.Schemas.CheckSuitePreference.PreferencesPayload.AutoTriggerChecksPayload?
                /// Creates a new `PreferencesPayload`.
                ///
                /// - Parameters:
                ///   - autoTriggerChecks:
                public init(autoTriggerChecks: Components.Schemas.CheckSuitePreference.PreferencesPayload.AutoTriggerChecksPayload? = nil) {
                    self.autoTriggerChecks = autoTriggerChecks
                }
                public enum CodingKeys: String, CodingKey {
                    case autoTriggerChecks = "auto_trigger_checks"
                }
            }
            /// - Remark: Generated from `#/components/schemas/check-suite-preference/preferences`.
            public var preferences: Components.Schemas.CheckSuitePreference.PreferencesPayload
            /// - Remark: Generated from `#/components/schemas/check-suite-preference/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// Creates a new `CheckSuitePreference`.
            ///
            /// - Parameters:
            ///   - preferences:
            ///   - repository:
            public init(
                preferences: Components.Schemas.CheckSuitePreference.PreferencesPayload,
                repository: Components.Schemas.MinimalRepository
            ) {
                self.preferences = preferences
                self.repository = repository
            }
            public enum CodingKeys: String, CodingKey {
                case preferences
                case repository
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The unique identifier of the check run.
        ///
        /// - Remark: Generated from `#/components/parameters/check-run-id`.
        public typealias CheckRunId = Swift.Int
        /// The unique identifier of the check suite.
        ///
        /// - Remark: Generated from `#/components/parameters/check-suite-id`.
        public typealias CheckSuiteId = Swift.Int
        /// Returns check runs with the specified `name`.
        ///
        /// - Remark: Generated from `#/components/parameters/check-name`.
        public typealias CheckName = Swift.String
        /// Returns check runs with the specified `status`.
        ///
        /// - Remark: Generated from `#/components/parameters/status`.
        @frozen public enum Status: String, Codable, Hashable, Sendable, CaseIterable {
            case queued = "queued"
            case inProgress = "in_progress"
            case completed = "completed"
        }
        /// The commit reference. Can be a commit SHA, branch name (`heads/BRANCH_NAME`), or tag name (`tags/TAG_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
        ///
        /// - Remark: Generated from `#/components/parameters/commit-ref`.
        public typealias CommitRef = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Create a check run
    ///
    /// Creates a new check run for a specific commit in a repository.
    ///
    /// To create a check run, you must use a GitHub App. OAuth apps and authenticated users are not able to create a check suite.
    ///
    /// In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/post(checks/create)`.
    public enum ChecksCreate {
        public static let id: Swift.String = "checks/create"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ChecksCreate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksCreate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksCreate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksCreate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    public enum CodingKeys: String, CodingKey {
                        case status
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        let discriminator = try container.decode(
                            Swift.String.self,
                            forKey: .status
                        )
                        switch discriminator {
                        default:
                            throw Swift.DecodingError.unknownOneOfDiscriminator(
                                discriminatorKey: CodingKeys.status,
                                discriminatorValue: discriminator,
                                codingPath: decoder.codingPath
                            )
                        }
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/requestBody/content/application\/json`.
                case json(Operations.ChecksCreate.Input.Body.JsonPayload)
            }
            public var body: Operations.ChecksCreate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ChecksCreate.Input.Path,
                headers: Operations.ChecksCreate.Input.Headers = .init(),
                body: Operations.ChecksCreate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CheckRun)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckRun {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksCreate.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksCreate.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/post(checks/create)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ChecksCreate.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ChecksCreate.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a check run
    ///
    /// Gets a single check run using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/get(checks/get)`.
    public enum ChecksGet {
        public static let id: Swift.String = "checks/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check run.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/path/check_run_id`.
                public var checkRunId: Components.Parameters.CheckRunId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkRunId: The unique identifier of the check run.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkRunId: Components.Parameters.CheckRunId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkRunId = checkRunId
                }
            }
            public var path: Operations.ChecksGet.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ChecksGet.Input.Path,
                headers: Operations.ChecksGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CheckRun)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckRun {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/get(checks/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a check run
    ///
    /// Updates a check run for a specific commit in a repository.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-runs/{check_run_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/patch(checks/update)`.
    public enum ChecksUpdate {
        public static let id: Swift.String = "checks/update"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check run.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/path/check_run_id`.
                public var checkRunId: Components.Parameters.CheckRunId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkRunId: The unique identifier of the check run.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkRunId: Components.Parameters.CheckRunId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkRunId = checkRunId
                }
            }
            public var path: Operations.ChecksUpdate.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksUpdate.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksUpdate.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksUpdate.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value1`.
                    public struct Value1Payload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value1/status`.
                        public var status: OpenAPIRuntime.OpenAPIValueContainer?
                        /// A container of undocumented properties.
                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                        /// Creates a new `Value1Payload`.
                        ///
                        /// - Parameters:
                        ///   - status:
                        ///   - additionalProperties: A container of undocumented properties.
                        public init(
                            status: OpenAPIRuntime.OpenAPIValueContainer? = nil,
                            additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
                        ) {
                            self.status = status
                            self.additionalProperties = additionalProperties
                        }
                        public enum CodingKeys: String, CodingKey {
                            case status
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            self.status = try container.decodeIfPresent(
                                OpenAPIRuntime.OpenAPIValueContainer.self,
                                forKey: .status
                            )
                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                                "status"
                            ])
                        }
                        public func encode(to encoder: any Encoder) throws {
                            var container = encoder.container(keyedBy: CodingKeys.self)
                            try container.encodeIfPresent(
                                self.status,
                                forKey: .status
                            )
                            try encoder.encodeAdditionalProperties(additionalProperties)
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value1`.
                    public var value1: Operations.ChecksUpdate.Input.Body.JsonPayload.Value1Payload?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value2`.
                    public struct Value2Payload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value2/status`.
                        public var status: OpenAPIRuntime.OpenAPIValueContainer?
                        /// A container of undocumented properties.
                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                        /// Creates a new `Value2Payload`.
                        ///
                        /// - Parameters:
                        ///   - status:
                        ///   - additionalProperties: A container of undocumented properties.
                        public init(
                            status: OpenAPIRuntime.OpenAPIValueContainer? = nil,
                            additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()
                        ) {
                            self.status = status
                            self.additionalProperties = additionalProperties
                        }
                        public enum CodingKeys: String, CodingKey {
                            case status
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            self.status = try container.decodeIfPresent(
                                OpenAPIRuntime.OpenAPIValueContainer.self,
                                forKey: .status
                            )
                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                                "status"
                            ])
                        }
                        public func encode(to encoder: any Encoder) throws {
                            var container = encoder.container(keyedBy: CodingKeys.self)
                            try container.encodeIfPresent(
                                self.status,
                                forKey: .status
                            )
                            try encoder.encodeAdditionalProperties(additionalProperties)
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/json/value2`.
                    public var value2: Operations.ChecksUpdate.Input.Body.JsonPayload.Value2Payload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - value1:
                    ///   - value2:
                    public init(
                        value1: Operations.ChecksUpdate.Input.Body.JsonPayload.Value1Payload? = nil,
                        value2: Operations.ChecksUpdate.Input.Body.JsonPayload.Value2Payload? = nil
                    ) {
                        self.value1 = value1
                        self.value2 = value2
                    }
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self.value1 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self.value2 = try .init(from: decoder)
                        } catch {
                            errors.append(error)
                        }
                        try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                            [
                                self.value1,
                                self.value2
                            ],
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try self.value1?.encode(to: encoder)
                        try self.value2?.encode(to: encoder)
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.ChecksUpdate.Input.Body.JsonPayload)
            }
            public var body: Operations.ChecksUpdate.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ChecksUpdate.Input.Path,
                headers: Operations.ChecksUpdate.Input.Headers = .init(),
                body: Operations.ChecksUpdate.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CheckRun)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckRun {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksUpdate.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksUpdate.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/patch(checks/update)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksUpdate.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksUpdate.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List check run annotations
    ///
    /// Lists annotations for a check run using the annotation `id`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-runs/{check_run_id}/annotations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/get(checks/list-annotations)`.
    public enum ChecksListAnnotations {
        public static let id: Swift.String = "checks/list-annotations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check run.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/path/check_run_id`.
                public var checkRunId: Components.Parameters.CheckRunId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkRunId: The unique identifier of the check run.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkRunId: Components.Parameters.CheckRunId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkRunId = checkRunId
                }
            }
            public var path: Operations.ChecksListAnnotations.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ChecksListAnnotations.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListAnnotations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListAnnotations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksListAnnotations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ChecksListAnnotations.Input.Path,
                query: Operations.ChecksListAnnotations.Input.Query = .init(),
                headers: Operations.ChecksListAnnotations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ChecksListAnnotations.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CheckAnnotation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CheckAnnotation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksListAnnotations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ChecksListAnnotations.Output.Ok.Headers = .init(),
                    body: Operations.ChecksListAnnotations.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/annotations/get(checks/list-annotations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksListAnnotations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksListAnnotations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Rerequest a check run
    ///
    /// Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, the `status` of the check suite it belongs to is reset to `queued` and the `conclusion` is cleared. The check run itself is not updated. GitHub apps recieving the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) with the `rerequested` action should then decide if the check run should be reset or updated and call the [update `check_run` endpoint](https://docs.github.com/rest/checks/runs#update-a-check-run) to update the check_run if desired.
    ///
    /// For more information about how to re-run GitHub Actions jobs, see "[Re-run a job from a workflow run](https://docs.github.com/rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run)".
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)`.
    public enum ChecksRerequestRun {
        public static let id: Swift.String = "checks/rerequest-run"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check run.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/path/check_run_id`.
                public var checkRunId: Components.Parameters.CheckRunId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkRunId: The unique identifier of the check run.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkRunId: Components.Parameters.CheckRunId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkRunId = checkRunId
                }
            }
            public var path: Operations.ChecksRerequestRun.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksRerequestRun.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksRerequestRun.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksRerequestRun.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ChecksRerequestRun.Input.Path,
                headers: Operations.ChecksRerequestRun.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksRerequestRun.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksRerequestRun.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ChecksRerequestRun.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ChecksRerequestRun.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/403/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/403/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksRerequestRun.Output.Forbidden.Body
                /// Creates a new `Forbidden`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksRerequestRun.Output.Forbidden.Body) {
                    self.body = body
                }
            }
            /// Forbidden if the check run is not rerequestable or doesn't belong to the authenticated GitHub App
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.ChecksRerequestRun.Output.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.ChecksRerequestRun.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/POST/responses/422/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksRerequestRun.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksRerequestRun.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Validation error if the check run is not rerequestable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.ChecksRerequestRun.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.ChecksRerequestRun.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest/post(checks/rerequest-run)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a check suite
    ///
    /// Creates a check suite manually. By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/checks/runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/checks/suites#update-repository-preferences-for-check-suites)".
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth apps and personal access tokens (classic) cannot use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/post(checks/create-suite)`.
    public enum ChecksCreateSuite {
        public static let id: Swift.String = "checks/create-suite"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ChecksCreateSuite.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksCreateSuite.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksCreateSuite.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksCreateSuite.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The sha of the head commit.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/requestBody/json/head_sha`.
                    public var headSha: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - headSha: The sha of the head commit.
                    public init(headSha: Swift.String) {
                        self.headSha = headSha
                    }
                    public enum CodingKeys: String, CodingKey {
                        case headSha = "head_sha"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/requestBody/content/application\/json`.
                case json(Operations.ChecksCreateSuite.Input.Body.JsonPayload)
            }
            public var body: Operations.ChecksCreateSuite.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ChecksCreateSuite.Input.Path,
                headers: Operations.ChecksCreateSuite.Input.Headers = .init(),
                body: Operations.ChecksCreateSuite.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CheckSuite)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckSuite {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksCreateSuite.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksCreateSuite.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when the suite already exists
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/post(checks/create-suite)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksCreateSuite.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksCreateSuite.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CheckSuite)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckSuite {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksCreateSuite.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksCreateSuite.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when the suite was created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/post(checks/create-suite)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ChecksCreateSuite.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ChecksCreateSuite.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update repository preferences for check suites
    ///
    /// Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/checks/suites#create-a-check-suite).
    /// You must have admin permissions in the repository to set preferences for check suites.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/check-suites/preferences`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/preferences/patch(checks/set-suites-preferences)`.
    public enum ChecksSetSuitesPreferences {
        public static let id: Swift.String = "checks/set-suites-preferences"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ChecksSetSuitesPreferences.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksSetSuitesPreferences.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksSetSuitesPreferences.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksSetSuitesPreferences.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json/AutoTriggerChecksPayload`.
                    public struct AutoTriggerChecksPayloadPayload: Codable, Hashable, Sendable {
                        /// The `id` of the GitHub App.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json/AutoTriggerChecksPayload/app_id`.
                        public var appId: Swift.Int
                        /// Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.
                        ///
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json/AutoTriggerChecksPayload/setting`.
                        public var setting: Swift.Bool
                        /// Creates a new `AutoTriggerChecksPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - appId: The `id` of the GitHub App.
                        ///   - setting: Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.
                        public init(
                            appId: Swift.Int,
                            setting: Swift.Bool
                        ) {
                            self.appId = appId
                            self.setting = setting
                        }
                        public enum CodingKeys: String, CodingKey {
                            case appId = "app_id"
                            case setting
                        }
                    }
                    /// Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json/auto_trigger_checks`.
                    public typealias AutoTriggerChecksPayload = [Operations.ChecksSetSuitesPreferences.Input.Body.JsonPayload.AutoTriggerChecksPayloadPayload]
                    /// Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/json/auto_trigger_checks`.
                    public var autoTriggerChecks: Operations.ChecksSetSuitesPreferences.Input.Body.JsonPayload.AutoTriggerChecksPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - autoTriggerChecks: Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default.
                    public init(autoTriggerChecks: Operations.ChecksSetSuitesPreferences.Input.Body.JsonPayload.AutoTriggerChecksPayload? = nil) {
                        self.autoTriggerChecks = autoTriggerChecks
                    }
                    public enum CodingKeys: String, CodingKey {
                        case autoTriggerChecks = "auto_trigger_checks"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/requestBody/content/application\/json`.
                case json(Operations.ChecksSetSuitesPreferences.Input.Body.JsonPayload)
            }
            public var body: Operations.ChecksSetSuitesPreferences.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ChecksSetSuitesPreferences.Input.Path,
                headers: Operations.ChecksSetSuitesPreferences.Input.Headers = .init(),
                body: Operations.ChecksSetSuitesPreferences.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/preferences/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CheckSuitePreference)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckSuitePreference {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksSetSuitesPreferences.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksSetSuitesPreferences.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/preferences/patch(checks/set-suites-preferences)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksSetSuitesPreferences.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksSetSuitesPreferences.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a check suite
    ///
    /// Gets a single check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/get(checks/get-suite)`.
    public enum ChecksGetSuite {
        public static let id: Swift.String = "checks/get-suite"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check suite.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/path/check_suite_id`.
                public var checkSuiteId: Components.Parameters.CheckSuiteId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkSuiteId: The unique identifier of the check suite.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkSuiteId: Components.Parameters.CheckSuiteId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkSuiteId = checkSuiteId
                }
            }
            public var path: Operations.ChecksGetSuite.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksGetSuite.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksGetSuite.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksGetSuite.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ChecksGetSuite.Input.Path,
                headers: Operations.ChecksGetSuite.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CheckSuite)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CheckSuite {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksGetSuite.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksGetSuite.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/get(checks/get-suite)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksGetSuite.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksGetSuite.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List check runs in a check suite
    ///
    /// Lists check runs for a check suite using its `id`.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/get(checks/list-for-suite)`.
    public enum ChecksListForSuite {
        public static let id: Swift.String = "checks/list-for-suite"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check suite.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/path/check_suite_id`.
                public var checkSuiteId: Components.Parameters.CheckSuiteId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkSuiteId: The unique identifier of the check suite.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkSuiteId: Components.Parameters.CheckSuiteId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkSuiteId = checkSuiteId
                }
            }
            public var path: Operations.ChecksListForSuite.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Returns check runs with the specified `name`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/check_name`.
                public var checkName: Components.Parameters.CheckName?
                /// - Remark: Generated from `#/components/parameters/status`.
                @frozen public enum Status: String, Codable, Hashable, Sendable, CaseIterable {
                    case queued = "queued"
                    case inProgress = "in_progress"
                    case completed = "completed"
                }
                /// Returns check runs with the specified `status`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/status`.
                public var status: Components.Parameters.Status?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/filter`.
                @frozen public enum FilterPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case latest = "latest"
                    case all = "all"
                }
                /// Filters check runs by their `completed_at` timestamp. `latest` returns the most recent check runs.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/filter`.
                public var filter: Operations.ChecksListForSuite.Input.Query.FilterPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - checkName: Returns check runs with the specified `name`.
                ///   - status: Returns check runs with the specified `status`.
                ///   - filter: Filters check runs by their `completed_at` timestamp. `latest` returns the most recent check runs.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    checkName: Components.Parameters.CheckName? = nil,
                    status: Components.Parameters.Status? = nil,
                    filter: Operations.ChecksListForSuite.Input.Query.FilterPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.checkName = checkName
                    self.status = status
                    self.filter = filter
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ChecksListForSuite.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListForSuite.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListForSuite.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksListForSuite.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ChecksListForSuite.Input.Path,
                query: Operations.ChecksListForSuite.Input.Query = .init(),
                headers: Operations.ChecksListForSuite.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ChecksListForSuite.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/content/json/check_runs`.
                        public var checkRuns: [Components.Schemas.CheckRun]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - checkRuns:
                        public init(
                            totalCount: Swift.Int,
                            checkRuns: [Components.Schemas.CheckRun]
                        ) {
                            self.totalCount = totalCount
                            self.checkRuns = checkRuns
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case checkRuns = "check_runs"
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/GET/responses/200/content/application\/json`.
                    case json(Operations.ChecksListForSuite.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ChecksListForSuite.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksListForSuite.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ChecksListForSuite.Output.Ok.Headers = .init(),
                    body: Operations.ChecksListForSuite.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs/get(checks/list-for-suite)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksListForSuite.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksListForSuite.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Rerequest a check suite
    ///
    /// Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/post(checks/rerequest-suite)`.
    public enum ChecksRerequestSuite {
        public static let id: Swift.String = "checks/rerequest-suite"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The unique identifier of the check suite.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/path/check_suite_id`.
                public var checkSuiteId: Components.Parameters.CheckSuiteId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - checkSuiteId: The unique identifier of the check suite.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    checkSuiteId: Components.Parameters.CheckSuiteId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.checkSuiteId = checkSuiteId
                }
            }
            public var path: Operations.ChecksRerequestSuite.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksRerequestSuite.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksRerequestSuite.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksRerequestSuite.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ChecksRerequestSuite.Input.Path,
                headers: Operations.ChecksRerequestSuite.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksRerequestSuite.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ChecksRerequestSuite.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest/post(checks/rerequest-suite)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.ChecksRerequestSuite.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.ChecksRerequestSuite.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List check runs for a Git reference
    ///
    /// Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
    ///
    /// If there are more than 1000 check suites on a single git reference, this endpoint will limit check runs to the 1000 most recent check suites. To iterate over all possible check runs, use the [List check suites for a Git reference](https://docs.github.com/rest/reference/checks#list-check-suites-for-a-git-reference) endpoint and provide the `check_suite_id` parameter to the [List check runs in a check suite](https://docs.github.com/rest/reference/checks#list-check-runs-in-a-check-suite) endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-runs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-runs/get(checks/list-for-ref)`.
    public enum ChecksListForRef {
        public static let id: Swift.String = "checks/list-for-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The commit reference. Can be a commit SHA, branch name (`heads/BRANCH_NAME`), or tag name (`tags/TAG_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/path/ref`.
                public var ref: Components.Parameters.CommitRef
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The commit reference. Can be a commit SHA, branch name (`heads/BRANCH_NAME`), or tag name (`tags/TAG_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.CommitRef
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.ChecksListForRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Returns check runs with the specified `name`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/check_name`.
                public var checkName: Components.Parameters.CheckName?
                /// - Remark: Generated from `#/components/parameters/status`.
                @frozen public enum Status: String, Codable, Hashable, Sendable, CaseIterable {
                    case queued = "queued"
                    case inProgress = "in_progress"
                    case completed = "completed"
                }
                /// Returns check runs with the specified `status`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/status`.
                public var status: Components.Parameters.Status?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/filter`.
                @frozen public enum FilterPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case latest = "latest"
                    case all = "all"
                }
                /// Filters check runs by their `completed_at` timestamp. `latest` returns the most recent check runs.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/filter`.
                public var filter: Operations.ChecksListForRef.Input.Query.FilterPayload?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/query/app_id`.
                public var appId: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - checkName: Returns check runs with the specified `name`.
                ///   - status: Returns check runs with the specified `status`.
                ///   - filter: Filters check runs by their `completed_at` timestamp. `latest` returns the most recent check runs.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - appId:
                public init(
                    checkName: Components.Parameters.CheckName? = nil,
                    status: Components.Parameters.Status? = nil,
                    filter: Operations.ChecksListForRef.Input.Query.FilterPayload? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    appId: Swift.Int? = nil
                ) {
                    self.checkName = checkName
                    self.status = status
                    self.filter = filter
                    self.perPage = perPage
                    self.page = page
                    self.appId = appId
                }
            }
            public var query: Operations.ChecksListForRef.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListForRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListForRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksListForRef.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ChecksListForRef.Input.Path,
                query: Operations.ChecksListForRef.Input.Query = .init(),
                headers: Operations.ChecksListForRef.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ChecksListForRef.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/content/json/check_runs`.
                        public var checkRuns: [Components.Schemas.CheckRun]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - checkRuns:
                        public init(
                            totalCount: Swift.Int,
                            checkRuns: [Components.Schemas.CheckRun]
                        ) {
                            self.totalCount = totalCount
                            self.checkRuns = checkRuns
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case checkRuns = "check_runs"
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-runs/GET/responses/200/content/application\/json`.
                    case json(Operations.ChecksListForRef.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ChecksListForRef.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksListForRef.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ChecksListForRef.Output.Ok.Headers = .init(),
                    body: Operations.ChecksListForRef.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-runs/get(checks/list-for-ref)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksListForRef.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksListForRef.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List check suites for a Git reference
    ///
    /// Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name.
    ///
    /// > [!NOTE]
    /// > The endpoints to manage checks only look for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint on a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/check-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-suites/get(checks/list-suites-for-ref)`.
    public enum ChecksListSuitesForRef {
        public static let id: Swift.String = "checks/list-suites-for-ref"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The commit reference. Can be a commit SHA, branch name (`heads/BRANCH_NAME`), or tag name (`tags/TAG_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/path/ref`.
                public var ref: Components.Parameters.CommitRef
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ref: The commit reference. Can be a commit SHA, branch name (`heads/BRANCH_NAME`), or tag name (`tags/TAG_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ref: Components.Parameters.CommitRef
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ref = ref
                }
            }
            public var path: Operations.ChecksListSuitesForRef.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Filters check suites by GitHub App `id`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/query/app_id`.
                public var appId: Swift.Int?
                /// Returns check runs with the specified `name`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/query/check_name`.
                public var checkName: Components.Parameters.CheckName?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - appId: Filters check suites by GitHub App `id`.
                ///   - checkName: Returns check runs with the specified `name`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    appId: Swift.Int? = nil,
                    checkName: Components.Parameters.CheckName? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.appId = appId
                    self.checkName = checkName
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ChecksListSuitesForRef.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListSuitesForRef.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ChecksListSuitesForRef.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ChecksListSuitesForRef.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ChecksListSuitesForRef.Input.Path,
                query: Operations.ChecksListSuitesForRef.Input.Query = .init(),
                headers: Operations.ChecksListSuitesForRef.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ChecksListSuitesForRef.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/content/json/check_suites`.
                        public var checkSuites: [Components.Schemas.CheckSuite]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - checkSuites:
                        public init(
                            totalCount: Swift.Int,
                            checkSuites: [Components.Schemas.CheckSuite]
                        ) {
                            self.totalCount = totalCount
                            self.checkSuites = checkSuites
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case checkSuites = "check_suites"
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/commits/{ref}/check-suites/GET/responses/200/content/application\/json`.
                    case json(Operations.ChecksListSuitesForRef.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ChecksListSuitesForRef.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ChecksListSuitesForRef.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ChecksListSuitesForRef.Output.Ok.Headers = .init(),
                    body: Operations.ChecksListSuitesForRef.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/check-suites/get(checks/list-suites-for-ref)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ChecksListSuitesForRef.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ChecksListSuitesForRef.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
