// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List campaigns for an organization
    ///
    /// Lists campaigns in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)`.
    func campaignsListOrgCampaigns(_ input: Operations.CampaignsListOrgCampaigns.Input) async throws -> Operations.CampaignsListOrgCampaigns.Output
    /// Create a campaign for an organization
    ///
    /// Create a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// Fine-grained tokens must have the "Code scanning alerts" repository permissions (read) on all repositories included
    /// in the campaign.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)`.
    func campaignsCreateCampaign(_ input: Operations.CampaignsCreateCampaign.Input) async throws -> Operations.CampaignsCreateCampaign.Output
    /// Get a campaign for an organization
    ///
    /// Gets a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)`.
    func campaignsGetCampaignSummary(_ input: Operations.CampaignsGetCampaignSummary.Input) async throws -> Operations.CampaignsGetCampaignSummary.Output
    /// Update a campaign
    ///
    /// Updates a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)`.
    func campaignsUpdateCampaign(_ input: Operations.CampaignsUpdateCampaign.Input) async throws -> Operations.CampaignsUpdateCampaign.Output
    /// Delete a campaign for an organization
    ///
    /// Deletes a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)`.
    func campaignsDeleteCampaign(_ input: Operations.CampaignsDeleteCampaign.Input) async throws -> Operations.CampaignsDeleteCampaign.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List campaigns for an organization
    ///
    /// Lists campaigns in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)`.
    public func campaignsListOrgCampaigns(
        path: Operations.CampaignsListOrgCampaigns.Input.Path,
        query: Operations.CampaignsListOrgCampaigns.Input.Query = .init(),
        headers: Operations.CampaignsListOrgCampaigns.Input.Headers = .init()
    ) async throws -> Operations.CampaignsListOrgCampaigns.Output {
        try await campaignsListOrgCampaigns(Operations.CampaignsListOrgCampaigns.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a campaign for an organization
    ///
    /// Create a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// Fine-grained tokens must have the "Code scanning alerts" repository permissions (read) on all repositories included
    /// in the campaign.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)`.
    public func campaignsCreateCampaign(
        path: Operations.CampaignsCreateCampaign.Input.Path,
        headers: Operations.CampaignsCreateCampaign.Input.Headers = .init(),
        body: Operations.CampaignsCreateCampaign.Input.Body
    ) async throws -> Operations.CampaignsCreateCampaign.Output {
        try await campaignsCreateCampaign(Operations.CampaignsCreateCampaign.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a campaign for an organization
    ///
    /// Gets a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)`.
    public func campaignsGetCampaignSummary(
        path: Operations.CampaignsGetCampaignSummary.Input.Path,
        headers: Operations.CampaignsGetCampaignSummary.Input.Headers = .init()
    ) async throws -> Operations.CampaignsGetCampaignSummary.Output {
        try await campaignsGetCampaignSummary(Operations.CampaignsGetCampaignSummary.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a campaign
    ///
    /// Updates a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)`.
    public func campaignsUpdateCampaign(
        path: Operations.CampaignsUpdateCampaign.Input.Path,
        headers: Operations.CampaignsUpdateCampaign.Input.Headers = .init(),
        body: Operations.CampaignsUpdateCampaign.Input.Body
    ) async throws -> Operations.CampaignsUpdateCampaign.Output {
        try await campaignsUpdateCampaign(Operations.CampaignsUpdateCampaign.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a campaign for an organization
    ///
    /// Deletes a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)`.
    public func campaignsDeleteCampaign(
        path: Operations.CampaignsDeleteCampaign.Input.Path,
        headers: Operations.CampaignsDeleteCampaign.Input.Headers = .init()
    ) async throws -> Operations.CampaignsDeleteCampaign.Output {
        try await campaignsDeleteCampaign(Operations.CampaignsDeleteCampaign.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Indicates whether a campaign is open or closed
        ///
        /// - Remark: Generated from `#/components/schemas/campaign-state`.
        @frozen public enum CampaignState: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case closed = "closed"
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/type`.
            public var _type: Components.Schemas.NullableTeamSimple._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil,
                _type: Components.Schemas.NullableTeamSimple._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case enterprise = "enterprise"
                case organization = "organization"
            }
            /// The ownership type of the team
            ///
            /// - Remark: Generated from `#/components/schemas/team/type`.
            public var _type: Components.Schemas.Team._TypePayload
            /// Unique identifier of the organization to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/organization_id`.
            public var organizationId: Swift.Int?
            /// Unique identifier of the enterprise to which this team belongs
            ///
            /// - Remark: Generated from `#/components/schemas/team/enterprise_id`.
            public var enterpriseId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - _type: The ownership type of the team
            ///   - organizationId: Unique identifier of the organization to which this team belongs
            ///   - enterpriseId: Unique identifier of the enterprise to which this team belongs
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                _type: Components.Schemas.Team._TypePayload,
                organizationId: Swift.Int? = nil,
                enterpriseId: Swift.Int? = nil,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self._type = _type
                self.organizationId = organizationId
                self.enterpriseId = enterpriseId
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case _type = "type"
                case organizationId = "organization_id"
                case enterpriseId = "enterprise_id"
                case parent
            }
        }
        /// The campaign metadata and alert stats.
        ///
        /// - Remark: Generated from `#/components/schemas/campaign-summary`.
        public struct CampaignSummary: Codable, Hashable, Sendable {
            /// The number of the newly created campaign
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/number`.
            public var number: Swift.Int
            /// The date and time the campaign was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time the campaign was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/updated_at`.
            public var updatedAt: Foundation.Date
            /// The campaign name
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/name`.
            public var name: Swift.String?
            /// The campaign description
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/description`.
            public var description: Swift.String
            /// The campaign managers
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/managers`.
            public var managers: [Components.Schemas.SimpleUser]
            /// The campaign team managers
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/team_managers`.
            public var teamManagers: [Components.Schemas.Team]?
            /// The date and time the campaign was published, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/published_at`.
            public var publishedAt: Foundation.Date?
            /// The date and time the campaign has ended, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/ends_at`.
            public var endsAt: Foundation.Date
            /// The date and time the campaign was closed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the campaign is still open.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/campaign-summary/state`.
            public var state: Components.Schemas.CampaignState
            /// The contact link of the campaign.
            ///
            /// - Remark: Generated from `#/components/schemas/campaign-summary/contact_link`.
            public var contactLink: Swift.String?
            /// - Remark: Generated from `#/components/schemas/campaign-summary/alert_stats`.
            public struct AlertStatsPayload: Codable, Hashable, Sendable {
                /// The number of open alerts
                ///
                /// - Remark: Generated from `#/components/schemas/campaign-summary/alert_stats/open_count`.
                public var openCount: Swift.Int
                /// The number of closed alerts
                ///
                /// - Remark: Generated from `#/components/schemas/campaign-summary/alert_stats/closed_count`.
                public var closedCount: Swift.Int
                /// The number of in-progress alerts
                ///
                /// - Remark: Generated from `#/components/schemas/campaign-summary/alert_stats/in_progress_count`.
                public var inProgressCount: Swift.Int
                /// Creates a new `AlertStatsPayload`.
                ///
                /// - Parameters:
                ///   - openCount: The number of open alerts
                ///   - closedCount: The number of closed alerts
                ///   - inProgressCount: The number of in-progress alerts
                public init(
                    openCount: Swift.Int,
                    closedCount: Swift.Int,
                    inProgressCount: Swift.Int
                ) {
                    self.openCount = openCount
                    self.closedCount = closedCount
                    self.inProgressCount = inProgressCount
                }
                public enum CodingKeys: String, CodingKey {
                    case openCount = "open_count"
                    case closedCount = "closed_count"
                    case inProgressCount = "in_progress_count"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.openCount = try container.decode(
                        Swift.Int.self,
                        forKey: .openCount
                    )
                    self.closedCount = try container.decode(
                        Swift.Int.self,
                        forKey: .closedCount
                    )
                    self.inProgressCount = try container.decode(
                        Swift.Int.self,
                        forKey: .inProgressCount
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "open_count",
                        "closed_count",
                        "in_progress_count"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/campaign-summary/alert_stats`.
            public var alertStats: Components.Schemas.CampaignSummary.AlertStatsPayload?
            /// Creates a new `CampaignSummary`.
            ///
            /// - Parameters:
            ///   - number: The number of the newly created campaign
            ///   - createdAt: The date and time the campaign was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time the campaign was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - name: The campaign name
            ///   - description: The campaign description
            ///   - managers: The campaign managers
            ///   - teamManagers: The campaign team managers
            ///   - publishedAt: The date and time the campaign was published, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - endsAt: The date and time the campaign has ended, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - closedAt: The date and time the campaign was closed, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ. Will be null if the campaign is still open.
            ///   - state:
            ///   - contactLink: The contact link of the campaign.
            ///   - alertStats:
            public init(
                number: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                name: Swift.String? = nil,
                description: Swift.String,
                managers: [Components.Schemas.SimpleUser],
                teamManagers: [Components.Schemas.Team]? = nil,
                publishedAt: Foundation.Date? = nil,
                endsAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                state: Components.Schemas.CampaignState,
                contactLink: Swift.String? = nil,
                alertStats: Components.Schemas.CampaignSummary.AlertStatsPayload? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.name = name
                self.description = description
                self.managers = managers
                self.teamManagers = teamManagers
                self.publishedAt = publishedAt
                self.endsAt = endsAt
                self.closedAt = closedAt
                self.state = state
                self.contactLink = contactLink
                self.alertStats = alertStats
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case name
                case description
                case managers
                case teamManagers = "team_managers"
                case publishedAt = "published_at"
                case endsAt = "ends_at"
                case closedAt = "closed_at"
                case state
                case contactLink = "contact_link"
                case alertStats = "alert_stats"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List campaigns for an organization
    ///
    /// Lists campaigns in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)`.
    public enum CampaignsListOrgCampaigns {
        public static let id: Swift.String = "campaigns/list-org-campaigns"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CampaignsListOrgCampaigns.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// If specified, only campaigns with this state will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/state`.
                public var state: Components.Schemas.CampaignState?
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case endsAt = "ends_at"
                    case published = "published"
                }
                /// The property by which to sort the results.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/query/sort`.
                public var sort: Operations.CampaignsListOrgCampaigns.Input.Query.SortPayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - state: If specified, only campaigns with this state will be returned.
                ///   - sort: The property by which to sort the results.
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    state: Components.Schemas.CampaignState? = nil,
                    sort: Operations.CampaignsListOrgCampaigns.Input.Query.SortPayload? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                    self.direction = direction
                    self.state = state
                    self.sort = sort
                }
            }
            public var query: Operations.CampaignsListOrgCampaigns.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsListOrgCampaigns.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsListOrgCampaigns.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CampaignsListOrgCampaigns.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CampaignsListOrgCampaigns.Input.Path,
                query: Operations.CampaignsListOrgCampaigns.Input.Query = .init(),
                headers: Operations.CampaignsListOrgCampaigns.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CampaignsListOrgCampaigns.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.CampaignSummary])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.CampaignSummary] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsListOrgCampaigns.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CampaignsListOrgCampaigns.Output.Ok.Headers = .init(),
                    body: Operations.CampaignsListOrgCampaigns.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CampaignsListOrgCampaigns.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CampaignsListOrgCampaigns.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/get(campaigns/list-org-campaigns)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a campaign for an organization
    ///
    /// Create a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// Fine-grained tokens must have the "Code scanning alerts" repository permissions (read) on all repositories included
    /// in the campaign.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/campaigns`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)`.
    public enum CampaignsCreateCampaign {
        public static let id: Swift.String = "campaigns/create-campaign"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CampaignsCreateCampaign.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsCreateCampaign.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsCreateCampaign.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CampaignsCreateCampaign.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/name`.
                    public var name: Swift.String
                    /// A description for the campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/description`.
                    public var description: Swift.String
                    /// The logins of the users to set as the campaign managers. At this time, only a single manager can be supplied.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/managers`.
                    public var managers: [Swift.String]?
                    /// The slugs of the teams to set as the campaign managers.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/team_managers`.
                    public var teamManagers: [Swift.String]?
                    /// The end date and time of the campaign. The date must be in the future.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/ends_at`.
                    public var endsAt: Foundation.Date
                    /// The contact link of the campaign. Must be a URI.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/contact_link`.
                    public var contactLink: Swift.String?
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/CodeScanningAlertsPayload`.
                    public struct CodeScanningAlertsPayloadPayload: Codable, Hashable, Sendable {
                        /// The repository id
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/CodeScanningAlertsPayload/repository_id`.
                        public var repositoryId: Swift.Int
                        /// The alert numbers
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/CodeScanningAlertsPayload/alert_numbers`.
                        public var alertNumbers: [Swift.Int]
                        /// Creates a new `CodeScanningAlertsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - repositoryId: The repository id
                        ///   - alertNumbers: The alert numbers
                        public init(
                            repositoryId: Swift.Int,
                            alertNumbers: [Swift.Int]
                        ) {
                            self.repositoryId = repositoryId
                            self.alertNumbers = alertNumbers
                        }
                        public enum CodingKeys: String, CodingKey {
                            case repositoryId = "repository_id"
                            case alertNumbers = "alert_numbers"
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            self.repositoryId = try container.decode(
                                Swift.Int.self,
                                forKey: .repositoryId
                            )
                            self.alertNumbers = try container.decode(
                                [Swift.Int].self,
                                forKey: .alertNumbers
                            )
                            try decoder.ensureNoAdditionalProperties(knownKeys: [
                                "repository_id",
                                "alert_numbers"
                            ])
                        }
                    }
                    /// The code scanning alerts to include in this campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/code_scanning_alerts`.
                    public typealias CodeScanningAlertsPayload = [Operations.CampaignsCreateCampaign.Input.Body.JsonPayload.CodeScanningAlertsPayloadPayload]
                    /// The code scanning alerts to include in this campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/code_scanning_alerts`.
                    public var codeScanningAlerts: Operations.CampaignsCreateCampaign.Input.Body.JsonPayload.CodeScanningAlertsPayload
                    /// If true, will automatically generate issues for the campaign. The default is false.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/json/generate_issues`.
                    public var generateIssues: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the campaign
                    ///   - description: A description for the campaign
                    ///   - managers: The logins of the users to set as the campaign managers. At this time, only a single manager can be supplied.
                    ///   - teamManagers: The slugs of the teams to set as the campaign managers.
                    ///   - endsAt: The end date and time of the campaign. The date must be in the future.
                    ///   - contactLink: The contact link of the campaign. Must be a URI.
                    ///   - codeScanningAlerts: The code scanning alerts to include in this campaign
                    ///   - generateIssues: If true, will automatically generate issues for the campaign. The default is false.
                    public init(
                        name: Swift.String,
                        description: Swift.String,
                        managers: [Swift.String]? = nil,
                        teamManagers: [Swift.String]? = nil,
                        endsAt: Foundation.Date,
                        contactLink: Swift.String? = nil,
                        codeScanningAlerts: Operations.CampaignsCreateCampaign.Input.Body.JsonPayload.CodeScanningAlertsPayload,
                        generateIssues: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.managers = managers
                        self.teamManagers = teamManagers
                        self.endsAt = endsAt
                        self.contactLink = contactLink
                        self.codeScanningAlerts = codeScanningAlerts
                        self.generateIssues = generateIssues
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case managers
                        case teamManagers = "team_managers"
                        case endsAt = "ends_at"
                        case contactLink = "contact_link"
                        case codeScanningAlerts = "code_scanning_alerts"
                        case generateIssues = "generate_issues"
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decode(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decode(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.managers = try container.decodeIfPresent(
                            [Swift.String].self,
                            forKey: .managers
                        )
                        self.teamManagers = try container.decodeIfPresent(
                            [Swift.String].self,
                            forKey: .teamManagers
                        )
                        self.endsAt = try container.decode(
                            Foundation.Date.self,
                            forKey: .endsAt
                        )
                        self.contactLink = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .contactLink
                        )
                        self.codeScanningAlerts = try container.decode(
                            Operations.CampaignsCreateCampaign.Input.Body.JsonPayload.CodeScanningAlertsPayload.self,
                            forKey: .codeScanningAlerts
                        )
                        self.generateIssues = try container.decodeIfPresent(
                            Swift.Bool.self,
                            forKey: .generateIssues
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "managers",
                            "team_managers",
                            "ends_at",
                            "contact_link",
                            "code_scanning_alerts",
                            "generate_issues"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/requestBody/content/application\/json`.
                case json(Operations.CampaignsCreateCampaign.Input.Body.JsonPayload)
            }
            public var body: Operations.CampaignsCreateCampaign.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CampaignsCreateCampaign.Input.Path,
                headers: Operations.CampaignsCreateCampaign.Input.Headers = .init(),
                body: Operations.CampaignsCreateCampaign.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CampaignSummary)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CampaignSummary {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsCreateCampaign.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsCreateCampaign.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CampaignsCreateCampaign.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CampaignsCreateCampaign.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/400/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/400/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsCreateCampaign.Output.BadRequest.Body
                /// Creates a new `BadRequest`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsCreateCampaign.Output.BadRequest.Body) {
                    self.body = body
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CampaignsCreateCampaign.Output.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CampaignsCreateCampaign.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/POST/responses/422/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsCreateCampaign.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsCreateCampaign.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CampaignsCreateCampaign.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CampaignsCreateCampaign.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            public struct TooManyRequests: Sendable, Hashable {
                /// Creates a new `TooManyRequests`.
                public init() {}
            }
            /// Too Many Requests
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/429`.
            ///
            /// HTTP response code: `429 tooManyRequests`.
            case tooManyRequests(Operations.CampaignsCreateCampaign.Output.TooManyRequests)
            /// Too Many Requests
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/429`.
            ///
            /// HTTP response code: `429 tooManyRequests`.
            public static var tooManyRequests: Self {
                .tooManyRequests(.init())
            }
            /// The associated value of the enum case if `self` is `.tooManyRequests`.
            ///
            /// - Throws: An error if `self` is not `.tooManyRequests`.
            /// - SeeAlso: `.tooManyRequests`.
            public var tooManyRequests: Operations.CampaignsCreateCampaign.Output.TooManyRequests {
                get throws {
                    switch self {
                    case let .tooManyRequests(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "tooManyRequests",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/post(campaigns/create-campaign)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a campaign for an organization
    ///
    /// Gets a campaign for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)`.
    public enum CampaignsGetCampaignSummary {
        public static let id: Swift.String = "campaigns/get-campaign-summary"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The campaign number.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/path/campaign_number`.
                public var campaignNumber: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - campaignNumber: The campaign number.
                public init(
                    org: Components.Parameters.Org,
                    campaignNumber: Swift.Int
                ) {
                    self.org = org
                    self.campaignNumber = campaignNumber
                }
            }
            public var path: Operations.CampaignsGetCampaignSummary.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsGetCampaignSummary.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsGetCampaignSummary.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CampaignsGetCampaignSummary.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CampaignsGetCampaignSummary.Input.Path,
                headers: Operations.CampaignsGetCampaignSummary.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CampaignSummary)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CampaignSummary {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsGetCampaignSummary.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsGetCampaignSummary.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CampaignsGetCampaignSummary.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CampaignsGetCampaignSummary.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/GET/responses/422/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsGetCampaignSummary.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsGetCampaignSummary.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CampaignsGetCampaignSummary.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CampaignsGetCampaignSummary.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/get(campaigns/get-campaign-summary)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a campaign
    ///
    /// Updates a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)`.
    public enum CampaignsUpdateCampaign {
        public static let id: Swift.String = "campaigns/update-campaign"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// The campaign number.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/path/campaign_number`.
                public var campaignNumber: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - campaignNumber: The campaign number.
                public init(
                    org: Components.Parameters.Org,
                    campaignNumber: Swift.Int
                ) {
                    self.org = org
                    self.campaignNumber = campaignNumber
                }
            }
            public var path: Operations.CampaignsUpdateCampaign.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsUpdateCampaign.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsUpdateCampaign.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CampaignsUpdateCampaign.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The name of the campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// A description for the campaign
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/description`.
                    public var description: Swift.String?
                    /// The logins of the users to set as the campaign managers. At this time, only a single manager can be supplied.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/managers`.
                    public var managers: [Swift.String]?
                    /// The slugs of the teams to set as the campaign managers.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/team_managers`.
                    public var teamManagers: [Swift.String]?
                    /// The end date and time of the campaign, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/ends_at`.
                    public var endsAt: Foundation.Date?
                    /// The contact link of the campaign. Must be a URI.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/contact_link`.
                    public var contactLink: Swift.String?
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/json/state`.
                    public var state: Components.Schemas.CampaignState?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The name of the campaign
                    ///   - description: A description for the campaign
                    ///   - managers: The logins of the users to set as the campaign managers. At this time, only a single manager can be supplied.
                    ///   - teamManagers: The slugs of the teams to set as the campaign managers.
                    ///   - endsAt: The end date and time of the campaign, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
                    ///   - contactLink: The contact link of the campaign. Must be a URI.
                    ///   - state:
                    public init(
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        managers: [Swift.String]? = nil,
                        teamManagers: [Swift.String]? = nil,
                        endsAt: Foundation.Date? = nil,
                        contactLink: Swift.String? = nil,
                        state: Components.Schemas.CampaignState? = nil
                    ) {
                        self.name = name
                        self.description = description
                        self.managers = managers
                        self.teamManagers = teamManagers
                        self.endsAt = endsAt
                        self.contactLink = contactLink
                        self.state = state
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case description
                        case managers
                        case teamManagers = "team_managers"
                        case endsAt = "ends_at"
                        case contactLink = "contact_link"
                        case state
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.name = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .name
                        )
                        self.description = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .description
                        )
                        self.managers = try container.decodeIfPresent(
                            [Swift.String].self,
                            forKey: .managers
                        )
                        self.teamManagers = try container.decodeIfPresent(
                            [Swift.String].self,
                            forKey: .teamManagers
                        )
                        self.endsAt = try container.decodeIfPresent(
                            Foundation.Date.self,
                            forKey: .endsAt
                        )
                        self.contactLink = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .contactLink
                        )
                        self.state = try container.decodeIfPresent(
                            Components.Schemas.CampaignState.self,
                            forKey: .state
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "name",
                            "description",
                            "managers",
                            "team_managers",
                            "ends_at",
                            "contact_link",
                            "state"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.CampaignsUpdateCampaign.Input.Body.JsonPayload)
            }
            public var body: Operations.CampaignsUpdateCampaign.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CampaignsUpdateCampaign.Input.Path,
                headers: Operations.CampaignsUpdateCampaign.Input.Headers = .init(),
                body: Operations.CampaignsUpdateCampaign.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.CampaignSummary)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CampaignSummary {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsUpdateCampaign.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsUpdateCampaign.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CampaignsUpdateCampaign.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CampaignsUpdateCampaign.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/400/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/400/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsUpdateCampaign.Output.BadRequest.Body
                /// Creates a new `BadRequest`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsUpdateCampaign.Output.BadRequest.Body) {
                    self.body = body
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CampaignsUpdateCampaign.Output.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CampaignsUpdateCampaign.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/PATCH/responses/422/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CampaignsUpdateCampaign.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CampaignsUpdateCampaign.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Unprocessable Entity
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.CampaignsUpdateCampaign.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.CampaignsUpdateCampaign.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/patch(campaigns/update-campaign)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a campaign for an organization
    ///
    /// Deletes a campaign in an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/campaigns/{campaign_number}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)`.
    public enum CampaignsDeleteCampaign {
        public static let id: Swift.String = "campaigns/delete-campaign"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The campaign number.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/DELETE/path/campaign_number`.
                public var campaignNumber: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - campaignNumber: The campaign number.
                public init(
                    org: Components.Parameters.Org,
                    campaignNumber: Swift.Int
                ) {
                    self.org = org
                    self.campaignNumber = campaignNumber
                }
            }
            public var path: Operations.CampaignsDeleteCampaign.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/campaigns/{campaign_number}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsDeleteCampaign.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CampaignsDeleteCampaign.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CampaignsDeleteCampaign.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CampaignsDeleteCampaign.Input.Path,
                headers: Operations.CampaignsDeleteCampaign.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Deletion successful
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CampaignsDeleteCampaign.Output.NoContent)
            /// Deletion successful
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CampaignsDeleteCampaign.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/campaigns/{campaign_number}/delete(campaigns/delete-campaign)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
