// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List public events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /events`.
    /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)`.
    func activityListPublicEvents(_ input: Operations.ActivityListPublicEvents.Input) async throws -> Operations.ActivityListPublicEvents.Output
    /// Get feeds
    ///
    /// Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.
    ///
    /// *   **Timeline**: The GitHub global public timeline
    /// *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
    /// *   **Current user public**: The public timeline for the authenticated user
    /// *   **Current user**: The private timeline for the authenticated user
    /// *   **Current user actor**: The private timeline for activity created by the authenticated user
    /// *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
    /// *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
    ///
    /// By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// > [!NOTE]
    /// > Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) since current feed URIs use the older, non revocable auth tokens.
    ///
    /// - Remark: HTTP `GET /feeds`.
    /// - Remark: Generated from `#/paths//feeds/get(activity/get-feeds)`.
    func activityGetFeeds(_ input: Operations.ActivityGetFeeds.Input) async throws -> Operations.ActivityGetFeeds.Output
    /// List public events for a network of repositories
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /networks/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)`.
    func activityListPublicEventsForRepoNetwork(_ input: Operations.ActivityListPublicEventsForRepoNetwork.Input) async throws -> Operations.ActivityListPublicEventsForRepoNetwork.Output
    /// List notifications for the authenticated user
    ///
    /// List all notifications for the current user, sorted by most recently updated.
    ///
    /// - Remark: HTTP `GET /notifications`.
    /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)`.
    func activityListNotificationsForAuthenticatedUser(_ input: Operations.ActivityListNotificationsForAuthenticatedUser.Input) async throws -> Operations.ActivityListNotificationsForAuthenticatedUser.Output
    /// Mark notifications as read
    ///
    /// Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /notifications`.
    /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)`.
    func activityMarkNotificationsAsRead(_ input: Operations.ActivityMarkNotificationsAsRead.Input) async throws -> Operations.ActivityMarkNotificationsAsRead.Output
    /// Get a thread
    ///
    /// Gets information about a notification thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)`.
    func activityGetThread(_ input: Operations.ActivityGetThread.Input) async throws -> Operations.ActivityGetThread.Output
    /// Mark a thread as read
    ///
    /// Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub: https://github.com/notifications.
    ///
    /// - Remark: HTTP `PATCH /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)`.
    func activityMarkThreadAsRead(_ input: Operations.ActivityMarkThreadAsRead.Input) async throws -> Operations.ActivityMarkThreadAsRead.Output
    /// Mark a thread as done
    ///
    /// Marks a thread as "done." Marking a thread as "done" is equivalent to marking a notification in your notification inbox on GitHub as done: https://github.com/notifications.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/delete(activity/mark-thread-as-done)`.
    func activityMarkThreadAsDone(_ input: Operations.ActivityMarkThreadAsDone.Input) async throws -> Operations.ActivityMarkThreadAsDone.Output
    /// Get a thread subscription for the authenticated user
    ///
    /// This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/activity/watching#get-a-repository-subscription).
    ///
    /// Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)`.
    func activityGetThreadSubscriptionForAuthenticatedUser(_ input: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input) async throws -> Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output
    /// Set a thread subscription
    ///
    /// If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
    ///
    /// You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
    ///
    /// Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription) endpoint.
    ///
    /// - Remark: HTTP `PUT /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)`.
    func activitySetThreadSubscription(_ input: Operations.ActivitySetThreadSubscription.Input) async throws -> Operations.ActivitySetThreadSubscription.Output
    /// Delete a thread subscription
    ///
    /// Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)`.
    func activityDeleteThreadSubscription(_ input: Operations.ActivityDeleteThreadSubscription.Input) async throws -> Operations.ActivityDeleteThreadSubscription.Output
    /// List public organization events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/events`.
    /// - Remark: Generated from `#/paths//orgs/{org}/events/get(activity/list-public-org-events)`.
    func activityListPublicOrgEvents(_ input: Operations.ActivityListPublicOrgEvents.Input) async throws -> Operations.ActivityListPublicOrgEvents.Output
    /// List repository events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/events/get(activity/list-repo-events)`.
    func activityListRepoEvents(_ input: Operations.ActivityListRepoEvents.Input) async throws -> Operations.ActivityListRepoEvents.Output
    /// List repository notifications for the authenticated user
    ///
    /// Lists all notifications for the current user in the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/get(activity/list-repo-notifications-for-authenticated-user)`.
    func activityListRepoNotificationsForAuthenticatedUser(_ input: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input) async throws -> Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output
    /// Mark repository notifications as read
    ///
    /// Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)`.
    func activityMarkRepoNotificationsAsRead(_ input: Operations.ActivityMarkRepoNotificationsAsRead.Input) async throws -> Operations.ActivityMarkRepoNotificationsAsRead.Output
    /// List stargazers
    ///
    /// Lists the people that have starred the repository.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stargazers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stargazers/get(activity/list-stargazers-for-repo)`.
    func activityListStargazersForRepo(_ input: Operations.ActivityListStargazersForRepo.Input) async throws -> Operations.ActivityListStargazersForRepo.Output
    /// List watchers
    ///
    /// Lists the people watching the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscribers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscribers/get(activity/list-watchers-for-repo)`.
    func activityListWatchersForRepo(_ input: Operations.ActivityListWatchersForRepo.Input) async throws -> Operations.ActivityListWatchersForRepo.Output
    /// Get a repository subscription
    ///
    /// Gets information about whether the authenticated user is subscribed to the repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)`.
    func activityGetRepoSubscription(_ input: Operations.ActivityGetRepoSubscription.Input) async throws -> Operations.ActivityGetRepoSubscription.Output
    /// Set a repository subscription
    ///
    /// If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/activity/watching#delete-a-repository-subscription) completely.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/put(activity/set-repo-subscription)`.
    func activitySetRepoSubscription(_ input: Operations.ActivitySetRepoSubscription.Input) async throws -> Operations.ActivitySetRepoSubscription.Output
    /// Delete a repository subscription
    ///
    /// This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/activity/watching#set-a-repository-subscription).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/delete(activity/delete-repo-subscription)`.
    func activityDeleteRepoSubscription(_ input: Operations.ActivityDeleteRepoSubscription.Input) async throws -> Operations.ActivityDeleteRepoSubscription.Output
    /// List repositories starred by the authenticated user
    ///
    /// Lists repositories the authenticated user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /user/starred`.
    /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)`.
    func activityListReposStarredByAuthenticatedUser(_ input: Operations.ActivityListReposStarredByAuthenticatedUser.Input) async throws -> Operations.ActivityListReposStarredByAuthenticatedUser.Output
    /// Check if a repository is starred by the authenticated user
    ///
    /// Whether the authenticated user has starred the repository.
    ///
    /// - Remark: HTTP `GET /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)`.
    func activityCheckRepoIsStarredByAuthenticatedUser(_ input: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input) async throws -> Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output
    /// Star a repository for the authenticated user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)`.
    func activityStarRepoForAuthenticatedUser(_ input: Operations.ActivityStarRepoForAuthenticatedUser.Input) async throws -> Operations.ActivityStarRepoForAuthenticatedUser.Output
    /// Unstar a repository for the authenticated user
    ///
    /// Unstar a repository that the authenticated user has previously starred.
    ///
    /// - Remark: HTTP `DELETE /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)`.
    func activityUnstarRepoForAuthenticatedUser(_ input: Operations.ActivityUnstarRepoForAuthenticatedUser.Input) async throws -> Operations.ActivityUnstarRepoForAuthenticatedUser.Output
    /// List repositories watched by the authenticated user
    ///
    /// Lists repositories the authenticated user is watching.
    ///
    /// - Remark: HTTP `GET /user/subscriptions`.
    /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)`.
    func activityListWatchedReposForAuthenticatedUser(_ input: Operations.ActivityListWatchedReposForAuthenticatedUser.Input) async throws -> Operations.ActivityListWatchedReposForAuthenticatedUser.Output
    /// List events for the authenticated user
    ///
    /// If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. _Optional_: use the fine-grained token with following permission set to view private events: "Events" user permissions (read).
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events`.
    /// - Remark: Generated from `#/paths//users/{username}/events/get(activity/list-events-for-authenticated-user)`.
    func activityListEventsForAuthenticatedUser(_ input: Operations.ActivityListEventsForAuthenticatedUser.Input) async throws -> Operations.ActivityListEventsForAuthenticatedUser.Output
    /// List organization events for the authenticated user
    ///
    /// This is the user's organization dashboard. You must be authenticated as the user to view this.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/orgs/{org}`.
    /// - Remark: Generated from `#/paths//users/{username}/events/orgs/{org}/get(activity/list-org-events-for-authenticated-user)`.
    func activityListOrgEventsForAuthenticatedUser(_ input: Operations.ActivityListOrgEventsForAuthenticatedUser.Input) async throws -> Operations.ActivityListOrgEventsForAuthenticatedUser.Output
    /// List public events for a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/events/public/get(activity/list-public-events-for-user)`.
    func activityListPublicEventsForUser(_ input: Operations.ActivityListPublicEventsForUser.Input) async throws -> Operations.ActivityListPublicEventsForUser.Output
    /// List events received by the authenticated user
    ///
    /// These are events that you've received by watching repositories and following users. If you are authenticated as the
    /// given user, you will see private events. Otherwise, you'll only see public events.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/get(activity/list-received-events-for-user)`.
    func activityListReceivedEventsForUser(_ input: Operations.ActivityListReceivedEventsForUser.Input) async throws -> Operations.ActivityListReceivedEventsForUser.Output
    /// List public events received by a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/public/get(activity/list-received-public-events-for-user)`.
    func activityListReceivedPublicEventsForUser(_ input: Operations.ActivityListReceivedPublicEventsForUser.Input) async throws -> Operations.ActivityListReceivedPublicEventsForUser.Output
    /// List repositories starred by a user
    ///
    /// Lists repositories a user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /users/{username}/starred`.
    /// - Remark: Generated from `#/paths//users/{username}/starred/get(activity/list-repos-starred-by-user)`.
    func activityListReposStarredByUser(_ input: Operations.ActivityListReposStarredByUser.Input) async throws -> Operations.ActivityListReposStarredByUser.Output
    /// List repositories watched by a user
    ///
    /// Lists repositories a user is watching.
    ///
    /// - Remark: HTTP `GET /users/{username}/subscriptions`.
    /// - Remark: Generated from `#/paths//users/{username}/subscriptions/get(activity/list-repos-watched-by-user)`.
    func activityListReposWatchedByUser(_ input: Operations.ActivityListReposWatchedByUser.Input) async throws -> Operations.ActivityListReposWatchedByUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List public events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /events`.
    /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)`.
    public func activityListPublicEvents(
        query: Operations.ActivityListPublicEvents.Input.Query = .init(),
        headers: Operations.ActivityListPublicEvents.Input.Headers = .init()
    ) async throws -> Operations.ActivityListPublicEvents.Output {
        try await activityListPublicEvents(Operations.ActivityListPublicEvents.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get feeds
    ///
    /// Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.
    ///
    /// *   **Timeline**: The GitHub global public timeline
    /// *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
    /// *   **Current user public**: The public timeline for the authenticated user
    /// *   **Current user**: The private timeline for the authenticated user
    /// *   **Current user actor**: The private timeline for activity created by the authenticated user
    /// *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
    /// *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
    ///
    /// By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// > [!NOTE]
    /// > Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) since current feed URIs use the older, non revocable auth tokens.
    ///
    /// - Remark: HTTP `GET /feeds`.
    /// - Remark: Generated from `#/paths//feeds/get(activity/get-feeds)`.
    public func activityGetFeeds(headers: Operations.ActivityGetFeeds.Input.Headers = .init()) async throws -> Operations.ActivityGetFeeds.Output {
        try await activityGetFeeds(Operations.ActivityGetFeeds.Input(headers: headers))
    }
    /// List public events for a network of repositories
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /networks/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)`.
    public func activityListPublicEventsForRepoNetwork(
        path: Operations.ActivityListPublicEventsForRepoNetwork.Input.Path,
        query: Operations.ActivityListPublicEventsForRepoNetwork.Input.Query = .init(),
        headers: Operations.ActivityListPublicEventsForRepoNetwork.Input.Headers = .init()
    ) async throws -> Operations.ActivityListPublicEventsForRepoNetwork.Output {
        try await activityListPublicEventsForRepoNetwork(Operations.ActivityListPublicEventsForRepoNetwork.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List notifications for the authenticated user
    ///
    /// List all notifications for the current user, sorted by most recently updated.
    ///
    /// - Remark: HTTP `GET /notifications`.
    /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)`.
    public func activityListNotificationsForAuthenticatedUser(
        query: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListNotificationsForAuthenticatedUser.Output {
        try await activityListNotificationsForAuthenticatedUser(Operations.ActivityListNotificationsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Mark notifications as read
    ///
    /// Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /notifications`.
    /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)`.
    public func activityMarkNotificationsAsRead(
        headers: Operations.ActivityMarkNotificationsAsRead.Input.Headers = .init(),
        body: Operations.ActivityMarkNotificationsAsRead.Input.Body? = nil
    ) async throws -> Operations.ActivityMarkNotificationsAsRead.Output {
        try await activityMarkNotificationsAsRead(Operations.ActivityMarkNotificationsAsRead.Input(
            headers: headers,
            body: body
        ))
    }
    /// Get a thread
    ///
    /// Gets information about a notification thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)`.
    public func activityGetThread(
        path: Operations.ActivityGetThread.Input.Path,
        headers: Operations.ActivityGetThread.Input.Headers = .init()
    ) async throws -> Operations.ActivityGetThread.Output {
        try await activityGetThread(Operations.ActivityGetThread.Input(
            path: path,
            headers: headers
        ))
    }
    /// Mark a thread as read
    ///
    /// Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub: https://github.com/notifications.
    ///
    /// - Remark: HTTP `PATCH /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)`.
    public func activityMarkThreadAsRead(
        path: Operations.ActivityMarkThreadAsRead.Input.Path,
        headers: Operations.ActivityMarkThreadAsRead.Input.Headers = .init()
    ) async throws -> Operations.ActivityMarkThreadAsRead.Output {
        try await activityMarkThreadAsRead(Operations.ActivityMarkThreadAsRead.Input(
            path: path,
            headers: headers
        ))
    }
    /// Mark a thread as done
    ///
    /// Marks a thread as "done." Marking a thread as "done" is equivalent to marking a notification in your notification inbox on GitHub as done: https://github.com/notifications.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/delete(activity/mark-thread-as-done)`.
    public func activityMarkThreadAsDone(path: Operations.ActivityMarkThreadAsDone.Input.Path) async throws -> Operations.ActivityMarkThreadAsDone.Output {
        try await activityMarkThreadAsDone(Operations.ActivityMarkThreadAsDone.Input(path: path))
    }
    /// Get a thread subscription for the authenticated user
    ///
    /// This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/activity/watching#get-a-repository-subscription).
    ///
    /// Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)`.
    public func activityGetThreadSubscriptionForAuthenticatedUser(
        path: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Path,
        headers: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output {
        try await activityGetThreadSubscriptionForAuthenticatedUser(Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set a thread subscription
    ///
    /// If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
    ///
    /// You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
    ///
    /// Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription) endpoint.
    ///
    /// - Remark: HTTP `PUT /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)`.
    public func activitySetThreadSubscription(
        path: Operations.ActivitySetThreadSubscription.Input.Path,
        headers: Operations.ActivitySetThreadSubscription.Input.Headers = .init(),
        body: Operations.ActivitySetThreadSubscription.Input.Body? = nil
    ) async throws -> Operations.ActivitySetThreadSubscription.Output {
        try await activitySetThreadSubscription(Operations.ActivitySetThreadSubscription.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a thread subscription
    ///
    /// Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)`.
    public func activityDeleteThreadSubscription(
        path: Operations.ActivityDeleteThreadSubscription.Input.Path,
        headers: Operations.ActivityDeleteThreadSubscription.Input.Headers = .init()
    ) async throws -> Operations.ActivityDeleteThreadSubscription.Output {
        try await activityDeleteThreadSubscription(Operations.ActivityDeleteThreadSubscription.Input(
            path: path,
            headers: headers
        ))
    }
    /// List public organization events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/events`.
    /// - Remark: Generated from `#/paths//orgs/{org}/events/get(activity/list-public-org-events)`.
    public func activityListPublicOrgEvents(
        path: Operations.ActivityListPublicOrgEvents.Input.Path,
        query: Operations.ActivityListPublicOrgEvents.Input.Query = .init(),
        headers: Operations.ActivityListPublicOrgEvents.Input.Headers = .init()
    ) async throws -> Operations.ActivityListPublicOrgEvents.Output {
        try await activityListPublicOrgEvents(Operations.ActivityListPublicOrgEvents.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/events/get(activity/list-repo-events)`.
    public func activityListRepoEvents(
        path: Operations.ActivityListRepoEvents.Input.Path,
        query: Operations.ActivityListRepoEvents.Input.Query = .init(),
        headers: Operations.ActivityListRepoEvents.Input.Headers = .init()
    ) async throws -> Operations.ActivityListRepoEvents.Output {
        try await activityListRepoEvents(Operations.ActivityListRepoEvents.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository notifications for the authenticated user
    ///
    /// Lists all notifications for the current user in the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/get(activity/list-repo-notifications-for-authenticated-user)`.
    public func activityListRepoNotificationsForAuthenticatedUser(
        path: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Path,
        query: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output {
        try await activityListRepoNotificationsForAuthenticatedUser(Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Mark repository notifications as read
    ///
    /// Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)`.
    public func activityMarkRepoNotificationsAsRead(
        path: Operations.ActivityMarkRepoNotificationsAsRead.Input.Path,
        headers: Operations.ActivityMarkRepoNotificationsAsRead.Input.Headers = .init(),
        body: Operations.ActivityMarkRepoNotificationsAsRead.Input.Body? = nil
    ) async throws -> Operations.ActivityMarkRepoNotificationsAsRead.Output {
        try await activityMarkRepoNotificationsAsRead(Operations.ActivityMarkRepoNotificationsAsRead.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List stargazers
    ///
    /// Lists the people that have starred the repository.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stargazers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stargazers/get(activity/list-stargazers-for-repo)`.
    public func activityListStargazersForRepo(
        path: Operations.ActivityListStargazersForRepo.Input.Path,
        query: Operations.ActivityListStargazersForRepo.Input.Query = .init(),
        headers: Operations.ActivityListStargazersForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActivityListStargazersForRepo.Output {
        try await activityListStargazersForRepo(Operations.ActivityListStargazersForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List watchers
    ///
    /// Lists the people watching the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscribers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscribers/get(activity/list-watchers-for-repo)`.
    public func activityListWatchersForRepo(
        path: Operations.ActivityListWatchersForRepo.Input.Path,
        query: Operations.ActivityListWatchersForRepo.Input.Query = .init(),
        headers: Operations.ActivityListWatchersForRepo.Input.Headers = .init()
    ) async throws -> Operations.ActivityListWatchersForRepo.Output {
        try await activityListWatchersForRepo(Operations.ActivityListWatchersForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository subscription
    ///
    /// Gets information about whether the authenticated user is subscribed to the repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)`.
    public func activityGetRepoSubscription(
        path: Operations.ActivityGetRepoSubscription.Input.Path,
        headers: Operations.ActivityGetRepoSubscription.Input.Headers = .init()
    ) async throws -> Operations.ActivityGetRepoSubscription.Output {
        try await activityGetRepoSubscription(Operations.ActivityGetRepoSubscription.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set a repository subscription
    ///
    /// If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/activity/watching#delete-a-repository-subscription) completely.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/put(activity/set-repo-subscription)`.
    public func activitySetRepoSubscription(
        path: Operations.ActivitySetRepoSubscription.Input.Path,
        headers: Operations.ActivitySetRepoSubscription.Input.Headers = .init(),
        body: Operations.ActivitySetRepoSubscription.Input.Body? = nil
    ) async throws -> Operations.ActivitySetRepoSubscription.Output {
        try await activitySetRepoSubscription(Operations.ActivitySetRepoSubscription.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository subscription
    ///
    /// This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/activity/watching#set-a-repository-subscription).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/delete(activity/delete-repo-subscription)`.
    public func activityDeleteRepoSubscription(path: Operations.ActivityDeleteRepoSubscription.Input.Path) async throws -> Operations.ActivityDeleteRepoSubscription.Output {
        try await activityDeleteRepoSubscription(Operations.ActivityDeleteRepoSubscription.Input(path: path))
    }
    /// List repositories starred by the authenticated user
    ///
    /// Lists repositories the authenticated user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /user/starred`.
    /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)`.
    public func activityListReposStarredByAuthenticatedUser(
        query: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListReposStarredByAuthenticatedUser.Output {
        try await activityListReposStarredByAuthenticatedUser(Operations.ActivityListReposStarredByAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Check if a repository is starred by the authenticated user
    ///
    /// Whether the authenticated user has starred the repository.
    ///
    /// - Remark: HTTP `GET /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)`.
    public func activityCheckRepoIsStarredByAuthenticatedUser(
        path: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Path,
        headers: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output {
        try await activityCheckRepoIsStarredByAuthenticatedUser(Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Star a repository for the authenticated user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)`.
    public func activityStarRepoForAuthenticatedUser(
        path: Operations.ActivityStarRepoForAuthenticatedUser.Input.Path,
        headers: Operations.ActivityStarRepoForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityStarRepoForAuthenticatedUser.Output {
        try await activityStarRepoForAuthenticatedUser(Operations.ActivityStarRepoForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unstar a repository for the authenticated user
    ///
    /// Unstar a repository that the authenticated user has previously starred.
    ///
    /// - Remark: HTTP `DELETE /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)`.
    public func activityUnstarRepoForAuthenticatedUser(
        path: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Path,
        headers: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityUnstarRepoForAuthenticatedUser.Output {
        try await activityUnstarRepoForAuthenticatedUser(Operations.ActivityUnstarRepoForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories watched by the authenticated user
    ///
    /// Lists repositories the authenticated user is watching.
    ///
    /// - Remark: HTTP `GET /user/subscriptions`.
    /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)`.
    public func activityListWatchedReposForAuthenticatedUser(
        query: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListWatchedReposForAuthenticatedUser.Output {
        try await activityListWatchedReposForAuthenticatedUser(Operations.ActivityListWatchedReposForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List events for the authenticated user
    ///
    /// If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. _Optional_: use the fine-grained token with following permission set to view private events: "Events" user permissions (read).
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events`.
    /// - Remark: Generated from `#/paths//users/{username}/events/get(activity/list-events-for-authenticated-user)`.
    public func activityListEventsForAuthenticatedUser(
        path: Operations.ActivityListEventsForAuthenticatedUser.Input.Path,
        query: Operations.ActivityListEventsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListEventsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListEventsForAuthenticatedUser.Output {
        try await activityListEventsForAuthenticatedUser(Operations.ActivityListEventsForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List organization events for the authenticated user
    ///
    /// This is the user's organization dashboard. You must be authenticated as the user to view this.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/orgs/{org}`.
    /// - Remark: Generated from `#/paths//users/{username}/events/orgs/{org}/get(activity/list-org-events-for-authenticated-user)`.
    public func activityListOrgEventsForAuthenticatedUser(
        path: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Path,
        query: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListOrgEventsForAuthenticatedUser.Output {
        try await activityListOrgEventsForAuthenticatedUser(Operations.ActivityListOrgEventsForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List public events for a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/events/public/get(activity/list-public-events-for-user)`.
    public func activityListPublicEventsForUser(
        path: Operations.ActivityListPublicEventsForUser.Input.Path,
        query: Operations.ActivityListPublicEventsForUser.Input.Query = .init(),
        headers: Operations.ActivityListPublicEventsForUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListPublicEventsForUser.Output {
        try await activityListPublicEventsForUser(Operations.ActivityListPublicEventsForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List events received by the authenticated user
    ///
    /// These are events that you've received by watching repositories and following users. If you are authenticated as the
    /// given user, you will see private events. Otherwise, you'll only see public events.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/get(activity/list-received-events-for-user)`.
    public func activityListReceivedEventsForUser(
        path: Operations.ActivityListReceivedEventsForUser.Input.Path,
        query: Operations.ActivityListReceivedEventsForUser.Input.Query = .init(),
        headers: Operations.ActivityListReceivedEventsForUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListReceivedEventsForUser.Output {
        try await activityListReceivedEventsForUser(Operations.ActivityListReceivedEventsForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List public events received by a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/public/get(activity/list-received-public-events-for-user)`.
    public func activityListReceivedPublicEventsForUser(
        path: Operations.ActivityListReceivedPublicEventsForUser.Input.Path,
        query: Operations.ActivityListReceivedPublicEventsForUser.Input.Query = .init(),
        headers: Operations.ActivityListReceivedPublicEventsForUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListReceivedPublicEventsForUser.Output {
        try await activityListReceivedPublicEventsForUser(Operations.ActivityListReceivedPublicEventsForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repositories starred by a user
    ///
    /// Lists repositories a user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /users/{username}/starred`.
    /// - Remark: Generated from `#/paths//users/{username}/starred/get(activity/list-repos-starred-by-user)`.
    public func activityListReposStarredByUser(
        path: Operations.ActivityListReposStarredByUser.Input.Path,
        query: Operations.ActivityListReposStarredByUser.Input.Query = .init(),
        headers: Operations.ActivityListReposStarredByUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListReposStarredByUser.Output {
        try await activityListReposStarredByUser(Operations.ActivityListReposStarredByUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repositories watched by a user
    ///
    /// Lists repositories a user is watching.
    ///
    /// - Remark: HTTP `GET /users/{username}/subscriptions`.
    /// - Remark: Generated from `#/paths//users/{username}/subscriptions/get(activity/list-repos-watched-by-user)`.
    public func activityListReposWatchedByUser(
        path: Operations.ActivityListReposWatchedByUser.Input.Path,
        query: Operations.ActivityListReposWatchedByUser.Input.Query = .init(),
        headers: Operations.ActivityListReposWatchedByUser.Input.Headers = .init()
    ) async throws -> Operations.ActivityListReposWatchedByUser.Output {
        try await activityListReposWatchedByUser(Operations.ActivityListReposWatchedByUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// Actor
        ///
        /// - Remark: Generated from `#/components/schemas/actor`.
        public struct Actor: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/actor/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/actor/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/actor/display_login`.
            public var displayLogin: Swift.String?
            /// - Remark: Generated from `#/components/schemas/actor/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/actor/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/actor/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Actor`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - login:
            ///   - displayLogin:
            ///   - gravatarId:
            ///   - url:
            ///   - avatarUrl:
            public init(
                id: Swift.Int,
                login: Swift.String,
                displayLogin: Swift.String? = nil,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                avatarUrl: Swift.String
            ) {
                self.id = id
                self.login = login
                self.displayLogin = displayLogin
                self.gravatarId = gravatarId
                self.url = url
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case login
                case displayLogin = "display_login"
                case gravatarId = "gravatar_id"
                case url
                case avatarUrl = "avatar_url"
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-milestone`.
        public struct NullableMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            public var state: Components.Schemas.NullableMilestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `NullableMilestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.NullableMilestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
        /// The type of issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-type`.
        public struct IssueType: Codable, Hashable, Sendable {
            /// The unique identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/id`.
            public var id: Swift.Int
            /// The node identifier of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/node_id`.
            public var nodeId: Swift.String
            /// The name of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/name`.
            public var name: Swift.String
            /// The description of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/description`.
            public var description: Swift.String?
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            @frozen public enum ColorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case gray = "gray"
                case blue = "blue"
                case green = "green"
                case yellow = "yellow"
                case orange = "orange"
                case red = "red"
                case pink = "pink"
                case purple = "purple"
            }
            /// The color of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/color`.
            public var color: Components.Schemas.IssueType.ColorPayload?
            /// The time the issue type created.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/created_at`.
            public var createdAt: Foundation.Date?
            /// The time the issue type last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The enabled state of the issue type.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-type/is_enabled`.
            public var isEnabled: Swift.Bool?
            /// Creates a new `IssueType`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the issue type.
            ///   - nodeId: The node identifier of the issue type.
            ///   - name: The name of the issue type.
            ///   - description: The description of the issue type.
            ///   - color: The color of the issue type.
            ///   - createdAt: The time the issue type created.
            ///   - updatedAt: The time the issue type last updated.
            ///   - isEnabled: The enabled state of the issue type.
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                color: Components.Schemas.IssueType.ColorPayload? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                isEnabled: Swift.Bool? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.description = description
                self.color = color
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.isEnabled = isEnabled
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case description
                case color
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case isEnabled = "is_enabled"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// - Remark: Generated from `#/components/schemas/sub-issues-summary`.
        public struct SubIssuesSummary: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/total`.
            public var total: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/completed`.
            public var completed: Swift.Int
            /// - Remark: Generated from `#/components/schemas/sub-issues-summary/percent_completed`.
            public var percentCompleted: Swift.Int
            /// Creates a new `SubIssuesSummary`.
            ///
            /// - Parameters:
            ///   - total:
            ///   - completed:
            ///   - percentCompleted:
            public init(
                total: Swift.Int,
                completed: Swift.Int,
                percentCompleted: Swift.Int
            ) {
                self.total = total
                self.completed = completed
                self.percentCompleted = percentCompleted
            }
            public enum CodingKeys: String, CodingKey {
                case total
                case completed
                case percentCompleted = "percent_completed"
            }
        }
        /// - Remark: Generated from `#/components/schemas/issue-dependencies-summary`.
        public struct IssueDependenciesSummary: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue-dependencies-summary/blocked_by`.
            public var blockedBy: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-dependencies-summary/blocking`.
            public var blocking: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-dependencies-summary/total_blocked_by`.
            public var totalBlockedBy: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue-dependencies-summary/total_blocking`.
            public var totalBlocking: Swift.Int
            /// Creates a new `IssueDependenciesSummary`.
            ///
            /// - Parameters:
            ///   - blockedBy:
            ///   - blocking:
            ///   - totalBlockedBy:
            ///   - totalBlocking:
            public init(
                blockedBy: Swift.Int,
                blocking: Swift.Int,
                totalBlockedBy: Swift.Int,
                totalBlocking: Swift.Int
            ) {
                self.blockedBy = blockedBy
                self.blocking = blocking
                self.totalBlockedBy = totalBlockedBy
                self.totalBlocking = totalBlocking
            }
            public enum CodingKeys: String, CodingKey {
                case blockedBy = "blocked_by"
                case blocking
                case totalBlockedBy = "total_blocked_by"
                case totalBlocking = "total_blocking"
            }
        }
        /// A value assigned to an issue field
        ///
        /// - Remark: Generated from `#/components/schemas/issue-field-value`.
        public struct IssueFieldValue: Codable, Hashable, Sendable {
            /// Unique identifier for the issue field.
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/issue_field_id`.
            public var issueFieldId: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue-field-value/node_id`.
            public var nodeId: Swift.String
            /// The data type of the issue field
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/data_type`.
            @frozen public enum DataTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case text = "text"
                case singleSelect = "single_select"
                case number = "number"
                case date = "date"
            }
            /// The data type of the issue field
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/data_type`.
            public var dataType: Components.Schemas.IssueFieldValue.DataTypePayload
            /// The value of the issue field
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/value`.
            public struct ValuePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue-field-value/value/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue-field-value/value/value2`.
                public var value2: Swift.Double?
                /// - Remark: Generated from `#/components/schemas/issue-field-value/value/value3`.
                public var value3: Swift.Int?
                /// Creates a new `ValuePayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                ///   - value3:
                public init(
                    value1: Swift.String? = nil,
                    value2: Swift.Double? = nil,
                    value3: Swift.Int? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                    self.value3 = value3
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value3 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2,
                            self.value3
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        self.value1,
                        self.value2,
                        self.value3
                    ])
                }
            }
            /// The value of the issue field
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/value`.
            public var value: Components.Schemas.IssueFieldValue.ValuePayload?
            /// Details about the selected option (only present for single_select fields)
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/single_select_option`.
            public struct SingleSelectOptionPayload: Codable, Hashable, Sendable {
                /// Unique identifier for the option.
                ///
                /// - Remark: Generated from `#/components/schemas/issue-field-value/single_select_option/id`.
                public var id: Swift.Int64
                /// The name of the option
                ///
                /// - Remark: Generated from `#/components/schemas/issue-field-value/single_select_option/name`.
                public var name: Swift.String
                /// The color of the option
                ///
                /// - Remark: Generated from `#/components/schemas/issue-field-value/single_select_option/color`.
                public var color: Swift.String
                /// Creates a new `SingleSelectOptionPayload`.
                ///
                /// - Parameters:
                ///   - id: Unique identifier for the option.
                ///   - name: The name of the option
                ///   - color: The color of the option
                public init(
                    id: Swift.Int64,
                    name: Swift.String,
                    color: Swift.String
                ) {
                    self.id = id
                    self.name = name
                    self.color = color
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case name
                    case color
                }
            }
            /// Details about the selected option (only present for single_select fields)
            ///
            /// - Remark: Generated from `#/components/schemas/issue-field-value/single_select_option`.
            public var singleSelectOption: Components.Schemas.IssueFieldValue.SingleSelectOptionPayload?
            /// Creates a new `IssueFieldValue`.
            ///
            /// - Parameters:
            ///   - issueFieldId: Unique identifier for the issue field.
            ///   - nodeId:
            ///   - dataType: The data type of the issue field
            ///   - value: The value of the issue field
            ///   - singleSelectOption: Details about the selected option (only present for single_select fields)
            public init(
                issueFieldId: Swift.Int64,
                nodeId: Swift.String,
                dataType: Components.Schemas.IssueFieldValue.DataTypePayload,
                value: Components.Schemas.IssueFieldValue.ValuePayload? = nil,
                singleSelectOption: Components.Schemas.IssueFieldValue.SingleSelectOptionPayload? = nil
            ) {
                self.issueFieldId = issueFieldId
                self.nodeId = nodeId
                self.dataType = dataType
                self.value = value
                self.singleSelectOption = singleSelectOption
            }
            public enum CodingKeys: String, CodingKey {
                case issueFieldId = "issue_field_id"
                case nodeId = "node_id"
                case dataType = "data_type"
                case value
                case singleSelectOption = "single_select_option"
            }
        }
        /// Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
        ///
        /// - Remark: Generated from `#/components/schemas/issue`.
        public struct Issue: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/issue/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue/html_url`.
            public var htmlUrl: Swift.String
            /// Number uniquely identifying the issue within its repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/number`.
            public var number: Swift.Int
            /// State of the issue; either 'open' or 'closed'
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state`.
            public var state: Swift.String
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state_reason`.
            @frozen public enum StateReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case completed = "completed"
                case reopened = "reopened"
                case notPlanned = "not_planned"
                case duplicate = "duplicate"
            }
            /// The reason for the current state
            ///
            /// - Remark: Generated from `#/components/schemas/issue/state_reason`.
            public var stateReason: Components.Schemas.Issue.StateReasonPayload?
            /// Title of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/title`.
            public var title: Swift.String
            /// Contents of the issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload`.
            @frozen public enum LabelsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2`.
                public struct Case2Payload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/id`.
                    public var id: Swift.Int64?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/node_id`.
                    public var nodeId: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/url`.
                    public var url: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/name`.
                    public var name: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/description`.
                    public var description: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/color`.
                    public var color: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2/default`.
                    public var _default: Swift.Bool?
                    /// Creates a new `Case2Payload`.
                    ///
                    /// - Parameters:
                    ///   - id:
                    ///   - nodeId:
                    ///   - url:
                    ///   - name:
                    ///   - description:
                    ///   - color:
                    ///   - _default:
                    public init(
                        id: Swift.Int64? = nil,
                        nodeId: Swift.String? = nil,
                        url: Swift.String? = nil,
                        name: Swift.String? = nil,
                        description: Swift.String? = nil,
                        color: Swift.String? = nil,
                        _default: Swift.Bool? = nil
                    ) {
                        self.id = id
                        self.nodeId = nodeId
                        self.url = url
                        self.name = name
                        self.description = description
                        self.color = color
                        self._default = _default
                    }
                    public enum CodingKeys: String, CodingKey {
                        case id
                        case nodeId = "node_id"
                        case url
                        case name
                        case description
                        case color
                        case _default = "default"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/issue/LabelsPayload/case2`.
                case case2(Components.Schemas.Issue.LabelsPayloadPayload.Case2Payload)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/labels`.
            public typealias LabelsPayload = [Components.Schemas.Issue.LabelsPayloadPayload]
            /// Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///
            /// - Remark: Generated from `#/components/schemas/issue/labels`.
            public var labels: Components.Schemas.Issue.LabelsPayload
            /// - Remark: Generated from `#/components/schemas/issue/assignee`.
            public var assignee: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/assignees`.
            public var assignees: [Components.Schemas.SimpleUser]?
            /// - Remark: Generated from `#/components/schemas/issue/milestone`.
            public var milestone: Components.Schemas.NullableMilestone?
            /// - Remark: Generated from `#/components/schemas/issue/locked`.
            public var locked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/issue/active_lock_reason`.
            public var activeLockReason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/comments`.
            public var comments: Swift.Int
            /// - Remark: Generated from `#/components/schemas/issue/pull_request`.
            public struct PullRequestPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/merged_at`.
                public var mergedAt: Foundation.Date?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/diff_url`.
                public var diffUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/patch_url`.
                public var patchUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/issue/pull_request/url`.
                public var url: Swift.String?
                /// Creates a new `PullRequestPayload`.
                ///
                /// - Parameters:
                ///   - mergedAt:
                ///   - diffUrl:
                ///   - htmlUrl:
                ///   - patchUrl:
                ///   - url:
                public init(
                    mergedAt: Foundation.Date? = nil,
                    diffUrl: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    patchUrl: Swift.String? = nil,
                    url: Swift.String? = nil
                ) {
                    self.mergedAt = mergedAt
                    self.diffUrl = diffUrl
                    self.htmlUrl = htmlUrl
                    self.patchUrl = patchUrl
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case mergedAt = "merged_at"
                    case diffUrl = "diff_url"
                    case htmlUrl = "html_url"
                    case patchUrl = "patch_url"
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/issue/pull_request`.
            public var pullRequest: Components.Schemas.Issue.PullRequestPayload?
            /// - Remark: Generated from `#/components/schemas/issue/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/issue/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue/draft`.
            public var draft: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/issue/closed_by`.
            public var closedBy: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/timeline_url`.
            public var timelineUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/type`.
            public var _type: Components.Schemas.IssueType?
            /// - Remark: Generated from `#/components/schemas/issue/repository`.
            public var repository: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/issue/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/issue/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation?
            /// - Remark: Generated from `#/components/schemas/issue/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// - Remark: Generated from `#/components/schemas/issue/sub_issues_summary`.
            public var subIssuesSummary: Components.Schemas.SubIssuesSummary?
            /// URL to get the parent issue of this issue, if it is a sub-issue
            ///
            /// - Remark: Generated from `#/components/schemas/issue/parent_issue_url`.
            public var parentIssueUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue/issue_dependencies_summary`.
            public var issueDependenciesSummary: Components.Schemas.IssueDependenciesSummary?
            /// - Remark: Generated from `#/components/schemas/issue/issue_field_values`.
            public var issueFieldValues: [Components.Schemas.IssueFieldValue]?
            /// Creates a new `Issue`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - url: URL for the issue
            ///   - repositoryUrl:
            ///   - labelsUrl:
            ///   - commentsUrl:
            ///   - eventsUrl:
            ///   - htmlUrl:
            ///   - number: Number uniquely identifying the issue within its repository
            ///   - state: State of the issue; either 'open' or 'closed'
            ///   - stateReason: The reason for the current state
            ///   - title: Title of the issue
            ///   - body: Contents of the issue
            ///   - user:
            ///   - labels: Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
            ///   - assignee:
            ///   - assignees:
            ///   - milestone:
            ///   - locked:
            ///   - activeLockReason:
            ///   - comments:
            ///   - pullRequest:
            ///   - closedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - draft:
            ///   - closedBy:
            ///   - bodyHtml:
            ///   - bodyText:
            ///   - timelineUrl:
            ///   - _type:
            ///   - repository:
            ///   - performedViaGithubApp:
            ///   - authorAssociation:
            ///   - reactions:
            ///   - subIssuesSummary:
            ///   - parentIssueUrl: URL to get the parent issue of this issue, if it is a sub-issue
            ///   - issueDependenciesSummary:
            ///   - issueFieldValues:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                repositoryUrl: Swift.String,
                labelsUrl: Swift.String,
                commentsUrl: Swift.String,
                eventsUrl: Swift.String,
                htmlUrl: Swift.String,
                number: Swift.Int,
                state: Swift.String,
                stateReason: Components.Schemas.Issue.StateReasonPayload? = nil,
                title: Swift.String,
                body: Swift.String? = nil,
                user: Components.Schemas.NullableSimpleUser? = nil,
                labels: Components.Schemas.Issue.LabelsPayload,
                assignee: Components.Schemas.NullableSimpleUser? = nil,
                assignees: [Components.Schemas.SimpleUser]? = nil,
                milestone: Components.Schemas.NullableMilestone? = nil,
                locked: Swift.Bool,
                activeLockReason: Swift.String? = nil,
                comments: Swift.Int,
                pullRequest: Components.Schemas.Issue.PullRequestPayload? = nil,
                closedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                draft: Swift.Bool? = nil,
                closedBy: Components.Schemas.NullableSimpleUser? = nil,
                bodyHtml: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                timelineUrl: Swift.String? = nil,
                _type: Components.Schemas.IssueType? = nil,
                repository: Components.Schemas.Repository? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                authorAssociation: Components.Schemas.AuthorAssociation? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil,
                subIssuesSummary: Components.Schemas.SubIssuesSummary? = nil,
                parentIssueUrl: Swift.String? = nil,
                issueDependenciesSummary: Components.Schemas.IssueDependenciesSummary? = nil,
                issueFieldValues: [Components.Schemas.IssueFieldValue]? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.repositoryUrl = repositoryUrl
                self.labelsUrl = labelsUrl
                self.commentsUrl = commentsUrl
                self.eventsUrl = eventsUrl
                self.htmlUrl = htmlUrl
                self.number = number
                self.state = state
                self.stateReason = stateReason
                self.title = title
                self.body = body
                self.user = user
                self.labels = labels
                self.assignee = assignee
                self.assignees = assignees
                self.milestone = milestone
                self.locked = locked
                self.activeLockReason = activeLockReason
                self.comments = comments
                self.pullRequest = pullRequest
                self.closedAt = closedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.draft = draft
                self.closedBy = closedBy
                self.bodyHtml = bodyHtml
                self.bodyText = bodyText
                self.timelineUrl = timelineUrl
                self._type = _type
                self.repository = repository
                self.performedViaGithubApp = performedViaGithubApp
                self.authorAssociation = authorAssociation
                self.reactions = reactions
                self.subIssuesSummary = subIssuesSummary
                self.parentIssueUrl = parentIssueUrl
                self.issueDependenciesSummary = issueDependenciesSummary
                self.issueFieldValues = issueFieldValues
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case repositoryUrl = "repository_url"
                case labelsUrl = "labels_url"
                case commentsUrl = "comments_url"
                case eventsUrl = "events_url"
                case htmlUrl = "html_url"
                case number
                case state
                case stateReason = "state_reason"
                case title
                case body
                case user
                case labels
                case assignee
                case assignees
                case milestone
                case locked
                case activeLockReason = "active_lock_reason"
                case comments
                case pullRequest = "pull_request"
                case closedAt = "closed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case draft
                case closedBy = "closed_by"
                case bodyHtml = "body_html"
                case bodyText = "body_text"
                case timelineUrl = "timeline_url"
                case _type = "type"
                case repository
                case performedViaGithubApp = "performed_via_github_app"
                case authorAssociation = "author_association"
                case reactions
                case subIssuesSummary = "sub_issues_summary"
                case parentIssueUrl = "parent_issue_url"
                case issueDependenciesSummary = "issue_dependencies_summary"
                case issueFieldValues = "issue_field_values"
            }
        }
        /// Comments provide a way for people to collaborate on an issue.
        ///
        /// - Remark: Generated from `#/components/schemas/issue-comment`.
        public struct IssueComment: Codable, Hashable, Sendable {
            /// Unique identifier of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/issue-comment/node_id`.
            public var nodeId: Swift.String
            /// URL for the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/url`.
            public var url: Swift.String
            /// Contents of the issue comment
            ///
            /// - Remark: Generated from `#/components/schemas/issue-comment/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/body_text`.
            public var bodyText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/body_html`.
            public var bodyHtml: Swift.String?
            /// - Remark: Generated from `#/components/schemas/issue-comment/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-comment/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/issue-comment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-comment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/issue-comment/issue_url`.
            public var issueUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/issue-comment/author_association`.
            public var authorAssociation: Components.Schemas.AuthorAssociation
            /// - Remark: Generated from `#/components/schemas/issue-comment/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// - Remark: Generated from `#/components/schemas/issue-comment/reactions`.
            public var reactions: Components.Schemas.ReactionRollup?
            /// Creates a new `IssueComment`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the issue comment
            ///   - nodeId:
            ///   - url: URL for the issue comment
            ///   - body: Contents of the issue comment
            ///   - bodyText:
            ///   - bodyHtml:
            ///   - htmlUrl:
            ///   - user:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - issueUrl:
            ///   - authorAssociation:
            ///   - performedViaGithubApp:
            ///   - reactions:
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                bodyText: Swift.String? = nil,
                bodyHtml: Swift.String? = nil,
                htmlUrl: Swift.String,
                user: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                issueUrl: Swift.String,
                authorAssociation: Components.Schemas.AuthorAssociation,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil,
                reactions: Components.Schemas.ReactionRollup? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.body = body
                self.bodyText = bodyText
                self.bodyHtml = bodyHtml
                self.htmlUrl = htmlUrl
                self.user = user
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.issueUrl = issueUrl
                self.authorAssociation = authorAssociation
                self.performedViaGithubApp = performedViaGithubApp
                self.reactions = reactions
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case body
                case bodyText = "body_text"
                case bodyHtml = "body_html"
                case htmlUrl = "html_url"
                case user
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case issueUrl = "issue_url"
                case authorAssociation = "author_association"
                case performedViaGithubApp = "performed_via_github_app"
                case reactions
            }
        }
        /// Event
        ///
        /// - Remark: Generated from `#/components/schemas/event`.
        public struct Event: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/event/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/event/type`.
            public var _type: Swift.String?
            /// - Remark: Generated from `#/components/schemas/event/actor`.
            public var actor: Components.Schemas.Actor
            /// - Remark: Generated from `#/components/schemas/event/repo`.
            public struct RepoPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/event/repo/id`.
                public var id: Swift.Int
                /// - Remark: Generated from `#/components/schemas/event/repo/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/event/repo/url`.
                public var url: Swift.String
                /// Creates a new `RepoPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - name:
                ///   - url:
                public init(
                    id: Swift.Int,
                    name: Swift.String,
                    url: Swift.String
                ) {
                    self.id = id
                    self.name = name
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case name
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/event/repo`.
            public var repo: Components.Schemas.Event.RepoPayload
            /// - Remark: Generated from `#/components/schemas/event/org`.
            public var org: Components.Schemas.Actor?
            /// - Remark: Generated from `#/components/schemas/event/payload`.
            public struct PayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/event/payload/action`.
                public var action: Swift.String?
                /// - Remark: Generated from `#/components/schemas/event/payload/issue`.
                public var issue: Components.Schemas.Issue?
                /// - Remark: Generated from `#/components/schemas/event/payload/comment`.
                public var comment: Components.Schemas.IssueComment?
                /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload`.
                public struct PagesPayloadPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/page_name`.
                    public var pageName: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/title`.
                    public var title: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/summary`.
                    public var summary: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/action`.
                    public var action: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/sha`.
                    public var sha: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/event/payload/PagesPayload/html_url`.
                    public var htmlUrl: Swift.String?
                    /// Creates a new `PagesPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - pageName:
                    ///   - title:
                    ///   - summary:
                    ///   - action:
                    ///   - sha:
                    ///   - htmlUrl:
                    public init(
                        pageName: Swift.String? = nil,
                        title: Swift.String? = nil,
                        summary: Swift.String? = nil,
                        action: Swift.String? = nil,
                        sha: Swift.String? = nil,
                        htmlUrl: Swift.String? = nil
                    ) {
                        self.pageName = pageName
                        self.title = title
                        self.summary = summary
                        self.action = action
                        self.sha = sha
                        self.htmlUrl = htmlUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case pageName = "page_name"
                        case title
                        case summary
                        case action
                        case sha
                        case htmlUrl = "html_url"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/event/payload/pages`.
                public typealias PagesPayload = [Components.Schemas.Event.PayloadPayload.PagesPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/event/payload/pages`.
                public var pages: Components.Schemas.Event.PayloadPayload.PagesPayload?
                /// Creates a new `PayloadPayload`.
                ///
                /// - Parameters:
                ///   - action:
                ///   - issue:
                ///   - comment:
                ///   - pages:
                public init(
                    action: Swift.String? = nil,
                    issue: Components.Schemas.Issue? = nil,
                    comment: Components.Schemas.IssueComment? = nil,
                    pages: Components.Schemas.Event.PayloadPayload.PagesPayload? = nil
                ) {
                    self.action = action
                    self.issue = issue
                    self.comment = comment
                    self.pages = pages
                }
                public enum CodingKeys: String, CodingKey {
                    case action
                    case issue
                    case comment
                    case pages
                }
            }
            /// - Remark: Generated from `#/components/schemas/event/payload`.
            public var payload: Components.Schemas.Event.PayloadPayload
            /// - Remark: Generated from `#/components/schemas/event/public`.
            public var _public: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/event/created_at`.
            public var createdAt: Foundation.Date?
            /// Creates a new `Event`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - _type:
            ///   - actor:
            ///   - repo:
            ///   - org:
            ///   - payload:
            ///   - _public:
            ///   - createdAt:
            public init(
                id: Swift.String,
                _type: Swift.String? = nil,
                actor: Components.Schemas.Actor,
                repo: Components.Schemas.Event.RepoPayload,
                org: Components.Schemas.Actor? = nil,
                payload: Components.Schemas.Event.PayloadPayload,
                _public: Swift.Bool,
                createdAt: Foundation.Date? = nil
            ) {
                self.id = id
                self._type = _type
                self.actor = actor
                self.repo = repo
                self.org = org
                self.payload = payload
                self._public = _public
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case actor
                case repo
                case org
                case payload
                case _public = "public"
                case createdAt = "created_at"
            }
        }
        /// Hypermedia Link with Type
        ///
        /// - Remark: Generated from `#/components/schemas/link-with-type`.
        public struct LinkWithType: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/link-with-type/href`.
            public var href: Swift.String
            /// - Remark: Generated from `#/components/schemas/link-with-type/type`.
            public var _type: Swift.String
            /// Creates a new `LinkWithType`.
            ///
            /// - Parameters:
            ///   - href:
            ///   - _type:
            public init(
                href: Swift.String,
                _type: Swift.String
            ) {
                self.href = href
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case href
                case _type = "type"
            }
        }
        /// Feed
        ///
        /// - Remark: Generated from `#/components/schemas/feed`.
        public struct Feed: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/feed/timeline_url`.
            public var timelineUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/feed/user_url`.
            public var userUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/feed/current_user_public_url`.
            public var currentUserPublicUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/feed/current_user_url`.
            public var currentUserUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/feed/current_user_actor_url`.
            public var currentUserActorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/feed/current_user_organization_url`.
            public var currentUserOrganizationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/feed/current_user_organization_urls`.
            public var currentUserOrganizationUrls: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/feed/security_advisories_url`.
            public var securityAdvisoriesUrl: Swift.String?
            /// A feed of discussions for a given repository.
            ///
            /// - Remark: Generated from `#/components/schemas/feed/repository_discussions_url`.
            public var repositoryDiscussionsUrl: Swift.String?
            /// A feed of discussions for a given repository and category.
            ///
            /// - Remark: Generated from `#/components/schemas/feed/repository_discussions_category_url`.
            public var repositoryDiscussionsCategoryUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/feed/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/feed/_links/timeline`.
                public var timeline: Components.Schemas.LinkWithType
                /// - Remark: Generated from `#/components/schemas/feed/_links/user`.
                public var user: Components.Schemas.LinkWithType
                /// - Remark: Generated from `#/components/schemas/feed/_links/security_advisories`.
                public var securityAdvisories: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/current_user`.
                public var currentUser: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/current_user_public`.
                public var currentUserPublic: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/current_user_actor`.
                public var currentUserActor: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/current_user_organization`.
                public var currentUserOrganization: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/current_user_organizations`.
                public var currentUserOrganizations: [Components.Schemas.LinkWithType]?
                /// - Remark: Generated from `#/components/schemas/feed/_links/repository_discussions`.
                public var repositoryDiscussions: Components.Schemas.LinkWithType?
                /// - Remark: Generated from `#/components/schemas/feed/_links/repository_discussions_category`.
                public var repositoryDiscussionsCategory: Components.Schemas.LinkWithType?
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - timeline:
                ///   - user:
                ///   - securityAdvisories:
                ///   - currentUser:
                ///   - currentUserPublic:
                ///   - currentUserActor:
                ///   - currentUserOrganization:
                ///   - currentUserOrganizations:
                ///   - repositoryDiscussions:
                ///   - repositoryDiscussionsCategory:
                public init(
                    timeline: Components.Schemas.LinkWithType,
                    user: Components.Schemas.LinkWithType,
                    securityAdvisories: Components.Schemas.LinkWithType? = nil,
                    currentUser: Components.Schemas.LinkWithType? = nil,
                    currentUserPublic: Components.Schemas.LinkWithType? = nil,
                    currentUserActor: Components.Schemas.LinkWithType? = nil,
                    currentUserOrganization: Components.Schemas.LinkWithType? = nil,
                    currentUserOrganizations: [Components.Schemas.LinkWithType]? = nil,
                    repositoryDiscussions: Components.Schemas.LinkWithType? = nil,
                    repositoryDiscussionsCategory: Components.Schemas.LinkWithType? = nil
                ) {
                    self.timeline = timeline
                    self.user = user
                    self.securityAdvisories = securityAdvisories
                    self.currentUser = currentUser
                    self.currentUserPublic = currentUserPublic
                    self.currentUserActor = currentUserActor
                    self.currentUserOrganization = currentUserOrganization
                    self.currentUserOrganizations = currentUserOrganizations
                    self.repositoryDiscussions = repositoryDiscussions
                    self.repositoryDiscussionsCategory = repositoryDiscussionsCategory
                }
                public enum CodingKeys: String, CodingKey {
                    case timeline
                    case user
                    case securityAdvisories = "security_advisories"
                    case currentUser = "current_user"
                    case currentUserPublic = "current_user_public"
                    case currentUserActor = "current_user_actor"
                    case currentUserOrganization = "current_user_organization"
                    case currentUserOrganizations = "current_user_organizations"
                    case repositoryDiscussions = "repository_discussions"
                    case repositoryDiscussionsCategory = "repository_discussions_category"
                }
            }
            /// - Remark: Generated from `#/components/schemas/feed/_links`.
            public var _links: Components.Schemas.Feed._LinksPayload
            /// Creates a new `Feed`.
            ///
            /// - Parameters:
            ///   - timelineUrl:
            ///   - userUrl:
            ///   - currentUserPublicUrl:
            ///   - currentUserUrl:
            ///   - currentUserActorUrl:
            ///   - currentUserOrganizationUrl:
            ///   - currentUserOrganizationUrls:
            ///   - securityAdvisoriesUrl:
            ///   - repositoryDiscussionsUrl: A feed of discussions for a given repository.
            ///   - repositoryDiscussionsCategoryUrl: A feed of discussions for a given repository and category.
            ///   - _links:
            public init(
                timelineUrl: Swift.String,
                userUrl: Swift.String,
                currentUserPublicUrl: Swift.String? = nil,
                currentUserUrl: Swift.String? = nil,
                currentUserActorUrl: Swift.String? = nil,
                currentUserOrganizationUrl: Swift.String? = nil,
                currentUserOrganizationUrls: [Swift.String]? = nil,
                securityAdvisoriesUrl: Swift.String? = nil,
                repositoryDiscussionsUrl: Swift.String? = nil,
                repositoryDiscussionsCategoryUrl: Swift.String? = nil,
                _links: Components.Schemas.Feed._LinksPayload
            ) {
                self.timelineUrl = timelineUrl
                self.userUrl = userUrl
                self.currentUserPublicUrl = currentUserPublicUrl
                self.currentUserUrl = currentUserUrl
                self.currentUserActorUrl = currentUserActorUrl
                self.currentUserOrganizationUrl = currentUserOrganizationUrl
                self.currentUserOrganizationUrls = currentUserOrganizationUrls
                self.securityAdvisoriesUrl = securityAdvisoriesUrl
                self.repositoryDiscussionsUrl = repositoryDiscussionsUrl
                self.repositoryDiscussionsCategoryUrl = repositoryDiscussionsCategoryUrl
                self._links = _links
            }
            public enum CodingKeys: String, CodingKey {
                case timelineUrl = "timeline_url"
                case userUrl = "user_url"
                case currentUserPublicUrl = "current_user_public_url"
                case currentUserUrl = "current_user_url"
                case currentUserActorUrl = "current_user_actor_url"
                case currentUserOrganizationUrl = "current_user_organization_url"
                case currentUserOrganizationUrls = "current_user_organization_urls"
                case securityAdvisoriesUrl = "security_advisories_url"
                case repositoryDiscussionsUrl = "repository_discussions_url"
                case repositoryDiscussionsCategoryUrl = "repository_discussions_category_url"
                case _links
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// Thread
        ///
        /// - Remark: Generated from `#/components/schemas/thread`.
        public struct Thread: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/thread/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/thread/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/thread/subject`.
            public struct SubjectPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/thread/subject/title`.
                public var title: Swift.String
                /// - Remark: Generated from `#/components/schemas/thread/subject/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/thread/subject/latest_comment_url`.
                public var latestCommentUrl: Swift.String
                /// - Remark: Generated from `#/components/schemas/thread/subject/type`.
                public var _type: Swift.String
                /// Creates a new `SubjectPayload`.
                ///
                /// - Parameters:
                ///   - title:
                ///   - url:
                ///   - latestCommentUrl:
                ///   - _type:
                public init(
                    title: Swift.String,
                    url: Swift.String,
                    latestCommentUrl: Swift.String,
                    _type: Swift.String
                ) {
                    self.title = title
                    self.url = url
                    self.latestCommentUrl = latestCommentUrl
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case title
                    case url
                    case latestCommentUrl = "latest_comment_url"
                    case _type = "type"
                }
            }
            /// - Remark: Generated from `#/components/schemas/thread/subject`.
            public var subject: Components.Schemas.Thread.SubjectPayload
            /// - Remark: Generated from `#/components/schemas/thread/reason`.
            public var reason: Swift.String
            /// - Remark: Generated from `#/components/schemas/thread/unread`.
            public var unread: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/thread/updated_at`.
            public var updatedAt: Swift.String
            /// - Remark: Generated from `#/components/schemas/thread/last_read_at`.
            public var lastReadAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/thread/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/thread/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// Creates a new `Thread`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - repository:
            ///   - subject:
            ///   - reason:
            ///   - unread:
            ///   - updatedAt:
            ///   - lastReadAt:
            ///   - url:
            ///   - subscriptionUrl:
            public init(
                id: Swift.String,
                repository: Components.Schemas.MinimalRepository,
                subject: Components.Schemas.Thread.SubjectPayload,
                reason: Swift.String,
                unread: Swift.Bool,
                updatedAt: Swift.String,
                lastReadAt: Swift.String? = nil,
                url: Swift.String,
                subscriptionUrl: Swift.String
            ) {
                self.id = id
                self.repository = repository
                self.subject = subject
                self.reason = reason
                self.unread = unread
                self.updatedAt = updatedAt
                self.lastReadAt = lastReadAt
                self.url = url
                self.subscriptionUrl = subscriptionUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case repository
                case subject
                case reason
                case unread
                case updatedAt = "updated_at"
                case lastReadAt = "last_read_at"
                case url
                case subscriptionUrl = "subscription_url"
            }
        }
        /// Thread Subscription
        ///
        /// - Remark: Generated from `#/components/schemas/thread-subscription`.
        public struct ThreadSubscription: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/thread-subscription/subscribed`.
            public var subscribed: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/thread-subscription/ignored`.
            public var ignored: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/thread-subscription/reason`.
            public var reason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/thread-subscription/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/thread-subscription/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/thread-subscription/thread_url`.
            public var threadUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/thread-subscription/repository_url`.
            public var repositoryUrl: Swift.String?
            /// Creates a new `ThreadSubscription`.
            ///
            /// - Parameters:
            ///   - subscribed:
            ///   - ignored:
            ///   - reason:
            ///   - createdAt:
            ///   - url:
            ///   - threadUrl:
            ///   - repositoryUrl:
            public init(
                subscribed: Swift.Bool,
                ignored: Swift.Bool,
                reason: Swift.String? = nil,
                createdAt: Foundation.Date? = nil,
                url: Swift.String,
                threadUrl: Swift.String? = nil,
                repositoryUrl: Swift.String? = nil
            ) {
                self.subscribed = subscribed
                self.ignored = ignored
                self.reason = reason
                self.createdAt = createdAt
                self.url = url
                self.threadUrl = threadUrl
                self.repositoryUrl = repositoryUrl
            }
            public enum CodingKeys: String, CodingKey {
                case subscribed
                case ignored
                case reason
                case createdAt = "created_at"
                case url
                case threadUrl = "thread_url"
                case repositoryUrl = "repository_url"
            }
        }
        /// Stargazer
        ///
        /// - Remark: Generated from `#/components/schemas/stargazer`.
        public struct Stargazer: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/stargazer/starred_at`.
            public var starredAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/stargazer/user`.
            public var user: Components.Schemas.NullableSimpleUser?
            /// Creates a new `Stargazer`.
            ///
            /// - Parameters:
            ///   - starredAt:
            ///   - user:
            public init(
                starredAt: Foundation.Date,
                user: Components.Schemas.NullableSimpleUser? = nil
            ) {
                self.starredAt = starredAt
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case starredAt = "starred_at"
                case user
            }
        }
        /// Repository invitations let you manage who you collaborate with.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-subscription`.
        public struct RepositorySubscription: Codable, Hashable, Sendable {
            /// Determines if notifications should be received from this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-subscription/subscribed`.
            public var subscribed: Swift.Bool
            /// Determines if all notifications should be blocked from this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-subscription/ignored`.
            public var ignored: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository-subscription/reason`.
            public var reason: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-subscription/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/repository-subscription/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository-subscription/repository_url`.
            public var repositoryUrl: Swift.String
            /// Creates a new `RepositorySubscription`.
            ///
            /// - Parameters:
            ///   - subscribed: Determines if notifications should be received from this repository.
            ///   - ignored: Determines if all notifications should be blocked from this repository.
            ///   - reason:
            ///   - createdAt:
            ///   - url:
            ///   - repositoryUrl:
            public init(
                subscribed: Swift.Bool,
                ignored: Swift.Bool,
                reason: Swift.String? = nil,
                createdAt: Foundation.Date,
                url: Swift.String,
                repositoryUrl: Swift.String
            ) {
                self.subscribed = subscribed
                self.ignored = ignored
                self.reason = reason
                self.createdAt = createdAt
                self.url = url
                self.repositoryUrl = repositoryUrl
            }
            public enum CodingKeys: String, CodingKey {
                case subscribed
                case ignored
                case reason
                case createdAt = "created_at"
                case url
                case repositoryUrl = "repository_url"
            }
        }
        /// Starred Repository
        ///
        /// - Remark: Generated from `#/components/schemas/starred-repository`.
        public struct StarredRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/starred-repository/starred_at`.
            public var starredAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/starred-repository/repo`.
            public var repo: Components.Schemas.Repository
            /// Creates a new `StarredRepository`.
            ///
            /// - Parameters:
            ///   - starredAt:
            ///   - repo:
            public init(
                starredAt: Foundation.Date,
                repo: Components.Schemas.Repository
            ) {
                self.starredAt = starredAt
                self.repo = repo
            }
            public enum CodingKeys: String, CodingKey {
                case starredAt = "starred_at"
                case repo
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/since`.
        public typealias Since = Foundation.Date
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// If `true`, show notifications marked as read.
        ///
        /// - Remark: Generated from `#/components/parameters/all`.
        public typealias All = Swift.Bool
        /// If `true`, only shows notifications in which the user is directly participating or mentioned.
        ///
        /// - Remark: Generated from `#/components/parameters/participating`.
        public typealias Participating = Swift.Bool
        /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/parameters/before`.
        public typealias Before = Foundation.Date
        /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
        ///
        /// - Remark: Generated from `#/components/parameters/thread-id`.
        public typealias ThreadId = Swift.Int
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to.
        ///
        /// - Remark: Generated from `#/components/parameters/sort-starred`.
        @frozen public enum SortStarred: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
        }
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
        public struct MovedPermanently: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/moved_permanently/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/moved_permanently/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.MovedPermanently.Body
            /// Creates a new `MovedPermanently`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.MovedPermanently.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List public events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /events`.
    /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)`.
    public enum ActivityListPublicEvents {
        public static let id: Swift.String = "activity/list-public-events"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListPublicEvents.Input.Query
            /// - Remark: Generated from `#/paths/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEvents.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEvents.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListPublicEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.ActivityListPublicEvents.Input.Query = .init(),
                headers: Operations.ActivityListPublicEvents.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListPublicEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListPublicEvents.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListPublicEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListPublicEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//events/get(activity/list-public-events)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get feeds
    ///
    /// Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.
    ///
    /// *   **Timeline**: The GitHub global public timeline
    /// *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
    /// *   **Current user public**: The public timeline for the authenticated user
    /// *   **Current user**: The private timeline for the authenticated user
    /// *   **Current user actor**: The private timeline for activity created by the authenticated user
    /// *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
    /// *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
    ///
    /// By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// > [!NOTE]
    /// > Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) since current feed URIs use the older, non revocable auth tokens.
    ///
    /// - Remark: HTTP `GET /feeds`.
    /// - Remark: Generated from `#/paths//feeds/get(activity/get-feeds)`.
    public enum ActivityGetFeeds {
        public static let id: Swift.String = "activity/get-feeds"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/feeds/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetFeeds.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetFeeds.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityGetFeeds.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.ActivityGetFeeds.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/feeds/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/feeds/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Feed)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Feed {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityGetFeeds.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityGetFeeds.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//feeds/get(activity/get-feeds)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityGetFeeds.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityGetFeeds.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public events for a network of repositories
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /networks/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)`.
    public enum ActivityListPublicEventsForRepoNetwork {
        public static let id: Swift.String = "activity/list-public-events-for-repo-network"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityListPublicEventsForRepoNetwork.Input.Path
            /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListPublicEventsForRepoNetwork.Input.Query
            /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEventsForRepoNetwork.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEventsForRepoNetwork.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListPublicEventsForRepoNetwork.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListPublicEventsForRepoNetwork.Input.Path,
                query: Operations.ActivityListPublicEventsForRepoNetwork.Input.Query = .init(),
                headers: Operations.ActivityListPublicEventsForRepoNetwork.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/networks/{owner}/{repo}/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListPublicEventsForRepoNetwork.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListPublicEventsForRepoNetwork.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListPublicEventsForRepoNetwork.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListPublicEventsForRepoNetwork.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Moved permanently
            ///
            /// - Remark: Generated from `#/paths//networks/{owner}/{repo}/events/get(activity/list-public-events-for-repo-network)/responses/301`.
            ///
            /// HTTP response code: `301 movedPermanently`.
            case movedPermanently(Components.Responses.MovedPermanently)
            /// The associated value of the enum case if `self` is `.movedPermanently`.
            ///
            /// - Throws: An error if `self` is not `.movedPermanently`.
            /// - SeeAlso: `.movedPermanently`.
            public var movedPermanently: Components.Responses.MovedPermanently {
                get throws {
                    switch self {
                    case let .movedPermanently(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "movedPermanently",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List notifications for the authenticated user
    ///
    /// List all notifications for the current user, sorted by most recently updated.
    ///
    /// - Remark: HTTP `GET /notifications`.
    /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)`.
    public enum ActivityListNotificationsForAuthenticatedUser {
        public static let id: Swift.String = "activity/list-notifications-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If `true`, show notifications marked as read.
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/all`.
                public var all: Components.Parameters.All?
                /// If `true`, only shows notifications in which the user is directly participating or mentioned.
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/participating`.
                public var participating: Components.Parameters.Participating?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/before`.
                public var before: Components.Parameters.Before?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 50). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/notifications/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - all: If `true`, show notifications marked as read.
                ///   - participating: If `true`, only shows notifications in which the user is directly participating or mentioned.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - before: Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 50). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    all: Components.Parameters.All? = nil,
                    participating: Components.Parameters.Participating? = nil,
                    since: Components.Parameters.Since? = nil,
                    before: Components.Parameters.Before? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.all = all
                    self.participating = participating
                    self.since = since
                    self.before = before
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/notifications/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListNotificationsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListNotificationsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListNotificationsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/notifications/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Thread])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Thread] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListNotificationsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//notifications/get(activity/list-notifications-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Mark notifications as read
    ///
    /// Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /notifications`.
    /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)`.
    public enum ActivityMarkNotificationsAsRead {
        public static let id: Swift.String = "activity/mark-notifications-as-read"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkNotificationsAsRead.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkNotificationsAsRead.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityMarkNotificationsAsRead.Input.Headers
            /// - Remark: Generated from `#/paths/notifications/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
                    ///
                    /// - Remark: Generated from `#/paths/notifications/PUT/requestBody/json/last_read_at`.
                    public var lastReadAt: Foundation.Date?
                    /// Whether the notification has been read.
                    ///
                    /// - Remark: Generated from `#/paths/notifications/PUT/requestBody/json/read`.
                    public var read: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - lastReadAt: Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
                    ///   - read: Whether the notification has been read.
                    public init(
                        lastReadAt: Foundation.Date? = nil,
                        read: Swift.Bool? = nil
                    ) {
                        self.lastReadAt = lastReadAt
                        self.read = read
                    }
                    public enum CodingKeys: String, CodingKey {
                        case lastReadAt = "last_read_at"
                        case read
                    }
                }
                /// - Remark: Generated from `#/paths/notifications/PUT/requestBody/content/application\/json`.
                case json(Operations.ActivityMarkNotificationsAsRead.Input.Body.JsonPayload)
            }
            public var body: Operations.ActivityMarkNotificationsAsRead.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.ActivityMarkNotificationsAsRead.Input.Headers = .init(),
                body: Operations.ActivityMarkNotificationsAsRead.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/PUT/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/PUT/responses/202/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/notifications/PUT/responses/202/content/json/message`.
                        public var message: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        public init(message: Swift.String? = nil) {
                            self.message = message
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                        }
                    }
                    /// - Remark: Generated from `#/paths/notifications/PUT/responses/202/content/application\/json`.
                    case json(Operations.ActivityMarkNotificationsAsRead.Output.Accepted.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActivityMarkNotificationsAsRead.Output.Accepted.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityMarkNotificationsAsRead.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityMarkNotificationsAsRead.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.ActivityMarkNotificationsAsRead.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.ActivityMarkNotificationsAsRead.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            public struct ResetContent: Sendable, Hashable {
                /// Creates a new `ResetContent`.
                public init() {}
            }
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            case resetContent(Operations.ActivityMarkNotificationsAsRead.Output.ResetContent)
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            public static var resetContent: Self {
                .resetContent(.init())
            }
            /// The associated value of the enum case if `self` is `.resetContent`.
            ///
            /// - Throws: An error if `self` is not `.resetContent`.
            /// - SeeAlso: `.resetContent`.
            public var resetContent: Operations.ActivityMarkNotificationsAsRead.Output.ResetContent {
                get throws {
                    switch self {
                    case let .resetContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "resetContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/put(activity/mark-notifications-as-read)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a thread
    ///
    /// Gets information about a notification thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)`.
    public enum ActivityGetThread {
        public static let id: Swift.String = "activity/get-thread"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/GET/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivityGetThread.Input.Path
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetThread.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetThread.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityGetThread.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityGetThread.Input.Path,
                headers: Operations.ActivityGetThread.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Thread)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Thread {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityGetThread.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityGetThread.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityGetThread.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityGetThread.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/get(activity/get-thread)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Mark a thread as read
    ///
    /// Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub: https://github.com/notifications.
    ///
    /// - Remark: HTTP `PATCH /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)`.
    public enum ActivityMarkThreadAsRead {
        public static let id: Swift.String = "activity/mark-thread-as-read"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/PATCH/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivityMarkThreadAsRead.Input.Path
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkThreadAsRead.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkThreadAsRead.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityMarkThreadAsRead.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityMarkThreadAsRead.Input.Path,
                headers: Operations.ActivityMarkThreadAsRead.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct ResetContent: Sendable, Hashable {
                /// Creates a new `ResetContent`.
                public init() {}
            }
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            case resetContent(Operations.ActivityMarkThreadAsRead.Output.ResetContent)
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            public static var resetContent: Self {
                .resetContent(.init())
            }
            /// The associated value of the enum case if `self` is `.resetContent`.
            ///
            /// - Throws: An error if `self` is not `.resetContent`.
            /// - SeeAlso: `.resetContent`.
            public var resetContent: Operations.ActivityMarkThreadAsRead.Output.ResetContent {
                get throws {
                    switch self {
                    case let .resetContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "resetContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/patch(activity/mark-thread-as-read)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Mark a thread as done
    ///
    /// Marks a thread as "done." Marking a thread as "done" is equivalent to marking a notification in your notification inbox on GitHub as done: https://github.com/notifications.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/delete(activity/mark-thread-as-done)`.
    public enum ActivityMarkThreadAsDone {
        public static let id: Swift.String = "activity/mark-thread-as-done"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/DELETE/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivityMarkThreadAsDone.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ActivityMarkThreadAsDone.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No content
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/delete(activity/mark-thread-as-done)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityMarkThreadAsDone.Output.NoContent)
            /// No content
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/delete(activity/mark-thread-as-done)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityMarkThreadAsDone.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get a thread subscription for the authenticated user
    ///
    /// This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/activity/watching#get-a-repository-subscription).
    ///
    /// Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
    ///
    /// - Remark: HTTP `GET /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)`.
    public enum ActivityGetThreadSubscriptionForAuthenticatedUser {
        public static let id: Swift.String = "activity/get-thread-subscription-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/GET/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Path,
                headers: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ThreadSubscription)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ThreadSubscription {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityGetThreadSubscriptionForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/get(activity/get-thread-subscription-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set a thread subscription
    ///
    /// If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
    ///
    /// You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
    ///
    /// Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription) endpoint.
    ///
    /// - Remark: HTTP `PUT /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)`.
    public enum ActivitySetThreadSubscription {
        public static let id: Swift.String = "activity/set-thread-subscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivitySetThreadSubscription.Input.Path
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivitySetThreadSubscription.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivitySetThreadSubscription.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivitySetThreadSubscription.Input.Headers
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Whether to block all notifications from a thread.
                    ///
                    /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/requestBody/json/ignored`.
                    public var ignored: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - ignored: Whether to block all notifications from a thread.
                    public init(ignored: Swift.Bool? = nil) {
                        self.ignored = ignored
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ignored
                    }
                }
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/requestBody/content/application\/json`.
                case json(Operations.ActivitySetThreadSubscription.Input.Body.JsonPayload)
            }
            public var body: Operations.ActivitySetThreadSubscription.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActivitySetThreadSubscription.Input.Path,
                headers: Operations.ActivitySetThreadSubscription.Input.Headers = .init(),
                body: Operations.ActivitySetThreadSubscription.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.ThreadSubscription)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ThreadSubscription {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivitySetThreadSubscription.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivitySetThreadSubscription.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivitySetThreadSubscription.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivitySetThreadSubscription.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/put(activity/set-thread-subscription)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a thread subscription
    ///
    /// Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.
    ///
    /// - Remark: HTTP `DELETE /notifications/threads/{thread_id}/subscription`.
    /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)`.
    public enum ActivityDeleteThreadSubscription {
        public static let id: Swift.String = "activity/delete-thread-subscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                ///
                /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/DELETE/path/thread_id`.
                public var threadId: Components.Parameters.ThreadId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - threadId: The unique identifier of the notification thread. This corresponds to the value returned in the `id` field when you retrieve notifications (for example with the [`GET /notifications` operation](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user)).
                public init(threadId: Components.Parameters.ThreadId) {
                    self.threadId = threadId
                }
            }
            public var path: Operations.ActivityDeleteThreadSubscription.Input.Path
            /// - Remark: Generated from `#/paths/notifications/threads/{thread_id}/subscription/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityDeleteThreadSubscription.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityDeleteThreadSubscription.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityDeleteThreadSubscription.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityDeleteThreadSubscription.Input.Path,
                headers: Operations.ActivityDeleteThreadSubscription.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityDeleteThreadSubscription.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityDeleteThreadSubscription.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//notifications/threads/{thread_id}/subscription/delete(activity/delete-thread-subscription)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public organization events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/events`.
    /// - Remark: Generated from `#/paths//orgs/{org}/events/get(activity/list-public-org-events)`.
    public enum ActivityListPublicOrgEvents {
        public static let id: Swift.String = "activity/list-public-org-events"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.ActivityListPublicOrgEvents.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListPublicOrgEvents.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicOrgEvents.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicOrgEvents.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListPublicOrgEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListPublicOrgEvents.Input.Path,
                query: Operations.ActivityListPublicOrgEvents.Input.Query = .init(),
                headers: Operations.ActivityListPublicOrgEvents.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListPublicOrgEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListPublicOrgEvents.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/events/get(activity/list-public-org-events)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListPublicOrgEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListPublicOrgEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository events
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/events`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/events/get(activity/list-repo-events)`.
    public enum ActivityListRepoEvents {
        public static let id: Swift.String = "activity/list-repo-events"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityListRepoEvents.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListRepoEvents.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListRepoEvents.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListRepoEvents.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListRepoEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListRepoEvents.Input.Path,
                query: Operations.ActivityListRepoEvents.Input.Query = .init(),
                headers: Operations.ActivityListRepoEvents.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListRepoEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListRepoEvents.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/events/get(activity/list-repo-events)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListRepoEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListRepoEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository notifications for the authenticated user
    ///
    /// Lists all notifications for the current user in the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/get(activity/list-repo-notifications-for-authenticated-user)`.
    public enum ActivityListRepoNotificationsForAuthenticatedUser {
        public static let id: Swift.String = "activity/list-repo-notifications-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If `true`, show notifications marked as read.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/all`.
                public var all: Components.Parameters.All?
                /// If `true`, only shows notifications in which the user is directly participating or mentioned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/participating`.
                public var participating: Components.Parameters.Participating?
                /// Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/since`.
                public var since: Components.Parameters.Since?
                /// Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/before`.
                public var before: Components.Parameters.Before?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - all: If `true`, show notifications marked as read.
                ///   - participating: If `true`, only shows notifications in which the user is directly participating or mentioned.
                ///   - since: Only show results that were last updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - before: Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    all: Components.Parameters.All? = nil,
                    participating: Components.Parameters.Participating? = nil,
                    since: Components.Parameters.Since? = nil,
                    before: Components.Parameters.Before? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.all = all
                    self.participating = participating
                    self.since = since
                    self.before = before
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListRepoNotificationsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListRepoNotificationsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Path,
                query: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Thread])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Thread] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/get(activity/list-repo-notifications-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListRepoNotificationsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Mark repository notifications as read
    ///
    /// Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/notifications`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)`.
    public enum ActivityMarkRepoNotificationsAsRead {
        public static let id: Swift.String = "activity/mark-repo-notifications-as-read"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityMarkRepoNotificationsAsRead.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkRepoNotificationsAsRead.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityMarkRepoNotificationsAsRead.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityMarkRepoNotificationsAsRead.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/requestBody/json/last_read_at`.
                    public var lastReadAt: Foundation.Date?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - lastReadAt: Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
                    public init(lastReadAt: Foundation.Date? = nil) {
                        self.lastReadAt = lastReadAt
                    }
                    public enum CodingKeys: String, CodingKey {
                        case lastReadAt = "last_read_at"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/requestBody/content/application\/json`.
                case json(Operations.ActivityMarkRepoNotificationsAsRead.Input.Body.JsonPayload)
            }
            public var body: Operations.ActivityMarkRepoNotificationsAsRead.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActivityMarkRepoNotificationsAsRead.Input.Path,
                headers: Operations.ActivityMarkRepoNotificationsAsRead.Input.Headers = .init(),
                body: Operations.ActivityMarkRepoNotificationsAsRead.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/responses/202/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/responses/202/content/json/message`.
                        public var message: Swift.String?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/responses/202/content/json/url`.
                        public var url: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - message:
                        ///   - url:
                        public init(
                            message: Swift.String? = nil,
                            url: Swift.String? = nil
                        ) {
                            self.message = message
                            self.url = url
                        }
                        public enum CodingKeys: String, CodingKey {
                            case message
                            case url
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/notifications/PUT/responses/202/content/application\/json`.
                    case json(Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.ActivityMarkRepoNotificationsAsRead.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            public struct ResetContent: Sendable, Hashable {
                /// Creates a new `ResetContent`.
                public init() {}
            }
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            case resetContent(Operations.ActivityMarkRepoNotificationsAsRead.Output.ResetContent)
            /// Reset Content
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/notifications/put(activity/mark-repo-notifications-as-read)/responses/205`.
            ///
            /// HTTP response code: `205 resetContent`.
            public static var resetContent: Self {
                .resetContent(.init())
            }
            /// The associated value of the enum case if `self` is `.resetContent`.
            ///
            /// - Throws: An error if `self` is not `.resetContent`.
            /// - SeeAlso: `.resetContent`.
            public var resetContent: Operations.ActivityMarkRepoNotificationsAsRead.Output.ResetContent {
                get throws {
                    switch self {
                    case let .resetContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "resetContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List stargazers
    ///
    /// Lists the people that have starred the repository.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stargazers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stargazers/get(activity/list-stargazers-for-repo)`.
    public enum ActivityListStargazersForRepo {
        public static let id: Swift.String = "activity/list-stargazers-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityListStargazersForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListStargazersForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListStargazersForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListStargazersForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListStargazersForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListStargazersForRepo.Input.Path,
                query: Operations.ActivityListStargazersForRepo.Input.Query = .init(),
                headers: Operations.ActivityListStargazersForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListStargazersForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/content/json/value1`.
                        public var value1: [Components.Schemas.SimpleUser]?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/content/json/value2`.
                        public var value2: [Components.Schemas.Stargazer]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: [Components.Schemas.SimpleUser]? = nil,
                            value2: [Components.Schemas.Stargazer]? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeFirstNonNilValueToSingleValueContainer([
                                self.value1,
                                self.value2
                            ])
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/stargazers/GET/responses/200/content/application\/json`.
                    case json(Operations.ActivityListStargazersForRepo.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActivityListStargazersForRepo.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListStargazersForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListStargazersForRepo.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListStargazersForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stargazers/get(activity/list-stargazers-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListStargazersForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListStargazersForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stargazers/get(activity/list-stargazers-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List watchers
    ///
    /// Lists the people watching the specified repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscribers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscribers/get(activity/list-watchers-for-repo)`.
    public enum ActivityListWatchersForRepo {
        public static let id: Swift.String = "activity/list-watchers-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityListWatchersForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListWatchersForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListWatchersForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListWatchersForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListWatchersForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListWatchersForRepo.Input.Path,
                query: Operations.ActivityListWatchersForRepo.Input.Query = .init(),
                headers: Operations.ActivityListWatchersForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListWatchersForRepo.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscribers/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListWatchersForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListWatchersForRepo.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListWatchersForRepo.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscribers/get(activity/list-watchers-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListWatchersForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListWatchersForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository subscription
    ///
    /// Gets information about whether the authenticated user is subscribed to the repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)`.
    public enum ActivityGetRepoSubscription {
        public static let id: Swift.String = "activity/get-repo-subscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityGetRepoSubscription.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetRepoSubscription.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityGetRepoSubscription.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityGetRepoSubscription.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityGetRepoSubscription.Input.Path,
                headers: Operations.ActivityGetRepoSubscription.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RepositorySubscription)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositorySubscription {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityGetRepoSubscription.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityGetRepoSubscription.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// if you subscribe to the repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityGetRepoSubscription.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityGetRepoSubscription.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Not Found if you don't subscribe to the repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.ActivityGetRepoSubscription.Output.NotFound)
            /// Not Found if you don't subscribe to the repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.ActivityGetRepoSubscription.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/get(activity/get-repo-subscription)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set a repository subscription
    ///
    /// If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/activity/watching#delete-a-repository-subscription) completely.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/put(activity/set-repo-subscription)`.
    public enum ActivitySetRepoSubscription {
        public static let id: Swift.String = "activity/set-repo-subscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivitySetRepoSubscription.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivitySetRepoSubscription.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivitySetRepoSubscription.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivitySetRepoSubscription.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Determines if notifications should be received from this repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/requestBody/json/subscribed`.
                    public var subscribed: Swift.Bool?
                    /// Determines if all notifications should be blocked from this repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/requestBody/json/ignored`.
                    public var ignored: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subscribed: Determines if notifications should be received from this repository.
                    ///   - ignored: Determines if all notifications should be blocked from this repository.
                    public init(
                        subscribed: Swift.Bool? = nil,
                        ignored: Swift.Bool? = nil
                    ) {
                        self.subscribed = subscribed
                        self.ignored = ignored
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subscribed
                        case ignored
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/requestBody/content/application\/json`.
                case json(Operations.ActivitySetRepoSubscription.Input.Body.JsonPayload)
            }
            public var body: Operations.ActivitySetRepoSubscription.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.ActivitySetRepoSubscription.Input.Path,
                headers: Operations.ActivitySetRepoSubscription.Input.Headers = .init(),
                body: Operations.ActivitySetRepoSubscription.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.RepositorySubscription)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositorySubscription {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivitySetRepoSubscription.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivitySetRepoSubscription.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/put(activity/set-repo-subscription)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivitySetRepoSubscription.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivitySetRepoSubscription.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a repository subscription
    ///
    /// This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/activity/watching#set-a-repository-subscription).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/subscription`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/delete(activity/delete-repo-subscription)`.
    public enum ActivityDeleteRepoSubscription {
        public static let id: Swift.String = "activity/delete-repo-subscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/subscription/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityDeleteRepoSubscription.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.ActivityDeleteRepoSubscription.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/delete(activity/delete-repo-subscription)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityDeleteRepoSubscription.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/subscription/delete(activity/delete-repo-subscription)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityDeleteRepoSubscription.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List repositories starred by the authenticated user
    ///
    /// Lists repositories the authenticated user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /user/starred`.
    /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)`.
    public enum ActivityListReposStarredByAuthenticatedUser {
        public static let id: Swift.String = "activity/list-repos-starred-by-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/starred/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort-starred`.
                @frozen public enum SortStarred: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to.
                ///
                /// - Remark: Generated from `#/paths/user/starred/GET/query/sort`.
                public var sort: Components.Parameters.SortStarred?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/user/starred/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/starred/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/starred/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to.
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.SortStarred? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/starred/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposStarredByAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposStarredByAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListReposStarredByAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/starred/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/starred/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/starred/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/starred/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Repository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Repository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "application/json",
                                    body: self
                                )
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/starred/GET/responses/200/content/application\/vnd.github.v3.star+json`.
                    case applicationVnd_github_v3_starJson([Components.Schemas.StarredRepository])
                    /// The associated value of the enum case if `self` is `.applicationVnd_github_v3_starJson`.
                    ///
                    /// - Throws: An error if `self` is not `.applicationVnd_github_v3_starJson`.
                    /// - SeeAlso: `.applicationVnd_github_v3_starJson`.
                    public var applicationVnd_github_v3_starJson: [Components.Schemas.StarredRepository] {
                        get throws {
                            switch self {
                            case let .applicationVnd_github_v3_starJson(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "application/vnd.github.v3.star+json",
                                    body: self
                                )
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListReposStarredByAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/starred/get(activity/list-repos-starred-by-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationVnd_github_v3_starJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/vnd.github.v3.star+json":
                    self = .applicationVnd_github_v3_starJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationVnd_github_v3_starJson:
                    return "application/vnd.github.v3.star+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationVnd_github_v3_starJson
                ]
            }
        }
    }
    /// Check if a repository is starred by the authenticated user
    ///
    /// Whether the authenticated user has starred the repository.
    ///
    /// - Remark: HTTP `GET /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)`.
    public enum ActivityCheckRepoIsStarredByAuthenticatedUser {
        public static let id: Swift.String = "activity/check-repo-is-starred-by-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Path,
                headers: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response if this repository is starred by you
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NoContent)
            /// Response if this repository is starred by you
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// Not Found if this repository is not starred by you
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.ActivityCheckRepoIsStarredByAuthenticatedUser.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/get(activity/check-repo-is-starred-by-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Star a repository for the authenticated user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// - Remark: HTTP `PUT /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)`.
    public enum ActivityStarRepoForAuthenticatedUser {
        public static let id: Swift.String = "activity/star-repo-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityStarRepoForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityStarRepoForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityStarRepoForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityStarRepoForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityStarRepoForAuthenticatedUser.Input.Path,
                headers: Operations.ActivityStarRepoForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityStarRepoForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityStarRepoForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/put(activity/star-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unstar a repository for the authenticated user
    ///
    /// Unstar a repository that the authenticated user has previously starred.
    ///
    /// - Remark: HTTP `DELETE /user/starred/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)`.
    public enum ActivityUnstarRepoForAuthenticatedUser {
        public static let id: Swift.String = "activity/unstar-repo-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/starred/{owner}/{repo}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityUnstarRepoForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityUnstarRepoForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Path,
                headers: Operations.ActivityUnstarRepoForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.ActivityUnstarRepoForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.ActivityUnstarRepoForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/starred/{owner}/{repo}/delete(activity/unstar-repo-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories watched by the authenticated user
    ///
    /// Lists repositories the authenticated user is watching.
    ///
    /// - Remark: HTTP `GET /user/subscriptions`.
    /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)`.
    public enum ActivityListWatchedReposForAuthenticatedUser {
        public static let id: Swift.String = "activity/list-watched-repos-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/subscriptions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/subscriptions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/subscriptions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/subscriptions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListWatchedReposForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListWatchedReposForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListWatchedReposForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/subscriptions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/subscriptions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/subscriptions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/subscriptions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListWatchedReposForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/subscriptions/get(activity/list-watched-repos-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List events for the authenticated user
    ///
    /// If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. _Optional_: use the fine-grained token with following permission set to view private events: "Events" user permissions (read).
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events`.
    /// - Remark: Generated from `#/paths//users/{username}/events/get(activity/list-events-for-authenticated-user)`.
    public enum ActivityListEventsForAuthenticatedUser {
        public static let id: Swift.String = "activity/list-events-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListEventsForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListEventsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListEventsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListEventsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListEventsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListEventsForAuthenticatedUser.Input.Path,
                query: Operations.ActivityListEventsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListEventsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListEventsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListEventsForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/events/get(activity/list-events-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListEventsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListEventsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization events for the authenticated user
    ///
    /// This is the user's organization dashboard. You must be authenticated as the user to view this.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/orgs/{org}`.
    /// - Remark: Generated from `#/paths//users/{username}/events/orgs/{org}/get(activity/list-org-events-for-authenticated-user)`.
    public enum ActivityListOrgEventsForAuthenticatedUser {
        public static let id: Swift.String = "activity/list-org-events-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                ///   - org: The organization name. The name is not case sensitive.
                public init(
                    username: Components.Parameters.Username,
                    org: Components.Parameters.Org
                ) {
                    self.username = username
                    self.org = org
                }
            }
            public var path: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListOrgEventsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListOrgEventsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Path,
                query: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.ActivityListOrgEventsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/events/orgs/{org}/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListOrgEventsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListOrgEventsForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/events/orgs/{org}/get(activity/list-org-events-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListOrgEventsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListOrgEventsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public events for a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/events/public/get(activity/list-public-events-for-user)`.
    public enum ActivityListPublicEventsForUser {
        public static let id: Swift.String = "activity/list-public-events-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListPublicEventsForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListPublicEventsForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEventsForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListPublicEventsForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListPublicEventsForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListPublicEventsForUser.Input.Path,
                query: Operations.ActivityListPublicEventsForUser.Input.Query = .init(),
                headers: Operations.ActivityListPublicEventsForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/events/public/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListPublicEventsForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListPublicEventsForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/events/public/get(activity/list-public-events-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListPublicEventsForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListPublicEventsForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List events received by the authenticated user
    ///
    /// These are events that you've received by watching repositories and following users. If you are authenticated as the
    /// given user, you will see private events. Otherwise, you'll only see public events.
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/get(activity/list-received-events-for-user)`.
    public enum ActivityListReceivedEventsForUser {
        public static let id: Swift.String = "activity/list-received-events-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListReceivedEventsForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListReceivedEventsForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReceivedEventsForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReceivedEventsForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListReceivedEventsForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListReceivedEventsForUser.Input.Path,
                query: Operations.ActivityListReceivedEventsForUser.Input.Query = .init(),
                headers: Operations.ActivityListReceivedEventsForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/received_events/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListReceivedEventsForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListReceivedEventsForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/received_events/get(activity/list-received-events-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListReceivedEventsForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListReceivedEventsForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public events received by a user
    ///
    /// > [!NOTE]
    /// > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.
    ///
    /// - Remark: HTTP `GET /users/{username}/received_events/public`.
    /// - Remark: Generated from `#/paths//users/{username}/received_events/public/get(activity/list-received-public-events-for-user)`.
    public enum ActivityListReceivedPublicEventsForUser {
        public static let id: Swift.String = "activity/list-received-public-events-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListReceivedPublicEventsForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListReceivedPublicEventsForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReceivedPublicEventsForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReceivedPublicEventsForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListReceivedPublicEventsForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListReceivedPublicEventsForUser.Input.Path,
                query: Operations.ActivityListReceivedPublicEventsForUser.Input.Query = .init(),
                headers: Operations.ActivityListReceivedPublicEventsForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/received_events/public/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Event])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Event] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListReceivedPublicEventsForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.ActivityListReceivedPublicEventsForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/received_events/public/get(activity/list-received-public-events-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListReceivedPublicEventsForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListReceivedPublicEventsForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories starred by a user
    ///
    /// Lists repositories a user has starred.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.
    ///
    /// - Remark: HTTP `GET /users/{username}/starred`.
    /// - Remark: Generated from `#/paths//users/{username}/starred/get(activity/list-repos-starred-by-user)`.
    public enum ActivityListReposStarredByUser {
        public static let id: Swift.String = "activity/list-repos-starred-by-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/starred/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListReposStarredByUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/starred/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/sort-starred`.
                @frozen public enum SortStarred: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/query/sort`.
                public var sort: Components.Parameters.SortStarred?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - sort: The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to.
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    sort: Components.Parameters.SortStarred? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListReposStarredByUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/starred/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposStarredByUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposStarredByUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListReposStarredByUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListReposStarredByUser.Input.Path,
                query: Operations.ActivityListReposStarredByUser.Input.Query = .init(),
                headers: Operations.ActivityListReposStarredByUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListReposStarredByUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/content/json/value1`.
                        public var value1: [Components.Schemas.StarredRepository]?
                        /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/content/json/value2`.
                        public var value2: [Components.Schemas.Repository]?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: [Components.Schemas.StarredRepository]? = nil,
                            value2: [Components.Schemas.Repository]? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeFirstNonNilValueToSingleValueContainer([
                                self.value1,
                                self.value2
                            ])
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/starred/GET/responses/200/content/application\/json`.
                    case json(Operations.ActivityListReposStarredByUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.ActivityListReposStarredByUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListReposStarredByUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListReposStarredByUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListReposStarredByUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/starred/get(activity/list-repos-starred-by-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListReposStarredByUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListReposStarredByUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories watched by a user
    ///
    /// Lists repositories a user is watching.
    ///
    /// - Remark: HTTP `GET /users/{username}/subscriptions`.
    /// - Remark: Generated from `#/paths//users/{username}/subscriptions/get(activity/list-repos-watched-by-user)`.
    public enum ActivityListReposWatchedByUser {
        public static let id: Swift.String = "activity/list-repos-watched-by-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.ActivityListReposWatchedByUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.ActivityListReposWatchedByUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposWatchedByUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.ActivityListReposWatchedByUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.ActivityListReposWatchedByUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.ActivityListReposWatchedByUser.Input.Path,
                query: Operations.ActivityListReposWatchedByUser.Input.Query = .init(),
                headers: Operations.ActivityListReposWatchedByUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.ActivityListReposWatchedByUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/subscriptions/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.ActivityListReposWatchedByUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.ActivityListReposWatchedByUser.Output.Ok.Headers = .init(),
                    body: Operations.ActivityListReposWatchedByUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/subscriptions/get(activity/list-repos-watched-by-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.ActivityListReposWatchedByUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.ActivityListReposWatchedByUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
