// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.
    ///
    /// - Remark: HTTP `GET /user`.
    /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)`.
    func usersGetAuthenticated(_ input: Operations.UsersGetAuthenticated.Input) async throws -> Operations.UsersGetAuthenticated.Output
    /// Update the authenticated user
    ///
    /// **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
    ///
    /// - Remark: HTTP `PATCH /user`.
    /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)`.
    func usersUpdateAuthenticated(_ input: Operations.UsersUpdateAuthenticated.Input) async throws -> Operations.UsersUpdateAuthenticated.Output
    /// List users blocked by the authenticated user
    ///
    /// List the users you've blocked on your personal account.
    ///
    /// - Remark: HTTP `GET /user/blocks`.
    /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)`.
    func usersListBlockedByAuthenticatedUser(_ input: Operations.UsersListBlockedByAuthenticatedUser.Input) async throws -> Operations.UsersListBlockedByAuthenticatedUser.Output
    /// Check if a user is blocked by the authenticated user
    ///
    /// Returns a 204 if the given user is blocked by the authenticated user. Returns a 404 if the given user is not blocked by the authenticated user, or if the given user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)`.
    func usersCheckBlocked(_ input: Operations.UsersCheckBlocked.Input) async throws -> Operations.UsersCheckBlocked.Output
    /// Block a user
    ///
    /// Blocks the given user and returns a 204. If the authenticated user cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)`.
    func usersBlock(_ input: Operations.UsersBlock.Input) async throws -> Operations.UsersBlock.Output
    /// Unblock a user
    ///
    /// Unblocks the given user and returns a 204.
    ///
    /// - Remark: HTTP `DELETE /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)`.
    func usersUnblock(_ input: Operations.UsersUnblock.Input) async throws -> Operations.UsersUnblock.Output
    /// Set primary email visibility for the authenticated user
    ///
    /// Sets the visibility for your primary email addresses.
    ///
    /// - Remark: HTTP `PATCH /user/email/visibility`.
    /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)`.
    func usersSetPrimaryEmailVisibilityForAuthenticatedUser(_ input: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input) async throws -> Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output
    /// List email addresses for the authenticated user
    ///
    /// Lists all of your email addresses, and specifies which one is visible
    /// to the public.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)`.
    func usersListEmailsForAuthenticatedUser(_ input: Operations.UsersListEmailsForAuthenticatedUser.Input) async throws -> Operations.UsersListEmailsForAuthenticatedUser.Output
    /// Add an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)`.
    func usersAddEmailForAuthenticatedUser(_ input: Operations.UsersAddEmailForAuthenticatedUser.Input) async throws -> Operations.UsersAddEmailForAuthenticatedUser.Output
    /// Delete an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)`.
    func usersDeleteEmailForAuthenticatedUser(_ input: Operations.UsersDeleteEmailForAuthenticatedUser.Input) async throws -> Operations.UsersDeleteEmailForAuthenticatedUser.Output
    /// List followers of the authenticated user
    ///
    /// Lists the people following the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/followers`.
    /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)`.
    func usersListFollowersForAuthenticatedUser(_ input: Operations.UsersListFollowersForAuthenticatedUser.Input) async throws -> Operations.UsersListFollowersForAuthenticatedUser.Output
    /// List the people the authenticated user follows
    ///
    /// Lists the people who the authenticated user follows.
    ///
    /// - Remark: HTTP `GET /user/following`.
    /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)`.
    func usersListFollowedByAuthenticatedUser(_ input: Operations.UsersListFollowedByAuthenticatedUser.Input) async throws -> Operations.UsersListFollowedByAuthenticatedUser.Output
    /// Check if a person is followed by the authenticated user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)`.
    func usersCheckPersonIsFollowedByAuthenticated(_ input: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input) async throws -> Operations.UsersCheckPersonIsFollowedByAuthenticated.Output
    /// Follow a user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)`.
    func usersFollow(_ input: Operations.UsersFollow.Input) async throws -> Operations.UsersFollow.Output
    /// Unfollow a user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)`.
    func usersUnfollow(_ input: Operations.UsersUnfollow.Input) async throws -> Operations.UsersUnfollow.Output
    /// List GPG keys for the authenticated user
    ///
    /// Lists the current user's GPG keys.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)`.
    func usersListGpgKeysForAuthenticatedUser(_ input: Operations.UsersListGpgKeysForAuthenticatedUser.Input) async throws -> Operations.UsersListGpgKeysForAuthenticatedUser.Output
    /// Create a GPG key for the authenticated user
    ///
    /// Adds a GPG key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)`.
    func usersCreateGpgKeyForAuthenticatedUser(_ input: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input) async throws -> Operations.UsersCreateGpgKeyForAuthenticatedUser.Output
    /// Get a GPG key for the authenticated user
    ///
    /// View extended details for a single GPG key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)`.
    func usersGetGpgKeyForAuthenticatedUser(_ input: Operations.UsersGetGpgKeyForAuthenticatedUser.Input) async throws -> Operations.UsersGetGpgKeyForAuthenticatedUser.Output
    /// Delete a GPG key for the authenticated user
    ///
    /// Removes a GPG key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)`.
    func usersDeleteGpgKeyForAuthenticatedUser(_ input: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input) async throws -> Operations.UsersDeleteGpgKeyForAuthenticatedUser.Output
    /// List public SSH keys for the authenticated user
    ///
    /// Lists the public SSH keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)`.
    func usersListPublicSshKeysForAuthenticatedUser(_ input: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input) async throws -> Operations.UsersListPublicSshKeysForAuthenticatedUser.Output
    /// Create a public SSH key for the authenticated user
    ///
    /// Adds a public SSH key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)`.
    func usersCreatePublicSshKeyForAuthenticatedUser(_ input: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input) async throws -> Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output
    /// Get a public SSH key for the authenticated user
    ///
    /// View extended details for a single public SSH key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)`.
    func usersGetPublicSshKeyForAuthenticatedUser(_ input: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input) async throws -> Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output
    /// Delete a public SSH key for the authenticated user
    ///
    /// Removes a public SSH key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)`.
    func usersDeletePublicSshKeyForAuthenticatedUser(_ input: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input) async throws -> Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Output
    /// List public email addresses for the authenticated user
    ///
    /// Lists your publicly visible email address, which you can set with the
    /// [Set primary email visibility for the authenticated user](https://docs.github.com/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
    /// endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/public_emails`.
    /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)`.
    func usersListPublicEmailsForAuthenticatedUser(_ input: Operations.UsersListPublicEmailsForAuthenticatedUser.Input) async throws -> Operations.UsersListPublicEmailsForAuthenticatedUser.Output
    /// List social accounts for the authenticated user
    ///
    /// Lists all of your social accounts.
    ///
    /// - Remark: HTTP `GET /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)`.
    func usersListSocialAccountsForAuthenticatedUser(_ input: Operations.UsersListSocialAccountsForAuthenticatedUser.Input) async throws -> Operations.UsersListSocialAccountsForAuthenticatedUser.Output
    /// Add social accounts for the authenticated user
    ///
    /// Add one or more social accounts to the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)`.
    func usersAddSocialAccountForAuthenticatedUser(_ input: Operations.UsersAddSocialAccountForAuthenticatedUser.Input) async throws -> Operations.UsersAddSocialAccountForAuthenticatedUser.Output
    /// Delete social accounts for the authenticated user
    ///
    /// Deletes one or more social accounts from the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)`.
    func usersDeleteSocialAccountForAuthenticatedUser(_ input: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input) async throws -> Operations.UsersDeleteSocialAccountForAuthenticatedUser.Output
    /// List SSH signing keys for the authenticated user
    ///
    /// Lists the SSH signing keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)`.
    func usersListSshSigningKeysForAuthenticatedUser(_ input: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input) async throws -> Operations.UsersListSshSigningKeysForAuthenticatedUser.Output
    /// Create a SSH signing key for the authenticated user
    ///
    /// Creates an SSH signing key for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)`.
    func usersCreateSshSigningKeyForAuthenticatedUser(_ input: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input) async throws -> Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output
    /// Get an SSH signing key for the authenticated user
    ///
    /// Gets extended details for an SSH signing key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)`.
    func usersGetSshSigningKeyForAuthenticatedUser(_ input: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input) async throws -> Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output
    /// Delete an SSH signing key for the authenticated user
    ///
    /// Deletes an SSH signing key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)`.
    func usersDeleteSshSigningKeyForAuthenticatedUser(_ input: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input) async throws -> Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Output
    /// Get a user using their ID
    ///
    /// Provides publicly available information about someone with a GitHub account. This method takes their durable user `ID` instead of their `login`, which can change over time.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /user/{account_id}`.
    /// - Remark: Generated from `#/paths//user/{account_id}/get(users/get-by-id)`.
    func usersGetById(_ input: Operations.UsersGetById.Input) async throws -> Operations.UsersGetById.Output
    /// List users
    ///
    /// Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
    ///
    /// Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.
    ///
    /// - Remark: HTTP `GET /users`.
    /// - Remark: Generated from `#/paths//users/get(users/list)`.
    func usersList(_ input: Operations.UsersList.Input) async throws -> Operations.UsersList.Output
    /// Get a user
    ///
    /// Provides publicly available information about someone with a GitHub account.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /users/{username}`.
    /// - Remark: Generated from `#/paths//users/{username}/get(users/get-by-username)`.
    func usersGetByUsername(_ input: Operations.UsersGetByUsername.Input) async throws -> Operations.UsersGetByUsername.Output
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/bulk-list/post(users/list-attestations-bulk)`.
    func usersListAttestationsBulk(_ input: Operations.UsersListAttestationsBulk.Input) async throws -> Operations.UsersListAttestationsBulk.Output
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)`.
    func usersDeleteAttestationsBulk(_ input: Operations.UsersDeleteAttestationsBulk.Input) async throws -> Operations.UsersDeleteAttestationsBulk.Output
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)`.
    func usersDeleteAttestationsBySubjectDigest(_ input: Operations.UsersDeleteAttestationsBySubjectDigest.Input) async throws -> Operations.UsersDeleteAttestationsBySubjectDigest.Output
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by a user.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)`.
    func usersDeleteAttestationsById(_ input: Operations.UsersDeleteAttestationsById.Input) async throws -> Operations.UsersDeleteAttestationsById.Output
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /users/{username}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)`.
    func usersListAttestations(_ input: Operations.UsersListAttestations.Input) async throws -> Operations.UsersListAttestations.Output
    /// List followers of a user
    ///
    /// Lists the people following the specified user.
    ///
    /// - Remark: HTTP `GET /users/{username}/followers`.
    /// - Remark: Generated from `#/paths//users/{username}/followers/get(users/list-followers-for-user)`.
    func usersListFollowersForUser(_ input: Operations.UsersListFollowersForUser.Input) async throws -> Operations.UsersListFollowersForUser.Output
    /// List the people a user follows
    ///
    /// Lists the people who the specified user follows.
    ///
    /// - Remark: HTTP `GET /users/{username}/following`.
    /// - Remark: Generated from `#/paths//users/{username}/following/get(users/list-following-for-user)`.
    func usersListFollowingForUser(_ input: Operations.UsersListFollowingForUser.Input) async throws -> Operations.UsersListFollowingForUser.Output
    /// Check if a user follows another user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /users/{username}/following/{target_user}`.
    /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)`.
    func usersCheckFollowingForUser(_ input: Operations.UsersCheckFollowingForUser.Input) async throws -> Operations.UsersCheckFollowingForUser.Output
    /// List GPG keys for a user
    ///
    /// Lists the GPG keys for a user. This information is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/gpg_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/gpg_keys/get(users/list-gpg-keys-for-user)`.
    func usersListGpgKeysForUser(_ input: Operations.UsersListGpgKeysForUser.Input) async throws -> Operations.UsersListGpgKeysForUser.Output
    /// Get contextual information for a user
    ///
    /// Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
    ///
    ///   The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/hovercard`.
    /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)`.
    func usersGetContextForUser(_ input: Operations.UsersGetContextForUser.Input) async throws -> Operations.UsersGetContextForUser.Output
    /// List public keys for a user
    ///
    /// Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/keys`.
    /// - Remark: Generated from `#/paths//users/{username}/keys/get(users/list-public-keys-for-user)`.
    func usersListPublicKeysForUser(_ input: Operations.UsersListPublicKeysForUser.Input) async throws -> Operations.UsersListPublicKeysForUser.Output
    /// List social accounts for a user
    ///
    /// Lists social media accounts for a user. This endpoint is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/social_accounts`.
    /// - Remark: Generated from `#/paths//users/{username}/social_accounts/get(users/list-social-accounts-for-user)`.
    func usersListSocialAccountsForUser(_ input: Operations.UsersListSocialAccountsForUser.Input) async throws -> Operations.UsersListSocialAccountsForUser.Output
    /// List SSH signing keys for a user
    ///
    /// Lists the SSH signing keys for a user. This operation is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/ssh_signing_keys/get(users/list-ssh-signing-keys-for-user)`.
    func usersListSshSigningKeysForUser(_ input: Operations.UsersListSshSigningKeysForUser.Input) async throws -> Operations.UsersListSshSigningKeysForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.
    ///
    /// - Remark: HTTP `GET /user`.
    /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)`.
    public func usersGetAuthenticated(headers: Operations.UsersGetAuthenticated.Input.Headers = .init()) async throws -> Operations.UsersGetAuthenticated.Output {
        try await usersGetAuthenticated(Operations.UsersGetAuthenticated.Input(headers: headers))
    }
    /// Update the authenticated user
    ///
    /// **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
    ///
    /// - Remark: HTTP `PATCH /user`.
    /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)`.
    public func usersUpdateAuthenticated(
        headers: Operations.UsersUpdateAuthenticated.Input.Headers = .init(),
        body: Operations.UsersUpdateAuthenticated.Input.Body? = nil
    ) async throws -> Operations.UsersUpdateAuthenticated.Output {
        try await usersUpdateAuthenticated(Operations.UsersUpdateAuthenticated.Input(
            headers: headers,
            body: body
        ))
    }
    /// List users blocked by the authenticated user
    ///
    /// List the users you've blocked on your personal account.
    ///
    /// - Remark: HTTP `GET /user/blocks`.
    /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)`.
    public func usersListBlockedByAuthenticatedUser(
        query: Operations.UsersListBlockedByAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListBlockedByAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListBlockedByAuthenticatedUser.Output {
        try await usersListBlockedByAuthenticatedUser(Operations.UsersListBlockedByAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Check if a user is blocked by the authenticated user
    ///
    /// Returns a 204 if the given user is blocked by the authenticated user. Returns a 404 if the given user is not blocked by the authenticated user, or if the given user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)`.
    public func usersCheckBlocked(
        path: Operations.UsersCheckBlocked.Input.Path,
        headers: Operations.UsersCheckBlocked.Input.Headers = .init()
    ) async throws -> Operations.UsersCheckBlocked.Output {
        try await usersCheckBlocked(Operations.UsersCheckBlocked.Input(
            path: path,
            headers: headers
        ))
    }
    /// Block a user
    ///
    /// Blocks the given user and returns a 204. If the authenticated user cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)`.
    public func usersBlock(
        path: Operations.UsersBlock.Input.Path,
        headers: Operations.UsersBlock.Input.Headers = .init()
    ) async throws -> Operations.UsersBlock.Output {
        try await usersBlock(Operations.UsersBlock.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unblock a user
    ///
    /// Unblocks the given user and returns a 204.
    ///
    /// - Remark: HTTP `DELETE /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)`.
    public func usersUnblock(
        path: Operations.UsersUnblock.Input.Path,
        headers: Operations.UsersUnblock.Input.Headers = .init()
    ) async throws -> Operations.UsersUnblock.Output {
        try await usersUnblock(Operations.UsersUnblock.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set primary email visibility for the authenticated user
    ///
    /// Sets the visibility for your primary email addresses.
    ///
    /// - Remark: HTTP `PATCH /user/email/visibility`.
    /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)`.
    public func usersSetPrimaryEmailVisibilityForAuthenticatedUser(
        headers: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output {
        try await usersSetPrimaryEmailVisibilityForAuthenticatedUser(Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List email addresses for the authenticated user
    ///
    /// Lists all of your email addresses, and specifies which one is visible
    /// to the public.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)`.
    public func usersListEmailsForAuthenticatedUser(
        query: Operations.UsersListEmailsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListEmailsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListEmailsForAuthenticatedUser.Output {
        try await usersListEmailsForAuthenticatedUser(Operations.UsersListEmailsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Add an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)`.
    public func usersAddEmailForAuthenticatedUser(
        headers: Operations.UsersAddEmailForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersAddEmailForAuthenticatedUser.Input.Body? = nil
    ) async throws -> Operations.UsersAddEmailForAuthenticatedUser.Output {
        try await usersAddEmailForAuthenticatedUser(Operations.UsersAddEmailForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Delete an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)`.
    public func usersDeleteEmailForAuthenticatedUser(
        headers: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Body? = nil
    ) async throws -> Operations.UsersDeleteEmailForAuthenticatedUser.Output {
        try await usersDeleteEmailForAuthenticatedUser(Operations.UsersDeleteEmailForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List followers of the authenticated user
    ///
    /// Lists the people following the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/followers`.
    /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)`.
    public func usersListFollowersForAuthenticatedUser(
        query: Operations.UsersListFollowersForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListFollowersForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListFollowersForAuthenticatedUser.Output {
        try await usersListFollowersForAuthenticatedUser(Operations.UsersListFollowersForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List the people the authenticated user follows
    ///
    /// Lists the people who the authenticated user follows.
    ///
    /// - Remark: HTTP `GET /user/following`.
    /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)`.
    public func usersListFollowedByAuthenticatedUser(
        query: Operations.UsersListFollowedByAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListFollowedByAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListFollowedByAuthenticatedUser.Output {
        try await usersListFollowedByAuthenticatedUser(Operations.UsersListFollowedByAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Check if a person is followed by the authenticated user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)`.
    public func usersCheckPersonIsFollowedByAuthenticated(
        path: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Path,
        headers: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Headers = .init()
    ) async throws -> Operations.UsersCheckPersonIsFollowedByAuthenticated.Output {
        try await usersCheckPersonIsFollowedByAuthenticated(Operations.UsersCheckPersonIsFollowedByAuthenticated.Input(
            path: path,
            headers: headers
        ))
    }
    /// Follow a user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)`.
    public func usersFollow(
        path: Operations.UsersFollow.Input.Path,
        headers: Operations.UsersFollow.Input.Headers = .init()
    ) async throws -> Operations.UsersFollow.Output {
        try await usersFollow(Operations.UsersFollow.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unfollow a user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)`.
    public func usersUnfollow(
        path: Operations.UsersUnfollow.Input.Path,
        headers: Operations.UsersUnfollow.Input.Headers = .init()
    ) async throws -> Operations.UsersUnfollow.Output {
        try await usersUnfollow(Operations.UsersUnfollow.Input(
            path: path,
            headers: headers
        ))
    }
    /// List GPG keys for the authenticated user
    ///
    /// Lists the current user's GPG keys.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)`.
    public func usersListGpgKeysForAuthenticatedUser(
        query: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListGpgKeysForAuthenticatedUser.Output {
        try await usersListGpgKeysForAuthenticatedUser(Operations.UsersListGpgKeysForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a GPG key for the authenticated user
    ///
    /// Adds a GPG key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)`.
    public func usersCreateGpgKeyForAuthenticatedUser(
        headers: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersCreateGpgKeyForAuthenticatedUser.Output {
        try await usersCreateGpgKeyForAuthenticatedUser(Operations.UsersCreateGpgKeyForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Get a GPG key for the authenticated user
    ///
    /// View extended details for a single GPG key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)`.
    public func usersGetGpgKeyForAuthenticatedUser(
        path: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersGetGpgKeyForAuthenticatedUser.Output {
        try await usersGetGpgKeyForAuthenticatedUser(Operations.UsersGetGpgKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a GPG key for the authenticated user
    ///
    /// Removes a GPG key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)`.
    public func usersDeleteGpgKeyForAuthenticatedUser(
        path: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersDeleteGpgKeyForAuthenticatedUser.Output {
        try await usersDeleteGpgKeyForAuthenticatedUser(Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List public SSH keys for the authenticated user
    ///
    /// Lists the public SSH keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)`.
    public func usersListPublicSshKeysForAuthenticatedUser(
        query: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListPublicSshKeysForAuthenticatedUser.Output {
        try await usersListPublicSshKeysForAuthenticatedUser(Operations.UsersListPublicSshKeysForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a public SSH key for the authenticated user
    ///
    /// Adds a public SSH key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)`.
    public func usersCreatePublicSshKeyForAuthenticatedUser(
        headers: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output {
        try await usersCreatePublicSshKeyForAuthenticatedUser(Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Get a public SSH key for the authenticated user
    ///
    /// View extended details for a single public SSH key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)`.
    public func usersGetPublicSshKeyForAuthenticatedUser(
        path: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output {
        try await usersGetPublicSshKeyForAuthenticatedUser(Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a public SSH key for the authenticated user
    ///
    /// Removes a public SSH key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)`.
    public func usersDeletePublicSshKeyForAuthenticatedUser(
        path: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Output {
        try await usersDeletePublicSshKeyForAuthenticatedUser(Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List public email addresses for the authenticated user
    ///
    /// Lists your publicly visible email address, which you can set with the
    /// [Set primary email visibility for the authenticated user](https://docs.github.com/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
    /// endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/public_emails`.
    /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)`.
    public func usersListPublicEmailsForAuthenticatedUser(
        query: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListPublicEmailsForAuthenticatedUser.Output {
        try await usersListPublicEmailsForAuthenticatedUser(Operations.UsersListPublicEmailsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// List social accounts for the authenticated user
    ///
    /// Lists all of your social accounts.
    ///
    /// - Remark: HTTP `GET /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)`.
    public func usersListSocialAccountsForAuthenticatedUser(
        query: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListSocialAccountsForAuthenticatedUser.Output {
        try await usersListSocialAccountsForAuthenticatedUser(Operations.UsersListSocialAccountsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Add social accounts for the authenticated user
    ///
    /// Add one or more social accounts to the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)`.
    public func usersAddSocialAccountForAuthenticatedUser(
        headers: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersAddSocialAccountForAuthenticatedUser.Output {
        try await usersAddSocialAccountForAuthenticatedUser(Operations.UsersAddSocialAccountForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Delete social accounts for the authenticated user
    ///
    /// Deletes one or more social accounts from the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)`.
    public func usersDeleteSocialAccountForAuthenticatedUser(
        headers: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersDeleteSocialAccountForAuthenticatedUser.Output {
        try await usersDeleteSocialAccountForAuthenticatedUser(Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List SSH signing keys for the authenticated user
    ///
    /// Lists the SSH signing keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)`.
    public func usersListSshSigningKeysForAuthenticatedUser(
        query: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListSshSigningKeysForAuthenticatedUser.Output {
        try await usersListSshSigningKeysForAuthenticatedUser(Operations.UsersListSshSigningKeysForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a SSH signing key for the authenticated user
    ///
    /// Creates an SSH signing key for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)`.
    public func usersCreateSshSigningKeyForAuthenticatedUser(
        headers: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Body
    ) async throws -> Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output {
        try await usersCreateSshSigningKeyForAuthenticatedUser(Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Get an SSH signing key for the authenticated user
    ///
    /// Gets extended details for an SSH signing key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)`.
    public func usersGetSshSigningKeyForAuthenticatedUser(
        path: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output {
        try await usersGetSshSigningKeyForAuthenticatedUser(Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an SSH signing key for the authenticated user
    ///
    /// Deletes an SSH signing key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)`.
    public func usersDeleteSshSigningKeyForAuthenticatedUser(
        path: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Path,
        headers: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Output {
        try await usersDeleteSshSigningKeyForAuthenticatedUser(Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a user using their ID
    ///
    /// Provides publicly available information about someone with a GitHub account. This method takes their durable user `ID` instead of their `login`, which can change over time.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /user/{account_id}`.
    /// - Remark: Generated from `#/paths//user/{account_id}/get(users/get-by-id)`.
    public func usersGetById(
        path: Operations.UsersGetById.Input.Path,
        headers: Operations.UsersGetById.Input.Headers = .init()
    ) async throws -> Operations.UsersGetById.Output {
        try await usersGetById(Operations.UsersGetById.Input(
            path: path,
            headers: headers
        ))
    }
    /// List users
    ///
    /// Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
    ///
    /// Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.
    ///
    /// - Remark: HTTP `GET /users`.
    /// - Remark: Generated from `#/paths//users/get(users/list)`.
    public func usersList(
        query: Operations.UsersList.Input.Query = .init(),
        headers: Operations.UsersList.Input.Headers = .init()
    ) async throws -> Operations.UsersList.Output {
        try await usersList(Operations.UsersList.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a user
    ///
    /// Provides publicly available information about someone with a GitHub account.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /users/{username}`.
    /// - Remark: Generated from `#/paths//users/{username}/get(users/get-by-username)`.
    public func usersGetByUsername(
        path: Operations.UsersGetByUsername.Input.Path,
        headers: Operations.UsersGetByUsername.Input.Headers = .init()
    ) async throws -> Operations.UsersGetByUsername.Output {
        try await usersGetByUsername(Operations.UsersGetByUsername.Input(
            path: path,
            headers: headers
        ))
    }
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/bulk-list/post(users/list-attestations-bulk)`.
    public func usersListAttestationsBulk(
        path: Operations.UsersListAttestationsBulk.Input.Path,
        query: Operations.UsersListAttestationsBulk.Input.Query = .init(),
        headers: Operations.UsersListAttestationsBulk.Input.Headers = .init(),
        body: Operations.UsersListAttestationsBulk.Input.Body
    ) async throws -> Operations.UsersListAttestationsBulk.Output {
        try await usersListAttestationsBulk(Operations.UsersListAttestationsBulk.Input(
            path: path,
            query: query,
            headers: headers,
            body: body
        ))
    }
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)`.
    public func usersDeleteAttestationsBulk(
        path: Operations.UsersDeleteAttestationsBulk.Input.Path,
        headers: Operations.UsersDeleteAttestationsBulk.Input.Headers = .init(),
        body: Operations.UsersDeleteAttestationsBulk.Input.Body
    ) async throws -> Operations.UsersDeleteAttestationsBulk.Output {
        try await usersDeleteAttestationsBulk(Operations.UsersDeleteAttestationsBulk.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)`.
    public func usersDeleteAttestationsBySubjectDigest(
        path: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Path,
        headers: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Headers = .init()
    ) async throws -> Operations.UsersDeleteAttestationsBySubjectDigest.Output {
        try await usersDeleteAttestationsBySubjectDigest(Operations.UsersDeleteAttestationsBySubjectDigest.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by a user.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)`.
    public func usersDeleteAttestationsById(
        path: Operations.UsersDeleteAttestationsById.Input.Path,
        headers: Operations.UsersDeleteAttestationsById.Input.Headers = .init()
    ) async throws -> Operations.UsersDeleteAttestationsById.Output {
        try await usersDeleteAttestationsById(Operations.UsersDeleteAttestationsById.Input(
            path: path,
            headers: headers
        ))
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /users/{username}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)`.
    public func usersListAttestations(
        path: Operations.UsersListAttestations.Input.Path,
        query: Operations.UsersListAttestations.Input.Query = .init(),
        headers: Operations.UsersListAttestations.Input.Headers = .init()
    ) async throws -> Operations.UsersListAttestations.Output {
        try await usersListAttestations(Operations.UsersListAttestations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List followers of a user
    ///
    /// Lists the people following the specified user.
    ///
    /// - Remark: HTTP `GET /users/{username}/followers`.
    /// - Remark: Generated from `#/paths//users/{username}/followers/get(users/list-followers-for-user)`.
    public func usersListFollowersForUser(
        path: Operations.UsersListFollowersForUser.Input.Path,
        query: Operations.UsersListFollowersForUser.Input.Query = .init(),
        headers: Operations.UsersListFollowersForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListFollowersForUser.Output {
        try await usersListFollowersForUser(Operations.UsersListFollowersForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List the people a user follows
    ///
    /// Lists the people who the specified user follows.
    ///
    /// - Remark: HTTP `GET /users/{username}/following`.
    /// - Remark: Generated from `#/paths//users/{username}/following/get(users/list-following-for-user)`.
    public func usersListFollowingForUser(
        path: Operations.UsersListFollowingForUser.Input.Path,
        query: Operations.UsersListFollowingForUser.Input.Query = .init(),
        headers: Operations.UsersListFollowingForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListFollowingForUser.Output {
        try await usersListFollowingForUser(Operations.UsersListFollowingForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if a user follows another user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /users/{username}/following/{target_user}`.
    /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)`.
    public func usersCheckFollowingForUser(path: Operations.UsersCheckFollowingForUser.Input.Path) async throws -> Operations.UsersCheckFollowingForUser.Output {
        try await usersCheckFollowingForUser(Operations.UsersCheckFollowingForUser.Input(path: path))
    }
    /// List GPG keys for a user
    ///
    /// Lists the GPG keys for a user. This information is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/gpg_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/gpg_keys/get(users/list-gpg-keys-for-user)`.
    public func usersListGpgKeysForUser(
        path: Operations.UsersListGpgKeysForUser.Input.Path,
        query: Operations.UsersListGpgKeysForUser.Input.Query = .init(),
        headers: Operations.UsersListGpgKeysForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListGpgKeysForUser.Output {
        try await usersListGpgKeysForUser(Operations.UsersListGpgKeysForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get contextual information for a user
    ///
    /// Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
    ///
    ///   The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/hovercard`.
    /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)`.
    public func usersGetContextForUser(
        path: Operations.UsersGetContextForUser.Input.Path,
        query: Operations.UsersGetContextForUser.Input.Query = .init(),
        headers: Operations.UsersGetContextForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersGetContextForUser.Output {
        try await usersGetContextForUser(Operations.UsersGetContextForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List public keys for a user
    ///
    /// Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/keys`.
    /// - Remark: Generated from `#/paths//users/{username}/keys/get(users/list-public-keys-for-user)`.
    public func usersListPublicKeysForUser(
        path: Operations.UsersListPublicKeysForUser.Input.Path,
        query: Operations.UsersListPublicKeysForUser.Input.Query = .init(),
        headers: Operations.UsersListPublicKeysForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListPublicKeysForUser.Output {
        try await usersListPublicKeysForUser(Operations.UsersListPublicKeysForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List social accounts for a user
    ///
    /// Lists social media accounts for a user. This endpoint is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/social_accounts`.
    /// - Remark: Generated from `#/paths//users/{username}/social_accounts/get(users/list-social-accounts-for-user)`.
    public func usersListSocialAccountsForUser(
        path: Operations.UsersListSocialAccountsForUser.Input.Path,
        query: Operations.UsersListSocialAccountsForUser.Input.Query = .init(),
        headers: Operations.UsersListSocialAccountsForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListSocialAccountsForUser.Output {
        try await usersListSocialAccountsForUser(Operations.UsersListSocialAccountsForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List SSH signing keys for a user
    ///
    /// Lists the SSH signing keys for a user. This operation is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/ssh_signing_keys/get(users/list-ssh-signing-keys-for-user)`.
    public func usersListSshSigningKeysForUser(
        path: Operations.UsersListSshSigningKeysForUser.Input.Path,
        query: Operations.UsersListSshSigningKeysForUser.Input.Query = .init(),
        headers: Operations.UsersListSshSigningKeysForUser.Input.Headers = .init()
    ) async throws -> Operations.UsersListSshSigningKeysForUser.Output {
        try await usersListSshSigningKeysForUser(Operations.UsersListSshSigningKeysForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Public User
        ///
        /// - Remark: Generated from `#/components/schemas/public-user`.
        public struct PublicUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/public-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/public-user/user_view_type`.
            public var userViewType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/public-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/public-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/notification_email`.
            public var notificationEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/hireable`.
            public var hireable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/public-user/bio`.
            public var bio: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/twitter_username`.
            public var twitterUsername: Swift.String?
            /// - Remark: Generated from `#/components/schemas/public-user/public_repos`.
            public var publicRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/public_gists`.
            public var publicGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/followers`.
            public var followers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/following`.
            public var following: Swift.Int
            /// - Remark: Generated from `#/components/schemas/public-user/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/public-user/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/public-user/plan`.
            public struct PlanPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/public-user/plan/collaborators`.
                public var collaborators: Swift.Int
                /// - Remark: Generated from `#/components/schemas/public-user/plan/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/public-user/plan/space`.
                public var space: Swift.Int
                /// - Remark: Generated from `#/components/schemas/public-user/plan/private_repos`.
                public var privateRepos: Swift.Int
                /// Creates a new `PlanPayload`.
                ///
                /// - Parameters:
                ///   - collaborators:
                ///   - name:
                ///   - space:
                ///   - privateRepos:
                public init(
                    collaborators: Swift.Int,
                    name: Swift.String,
                    space: Swift.Int,
                    privateRepos: Swift.Int
                ) {
                    self.collaborators = collaborators
                    self.name = name
                    self.space = space
                    self.privateRepos = privateRepos
                }
                public enum CodingKeys: String, CodingKey {
                    case collaborators
                    case name
                    case space
                    case privateRepos = "private_repos"
                }
            }
            /// - Remark: Generated from `#/components/schemas/public-user/plan`.
            public var plan: Components.Schemas.PublicUser.PlanPayload?
            /// - Remark: Generated from `#/components/schemas/public-user/private_gists`.
            public var privateGists: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/total_private_repos`.
            public var totalPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/owned_private_repos`.
            public var ownedPrivateRepos: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/disk_usage`.
            public var diskUsage: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/public-user/collaborators`.
            public var collaborators: Swift.Int?
            /// Creates a new `PublicUser`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - userViewType:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - name:
            ///   - company:
            ///   - blog:
            ///   - location:
            ///   - email:
            ///   - notificationEmail:
            ///   - hireable:
            ///   - bio:
            ///   - twitterUsername:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - plan:
            ///   - privateGists:
            ///   - totalPrivateRepos:
            ///   - ownedPrivateRepos:
            ///   - diskUsage:
            ///   - collaborators:
            public init(
                login: Swift.String,
                id: Swift.Int64,
                userViewType: Swift.String? = nil,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                name: Swift.String? = nil,
                company: Swift.String? = nil,
                blog: Swift.String? = nil,
                location: Swift.String? = nil,
                email: Swift.String? = nil,
                notificationEmail: Swift.String? = nil,
                hireable: Swift.Bool? = nil,
                bio: Swift.String? = nil,
                twitterUsername: Swift.String? = nil,
                publicRepos: Swift.Int,
                publicGists: Swift.Int,
                followers: Swift.Int,
                following: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                plan: Components.Schemas.PublicUser.PlanPayload? = nil,
                privateGists: Swift.Int? = nil,
                totalPrivateRepos: Swift.Int? = nil,
                ownedPrivateRepos: Swift.Int? = nil,
                diskUsage: Swift.Int? = nil,
                collaborators: Swift.Int? = nil
            ) {
                self.login = login
                self.id = id
                self.userViewType = userViewType
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.name = name
                self.company = company
                self.blog = blog
                self.location = location
                self.email = email
                self.notificationEmail = notificationEmail
                self.hireable = hireable
                self.bio = bio
                self.twitterUsername = twitterUsername
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.plan = plan
                self.privateGists = privateGists
                self.totalPrivateRepos = totalPrivateRepos
                self.ownedPrivateRepos = ownedPrivateRepos
                self.diskUsage = diskUsage
                self.collaborators = collaborators
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case userViewType = "user_view_type"
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case name
                case company
                case blog
                case location
                case email
                case notificationEmail = "notification_email"
                case hireable
                case bio
                case twitterUsername = "twitter_username"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case plan
                case privateGists = "private_gists"
                case totalPrivateRepos = "total_private_repos"
                case ownedPrivateRepos = "owned_private_repos"
                case diskUsage = "disk_usage"
                case collaborators
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.login = try container.decode(
                    Swift.String.self,
                    forKey: .login
                )
                self.id = try container.decode(
                    Swift.Int64.self,
                    forKey: .id
                )
                self.userViewType = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .userViewType
                )
                self.nodeId = try container.decode(
                    Swift.String.self,
                    forKey: .nodeId
                )
                self.avatarUrl = try container.decode(
                    Swift.String.self,
                    forKey: .avatarUrl
                )
                self.gravatarId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .gravatarId
                )
                self.url = try container.decode(
                    Swift.String.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Swift.String.self,
                    forKey: .htmlUrl
                )
                self.followersUrl = try container.decode(
                    Swift.String.self,
                    forKey: .followersUrl
                )
                self.followingUrl = try container.decode(
                    Swift.String.self,
                    forKey: .followingUrl
                )
                self.gistsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .gistsUrl
                )
                self.starredUrl = try container.decode(
                    Swift.String.self,
                    forKey: .starredUrl
                )
                self.subscriptionsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .subscriptionsUrl
                )
                self.organizationsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .organizationsUrl
                )
                self.reposUrl = try container.decode(
                    Swift.String.self,
                    forKey: .reposUrl
                )
                self.eventsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .eventsUrl
                )
                self.receivedEventsUrl = try container.decode(
                    Swift.String.self,
                    forKey: .receivedEventsUrl
                )
                self._type = try container.decode(
                    Swift.String.self,
                    forKey: ._type
                )
                self.siteAdmin = try container.decode(
                    Swift.Bool.self,
                    forKey: .siteAdmin
                )
                self.name = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .name
                )
                self.company = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .company
                )
                self.blog = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .blog
                )
                self.location = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .location
                )
                self.email = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .email
                )
                self.notificationEmail = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .notificationEmail
                )
                self.hireable = try container.decodeIfPresent(
                    Swift.Bool.self,
                    forKey: .hireable
                )
                self.bio = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .bio
                )
                self.twitterUsername = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .twitterUsername
                )
                self.publicRepos = try container.decode(
                    Swift.Int.self,
                    forKey: .publicRepos
                )
                self.publicGists = try container.decode(
                    Swift.Int.self,
                    forKey: .publicGists
                )
                self.followers = try container.decode(
                    Swift.Int.self,
                    forKey: .followers
                )
                self.following = try container.decode(
                    Swift.Int.self,
                    forKey: .following
                )
                self.createdAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.plan = try container.decodeIfPresent(
                    Components.Schemas.PublicUser.PlanPayload.self,
                    forKey: .plan
                )
                self.privateGists = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .privateGists
                )
                self.totalPrivateRepos = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .totalPrivateRepos
                )
                self.ownedPrivateRepos = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .ownedPrivateRepos
                )
                self.diskUsage = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .diskUsage
                )
                self.collaborators = try container.decodeIfPresent(
                    Swift.Int.self,
                    forKey: .collaborators
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "login",
                    "id",
                    "user_view_type",
                    "node_id",
                    "avatar_url",
                    "gravatar_id",
                    "url",
                    "html_url",
                    "followers_url",
                    "following_url",
                    "gists_url",
                    "starred_url",
                    "subscriptions_url",
                    "organizations_url",
                    "repos_url",
                    "events_url",
                    "received_events_url",
                    "type",
                    "site_admin",
                    "name",
                    "company",
                    "blog",
                    "location",
                    "email",
                    "notification_email",
                    "hireable",
                    "bio",
                    "twitter_username",
                    "public_repos",
                    "public_gists",
                    "followers",
                    "following",
                    "created_at",
                    "updated_at",
                    "plan",
                    "private_gists",
                    "total_private_repos",
                    "owned_private_repos",
                    "disk_usage",
                    "collaborators"
                ])
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// Private User
        ///
        /// - Remark: Generated from `#/components/schemas/private-user`.
        public struct PrivateUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/private-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/private-user/user_view_type`.
            public var userViewType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/private-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/company`.
            public var company: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/blog`.
            public var blog: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/location`.
            public var location: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/notification_email`.
            public var notificationEmail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/hireable`.
            public var hireable: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/private-user/bio`.
            public var bio: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/twitter_username`.
            public var twitterUsername: Swift.String?
            /// - Remark: Generated from `#/components/schemas/private-user/public_repos`.
            public var publicRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/public_gists`.
            public var publicGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/followers`.
            public var followers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/following`.
            public var following: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/private-user/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/private-user/private_gists`.
            public var privateGists: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/total_private_repos`.
            public var totalPrivateRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/owned_private_repos`.
            public var ownedPrivateRepos: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/disk_usage`.
            public var diskUsage: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/collaborators`.
            public var collaborators: Swift.Int
            /// - Remark: Generated from `#/components/schemas/private-user/two_factor_authentication`.
            public var twoFactorAuthentication: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/private-user/plan`.
            public struct PlanPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/private-user/plan/collaborators`.
                public var collaborators: Swift.Int
                /// - Remark: Generated from `#/components/schemas/private-user/plan/name`.
                public var name: Swift.String
                /// - Remark: Generated from `#/components/schemas/private-user/plan/space`.
                public var space: Swift.Int
                /// - Remark: Generated from `#/components/schemas/private-user/plan/private_repos`.
                public var privateRepos: Swift.Int
                /// Creates a new `PlanPayload`.
                ///
                /// - Parameters:
                ///   - collaborators:
                ///   - name:
                ///   - space:
                ///   - privateRepos:
                public init(
                    collaborators: Swift.Int,
                    name: Swift.String,
                    space: Swift.Int,
                    privateRepos: Swift.Int
                ) {
                    self.collaborators = collaborators
                    self.name = name
                    self.space = space
                    self.privateRepos = privateRepos
                }
                public enum CodingKeys: String, CodingKey {
                    case collaborators
                    case name
                    case space
                    case privateRepos = "private_repos"
                }
            }
            /// - Remark: Generated from `#/components/schemas/private-user/plan`.
            public var plan: Components.Schemas.PrivateUser.PlanPayload?
            /// - Remark: Generated from `#/components/schemas/private-user/business_plus`.
            public var businessPlus: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/private-user/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `PrivateUser`.
            ///
            /// - Parameters:
            ///   - login:
            ///   - id:
            ///   - userViewType:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - name:
            ///   - company:
            ///   - blog:
            ///   - location:
            ///   - email:
            ///   - notificationEmail:
            ///   - hireable:
            ///   - bio:
            ///   - twitterUsername:
            ///   - publicRepos:
            ///   - publicGists:
            ///   - followers:
            ///   - following:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - privateGists:
            ///   - totalPrivateRepos:
            ///   - ownedPrivateRepos:
            ///   - diskUsage:
            ///   - collaborators:
            ///   - twoFactorAuthentication:
            ///   - plan:
            ///   - businessPlus:
            ///   - ldapDn:
            public init(
                login: Swift.String,
                id: Swift.Int64,
                userViewType: Swift.String? = nil,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                name: Swift.String? = nil,
                company: Swift.String? = nil,
                blog: Swift.String? = nil,
                location: Swift.String? = nil,
                email: Swift.String? = nil,
                notificationEmail: Swift.String? = nil,
                hireable: Swift.Bool? = nil,
                bio: Swift.String? = nil,
                twitterUsername: Swift.String? = nil,
                publicRepos: Swift.Int,
                publicGists: Swift.Int,
                followers: Swift.Int,
                following: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                privateGists: Swift.Int,
                totalPrivateRepos: Swift.Int,
                ownedPrivateRepos: Swift.Int,
                diskUsage: Swift.Int,
                collaborators: Swift.Int,
                twoFactorAuthentication: Swift.Bool,
                plan: Components.Schemas.PrivateUser.PlanPayload? = nil,
                businessPlus: Swift.Bool? = nil,
                ldapDn: Swift.String? = nil
            ) {
                self.login = login
                self.id = id
                self.userViewType = userViewType
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.name = name
                self.company = company
                self.blog = blog
                self.location = location
                self.email = email
                self.notificationEmail = notificationEmail
                self.hireable = hireable
                self.bio = bio
                self.twitterUsername = twitterUsername
                self.publicRepos = publicRepos
                self.publicGists = publicGists
                self.followers = followers
                self.following = following
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.privateGists = privateGists
                self.totalPrivateRepos = totalPrivateRepos
                self.ownedPrivateRepos = ownedPrivateRepos
                self.diskUsage = diskUsage
                self.collaborators = collaborators
                self.twoFactorAuthentication = twoFactorAuthentication
                self.plan = plan
                self.businessPlus = businessPlus
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case login
                case id
                case userViewType = "user_view_type"
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case name
                case company
                case blog
                case location
                case email
                case notificationEmail = "notification_email"
                case hireable
                case bio
                case twitterUsername = "twitter_username"
                case publicRepos = "public_repos"
                case publicGists = "public_gists"
                case followers
                case following
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case privateGists = "private_gists"
                case totalPrivateRepos = "total_private_repos"
                case ownedPrivateRepos = "owned_private_repos"
                case diskUsage = "disk_usage"
                case collaborators
                case twoFactorAuthentication = "two_factor_authentication"
                case plan
                case businessPlus = "business_plus"
                case ldapDn = "ldap_dn"
            }
        }
        /// Email
        ///
        /// - Remark: Generated from `#/components/schemas/email`.
        public struct Email: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/email/email`.
            public var email: Swift.String
            /// - Remark: Generated from `#/components/schemas/email/primary`.
            public var primary: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/email/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/email/visibility`.
            public var visibility: Swift.String?
            /// Creates a new `Email`.
            ///
            /// - Parameters:
            ///   - email:
            ///   - primary:
            ///   - verified:
            ///   - visibility:
            public init(
                email: Swift.String,
                primary: Swift.Bool,
                verified: Swift.Bool,
                visibility: Swift.String? = nil
            ) {
                self.email = email
                self.primary = primary
                self.verified = verified
                self.visibility = visibility
            }
            public enum CodingKeys: String, CodingKey {
                case email
                case primary
                case verified
                case visibility
            }
        }
        /// A unique encryption key
        ///
        /// - Remark: Generated from `#/components/schemas/gpg-key`.
        public struct GpgKey: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/gpg-key/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/gpg-key/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/gpg-key/primary_key_id`.
            public var primaryKeyId: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/gpg-key/key_id`.
            public var keyId: Swift.String
            /// - Remark: Generated from `#/components/schemas/gpg-key/public_key`.
            public var publicKey: Swift.String
            /// - Remark: Generated from `#/components/schemas/gpg-key/EmailsPayload`.
            public struct EmailsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gpg-key/EmailsPayload/email`.
                public var email: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/EmailsPayload/verified`.
                public var verified: Swift.Bool?
                /// Creates a new `EmailsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - email:
                ///   - verified:
                public init(
                    email: Swift.String? = nil,
                    verified: Swift.Bool? = nil
                ) {
                    self.email = email
                    self.verified = verified
                }
                public enum CodingKeys: String, CodingKey {
                    case email
                    case verified
                }
            }
            /// - Remark: Generated from `#/components/schemas/gpg-key/emails`.
            public typealias EmailsPayload = [Components.Schemas.GpgKey.EmailsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/gpg-key/emails`.
            public var emails: Components.Schemas.GpgKey.EmailsPayload
            /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload`.
            public struct SubkeysPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/id`.
                public var id: Swift.Int64?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/primary_key_id`.
                public var primaryKeyId: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/key_id`.
                public var keyId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/public_key`.
                public var publicKey: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/EmailsPayload`.
                public struct EmailsPayloadPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/EmailsPayload/email`.
                    public var email: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/EmailsPayload/verified`.
                    public var verified: Swift.Bool?
                    /// Creates a new `EmailsPayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - email:
                    ///   - verified:
                    public init(
                        email: Swift.String? = nil,
                        verified: Swift.Bool? = nil
                    ) {
                        self.email = email
                        self.verified = verified
                    }
                    public enum CodingKeys: String, CodingKey {
                        case email
                        case verified
                    }
                }
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/emails`.
                public typealias EmailsPayload = [Components.Schemas.GpgKey.SubkeysPayloadPayload.EmailsPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/emails`.
                public var emails: Components.Schemas.GpgKey.SubkeysPayloadPayload.EmailsPayload?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/subkeys`.
                public var subkeys: [OpenAPIRuntime.OpenAPIValueContainer]?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/can_sign`.
                public var canSign: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/can_encrypt_comms`.
                public var canEncryptComms: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/can_encrypt_storage`.
                public var canEncryptStorage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/can_certify`.
                public var canCertify: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/created_at`.
                public var createdAt: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/expires_at`.
                public var expiresAt: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/raw_key`.
                public var rawKey: Swift.String?
                /// - Remark: Generated from `#/components/schemas/gpg-key/SubkeysPayload/revoked`.
                public var revoked: Swift.Bool?
                /// Creates a new `SubkeysPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - primaryKeyId:
                ///   - keyId:
                ///   - publicKey:
                ///   - emails:
                ///   - subkeys:
                ///   - canSign:
                ///   - canEncryptComms:
                ///   - canEncryptStorage:
                ///   - canCertify:
                ///   - createdAt:
                ///   - expiresAt:
                ///   - rawKey:
                ///   - revoked:
                public init(
                    id: Swift.Int64? = nil,
                    primaryKeyId: Swift.Int? = nil,
                    keyId: Swift.String? = nil,
                    publicKey: Swift.String? = nil,
                    emails: Components.Schemas.GpgKey.SubkeysPayloadPayload.EmailsPayload? = nil,
                    subkeys: [OpenAPIRuntime.OpenAPIValueContainer]? = nil,
                    canSign: Swift.Bool? = nil,
                    canEncryptComms: Swift.Bool? = nil,
                    canEncryptStorage: Swift.Bool? = nil,
                    canCertify: Swift.Bool? = nil,
                    createdAt: Swift.String? = nil,
                    expiresAt: Swift.String? = nil,
                    rawKey: Swift.String? = nil,
                    revoked: Swift.Bool? = nil
                ) {
                    self.id = id
                    self.primaryKeyId = primaryKeyId
                    self.keyId = keyId
                    self.publicKey = publicKey
                    self.emails = emails
                    self.subkeys = subkeys
                    self.canSign = canSign
                    self.canEncryptComms = canEncryptComms
                    self.canEncryptStorage = canEncryptStorage
                    self.canCertify = canCertify
                    self.createdAt = createdAt
                    self.expiresAt = expiresAt
                    self.rawKey = rawKey
                    self.revoked = revoked
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case primaryKeyId = "primary_key_id"
                    case keyId = "key_id"
                    case publicKey = "public_key"
                    case emails
                    case subkeys
                    case canSign = "can_sign"
                    case canEncryptComms = "can_encrypt_comms"
                    case canEncryptStorage = "can_encrypt_storage"
                    case canCertify = "can_certify"
                    case createdAt = "created_at"
                    case expiresAt = "expires_at"
                    case rawKey = "raw_key"
                    case revoked
                }
            }
            /// - Remark: Generated from `#/components/schemas/gpg-key/subkeys`.
            public typealias SubkeysPayload = [Components.Schemas.GpgKey.SubkeysPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/gpg-key/subkeys`.
            public var subkeys: Components.Schemas.GpgKey.SubkeysPayload
            /// - Remark: Generated from `#/components/schemas/gpg-key/can_sign`.
            public var canSign: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/gpg-key/can_encrypt_comms`.
            public var canEncryptComms: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/gpg-key/can_encrypt_storage`.
            public var canEncryptStorage: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/gpg-key/can_certify`.
            public var canCertify: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/gpg-key/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/gpg-key/expires_at`.
            public var expiresAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/gpg-key/revoked`.
            public var revoked: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/gpg-key/raw_key`.
            public var rawKey: Swift.String?
            /// Creates a new `GpgKey`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - name:
            ///   - primaryKeyId:
            ///   - keyId:
            ///   - publicKey:
            ///   - emails:
            ///   - subkeys:
            ///   - canSign:
            ///   - canEncryptComms:
            ///   - canEncryptStorage:
            ///   - canCertify:
            ///   - createdAt:
            ///   - expiresAt:
            ///   - revoked:
            ///   - rawKey:
            public init(
                id: Swift.Int64,
                name: Swift.String? = nil,
                primaryKeyId: Swift.Int? = nil,
                keyId: Swift.String,
                publicKey: Swift.String,
                emails: Components.Schemas.GpgKey.EmailsPayload,
                subkeys: Components.Schemas.GpgKey.SubkeysPayload,
                canSign: Swift.Bool,
                canEncryptComms: Swift.Bool,
                canEncryptStorage: Swift.Bool,
                canCertify: Swift.Bool,
                createdAt: Foundation.Date,
                expiresAt: Foundation.Date? = nil,
                revoked: Swift.Bool,
                rawKey: Swift.String? = nil
            ) {
                self.id = id
                self.name = name
                self.primaryKeyId = primaryKeyId
                self.keyId = keyId
                self.publicKey = publicKey
                self.emails = emails
                self.subkeys = subkeys
                self.canSign = canSign
                self.canEncryptComms = canEncryptComms
                self.canEncryptStorage = canEncryptStorage
                self.canCertify = canCertify
                self.createdAt = createdAt
                self.expiresAt = expiresAt
                self.revoked = revoked
                self.rawKey = rawKey
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case primaryKeyId = "primary_key_id"
                case keyId = "key_id"
                case publicKey = "public_key"
                case emails
                case subkeys
                case canSign = "can_sign"
                case canEncryptComms = "can_encrypt_comms"
                case canEncryptStorage = "can_encrypt_storage"
                case canCertify = "can_certify"
                case createdAt = "created_at"
                case expiresAt = "expires_at"
                case revoked
                case rawKey = "raw_key"
            }
        }
        /// Key
        ///
        /// - Remark: Generated from `#/components/schemas/key`.
        public struct Key: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/key/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/key/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/key/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/key/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/key/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/key/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/key/read_only`.
            public var readOnly: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/key/last_used`.
            public var lastUsed: Foundation.Date?
            /// Creates a new `Key`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - id:
            ///   - url:
            ///   - title:
            ///   - createdAt:
            ///   - verified:
            ///   - readOnly:
            ///   - lastUsed:
            public init(
                key: Swift.String,
                id: Swift.Int64,
                url: Swift.String,
                title: Swift.String,
                createdAt: Foundation.Date,
                verified: Swift.Bool,
                readOnly: Swift.Bool,
                lastUsed: Foundation.Date? = nil
            ) {
                self.key = key
                self.id = id
                self.url = url
                self.title = title
                self.createdAt = createdAt
                self.verified = verified
                self.readOnly = readOnly
                self.lastUsed = lastUsed
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case id
                case url
                case title
                case createdAt = "created_at"
                case verified
                case readOnly = "read_only"
                case lastUsed = "last_used"
            }
        }
        /// Social media account
        ///
        /// - Remark: Generated from `#/components/schemas/social-account`.
        public struct SocialAccount: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/social-account/provider`.
            public var provider: Swift.String
            /// - Remark: Generated from `#/components/schemas/social-account/url`.
            public var url: Swift.String
            /// Creates a new `SocialAccount`.
            ///
            /// - Parameters:
            ///   - provider:
            ///   - url:
            public init(
                provider: Swift.String,
                url: Swift.String
            ) {
                self.provider = provider
                self.url = url
            }
            public enum CodingKeys: String, CodingKey {
                case provider
                case url
            }
        }
        /// A public SSH key used to sign Git commits
        ///
        /// - Remark: Generated from `#/components/schemas/ssh-signing-key`.
        public struct SshSigningKey: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ssh-signing-key/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/ssh-signing-key/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/ssh-signing-key/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/ssh-signing-key/created_at`.
            public var createdAt: Foundation.Date
            /// Creates a new `SshSigningKey`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - id:
            ///   - title:
            ///   - createdAt:
            public init(
                key: Swift.String,
                id: Swift.Int,
                title: Swift.String,
                createdAt: Foundation.Date
            ) {
                self.key = key
                self.id = id
                self.title = title
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case id
                case title
                case createdAt = "created_at"
            }
        }
        /// Hovercard
        ///
        /// - Remark: Generated from `#/components/schemas/hovercard`.
        public struct Hovercard: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/hovercard/ContextsPayload`.
            public struct ContextsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/hovercard/ContextsPayload/message`.
                public var message: Swift.String
                /// - Remark: Generated from `#/components/schemas/hovercard/ContextsPayload/octicon`.
                public var octicon: Swift.String
                /// Creates a new `ContextsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - message:
                ///   - octicon:
                public init(
                    message: Swift.String,
                    octicon: Swift.String
                ) {
                    self.message = message
                    self.octicon = octicon
                }
                public enum CodingKeys: String, CodingKey {
                    case message
                    case octicon
                }
            }
            /// - Remark: Generated from `#/components/schemas/hovercard/contexts`.
            public typealias ContextsPayload = [Components.Schemas.Hovercard.ContextsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/hovercard/contexts`.
            public var contexts: Components.Schemas.Hovercard.ContextsPayload
            /// Creates a new `Hovercard`.
            ///
            /// - Parameters:
            ///   - contexts:
            public init(contexts: Components.Schemas.Hovercard.ContextsPayload) {
                self.contexts = contexts
            }
            public enum CodingKeys: String, CodingKey {
                case contexts
            }
        }
        /// Key Simple
        ///
        /// - Remark: Generated from `#/components/schemas/key-simple`.
        public struct KeySimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/key-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/key-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/key-simple/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/key-simple/last_used`.
            public var lastUsed: Foundation.Date?
            /// Creates a new `KeySimple`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - key:
            ///   - createdAt:
            ///   - lastUsed:
            public init(
                id: Swift.Int,
                key: Swift.String,
                createdAt: Foundation.Date? = nil,
                lastUsed: Foundation.Date? = nil
            ) {
                self.id = id
                self.key = key
                self.createdAt = createdAt
                self.lastUsed = lastUsed
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case key
                case createdAt = "created_at"
                case lastUsed = "last_used"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// account_id parameter
        ///
        /// - Remark: Generated from `#/components/parameters/account-id`.
        public typealias AccountId = Swift.Int
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// A user ID. Only return users with an ID greater than this ID.
        ///
        /// - Remark: Generated from `#/components/parameters/since-user`.
        public typealias SinceUser = Swift.Int
        /// The unique identifier of the key.
        ///
        /// - Remark: Generated from `#/components/parameters/key-id`.
        public typealias KeyId = Swift.Int
        /// The unique identifier of the GPG key.
        ///
        /// - Remark: Generated from `#/components/parameters/gpg-key-id`.
        public typealias GpgKeyId = Swift.Int
        /// The unique identifier of the SSH signing key.
        ///
        /// - Remark: Generated from `#/components/parameters/ssh-signing-key-id`.
        public typealias SshSigningKeyId = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.
    ///
    /// - Remark: HTTP `GET /user`.
    /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)`.
    public enum UsersGetAuthenticated {
        public static let id: Swift.String = "users/get-authenticated"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetAuthenticated.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetAuthenticated.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetAuthenticated.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.UsersGetAuthenticated.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/GET/responses/200/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/GET/responses/200/content/json/PrivateUser`.
                        case _private(Components.Schemas.PrivateUser)
                        /// - Remark: Generated from `#/paths/user/GET/responses/200/content/json/PublicUser`.
                        case _public(Components.Schemas.PublicUser)
                        public enum CodingKeys: String, CodingKey {
                            case userViewType = "user_view_type"
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            let discriminator = try container.decode(
                                Swift.String.self,
                                forKey: .userViewType
                            )
                            switch discriminator {
                            case "private":
                                self = ._private(try .init(from: decoder))
                            case "public":
                                self = ._public(try .init(from: decoder))
                            default:
                                throw Swift.DecodingError.unknownOneOfDiscriminator(
                                    discriminatorKey: CodingKeys.userViewType,
                                    discriminatorValue: discriminator,
                                    codingPath: decoder.codingPath
                                )
                            }
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let ._private(value):
                                try value.encode(to: encoder)
                            case let ._public(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/GET/responses/200/content/application\/json`.
                    case json(Operations.UsersGetAuthenticated.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.UsersGetAuthenticated.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetAuthenticated.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetAuthenticated.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetAuthenticated.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetAuthenticated.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/get(users/get-authenticated)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update the authenticated user
    ///
    /// **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
    ///
    /// - Remark: HTTP `PATCH /user`.
    /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)`.
    public enum UsersUpdateAuthenticated {
        public static let id: Swift.String = "users/update-authenticated"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUpdateAuthenticated.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUpdateAuthenticated.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersUpdateAuthenticated.Input.Headers
            /// - Remark: Generated from `#/paths/user/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The new name of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// The publicly visible email address of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/email`.
                    public var email: Swift.String?
                    /// The new blog URL of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/blog`.
                    public var blog: Swift.String?
                    /// The new Twitter username of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/twitter_username`.
                    public var twitterUsername: Swift.String?
                    /// The new company of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/company`.
                    public var company: Swift.String?
                    /// The new location of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/location`.
                    public var location: Swift.String?
                    /// The new hiring availability of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/hireable`.
                    public var hireable: Swift.Bool?
                    /// The new short biography of the user.
                    ///
                    /// - Remark: Generated from `#/paths/user/PATCH/requestBody/json/bio`.
                    public var bio: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: The new name of the user.
                    ///   - email: The publicly visible email address of the user.
                    ///   - blog: The new blog URL of the user.
                    ///   - twitterUsername: The new Twitter username of the user.
                    ///   - company: The new company of the user.
                    ///   - location: The new location of the user.
                    ///   - hireable: The new hiring availability of the user.
                    ///   - bio: The new short biography of the user.
                    public init(
                        name: Swift.String? = nil,
                        email: Swift.String? = nil,
                        blog: Swift.String? = nil,
                        twitterUsername: Swift.String? = nil,
                        company: Swift.String? = nil,
                        location: Swift.String? = nil,
                        hireable: Swift.Bool? = nil,
                        bio: Swift.String? = nil
                    ) {
                        self.name = name
                        self.email = email
                        self.blog = blog
                        self.twitterUsername = twitterUsername
                        self.company = company
                        self.location = location
                        self.hireable = hireable
                        self.bio = bio
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case email
                        case blog
                        case twitterUsername = "twitter_username"
                        case company
                        case location
                        case hireable
                        case bio
                    }
                }
                /// - Remark: Generated from `#/paths/user/PATCH/requestBody/content/application\/json`.
                case json(Operations.UsersUpdateAuthenticated.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersUpdateAuthenticated.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersUpdateAuthenticated.Input.Headers = .init(),
                body: Operations.UsersUpdateAuthenticated.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.PrivateUser)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PrivateUser {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersUpdateAuthenticated.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersUpdateAuthenticated.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersUpdateAuthenticated.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersUpdateAuthenticated.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/patch(users/update-authenticated)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List users blocked by the authenticated user
    ///
    /// List the users you've blocked on your personal account.
    ///
    /// - Remark: HTTP `GET /user/blocks`.
    /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)`.
    public enum UsersListBlockedByAuthenticatedUser {
        public static let id: Swift.String = "users/list-blocked-by-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/blocks/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/blocks/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/blocks/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListBlockedByAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/blocks/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListBlockedByAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListBlockedByAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListBlockedByAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListBlockedByAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListBlockedByAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/blocks/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/blocks/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListBlockedByAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersListBlockedByAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListBlockedByAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListBlockedByAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/blocks/get(users/list-blocked-by-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a user is blocked by the authenticated user
    ///
    /// Returns a 204 if the given user is blocked by the authenticated user. Returns a 404 if the given user is not blocked by the authenticated user, or if the given user account has been identified as spam by GitHub.
    ///
    /// - Remark: HTTP `GET /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)`.
    public enum UsersCheckBlocked {
        public static let id: Swift.String = "users/check-blocked"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/blocks/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/blocks/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersCheckBlocked.Input.Path
            /// - Remark: Generated from `#/paths/user/blocks/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCheckBlocked.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCheckBlocked.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersCheckBlocked.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersCheckBlocked.Input.Path,
                headers: Operations.UsersCheckBlocked.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// If the user is blocked
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersCheckBlocked.Output.NoContent)
            /// If the user is blocked
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersCheckBlocked.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/blocks/{username}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/blocks/{username}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersCheckBlocked.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersCheckBlocked.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// If the user is not blocked
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.UsersCheckBlocked.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.UsersCheckBlocked.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/get(users/check-blocked)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Block a user
    ///
    /// Blocks the given user and returns a 204. If the authenticated user cannot block the given user a 422 is returned.
    ///
    /// - Remark: HTTP `PUT /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)`.
    public enum UsersBlock {
        public static let id: Swift.String = "users/block"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/blocks/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/blocks/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersBlock.Input.Path
            /// - Remark: Generated from `#/paths/user/blocks/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersBlock.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersBlock.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersBlock.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersBlock.Input.Path,
                headers: Operations.UsersBlock.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersBlock.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersBlock.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/put(users/block)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unblock a user
    ///
    /// Unblocks the given user and returns a 204.
    ///
    /// - Remark: HTTP `DELETE /user/blocks/{username}`.
    /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)`.
    public enum UsersUnblock {
        public static let id: Swift.String = "users/unblock"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/blocks/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/blocks/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersUnblock.Input.Path
            /// - Remark: Generated from `#/paths/user/blocks/{username}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUnblock.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUnblock.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersUnblock.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersUnblock.Input.Path,
                headers: Operations.UsersUnblock.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersUnblock.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersUnblock.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/blocks/{username}/delete(users/unblock)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set primary email visibility for the authenticated user
    ///
    /// Sets the visibility for your primary email addresses.
    ///
    /// - Remark: HTTP `PATCH /user/email/visibility`.
    /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)`.
    public enum UsersSetPrimaryEmailVisibilityForAuthenticatedUser {
        public static let id: Swift.String = "users/set-primary-email-visibility-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Denotes whether an email is publicly visible.
                    ///
                    /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _public = "public"
                        case _private = "private"
                    }
                    /// Denotes whether an email is publicly visible.
                    ///
                    /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/requestBody/json/visibility`.
                    public var visibility: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body.JsonPayload.VisibilityPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - visibility: Denotes whether an email is publicly visible.
                    public init(visibility: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body.JsonPayload.VisibilityPayload) {
                        self.visibility = visibility
                    }
                    public enum CodingKeys: String, CodingKey {
                        case visibility
                    }
                }
                /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/requestBody/content/application\/json`.
                case json(Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/email/visibility/PATCH/responses/200/content/application\/json`.
                    case json([Components.Schemas.Email])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Email] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersSetPrimaryEmailVisibilityForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/email/visibility/patch(users/set-primary-email-visibility-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List email addresses for the authenticated user
    ///
    /// Lists all of your email addresses, and specifies which one is visible
    /// to the public.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)`.
    public enum UsersListEmailsForAuthenticatedUser {
        public static let id: Swift.String = "users/list-emails-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/emails/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/emails/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/emails/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListEmailsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/emails/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListEmailsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListEmailsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListEmailsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListEmailsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListEmailsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/emails/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/emails/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListEmailsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/emails/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/emails/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Email])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Email] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListEmailsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListEmailsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListEmailsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListEmailsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListEmailsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/emails/get(users/list-emails-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)`.
    public enum UsersAddEmailForAuthenticatedUser {
        public static let id: Swift.String = "users/add-email-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/emails/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersAddEmailForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersAddEmailForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersAddEmailForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/emails/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
                        ///
                        /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json/case1/emails`.
                        public var emails: [Swift.String]
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - emails: Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
                        public init(emails: [Swift.String]) {
                            self.emails = emails
                        }
                        public enum CodingKeys: String, CodingKey {
                            case emails
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json/case1`.
                    case case1(Operations.UsersAddEmailForAuthenticatedUser.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json/case2`.
                    case case2([Swift.String])
                    /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/json/case3`.
                    case case3(Swift.String)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/user/emails/POST/requestBody/content/application\/json`.
                case json(Operations.UsersAddEmailForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersAddEmailForAuthenticatedUser.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersAddEmailForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersAddEmailForAuthenticatedUser.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/emails/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/emails/POST/responses/201/content/application\/json`.
                    case json([Components.Schemas.Email])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Email] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersAddEmailForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersAddEmailForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersAddEmailForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersAddEmailForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/emails/post(users/add-email-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an email address for the authenticated user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/emails`.
    /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)`.
    public enum UsersDeleteEmailForAuthenticatedUser {
        public static let id: Swift.String = "users/delete-email-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/emails/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteEmailForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteEmailForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
                    ///
                    /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// Email addresses associated with the GitHub user account.
                        ///
                        /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json/case1/emails`.
                        public var emails: [Swift.String]
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - emails: Email addresses associated with the GitHub user account.
                        public init(emails: [Swift.String]) {
                            self.emails = emails
                        }
                        public enum CodingKeys: String, CodingKey {
                            case emails
                        }
                    }
                    /// Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
                    ///
                    /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json/case1`.
                    case case1(Operations.UsersDeleteEmailForAuthenticatedUser.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json/case2`.
                    case case2([Swift.String])
                    /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/json/case3`.
                    case case3(Swift.String)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/user/emails/DELETE/requestBody/content/application\/json`.
                case json(Operations.UsersDeleteEmailForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersDeleteEmailForAuthenticatedUser.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteEmailForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteEmailForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/emails/delete(users/delete-email-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List followers of the authenticated user
    ///
    /// Lists the people following the authenticated user.
    ///
    /// - Remark: HTTP `GET /user/followers`.
    /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)`.
    public enum UsersListFollowersForAuthenticatedUser {
        public static let id: Swift.String = "users/list-followers-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/followers/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/followers/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/followers/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListFollowersForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/followers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowersForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowersForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListFollowersForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListFollowersForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListFollowersForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/followers/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/followers/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListFollowersForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/followers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/followers/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListFollowersForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListFollowersForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListFollowersForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListFollowersForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListFollowersForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/followers/get(users/list-followers-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List the people the authenticated user follows
    ///
    /// Lists the people who the authenticated user follows.
    ///
    /// - Remark: HTTP `GET /user/following`.
    /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)`.
    public enum UsersListFollowedByAuthenticatedUser {
        public static let id: Swift.String = "users/list-followed-by-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/following/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/following/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/following/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListFollowedByAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/following/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowedByAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowedByAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListFollowedByAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListFollowedByAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListFollowedByAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/following/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/following/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListFollowedByAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/following/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/following/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListFollowedByAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListFollowedByAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListFollowedByAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListFollowedByAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListFollowedByAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/following/get(users/list-followed-by-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a person is followed by the authenticated user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)`.
    public enum UsersCheckPersonIsFollowedByAuthenticated {
        public static let id: Swift.String = "users/check-person-is-followed-by-authenticated"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/following/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/following/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Path
            /// - Remark: Generated from `#/paths/user/following/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCheckPersonIsFollowedByAuthenticated.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCheckPersonIsFollowedByAuthenticated.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Path,
                headers: Operations.UsersCheckPersonIsFollowedByAuthenticated.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// if the person is followed by the authenticated user
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NoContent)
            /// if the person is followed by the authenticated user
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/following/{username}/GET/responses/404/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/following/{username}/GET/responses/404/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NotFound.Body
                /// Creates a new `NotFound`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NotFound.Body) {
                    self.body = body
                }
            }
            /// if the person is not followed by the authenticated user
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.UsersCheckPersonIsFollowedByAuthenticated.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/get(users/check-person-is-followed-by-authenticated)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Follow a user
    ///
    /// Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)`.
    public enum UsersFollow {
        public static let id: Swift.String = "users/follow"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/following/{username}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/following/{username}/PUT/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersFollow.Input.Path
            /// - Remark: Generated from `#/paths/user/following/{username}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersFollow.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersFollow.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersFollow.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersFollow.Input.Path,
                headers: Operations.UsersFollow.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersFollow.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersFollow.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/put(users/follow)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unfollow a user
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/following/{username}`.
    /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)`.
    public enum UsersUnfollow {
        public static let id: Swift.String = "users/unfollow"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/following/{username}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/user/following/{username}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersUnfollow.Input.Path
            /// - Remark: Generated from `#/paths/user/following/{username}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUnfollow.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersUnfollow.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersUnfollow.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersUnfollow.Input.Path,
                headers: Operations.UsersUnfollow.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersUnfollow.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersUnfollow.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/following/{username}/delete(users/unfollow)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List GPG keys for the authenticated user
    ///
    /// Lists the current user's GPG keys.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)`.
    public enum UsersListGpgKeysForAuthenticatedUser {
        public static let id: Swift.String = "users/list-gpg-keys-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/gpg_keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/gpg_keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/gpg_keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/gpg_keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListGpgKeysForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListGpgKeysForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListGpgKeysForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/gpg_keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/gpg_keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/gpg_keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/gpg_keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GpgKey])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GpgKey] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListGpgKeysForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/get(users/list-gpg-keys-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a GPG key for the authenticated user
    ///
    /// Adds a GPG key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/gpg_keys`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)`.
    public enum UsersCreateGpgKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/create-gpg-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/gpg_keys/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreateGpgKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreateGpgKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/gpg_keys/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/gpg_keys/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A descriptive name for the new key.
                    ///
                    /// - Remark: Generated from `#/paths/user/gpg_keys/POST/requestBody/json/name`.
                    public var name: Swift.String?
                    /// A GPG key in ASCII-armored format.
                    ///
                    /// - Remark: Generated from `#/paths/user/gpg_keys/POST/requestBody/json/armored_public_key`.
                    public var armoredPublicKey: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: A descriptive name for the new key.
                    ///   - armoredPublicKey: A GPG key in ASCII-armored format.
                    public init(
                        name: Swift.String? = nil,
                        armoredPublicKey: Swift.String
                    ) {
                        self.name = name
                        self.armoredPublicKey = armoredPublicKey
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case armoredPublicKey = "armored_public_key"
                    }
                }
                /// - Remark: Generated from `#/paths/user/gpg_keys/POST/requestBody/content/application\/json`.
                case json(Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersCreateGpgKeyForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/gpg_keys/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/gpg_keys/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.GpgKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GpgKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersCreateGpgKeyForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersCreateGpgKeyForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersCreateGpgKeyForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersCreateGpgKeyForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/post(users/create-gpg-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a GPG key for the authenticated user
    ///
    /// View extended details for a single GPG key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)`.
    public enum UsersGetGpgKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/get-gpg-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the GPG key.
                ///
                /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/GET/path/gpg_key_id`.
                public var gpgKeyId: Components.Parameters.GpgKeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gpgKeyId: The unique identifier of the GPG key.
                public init(gpgKeyId: Components.Parameters.GpgKeyId) {
                    self.gpgKeyId = gpgKeyId
                }
            }
            public var path: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetGpgKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetGpgKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersGetGpgKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GpgKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GpgKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetGpgKeyForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetGpgKeyForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetGpgKeyForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetGpgKeyForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/get(users/get-gpg-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a GPG key for the authenticated user
    ///
    /// Removes a GPG key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/gpg_keys/{gpg_key_id}`.
    /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)`.
    public enum UsersDeleteGpgKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/delete-gpg-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the GPG key.
                ///
                /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/DELETE/path/gpg_key_id`.
                public var gpgKeyId: Components.Parameters.GpgKeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - gpgKeyId: The unique identifier of the GPG key.
                public init(gpgKeyId: Components.Parameters.GpgKeyId) {
                    self.gpgKeyId = gpgKeyId
                }
            }
            public var path: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/gpg_keys/{gpg_key_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteGpgKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteGpgKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteGpgKeyForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteGpgKeyForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/gpg_keys/{gpg_key_id}/delete(users/delete-gpg-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public SSH keys for the authenticated user
    ///
    /// Lists the public SSH keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)`.
    public enum UsersListPublicSshKeysForAuthenticatedUser {
        public static let id: Swift.String = "users/list-public-ssh-keys-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicSshKeysForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicSshKeysForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListPublicSshKeysForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Key])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Key] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListPublicSshKeysForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/keys/get(users/list-public-ssh-keys-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a public SSH key for the authenticated user
    ///
    /// Adds a public SSH key to the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/keys`.
    /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)`.
    public enum UsersCreatePublicSshKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/create-public-ssh-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/keys/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreatePublicSshKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreatePublicSshKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/keys/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/keys/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A descriptive name for the new key.
                    ///
                    /// - Remark: Generated from `#/paths/user/keys/POST/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The public SSH key to add to your GitHub account.
                    ///
                    /// - Remark: Generated from `#/paths/user/keys/POST/requestBody/json/key`.
                    public var key: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: A descriptive name for the new key.
                    ///   - key: The public SSH key to add to your GitHub account.
                    public init(
                        title: Swift.String? = nil,
                        key: Swift.String
                    ) {
                        self.title = title
                        self.key = key
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case key
                    }
                }
                /// - Remark: Generated from `#/paths/user/keys/POST/requestBody/content/application\/json`.
                case json(Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/keys/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/keys/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Key)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Key {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersCreatePublicSshKeyForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/keys/post(users/create-public-ssh-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a public SSH key for the authenticated user
    ///
    /// View extended details for a single public SSH key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)`.
    public enum UsersGetPublicSshKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/get-public-ssh-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/keys/{key_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the key.
                ///
                /// - Remark: Generated from `#/paths/user/keys/{key_id}/GET/path/key_id`.
                public var keyId: Components.Parameters.KeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - keyId: The unique identifier of the key.
                public init(keyId: Components.Parameters.KeyId) {
                    self.keyId = keyId
                }
            }
            public var path: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/keys/{key_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetPublicSshKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetPublicSshKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/keys/{key_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/keys/{key_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Key)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Key {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetPublicSshKeyForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/get(users/get-public-ssh-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a public SSH key for the authenticated user
    ///
    /// Removes a public SSH key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)`.
    public enum UsersDeletePublicSshKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/delete-public-ssh-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/keys/{key_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the key.
                ///
                /// - Remark: Generated from `#/paths/user/keys/{key_id}/DELETE/path/key_id`.
                public var keyId: Components.Parameters.KeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - keyId: The unique identifier of the key.
                public init(keyId: Components.Parameters.KeyId) {
                    self.keyId = keyId
                }
            }
            public var path: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/keys/{key_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeletePublicSshKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeletePublicSshKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeletePublicSshKeyForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/keys/{key_id}/delete(users/delete-public-ssh-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public email addresses for the authenticated user
    ///
    /// Lists your publicly visible email address, which you can set with the
    /// [Set primary email visibility for the authenticated user](https://docs.github.com/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
    /// endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/public_emails`.
    /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)`.
    public enum UsersListPublicEmailsForAuthenticatedUser {
        public static let id: Swift.String = "users/list-public-emails-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/public_emails/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/public_emails/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/public_emails/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/public_emails/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicEmailsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicEmailsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListPublicEmailsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/public_emails/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/public_emails/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/public_emails/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/public_emails/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Email])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Email] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListPublicEmailsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/public_emails/get(users/list-public-emails-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List social accounts for the authenticated user
    ///
    /// Lists all of your social accounts.
    ///
    /// - Remark: HTTP `GET /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)`.
    public enum UsersListSocialAccountsForAuthenticatedUser {
        public static let id: Swift.String = "users/list-social-accounts-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/social_accounts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/social_accounts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/social_accounts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/social_accounts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSocialAccountsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSocialAccountsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListSocialAccountsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/social_accounts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/social_accounts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/social_accounts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/social_accounts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SocialAccount])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SocialAccount] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListSocialAccountsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/get(users/list-social-accounts-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add social accounts for the authenticated user
    ///
    /// Add one or more social accounts to the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)`.
    public enum UsersAddSocialAccountForAuthenticatedUser {
        public static let id: Swift.String = "users/add-social-account-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/social_accounts/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersAddSocialAccountForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersAddSocialAccountForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/social_accounts/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/social_accounts/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Full URLs for the social media profiles to add.
                    ///
                    /// - Remark: Generated from `#/paths/user/social_accounts/POST/requestBody/json/account_urls`.
                    public var accountUrls: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accountUrls: Full URLs for the social media profiles to add.
                    public init(accountUrls: [Swift.String]) {
                        self.accountUrls = accountUrls
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accountUrls = "account_urls"
                    }
                }
                /// - Remark: Generated from `#/paths/user/social_accounts/POST/requestBody/content/application\/json`.
                case json(Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersAddSocialAccountForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/social_accounts/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/social_accounts/POST/responses/201/content/application\/json`.
                    case json([Components.Schemas.SocialAccount])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SocialAccount] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersAddSocialAccountForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersAddSocialAccountForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersAddSocialAccountForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersAddSocialAccountForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/post(users/add-social-account-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete social accounts for the authenticated user
    ///
    /// Deletes one or more social accounts from the authenticated user's profile.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/social_accounts`.
    /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)`.
    public enum UsersDeleteSocialAccountForAuthenticatedUser {
        public static let id: Swift.String = "users/delete-social-account-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/social_accounts/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteSocialAccountForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteSocialAccountForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/social_accounts/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/social_accounts/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Full URLs for the social media profiles to delete.
                    ///
                    /// - Remark: Generated from `#/paths/user/social_accounts/DELETE/requestBody/json/account_urls`.
                    public var accountUrls: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - accountUrls: Full URLs for the social media profiles to delete.
                    public init(accountUrls: [Swift.String]) {
                        self.accountUrls = accountUrls
                    }
                    public enum CodingKeys: String, CodingKey {
                        case accountUrls = "account_urls"
                    }
                }
                /// - Remark: Generated from `#/paths/user/social_accounts/DELETE/requestBody/content/application\/json`.
                case json(Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteSocialAccountForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteSocialAccountForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/social_accounts/delete(users/delete-social-account-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List SSH signing keys for the authenticated user
    ///
    /// Lists the SSH signing keys for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)`.
    public enum UsersListSshSigningKeysForAuthenticatedUser {
        public static let id: Swift.String = "users/list-ssh-signing-keys-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSshSigningKeysForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSshSigningKeysForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.UsersListSshSigningKeysForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SshSigningKey])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SshSigningKey] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListSshSigningKeysForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/get(users/list-ssh-signing-keys-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a SSH signing key for the authenticated user
    ///
    /// Creates an SSH signing key for the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)`.
    public enum UsersCreateSshSigningKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/create-ssh-signing-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreateSshSigningKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersCreateSshSigningKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A descriptive name for the new key.
                    ///
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/requestBody/json/title`.
                    public var title: Swift.String?
                    /// The public SSH key to add to your GitHub account. For more information, see "[Checking for existing SSH keys](https://docs.github.com/authentication/connecting-to-github-with-ssh/checking-for-existing-ssh-keys)."
                    ///
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/requestBody/json/key`.
                    public var key: Swift.String
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - title: A descriptive name for the new key.
                    ///   - key: The public SSH key to add to your GitHub account. For more information, see "[Checking for existing SSH keys](https://docs.github.com/authentication/connecting-to-github-with-ssh/checking-for-existing-ssh-keys)."
                    public init(
                        title: Swift.String? = nil,
                        key: Swift.String
                    ) {
                        self.title = title
                        self.key = key
                    }
                    public enum CodingKeys: String, CodingKey {
                        case title
                        case key
                    }
                }
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/requestBody/content/application\/json`.
                case json(Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.SshSigningKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SshSigningKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersCreateSshSigningKeyForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/post(users/create-ssh-signing-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an SSH signing key for the authenticated user
    ///
    /// Gets extended details for an SSH signing key.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)`.
    public enum UsersGetSshSigningKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/get-ssh-signing-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the SSH signing key.
                ///
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/GET/path/ssh_signing_key_id`.
                public var sshSigningKeyId: Components.Parameters.SshSigningKeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - sshSigningKeyId: The unique identifier of the SSH signing key.
                public init(sshSigningKeyId: Components.Parameters.SshSigningKeyId) {
                    self.sshSigningKeyId = sshSigningKeyId
                }
            }
            public var path: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetSshSigningKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetSshSigningKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SshSigningKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SshSigningKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetSshSigningKeyForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/get(users/get-ssh-signing-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an SSH signing key for the authenticated user
    ///
    /// Deletes an SSH signing key from the authenticated user's GitHub account.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/ssh_signing_keys/{ssh_signing_key_id}`.
    /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)`.
    public enum UsersDeleteSshSigningKeyForAuthenticatedUser {
        public static let id: Swift.String = "users/delete-ssh-signing-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the SSH signing key.
                ///
                /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/DELETE/path/ssh_signing_key_id`.
                public var sshSigningKeyId: Components.Parameters.SshSigningKeyId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - sshSigningKeyId: The unique identifier of the SSH signing key.
                public init(sshSigningKeyId: Components.Parameters.SshSigningKeyId) {
                    self.sshSigningKeyId = sshSigningKeyId
                }
            }
            public var path: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/ssh_signing_keys/{ssh_signing_key_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Path,
                headers: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteSshSigningKeyForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/ssh_signing_keys/{ssh_signing_key_id}/delete(users/delete-ssh-signing-key-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a user using their ID
    ///
    /// Provides publicly available information about someone with a GitHub account. This method takes their durable user `ID` instead of their `login`, which can change over time.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /user/{account_id}`.
    /// - Remark: Generated from `#/paths//user/{account_id}/get(users/get-by-id)`.
    public enum UsersGetById {
        public static let id: Swift.String = "users/get-by-id"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/{account_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// account_id parameter
                ///
                /// - Remark: Generated from `#/paths/user/{account_id}/GET/path/account_id`.
                public var accountId: Components.Parameters.AccountId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - accountId: account_id parameter
                public init(accountId: Components.Parameters.AccountId) {
                    self.accountId = accountId
                }
            }
            public var path: Operations.UsersGetById.Input.Path
            /// - Remark: Generated from `#/paths/user/{account_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetById.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetById.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetById.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersGetById.Input.Path,
                headers: Operations.UsersGetById.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/{account_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/{account_id}/GET/responses/200/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/{account_id}/GET/responses/200/content/json/PrivateUser`.
                        case _private(Components.Schemas.PrivateUser)
                        /// - Remark: Generated from `#/paths/user/{account_id}/GET/responses/200/content/json/PublicUser`.
                        case _public(Components.Schemas.PublicUser)
                        public enum CodingKeys: String, CodingKey {
                            case userViewType = "user_view_type"
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            let discriminator = try container.decode(
                                Swift.String.self,
                                forKey: .userViewType
                            )
                            switch discriminator {
                            case "private":
                                self = ._private(try .init(from: decoder))
                            case "public":
                                self = ._public(try .init(from: decoder))
                            default:
                                throw Swift.DecodingError.unknownOneOfDiscriminator(
                                    discriminatorKey: CodingKeys.userViewType,
                                    discriminatorValue: discriminator,
                                    codingPath: decoder.codingPath
                                )
                            }
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let ._private(value):
                                try value.encode(to: encoder)
                            case let ._public(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/{account_id}/GET/responses/200/content/application\/json`.
                    case json(Operations.UsersGetById.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.UsersGetById.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetById.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetById.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/{account_id}/get(users/get-by-id)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetById.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetById.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/{account_id}/get(users/get-by-id)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List users
    ///
    /// Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
    ///
    /// Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.
    ///
    /// - Remark: HTTP `GET /users`.
    /// - Remark: Generated from `#/paths//users/get(users/list)`.
    public enum UsersList {
        public static let id: Swift.String = "users/list"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A user ID. Only return users with an ID greater than this ID.
                ///
                /// - Remark: Generated from `#/paths/users/GET/query/since`.
                public var since: Components.Parameters.SinceUser?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: A user ID. Only return users with an ID greater than this ID.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    since: Components.Parameters.SinceUser? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.since = since
                    self.perPage = perPage
                }
            }
            public var query: Operations.UsersList.Input.Query
            /// - Remark: Generated from `#/paths/users/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersList.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersList.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersList.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.UsersList.Input.Query = .init(),
                headers: Operations.UsersList.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/GET/responses/200/headers/Link`.
                    public var link: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Swift.String? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersList.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersList.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersList.Output.Ok.Headers = .init(),
                    body: Operations.UsersList.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/get(users/list)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersList.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersList.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//users/get(users/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//users/get(users/list)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a user
    ///
    /// Provides publicly available information about someone with a GitHub account.
    ///
    /// If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.
    ///
    /// The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#authentication).
    ///
    /// The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/rest/users/emails).
    ///
    /// - Remark: HTTP `GET /users/{username}`.
    /// - Remark: Generated from `#/paths//users/{username}/get(users/get-by-username)`.
    public enum UsersGetByUsername {
        public static let id: Swift.String = "users/get-by-username"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersGetByUsername.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetByUsername.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetByUsername.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetByUsername.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersGetByUsername.Input.Path,
                headers: Operations.UsersGetByUsername.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/GET/responses/200/content/json`.
                    @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/users/{username}/GET/responses/200/content/json/PrivateUser`.
                        case _private(Components.Schemas.PrivateUser)
                        /// - Remark: Generated from `#/paths/users/{username}/GET/responses/200/content/json/PublicUser`.
                        case _public(Components.Schemas.PublicUser)
                        public enum CodingKeys: String, CodingKey {
                            case userViewType = "user_view_type"
                        }
                        public init(from decoder: any Decoder) throws {
                            let container = try decoder.container(keyedBy: CodingKeys.self)
                            let discriminator = try container.decode(
                                Swift.String.self,
                                forKey: .userViewType
                            )
                            switch discriminator {
                            case "private":
                                self = ._private(try .init(from: decoder))
                            case "public":
                                self = ._public(try .init(from: decoder))
                            default:
                                throw Swift.DecodingError.unknownOneOfDiscriminator(
                                    discriminatorKey: CodingKeys.userViewType,
                                    discriminatorValue: discriminator,
                                    codingPath: decoder.codingPath
                                )
                            }
                        }
                        public func encode(to encoder: any Encoder) throws {
                            switch self {
                            case let ._private(value):
                                try value.encode(to: encoder)
                            case let ._public(value):
                                try value.encode(to: encoder)
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/GET/responses/200/content/application\/json`.
                    case json(Operations.UsersGetByUsername.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.UsersGetByUsername.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetByUsername.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetByUsername.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/get(users/get-by-username)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetByUsername.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetByUsername.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/get(users/get-by-username)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List attestations by bulk subject digests
    ///
    /// List a collection of artifact attestations associated with any entry in a list of subject digests owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/bulk-list`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/bulk-list/post(users/list-attestations-bulk)`.
    public enum UsersListAttestationsBulk {
        public static let id: Swift.String = "users/list-attestations-bulk"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListAttestationsBulk.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                }
            }
            public var query: Operations.UsersListAttestationsBulk.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListAttestationsBulk.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListAttestationsBulk.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListAttestationsBulk.Input.Headers
            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of subject digests to fetch attestations for.
                    ///
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/requestBody/json/subject_digests`.
                    public var subjectDigests: [Swift.String]
                    /// Optional filter for fetching attestations with a given predicate type.
                    /// This option accepts `provenance`, `sbom`, or freeform text for custom predicate types.
                    ///
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/requestBody/json/predicate_type`.
                    public var predicateType: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - subjectDigests: List of subject digests to fetch attestations for.
                    ///   - predicateType: Optional filter for fetching attestations with a given predicate type.
                    public init(
                        subjectDigests: [Swift.String],
                        predicateType: Swift.String? = nil
                    ) {
                        self.subjectDigests = subjectDigests
                        self.predicateType = predicateType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case subjectDigests = "subject_digests"
                        case predicateType = "predicate_type"
                    }
                }
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/requestBody/content/application\/json`.
                case json(Operations.UsersListAttestationsBulk.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersListAttestationsBulk.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.UsersListAttestationsBulk.Input.Path,
                query: Operations.UsersListAttestationsBulk.Input.Query = .init(),
                headers: Operations.UsersListAttestationsBulk.Input.Headers = .init(),
                body: Operations.UsersListAttestationsBulk.Input.Body
            ) {
                self.path = path
                self.query = query
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// Mapping of subject digest to bundles.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests`.
                        public struct AttestationsSubjectDigestsPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload`.
                            public struct AdditionalPropertiesPayloadPayload: Codable, Hashable, Sendable {
                                /// The bundle of the attestation.
                                ///
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle`.
                                public struct BundlePayload: Codable, Hashable, Sendable {
                                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/mediaType`.
                                    public var mediaType: Swift.String?
                                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/verificationMaterial`.
                                    public struct VerificationMaterialPayload: Codable, Hashable, Sendable {
                                        /// A container of undocumented properties.
                                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                        /// Creates a new `VerificationMaterialPayload`.
                                        ///
                                        /// - Parameters:
                                        ///   - additionalProperties: A container of undocumented properties.
                                        public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                            self.additionalProperties = additionalProperties
                                        }
                                        public init(from decoder: any Decoder) throws {
                                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                        }
                                        public func encode(to encoder: any Encoder) throws {
                                            try encoder.encodeAdditionalProperties(additionalProperties)
                                        }
                                    }
                                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/verificationMaterial`.
                                    public var verificationMaterial: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.VerificationMaterialPayload?
                                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/dsseEnvelope`.
                                    public struct DsseEnvelopePayload: Codable, Hashable, Sendable {
                                        /// A container of undocumented properties.
                                        public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                        /// Creates a new `DsseEnvelopePayload`.
                                        ///
                                        /// - Parameters:
                                        ///   - additionalProperties: A container of undocumented properties.
                                        public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                            self.additionalProperties = additionalProperties
                                        }
                                        public init(from decoder: any Decoder) throws {
                                            additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                        }
                                        public func encode(to encoder: any Encoder) throws {
                                            try encoder.encodeAdditionalProperties(additionalProperties)
                                        }
                                    }
                                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle/dsseEnvelope`.
                                    public var dsseEnvelope: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.DsseEnvelopePayload?
                                    /// Creates a new `BundlePayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - mediaType:
                                    ///   - verificationMaterial:
                                    ///   - dsseEnvelope:
                                    public init(
                                        mediaType: Swift.String? = nil,
                                        verificationMaterial: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.VerificationMaterialPayload? = nil,
                                        dsseEnvelope: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload.DsseEnvelopePayload? = nil
                                    ) {
                                        self.mediaType = mediaType
                                        self.verificationMaterial = verificationMaterial
                                        self.dsseEnvelope = dsseEnvelope
                                    }
                                    public enum CodingKeys: String, CodingKey {
                                        case mediaType
                                        case verificationMaterial
                                        case dsseEnvelope
                                    }
                                }
                                /// The bundle of the attestation.
                                ///
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle`.
                                public var bundle: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload?
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/repository_id`.
                                public var repositoryId: Swift.Int?
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/AdditionalPropertiesPayload/bundle_url`.
                                public var bundleUrl: Swift.String?
                                /// Creates a new `AdditionalPropertiesPayloadPayload`.
                                ///
                                /// - Parameters:
                                ///   - bundle: The bundle of the attestation.
                                ///   - repositoryId:
                                ///   - bundleUrl:
                                public init(
                                    bundle: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload.BundlePayload? = nil,
                                    repositoryId: Swift.Int? = nil,
                                    bundleUrl: Swift.String? = nil
                                ) {
                                    self.bundle = bundle
                                    self.repositoryId = repositoryId
                                    self.bundleUrl = bundleUrl
                                }
                                public enum CodingKeys: String, CodingKey {
                                    case bundle
                                    case repositoryId = "repository_id"
                                    case bundleUrl = "bundle_url"
                                }
                            }
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests/additionalProperties`.
                            public typealias AdditionalPropertiesPayload = [Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayloadPayload]
                            /// A container of undocumented properties.
                            public var additionalProperties: [String: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayload?]
                            /// Creates a new `AttestationsSubjectDigestsPayload`.
                            ///
                            /// - Parameters:
                            ///   - additionalProperties: A container of undocumented properties.
                            public init(additionalProperties: [String: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload.AdditionalPropertiesPayload?] = .init()) {
                                self.additionalProperties = additionalProperties
                            }
                            public init(from decoder: any Decoder) throws {
                                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                            }
                            public func encode(to encoder: any Encoder) throws {
                                try encoder.encodeAdditionalProperties(additionalProperties)
                            }
                        }
                        /// Mapping of subject digest to bundles.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/attestations_subject_digests`.
                        public var attestationsSubjectDigests: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload?
                        /// Information about the current page.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info`.
                        public struct PageInfoPayload: Codable, Hashable, Sendable {
                            /// Indicates whether there is a next page.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info/has_next`.
                            public var hasNext: Swift.Bool?
                            /// Indicates whether there is a previous page.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info/has_previous`.
                            public var hasPrevious: Swift.Bool?
                            /// The cursor to the next page.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info/next`.
                            public var next: Swift.String?
                            /// The cursor to the previous page.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info/previous`.
                            public var previous: Swift.String?
                            /// Creates a new `PageInfoPayload`.
                            ///
                            /// - Parameters:
                            ///   - hasNext: Indicates whether there is a next page.
                            ///   - hasPrevious: Indicates whether there is a previous page.
                            ///   - next: The cursor to the next page.
                            ///   - previous: The cursor to the previous page.
                            public init(
                                hasNext: Swift.Bool? = nil,
                                hasPrevious: Swift.Bool? = nil,
                                next: Swift.String? = nil,
                                previous: Swift.String? = nil
                            ) {
                                self.hasNext = hasNext
                                self.hasPrevious = hasPrevious
                                self.next = next
                                self.previous = previous
                            }
                            public enum CodingKeys: String, CodingKey {
                                case hasNext = "has_next"
                                case hasPrevious = "has_previous"
                                case next
                                case previous
                            }
                        }
                        /// Information about the current page.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/json/page_info`.
                        public var pageInfo: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.PageInfoPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - attestationsSubjectDigests: Mapping of subject digest to bundles.
                        ///   - pageInfo: Information about the current page.
                        public init(
                            attestationsSubjectDigests: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.AttestationsSubjectDigestsPayload? = nil,
                            pageInfo: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload.PageInfoPayload? = nil
                        ) {
                            self.attestationsSubjectDigests = attestationsSubjectDigests
                            self.pageInfo = pageInfo
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestationsSubjectDigests = "attestations_subject_digests"
                            case pageInfo = "page_info"
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/bulk-list/POST/responses/200/content/application\/json`.
                    case json(Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.UsersListAttestationsBulk.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListAttestationsBulk.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersListAttestationsBulk.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/bulk-list/post(users/list-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListAttestationsBulk.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListAttestationsBulk.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations in bulk
    ///
    /// Delete artifact attestations in bulk by either subject digests or unique ID.
    ///
    /// - Remark: HTTP `POST /users/{username}/attestations/delete-request`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)`.
    public enum UsersDeleteAttestationsBulk {
        public static let id: Swift.String = "users/delete-attestations-bulk"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersDeleteAttestationsBulk.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsBulk.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsBulk.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteAttestationsBulk.Input.Headers
            /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// The request body must include either `subject_digests` or `attestation_ids`, but not both.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// List of subject digests associated with the artifact attestations to delete.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case1/subject_digests`.
                        public var subjectDigests: [Swift.String]
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - subjectDigests: List of subject digests associated with the artifact attestations to delete.
                        public init(subjectDigests: [Swift.String]) {
                            self.subjectDigests = subjectDigests
                        }
                        public enum CodingKeys: String, CodingKey {
                            case subjectDigests = "subject_digests"
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case1`.
                    case case1(Operations.UsersDeleteAttestationsBulk.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case2`.
                    public struct Case2Payload: Codable, Hashable, Sendable {
                        /// List of unique IDs associated with the artifact attestations to delete.
                        ///
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case2/attestation_ids`.
                        public var attestationIds: [Swift.Int]
                        /// Creates a new `Case2Payload`.
                        ///
                        /// - Parameters:
                        ///   - attestationIds: List of unique IDs associated with the artifact attestations to delete.
                        public init(attestationIds: [Swift.Int]) {
                            self.attestationIds = attestationIds
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestationIds = "attestation_ids"
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/json/case2`.
                    case case2(Operations.UsersDeleteAttestationsBulk.Input.Body.JsonPayload.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/users/{username}/attestations/delete-request/POST/requestBody/content/application\/json`.
                case json(Operations.UsersDeleteAttestationsBulk.Input.Body.JsonPayload)
            }
            public var body: Operations.UsersDeleteAttestationsBulk.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.UsersDeleteAttestationsBulk.Input.Path,
                headers: Operations.UsersDeleteAttestationsBulk.Input.Headers = .init(),
                body: Operations.UsersDeleteAttestationsBulk.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersDeleteAttestationsBulk.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersDeleteAttestationsBulk.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/delete-request/post(users/delete-attestations-bulk)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations by subject digest
    ///
    /// Delete an artifact attestation by subject digest.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/digest/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)`.
    public enum UsersDeleteAttestationsBySubjectDigest {
        public static let id: Swift.String = "users/delete-attestations-by-subject-digest"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/attestations/digest/{subject_digest}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/digest/{subject_digest}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Subject Digest
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/digest/{subject_digest}/DELETE/path/subject_digest`.
                public var subjectDigest: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                ///   - subjectDigest: Subject Digest
                public init(
                    username: Components.Parameters.Username,
                    subjectDigest: Swift.String
                ) {
                    self.username = username
                    self.subjectDigest = subjectDigest
                }
            }
            public var path: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/attestations/digest/{subject_digest}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsBySubjectDigest.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsBySubjectDigest.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Path,
                headers: Operations.UsersDeleteAttestationsBySubjectDigest.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersDeleteAttestationsBySubjectDigest.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersDeleteAttestationsBySubjectDigest.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteAttestationsBySubjectDigest.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteAttestationsBySubjectDigest.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/digest/{subject_digest}/delete(users/delete-attestations-by-subject-digest)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete attestations by ID
    ///
    /// Delete an artifact attestation by unique ID that is associated with a repository owned by a user.
    ///
    /// - Remark: HTTP `DELETE /users/{username}/attestations/{attestation_id}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)`.
    public enum UsersDeleteAttestationsById {
        public static let id: Swift.String = "users/delete-attestations-by-id"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/attestations/{attestation_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{attestation_id}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// Attestation ID
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{attestation_id}/DELETE/path/attestation_id`.
                public var attestationId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                ///   - attestationId: Attestation ID
                public init(
                    username: Components.Parameters.Username,
                    attestationId: Swift.Int
                ) {
                    self.username = username
                    self.attestationId = attestationId
                }
            }
            public var path: Operations.UsersDeleteAttestationsById.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/attestations/{attestation_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsById.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersDeleteAttestationsById.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersDeleteAttestationsById.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.UsersDeleteAttestationsById.Input.Path,
                headers: Operations.UsersDeleteAttestationsById.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// Creates a new `Ok`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersDeleteAttestationsById.Output.Ok)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            public static var ok: Self {
                .ok(.init())
            }
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersDeleteAttestationsById.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersDeleteAttestationsById.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersDeleteAttestationsById.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{attestation_id}/delete(users/delete-attestations-by-id)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with repositories owned by a user.
    ///
    /// The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /users/{username}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)`.
    public enum UsersListAttestations {
        public static let id: Swift.String = "users/list-attestations"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Subject Digest
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/path/subject_digest`.
                public var subjectDigest: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                ///   - subjectDigest: Subject Digest
                public init(
                    username: Components.Parameters.Username,
                    subjectDigest: Swift.String
                ) {
                    self.username = username
                    self.subjectDigest = subjectDigest
                }
            }
            public var path: Operations.UsersListAttestations.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// Optional filter for fetching attestations with a given predicate type.
                /// This option accepts `provenance`, `sbom`, or freeform text for custom predicate types.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/query/predicate_type`.
                public var predicateType: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - predicateType: Optional filter for fetching attestations with a given predicate type.
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    predicateType: Swift.String? = nil
                ) {
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.predicateType = predicateType
                }
            }
            public var query: Operations.UsersListAttestations.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListAttestations.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListAttestations.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListAttestations.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListAttestations.Input.Path,
                query: Operations.UsersListAttestations.Input.Query = .init(),
                headers: Operations.UsersListAttestations.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload`.
                        public struct AttestationsPayloadPayload: Codable, Hashable, Sendable {
                            /// The attestation's Sigstore Bundle.
                            /// Refer to the [Sigstore Bundle Specification](https://github.com/sigstore/protobuf-specs/blob/main/protos/sigstore_bundle.proto) for more information.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle`.
                            public struct BundlePayload: Codable, Hashable, Sendable {
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/mediaType`.
                                public var mediaType: Swift.String?
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/verificationMaterial`.
                                public struct VerificationMaterialPayload: Codable, Hashable, Sendable {
                                    /// A container of undocumented properties.
                                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                    /// Creates a new `VerificationMaterialPayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - additionalProperties: A container of undocumented properties.
                                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                        self.additionalProperties = additionalProperties
                                    }
                                    public init(from decoder: any Decoder) throws {
                                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                    }
                                    public func encode(to encoder: any Encoder) throws {
                                        try encoder.encodeAdditionalProperties(additionalProperties)
                                    }
                                }
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/verificationMaterial`.
                                public var verificationMaterial: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.VerificationMaterialPayload?
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/dsseEnvelope`.
                                public struct DsseEnvelopePayload: Codable, Hashable, Sendable {
                                    /// A container of undocumented properties.
                                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                                    /// Creates a new `DsseEnvelopePayload`.
                                    ///
                                    /// - Parameters:
                                    ///   - additionalProperties: A container of undocumented properties.
                                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                                        self.additionalProperties = additionalProperties
                                    }
                                    public init(from decoder: any Decoder) throws {
                                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                                    }
                                    public func encode(to encoder: any Encoder) throws {
                                        try encoder.encodeAdditionalProperties(additionalProperties)
                                    }
                                }
                                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle/dsseEnvelope`.
                                public var dsseEnvelope: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.DsseEnvelopePayload?
                                /// Creates a new `BundlePayload`.
                                ///
                                /// - Parameters:
                                ///   - mediaType:
                                ///   - verificationMaterial:
                                ///   - dsseEnvelope:
                                public init(
                                    mediaType: Swift.String? = nil,
                                    verificationMaterial: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.VerificationMaterialPayload? = nil,
                                    dsseEnvelope: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload.DsseEnvelopePayload? = nil
                                ) {
                                    self.mediaType = mediaType
                                    self.verificationMaterial = verificationMaterial
                                    self.dsseEnvelope = dsseEnvelope
                                }
                                public enum CodingKeys: String, CodingKey {
                                    case mediaType
                                    case verificationMaterial
                                    case dsseEnvelope
                                }
                            }
                            /// The attestation's Sigstore Bundle.
                            /// Refer to the [Sigstore Bundle Specification](https://github.com/sigstore/protobuf-specs/blob/main/protos/sigstore_bundle.proto) for more information.
                            ///
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle`.
                            public var bundle: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload?
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/repository_id`.
                            public var repositoryId: Swift.Int?
                            /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/AttestationsPayload/bundle_url`.
                            public var bundleUrl: Swift.String?
                            /// Creates a new `AttestationsPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - bundle: The attestation's Sigstore Bundle.
                            ///   - repositoryId:
                            ///   - bundleUrl:
                            public init(
                                bundle: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload.BundlePayload? = nil,
                                repositoryId: Swift.Int? = nil,
                                bundleUrl: Swift.String? = nil
                            ) {
                                self.bundle = bundle
                                self.repositoryId = repositoryId
                                self.bundleUrl = bundleUrl
                            }
                            public enum CodingKeys: String, CodingKey {
                                case bundle
                                case repositoryId = "repository_id"
                                case bundleUrl = "bundle_url"
                            }
                        }
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/attestations`.
                        public typealias AttestationsPayload = [Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayloadPayload]
                        /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/json/attestations`.
                        public var attestations: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - attestations:
                        public init(attestations: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload.AttestationsPayload? = nil) {
                            self.attestations = attestations
                        }
                        public enum CodingKeys: String, CodingKey {
                            case attestations
                        }
                    }
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/200/content/application\/json`.
                    case json(Operations.UsersListAttestations.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.UsersListAttestations.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListAttestations.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersListAttestations.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListAttestations.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListAttestations.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/attestations/{subject_digest}/GET/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListAttestations.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersListAttestations.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.UsersListAttestations.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.UsersListAttestations.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersListAttestations.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersListAttestations.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/attestations/{subject_digest}/get(users/list-attestations)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List followers of a user
    ///
    /// Lists the people following the specified user.
    ///
    /// - Remark: HTTP `GET /users/{username}/followers`.
    /// - Remark: Generated from `#/paths//users/{username}/followers/get(users/list-followers-for-user)`.
    public enum UsersListFollowersForUser {
        public static let id: Swift.String = "users/list-followers-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/followers/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/followers/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListFollowersForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/followers/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/followers/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/followers/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListFollowersForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/followers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowersForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowersForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListFollowersForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListFollowersForUser.Input.Path,
                query: Operations.UsersListFollowersForUser.Input.Query = .init(),
                headers: Operations.UsersListFollowersForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/followers/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/followers/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListFollowersForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/followers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/followers/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListFollowersForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListFollowersForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListFollowersForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/followers/get(users/list-followers-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListFollowersForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListFollowersForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List the people a user follows
    ///
    /// Lists the people who the specified user follows.
    ///
    /// - Remark: HTTP `GET /users/{username}/following`.
    /// - Remark: Generated from `#/paths//users/{username}/following/get(users/list-following-for-user)`.
    public enum UsersListFollowingForUser {
        public static let id: Swift.String = "users/list-following-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/following/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/following/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListFollowingForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/following/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/following/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/following/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListFollowingForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/following/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowingForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListFollowingForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListFollowingForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListFollowingForUser.Input.Path,
                query: Operations.UsersListFollowingForUser.Input.Query = .init(),
                headers: Operations.UsersListFollowingForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/following/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/following/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListFollowingForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/following/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/following/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SimpleUser])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SimpleUser] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListFollowingForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListFollowingForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListFollowingForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/following/get(users/list-following-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListFollowingForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListFollowingForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if a user follows another user
    ///
    ///
    ///
    /// - Remark: HTTP `GET /users/{username}/following/{target_user}`.
    /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)`.
    public enum UsersCheckFollowingForUser {
        public static let id: Swift.String = "users/check-following-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/following/{target_user}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/following/{target_user}/GET/path/username`.
                public var username: Components.Parameters.Username
                /// - Remark: Generated from `#/paths/users/{username}/following/{target_user}/GET/path/target_user`.
                public var targetUser: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                ///   - targetUser:
                public init(
                    username: Components.Parameters.Username,
                    targetUser: Swift.String
                ) {
                    self.username = username
                    self.targetUser = targetUser
                }
            }
            public var path: Operations.UsersCheckFollowingForUser.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.UsersCheckFollowingForUser.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// if the user follows the target user
            ///
            /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.UsersCheckFollowingForUser.Output.NoContent)
            /// if the user follows the target user
            ///
            /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.UsersCheckFollowingForUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// if the user does not follow the target user
            ///
            /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.UsersCheckFollowingForUser.Output.NotFound)
            /// if the user does not follow the target user
            ///
            /// - Remark: Generated from `#/paths//users/{username}/following/{target_user}/get(users/check-following-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.UsersCheckFollowingForUser.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List GPG keys for a user
    ///
    /// Lists the GPG keys for a user. This information is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/gpg_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/gpg_keys/get(users/list-gpg-keys-for-user)`.
    public enum UsersListGpgKeysForUser {
        public static let id: Swift.String = "users/list-gpg-keys-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListGpgKeysForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListGpgKeysForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListGpgKeysForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListGpgKeysForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListGpgKeysForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListGpgKeysForUser.Input.Path,
                query: Operations.UsersListGpgKeysForUser.Input.Query = .init(),
                headers: Operations.UsersListGpgKeysForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListGpgKeysForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/gpg_keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GpgKey])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GpgKey] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListGpgKeysForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListGpgKeysForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListGpgKeysForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/gpg_keys/get(users/list-gpg-keys-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListGpgKeysForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListGpgKeysForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get contextual information for a user
    ///
    /// Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
    ///
    ///   The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /users/{username}/hovercard`.
    /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)`.
    public enum UsersGetContextForUser {
        public static let id: Swift.String = "users/get-context-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersGetContextForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/query/subject_type`.
                @frozen public enum SubjectTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case organization = "organization"
                    case repository = "repository"
                    case issue = "issue"
                    case pullRequest = "pull_request"
                }
                /// Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/query/subject_type`.
                public var subjectType: Operations.UsersGetContextForUser.Input.Query.SubjectTypePayload?
                /// Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/query/subject_id`.
                public var subjectId: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - subjectType: Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
                ///   - subjectId: Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
                public init(
                    subjectType: Operations.UsersGetContextForUser.Input.Query.SubjectTypePayload? = nil,
                    subjectId: Swift.String? = nil
                ) {
                    self.subjectType = subjectType
                    self.subjectId = subjectId
                }
            }
            public var query: Operations.UsersGetContextForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetContextForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersGetContextForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersGetContextForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersGetContextForUser.Input.Path,
                query: Operations.UsersGetContextForUser.Input.Query = .init(),
                headers: Operations.UsersGetContextForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/hovercard/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Hovercard)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Hovercard {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersGetContextForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.UsersGetContextForUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersGetContextForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersGetContextForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//users/{username}/hovercard/get(users/get-context-for-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List public keys for a user
    ///
    /// Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/keys`.
    /// - Remark: Generated from `#/paths//users/{username}/keys/get(users/list-public-keys-for-user)`.
    public enum UsersListPublicKeysForUser {
        public static let id: Swift.String = "users/list-public-keys-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/keys/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/keys/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListPublicKeysForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListPublicKeysForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicKeysForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListPublicKeysForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListPublicKeysForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListPublicKeysForUser.Input.Path,
                query: Operations.UsersListPublicKeysForUser.Input.Query = .init(),
                headers: Operations.UsersListPublicKeysForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListPublicKeysForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.KeySimple])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.KeySimple] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListPublicKeysForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListPublicKeysForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListPublicKeysForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/keys/get(users/list-public-keys-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListPublicKeysForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListPublicKeysForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List social accounts for a user
    ///
    /// Lists social media accounts for a user. This endpoint is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/social_accounts`.
    /// - Remark: Generated from `#/paths//users/{username}/social_accounts/get(users/list-social-accounts-for-user)`.
    public enum UsersListSocialAccountsForUser {
        public static let id: Swift.String = "users/list-social-accounts-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListSocialAccountsForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListSocialAccountsForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSocialAccountsForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSocialAccountsForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListSocialAccountsForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListSocialAccountsForUser.Input.Path,
                query: Operations.UsersListSocialAccountsForUser.Input.Query = .init(),
                headers: Operations.UsersListSocialAccountsForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListSocialAccountsForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/social_accounts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SocialAccount])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SocialAccount] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListSocialAccountsForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListSocialAccountsForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListSocialAccountsForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/social_accounts/get(users/list-social-accounts-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListSocialAccountsForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListSocialAccountsForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List SSH signing keys for a user
    ///
    /// Lists the SSH signing keys for a user. This operation is accessible by anyone.
    ///
    /// - Remark: HTTP `GET /users/{username}/ssh_signing_keys`.
    /// - Remark: Generated from `#/paths//users/{username}/ssh_signing_keys/get(users/list-ssh-signing-keys-for-user)`.
    public enum UsersListSshSigningKeysForUser {
        public static let id: Swift.String = "users/list-ssh-signing-keys-for-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - username: The handle for the GitHub user account.
                public init(username: Components.Parameters.Username) {
                    self.username = username
                }
            }
            public var path: Operations.UsersListSshSigningKeysForUser.Input.Path
            /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.UsersListSshSigningKeysForUser.Input.Query
            /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSshSigningKeysForUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.UsersListSshSigningKeysForUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.UsersListSshSigningKeysForUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.UsersListSshSigningKeysForUser.Input.Path,
                query: Operations.UsersListSshSigningKeysForUser.Input.Query = .init(),
                headers: Operations.UsersListSshSigningKeysForUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.UsersListSshSigningKeysForUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/users/{username}/ssh_signing_keys/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SshSigningKey])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SshSigningKey] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.UsersListSshSigningKeysForUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.UsersListSshSigningKeysForUser.Output.Ok.Headers = .init(),
                    body: Operations.UsersListSshSigningKeysForUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//users/{username}/ssh_signing_keys/get(users/list-ssh-signing-keys-for-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.UsersListSshSigningKeysForUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.UsersListSshSigningKeysForUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
