// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List global security advisories
    ///
    /// Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.
    ///
    /// By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see "[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories)."
    ///
    /// - Remark: HTTP `GET /advisories`.
    /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)`.
    func securityAdvisoriesListGlobalAdvisories(_ input: Operations.SecurityAdvisoriesListGlobalAdvisories.Input) async throws -> Operations.SecurityAdvisoriesListGlobalAdvisories.Output
    /// Get a global security advisory
    ///
    /// Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// - Remark: HTTP `GET /advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//advisories/{ghsa_id}/get(security-advisories/get-global-advisory)`.
    func securityAdvisoriesGetGlobalAdvisory(_ input: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input) async throws -> Operations.SecurityAdvisoriesGetGlobalAdvisory.Output
    /// List repository security advisories for an organization
    ///
    /// Lists repository security advisories for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-advisories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)`.
    func securityAdvisoriesListOrgRepositoryAdvisories(_ input: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input) async throws -> Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output
    /// List repository security advisories
    ///
    /// Lists security advisories in a repository.
    ///
    /// The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)`.
    func securityAdvisoriesListRepositoryAdvisories(_ input: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input) async throws -> Operations.SecurityAdvisoriesListRepositoryAdvisories.Output
    /// Create a repository security advisory
    ///
    /// Creates a new repository security advisory.
    ///
    /// In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)`.
    func securityAdvisoriesCreateRepositoryAdvisory(_ input: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input) async throws -> Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output
    /// Privately report a security vulnerability
    ///
    /// Report a security vulnerability to the maintainers of the repository.
    /// See "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)" for more information about private vulnerability reporting.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/reports`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)`.
    func securityAdvisoriesCreatePrivateVulnerabilityReport(_ input: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input) async throws -> Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output
    /// Get a repository security advisory
    ///
    /// Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// Anyone can access any published security advisory on a public repository.
    ///
    /// The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a
    /// collaborator on the security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)`.
    func securityAdvisoriesGetRepositoryAdvisory(_ input: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input) async throws -> Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output
    /// Update a repository security advisory
    ///
    /// Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository,
    /// or a collaborator on the repository security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)`.
    func securityAdvisoriesUpdateRepositoryAdvisory(_ input: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input) async throws -> Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output
    /// Request a CVE for a repository security advisory
    ///
    /// If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see "[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional)."
    ///
    /// You may request a CVE for public repositories, but cannot do so for private repositories.
    ///
    /// In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)`.
    func securityAdvisoriesCreateRepositoryAdvisoryCveRequest(_ input: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input) async throws -> Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Output
    /// Create a temporary private fork
    ///
    /// Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.
    ///
    /// > [!NOTE]
    /// > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)`.
    func securityAdvisoriesCreateFork(_ input: Operations.SecurityAdvisoriesCreateFork.Input) async throws -> Operations.SecurityAdvisoriesCreateFork.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List global security advisories
    ///
    /// Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.
    ///
    /// By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see "[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories)."
    ///
    /// - Remark: HTTP `GET /advisories`.
    /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)`.
    public func securityAdvisoriesListGlobalAdvisories(
        query: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query = .init(),
        headers: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesListGlobalAdvisories.Output {
        try await securityAdvisoriesListGlobalAdvisories(Operations.SecurityAdvisoriesListGlobalAdvisories.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a global security advisory
    ///
    /// Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// - Remark: HTTP `GET /advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//advisories/{ghsa_id}/get(security-advisories/get-global-advisory)`.
    public func securityAdvisoriesGetGlobalAdvisory(
        path: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Path,
        headers: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesGetGlobalAdvisory.Output {
        try await securityAdvisoriesGetGlobalAdvisory(Operations.SecurityAdvisoriesGetGlobalAdvisory.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repository security advisories for an organization
    ///
    /// Lists repository security advisories for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-advisories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)`.
    public func securityAdvisoriesListOrgRepositoryAdvisories(
        path: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Path,
        query: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query = .init(),
        headers: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output {
        try await securityAdvisoriesListOrgRepositoryAdvisories(Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository security advisories
    ///
    /// Lists security advisories in a repository.
    ///
    /// The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)`.
    public func securityAdvisoriesListRepositoryAdvisories(
        path: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Path,
        query: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query = .init(),
        headers: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesListRepositoryAdvisories.Output {
        try await securityAdvisoriesListRepositoryAdvisories(Operations.SecurityAdvisoriesListRepositoryAdvisories.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository security advisory
    ///
    /// Creates a new repository security advisory.
    ///
    /// In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)`.
    public func securityAdvisoriesCreateRepositoryAdvisory(
        path: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Path,
        headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Headers = .init(),
        body: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Body
    ) async throws -> Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output {
        try await securityAdvisoriesCreateRepositoryAdvisory(Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Privately report a security vulnerability
    ///
    /// Report a security vulnerability to the maintainers of the repository.
    /// See "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)" for more information about private vulnerability reporting.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/reports`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)`.
    public func securityAdvisoriesCreatePrivateVulnerabilityReport(
        path: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Path,
        headers: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Headers = .init(),
        body: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Body
    ) async throws -> Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output {
        try await securityAdvisoriesCreatePrivateVulnerabilityReport(Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a repository security advisory
    ///
    /// Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// Anyone can access any published security advisory on a public repository.
    ///
    /// The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a
    /// collaborator on the security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)`.
    public func securityAdvisoriesGetRepositoryAdvisory(
        path: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Path,
        headers: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output {
        try await securityAdvisoriesGetRepositoryAdvisory(Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a repository security advisory
    ///
    /// Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository,
    /// or a collaborator on the repository security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)`.
    public func securityAdvisoriesUpdateRepositoryAdvisory(
        path: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Path,
        headers: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Headers = .init(),
        body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Body
    ) async throws -> Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output {
        try await securityAdvisoriesUpdateRepositoryAdvisory(Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Request a CVE for a repository security advisory
    ///
    /// If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see "[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional)."
    ///
    /// You may request a CVE for public repositories, but cannot do so for private repositories.
    ///
    /// In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)`.
    public func securityAdvisoriesCreateRepositoryAdvisoryCveRequest(
        path: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Path,
        headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Output {
        try await securityAdvisoriesCreateRepositoryAdvisoryCveRequest(Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a temporary private fork
    ///
    /// Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.
    ///
    /// > [!NOTE]
    /// > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)`.
    public func securityAdvisoriesCreateFork(
        path: Operations.SecurityAdvisoriesCreateFork.Input.Path,
        headers: Operations.SecurityAdvisoriesCreateFork.Input.Headers = .init()
    ) async throws -> Operations.SecurityAdvisoriesCreateFork.Output {
        try await securityAdvisoriesCreateFork(Operations.SecurityAdvisoriesCreateFork.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// The package's language or package management ecosystem.
        ///
        /// - Remark: Generated from `#/components/schemas/security-advisory-ecosystems`.
        @frozen public enum SecurityAdvisoryEcosystems: String, Codable, Hashable, Sendable, CaseIterable {
            case rubygems = "rubygems"
            case npm = "npm"
            case pip = "pip"
            case maven = "maven"
            case nuget = "nuget"
            case composer = "composer"
            case go = "go"
            case rust = "rust"
            case erlang = "erlang"
            case actions = "actions"
            case pub = "pub"
            case other = "other"
            case swift = "swift"
        }
        /// A vulnerability describing the product and its affected versions within a GitHub Security Advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/vulnerability`.
        public struct Vulnerability: Codable, Hashable, Sendable {
            /// The name of the package affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/vulnerability/package`.
            public struct PackagePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/vulnerability/package/ecosystem`.
                public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems
                /// The unique package name within its ecosystem.
                ///
                /// - Remark: Generated from `#/components/schemas/vulnerability/package/name`.
                public var name: Swift.String?
                /// Creates a new `PackagePayload`.
                ///
                /// - Parameters:
                ///   - ecosystem:
                ///   - name: The unique package name within its ecosystem.
                public init(
                    ecosystem: Components.Schemas.SecurityAdvisoryEcosystems,
                    name: Swift.String? = nil
                ) {
                    self.ecosystem = ecosystem
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case ecosystem
                    case name
                }
            }
            /// The name of the package affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/vulnerability/package`.
            public var package: Components.Schemas.Vulnerability.PackagePayload?
            /// The range of the package versions affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/vulnerability/vulnerable_version_range`.
            public var vulnerableVersionRange: Swift.String?
            /// The package version that resolves the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/vulnerability/first_patched_version`.
            public var firstPatchedVersion: Swift.String?
            /// The functions in the package that are affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/vulnerability/vulnerable_functions`.
            public var vulnerableFunctions: [Swift.String]?
            /// Creates a new `Vulnerability`.
            ///
            /// - Parameters:
            ///   - package: The name of the package affected by the vulnerability.
            ///   - vulnerableVersionRange: The range of the package versions affected by the vulnerability.
            ///   - firstPatchedVersion: The package version that resolves the vulnerability.
            ///   - vulnerableFunctions: The functions in the package that are affected by the vulnerability.
            public init(
                package: Components.Schemas.Vulnerability.PackagePayload? = nil,
                vulnerableVersionRange: Swift.String? = nil,
                firstPatchedVersion: Swift.String? = nil,
                vulnerableFunctions: [Swift.String]? = nil
            ) {
                self.package = package
                self.vulnerableVersionRange = vulnerableVersionRange
                self.firstPatchedVersion = firstPatchedVersion
                self.vulnerableFunctions = vulnerableFunctions
            }
            public enum CodingKeys: String, CodingKey {
                case package
                case vulnerableVersionRange = "vulnerable_version_range"
                case firstPatchedVersion = "first_patched_version"
                case vulnerableFunctions = "vulnerable_functions"
            }
        }
        /// - Remark: Generated from `#/components/schemas/cvss-severities`.
        public struct CvssSeverities: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3`.
            public struct CvssV3Payload: Codable, Hashable, Sendable {
                /// The CVSS 3 vector string.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS 3 score.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssV3Payload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS 3 vector string.
                ///   - score: The CVSS 3 score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3`.
            public var cvssV3: Components.Schemas.CvssSeverities.CvssV3Payload?
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4`.
            public struct CvssV4Payload: Codable, Hashable, Sendable {
                /// The CVSS 4 vector string.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS 4 score.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssV4Payload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS 4 vector string.
                ///   - score: The CVSS 4 score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4`.
            public var cvssV4: Components.Schemas.CvssSeverities.CvssV4Payload?
            /// Creates a new `CvssSeverities`.
            ///
            /// - Parameters:
            ///   - cvssV3:
            ///   - cvssV4:
            public init(
                cvssV3: Components.Schemas.CvssSeverities.CvssV3Payload? = nil,
                cvssV4: Components.Schemas.CvssSeverities.CvssV4Payload? = nil
            ) {
                self.cvssV3 = cvssV3
                self.cvssV4 = cvssV4
            }
            public enum CodingKeys: String, CodingKey {
                case cvssV3 = "cvss_v3"
                case cvssV4 = "cvss_v4"
            }
        }
        /// The EPSS scores as calculated by the [Exploit Prediction Scoring System](https://www.first.org/epss).
        ///
        /// - Remark: Generated from `#/components/schemas/security-advisory-epss`.
        public struct SecurityAdvisoryEpss: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/security-advisory-epss/percentage`.
            public var percentage: Swift.Double?
            /// - Remark: Generated from `#/components/schemas/security-advisory-epss/percentile`.
            public var percentile: Swift.Double?
            /// Creates a new `SecurityAdvisoryEpss`.
            ///
            /// - Parameters:
            ///   - percentage:
            ///   - percentile:
            public init(
                percentage: Swift.Double? = nil,
                percentile: Swift.Double? = nil
            ) {
                self.percentage = percentage
                self.percentile = percentile
            }
            public enum CodingKeys: String, CodingKey {
                case percentage
                case percentile
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// The type of credit the user is receiving.
        ///
        /// - Remark: Generated from `#/components/schemas/security-advisory-credit-types`.
        @frozen public enum SecurityAdvisoryCreditTypes: String, Codable, Hashable, Sendable, CaseIterable {
            case analyst = "analyst"
            case finder = "finder"
            case reporter = "reporter"
            case coordinator = "coordinator"
            case remediationDeveloper = "remediation_developer"
            case remediationReviewer = "remediation_reviewer"
            case remediationVerifier = "remediation_verifier"
            case tool = "tool"
            case sponsor = "sponsor"
            case other = "other"
        }
        /// A GitHub Security Advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/global-advisory`.
        public struct GlobalAdvisory: Codable, Hashable, Sendable {
            /// The GitHub Security Advisory ID.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/ghsa_id`.
            public var ghsaId: Swift.String
            /// The Common Vulnerabilities and Exposures (CVE) ID.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/cve_id`.
            public var cveId: Swift.String?
            /// The API URL for the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/url`.
            public var url: Swift.String
            /// The URL for the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/html_url`.
            public var htmlUrl: Swift.String
            /// The API URL for the repository advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/repository_advisory_url`.
            public var repositoryAdvisoryUrl: Swift.String?
            /// A short summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/summary`.
            public var summary: Swift.String
            /// A detailed description of what the advisory entails.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/description`.
            public var description: Swift.String?
            /// The type of advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case reviewed = "reviewed"
                case unreviewed = "unreviewed"
                case malware = "malware"
            }
            /// The type of advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/type`.
            public var _type: Components.Schemas.GlobalAdvisory._TypePayload
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case critical = "critical"
                case high = "high"
                case medium = "medium"
                case low = "low"
                case unknown = "unknown"
            }
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/severity`.
            public var severity: Components.Schemas.GlobalAdvisory.SeverityPayload
            /// The URL of the advisory's source code.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/source_code_location`.
            public var sourceCodeLocation: Swift.String?
            /// - Remark: Generated from `#/components/schemas/global-advisory/IdentifiersPayload`.
            public struct IdentifiersPayloadPayload: Codable, Hashable, Sendable {
                /// The type of identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/IdentifiersPayload/type`.
                @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case cve = "CVE"
                    case ghsa = "GHSA"
                }
                /// The type of identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/IdentifiersPayload/type`.
                public var _type: Components.Schemas.GlobalAdvisory.IdentifiersPayloadPayload._TypePayload
                /// The identifier value.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/IdentifiersPayload/value`.
                public var value: Swift.String
                /// Creates a new `IdentifiersPayloadPayload`.
                ///
                /// - Parameters:
                ///   - _type: The type of identifier.
                ///   - value: The identifier value.
                public init(
                    _type: Components.Schemas.GlobalAdvisory.IdentifiersPayloadPayload._TypePayload,
                    value: Swift.String
                ) {
                    self._type = _type
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/global-advisory/identifiers`.
            public typealias IdentifiersPayload = [Components.Schemas.GlobalAdvisory.IdentifiersPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/global-advisory/identifiers`.
            public var identifiers: Components.Schemas.GlobalAdvisory.IdentifiersPayload?
            /// - Remark: Generated from `#/components/schemas/global-advisory/references`.
            public var references: [Swift.String]?
            /// The date and time of when the advisory was published, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/published_at`.
            public var publishedAt: Foundation.Date
            /// The date and time of when the advisory was last updated, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/updated_at`.
            public var updatedAt: Foundation.Date
            /// The date and time of when the advisory was reviewed by GitHub, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/github_reviewed_at`.
            public var githubReviewedAt: Foundation.Date?
            /// The date and time when the advisory was published in the National Vulnerability Database, in ISO 8601 format.
            /// This field is only populated when the advisory is imported from the National Vulnerability Database.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/nvd_published_at`.
            public var nvdPublishedAt: Foundation.Date?
            /// The date and time of when the advisory was withdrawn, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/withdrawn_at`.
            public var withdrawnAt: Foundation.Date?
            /// The products and respective version ranges affected by the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/vulnerabilities`.
            public var vulnerabilities: [Components.Schemas.Vulnerability]?
            /// - Remark: Generated from `#/components/schemas/global-advisory/cvss`.
            public struct CvssPayload: Codable, Hashable, Sendable {
                /// The CVSS vector.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/cvss/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS score.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/cvss/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssPayload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS vector.
                ///   - score: The CVSS score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/global-advisory/cvss`.
            public var cvss: Components.Schemas.GlobalAdvisory.CvssPayload?
            /// - Remark: Generated from `#/components/schemas/global-advisory/cvss_severities`.
            public var cvssSeverities: Components.Schemas.CvssSeverities?
            /// - Remark: Generated from `#/components/schemas/global-advisory/epss`.
            public var epss: Components.Schemas.SecurityAdvisoryEpss?
            /// - Remark: Generated from `#/components/schemas/global-advisory/CwesPayload`.
            public struct CwesPayloadPayload: Codable, Hashable, Sendable {
                /// The Common Weakness Enumeration (CWE) identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/CwesPayload/cwe_id`.
                public var cweId: Swift.String
                /// The name of the CWE.
                ///
                /// - Remark: Generated from `#/components/schemas/global-advisory/CwesPayload/name`.
                public var name: Swift.String
                /// Creates a new `CwesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - cweId: The Common Weakness Enumeration (CWE) identifier.
                ///   - name: The name of the CWE.
                public init(
                    cweId: Swift.String,
                    name: Swift.String
                ) {
                    self.cweId = cweId
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case cweId = "cwe_id"
                    case name
                }
            }
            /// - Remark: Generated from `#/components/schemas/global-advisory/cwes`.
            public typealias CwesPayload = [Components.Schemas.GlobalAdvisory.CwesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/global-advisory/cwes`.
            public var cwes: Components.Schemas.GlobalAdvisory.CwesPayload?
            /// - Remark: Generated from `#/components/schemas/global-advisory/CreditsPayload`.
            public struct CreditsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/global-advisory/CreditsPayload/user`.
                public var user: Components.Schemas.SimpleUser
                /// - Remark: Generated from `#/components/schemas/global-advisory/CreditsPayload/type`.
                public var _type: Components.Schemas.SecurityAdvisoryCreditTypes
                /// Creates a new `CreditsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - user:
                ///   - _type:
                public init(
                    user: Components.Schemas.SimpleUser,
                    _type: Components.Schemas.SecurityAdvisoryCreditTypes
                ) {
                    self.user = user
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case user
                    case _type = "type"
                }
            }
            /// The users who contributed to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/credits`.
            public typealias CreditsPayload = [Components.Schemas.GlobalAdvisory.CreditsPayloadPayload]
            /// The users who contributed to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/global-advisory/credits`.
            public var credits: Components.Schemas.GlobalAdvisory.CreditsPayload?
            /// Creates a new `GlobalAdvisory`.
            ///
            /// - Parameters:
            ///   - ghsaId: The GitHub Security Advisory ID.
            ///   - cveId: The Common Vulnerabilities and Exposures (CVE) ID.
            ///   - url: The API URL for the advisory.
            ///   - htmlUrl: The URL for the advisory.
            ///   - repositoryAdvisoryUrl: The API URL for the repository advisory.
            ///   - summary: A short summary of the advisory.
            ///   - description: A detailed description of what the advisory entails.
            ///   - _type: The type of advisory.
            ///   - severity: The severity of the advisory.
            ///   - sourceCodeLocation: The URL of the advisory's source code.
            ///   - identifiers:
            ///   - references:
            ///   - publishedAt: The date and time of when the advisory was published, in ISO 8601 format.
            ///   - updatedAt: The date and time of when the advisory was last updated, in ISO 8601 format.
            ///   - githubReviewedAt: The date and time of when the advisory was reviewed by GitHub, in ISO 8601 format.
            ///   - nvdPublishedAt: The date and time when the advisory was published in the National Vulnerability Database, in ISO 8601 format.
            ///   - withdrawnAt: The date and time of when the advisory was withdrawn, in ISO 8601 format.
            ///   - vulnerabilities: The products and respective version ranges affected by the advisory.
            ///   - cvss:
            ///   - cvssSeverities:
            ///   - epss:
            ///   - cwes:
            ///   - credits: The users who contributed to the advisory.
            public init(
                ghsaId: Swift.String,
                cveId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                repositoryAdvisoryUrl: Swift.String? = nil,
                summary: Swift.String,
                description: Swift.String? = nil,
                _type: Components.Schemas.GlobalAdvisory._TypePayload,
                severity: Components.Schemas.GlobalAdvisory.SeverityPayload,
                sourceCodeLocation: Swift.String? = nil,
                identifiers: Components.Schemas.GlobalAdvisory.IdentifiersPayload? = nil,
                references: [Swift.String]? = nil,
                publishedAt: Foundation.Date,
                updatedAt: Foundation.Date,
                githubReviewedAt: Foundation.Date? = nil,
                nvdPublishedAt: Foundation.Date? = nil,
                withdrawnAt: Foundation.Date? = nil,
                vulnerabilities: [Components.Schemas.Vulnerability]? = nil,
                cvss: Components.Schemas.GlobalAdvisory.CvssPayload? = nil,
                cvssSeverities: Components.Schemas.CvssSeverities? = nil,
                epss: Components.Schemas.SecurityAdvisoryEpss? = nil,
                cwes: Components.Schemas.GlobalAdvisory.CwesPayload? = nil,
                credits: Components.Schemas.GlobalAdvisory.CreditsPayload? = nil
            ) {
                self.ghsaId = ghsaId
                self.cveId = cveId
                self.url = url
                self.htmlUrl = htmlUrl
                self.repositoryAdvisoryUrl = repositoryAdvisoryUrl
                self.summary = summary
                self.description = description
                self._type = _type
                self.severity = severity
                self.sourceCodeLocation = sourceCodeLocation
                self.identifiers = identifiers
                self.references = references
                self.publishedAt = publishedAt
                self.updatedAt = updatedAt
                self.githubReviewedAt = githubReviewedAt
                self.nvdPublishedAt = nvdPublishedAt
                self.withdrawnAt = withdrawnAt
                self.vulnerabilities = vulnerabilities
                self.cvss = cvss
                self.cvssSeverities = cvssSeverities
                self.epss = epss
                self.cwes = cwes
                self.credits = credits
            }
            public enum CodingKeys: String, CodingKey {
                case ghsaId = "ghsa_id"
                case cveId = "cve_id"
                case url
                case htmlUrl = "html_url"
                case repositoryAdvisoryUrl = "repository_advisory_url"
                case summary
                case description
                case _type = "type"
                case severity
                case sourceCodeLocation = "source_code_location"
                case identifiers
                case references
                case publishedAt = "published_at"
                case updatedAt = "updated_at"
                case githubReviewedAt = "github_reviewed_at"
                case nvdPublishedAt = "nvd_published_at"
                case withdrawnAt = "withdrawn_at"
                case vulnerabilities
                case cvss
                case cvssSeverities = "cvss_severities"
                case epss
                case cwes
                case credits
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.ghsaId = try container.decode(
                    Swift.String.self,
                    forKey: .ghsaId
                )
                self.cveId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cveId
                )
                self.url = try container.decode(
                    Swift.String.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Swift.String.self,
                    forKey: .htmlUrl
                )
                self.repositoryAdvisoryUrl = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .repositoryAdvisoryUrl
                )
                self.summary = try container.decode(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .description
                )
                self._type = try container.decode(
                    Components.Schemas.GlobalAdvisory._TypePayload.self,
                    forKey: ._type
                )
                self.severity = try container.decode(
                    Components.Schemas.GlobalAdvisory.SeverityPayload.self,
                    forKey: .severity
                )
                self.sourceCodeLocation = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .sourceCodeLocation
                )
                self.identifiers = try container.decodeIfPresent(
                    Components.Schemas.GlobalAdvisory.IdentifiersPayload.self,
                    forKey: .identifiers
                )
                self.references = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .references
                )
                self.publishedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .publishedAt
                )
                self.updatedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.githubReviewedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .githubReviewedAt
                )
                self.nvdPublishedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .nvdPublishedAt
                )
                self.withdrawnAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .withdrawnAt
                )
                self.vulnerabilities = try container.decodeIfPresent(
                    [Components.Schemas.Vulnerability].self,
                    forKey: .vulnerabilities
                )
                self.cvss = try container.decodeIfPresent(
                    Components.Schemas.GlobalAdvisory.CvssPayload.self,
                    forKey: .cvss
                )
                self.cvssSeverities = try container.decodeIfPresent(
                    Components.Schemas.CvssSeverities.self,
                    forKey: .cvssSeverities
                )
                self.epss = try container.decodeIfPresent(
                    Components.Schemas.SecurityAdvisoryEpss.self,
                    forKey: .epss
                )
                self.cwes = try container.decodeIfPresent(
                    Components.Schemas.GlobalAdvisory.CwesPayload.self,
                    forKey: .cwes
                )
                self.credits = try container.decodeIfPresent(
                    Components.Schemas.GlobalAdvisory.CreditsPayload.self,
                    forKey: .credits
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "ghsa_id",
                    "cve_id",
                    "url",
                    "html_url",
                    "repository_advisory_url",
                    "summary",
                    "description",
                    "type",
                    "severity",
                    "source_code_location",
                    "identifiers",
                    "references",
                    "published_at",
                    "updated_at",
                    "github_reviewed_at",
                    "nvd_published_at",
                    "withdrawn_at",
                    "vulnerabilities",
                    "cvss",
                    "cvss_severities",
                    "epss",
                    "cwes",
                    "credits"
                ])
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-repository`.
        public struct SimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `SimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-repository`.
        public struct NullableRepository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public var permissions: Components.Schemas.NullableRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload?
            /// Creates a new `NullableRepository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.NullableRepository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code of Conduct Simple
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple`.
        public struct CodeOfConductSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConductSimple`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - key:
            ///   - name:
            ///   - htmlUrl:
            public init(
                url: Swift.String,
                key: Swift.String,
                name: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.url = url
                self.key = key
                self.name = name
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case key
                case name
                case htmlUrl = "html_url"
            }
        }
        /// Full Repository
        ///
        /// - Remark: Generated from `#/components/schemas/full-repository`.
        public struct FullRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/full-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/full-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/full-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/size`.
            public var size: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/pushed_at`.
            public var pushedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public var permissions: Components.Schemas.FullRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/template_repository`.
            public var templateRepository: Components.Schemas.NullableRepository?
            /// - Remark: Generated from `#/components/schemas/full-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/use_squash_pr_title_as_default`.
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_count`.
            public var subscribersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/network_count`.
            public var networkCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/organization`.
            public var organization: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/full-repository/parent`.
            public var parent: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/source`.
            public var source: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers`.
            public var watchers: Swift.Int
            /// Whether anonymous git access is allowed.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConductSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public var customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload?
            /// Creates a new `FullRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - allowRebaseMerge:
            ///   - templateRepository:
            ///   - tempCloneToken:
            ///   - allowSquashMerge:
            ///   - allowAutoMerge:
            ///   - deleteBranchOnMerge:
            ///   - allowMergeCommit:
            ///   - allowUpdateBranch:
            ///   - useSquashPrTitleAsDefault:
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - license:
            ///   - organization:
            ///   - parent:
            ///   - source:
            ///   - forks:
            ///   - masterBranch:
            ///   - openIssues:
            ///   - watchers:
            ///   - anonymousAccessEnabled: Whether anonymous git access is allowed.
            ///   - codeOfConduct:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.FullRepository.PermissionsPayload? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                templateRepository: Components.Schemas.NullableRepository? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                subscribersCount: Swift.Int,
                networkCount: Swift.Int,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                organization: Components.Schemas.NullableSimpleUser? = nil,
                parent: Components.Schemas.Repository? = nil,
                source: Components.Schemas.Repository? = nil,
                forks: Swift.Int,
                masterBranch: Swift.String? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeOfConduct: Components.Schemas.CodeOfConductSimple? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.allowRebaseMerge = allowRebaseMerge
                self.templateRepository = templateRepository
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowMergeCommit = allowMergeCommit
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.license = license
                self.organization = organization
                self.parent = parent
                self.source = source
                self.forks = forks
                self.masterBranch = masterBranch
                self.openIssues = openIssues
                self.watchers = watchers
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeOfConduct = codeOfConduct
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case allowRebaseMerge = "allow_rebase_merge"
                case templateRepository = "template_repository"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowMergeCommit = "allow_merge_commit"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case license
                case organization
                case parent
                case source
                case forks
                case masterBranch = "master_branch"
                case openIssues = "open_issues"
                case watchers
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeOfConduct = "code_of_conduct"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A product affected by the vulnerability detailed in a repository security advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability`.
        public struct RepositoryAdvisoryVulnerability: Codable, Hashable, Sendable {
            /// The name of the package affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/package`.
            public struct PackagePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/package/ecosystem`.
                public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems
                /// The unique package name within its ecosystem.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/package/name`.
                public var name: Swift.String?
                /// Creates a new `PackagePayload`.
                ///
                /// - Parameters:
                ///   - ecosystem:
                ///   - name: The unique package name within its ecosystem.
                public init(
                    ecosystem: Components.Schemas.SecurityAdvisoryEcosystems,
                    name: Swift.String? = nil
                ) {
                    self.ecosystem = ecosystem
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case ecosystem
                    case name
                }
            }
            /// The name of the package affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/package`.
            public var package: Components.Schemas.RepositoryAdvisoryVulnerability.PackagePayload?
            /// The range of the package versions affected by the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/vulnerable_version_range`.
            public var vulnerableVersionRange: Swift.String?
            /// The package version(s) that resolve the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/patched_versions`.
            public var patchedVersions: Swift.String?
            /// The functions in the package that are affected.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-vulnerability/vulnerable_functions`.
            public var vulnerableFunctions: [Swift.String]?
            /// Creates a new `RepositoryAdvisoryVulnerability`.
            ///
            /// - Parameters:
            ///   - package: The name of the package affected by the vulnerability.
            ///   - vulnerableVersionRange: The range of the package versions affected by the vulnerability.
            ///   - patchedVersions: The package version(s) that resolve the vulnerability.
            ///   - vulnerableFunctions: The functions in the package that are affected.
            public init(
                package: Components.Schemas.RepositoryAdvisoryVulnerability.PackagePayload? = nil,
                vulnerableVersionRange: Swift.String? = nil,
                patchedVersions: Swift.String? = nil,
                vulnerableFunctions: [Swift.String]? = nil
            ) {
                self.package = package
                self.vulnerableVersionRange = vulnerableVersionRange
                self.patchedVersions = patchedVersions
                self.vulnerableFunctions = vulnerableFunctions
            }
            public enum CodingKeys: String, CodingKey {
                case package
                case vulnerableVersionRange = "vulnerable_version_range"
                case patchedVersions = "patched_versions"
                case vulnerableFunctions = "vulnerable_functions"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.package = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryVulnerability.PackagePayload.self,
                    forKey: .package
                )
                self.vulnerableVersionRange = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .vulnerableVersionRange
                )
                self.patchedVersions = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .patchedVersions
                )
                self.vulnerableFunctions = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .vulnerableFunctions
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "package",
                    "vulnerable_version_range",
                    "patched_versions",
                    "vulnerable_functions"
                ])
            }
        }
        /// A credit given to a user for a repository security advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-advisory-credit`.
        public struct RepositoryAdvisoryCredit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-advisory-credit/user`.
            public var user: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/repository-advisory-credit/type`.
            public var _type: Components.Schemas.SecurityAdvisoryCreditTypes
            /// The state of the user's acceptance of the credit.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-credit/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case accepted = "accepted"
                case declined = "declined"
                case pending = "pending"
            }
            /// The state of the user's acceptance of the credit.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-credit/state`.
            public var state: Components.Schemas.RepositoryAdvisoryCredit.StatePayload
            /// Creates a new `RepositoryAdvisoryCredit`.
            ///
            /// - Parameters:
            ///   - user:
            ///   - _type:
            ///   - state: The state of the user's acceptance of the credit.
            public init(
                user: Components.Schemas.SimpleUser,
                _type: Components.Schemas.SecurityAdvisoryCreditTypes,
                state: Components.Schemas.RepositoryAdvisoryCredit.StatePayload
            ) {
                self.user = user
                self._type = _type
                self.state = state
            }
            public enum CodingKeys: String, CodingKey {
                case user
                case _type = "type"
                case state
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.user = try container.decode(
                    Components.Schemas.SimpleUser.self,
                    forKey: .user
                )
                self._type = try container.decode(
                    Components.Schemas.SecurityAdvisoryCreditTypes.self,
                    forKey: ._type
                )
                self.state = try container.decode(
                    Components.Schemas.RepositoryAdvisoryCredit.StatePayload.self,
                    forKey: .state
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "user",
                    "type",
                    "state"
                ])
            }
        }
        /// A repository security advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-advisory`.
        public struct RepositoryAdvisory: Codable, Hashable, Sendable {
            /// The GitHub Security Advisory ID.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/ghsa_id`.
            public var ghsaId: Swift.String
            /// The Common Vulnerabilities and Exposures (CVE) ID.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cve_id`.
            public var cveId: Swift.String?
            /// The API URL for the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/url`.
            public var url: Swift.String
            /// The URL for the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/html_url`.
            public var htmlUrl: Swift.String
            /// A short summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/summary`.
            public var summary: Swift.String
            /// A detailed description of what the advisory entails.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/description`.
            public var description: Swift.String?
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case critical = "critical"
                case high = "high"
                case medium = "medium"
                case low = "low"
            }
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/severity`.
            public var severity: Components.Schemas.RepositoryAdvisory.SeverityPayload?
            /// The author of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/author`.
            public struct AuthorPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-advisory/author/value1`.
                public var value1: Components.Schemas.SimpleUser
                /// Creates a new `AuthorPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                public init(value1: Components.Schemas.SimpleUser) {
                    self.value1 = value1
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                }
            }
            /// The author of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/author`.
            public var author: Components.Schemas.RepositoryAdvisory.AuthorPayload?
            /// The publisher of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/publisher`.
            public struct PublisherPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-advisory/publisher/value1`.
                public var value1: Components.Schemas.SimpleUser
                /// Creates a new `PublisherPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                public init(value1: Components.Schemas.SimpleUser) {
                    self.value1 = value1
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                }
            }
            /// The publisher of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/publisher`.
            public var publisher: Components.Schemas.RepositoryAdvisory.PublisherPayload?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/IdentifiersPayload`.
            public struct IdentifiersPayloadPayload: Codable, Hashable, Sendable {
                /// The type of identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/IdentifiersPayload/type`.
                @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case cve = "CVE"
                    case ghsa = "GHSA"
                }
                /// The type of identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/IdentifiersPayload/type`.
                public var _type: Components.Schemas.RepositoryAdvisory.IdentifiersPayloadPayload._TypePayload
                /// The identifier value.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/IdentifiersPayload/value`.
                public var value: Swift.String
                /// Creates a new `IdentifiersPayloadPayload`.
                ///
                /// - Parameters:
                ///   - _type: The type of identifier.
                ///   - value: The identifier value.
                public init(
                    _type: Components.Schemas.RepositoryAdvisory.IdentifiersPayloadPayload._TypePayload,
                    value: Swift.String
                ) {
                    self._type = _type
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-advisory/identifiers`.
            public typealias IdentifiersPayload = [Components.Schemas.RepositoryAdvisory.IdentifiersPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/repository-advisory/identifiers`.
            public var identifiers: Components.Schemas.RepositoryAdvisory.IdentifiersPayload
            /// The state of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case published = "published"
                case closed = "closed"
                case withdrawn = "withdrawn"
                case draft = "draft"
                case triage = "triage"
            }
            /// The state of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/state`.
            public var state: Components.Schemas.RepositoryAdvisory.StatePayload
            /// The date and time of when the advisory was created, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/created_at`.
            public var createdAt: Foundation.Date?
            /// The date and time of when the advisory was last updated, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/updated_at`.
            public var updatedAt: Foundation.Date?
            /// The date and time of when the advisory was published, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/published_at`.
            public var publishedAt: Foundation.Date?
            /// The date and time of when the advisory was closed, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/closed_at`.
            public var closedAt: Foundation.Date?
            /// The date and time of when the advisory was withdrawn, in ISO 8601 format.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/withdrawn_at`.
            public var withdrawnAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/submission`.
            public struct SubmissionPayload: Codable, Hashable, Sendable {
                /// Whether a private vulnerability report was accepted by the repository's administrators.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/submission/accepted`.
                public var accepted: Swift.Bool
                /// Creates a new `SubmissionPayload`.
                ///
                /// - Parameters:
                ///   - accepted: Whether a private vulnerability report was accepted by the repository's administrators.
                public init(accepted: Swift.Bool) {
                    self.accepted = accepted
                }
                public enum CodingKeys: String, CodingKey {
                    case accepted
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-advisory/submission`.
            public var submission: Components.Schemas.RepositoryAdvisory.SubmissionPayload?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/vulnerabilities`.
            public var vulnerabilities: [Components.Schemas.RepositoryAdvisoryVulnerability]?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cvss`.
            public struct CvssPayload: Codable, Hashable, Sendable {
                /// The CVSS vector.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/cvss/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS score.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/cvss/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssPayload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS vector.
                ///   - score: The CVSS score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cvss`.
            public var cvss: Components.Schemas.RepositoryAdvisory.CvssPayload?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cvss_severities`.
            public var cvssSeverities: Components.Schemas.CvssSeverities?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/CwesPayload`.
            public struct CwesPayloadPayload: Codable, Hashable, Sendable {
                /// The Common Weakness Enumeration (CWE) identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/CwesPayload/cwe_id`.
                public var cweId: Swift.String
                /// The name of the CWE.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/CwesPayload/name`.
                public var name: Swift.String
                /// Creates a new `CwesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - cweId: The Common Weakness Enumeration (CWE) identifier.
                ///   - name: The name of the CWE.
                public init(
                    cweId: Swift.String,
                    name: Swift.String
                ) {
                    self.cweId = cweId
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case cweId = "cwe_id"
                    case name
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cwes`.
            public typealias CwesPayload = [Components.Schemas.RepositoryAdvisory.CwesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cwes`.
            public var cwes: Components.Schemas.RepositoryAdvisory.CwesPayload?
            /// A list of only the CWE IDs.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/cwe_ids`.
            public var cweIds: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/CreditsPayload`.
            public struct CreditsPayloadPayload: Codable, Hashable, Sendable {
                /// The username of the user credited.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory/CreditsPayload/login`.
                public var login: Swift.String?
                /// - Remark: Generated from `#/components/schemas/repository-advisory/CreditsPayload/type`.
                public var _type: Components.Schemas.SecurityAdvisoryCreditTypes?
                /// Creates a new `CreditsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - login: The username of the user credited.
                ///   - _type:
                public init(
                    login: Swift.String? = nil,
                    _type: Components.Schemas.SecurityAdvisoryCreditTypes? = nil
                ) {
                    self.login = login
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case login
                    case _type = "type"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-advisory/credits`.
            public typealias CreditsPayload = [Components.Schemas.RepositoryAdvisory.CreditsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/repository-advisory/credits`.
            public var credits: Components.Schemas.RepositoryAdvisory.CreditsPayload?
            /// - Remark: Generated from `#/components/schemas/repository-advisory/credits_detailed`.
            public var creditsDetailed: [Components.Schemas.RepositoryAdvisoryCredit]?
            /// A list of users that collaborate on the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/collaborating_users`.
            public var collaboratingUsers: [Components.Schemas.SimpleUser]?
            /// A list of teams that collaborate on the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/collaborating_teams`.
            public var collaboratingTeams: [Components.Schemas.Team]?
            /// A temporary private fork of the advisory's repository for collaborating on a fix.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/private_fork`.
            public struct PrivateForkPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-advisory/private_fork/value1`.
                public var value1: Components.Schemas.SimpleRepository
                /// Creates a new `PrivateForkPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                public init(value1: Components.Schemas.SimpleRepository) {
                    self.value1 = value1
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                }
            }
            /// A temporary private fork of the advisory's repository for collaborating on a fix.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory/private_fork`.
            public var privateFork: Components.Schemas.RepositoryAdvisory.PrivateForkPayload?
            /// Creates a new `RepositoryAdvisory`.
            ///
            /// - Parameters:
            ///   - ghsaId: The GitHub Security Advisory ID.
            ///   - cveId: The Common Vulnerabilities and Exposures (CVE) ID.
            ///   - url: The API URL for the advisory.
            ///   - htmlUrl: The URL for the advisory.
            ///   - summary: A short summary of the advisory.
            ///   - description: A detailed description of what the advisory entails.
            ///   - severity: The severity of the advisory.
            ///   - author: The author of the advisory.
            ///   - publisher: The publisher of the advisory.
            ///   - identifiers:
            ///   - state: The state of the advisory.
            ///   - createdAt: The date and time of when the advisory was created, in ISO 8601 format.
            ///   - updatedAt: The date and time of when the advisory was last updated, in ISO 8601 format.
            ///   - publishedAt: The date and time of when the advisory was published, in ISO 8601 format.
            ///   - closedAt: The date and time of when the advisory was closed, in ISO 8601 format.
            ///   - withdrawnAt: The date and time of when the advisory was withdrawn, in ISO 8601 format.
            ///   - submission:
            ///   - vulnerabilities:
            ///   - cvss:
            ///   - cvssSeverities:
            ///   - cwes:
            ///   - cweIds: A list of only the CWE IDs.
            ///   - credits:
            ///   - creditsDetailed:
            ///   - collaboratingUsers: A list of users that collaborate on the advisory.
            ///   - collaboratingTeams: A list of teams that collaborate on the advisory.
            ///   - privateFork: A temporary private fork of the advisory's repository for collaborating on a fix.
            public init(
                ghsaId: Swift.String,
                cveId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                summary: Swift.String,
                description: Swift.String? = nil,
                severity: Components.Schemas.RepositoryAdvisory.SeverityPayload? = nil,
                author: Components.Schemas.RepositoryAdvisory.AuthorPayload? = nil,
                publisher: Components.Schemas.RepositoryAdvisory.PublisherPayload? = nil,
                identifiers: Components.Schemas.RepositoryAdvisory.IdentifiersPayload,
                state: Components.Schemas.RepositoryAdvisory.StatePayload,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                publishedAt: Foundation.Date? = nil,
                closedAt: Foundation.Date? = nil,
                withdrawnAt: Foundation.Date? = nil,
                submission: Components.Schemas.RepositoryAdvisory.SubmissionPayload? = nil,
                vulnerabilities: [Components.Schemas.RepositoryAdvisoryVulnerability]? = nil,
                cvss: Components.Schemas.RepositoryAdvisory.CvssPayload? = nil,
                cvssSeverities: Components.Schemas.CvssSeverities? = nil,
                cwes: Components.Schemas.RepositoryAdvisory.CwesPayload? = nil,
                cweIds: [Swift.String]? = nil,
                credits: Components.Schemas.RepositoryAdvisory.CreditsPayload? = nil,
                creditsDetailed: [Components.Schemas.RepositoryAdvisoryCredit]? = nil,
                collaboratingUsers: [Components.Schemas.SimpleUser]? = nil,
                collaboratingTeams: [Components.Schemas.Team]? = nil,
                privateFork: Components.Schemas.RepositoryAdvisory.PrivateForkPayload? = nil
            ) {
                self.ghsaId = ghsaId
                self.cveId = cveId
                self.url = url
                self.htmlUrl = htmlUrl
                self.summary = summary
                self.description = description
                self.severity = severity
                self.author = author
                self.publisher = publisher
                self.identifiers = identifiers
                self.state = state
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.publishedAt = publishedAt
                self.closedAt = closedAt
                self.withdrawnAt = withdrawnAt
                self.submission = submission
                self.vulnerabilities = vulnerabilities
                self.cvss = cvss
                self.cvssSeverities = cvssSeverities
                self.cwes = cwes
                self.cweIds = cweIds
                self.credits = credits
                self.creditsDetailed = creditsDetailed
                self.collaboratingUsers = collaboratingUsers
                self.collaboratingTeams = collaboratingTeams
                self.privateFork = privateFork
            }
            public enum CodingKeys: String, CodingKey {
                case ghsaId = "ghsa_id"
                case cveId = "cve_id"
                case url
                case htmlUrl = "html_url"
                case summary
                case description
                case severity
                case author
                case publisher
                case identifiers
                case state
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case publishedAt = "published_at"
                case closedAt = "closed_at"
                case withdrawnAt = "withdrawn_at"
                case submission
                case vulnerabilities
                case cvss
                case cvssSeverities = "cvss_severities"
                case cwes
                case cweIds = "cwe_ids"
                case credits
                case creditsDetailed = "credits_detailed"
                case collaboratingUsers = "collaborating_users"
                case collaboratingTeams = "collaborating_teams"
                case privateFork = "private_fork"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.ghsaId = try container.decode(
                    Swift.String.self,
                    forKey: .ghsaId
                )
                self.cveId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cveId
                )
                self.url = try container.decode(
                    Swift.String.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Swift.String.self,
                    forKey: .htmlUrl
                )
                self.summary = try container.decode(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .description
                )
                self.severity = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.SeverityPayload.self,
                    forKey: .severity
                )
                self.author = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.AuthorPayload.self,
                    forKey: .author
                )
                self.publisher = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.PublisherPayload.self,
                    forKey: .publisher
                )
                self.identifiers = try container.decode(
                    Components.Schemas.RepositoryAdvisory.IdentifiersPayload.self,
                    forKey: .identifiers
                )
                self.state = try container.decode(
                    Components.Schemas.RepositoryAdvisory.StatePayload.self,
                    forKey: .state
                )
                self.createdAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.publishedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .publishedAt
                )
                self.closedAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .closedAt
                )
                self.withdrawnAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .withdrawnAt
                )
                self.submission = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.SubmissionPayload.self,
                    forKey: .submission
                )
                self.vulnerabilities = try container.decodeIfPresent(
                    [Components.Schemas.RepositoryAdvisoryVulnerability].self,
                    forKey: .vulnerabilities
                )
                self.cvss = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.CvssPayload.self,
                    forKey: .cvss
                )
                self.cvssSeverities = try container.decodeIfPresent(
                    Components.Schemas.CvssSeverities.self,
                    forKey: .cvssSeverities
                )
                self.cwes = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.CwesPayload.self,
                    forKey: .cwes
                )
                self.cweIds = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .cweIds
                )
                self.credits = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.CreditsPayload.self,
                    forKey: .credits
                )
                self.creditsDetailed = try container.decodeIfPresent(
                    [Components.Schemas.RepositoryAdvisoryCredit].self,
                    forKey: .creditsDetailed
                )
                self.collaboratingUsers = try container.decodeIfPresent(
                    [Components.Schemas.SimpleUser].self,
                    forKey: .collaboratingUsers
                )
                self.collaboratingTeams = try container.decodeIfPresent(
                    [Components.Schemas.Team].self,
                    forKey: .collaboratingTeams
                )
                self.privateFork = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisory.PrivateForkPayload.self,
                    forKey: .privateFork
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "ghsa_id",
                    "cve_id",
                    "url",
                    "html_url",
                    "summary",
                    "description",
                    "severity",
                    "author",
                    "publisher",
                    "identifiers",
                    "state",
                    "created_at",
                    "updated_at",
                    "published_at",
                    "closed_at",
                    "withdrawn_at",
                    "submission",
                    "vulnerabilities",
                    "cvss",
                    "cvss_severities",
                    "cwes",
                    "cwe_ids",
                    "credits",
                    "credits_detailed",
                    "collaborating_users",
                    "collaborating_teams",
                    "private_fork"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/repository-advisory-create`.
        public struct RepositoryAdvisoryCreate: Codable, Hashable, Sendable {
            /// A short summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/summary`.
            public var summary: Swift.String
            /// A detailed description of what the advisory impacts.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/description`.
            public var description: Swift.String
            /// The Common Vulnerabilities and Exposures (CVE) ID.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/cve_id`.
            public var cveId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload`.
            public struct VulnerabilitiesPayloadPayload: Codable, Hashable, Sendable {
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/package`.
                public struct PackagePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/package/ecosystem`.
                    public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems
                    /// The unique package name within its ecosystem.
                    ///
                    /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/package/name`.
                    public var name: Swift.String?
                    /// Creates a new `PackagePayload`.
                    ///
                    /// - Parameters:
                    ///   - ecosystem:
                    ///   - name: The unique package name within its ecosystem.
                    public init(
                        ecosystem: Components.Schemas.SecurityAdvisoryEcosystems,
                        name: Swift.String? = nil
                    ) {
                        self.ecosystem = ecosystem
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ecosystem
                        case name
                    }
                }
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/package`.
                public var package: Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayloadPayload.PackagePayload
                /// The range of the package versions affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/vulnerable_version_range`.
                public var vulnerableVersionRange: Swift.String?
                /// The package version(s) that resolve the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/patched_versions`.
                public var patchedVersions: Swift.String?
                /// The functions in the package that are affected.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/VulnerabilitiesPayload/vulnerable_functions`.
                public var vulnerableFunctions: [Swift.String]?
                /// Creates a new `VulnerabilitiesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - package: The name of the package affected by the vulnerability.
                ///   - vulnerableVersionRange: The range of the package versions affected by the vulnerability.
                ///   - patchedVersions: The package version(s) that resolve the vulnerability.
                ///   - vulnerableFunctions: The functions in the package that are affected.
                public init(
                    package: Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayloadPayload.PackagePayload,
                    vulnerableVersionRange: Swift.String? = nil,
                    patchedVersions: Swift.String? = nil,
                    vulnerableFunctions: [Swift.String]? = nil
                ) {
                    self.package = package
                    self.vulnerableVersionRange = vulnerableVersionRange
                    self.patchedVersions = patchedVersions
                    self.vulnerableFunctions = vulnerableFunctions
                }
                public enum CodingKeys: String, CodingKey {
                    case package
                    case vulnerableVersionRange = "vulnerable_version_range"
                    case patchedVersions = "patched_versions"
                    case vulnerableFunctions = "vulnerable_functions"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.package = try container.decode(
                        Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayloadPayload.PackagePayload.self,
                        forKey: .package
                    )
                    self.vulnerableVersionRange = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .vulnerableVersionRange
                    )
                    self.patchedVersions = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .patchedVersions
                    )
                    self.vulnerableFunctions = try container.decodeIfPresent(
                        [Swift.String].self,
                        forKey: .vulnerableFunctions
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "package",
                        "vulnerable_version_range",
                        "patched_versions",
                        "vulnerable_functions"
                    ])
                }
            }
            /// A product affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/vulnerabilities`.
            public typealias VulnerabilitiesPayload = [Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayloadPayload]
            /// A product affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/vulnerabilities`.
            public var vulnerabilities: Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayload
            /// A list of Common Weakness Enumeration (CWE) IDs.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/cwe_ids`.
            public var cweIds: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/CreditsPayload`.
            public struct CreditsPayloadPayload: Codable, Hashable, Sendable {
                /// The username of the user credited.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/CreditsPayload/login`.
                public var login: Swift.String
                /// - Remark: Generated from `#/components/schemas/repository-advisory-create/CreditsPayload/type`.
                public var _type: Components.Schemas.SecurityAdvisoryCreditTypes
                /// Creates a new `CreditsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - login: The username of the user credited.
                ///   - _type:
                public init(
                    login: Swift.String,
                    _type: Components.Schemas.SecurityAdvisoryCreditTypes
                ) {
                    self.login = login
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case login
                    case _type = "type"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.login = try container.decode(
                        Swift.String.self,
                        forKey: .login
                    )
                    self._type = try container.decode(
                        Components.Schemas.SecurityAdvisoryCreditTypes.self,
                        forKey: ._type
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "login",
                        "type"
                    ])
                }
            }
            /// A list of users receiving credit for their participation in the security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/credits`.
            public typealias CreditsPayload = [Components.Schemas.RepositoryAdvisoryCreate.CreditsPayloadPayload]
            /// A list of users receiving credit for their participation in the security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/credits`.
            public var credits: Components.Schemas.RepositoryAdvisoryCreate.CreditsPayload?
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case critical = "critical"
                case high = "high"
                case medium = "medium"
                case low = "low"
            }
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/severity`.
            public var severity: Components.Schemas.RepositoryAdvisoryCreate.SeverityPayload?
            /// The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/cvss_vector_string`.
            public var cvssVectorString: Swift.String?
            /// Whether to create a temporary private fork of the repository to collaborate on a fix.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-create/start_private_fork`.
            public var startPrivateFork: Swift.Bool?
            /// Creates a new `RepositoryAdvisoryCreate`.
            ///
            /// - Parameters:
            ///   - summary: A short summary of the advisory.
            ///   - description: A detailed description of what the advisory impacts.
            ///   - cveId: The Common Vulnerabilities and Exposures (CVE) ID.
            ///   - vulnerabilities: A product affected by the vulnerability detailed in a repository security advisory.
            ///   - cweIds: A list of Common Weakness Enumeration (CWE) IDs.
            ///   - credits: A list of users receiving credit for their participation in the security advisory.
            ///   - severity: The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///   - cvssVectorString: The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///   - startPrivateFork: Whether to create a temporary private fork of the repository to collaborate on a fix.
            public init(
                summary: Swift.String,
                description: Swift.String,
                cveId: Swift.String? = nil,
                vulnerabilities: Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayload,
                cweIds: [Swift.String]? = nil,
                credits: Components.Schemas.RepositoryAdvisoryCreate.CreditsPayload? = nil,
                severity: Components.Schemas.RepositoryAdvisoryCreate.SeverityPayload? = nil,
                cvssVectorString: Swift.String? = nil,
                startPrivateFork: Swift.Bool? = nil
            ) {
                self.summary = summary
                self.description = description
                self.cveId = cveId
                self.vulnerabilities = vulnerabilities
                self.cweIds = cweIds
                self.credits = credits
                self.severity = severity
                self.cvssVectorString = cvssVectorString
                self.startPrivateFork = startPrivateFork
            }
            public enum CodingKeys: String, CodingKey {
                case summary
                case description
                case cveId = "cve_id"
                case vulnerabilities
                case cweIds = "cwe_ids"
                case credits
                case severity
                case cvssVectorString = "cvss_vector_string"
                case startPrivateFork = "start_private_fork"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.summary = try container.decode(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decode(
                    Swift.String.self,
                    forKey: .description
                )
                self.cveId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cveId
                )
                self.vulnerabilities = try container.decode(
                    Components.Schemas.RepositoryAdvisoryCreate.VulnerabilitiesPayload.self,
                    forKey: .vulnerabilities
                )
                self.cweIds = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .cweIds
                )
                self.credits = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryCreate.CreditsPayload.self,
                    forKey: .credits
                )
                self.severity = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryCreate.SeverityPayload.self,
                    forKey: .severity
                )
                self.cvssVectorString = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cvssVectorString
                )
                self.startPrivateFork = try container.decodeIfPresent(
                    Swift.Bool.self,
                    forKey: .startPrivateFork
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "summary",
                    "description",
                    "cve_id",
                    "vulnerabilities",
                    "cwe_ids",
                    "credits",
                    "severity",
                    "cvss_vector_string",
                    "start_private_fork"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create`.
        public struct PrivateVulnerabilityReportCreate: Codable, Hashable, Sendable {
            /// A short summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/summary`.
            public var summary: Swift.String
            /// A detailed description of what the advisory impacts.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/description`.
            public var description: Swift.String
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload`.
            public struct VulnerabilitiesPayloadPayload: Codable, Hashable, Sendable {
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/package`.
                public struct PackagePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/package/ecosystem`.
                    public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems
                    /// The unique package name within its ecosystem.
                    ///
                    /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/package/name`.
                    public var name: Swift.String?
                    /// Creates a new `PackagePayload`.
                    ///
                    /// - Parameters:
                    ///   - ecosystem:
                    ///   - name: The unique package name within its ecosystem.
                    public init(
                        ecosystem: Components.Schemas.SecurityAdvisoryEcosystems,
                        name: Swift.String? = nil
                    ) {
                        self.ecosystem = ecosystem
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ecosystem
                        case name
                    }
                }
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/package`.
                public var package: Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayloadPayload.PackagePayload
                /// The range of the package versions affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/vulnerable_version_range`.
                public var vulnerableVersionRange: Swift.String?
                /// The package version(s) that resolve the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/patched_versions`.
                public var patchedVersions: Swift.String?
                /// The functions in the package that are affected.
                ///
                /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/VulnerabilitiesPayload/vulnerable_functions`.
                public var vulnerableFunctions: [Swift.String]?
                /// Creates a new `VulnerabilitiesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - package: The name of the package affected by the vulnerability.
                ///   - vulnerableVersionRange: The range of the package versions affected by the vulnerability.
                ///   - patchedVersions: The package version(s) that resolve the vulnerability.
                ///   - vulnerableFunctions: The functions in the package that are affected.
                public init(
                    package: Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayloadPayload.PackagePayload,
                    vulnerableVersionRange: Swift.String? = nil,
                    patchedVersions: Swift.String? = nil,
                    vulnerableFunctions: [Swift.String]? = nil
                ) {
                    self.package = package
                    self.vulnerableVersionRange = vulnerableVersionRange
                    self.patchedVersions = patchedVersions
                    self.vulnerableFunctions = vulnerableFunctions
                }
                public enum CodingKeys: String, CodingKey {
                    case package
                    case vulnerableVersionRange = "vulnerable_version_range"
                    case patchedVersions = "patched_versions"
                    case vulnerableFunctions = "vulnerable_functions"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.package = try container.decode(
                        Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayloadPayload.PackagePayload.self,
                        forKey: .package
                    )
                    self.vulnerableVersionRange = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .vulnerableVersionRange
                    )
                    self.patchedVersions = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .patchedVersions
                    )
                    self.vulnerableFunctions = try container.decodeIfPresent(
                        [Swift.String].self,
                        forKey: .vulnerableFunctions
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "package",
                        "vulnerable_version_range",
                        "patched_versions",
                        "vulnerable_functions"
                    ])
                }
            }
            /// An array of products affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/vulnerabilities`.
            public typealias VulnerabilitiesPayload = [Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayloadPayload]
            /// An array of products affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/vulnerabilities`.
            public var vulnerabilities: Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayload?
            /// A list of Common Weakness Enumeration (CWE) IDs.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/cwe_ids`.
            public var cweIds: [Swift.String]?
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case critical = "critical"
                case high = "high"
                case medium = "medium"
                case low = "low"
            }
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/severity`.
            public var severity: Components.Schemas.PrivateVulnerabilityReportCreate.SeverityPayload?
            /// The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/cvss_vector_string`.
            public var cvssVectorString: Swift.String?
            /// Whether to create a temporary private fork of the repository to collaborate on a fix.
            ///
            /// - Remark: Generated from `#/components/schemas/private-vulnerability-report-create/start_private_fork`.
            public var startPrivateFork: Swift.Bool?
            /// Creates a new `PrivateVulnerabilityReportCreate`.
            ///
            /// - Parameters:
            ///   - summary: A short summary of the advisory.
            ///   - description: A detailed description of what the advisory impacts.
            ///   - vulnerabilities: An array of products affected by the vulnerability detailed in a repository security advisory.
            ///   - cweIds: A list of Common Weakness Enumeration (CWE) IDs.
            ///   - severity: The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///   - cvssVectorString: The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///   - startPrivateFork: Whether to create a temporary private fork of the repository to collaborate on a fix.
            public init(
                summary: Swift.String,
                description: Swift.String,
                vulnerabilities: Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayload? = nil,
                cweIds: [Swift.String]? = nil,
                severity: Components.Schemas.PrivateVulnerabilityReportCreate.SeverityPayload? = nil,
                cvssVectorString: Swift.String? = nil,
                startPrivateFork: Swift.Bool? = nil
            ) {
                self.summary = summary
                self.description = description
                self.vulnerabilities = vulnerabilities
                self.cweIds = cweIds
                self.severity = severity
                self.cvssVectorString = cvssVectorString
                self.startPrivateFork = startPrivateFork
            }
            public enum CodingKeys: String, CodingKey {
                case summary
                case description
                case vulnerabilities
                case cweIds = "cwe_ids"
                case severity
                case cvssVectorString = "cvss_vector_string"
                case startPrivateFork = "start_private_fork"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.summary = try container.decode(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decode(
                    Swift.String.self,
                    forKey: .description
                )
                self.vulnerabilities = try container.decodeIfPresent(
                    Components.Schemas.PrivateVulnerabilityReportCreate.VulnerabilitiesPayload.self,
                    forKey: .vulnerabilities
                )
                self.cweIds = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .cweIds
                )
                self.severity = try container.decodeIfPresent(
                    Components.Schemas.PrivateVulnerabilityReportCreate.SeverityPayload.self,
                    forKey: .severity
                )
                self.cvssVectorString = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cvssVectorString
                )
                self.startPrivateFork = try container.decodeIfPresent(
                    Swift.Bool.self,
                    forKey: .startPrivateFork
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "summary",
                    "description",
                    "vulnerabilities",
                    "cwe_ids",
                    "severity",
                    "cvss_vector_string",
                    "start_private_fork"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/repository-advisory-update`.
        public struct RepositoryAdvisoryUpdate: Codable, Hashable, Sendable {
            /// A short summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/summary`.
            public var summary: Swift.String?
            /// A detailed description of what the advisory impacts.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/description`.
            public var description: Swift.String?
            /// The Common Vulnerabilities and Exposures (CVE) ID.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/cve_id`.
            public var cveId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload`.
            public struct VulnerabilitiesPayloadPayload: Codable, Hashable, Sendable {
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/package`.
                public struct PackagePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/package/ecosystem`.
                    public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems
                    /// The unique package name within its ecosystem.
                    ///
                    /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/package/name`.
                    public var name: Swift.String?
                    /// Creates a new `PackagePayload`.
                    ///
                    /// - Parameters:
                    ///   - ecosystem:
                    ///   - name: The unique package name within its ecosystem.
                    public init(
                        ecosystem: Components.Schemas.SecurityAdvisoryEcosystems,
                        name: Swift.String? = nil
                    ) {
                        self.ecosystem = ecosystem
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ecosystem
                        case name
                    }
                }
                /// The name of the package affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/package`.
                public var package: Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayloadPayload.PackagePayload
                /// The range of the package versions affected by the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/vulnerable_version_range`.
                public var vulnerableVersionRange: Swift.String?
                /// The package version(s) that resolve the vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/patched_versions`.
                public var patchedVersions: Swift.String?
                /// The functions in the package that are affected.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/VulnerabilitiesPayload/vulnerable_functions`.
                public var vulnerableFunctions: [Swift.String]?
                /// Creates a new `VulnerabilitiesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - package: The name of the package affected by the vulnerability.
                ///   - vulnerableVersionRange: The range of the package versions affected by the vulnerability.
                ///   - patchedVersions: The package version(s) that resolve the vulnerability.
                ///   - vulnerableFunctions: The functions in the package that are affected.
                public init(
                    package: Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayloadPayload.PackagePayload,
                    vulnerableVersionRange: Swift.String? = nil,
                    patchedVersions: Swift.String? = nil,
                    vulnerableFunctions: [Swift.String]? = nil
                ) {
                    self.package = package
                    self.vulnerableVersionRange = vulnerableVersionRange
                    self.patchedVersions = patchedVersions
                    self.vulnerableFunctions = vulnerableFunctions
                }
                public enum CodingKeys: String, CodingKey {
                    case package
                    case vulnerableVersionRange = "vulnerable_version_range"
                    case patchedVersions = "patched_versions"
                    case vulnerableFunctions = "vulnerable_functions"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.package = try container.decode(
                        Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayloadPayload.PackagePayload.self,
                        forKey: .package
                    )
                    self.vulnerableVersionRange = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .vulnerableVersionRange
                    )
                    self.patchedVersions = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .patchedVersions
                    )
                    self.vulnerableFunctions = try container.decodeIfPresent(
                        [Swift.String].self,
                        forKey: .vulnerableFunctions
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "package",
                        "vulnerable_version_range",
                        "patched_versions",
                        "vulnerable_functions"
                    ])
                }
            }
            /// A product affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/vulnerabilities`.
            public typealias VulnerabilitiesPayload = [Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayloadPayload]
            /// A product affected by the vulnerability detailed in a repository security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/vulnerabilities`.
            public var vulnerabilities: Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayload?
            /// A list of Common Weakness Enumeration (CWE) IDs.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/cwe_ids`.
            public var cweIds: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/CreditsPayload`.
            public struct CreditsPayloadPayload: Codable, Hashable, Sendable {
                /// The username of the user credited.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/CreditsPayload/login`.
                public var login: Swift.String
                /// - Remark: Generated from `#/components/schemas/repository-advisory-update/CreditsPayload/type`.
                public var _type: Components.Schemas.SecurityAdvisoryCreditTypes
                /// Creates a new `CreditsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - login: The username of the user credited.
                ///   - _type:
                public init(
                    login: Swift.String,
                    _type: Components.Schemas.SecurityAdvisoryCreditTypes
                ) {
                    self.login = login
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case login
                    case _type = "type"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.login = try container.decode(
                        Swift.String.self,
                        forKey: .login
                    )
                    self._type = try container.decode(
                        Components.Schemas.SecurityAdvisoryCreditTypes.self,
                        forKey: ._type
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "login",
                        "type"
                    ])
                }
            }
            /// A list of users receiving credit for their participation in the security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/credits`.
            public typealias CreditsPayload = [Components.Schemas.RepositoryAdvisoryUpdate.CreditsPayloadPayload]
            /// A list of users receiving credit for their participation in the security advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/credits`.
            public var credits: Components.Schemas.RepositoryAdvisoryUpdate.CreditsPayload?
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case critical = "critical"
                case high = "high"
                case medium = "medium"
                case low = "low"
            }
            /// The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/severity`.
            public var severity: Components.Schemas.RepositoryAdvisoryUpdate.SeverityPayload?
            /// The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/cvss_vector_string`.
            public var cvssVectorString: Swift.String?
            /// The state of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case published = "published"
                case closed = "closed"
                case draft = "draft"
            }
            /// The state of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/state`.
            public var state: Components.Schemas.RepositoryAdvisoryUpdate.StatePayload?
            /// A list of usernames who have been granted write access to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/collaborating_users`.
            public var collaboratingUsers: [Swift.String]?
            /// A list of team slugs which have been granted write access to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-advisory-update/collaborating_teams`.
            public var collaboratingTeams: [Swift.String]?
            /// Creates a new `RepositoryAdvisoryUpdate`.
            ///
            /// - Parameters:
            ///   - summary: A short summary of the advisory.
            ///   - description: A detailed description of what the advisory impacts.
            ///   - cveId: The Common Vulnerabilities and Exposures (CVE) ID.
            ///   - vulnerabilities: A product affected by the vulnerability detailed in a repository security advisory.
            ///   - cweIds: A list of Common Weakness Enumeration (CWE) IDs.
            ///   - credits: A list of users receiving credit for their participation in the security advisory.
            ///   - severity: The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.
            ///   - cvssVectorString: The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.
            ///   - state: The state of the advisory.
            ///   - collaboratingUsers: A list of usernames who have been granted write access to the advisory.
            ///   - collaboratingTeams: A list of team slugs which have been granted write access to the advisory.
            public init(
                summary: Swift.String? = nil,
                description: Swift.String? = nil,
                cveId: Swift.String? = nil,
                vulnerabilities: Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayload? = nil,
                cweIds: [Swift.String]? = nil,
                credits: Components.Schemas.RepositoryAdvisoryUpdate.CreditsPayload? = nil,
                severity: Components.Schemas.RepositoryAdvisoryUpdate.SeverityPayload? = nil,
                cvssVectorString: Swift.String? = nil,
                state: Components.Schemas.RepositoryAdvisoryUpdate.StatePayload? = nil,
                collaboratingUsers: [Swift.String]? = nil,
                collaboratingTeams: [Swift.String]? = nil
            ) {
                self.summary = summary
                self.description = description
                self.cveId = cveId
                self.vulnerabilities = vulnerabilities
                self.cweIds = cweIds
                self.credits = credits
                self.severity = severity
                self.cvssVectorString = cvssVectorString
                self.state = state
                self.collaboratingUsers = collaboratingUsers
                self.collaboratingTeams = collaboratingTeams
            }
            public enum CodingKeys: String, CodingKey {
                case summary
                case description
                case cveId = "cve_id"
                case vulnerabilities
                case cweIds = "cwe_ids"
                case credits
                case severity
                case cvssVectorString = "cvss_vector_string"
                case state
                case collaboratingUsers = "collaborating_users"
                case collaboratingTeams = "collaborating_teams"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.summary = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .description
                )
                self.cveId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cveId
                )
                self.vulnerabilities = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryUpdate.VulnerabilitiesPayload.self,
                    forKey: .vulnerabilities
                )
                self.cweIds = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .cweIds
                )
                self.credits = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryUpdate.CreditsPayload.self,
                    forKey: .credits
                )
                self.severity = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryUpdate.SeverityPayload.self,
                    forKey: .severity
                )
                self.cvssVectorString = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cvssVectorString
                )
                self.state = try container.decodeIfPresent(
                    Components.Schemas.RepositoryAdvisoryUpdate.StatePayload.self,
                    forKey: .state
                )
                self.collaboratingUsers = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .collaboratingUsers
                )
                self.collaboratingTeams = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .collaboratingTeams
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "summary",
                    "description",
                    "cve_id",
                    "vulnerabilities",
                    "cwe_ids",
                    "credits",
                    "severity",
                    "cvss_vector_string",
                    "state",
                    "collaborating_users",
                    "collaborating_teams"
                ])
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The GHSA (GitHub Security Advisory) identifier of the advisory.
        ///
        /// - Remark: Generated from `#/components/parameters/ghsa_id`.
        public typealias GhsaId = Swift.String
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Accepted: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/accepted/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/accepted/content/application\/json`.
                case json(OpenAPIRuntime.OpenAPIObjectContainer)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: OpenAPIRuntime.OpenAPIObjectContainer {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Accepted.Body
            /// Creates a new `Accepted`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Accepted.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List global security advisories
    ///
    /// Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.
    ///
    /// By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see "[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories)."
    ///
    /// - Remark: HTTP `GET /advisories`.
    /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)`.
    public enum SecurityAdvisoriesListGlobalAdvisories {
        public static let id: Swift.String = "security-advisories/list-global-advisories"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/advisories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/ghsa_id`.
                public var ghsaId: Swift.String?
                /// - Remark: Generated from `#/paths/advisories/GET/query/type`.
                @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case reviewed = "reviewed"
                    case malware = "malware"
                    case unreviewed = "unreviewed"
                }
                /// If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/type`.
                public var _type: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query._TypePayload?
                /// If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/cve_id`.
                public var cveId: Swift.String?
                /// If specified, only advisories for these ecosystems will be returned.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/ecosystem`.
                public var ecosystem: Components.Schemas.SecurityAdvisoryEcosystems?
                /// - Remark: Generated from `#/paths/advisories/GET/query/severity`.
                @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case unknown = "unknown"
                    case low = "low"
                    case medium = "medium"
                    case high = "high"
                    case critical = "critical"
                }
                /// If specified, only advisories with these severities will be returned.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/severity`.
                public var severity: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.SeverityPayload?
                /// - Remark: Generated from `#/paths/advisories/GET/query/cwes`.
                @frozen public enum CwesPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/advisories/GET/query/cwes/case1`.
                    case case1(Swift.String)
                    /// - Remark: Generated from `#/paths/advisories/GET/query/cwes/case2`.
                    case case2([Swift.String])
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.
                ///
                /// Example: `cwes=79,284,22` or `cwes[]=79&cwes[]=284&cwes[]=22`
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/cwes`.
                public var cwes: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.CwesPayload?
                /// Whether to only return advisories that have been withdrawn.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/is_withdrawn`.
                public var isWithdrawn: Swift.Bool?
                /// - Remark: Generated from `#/paths/advisories/GET/query/affects`.
                @frozen public enum AffectsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/advisories/GET/query/affects/case1`.
                    case case1(Swift.String)
                    /// - Remark: Generated from `#/paths/advisories/GET/query/affects/case2`.
                    case case2([Swift.String])
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified.
                /// If the query parameter causes the URL to exceed the maximum URL length supported by your client, you must specify fewer packages.
                ///
                /// Example: `affects=package1,package2@1.0.0,package3@^2.0.0` or `affects[]=package1&affects[]=package2@1.0.0`
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/affects`.
                public var affects: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.AffectsPayload?
                /// If specified, only return advisories that were published on a date or date range.
                ///
                /// For more information on the syntax of the date range, see "[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/published`.
                public var published: Swift.String?
                /// If specified, only return advisories that were updated on a date or date range.
                ///
                /// For more information on the syntax of the date range, see "[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/updated`.
                public var updated: Swift.String?
                /// If specified, only show advisories that were updated or published on a date or date range.
                ///
                /// For more information on the syntax of the date range, see "[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/modified`.
                public var modified: Swift.String?
                /// If specified, only return advisories that have an EPSS percentage score that matches the provided value.
                /// The EPSS percentage represents the likelihood of a CVE being exploited.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/epss_percentage`.
                public var epssPercentage: Swift.String?
                /// If specified, only return advisories that have an EPSS percentile score that matches the provided value.
                /// The EPSS percentile represents the relative rank of the CVE's likelihood of being exploited compared to other CVEs.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/epss_percentile`.
                public var epssPercentile: Swift.String?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// - Remark: Generated from `#/paths/advisories/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case updated = "updated"
                    case published = "published"
                    case epssPercentage = "epss_percentage"
                    case epssPercentile = "epss_percentile"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/advisories/GET/query/sort`.
                public var sort: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.SortPayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - ghsaId: If specified, only advisories with this GHSA (GitHub Security Advisory) identifier will be returned.
                ///   - _type: If specified, only advisories of this type will be returned. By default, a request with no other parameters defined will only return reviewed advisories that are not malware.
                ///   - cveId: If specified, only advisories with this CVE (Common Vulnerabilities and Exposures) identifier will be returned.
                ///   - ecosystem: If specified, only advisories for these ecosystems will be returned.
                ///   - severity: If specified, only advisories with these severities will be returned.
                ///   - cwes: If specified, only advisories with these Common Weakness Enumerations (CWEs) will be returned.
                ///   - isWithdrawn: Whether to only return advisories that have been withdrawn.
                ///   - affects: If specified, only return advisories that affect any of `package` or `package@version`. A maximum of 1000 packages can be specified.
                ///   - published: If specified, only return advisories that were published on a date or date range.
                ///   - updated: If specified, only return advisories that were updated on a date or date range.
                ///   - modified: If specified, only show advisories that were updated or published on a date or date range.
                ///   - epssPercentage: If specified, only return advisories that have an EPSS percentage score that matches the provided value.
                ///   - epssPercentile: If specified, only return advisories that have an EPSS percentile score that matches the provided value.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - sort: The property to sort the results by.
                public init(
                    ghsaId: Swift.String? = nil,
                    _type: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query._TypePayload? = nil,
                    cveId: Swift.String? = nil,
                    ecosystem: Components.Schemas.SecurityAdvisoryEcosystems? = nil,
                    severity: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.SeverityPayload? = nil,
                    cwes: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.CwesPayload? = nil,
                    isWithdrawn: Swift.Bool? = nil,
                    affects: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.AffectsPayload? = nil,
                    published: Swift.String? = nil,
                    updated: Swift.String? = nil,
                    modified: Swift.String? = nil,
                    epssPercentage: Swift.String? = nil,
                    epssPercentile: Swift.String? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Swift.Int? = nil,
                    sort: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query.SortPayload? = nil
                ) {
                    self.ghsaId = ghsaId
                    self._type = _type
                    self.cveId = cveId
                    self.ecosystem = ecosystem
                    self.severity = severity
                    self.cwes = cwes
                    self.isWithdrawn = isWithdrawn
                    self.affects = affects
                    self.published = published
                    self.updated = updated
                    self.modified = modified
                    self.epssPercentage = epssPercentage
                    self.epssPercentile = epssPercentile
                    self.before = before
                    self.after = after
                    self.direction = direction
                    self.perPage = perPage
                    self.sort = sort
                }
            }
            public var query: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query
            /// - Remark: Generated from `#/paths/advisories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListGlobalAdvisories.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListGlobalAdvisories.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Query = .init(),
                headers: Operations.SecurityAdvisoriesListGlobalAdvisories.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/advisories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/advisories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.GlobalAdvisory])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.GlobalAdvisory] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesListGlobalAdvisories.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct TooManyRequests: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/advisories/GET/responses/429/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/advisories/GET/responses/429/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.TooManyRequests.Body
                /// Creates a new `TooManyRequests`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.TooManyRequests.Body) {
                    self.body = body
                }
            }
            /// Too many requests
            ///
            /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)/responses/429`.
            ///
            /// HTTP response code: `429 tooManyRequests`.
            case tooManyRequests(Operations.SecurityAdvisoriesListGlobalAdvisories.Output.TooManyRequests)
            /// The associated value of the enum case if `self` is `.tooManyRequests`.
            ///
            /// - Throws: An error if `self` is not `.tooManyRequests`.
            /// - SeeAlso: `.tooManyRequests`.
            public var tooManyRequests: Operations.SecurityAdvisoriesListGlobalAdvisories.Output.TooManyRequests {
                get throws {
                    switch self {
                    case let .tooManyRequests(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "tooManyRequests",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//advisories/get(security-advisories/list-global-advisories)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a global security advisory
    ///
    /// Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// - Remark: HTTP `GET /advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//advisories/{ghsa_id}/get(security-advisories/get-global-advisory)`.
    public enum SecurityAdvisoriesGetGlobalAdvisory {
        public static let id: Swift.String = "security-advisories/get-global-advisory"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/advisories/{ghsa_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The GHSA (GitHub Security Advisory) identifier of the advisory.
                ///
                /// - Remark: Generated from `#/paths/advisories/{ghsa_id}/GET/path/ghsa_id`.
                public var ghsaId: Components.Parameters.GhsaId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - ghsaId: The GHSA (GitHub Security Advisory) identifier of the advisory.
                public init(ghsaId: Components.Parameters.GhsaId) {
                    self.ghsaId = ghsaId
                }
            }
            public var path: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Path
            /// - Remark: Generated from `#/paths/advisories/{ghsa_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesGetGlobalAdvisory.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesGetGlobalAdvisory.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Path,
                headers: Operations.SecurityAdvisoriesGetGlobalAdvisory.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/advisories/{ghsa_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/advisories/{ghsa_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.GlobalAdvisory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.GlobalAdvisory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesGetGlobalAdvisory.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesGetGlobalAdvisory.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//advisories/{ghsa_id}/get(security-advisories/get-global-advisory)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesGetGlobalAdvisory.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesGetGlobalAdvisory.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//advisories/{ghsa_id}/get(security-advisories/get-global-advisory)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository security advisories for an organization
    ///
    /// Lists repository security advisories for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/security-advisories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)`.
    public enum SecurityAdvisoriesListOrgRepositoryAdvisories {
        public static let id: Swift.String = "security-advisories/list-org-repository-advisories"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case published = "published"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/sort`.
                public var sort: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query.SortPayload?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// The number of advisories to return per page. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case triage = "triage"
                    case draft = "draft"
                    case published = "published"
                    case closed = "closed"
                }
                /// Filter by the state of the repository advisories. Only advisories of this state will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/query/state`.
                public var state: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query.StatePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property to sort the results by.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of advisories to return per page. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - state: Filter by the state of the repository advisories. Only advisories of this state will be returned.
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    sort: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query.SortPayload? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    perPage: Swift.Int? = nil,
                    state: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query.StatePayload? = nil
                ) {
                    self.direction = direction
                    self.sort = sort
                    self.before = before
                    self.after = after
                    self.perPage = perPage
                    self.state = state
                }
            }
            public var query: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Path,
                query: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Query = .init(),
                headers: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/security-advisories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.RepositoryAdvisory])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.RepositoryAdvisory] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesListOrgRepositoryAdvisories.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/security-advisories/get(security-advisories/list-org-repository-advisories)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List repository security advisories
    ///
    /// Lists security advisories in a repository.
    ///
    /// The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)`.
    public enum SecurityAdvisoriesListRepositoryAdvisories {
        public static let id: Swift.String = "security-advisories/list-repository-advisories"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/sort`.
                @frozen public enum SortPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case published = "published"
                }
                /// The property to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/sort`.
                public var sort: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query.SortPayload?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// The number of advisories to return per page. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/state`.
                @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case triage = "triage"
                    case draft = "draft"
                    case published = "published"
                    case closed = "closed"
                }
                /// Filter by state of the repository advisories. Only advisories of this state will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/query/state`.
                public var state: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query.StatePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - direction: The direction to sort the results by.
                ///   - sort: The property to sort the results by.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of advisories to return per page. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - state: Filter by state of the repository advisories. Only advisories of this state will be returned.
                public init(
                    direction: Components.Parameters.Direction? = nil,
                    sort: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query.SortPayload? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    perPage: Swift.Int? = nil,
                    state: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query.StatePayload? = nil
                ) {
                    self.direction = direction
                    self.sort = sort
                    self.before = before
                    self.after = after
                    self.perPage = perPage
                    self.state = state
                }
            }
            public var query: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListRepositoryAdvisories.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesListRepositoryAdvisories.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Path,
                query: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Query = .init(),
                headers: Operations.SecurityAdvisoriesListRepositoryAdvisories.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.RepositoryAdvisory])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.RepositoryAdvisory] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesListRepositoryAdvisories.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesListRepositoryAdvisories.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesListRepositoryAdvisories.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesListRepositoryAdvisories.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/get(security-advisories/list-repository-advisories)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Create a repository security advisory
    ///
    /// Creates a new repository security advisory.
    ///
    /// In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)`.
    public enum SecurityAdvisoriesCreateRepositoryAdvisory {
        public static let id: Swift.String = "security-advisories/create-repository-advisory"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateRepositoryAdvisory.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateRepositoryAdvisory.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.RepositoryAdvisoryCreate)
            }
            public var body: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Path,
                headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Headers = .init(),
                body: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.RepositoryAdvisory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositoryAdvisory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.SecurityAdvisoriesCreateRepositoryAdvisory.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/post(security-advisories/create-repository-advisory)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Privately report a security vulnerability
    ///
    /// Report a security vulnerability to the maintainers of the repository.
    /// See "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)" for more information about private vulnerability reporting.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/reports`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)`.
    public enum SecurityAdvisoriesCreatePrivateVulnerabilityReport {
        public static let id: Swift.String = "security-advisories/create-private-vulnerability-report"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.PrivateVulnerabilityReportCreate)
            }
            public var body: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Path,
                headers: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Headers = .init(),
                body: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/reports/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.RepositoryAdvisory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositoryAdvisory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.SecurityAdvisoriesCreatePrivateVulnerabilityReport.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/reports/post(security-advisories/create-private-vulnerability-report)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository security advisory
    ///
    /// Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// Anyone can access any published security advisory on a public repository.
    ///
    /// The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a
    /// collaborator on the security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)`.
    public enum SecurityAdvisoriesGetRepositoryAdvisory {
        public static let id: Swift.String = "security-advisories/get-repository-advisory"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The GHSA (GitHub Security Advisory) identifier of the advisory.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/path/ghsa_id`.
                public var ghsaId: Components.Parameters.GhsaId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ghsaId: The GHSA (GitHub Security Advisory) identifier of the advisory.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ghsaId: Components.Parameters.GhsaId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ghsaId = ghsaId
                }
            }
            public var path: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesGetRepositoryAdvisory.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesGetRepositoryAdvisory.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Path,
                headers: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RepositoryAdvisory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositoryAdvisory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesGetRepositoryAdvisory.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/get(security-advisories/get-repository-advisory)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a repository security advisory
    ///
    /// Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.
    ///
    /// In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository,
    /// or a collaborator on the repository security advisory.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/security-advisories/{ghsa_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)`.
    public enum SecurityAdvisoriesUpdateRepositoryAdvisory {
        public static let id: Swift.String = "security-advisories/update-repository-advisory"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The GHSA (GitHub Security Advisory) identifier of the advisory.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/path/ghsa_id`.
                public var ghsaId: Components.Parameters.GhsaId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ghsaId: The GHSA (GitHub Security Advisory) identifier of the advisory.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ghsaId: Components.Parameters.GhsaId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ghsaId = ghsaId
                }
            }
            public var path: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/requestBody/content/application\/json`.
                case json(Components.Schemas.RepositoryAdvisoryUpdate)
            }
            public var body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Path,
                headers: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Headers = .init(),
                body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.RepositoryAdvisory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepositoryAdvisory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/responses/422/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/PATCH/responses/422/content/application\/json`.
                    case json(Components.Schemas.ValidationError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ValidationError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.UnprocessableContent.Body
                /// Creates a new `UnprocessableContent`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.UnprocessableContent.Body) {
                    self.body = body
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/patch(security-advisories/update-repository-advisory)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.UnprocessableContent)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.SecurityAdvisoriesUpdateRepositoryAdvisory.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Request a CVE for a repository security advisory
    ///
    /// If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see "[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional)."
    ///
    /// You may request a CVE for public repositories, but cannot do so for private repositories.
    ///
    /// In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)`.
    public enum SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest {
        public static let id: Swift.String = "security-advisories/create-repository-advisory-cve-request"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The GHSA (GitHub Security Advisory) identifier of the advisory.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/POST/path/ghsa_id`.
                public var ghsaId: Components.Parameters.GhsaId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ghsaId: The GHSA (GitHub Security Advisory) identifier of the advisory.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ghsaId: Components.Parameters.GhsaId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ghsaId = ghsaId
                }
            }
            public var path: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Path,
                headers: Operations.SecurityAdvisoriesCreateRepositoryAdvisoryCveRequest.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve/post(security-advisories/create-repository-advisory-cve-request)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Create a temporary private fork
    ///
    /// Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.
    ///
    /// > [!NOTE]
    /// > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)`.
    public enum SecurityAdvisoriesCreateFork {
        public static let id: Swift.String = "security-advisories/create-fork"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The GHSA (GitHub Security Advisory) identifier of the advisory.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/path/ghsa_id`.
                public var ghsaId: Components.Parameters.GhsaId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - ghsaId: The GHSA (GitHub Security Advisory) identifier of the advisory.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    ghsaId: Components.Parameters.GhsaId
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.ghsaId = ghsaId
                }
            }
            public var path: Operations.SecurityAdvisoriesCreateFork.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateFork.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecurityAdvisoriesCreateFork.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecurityAdvisoriesCreateFork.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecurityAdvisoriesCreateFork.Input.Path,
                headers: Operations.SecurityAdvisoriesCreateFork.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.FullRepository)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FullRepository {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecurityAdvisoriesCreateFork.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecurityAdvisoriesCreateFork.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.SecurityAdvisoriesCreateFork.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.SecurityAdvisoriesCreateFork.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks/post(security-advisories/create-fork)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
}
