// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List secret scanning alerts for an enterprise
    ///
    /// Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
    ///
    /// Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
    ///
    /// The authenticated user must be a member of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)`.
    func secretScanningListAlertsForEnterprise(_ input: Operations.SecretScanningListAlertsForEnterprise.Input) async throws -> Operations.SecretScanningListAlertsForEnterprise.Output
    /// List secret scanning alerts for an organization
    ///
    /// Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)`.
    func secretScanningListAlertsForOrg(_ input: Operations.SecretScanningListAlertsForOrg.Input) async throws -> Operations.SecretScanningListAlertsForOrg.Output
    /// List organization pattern configurations
    ///
    /// Lists the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)`.
    func secretScanningListOrgPatternConfigs(_ input: Operations.SecretScanningListOrgPatternConfigs.Input) async throws -> Operations.SecretScanningListOrgPatternConfigs.Output
    /// Update organization pattern configurations
    ///
    /// Updates the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)`.
    func secretScanningUpdateOrgPatternConfigs(_ input: Operations.SecretScanningUpdateOrgPatternConfigs.Input) async throws -> Operations.SecretScanningUpdateOrgPatternConfigs.Output
    /// List secret scanning alerts for a repository
    ///
    /// Lists secret scanning alerts for an eligible repository, from newest to oldest.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)`.
    func secretScanningListAlertsForRepo(_ input: Operations.SecretScanningListAlertsForRepo.Input) async throws -> Operations.SecretScanningListAlertsForRepo.Output
    /// Get a secret scanning alert
    ///
    /// Gets a single secret scanning alert detected in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)`.
    func secretScanningGetAlert(_ input: Operations.SecretScanningGetAlert.Input) async throws -> Operations.SecretScanningGetAlert.Output
    /// Update a secret scanning alert
    ///
    /// Updates the status of a secret scanning alert in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)`.
    func secretScanningUpdateAlert(_ input: Operations.SecretScanningUpdateAlert.Input) async throws -> Operations.SecretScanningUpdateAlert.Output
    /// List locations for a secret scanning alert
    ///
    /// Lists all locations for a given secret scanning alert for an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)`.
    func secretScanningListLocationsForAlert(_ input: Operations.SecretScanningListLocationsForAlert.Input) async throws -> Operations.SecretScanningListLocationsForAlert.Output
    /// Create a push protection bypass
    ///
    /// Creates a bypass for a previously push protected secret.
    ///
    /// The authenticated user must be the original author of the committed secret.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)`.
    func secretScanningCreatePushProtectionBypass(_ input: Operations.SecretScanningCreatePushProtectionBypass.Input) async throws -> Operations.SecretScanningCreatePushProtectionBypass.Output
    /// Get secret scanning scan history for a repository
    ///
    /// Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/scan-history`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)`.
    func secretScanningGetScanHistory(_ input: Operations.SecretScanningGetScanHistory.Input) async throws -> Operations.SecretScanningGetScanHistory.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List secret scanning alerts for an enterprise
    ///
    /// Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
    ///
    /// Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
    ///
    /// The authenticated user must be a member of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)`.
    public func secretScanningListAlertsForEnterprise(
        path: Operations.SecretScanningListAlertsForEnterprise.Input.Path,
        query: Operations.SecretScanningListAlertsForEnterprise.Input.Query = .init(),
        headers: Operations.SecretScanningListAlertsForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningListAlertsForEnterprise.Output {
        try await secretScanningListAlertsForEnterprise(Operations.SecretScanningListAlertsForEnterprise.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List secret scanning alerts for an organization
    ///
    /// Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)`.
    public func secretScanningListAlertsForOrg(
        path: Operations.SecretScanningListAlertsForOrg.Input.Path,
        query: Operations.SecretScanningListAlertsForOrg.Input.Query = .init(),
        headers: Operations.SecretScanningListAlertsForOrg.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningListAlertsForOrg.Output {
        try await secretScanningListAlertsForOrg(Operations.SecretScanningListAlertsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List organization pattern configurations
    ///
    /// Lists the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)`.
    public func secretScanningListOrgPatternConfigs(
        path: Operations.SecretScanningListOrgPatternConfigs.Input.Path,
        headers: Operations.SecretScanningListOrgPatternConfigs.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningListOrgPatternConfigs.Output {
        try await secretScanningListOrgPatternConfigs(Operations.SecretScanningListOrgPatternConfigs.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update organization pattern configurations
    ///
    /// Updates the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)`.
    public func secretScanningUpdateOrgPatternConfigs(
        path: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Path,
        headers: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Headers = .init(),
        body: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body
    ) async throws -> Operations.SecretScanningUpdateOrgPatternConfigs.Output {
        try await secretScanningUpdateOrgPatternConfigs(Operations.SecretScanningUpdateOrgPatternConfigs.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List secret scanning alerts for a repository
    ///
    /// Lists secret scanning alerts for an eligible repository, from newest to oldest.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)`.
    public func secretScanningListAlertsForRepo(
        path: Operations.SecretScanningListAlertsForRepo.Input.Path,
        query: Operations.SecretScanningListAlertsForRepo.Input.Query = .init(),
        headers: Operations.SecretScanningListAlertsForRepo.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningListAlertsForRepo.Output {
        try await secretScanningListAlertsForRepo(Operations.SecretScanningListAlertsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a secret scanning alert
    ///
    /// Gets a single secret scanning alert detected in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)`.
    public func secretScanningGetAlert(
        path: Operations.SecretScanningGetAlert.Input.Path,
        query: Operations.SecretScanningGetAlert.Input.Query = .init(),
        headers: Operations.SecretScanningGetAlert.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningGetAlert.Output {
        try await secretScanningGetAlert(Operations.SecretScanningGetAlert.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Update a secret scanning alert
    ///
    /// Updates the status of a secret scanning alert in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)`.
    public func secretScanningUpdateAlert(
        path: Operations.SecretScanningUpdateAlert.Input.Path,
        headers: Operations.SecretScanningUpdateAlert.Input.Headers = .init(),
        body: Operations.SecretScanningUpdateAlert.Input.Body
    ) async throws -> Operations.SecretScanningUpdateAlert.Output {
        try await secretScanningUpdateAlert(Operations.SecretScanningUpdateAlert.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List locations for a secret scanning alert
    ///
    /// Lists all locations for a given secret scanning alert for an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)`.
    public func secretScanningListLocationsForAlert(
        path: Operations.SecretScanningListLocationsForAlert.Input.Path,
        query: Operations.SecretScanningListLocationsForAlert.Input.Query = .init(),
        headers: Operations.SecretScanningListLocationsForAlert.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningListLocationsForAlert.Output {
        try await secretScanningListLocationsForAlert(Operations.SecretScanningListLocationsForAlert.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a push protection bypass
    ///
    /// Creates a bypass for a previously push protected secret.
    ///
    /// The authenticated user must be the original author of the committed secret.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)`.
    public func secretScanningCreatePushProtectionBypass(
        path: Operations.SecretScanningCreatePushProtectionBypass.Input.Path,
        headers: Operations.SecretScanningCreatePushProtectionBypass.Input.Headers = .init(),
        body: Operations.SecretScanningCreatePushProtectionBypass.Input.Body
    ) async throws -> Operations.SecretScanningCreatePushProtectionBypass.Output {
        try await secretScanningCreatePushProtectionBypass(Operations.SecretScanningCreatePushProtectionBypass.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get secret scanning scan history for a repository
    ///
    /// Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/scan-history`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)`.
    public func secretScanningGetScanHistory(
        path: Operations.SecretScanningGetScanHistory.Input.Path,
        headers: Operations.SecretScanningGetScanHistory.Input.Headers = .init()
    ) async throws -> Operations.SecretScanningGetScanHistory.Output {
        try await secretScanningGetScanHistory(Operations.SecretScanningGetScanHistory.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-repository`.
        public struct SimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `SimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// The security alert number.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-number`.
        public typealias AlertNumber = Swift.Int
        /// The REST API URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-url`.
        public typealias AlertUrl = Swift.String
        /// The GitHub URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-html-url`.
        public typealias AlertHtmlUrl = Swift.String
        /// The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-created-at`.
        public typealias AlertCreatedAt = Foundation.Date
        /// The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-alert-updated-at`.
        public typealias NullableAlertUpdatedAt = Foundation.Date
        /// Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-alert-state`.
        @frozen public enum SecretScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case resolved = "resolved"
        }
        /// **Required when the `state` is `resolved`.** The reason for resolving the alert.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-alert-resolution`.
        @frozen public enum SecretScanningAlertResolution: String, Codable, Hashable, Sendable, CaseIterable {
            case falsePositive = "false_positive"
            case wontFix = "wont_fix"
            case revoked = "revoked"
            case usedInTests = "used_in_tests"
        }
        /// Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit`.
        public struct SecretScanningLocationCommit: Codable, Hashable, Sendable {
            /// The file path in the repository
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/path`.
            public var path: Swift.String
            /// Line number at which the secret starts in the file
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/start_line`.
            public var startLine: Swift.Double
            /// Line number at which the secret ends in the file
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/end_line`.
            public var endLine: Swift.Double
            /// The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/start_column`.
            public var startColumn: Swift.Double
            /// The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/end_column`.
            public var endColumn: Swift.Double
            /// SHA-1 hash ID of the associated blob
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/blob_sha`.
            public var blobSha: Swift.String
            /// The API URL to get the associated blob resource
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/blob_url`.
            public var blobUrl: Swift.String
            /// SHA-1 hash ID of the associated commit
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/commit_sha`.
            public var commitSha: Swift.String
            /// The API URL to get the associated commit resource
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-commit/commit_url`.
            public var commitUrl: Swift.String
            /// Creates a new `SecretScanningLocationCommit`.
            ///
            /// - Parameters:
            ///   - path: The file path in the repository
            ///   - startLine: Line number at which the secret starts in the file
            ///   - endLine: Line number at which the secret ends in the file
            ///   - startColumn: The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
            ///   - endColumn: The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
            ///   - blobSha: SHA-1 hash ID of the associated blob
            ///   - blobUrl: The API URL to get the associated blob resource
            ///   - commitSha: SHA-1 hash ID of the associated commit
            ///   - commitUrl: The API URL to get the associated commit resource
            public init(
                path: Swift.String,
                startLine: Swift.Double,
                endLine: Swift.Double,
                startColumn: Swift.Double,
                endColumn: Swift.Double,
                blobSha: Swift.String,
                blobUrl: Swift.String,
                commitSha: Swift.String,
                commitUrl: Swift.String
            ) {
                self.path = path
                self.startLine = startLine
                self.endLine = endLine
                self.startColumn = startColumn
                self.endColumn = endColumn
                self.blobSha = blobSha
                self.blobUrl = blobUrl
                self.commitSha = commitSha
                self.commitUrl = commitUrl
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case startLine = "start_line"
                case endLine = "end_line"
                case startColumn = "start_column"
                case endColumn = "end_column"
                case blobSha = "blob_sha"
                case blobUrl = "blob_url"
                case commitSha = "commit_sha"
                case commitUrl = "commit_url"
            }
        }
        /// Represents a 'wiki_commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository wiki.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit`.
        public struct SecretScanningLocationWikiCommit: Codable, Hashable, Sendable {
            /// The file path of the wiki page
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/path`.
            public var path: Swift.String
            /// Line number at which the secret starts in the file
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/start_line`.
            public var startLine: Swift.Double
            /// Line number at which the secret ends in the file
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/end_line`.
            public var endLine: Swift.Double
            /// The column at which the secret starts within the start line when the file is interpreted as 8-bit ASCII.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/start_column`.
            public var startColumn: Swift.Double
            /// The column at which the secret ends within the end line when the file is interpreted as 8-bit ASCII.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/end_column`.
            public var endColumn: Swift.Double
            /// SHA-1 hash ID of the associated blob
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/blob_sha`.
            public var blobSha: Swift.String
            /// The GitHub URL to get the associated wiki page
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/page_url`.
            public var pageUrl: Swift.String
            /// SHA-1 hash ID of the associated commit
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/commit_sha`.
            public var commitSha: Swift.String
            /// The GitHub URL to get the associated wiki commit
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-wiki-commit/commit_url`.
            public var commitUrl: Swift.String
            /// Creates a new `SecretScanningLocationWikiCommit`.
            ///
            /// - Parameters:
            ///   - path: The file path of the wiki page
            ///   - startLine: Line number at which the secret starts in the file
            ///   - endLine: Line number at which the secret ends in the file
            ///   - startColumn: The column at which the secret starts within the start line when the file is interpreted as 8-bit ASCII.
            ///   - endColumn: The column at which the secret ends within the end line when the file is interpreted as 8-bit ASCII.
            ///   - blobSha: SHA-1 hash ID of the associated blob
            ///   - pageUrl: The GitHub URL to get the associated wiki page
            ///   - commitSha: SHA-1 hash ID of the associated commit
            ///   - commitUrl: The GitHub URL to get the associated wiki commit
            public init(
                path: Swift.String,
                startLine: Swift.Double,
                endLine: Swift.Double,
                startColumn: Swift.Double,
                endColumn: Swift.Double,
                blobSha: Swift.String,
                pageUrl: Swift.String,
                commitSha: Swift.String,
                commitUrl: Swift.String
            ) {
                self.path = path
                self.startLine = startLine
                self.endLine = endLine
                self.startColumn = startColumn
                self.endColumn = endColumn
                self.blobSha = blobSha
                self.pageUrl = pageUrl
                self.commitSha = commitSha
                self.commitUrl = commitUrl
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case startLine = "start_line"
                case endLine = "end_line"
                case startColumn = "start_column"
                case endColumn = "end_column"
                case blobSha = "blob_sha"
                case pageUrl = "page_url"
                case commitSha = "commit_sha"
                case commitUrl = "commit_url"
            }
        }
        /// Represents an 'issue_title' secret scanning location type. This location type shows that a secret was detected in the title of an issue.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-title`.
        public struct SecretScanningLocationIssueTitle: Codable, Hashable, Sendable {
            /// The API URL to get the issue where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-title/issue_title_url`.
            public var issueTitleUrl: Swift.String
            /// Creates a new `SecretScanningLocationIssueTitle`.
            ///
            /// - Parameters:
            ///   - issueTitleUrl: The API URL to get the issue where the secret was detected.
            public init(issueTitleUrl: Swift.String) {
                self.issueTitleUrl = issueTitleUrl
            }
            public enum CodingKeys: String, CodingKey {
                case issueTitleUrl = "issue_title_url"
            }
        }
        /// Represents an 'issue_body' secret scanning location type. This location type shows that a secret was detected in the body of an issue.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-body`.
        public struct SecretScanningLocationIssueBody: Codable, Hashable, Sendable {
            /// The API URL to get the issue where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-body/issue_body_url`.
            public var issueBodyUrl: Swift.String
            /// Creates a new `SecretScanningLocationIssueBody`.
            ///
            /// - Parameters:
            ///   - issueBodyUrl: The API URL to get the issue where the secret was detected.
            public init(issueBodyUrl: Swift.String) {
                self.issueBodyUrl = issueBodyUrl
            }
            public enum CodingKeys: String, CodingKey {
                case issueBodyUrl = "issue_body_url"
            }
        }
        /// Represents an 'issue_comment' secret scanning location type. This location type shows that a secret was detected in a comment on an issue.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-comment`.
        public struct SecretScanningLocationIssueComment: Codable, Hashable, Sendable {
            /// The API URL to get the issue comment where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-issue-comment/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// Creates a new `SecretScanningLocationIssueComment`.
            ///
            /// - Parameters:
            ///   - issueCommentUrl: The API URL to get the issue comment where the secret was detected.
            public init(issueCommentUrl: Swift.String) {
                self.issueCommentUrl = issueCommentUrl
            }
            public enum CodingKeys: String, CodingKey {
                case issueCommentUrl = "issue_comment_url"
            }
        }
        /// Represents a 'discussion_title' secret scanning location type. This location type shows that a secret was detected in the title of a discussion.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-title`.
        public struct SecretScanningLocationDiscussionTitle: Codable, Hashable, Sendable {
            /// The URL to the discussion where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-title/discussion_title_url`.
            public var discussionTitleUrl: Swift.String
            /// Creates a new `SecretScanningLocationDiscussionTitle`.
            ///
            /// - Parameters:
            ///   - discussionTitleUrl: The URL to the discussion where the secret was detected.
            public init(discussionTitleUrl: Swift.String) {
                self.discussionTitleUrl = discussionTitleUrl
            }
            public enum CodingKeys: String, CodingKey {
                case discussionTitleUrl = "discussion_title_url"
            }
        }
        /// Represents a 'discussion_body' secret scanning location type. This location type shows that a secret was detected in the body of a discussion.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-body`.
        public struct SecretScanningLocationDiscussionBody: Codable, Hashable, Sendable {
            /// The URL to the discussion where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-body/discussion_body_url`.
            public var discussionBodyUrl: Swift.String
            /// Creates a new `SecretScanningLocationDiscussionBody`.
            ///
            /// - Parameters:
            ///   - discussionBodyUrl: The URL to the discussion where the secret was detected.
            public init(discussionBodyUrl: Swift.String) {
                self.discussionBodyUrl = discussionBodyUrl
            }
            public enum CodingKeys: String, CodingKey {
                case discussionBodyUrl = "discussion_body_url"
            }
        }
        /// Represents a 'discussion_comment' secret scanning location type. This location type shows that a secret was detected in a comment on a discussion.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-comment`.
        public struct SecretScanningLocationDiscussionComment: Codable, Hashable, Sendable {
            /// The API URL to get the discussion comment where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-discussion-comment/discussion_comment_url`.
            public var discussionCommentUrl: Swift.String
            /// Creates a new `SecretScanningLocationDiscussionComment`.
            ///
            /// - Parameters:
            ///   - discussionCommentUrl: The API URL to get the discussion comment where the secret was detected.
            public init(discussionCommentUrl: Swift.String) {
                self.discussionCommentUrl = discussionCommentUrl
            }
            public enum CodingKeys: String, CodingKey {
                case discussionCommentUrl = "discussion_comment_url"
            }
        }
        /// Represents a 'pull_request_title' secret scanning location type. This location type shows that a secret was detected in the title of a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-title`.
        public struct SecretScanningLocationPullRequestTitle: Codable, Hashable, Sendable {
            /// The API URL to get the pull request where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-title/pull_request_title_url`.
            public var pullRequestTitleUrl: Swift.String
            /// Creates a new `SecretScanningLocationPullRequestTitle`.
            ///
            /// - Parameters:
            ///   - pullRequestTitleUrl: The API URL to get the pull request where the secret was detected.
            public init(pullRequestTitleUrl: Swift.String) {
                self.pullRequestTitleUrl = pullRequestTitleUrl
            }
            public enum CodingKeys: String, CodingKey {
                case pullRequestTitleUrl = "pull_request_title_url"
            }
        }
        /// Represents a 'pull_request_body' secret scanning location type. This location type shows that a secret was detected in the body of a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-body`.
        public struct SecretScanningLocationPullRequestBody: Codable, Hashable, Sendable {
            /// The API URL to get the pull request where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-body/pull_request_body_url`.
            public var pullRequestBodyUrl: Swift.String
            /// Creates a new `SecretScanningLocationPullRequestBody`.
            ///
            /// - Parameters:
            ///   - pullRequestBodyUrl: The API URL to get the pull request where the secret was detected.
            public init(pullRequestBodyUrl: Swift.String) {
                self.pullRequestBodyUrl = pullRequestBodyUrl
            }
            public enum CodingKeys: String, CodingKey {
                case pullRequestBodyUrl = "pull_request_body_url"
            }
        }
        /// Represents a 'pull_request_comment' secret scanning location type. This location type shows that a secret was detected in a comment on a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-comment`.
        public struct SecretScanningLocationPullRequestComment: Codable, Hashable, Sendable {
            /// The API URL to get the pull request comment where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-comment/pull_request_comment_url`.
            public var pullRequestCommentUrl: Swift.String
            /// Creates a new `SecretScanningLocationPullRequestComment`.
            ///
            /// - Parameters:
            ///   - pullRequestCommentUrl: The API URL to get the pull request comment where the secret was detected.
            public init(pullRequestCommentUrl: Swift.String) {
                self.pullRequestCommentUrl = pullRequestCommentUrl
            }
            public enum CodingKeys: String, CodingKey {
                case pullRequestCommentUrl = "pull_request_comment_url"
            }
        }
        /// Represents a 'pull_request_review' secret scanning location type. This location type shows that a secret was detected in a review on a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-review`.
        public struct SecretScanningLocationPullRequestReview: Codable, Hashable, Sendable {
            /// The API URL to get the pull request review where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-review/pull_request_review_url`.
            public var pullRequestReviewUrl: Swift.String
            /// Creates a new `SecretScanningLocationPullRequestReview`.
            ///
            /// - Parameters:
            ///   - pullRequestReviewUrl: The API URL to get the pull request review where the secret was detected.
            public init(pullRequestReviewUrl: Swift.String) {
                self.pullRequestReviewUrl = pullRequestReviewUrl
            }
            public enum CodingKeys: String, CodingKey {
                case pullRequestReviewUrl = "pull_request_review_url"
            }
        }
        /// Represents a 'pull_request_review_comment' secret scanning location type. This location type shows that a secret was detected in a review comment on a pull request.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-review-comment`.
        public struct SecretScanningLocationPullRequestReviewComment: Codable, Hashable, Sendable {
            /// The API URL to get the pull request review comment where the secret was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location-pull-request-review-comment/pull_request_review_comment_url`.
            public var pullRequestReviewCommentUrl: Swift.String
            /// Creates a new `SecretScanningLocationPullRequestReviewComment`.
            ///
            /// - Parameters:
            ///   - pullRequestReviewCommentUrl: The API URL to get the pull request review comment where the secret was detected.
            public init(pullRequestReviewCommentUrl: Swift.String) {
                self.pullRequestReviewCommentUrl = pullRequestReviewCommentUrl
            }
            public enum CodingKeys: String, CodingKey {
                case pullRequestReviewCommentUrl = "pull_request_review_comment_url"
            }
        }
        /// Details on the location where the token was initially detected. This can be a commit, wiki commit, issue, discussion, pull request.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location`.
        @frozen public enum NullableSecretScanningFirstDetectedLocation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case1`.
            case SecretScanningLocationCommit(Components.Schemas.SecretScanningLocationCommit)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case2`.
            case SecretScanningLocationWikiCommit(Components.Schemas.SecretScanningLocationWikiCommit)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case3`.
            case SecretScanningLocationIssueTitle(Components.Schemas.SecretScanningLocationIssueTitle)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case4`.
            case SecretScanningLocationIssueBody(Components.Schemas.SecretScanningLocationIssueBody)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case5`.
            case SecretScanningLocationIssueComment(Components.Schemas.SecretScanningLocationIssueComment)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case6`.
            case SecretScanningLocationDiscussionTitle(Components.Schemas.SecretScanningLocationDiscussionTitle)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case7`.
            case SecretScanningLocationDiscussionBody(Components.Schemas.SecretScanningLocationDiscussionBody)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case8`.
            case SecretScanningLocationDiscussionComment(Components.Schemas.SecretScanningLocationDiscussionComment)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case9`.
            case SecretScanningLocationPullRequestTitle(Components.Schemas.SecretScanningLocationPullRequestTitle)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case10`.
            case SecretScanningLocationPullRequestBody(Components.Schemas.SecretScanningLocationPullRequestBody)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case11`.
            case SecretScanningLocationPullRequestComment(Components.Schemas.SecretScanningLocationPullRequestComment)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case12`.
            case SecretScanningLocationPullRequestReview(Components.Schemas.SecretScanningLocationPullRequestReview)
            /// - Remark: Generated from `#/components/schemas/nullable-secret-scanning-first-detected-location/case13`.
            case SecretScanningLocationPullRequestReviewComment(Components.Schemas.SecretScanningLocationPullRequestReviewComment)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .SecretScanningLocationCommit(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationWikiCommit(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationIssueTitle(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationIssueBody(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationIssueComment(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationDiscussionTitle(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationDiscussionBody(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationDiscussionComment(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationPullRequestTitle(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationPullRequestBody(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationPullRequestComment(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationPullRequestReview(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .SecretScanningLocationPullRequestReviewComment(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .SecretScanningLocationCommit(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationWikiCommit(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationIssueTitle(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationIssueBody(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationIssueComment(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationDiscussionTitle(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationDiscussionBody(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationDiscussionComment(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationPullRequestTitle(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationPullRequestBody(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationPullRequestComment(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationPullRequestReview(value):
                    try value.encode(to: encoder)
                case let .SecretScanningLocationPullRequestReviewComment(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert`.
        public struct OrganizationSecretScanningAlert: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/number`.
            public var number: Components.Schemas.AlertNumber?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/updated_at`.
            public var updatedAt: Components.Schemas.NullableAlertUpdatedAt?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/url`.
            public var url: Components.Schemas.AlertUrl?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl?
            /// The REST API URL of the code locations for this alert.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/locations_url`.
            public var locationsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/state`.
            public var state: Components.Schemas.SecretScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/resolution`.
            public var resolution: Components.Schemas.SecretScanningAlertResolution?
            /// The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/resolved_at`.
            public var resolvedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/resolved_by`.
            public var resolvedBy: Components.Schemas.NullableSimpleUser?
            /// The type of secret that secret scanning detected.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/secret_type`.
            public var secretType: Swift.String?
            /// User-friendly name for the detected secret, matching the `secret_type`.
            /// For a list of built-in patterns, see "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)."
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/secret_type_display_name`.
            public var secretTypeDisplayName: Swift.String?
            /// The secret that was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/secret`.
            public var secret: Swift.String?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/repository`.
            public var repository: Components.Schemas.SimpleRepository?
            /// Whether push protection was bypassed for the detected secret.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypassed`.
            public var pushProtectionBypassed: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypassed_by`.
            public var pushProtectionBypassedBy: Components.Schemas.NullableSimpleUser?
            /// The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypassed_at`.
            public var pushProtectionBypassedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypass_request_reviewer`.
            public var pushProtectionBypassRequestReviewer: Components.Schemas.NullableSimpleUser?
            /// An optional comment when reviewing a push protection bypass.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypass_request_reviewer_comment`.
            public var pushProtectionBypassRequestReviewerComment: Swift.String?
            /// An optional comment when requesting a push protection bypass.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypass_request_comment`.
            public var pushProtectionBypassRequestComment: Swift.String?
            /// The URL to a push protection bypass request.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/push_protection_bypass_request_html_url`.
            public var pushProtectionBypassRequestHtmlUrl: Swift.String?
            /// The comment that was optionally added when this alert was closed
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/resolution_comment`.
            public var resolutionComment: Swift.String?
            /// The token status as of the latest validity check.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/validity`.
            @frozen public enum ValidityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case active = "active"
                case inactive = "inactive"
                case unknown = "unknown"
            }
            /// The token status as of the latest validity check.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/validity`.
            public var validity: Components.Schemas.OrganizationSecretScanningAlert.ValidityPayload?
            /// Whether the secret was publicly leaked.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/publicly_leaked`.
            public var publiclyLeaked: Swift.Bool?
            /// Whether the detected secret was found in multiple repositories in the same organization or enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/multi_repo`.
            public var multiRepo: Swift.Bool?
            /// A boolean value representing whether or not alert is base64 encoded
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/is_base64_encoded`.
            public var isBase64Encoded: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/first_location_detected`.
            public var firstLocationDetected: Components.Schemas.NullableSecretScanningFirstDetectedLocation?
            /// A boolean value representing whether or not the token in the alert was detected in more than one location.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-secret-scanning-alert/has_more_locations`.
            public var hasMoreLocations: Swift.Bool?
            /// Creates a new `OrganizationSecretScanningAlert`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - locationsUrl: The REST API URL of the code locations for this alert.
            ///   - state:
            ///   - resolution:
            ///   - resolvedAt: The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - resolvedBy:
            ///   - secretType: The type of secret that secret scanning detected.
            ///   - secretTypeDisplayName: User-friendly name for the detected secret, matching the `secret_type`.
            ///   - secret: The secret that was detected.
            ///   - repository:
            ///   - pushProtectionBypassed: Whether push protection was bypassed for the detected secret.
            ///   - pushProtectionBypassedBy:
            ///   - pushProtectionBypassedAt: The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - pushProtectionBypassRequestReviewer:
            ///   - pushProtectionBypassRequestReviewerComment: An optional comment when reviewing a push protection bypass.
            ///   - pushProtectionBypassRequestComment: An optional comment when requesting a push protection bypass.
            ///   - pushProtectionBypassRequestHtmlUrl: The URL to a push protection bypass request.
            ///   - resolutionComment: The comment that was optionally added when this alert was closed
            ///   - validity: The token status as of the latest validity check.
            ///   - publiclyLeaked: Whether the secret was publicly leaked.
            ///   - multiRepo: Whether the detected secret was found in multiple repositories in the same organization or enterprise.
            ///   - isBase64Encoded: A boolean value representing whether or not alert is base64 encoded
            ///   - firstLocationDetected:
            ///   - hasMoreLocations: A boolean value representing whether or not the token in the alert was detected in more than one location.
            public init(
                number: Components.Schemas.AlertNumber? = nil,
                createdAt: Components.Schemas.AlertCreatedAt? = nil,
                updatedAt: Components.Schemas.NullableAlertUpdatedAt? = nil,
                url: Components.Schemas.AlertUrl? = nil,
                htmlUrl: Components.Schemas.AlertHtmlUrl? = nil,
                locationsUrl: Swift.String? = nil,
                state: Components.Schemas.SecretScanningAlertState? = nil,
                resolution: Components.Schemas.SecretScanningAlertResolution? = nil,
                resolvedAt: Foundation.Date? = nil,
                resolvedBy: Components.Schemas.NullableSimpleUser? = nil,
                secretType: Swift.String? = nil,
                secretTypeDisplayName: Swift.String? = nil,
                secret: Swift.String? = nil,
                repository: Components.Schemas.SimpleRepository? = nil,
                pushProtectionBypassed: Swift.Bool? = nil,
                pushProtectionBypassedBy: Components.Schemas.NullableSimpleUser? = nil,
                pushProtectionBypassedAt: Foundation.Date? = nil,
                pushProtectionBypassRequestReviewer: Components.Schemas.NullableSimpleUser? = nil,
                pushProtectionBypassRequestReviewerComment: Swift.String? = nil,
                pushProtectionBypassRequestComment: Swift.String? = nil,
                pushProtectionBypassRequestHtmlUrl: Swift.String? = nil,
                resolutionComment: Swift.String? = nil,
                validity: Components.Schemas.OrganizationSecretScanningAlert.ValidityPayload? = nil,
                publiclyLeaked: Swift.Bool? = nil,
                multiRepo: Swift.Bool? = nil,
                isBase64Encoded: Swift.Bool? = nil,
                firstLocationDetected: Components.Schemas.NullableSecretScanningFirstDetectedLocation? = nil,
                hasMoreLocations: Swift.Bool? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.locationsUrl = locationsUrl
                self.state = state
                self.resolution = resolution
                self.resolvedAt = resolvedAt
                self.resolvedBy = resolvedBy
                self.secretType = secretType
                self.secretTypeDisplayName = secretTypeDisplayName
                self.secret = secret
                self.repository = repository
                self.pushProtectionBypassed = pushProtectionBypassed
                self.pushProtectionBypassedBy = pushProtectionBypassedBy
                self.pushProtectionBypassedAt = pushProtectionBypassedAt
                self.pushProtectionBypassRequestReviewer = pushProtectionBypassRequestReviewer
                self.pushProtectionBypassRequestReviewerComment = pushProtectionBypassRequestReviewerComment
                self.pushProtectionBypassRequestComment = pushProtectionBypassRequestComment
                self.pushProtectionBypassRequestHtmlUrl = pushProtectionBypassRequestHtmlUrl
                self.resolutionComment = resolutionComment
                self.validity = validity
                self.publiclyLeaked = publiclyLeaked
                self.multiRepo = multiRepo
                self.isBase64Encoded = isBase64Encoded
                self.firstLocationDetected = firstLocationDetected
                self.hasMoreLocations = hasMoreLocations
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case locationsUrl = "locations_url"
                case state
                case resolution
                case resolvedAt = "resolved_at"
                case resolvedBy = "resolved_by"
                case secretType = "secret_type"
                case secretTypeDisplayName = "secret_type_display_name"
                case secret
                case repository
                case pushProtectionBypassed = "push_protection_bypassed"
                case pushProtectionBypassedBy = "push_protection_bypassed_by"
                case pushProtectionBypassedAt = "push_protection_bypassed_at"
                case pushProtectionBypassRequestReviewer = "push_protection_bypass_request_reviewer"
                case pushProtectionBypassRequestReviewerComment = "push_protection_bypass_request_reviewer_comment"
                case pushProtectionBypassRequestComment = "push_protection_bypass_request_comment"
                case pushProtectionBypassRequestHtmlUrl = "push_protection_bypass_request_html_url"
                case resolutionComment = "resolution_comment"
                case validity
                case publiclyLeaked = "publicly_leaked"
                case multiRepo = "multi_repo"
                case isBase64Encoded = "is_base64_encoded"
                case firstLocationDetected = "first_location_detected"
                case hasMoreLocations = "has_more_locations"
            }
        }
        /// The version of the entity. This is used to confirm you're updating the current version of the entity and mitigate unintentionally overriding someone else's update.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-row-version`.
        public typealias SecretScanningRowVersion = Swift.String
        /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override`.
        public struct SecretScanningPatternOverride: Codable, Hashable, Sendable {
            /// The ID of the pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/token_type`.
            public var tokenType: Swift.String?
            /// The version of this pattern if it's a custom pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/custom_pattern_version`.
            public var customPatternVersion: Swift.String?
            /// The slug of the pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/slug`.
            public var slug: Swift.String?
            /// The user-friendly name for the pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/display_name`.
            public var displayName: Swift.String?
            /// The total number of alerts generated by this pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/alert_total`.
            public var alertTotal: Swift.Int?
            /// The percentage of all alerts that this pattern represents, rounded to the nearest integer.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/alert_total_percentage`.
            public var alertTotalPercentage: Swift.Int?
            /// The number of false positive alerts generated by this pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/false_positives`.
            public var falsePositives: Swift.Int?
            /// The percentage of alerts from this pattern that are false positives, rounded to the nearest integer.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/false_positive_rate`.
            public var falsePositiveRate: Swift.Int?
            /// The percentage of blocks for this pattern that were bypassed, rounded to the nearest integer.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/bypass_rate`.
            public var bypassRate: Swift.Int?
            /// The default push protection setting for this pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/default_setting`.
            @frozen public enum DefaultSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case disabled = "disabled"
                case enabled = "enabled"
            }
            /// The default push protection setting for this pattern.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/default_setting`.
            public var defaultSetting: Components.Schemas.SecretScanningPatternOverride.DefaultSettingPayload?
            /// The push protection setting for this pattern set at the enterprise level. Only present for partner patterns when the organization has a parent enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/enterprise_setting`.
            @frozen public enum EnterpriseSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case notSet = "not-set"
                case disabled = "disabled"
                case enabled = "enabled"
            }
            /// The push protection setting for this pattern set at the enterprise level. Only present for partner patterns when the organization has a parent enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/enterprise_setting`.
            public var enterpriseSetting: Components.Schemas.SecretScanningPatternOverride.EnterpriseSettingPayload?
            /// The current push protection setting for this pattern. If this is `not-set`, then it inherits either the enterprise setting if it exists or the default setting.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/setting`.
            @frozen public enum SettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case notSet = "not-set"
                case disabled = "disabled"
                case enabled = "enabled"
            }
            /// The current push protection setting for this pattern. If this is `not-set`, then it inherits either the enterprise setting if it exists or the default setting.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-override/setting`.
            public var setting: Components.Schemas.SecretScanningPatternOverride.SettingPayload?
            /// Creates a new `SecretScanningPatternOverride`.
            ///
            /// - Parameters:
            ///   - tokenType: The ID of the pattern.
            ///   - customPatternVersion: The version of this pattern if it's a custom pattern.
            ///   - slug: The slug of the pattern.
            ///   - displayName: The user-friendly name for the pattern.
            ///   - alertTotal: The total number of alerts generated by this pattern.
            ///   - alertTotalPercentage: The percentage of all alerts that this pattern represents, rounded to the nearest integer.
            ///   - falsePositives: The number of false positive alerts generated by this pattern.
            ///   - falsePositiveRate: The percentage of alerts from this pattern that are false positives, rounded to the nearest integer.
            ///   - bypassRate: The percentage of blocks for this pattern that were bypassed, rounded to the nearest integer.
            ///   - defaultSetting: The default push protection setting for this pattern.
            ///   - enterpriseSetting: The push protection setting for this pattern set at the enterprise level. Only present for partner patterns when the organization has a parent enterprise.
            ///   - setting: The current push protection setting for this pattern. If this is `not-set`, then it inherits either the enterprise setting if it exists or the default setting.
            public init(
                tokenType: Swift.String? = nil,
                customPatternVersion: Swift.String? = nil,
                slug: Swift.String? = nil,
                displayName: Swift.String? = nil,
                alertTotal: Swift.Int? = nil,
                alertTotalPercentage: Swift.Int? = nil,
                falsePositives: Swift.Int? = nil,
                falsePositiveRate: Swift.Int? = nil,
                bypassRate: Swift.Int? = nil,
                defaultSetting: Components.Schemas.SecretScanningPatternOverride.DefaultSettingPayload? = nil,
                enterpriseSetting: Components.Schemas.SecretScanningPatternOverride.EnterpriseSettingPayload? = nil,
                setting: Components.Schemas.SecretScanningPatternOverride.SettingPayload? = nil
            ) {
                self.tokenType = tokenType
                self.customPatternVersion = customPatternVersion
                self.slug = slug
                self.displayName = displayName
                self.alertTotal = alertTotal
                self.alertTotalPercentage = alertTotalPercentage
                self.falsePositives = falsePositives
                self.falsePositiveRate = falsePositiveRate
                self.bypassRate = bypassRate
                self.defaultSetting = defaultSetting
                self.enterpriseSetting = enterpriseSetting
                self.setting = setting
            }
            public enum CodingKeys: String, CodingKey {
                case tokenType = "token_type"
                case customPatternVersion = "custom_pattern_version"
                case slug
                case displayName = "display_name"
                case alertTotal = "alert_total"
                case alertTotalPercentage = "alert_total_percentage"
                case falsePositives = "false_positives"
                case falsePositiveRate = "false_positive_rate"
                case bypassRate = "bypass_rate"
                case defaultSetting = "default_setting"
                case enterpriseSetting = "enterprise_setting"
                case setting
            }
        }
        /// A collection of secret scanning patterns and their settings related to push protection.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-configuration`.
        public struct SecretScanningPatternConfiguration: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-configuration/pattern_config_version`.
            public var patternConfigVersion: Components.Schemas.SecretScanningRowVersion?
            /// Overrides for partner patterns.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-configuration/provider_pattern_overrides`.
            public var providerPatternOverrides: [Components.Schemas.SecretScanningPatternOverride]?
            /// Overrides for custom patterns defined by the organization.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-pattern-configuration/custom_pattern_overrides`.
            public var customPatternOverrides: [Components.Schemas.SecretScanningPatternOverride]?
            /// Creates a new `SecretScanningPatternConfiguration`.
            ///
            /// - Parameters:
            ///   - patternConfigVersion:
            ///   - providerPatternOverrides: Overrides for partner patterns.
            ///   - customPatternOverrides: Overrides for custom patterns defined by the organization.
            public init(
                patternConfigVersion: Components.Schemas.SecretScanningRowVersion? = nil,
                providerPatternOverrides: [Components.Schemas.SecretScanningPatternOverride]? = nil,
                customPatternOverrides: [Components.Schemas.SecretScanningPatternOverride]? = nil
            ) {
                self.patternConfigVersion = patternConfigVersion
                self.providerPatternOverrides = providerPatternOverrides
                self.customPatternOverrides = customPatternOverrides
            }
            public enum CodingKeys: String, CodingKey {
                case patternConfigVersion = "pattern_config_version"
                case providerPatternOverrides = "provider_pattern_overrides"
                case customPatternOverrides = "custom_pattern_overrides"
            }
        }
        /// The ID of the push protection bypass placeholder. This value is returned on any push protected routes.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass-placeholder-id`.
        public typealias SecretScanningPushProtectionBypassPlaceholderId = Swift.String
        /// - Remark: Generated from `#/components/schemas/secret-scanning-alert`.
        public struct SecretScanningAlert: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/number`.
            public var number: Components.Schemas.AlertNumber?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/updated_at`.
            public var updatedAt: Components.Schemas.NullableAlertUpdatedAt?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/url`.
            public var url: Components.Schemas.AlertUrl?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl?
            /// The REST API URL of the code locations for this alert.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/locations_url`.
            public var locationsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/state`.
            public var state: Components.Schemas.SecretScanningAlertState?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/resolution`.
            public var resolution: Components.Schemas.SecretScanningAlertResolution?
            /// The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/resolved_at`.
            public var resolvedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/resolved_by`.
            public var resolvedBy: Components.Schemas.NullableSimpleUser?
            /// An optional comment to resolve an alert.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/resolution_comment`.
            public var resolutionComment: Swift.String?
            /// The type of secret that secret scanning detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/secret_type`.
            public var secretType: Swift.String?
            /// User-friendly name for the detected secret, matching the `secret_type`.
            /// For a list of built-in patterns, see "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)."
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/secret_type_display_name`.
            public var secretTypeDisplayName: Swift.String?
            /// The secret that was detected.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/secret`.
            public var secret: Swift.String?
            /// Whether push protection was bypassed for the detected secret.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypassed`.
            public var pushProtectionBypassed: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypassed_by`.
            public var pushProtectionBypassedBy: Components.Schemas.NullableSimpleUser?
            /// The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypassed_at`.
            public var pushProtectionBypassedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypass_request_reviewer`.
            public var pushProtectionBypassRequestReviewer: Components.Schemas.NullableSimpleUser?
            /// An optional comment when reviewing a push protection bypass.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypass_request_reviewer_comment`.
            public var pushProtectionBypassRequestReviewerComment: Swift.String?
            /// An optional comment when requesting a push protection bypass.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypass_request_comment`.
            public var pushProtectionBypassRequestComment: Swift.String?
            /// The URL to a push protection bypass request.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/push_protection_bypass_request_html_url`.
            public var pushProtectionBypassRequestHtmlUrl: Swift.String?
            /// The token status as of the latest validity check.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/validity`.
            @frozen public enum ValidityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case active = "active"
                case inactive = "inactive"
                case unknown = "unknown"
            }
            /// The token status as of the latest validity check.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/validity`.
            public var validity: Components.Schemas.SecretScanningAlert.ValidityPayload?
            /// Whether the detected secret was publicly leaked.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/publicly_leaked`.
            public var publiclyLeaked: Swift.Bool?
            /// Whether the detected secret was found in multiple repositories under the same organization or enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/multi_repo`.
            public var multiRepo: Swift.Bool?
            /// A boolean value representing whether or not alert is base64 encoded
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/is_base64_encoded`.
            public var isBase64Encoded: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/first_location_detected`.
            public var firstLocationDetected: Components.Schemas.NullableSecretScanningFirstDetectedLocation?
            /// A boolean value representing whether or not the token in the alert was detected in more than one location.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-alert/has_more_locations`.
            public var hasMoreLocations: Swift.Bool?
            /// Creates a new `SecretScanningAlert`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - url:
            ///   - htmlUrl:
            ///   - locationsUrl: The REST API URL of the code locations for this alert.
            ///   - state:
            ///   - resolution:
            ///   - resolvedAt: The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - resolvedBy:
            ///   - resolutionComment: An optional comment to resolve an alert.
            ///   - secretType: The type of secret that secret scanning detected.
            ///   - secretTypeDisplayName: User-friendly name for the detected secret, matching the `secret_type`.
            ///   - secret: The secret that was detected.
            ///   - pushProtectionBypassed: Whether push protection was bypassed for the detected secret.
            ///   - pushProtectionBypassedBy:
            ///   - pushProtectionBypassedAt: The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - pushProtectionBypassRequestReviewer:
            ///   - pushProtectionBypassRequestReviewerComment: An optional comment when reviewing a push protection bypass.
            ///   - pushProtectionBypassRequestComment: An optional comment when requesting a push protection bypass.
            ///   - pushProtectionBypassRequestHtmlUrl: The URL to a push protection bypass request.
            ///   - validity: The token status as of the latest validity check.
            ///   - publiclyLeaked: Whether the detected secret was publicly leaked.
            ///   - multiRepo: Whether the detected secret was found in multiple repositories under the same organization or enterprise.
            ///   - isBase64Encoded: A boolean value representing whether or not alert is base64 encoded
            ///   - firstLocationDetected:
            ///   - hasMoreLocations: A boolean value representing whether or not the token in the alert was detected in more than one location.
            public init(
                number: Components.Schemas.AlertNumber? = nil,
                createdAt: Components.Schemas.AlertCreatedAt? = nil,
                updatedAt: Components.Schemas.NullableAlertUpdatedAt? = nil,
                url: Components.Schemas.AlertUrl? = nil,
                htmlUrl: Components.Schemas.AlertHtmlUrl? = nil,
                locationsUrl: Swift.String? = nil,
                state: Components.Schemas.SecretScanningAlertState? = nil,
                resolution: Components.Schemas.SecretScanningAlertResolution? = nil,
                resolvedAt: Foundation.Date? = nil,
                resolvedBy: Components.Schemas.NullableSimpleUser? = nil,
                resolutionComment: Swift.String? = nil,
                secretType: Swift.String? = nil,
                secretTypeDisplayName: Swift.String? = nil,
                secret: Swift.String? = nil,
                pushProtectionBypassed: Swift.Bool? = nil,
                pushProtectionBypassedBy: Components.Schemas.NullableSimpleUser? = nil,
                pushProtectionBypassedAt: Foundation.Date? = nil,
                pushProtectionBypassRequestReviewer: Components.Schemas.NullableSimpleUser? = nil,
                pushProtectionBypassRequestReviewerComment: Swift.String? = nil,
                pushProtectionBypassRequestComment: Swift.String? = nil,
                pushProtectionBypassRequestHtmlUrl: Swift.String? = nil,
                validity: Components.Schemas.SecretScanningAlert.ValidityPayload? = nil,
                publiclyLeaked: Swift.Bool? = nil,
                multiRepo: Swift.Bool? = nil,
                isBase64Encoded: Swift.Bool? = nil,
                firstLocationDetected: Components.Schemas.NullableSecretScanningFirstDetectedLocation? = nil,
                hasMoreLocations: Swift.Bool? = nil
            ) {
                self.number = number
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.url = url
                self.htmlUrl = htmlUrl
                self.locationsUrl = locationsUrl
                self.state = state
                self.resolution = resolution
                self.resolvedAt = resolvedAt
                self.resolvedBy = resolvedBy
                self.resolutionComment = resolutionComment
                self.secretType = secretType
                self.secretTypeDisplayName = secretTypeDisplayName
                self.secret = secret
                self.pushProtectionBypassed = pushProtectionBypassed
                self.pushProtectionBypassedBy = pushProtectionBypassedBy
                self.pushProtectionBypassedAt = pushProtectionBypassedAt
                self.pushProtectionBypassRequestReviewer = pushProtectionBypassRequestReviewer
                self.pushProtectionBypassRequestReviewerComment = pushProtectionBypassRequestReviewerComment
                self.pushProtectionBypassRequestComment = pushProtectionBypassRequestComment
                self.pushProtectionBypassRequestHtmlUrl = pushProtectionBypassRequestHtmlUrl
                self.validity = validity
                self.publiclyLeaked = publiclyLeaked
                self.multiRepo = multiRepo
                self.isBase64Encoded = isBase64Encoded
                self.firstLocationDetected = firstLocationDetected
                self.hasMoreLocations = hasMoreLocations
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case url
                case htmlUrl = "html_url"
                case locationsUrl = "locations_url"
                case state
                case resolution
                case resolvedAt = "resolved_at"
                case resolvedBy = "resolved_by"
                case resolutionComment = "resolution_comment"
                case secretType = "secret_type"
                case secretTypeDisplayName = "secret_type_display_name"
                case secret
                case pushProtectionBypassed = "push_protection_bypassed"
                case pushProtectionBypassedBy = "push_protection_bypassed_by"
                case pushProtectionBypassedAt = "push_protection_bypassed_at"
                case pushProtectionBypassRequestReviewer = "push_protection_bypass_request_reviewer"
                case pushProtectionBypassRequestReviewerComment = "push_protection_bypass_request_reviewer_comment"
                case pushProtectionBypassRequestComment = "push_protection_bypass_request_comment"
                case pushProtectionBypassRequestHtmlUrl = "push_protection_bypass_request_html_url"
                case validity
                case publiclyLeaked = "publicly_leaked"
                case multiRepo = "multi_repo"
                case isBase64Encoded = "is_base64_encoded"
                case firstLocationDetected = "first_location_detected"
                case hasMoreLocations = "has_more_locations"
            }
        }
        /// An optional comment when closing or reopening an alert. Cannot be updated or deleted.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-alert-resolution-comment`.
        public typealias SecretScanningAlertResolutionComment = Swift.String
        /// - Remark: Generated from `#/components/schemas/secret-scanning-location`.
        public struct SecretScanningLocation: Codable, Hashable, Sendable {
            /// The location type. Because secrets may be found in different types of resources (ie. code, comments, issues, pull requests, discussions), this field identifies the type of resource where the secret was found.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case commit = "commit"
                case wikiCommit = "wiki_commit"
                case issueTitle = "issue_title"
                case issueBody = "issue_body"
                case issueComment = "issue_comment"
                case discussionTitle = "discussion_title"
                case discussionBody = "discussion_body"
                case discussionComment = "discussion_comment"
                case pullRequestTitle = "pull_request_title"
                case pullRequestBody = "pull_request_body"
                case pullRequestComment = "pull_request_comment"
                case pullRequestReview = "pull_request_review"
                case pullRequestReviewComment = "pull_request_review_comment"
            }
            /// The location type. Because secrets may be found in different types of resources (ie. code, comments, issues, pull requests, discussions), this field identifies the type of resource where the secret was found.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location/type`.
            public var _type: Components.Schemas.SecretScanningLocation._TypePayload?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details`.
            @frozen public enum DetailsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case1`.
                case SecretScanningLocationCommit(Components.Schemas.SecretScanningLocationCommit)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case2`.
                case SecretScanningLocationWikiCommit(Components.Schemas.SecretScanningLocationWikiCommit)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case3`.
                case SecretScanningLocationIssueTitle(Components.Schemas.SecretScanningLocationIssueTitle)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case4`.
                case SecretScanningLocationIssueBody(Components.Schemas.SecretScanningLocationIssueBody)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case5`.
                case SecretScanningLocationIssueComment(Components.Schemas.SecretScanningLocationIssueComment)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case6`.
                case SecretScanningLocationDiscussionTitle(Components.Schemas.SecretScanningLocationDiscussionTitle)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case7`.
                case SecretScanningLocationDiscussionBody(Components.Schemas.SecretScanningLocationDiscussionBody)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case8`.
                case SecretScanningLocationDiscussionComment(Components.Schemas.SecretScanningLocationDiscussionComment)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case9`.
                case SecretScanningLocationPullRequestTitle(Components.Schemas.SecretScanningLocationPullRequestTitle)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case10`.
                case SecretScanningLocationPullRequestBody(Components.Schemas.SecretScanningLocationPullRequestBody)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case11`.
                case SecretScanningLocationPullRequestComment(Components.Schemas.SecretScanningLocationPullRequestComment)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case12`.
                case SecretScanningLocationPullRequestReview(Components.Schemas.SecretScanningLocationPullRequestReview)
                /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details/case13`.
                case SecretScanningLocationPullRequestReviewComment(Components.Schemas.SecretScanningLocationPullRequestReviewComment)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SecretScanningLocationCommit(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationWikiCommit(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationIssueTitle(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationIssueBody(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationIssueComment(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationDiscussionTitle(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationDiscussionBody(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationDiscussionComment(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationPullRequestTitle(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationPullRequestBody(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationPullRequestComment(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationPullRequestReview(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .SecretScanningLocationPullRequestReviewComment(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SecretScanningLocationCommit(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationWikiCommit(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationIssueTitle(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationIssueBody(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationIssueComment(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationDiscussionTitle(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationDiscussionBody(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationDiscussionComment(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationPullRequestTitle(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationPullRequestBody(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationPullRequestComment(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationPullRequestReview(value):
                        try value.encode(to: encoder)
                    case let .SecretScanningLocationPullRequestReviewComment(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/secret-scanning-location/details`.
            public var details: Components.Schemas.SecretScanningLocation.DetailsPayload?
            /// Creates a new `SecretScanningLocation`.
            ///
            /// - Parameters:
            ///   - _type: The location type. Because secrets may be found in different types of resources (ie. code, comments, issues, pull requests, discussions), this field identifies the type of resource where the secret was found.
            ///   - details:
            public init(
                _type: Components.Schemas.SecretScanningLocation._TypePayload? = nil,
                details: Components.Schemas.SecretScanningLocation.DetailsPayload? = nil
            ) {
                self._type = _type
                self.details = details
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case details
            }
        }
        /// The reason for bypassing push protection.
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass-reason`.
        @frozen public enum SecretScanningPushProtectionBypassReason: String, Codable, Hashable, Sendable, CaseIterable {
            case falsePositive = "false_positive"
            case usedInTests = "used_in_tests"
            case willFixLater = "will_fix_later"
        }
        /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass`.
        public struct SecretScanningPushProtectionBypass: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass/reason`.
            public var reason: Components.Schemas.SecretScanningPushProtectionBypassReason?
            /// The time that the bypass will expire in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass/expire_at`.
            public var expireAt: Foundation.Date?
            /// The token type this bypass is for.
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-push-protection-bypass/token_type`.
            public var tokenType: Swift.String?
            /// Creates a new `SecretScanningPushProtectionBypass`.
            ///
            /// - Parameters:
            ///   - reason:
            ///   - expireAt: The time that the bypass will expire in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - tokenType: The token type this bypass is for.
            public init(
                reason: Components.Schemas.SecretScanningPushProtectionBypassReason? = nil,
                expireAt: Foundation.Date? = nil,
                tokenType: Swift.String? = nil
            ) {
                self.reason = reason
                self.expireAt = expireAt
                self.tokenType = tokenType
            }
            public enum CodingKeys: String, CodingKey {
                case reason
                case expireAt = "expire_at"
                case tokenType = "token_type"
            }
        }
        /// Information on a single scan performed by secret scanning on the repository
        ///
        /// - Remark: Generated from `#/components/schemas/secret-scanning-scan`.
        public struct SecretScanningScan: Codable, Hashable, Sendable {
            /// The type of scan
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan/type`.
            public var _type: Swift.String?
            /// The state of the scan. Either "completed", "running", or "pending"
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan/status`.
            public var status: Swift.String?
            /// The time that the scan was completed. Empty if the scan is running
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan/completed_at`.
            public var completedAt: Foundation.Date?
            /// The time that the scan was started. Empty if the scan is pending
            ///
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan/started_at`.
            public var startedAt: Foundation.Date?
            /// Creates a new `SecretScanningScan`.
            ///
            /// - Parameters:
            ///   - _type: The type of scan
            ///   - status: The state of the scan. Either "completed", "running", or "pending"
            ///   - completedAt: The time that the scan was completed. Empty if the scan is running
            ///   - startedAt: The time that the scan was started. Empty if the scan is pending
            public init(
                _type: Swift.String? = nil,
                status: Swift.String? = nil,
                completedAt: Foundation.Date? = nil,
                startedAt: Foundation.Date? = nil
            ) {
                self._type = _type
                self.status = status
                self.completedAt = completedAt
                self.startedAt = startedAt
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case status
                case completedAt = "completed_at"
                case startedAt = "started_at"
            }
        }
        /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history`.
        public struct SecretScanningScanHistory: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/incremental_scans`.
            public var incrementalScans: [Components.Schemas.SecretScanningScan]?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/pattern_update_scans`.
            public var patternUpdateScans: [Components.Schemas.SecretScanningScan]?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/backfill_scans`.
            public var backfillScans: [Components.Schemas.SecretScanningScan]?
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload`.
            public struct CustomPatternBackfillScansPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload/value1`.
                public var value1: Components.Schemas.SecretScanningScan
                /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload/value2`.
                public struct Value2Payload: Codable, Hashable, Sendable {
                    /// Name of the custom pattern for custom pattern scans
                    ///
                    /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload/value2/pattern_name`.
                    public var patternName: Swift.String?
                    /// Level at which the custom pattern is defined, one of "repository", "organization", or "enterprise"
                    ///
                    /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload/value2/pattern_scope`.
                    public var patternScope: Swift.String?
                    /// Creates a new `Value2Payload`.
                    ///
                    /// - Parameters:
                    ///   - patternName: Name of the custom pattern for custom pattern scans
                    ///   - patternScope: Level at which the custom pattern is defined, one of "repository", "organization", or "enterprise"
                    public init(
                        patternName: Swift.String? = nil,
                        patternScope: Swift.String? = nil
                    ) {
                        self.patternName = patternName
                        self.patternScope = patternScope
                    }
                    public enum CodingKeys: String, CodingKey {
                        case patternName = "pattern_name"
                        case patternScope = "pattern_scope"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/CustomPatternBackfillScansPayload/value2`.
                public var value2: Components.Schemas.SecretScanningScanHistory.CustomPatternBackfillScansPayloadPayload.Value2Payload
                /// Creates a new `CustomPatternBackfillScansPayloadPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.SecretScanningScan,
                    value2: Components.Schemas.SecretScanningScanHistory.CustomPatternBackfillScansPayloadPayload.Value2Payload
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                    self.value2 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                    try self.value2.encode(to: encoder)
                }
            }
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/custom_pattern_backfill_scans`.
            public typealias CustomPatternBackfillScansPayload = [Components.Schemas.SecretScanningScanHistory.CustomPatternBackfillScansPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/secret-scanning-scan-history/custom_pattern_backfill_scans`.
            public var customPatternBackfillScans: Components.Schemas.SecretScanningScanHistory.CustomPatternBackfillScansPayload?
            /// Creates a new `SecretScanningScanHistory`.
            ///
            /// - Parameters:
            ///   - incrementalScans:
            ///   - patternUpdateScans:
            ///   - backfillScans:
            ///   - customPatternBackfillScans:
            public init(
                incrementalScans: [Components.Schemas.SecretScanningScan]? = nil,
                patternUpdateScans: [Components.Schemas.SecretScanningScan]? = nil,
                backfillScans: [Components.Schemas.SecretScanningScan]? = nil,
                customPatternBackfillScans: Components.Schemas.SecretScanningScanHistory.CustomPatternBackfillScansPayload? = nil
            ) {
                self.incrementalScans = incrementalScans
                self.patternUpdateScans = patternUpdateScans
                self.backfillScans = backfillScans
                self.customPatternBackfillScans = customPatternBackfillScans
            }
            public enum CodingKeys: String, CodingKey {
                case incrementalScans = "incremental_scans"
                case patternUpdateScans = "pattern_update_scans"
                case backfillScans = "backfill_scans"
                case customPatternBackfillScans = "custom_pattern_backfill_scans"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The slug version of the enterprise name.
        ///
        /// - Remark: Generated from `#/components/parameters/enterprise`.
        public typealias Enterprise = Swift.String
        /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-state`.
        @frozen public enum SecretScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
            case open = "open"
            case resolved = "resolved"
        }
        /// A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-secret-type`.
        public typealias SecretScanningAlertSecretType = Swift.String
        /// A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-resolution`.
        public typealias SecretScanningAlertResolution = Swift.String
        /// The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-sort`.
        @frozen public enum SecretScanningAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
        }
        /// A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-validity`.
        public typealias SecretScanningAlertValidity = Swift.String
        /// A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-publicly-leaked`.
        public typealias SecretScanningAlertPubliclyLeaked = Swift.Bool
        /// A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-multi-repo`.
        public typealias SecretScanningAlertMultiRepo = Swift.Bool
        /// A boolean value representing whether or not to hide literal secrets in the results.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-hide-secret`.
        public typealias SecretScanningAlertHideSecret = Swift.Bool
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-pagination-before-org-repo`.
        public typealias SecretScanningPaginationBeforeOrgRepo = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-scanning-pagination-after-org-repo`.
        public typealias SecretScanningPaginationAfterOrgRepo = Swift.String
        /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
        ///
        /// - Remark: Generated from `#/components/parameters/alert-number`.
        public typealias AlertNumber = Components.Schemas.AlertNumber
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List secret scanning alerts for an enterprise
    ///
    /// Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
    ///
    /// Alerts are only returned for organizations in the enterprise for which the authenticated user is an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
    ///
    /// The authenticated user must be a member of the enterprise in order to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)`.
    public enum SecretScanningListAlertsForEnterprise {
        public static let id: Swift.String = "secret-scanning/list-alerts-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                public init(enterprise: Components.Parameters.Enterprise) {
                    self.enterprise = enterprise
                }
            }
            public var path: Operations.SecretScanningListAlertsForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-state`.
                @frozen public enum SecretScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case resolved = "resolved"
                }
                /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/state`.
                public var state: Components.Parameters.SecretScanningAlertState?
                /// A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/secret_type`.
                public var secretType: Components.Parameters.SecretScanningAlertSecretType?
                /// A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/resolution`.
                public var resolution: Components.Parameters.SecretScanningAlertResolution?
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-sort`.
                @frozen public enum SecretScanningAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/sort`.
                public var sort: Components.Parameters.SecretScanningAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/validity`.
                public var validity: Components.Parameters.SecretScanningAlertValidity?
                /// A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/is_publicly_leaked`.
                public var isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked?
                /// A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/is_multi_repo`.
                public var isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo?
                /// A boolean value representing whether or not to hide literal secrets in the results.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/query/hide_secret`.
                public var hideSecret: Components.Parameters.SecretScanningAlertHideSecret?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///   - secretType: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///   - resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///   - sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///   - direction: The direction to sort the results by.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///   - isPubliclyLeaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///   - isMultiRepo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///   - hideSecret: A boolean value representing whether or not to hide literal secrets in the results.
                public init(
                    state: Components.Parameters.SecretScanningAlertState? = nil,
                    secretType: Components.Parameters.SecretScanningAlertSecretType? = nil,
                    resolution: Components.Parameters.SecretScanningAlertResolution? = nil,
                    sort: Components.Parameters.SecretScanningAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    validity: Components.Parameters.SecretScanningAlertValidity? = nil,
                    isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked? = nil,
                    isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo? = nil,
                    hideSecret: Components.Parameters.SecretScanningAlertHideSecret? = nil
                ) {
                    self.state = state
                    self.secretType = secretType
                    self.resolution = resolution
                    self.sort = sort
                    self.direction = direction
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.validity = validity
                    self.isPubliclyLeaked = isPubliclyLeaked
                    self.isMultiRepo = isMultiRepo
                    self.hideSecret = hideSecret
                }
            }
            public var query: Operations.SecretScanningListAlertsForEnterprise.Input.Query
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningListAlertsForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecretScanningListAlertsForEnterprise.Input.Path,
                query: Operations.SecretScanningListAlertsForEnterprise.Input.Query = .init(),
                headers: Operations.SecretScanningListAlertsForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.SecretScanningListAlertsForEnterprise.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/secret-scanning/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationSecretScanningAlert])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationSecretScanningAlert] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningListAlertsForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.SecretScanningListAlertsForEnterprise.Output.Ok.Headers = .init(),
                    body: Operations.SecretScanningListAlertsForEnterprise.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningListAlertsForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningListAlertsForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-enterprise)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List secret scanning alerts for an organization
    ///
    /// Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
    ///
    /// The authenticated user must be an administrator or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)`.
    public enum SecretScanningListAlertsForOrg {
        public static let id: Swift.String = "secret-scanning/list-alerts-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.SecretScanningListAlertsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-state`.
                @frozen public enum SecretScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case resolved = "resolved"
                }
                /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/state`.
                public var state: Components.Parameters.SecretScanningAlertState?
                /// A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/secret_type`.
                public var secretType: Components.Parameters.SecretScanningAlertSecretType?
                /// A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/resolution`.
                public var resolution: Components.Parameters.SecretScanningAlertResolution?
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-sort`.
                @frozen public enum SecretScanningAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/sort`.
                public var sort: Components.Parameters.SecretScanningAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/before`.
                public var before: Components.Parameters.SecretScanningPaginationBeforeOrgRepo?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/after`.
                public var after: Components.Parameters.SecretScanningPaginationAfterOrgRepo?
                /// A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/validity`.
                public var validity: Components.Parameters.SecretScanningAlertValidity?
                /// A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/is_publicly_leaked`.
                public var isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked?
                /// A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/is_multi_repo`.
                public var isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo?
                /// A boolean value representing whether or not to hide literal secrets in the results.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/query/hide_secret`.
                public var hideSecret: Components.Parameters.SecretScanningAlertHideSecret?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///   - secretType: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///   - resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///   - sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///   - direction: The direction to sort the results by.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string.
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string.
                ///   - validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///   - isPubliclyLeaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///   - isMultiRepo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///   - hideSecret: A boolean value representing whether or not to hide literal secrets in the results.
                public init(
                    state: Components.Parameters.SecretScanningAlertState? = nil,
                    secretType: Components.Parameters.SecretScanningAlertSecretType? = nil,
                    resolution: Components.Parameters.SecretScanningAlertResolution? = nil,
                    sort: Components.Parameters.SecretScanningAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.SecretScanningPaginationBeforeOrgRepo? = nil,
                    after: Components.Parameters.SecretScanningPaginationAfterOrgRepo? = nil,
                    validity: Components.Parameters.SecretScanningAlertValidity? = nil,
                    isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked? = nil,
                    isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo? = nil,
                    hideSecret: Components.Parameters.SecretScanningAlertHideSecret? = nil
                ) {
                    self.state = state
                    self.secretType = secretType
                    self.resolution = resolution
                    self.sort = sort
                    self.direction = direction
                    self.page = page
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.validity = validity
                    self.isPubliclyLeaked = isPubliclyLeaked
                    self.isMultiRepo = isMultiRepo
                    self.hideSecret = hideSecret
                }
            }
            public var query: Operations.SecretScanningListAlertsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningListAlertsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecretScanningListAlertsForOrg.Input.Path,
                query: Operations.SecretScanningListAlertsForOrg.Input.Query = .init(),
                headers: Operations.SecretScanningListAlertsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.SecretScanningListAlertsForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.OrganizationSecretScanningAlert])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.OrganizationSecretScanningAlert] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningListAlertsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.SecretScanningListAlertsForOrg.Output.Ok.Headers = .init(),
                    body: Operations.SecretScanningListAlertsForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningListAlertsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningListAlertsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-org)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization pattern configurations
    ///
    /// Lists the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `read:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)`.
    public enum SecretScanningListOrgPatternConfigs {
        public static let id: Swift.String = "secret-scanning/list-org-pattern-configs"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.SecretScanningListOrgPatternConfigs.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListOrgPatternConfigs.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListOrgPatternConfigs.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningListOrgPatternConfigs.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecretScanningListOrgPatternConfigs.Input.Path,
                headers: Operations.SecretScanningListOrgPatternConfigs.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SecretScanningPatternConfiguration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SecretScanningPatternConfiguration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningListOrgPatternConfigs.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningListOrgPatternConfigs.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningListOrgPatternConfigs.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningListOrgPatternConfigs.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/get(secret-scanning/list-org-pattern-configs)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update organization pattern configurations
    ///
    /// Updates the secret scanning pattern configurations for an organization.
    ///
    /// Personal access tokens (classic) need the `write:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /orgs/{org}/secret-scanning/pattern-configurations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)`.
    public enum SecretScanningUpdateOrgPatternConfigs {
        public static let id: Swift.String = "secret-scanning/update-org-pattern-configs"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningUpdateOrgPatternConfigs.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningUpdateOrgPatternConfigs.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/pattern_config_version`.
                    public var patternConfigVersion: Components.Schemas.SecretScanningRowVersion?
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/ProviderPatternSettingsPayload`.
                    public struct ProviderPatternSettingsPayloadPayload: Codable, Hashable, Sendable {
                        /// The ID of the pattern to configure.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/ProviderPatternSettingsPayload/token_type`.
                        public var tokenType: Swift.String?
                        /// Push protection setting to set for the pattern.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/ProviderPatternSettingsPayload/push_protection_setting`.
                        @frozen public enum PushProtectionSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case notSet = "not-set"
                            case disabled = "disabled"
                            case enabled = "enabled"
                        }
                        /// Push protection setting to set for the pattern.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/ProviderPatternSettingsPayload/push_protection_setting`.
                        public var pushProtectionSetting: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.ProviderPatternSettingsPayloadPayload.PushProtectionSettingPayload?
                        /// Creates a new `ProviderPatternSettingsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - tokenType: The ID of the pattern to configure.
                        ///   - pushProtectionSetting: Push protection setting to set for the pattern.
                        public init(
                            tokenType: Swift.String? = nil,
                            pushProtectionSetting: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.ProviderPatternSettingsPayloadPayload.PushProtectionSettingPayload? = nil
                        ) {
                            self.tokenType = tokenType
                            self.pushProtectionSetting = pushProtectionSetting
                        }
                        public enum CodingKeys: String, CodingKey {
                            case tokenType = "token_type"
                            case pushProtectionSetting = "push_protection_setting"
                        }
                    }
                    /// Pattern settings for provider patterns.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/provider_pattern_settings`.
                    public typealias ProviderPatternSettingsPayload = [Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.ProviderPatternSettingsPayloadPayload]
                    /// Pattern settings for provider patterns.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/provider_pattern_settings`.
                    public var providerPatternSettings: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.ProviderPatternSettingsPayload?
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/CustomPatternSettingsPayload`.
                    public struct CustomPatternSettingsPayloadPayload: Codable, Hashable, Sendable {
                        /// The ID of the pattern to configure.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/CustomPatternSettingsPayload/token_type`.
                        public var tokenType: Swift.String?
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/CustomPatternSettingsPayload/custom_pattern_version`.
                        public var customPatternVersion: Components.Schemas.SecretScanningRowVersion?
                        /// Push protection setting to set for the pattern.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/CustomPatternSettingsPayload/push_protection_setting`.
                        @frozen public enum PushProtectionSettingPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case disabled = "disabled"
                            case enabled = "enabled"
                        }
                        /// Push protection setting to set for the pattern.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/CustomPatternSettingsPayload/push_protection_setting`.
                        public var pushProtectionSetting: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.CustomPatternSettingsPayloadPayload.PushProtectionSettingPayload?
                        /// Creates a new `CustomPatternSettingsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - tokenType: The ID of the pattern to configure.
                        ///   - customPatternVersion:
                        ///   - pushProtectionSetting: Push protection setting to set for the pattern.
                        public init(
                            tokenType: Swift.String? = nil,
                            customPatternVersion: Components.Schemas.SecretScanningRowVersion? = nil,
                            pushProtectionSetting: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.CustomPatternSettingsPayloadPayload.PushProtectionSettingPayload? = nil
                        ) {
                            self.tokenType = tokenType
                            self.customPatternVersion = customPatternVersion
                            self.pushProtectionSetting = pushProtectionSetting
                        }
                        public enum CodingKeys: String, CodingKey {
                            case tokenType = "token_type"
                            case customPatternVersion = "custom_pattern_version"
                            case pushProtectionSetting = "push_protection_setting"
                        }
                    }
                    /// Pattern settings for custom patterns.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/custom_pattern_settings`.
                    public typealias CustomPatternSettingsPayload = [Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.CustomPatternSettingsPayloadPayload]
                    /// Pattern settings for custom patterns.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/json/custom_pattern_settings`.
                    public var customPatternSettings: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.CustomPatternSettingsPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - patternConfigVersion:
                    ///   - providerPatternSettings: Pattern settings for provider patterns.
                    ///   - customPatternSettings: Pattern settings for custom patterns.
                    public init(
                        patternConfigVersion: Components.Schemas.SecretScanningRowVersion? = nil,
                        providerPatternSettings: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.ProviderPatternSettingsPayload? = nil,
                        customPatternSettings: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload.CustomPatternSettingsPayload? = nil
                    ) {
                        self.patternConfigVersion = patternConfigVersion
                        self.providerPatternSettings = providerPatternSettings
                        self.customPatternSettings = customPatternSettings
                    }
                    public enum CodingKeys: String, CodingKey {
                        case patternConfigVersion = "pattern_config_version"
                        case providerPatternSettings = "provider_pattern_settings"
                        case customPatternSettings = "custom_pattern_settings"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/requestBody/content/application\/json`.
                case json(Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body.JsonPayload)
            }
            public var body: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Path,
                headers: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Headers = .init(),
                body: Operations.SecretScanningUpdateOrgPatternConfigs.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// The updated pattern configuration version.
                        ///
                        /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/responses/200/content/json/pattern_config_version`.
                        public var patternConfigVersion: Swift.String?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - patternConfigVersion: The updated pattern configuration version.
                        public init(patternConfigVersion: Swift.String? = nil) {
                            self.patternConfigVersion = patternConfigVersion
                        }
                        public enum CodingKeys: String, CodingKey {
                            case patternConfigVersion = "pattern_config_version"
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/secret-scanning/pattern-configurations/PATCH/responses/200/content/application\/json`.
                    case json(Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningUpdateOrgPatternConfigs.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/secret-scanning/pattern-configurations/patch(secret-scanning/update-org-pattern-configs)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List secret scanning alerts for a repository
    ///
    /// Lists secret scanning alerts for an eligible repository, from newest to oldest.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)`.
    public enum SecretScanningListAlertsForRepo {
        public static let id: Swift.String = "secret-scanning/list-alerts-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecretScanningListAlertsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-state`.
                @frozen public enum SecretScanningAlertState: String, Codable, Hashable, Sendable, CaseIterable {
                    case open = "open"
                    case resolved = "resolved"
                }
                /// Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/state`.
                public var state: Components.Parameters.SecretScanningAlertState?
                /// A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/secret_type`.
                public var secretType: Components.Parameters.SecretScanningAlertSecretType?
                /// A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/resolution`.
                public var resolution: Components.Parameters.SecretScanningAlertResolution?
                /// - Remark: Generated from `#/components/parameters/secret-scanning-alert-sort`.
                @frozen public enum SecretScanningAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                }
                /// The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/sort`.
                public var sort: Components.Parameters.SecretScanningAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/before`.
                public var before: Components.Parameters.SecretScanningPaginationBeforeOrgRepo?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/after`.
                public var after: Components.Parameters.SecretScanningPaginationAfterOrgRepo?
                /// A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/validity`.
                public var validity: Components.Parameters.SecretScanningAlertValidity?
                /// A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/is_publicly_leaked`.
                public var isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked?
                /// A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/is_multi_repo`.
                public var isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo?
                /// A boolean value representing whether or not to hide literal secrets in the results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/query/hide_secret`.
                public var hideSecret: Components.Parameters.SecretScanningAlertHideSecret?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
                ///   - secretType: A comma-separated list of secret types to return. All default secret patterns are returned. To return generic patterns, pass the token name(s) in the parameter. See "[Supported secret scanning patterns](https://docs.github.com/code-security/secret-scanning/introduction/supported-secret-scanning-patterns#supported-secrets)" for a complete list of secret types.
                ///   - resolution: A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`.
                ///   - sort: The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved.
                ///   - direction: The direction to sort the results by.
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string.
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string.
                ///   - validity: A comma-separated list of validities that, when present, will return alerts that match the validities in this list. Valid options are `active`, `inactive`, and `unknown`.
                ///   - isPubliclyLeaked: A boolean value representing whether or not to filter alerts by the publicly-leaked tag being present.
                ///   - isMultiRepo: A boolean value representing whether or not to filter alerts by the multi-repo tag being present.
                ///   - hideSecret: A boolean value representing whether or not to hide literal secrets in the results.
                public init(
                    state: Components.Parameters.SecretScanningAlertState? = nil,
                    secretType: Components.Parameters.SecretScanningAlertSecretType? = nil,
                    resolution: Components.Parameters.SecretScanningAlertResolution? = nil,
                    sort: Components.Parameters.SecretScanningAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    before: Components.Parameters.SecretScanningPaginationBeforeOrgRepo? = nil,
                    after: Components.Parameters.SecretScanningPaginationAfterOrgRepo? = nil,
                    validity: Components.Parameters.SecretScanningAlertValidity? = nil,
                    isPubliclyLeaked: Components.Parameters.SecretScanningAlertPubliclyLeaked? = nil,
                    isMultiRepo: Components.Parameters.SecretScanningAlertMultiRepo? = nil,
                    hideSecret: Components.Parameters.SecretScanningAlertHideSecret? = nil
                ) {
                    self.state = state
                    self.secretType = secretType
                    self.resolution = resolution
                    self.sort = sort
                    self.direction = direction
                    self.page = page
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.validity = validity
                    self.isPubliclyLeaked = isPubliclyLeaked
                    self.isMultiRepo = isMultiRepo
                    self.hideSecret = hideSecret
                }
            }
            public var query: Operations.SecretScanningListAlertsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListAlertsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningListAlertsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecretScanningListAlertsForRepo.Input.Path,
                query: Operations.SecretScanningListAlertsForRepo.Input.Query = .init(),
                headers: Operations.SecretScanningListAlertsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SecretScanningAlert])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SecretScanningAlert] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningListAlertsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningListAlertsForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningListAlertsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningListAlertsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Repository is public or secret scanning is disabled for the repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningListAlertsForRepo.Output.NotFound)
            /// Repository is public or secret scanning is disabled for the repository
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningListAlertsForRepo.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/get(secret-scanning/list-alerts-for-repo)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a secret scanning alert
    ///
    /// Gets a single secret scanning alert detected in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)`.
    public enum SecretScanningGetAlert {
        public static let id: Swift.String = "secret-scanning/get-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.SecretScanningGetAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A boolean value representing whether or not to hide literal secrets in the results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/query/hide_secret`.
                public var hideSecret: Components.Parameters.SecretScanningAlertHideSecret?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - hideSecret: A boolean value representing whether or not to hide literal secrets in the results.
                public init(hideSecret: Components.Parameters.SecretScanningAlertHideSecret? = nil) {
                    self.hideSecret = hideSecret
                }
            }
            public var query: Operations.SecretScanningGetAlert.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningGetAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningGetAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningGetAlert.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecretScanningGetAlert.Input.Path,
                query: Operations.SecretScanningGetAlert.Input.Query = .init(),
                headers: Operations.SecretScanningGetAlert.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SecretScanningAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SecretScanningAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningGetAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningGetAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningGetAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningGetAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningGetAlert.Output.NotFound)
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningGetAlert.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/get(secret-scanning/get-alert)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a secret scanning alert
    ///
    /// Updates the status of a secret scanning alert in an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)`.
    public enum SecretScanningUpdateAlert {
        public static let id: Swift.String = "secret-scanning/update-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.SecretScanningUpdateAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningUpdateAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningUpdateAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningUpdateAlert.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody/json/state`.
                    public var state: Components.Schemas.SecretScanningAlertState
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody/json/resolution`.
                    public var resolution: Components.Schemas.SecretScanningAlertResolution?
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody/json/resolution_comment`.
                    public var resolutionComment: Components.Schemas.SecretScanningAlertResolutionComment?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - state:
                    ///   - resolution:
                    ///   - resolutionComment:
                    public init(
                        state: Components.Schemas.SecretScanningAlertState,
                        resolution: Components.Schemas.SecretScanningAlertResolution? = nil,
                        resolutionComment: Components.Schemas.SecretScanningAlertResolutionComment? = nil
                    ) {
                        self.state = state
                        self.resolution = resolution
                        self.resolutionComment = resolutionComment
                    }
                    public enum CodingKeys: String, CodingKey {
                        case state
                        case resolution
                        case resolutionComment = "resolution_comment"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.SecretScanningUpdateAlert.Input.Body.JsonPayload)
            }
            public var body: Operations.SecretScanningUpdateAlert.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecretScanningUpdateAlert.Input.Path,
                headers: Operations.SecretScanningUpdateAlert.Input.Headers = .init(),
                body: Operations.SecretScanningUpdateAlert.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.SecretScanningAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SecretScanningAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningUpdateAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningUpdateAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningUpdateAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningUpdateAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// Creates a new `BadRequest`.
                public init() {}
            }
            /// Bad request, resolution comment is invalid or the resolution was not changed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.SecretScanningUpdateAlert.Output.BadRequest)
            /// Bad request, resolution comment is invalid or the resolution was not changed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.SecretScanningUpdateAlert.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningUpdateAlert.Output.NotFound)
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningUpdateAlert.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// State does not match the resolution or resolution comment
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.SecretScanningUpdateAlert.Output.UnprocessableContent)
            /// State does not match the resolution or resolution comment
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.SecretScanningUpdateAlert.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/patch(secret-scanning/update-alert)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List locations for a secret scanning alert
    ///
    /// Lists all locations for a given secret scanning alert for an eligible repository.
    ///
    /// The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)`.
    public enum SecretScanningListLocationsForAlert {
        public static let id: Swift.String = "secret-scanning/list-locations-for-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.AlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.AlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.SecretScanningListLocationsForAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.SecretScanningListLocationsForAlert.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListLocationsForAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningListLocationsForAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningListLocationsForAlert.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.SecretScanningListLocationsForAlert.Input.Path,
                query: Operations.SecretScanningListLocationsForAlert.Input.Query = .init(),
                headers: Operations.SecretScanningListLocationsForAlert.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.SecretScanningListLocationsForAlert.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.SecretScanningLocation])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.SecretScanningLocation] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningListLocationsForAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.SecretScanningListLocationsForAlert.Output.Ok.Headers = .init(),
                    body: Operations.SecretScanningListLocationsForAlert.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningListLocationsForAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningListLocationsForAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningListLocationsForAlert.Output.NotFound)
            /// Repository is public, or secret scanning is disabled for the repository, or the resource is not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningListLocationsForAlert.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations/get(secret-scanning/list-locations-for-alert)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a push protection bypass
    ///
    /// Creates a bypass for a previously push protected secret.
    ///
    /// The authenticated user must be the original author of the committed secret.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)`.
    public enum SecretScanningCreatePushProtectionBypass {
        public static let id: Swift.String = "secret-scanning/create-push-protection-bypass"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecretScanningCreatePushProtectionBypass.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningCreatePushProtectionBypass.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningCreatePushProtectionBypass.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningCreatePushProtectionBypass.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/requestBody/json/reason`.
                    public var reason: Components.Schemas.SecretScanningPushProtectionBypassReason
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/requestBody/json/placeholder_id`.
                    public var placeholderId: Components.Schemas.SecretScanningPushProtectionBypassPlaceholderId
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - reason:
                    ///   - placeholderId:
                    public init(
                        reason: Components.Schemas.SecretScanningPushProtectionBypassReason,
                        placeholderId: Components.Schemas.SecretScanningPushProtectionBypassPlaceholderId
                    ) {
                        self.reason = reason
                        self.placeholderId = placeholderId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case reason
                        case placeholderId = "placeholder_id"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/requestBody/content/application\/json`.
                case json(Operations.SecretScanningCreatePushProtectionBypass.Input.Body.JsonPayload)
            }
            public var body: Operations.SecretScanningCreatePushProtectionBypass.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.SecretScanningCreatePushProtectionBypass.Input.Path,
                headers: Operations.SecretScanningCreatePushProtectionBypass.Input.Headers = .init(),
                body: Operations.SecretScanningCreatePushProtectionBypass.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.SecretScanningPushProtectionBypass)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SecretScanningPushProtectionBypass {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningCreatePushProtectionBypass.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningCreatePushProtectionBypass.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningCreatePushProtectionBypass.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningCreatePushProtectionBypass.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Forbidden: Sendable, Hashable {
                /// Creates a new `Forbidden`.
                public init() {}
            }
            /// User does not have enough permissions to perform this action.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Operations.SecretScanningCreatePushProtectionBypass.Output.Forbidden)
            /// User does not have enough permissions to perform this action.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            public static var forbidden: Self {
                .forbidden(.init())
            }
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Operations.SecretScanningCreatePushProtectionBypass.Output.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Placeholder ID not found, or push protection is disabled on this repository.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningCreatePushProtectionBypass.Output.NotFound)
            /// Placeholder ID not found, or push protection is disabled on this repository.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningCreatePushProtectionBypass.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct UnprocessableContent: Sendable, Hashable {
                /// Creates a new `UnprocessableContent`.
                public init() {}
            }
            /// Bad request, input data missing or incorrect.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Operations.SecretScanningCreatePushProtectionBypass.Output.UnprocessableContent)
            /// Bad request, input data missing or incorrect.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            public static var unprocessableContent: Self {
                .unprocessableContent(.init())
            }
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Operations.SecretScanningCreatePushProtectionBypass.Output.UnprocessableContent {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/push-protection-bypasses/post(secret-scanning/create-push-protection-bypass)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get secret scanning scan history for a repository
    ///
    /// Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/secret-scanning/scan-history`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)`.
    public enum SecretScanningGetScanHistory {
        public static let id: Swift.String = "secret-scanning/get-scan-history"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.SecretScanningGetScanHistory.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningGetScanHistory.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.SecretScanningGetScanHistory.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.SecretScanningGetScanHistory.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.SecretScanningGetScanHistory.Input.Path,
                headers: Operations.SecretScanningGetScanHistory.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NotFound: Sendable, Hashable {
                /// Creates a new `NotFound`.
                public init() {}
            }
            /// Repository does not have GitHub Advanced Security or secret scanning enabled
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Operations.SecretScanningGetScanHistory.Output.NotFound)
            /// Repository does not have GitHub Advanced Security or secret scanning enabled
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            public static var notFound: Self {
                .notFound(.init())
            }
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Operations.SecretScanningGetScanHistory.Output.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/secret-scanning/scan-history/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.SecretScanningScanHistory)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.SecretScanningScanHistory {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.SecretScanningGetScanHistory.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.SecretScanningGetScanHistory.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/secret-scanning/scan-history/get(secret-scanning/get-scan-history)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.SecretScanningGetScanHistory.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.SecretScanningGetScanHistory.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
