// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List organization repositories
    ///
    /// Lists repositories for the specified organization.
    ///
    /// > [!NOTE]
    /// > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/repos/get(repos/list-for-org)`.
    func reposListForOrg(_ input: Operations.ReposListForOrg.Input) async throws -> Operations.ReposListForOrg.Output
    /// Create an organization repository
    ///
    /// Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/repos/post(repos/create-in-org)`.
    func reposCreateInOrg(_ input: Operations.ReposCreateInOrg.Input) async throws -> Operations.ReposCreateInOrg.Output
    /// Get all organization repository rulesets
    ///
    /// Get all the repository rulesets for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/get(repos/get-org-rulesets)`.
    func reposGetOrgRulesets(_ input: Operations.ReposGetOrgRulesets.Input) async throws -> Operations.ReposGetOrgRulesets.Output
    /// Create an organization repository ruleset
    ///
    /// Create a repository ruleset for an organization.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/rulesets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/post(repos/create-org-ruleset)`.
    func reposCreateOrgRuleset(_ input: Operations.ReposCreateOrgRuleset.Input) async throws -> Operations.ReposCreateOrgRuleset.Output
    /// List organization rule suites
    ///
    /// Lists suites of rule evaluations at the organization level.
    /// For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/rule-suites`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/rule-suites/get(repos/get-org-rule-suites)`.
    func reposGetOrgRuleSuites(_ input: Operations.ReposGetOrgRuleSuites.Input) async throws -> Operations.ReposGetOrgRuleSuites.Output
    /// Get an organization rule suite
    ///
    /// Gets information about a suite of rule evaluations from within an organization.
    /// For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/rule-suites/{rule_suite_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/rule-suites/{rule_suite_id}/get(repos/get-org-rule-suite)`.
    func reposGetOrgRuleSuite(_ input: Operations.ReposGetOrgRuleSuite.Input) async throws -> Operations.ReposGetOrgRuleSuite.Output
    /// Get an organization repository ruleset
    ///
    /// Get a repository ruleset for an organization.
    ///
    /// **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
    /// making the API request has write access to the ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/get(repos/get-org-ruleset)`.
    func reposGetOrgRuleset(_ input: Operations.ReposGetOrgRuleset.Input) async throws -> Operations.ReposGetOrgRuleset.Output
    /// Update an organization repository ruleset
    ///
    /// Update a ruleset for an organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/put(repos/update-org-ruleset)`.
    func reposUpdateOrgRuleset(_ input: Operations.ReposUpdateOrgRuleset.Input) async throws -> Operations.ReposUpdateOrgRuleset.Output
    /// Delete an organization repository ruleset
    ///
    /// Delete a ruleset for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/delete(repos/delete-org-ruleset)`.
    func reposDeleteOrgRuleset(_ input: Operations.ReposDeleteOrgRuleset.Input) async throws -> Operations.ReposDeleteOrgRuleset.Output
    /// Get a repository
    ///
    /// The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
    ///
    /// > [!NOTE]
    /// > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/get(repos/get)`.
    func reposGet(_ input: Operations.ReposGet.Input) async throws -> Operations.ReposGet.Output
    /// Update a repository
    ///
    /// **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/repos/repos#replace-all-repository-topics) endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/patch(repos/update)`.
    func reposUpdate(_ input: Operations.ReposUpdate.Input) async throws -> Operations.ReposUpdate.Output
    /// Delete a repository
    ///
    /// Deleting a repository requires admin access.
    ///
    /// If an organization owner has configured the organization to prevent members from deleting organization-owned
    /// repositories, you will get a `403 Forbidden` response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `delete_repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/delete(repos/delete)`.
    func reposDelete(_ input: Operations.ReposDelete.Input) async throws -> Operations.ReposDelete.Output
    /// List repository activities
    ///
    /// Lists a detailed history of changes to a repository, such as pushes, merges, force pushes, and branch changes, and associates these changes with commits and users.
    ///
    /// For more information about viewing repository activity,
    /// see "[Viewing activity and data for your repository](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/activity`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/activity/get(repos/list-activities)`.
    func reposListActivities(_ input: Operations.ReposListActivities.Input) async throws -> Operations.ReposListActivities.Output
    /// Create an attestation
    ///
    /// Store an artifact attestation and associate it with a repository.
    ///
    /// The authenticated user must have write permission to the repository and, if using a fine-grained access token, the `attestations:write` permission is required.
    ///
    /// Artifact attestations are meant to be created using the [attest action](https://github.com/actions/attest). For more information, see our guide on [using artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/attestations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/attestations/post(repos/create-attestation)`.
    func reposCreateAttestation(_ input: Operations.ReposCreateAttestation.Input) async throws -> Operations.ReposCreateAttestation.Output
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with a repository.
    ///
    /// The authenticated user making the request must have read access to the repository. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/attestations/{subject_digest}/get(repos/list-attestations)`.
    func reposListAttestations(_ input: Operations.ReposListAttestations.Input) async throws -> Operations.ReposListAttestations.Output
    /// Get all autolinks of a repository
    ///
    /// Gets all autolinks that are configured for a repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/autolinks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/get(repos/list-autolinks)`.
    func reposListAutolinks(_ input: Operations.ReposListAutolinks.Input) async throws -> Operations.ReposListAutolinks.Output
    /// Create an autolink reference for a repository
    ///
    /// Users with admin access to the repository can create an autolink.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/autolinks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/post(repos/create-autolink)`.
    func reposCreateAutolink(_ input: Operations.ReposCreateAutolink.Input) async throws -> Operations.ReposCreateAutolink.Output
    /// Get an autolink reference of a repository
    ///
    /// This returns a single autolink reference by ID that was configured for the given repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/autolinks/{autolink_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/{autolink_id}/get(repos/get-autolink)`.
    func reposGetAutolink(_ input: Operations.ReposGetAutolink.Input) async throws -> Operations.ReposGetAutolink.Output
    /// Delete an autolink reference from a repository
    ///
    /// This deletes a single autolink reference by ID that was configured for the given repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/autolinks/{autolink_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/{autolink_id}/delete(repos/delete-autolink)`.
    func reposDeleteAutolink(_ input: Operations.ReposDeleteAutolink.Input) async throws -> Operations.ReposDeleteAutolink.Output
    /// Check if Dependabot security updates are enabled for a repository
    ///
    /// Shows whether Dependabot security updates are enabled, disabled or paused for a repository. The authenticated user must have admin read access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/get(repos/check-automated-security-fixes)`.
    func reposCheckAutomatedSecurityFixes(_ input: Operations.ReposCheckAutomatedSecurityFixes.Input) async throws -> Operations.ReposCheckAutomatedSecurityFixes.Output
    /// Enable Dependabot security updates
    ///
    /// Enables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/put(repos/enable-automated-security-fixes)`.
    func reposEnableAutomatedSecurityFixes(_ input: Operations.ReposEnableAutomatedSecurityFixes.Input) async throws -> Operations.ReposEnableAutomatedSecurityFixes.Output
    /// Disable Dependabot security updates
    ///
    /// Disables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/delete(repos/disable-automated-security-fixes)`.
    func reposDisableAutomatedSecurityFixes(_ input: Operations.ReposDisableAutomatedSecurityFixes.Input) async throws -> Operations.ReposDisableAutomatedSecurityFixes.Output
    /// List branches
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/get(repos/list-branches)`.
    func reposListBranches(_ input: Operations.ReposListBranches.Input) async throws -> Operations.ReposListBranches.Output
    /// Get a branch
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/get(repos/get-branch)`.
    func reposGetBranch(_ input: Operations.ReposGetBranch.Input) async throws -> Operations.ReposGetBranch.Output
    /// Get branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/get(repos/get-branch-protection)`.
    func reposGetBranchProtection(_ input: Operations.ReposGetBranchProtection.Input) async throws -> Operations.ReposGetBranchProtection.Output
    /// Update branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Protecting a branch requires admin or owner permissions to the repository.
    ///
    /// > [!NOTE]
    /// > Passing new arrays of `users` and `teams` replaces their previous values.
    ///
    /// > [!NOTE]
    /// > The list of users, apps, and teams in total is limited to 100 items.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/put(repos/update-branch-protection)`.
    func reposUpdateBranchProtection(_ input: Operations.ReposUpdateBranchProtection.Input) async throws -> Operations.ReposUpdateBranchProtection.Output
    /// Delete branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/delete(repos/delete-branch-protection)`.
    func reposDeleteBranchProtection(_ input: Operations.ReposDeleteBranchProtection.Input) async throws -> Operations.ReposDeleteBranchProtection.Output
    /// Get admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/get(repos/get-admin-branch-protection)`.
    func reposGetAdminBranchProtection(_ input: Operations.ReposGetAdminBranchProtection.Input) async throws -> Operations.ReposGetAdminBranchProtection.Output
    /// Set admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/post(repos/set-admin-branch-protection)`.
    func reposSetAdminBranchProtection(_ input: Operations.ReposSetAdminBranchProtection.Input) async throws -> Operations.ReposSetAdminBranchProtection.Output
    /// Delete admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/delete(repos/delete-admin-branch-protection)`.
    func reposDeleteAdminBranchProtection(_ input: Operations.ReposDeleteAdminBranchProtection.Input) async throws -> Operations.ReposDeleteAdminBranchProtection.Output
    /// Get pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/get(repos/get-pull-request-review-protection)`.
    func reposGetPullRequestReviewProtection(_ input: Operations.ReposGetPullRequestReviewProtection.Input) async throws -> Operations.ReposGetPullRequestReviewProtection.Output
    /// Update pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// > [!NOTE]
    /// > Passing new arrays of `users` and `teams` replaces their previous values.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/patch(repos/update-pull-request-review-protection)`.
    func reposUpdatePullRequestReviewProtection(_ input: Operations.ReposUpdatePullRequestReviewProtection.Input) async throws -> Operations.ReposUpdatePullRequestReviewProtection.Output
    /// Delete pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/delete(repos/delete-pull-request-review-protection)`.
    func reposDeletePullRequestReviewProtection(_ input: Operations.ReposDeletePullRequestReviewProtection.Input) async throws -> Operations.ReposDeletePullRequestReviewProtection.Output
    /// Get commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.
    ///
    /// > [!NOTE]
    /// > You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/get(repos/get-commit-signature-protection)`.
    func reposGetCommitSignatureProtection(_ input: Operations.ReposGetCommitSignatureProtection.Input) async throws -> Operations.ReposGetCommitSignatureProtection.Output
    /// Create commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/post(repos/create-commit-signature-protection)`.
    func reposCreateCommitSignatureProtection(_ input: Operations.ReposCreateCommitSignatureProtection.Input) async throws -> Operations.ReposCreateCommitSignatureProtection.Output
    /// Delete commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/delete(repos/delete-commit-signature-protection)`.
    func reposDeleteCommitSignatureProtection(_ input: Operations.ReposDeleteCommitSignatureProtection.Input) async throws -> Operations.ReposDeleteCommitSignatureProtection.Output
    /// Get status checks protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/get(repos/get-status-checks-protection)`.
    func reposGetStatusChecksProtection(_ input: Operations.ReposGetStatusChecksProtection.Input) async throws -> Operations.ReposGetStatusChecksProtection.Output
    /// Update status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/patch(repos/update-status-check-protection)`.
    func reposUpdateStatusCheckProtection(_ input: Operations.ReposUpdateStatusCheckProtection.Input) async throws -> Operations.ReposUpdateStatusCheckProtection.Output
    /// Remove status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/delete(repos/remove-status-check-protection)`.
    func reposRemoveStatusCheckProtection(_ input: Operations.ReposRemoveStatusCheckProtection.Input) async throws -> Operations.ReposRemoveStatusCheckProtection.Output
    /// Get all status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/get(repos/get-all-status-check-contexts)`.
    func reposGetAllStatusCheckContexts(_ input: Operations.ReposGetAllStatusCheckContexts.Input) async throws -> Operations.ReposGetAllStatusCheckContexts.Output
    /// Add status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/post(repos/add-status-check-contexts)`.
    func reposAddStatusCheckContexts(_ input: Operations.ReposAddStatusCheckContexts.Input) async throws -> Operations.ReposAddStatusCheckContexts.Output
    /// Set status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/put(repos/set-status-check-contexts)`.
    func reposSetStatusCheckContexts(_ input: Operations.ReposSetStatusCheckContexts.Input) async throws -> Operations.ReposSetStatusCheckContexts.Output
    /// Remove status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/delete(repos/remove-status-check-contexts)`.
    func reposRemoveStatusCheckContexts(_ input: Operations.ReposRemoveStatusCheckContexts.Input) async throws -> Operations.ReposRemoveStatusCheckContexts.Output
    /// Get access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists who has access to this protected branch.
    ///
    /// > [!NOTE]
    /// > Users, apps, and teams `restrictions` are only available for organization-owned repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/get(repos/get-access-restrictions)`.
    func reposGetAccessRestrictions(_ input: Operations.ReposGetAccessRestrictions.Input) async throws -> Operations.ReposGetAccessRestrictions.Output
    /// Delete access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Disables the ability to restrict who can push to this branch.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/delete(repos/delete-access-restrictions)`.
    func reposDeleteAccessRestrictions(_ input: Operations.ReposDeleteAccessRestrictions.Input) async throws -> Operations.ReposDeleteAccessRestrictions.Output
    /// Get apps with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the GitHub Apps that have push access to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/get(repos/get-apps-with-access-to-protected-branch)`.
    func reposGetAppsWithAccessToProtectedBranch(_ input: Operations.ReposGetAppsWithAccessToProtectedBranch.Input) async throws -> Operations.ReposGetAppsWithAccessToProtectedBranch.Output
    /// Add app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified apps push access for this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/post(repos/add-app-access-restrictions)`.
    func reposAddAppAccessRestrictions(_ input: Operations.ReposAddAppAccessRestrictions.Input) async throws -> Operations.ReposAddAppAccessRestrictions.Output
    /// Set app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/put(repos/set-app-access-restrictions)`.
    func reposSetAppAccessRestrictions(_ input: Operations.ReposSetAppAccessRestrictions.Input) async throws -> Operations.ReposSetAppAccessRestrictions.Output
    /// Remove app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of an app to push to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/delete(repos/remove-app-access-restrictions)`.
    func reposRemoveAppAccessRestrictions(_ input: Operations.ReposRemoveAppAccessRestrictions.Input) async throws -> Operations.ReposRemoveAppAccessRestrictions.Output
    /// Get teams with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the teams who have push access to this branch. The list includes child teams.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/get(repos/get-teams-with-access-to-protected-branch)`.
    func reposGetTeamsWithAccessToProtectedBranch(_ input: Operations.ReposGetTeamsWithAccessToProtectedBranch.Input) async throws -> Operations.ReposGetTeamsWithAccessToProtectedBranch.Output
    /// Add team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified teams push access for this branch. You can also give push access to child teams.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/post(repos/add-team-access-restrictions)`.
    func reposAddTeamAccessRestrictions(_ input: Operations.ReposAddTeamAccessRestrictions.Input) async throws -> Operations.ReposAddTeamAccessRestrictions.Output
    /// Set team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/put(repos/set-team-access-restrictions)`.
    func reposSetTeamAccessRestrictions(_ input: Operations.ReposSetTeamAccessRestrictions.Input) async throws -> Operations.ReposSetTeamAccessRestrictions.Output
    /// Remove team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of a team to push to this branch. You can also remove push access for child teams.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/delete(repos/remove-team-access-restrictions)`.
    func reposRemoveTeamAccessRestrictions(_ input: Operations.ReposRemoveTeamAccessRestrictions.Input) async throws -> Operations.ReposRemoveTeamAccessRestrictions.Output
    /// Get users with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the people who have push access to this branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/get(repos/get-users-with-access-to-protected-branch)`.
    func reposGetUsersWithAccessToProtectedBranch(_ input: Operations.ReposGetUsersWithAccessToProtectedBranch.Input) async throws -> Operations.ReposGetUsersWithAccessToProtectedBranch.Output
    /// Add user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified people push access for this branch.
    ///
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/post(repos/add-user-access-restrictions)`.
    func reposAddUserAccessRestrictions(_ input: Operations.ReposAddUserAccessRestrictions.Input) async throws -> Operations.ReposAddUserAccessRestrictions.Output
    /// Set user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
    ///
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/put(repos/set-user-access-restrictions)`.
    func reposSetUserAccessRestrictions(_ input: Operations.ReposSetUserAccessRestrictions.Input) async throws -> Operations.ReposSetUserAccessRestrictions.Output
    /// Remove user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of a user to push to this branch.
    ///
    /// | Type    | Description                                                                                                                                   |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/delete(repos/remove-user-access-restrictions)`.
    func reposRemoveUserAccessRestrictions(_ input: Operations.ReposRemoveUserAccessRestrictions.Input) async throws -> Operations.ReposRemoveUserAccessRestrictions.Output
    /// Rename a branch
    ///
    /// Renames a branch in a repository.
    ///
    /// > [!NOTE]
    /// > Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".
    ///
    /// The authenticated user must have push access to the branch. If the branch is the default branch, the authenticated user must also have admin or owner permissions.
    ///
    /// In order to rename the default branch, fine-grained access tokens also need the `administration:write` repository permission.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/rename`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/rename/post(repos/rename-branch)`.
    func reposRenameBranch(_ input: Operations.ReposRenameBranch.Input) async throws -> Operations.ReposRenameBranch.Output
    /// List CODEOWNERS errors
    ///
    /// List any syntax errors that are detected in the CODEOWNERS
    /// file.
    ///
    /// For more information about the correct CODEOWNERS syntax,
    /// see "[About code owners](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codeowners/errors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codeowners/errors/get(repos/codeowners-errors)`.
    func reposCodeownersErrors(_ input: Operations.ReposCodeownersErrors.Input) async throws -> Operations.ReposCodeownersErrors.Output
    /// List repository collaborators
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// The `permissions` hash returned in the response contains the base role permissions of the collaborator. The `role_name` is the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
    /// There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.
    ///
    /// Team members will include the members of child teams.
    ///
    /// The authenticated user must have write, maintain, or admin privileges on the repository to use this endpoint. For organization-owned repositories, the authenticated user needs to be a member of the organization.
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/get(repos/list-collaborators)`.
    func reposListCollaborators(_ input: Operations.ReposListCollaborators.Input) async throws -> Operations.ReposListCollaborators.Output
    /// Check if a user is a repository collaborator
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    ///
    /// Team members will include the members of child teams.
    ///
    /// The authenticated user must have push access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/get(repos/check-collaborator)`.
    func reposCheckCollaborator(_ input: Operations.ReposCheckCollaborator.Input) async throws -> Operations.ReposCheckCollaborator.Output
    /// Add a repository collaborator
    ///
    /// Add a user to a repository with a specified level of access. If the repository is owned by an organization, this API does not add the user to the organization - a user that has repository access without being an organization member is called an "outside collaborator" (if they are not an Enterprise Managed User) or a "repository collaborator" if they are an Enterprise Managed User. These users are exempt from some organization policies - see "[Adding outside collaborators to repositories](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/managing-outside-collaborators/adding-outside-collaborators-to-repositories-in-your-organization)" to learn more about these collaborator types.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// Adding an outside collaborator may be restricted by enterprise and organization administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)" and "[Setting permissions for adding outside collaborators](https://docs.github.com/organizations/managing-organization-settings/setting-permissions-for-adding-outside-collaborators)" for organization settings.
    ///
    /// For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the role being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
    ///
    /// ```
    /// Cannot assign {member} permission of {role name}
    /// ```
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [API](https://docs.github.com/rest/collaborators/invitations).
    ///
    /// For Enterprise Managed Users, this endpoint does not send invitations - these users are automatically added to organizations and repositories. Enterprise Managed Users can only be added to organizations and repositories within their enterprise.
    ///
    /// **Updating an existing collaborator's permission level**
    ///
    /// The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.
    ///
    /// **Rate limits**
    ///
    /// You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/put(repos/add-collaborator)`.
    func reposAddCollaborator(_ input: Operations.ReposAddCollaborator.Input) async throws -> Operations.ReposAddCollaborator.Output
    /// Remove a repository collaborator
    ///
    /// Removes a collaborator from a repository.
    ///
    /// To use this endpoint, the authenticated user must either be an administrator of the repository or target themselves for removal.
    ///
    /// This endpoint also:
    /// - Cancels any outstanding invitations sent by the collaborator
    /// - Unassigns the user from any issues
    /// - Removes access to organization projects if the user is not an organization member and is not a collaborator on any other organization repositories.
    /// - Unstars the repository
    /// - Updates access permissions to packages
    ///
    /// Removing a user as a collaborator has the following effects on forks:
    ///  - If the user had access to a fork through their membership to this repository, the user will also be removed from the fork.
    ///  - If the user had their own fork of the repository, the fork will be deleted.
    ///  - If the user still has read access to the repository, open pull requests by this user from a fork will be denied.
    ///
    /// > [!NOTE]
    /// > A user can still have access to the repository through organization permissions like base repository permissions.
    ///
    /// Although the API responds immediately, the additional permission updates might take some extra time to complete in the background.
    ///
    /// For more information on fork permissions, see "[About permissions and visibility of forks](https://docs.github.com/pull-requests/collaborating-with-pull-requests/working-with-forks/about-permissions-and-visibility-of-forks)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/delete(repos/remove-collaborator)`.
    func reposRemoveCollaborator(_ input: Operations.ReposRemoveCollaborator.Input) async throws -> Operations.ReposRemoveCollaborator.Output
    /// Get repository permissions for a user
    ///
    /// Checks the repository permission and role of a collaborator.
    ///
    /// The `permission` attribute provides the legacy base roles of `admin`, `write`, `read`, and `none`, where the
    /// `maintain` role is mapped to `write` and the `triage` role is mapped to `read`.
    /// The `role_name` attribute provides the name of the assigned role, including custom roles. The
    /// `permission` can also be used to determine which base level of access the collaborator has to the repository.
    ///
    /// The calculated permissions are the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
    /// There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/permission/get(repos/get-collaborator-permission-level)`.
    func reposGetCollaboratorPermissionLevel(_ input: Operations.ReposGetCollaboratorPermissionLevel.Input) async throws -> Operations.ReposGetCollaboratorPermissionLevel.Output
    /// List commit comments for a repository
    ///
    /// Lists the commit comments for a specified repository. Comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/get(repos/list-commit-comments-for-repo)`.
    func reposListCommitCommentsForRepo(_ input: Operations.ReposListCommitCommentsForRepo.Input) async throws -> Operations.ReposListCommitCommentsForRepo.Output
    /// Get a commit comment
    ///
    /// Gets a specified commit comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/get(repos/get-commit-comment)`.
    func reposGetCommitComment(_ input: Operations.ReposGetCommitComment.Input) async throws -> Operations.ReposGetCommitComment.Output
    /// Update a commit comment
    ///
    /// Updates the contents of a specified commit comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/patch(repos/update-commit-comment)`.
    func reposUpdateCommitComment(_ input: Operations.ReposUpdateCommitComment.Input) async throws -> Operations.ReposUpdateCommitComment.Output
    /// Delete a commit comment
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/delete(repos/delete-commit-comment)`.
    func reposDeleteCommitComment(_ input: Operations.ReposDeleteCommitComment.Input) async throws -> Operations.ReposDeleteCommitComment.Output
    /// List commits
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/get(repos/list-commits)`.
    func reposListCommits(_ input: Operations.ReposListCommits.Input) async throws -> Operations.ReposListCommits.Output
    /// List branches for HEAD commit
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head/get(repos/list-branches-for-head-commit)`.
    func reposListBranchesForHeadCommit(_ input: Operations.ReposListBranchesForHeadCommit.Input) async throws -> Operations.ReposListBranchesForHeadCommit.Output
    /// List commit comments
    ///
    /// Lists the comments for a specified commit.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/comments/get(repos/list-comments-for-commit)`.
    func reposListCommentsForCommit(_ input: Operations.ReposListCommentsForCommit.Input) async throws -> Operations.ReposListCommentsForCommit.Output
    /// Create a commit comment
    ///
    /// Create a comment for a commit using its `:commit_sha`.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/commits/{commit_sha}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/comments/post(repos/create-commit-comment)`.
    func reposCreateCommitComment(_ input: Operations.ReposCreateCommitComment.Input) async throws -> Operations.ReposCreateCommitComment.Output
    /// List pull requests associated with a commit
    ///
    /// Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, it will return merged and open pull requests associated with the commit.
    ///
    /// To list the open or merged pull requests associated with a branch, you can set the `commit_sha` parameter to the branch name.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/pulls/get(repos/list-pull-requests-associated-with-commit)`.
    func reposListPullRequestsAssociatedWithCommit(_ input: Operations.ReposListPullRequestsAssociatedWithCommit.Input) async throws -> Operations.ReposListPullRequestsAssociatedWithCommit.Output
    /// Get a commit
    ///
    /// Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
    ///
    /// > [!NOTE]
    /// > If there are more than 300 files in the commit diff and the default JSON media type is requested, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)." Pagination query parameters are not supported for these media types.
    ///
    /// - **`application/vnd.github.diff`**: Returns the diff of the commit. Larger diffs may time out and return a 5xx status code.
    /// - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property. Larger diffs may time out and return a 5xx status code.
    /// - **`application/vnd.github.sha`**: Returns the commit's SHA-1 hash. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/get(repos/get-commit)`.
    func reposGetCommit(_ input: Operations.ReposGetCommit.Input) async throws -> Operations.ReposGetCommit.Output
    /// Get the combined status for a specific reference
    ///
    /// Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
    ///
    ///
    /// Additionally, a combined `state` is returned. The `state` is one of:
    ///
    /// *   **failure** if any of the contexts report as `error` or `failure`
    /// *   **pending** if there are no statuses or a context is `pending`
    /// *   **success** if the latest status for all contexts is `success`
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/status`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/status/get(repos/get-combined-status-for-ref)`.
    func reposGetCombinedStatusForRef(_ input: Operations.ReposGetCombinedStatusForRef.Input) async throws -> Operations.ReposGetCombinedStatusForRef.Output
    /// List commit statuses for a reference
    ///
    /// Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
    ///
    /// This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/statuses/get(repos/list-commit-statuses-for-ref)`.
    func reposListCommitStatusesForRef(_ input: Operations.ReposListCommitStatusesForRef.Input) async throws -> Operations.ReposListCommitStatusesForRef.Output
    /// Get community profile metrics
    ///
    /// Returns all community profile metrics for a repository. The repository cannot be a fork.
    ///
    /// The returned metrics include an overall health score, the repository description, the presence of documentation, the
    /// detected code of conduct, the detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
    /// README, and CONTRIBUTING files.
    ///
    /// The `health_percentage` score is defined as a percentage of how many of
    /// the recommended community health files are present. For more information, see
    /// "[About community profiles for public repositories](https://docs.github.com/communities/setting-up-your-project-for-healthy-contributions/about-community-profiles-for-public-repositories)."
    ///
    /// `content_reports_enabled` is only returned for organization-owned repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/community/profile`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/community/profile/get(repos/get-community-profile-metrics)`.
    func reposGetCommunityProfileMetrics(_ input: Operations.ReposGetCommunityProfileMetrics.Input) async throws -> Operations.ReposGetCommunityProfileMetrics.Output
    /// Compare two commits
    ///
    /// Compares two commits against one another. You can compare refs (branches or tags) and commit SHAs in the same repository, or you can compare refs and commit SHAs that exist in different repositories within the same repository network, including fork branches. For more information about how to view a repository's network, see "[Understanding connections between repositories](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository/understanding-connections-between-repositories)."
    ///
    /// This endpoint is equivalent to running the `git log BASE..HEAD` command, but it returns commits in a different order. The `git log BASE..HEAD` command returns commits in reverse chronological order, whereas the API returns commits in chronological order.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.diff`**: Returns the diff of the commit.
    /// - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property.
    ///
    /// The API response includes details about the files that were changed between the two commits. This includes the status of the change (if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
    ///
    /// When calling this endpoint without any paging parameter (`per_page` or `page`), the returned list is limited to 250 commits, and the last commit in the list is the most recent of the entire comparison.
    ///
    /// **Working with large comparisons**
    ///
    /// To process a response with a large number of commits, use a query parameter (`per_page` or `page`) to paginate the results. When using pagination:
    ///
    /// - The list of changed files is only shown on the first page of results, and it includes up to 300 changed files for the entire comparison.
    /// - The results are returned in chronological order, but the last commit in the returned list may not be the most recent one in the entire set if there are more pages of results.
    ///
    /// For more information on working with pagination, see "[Using pagination in the REST API](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api)."
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The `verification` object includes the following fields:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/compare/{basehead}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/compare/{basehead}/get(repos/compare-commits)`.
    func reposCompareCommits(_ input: Operations.ReposCompareCommits.Input) async throws -> Operations.ReposCompareCommits.Output
    /// Get repository content
    ///
    /// Gets the contents of a file or directory in a repository. Specify the file path or directory with the `path` parameter. If you omit the `path` parameter, you will receive the contents of the repository's root directory.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents for files and symlinks.
    /// - **`application/vnd.github.html+json`**: Returns the file contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    /// - **`application/vnd.github.object+json`**: Returns the contents in a consistent object format regardless of the content type. For example, instead of an array of objects for a directory, the response will be an object with an `entries` attribute containing the array of objects.
    ///
    /// If the content is a directory, the response will be an array of objects, one object for each item in the directory. When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".
    ///
    /// If the content is a symlink and the symlink's target is a normal file in the repository, then the API responds with the content of the file. Otherwise, the API responds with an object describing the symlink itself.
    ///
    /// If the content is a submodule, the `submodule_git_url` field identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit. If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.
    ///
    /// **Notes**:
    ///
    /// - To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/git/trees#get-a-tree).
    /// - This API has an upper limit of 1,000 files for a directory. If you need to retrieve
    /// more files, use the [Git Trees API](https://docs.github.com/rest/git/trees#get-a-tree).
    /// - Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
    /// - If the requested file's size is:
    ///   - 1 MB or smaller: All features of this endpoint are supported.
    ///   - Between 1-100 MB: Only the `raw` or `object` custom media types are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty
    /// string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
    ///   - Greater than 100 MB: This endpoint is not supported.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/get(repos/get-content)`.
    func reposGetContent(_ input: Operations.ReposGetContent.Input) async throws -> Operations.ReposGetContent.Output
    /// Create or update file contents
    ///
    /// Creates a new file or replaces an existing file in a repository.
    ///
    /// > [!NOTE]
    /// > If you use this endpoint and the "[Delete a file](https://docs.github.com/rest/repos/contents/#delete-a-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The `workflow` scope is also required in order to modify files in the `.github/workflows` directory.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/put(repos/create-or-update-file-contents)`.
    func reposCreateOrUpdateFileContents(_ input: Operations.ReposCreateOrUpdateFileContents.Input) async throws -> Operations.ReposCreateOrUpdateFileContents.Output
    /// Delete a file
    ///
    /// Deletes a file in a repository.
    ///
    /// You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
    ///
    /// The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
    ///
    /// You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
    ///
    /// > [!NOTE]
    /// > If you use this endpoint and the "[Create or update file contents](https://docs.github.com/rest/repos/contents/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/delete(repos/delete-file)`.
    func reposDeleteFile(_ input: Operations.ReposDeleteFile.Input) async throws -> Operations.ReposDeleteFile.Output
    /// List repository contributors
    ///
    /// Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API caches contributor data to improve performance.
    ///
    /// GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/contributors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contributors/get(repos/list-contributors)`.
    func reposListContributors(_ input: Operations.ReposListContributors.Input) async throws -> Operations.ReposListContributors.Output
    /// List deployments
    ///
    /// Simple filtering of deployments is available via query parameters:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/get(repos/list-deployments)`.
    func reposListDeployments(_ input: Operations.ReposListDeployments.Input) async throws -> Operations.ReposListDeployments.Output
    /// Create a deployment
    ///
    /// Deployments offer a few configurable parameters with certain defaults.
    ///
    /// The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
    /// before we merge a pull request.
    ///
    /// The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
    /// multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
    /// makes it easier to track which environments have requested deployments. The default environment is `production`.
    ///
    /// The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
    /// the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
    /// the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
    /// return a failure response.
    ///
    /// By default, [commit statuses](https://docs.github.com/rest/commits/statuses) for every submitted context must be in a `success`
    /// state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
    /// specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
    /// not require any contexts or create any commit statuses, the deployment will always succeed.
    ///
    /// The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
    /// field that will be passed on when a deployment event is dispatched.
    ///
    /// The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
    /// be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
    /// application with debugging enabled.
    ///
    /// Merged branch response:
    ///
    /// You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
    /// a deployment. This auto-merge happens when:
    /// *   Auto-merge option is enabled in the repository
    /// *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
    /// *   There are no merge conflicts
    ///
    /// If there are no new commits in the base branch, a new request to create a deployment should give a successful
    /// response.
    ///
    /// Merge conflict response:
    ///
    /// This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
    /// be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
    ///
    /// Failed commit status checks:
    ///
    /// This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
    /// status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/post(repos/create-deployment)`.
    func reposCreateDeployment(_ input: Operations.ReposCreateDeployment.Input) async throws -> Operations.ReposCreateDeployment.Output
    /// Get a deployment
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/get(repos/get-deployment)`.
    func reposGetDeployment(_ input: Operations.ReposGetDeployment.Input) async throws -> Operations.ReposGetDeployment.Output
    /// Delete a deployment
    ///
    /// If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment.
    ///
    /// To set a deployment as inactive, you must:
    ///
    /// *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
    /// *   Mark the active deployment as inactive by adding any non-successful deployment status.
    ///
    /// For more information, see "[Create a deployment](https://docs.github.com/rest/deployments/deployments/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/deployments/statuses#create-a-deployment-status)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/deployments/{deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/delete(repos/delete-deployment)`.
    func reposDeleteDeployment(_ input: Operations.ReposDeleteDeployment.Input) async throws -> Operations.ReposDeleteDeployment.Output
    /// List deployment statuses
    ///
    /// Users with pull access can view deployment statuses for a deployment:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/get(repos/list-deployment-statuses)`.
    func reposListDeploymentStatuses(_ input: Operations.ReposListDeploymentStatuses.Input) async throws -> Operations.ReposListDeploymentStatuses.Output
    /// Create a deployment status
    ///
    /// Users with `push` access can create deployment statuses for a given deployment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/deployments/{deployment_id}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/post(repos/create-deployment-status)`.
    func reposCreateDeploymentStatus(_ input: Operations.ReposCreateDeploymentStatus.Input) async throws -> Operations.ReposCreateDeploymentStatus.Output
    /// Get a deployment status
    ///
    /// Users with pull access can view a deployment status for a deployment:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}/get(repos/get-deployment-status)`.
    func reposGetDeploymentStatus(_ input: Operations.ReposGetDeploymentStatus.Input) async throws -> Operations.ReposGetDeploymentStatus.Output
    /// Create a repository dispatch event
    ///
    /// You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
    ///
    /// The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
    ///
    /// This input example shows how you can use the `client_payload` as a test to debug your workflow.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/dispatches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dispatches/post(repos/create-dispatch-event)`.
    func reposCreateDispatchEvent(_ input: Operations.ReposCreateDispatchEvent.Input) async throws -> Operations.ReposCreateDispatchEvent.Output
    /// List environments
    ///
    /// Lists the environments for a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/get(repos/get-all-environments)`.
    func reposGetAllEnvironments(_ input: Operations.ReposGetAllEnvironments.Input) async throws -> Operations.ReposGetAllEnvironments.Output
    /// Get an environment
    ///
    /// > [!NOTE]
    /// > To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/get(repos/get-environment)`.
    func reposGetEnvironment(_ input: Operations.ReposGetEnvironment.Input) async throws -> Operations.ReposGetEnvironment.Output
    /// Create or update an environment
    ///
    /// Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
    ///
    /// > [!NOTE]
    /// > To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."
    ///
    /// > [!NOTE]
    /// > To create or update secrets for an environment, see "[GitHub Actions secrets](/rest/actions/secrets)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/put(repos/create-or-update-environment)`.
    func reposCreateOrUpdateEnvironment(_ input: Operations.ReposCreateOrUpdateEnvironment.Input) async throws -> Operations.ReposCreateOrUpdateEnvironment.Output
    /// Delete an environment
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/delete(repos/delete-an-environment)`.
    func reposDeleteAnEnvironment(_ input: Operations.ReposDeleteAnEnvironment.Input) async throws -> Operations.ReposDeleteAnEnvironment.Output
    /// List deployment branch policies
    ///
    /// Lists the deployment branch policies for an environment.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/get(repos/list-deployment-branch-policies)`.
    func reposListDeploymentBranchPolicies(_ input: Operations.ReposListDeploymentBranchPolicies.Input) async throws -> Operations.ReposListDeploymentBranchPolicies.Output
    /// Create a deployment branch policy
    ///
    /// Creates a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/post(repos/create-deployment-branch-policy)`.
    func reposCreateDeploymentBranchPolicy(_ input: Operations.ReposCreateDeploymentBranchPolicy.Input) async throws -> Operations.ReposCreateDeploymentBranchPolicy.Output
    /// Get a deployment branch policy
    ///
    /// Gets a deployment branch or tag policy for an environment.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/get(repos/get-deployment-branch-policy)`.
    func reposGetDeploymentBranchPolicy(_ input: Operations.ReposGetDeploymentBranchPolicy.Input) async throws -> Operations.ReposGetDeploymentBranchPolicy.Output
    /// Update a deployment branch policy
    ///
    /// Updates a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/put(repos/update-deployment-branch-policy)`.
    func reposUpdateDeploymentBranchPolicy(_ input: Operations.ReposUpdateDeploymentBranchPolicy.Input) async throws -> Operations.ReposUpdateDeploymentBranchPolicy.Output
    /// Delete a deployment branch policy
    ///
    /// Deletes a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/delete(repos/delete-deployment-branch-policy)`.
    func reposDeleteDeploymentBranchPolicy(_ input: Operations.ReposDeleteDeploymentBranchPolicy.Input) async throws -> Operations.ReposDeleteDeploymentBranchPolicy.Output
    /// Get all deployment protection rules for an environment
    ///
    /// Gets all custom deployment protection rules that are enabled for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/get(repos/get-all-deployment-protection-rules)`.
    func reposGetAllDeploymentProtectionRules(_ input: Operations.ReposGetAllDeploymentProtectionRules.Input) async throws -> Operations.ReposGetAllDeploymentProtectionRules.Output
    /// Create a custom deployment protection rule on an environment
    ///
    /// Enable a custom deployment protection rule for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app), as well as the [guide to creating custom deployment protection rules](https://docs.github.com/actions/managing-workflow-runs-and-deployments/managing-deployments/creating-custom-deployment-protection-rules).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/post(repos/create-deployment-protection-rule)`.
    func reposCreateDeploymentProtectionRule(_ input: Operations.ReposCreateDeploymentProtectionRule.Input) async throws -> Operations.ReposCreateDeploymentProtectionRule.Output
    /// List custom deployment rule integrations available for an environment
    ///
    /// Gets all custom deployment protection rule integrations that are available for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see "[GET an app](https://docs.github.com/rest/apps/apps#get-an-app)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps/get(repos/list-custom-deployment-rule-integrations)`.
    func reposListCustomDeploymentRuleIntegrations(_ input: Operations.ReposListCustomDeploymentRuleIntegrations.Input) async throws -> Operations.ReposListCustomDeploymentRuleIntegrations.Output
    /// Get a custom deployment protection rule
    ///
    /// Gets an enabled custom deployment protection rule for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see [`GET /apps/{app_slug}`](https://docs.github.com/rest/apps/apps#get-an-app).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}/get(repos/get-custom-deployment-protection-rule)`.
    func reposGetCustomDeploymentProtectionRule(_ input: Operations.ReposGetCustomDeploymentProtectionRule.Input) async throws -> Operations.ReposGetCustomDeploymentProtectionRule.Output
    /// Disable a custom protection rule for an environment
    ///
    /// Disables a custom deployment protection rule for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}/delete(repos/disable-deployment-protection-rule)`.
    func reposDisableDeploymentProtectionRule(_ input: Operations.ReposDisableDeploymentProtectionRule.Input) async throws -> Operations.ReposDisableDeploymentProtectionRule.Output
    /// List forks
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/forks/get(repos/list-forks)`.
    func reposListForks(_ input: Operations.ReposListForks.Input) async throws -> Operations.ReposListForks.Output
    /// Create a fork
    ///
    /// Create a fork for the authenticated user.
    ///
    /// > [!NOTE]
    /// > Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    ///
    /// > [!NOTE]
    /// > Although this endpoint works with GitHub Apps, the GitHub App must be installed on the destination account with access to all repositories and on the source account with access to the source repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/forks/post(repos/create-fork)`.
    func reposCreateFork(_ input: Operations.ReposCreateFork.Input) async throws -> Operations.ReposCreateFork.Output
    /// List repository webhooks
    ///
    /// Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/get(repos/list-webhooks)`.
    func reposListWebhooks(_ input: Operations.ReposListWebhooks.Input) async throws -> Operations.ReposListWebhooks.Output
    /// Create a repository webhook
    ///
    /// Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
    /// share the same `config` as long as those webhooks do not have any `events` that overlap.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/post(repos/create-webhook)`.
    func reposCreateWebhook(_ input: Operations.ReposCreateWebhook.Input) async throws -> Operations.ReposCreateWebhook.Output
    /// Get a repository webhook
    ///
    /// Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/webhooks/repo-config#get-a-webhook-configuration-for-a-repository)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/get(repos/get-webhook)`.
    func reposGetWebhook(_ input: Operations.ReposGetWebhook.Input) async throws -> Operations.ReposGetWebhook.Output
    /// Update a repository webhook
    ///
    /// Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/webhooks/repo-config#update-a-webhook-configuration-for-a-repository)."
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/patch(repos/update-webhook)`.
    func reposUpdateWebhook(_ input: Operations.ReposUpdateWebhook.Input) async throws -> Operations.ReposUpdateWebhook.Output
    /// Delete a repository webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be a repository owner, or have admin access in the repository, to delete the webhook.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/delete(repos/delete-webhook)`.
    func reposDeleteWebhook(_ input: Operations.ReposDeleteWebhook.Input) async throws -> Operations.ReposDeleteWebhook.Output
    /// Get a webhook configuration for a repository
    ///
    /// Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/webhooks/repos#get-a-repository-webhook)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:repo_hook` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/config/get(repos/get-webhook-config-for-repo)`.
    func reposGetWebhookConfigForRepo(_ input: Operations.ReposGetWebhookConfigForRepo.Input) async throws -> Operations.ReposGetWebhookConfigForRepo.Output
    /// Update a webhook configuration for a repository
    ///
    /// Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/webhooks/repos#update-a-repository-webhook)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:repo_hook` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/config/patch(repos/update-webhook-config-for-repo)`.
    func reposUpdateWebhookConfigForRepo(_ input: Operations.ReposUpdateWebhookConfigForRepo.Input) async throws -> Operations.ReposUpdateWebhookConfigForRepo.Output
    /// List deliveries for a repository webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/get(repos/list-webhook-deliveries)`.
    func reposListWebhookDeliveries(_ input: Operations.ReposListWebhookDeliveries.Input) async throws -> Operations.ReposListWebhookDeliveries.Output
    /// Get a delivery for a repository webhook
    ///
    /// Returns a delivery for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/get(repos/get-webhook-delivery)`.
    func reposGetWebhookDelivery(_ input: Operations.ReposGetWebhookDelivery.Input) async throws -> Operations.ReposGetWebhookDelivery.Output
    /// Redeliver a delivery for a repository webhook
    ///
    /// Redeliver a webhook delivery for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(repos/redeliver-webhook-delivery)`.
    func reposRedeliverWebhookDelivery(_ input: Operations.ReposRedeliverWebhookDelivery.Input) async throws -> Operations.ReposRedeliverWebhookDelivery.Output
    /// Ping a repository webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/pings/post(repos/ping-webhook)`.
    func reposPingWebhook(_ input: Operations.ReposPingWebhook.Input) async throws -> Operations.ReposPingWebhook.Output
    /// Test the push repository webhook
    ///
    /// This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
    ///
    /// > [!NOTE]
    /// > Previously `/repos/:owner/:repo/hooks/:hook_id/test`
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/tests`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/tests/post(repos/test-push-webhook)`.
    func reposTestPushWebhook(_ input: Operations.ReposTestPushWebhook.Input) async throws -> Operations.ReposTestPushWebhook.Output
    /// List repository invitations
    ///
    /// When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/invitations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/get(repos/list-invitations)`.
    func reposListInvitations(_ input: Operations.ReposListInvitations.Input) async throws -> Operations.ReposListInvitations.Output
    /// Update a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/{invitation_id}/patch(repos/update-invitation)`.
    func reposUpdateInvitation(_ input: Operations.ReposUpdateInvitation.Input) async throws -> Operations.ReposUpdateInvitation.Output
    /// Delete a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/{invitation_id}/delete(repos/delete-invitation)`.
    func reposDeleteInvitation(_ input: Operations.ReposDeleteInvitation.Input) async throws -> Operations.ReposDeleteInvitation.Output
    /// List deploy keys
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/keys`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/get(repos/list-deploy-keys)`.
    func reposListDeployKeys(_ input: Operations.ReposListDeployKeys.Input) async throws -> Operations.ReposListDeployKeys.Output
    /// Create a deploy key
    ///
    /// You can create a read-only deploy key.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/keys`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/post(repos/create-deploy-key)`.
    func reposCreateDeployKey(_ input: Operations.ReposCreateDeployKey.Input) async throws -> Operations.ReposCreateDeployKey.Output
    /// Get a deploy key
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/{key_id}/get(repos/get-deploy-key)`.
    func reposGetDeployKey(_ input: Operations.ReposGetDeployKey.Input) async throws -> Operations.ReposGetDeployKey.Output
    /// Delete a deploy key
    ///
    /// Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/{key_id}/delete(repos/delete-deploy-key)`.
    func reposDeleteDeployKey(_ input: Operations.ReposDeleteDeployKey.Input) async throws -> Operations.ReposDeleteDeployKey.Output
    /// List repository languages
    ///
    /// Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/languages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/languages/get(repos/list-languages)`.
    func reposListLanguages(_ input: Operations.ReposListLanguages.Input) async throws -> Operations.ReposListLanguages.Output
    /// Sync a fork branch with the upstream repository
    ///
    /// Sync a branch of a forked repository to keep it up-to-date with the upstream repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/merge-upstream`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/merge-upstream/post(repos/merge-upstream)`.
    func reposMergeUpstream(_ input: Operations.ReposMergeUpstream.Input) async throws -> Operations.ReposMergeUpstream.Output
    /// Merge a branch
    ///
    ///
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/merges`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/merges/post(repos/merge)`.
    func reposMerge(_ input: Operations.ReposMerge.Input) async throws -> Operations.ReposMerge.Output
    /// Get a GitHub Pages site
    ///
    /// Gets information about a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/get(repos/get-pages)`.
    func reposGetPages(_ input: Operations.ReposGetPages.Input) async throws -> Operations.ReposGetPages.Output
    /// Create a GitHub Pages site
    ///
    /// Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/post(repos/create-pages-site)`.
    func reposCreatePagesSite(_ input: Operations.ReposCreatePagesSite.Input) async throws -> Operations.ReposCreatePagesSite.Output
    /// Update information about a GitHub Pages site
    ///
    /// Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/put(repos/update-information-about-pages-site)`.
    func reposUpdateInformationAboutPagesSite(_ input: Operations.ReposUpdateInformationAboutPagesSite.Input) async throws -> Operations.ReposUpdateInformationAboutPagesSite.Output
    /// Delete a GitHub Pages site
    ///
    /// Deletes a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/delete(repos/delete-pages-site)`.
    func reposDeletePagesSite(_ input: Operations.ReposDeletePagesSite.Input) async throws -> Operations.ReposDeletePagesSite.Output
    /// List GitHub Pages builds
    ///
    /// Lists builts of a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/get(repos/list-pages-builds)`.
    func reposListPagesBuilds(_ input: Operations.ReposListPagesBuilds.Input) async throws -> Operations.ReposListPagesBuilds.Output
    /// Request a GitHub Pages build
    ///
    /// You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
    ///
    /// Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/builds`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/post(repos/request-pages-build)`.
    func reposRequestPagesBuild(_ input: Operations.ReposRequestPagesBuild.Input) async throws -> Operations.ReposRequestPagesBuild.Output
    /// Get latest Pages build
    ///
    /// Gets information about the single most recent build of a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds/latest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/latest/get(repos/get-latest-pages-build)`.
    func reposGetLatestPagesBuild(_ input: Operations.ReposGetLatestPagesBuild.Input) async throws -> Operations.ReposGetLatestPagesBuild.Output
    /// Get GitHub Pages build
    ///
    /// Gets information about a GitHub Pages build.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds/{build_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/{build_id}/get(repos/get-pages-build)`.
    func reposGetPagesBuild(_ input: Operations.ReposGetPagesBuild.Input) async throws -> Operations.ReposGetPagesBuild.Output
    /// Create a GitHub Pages deployment
    ///
    /// Create a GitHub Pages deployment for a repository.
    ///
    /// The authenticated user must have write permission to the repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/post(repos/create-pages-deployment)`.
    func reposCreatePagesDeployment(_ input: Operations.ReposCreatePagesDeployment.Input) async throws -> Operations.ReposCreatePagesDeployment.Output
    /// Get the status of a GitHub Pages deployment
    ///
    /// Gets the current status of a GitHub Pages deployment.
    ///
    /// The authenticated user must have read permission for the GitHub Pages site.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/get(repos/get-pages-deployment)`.
    func reposGetPagesDeployment(_ input: Operations.ReposGetPagesDeployment.Input) async throws -> Operations.ReposGetPagesDeployment.Output
    /// Cancel a GitHub Pages deployment
    ///
    /// Cancels a GitHub Pages deployment.
    ///
    /// The authenticated user must have write permissions for the GitHub Pages site.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel/post(repos/cancel-pages-deployment)`.
    func reposCancelPagesDeployment(_ input: Operations.ReposCancelPagesDeployment.Input) async throws -> Operations.ReposCancelPagesDeployment.Output
    /// Get a DNS health check for GitHub Pages
    ///
    /// Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.
    ///
    /// The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/health`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/health/get(repos/get-pages-health-check)`.
    func reposGetPagesHealthCheck(_ input: Operations.ReposGetPagesHealthCheck.Input) async throws -> Operations.ReposGetPagesHealthCheck.Output
    /// Check if private vulnerability reporting is enabled for a repository
    ///
    /// Returns a boolean indicating whether or not private vulnerability reporting is enabled for the repository. For more information, see "[Evaluating the security settings of a repository](https://docs.github.com/code-security/security-advisories/working-with-repository-security-advisories/evaluating-the-security-settings-of-a-repository)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/get(repos/check-private-vulnerability-reporting)`.
    func reposCheckPrivateVulnerabilityReporting(_ input: Operations.ReposCheckPrivateVulnerabilityReporting.Input) async throws -> Operations.ReposCheckPrivateVulnerabilityReporting.Output
    /// Enable private vulnerability reporting for a repository
    ///
    /// Enables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/put(repos/enable-private-vulnerability-reporting)`.
    func reposEnablePrivateVulnerabilityReporting(_ input: Operations.ReposEnablePrivateVulnerabilityReporting.Input) async throws -> Operations.ReposEnablePrivateVulnerabilityReporting.Output
    /// Disable private vulnerability reporting for a repository
    ///
    /// Disables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/delete(repos/disable-private-vulnerability-reporting)`.
    func reposDisablePrivateVulnerabilityReporting(_ input: Operations.ReposDisablePrivateVulnerabilityReporting.Input) async throws -> Operations.ReposDisablePrivateVulnerabilityReporting.Output
    /// Get all custom property values for a repository
    ///
    /// Gets all custom property values that are set for a repository.
    /// Users with read access to the repository can use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/properties/values`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/properties/values/get(repos/get-custom-properties-values)`.
    func reposGetCustomPropertiesValues(_ input: Operations.ReposGetCustomPropertiesValues.Input) async throws -> Operations.ReposGetCustomPropertiesValues.Output
    /// Create or update custom property values for a repository
    ///
    /// Create new or update existing custom property values for a repository.
    /// Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.
    ///
    /// Repository admins and other users with the repository-level "edit custom property values" fine-grained permission can use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/properties/values`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/properties/values/patch(repos/create-or-update-custom-properties-values)`.
    func reposCreateOrUpdateCustomPropertiesValues(_ input: Operations.ReposCreateOrUpdateCustomPropertiesValues.Input) async throws -> Operations.ReposCreateOrUpdateCustomPropertiesValues.Output
    /// Get a repository README
    ///
    /// Gets the preferred README for a repository.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
    /// - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/readme`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/readme/get(repos/get-readme)`.
    func reposGetReadme(_ input: Operations.ReposGetReadme.Input) async throws -> Operations.ReposGetReadme.Output
    /// Get a repository README for a directory
    ///
    /// Gets the README from a repository directory.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
    /// - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/readme/{dir}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/readme/{dir}/get(repos/get-readme-in-directory)`.
    func reposGetReadmeInDirectory(_ input: Operations.ReposGetReadmeInDirectory.Input) async throws -> Operations.ReposGetReadmeInDirectory.Output
    /// List releases
    ///
    /// This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/repos/repos#list-repository-tags).
    ///
    /// Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/get(repos/list-releases)`.
    func reposListReleases(_ input: Operations.ReposListReleases.Input) async throws -> Operations.ReposListReleases.Output
    /// Create a release
    ///
    /// Users with push access to the repository can create a release.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/post(repos/create-release)`.
    func reposCreateRelease(_ input: Operations.ReposCreateRelease.Input) async throws -> Operations.ReposCreateRelease.Output
    /// Get a release asset
    ///
    /// To download the asset's binary content:
    ///
    /// - If within a browser, fetch the location specified in the `browser_download_url` key provided in the response.
    /// - Alternatively, set the `Accept` header of the request to 
    ///   [`application/octet-stream`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types). 
    ///   The API will either redirect the client to the location, or stream it directly if possible.
    ///   API clients should handle both a `200` or `302` response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/get(repos/get-release-asset)`.
    func reposGetReleaseAsset(_ input: Operations.ReposGetReleaseAsset.Input) async throws -> Operations.ReposGetReleaseAsset.Output
    /// Update a release asset
    ///
    /// Users with push access to the repository can edit a release asset.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/patch(repos/update-release-asset)`.
    func reposUpdateReleaseAsset(_ input: Operations.ReposUpdateReleaseAsset.Input) async throws -> Operations.ReposUpdateReleaseAsset.Output
    /// Delete a release asset
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/delete(repos/delete-release-asset)`.
    func reposDeleteReleaseAsset(_ input: Operations.ReposDeleteReleaseAsset.Input) async throws -> Operations.ReposDeleteReleaseAsset.Output
    /// Generate release notes content for a release
    ///
    /// Generate a name and body describing a [release](https://docs.github.com/rest/releases/releases#get-a-release). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/generate-notes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/generate-notes/post(repos/generate-release-notes)`.
    func reposGenerateReleaseNotes(_ input: Operations.ReposGenerateReleaseNotes.Input) async throws -> Operations.ReposGenerateReleaseNotes.Output
    /// Get the latest release
    ///
    /// View the latest published full release for the repository.
    ///
    /// The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/latest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/latest/get(repos/get-latest-release)`.
    func reposGetLatestRelease(_ input: Operations.ReposGetLatestRelease.Input) async throws -> Operations.ReposGetLatestRelease.Output
    /// Get a release by tag name
    ///
    /// Get a published release with the specified tag.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/tags/{tag}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/tags/{tag}/get(repos/get-release-by-tag)`.
    func reposGetReleaseByTag(_ input: Operations.ReposGetReleaseByTag.Input) async throws -> Operations.ReposGetReleaseByTag.Output
    /// Get a release
    ///
    /// Gets a public release with the specified release ID.
    ///
    /// > [!NOTE]
    /// > This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a hypermedia resource. For more information, see "[Getting started with the REST API](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/get(repos/get-release)`.
    func reposGetRelease(_ input: Operations.ReposGetRelease.Input) async throws -> Operations.ReposGetRelease.Output
    /// Update a release
    ///
    /// Users with push access to the repository can edit a release.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/patch(repos/update-release)`.
    func reposUpdateRelease(_ input: Operations.ReposUpdateRelease.Input) async throws -> Operations.ReposUpdateRelease.Output
    /// Delete a release
    ///
    /// Users with push access to the repository can delete a release.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/delete(repos/delete-release)`.
    func reposDeleteRelease(_ input: Operations.ReposDeleteRelease.Input) async throws -> Operations.ReposDeleteRelease.Output
    /// List release assets
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/assets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/assets/get(repos/list-release-assets)`.
    func reposListReleaseAssets(_ input: Operations.ReposListReleaseAssets.Input) async throws -> Operations.ReposListReleaseAssets.Output
    /// Upload a release asset
    ///
    /// This endpoint makes use of a [Hypermedia relation](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
    /// the response of the [Create a release endpoint](https://docs.github.com/rest/releases/releases#create-a-release) to upload a release asset.
    ///
    /// You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
    ///
    /// Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example: 
    ///
    /// `application/zip`
    ///
    /// GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
    /// you'll still need to pass your authentication to be able to upload an asset.
    ///
    /// When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
    ///
    /// **Notes:**
    /// *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List release assets](https://docs.github.com/rest/releases/assets#list-release-assets)"
    /// endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// *   To find the `release_id` query the [`GET /repos/{owner}/{repo}/releases/latest` endpoint](https://docs.github.com/rest/releases/releases#get-the-latest-release). 
    /// *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/assets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/assets/post(repos/upload-release-asset)`.
    func reposUploadReleaseAsset(_ input: Operations.ReposUploadReleaseAsset.Input) async throws -> Operations.ReposUploadReleaseAsset.Output
    /// Get rules for a branch
    ///
    /// Returns all active rules that apply to the specified branch. The branch does not need to exist; rules that would apply
    /// to a branch with that name will be returned. All active rules that apply will be returned, regardless of the level
    /// at which they are configured (e.g. repository or organization). Rules in rulesets with "evaluate" or "disabled"
    /// enforcement statuses are not returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rules/branches/{branch}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rules/branches/{branch}/get(repos/get-branch-rules)`.
    func reposGetBranchRules(_ input: Operations.ReposGetBranchRules.Input) async throws -> Operations.ReposGetBranchRules.Output
    /// Get all repository rulesets
    ///
    /// Get all the rulesets for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/get(repos/get-repo-rulesets)`.
    func reposGetRepoRulesets(_ input: Operations.ReposGetRepoRulesets.Input) async throws -> Operations.ReposGetRepoRulesets.Output
    /// Create a repository ruleset
    ///
    /// Create a ruleset for a repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/rulesets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/post(repos/create-repo-ruleset)`.
    func reposCreateRepoRuleset(_ input: Operations.ReposCreateRepoRuleset.Input) async throws -> Operations.ReposCreateRepoRuleset.Output
    /// List repository rule suites
    ///
    /// Lists suites of rule evaluations at the repository level.
    /// For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/rule-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/rule-suites/get(repos/get-repo-rule-suites)`.
    func reposGetRepoRuleSuites(_ input: Operations.ReposGetRepoRuleSuites.Input) async throws -> Operations.ReposGetRepoRuleSuites.Output
    /// Get a repository rule suite
    ///
    /// Gets information about a suite of rule evaluations from within a repository.
    /// For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}/get(repos/get-repo-rule-suite)`.
    func reposGetRepoRuleSuite(_ input: Operations.ReposGetRepoRuleSuite.Input) async throws -> Operations.ReposGetRepoRuleSuite.Output
    /// Get a repository ruleset
    ///
    /// Get a ruleset for a repository.
    ///
    /// **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
    /// making the API request has write access to the ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/get(repos/get-repo-ruleset)`.
    func reposGetRepoRuleset(_ input: Operations.ReposGetRepoRuleset.Input) async throws -> Operations.ReposGetRepoRuleset.Output
    /// Update a repository ruleset
    ///
    /// Update a ruleset for a repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/put(repos/update-repo-ruleset)`.
    func reposUpdateRepoRuleset(_ input: Operations.ReposUpdateRepoRuleset.Input) async throws -> Operations.ReposUpdateRepoRuleset.Output
    /// Delete a repository ruleset
    ///
    /// Delete a ruleset for a repository.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/delete(repos/delete-repo-ruleset)`.
    func reposDeleteRepoRuleset(_ input: Operations.ReposDeleteRepoRuleset.Input) async throws -> Operations.ReposDeleteRepoRuleset.Output
    /// Get repository ruleset history
    ///
    /// Get the history of a repository ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/history/get(repos/get-repo-ruleset-history)`.
    func reposGetRepoRulesetHistory(_ input: Operations.ReposGetRepoRulesetHistory.Input) async throws -> Operations.ReposGetRepoRulesetHistory.Output
    /// Get repository ruleset version
    ///
    /// Get a version of a repository ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}/get(repos/get-repo-ruleset-version)`.
    func reposGetRepoRulesetVersion(_ input: Operations.ReposGetRepoRulesetVersion.Input) async throws -> Operations.ReposGetRepoRulesetVersion.Output
    /// Get the weekly commit activity
    ///
    /// Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
    ///
    /// > [!NOTE]
    /// > This endpoint can only be used for repositories with fewer than 10,000 commits. If the repository contains 10,000 or more commits, a 422 status code will be returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/code_frequency`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/code_frequency/get(repos/get-code-frequency-stats)`.
    func reposGetCodeFrequencyStats(_ input: Operations.ReposGetCodeFrequencyStats.Input) async throws -> Operations.ReposGetCodeFrequencyStats.Output
    /// Get the last year of commit activity
    ///
    /// Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/commit_activity`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/commit_activity/get(repos/get-commit-activity-stats)`.
    func reposGetCommitActivityStats(_ input: Operations.ReposGetCommitActivityStats.Input) async throws -> Operations.ReposGetCommitActivityStats.Output
    /// Get all contributor commit activity
    ///
    ///
    /// Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
    ///
    /// *   `w` - Start of the week, given as a [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time).
    /// *   `a` - Number of additions
    /// *   `d` - Number of deletions
    /// *   `c` - Number of commits
    ///
    /// > [!NOTE]
    /// > This endpoint will return `0` values for all addition and deletion counts in repositories with 10,000 or more commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/contributors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/contributors/get(repos/get-contributors-stats)`.
    func reposGetContributorsStats(_ input: Operations.ReposGetContributorsStats.Input) async throws -> Operations.ReposGetContributorsStats.Output
    /// Get the weekly commit count
    ///
    /// Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
    ///
    /// The array order is oldest week (index 0) to most recent week.
    ///
    /// The most recent week is seven days ago at UTC midnight to today at UTC midnight.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/participation`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/participation/get(repos/get-participation-stats)`.
    func reposGetParticipationStats(_ input: Operations.ReposGetParticipationStats.Input) async throws -> Operations.ReposGetParticipationStats.Output
    /// Get the hourly commit count for each day
    ///
    /// Each array contains the day number, hour number, and number of commits:
    ///
    /// *   `0-6`: Sunday - Saturday
    /// *   `0-23`: Hour of day
    /// *   Number of commits
    ///
    /// For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/punch_card`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/punch_card/get(repos/get-punch-card-stats)`.
    func reposGetPunchCardStats(_ input: Operations.ReposGetPunchCardStats.Input) async throws -> Operations.ReposGetPunchCardStats.Output
    /// Create a commit status
    ///
    /// Users with push access in a repository can create commit statuses for a given SHA.
    ///
    /// Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/statuses/{sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/statuses/{sha}/post(repos/create-commit-status)`.
    func reposCreateCommitStatus(_ input: Operations.ReposCreateCommitStatus.Input) async throws -> Operations.ReposCreateCommitStatus.Output
    /// List repository tags
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tags`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/get(repos/list-tags)`.
    func reposListTags(_ input: Operations.ReposListTags.Input) async throws -> Operations.ReposListTags.Output
    /// Closing down - List tag protection states for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#get-all-repository-rulesets)" endpoint instead.
    ///
    /// This returns the tag protection states of a repository.
    ///
    /// This information is only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tags/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/get(repos/list-tag-protection)`.
    @available(*, deprecated)
    func reposListTagProtection(_ input: Operations.ReposListTagProtection.Input) async throws -> Operations.ReposListTagProtection.Output
    /// Closing down - Create a tag protection state for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#create-a-repository-ruleset)" endpoint instead.
    ///
    /// This creates a tag protection state for a repository.
    /// This endpoint is only available to repository administrators.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/tags/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/post(repos/create-tag-protection)`.
    @available(*, deprecated)
    func reposCreateTagProtection(_ input: Operations.ReposCreateTagProtection.Input) async throws -> Operations.ReposCreateTagProtection.Output
    /// Closing down - Delete a tag protection state for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset)" endpoint instead.
    ///
    /// This deletes a tag protection state for a repository.
    /// This endpoint is only available to repository administrators.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/tags/protection/{tag_protection_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/{tag_protection_id}/delete(repos/delete-tag-protection)`.
    @available(*, deprecated)
    func reposDeleteTagProtection(_ input: Operations.ReposDeleteTagProtection.Input) async throws -> Operations.ReposDeleteTagProtection.Output
    /// Download a repository archive (tar)
    ///
    /// Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    ///
    /// > [!NOTE]
    /// > For private repositories, these links are temporary and expire after five minutes.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tarball/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tarball/{ref}/get(repos/download-tarball-archive)`.
    func reposDownloadTarballArchive(_ input: Operations.ReposDownloadTarballArchive.Input) async throws -> Operations.ReposDownloadTarballArchive.Output
    /// List repository teams
    ///
    /// Lists the teams that have access to the specified repository and that are also visible to the authenticated user.
    ///
    /// For a public repository, a team is listed only if that team added the public repository explicitly.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to use this endpoint with a public repository, and `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/teams/get(repos/list-teams)`.
    func reposListTeams(_ input: Operations.ReposListTeams.Input) async throws -> Operations.ReposListTeams.Output
    /// Get all repository topics
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/topics`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/topics/get(repos/get-all-topics)`.
    func reposGetAllTopics(_ input: Operations.ReposGetAllTopics.Input) async throws -> Operations.ReposGetAllTopics.Output
    /// Replace all repository topics
    ///
    ///
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/topics`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/topics/put(repos/replace-all-topics)`.
    func reposReplaceAllTopics(_ input: Operations.ReposReplaceAllTopics.Input) async throws -> Operations.ReposReplaceAllTopics.Output
    /// Get repository clones
    ///
    /// Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/clones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/clones/get(repos/get-clones)`.
    func reposGetClones(_ input: Operations.ReposGetClones.Input) async throws -> Operations.ReposGetClones.Output
    /// Get top referral paths
    ///
    /// Get the top 10 popular contents over the last 14 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/popular/paths`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/popular/paths/get(repos/get-top-paths)`.
    func reposGetTopPaths(_ input: Operations.ReposGetTopPaths.Input) async throws -> Operations.ReposGetTopPaths.Output
    /// Get top referral sources
    ///
    /// Get the top 10 referrers over the last 14 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/popular/referrers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/popular/referrers/get(repos/get-top-referrers)`.
    func reposGetTopReferrers(_ input: Operations.ReposGetTopReferrers.Input) async throws -> Operations.ReposGetTopReferrers.Output
    /// Get page views
    ///
    /// Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/views`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/views/get(repos/get-views)`.
    func reposGetViews(_ input: Operations.ReposGetViews.Input) async throws -> Operations.ReposGetViews.Output
    /// Transfer a repository
    ///
    /// A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/transfer`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/transfer/post(repos/transfer)`.
    func reposTransfer(_ input: Operations.ReposTransfer.Input) async throws -> Operations.ReposTransfer.Output
    /// Check if vulnerability alerts are enabled for a repository
    ///
    /// Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/get(repos/check-vulnerability-alerts)`.
    func reposCheckVulnerabilityAlerts(_ input: Operations.ReposCheckVulnerabilityAlerts.Input) async throws -> Operations.ReposCheckVulnerabilityAlerts.Output
    /// Enable vulnerability alerts
    ///
    /// Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/put(repos/enable-vulnerability-alerts)`.
    func reposEnableVulnerabilityAlerts(_ input: Operations.ReposEnableVulnerabilityAlerts.Input) async throws -> Operations.ReposEnableVulnerabilityAlerts.Output
    /// Disable vulnerability alerts
    ///
    /// Disables dependency alerts and the dependency graph for a repository.
    /// The authenticated user must have admin access to the repository. For more information,
    /// see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/delete(repos/disable-vulnerability-alerts)`.
    func reposDisableVulnerabilityAlerts(_ input: Operations.ReposDisableVulnerabilityAlerts.Input) async throws -> Operations.ReposDisableVulnerabilityAlerts.Output
    /// Download a repository archive (zip)
    ///
    /// Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    ///
    /// > [!NOTE]
    /// > For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/zipball/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/zipball/{ref}/get(repos/download-zipball-archive)`.
    func reposDownloadZipballArchive(_ input: Operations.ReposDownloadZipballArchive.Input) async throws -> Operations.ReposDownloadZipballArchive.Output
    /// Create a repository using a template
    ///
    /// Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/repos/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /repos/{template_owner}/{template_repo}/generate`.
    /// - Remark: Generated from `#/paths//repos/{template_owner}/{template_repo}/generate/post(repos/create-using-template)`.
    func reposCreateUsingTemplate(_ input: Operations.ReposCreateUsingTemplate.Input) async throws -> Operations.ReposCreateUsingTemplate.Output
    /// List public repositories
    ///
    /// Lists all public repositories in the order that they were created.
    ///
    /// Note:
    /// - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
    /// - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of repositories.
    ///
    /// - Remark: HTTP `GET /repositories`.
    /// - Remark: Generated from `#/paths//repositories/get(repos/list-public)`.
    func reposListPublic(_ input: Operations.ReposListPublic.Input) async throws -> Operations.ReposListPublic.Output
    /// List repositories for the authenticated user
    ///
    /// Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// - Remark: HTTP `GET /user/repos`.
    /// - Remark: Generated from `#/paths//user/repos/get(repos/list-for-authenticated-user)`.
    func reposListForAuthenticatedUser(_ input: Operations.ReposListForAuthenticatedUser.Input) async throws -> Operations.ReposListForAuthenticatedUser.Output
    /// Create a repository for the authenticated user
    ///
    /// Creates a new repository for the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /user/repos`.
    /// - Remark: Generated from `#/paths//user/repos/post(repos/create-for-authenticated-user)`.
    func reposCreateForAuthenticatedUser(_ input: Operations.ReposCreateForAuthenticatedUser.Input) async throws -> Operations.ReposCreateForAuthenticatedUser.Output
    /// List repository invitations for the authenticated user
    ///
    /// When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
    ///
    /// - Remark: HTTP `GET /user/repository_invitations`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/get(repos/list-invitations-for-authenticated-user)`.
    func reposListInvitationsForAuthenticatedUser(_ input: Operations.ReposListInvitationsForAuthenticatedUser.Input) async throws -> Operations.ReposListInvitationsForAuthenticatedUser.Output
    /// Accept a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /user/repository_invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/{invitation_id}/patch(repos/accept-invitation-for-authenticated-user)`.
    func reposAcceptInvitationForAuthenticatedUser(_ input: Operations.ReposAcceptInvitationForAuthenticatedUser.Input) async throws -> Operations.ReposAcceptInvitationForAuthenticatedUser.Output
    /// Decline a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /user/repository_invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/{invitation_id}/delete(repos/decline-invitation-for-authenticated-user)`.
    func reposDeclineInvitationForAuthenticatedUser(_ input: Operations.ReposDeclineInvitationForAuthenticatedUser.Input) async throws -> Operations.ReposDeclineInvitationForAuthenticatedUser.Output
    /// List repositories for a user
    ///
    /// Lists public repositories for the specified user.
    ///
    /// - Remark: HTTP `GET /users/{username}/repos`.
    /// - Remark: Generated from `#/paths//users/{username}/repos/get(repos/list-for-user)`.
    func reposListForUser(_ input: Operations.ReposListForUser.Input) async throws -> Operations.ReposListForUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List organization repositories
    ///
    /// Lists repositories for the specified organization.
    ///
    /// > [!NOTE]
    /// > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/repos/get(repos/list-for-org)`.
    public func reposListForOrg(
        path: Operations.ReposListForOrg.Input.Path,
        query: Operations.ReposListForOrg.Input.Query = .init(),
        headers: Operations.ReposListForOrg.Input.Headers = .init()
    ) async throws -> Operations.ReposListForOrg.Output {
        try await reposListForOrg(Operations.ReposListForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization repository
    ///
    /// Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/repos`.
    /// - Remark: Generated from `#/paths//orgs/{org}/repos/post(repos/create-in-org)`.
    public func reposCreateInOrg(
        path: Operations.ReposCreateInOrg.Input.Path,
        headers: Operations.ReposCreateInOrg.Input.Headers = .init(),
        body: Operations.ReposCreateInOrg.Input.Body
    ) async throws -> Operations.ReposCreateInOrg.Output {
        try await reposCreateInOrg(Operations.ReposCreateInOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get all organization repository rulesets
    ///
    /// Get all the repository rulesets for an organization.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/get(repos/get-org-rulesets)`.
    public func reposGetOrgRulesets(
        path: Operations.ReposGetOrgRulesets.Input.Path,
        query: Operations.ReposGetOrgRulesets.Input.Query = .init(),
        headers: Operations.ReposGetOrgRulesets.Input.Headers = .init()
    ) async throws -> Operations.ReposGetOrgRulesets.Output {
        try await reposGetOrgRulesets(Operations.ReposGetOrgRulesets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an organization repository ruleset
    ///
    /// Create a repository ruleset for an organization.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/rulesets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/post(repos/create-org-ruleset)`.
    public func reposCreateOrgRuleset(
        path: Operations.ReposCreateOrgRuleset.Input.Path,
        headers: Operations.ReposCreateOrgRuleset.Input.Headers = .init(),
        body: Operations.ReposCreateOrgRuleset.Input.Body
    ) async throws -> Operations.ReposCreateOrgRuleset.Output {
        try await reposCreateOrgRuleset(Operations.ReposCreateOrgRuleset.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List organization rule suites
    ///
    /// Lists suites of rule evaluations at the organization level.
    /// For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/rule-suites`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/rule-suites/get(repos/get-org-rule-suites)`.
    public func reposGetOrgRuleSuites(
        path: Operations.ReposGetOrgRuleSuites.Input.Path,
        query: Operations.ReposGetOrgRuleSuites.Input.Query = .init(),
        headers: Operations.ReposGetOrgRuleSuites.Input.Headers = .init()
    ) async throws -> Operations.ReposGetOrgRuleSuites.Output {
        try await reposGetOrgRuleSuites(Operations.ReposGetOrgRuleSuites.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an organization rule suite
    ///
    /// Gets information about a suite of rule evaluations from within an organization.
    /// For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/rule-suites/{rule_suite_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/rule-suites/{rule_suite_id}/get(repos/get-org-rule-suite)`.
    public func reposGetOrgRuleSuite(
        path: Operations.ReposGetOrgRuleSuite.Input.Path,
        headers: Operations.ReposGetOrgRuleSuite.Input.Headers = .init()
    ) async throws -> Operations.ReposGetOrgRuleSuite.Output {
        try await reposGetOrgRuleSuite(Operations.ReposGetOrgRuleSuite.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an organization repository ruleset
    ///
    /// Get a repository ruleset for an organization.
    ///
    /// **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
    /// making the API request has write access to the ruleset.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/get(repos/get-org-ruleset)`.
    public func reposGetOrgRuleset(
        path: Operations.ReposGetOrgRuleset.Input.Path,
        headers: Operations.ReposGetOrgRuleset.Input.Headers = .init()
    ) async throws -> Operations.ReposGetOrgRuleset.Output {
        try await reposGetOrgRuleset(Operations.ReposGetOrgRuleset.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an organization repository ruleset
    ///
    /// Update a ruleset for an organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/put(repos/update-org-ruleset)`.
    public func reposUpdateOrgRuleset(
        path: Operations.ReposUpdateOrgRuleset.Input.Path,
        headers: Operations.ReposUpdateOrgRuleset.Input.Headers = .init(),
        body: Operations.ReposUpdateOrgRuleset.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateOrgRuleset.Output {
        try await reposUpdateOrgRuleset(Operations.ReposUpdateOrgRuleset.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization repository ruleset
    ///
    /// Delete a ruleset for an organization.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/rulesets/{ruleset_id}/delete(repos/delete-org-ruleset)`.
    public func reposDeleteOrgRuleset(
        path: Operations.ReposDeleteOrgRuleset.Input.Path,
        headers: Operations.ReposDeleteOrgRuleset.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteOrgRuleset.Output {
        try await reposDeleteOrgRuleset(Operations.ReposDeleteOrgRuleset.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository
    ///
    /// The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
    ///
    /// > [!NOTE]
    /// > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/get(repos/get)`.
    public func reposGet(
        path: Operations.ReposGet.Input.Path,
        headers: Operations.ReposGet.Input.Headers = .init()
    ) async throws -> Operations.ReposGet.Output {
        try await reposGet(Operations.ReposGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a repository
    ///
    /// **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/repos/repos#replace-all-repository-topics) endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/patch(repos/update)`.
    public func reposUpdate(
        path: Operations.ReposUpdate.Input.Path,
        headers: Operations.ReposUpdate.Input.Headers = .init(),
        body: Operations.ReposUpdate.Input.Body? = nil
    ) async throws -> Operations.ReposUpdate.Output {
        try await reposUpdate(Operations.ReposUpdate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository
    ///
    /// Deleting a repository requires admin access.
    ///
    /// If an organization owner has configured the organization to prevent members from deleting organization-owned
    /// repositories, you will get a `403 Forbidden` response.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `delete_repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/delete(repos/delete)`.
    public func reposDelete(
        path: Operations.ReposDelete.Input.Path,
        headers: Operations.ReposDelete.Input.Headers = .init()
    ) async throws -> Operations.ReposDelete.Output {
        try await reposDelete(Operations.ReposDelete.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repository activities
    ///
    /// Lists a detailed history of changes to a repository, such as pushes, merges, force pushes, and branch changes, and associates these changes with commits and users.
    ///
    /// For more information about viewing repository activity,
    /// see "[Viewing activity and data for your repository](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/activity`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/activity/get(repos/list-activities)`.
    public func reposListActivities(
        path: Operations.ReposListActivities.Input.Path,
        query: Operations.ReposListActivities.Input.Query = .init(),
        headers: Operations.ReposListActivities.Input.Headers = .init()
    ) async throws -> Operations.ReposListActivities.Output {
        try await reposListActivities(Operations.ReposListActivities.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create an attestation
    ///
    /// Store an artifact attestation and associate it with a repository.
    ///
    /// The authenticated user must have write permission to the repository and, if using a fine-grained access token, the `attestations:write` permission is required.
    ///
    /// Artifact attestations are meant to be created using the [attest action](https://github.com/actions/attest). For more information, see our guide on [using artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/attestations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/attestations/post(repos/create-attestation)`.
    public func reposCreateAttestation(
        path: Operations.ReposCreateAttestation.Input.Path,
        headers: Operations.ReposCreateAttestation.Input.Headers = .init(),
        body: Operations.ReposCreateAttestation.Input.Body
    ) async throws -> Operations.ReposCreateAttestation.Output {
        try await reposCreateAttestation(Operations.ReposCreateAttestation.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List attestations
    ///
    /// List a collection of artifact attestations with a given subject digest that are associated with a repository.
    ///
    /// The authenticated user making the request must have read access to the repository. In addition, when using a fine-grained access token the `attestations:read` permission is required.
    ///
    /// **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/attestations/{subject_digest}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/attestations/{subject_digest}/get(repos/list-attestations)`.
    public func reposListAttestations(
        path: Operations.ReposListAttestations.Input.Path,
        query: Operations.ReposListAttestations.Input.Query = .init(),
        headers: Operations.ReposListAttestations.Input.Headers = .init()
    ) async throws -> Operations.ReposListAttestations.Output {
        try await reposListAttestations(Operations.ReposListAttestations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get all autolinks of a repository
    ///
    /// Gets all autolinks that are configured for a repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/autolinks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/get(repos/list-autolinks)`.
    public func reposListAutolinks(
        path: Operations.ReposListAutolinks.Input.Path,
        headers: Operations.ReposListAutolinks.Input.Headers = .init()
    ) async throws -> Operations.ReposListAutolinks.Output {
        try await reposListAutolinks(Operations.ReposListAutolinks.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create an autolink reference for a repository
    ///
    /// Users with admin access to the repository can create an autolink.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/autolinks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/post(repos/create-autolink)`.
    public func reposCreateAutolink(
        path: Operations.ReposCreateAutolink.Input.Path,
        headers: Operations.ReposCreateAutolink.Input.Headers = .init(),
        body: Operations.ReposCreateAutolink.Input.Body
    ) async throws -> Operations.ReposCreateAutolink.Output {
        try await reposCreateAutolink(Operations.ReposCreateAutolink.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an autolink reference of a repository
    ///
    /// This returns a single autolink reference by ID that was configured for the given repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/autolinks/{autolink_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/{autolink_id}/get(repos/get-autolink)`.
    public func reposGetAutolink(
        path: Operations.ReposGetAutolink.Input.Path,
        headers: Operations.ReposGetAutolink.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAutolink.Output {
        try await reposGetAutolink(Operations.ReposGetAutolink.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an autolink reference from a repository
    ///
    /// This deletes a single autolink reference by ID that was configured for the given repository.
    ///
    /// Information about autolinks are only available to repository administrators.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/autolinks/{autolink_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/autolinks/{autolink_id}/delete(repos/delete-autolink)`.
    public func reposDeleteAutolink(
        path: Operations.ReposDeleteAutolink.Input.Path,
        headers: Operations.ReposDeleteAutolink.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteAutolink.Output {
        try await reposDeleteAutolink(Operations.ReposDeleteAutolink.Input(
            path: path,
            headers: headers
        ))
    }
    /// Check if Dependabot security updates are enabled for a repository
    ///
    /// Shows whether Dependabot security updates are enabled, disabled or paused for a repository. The authenticated user must have admin read access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/get(repos/check-automated-security-fixes)`.
    public func reposCheckAutomatedSecurityFixes(
        path: Operations.ReposCheckAutomatedSecurityFixes.Input.Path,
        headers: Operations.ReposCheckAutomatedSecurityFixes.Input.Headers = .init()
    ) async throws -> Operations.ReposCheckAutomatedSecurityFixes.Output {
        try await reposCheckAutomatedSecurityFixes(Operations.ReposCheckAutomatedSecurityFixes.Input(
            path: path,
            headers: headers
        ))
    }
    /// Enable Dependabot security updates
    ///
    /// Enables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/put(repos/enable-automated-security-fixes)`.
    public func reposEnableAutomatedSecurityFixes(path: Operations.ReposEnableAutomatedSecurityFixes.Input.Path) async throws -> Operations.ReposEnableAutomatedSecurityFixes.Output {
        try await reposEnableAutomatedSecurityFixes(Operations.ReposEnableAutomatedSecurityFixes.Input(path: path))
    }
    /// Disable Dependabot security updates
    ///
    /// Disables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/automated-security-fixes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/automated-security-fixes/delete(repos/disable-automated-security-fixes)`.
    public func reposDisableAutomatedSecurityFixes(path: Operations.ReposDisableAutomatedSecurityFixes.Input.Path) async throws -> Operations.ReposDisableAutomatedSecurityFixes.Output {
        try await reposDisableAutomatedSecurityFixes(Operations.ReposDisableAutomatedSecurityFixes.Input(path: path))
    }
    /// List branches
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/get(repos/list-branches)`.
    public func reposListBranches(
        path: Operations.ReposListBranches.Input.Path,
        query: Operations.ReposListBranches.Input.Query = .init(),
        headers: Operations.ReposListBranches.Input.Headers = .init()
    ) async throws -> Operations.ReposListBranches.Output {
        try await reposListBranches(Operations.ReposListBranches.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a branch
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/get(repos/get-branch)`.
    public func reposGetBranch(
        path: Operations.ReposGetBranch.Input.Path,
        headers: Operations.ReposGetBranch.Input.Headers = .init()
    ) async throws -> Operations.ReposGetBranch.Output {
        try await reposGetBranch(Operations.ReposGetBranch.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/get(repos/get-branch-protection)`.
    public func reposGetBranchProtection(
        path: Operations.ReposGetBranchProtection.Input.Path,
        headers: Operations.ReposGetBranchProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposGetBranchProtection.Output {
        try await reposGetBranchProtection(Operations.ReposGetBranchProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Protecting a branch requires admin or owner permissions to the repository.
    ///
    /// > [!NOTE]
    /// > Passing new arrays of `users` and `teams` replaces their previous values.
    ///
    /// > [!NOTE]
    /// > The list of users, apps, and teams in total is limited to 100 items.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/put(repos/update-branch-protection)`.
    public func reposUpdateBranchProtection(
        path: Operations.ReposUpdateBranchProtection.Input.Path,
        headers: Operations.ReposUpdateBranchProtection.Input.Headers = .init(),
        body: Operations.ReposUpdateBranchProtection.Input.Body
    ) async throws -> Operations.ReposUpdateBranchProtection.Output {
        try await reposUpdateBranchProtection(Operations.ReposUpdateBranchProtection.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/delete(repos/delete-branch-protection)`.
    public func reposDeleteBranchProtection(
        path: Operations.ReposDeleteBranchProtection.Input.Path,
        headers: Operations.ReposDeleteBranchProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteBranchProtection.Output {
        try await reposDeleteBranchProtection(Operations.ReposDeleteBranchProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/get(repos/get-admin-branch-protection)`.
    public func reposGetAdminBranchProtection(
        path: Operations.ReposGetAdminBranchProtection.Input.Path,
        headers: Operations.ReposGetAdminBranchProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAdminBranchProtection.Output {
        try await reposGetAdminBranchProtection(Operations.ReposGetAdminBranchProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/post(repos/set-admin-branch-protection)`.
    public func reposSetAdminBranchProtection(
        path: Operations.ReposSetAdminBranchProtection.Input.Path,
        headers: Operations.ReposSetAdminBranchProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposSetAdminBranchProtection.Output {
        try await reposSetAdminBranchProtection(Operations.ReposSetAdminBranchProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete admin branch protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins/delete(repos/delete-admin-branch-protection)`.
    public func reposDeleteAdminBranchProtection(
        path: Operations.ReposDeleteAdminBranchProtection.Input.Path,
        headers: Operations.ReposDeleteAdminBranchProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteAdminBranchProtection.Output {
        try await reposDeleteAdminBranchProtection(Operations.ReposDeleteAdminBranchProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/get(repos/get-pull-request-review-protection)`.
    public func reposGetPullRequestReviewProtection(
        path: Operations.ReposGetPullRequestReviewProtection.Input.Path,
        headers: Operations.ReposGetPullRequestReviewProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPullRequestReviewProtection.Output {
        try await reposGetPullRequestReviewProtection(Operations.ReposGetPullRequestReviewProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// > [!NOTE]
    /// > Passing new arrays of `users` and `teams` replaces their previous values.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/patch(repos/update-pull-request-review-protection)`.
    public func reposUpdatePullRequestReviewProtection(
        path: Operations.ReposUpdatePullRequestReviewProtection.Input.Path,
        headers: Operations.ReposUpdatePullRequestReviewProtection.Input.Headers = .init(),
        body: Operations.ReposUpdatePullRequestReviewProtection.Input.Body? = nil
    ) async throws -> Operations.ReposUpdatePullRequestReviewProtection.Output {
        try await reposUpdatePullRequestReviewProtection(Operations.ReposUpdatePullRequestReviewProtection.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete pull request review protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews/delete(repos/delete-pull-request-review-protection)`.
    public func reposDeletePullRequestReviewProtection(
        path: Operations.ReposDeletePullRequestReviewProtection.Input.Path,
        headers: Operations.ReposDeletePullRequestReviewProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposDeletePullRequestReviewProtection.Output {
        try await reposDeletePullRequestReviewProtection(Operations.ReposDeletePullRequestReviewProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.
    ///
    /// > [!NOTE]
    /// > You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/get(repos/get-commit-signature-protection)`.
    public func reposGetCommitSignatureProtection(
        path: Operations.ReposGetCommitSignatureProtection.Input.Path,
        headers: Operations.ReposGetCommitSignatureProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCommitSignatureProtection.Output {
        try await reposGetCommitSignatureProtection(Operations.ReposGetCommitSignatureProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/post(repos/create-commit-signature-protection)`.
    public func reposCreateCommitSignatureProtection(
        path: Operations.ReposCreateCommitSignatureProtection.Input.Path,
        headers: Operations.ReposCreateCommitSignatureProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposCreateCommitSignatureProtection.Output {
        try await reposCreateCommitSignatureProtection(Operations.ReposCreateCommitSignatureProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete commit signature protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_signatures/delete(repos/delete-commit-signature-protection)`.
    public func reposDeleteCommitSignatureProtection(
        path: Operations.ReposDeleteCommitSignatureProtection.Input.Path,
        headers: Operations.ReposDeleteCommitSignatureProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteCommitSignatureProtection.Output {
        try await reposDeleteCommitSignatureProtection(Operations.ReposDeleteCommitSignatureProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get status checks protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/get(repos/get-status-checks-protection)`.
    public func reposGetStatusChecksProtection(
        path: Operations.ReposGetStatusChecksProtection.Input.Path,
        headers: Operations.ReposGetStatusChecksProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposGetStatusChecksProtection.Output {
        try await reposGetStatusChecksProtection(Operations.ReposGetStatusChecksProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/patch(repos/update-status-check-protection)`.
    public func reposUpdateStatusCheckProtection(
        path: Operations.ReposUpdateStatusCheckProtection.Input.Path,
        headers: Operations.ReposUpdateStatusCheckProtection.Input.Headers = .init(),
        body: Operations.ReposUpdateStatusCheckProtection.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateStatusCheckProtection.Output {
        try await reposUpdateStatusCheckProtection(Operations.ReposUpdateStatusCheckProtection.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove status check protection
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/delete(repos/remove-status-check-protection)`.
    public func reposRemoveStatusCheckProtection(path: Operations.ReposRemoveStatusCheckProtection.Input.Path) async throws -> Operations.ReposRemoveStatusCheckProtection.Output {
        try await reposRemoveStatusCheckProtection(Operations.ReposRemoveStatusCheckProtection.Input(path: path))
    }
    /// Get all status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/get(repos/get-all-status-check-contexts)`.
    public func reposGetAllStatusCheckContexts(
        path: Operations.ReposGetAllStatusCheckContexts.Input.Path,
        headers: Operations.ReposGetAllStatusCheckContexts.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAllStatusCheckContexts.Output {
        try await reposGetAllStatusCheckContexts(Operations.ReposGetAllStatusCheckContexts.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/post(repos/add-status-check-contexts)`.
    public func reposAddStatusCheckContexts(
        path: Operations.ReposAddStatusCheckContexts.Input.Path,
        headers: Operations.ReposAddStatusCheckContexts.Input.Headers = .init(),
        body: Operations.ReposAddStatusCheckContexts.Input.Body? = nil
    ) async throws -> Operations.ReposAddStatusCheckContexts.Output {
        try await reposAddStatusCheckContexts(Operations.ReposAddStatusCheckContexts.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/put(repos/set-status-check-contexts)`.
    public func reposSetStatusCheckContexts(
        path: Operations.ReposSetStatusCheckContexts.Input.Path,
        headers: Operations.ReposSetStatusCheckContexts.Input.Headers = .init(),
        body: Operations.ReposSetStatusCheckContexts.Input.Body? = nil
    ) async throws -> Operations.ReposSetStatusCheckContexts.Output {
        try await reposSetStatusCheckContexts(Operations.ReposSetStatusCheckContexts.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove status check contexts
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts/delete(repos/remove-status-check-contexts)`.
    public func reposRemoveStatusCheckContexts(
        path: Operations.ReposRemoveStatusCheckContexts.Input.Path,
        headers: Operations.ReposRemoveStatusCheckContexts.Input.Headers = .init(),
        body: Operations.ReposRemoveStatusCheckContexts.Input.Body? = nil
    ) async throws -> Operations.ReposRemoveStatusCheckContexts.Output {
        try await reposRemoveStatusCheckContexts(Operations.ReposRemoveStatusCheckContexts.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists who has access to this protected branch.
    ///
    /// > [!NOTE]
    /// > Users, apps, and teams `restrictions` are only available for organization-owned repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/get(repos/get-access-restrictions)`.
    public func reposGetAccessRestrictions(
        path: Operations.ReposGetAccessRestrictions.Input.Path,
        headers: Operations.ReposGetAccessRestrictions.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAccessRestrictions.Output {
        try await reposGetAccessRestrictions(Operations.ReposGetAccessRestrictions.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Disables the ability to restrict who can push to this branch.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/delete(repos/delete-access-restrictions)`.
    public func reposDeleteAccessRestrictions(path: Operations.ReposDeleteAccessRestrictions.Input.Path) async throws -> Operations.ReposDeleteAccessRestrictions.Output {
        try await reposDeleteAccessRestrictions(Operations.ReposDeleteAccessRestrictions.Input(path: path))
    }
    /// Get apps with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the GitHub Apps that have push access to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/get(repos/get-apps-with-access-to-protected-branch)`.
    public func reposGetAppsWithAccessToProtectedBranch(
        path: Operations.ReposGetAppsWithAccessToProtectedBranch.Input.Path,
        headers: Operations.ReposGetAppsWithAccessToProtectedBranch.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAppsWithAccessToProtectedBranch.Output {
        try await reposGetAppsWithAccessToProtectedBranch(Operations.ReposGetAppsWithAccessToProtectedBranch.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified apps push access for this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/post(repos/add-app-access-restrictions)`.
    public func reposAddAppAccessRestrictions(
        path: Operations.ReposAddAppAccessRestrictions.Input.Path,
        headers: Operations.ReposAddAppAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposAddAppAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposAddAppAccessRestrictions.Output {
        try await reposAddAppAccessRestrictions(Operations.ReposAddAppAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/put(repos/set-app-access-restrictions)`.
    public func reposSetAppAccessRestrictions(
        path: Operations.ReposSetAppAccessRestrictions.Input.Path,
        headers: Operations.ReposSetAppAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposSetAppAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposSetAppAccessRestrictions.Output {
        try await reposSetAppAccessRestrictions(Operations.ReposSetAppAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove app access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of an app to push to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps/delete(repos/remove-app-access-restrictions)`.
    public func reposRemoveAppAccessRestrictions(
        path: Operations.ReposRemoveAppAccessRestrictions.Input.Path,
        headers: Operations.ReposRemoveAppAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposRemoveAppAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposRemoveAppAccessRestrictions.Output {
        try await reposRemoveAppAccessRestrictions(Operations.ReposRemoveAppAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get teams with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the teams who have push access to this branch. The list includes child teams.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/get(repos/get-teams-with-access-to-protected-branch)`.
    public func reposGetTeamsWithAccessToProtectedBranch(
        path: Operations.ReposGetTeamsWithAccessToProtectedBranch.Input.Path,
        headers: Operations.ReposGetTeamsWithAccessToProtectedBranch.Input.Headers = .init()
    ) async throws -> Operations.ReposGetTeamsWithAccessToProtectedBranch.Output {
        try await reposGetTeamsWithAccessToProtectedBranch(Operations.ReposGetTeamsWithAccessToProtectedBranch.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified teams push access for this branch. You can also give push access to child teams.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/post(repos/add-team-access-restrictions)`.
    public func reposAddTeamAccessRestrictions(
        path: Operations.ReposAddTeamAccessRestrictions.Input.Path,
        headers: Operations.ReposAddTeamAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposAddTeamAccessRestrictions.Input.Body? = nil
    ) async throws -> Operations.ReposAddTeamAccessRestrictions.Output {
        try await reposAddTeamAccessRestrictions(Operations.ReposAddTeamAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/put(repos/set-team-access-restrictions)`.
    public func reposSetTeamAccessRestrictions(
        path: Operations.ReposSetTeamAccessRestrictions.Input.Path,
        headers: Operations.ReposSetTeamAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposSetTeamAccessRestrictions.Input.Body? = nil
    ) async throws -> Operations.ReposSetTeamAccessRestrictions.Output {
        try await reposSetTeamAccessRestrictions(Operations.ReposSetTeamAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove team access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of a team to push to this branch. You can also remove push access for child teams.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams/delete(repos/remove-team-access-restrictions)`.
    public func reposRemoveTeamAccessRestrictions(
        path: Operations.ReposRemoveTeamAccessRestrictions.Input.Path,
        headers: Operations.ReposRemoveTeamAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposRemoveTeamAccessRestrictions.Input.Body? = nil
    ) async throws -> Operations.ReposRemoveTeamAccessRestrictions.Output {
        try await reposRemoveTeamAccessRestrictions(Operations.ReposRemoveTeamAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get users with access to the protected branch
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Lists the people who have push access to this branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/get(repos/get-users-with-access-to-protected-branch)`.
    public func reposGetUsersWithAccessToProtectedBranch(
        path: Operations.ReposGetUsersWithAccessToProtectedBranch.Input.Path,
        headers: Operations.ReposGetUsersWithAccessToProtectedBranch.Input.Headers = .init()
    ) async throws -> Operations.ReposGetUsersWithAccessToProtectedBranch.Output {
        try await reposGetUsersWithAccessToProtectedBranch(Operations.ReposGetUsersWithAccessToProtectedBranch.Input(
            path: path,
            headers: headers
        ))
    }
    /// Add user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Grants the specified people push access for this branch.
    ///
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/post(repos/add-user-access-restrictions)`.
    public func reposAddUserAccessRestrictions(
        path: Operations.ReposAddUserAccessRestrictions.Input.Path,
        headers: Operations.ReposAddUserAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposAddUserAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposAddUserAccessRestrictions.Output {
        try await reposAddUserAccessRestrictions(Operations.ReposAddUserAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
    ///
    /// | Type    | Description                                                                                                                   |
    /// | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/put(repos/set-user-access-restrictions)`.
    public func reposSetUserAccessRestrictions(
        path: Operations.ReposSetUserAccessRestrictions.Input.Path,
        headers: Operations.ReposSetUserAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposSetUserAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposSetUserAccessRestrictions.Output {
        try await reposSetUserAccessRestrictions(Operations.ReposSetUserAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove user access restrictions
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Removes the ability of a user to push to this branch.
    ///
    /// | Type    | Description                                                                                                                                   |
    /// | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
    /// | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users/delete(repos/remove-user-access-restrictions)`.
    public func reposRemoveUserAccessRestrictions(
        path: Operations.ReposRemoveUserAccessRestrictions.Input.Path,
        headers: Operations.ReposRemoveUserAccessRestrictions.Input.Headers = .init(),
        body: Operations.ReposRemoveUserAccessRestrictions.Input.Body
    ) async throws -> Operations.ReposRemoveUserAccessRestrictions.Output {
        try await reposRemoveUserAccessRestrictions(Operations.ReposRemoveUserAccessRestrictions.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Rename a branch
    ///
    /// Renames a branch in a repository.
    ///
    /// > [!NOTE]
    /// > Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".
    ///
    /// The authenticated user must have push access to the branch. If the branch is the default branch, the authenticated user must also have admin or owner permissions.
    ///
    /// In order to rename the default branch, fine-grained access tokens also need the `administration:write` repository permission.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/branches/{branch}/rename`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/branches/{branch}/rename/post(repos/rename-branch)`.
    public func reposRenameBranch(
        path: Operations.ReposRenameBranch.Input.Path,
        headers: Operations.ReposRenameBranch.Input.Headers = .init(),
        body: Operations.ReposRenameBranch.Input.Body
    ) async throws -> Operations.ReposRenameBranch.Output {
        try await reposRenameBranch(Operations.ReposRenameBranch.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List CODEOWNERS errors
    ///
    /// List any syntax errors that are detected in the CODEOWNERS
    /// file.
    ///
    /// For more information about the correct CODEOWNERS syntax,
    /// see "[About code owners](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codeowners/errors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codeowners/errors/get(repos/codeowners-errors)`.
    public func reposCodeownersErrors(
        path: Operations.ReposCodeownersErrors.Input.Path,
        query: Operations.ReposCodeownersErrors.Input.Query = .init(),
        headers: Operations.ReposCodeownersErrors.Input.Headers = .init()
    ) async throws -> Operations.ReposCodeownersErrors.Output {
        try await reposCodeownersErrors(Operations.ReposCodeownersErrors.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository collaborators
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    /// The `permissions` hash returned in the response contains the base role permissions of the collaborator. The `role_name` is the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
    /// There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.
    ///
    /// Team members will include the members of child teams.
    ///
    /// The authenticated user must have write, maintain, or admin privileges on the repository to use this endpoint. For organization-owned repositories, the authenticated user needs to be a member of the organization.
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/get(repos/list-collaborators)`.
    public func reposListCollaborators(
        path: Operations.ReposListCollaborators.Input.Path,
        query: Operations.ReposListCollaborators.Input.Query = .init(),
        headers: Operations.ReposListCollaborators.Input.Headers = .init()
    ) async throws -> Operations.ReposListCollaborators.Output {
        try await reposListCollaborators(Operations.ReposListCollaborators.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if a user is a repository collaborator
    ///
    /// For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
    ///
    /// Team members will include the members of child teams.
    ///
    /// The authenticated user must have push access to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/get(repos/check-collaborator)`.
    public func reposCheckCollaborator(path: Operations.ReposCheckCollaborator.Input.Path) async throws -> Operations.ReposCheckCollaborator.Output {
        try await reposCheckCollaborator(Operations.ReposCheckCollaborator.Input(path: path))
    }
    /// Add a repository collaborator
    ///
    /// Add a user to a repository with a specified level of access. If the repository is owned by an organization, this API does not add the user to the organization - a user that has repository access without being an organization member is called an "outside collaborator" (if they are not an Enterprise Managed User) or a "repository collaborator" if they are an Enterprise Managed User. These users are exempt from some organization policies - see "[Adding outside collaborators to repositories](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/managing-outside-collaborators/adding-outside-collaborators-to-repositories-in-your-organization)" to learn more about these collaborator types.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).
    ///
    /// Adding an outside collaborator may be restricted by enterprise and organization administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)" and "[Setting permissions for adding outside collaborators](https://docs.github.com/organizations/managing-organization-settings/setting-permissions-for-adding-outside-collaborators)" for organization settings.
    ///
    /// For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the role being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
    ///
    /// ```
    /// Cannot assign {member} permission of {role name}
    /// ```
    ///
    /// Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."
    ///
    /// The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [API](https://docs.github.com/rest/collaborators/invitations).
    ///
    /// For Enterprise Managed Users, this endpoint does not send invitations - these users are automatically added to organizations and repositories. Enterprise Managed Users can only be added to organizations and repositories within their enterprise.
    ///
    /// **Updating an existing collaborator's permission level**
    ///
    /// The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.
    ///
    /// **Rate limits**
    ///
    /// You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/put(repos/add-collaborator)`.
    public func reposAddCollaborator(
        path: Operations.ReposAddCollaborator.Input.Path,
        headers: Operations.ReposAddCollaborator.Input.Headers = .init(),
        body: Operations.ReposAddCollaborator.Input.Body? = nil
    ) async throws -> Operations.ReposAddCollaborator.Output {
        try await reposAddCollaborator(Operations.ReposAddCollaborator.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove a repository collaborator
    ///
    /// Removes a collaborator from a repository.
    ///
    /// To use this endpoint, the authenticated user must either be an administrator of the repository or target themselves for removal.
    ///
    /// This endpoint also:
    /// - Cancels any outstanding invitations sent by the collaborator
    /// - Unassigns the user from any issues
    /// - Removes access to organization projects if the user is not an organization member and is not a collaborator on any other organization repositories.
    /// - Unstars the repository
    /// - Updates access permissions to packages
    ///
    /// Removing a user as a collaborator has the following effects on forks:
    ///  - If the user had access to a fork through their membership to this repository, the user will also be removed from the fork.
    ///  - If the user had their own fork of the repository, the fork will be deleted.
    ///  - If the user still has read access to the repository, open pull requests by this user from a fork will be denied.
    ///
    /// > [!NOTE]
    /// > A user can still have access to the repository through organization permissions like base repository permissions.
    ///
    /// Although the API responds immediately, the additional permission updates might take some extra time to complete in the background.
    ///
    /// For more information on fork permissions, see "[About permissions and visibility of forks](https://docs.github.com/pull-requests/collaborating-with-pull-requests/working-with-forks/about-permissions-and-visibility-of-forks)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/collaborators/{username}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/delete(repos/remove-collaborator)`.
    public func reposRemoveCollaborator(
        path: Operations.ReposRemoveCollaborator.Input.Path,
        headers: Operations.ReposRemoveCollaborator.Input.Headers = .init()
    ) async throws -> Operations.ReposRemoveCollaborator.Output {
        try await reposRemoveCollaborator(Operations.ReposRemoveCollaborator.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get repository permissions for a user
    ///
    /// Checks the repository permission and role of a collaborator.
    ///
    /// The `permission` attribute provides the legacy base roles of `admin`, `write`, `read`, and `none`, where the
    /// `maintain` role is mapped to `write` and the `triage` role is mapped to `read`.
    /// The `role_name` attribute provides the name of the assigned role, including custom roles. The
    /// `permission` can also be used to determine which base level of access the collaborator has to the repository.
    ///
    /// The calculated permissions are the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
    /// There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/collaborators/{username}/permission`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/collaborators/{username}/permission/get(repos/get-collaborator-permission-level)`.
    public func reposGetCollaboratorPermissionLevel(
        path: Operations.ReposGetCollaboratorPermissionLevel.Input.Path,
        headers: Operations.ReposGetCollaboratorPermissionLevel.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCollaboratorPermissionLevel.Output {
        try await reposGetCollaboratorPermissionLevel(Operations.ReposGetCollaboratorPermissionLevel.Input(
            path: path,
            headers: headers
        ))
    }
    /// List commit comments for a repository
    ///
    /// Lists the commit comments for a specified repository. Comments are ordered by ascending ID.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/get(repos/list-commit-comments-for-repo)`.
    public func reposListCommitCommentsForRepo(
        path: Operations.ReposListCommitCommentsForRepo.Input.Path,
        query: Operations.ReposListCommitCommentsForRepo.Input.Query = .init(),
        headers: Operations.ReposListCommitCommentsForRepo.Input.Headers = .init()
    ) async throws -> Operations.ReposListCommitCommentsForRepo.Output {
        try await reposListCommitCommentsForRepo(Operations.ReposListCommitCommentsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a commit comment
    ///
    /// Gets a specified commit comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/get(repos/get-commit-comment)`.
    public func reposGetCommitComment(
        path: Operations.ReposGetCommitComment.Input.Path,
        headers: Operations.ReposGetCommitComment.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCommitComment.Output {
        try await reposGetCommitComment(Operations.ReposGetCommitComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a commit comment
    ///
    /// Updates the contents of a specified commit comment.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/patch(repos/update-commit-comment)`.
    public func reposUpdateCommitComment(
        path: Operations.ReposUpdateCommitComment.Input.Path,
        headers: Operations.ReposUpdateCommitComment.Input.Headers = .init(),
        body: Operations.ReposUpdateCommitComment.Input.Body
    ) async throws -> Operations.ReposUpdateCommitComment.Output {
        try await reposUpdateCommitComment(Operations.ReposUpdateCommitComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a commit comment
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/comments/{comment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/comments/{comment_id}/delete(repos/delete-commit-comment)`.
    public func reposDeleteCommitComment(
        path: Operations.ReposDeleteCommitComment.Input.Path,
        headers: Operations.ReposDeleteCommitComment.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteCommitComment.Output {
        try await reposDeleteCommitComment(Operations.ReposDeleteCommitComment.Input(
            path: path,
            headers: headers
        ))
    }
    /// List commits
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/get(repos/list-commits)`.
    public func reposListCommits(
        path: Operations.ReposListCommits.Input.Path,
        query: Operations.ReposListCommits.Input.Query = .init(),
        headers: Operations.ReposListCommits.Input.Headers = .init()
    ) async throws -> Operations.ReposListCommits.Output {
        try await reposListCommits(Operations.ReposListCommits.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List branches for HEAD commit
    ///
    /// Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
    ///
    /// Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head/get(repos/list-branches-for-head-commit)`.
    public func reposListBranchesForHeadCommit(
        path: Operations.ReposListBranchesForHeadCommit.Input.Path,
        headers: Operations.ReposListBranchesForHeadCommit.Input.Headers = .init()
    ) async throws -> Operations.ReposListBranchesForHeadCommit.Output {
        try await reposListBranchesForHeadCommit(Operations.ReposListBranchesForHeadCommit.Input(
            path: path,
            headers: headers
        ))
    }
    /// List commit comments
    ///
    /// Lists the comments for a specified commit.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/comments/get(repos/list-comments-for-commit)`.
    public func reposListCommentsForCommit(
        path: Operations.ReposListCommentsForCommit.Input.Path,
        query: Operations.ReposListCommentsForCommit.Input.Query = .init(),
        headers: Operations.ReposListCommentsForCommit.Input.Headers = .init()
    ) async throws -> Operations.ReposListCommentsForCommit.Output {
        try await reposListCommentsForCommit(Operations.ReposListCommentsForCommit.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a commit comment
    ///
    /// Create a comment for a commit using its `:commit_sha`.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
    /// - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
    /// - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
    /// - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/commits/{commit_sha}/comments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/comments/post(repos/create-commit-comment)`.
    public func reposCreateCommitComment(
        path: Operations.ReposCreateCommitComment.Input.Path,
        headers: Operations.ReposCreateCommitComment.Input.Headers = .init(),
        body: Operations.ReposCreateCommitComment.Input.Body
    ) async throws -> Operations.ReposCreateCommitComment.Output {
        try await reposCreateCommitComment(Operations.ReposCreateCommitComment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List pull requests associated with a commit
    ///
    /// Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, it will return merged and open pull requests associated with the commit.
    ///
    /// To list the open or merged pull requests associated with a branch, you can set the `commit_sha` parameter to the branch name.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{commit_sha}/pulls`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{commit_sha}/pulls/get(repos/list-pull-requests-associated-with-commit)`.
    public func reposListPullRequestsAssociatedWithCommit(
        path: Operations.ReposListPullRequestsAssociatedWithCommit.Input.Path,
        query: Operations.ReposListPullRequestsAssociatedWithCommit.Input.Query = .init(),
        headers: Operations.ReposListPullRequestsAssociatedWithCommit.Input.Headers = .init()
    ) async throws -> Operations.ReposListPullRequestsAssociatedWithCommit.Output {
        try await reposListPullRequestsAssociatedWithCommit(Operations.ReposListPullRequestsAssociatedWithCommit.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a commit
    ///
    /// Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
    ///
    /// > [!NOTE]
    /// > If there are more than 300 files in the commit diff and the default JSON media type is requested, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)." Pagination query parameters are not supported for these media types.
    ///
    /// - **`application/vnd.github.diff`**: Returns the diff of the commit. Larger diffs may time out and return a 5xx status code.
    /// - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property. Larger diffs may time out and return a 5xx status code.
    /// - **`application/vnd.github.sha`**: Returns the commit's SHA-1 hash. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/get(repos/get-commit)`.
    public func reposGetCommit(
        path: Operations.ReposGetCommit.Input.Path,
        query: Operations.ReposGetCommit.Input.Query = .init(),
        headers: Operations.ReposGetCommit.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCommit.Output {
        try await reposGetCommit(Operations.ReposGetCommit.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get the combined status for a specific reference
    ///
    /// Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
    ///
    ///
    /// Additionally, a combined `state` is returned. The `state` is one of:
    ///
    /// *   **failure** if any of the contexts report as `error` or `failure`
    /// *   **pending** if there are no statuses or a context is `pending`
    /// *   **success** if the latest status for all contexts is `success`
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/status`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/status/get(repos/get-combined-status-for-ref)`.
    public func reposGetCombinedStatusForRef(
        path: Operations.ReposGetCombinedStatusForRef.Input.Path,
        query: Operations.ReposGetCombinedStatusForRef.Input.Query = .init(),
        headers: Operations.ReposGetCombinedStatusForRef.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCombinedStatusForRef.Output {
        try await reposGetCombinedStatusForRef(Operations.ReposGetCombinedStatusForRef.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List commit statuses for a reference
    ///
    /// Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
    ///
    /// This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/commits/{ref}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/commits/{ref}/statuses/get(repos/list-commit-statuses-for-ref)`.
    public func reposListCommitStatusesForRef(
        path: Operations.ReposListCommitStatusesForRef.Input.Path,
        query: Operations.ReposListCommitStatusesForRef.Input.Query = .init(),
        headers: Operations.ReposListCommitStatusesForRef.Input.Headers = .init()
    ) async throws -> Operations.ReposListCommitStatusesForRef.Output {
        try await reposListCommitStatusesForRef(Operations.ReposListCommitStatusesForRef.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get community profile metrics
    ///
    /// Returns all community profile metrics for a repository. The repository cannot be a fork.
    ///
    /// The returned metrics include an overall health score, the repository description, the presence of documentation, the
    /// detected code of conduct, the detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
    /// README, and CONTRIBUTING files.
    ///
    /// The `health_percentage` score is defined as a percentage of how many of
    /// the recommended community health files are present. For more information, see
    /// "[About community profiles for public repositories](https://docs.github.com/communities/setting-up-your-project-for-healthy-contributions/about-community-profiles-for-public-repositories)."
    ///
    /// `content_reports_enabled` is only returned for organization-owned repositories.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/community/profile`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/community/profile/get(repos/get-community-profile-metrics)`.
    public func reposGetCommunityProfileMetrics(
        path: Operations.ReposGetCommunityProfileMetrics.Input.Path,
        headers: Operations.ReposGetCommunityProfileMetrics.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCommunityProfileMetrics.Output {
        try await reposGetCommunityProfileMetrics(Operations.ReposGetCommunityProfileMetrics.Input(
            path: path,
            headers: headers
        ))
    }
    /// Compare two commits
    ///
    /// Compares two commits against one another. You can compare refs (branches or tags) and commit SHAs in the same repository, or you can compare refs and commit SHAs that exist in different repositories within the same repository network, including fork branches. For more information about how to view a repository's network, see "[Understanding connections between repositories](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository/understanding-connections-between-repositories)."
    ///
    /// This endpoint is equivalent to running the `git log BASE..HEAD` command, but it returns commits in a different order. The `git log BASE..HEAD` command returns commits in reverse chronological order, whereas the API returns commits in chronological order.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.diff`**: Returns the diff of the commit.
    /// - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property.
    ///
    /// The API response includes details about the files that were changed between the two commits. This includes the status of the change (if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
    ///
    /// When calling this endpoint without any paging parameter (`per_page` or `page`), the returned list is limited to 250 commits, and the last commit in the list is the most recent of the entire comparison.
    ///
    /// **Working with large comparisons**
    ///
    /// To process a response with a large number of commits, use a query parameter (`per_page` or `page`) to paginate the results. When using pagination:
    ///
    /// - The list of changed files is only shown on the first page of results, and it includes up to 300 changed files for the entire comparison.
    /// - The results are returned in chronological order, but the last commit in the returned list may not be the most recent one in the entire set if there are more pages of results.
    ///
    /// For more information on working with pagination, see "[Using pagination in the REST API](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api)."
    ///
    /// **Signature verification object**
    ///
    /// The response will include a `verification` object that describes the result of verifying the commit's signature. The `verification` object includes the following fields:
    ///
    /// | Name | Type | Description |
    /// | ---- | ---- | ----------- |
    /// | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
    /// | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
    /// | `signature` | `string` | The signature that was extracted from the commit. |
    /// | `payload` | `string` | The value that was signed. |
    /// | `verified_at` | `string` | The date the signature was verified by GitHub. |
    ///
    /// These are the possible values for `reason` in the `verification` object:
    ///
    /// | Value | Description |
    /// | ----- | ----------- |
    /// | `expired_key` | The key that made the signature is expired. |
    /// | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
    /// | `gpgverify_error` | There was an error communicating with the signature verification service. |
    /// | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
    /// | `unsigned` | The object does not include a signature. |
    /// | `unknown_signature_type` | A non-PGP signature was found in the commit. |
    /// | `no_user` | No user was associated with the `committer` email address in the commit. |
    /// | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
    /// | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
    /// | `unknown_key` | The key that made the signature has not been registered with any user's account. |
    /// | `malformed_signature` | There was an error parsing the signature. |
    /// | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
    /// | `valid` | None of the above errors applied, so the signature is considered to be verified. |
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/compare/{basehead}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/compare/{basehead}/get(repos/compare-commits)`.
    public func reposCompareCommits(
        path: Operations.ReposCompareCommits.Input.Path,
        query: Operations.ReposCompareCommits.Input.Query = .init(),
        headers: Operations.ReposCompareCommits.Input.Headers = .init()
    ) async throws -> Operations.ReposCompareCommits.Output {
        try await reposCompareCommits(Operations.ReposCompareCommits.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get repository content
    ///
    /// Gets the contents of a file or directory in a repository. Specify the file path or directory with the `path` parameter. If you omit the `path` parameter, you will receive the contents of the repository's root directory.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents for files and symlinks.
    /// - **`application/vnd.github.html+json`**: Returns the file contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    /// - **`application/vnd.github.object+json`**: Returns the contents in a consistent object format regardless of the content type. For example, instead of an array of objects for a directory, the response will be an object with an `entries` attribute containing the array of objects.
    ///
    /// If the content is a directory, the response will be an array of objects, one object for each item in the directory. When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".
    ///
    /// If the content is a symlink and the symlink's target is a normal file in the repository, then the API responds with the content of the file. Otherwise, the API responds with an object describing the symlink itself.
    ///
    /// If the content is a submodule, the `submodule_git_url` field identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit. If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.
    ///
    /// **Notes**:
    ///
    /// - To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/git/trees#get-a-tree).
    /// - This API has an upper limit of 1,000 files for a directory. If you need to retrieve
    /// more files, use the [Git Trees API](https://docs.github.com/rest/git/trees#get-a-tree).
    /// - Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
    /// - If the requested file's size is:
    ///   - 1 MB or smaller: All features of this endpoint are supported.
    ///   - Between 1-100 MB: Only the `raw` or `object` custom media types are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty
    /// string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
    ///   - Greater than 100 MB: This endpoint is not supported.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/get(repos/get-content)`.
    public func reposGetContent(
        path: Operations.ReposGetContent.Input.Path,
        query: Operations.ReposGetContent.Input.Query = .init(),
        headers: Operations.ReposGetContent.Input.Headers = .init()
    ) async throws -> Operations.ReposGetContent.Output {
        try await reposGetContent(Operations.ReposGetContent.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create or update file contents
    ///
    /// Creates a new file or replaces an existing file in a repository.
    ///
    /// > [!NOTE]
    /// > If you use this endpoint and the "[Delete a file](https://docs.github.com/rest/repos/contents/#delete-a-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The `workflow` scope is also required in order to modify files in the `.github/workflows` directory.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/put(repos/create-or-update-file-contents)`.
    public func reposCreateOrUpdateFileContents(
        path: Operations.ReposCreateOrUpdateFileContents.Input.Path,
        headers: Operations.ReposCreateOrUpdateFileContents.Input.Headers = .init(),
        body: Operations.ReposCreateOrUpdateFileContents.Input.Body
    ) async throws -> Operations.ReposCreateOrUpdateFileContents.Output {
        try await reposCreateOrUpdateFileContents(Operations.ReposCreateOrUpdateFileContents.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a file
    ///
    /// Deletes a file in a repository.
    ///
    /// You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
    ///
    /// The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
    ///
    /// You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
    ///
    /// > [!NOTE]
    /// > If you use this endpoint and the "[Create or update file contents](https://docs.github.com/rest/repos/contents/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/contents/{path}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contents/{path}/delete(repos/delete-file)`.
    public func reposDeleteFile(
        path: Operations.ReposDeleteFile.Input.Path,
        headers: Operations.ReposDeleteFile.Input.Headers = .init(),
        body: Operations.ReposDeleteFile.Input.Body
    ) async throws -> Operations.ReposDeleteFile.Output {
        try await reposDeleteFile(Operations.ReposDeleteFile.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository contributors
    ///
    /// Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API caches contributor data to improve performance.
    ///
    /// GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/contributors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/contributors/get(repos/list-contributors)`.
    public func reposListContributors(
        path: Operations.ReposListContributors.Input.Path,
        query: Operations.ReposListContributors.Input.Query = .init(),
        headers: Operations.ReposListContributors.Input.Headers = .init()
    ) async throws -> Operations.ReposListContributors.Output {
        try await reposListContributors(Operations.ReposListContributors.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List deployments
    ///
    /// Simple filtering of deployments is available via query parameters:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/get(repos/list-deployments)`.
    public func reposListDeployments(
        path: Operations.ReposListDeployments.Input.Path,
        query: Operations.ReposListDeployments.Input.Query = .init(),
        headers: Operations.ReposListDeployments.Input.Headers = .init()
    ) async throws -> Operations.ReposListDeployments.Output {
        try await reposListDeployments(Operations.ReposListDeployments.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a deployment
    ///
    /// Deployments offer a few configurable parameters with certain defaults.
    ///
    /// The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
    /// before we merge a pull request.
    ///
    /// The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
    /// multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
    /// makes it easier to track which environments have requested deployments. The default environment is `production`.
    ///
    /// The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
    /// the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
    /// the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
    /// return a failure response.
    ///
    /// By default, [commit statuses](https://docs.github.com/rest/commits/statuses) for every submitted context must be in a `success`
    /// state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
    /// specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
    /// not require any contexts or create any commit statuses, the deployment will always succeed.
    ///
    /// The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
    /// field that will be passed on when a deployment event is dispatched.
    ///
    /// The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
    /// be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
    /// application with debugging enabled.
    ///
    /// Merged branch response:
    ///
    /// You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
    /// a deployment. This auto-merge happens when:
    /// *   Auto-merge option is enabled in the repository
    /// *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
    /// *   There are no merge conflicts
    ///
    /// If there are no new commits in the base branch, a new request to create a deployment should give a successful
    /// response.
    ///
    /// Merge conflict response:
    ///
    /// This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
    /// be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
    ///
    /// Failed commit status checks:
    ///
    /// This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
    /// status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/post(repos/create-deployment)`.
    public func reposCreateDeployment(
        path: Operations.ReposCreateDeployment.Input.Path,
        headers: Operations.ReposCreateDeployment.Input.Headers = .init(),
        body: Operations.ReposCreateDeployment.Input.Body
    ) async throws -> Operations.ReposCreateDeployment.Output {
        try await reposCreateDeployment(Operations.ReposCreateDeployment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a deployment
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/get(repos/get-deployment)`.
    public func reposGetDeployment(
        path: Operations.ReposGetDeployment.Input.Path,
        headers: Operations.ReposGetDeployment.Input.Headers = .init()
    ) async throws -> Operations.ReposGetDeployment.Output {
        try await reposGetDeployment(Operations.ReposGetDeployment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a deployment
    ///
    /// If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment.
    ///
    /// To set a deployment as inactive, you must:
    ///
    /// *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
    /// *   Mark the active deployment as inactive by adding any non-successful deployment status.
    ///
    /// For more information, see "[Create a deployment](https://docs.github.com/rest/deployments/deployments/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/deployments/statuses#create-a-deployment-status)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/deployments/{deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/delete(repos/delete-deployment)`.
    public func reposDeleteDeployment(
        path: Operations.ReposDeleteDeployment.Input.Path,
        headers: Operations.ReposDeleteDeployment.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteDeployment.Output {
        try await reposDeleteDeployment(Operations.ReposDeleteDeployment.Input(
            path: path,
            headers: headers
        ))
    }
    /// List deployment statuses
    ///
    /// Users with pull access can view deployment statuses for a deployment:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/get(repos/list-deployment-statuses)`.
    public func reposListDeploymentStatuses(
        path: Operations.ReposListDeploymentStatuses.Input.Path,
        query: Operations.ReposListDeploymentStatuses.Input.Query = .init(),
        headers: Operations.ReposListDeploymentStatuses.Input.Headers = .init()
    ) async throws -> Operations.ReposListDeploymentStatuses.Output {
        try await reposListDeploymentStatuses(Operations.ReposListDeploymentStatuses.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a deployment status
    ///
    /// Users with `push` access can create deployment statuses for a given deployment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo_deployment` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/deployments/{deployment_id}/statuses`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/post(repos/create-deployment-status)`.
    public func reposCreateDeploymentStatus(
        path: Operations.ReposCreateDeploymentStatus.Input.Path,
        headers: Operations.ReposCreateDeploymentStatus.Input.Headers = .init(),
        body: Operations.ReposCreateDeploymentStatus.Input.Body
    ) async throws -> Operations.ReposCreateDeploymentStatus.Output {
        try await reposCreateDeploymentStatus(Operations.ReposCreateDeploymentStatus.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a deployment status
    ///
    /// Users with pull access can view a deployment status for a deployment:
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}/get(repos/get-deployment-status)`.
    public func reposGetDeploymentStatus(
        path: Operations.ReposGetDeploymentStatus.Input.Path,
        headers: Operations.ReposGetDeploymentStatus.Input.Headers = .init()
    ) async throws -> Operations.ReposGetDeploymentStatus.Output {
        try await reposGetDeploymentStatus(Operations.ReposGetDeploymentStatus.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a repository dispatch event
    ///
    /// You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
    ///
    /// The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
    ///
    /// This input example shows how you can use the `client_payload` as a test to debug your workflow.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/dispatches`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dispatches/post(repos/create-dispatch-event)`.
    public func reposCreateDispatchEvent(
        path: Operations.ReposCreateDispatchEvent.Input.Path,
        headers: Operations.ReposCreateDispatchEvent.Input.Headers = .init(),
        body: Operations.ReposCreateDispatchEvent.Input.Body
    ) async throws -> Operations.ReposCreateDispatchEvent.Output {
        try await reposCreateDispatchEvent(Operations.ReposCreateDispatchEvent.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List environments
    ///
    /// Lists the environments for a repository.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/get(repos/get-all-environments)`.
    public func reposGetAllEnvironments(
        path: Operations.ReposGetAllEnvironments.Input.Path,
        query: Operations.ReposGetAllEnvironments.Input.Query = .init(),
        headers: Operations.ReposGetAllEnvironments.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAllEnvironments.Output {
        try await reposGetAllEnvironments(Operations.ReposGetAllEnvironments.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an environment
    ///
    /// > [!NOTE]
    /// > To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/get(repos/get-environment)`.
    public func reposGetEnvironment(
        path: Operations.ReposGetEnvironment.Input.Path,
        headers: Operations.ReposGetEnvironment.Input.Headers = .init()
    ) async throws -> Operations.ReposGetEnvironment.Output {
        try await reposGetEnvironment(Operations.ReposGetEnvironment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update an environment
    ///
    /// Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
    ///
    /// > [!NOTE]
    /// > To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."
    ///
    /// > [!NOTE]
    /// > To create or update secrets for an environment, see "[GitHub Actions secrets](/rest/actions/secrets)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/put(repos/create-or-update-environment)`.
    public func reposCreateOrUpdateEnvironment(
        path: Operations.ReposCreateOrUpdateEnvironment.Input.Path,
        headers: Operations.ReposCreateOrUpdateEnvironment.Input.Headers = .init(),
        body: Operations.ReposCreateOrUpdateEnvironment.Input.Body? = nil
    ) async throws -> Operations.ReposCreateOrUpdateEnvironment.Output {
        try await reposCreateOrUpdateEnvironment(Operations.ReposCreateOrUpdateEnvironment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an environment
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/delete(repos/delete-an-environment)`.
    public func reposDeleteAnEnvironment(path: Operations.ReposDeleteAnEnvironment.Input.Path) async throws -> Operations.ReposDeleteAnEnvironment.Output {
        try await reposDeleteAnEnvironment(Operations.ReposDeleteAnEnvironment.Input(path: path))
    }
    /// List deployment branch policies
    ///
    /// Lists the deployment branch policies for an environment.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/get(repos/list-deployment-branch-policies)`.
    public func reposListDeploymentBranchPolicies(
        path: Operations.ReposListDeploymentBranchPolicies.Input.Path,
        query: Operations.ReposListDeploymentBranchPolicies.Input.Query = .init(),
        headers: Operations.ReposListDeploymentBranchPolicies.Input.Headers = .init()
    ) async throws -> Operations.ReposListDeploymentBranchPolicies.Output {
        try await reposListDeploymentBranchPolicies(Operations.ReposListDeploymentBranchPolicies.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a deployment branch policy
    ///
    /// Creates a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/post(repos/create-deployment-branch-policy)`.
    public func reposCreateDeploymentBranchPolicy(
        path: Operations.ReposCreateDeploymentBranchPolicy.Input.Path,
        headers: Operations.ReposCreateDeploymentBranchPolicy.Input.Headers = .init(),
        body: Operations.ReposCreateDeploymentBranchPolicy.Input.Body
    ) async throws -> Operations.ReposCreateDeploymentBranchPolicy.Output {
        try await reposCreateDeploymentBranchPolicy(Operations.ReposCreateDeploymentBranchPolicy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a deployment branch policy
    ///
    /// Gets a deployment branch or tag policy for an environment.
    ///
    /// Anyone with read access to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/get(repos/get-deployment-branch-policy)`.
    public func reposGetDeploymentBranchPolicy(
        path: Operations.ReposGetDeploymentBranchPolicy.Input.Path,
        headers: Operations.ReposGetDeploymentBranchPolicy.Input.Headers = .init()
    ) async throws -> Operations.ReposGetDeploymentBranchPolicy.Output {
        try await reposGetDeploymentBranchPolicy(Operations.ReposGetDeploymentBranchPolicy.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a deployment branch policy
    ///
    /// Updates a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/put(repos/update-deployment-branch-policy)`.
    public func reposUpdateDeploymentBranchPolicy(
        path: Operations.ReposUpdateDeploymentBranchPolicy.Input.Path,
        headers: Operations.ReposUpdateDeploymentBranchPolicy.Input.Headers = .init(),
        body: Operations.ReposUpdateDeploymentBranchPolicy.Input.Body
    ) async throws -> Operations.ReposUpdateDeploymentBranchPolicy.Output {
        try await reposUpdateDeploymentBranchPolicy(Operations.ReposUpdateDeploymentBranchPolicy.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a deployment branch policy
    ///
    /// Deletes a deployment branch or tag policy for an environment.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}/delete(repos/delete-deployment-branch-policy)`.
    public func reposDeleteDeploymentBranchPolicy(path: Operations.ReposDeleteDeploymentBranchPolicy.Input.Path) async throws -> Operations.ReposDeleteDeploymentBranchPolicy.Output {
        try await reposDeleteDeploymentBranchPolicy(Operations.ReposDeleteDeploymentBranchPolicy.Input(path: path))
    }
    /// Get all deployment protection rules for an environment
    ///
    /// Gets all custom deployment protection rules that are enabled for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/get(repos/get-all-deployment-protection-rules)`.
    public func reposGetAllDeploymentProtectionRules(
        path: Operations.ReposGetAllDeploymentProtectionRules.Input.Path,
        headers: Operations.ReposGetAllDeploymentProtectionRules.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAllDeploymentProtectionRules.Output {
        try await reposGetAllDeploymentProtectionRules(Operations.ReposGetAllDeploymentProtectionRules.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a custom deployment protection rule on an environment
    ///
    /// Enable a custom deployment protection rule for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app), as well as the [guide to creating custom deployment protection rules](https://docs.github.com/actions/managing-workflow-runs-and-deployments/managing-deployments/creating-custom-deployment-protection-rules).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/post(repos/create-deployment-protection-rule)`.
    public func reposCreateDeploymentProtectionRule(
        path: Operations.ReposCreateDeploymentProtectionRule.Input.Path,
        headers: Operations.ReposCreateDeploymentProtectionRule.Input.Headers = .init(),
        body: Operations.ReposCreateDeploymentProtectionRule.Input.Body
    ) async throws -> Operations.ReposCreateDeploymentProtectionRule.Output {
        try await reposCreateDeploymentProtectionRule(Operations.ReposCreateDeploymentProtectionRule.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List custom deployment rule integrations available for an environment
    ///
    /// Gets all custom deployment protection rule integrations that are available for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see "[GET an app](https://docs.github.com/rest/apps/apps#get-an-app)".
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps/get(repos/list-custom-deployment-rule-integrations)`.
    public func reposListCustomDeploymentRuleIntegrations(
        path: Operations.ReposListCustomDeploymentRuleIntegrations.Input.Path,
        query: Operations.ReposListCustomDeploymentRuleIntegrations.Input.Query = .init(),
        headers: Operations.ReposListCustomDeploymentRuleIntegrations.Input.Headers = .init()
    ) async throws -> Operations.ReposListCustomDeploymentRuleIntegrations.Output {
        try await reposListCustomDeploymentRuleIntegrations(Operations.ReposListCustomDeploymentRuleIntegrations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a custom deployment protection rule
    ///
    /// Gets an enabled custom deployment protection rule for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."
    ///
    /// For more information about the app that is providing this custom deployment rule, see [`GET /apps/{app_slug}`](https://docs.github.com/rest/apps/apps#get-an-app).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}/get(repos/get-custom-deployment-protection-rule)`.
    public func reposGetCustomDeploymentProtectionRule(
        path: Operations.ReposGetCustomDeploymentProtectionRule.Input.Path,
        headers: Operations.ReposGetCustomDeploymentProtectionRule.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCustomDeploymentProtectionRule.Output {
        try await reposGetCustomDeploymentProtectionRule(Operations.ReposGetCustomDeploymentProtectionRule.Input(
            path: path,
            headers: headers
        ))
    }
    /// Disable a custom protection rule for an environment
    ///
    /// Disables a custom deployment protection rule for an environment.
    ///
    /// The authenticated user must have admin or owner permissions to the repository to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}/delete(repos/disable-deployment-protection-rule)`.
    public func reposDisableDeploymentProtectionRule(path: Operations.ReposDisableDeploymentProtectionRule.Input.Path) async throws -> Operations.ReposDisableDeploymentProtectionRule.Output {
        try await reposDisableDeploymentProtectionRule(Operations.ReposDisableDeploymentProtectionRule.Input(path: path))
    }
    /// List forks
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/forks/get(repos/list-forks)`.
    public func reposListForks(
        path: Operations.ReposListForks.Input.Path,
        query: Operations.ReposListForks.Input.Query = .init(),
        headers: Operations.ReposListForks.Input.Headers = .init()
    ) async throws -> Operations.ReposListForks.Output {
        try await reposListForks(Operations.ReposListForks.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a fork
    ///
    /// Create a fork for the authenticated user.
    ///
    /// > [!NOTE]
    /// > Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    ///
    /// > [!NOTE]
    /// > Although this endpoint works with GitHub Apps, the GitHub App must be installed on the destination account with access to all repositories and on the source account with access to the source repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/forks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/forks/post(repos/create-fork)`.
    public func reposCreateFork(
        path: Operations.ReposCreateFork.Input.Path,
        headers: Operations.ReposCreateFork.Input.Headers = .init(),
        body: Operations.ReposCreateFork.Input.Body? = nil
    ) async throws -> Operations.ReposCreateFork.Output {
        try await reposCreateFork(Operations.ReposCreateFork.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository webhooks
    ///
    /// Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/get(repos/list-webhooks)`.
    public func reposListWebhooks(
        path: Operations.ReposListWebhooks.Input.Path,
        query: Operations.ReposListWebhooks.Input.Query = .init(),
        headers: Operations.ReposListWebhooks.Input.Headers = .init()
    ) async throws -> Operations.ReposListWebhooks.Output {
        try await reposListWebhooks(Operations.ReposListWebhooks.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository webhook
    ///
    /// Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
    /// share the same `config` as long as those webhooks do not have any `events` that overlap.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/post(repos/create-webhook)`.
    public func reposCreateWebhook(
        path: Operations.ReposCreateWebhook.Input.Path,
        headers: Operations.ReposCreateWebhook.Input.Headers = .init(),
        body: Operations.ReposCreateWebhook.Input.Body? = nil
    ) async throws -> Operations.ReposCreateWebhook.Output {
        try await reposCreateWebhook(Operations.ReposCreateWebhook.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a repository webhook
    ///
    /// Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/webhooks/repo-config#get-a-webhook-configuration-for-a-repository)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/get(repos/get-webhook)`.
    public func reposGetWebhook(
        path: Operations.ReposGetWebhook.Input.Path,
        headers: Operations.ReposGetWebhook.Input.Headers = .init()
    ) async throws -> Operations.ReposGetWebhook.Output {
        try await reposGetWebhook(Operations.ReposGetWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a repository webhook
    ///
    /// Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/webhooks/repo-config#update-a-webhook-configuration-for-a-repository)."
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/patch(repos/update-webhook)`.
    public func reposUpdateWebhook(
        path: Operations.ReposUpdateWebhook.Input.Path,
        headers: Operations.ReposUpdateWebhook.Input.Headers = .init(),
        body: Operations.ReposUpdateWebhook.Input.Body
    ) async throws -> Operations.ReposUpdateWebhook.Output {
        try await reposUpdateWebhook(Operations.ReposUpdateWebhook.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository webhook
    ///
    /// Delete a webhook for an organization.
    ///
    /// The authenticated user must be a repository owner, or have admin access in the repository, to delete the webhook.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/hooks/{hook_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/delete(repos/delete-webhook)`.
    public func reposDeleteWebhook(
        path: Operations.ReposDeleteWebhook.Input.Path,
        headers: Operations.ReposDeleteWebhook.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteWebhook.Output {
        try await reposDeleteWebhook(Operations.ReposDeleteWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a webhook configuration for a repository
    ///
    /// Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/webhooks/repos#get-a-repository-webhook)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `read:repo_hook` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/config/get(repos/get-webhook-config-for-repo)`.
    public func reposGetWebhookConfigForRepo(
        path: Operations.ReposGetWebhookConfigForRepo.Input.Path,
        headers: Operations.ReposGetWebhookConfigForRepo.Input.Headers = .init()
    ) async throws -> Operations.ReposGetWebhookConfigForRepo.Output {
        try await reposGetWebhookConfigForRepo(Operations.ReposGetWebhookConfigForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a webhook configuration for a repository
    ///
    /// Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/webhooks/repos#update-a-repository-webhook)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `write:repo_hook` or `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/hooks/{hook_id}/config`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/config/patch(repos/update-webhook-config-for-repo)`.
    public func reposUpdateWebhookConfigForRepo(
        path: Operations.ReposUpdateWebhookConfigForRepo.Input.Path,
        headers: Operations.ReposUpdateWebhookConfigForRepo.Input.Headers = .init(),
        body: Operations.ReposUpdateWebhookConfigForRepo.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateWebhookConfigForRepo.Output {
        try await reposUpdateWebhookConfigForRepo(Operations.ReposUpdateWebhookConfigForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List deliveries for a repository webhook
    ///
    /// Returns a list of webhook deliveries for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/get(repos/list-webhook-deliveries)`.
    public func reposListWebhookDeliveries(
        path: Operations.ReposListWebhookDeliveries.Input.Path,
        query: Operations.ReposListWebhookDeliveries.Input.Query = .init(),
        headers: Operations.ReposListWebhookDeliveries.Input.Headers = .init()
    ) async throws -> Operations.ReposListWebhookDeliveries.Output {
        try await reposListWebhookDeliveries(Operations.ReposListWebhookDeliveries.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a delivery for a repository webhook
    ///
    /// Returns a delivery for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/get(repos/get-webhook-delivery)`.
    public func reposGetWebhookDelivery(
        path: Operations.ReposGetWebhookDelivery.Input.Path,
        headers: Operations.ReposGetWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.ReposGetWebhookDelivery.Output {
        try await reposGetWebhookDelivery(Operations.ReposGetWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// Redeliver a delivery for a repository webhook
    ///
    /// Redeliver a webhook delivery for a webhook configured in a repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts/post(repos/redeliver-webhook-delivery)`.
    public func reposRedeliverWebhookDelivery(
        path: Operations.ReposRedeliverWebhookDelivery.Input.Path,
        headers: Operations.ReposRedeliverWebhookDelivery.Input.Headers = .init()
    ) async throws -> Operations.ReposRedeliverWebhookDelivery.Output {
        try await reposRedeliverWebhookDelivery(Operations.ReposRedeliverWebhookDelivery.Input(
            path: path,
            headers: headers
        ))
    }
    /// Ping a repository webhook
    ///
    /// This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/pings`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/pings/post(repos/ping-webhook)`.
    public func reposPingWebhook(
        path: Operations.ReposPingWebhook.Input.Path,
        headers: Operations.ReposPingWebhook.Input.Headers = .init()
    ) async throws -> Operations.ReposPingWebhook.Output {
        try await reposPingWebhook(Operations.ReposPingWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// Test the push repository webhook
    ///
    /// This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
    ///
    /// > [!NOTE]
    /// > Previously `/repos/:owner/:repo/hooks/:hook_id/test`
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/hooks/{hook_id}/tests`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/hooks/{hook_id}/tests/post(repos/test-push-webhook)`.
    public func reposTestPushWebhook(
        path: Operations.ReposTestPushWebhook.Input.Path,
        headers: Operations.ReposTestPushWebhook.Input.Headers = .init()
    ) async throws -> Operations.ReposTestPushWebhook.Output {
        try await reposTestPushWebhook(Operations.ReposTestPushWebhook.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repository invitations
    ///
    /// When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/invitations`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/get(repos/list-invitations)`.
    public func reposListInvitations(
        path: Operations.ReposListInvitations.Input.Path,
        query: Operations.ReposListInvitations.Input.Query = .init(),
        headers: Operations.ReposListInvitations.Input.Headers = .init()
    ) async throws -> Operations.ReposListInvitations.Output {
        try await reposListInvitations(Operations.ReposListInvitations.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Update a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/{invitation_id}/patch(repos/update-invitation)`.
    public func reposUpdateInvitation(
        path: Operations.ReposUpdateInvitation.Input.Path,
        headers: Operations.ReposUpdateInvitation.Input.Headers = .init(),
        body: Operations.ReposUpdateInvitation.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateInvitation.Output {
        try await reposUpdateInvitation(Operations.ReposUpdateInvitation.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/invitations/{invitation_id}/delete(repos/delete-invitation)`.
    public func reposDeleteInvitation(path: Operations.ReposDeleteInvitation.Input.Path) async throws -> Operations.ReposDeleteInvitation.Output {
        try await reposDeleteInvitation(Operations.ReposDeleteInvitation.Input(path: path))
    }
    /// List deploy keys
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/keys`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/get(repos/list-deploy-keys)`.
    public func reposListDeployKeys(
        path: Operations.ReposListDeployKeys.Input.Path,
        query: Operations.ReposListDeployKeys.Input.Query = .init(),
        headers: Operations.ReposListDeployKeys.Input.Headers = .init()
    ) async throws -> Operations.ReposListDeployKeys.Output {
        try await reposListDeployKeys(Operations.ReposListDeployKeys.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a deploy key
    ///
    /// You can create a read-only deploy key.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/keys`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/post(repos/create-deploy-key)`.
    public func reposCreateDeployKey(
        path: Operations.ReposCreateDeployKey.Input.Path,
        headers: Operations.ReposCreateDeployKey.Input.Headers = .init(),
        body: Operations.ReposCreateDeployKey.Input.Body
    ) async throws -> Operations.ReposCreateDeployKey.Output {
        try await reposCreateDeployKey(Operations.ReposCreateDeployKey.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a deploy key
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/{key_id}/get(repos/get-deploy-key)`.
    public func reposGetDeployKey(
        path: Operations.ReposGetDeployKey.Input.Path,
        headers: Operations.ReposGetDeployKey.Input.Headers = .init()
    ) async throws -> Operations.ReposGetDeployKey.Output {
        try await reposGetDeployKey(Operations.ReposGetDeployKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a deploy key
    ///
    /// Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/keys/{key_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/keys/{key_id}/delete(repos/delete-deploy-key)`.
    public func reposDeleteDeployKey(path: Operations.ReposDeleteDeployKey.Input.Path) async throws -> Operations.ReposDeleteDeployKey.Output {
        try await reposDeleteDeployKey(Operations.ReposDeleteDeployKey.Input(path: path))
    }
    /// List repository languages
    ///
    /// Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/languages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/languages/get(repos/list-languages)`.
    public func reposListLanguages(
        path: Operations.ReposListLanguages.Input.Path,
        headers: Operations.ReposListLanguages.Input.Headers = .init()
    ) async throws -> Operations.ReposListLanguages.Output {
        try await reposListLanguages(Operations.ReposListLanguages.Input(
            path: path,
            headers: headers
        ))
    }
    /// Sync a fork branch with the upstream repository
    ///
    /// Sync a branch of a forked repository to keep it up-to-date with the upstream repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/merge-upstream`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/merge-upstream/post(repos/merge-upstream)`.
    public func reposMergeUpstream(
        path: Operations.ReposMergeUpstream.Input.Path,
        headers: Operations.ReposMergeUpstream.Input.Headers = .init(),
        body: Operations.ReposMergeUpstream.Input.Body
    ) async throws -> Operations.ReposMergeUpstream.Output {
        try await reposMergeUpstream(Operations.ReposMergeUpstream.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Merge a branch
    ///
    ///
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/merges`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/merges/post(repos/merge)`.
    public func reposMerge(
        path: Operations.ReposMerge.Input.Path,
        headers: Operations.ReposMerge.Input.Headers = .init(),
        body: Operations.ReposMerge.Input.Body
    ) async throws -> Operations.ReposMerge.Output {
        try await reposMerge(Operations.ReposMerge.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a GitHub Pages site
    ///
    /// Gets information about a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/get(repos/get-pages)`.
    public func reposGetPages(
        path: Operations.ReposGetPages.Input.Path,
        headers: Operations.ReposGetPages.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPages.Output {
        try await reposGetPages(Operations.ReposGetPages.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a GitHub Pages site
    ///
    /// Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/post(repos/create-pages-site)`.
    public func reposCreatePagesSite(
        path: Operations.ReposCreatePagesSite.Input.Path,
        headers: Operations.ReposCreatePagesSite.Input.Headers = .init(),
        body: Operations.ReposCreatePagesSite.Input.Body
    ) async throws -> Operations.ReposCreatePagesSite.Output {
        try await reposCreatePagesSite(Operations.ReposCreatePagesSite.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Update information about a GitHub Pages site
    ///
    /// Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/put(repos/update-information-about-pages-site)`.
    public func reposUpdateInformationAboutPagesSite(
        path: Operations.ReposUpdateInformationAboutPagesSite.Input.Path,
        headers: Operations.ReposUpdateInformationAboutPagesSite.Input.Headers = .init(),
        body: Operations.ReposUpdateInformationAboutPagesSite.Input.Body
    ) async throws -> Operations.ReposUpdateInformationAboutPagesSite.Output {
        try await reposUpdateInformationAboutPagesSite(Operations.ReposUpdateInformationAboutPagesSite.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a GitHub Pages site
    ///
    /// Deletes a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/pages`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/delete(repos/delete-pages-site)`.
    public func reposDeletePagesSite(
        path: Operations.ReposDeletePagesSite.Input.Path,
        headers: Operations.ReposDeletePagesSite.Input.Headers = .init()
    ) async throws -> Operations.ReposDeletePagesSite.Output {
        try await reposDeletePagesSite(Operations.ReposDeletePagesSite.Input(
            path: path,
            headers: headers
        ))
    }
    /// List GitHub Pages builds
    ///
    /// Lists builts of a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/get(repos/list-pages-builds)`.
    public func reposListPagesBuilds(
        path: Operations.ReposListPagesBuilds.Input.Path,
        query: Operations.ReposListPagesBuilds.Input.Query = .init(),
        headers: Operations.ReposListPagesBuilds.Input.Headers = .init()
    ) async throws -> Operations.ReposListPagesBuilds.Output {
        try await reposListPagesBuilds(Operations.ReposListPagesBuilds.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Request a GitHub Pages build
    ///
    /// You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
    ///
    /// Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/builds`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/post(repos/request-pages-build)`.
    public func reposRequestPagesBuild(
        path: Operations.ReposRequestPagesBuild.Input.Path,
        headers: Operations.ReposRequestPagesBuild.Input.Headers = .init()
    ) async throws -> Operations.ReposRequestPagesBuild.Output {
        try await reposRequestPagesBuild(Operations.ReposRequestPagesBuild.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get latest Pages build
    ///
    /// Gets information about the single most recent build of a GitHub Pages site.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds/latest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/latest/get(repos/get-latest-pages-build)`.
    public func reposGetLatestPagesBuild(
        path: Operations.ReposGetLatestPagesBuild.Input.Path,
        headers: Operations.ReposGetLatestPagesBuild.Input.Headers = .init()
    ) async throws -> Operations.ReposGetLatestPagesBuild.Output {
        try await reposGetLatestPagesBuild(Operations.ReposGetLatestPagesBuild.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get GitHub Pages build
    ///
    /// Gets information about a GitHub Pages build.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/builds/{build_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/builds/{build_id}/get(repos/get-pages-build)`.
    public func reposGetPagesBuild(
        path: Operations.ReposGetPagesBuild.Input.Path,
        headers: Operations.ReposGetPagesBuild.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPagesBuild.Output {
        try await reposGetPagesBuild(Operations.ReposGetPagesBuild.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a GitHub Pages deployment
    ///
    /// Create a GitHub Pages deployment for a repository.
    ///
    /// The authenticated user must have write permission to the repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/deployments`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/post(repos/create-pages-deployment)`.
    public func reposCreatePagesDeployment(
        path: Operations.ReposCreatePagesDeployment.Input.Path,
        headers: Operations.ReposCreatePagesDeployment.Input.Headers = .init(),
        body: Operations.ReposCreatePagesDeployment.Input.Body
    ) async throws -> Operations.ReposCreatePagesDeployment.Output {
        try await reposCreatePagesDeployment(Operations.ReposCreatePagesDeployment.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get the status of a GitHub Pages deployment
    ///
    /// Gets the current status of a GitHub Pages deployment.
    ///
    /// The authenticated user must have read permission for the GitHub Pages site.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/get(repos/get-pages-deployment)`.
    public func reposGetPagesDeployment(
        path: Operations.ReposGetPagesDeployment.Input.Path,
        headers: Operations.ReposGetPagesDeployment.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPagesDeployment.Output {
        try await reposGetPagesDeployment(Operations.ReposGetPagesDeployment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Cancel a GitHub Pages deployment
    ///
    /// Cancels a GitHub Pages deployment.
    ///
    /// The authenticated user must have write permissions for the GitHub Pages site.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel/post(repos/cancel-pages-deployment)`.
    public func reposCancelPagesDeployment(
        path: Operations.ReposCancelPagesDeployment.Input.Path,
        headers: Operations.ReposCancelPagesDeployment.Input.Headers = .init()
    ) async throws -> Operations.ReposCancelPagesDeployment.Output {
        try await reposCancelPagesDeployment(Operations.ReposCancelPagesDeployment.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a DNS health check for GitHub Pages
    ///
    /// Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.
    ///
    /// The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.
    ///
    /// The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/pages/health`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pages/health/get(repos/get-pages-health-check)`.
    public func reposGetPagesHealthCheck(
        path: Operations.ReposGetPagesHealthCheck.Input.Path,
        headers: Operations.ReposGetPagesHealthCheck.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPagesHealthCheck.Output {
        try await reposGetPagesHealthCheck(Operations.ReposGetPagesHealthCheck.Input(
            path: path,
            headers: headers
        ))
    }
    /// Check if private vulnerability reporting is enabled for a repository
    ///
    /// Returns a boolean indicating whether or not private vulnerability reporting is enabled for the repository. For more information, see "[Evaluating the security settings of a repository](https://docs.github.com/code-security/security-advisories/working-with-repository-security-advisories/evaluating-the-security-settings-of-a-repository)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/get(repos/check-private-vulnerability-reporting)`.
    public func reposCheckPrivateVulnerabilityReporting(
        path: Operations.ReposCheckPrivateVulnerabilityReporting.Input.Path,
        headers: Operations.ReposCheckPrivateVulnerabilityReporting.Input.Headers = .init()
    ) async throws -> Operations.ReposCheckPrivateVulnerabilityReporting.Output {
        try await reposCheckPrivateVulnerabilityReporting(Operations.ReposCheckPrivateVulnerabilityReporting.Input(
            path: path,
            headers: headers
        ))
    }
    /// Enable private vulnerability reporting for a repository
    ///
    /// Enables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)."
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/put(repos/enable-private-vulnerability-reporting)`.
    public func reposEnablePrivateVulnerabilityReporting(
        path: Operations.ReposEnablePrivateVulnerabilityReporting.Input.Path,
        headers: Operations.ReposEnablePrivateVulnerabilityReporting.Input.Headers = .init()
    ) async throws -> Operations.ReposEnablePrivateVulnerabilityReporting.Output {
        try await reposEnablePrivateVulnerabilityReporting(Operations.ReposEnablePrivateVulnerabilityReporting.Input(
            path: path,
            headers: headers
        ))
    }
    /// Disable private vulnerability reporting for a repository
    ///
    /// Disables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/private-vulnerability-reporting`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/private-vulnerability-reporting/delete(repos/disable-private-vulnerability-reporting)`.
    public func reposDisablePrivateVulnerabilityReporting(
        path: Operations.ReposDisablePrivateVulnerabilityReporting.Input.Path,
        headers: Operations.ReposDisablePrivateVulnerabilityReporting.Input.Headers = .init()
    ) async throws -> Operations.ReposDisablePrivateVulnerabilityReporting.Output {
        try await reposDisablePrivateVulnerabilityReporting(Operations.ReposDisablePrivateVulnerabilityReporting.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get all custom property values for a repository
    ///
    /// Gets all custom property values that are set for a repository.
    /// Users with read access to the repository can use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/properties/values`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/properties/values/get(repos/get-custom-properties-values)`.
    public func reposGetCustomPropertiesValues(
        path: Operations.ReposGetCustomPropertiesValues.Input.Path,
        headers: Operations.ReposGetCustomPropertiesValues.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCustomPropertiesValues.Output {
        try await reposGetCustomPropertiesValues(Operations.ReposGetCustomPropertiesValues.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update custom property values for a repository
    ///
    /// Create new or update existing custom property values for a repository.
    /// Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.
    ///
    /// Repository admins and other users with the repository-level "edit custom property values" fine-grained permission can use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/properties/values`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/properties/values/patch(repos/create-or-update-custom-properties-values)`.
    public func reposCreateOrUpdateCustomPropertiesValues(
        path: Operations.ReposCreateOrUpdateCustomPropertiesValues.Input.Path,
        headers: Operations.ReposCreateOrUpdateCustomPropertiesValues.Input.Headers = .init(),
        body: Operations.ReposCreateOrUpdateCustomPropertiesValues.Input.Body
    ) async throws -> Operations.ReposCreateOrUpdateCustomPropertiesValues.Output {
        try await reposCreateOrUpdateCustomPropertiesValues(Operations.ReposCreateOrUpdateCustomPropertiesValues.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a repository README
    ///
    /// Gets the preferred README for a repository.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
    /// - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/readme`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/readme/get(repos/get-readme)`.
    public func reposGetReadme(
        path: Operations.ReposGetReadme.Input.Path,
        query: Operations.ReposGetReadme.Input.Query = .init(),
        headers: Operations.ReposGetReadme.Input.Headers = .init()
    ) async throws -> Operations.ReposGetReadme.Output {
        try await reposGetReadme(Operations.ReposGetReadme.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository README for a directory
    ///
    /// Gets the README from a repository directory.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
    /// - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/readme/{dir}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/readme/{dir}/get(repos/get-readme-in-directory)`.
    public func reposGetReadmeInDirectory(
        path: Operations.ReposGetReadmeInDirectory.Input.Path,
        query: Operations.ReposGetReadmeInDirectory.Input.Query = .init(),
        headers: Operations.ReposGetReadmeInDirectory.Input.Headers = .init()
    ) async throws -> Operations.ReposGetReadmeInDirectory.Output {
        try await reposGetReadmeInDirectory(Operations.ReposGetReadmeInDirectory.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List releases
    ///
    /// This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/repos/repos#list-repository-tags).
    ///
    /// Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/get(repos/list-releases)`.
    public func reposListReleases(
        path: Operations.ReposListReleases.Input.Path,
        query: Operations.ReposListReleases.Input.Query = .init(),
        headers: Operations.ReposListReleases.Input.Headers = .init()
    ) async throws -> Operations.ReposListReleases.Output {
        try await reposListReleases(Operations.ReposListReleases.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a release
    ///
    /// Users with push access to the repository can create a release.
    ///
    /// This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/post(repos/create-release)`.
    public func reposCreateRelease(
        path: Operations.ReposCreateRelease.Input.Path,
        headers: Operations.ReposCreateRelease.Input.Headers = .init(),
        body: Operations.ReposCreateRelease.Input.Body
    ) async throws -> Operations.ReposCreateRelease.Output {
        try await reposCreateRelease(Operations.ReposCreateRelease.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get a release asset
    ///
    /// To download the asset's binary content:
    ///
    /// - If within a browser, fetch the location specified in the `browser_download_url` key provided in the response.
    /// - Alternatively, set the `Accept` header of the request to 
    ///   [`application/octet-stream`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types). 
    ///   The API will either redirect the client to the location, or stream it directly if possible.
    ///   API clients should handle both a `200` or `302` response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/get(repos/get-release-asset)`.
    public func reposGetReleaseAsset(
        path: Operations.ReposGetReleaseAsset.Input.Path,
        headers: Operations.ReposGetReleaseAsset.Input.Headers = .init()
    ) async throws -> Operations.ReposGetReleaseAsset.Output {
        try await reposGetReleaseAsset(Operations.ReposGetReleaseAsset.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a release asset
    ///
    /// Users with push access to the repository can edit a release asset.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/patch(repos/update-release-asset)`.
    public func reposUpdateReleaseAsset(
        path: Operations.ReposUpdateReleaseAsset.Input.Path,
        headers: Operations.ReposUpdateReleaseAsset.Input.Headers = .init(),
        body: Operations.ReposUpdateReleaseAsset.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateReleaseAsset.Output {
        try await reposUpdateReleaseAsset(Operations.ReposUpdateReleaseAsset.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a release asset
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/assets/{asset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/assets/{asset_id}/delete(repos/delete-release-asset)`.
    public func reposDeleteReleaseAsset(path: Operations.ReposDeleteReleaseAsset.Input.Path) async throws -> Operations.ReposDeleteReleaseAsset.Output {
        try await reposDeleteReleaseAsset(Operations.ReposDeleteReleaseAsset.Input(path: path))
    }
    /// Generate release notes content for a release
    ///
    /// Generate a name and body describing a [release](https://docs.github.com/rest/releases/releases#get-a-release). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/generate-notes`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/generate-notes/post(repos/generate-release-notes)`.
    public func reposGenerateReleaseNotes(
        path: Operations.ReposGenerateReleaseNotes.Input.Path,
        headers: Operations.ReposGenerateReleaseNotes.Input.Headers = .init(),
        body: Operations.ReposGenerateReleaseNotes.Input.Body
    ) async throws -> Operations.ReposGenerateReleaseNotes.Output {
        try await reposGenerateReleaseNotes(Operations.ReposGenerateReleaseNotes.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get the latest release
    ///
    /// View the latest published full release for the repository.
    ///
    /// The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/latest`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/latest/get(repos/get-latest-release)`.
    public func reposGetLatestRelease(
        path: Operations.ReposGetLatestRelease.Input.Path,
        headers: Operations.ReposGetLatestRelease.Input.Headers = .init()
    ) async throws -> Operations.ReposGetLatestRelease.Output {
        try await reposGetLatestRelease(Operations.ReposGetLatestRelease.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a release by tag name
    ///
    /// Get a published release with the specified tag.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/tags/{tag}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/tags/{tag}/get(repos/get-release-by-tag)`.
    public func reposGetReleaseByTag(
        path: Operations.ReposGetReleaseByTag.Input.Path,
        headers: Operations.ReposGetReleaseByTag.Input.Headers = .init()
    ) async throws -> Operations.ReposGetReleaseByTag.Output {
        try await reposGetReleaseByTag(Operations.ReposGetReleaseByTag.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a release
    ///
    /// Gets a public release with the specified release ID.
    ///
    /// > [!NOTE]
    /// > This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a hypermedia resource. For more information, see "[Getting started with the REST API](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/get(repos/get-release)`.
    public func reposGetRelease(
        path: Operations.ReposGetRelease.Input.Path,
        headers: Operations.ReposGetRelease.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRelease.Output {
        try await reposGetRelease(Operations.ReposGetRelease.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a release
    ///
    /// Users with push access to the repository can edit a release.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/patch(repos/update-release)`.
    public func reposUpdateRelease(
        path: Operations.ReposUpdateRelease.Input.Path,
        headers: Operations.ReposUpdateRelease.Input.Headers = .init(),
        body: Operations.ReposUpdateRelease.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateRelease.Output {
        try await reposUpdateRelease(Operations.ReposUpdateRelease.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a release
    ///
    /// Users with push access to the repository can delete a release.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/releases/{release_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/delete(repos/delete-release)`.
    public func reposDeleteRelease(path: Operations.ReposDeleteRelease.Input.Path) async throws -> Operations.ReposDeleteRelease.Output {
        try await reposDeleteRelease(Operations.ReposDeleteRelease.Input(path: path))
    }
    /// List release assets
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/releases/{release_id}/assets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/assets/get(repos/list-release-assets)`.
    public func reposListReleaseAssets(
        path: Operations.ReposListReleaseAssets.Input.Path,
        query: Operations.ReposListReleaseAssets.Input.Query = .init(),
        headers: Operations.ReposListReleaseAssets.Input.Headers = .init()
    ) async throws -> Operations.ReposListReleaseAssets.Output {
        try await reposListReleaseAssets(Operations.ReposListReleaseAssets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Upload a release asset
    ///
    /// This endpoint makes use of a [Hypermedia relation](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
    /// the response of the [Create a release endpoint](https://docs.github.com/rest/releases/releases#create-a-release) to upload a release asset.
    ///
    /// You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
    ///
    /// Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example: 
    ///
    /// `application/zip`
    ///
    /// GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
    /// you'll still need to pass your authentication to be able to upload an asset.
    ///
    /// When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
    ///
    /// **Notes:**
    /// *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List release assets](https://docs.github.com/rest/releases/assets#list-release-assets)"
    /// endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
    /// *   To find the `release_id` query the [`GET /repos/{owner}/{repo}/releases/latest` endpoint](https://docs.github.com/rest/releases/releases#get-the-latest-release). 
    /// *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/releases/{release_id}/assets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/releases/{release_id}/assets/post(repos/upload-release-asset)`.
    public func reposUploadReleaseAsset(
        path: Operations.ReposUploadReleaseAsset.Input.Path,
        query: Operations.ReposUploadReleaseAsset.Input.Query,
        headers: Operations.ReposUploadReleaseAsset.Input.Headers = .init(),
        body: Operations.ReposUploadReleaseAsset.Input.Body? = nil
    ) async throws -> Operations.ReposUploadReleaseAsset.Output {
        try await reposUploadReleaseAsset(Operations.ReposUploadReleaseAsset.Input(
            path: path,
            query: query,
            headers: headers,
            body: body
        ))
    }
    /// Get rules for a branch
    ///
    /// Returns all active rules that apply to the specified branch. The branch does not need to exist; rules that would apply
    /// to a branch with that name will be returned. All active rules that apply will be returned, regardless of the level
    /// at which they are configured (e.g. repository or organization). Rules in rulesets with "evaluate" or "disabled"
    /// enforcement statuses are not returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rules/branches/{branch}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rules/branches/{branch}/get(repos/get-branch-rules)`.
    public func reposGetBranchRules(
        path: Operations.ReposGetBranchRules.Input.Path,
        query: Operations.ReposGetBranchRules.Input.Query = .init(),
        headers: Operations.ReposGetBranchRules.Input.Headers = .init()
    ) async throws -> Operations.ReposGetBranchRules.Output {
        try await reposGetBranchRules(Operations.ReposGetBranchRules.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get all repository rulesets
    ///
    /// Get all the rulesets for a repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/get(repos/get-repo-rulesets)`.
    public func reposGetRepoRulesets(
        path: Operations.ReposGetRepoRulesets.Input.Path,
        query: Operations.ReposGetRepoRulesets.Input.Query = .init(),
        headers: Operations.ReposGetRepoRulesets.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRulesets.Output {
        try await reposGetRepoRulesets(Operations.ReposGetRepoRulesets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a repository ruleset
    ///
    /// Create a ruleset for a repository.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/rulesets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/post(repos/create-repo-ruleset)`.
    public func reposCreateRepoRuleset(
        path: Operations.ReposCreateRepoRuleset.Input.Path,
        headers: Operations.ReposCreateRepoRuleset.Input.Headers = .init(),
        body: Operations.ReposCreateRepoRuleset.Input.Body
    ) async throws -> Operations.ReposCreateRepoRuleset.Output {
        try await reposCreateRepoRuleset(Operations.ReposCreateRepoRuleset.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository rule suites
    ///
    /// Lists suites of rule evaluations at the repository level.
    /// For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/rule-suites`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/rule-suites/get(repos/get-repo-rule-suites)`.
    public func reposGetRepoRuleSuites(
        path: Operations.ReposGetRepoRuleSuites.Input.Path,
        query: Operations.ReposGetRepoRuleSuites.Input.Query = .init(),
        headers: Operations.ReposGetRepoRuleSuites.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRuleSuites.Output {
        try await reposGetRepoRuleSuites(Operations.ReposGetRepoRuleSuites.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository rule suite
    ///
    /// Gets information about a suite of rule evaluations from within a repository.
    /// For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}/get(repos/get-repo-rule-suite)`.
    public func reposGetRepoRuleSuite(
        path: Operations.ReposGetRepoRuleSuite.Input.Path,
        headers: Operations.ReposGetRepoRuleSuite.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRuleSuite.Output {
        try await reposGetRepoRuleSuite(Operations.ReposGetRepoRuleSuite.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository ruleset
    ///
    /// Get a ruleset for a repository.
    ///
    /// **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
    /// making the API request has write access to the ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/get(repos/get-repo-ruleset)`.
    public func reposGetRepoRuleset(
        path: Operations.ReposGetRepoRuleset.Input.Path,
        query: Operations.ReposGetRepoRuleset.Input.Query = .init(),
        headers: Operations.ReposGetRepoRuleset.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRuleset.Output {
        try await reposGetRepoRuleset(Operations.ReposGetRepoRuleset.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Update a repository ruleset
    ///
    /// Update a ruleset for a repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/put(repos/update-repo-ruleset)`.
    public func reposUpdateRepoRuleset(
        path: Operations.ReposUpdateRepoRuleset.Input.Path,
        headers: Operations.ReposUpdateRepoRuleset.Input.Headers = .init(),
        body: Operations.ReposUpdateRepoRuleset.Input.Body? = nil
    ) async throws -> Operations.ReposUpdateRepoRuleset.Output {
        try await reposUpdateRepoRuleset(Operations.ReposUpdateRepoRuleset.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository ruleset
    ///
    /// Delete a ruleset for a repository.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/rulesets/{ruleset_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/delete(repos/delete-repo-ruleset)`.
    public func reposDeleteRepoRuleset(
        path: Operations.ReposDeleteRepoRuleset.Input.Path,
        headers: Operations.ReposDeleteRepoRuleset.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteRepoRuleset.Output {
        try await reposDeleteRepoRuleset(Operations.ReposDeleteRepoRuleset.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get repository ruleset history
    ///
    /// Get the history of a repository ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/history/get(repos/get-repo-ruleset-history)`.
    public func reposGetRepoRulesetHistory(
        path: Operations.ReposGetRepoRulesetHistory.Input.Path,
        query: Operations.ReposGetRepoRulesetHistory.Input.Query = .init(),
        headers: Operations.ReposGetRepoRulesetHistory.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRulesetHistory.Output {
        try await reposGetRepoRulesetHistory(Operations.ReposGetRepoRulesetHistory.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get repository ruleset version
    ///
    /// Get a version of a repository ruleset.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}/get(repos/get-repo-ruleset-version)`.
    public func reposGetRepoRulesetVersion(
        path: Operations.ReposGetRepoRulesetVersion.Input.Path,
        headers: Operations.ReposGetRepoRulesetVersion.Input.Headers = .init()
    ) async throws -> Operations.ReposGetRepoRulesetVersion.Output {
        try await reposGetRepoRulesetVersion(Operations.ReposGetRepoRulesetVersion.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the weekly commit activity
    ///
    /// Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
    ///
    /// > [!NOTE]
    /// > This endpoint can only be used for repositories with fewer than 10,000 commits. If the repository contains 10,000 or more commits, a 422 status code will be returned.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/code_frequency`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/code_frequency/get(repos/get-code-frequency-stats)`.
    public func reposGetCodeFrequencyStats(
        path: Operations.ReposGetCodeFrequencyStats.Input.Path,
        headers: Operations.ReposGetCodeFrequencyStats.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCodeFrequencyStats.Output {
        try await reposGetCodeFrequencyStats(Operations.ReposGetCodeFrequencyStats.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the last year of commit activity
    ///
    /// Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/commit_activity`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/commit_activity/get(repos/get-commit-activity-stats)`.
    public func reposGetCommitActivityStats(
        path: Operations.ReposGetCommitActivityStats.Input.Path,
        headers: Operations.ReposGetCommitActivityStats.Input.Headers = .init()
    ) async throws -> Operations.ReposGetCommitActivityStats.Output {
        try await reposGetCommitActivityStats(Operations.ReposGetCommitActivityStats.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get all contributor commit activity
    ///
    ///
    /// Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
    ///
    /// *   `w` - Start of the week, given as a [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time).
    /// *   `a` - Number of additions
    /// *   `d` - Number of deletions
    /// *   `c` - Number of commits
    ///
    /// > [!NOTE]
    /// > This endpoint will return `0` values for all addition and deletion counts in repositories with 10,000 or more commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/contributors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/contributors/get(repos/get-contributors-stats)`.
    public func reposGetContributorsStats(
        path: Operations.ReposGetContributorsStats.Input.Path,
        headers: Operations.ReposGetContributorsStats.Input.Headers = .init()
    ) async throws -> Operations.ReposGetContributorsStats.Output {
        try await reposGetContributorsStats(Operations.ReposGetContributorsStats.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the weekly commit count
    ///
    /// Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
    ///
    /// The array order is oldest week (index 0) to most recent week.
    ///
    /// The most recent week is seven days ago at UTC midnight to today at UTC midnight.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/participation`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/participation/get(repos/get-participation-stats)`.
    public func reposGetParticipationStats(
        path: Operations.ReposGetParticipationStats.Input.Path,
        headers: Operations.ReposGetParticipationStats.Input.Headers = .init()
    ) async throws -> Operations.ReposGetParticipationStats.Output {
        try await reposGetParticipationStats(Operations.ReposGetParticipationStats.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the hourly commit count for each day
    ///
    /// Each array contains the day number, hour number, and number of commits:
    ///
    /// *   `0-6`: Sunday - Saturday
    /// *   `0-23`: Hour of day
    /// *   Number of commits
    ///
    /// For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/stats/punch_card`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/stats/punch_card/get(repos/get-punch-card-stats)`.
    public func reposGetPunchCardStats(
        path: Operations.ReposGetPunchCardStats.Input.Path,
        headers: Operations.ReposGetPunchCardStats.Input.Headers = .init()
    ) async throws -> Operations.ReposGetPunchCardStats.Output {
        try await reposGetPunchCardStats(Operations.ReposGetPunchCardStats.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a commit status
    ///
    /// Users with push access in a repository can create commit statuses for a given SHA.
    ///
    /// Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/statuses/{sha}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/statuses/{sha}/post(repos/create-commit-status)`.
    public func reposCreateCommitStatus(
        path: Operations.ReposCreateCommitStatus.Input.Path,
        headers: Operations.ReposCreateCommitStatus.Input.Headers = .init(),
        body: Operations.ReposCreateCommitStatus.Input.Body
    ) async throws -> Operations.ReposCreateCommitStatus.Output {
        try await reposCreateCommitStatus(Operations.ReposCreateCommitStatus.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository tags
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tags`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/get(repos/list-tags)`.
    public func reposListTags(
        path: Operations.ReposListTags.Input.Path,
        query: Operations.ReposListTags.Input.Query = .init(),
        headers: Operations.ReposListTags.Input.Headers = .init()
    ) async throws -> Operations.ReposListTags.Output {
        try await reposListTags(Operations.ReposListTags.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Closing down - List tag protection states for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#get-all-repository-rulesets)" endpoint instead.
    ///
    /// This returns the tag protection states of a repository.
    ///
    /// This information is only available to repository administrators.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tags/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/get(repos/list-tag-protection)`.
    @available(*, deprecated)
    public func reposListTagProtection(
        path: Operations.ReposListTagProtection.Input.Path,
        headers: Operations.ReposListTagProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposListTagProtection.Output {
        try await reposListTagProtection(Operations.ReposListTagProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Closing down - Create a tag protection state for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#create-a-repository-ruleset)" endpoint instead.
    ///
    /// This creates a tag protection state for a repository.
    /// This endpoint is only available to repository administrators.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/tags/protection`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/post(repos/create-tag-protection)`.
    @available(*, deprecated)
    public func reposCreateTagProtection(
        path: Operations.ReposCreateTagProtection.Input.Path,
        headers: Operations.ReposCreateTagProtection.Input.Headers = .init(),
        body: Operations.ReposCreateTagProtection.Input.Body
    ) async throws -> Operations.ReposCreateTagProtection.Output {
        try await reposCreateTagProtection(Operations.ReposCreateTagProtection.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Closing down - Delete a tag protection state for a repository
    ///
    /// > [!WARNING]
    /// > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset)" endpoint instead.
    ///
    /// This deletes a tag protection state for a repository.
    /// This endpoint is only available to repository administrators.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/tags/protection/{tag_protection_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tags/protection/{tag_protection_id}/delete(repos/delete-tag-protection)`.
    @available(*, deprecated)
    public func reposDeleteTagProtection(
        path: Operations.ReposDeleteTagProtection.Input.Path,
        headers: Operations.ReposDeleteTagProtection.Input.Headers = .init()
    ) async throws -> Operations.ReposDeleteTagProtection.Output {
        try await reposDeleteTagProtection(Operations.ReposDeleteTagProtection.Input(
            path: path,
            headers: headers
        ))
    }
    /// Download a repository archive (tar)
    ///
    /// Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    ///
    /// > [!NOTE]
    /// > For private repositories, these links are temporary and expire after five minutes.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/tarball/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/tarball/{ref}/get(repos/download-tarball-archive)`.
    public func reposDownloadTarballArchive(path: Operations.ReposDownloadTarballArchive.Input.Path) async throws -> Operations.ReposDownloadTarballArchive.Output {
        try await reposDownloadTarballArchive(Operations.ReposDownloadTarballArchive.Input(path: path))
    }
    /// List repository teams
    ///
    /// Lists the teams that have access to the specified repository and that are also visible to the authenticated user.
    ///
    /// For a public repository, a team is listed only if that team added the public repository explicitly.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to use this endpoint with a public repository, and `repo` scope to use this endpoint with a private repository.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/teams`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/teams/get(repos/list-teams)`.
    public func reposListTeams(
        path: Operations.ReposListTeams.Input.Path,
        query: Operations.ReposListTeams.Input.Query = .init(),
        headers: Operations.ReposListTeams.Input.Headers = .init()
    ) async throws -> Operations.ReposListTeams.Output {
        try await reposListTeams(Operations.ReposListTeams.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get all repository topics
    ///
    ///
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/topics`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/topics/get(repos/get-all-topics)`.
    public func reposGetAllTopics(
        path: Operations.ReposGetAllTopics.Input.Path,
        query: Operations.ReposGetAllTopics.Input.Query = .init(),
        headers: Operations.ReposGetAllTopics.Input.Headers = .init()
    ) async throws -> Operations.ReposGetAllTopics.Output {
        try await reposGetAllTopics(Operations.ReposGetAllTopics.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Replace all repository topics
    ///
    ///
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/topics`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/topics/put(repos/replace-all-topics)`.
    public func reposReplaceAllTopics(
        path: Operations.ReposReplaceAllTopics.Input.Path,
        headers: Operations.ReposReplaceAllTopics.Input.Headers = .init(),
        body: Operations.ReposReplaceAllTopics.Input.Body
    ) async throws -> Operations.ReposReplaceAllTopics.Output {
        try await reposReplaceAllTopics(Operations.ReposReplaceAllTopics.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get repository clones
    ///
    /// Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/clones`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/clones/get(repos/get-clones)`.
    public func reposGetClones(
        path: Operations.ReposGetClones.Input.Path,
        query: Operations.ReposGetClones.Input.Query = .init(),
        headers: Operations.ReposGetClones.Input.Headers = .init()
    ) async throws -> Operations.ReposGetClones.Output {
        try await reposGetClones(Operations.ReposGetClones.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get top referral paths
    ///
    /// Get the top 10 popular contents over the last 14 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/popular/paths`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/popular/paths/get(repos/get-top-paths)`.
    public func reposGetTopPaths(
        path: Operations.ReposGetTopPaths.Input.Path,
        headers: Operations.ReposGetTopPaths.Input.Headers = .init()
    ) async throws -> Operations.ReposGetTopPaths.Output {
        try await reposGetTopPaths(Operations.ReposGetTopPaths.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get top referral sources
    ///
    /// Get the top 10 referrers over the last 14 days.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/popular/referrers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/popular/referrers/get(repos/get-top-referrers)`.
    public func reposGetTopReferrers(
        path: Operations.ReposGetTopReferrers.Input.Path,
        headers: Operations.ReposGetTopReferrers.Input.Headers = .init()
    ) async throws -> Operations.ReposGetTopReferrers.Output {
        try await reposGetTopReferrers(Operations.ReposGetTopReferrers.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get page views
    ///
    /// Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/traffic/views`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/traffic/views/get(repos/get-views)`.
    public func reposGetViews(
        path: Operations.ReposGetViews.Input.Path,
        query: Operations.ReposGetViews.Input.Query = .init(),
        headers: Operations.ReposGetViews.Input.Headers = .init()
    ) async throws -> Operations.ReposGetViews.Output {
        try await reposGetViews(Operations.ReposGetViews.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Transfer a repository
    ///
    /// A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/).
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/transfer`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/transfer/post(repos/transfer)`.
    public func reposTransfer(
        path: Operations.ReposTransfer.Input.Path,
        headers: Operations.ReposTransfer.Input.Headers = .init(),
        body: Operations.ReposTransfer.Input.Body
    ) async throws -> Operations.ReposTransfer.Output {
        try await reposTransfer(Operations.ReposTransfer.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Check if vulnerability alerts are enabled for a repository
    ///
    /// Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/get(repos/check-vulnerability-alerts)`.
    public func reposCheckVulnerabilityAlerts(path: Operations.ReposCheckVulnerabilityAlerts.Input.Path) async throws -> Operations.ReposCheckVulnerabilityAlerts.Output {
        try await reposCheckVulnerabilityAlerts(Operations.ReposCheckVulnerabilityAlerts.Input(path: path))
    }
    /// Enable vulnerability alerts
    ///
    /// Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/put(repos/enable-vulnerability-alerts)`.
    public func reposEnableVulnerabilityAlerts(path: Operations.ReposEnableVulnerabilityAlerts.Input.Path) async throws -> Operations.ReposEnableVulnerabilityAlerts.Output {
        try await reposEnableVulnerabilityAlerts(Operations.ReposEnableVulnerabilityAlerts.Input(path: path))
    }
    /// Disable vulnerability alerts
    ///
    /// Disables dependency alerts and the dependency graph for a repository.
    /// The authenticated user must have admin access to the repository. For more information,
    /// see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/vulnerability-alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/vulnerability-alerts/delete(repos/disable-vulnerability-alerts)`.
    public func reposDisableVulnerabilityAlerts(path: Operations.ReposDisableVulnerabilityAlerts.Input.Path) async throws -> Operations.ReposDisableVulnerabilityAlerts.Output {
        try await reposDisableVulnerabilityAlerts(Operations.ReposDisableVulnerabilityAlerts.Input(path: path))
    }
    /// Download a repository archive (zip)
    ///
    /// Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
    /// `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
    /// the `Location` header to make a second `GET` request.
    ///
    /// > [!NOTE]
    /// > For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/zipball/{ref}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/zipball/{ref}/get(repos/download-zipball-archive)`.
    public func reposDownloadZipballArchive(path: Operations.ReposDownloadZipballArchive.Input.Path) async throws -> Operations.ReposDownloadZipballArchive.Output {
        try await reposDownloadZipballArchive(Operations.ReposDownloadZipballArchive.Input(path: path))
    }
    /// Create a repository using a template
    ///
    /// Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/repos/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /repos/{template_owner}/{template_repo}/generate`.
    /// - Remark: Generated from `#/paths//repos/{template_owner}/{template_repo}/generate/post(repos/create-using-template)`.
    public func reposCreateUsingTemplate(
        path: Operations.ReposCreateUsingTemplate.Input.Path,
        headers: Operations.ReposCreateUsingTemplate.Input.Headers = .init(),
        body: Operations.ReposCreateUsingTemplate.Input.Body
    ) async throws -> Operations.ReposCreateUsingTemplate.Output {
        try await reposCreateUsingTemplate(Operations.ReposCreateUsingTemplate.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List public repositories
    ///
    /// Lists all public repositories in the order that they were created.
    ///
    /// Note:
    /// - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
    /// - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of repositories.
    ///
    /// - Remark: HTTP `GET /repositories`.
    /// - Remark: Generated from `#/paths//repositories/get(repos/list-public)`.
    public func reposListPublic(
        query: Operations.ReposListPublic.Input.Query = .init(),
        headers: Operations.ReposListPublic.Input.Headers = .init()
    ) async throws -> Operations.ReposListPublic.Output {
        try await reposListPublic(Operations.ReposListPublic.Input(
            query: query,
            headers: headers
        ))
    }
    /// List repositories for the authenticated user
    ///
    /// Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
    ///
    /// The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
    ///
    /// - Remark: HTTP `GET /user/repos`.
    /// - Remark: Generated from `#/paths//user/repos/get(repos/list-for-authenticated-user)`.
    public func reposListForAuthenticatedUser(
        query: Operations.ReposListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ReposListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ReposListForAuthenticatedUser.Output {
        try await reposListForAuthenticatedUser(Operations.ReposListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a repository for the authenticated user
    ///
    /// Creates a new repository for the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.
    ///
    /// - Remark: HTTP `POST /user/repos`.
    /// - Remark: Generated from `#/paths//user/repos/post(repos/create-for-authenticated-user)`.
    public func reposCreateForAuthenticatedUser(
        headers: Operations.ReposCreateForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.ReposCreateForAuthenticatedUser.Input.Body
    ) async throws -> Operations.ReposCreateForAuthenticatedUser.Output {
        try await reposCreateForAuthenticatedUser(Operations.ReposCreateForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List repository invitations for the authenticated user
    ///
    /// When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
    ///
    /// - Remark: HTTP `GET /user/repository_invitations`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/get(repos/list-invitations-for-authenticated-user)`.
    public func reposListInvitationsForAuthenticatedUser(
        query: Operations.ReposListInvitationsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.ReposListInvitationsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ReposListInvitationsForAuthenticatedUser.Output {
        try await reposListInvitationsForAuthenticatedUser(Operations.ReposListInvitationsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Accept a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `PATCH /user/repository_invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/{invitation_id}/patch(repos/accept-invitation-for-authenticated-user)`.
    public func reposAcceptInvitationForAuthenticatedUser(
        path: Operations.ReposAcceptInvitationForAuthenticatedUser.Input.Path,
        headers: Operations.ReposAcceptInvitationForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ReposAcceptInvitationForAuthenticatedUser.Output {
        try await reposAcceptInvitationForAuthenticatedUser(Operations.ReposAcceptInvitationForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Decline a repository invitation
    ///
    ///
    ///
    /// - Remark: HTTP `DELETE /user/repository_invitations/{invitation_id}`.
    /// - Remark: Generated from `#/paths//user/repository_invitations/{invitation_id}/delete(repos/decline-invitation-for-authenticated-user)`.
    public func reposDeclineInvitationForAuthenticatedUser(
        path: Operations.ReposDeclineInvitationForAuthenticatedUser.Input.Path,
        headers: Operations.ReposDeclineInvitationForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.ReposDeclineInvitationForAuthenticatedUser.Output {
        try await reposDeclineInvitationForAuthenticatedUser(Operations.ReposDeclineInvitationForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories for a user
    ///
    /// Lists public repositories for the specified user.
    ///
    /// - Remark: HTTP `GET /users/{username}/repos`.
    /// - Remark: Generated from `#/paths//users/{username}/repos/get(repos/list-for-user)`.
    public func reposListForUser(
        path: Operations.ReposListForUser.Input.Path,
        query: Operations.ReposListForUser.Input.Query = .init(),
        headers: Operations.ReposListForUser.Input.Headers = .init()
    ) async throws -> Operations.ReposListForUser.Output {
        try await reposListForUser(Operations.ReposListForUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// An enterprise on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/enterprise`.
        public struct Enterprise: Codable, Hashable, Sendable {
            /// A short description of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/enterprise/html_url`.
            public var htmlUrl: Swift.String
            /// The enterprise's website URL.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/website_url`.
            public var websiteUrl: Swift.String?
            /// Unique identifier of the enterprise
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/enterprise/node_id`.
            public var nodeId: Swift.String
            /// The name of the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/name`.
            public var name: Swift.String
            /// The slug url identifier for the enterprise.
            ///
            /// - Remark: Generated from `#/components/schemas/enterprise/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/enterprise/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/enterprise/avatar_url`.
            public var avatarUrl: Swift.String
            /// Creates a new `Enterprise`.
            ///
            /// - Parameters:
            ///   - description: A short description of the enterprise.
            ///   - htmlUrl:
            ///   - websiteUrl: The enterprise's website URL.
            ///   - id: Unique identifier of the enterprise
            ///   - nodeId:
            ///   - name: The name of the enterprise.
            ///   - slug: The slug url identifier for the enterprise.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - avatarUrl:
            public init(
                description: Swift.String? = nil,
                htmlUrl: Swift.String,
                websiteUrl: Swift.String? = nil,
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                avatarUrl: Swift.String
            ) {
                self.description = description
                self.htmlUrl = htmlUrl
                self.websiteUrl = websiteUrl
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.avatarUrl = avatarUrl
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case htmlUrl = "html_url"
                case websiteUrl = "website_url"
                case id
                case nodeId = "node_id"
                case name
                case slug
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case avatarUrl = "avatar_url"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/integration`.
        public struct Integration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/integration/owner`.
            public var owner: Components.Schemas.Integration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/integration/permissions`.
            public var permissions: Components.Schemas.Integration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `Integration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.Integration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.Integration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// The URL to which the payloads will be delivered.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-url`.
        public typealias WebhookConfigUrl = Swift.String
        /// The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-content-type`.
        public typealias WebhookConfigContentType = Swift.String
        /// If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config-secret`.
        public typealias WebhookConfigSecret = Swift.String
        /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl`.
        @frozen public enum WebhookConfigInsecureSsl: Codable, Hashable, Sendable {
            /// Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
            ///
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case1`.
            case case1(Swift.String)
            /// - Remark: Generated from `#/components/schemas/webhook-config-insecure-ssl/case2`.
            case case2(Swift.Double)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .case2(value):
                    try encoder.encodeToSingleValueContainer(value)
                }
            }
        }
        /// Configuration object of the webhook
        ///
        /// - Remark: Generated from `#/components/schemas/webhook-config`.
        public struct WebhookConfig: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/webhook-config/url`.
            public var url: Components.Schemas.WebhookConfigUrl?
            /// - Remark: Generated from `#/components/schemas/webhook-config/content_type`.
            public var contentType: Components.Schemas.WebhookConfigContentType?
            /// - Remark: Generated from `#/components/schemas/webhook-config/secret`.
            public var secret: Components.Schemas.WebhookConfigSecret?
            /// - Remark: Generated from `#/components/schemas/webhook-config/insecure_ssl`.
            public var insecureSsl: Components.Schemas.WebhookConfigInsecureSsl?
            /// Creates a new `WebhookConfig`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - contentType:
            ///   - secret:
            ///   - insecureSsl:
            public init(
                url: Components.Schemas.WebhookConfigUrl? = nil,
                contentType: Components.Schemas.WebhookConfigContentType? = nil,
                secret: Components.Schemas.WebhookConfigSecret? = nil,
                insecureSsl: Components.Schemas.WebhookConfigInsecureSsl? = nil
            ) {
                self.url = url
                self.contentType = contentType
                self.secret = secret
                self.insecureSsl = insecureSsl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case contentType = "content_type"
                case secret
                case insecureSsl = "insecure_ssl"
            }
        }
        /// Delivery made by a webhook, without request and response information.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery-item`.
        public struct HookDeliveryItem: Codable, Hashable, Sendable {
            /// Unique identifier of the webhook delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/id`.
            public var id: Swift.Int64
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/guid`.
            public var guid: Swift.String
            /// Time when the webhook delivery occurred.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the webhook delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/duration`.
            public var duration: Swift.Double
            /// Describes the response returned after attempting the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/installation_id`.
            public var installationId: Swift.Int64?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/repository_id`.
            public var repositoryId: Swift.Int64?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery-item/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// Creates a new `HookDeliveryItem`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the webhook delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the webhook delivery occurred.
            ///   - redelivery: Whether the webhook delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Describes the response returned after attempting the delivery.
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            public init(
                id: Swift.Int64,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int64? = nil,
                repositoryId: Swift.Int64? = nil,
                throttledAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Delivery made by a webhook.
        ///
        /// - Remark: Generated from `#/components/schemas/hook-delivery`.
        public struct HookDelivery: Codable, Hashable, Sendable {
            /// Unique identifier of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/id`.
            public var id: Swift.Int
            /// Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/guid`.
            public var guid: Swift.String
            /// Time when the delivery was delivered.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/delivered_at`.
            public var deliveredAt: Foundation.Date
            /// Whether the delivery is a redelivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/redelivery`.
            public var redelivery: Swift.Bool
            /// Time spent delivering.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/duration`.
            public var duration: Swift.Double
            /// Description of the status of the attempted delivery
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status`.
            public var status: Swift.String
            /// Status code received when delivery was made.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/status_code`.
            public var statusCode: Swift.Int
            /// The event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/event`.
            public var event: Swift.String
            /// The type of activity for the event that triggered the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/action`.
            public var action: Swift.String?
            /// The id of the GitHub App installation associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/installation_id`.
            public var installationId: Swift.Int?
            /// The id of the repository associated with this event.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/repository_id`.
            public var repositoryId: Swift.Int?
            /// Time when the webhook delivery was throttled.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/throttled_at`.
            public var throttledAt: Foundation.Date?
            /// The URL target of the delivery.
            ///
            /// - Remark: Generated from `#/components/schemas/hook-delivery/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public struct RequestPayload: Codable, Hashable, Sendable {
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The request headers sent with the webhook delivery.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/headers`.
                public var headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload?
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public struct PayloadPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `PayloadPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The webhook payload.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/request/payload`.
                public var payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload?
                /// Creates a new `RequestPayload`.
                ///
                /// - Parameters:
                ///   - headers: The request headers sent with the webhook delivery.
                ///   - payload: The webhook payload.
                public init(
                    headers: Components.Schemas.HookDelivery.RequestPayload.HeadersPayload? = nil,
                    payload: Components.Schemas.HookDelivery.RequestPayload.PayloadPayload? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/request`.
            public var request: Components.Schemas.HookDelivery.RequestPayload
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public struct ResponsePayload: Codable, Hashable, Sendable {
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public struct HeadersPayload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `HeadersPayload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// The response headers received when the delivery was made.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/headers`.
                public var headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload?
                /// The response payload received.
                ///
                /// - Remark: Generated from `#/components/schemas/hook-delivery/response/payload`.
                public var payload: Swift.String?
                /// Creates a new `ResponsePayload`.
                ///
                /// - Parameters:
                ///   - headers: The response headers received when the delivery was made.
                ///   - payload: The response payload received.
                public init(
                    headers: Components.Schemas.HookDelivery.ResponsePayload.HeadersPayload? = nil,
                    payload: Swift.String? = nil
                ) {
                    self.headers = headers
                    self.payload = payload
                }
                public enum CodingKeys: String, CodingKey {
                    case headers
                    case payload
                }
            }
            /// - Remark: Generated from `#/components/schemas/hook-delivery/response`.
            public var response: Components.Schemas.HookDelivery.ResponsePayload
            /// Creates a new `HookDelivery`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the delivery.
            ///   - guid: Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
            ///   - deliveredAt: Time when the delivery was delivered.
            ///   - redelivery: Whether the delivery is a redelivery.
            ///   - duration: Time spent delivering.
            ///   - status: Description of the status of the attempted delivery
            ///   - statusCode: Status code received when delivery was made.
            ///   - event: The event that triggered the delivery.
            ///   - action: The type of activity for the event that triggered the delivery.
            ///   - installationId: The id of the GitHub App installation associated with this event.
            ///   - repositoryId: The id of the repository associated with this event.
            ///   - throttledAt: Time when the webhook delivery was throttled.
            ///   - url: The URL target of the delivery.
            ///   - request:
            ///   - response:
            public init(
                id: Swift.Int,
                guid: Swift.String,
                deliveredAt: Foundation.Date,
                redelivery: Swift.Bool,
                duration: Swift.Double,
                status: Swift.String,
                statusCode: Swift.Int,
                event: Swift.String,
                action: Swift.String? = nil,
                installationId: Swift.Int? = nil,
                repositoryId: Swift.Int? = nil,
                throttledAt: Foundation.Date? = nil,
                url: Swift.String? = nil,
                request: Components.Schemas.HookDelivery.RequestPayload,
                response: Components.Schemas.HookDelivery.ResponsePayload
            ) {
                self.id = id
                self.guid = guid
                self.deliveredAt = deliveredAt
                self.redelivery = redelivery
                self.duration = duration
                self.status = status
                self.statusCode = statusCode
                self.event = event
                self.action = action
                self.installationId = installationId
                self.repositoryId = repositoryId
                self.throttledAt = throttledAt
                self.url = url
                self.request = request
                self.response = response
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case guid
                case deliveredAt = "delivered_at"
                case redelivery
                case duration
                case status
                case statusCode = "status_code"
                case event
                case action
                case installationId = "installation_id"
                case repositoryId = "repository_id"
                case throttledAt = "throttled_at"
                case url
                case request
                case response
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// A collection of related issues and pull requests.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-milestone`.
        public struct NullableMilestone: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/node_id`.
            public var nodeId: Swift.String
            /// The number of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/number`.
            public var number: Swift.Int
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case open = "open"
                case closed = "closed"
            }
            /// The state of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/state`.
            public var state: Components.Schemas.NullableMilestone.StatePayload
            /// The title of the milestone.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/title`.
            public var title: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_issues`.
            public var closedIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/closed_at`.
            public var closedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-milestone/due_on`.
            public var dueOn: Foundation.Date?
            /// Creates a new `NullableMilestone`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - htmlUrl:
            ///   - labelsUrl:
            ///   - id:
            ///   - nodeId:
            ///   - number: The number of the milestone.
            ///   - state: The state of the milestone.
            ///   - title: The title of the milestone.
            ///   - description:
            ///   - creator:
            ///   - openIssues:
            ///   - closedIssues:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - closedAt:
            ///   - dueOn:
            public init(
                url: Swift.String,
                htmlUrl: Swift.String,
                labelsUrl: Swift.String,
                id: Swift.Int,
                nodeId: Swift.String,
                number: Swift.Int,
                state: Components.Schemas.NullableMilestone.StatePayload,
                title: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                openIssues: Swift.Int,
                closedIssues: Swift.Int,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                closedAt: Foundation.Date? = nil,
                dueOn: Foundation.Date? = nil
            ) {
                self.url = url
                self.htmlUrl = htmlUrl
                self.labelsUrl = labelsUrl
                self.id = id
                self.nodeId = nodeId
                self.number = number
                self.state = state
                self.title = title
                self.description = description
                self.creator = creator
                self.openIssues = openIssues
                self.closedIssues = closedIssues
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.closedAt = closedAt
                self.dueOn = dueOn
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case htmlUrl = "html_url"
                case labelsUrl = "labels_url"
                case id
                case nodeId = "node_id"
                case number
                case state
                case title
                case description
                case creator
                case openIssues = "open_issues"
                case closedIssues = "closed_issues"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case closedAt = "closed_at"
                case dueOn = "due_on"
            }
        }
        /// GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-integration`.
        public struct NullableIntegration: Codable, Hashable, Sendable {
            /// Unique identifier of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/id`.
            public var id: Swift.Int
            /// The slug name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/slug`.
            public var slug: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/client_id`.
            public var clientId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            @frozen public enum OwnerPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/nullable-integration/owner/case2`.
                case Enterprise(Components.Schemas.Enterprise)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .Enterprise(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .Enterprise(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-integration/owner`.
            public var owner: Components.Schemas.NullableIntegration.OwnerPayload
            /// The name of the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-integration/external_url`.
            public var externalUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-integration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/nullable-integration/updated_at`.
            public var updatedAt: Foundation.Date
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/issues`.
                public var issues: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/checks`.
                public var checks: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/metadata`.
                public var metadata: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/contents`.
                public var contents: Swift.String?
                /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions/deployments`.
                public var deployments: Swift.String?
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.String]
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - issues:
                ///   - checks:
                ///   - metadata:
                ///   - contents:
                ///   - deployments:
                ///   - additionalProperties: A container of undocumented properties.
                public init(
                    issues: Swift.String? = nil,
                    checks: Swift.String? = nil,
                    metadata: Swift.String? = nil,
                    contents: Swift.String? = nil,
                    deployments: Swift.String? = nil,
                    additionalProperties: [String: Swift.String] = .init()
                ) {
                    self.issues = issues
                    self.checks = checks
                    self.metadata = metadata
                    self.contents = contents
                    self.deployments = deployments
                    self.additionalProperties = additionalProperties
                }
                public enum CodingKeys: String, CodingKey {
                    case issues
                    case checks
                    case metadata
                    case contents
                    case deployments
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.issues = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .issues
                    )
                    self.checks = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .checks
                    )
                    self.metadata = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .metadata
                    )
                    self.contents = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .contents
                    )
                    self.deployments = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .deployments
                    )
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [
                        "issues",
                        "checks",
                        "metadata",
                        "contents",
                        "deployments"
                    ])
                }
                public func encode(to encoder: any Encoder) throws {
                    var container = encoder.container(keyedBy: CodingKeys.self)
                    try container.encodeIfPresent(
                        self.issues,
                        forKey: .issues
                    )
                    try container.encodeIfPresent(
                        self.checks,
                        forKey: .checks
                    )
                    try container.encodeIfPresent(
                        self.metadata,
                        forKey: .metadata
                    )
                    try container.encodeIfPresent(
                        self.contents,
                        forKey: .contents
                    )
                    try container.encodeIfPresent(
                        self.deployments,
                        forKey: .deployments
                    )
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The set of permissions for the GitHub app
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/permissions`.
            public var permissions: Components.Schemas.NullableIntegration.PermissionsPayload
            /// The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/events`.
            public var events: [Swift.String]
            /// The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-integration/installations_count`.
            public var installationsCount: Swift.Int?
            /// Creates a new `NullableIntegration`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the GitHub app
            ///   - slug: The slug name of the GitHub app
            ///   - nodeId:
            ///   - clientId:
            ///   - owner:
            ///   - name: The name of the GitHub app
            ///   - description:
            ///   - externalUrl:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions: The set of permissions for the GitHub app
            ///   - events: The list of events for the GitHub app. Note that the `installation_target`, `security_advisory`, and `meta` events are not included because they are global events and not specific to an installation.
            ///   - installationsCount: The number of installations associated with the GitHub app. Only returned when the integration is requesting details about itself.
            public init(
                id: Swift.Int,
                slug: Swift.String? = nil,
                nodeId: Swift.String,
                clientId: Swift.String? = nil,
                owner: Components.Schemas.NullableIntegration.OwnerPayload,
                name: Swift.String,
                description: Swift.String? = nil,
                externalUrl: Swift.String,
                htmlUrl: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.NullableIntegration.PermissionsPayload,
                events: [Swift.String],
                installationsCount: Swift.Int? = nil
            ) {
                self.id = id
                self.slug = slug
                self.nodeId = nodeId
                self.clientId = clientId
                self.owner = owner
                self.name = name
                self.description = description
                self.externalUrl = externalUrl
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.events = events
                self.installationsCount = installationsCount
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case slug
                case nodeId = "node_id"
                case clientId = "client_id"
                case owner
                case name
                case description
                case externalUrl = "external_url"
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case events
                case installationsCount = "installations_count"
            }
        }
        /// How the author is associated with the repository.
        ///
        /// - Remark: Generated from `#/components/schemas/author-association`.
        @frozen public enum AuthorAssociation: String, Codable, Hashable, Sendable, CaseIterable {
            case collaborator = "COLLABORATOR"
            case contributor = "CONTRIBUTOR"
            case firstTimer = "FIRST_TIMER"
            case firstTimeContributor = "FIRST_TIME_CONTRIBUTOR"
            case mannequin = "MANNEQUIN"
            case member = "MEMBER"
            case none = "NONE"
            case owner = "OWNER"
        }
        /// - Remark: Generated from `#/components/schemas/reaction-rollup`.
        public struct ReactionRollup: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/total_count`.
            public var totalCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/+1`.
            public var _plus_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/-1`.
            public var _hyphen_1: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/laugh`.
            public var laugh: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/confused`.
            public var confused: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/heart`.
            public var heart: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/hooray`.
            public var hooray: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/eyes`.
            public var eyes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/reaction-rollup/rocket`.
            public var rocket: Swift.Int
            /// Creates a new `ReactionRollup`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - totalCount:
            ///   - _plus_1:
            ///   - _hyphen_1:
            ///   - laugh:
            ///   - confused:
            ///   - heart:
            ///   - hooray:
            ///   - eyes:
            ///   - rocket:
            public init(
                url: Swift.String,
                totalCount: Swift.Int,
                _plus_1: Swift.Int,
                _hyphen_1: Swift.Int,
                laugh: Swift.Int,
                confused: Swift.Int,
                heart: Swift.Int,
                hooray: Swift.Int,
                eyes: Swift.Int,
                rocket: Swift.Int
            ) {
                self.url = url
                self.totalCount = totalCount
                self._plus_1 = _plus_1
                self._hyphen_1 = _hyphen_1
                self.laugh = laugh
                self.confused = confused
                self.heart = heart
                self.hooray = hooray
                self.eyes = eyes
                self.rocket = rocket
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case totalCount = "total_count"
                case _plus_1 = "+1"
                case _hyphen_1 = "-1"
                case laugh
                case confused
                case heart
                case hooray
                case eyes
                case rocket
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-team-simple`.
        public struct NullableTeamSimple: Codable, Hashable, Sendable {
            /// Unique identifier of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/node_id`.
            public var nodeId: Swift.String
            /// URL for the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/members_url`.
            public var membersUrl: Swift.String
            /// Name of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/name`.
            public var name: Swift.String
            /// Description of the team
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/description`.
            public var description: Swift.String?
            /// Permission that the team will have for its repositories
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/permission`.
            public var permission: Swift.String
            /// The level of privacy this team should have
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/privacy`.
            public var privacy: Swift.String?
            /// The notification setting the team has set
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/slug`.
            public var slug: Swift.String
            /// Distinguished Name (DN) that team maps to within LDAP environment
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-team-simple/ldap_dn`.
            public var ldapDn: Swift.String?
            /// Creates a new `NullableTeamSimple`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the team
            ///   - nodeId:
            ///   - url: URL for the team
            ///   - membersUrl:
            ///   - name: Name of the team
            ///   - description: Description of the team
            ///   - permission: Permission that the team will have for its repositories
            ///   - privacy: The level of privacy this team should have
            ///   - notificationSetting: The notification setting the team has set
            ///   - htmlUrl:
            ///   - repositoriesUrl:
            ///   - slug:
            ///   - ldapDn: Distinguished Name (DN) that team maps to within LDAP environment
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                url: Swift.String,
                membersUrl: Swift.String,
                name: Swift.String,
                description: Swift.String? = nil,
                permission: Swift.String,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                htmlUrl: Swift.String,
                repositoriesUrl: Swift.String,
                slug: Swift.String,
                ldapDn: Swift.String? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.url = url
                self.membersUrl = membersUrl
                self.name = name
                self.description = description
                self.permission = permission
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.htmlUrl = htmlUrl
                self.repositoriesUrl = repositoriesUrl
                self.slug = slug
                self.ldapDn = ldapDn
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case url
                case membersUrl = "members_url"
                case name
                case description
                case permission
                case privacy
                case notificationSetting = "notification_setting"
                case htmlUrl = "html_url"
                case repositoriesUrl = "repositories_url"
                case slug
                case ldapDn = "ldap_dn"
            }
        }
        /// Groups of organization members that gives permissions on specified repositories.
        ///
        /// - Remark: Generated from `#/components/schemas/team`.
        public struct Team: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/team/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/team/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/slug`.
            public var slug: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/privacy`.
            public var privacy: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/notification_setting`.
            public var notificationSetting: Swift.String?
            /// - Remark: Generated from `#/components/schemas/team/permission`.
            public var permission: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/team/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/triage`.
                public var triage: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/maintain`.
                public var maintain: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/team/permissions/admin`.
                public var admin: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                ///   - admin:
                public init(
                    pull: Swift.Bool,
                    triage: Swift.Bool,
                    push: Swift.Bool,
                    maintain: Swift.Bool,
                    admin: Swift.Bool
                ) {
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                    self.admin = admin
                }
                public enum CodingKeys: String, CodingKey {
                    case pull
                    case triage
                    case push
                    case maintain
                    case admin
                }
            }
            /// - Remark: Generated from `#/components/schemas/team/permissions`.
            public var permissions: Components.Schemas.Team.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/team/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/members_url`.
            public var membersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/repositories_url`.
            public var repositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/team/parent`.
            public var parent: Components.Schemas.NullableTeamSimple?
            /// Creates a new `Team`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - slug:
            ///   - description:
            ///   - privacy:
            ///   - notificationSetting:
            ///   - permission:
            ///   - permissions:
            ///   - url:
            ///   - htmlUrl:
            ///   - membersUrl:
            ///   - repositoriesUrl:
            ///   - parent:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                name: Swift.String,
                slug: Swift.String,
                description: Swift.String? = nil,
                privacy: Swift.String? = nil,
                notificationSetting: Swift.String? = nil,
                permission: Swift.String,
                permissions: Components.Schemas.Team.PermissionsPayload? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                membersUrl: Swift.String,
                repositoriesUrl: Swift.String,
                parent: Components.Schemas.NullableTeamSimple? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.slug = slug
                self.description = description
                self.privacy = privacy
                self.notificationSetting = notificationSetting
                self.permission = permission
                self.permissions = permissions
                self.url = url
                self.htmlUrl = htmlUrl
                self.membersUrl = membersUrl
                self.repositoriesUrl = repositoriesUrl
                self.parent = parent
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case slug
                case description
                case privacy
                case notificationSetting = "notification_setting"
                case permission
                case permissions
                case url
                case htmlUrl = "html_url"
                case membersUrl = "members_url"
                case repositoriesUrl = "repositories_url"
                case parent
            }
        }
        /// Custom property name and associated value
        ///
        /// - Remark: Generated from `#/components/schemas/custom-property-value`.
        public struct CustomPropertyValue: Codable, Hashable, Sendable {
            /// The name of the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/property_name`.
            public var propertyName: Swift.String
            /// The value assigned to the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/value`.
            @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/custom-property-value/value/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/custom-property-value/value/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// The value assigned to the property
            ///
            /// - Remark: Generated from `#/components/schemas/custom-property-value/value`.
            public var value: Components.Schemas.CustomPropertyValue.ValuePayload?
            /// Creates a new `CustomPropertyValue`.
            ///
            /// - Parameters:
            ///   - propertyName: The name of the property
            ///   - value: The value assigned to the property
            public init(
                propertyName: Swift.String,
                value: Components.Schemas.CustomPropertyValue.ValuePayload? = nil
            ) {
                self.propertyName = propertyName
                self.value = value
            }
            public enum CodingKeys: String, CodingKey {
                case propertyName = "property_name"
                case value
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-repository`.
        public struct NullableRepository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public var permissions: Components.Schemas.NullableRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload?
            /// Creates a new `NullableRepository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.NullableRepository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code of Conduct Simple
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple`.
        public struct CodeOfConductSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConductSimple`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - key:
            ///   - name:
            ///   - htmlUrl:
            public init(
                url: Swift.String,
                key: Swift.String,
                name: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.url = url
                self.key = key
                self.name = name
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case key
                case name
                case htmlUrl = "html_url"
            }
        }
        /// Full Repository
        ///
        /// - Remark: Generated from `#/components/schemas/full-repository`.
        public struct FullRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/full-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/full-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/full-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/size`.
            public var size: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/pushed_at`.
            public var pushedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public var permissions: Components.Schemas.FullRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/template_repository`.
            public var templateRepository: Components.Schemas.NullableRepository?
            /// - Remark: Generated from `#/components/schemas/full-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/use_squash_pr_title_as_default`.
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_count`.
            public var subscribersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/network_count`.
            public var networkCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/organization`.
            public var organization: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/full-repository/parent`.
            public var parent: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/source`.
            public var source: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers`.
            public var watchers: Swift.Int
            /// Whether anonymous git access is allowed.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConductSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public var customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload?
            /// Creates a new `FullRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - allowRebaseMerge:
            ///   - templateRepository:
            ///   - tempCloneToken:
            ///   - allowSquashMerge:
            ///   - allowAutoMerge:
            ///   - deleteBranchOnMerge:
            ///   - allowMergeCommit:
            ///   - allowUpdateBranch:
            ///   - useSquashPrTitleAsDefault:
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - license:
            ///   - organization:
            ///   - parent:
            ///   - source:
            ///   - forks:
            ///   - masterBranch:
            ///   - openIssues:
            ///   - watchers:
            ///   - anonymousAccessEnabled: Whether anonymous git access is allowed.
            ///   - codeOfConduct:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.FullRepository.PermissionsPayload? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                templateRepository: Components.Schemas.NullableRepository? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                subscribersCount: Swift.Int,
                networkCount: Swift.Int,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                organization: Components.Schemas.NullableSimpleUser? = nil,
                parent: Components.Schemas.Repository? = nil,
                source: Components.Schemas.Repository? = nil,
                forks: Swift.Int,
                masterBranch: Swift.String? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeOfConduct: Components.Schemas.CodeOfConductSimple? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.allowRebaseMerge = allowRebaseMerge
                self.templateRepository = templateRepository
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowMergeCommit = allowMergeCommit
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.license = license
                self.organization = organization
                self.parent = parent
                self.source = source
                self.forks = forks
                self.masterBranch = masterBranch
                self.openIssues = openIssues
                self.watchers = watchers
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeOfConduct = codeOfConduct
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case allowRebaseMerge = "allow_rebase_merge"
                case templateRepository = "template_repository"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowMergeCommit = "allow_merge_commit"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case license
                case organization
                case parent
                case source
                case forks
                case masterBranch = "master_branch"
                case openIssues = "open_issues"
                case watchers
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeOfConduct = "code_of_conduct"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-enforcement`.
        @frozen public enum RepositoryRuleEnforcement: String, Codable, Hashable, Sendable, CaseIterable {
            case disabled = "disabled"
            case active = "active"
            case evaluate = "evaluate"
        }
        /// An actor that can bypass rules in a ruleset
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor`.
        public struct RepositoryRulesetBypassActor: Codable, Hashable, Sendable {
            /// The ID of the actor that can bypass a ruleset. Required for `Integration`, `RepositoryRole`, and `Team` actor types. If `actor_type` is `OrganizationAdmin`, this should be `1`. If `actor_type` is `DeployKey`, this should be null. `OrganizationAdmin` is not applicable for personal repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor/actor_id`.
            public var actorId: Swift.Int?
            /// The type of actor that can bypass a ruleset.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor/actor_type`.
            @frozen public enum ActorTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case integration = "Integration"
                case organizationAdmin = "OrganizationAdmin"
                case repositoryRole = "RepositoryRole"
                case team = "Team"
                case deployKey = "DeployKey"
            }
            /// The type of actor that can bypass a ruleset.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor/actor_type`.
            public var actorType: Components.Schemas.RepositoryRulesetBypassActor.ActorTypePayload
            /// When the specified actor can bypass the ruleset. `pull_request` means that an actor can only bypass rules on pull requests. `pull_request` is not applicable for the `DeployKey` actor type. Also, `pull_request` is only applicable to branch rulesets.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor/bypass_mode`.
            @frozen public enum BypassModePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case always = "always"
                case pullRequest = "pull_request"
            }
            /// When the specified actor can bypass the ruleset. `pull_request` means that an actor can only bypass rules on pull requests. `pull_request` is not applicable for the `DeployKey` actor type. Also, `pull_request` is only applicable to branch rulesets.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-bypass-actor/bypass_mode`.
            public var bypassMode: Components.Schemas.RepositoryRulesetBypassActor.BypassModePayload?
            /// Creates a new `RepositoryRulesetBypassActor`.
            ///
            /// - Parameters:
            ///   - actorId: The ID of the actor that can bypass a ruleset. Required for `Integration`, `RepositoryRole`, and `Team` actor types. If `actor_type` is `OrganizationAdmin`, this should be `1`. If `actor_type` is `DeployKey`, this should be null. `OrganizationAdmin` is not applicable for personal repositories.
            ///   - actorType: The type of actor that can bypass a ruleset.
            ///   - bypassMode: When the specified actor can bypass the ruleset. `pull_request` means that an actor can only bypass rules on pull requests. `pull_request` is not applicable for the `DeployKey` actor type. Also, `pull_request` is only applicable to branch rulesets.
            public init(
                actorId: Swift.Int? = nil,
                actorType: Components.Schemas.RepositoryRulesetBypassActor.ActorTypePayload,
                bypassMode: Components.Schemas.RepositoryRulesetBypassActor.BypassModePayload? = nil
            ) {
                self.actorId = actorId
                self.actorType = actorType
                self.bypassMode = bypassMode
            }
            public enum CodingKeys: String, CodingKey {
                case actorId = "actor_id"
                case actorType = "actor_type"
                case bypassMode = "bypass_mode"
            }
        }
        /// Parameters for a repository ruleset ref name condition
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions`.
        public struct RepositoryRulesetConditions: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions/ref_name`.
            public struct RefNamePayload: Codable, Hashable, Sendable {
                /// Array of ref names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~DEFAULT_BRANCH` to include the default branch or `~ALL` to include all branches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions/ref_name/include`.
                public var include: [Swift.String]?
                /// Array of ref names or patterns to exclude. The condition will not pass if any of these patterns match.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions/ref_name/exclude`.
                public var exclude: [Swift.String]?
                /// Creates a new `RefNamePayload`.
                ///
                /// - Parameters:
                ///   - include: Array of ref names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~DEFAULT_BRANCH` to include the default branch or `~ALL` to include all branches.
                ///   - exclude: Array of ref names or patterns to exclude. The condition will not pass if any of these patterns match.
                public init(
                    include: [Swift.String]? = nil,
                    exclude: [Swift.String]? = nil
                ) {
                    self.include = include
                    self.exclude = exclude
                }
                public enum CodingKeys: String, CodingKey {
                    case include
                    case exclude
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions/ref_name`.
            public var refName: Components.Schemas.RepositoryRulesetConditions.RefNamePayload?
            /// Creates a new `RepositoryRulesetConditions`.
            ///
            /// - Parameters:
            ///   - refName:
            public init(refName: Components.Schemas.RepositoryRulesetConditions.RefNamePayload? = nil) {
                self.refName = refName
            }
            public enum CodingKeys: String, CodingKey {
                case refName = "ref_name"
            }
        }
        /// Parameters for a repository name condition
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target`.
        public struct RepositoryRulesetConditionsRepositoryNameTarget: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target/repository_name`.
            public struct RepositoryNamePayload: Codable, Hashable, Sendable {
                /// Array of repository names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~ALL` to include all repositories.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target/repository_name/include`.
                public var include: [Swift.String]?
                /// Array of repository names or patterns to exclude. The condition will not pass if any of these patterns match.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target/repository_name/exclude`.
                public var exclude: [Swift.String]?
                /// Whether renaming of target repositories is prevented.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target/repository_name/protected`.
                public var protected: Swift.Bool?
                /// Creates a new `RepositoryNamePayload`.
                ///
                /// - Parameters:
                ///   - include: Array of repository names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~ALL` to include all repositories.
                ///   - exclude: Array of repository names or patterns to exclude. The condition will not pass if any of these patterns match.
                ///   - protected: Whether renaming of target repositories is prevented.
                public init(
                    include: [Swift.String]? = nil,
                    exclude: [Swift.String]? = nil,
                    protected: Swift.Bool? = nil
                ) {
                    self.include = include
                    self.exclude = exclude
                    self.protected = protected
                }
                public enum CodingKeys: String, CodingKey {
                    case include
                    case exclude
                    case protected
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-name-target/repository_name`.
            public var repositoryName: Components.Schemas.RepositoryRulesetConditionsRepositoryNameTarget.RepositoryNamePayload
            /// Creates a new `RepositoryRulesetConditionsRepositoryNameTarget`.
            ///
            /// - Parameters:
            ///   - repositoryName:
            public init(repositoryName: Components.Schemas.RepositoryRulesetConditionsRepositoryNameTarget.RepositoryNamePayload) {
                self.repositoryName = repositoryName
            }
            public enum CodingKeys: String, CodingKey {
                case repositoryName = "repository_name"
            }
        }
        /// Parameters for a repository ID condition
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-id-target`.
        public struct RepositoryRulesetConditionsRepositoryIdTarget: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-id-target/repository_id`.
            public struct RepositoryIdPayload: Codable, Hashable, Sendable {
                /// The repository IDs that the ruleset applies to. One of these IDs must match for the condition to pass.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-id-target/repository_id/repository_ids`.
                public var repositoryIds: [Swift.Int]?
                /// Creates a new `RepositoryIdPayload`.
                ///
                /// - Parameters:
                ///   - repositoryIds: The repository IDs that the ruleset applies to. One of these IDs must match for the condition to pass.
                public init(repositoryIds: [Swift.Int]? = nil) {
                    self.repositoryIds = repositoryIds
                }
                public enum CodingKeys: String, CodingKey {
                    case repositoryIds = "repository_ids"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-id-target/repository_id`.
            public var repositoryId: Components.Schemas.RepositoryRulesetConditionsRepositoryIdTarget.RepositoryIdPayload
            /// Creates a new `RepositoryRulesetConditionsRepositoryIdTarget`.
            ///
            /// - Parameters:
            ///   - repositoryId:
            public init(repositoryId: Components.Schemas.RepositoryRulesetConditionsRepositoryIdTarget.RepositoryIdPayload) {
                self.repositoryId = repositoryId
            }
            public enum CodingKeys: String, CodingKey {
                case repositoryId = "repository_id"
            }
        }
        /// Parameters for a targeting a repository property
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-spec`.
        public struct RepositoryRulesetConditionsRepositoryPropertySpec: Codable, Hashable, Sendable {
            /// The name of the repository property to target
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-spec/name`.
            public var name: Swift.String
            /// The values to match for the repository property
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-spec/property_values`.
            public var propertyValues: [Swift.String]
            /// The source of the repository property. Defaults to 'custom' if not specified.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-spec/source`.
            @frozen public enum SourcePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case custom = "custom"
                case system = "system"
            }
            /// The source of the repository property. Defaults to 'custom' if not specified.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-spec/source`.
            public var source: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec.SourcePayload?
            /// Creates a new `RepositoryRulesetConditionsRepositoryPropertySpec`.
            ///
            /// - Parameters:
            ///   - name: The name of the repository property to target
            ///   - propertyValues: The values to match for the repository property
            ///   - source: The source of the repository property. Defaults to 'custom' if not specified.
            public init(
                name: Swift.String,
                propertyValues: [Swift.String],
                source: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec.SourcePayload? = nil
            ) {
                self.name = name
                self.propertyValues = propertyValues
                self.source = source
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case propertyValues = "property_values"
                case source
            }
        }
        /// Parameters for a repository property condition
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-target`.
        public struct RepositoryRulesetConditionsRepositoryPropertyTarget: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-target/repository_property`.
            public struct RepositoryPropertyPayload: Codable, Hashable, Sendable {
                /// The repository properties and values to include. All of these properties must match for the condition to pass.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-target/repository_property/include`.
                public var include: [Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec]?
                /// The repository properties and values to exclude. The condition will not pass if any of these properties match.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-target/repository_property/exclude`.
                public var exclude: [Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec]?
                /// Creates a new `RepositoryPropertyPayload`.
                ///
                /// - Parameters:
                ///   - include: The repository properties and values to include. All of these properties must match for the condition to pass.
                ///   - exclude: The repository properties and values to exclude. The condition will not pass if any of these properties match.
                public init(
                    include: [Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec]? = nil,
                    exclude: [Components.Schemas.RepositoryRulesetConditionsRepositoryPropertySpec]? = nil
                ) {
                    self.include = include
                    self.exclude = exclude
                }
                public enum CodingKeys: String, CodingKey {
                    case include
                    case exclude
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset-conditions-repository-property-target/repository_property`.
            public var repositoryProperty: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertyTarget.RepositoryPropertyPayload
            /// Creates a new `RepositoryRulesetConditionsRepositoryPropertyTarget`.
            ///
            /// - Parameters:
            ///   - repositoryProperty:
            public init(repositoryProperty: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertyTarget.RepositoryPropertyPayload) {
                self.repositoryProperty = repositoryProperty
            }
            public enum CodingKeys: String, CodingKey {
                case repositoryProperty = "repository_property"
            }
        }
        /// Conditions for an organization ruleset.
        /// The branch and tag rulesets conditions object should contain both `repository_name` and `ref_name` properties, or both `repository_id` and `ref_name` properties, or both `repository_property` and `ref_name` properties.
        /// The push rulesets conditions object does not require the `ref_name` property.
        /// For repository policy rulesets, the conditions object should only contain the `repository_name`, the `repository_id`, or the `repository_property`.
        ///
        /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions`.
        @frozen public enum OrgRulesetConditions: Codable, Hashable, Sendable {
            /// Conditions to target repositories by name and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case1`.
            public struct Case1Payload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case1/value1`.
                public var value1: Components.Schemas.RepositoryRulesetConditions
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case1/value2`.
                public var value2: Components.Schemas.RepositoryRulesetConditionsRepositoryNameTarget
                /// Creates a new `Case1Payload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.RepositoryRulesetConditions,
                    value2: Components.Schemas.RepositoryRulesetConditionsRepositoryNameTarget
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                    self.value2 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                    try self.value2.encode(to: encoder)
                }
            }
            /// Conditions to target repositories by name and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case1`.
            case case1(Components.Schemas.OrgRulesetConditions.Case1Payload)
            /// Conditions to target repositories by id and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case2`.
            public struct Case2Payload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case2/value1`.
                public var value1: Components.Schemas.RepositoryRulesetConditions
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case2/value2`.
                public var value2: Components.Schemas.RepositoryRulesetConditionsRepositoryIdTarget
                /// Creates a new `Case2Payload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.RepositoryRulesetConditions,
                    value2: Components.Schemas.RepositoryRulesetConditionsRepositoryIdTarget
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                    self.value2 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                    try self.value2.encode(to: encoder)
                }
            }
            /// Conditions to target repositories by id and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case2`.
            case case2(Components.Schemas.OrgRulesetConditions.Case2Payload)
            /// Conditions to target repositories by property and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case3`.
            public struct Case3Payload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case3/value1`.
                public var value1: Components.Schemas.RepositoryRulesetConditions
                /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case3/value2`.
                public var value2: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertyTarget
                /// Creates a new `Case3Payload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.RepositoryRulesetConditions,
                    value2: Components.Schemas.RepositoryRulesetConditionsRepositoryPropertyTarget
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    self.value1 = try .init(from: decoder)
                    self.value2 = try .init(from: decoder)
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1.encode(to: encoder)
                    try self.value2.encode(to: encoder)
                }
            }
            /// Conditions to target repositories by property and refs by name
            ///
            /// - Remark: Generated from `#/components/schemas/org-ruleset-conditions/case3`.
            case case3(Components.Schemas.OrgRulesetConditions.Case3Payload)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case3(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try value.encode(to: encoder)
                case let .case2(value):
                    try value.encode(to: encoder)
                case let .case3(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// Only allow users with bypass permission to create matching refs.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-creation`.
        public struct RepositoryRuleCreation: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-creation/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case creation = "creation"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-creation/type`.
            public var _type: Components.Schemas.RepositoryRuleCreation._TypePayload
            /// Creates a new `RepositoryRuleCreation`.
            ///
            /// - Parameters:
            ///   - _type:
            public init(_type: Components.Schemas.RepositoryRuleCreation._TypePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// Only allow users with bypass permission to update matching refs.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-update`.
        public struct RepositoryRuleUpdate: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-update/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case update = "update"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-update/type`.
            public var _type: Components.Schemas.RepositoryRuleUpdate._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-update/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// Branch can pull changes from its upstream repository
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-update/parameters/update_allows_fetch_and_merge`.
                public var updateAllowsFetchAndMerge: Swift.Bool
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - updateAllowsFetchAndMerge: Branch can pull changes from its upstream repository
                public init(updateAllowsFetchAndMerge: Swift.Bool) {
                    self.updateAllowsFetchAndMerge = updateAllowsFetchAndMerge
                }
                public enum CodingKeys: String, CodingKey {
                    case updateAllowsFetchAndMerge = "update_allows_fetch_and_merge"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-update/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleUpdate.ParametersPayload?
            /// Creates a new `RepositoryRuleUpdate`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleUpdate._TypePayload,
                parameters: Components.Schemas.RepositoryRuleUpdate.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Only allow users with bypass permissions to delete matching refs.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-deletion`.
        public struct RepositoryRuleDeletion: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-deletion/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case deletion = "deletion"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-deletion/type`.
            public var _type: Components.Schemas.RepositoryRuleDeletion._TypePayload
            /// Creates a new `RepositoryRuleDeletion`.
            ///
            /// - Parameters:
            ///   - _type:
            public init(_type: Components.Schemas.RepositoryRuleDeletion._TypePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// Prevent merge commits from being pushed to matching refs.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-required-linear-history`.
        public struct RepositoryRuleRequiredLinearHistory: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-linear-history/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case requiredLinearHistory = "required_linear_history"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-linear-history/type`.
            public var _type: Components.Schemas.RepositoryRuleRequiredLinearHistory._TypePayload
            /// Creates a new `RepositoryRuleRequiredLinearHistory`.
            ///
            /// - Parameters:
            ///   - _type:
            public init(_type: Components.Schemas.RepositoryRuleRequiredLinearHistory._TypePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// Merges must be performed via a merge queue.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue`.
        public struct RepositoryRuleMergeQueue: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case mergeQueue = "merge_queue"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/type`.
            public var _type: Components.Schemas.RepositoryRuleMergeQueue._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// Maximum time for a required status check to report a conclusion. After this much time has elapsed, checks that have not reported a conclusion will be assumed to have failed
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/check_response_timeout_minutes`.
                public var checkResponseTimeoutMinutes: Swift.Int
                /// When set to ALLGREEN, the merge commit created by merge queue for each PR in the group must pass all required checks to merge. When set to HEADGREEN, only the commit at the head of the merge group, i.e. the commit containing changes from all of the PRs in the group, must pass its required checks to merge.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/grouping_strategy`.
                @frozen public enum GroupingStrategyPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case allgreen = "ALLGREEN"
                    case headgreen = "HEADGREEN"
                }
                /// When set to ALLGREEN, the merge commit created by merge queue for each PR in the group must pass all required checks to merge. When set to HEADGREEN, only the commit at the head of the merge group, i.e. the commit containing changes from all of the PRs in the group, must pass its required checks to merge.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/grouping_strategy`.
                public var groupingStrategy: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload.GroupingStrategyPayload
                /// Limit the number of queued pull requests requesting checks and workflow runs at the same time.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/max_entries_to_build`.
                public var maxEntriesToBuild: Swift.Int
                /// The maximum number of PRs that will be merged together in a group.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/max_entries_to_merge`.
                public var maxEntriesToMerge: Swift.Int
                /// Method to use when merging changes from queued pull requests.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/merge_method`.
                @frozen public enum MergeMethodPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case merge = "MERGE"
                    case squash = "SQUASH"
                    case rebase = "REBASE"
                }
                /// Method to use when merging changes from queued pull requests.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/merge_method`.
                public var mergeMethod: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload.MergeMethodPayload
                /// The minimum number of PRs that will be merged together in a group.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/min_entries_to_merge`.
                public var minEntriesToMerge: Swift.Int
                /// The time merge queue should wait after the first PR is added to the queue for the minimum group size to be met. After this time has elapsed, the minimum group size will be ignored and a smaller group will be merged.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters/min_entries_to_merge_wait_minutes`.
                public var minEntriesToMergeWaitMinutes: Swift.Int
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - checkResponseTimeoutMinutes: Maximum time for a required status check to report a conclusion. After this much time has elapsed, checks that have not reported a conclusion will be assumed to have failed
                ///   - groupingStrategy: When set to ALLGREEN, the merge commit created by merge queue for each PR in the group must pass all required checks to merge. When set to HEADGREEN, only the commit at the head of the merge group, i.e. the commit containing changes from all of the PRs in the group, must pass its required checks to merge.
                ///   - maxEntriesToBuild: Limit the number of queued pull requests requesting checks and workflow runs at the same time.
                ///   - maxEntriesToMerge: The maximum number of PRs that will be merged together in a group.
                ///   - mergeMethod: Method to use when merging changes from queued pull requests.
                ///   - minEntriesToMerge: The minimum number of PRs that will be merged together in a group.
                ///   - minEntriesToMergeWaitMinutes: The time merge queue should wait after the first PR is added to the queue for the minimum group size to be met. After this time has elapsed, the minimum group size will be ignored and a smaller group will be merged.
                public init(
                    checkResponseTimeoutMinutes: Swift.Int,
                    groupingStrategy: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload.GroupingStrategyPayload,
                    maxEntriesToBuild: Swift.Int,
                    maxEntriesToMerge: Swift.Int,
                    mergeMethod: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload.MergeMethodPayload,
                    minEntriesToMerge: Swift.Int,
                    minEntriesToMergeWaitMinutes: Swift.Int
                ) {
                    self.checkResponseTimeoutMinutes = checkResponseTimeoutMinutes
                    self.groupingStrategy = groupingStrategy
                    self.maxEntriesToBuild = maxEntriesToBuild
                    self.maxEntriesToMerge = maxEntriesToMerge
                    self.mergeMethod = mergeMethod
                    self.minEntriesToMerge = minEntriesToMerge
                    self.minEntriesToMergeWaitMinutes = minEntriesToMergeWaitMinutes
                }
                public enum CodingKeys: String, CodingKey {
                    case checkResponseTimeoutMinutes = "check_response_timeout_minutes"
                    case groupingStrategy = "grouping_strategy"
                    case maxEntriesToBuild = "max_entries_to_build"
                    case maxEntriesToMerge = "max_entries_to_merge"
                    case mergeMethod = "merge_method"
                    case minEntriesToMerge = "min_entries_to_merge"
                    case minEntriesToMergeWaitMinutes = "min_entries_to_merge_wait_minutes"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-merge-queue/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload?
            /// Creates a new `RepositoryRuleMergeQueue`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleMergeQueue._TypePayload,
                parameters: Components.Schemas.RepositoryRuleMergeQueue.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments`.
        public struct RepositoryRuleRequiredDeployments: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case requiredDeployments = "required_deployments"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments/type`.
            public var _type: Components.Schemas.RepositoryRuleRequiredDeployments._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// The environments that must be successfully deployed to before branches can be merged.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments/parameters/required_deployment_environments`.
                public var requiredDeploymentEnvironments: [Swift.String]
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - requiredDeploymentEnvironments: The environments that must be successfully deployed to before branches can be merged.
                public init(requiredDeploymentEnvironments: [Swift.String]) {
                    self.requiredDeploymentEnvironments = requiredDeploymentEnvironments
                }
                public enum CodingKeys: String, CodingKey {
                    case requiredDeploymentEnvironments = "required_deployment_environments"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-deployments/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleRequiredDeployments.ParametersPayload?
            /// Creates a new `RepositoryRuleRequiredDeployments`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleRequiredDeployments._TypePayload,
                parameters: Components.Schemas.RepositoryRuleRequiredDeployments.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Commits pushed to matching refs must have verified signatures.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-required-signatures`.
        public struct RepositoryRuleRequiredSignatures: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-signatures/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case requiredSignatures = "required_signatures"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-signatures/type`.
            public var _type: Components.Schemas.RepositoryRuleRequiredSignatures._TypePayload
            /// Creates a new `RepositoryRuleRequiredSignatures`.
            ///
            /// - Parameters:
            ///   - _type:
            public init(_type: Components.Schemas.RepositoryRuleRequiredSignatures._TypePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request`.
        public struct RepositoryRulePullRequest: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pullRequest = "pull_request"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/type`.
            public var _type: Components.Schemas.RepositoryRulePullRequest._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/AllowedMergeMethodsPayload`.
                @frozen public enum AllowedMergeMethodsPayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case merge = "merge"
                    case squash = "squash"
                    case rebase = "rebase"
                }
                /// Array of allowed merge methods. Allowed values include `merge`, `squash`, and `rebase`. At least one option must be enabled.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/allowed_merge_methods`.
                public typealias AllowedMergeMethodsPayload = [Components.Schemas.RepositoryRulePullRequest.ParametersPayload.AllowedMergeMethodsPayloadPayload]
                /// Array of allowed merge methods. Allowed values include `merge`, `squash`, and `rebase`. At least one option must be enabled.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/allowed_merge_methods`.
                public var allowedMergeMethods: Components.Schemas.RepositoryRulePullRequest.ParametersPayload.AllowedMergeMethodsPayload?
                /// Request Copilot code review for new pull requests automatically if the author has access to Copilot code review.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/automatic_copilot_code_review_enabled`.
                public var automaticCopilotCodeReviewEnabled: Swift.Bool?
                /// New, reviewable commits pushed will dismiss previous pull request review approvals.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/dismiss_stale_reviews_on_push`.
                public var dismissStaleReviewsOnPush: Swift.Bool
                /// Require an approving review in pull requests that modify files that have a designated code owner.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/require_code_owner_review`.
                public var requireCodeOwnerReview: Swift.Bool
                /// Whether the most recent reviewable push must be approved by someone other than the person who pushed it.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/require_last_push_approval`.
                public var requireLastPushApproval: Swift.Bool
                /// The number of approving reviews that are required before a pull request can be merged.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/required_approving_review_count`.
                public var requiredApprovingReviewCount: Swift.Int
                /// All conversations on code must be resolved before a pull request can be merged.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters/required_review_thread_resolution`.
                public var requiredReviewThreadResolution: Swift.Bool
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - allowedMergeMethods: Array of allowed merge methods. Allowed values include `merge`, `squash`, and `rebase`. At least one option must be enabled.
                ///   - automaticCopilotCodeReviewEnabled: Request Copilot code review for new pull requests automatically if the author has access to Copilot code review.
                ///   - dismissStaleReviewsOnPush: New, reviewable commits pushed will dismiss previous pull request review approvals.
                ///   - requireCodeOwnerReview: Require an approving review in pull requests that modify files that have a designated code owner.
                ///   - requireLastPushApproval: Whether the most recent reviewable push must be approved by someone other than the person who pushed it.
                ///   - requiredApprovingReviewCount: The number of approving reviews that are required before a pull request can be merged.
                ///   - requiredReviewThreadResolution: All conversations on code must be resolved before a pull request can be merged.
                public init(
                    allowedMergeMethods: Components.Schemas.RepositoryRulePullRequest.ParametersPayload.AllowedMergeMethodsPayload? = nil,
                    automaticCopilotCodeReviewEnabled: Swift.Bool? = nil,
                    dismissStaleReviewsOnPush: Swift.Bool,
                    requireCodeOwnerReview: Swift.Bool,
                    requireLastPushApproval: Swift.Bool,
                    requiredApprovingReviewCount: Swift.Int,
                    requiredReviewThreadResolution: Swift.Bool
                ) {
                    self.allowedMergeMethods = allowedMergeMethods
                    self.automaticCopilotCodeReviewEnabled = automaticCopilotCodeReviewEnabled
                    self.dismissStaleReviewsOnPush = dismissStaleReviewsOnPush
                    self.requireCodeOwnerReview = requireCodeOwnerReview
                    self.requireLastPushApproval = requireLastPushApproval
                    self.requiredApprovingReviewCount = requiredApprovingReviewCount
                    self.requiredReviewThreadResolution = requiredReviewThreadResolution
                }
                public enum CodingKeys: String, CodingKey {
                    case allowedMergeMethods = "allowed_merge_methods"
                    case automaticCopilotCodeReviewEnabled = "automatic_copilot_code_review_enabled"
                    case dismissStaleReviewsOnPush = "dismiss_stale_reviews_on_push"
                    case requireCodeOwnerReview = "require_code_owner_review"
                    case requireLastPushApproval = "require_last_push_approval"
                    case requiredApprovingReviewCount = "required_approving_review_count"
                    case requiredReviewThreadResolution = "required_review_thread_resolution"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-pull-request/parameters`.
            public var parameters: Components.Schemas.RepositoryRulePullRequest.ParametersPayload?
            /// Creates a new `RepositoryRulePullRequest`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRulePullRequest._TypePayload,
                parameters: Components.Schemas.RepositoryRulePullRequest.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Required status check
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-params-status-check-configuration`.
        public struct RepositoryRuleParamsStatusCheckConfiguration: Codable, Hashable, Sendable {
            /// The status check context name that must be present on the commit.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-status-check-configuration/context`.
            public var context: Swift.String
            /// The optional integration ID that this status check must originate from.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-status-check-configuration/integration_id`.
            public var integrationId: Swift.Int?
            /// Creates a new `RepositoryRuleParamsStatusCheckConfiguration`.
            ///
            /// - Parameters:
            ///   - context: The status check context name that must be present on the commit.
            ///   - integrationId: The optional integration ID that this status check must originate from.
            public init(
                context: Swift.String,
                integrationId: Swift.Int? = nil
            ) {
                self.context = context
                self.integrationId = integrationId
            }
            public enum CodingKeys: String, CodingKey {
                case context
                case integrationId = "integration_id"
            }
        }
        /// Choose which status checks must pass before the ref is updated. When enabled, commits must first be pushed to another ref where the checks pass.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks`.
        public struct RepositoryRuleRequiredStatusChecks: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case requiredStatusChecks = "required_status_checks"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/type`.
            public var _type: Components.Schemas.RepositoryRuleRequiredStatusChecks._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// Allow repositories and branches to be created if a check would otherwise prohibit it.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/parameters/do_not_enforce_on_create`.
                public var doNotEnforceOnCreate: Swift.Bool?
                /// Status checks that are required.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/parameters/required_status_checks`.
                public var requiredStatusChecks: [Components.Schemas.RepositoryRuleParamsStatusCheckConfiguration]
                /// Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/parameters/strict_required_status_checks_policy`.
                public var strictRequiredStatusChecksPolicy: Swift.Bool
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - doNotEnforceOnCreate: Allow repositories and branches to be created if a check would otherwise prohibit it.
                ///   - requiredStatusChecks: Status checks that are required.
                ///   - strictRequiredStatusChecksPolicy: Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled.
                public init(
                    doNotEnforceOnCreate: Swift.Bool? = nil,
                    requiredStatusChecks: [Components.Schemas.RepositoryRuleParamsStatusCheckConfiguration],
                    strictRequiredStatusChecksPolicy: Swift.Bool
                ) {
                    self.doNotEnforceOnCreate = doNotEnforceOnCreate
                    self.requiredStatusChecks = requiredStatusChecks
                    self.strictRequiredStatusChecksPolicy = strictRequiredStatusChecksPolicy
                }
                public enum CodingKeys: String, CodingKey {
                    case doNotEnforceOnCreate = "do_not_enforce_on_create"
                    case requiredStatusChecks = "required_status_checks"
                    case strictRequiredStatusChecksPolicy = "strict_required_status_checks_policy"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-required-status-checks/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleRequiredStatusChecks.ParametersPayload?
            /// Creates a new `RepositoryRuleRequiredStatusChecks`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleRequiredStatusChecks._TypePayload,
                parameters: Components.Schemas.RepositoryRuleRequiredStatusChecks.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Prevent users with push access from force pushing to refs.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-non-fast-forward`.
        public struct RepositoryRuleNonFastForward: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-non-fast-forward/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case nonFastForward = "non_fast_forward"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-non-fast-forward/type`.
            public var _type: Components.Schemas.RepositoryRuleNonFastForward._TypePayload
            /// Creates a new `RepositoryRuleNonFastForward`.
            ///
            /// - Parameters:
            ///   - _type:
            public init(_type: Components.Schemas.RepositoryRuleNonFastForward._TypePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// Parameters to be used for the commit_message_pattern rule
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern`.
        public struct RepositoryRuleCommitMessagePattern: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case commitMessagePattern = "commit_message_pattern"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/type`.
            public var _type: Components.Schemas.RepositoryRuleCommitMessagePattern._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// How this rule will appear to users.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters/name`.
                public var name: Swift.String?
                /// If true, the rule will fail if the pattern matches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters/negate`.
                public var negate: Swift.Bool?
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters/operator`.
                @frozen public enum OperatorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case startsWith = "starts_with"
                    case endsWith = "ends_with"
                    case contains = "contains"
                    case regex = "regex"
                }
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters/operator`.
                public var _operator: Components.Schemas.RepositoryRuleCommitMessagePattern.ParametersPayload.OperatorPayload
                /// The pattern to match with.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters/pattern`.
                public var pattern: Swift.String
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - name: How this rule will appear to users.
                ///   - negate: If true, the rule will fail if the pattern matches.
                ///   - _operator: The operator to use for matching.
                ///   - pattern: The pattern to match with.
                public init(
                    name: Swift.String? = nil,
                    negate: Swift.Bool? = nil,
                    _operator: Components.Schemas.RepositoryRuleCommitMessagePattern.ParametersPayload.OperatorPayload,
                    pattern: Swift.String
                ) {
                    self.name = name
                    self.negate = negate
                    self._operator = _operator
                    self.pattern = pattern
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case negate
                    case _operator = "operator"
                    case pattern
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-message-pattern/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleCommitMessagePattern.ParametersPayload?
            /// Creates a new `RepositoryRuleCommitMessagePattern`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleCommitMessagePattern._TypePayload,
                parameters: Components.Schemas.RepositoryRuleCommitMessagePattern.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Parameters to be used for the commit_author_email_pattern rule
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern`.
        public struct RepositoryRuleCommitAuthorEmailPattern: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case commitAuthorEmailPattern = "commit_author_email_pattern"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/type`.
            public var _type: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// How this rule will appear to users.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters/name`.
                public var name: Swift.String?
                /// If true, the rule will fail if the pattern matches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters/negate`.
                public var negate: Swift.Bool?
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters/operator`.
                @frozen public enum OperatorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case startsWith = "starts_with"
                    case endsWith = "ends_with"
                    case contains = "contains"
                    case regex = "regex"
                }
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters/operator`.
                public var _operator: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern.ParametersPayload.OperatorPayload
                /// The pattern to match with.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters/pattern`.
                public var pattern: Swift.String
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - name: How this rule will appear to users.
                ///   - negate: If true, the rule will fail if the pattern matches.
                ///   - _operator: The operator to use for matching.
                ///   - pattern: The pattern to match with.
                public init(
                    name: Swift.String? = nil,
                    negate: Swift.Bool? = nil,
                    _operator: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern.ParametersPayload.OperatorPayload,
                    pattern: Swift.String
                ) {
                    self.name = name
                    self.negate = negate
                    self._operator = _operator
                    self.pattern = pattern
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case negate
                    case _operator = "operator"
                    case pattern
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-commit-author-email-pattern/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern.ParametersPayload?
            /// Creates a new `RepositoryRuleCommitAuthorEmailPattern`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern._TypePayload,
                parameters: Components.Schemas.RepositoryRuleCommitAuthorEmailPattern.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Parameters to be used for the committer_email_pattern rule
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern`.
        public struct RepositoryRuleCommitterEmailPattern: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case committerEmailPattern = "committer_email_pattern"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/type`.
            public var _type: Components.Schemas.RepositoryRuleCommitterEmailPattern._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// How this rule will appear to users.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters/name`.
                public var name: Swift.String?
                /// If true, the rule will fail if the pattern matches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters/negate`.
                public var negate: Swift.Bool?
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters/operator`.
                @frozen public enum OperatorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case startsWith = "starts_with"
                    case endsWith = "ends_with"
                    case contains = "contains"
                    case regex = "regex"
                }
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters/operator`.
                public var _operator: Components.Schemas.RepositoryRuleCommitterEmailPattern.ParametersPayload.OperatorPayload
                /// The pattern to match with.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters/pattern`.
                public var pattern: Swift.String
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - name: How this rule will appear to users.
                ///   - negate: If true, the rule will fail if the pattern matches.
                ///   - _operator: The operator to use for matching.
                ///   - pattern: The pattern to match with.
                public init(
                    name: Swift.String? = nil,
                    negate: Swift.Bool? = nil,
                    _operator: Components.Schemas.RepositoryRuleCommitterEmailPattern.ParametersPayload.OperatorPayload,
                    pattern: Swift.String
                ) {
                    self.name = name
                    self.negate = negate
                    self._operator = _operator
                    self.pattern = pattern
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case negate
                    case _operator = "operator"
                    case pattern
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-committer-email-pattern/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleCommitterEmailPattern.ParametersPayload?
            /// Creates a new `RepositoryRuleCommitterEmailPattern`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleCommitterEmailPattern._TypePayload,
                parameters: Components.Schemas.RepositoryRuleCommitterEmailPattern.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Parameters to be used for the branch_name_pattern rule
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern`.
        public struct RepositoryRuleBranchNamePattern: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case branchNamePattern = "branch_name_pattern"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/type`.
            public var _type: Components.Schemas.RepositoryRuleBranchNamePattern._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// How this rule will appear to users.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters/name`.
                public var name: Swift.String?
                /// If true, the rule will fail if the pattern matches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters/negate`.
                public var negate: Swift.Bool?
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters/operator`.
                @frozen public enum OperatorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case startsWith = "starts_with"
                    case endsWith = "ends_with"
                    case contains = "contains"
                    case regex = "regex"
                }
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters/operator`.
                public var _operator: Components.Schemas.RepositoryRuleBranchNamePattern.ParametersPayload.OperatorPayload
                /// The pattern to match with.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters/pattern`.
                public var pattern: Swift.String
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - name: How this rule will appear to users.
                ///   - negate: If true, the rule will fail if the pattern matches.
                ///   - _operator: The operator to use for matching.
                ///   - pattern: The pattern to match with.
                public init(
                    name: Swift.String? = nil,
                    negate: Swift.Bool? = nil,
                    _operator: Components.Schemas.RepositoryRuleBranchNamePattern.ParametersPayload.OperatorPayload,
                    pattern: Swift.String
                ) {
                    self.name = name
                    self.negate = negate
                    self._operator = _operator
                    self.pattern = pattern
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case negate
                    case _operator = "operator"
                    case pattern
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-branch-name-pattern/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleBranchNamePattern.ParametersPayload?
            /// Creates a new `RepositoryRuleBranchNamePattern`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleBranchNamePattern._TypePayload,
                parameters: Components.Schemas.RepositoryRuleBranchNamePattern.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Parameters to be used for the tag_name_pattern rule
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern`.
        public struct RepositoryRuleTagNamePattern: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case tagNamePattern = "tag_name_pattern"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/type`.
            public var _type: Components.Schemas.RepositoryRuleTagNamePattern._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// How this rule will appear to users.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters/name`.
                public var name: Swift.String?
                /// If true, the rule will fail if the pattern matches.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters/negate`.
                public var negate: Swift.Bool?
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters/operator`.
                @frozen public enum OperatorPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case startsWith = "starts_with"
                    case endsWith = "ends_with"
                    case contains = "contains"
                    case regex = "regex"
                }
                /// The operator to use for matching.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters/operator`.
                public var _operator: Components.Schemas.RepositoryRuleTagNamePattern.ParametersPayload.OperatorPayload
                /// The pattern to match with.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters/pattern`.
                public var pattern: Swift.String
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - name: How this rule will appear to users.
                ///   - negate: If true, the rule will fail if the pattern matches.
                ///   - _operator: The operator to use for matching.
                ///   - pattern: The pattern to match with.
                public init(
                    name: Swift.String? = nil,
                    negate: Swift.Bool? = nil,
                    _operator: Components.Schemas.RepositoryRuleTagNamePattern.ParametersPayload.OperatorPayload,
                    pattern: Swift.String
                ) {
                    self.name = name
                    self.negate = negate
                    self._operator = _operator
                    self.pattern = pattern
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case negate
                    case _operator = "operator"
                    case pattern
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-tag-name-pattern/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleTagNamePattern.ParametersPayload?
            /// Creates a new `RepositoryRuleTagNamePattern`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleTagNamePattern._TypePayload,
                parameters: Components.Schemas.RepositoryRuleTagNamePattern.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Prevent commits that include changes in specified file and folder paths from being pushed to the commit graph. This includes absolute paths that contain file names.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction`.
        public struct RepositoryRuleFilePathRestriction: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case filePathRestriction = "file_path_restriction"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction/type`.
            public var _type: Components.Schemas.RepositoryRuleFilePathRestriction._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// The file paths that are restricted from being pushed to the commit graph.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction/parameters/restricted_file_paths`.
                public var restrictedFilePaths: [Swift.String]
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - restrictedFilePaths: The file paths that are restricted from being pushed to the commit graph.
                public init(restrictedFilePaths: [Swift.String]) {
                    self.restrictedFilePaths = restrictedFilePaths
                }
                public enum CodingKeys: String, CodingKey {
                    case restrictedFilePaths = "restricted_file_paths"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-path-restriction/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleFilePathRestriction.ParametersPayload?
            /// Creates a new `RepositoryRuleFilePathRestriction`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleFilePathRestriction._TypePayload,
                parameters: Components.Schemas.RepositoryRuleFilePathRestriction.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Prevent commits that include file paths that exceed the specified character limit from being pushed to the commit graph.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length`.
        public struct RepositoryRuleMaxFilePathLength: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case maxFilePathLength = "max_file_path_length"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length/type`.
            public var _type: Components.Schemas.RepositoryRuleMaxFilePathLength._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// The maximum amount of characters allowed in file paths.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length/parameters/max_file_path_length`.
                public var maxFilePathLength: Swift.Int
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - maxFilePathLength: The maximum amount of characters allowed in file paths.
                public init(maxFilePathLength: Swift.Int) {
                    self.maxFilePathLength = maxFilePathLength
                }
                public enum CodingKeys: String, CodingKey {
                    case maxFilePathLength = "max_file_path_length"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-path-length/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleMaxFilePathLength.ParametersPayload?
            /// Creates a new `RepositoryRuleMaxFilePathLength`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleMaxFilePathLength._TypePayload,
                parameters: Components.Schemas.RepositoryRuleMaxFilePathLength.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Prevent commits that include files with specified file extensions from being pushed to the commit graph.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction`.
        public struct RepositoryRuleFileExtensionRestriction: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case fileExtensionRestriction = "file_extension_restriction"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction/type`.
            public var _type: Components.Schemas.RepositoryRuleFileExtensionRestriction._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// The file extensions that are restricted from being pushed to the commit graph.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction/parameters/restricted_file_extensions`.
                public var restrictedFileExtensions: [Swift.String]
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - restrictedFileExtensions: The file extensions that are restricted from being pushed to the commit graph.
                public init(restrictedFileExtensions: [Swift.String]) {
                    self.restrictedFileExtensions = restrictedFileExtensions
                }
                public enum CodingKeys: String, CodingKey {
                    case restrictedFileExtensions = "restricted_file_extensions"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-file-extension-restriction/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleFileExtensionRestriction.ParametersPayload?
            /// Creates a new `RepositoryRuleFileExtensionRestriction`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleFileExtensionRestriction._TypePayload,
                parameters: Components.Schemas.RepositoryRuleFileExtensionRestriction.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// Prevent commits with individual files that exceed the specified limit from being pushed to the commit graph.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size`.
        public struct RepositoryRuleMaxFileSize: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case maxFileSize = "max_file_size"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size/type`.
            public var _type: Components.Schemas.RepositoryRuleMaxFileSize._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// The maximum file size allowed in megabytes. This limit does not apply to Git Large File Storage (Git LFS).
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size/parameters/max_file_size`.
                public var maxFileSize: Swift.Int
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - maxFileSize: The maximum file size allowed in megabytes. This limit does not apply to Git Large File Storage (Git LFS).
                public init(maxFileSize: Swift.Int) {
                    self.maxFileSize = maxFileSize
                }
                public enum CodingKeys: String, CodingKey {
                    case maxFileSize = "max_file_size"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-max-file-size/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleMaxFileSize.ParametersPayload?
            /// Creates a new `RepositoryRuleMaxFileSize`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleMaxFileSize._TypePayload,
                parameters: Components.Schemas.RepositoryRuleMaxFileSize.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// A workflow that must run for this rule to pass
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-params-workflow-file-reference`.
        public struct RepositoryRuleParamsWorkflowFileReference: Codable, Hashable, Sendable {
            /// The path to the workflow file
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-workflow-file-reference/path`.
            public var path: Swift.String
            /// The ref (branch or tag) of the workflow file to use
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-workflow-file-reference/ref`.
            public var ref: Swift.String?
            /// The ID of the repository where the workflow is defined
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-workflow-file-reference/repository_id`.
            public var repositoryId: Swift.Int
            /// The commit SHA of the workflow file to use
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-workflow-file-reference/sha`.
            public var sha: Swift.String?
            /// Creates a new `RepositoryRuleParamsWorkflowFileReference`.
            ///
            /// - Parameters:
            ///   - path: The path to the workflow file
            ///   - ref: The ref (branch or tag) of the workflow file to use
            ///   - repositoryId: The ID of the repository where the workflow is defined
            ///   - sha: The commit SHA of the workflow file to use
            public init(
                path: Swift.String,
                ref: Swift.String? = nil,
                repositoryId: Swift.Int,
                sha: Swift.String? = nil
            ) {
                self.path = path
                self.ref = ref
                self.repositoryId = repositoryId
                self.sha = sha
            }
            public enum CodingKeys: String, CodingKey {
                case path
                case ref
                case repositoryId = "repository_id"
                case sha
            }
        }
        /// Require all changes made to a targeted branch to pass the specified workflows before they can be merged.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-workflows`.
        public struct RepositoryRuleWorkflows: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case workflows = "workflows"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/type`.
            public var _type: Components.Schemas.RepositoryRuleWorkflows._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// Allow repositories and branches to be created if a check would otherwise prohibit it.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/parameters/do_not_enforce_on_create`.
                public var doNotEnforceOnCreate: Swift.Bool?
                /// Workflows that must pass for this rule to pass.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/parameters/workflows`.
                public var workflows: [Components.Schemas.RepositoryRuleParamsWorkflowFileReference]
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - doNotEnforceOnCreate: Allow repositories and branches to be created if a check would otherwise prohibit it.
                ///   - workflows: Workflows that must pass for this rule to pass.
                public init(
                    doNotEnforceOnCreate: Swift.Bool? = nil,
                    workflows: [Components.Schemas.RepositoryRuleParamsWorkflowFileReference]
                ) {
                    self.doNotEnforceOnCreate = doNotEnforceOnCreate
                    self.workflows = workflows
                }
                public enum CodingKeys: String, CodingKey {
                    case doNotEnforceOnCreate = "do_not_enforce_on_create"
                    case workflows
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-workflows/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleWorkflows.ParametersPayload?
            /// Creates a new `RepositoryRuleWorkflows`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleWorkflows._TypePayload,
                parameters: Components.Schemas.RepositoryRuleWorkflows.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// A tool that must provide code scanning results for this rule to pass.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool`.
        public struct RepositoryRuleParamsCodeScanningTool: Codable, Hashable, Sendable {
            /// The severity level at which code scanning results that raise alerts block a reference update. For more information on alert severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool/alerts_threshold`.
            @frozen public enum AlertsThresholdPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case errors = "errors"
                case errorsAndWarnings = "errors_and_warnings"
                case all = "all"
            }
            /// The severity level at which code scanning results that raise alerts block a reference update. For more information on alert severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool/alerts_threshold`.
            public var alertsThreshold: Components.Schemas.RepositoryRuleParamsCodeScanningTool.AlertsThresholdPayload
            /// The severity level at which code scanning results that raise security alerts block a reference update. For more information on security severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool/security_alerts_threshold`.
            @frozen public enum SecurityAlertsThresholdPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case critical = "critical"
                case highOrHigher = "high_or_higher"
                case mediumOrHigher = "medium_or_higher"
                case all = "all"
            }
            /// The severity level at which code scanning results that raise security alerts block a reference update. For more information on security severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool/security_alerts_threshold`.
            public var securityAlertsThreshold: Components.Schemas.RepositoryRuleParamsCodeScanningTool.SecurityAlertsThresholdPayload
            /// The name of a code scanning tool
            ///
            /// - Remark: Generated from `#/components/schemas/repository-rule-params-code-scanning-tool/tool`.
            public var tool: Swift.String
            /// Creates a new `RepositoryRuleParamsCodeScanningTool`.
            ///
            /// - Parameters:
            ///   - alertsThreshold: The severity level at which code scanning results that raise alerts block a reference update. For more information on alert severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///   - securityAlertsThreshold: The severity level at which code scanning results that raise security alerts block a reference update. For more information on security severity levels, see "[About code scanning alerts](https://docs.github.com/code-security/code-scanning/managing-code-scanning-alerts/about-code-scanning-alerts#about-alert-severity-and-security-severity-levels)."
            ///   - tool: The name of a code scanning tool
            public init(
                alertsThreshold: Components.Schemas.RepositoryRuleParamsCodeScanningTool.AlertsThresholdPayload,
                securityAlertsThreshold: Components.Schemas.RepositoryRuleParamsCodeScanningTool.SecurityAlertsThresholdPayload,
                tool: Swift.String
            ) {
                self.alertsThreshold = alertsThreshold
                self.securityAlertsThreshold = securityAlertsThreshold
                self.tool = tool
            }
            public enum CodingKeys: String, CodingKey {
                case alertsThreshold = "alerts_threshold"
                case securityAlertsThreshold = "security_alerts_threshold"
                case tool
            }
        }
        /// Choose which tools must provide code scanning results before the reference is updated. When configured, code scanning must be enabled and have results for both the commit and the reference being updated.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning`.
        public struct RepositoryRuleCodeScanning: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning/type`.
            @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case codeScanning = "code_scanning"
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning/type`.
            public var _type: Components.Schemas.RepositoryRuleCodeScanning._TypePayload
            /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning/parameters`.
            public struct ParametersPayload: Codable, Hashable, Sendable {
                /// Tools that must provide code scanning results for this rule to pass.
                ///
                /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning/parameters/code_scanning_tools`.
                public var codeScanningTools: [Components.Schemas.RepositoryRuleParamsCodeScanningTool]
                /// Creates a new `ParametersPayload`.
                ///
                /// - Parameters:
                ///   - codeScanningTools: Tools that must provide code scanning results for this rule to pass.
                public init(codeScanningTools: [Components.Schemas.RepositoryRuleParamsCodeScanningTool]) {
                    self.codeScanningTools = codeScanningTools
                }
                public enum CodingKeys: String, CodingKey {
                    case codeScanningTools = "code_scanning_tools"
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-rule-code-scanning/parameters`.
            public var parameters: Components.Schemas.RepositoryRuleCodeScanning.ParametersPayload?
            /// Creates a new `RepositoryRuleCodeScanning`.
            ///
            /// - Parameters:
            ///   - _type:
            ///   - parameters:
            public init(
                _type: Components.Schemas.RepositoryRuleCodeScanning._TypePayload,
                parameters: Components.Schemas.RepositoryRuleCodeScanning.ParametersPayload? = nil
            ) {
                self._type = _type
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case parameters
            }
        }
        /// A repository rule.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-rule`.
        @frozen public enum RepositoryRule: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/repository-rule/case1`.
            case RepositoryRuleCreation(Components.Schemas.RepositoryRuleCreation)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case2`.
            case RepositoryRuleUpdate(Components.Schemas.RepositoryRuleUpdate)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case3`.
            case RepositoryRuleDeletion(Components.Schemas.RepositoryRuleDeletion)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case4`.
            case RepositoryRuleRequiredLinearHistory(Components.Schemas.RepositoryRuleRequiredLinearHistory)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case5`.
            case RepositoryRuleMergeQueue(Components.Schemas.RepositoryRuleMergeQueue)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case6`.
            case RepositoryRuleRequiredDeployments(Components.Schemas.RepositoryRuleRequiredDeployments)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case7`.
            case RepositoryRuleRequiredSignatures(Components.Schemas.RepositoryRuleRequiredSignatures)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case8`.
            case RepositoryRulePullRequest(Components.Schemas.RepositoryRulePullRequest)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case9`.
            case RepositoryRuleRequiredStatusChecks(Components.Schemas.RepositoryRuleRequiredStatusChecks)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case10`.
            case RepositoryRuleNonFastForward(Components.Schemas.RepositoryRuleNonFastForward)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case11`.
            case RepositoryRuleCommitMessagePattern(Components.Schemas.RepositoryRuleCommitMessagePattern)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case12`.
            case RepositoryRuleCommitAuthorEmailPattern(Components.Schemas.RepositoryRuleCommitAuthorEmailPattern)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case13`.
            case RepositoryRuleCommitterEmailPattern(Components.Schemas.RepositoryRuleCommitterEmailPattern)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case14`.
            case RepositoryRuleBranchNamePattern(Components.Schemas.RepositoryRuleBranchNamePattern)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case15`.
            case RepositoryRuleTagNamePattern(Components.Schemas.RepositoryRuleTagNamePattern)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case16`.
            case RepositoryRuleFilePathRestriction(Components.Schemas.RepositoryRuleFilePathRestriction)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case17`.
            case RepositoryRuleMaxFilePathLength(Components.Schemas.RepositoryRuleMaxFilePathLength)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case18`.
            case RepositoryRuleFileExtensionRestriction(Components.Schemas.RepositoryRuleFileExtensionRestriction)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case19`.
            case RepositoryRuleMaxFileSize(Components.Schemas.RepositoryRuleMaxFileSize)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case20`.
            case RepositoryRuleWorkflows(Components.Schemas.RepositoryRuleWorkflows)
            /// - Remark: Generated from `#/components/schemas/repository-rule/case21`.
            case RepositoryRuleCodeScanning(Components.Schemas.RepositoryRuleCodeScanning)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .RepositoryRuleCreation(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleUpdate(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleDeletion(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredLinearHistory(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleMergeQueue(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredDeployments(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredSignatures(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRulePullRequest(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredStatusChecks(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleNonFastForward(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitMessagePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitAuthorEmailPattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitterEmailPattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleBranchNamePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleTagNamePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleFilePathRestriction(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleMaxFilePathLength(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleFileExtensionRestriction(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleMaxFileSize(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleWorkflows(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCodeScanning(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .RepositoryRuleCreation(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleUpdate(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleDeletion(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredLinearHistory(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleMergeQueue(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredDeployments(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredSignatures(value):
                    try value.encode(to: encoder)
                case let .RepositoryRulePullRequest(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredStatusChecks(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleNonFastForward(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitMessagePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitAuthorEmailPattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitterEmailPattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleBranchNamePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleTagNamePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleFilePathRestriction(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleMaxFilePathLength(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleFileExtensionRestriction(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleMaxFileSize(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleWorkflows(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCodeScanning(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// A set of rules to apply when specified conditions are met.
        ///
        /// - Remark: Generated from `#/components/schemas/repository-ruleset`.
        public struct RepositoryRuleset: Codable, Hashable, Sendable {
            /// The ID of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/id`.
            public var id: Swift.Int
            /// The name of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/name`.
            public var name: Swift.String
            /// The target of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/target`.
            @frozen public enum TargetPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case branch = "branch"
                case tag = "tag"
                case push = "push"
                case repository = "repository"
            }
            /// The target of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/target`.
            public var target: Components.Schemas.RepositoryRuleset.TargetPayload?
            /// The type of the source of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/source_type`.
            @frozen public enum SourceTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case repository = "Repository"
                case organization = "Organization"
                case enterprise = "Enterprise"
            }
            /// The type of the source of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/source_type`.
            public var sourceType: Components.Schemas.RepositoryRuleset.SourceTypePayload?
            /// The name of the source
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/source`.
            public var source: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/enforcement`.
            public var enforcement: Components.Schemas.RepositoryRuleEnforcement
            /// The actors that can bypass the rules in this ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/bypass_actors`.
            public var bypassActors: [Components.Schemas.RepositoryRulesetBypassActor]?
            /// The bypass type of the user making the API request for this ruleset. This field is only returned when
            /// querying the repository-level endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/current_user_can_bypass`.
            @frozen public enum CurrentUserCanBypassPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case always = "always"
                case pullRequestsOnly = "pull_requests_only"
                case never = "never"
            }
            /// The bypass type of the user making the API request for this ruleset. This field is only returned when
            /// querying the repository-level endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/current_user_can_bypass`.
            public var currentUserCanBypass: Components.Schemas.RepositoryRuleset.CurrentUserCanBypassPayload?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/node_id`.
            public var nodeId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/self`.
                public struct _SelfPayload: Codable, Hashable, Sendable {
                    /// The URL of the ruleset
                    ///
                    /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/self/href`.
                    public var href: Swift.String?
                    /// Creates a new `_SelfPayload`.
                    ///
                    /// - Parameters:
                    ///   - href: The URL of the ruleset
                    public init(href: Swift.String? = nil) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/self`.
                public var _self: Components.Schemas.RepositoryRuleset._LinksPayload._SelfPayload?
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/html`.
                public struct HtmlPayload: Codable, Hashable, Sendable {
                    /// The html URL of the ruleset
                    ///
                    /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/html/href`.
                    public var href: Swift.String?
                    /// Creates a new `HtmlPayload`.
                    ///
                    /// - Parameters:
                    ///   - href: The html URL of the ruleset
                    public init(href: Swift.String? = nil) {
                        self.href = href
                    }
                    public enum CodingKeys: String, CodingKey {
                        case href
                    }
                }
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links/html`.
                public var html: Components.Schemas.RepositoryRuleset._LinksPayload.HtmlPayload?
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - _self:
                ///   - html:
                public init(
                    _self: Components.Schemas.RepositoryRuleset._LinksPayload._SelfPayload? = nil,
                    html: Components.Schemas.RepositoryRuleset._LinksPayload.HtmlPayload? = nil
                ) {
                    self._self = _self
                    self.html = html
                }
                public enum CodingKeys: String, CodingKey {
                    case _self = "self"
                    case html
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/_links`.
            public var _links: Components.Schemas.RepositoryRuleset._LinksPayload?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/conditions`.
            public struct ConditionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/conditions/value1`.
                public var value1: Components.Schemas.RepositoryRulesetConditions?
                /// - Remark: Generated from `#/components/schemas/repository-ruleset/conditions/value2`.
                public var value2: Components.Schemas.OrgRulesetConditions?
                /// Creates a new `ConditionsPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Components.Schemas.RepositoryRulesetConditions? = nil,
                    value2: Components.Schemas.OrgRulesetConditions? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self.value1 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self.value2 = try .init(from: decoder)
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            self.value1,
                            self.value2
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try self.value1?.encode(to: encoder)
                    try self.value2?.encode(to: encoder)
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/conditions`.
            public var conditions: Components.Schemas.RepositoryRuleset.ConditionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/rules`.
            public var rules: [Components.Schemas.RepositoryRule]?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository-ruleset/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Creates a new `RepositoryRuleset`.
            ///
            /// - Parameters:
            ///   - id: The ID of the ruleset
            ///   - name: The name of the ruleset
            ///   - target: The target of the ruleset
            ///   - sourceType: The type of the source of the ruleset
            ///   - source: The name of the source
            ///   - enforcement:
            ///   - bypassActors: The actors that can bypass the rules in this ruleset
            ///   - currentUserCanBypass: The bypass type of the user making the API request for this ruleset. This field is only returned when
            ///   - nodeId:
            ///   - _links:
            ///   - conditions:
            ///   - rules:
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                id: Swift.Int,
                name: Swift.String,
                target: Components.Schemas.RepositoryRuleset.TargetPayload? = nil,
                sourceType: Components.Schemas.RepositoryRuleset.SourceTypePayload? = nil,
                source: Swift.String,
                enforcement: Components.Schemas.RepositoryRuleEnforcement,
                bypassActors: [Components.Schemas.RepositoryRulesetBypassActor]? = nil,
                currentUserCanBypass: Components.Schemas.RepositoryRuleset.CurrentUserCanBypassPayload? = nil,
                nodeId: Swift.String? = nil,
                _links: Components.Schemas.RepositoryRuleset._LinksPayload? = nil,
                conditions: Components.Schemas.RepositoryRuleset.ConditionsPayload? = nil,
                rules: [Components.Schemas.RepositoryRule]? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.target = target
                self.sourceType = sourceType
                self.source = source
                self.enforcement = enforcement
                self.bypassActors = bypassActors
                self.currentUserCanBypass = currentUserCanBypass
                self.nodeId = nodeId
                self._links = _links
                self.conditions = conditions
                self.rules = rules
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case target
                case sourceType = "source_type"
                case source
                case enforcement
                case bypassActors = "bypass_actors"
                case currentUserCanBypass = "current_user_can_bypass"
                case nodeId = "node_id"
                case _links
                case conditions
                case rules
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// A repository rule.
        ///
        /// - Remark: Generated from `#/components/schemas/org-rules`.
        @frozen public enum OrgRules: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/org-rules/case1`.
            case RepositoryRuleCreation(Components.Schemas.RepositoryRuleCreation)
            /// - Remark: Generated from `#/components/schemas/org-rules/case2`.
            case RepositoryRuleUpdate(Components.Schemas.RepositoryRuleUpdate)
            /// - Remark: Generated from `#/components/schemas/org-rules/case3`.
            case RepositoryRuleDeletion(Components.Schemas.RepositoryRuleDeletion)
            /// - Remark: Generated from `#/components/schemas/org-rules/case4`.
            case RepositoryRuleRequiredLinearHistory(Components.Schemas.RepositoryRuleRequiredLinearHistory)
            /// - Remark: Generated from `#/components/schemas/org-rules/case5`.
            case RepositoryRuleRequiredDeployments(Components.Schemas.RepositoryRuleRequiredDeployments)
            /// - Remark: Generated from `#/components/schemas/org-rules/case6`.
            case RepositoryRuleRequiredSignatures(Components.Schemas.RepositoryRuleRequiredSignatures)
            /// - Remark: Generated from `#/components/schemas/org-rules/case7`.
            case RepositoryRulePullRequest(Components.Schemas.RepositoryRulePullRequest)
            /// - Remark: Generated from `#/components/schemas/org-rules/case8`.
            case RepositoryRuleRequiredStatusChecks(Components.Schemas.RepositoryRuleRequiredStatusChecks)
            /// - Remark: Generated from `#/components/schemas/org-rules/case9`.
            case RepositoryRuleNonFastForward(Components.Schemas.RepositoryRuleNonFastForward)
            /// - Remark: Generated from `#/components/schemas/org-rules/case10`.
            case RepositoryRuleCommitMessagePattern(Components.Schemas.RepositoryRuleCommitMessagePattern)
            /// - Remark: Generated from `#/components/schemas/org-rules/case11`.
            case RepositoryRuleCommitAuthorEmailPattern(Components.Schemas.RepositoryRuleCommitAuthorEmailPattern)
            /// - Remark: Generated from `#/components/schemas/org-rules/case12`.
            case RepositoryRuleCommitterEmailPattern(Components.Schemas.RepositoryRuleCommitterEmailPattern)
            /// - Remark: Generated from `#/components/schemas/org-rules/case13`.
            case RepositoryRuleBranchNamePattern(Components.Schemas.RepositoryRuleBranchNamePattern)
            /// - Remark: Generated from `#/components/schemas/org-rules/case14`.
            case RepositoryRuleTagNamePattern(Components.Schemas.RepositoryRuleTagNamePattern)
            /// - Remark: Generated from `#/components/schemas/org-rules/case15`.
            case RepositoryRuleFilePathRestriction(Components.Schemas.RepositoryRuleFilePathRestriction)
            /// - Remark: Generated from `#/components/schemas/org-rules/case16`.
            case RepositoryRuleMaxFilePathLength(Components.Schemas.RepositoryRuleMaxFilePathLength)
            /// - Remark: Generated from `#/components/schemas/org-rules/case17`.
            case RepositoryRuleFileExtensionRestriction(Components.Schemas.RepositoryRuleFileExtensionRestriction)
            /// - Remark: Generated from `#/components/schemas/org-rules/case18`.
            case RepositoryRuleMaxFileSize(Components.Schemas.RepositoryRuleMaxFileSize)
            /// - Remark: Generated from `#/components/schemas/org-rules/case19`.
            case RepositoryRuleWorkflows(Components.Schemas.RepositoryRuleWorkflows)
            /// - Remark: Generated from `#/components/schemas/org-rules/case20`.
            case RepositoryRuleCodeScanning(Components.Schemas.RepositoryRuleCodeScanning)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .RepositoryRuleCreation(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleUpdate(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleDeletion(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredLinearHistory(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredDeployments(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredSignatures(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRulePullRequest(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleRequiredStatusChecks(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleNonFastForward(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitMessagePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitAuthorEmailPattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCommitterEmailPattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleBranchNamePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleTagNamePattern(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleFilePathRestriction(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleMaxFilePathLength(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleFileExtensionRestriction(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleMaxFileSize(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleWorkflows(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .RepositoryRuleCodeScanning(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .RepositoryRuleCreation(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleUpdate(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleDeletion(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredLinearHistory(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredDeployments(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredSignatures(value):
                    try value.encode(to: encoder)
                case let .RepositoryRulePullRequest(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleRequiredStatusChecks(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleNonFastForward(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitMessagePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitAuthorEmailPattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCommitterEmailPattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleBranchNamePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleTagNamePattern(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleFilePathRestriction(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleMaxFilePathLength(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleFileExtensionRestriction(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleMaxFileSize(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleWorkflows(value):
                    try value.encode(to: encoder)
                case let .RepositoryRuleCodeScanning(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// - Remark: Generated from `#/components/schemas/RuleSuites`.
        public struct RuleSuitesPayload: Codable, Hashable, Sendable {
            /// The unique identifier of the rule insight.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/id`.
            public var id: Swift.Int?
            /// The number that identifies the user.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/actor_id`.
            public var actorId: Swift.Int?
            /// The handle for the GitHub user account.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/actor_name`.
            public var actorName: Swift.String?
            /// The first commit sha before the push evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/before_sha`.
            public var beforeSha: Swift.String?
            /// The last commit sha in the push evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/after_sha`.
            public var afterSha: Swift.String?
            /// The ref name that the evaluation ran on.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/ref`.
            public var ref: Swift.String?
            /// The ID of the repository associated with the rule evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/repository_id`.
            public var repositoryId: Swift.Int?
            /// The name of the repository without the `.git` extension.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/repository_name`.
            public var repositoryName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/RuleSuites/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// The result of the rule evaluations for rules with the `active` enforcement status.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/result`.
            @frozen public enum ResultPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pass = "pass"
                case fail = "fail"
                case bypass = "bypass"
            }
            /// The result of the rule evaluations for rules with the `active` enforcement status.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/result`.
            public var result: Components.Schemas.RuleSuitesPayload.ResultPayload?
            /// The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/evaluation_result`.
            @frozen public enum EvaluationResultPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pass = "pass"
                case fail = "fail"
                case bypass = "bypass"
            }
            /// The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.
            ///
            /// - Remark: Generated from `#/components/schemas/RuleSuites/evaluation_result`.
            public var evaluationResult: Components.Schemas.RuleSuitesPayload.EvaluationResultPayload?
            /// Creates a new `RuleSuitesPayload`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the rule insight.
            ///   - actorId: The number that identifies the user.
            ///   - actorName: The handle for the GitHub user account.
            ///   - beforeSha: The first commit sha before the push evaluation.
            ///   - afterSha: The last commit sha in the push evaluation.
            ///   - ref: The ref name that the evaluation ran on.
            ///   - repositoryId: The ID of the repository associated with the rule evaluation.
            ///   - repositoryName: The name of the repository without the `.git` extension.
            ///   - pushedAt:
            ///   - result: The result of the rule evaluations for rules with the `active` enforcement status.
            ///   - evaluationResult: The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.
            public init(
                id: Swift.Int? = nil,
                actorId: Swift.Int? = nil,
                actorName: Swift.String? = nil,
                beforeSha: Swift.String? = nil,
                afterSha: Swift.String? = nil,
                ref: Swift.String? = nil,
                repositoryId: Swift.Int? = nil,
                repositoryName: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                result: Components.Schemas.RuleSuitesPayload.ResultPayload? = nil,
                evaluationResult: Components.Schemas.RuleSuitesPayload.EvaluationResultPayload? = nil
            ) {
                self.id = id
                self.actorId = actorId
                self.actorName = actorName
                self.beforeSha = beforeSha
                self.afterSha = afterSha
                self.ref = ref
                self.repositoryId = repositoryId
                self.repositoryName = repositoryName
                self.pushedAt = pushedAt
                self.result = result
                self.evaluationResult = evaluationResult
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case actorId = "actor_id"
                case actorName = "actor_name"
                case beforeSha = "before_sha"
                case afterSha = "after_sha"
                case ref
                case repositoryId = "repository_id"
                case repositoryName = "repository_name"
                case pushedAt = "pushed_at"
                case result
                case evaluationResult = "evaluation_result"
            }
        }
        /// Response
        ///
        /// - Remark: Generated from `#/components/schemas/rule-suites`.
        public typealias RuleSuites = [Components.Schemas.RuleSuitesPayload]
        /// Response
        ///
        /// - Remark: Generated from `#/components/schemas/rule-suite`.
        public struct RuleSuite: Codable, Hashable, Sendable {
            /// The unique identifier of the rule insight.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/id`.
            public var id: Swift.Int?
            /// The number that identifies the user.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/actor_id`.
            public var actorId: Swift.Int?
            /// The handle for the GitHub user account.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/actor_name`.
            public var actorName: Swift.String?
            /// The first commit sha before the push evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/before_sha`.
            public var beforeSha: Swift.String?
            /// The last commit sha in the push evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/after_sha`.
            public var afterSha: Swift.String?
            /// The ref name that the evaluation ran on.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/ref`.
            public var ref: Swift.String?
            /// The ID of the repository associated with the rule evaluation.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/repository_id`.
            public var repositoryId: Swift.Int?
            /// The name of the repository without the `.git` extension.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/repository_name`.
            public var repositoryName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/rule-suite/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// The result of the rule evaluations for rules with the `active` enforcement status.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/result`.
            @frozen public enum ResultPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pass = "pass"
                case fail = "fail"
                case bypass = "bypass"
            }
            /// The result of the rule evaluations for rules with the `active` enforcement status.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/result`.
            public var result: Components.Schemas.RuleSuite.ResultPayload?
            /// The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`. Null if no rules with `evaluate` enforcement status were run.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/evaluation_result`.
            @frozen public enum EvaluationResultPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case pass = "pass"
                case fail = "fail"
                case bypass = "bypass"
            }
            /// The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`. Null if no rules with `evaluate` enforcement status were run.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/evaluation_result`.
            public var evaluationResult: Components.Schemas.RuleSuite.EvaluationResultPayload?
            /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload`.
            public struct RuleEvaluationsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_source`.
                public struct RuleSourcePayload: Codable, Hashable, Sendable {
                    /// The type of rule source.
                    ///
                    /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_source/type`.
                    public var _type: Swift.String?
                    /// The ID of the rule source.
                    ///
                    /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_source/id`.
                    public var id: Swift.Int?
                    /// The name of the rule source.
                    ///
                    /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_source/name`.
                    public var name: Swift.String?
                    /// Creates a new `RuleSourcePayload`.
                    ///
                    /// - Parameters:
                    ///   - _type: The type of rule source.
                    ///   - id: The ID of the rule source.
                    ///   - name: The name of the rule source.
                    public init(
                        _type: Swift.String? = nil,
                        id: Swift.Int? = nil,
                        name: Swift.String? = nil
                    ) {
                        self._type = _type
                        self.id = id
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case _type = "type"
                        case id
                        case name
                    }
                }
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_source`.
                public var ruleSource: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.RuleSourcePayload?
                /// The enforcement level of this rule source.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/enforcement`.
                @frozen public enum EnforcementPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case active = "active"
                    case evaluate = "evaluate"
                    case deletedRuleset = "deleted ruleset"
                }
                /// The enforcement level of this rule source.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/enforcement`.
                public var enforcement: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.EnforcementPayload?
                /// The result of the evaluation of the individual rule.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/result`.
                @frozen public enum ResultPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case pass = "pass"
                    case fail = "fail"
                }
                /// The result of the evaluation of the individual rule.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/result`.
                public var result: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.ResultPayload?
                /// The type of rule.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/rule_type`.
                public var ruleType: Swift.String?
                /// The detailed failure message for the rule. Null if the rule passed.
                ///
                /// - Remark: Generated from `#/components/schemas/rule-suite/RuleEvaluationsPayload/details`.
                public var details: Swift.String?
                /// Creates a new `RuleEvaluationsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - ruleSource:
                ///   - enforcement: The enforcement level of this rule source.
                ///   - result: The result of the evaluation of the individual rule.
                ///   - ruleType: The type of rule.
                ///   - details: The detailed failure message for the rule. Null if the rule passed.
                public init(
                    ruleSource: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.RuleSourcePayload? = nil,
                    enforcement: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.EnforcementPayload? = nil,
                    result: Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload.ResultPayload? = nil,
                    ruleType: Swift.String? = nil,
                    details: Swift.String? = nil
                ) {
                    self.ruleSource = ruleSource
                    self.enforcement = enforcement
                    self.result = result
                    self.ruleType = ruleType
                    self.details = details
                }
                public enum CodingKeys: String, CodingKey {
                    case ruleSource = "rule_source"
                    case enforcement
                    case result
                    case ruleType = "rule_type"
                    case details
                }
            }
            /// Details on the evaluated rules.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/rule_evaluations`.
            public typealias RuleEvaluationsPayload = [Components.Schemas.RuleSuite.RuleEvaluationsPayloadPayload]
            /// Details on the evaluated rules.
            ///
            /// - Remark: Generated from `#/components/schemas/rule-suite/rule_evaluations`.
            public var ruleEvaluations: Components.Schemas.RuleSuite.RuleEvaluationsPayload?
            /// Creates a new `RuleSuite`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier of the rule insight.
            ///   - actorId: The number that identifies the user.
            ///   - actorName: The handle for the GitHub user account.
            ///   - beforeSha: The first commit sha before the push evaluation.
            ///   - afterSha: The last commit sha in the push evaluation.
            ///   - ref: The ref name that the evaluation ran on.
            ///   - repositoryId: The ID of the repository associated with the rule evaluation.
            ///   - repositoryName: The name of the repository without the `.git` extension.
            ///   - pushedAt:
            ///   - result: The result of the rule evaluations for rules with the `active` enforcement status.
            ///   - evaluationResult: The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`. Null if no rules with `evaluate` enforcement status were run.
            ///   - ruleEvaluations: Details on the evaluated rules.
            public init(
                id: Swift.Int? = nil,
                actorId: Swift.Int? = nil,
                actorName: Swift.String? = nil,
                beforeSha: Swift.String? = nil,
                afterSha: Swift.String? = nil,
                ref: Swift.String? = nil,
                repositoryId: Swift.Int? = nil,
                repositoryName: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                result: Components.Schemas.RuleSuite.ResultPayload? = nil,
                evaluationResult: Components.Schemas.RuleSuite.EvaluationResultPayload? = nil,
                ruleEvaluations: Components.Schemas.RuleSuite.RuleEvaluationsPayload? = nil
            ) {
                self.id = id
                self.actorId = actorId
                self.actorName = actorName
                self.beforeSha = beforeSha
                self.afterSha = afterSha
                self.ref = ref
                self.repositoryId = repositoryId
                self.repositoryName = repositoryName
                self.pushedAt = pushedAt
                self.result = result
                self.evaluationResult = evaluationResult
                self.ruleEvaluations = ruleEvaluations
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case actorId = "actor_id"
                case actorName = "actor_name"
                case beforeSha = "before_sha"
                case afterSha = "after_sha"
                case ref
                case repositoryId = "repository_id"
                case repositoryName = "repository_name"
                case pushedAt = "pushed_at"
                case result
                case evaluationResult = "evaluation_result"
                case ruleEvaluations = "rule_evaluations"
            }
        }
        /// The historical version of a ruleset
        ///
        /// - Remark: Generated from `#/components/schemas/ruleset-version`.
        public struct RulesetVersion: Codable, Hashable, Sendable {
            /// The ID of the previous version of the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/version_id`.
            public var versionId: Swift.Int
            /// The actor who updated the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/actor`.
            public struct ActorPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/ruleset-version/actor/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/ruleset-version/actor/type`.
                public var _type: Swift.String?
                /// Creates a new `ActorPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - _type:
                public init(
                    id: Swift.Int? = nil,
                    _type: Swift.String? = nil
                ) {
                    self.id = id
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case _type = "type"
                }
            }
            /// The actor who updated the ruleset
            ///
            /// - Remark: Generated from `#/components/schemas/ruleset-version/actor`.
            public var actor: Components.Schemas.RulesetVersion.ActorPayload
            /// - Remark: Generated from `#/components/schemas/ruleset-version/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `RulesetVersion`.
            ///
            /// - Parameters:
            ///   - versionId: The ID of the previous version of the ruleset
            ///   - actor: The actor who updated the ruleset
            ///   - updatedAt:
            public init(
                versionId: Swift.Int,
                actor: Components.Schemas.RulesetVersion.ActorPayload,
                updatedAt: Foundation.Date
            ) {
                self.versionId = versionId
                self.actor = actor
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case versionId = "version_id"
                case actor
                case updatedAt = "updated_at"
            }
        }
        /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state`.
        public struct RulesetVersionWithState: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value1`.
            public var value1: Components.Schemas.RulesetVersion
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2`.
            public struct Value2Payload: Codable, Hashable, Sendable {
                /// The state of the ruleset version
                ///
                /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2/state`.
                public var state: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `Value2Payload`.
                ///
                /// - Parameters:
                ///   - state: The state of the ruleset version
                public init(state: OpenAPIRuntime.OpenAPIObjectContainer) {
                    self.state = state
                }
                public enum CodingKeys: String, CodingKey {
                    case state
                }
            }
            /// - Remark: Generated from `#/components/schemas/ruleset-version-with-state/value2`.
            public var value2: Components.Schemas.RulesetVersionWithState.Value2Payload
            /// Creates a new `RulesetVersionWithState`.
            ///
            /// - Parameters:
            ///   - value1:
            ///   - value2:
            public init(
                value1: Components.Schemas.RulesetVersion,
                value2: Components.Schemas.RulesetVersionWithState.Value2Payload
            ) {
                self.value1 = value1
                self.value2 = value2
            }
            public init(from decoder: any Decoder) throws {
                self.value1 = try .init(from: decoder)
                self.value2 = try .init(from: decoder)
            }
            public func encode(to encoder: any Encoder) throws {
                try self.value1.encode(to: encoder)
                try self.value2.encode(to: encoder)
            }
        }
        /// The type of reviewer.
        ///
        /// - Remark: Generated from `#/components/schemas/deployment-reviewer-type`.
        @frozen public enum DeploymentReviewerType: String, Codable, Hashable, Sendable, CaseIterable {
            case user = "User"
            case team = "Team"
        }
        /// A request for a specific ref(branch,sha,tag) to be deployed
        ///
        /// - Remark: Generated from `#/components/schemas/deployment`.
        public struct Deployment: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/deployment/url`.
            public var url: Swift.String
            /// Unique identifier of the deployment
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/deployment/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/sha`.
            public var sha: Swift.String
            /// The ref to deploy. This can be a branch, tag, or sha.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/ref`.
            public var ref: Swift.String
            /// Parameter to specify a task to execute
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/task`.
            public var task: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/payload`.
            @frozen public enum PayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case1`.
                public struct Case1Payload: Codable, Hashable, Sendable {
                    /// A container of undocumented properties.
                    public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                    /// Creates a new `Case1Payload`.
                    ///
                    /// - Parameters:
                    ///   - additionalProperties: A container of undocumented properties.
                    public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                        self.additionalProperties = additionalProperties
                    }
                    public init(from decoder: any Decoder) throws {
                        additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                    }
                    public func encode(to encoder: any Encoder) throws {
                        try encoder.encodeAdditionalProperties(additionalProperties)
                    }
                }
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case1`.
                case case1(Components.Schemas.Deployment.PayloadPayload.Case1Payload)
                /// - Remark: Generated from `#/components/schemas/deployment/payload/case2`.
                case case2(Swift.String)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try value.encode(to: encoder)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/deployment/payload`.
            public var payload: Components.Schemas.Deployment.PayloadPayload
            /// - Remark: Generated from `#/components/schemas/deployment/original_environment`.
            public var originalEnvironment: Swift.String?
            /// Name for the target deployment environment.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/environment`.
            public var environment: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/deployment/creator`.
            public var creator: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/deployment/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/deployment/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/deployment/repository_url`.
            public var repositoryUrl: Swift.String
            /// Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/transient_environment`.
            public var transientEnvironment: Swift.Bool?
            /// Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///
            /// - Remark: Generated from `#/components/schemas/deployment/production_environment`.
            public var productionEnvironment: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/deployment/performed_via_github_app`.
            public var performedViaGithubApp: Components.Schemas.NullableIntegration?
            /// Creates a new `Deployment`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - id: Unique identifier of the deployment
            ///   - nodeId:
            ///   - sha:
            ///   - ref: The ref to deploy. This can be a branch, tag, or sha.
            ///   - task: Parameter to specify a task to execute
            ///   - payload:
            ///   - originalEnvironment:
            ///   - environment: Name for the target deployment environment.
            ///   - description:
            ///   - creator:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - statusesUrl:
            ///   - repositoryUrl:
            ///   - transientEnvironment: Specifies if the given environment is will no longer exist at some point in the future. Default: false.
            ///   - productionEnvironment: Specifies if the given environment is one that end-users directly interact with. Default: false.
            ///   - performedViaGithubApp:
            public init(
                url: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                sha: Swift.String,
                ref: Swift.String,
                task: Swift.String,
                payload: Components.Schemas.Deployment.PayloadPayload,
                originalEnvironment: Swift.String? = nil,
                environment: Swift.String,
                description: Swift.String? = nil,
                creator: Components.Schemas.NullableSimpleUser? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                statusesUrl: Swift.String,
                repositoryUrl: Swift.String,
                transientEnvironment: Swift.Bool? = nil,
                productionEnvironment: Swift.Bool? = nil,
                performedViaGithubApp: Components.Schemas.NullableIntegration? = nil
            ) {
                self.url = url
                self.id = id
                self.nodeId = nodeId
                self.sha = sha
                self.ref = ref
                self.task = task
                self.payload = payload
                self.originalEnvironment = originalEnvironment
                self.environment = environment
                self.description = description
                self.creator = creator
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.statusesUrl = statusesUrl
                self.repositoryUrl = repositoryUrl
                self.transientEnvironment = transientEnvironment
                self.productionEnvironment = productionEnvironment
                self.performedViaGithubApp = performedViaGithubApp
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case id
                case nodeId = "node_id"
                case sha
                case ref
                case task
                case payload
                case originalEnvironment = "original_environment"
                case environment
                case description
                case creator
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case statusesUrl = "statuses_url"
                case repositoryUrl = "repository_url"
                case transientEnvironment = "transient_environment"
                case productionEnvironment = "production_environment"
                case performedViaGithubApp = "performed_via_github_app"
            }
        }
        /// Activity
        ///
        /// - Remark: Generated from `#/components/schemas/activity`.
        public struct Activity: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/activity/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/activity/node_id`.
            public var nodeId: Swift.String
            /// The SHA of the commit before the activity.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/before`.
            public var before: Swift.String
            /// The SHA of the commit after the activity.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/after`.
            public var after: Swift.String
            /// The full Git reference, formatted as `refs/heads/<branch name>`.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/ref`.
            public var ref: Swift.String
            /// The time when the activity occurred.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/timestamp`.
            public var timestamp: Foundation.Date
            /// The type of the activity that was performed.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/activity_type`.
            @frozen public enum ActivityTypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case push = "push"
                case forcePush = "force_push"
                case branchDeletion = "branch_deletion"
                case branchCreation = "branch_creation"
                case prMerge = "pr_merge"
                case mergeQueueMerge = "merge_queue_merge"
            }
            /// The type of the activity that was performed.
            ///
            /// - Remark: Generated from `#/components/schemas/activity/activity_type`.
            public var activityType: Components.Schemas.Activity.ActivityTypePayload
            /// - Remark: Generated from `#/components/schemas/activity/actor`.
            public var actor: Components.Schemas.NullableSimpleUser?
            /// Creates a new `Activity`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - before: The SHA of the commit before the activity.
            ///   - after: The SHA of the commit after the activity.
            ///   - ref: The full Git reference, formatted as `refs/heads/<branch name>`.
            ///   - timestamp: The time when the activity occurred.
            ///   - activityType: The type of the activity that was performed.
            ///   - actor:
            public init(
                id: Swift.Int,
                nodeId: Swift.String,
                before: Swift.String,
                after: Swift.String,
                ref: Swift.String,
                timestamp: Foundation.Date,
                activityType: Components.Schemas.Activity.ActivityTypePayload,
                actor: Components.Schemas.NullableSimpleUser? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.before = before
                self.after = after
                self.ref = ref
                self.timestamp = timestamp
                self.activityType = activityType
                self.actor = actor
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case before
                case after
                case ref
                case timestamp
                case activityType = "activity_type"
                case actor
            }
        }
        /// An autolink reference.
        ///
        /// - Remark: Generated from `#/components/schemas/autolink`.
        public struct Autolink: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/autolink/id`.
            public var id: Swift.Int
            /// The prefix of a key that is linkified.
            ///
            /// - Remark: Generated from `#/components/schemas/autolink/key_prefix`.
            public var keyPrefix: Swift.String
            /// A template for the target URL that is generated if a key was found.
            ///
            /// - Remark: Generated from `#/components/schemas/autolink/url_template`.
            public var urlTemplate: Swift.String
            /// Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.
            ///
            /// - Remark: Generated from `#/components/schemas/autolink/is_alphanumeric`.
            public var isAlphanumeric: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/autolink/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Creates a new `Autolink`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - keyPrefix: The prefix of a key that is linkified.
            ///   - urlTemplate: A template for the target URL that is generated if a key was found.
            ///   - isAlphanumeric: Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.
            ///   - updatedAt:
            public init(
                id: Swift.Int,
                keyPrefix: Swift.String,
                urlTemplate: Swift.String,
                isAlphanumeric: Swift.Bool,
                updatedAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.keyPrefix = keyPrefix
                self.urlTemplate = urlTemplate
                self.isAlphanumeric = isAlphanumeric
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case keyPrefix = "key_prefix"
                case urlTemplate = "url_template"
                case isAlphanumeric = "is_alphanumeric"
                case updatedAt = "updated_at"
            }
        }
        /// Check Dependabot security updates
        ///
        /// - Remark: Generated from `#/components/schemas/check-automated-security-fixes`.
        public struct CheckAutomatedSecurityFixes: Codable, Hashable, Sendable {
            /// Whether Dependabot security updates are enabled for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/check-automated-security-fixes/enabled`.
            public var enabled: Swift.Bool
            /// Whether Dependabot security updates are paused for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/check-automated-security-fixes/paused`.
            public var paused: Swift.Bool
            /// Creates a new `CheckAutomatedSecurityFixes`.
            ///
            /// - Parameters:
            ///   - enabled: Whether Dependabot security updates are enabled for the repository.
            ///   - paused: Whether Dependabot security updates are paused for the repository.
            public init(
                enabled: Swift.Bool,
                paused: Swift.Bool
            ) {
                self.enabled = enabled
                self.paused = paused
            }
            public enum CodingKeys: String, CodingKey {
                case enabled
                case paused
            }
        }
        /// Protected Branch Required Status Check
        ///
        /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check`.
        public struct ProtectedBranchRequiredStatusCheck: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/enforcement_level`.
            public var enforcementLevel: Swift.String?
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/contexts`.
            public var contexts: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/ChecksPayload`.
            public struct ChecksPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/ChecksPayload/context`.
                public var context: Swift.String
                /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/ChecksPayload/app_id`.
                public var appId: Swift.Int?
                /// Creates a new `ChecksPayloadPayload`.
                ///
                /// - Parameters:
                ///   - context:
                ///   - appId:
                public init(
                    context: Swift.String,
                    appId: Swift.Int? = nil
                ) {
                    self.context = context
                    self.appId = appId
                }
                public enum CodingKeys: String, CodingKey {
                    case context
                    case appId = "app_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/checks`.
            public typealias ChecksPayload = [Components.Schemas.ProtectedBranchRequiredStatusCheck.ChecksPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/checks`.
            public var checks: Components.Schemas.ProtectedBranchRequiredStatusCheck.ChecksPayload
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/contexts_url`.
            public var contextsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/protected-branch-required-status-check/strict`.
            public var strict: Swift.Bool?
            /// Creates a new `ProtectedBranchRequiredStatusCheck`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - enforcementLevel:
            ///   - contexts:
            ///   - checks:
            ///   - contextsUrl:
            ///   - strict:
            public init(
                url: Swift.String? = nil,
                enforcementLevel: Swift.String? = nil,
                contexts: [Swift.String],
                checks: Components.Schemas.ProtectedBranchRequiredStatusCheck.ChecksPayload,
                contextsUrl: Swift.String? = nil,
                strict: Swift.Bool? = nil
            ) {
                self.url = url
                self.enforcementLevel = enforcementLevel
                self.contexts = contexts
                self.checks = checks
                self.contextsUrl = contextsUrl
                self.strict = strict
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case enforcementLevel = "enforcement_level"
                case contexts
                case checks
                case contextsUrl = "contexts_url"
                case strict
            }
        }
        /// Protected Branch Admin Enforced
        ///
        /// - Remark: Generated from `#/components/schemas/protected-branch-admin-enforced`.
        public struct ProtectedBranchAdminEnforced: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/protected-branch-admin-enforced/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/protected-branch-admin-enforced/enabled`.
            public var enabled: Swift.Bool
            /// Creates a new `ProtectedBranchAdminEnforced`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - enabled:
            public init(
                url: Swift.String,
                enabled: Swift.Bool
            ) {
                self.url = url
                self.enabled = enabled
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case enabled
            }
        }
        /// Protected Branch Pull Request Review
        ///
        /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review`.
        public struct ProtectedBranchPullRequestReview: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions`.
            public struct DismissalRestrictionsPayload: Codable, Hashable, Sendable {
                /// The list of users with review dismissal access.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/users`.
                public var users: [Components.Schemas.SimpleUser]?
                /// The list of teams with review dismissal access.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/teams`.
                public var teams: [Components.Schemas.Team]?
                /// The list of apps with review dismissal access.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/apps`.
                public var apps: [Components.Schemas.Integration]?
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/users_url`.
                public var usersUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions/teams_url`.
                public var teamsUrl: Swift.String?
                /// Creates a new `DismissalRestrictionsPayload`.
                ///
                /// - Parameters:
                ///   - users: The list of users with review dismissal access.
                ///   - teams: The list of teams with review dismissal access.
                ///   - apps: The list of apps with review dismissal access.
                ///   - url:
                ///   - usersUrl:
                ///   - teamsUrl:
                public init(
                    users: [Components.Schemas.SimpleUser]? = nil,
                    teams: [Components.Schemas.Team]? = nil,
                    apps: [Components.Schemas.Integration]? = nil,
                    url: Swift.String? = nil,
                    usersUrl: Swift.String? = nil,
                    teamsUrl: Swift.String? = nil
                ) {
                    self.users = users
                    self.teams = teams
                    self.apps = apps
                    self.url = url
                    self.usersUrl = usersUrl
                    self.teamsUrl = teamsUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case users
                    case teams
                    case apps
                    case url
                    case usersUrl = "users_url"
                    case teamsUrl = "teams_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismissal_restrictions`.
            public var dismissalRestrictions: Components.Schemas.ProtectedBranchPullRequestReview.DismissalRestrictionsPayload?
            /// Allow specific users, teams, or apps to bypass pull request requirements.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/bypass_pull_request_allowances`.
            public struct BypassPullRequestAllowancesPayload: Codable, Hashable, Sendable {
                /// The list of users allowed to bypass pull request requirements.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/bypass_pull_request_allowances/users`.
                public var users: [Components.Schemas.SimpleUser]?
                /// The list of teams allowed to bypass pull request requirements.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/bypass_pull_request_allowances/teams`.
                public var teams: [Components.Schemas.Team]?
                /// The list of apps allowed to bypass pull request requirements.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/bypass_pull_request_allowances/apps`.
                public var apps: [Components.Schemas.Integration]?
                /// Creates a new `BypassPullRequestAllowancesPayload`.
                ///
                /// - Parameters:
                ///   - users: The list of users allowed to bypass pull request requirements.
                ///   - teams: The list of teams allowed to bypass pull request requirements.
                ///   - apps: The list of apps allowed to bypass pull request requirements.
                public init(
                    users: [Components.Schemas.SimpleUser]? = nil,
                    teams: [Components.Schemas.Team]? = nil,
                    apps: [Components.Schemas.Integration]? = nil
                ) {
                    self.users = users
                    self.teams = teams
                    self.apps = apps
                }
                public enum CodingKeys: String, CodingKey {
                    case users
                    case teams
                    case apps
                }
            }
            /// Allow specific users, teams, or apps to bypass pull request requirements.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/bypass_pull_request_allowances`.
            public var bypassPullRequestAllowances: Components.Schemas.ProtectedBranchPullRequestReview.BypassPullRequestAllowancesPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/dismiss_stale_reviews`.
            public var dismissStaleReviews: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/require_code_owner_reviews`.
            public var requireCodeOwnerReviews: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/required_approving_review_count`.
            public var requiredApprovingReviewCount: Swift.Int?
            /// Whether the most recent push must be approved by someone other than the person who pushed it.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch-pull-request-review/require_last_push_approval`.
            public var requireLastPushApproval: Swift.Bool?
            /// Creates a new `ProtectedBranchPullRequestReview`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - dismissalRestrictions:
            ///   - bypassPullRequestAllowances: Allow specific users, teams, or apps to bypass pull request requirements.
            ///   - dismissStaleReviews:
            ///   - requireCodeOwnerReviews:
            ///   - requiredApprovingReviewCount:
            ///   - requireLastPushApproval: Whether the most recent push must be approved by someone other than the person who pushed it.
            public init(
                url: Swift.String? = nil,
                dismissalRestrictions: Components.Schemas.ProtectedBranchPullRequestReview.DismissalRestrictionsPayload? = nil,
                bypassPullRequestAllowances: Components.Schemas.ProtectedBranchPullRequestReview.BypassPullRequestAllowancesPayload? = nil,
                dismissStaleReviews: Swift.Bool,
                requireCodeOwnerReviews: Swift.Bool,
                requiredApprovingReviewCount: Swift.Int? = nil,
                requireLastPushApproval: Swift.Bool? = nil
            ) {
                self.url = url
                self.dismissalRestrictions = dismissalRestrictions
                self.bypassPullRequestAllowances = bypassPullRequestAllowances
                self.dismissStaleReviews = dismissStaleReviews
                self.requireCodeOwnerReviews = requireCodeOwnerReviews
                self.requiredApprovingReviewCount = requiredApprovingReviewCount
                self.requireLastPushApproval = requireLastPushApproval
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case dismissalRestrictions = "dismissal_restrictions"
                case bypassPullRequestAllowances = "bypass_pull_request_allowances"
                case dismissStaleReviews = "dismiss_stale_reviews"
                case requireCodeOwnerReviews = "require_code_owner_reviews"
                case requiredApprovingReviewCount = "required_approving_review_count"
                case requireLastPushApproval = "require_last_push_approval"
            }
        }
        /// Branch Restriction Policy
        ///
        /// - Remark: Generated from `#/components/schemas/branch-restriction-policy`.
        public struct BranchRestrictionPolicy: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/users_url`.
            public var usersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/apps_url`.
            public var appsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload`.
            public struct UsersPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/login`.
                public var login: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/id`.
                public var id: Swift.Int64?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/node_id`.
                public var nodeId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/avatar_url`.
                public var avatarUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/gravatar_id`.
                public var gravatarId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/followers_url`.
                public var followersUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/following_url`.
                public var followingUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/gists_url`.
                public var gistsUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/starred_url`.
                public var starredUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/subscriptions_url`.
                public var subscriptionsUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/organizations_url`.
                public var organizationsUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/repos_url`.
                public var reposUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/events_url`.
                public var eventsUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/received_events_url`.
                public var receivedEventsUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/type`.
                public var _type: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/site_admin`.
                public var siteAdmin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/UsersPayload/user_view_type`.
                public var userViewType: Swift.String?
                /// Creates a new `UsersPayloadPayload`.
                ///
                /// - Parameters:
                ///   - login:
                ///   - id:
                ///   - nodeId:
                ///   - avatarUrl:
                ///   - gravatarId:
                ///   - url:
                ///   - htmlUrl:
                ///   - followersUrl:
                ///   - followingUrl:
                ///   - gistsUrl:
                ///   - starredUrl:
                ///   - subscriptionsUrl:
                ///   - organizationsUrl:
                ///   - reposUrl:
                ///   - eventsUrl:
                ///   - receivedEventsUrl:
                ///   - _type:
                ///   - siteAdmin:
                ///   - userViewType:
                public init(
                    login: Swift.String? = nil,
                    id: Swift.Int64? = nil,
                    nodeId: Swift.String? = nil,
                    avatarUrl: Swift.String? = nil,
                    gravatarId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    followersUrl: Swift.String? = nil,
                    followingUrl: Swift.String? = nil,
                    gistsUrl: Swift.String? = nil,
                    starredUrl: Swift.String? = nil,
                    subscriptionsUrl: Swift.String? = nil,
                    organizationsUrl: Swift.String? = nil,
                    reposUrl: Swift.String? = nil,
                    eventsUrl: Swift.String? = nil,
                    receivedEventsUrl: Swift.String? = nil,
                    _type: Swift.String? = nil,
                    siteAdmin: Swift.Bool? = nil,
                    userViewType: Swift.String? = nil
                ) {
                    self.login = login
                    self.id = id
                    self.nodeId = nodeId
                    self.avatarUrl = avatarUrl
                    self.gravatarId = gravatarId
                    self.url = url
                    self.htmlUrl = htmlUrl
                    self.followersUrl = followersUrl
                    self.followingUrl = followingUrl
                    self.gistsUrl = gistsUrl
                    self.starredUrl = starredUrl
                    self.subscriptionsUrl = subscriptionsUrl
                    self.organizationsUrl = organizationsUrl
                    self.reposUrl = reposUrl
                    self.eventsUrl = eventsUrl
                    self.receivedEventsUrl = receivedEventsUrl
                    self._type = _type
                    self.siteAdmin = siteAdmin
                    self.userViewType = userViewType
                }
                public enum CodingKeys: String, CodingKey {
                    case login
                    case id
                    case nodeId = "node_id"
                    case avatarUrl = "avatar_url"
                    case gravatarId = "gravatar_id"
                    case url
                    case htmlUrl = "html_url"
                    case followersUrl = "followers_url"
                    case followingUrl = "following_url"
                    case gistsUrl = "gists_url"
                    case starredUrl = "starred_url"
                    case subscriptionsUrl = "subscriptions_url"
                    case organizationsUrl = "organizations_url"
                    case reposUrl = "repos_url"
                    case eventsUrl = "events_url"
                    case receivedEventsUrl = "received_events_url"
                    case _type = "type"
                    case siteAdmin = "site_admin"
                    case userViewType = "user_view_type"
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/users`.
            public typealias UsersPayload = [Components.Schemas.BranchRestrictionPolicy.UsersPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/users`.
            public var users: Components.Schemas.BranchRestrictionPolicy.UsersPayload
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload`.
            public struct TeamsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/node_id`.
                public var nodeId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/slug`.
                public var slug: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/description`.
                public var description: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/privacy`.
                public var privacy: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/notification_setting`.
                public var notificationSetting: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/permission`.
                public var permission: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/members_url`.
                public var membersUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/repositories_url`.
                public var repositoriesUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/TeamsPayload/parent`.
                public var parent: Swift.String?
                /// Creates a new `TeamsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - nodeId:
                ///   - url:
                ///   - htmlUrl:
                ///   - name:
                ///   - slug:
                ///   - description:
                ///   - privacy:
                ///   - notificationSetting:
                ///   - permission:
                ///   - membersUrl:
                ///   - repositoriesUrl:
                ///   - parent:
                public init(
                    id: Swift.Int? = nil,
                    nodeId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    name: Swift.String? = nil,
                    slug: Swift.String? = nil,
                    description: Swift.String? = nil,
                    privacy: Swift.String? = nil,
                    notificationSetting: Swift.String? = nil,
                    permission: Swift.String? = nil,
                    membersUrl: Swift.String? = nil,
                    repositoriesUrl: Swift.String? = nil,
                    parent: Swift.String? = nil
                ) {
                    self.id = id
                    self.nodeId = nodeId
                    self.url = url
                    self.htmlUrl = htmlUrl
                    self.name = name
                    self.slug = slug
                    self.description = description
                    self.privacy = privacy
                    self.notificationSetting = notificationSetting
                    self.permission = permission
                    self.membersUrl = membersUrl
                    self.repositoriesUrl = repositoriesUrl
                    self.parent = parent
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case nodeId = "node_id"
                    case url
                    case htmlUrl = "html_url"
                    case name
                    case slug
                    case description
                    case privacy
                    case notificationSetting = "notification_setting"
                    case permission
                    case membersUrl = "members_url"
                    case repositoriesUrl = "repositories_url"
                    case parent
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/teams`.
            public typealias TeamsPayload = [Components.Schemas.BranchRestrictionPolicy.TeamsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/teams`.
            public var teams: Components.Schemas.BranchRestrictionPolicy.TeamsPayload
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload`.
            public struct AppsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/id`.
                public var id: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/slug`.
                public var slug: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/node_id`.
                public var nodeId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner`.
                public struct OwnerPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/login`.
                    public var login: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/id`.
                    public var id: Swift.Int?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/node_id`.
                    public var nodeId: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/url`.
                    public var url: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/repos_url`.
                    public var reposUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/events_url`.
                    public var eventsUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/hooks_url`.
                    public var hooksUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/issues_url`.
                    public var issuesUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/members_url`.
                    public var membersUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/public_members_url`.
                    public var publicMembersUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/avatar_url`.
                    public var avatarUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/description`.
                    public var description: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/gravatar_id`.
                    public var gravatarId: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/html_url`.
                    public var htmlUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/followers_url`.
                    public var followersUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/following_url`.
                    public var followingUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/gists_url`.
                    public var gistsUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/starred_url`.
                    public var starredUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/subscriptions_url`.
                    public var subscriptionsUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/organizations_url`.
                    public var organizationsUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/received_events_url`.
                    public var receivedEventsUrl: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/type`.
                    public var _type: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/site_admin`.
                    public var siteAdmin: Swift.Bool?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner/user_view_type`.
                    public var userViewType: Swift.String?
                    /// Creates a new `OwnerPayload`.
                    ///
                    /// - Parameters:
                    ///   - login:
                    ///   - id:
                    ///   - nodeId:
                    ///   - url:
                    ///   - reposUrl:
                    ///   - eventsUrl:
                    ///   - hooksUrl:
                    ///   - issuesUrl:
                    ///   - membersUrl:
                    ///   - publicMembersUrl:
                    ///   - avatarUrl:
                    ///   - description:
                    ///   - gravatarId:
                    ///   - htmlUrl:
                    ///   - followersUrl:
                    ///   - followingUrl:
                    ///   - gistsUrl:
                    ///   - starredUrl:
                    ///   - subscriptionsUrl:
                    ///   - organizationsUrl:
                    ///   - receivedEventsUrl:
                    ///   - _type:
                    ///   - siteAdmin:
                    ///   - userViewType:
                    public init(
                        login: Swift.String? = nil,
                        id: Swift.Int? = nil,
                        nodeId: Swift.String? = nil,
                        url: Swift.String? = nil,
                        reposUrl: Swift.String? = nil,
                        eventsUrl: Swift.String? = nil,
                        hooksUrl: Swift.String? = nil,
                        issuesUrl: Swift.String? = nil,
                        membersUrl: Swift.String? = nil,
                        publicMembersUrl: Swift.String? = nil,
                        avatarUrl: Swift.String? = nil,
                        description: Swift.String? = nil,
                        gravatarId: Swift.String? = nil,
                        htmlUrl: Swift.String? = nil,
                        followersUrl: Swift.String? = nil,
                        followingUrl: Swift.String? = nil,
                        gistsUrl: Swift.String? = nil,
                        starredUrl: Swift.String? = nil,
                        subscriptionsUrl: Swift.String? = nil,
                        organizationsUrl: Swift.String? = nil,
                        receivedEventsUrl: Swift.String? = nil,
                        _type: Swift.String? = nil,
                        siteAdmin: Swift.Bool? = nil,
                        userViewType: Swift.String? = nil
                    ) {
                        self.login = login
                        self.id = id
                        self.nodeId = nodeId
                        self.url = url
                        self.reposUrl = reposUrl
                        self.eventsUrl = eventsUrl
                        self.hooksUrl = hooksUrl
                        self.issuesUrl = issuesUrl
                        self.membersUrl = membersUrl
                        self.publicMembersUrl = publicMembersUrl
                        self.avatarUrl = avatarUrl
                        self.description = description
                        self.gravatarId = gravatarId
                        self.htmlUrl = htmlUrl
                        self.followersUrl = followersUrl
                        self.followingUrl = followingUrl
                        self.gistsUrl = gistsUrl
                        self.starredUrl = starredUrl
                        self.subscriptionsUrl = subscriptionsUrl
                        self.organizationsUrl = organizationsUrl
                        self.receivedEventsUrl = receivedEventsUrl
                        self._type = _type
                        self.siteAdmin = siteAdmin
                        self.userViewType = userViewType
                    }
                    public enum CodingKeys: String, CodingKey {
                        case login
                        case id
                        case nodeId = "node_id"
                        case url
                        case reposUrl = "repos_url"
                        case eventsUrl = "events_url"
                        case hooksUrl = "hooks_url"
                        case issuesUrl = "issues_url"
                        case membersUrl = "members_url"
                        case publicMembersUrl = "public_members_url"
                        case avatarUrl = "avatar_url"
                        case description
                        case gravatarId = "gravatar_id"
                        case htmlUrl = "html_url"
                        case followersUrl = "followers_url"
                        case followingUrl = "following_url"
                        case gistsUrl = "gists_url"
                        case starredUrl = "starred_url"
                        case subscriptionsUrl = "subscriptions_url"
                        case organizationsUrl = "organizations_url"
                        case receivedEventsUrl = "received_events_url"
                        case _type = "type"
                        case siteAdmin = "site_admin"
                        case userViewType = "user_view_type"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/owner`.
                public var owner: Components.Schemas.BranchRestrictionPolicy.AppsPayloadPayload.OwnerPayload?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/client_id`.
                public var clientId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/description`.
                public var description: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/external_url`.
                public var externalUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/created_at`.
                public var createdAt: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/updated_at`.
                public var updatedAt: Swift.String?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions`.
                public struct PermissionsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions/metadata`.
                    public var metadata: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions/contents`.
                    public var contents: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions/issues`.
                    public var issues: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions/single_file`.
                    public var singleFile: Swift.String?
                    /// Creates a new `PermissionsPayload`.
                    ///
                    /// - Parameters:
                    ///   - metadata:
                    ///   - contents:
                    ///   - issues:
                    ///   - singleFile:
                    public init(
                        metadata: Swift.String? = nil,
                        contents: Swift.String? = nil,
                        issues: Swift.String? = nil,
                        singleFile: Swift.String? = nil
                    ) {
                        self.metadata = metadata
                        self.contents = contents
                        self.issues = issues
                        self.singleFile = singleFile
                    }
                    public enum CodingKeys: String, CodingKey {
                        case metadata
                        case contents
                        case issues
                        case singleFile = "single_file"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/permissions`.
                public var permissions: Components.Schemas.BranchRestrictionPolicy.AppsPayloadPayload.PermissionsPayload?
                /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/AppsPayload/events`.
                public var events: [Swift.String]?
                /// Creates a new `AppsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - id:
                ///   - slug:
                ///   - nodeId:
                ///   - owner:
                ///   - name:
                ///   - clientId:
                ///   - description:
                ///   - externalUrl:
                ///   - htmlUrl:
                ///   - createdAt:
                ///   - updatedAt:
                ///   - permissions:
                ///   - events:
                public init(
                    id: Swift.Int? = nil,
                    slug: Swift.String? = nil,
                    nodeId: Swift.String? = nil,
                    owner: Components.Schemas.BranchRestrictionPolicy.AppsPayloadPayload.OwnerPayload? = nil,
                    name: Swift.String? = nil,
                    clientId: Swift.String? = nil,
                    description: Swift.String? = nil,
                    externalUrl: Swift.String? = nil,
                    htmlUrl: Swift.String? = nil,
                    createdAt: Swift.String? = nil,
                    updatedAt: Swift.String? = nil,
                    permissions: Components.Schemas.BranchRestrictionPolicy.AppsPayloadPayload.PermissionsPayload? = nil,
                    events: [Swift.String]? = nil
                ) {
                    self.id = id
                    self.slug = slug
                    self.nodeId = nodeId
                    self.owner = owner
                    self.name = name
                    self.clientId = clientId
                    self.description = description
                    self.externalUrl = externalUrl
                    self.htmlUrl = htmlUrl
                    self.createdAt = createdAt
                    self.updatedAt = updatedAt
                    self.permissions = permissions
                    self.events = events
                }
                public enum CodingKeys: String, CodingKey {
                    case id
                    case slug
                    case nodeId = "node_id"
                    case owner
                    case name
                    case clientId = "client_id"
                    case description
                    case externalUrl = "external_url"
                    case htmlUrl = "html_url"
                    case createdAt = "created_at"
                    case updatedAt = "updated_at"
                    case permissions
                    case events
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/apps`.
            public typealias AppsPayload = [Components.Schemas.BranchRestrictionPolicy.AppsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/branch-restriction-policy/apps`.
            public var apps: Components.Schemas.BranchRestrictionPolicy.AppsPayload
            /// Creates a new `BranchRestrictionPolicy`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - usersUrl:
            ///   - teamsUrl:
            ///   - appsUrl:
            ///   - users:
            ///   - teams:
            ///   - apps:
            public init(
                url: Swift.String,
                usersUrl: Swift.String,
                teamsUrl: Swift.String,
                appsUrl: Swift.String,
                users: Components.Schemas.BranchRestrictionPolicy.UsersPayload,
                teams: Components.Schemas.BranchRestrictionPolicy.TeamsPayload,
                apps: Components.Schemas.BranchRestrictionPolicy.AppsPayload
            ) {
                self.url = url
                self.usersUrl = usersUrl
                self.teamsUrl = teamsUrl
                self.appsUrl = appsUrl
                self.users = users
                self.teams = teams
                self.apps = apps
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case usersUrl = "users_url"
                case teamsUrl = "teams_url"
                case appsUrl = "apps_url"
                case users
                case teams
                case apps
            }
        }
        /// Branch Protection
        ///
        /// - Remark: Generated from `#/components/schemas/branch-protection`.
        public struct BranchProtection: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/branch-protection/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/branch-protection/enabled`.
            public var enabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_status_checks`.
            public var requiredStatusChecks: Components.Schemas.ProtectedBranchRequiredStatusCheck?
            /// - Remark: Generated from `#/components/schemas/branch-protection/enforce_admins`.
            public var enforceAdmins: Components.Schemas.ProtectedBranchAdminEnforced?
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_pull_request_reviews`.
            public var requiredPullRequestReviews: Components.Schemas.ProtectedBranchPullRequestReview?
            /// - Remark: Generated from `#/components/schemas/branch-protection/restrictions`.
            public var restrictions: Components.Schemas.BranchRestrictionPolicy?
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_linear_history`.
            public struct RequiredLinearHistoryPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/required_linear_history/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `RequiredLinearHistoryPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_linear_history`.
            public var requiredLinearHistory: Components.Schemas.BranchProtection.RequiredLinearHistoryPayload?
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_force_pushes`.
            public struct AllowForcePushesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/allow_force_pushes/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `AllowForcePushesPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_force_pushes`.
            public var allowForcePushes: Components.Schemas.BranchProtection.AllowForcePushesPayload?
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_deletions`.
            public struct AllowDeletionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/allow_deletions/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `AllowDeletionsPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_deletions`.
            public var allowDeletions: Components.Schemas.BranchProtection.AllowDeletionsPayload?
            /// - Remark: Generated from `#/components/schemas/branch-protection/block_creations`.
            public struct BlockCreationsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/block_creations/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `BlockCreationsPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/block_creations`.
            public var blockCreations: Components.Schemas.BranchProtection.BlockCreationsPayload?
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_conversation_resolution`.
            public struct RequiredConversationResolutionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/required_conversation_resolution/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `RequiredConversationResolutionPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_conversation_resolution`.
            public var requiredConversationResolution: Components.Schemas.BranchProtection.RequiredConversationResolutionPayload?
            /// - Remark: Generated from `#/components/schemas/branch-protection/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/branch-protection/protection_url`.
            public var protectionUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_signatures`.
            public struct RequiredSignaturesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/required_signatures/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/branch-protection/required_signatures/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `RequiredSignaturesPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - enabled:
                public init(
                    url: Swift.String,
                    enabled: Swift.Bool
                ) {
                    self.url = url
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-protection/required_signatures`.
            public var requiredSignatures: Components.Schemas.BranchProtection.RequiredSignaturesPayload?
            /// Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///
            /// - Remark: Generated from `#/components/schemas/branch-protection/lock_branch`.
            public struct LockBranchPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/lock_branch/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `LockBranchPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///
            /// - Remark: Generated from `#/components/schemas/branch-protection/lock_branch`.
            public var lockBranch: Components.Schemas.BranchProtection.LockBranchPayload?
            /// Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            ///
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_fork_syncing`.
            public struct AllowForkSyncingPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-protection/allow_fork_syncing/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `AllowForkSyncingPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
            }
            /// Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            ///
            /// - Remark: Generated from `#/components/schemas/branch-protection/allow_fork_syncing`.
            public var allowForkSyncing: Components.Schemas.BranchProtection.AllowForkSyncingPayload?
            /// Creates a new `BranchProtection`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - enabled:
            ///   - requiredStatusChecks:
            ///   - enforceAdmins:
            ///   - requiredPullRequestReviews:
            ///   - restrictions:
            ///   - requiredLinearHistory:
            ///   - allowForcePushes:
            ///   - allowDeletions:
            ///   - blockCreations:
            ///   - requiredConversationResolution:
            ///   - name:
            ///   - protectionUrl:
            ///   - requiredSignatures:
            ///   - lockBranch: Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///   - allowForkSyncing: Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            public init(
                url: Swift.String? = nil,
                enabled: Swift.Bool? = nil,
                requiredStatusChecks: Components.Schemas.ProtectedBranchRequiredStatusCheck? = nil,
                enforceAdmins: Components.Schemas.ProtectedBranchAdminEnforced? = nil,
                requiredPullRequestReviews: Components.Schemas.ProtectedBranchPullRequestReview? = nil,
                restrictions: Components.Schemas.BranchRestrictionPolicy? = nil,
                requiredLinearHistory: Components.Schemas.BranchProtection.RequiredLinearHistoryPayload? = nil,
                allowForcePushes: Components.Schemas.BranchProtection.AllowForcePushesPayload? = nil,
                allowDeletions: Components.Schemas.BranchProtection.AllowDeletionsPayload? = nil,
                blockCreations: Components.Schemas.BranchProtection.BlockCreationsPayload? = nil,
                requiredConversationResolution: Components.Schemas.BranchProtection.RequiredConversationResolutionPayload? = nil,
                name: Swift.String? = nil,
                protectionUrl: Swift.String? = nil,
                requiredSignatures: Components.Schemas.BranchProtection.RequiredSignaturesPayload? = nil,
                lockBranch: Components.Schemas.BranchProtection.LockBranchPayload? = nil,
                allowForkSyncing: Components.Schemas.BranchProtection.AllowForkSyncingPayload? = nil
            ) {
                self.url = url
                self.enabled = enabled
                self.requiredStatusChecks = requiredStatusChecks
                self.enforceAdmins = enforceAdmins
                self.requiredPullRequestReviews = requiredPullRequestReviews
                self.restrictions = restrictions
                self.requiredLinearHistory = requiredLinearHistory
                self.allowForcePushes = allowForcePushes
                self.allowDeletions = allowDeletions
                self.blockCreations = blockCreations
                self.requiredConversationResolution = requiredConversationResolution
                self.name = name
                self.protectionUrl = protectionUrl
                self.requiredSignatures = requiredSignatures
                self.lockBranch = lockBranch
                self.allowForkSyncing = allowForkSyncing
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case enabled
                case requiredStatusChecks = "required_status_checks"
                case enforceAdmins = "enforce_admins"
                case requiredPullRequestReviews = "required_pull_request_reviews"
                case restrictions
                case requiredLinearHistory = "required_linear_history"
                case allowForcePushes = "allow_force_pushes"
                case allowDeletions = "allow_deletions"
                case blockCreations = "block_creations"
                case requiredConversationResolution = "required_conversation_resolution"
                case name
                case protectionUrl = "protection_url"
                case requiredSignatures = "required_signatures"
                case lockBranch = "lock_branch"
                case allowForkSyncing = "allow_fork_syncing"
            }
        }
        /// Short Branch
        ///
        /// - Remark: Generated from `#/components/schemas/short-branch`.
        public struct ShortBranch: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/short-branch/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/short-branch/commit`.
            public struct CommitPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/short-branch/commit/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/short-branch/commit/url`.
                public var url: Swift.String
                /// Creates a new `CommitPayload`.
                ///
                /// - Parameters:
                ///   - sha:
                ///   - url:
                public init(
                    sha: Swift.String,
                    url: Swift.String
                ) {
                    self.sha = sha
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                }
            }
            /// - Remark: Generated from `#/components/schemas/short-branch/commit`.
            public var commit: Components.Schemas.ShortBranch.CommitPayload
            /// - Remark: Generated from `#/components/schemas/short-branch/protected`.
            public var protected: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/short-branch/protection`.
            public var protection: Components.Schemas.BranchProtection?
            /// - Remark: Generated from `#/components/schemas/short-branch/protection_url`.
            public var protectionUrl: Swift.String?
            /// Creates a new `ShortBranch`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - commit:
            ///   - protected:
            ///   - protection:
            ///   - protectionUrl:
            public init(
                name: Swift.String,
                commit: Components.Schemas.ShortBranch.CommitPayload,
                protected: Swift.Bool,
                protection: Components.Schemas.BranchProtection? = nil,
                protectionUrl: Swift.String? = nil
            ) {
                self.name = name
                self.commit = commit
                self.protected = protected
                self.protection = protection
                self.protectionUrl = protectionUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case commit
                case protected
                case protection
                case protectionUrl = "protection_url"
            }
        }
        /// Metaproperties for Git author/committer information.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-git-user`.
        public struct NullableGitUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-git-user/date`.
            public var date: Swift.String?
            /// Creates a new `NullableGitUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - date:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                date: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.date = date
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case date
            }
        }
        /// - Remark: Generated from `#/components/schemas/verification`.
        public struct Verification: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/verification/verified`.
            public var verified: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/verification/reason`.
            public var reason: Swift.String
            /// - Remark: Generated from `#/components/schemas/verification/payload`.
            public var payload: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/signature`.
            public var signature: Swift.String?
            /// - Remark: Generated from `#/components/schemas/verification/verified_at`.
            public var verifiedAt: Swift.String?
            /// Creates a new `Verification`.
            ///
            /// - Parameters:
            ///   - verified:
            ///   - reason:
            ///   - payload:
            ///   - signature:
            ///   - verifiedAt:
            public init(
                verified: Swift.Bool,
                reason: Swift.String,
                payload: Swift.String? = nil,
                signature: Swift.String? = nil,
                verifiedAt: Swift.String? = nil
            ) {
                self.verified = verified
                self.reason = reason
                self.payload = payload
                self.signature = signature
                self.verifiedAt = verifiedAt
            }
            public enum CodingKeys: String, CodingKey {
                case verified
                case reason
                case payload
                case signature
                case verifiedAt = "verified_at"
            }
        }
        /// Diff Entry
        ///
        /// - Remark: Generated from `#/components/schemas/diff-entry`.
        public struct DiffEntry: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/diff-entry/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/filename`.
            public var filename: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case added = "added"
                case removed = "removed"
                case modified = "modified"
                case renamed = "renamed"
                case copied = "copied"
                case changed = "changed"
                case unchanged = "unchanged"
            }
            /// - Remark: Generated from `#/components/schemas/diff-entry/status`.
            public var status: Components.Schemas.DiffEntry.StatusPayload
            /// - Remark: Generated from `#/components/schemas/diff-entry/additions`.
            public var additions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/deletions`.
            public var deletions: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/changes`.
            public var changes: Swift.Int
            /// - Remark: Generated from `#/components/schemas/diff-entry/blob_url`.
            public var blobUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/raw_url`.
            public var rawUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/diff-entry/patch`.
            public var patch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/diff-entry/previous_filename`.
            public var previousFilename: Swift.String?
            /// Creates a new `DiffEntry`.
            ///
            /// - Parameters:
            ///   - sha:
            ///   - filename:
            ///   - status:
            ///   - additions:
            ///   - deletions:
            ///   - changes:
            ///   - blobUrl:
            ///   - rawUrl:
            ///   - contentsUrl:
            ///   - patch:
            ///   - previousFilename:
            public init(
                sha: Swift.String,
                filename: Swift.String,
                status: Components.Schemas.DiffEntry.StatusPayload,
                additions: Swift.Int,
                deletions: Swift.Int,
                changes: Swift.Int,
                blobUrl: Swift.String,
                rawUrl: Swift.String,
                contentsUrl: Swift.String,
                patch: Swift.String? = nil,
                previousFilename: Swift.String? = nil
            ) {
                self.sha = sha
                self.filename = filename
                self.status = status
                self.additions = additions
                self.deletions = deletions
                self.changes = changes
                self.blobUrl = blobUrl
                self.rawUrl = rawUrl
                self.contentsUrl = contentsUrl
                self.patch = patch
                self.previousFilename = previousFilename
            }
            public enum CodingKeys: String, CodingKey {
                case sha
                case filename
                case status
                case additions
                case deletions
                case changes
                case blobUrl = "blob_url"
                case rawUrl = "raw_url"
                case contentsUrl = "contents_url"
                case patch
                case previousFilename = "previous_filename"
            }
        }
        /// Commit
        ///
        /// - Remark: Generated from `#/components/schemas/commit`.
        public struct Commit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/commit/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/commit/commit`.
            public struct CommitPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/commit/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/commit/author`.
                public var author: Components.Schemas.NullableGitUser?
                /// - Remark: Generated from `#/components/schemas/commit/commit/committer`.
                public var committer: Components.Schemas.NullableGitUser?
                /// - Remark: Generated from `#/components/schemas/commit/commit/message`.
                public var message: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/commit/comment_count`.
                public var commentCount: Swift.Int
                /// - Remark: Generated from `#/components/schemas/commit/commit/tree`.
                public struct TreePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/commit/commit/tree/sha`.
                    public var sha: Swift.String
                    /// - Remark: Generated from `#/components/schemas/commit/commit/tree/url`.
                    public var url: Swift.String
                    /// Creates a new `TreePayload`.
                    ///
                    /// - Parameters:
                    ///   - sha:
                    ///   - url:
                    public init(
                        sha: Swift.String,
                        url: Swift.String
                    ) {
                        self.sha = sha
                        self.url = url
                    }
                    public enum CodingKeys: String, CodingKey {
                        case sha
                        case url
                    }
                }
                /// - Remark: Generated from `#/components/schemas/commit/commit/tree`.
                public var tree: Components.Schemas.Commit.CommitPayload.TreePayload
                /// - Remark: Generated from `#/components/schemas/commit/commit/verification`.
                public var verification: Components.Schemas.Verification?
                /// Creates a new `CommitPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - author:
                ///   - committer:
                ///   - message:
                ///   - commentCount:
                ///   - tree:
                ///   - verification:
                public init(
                    url: Swift.String,
                    author: Components.Schemas.NullableGitUser? = nil,
                    committer: Components.Schemas.NullableGitUser? = nil,
                    message: Swift.String,
                    commentCount: Swift.Int,
                    tree: Components.Schemas.Commit.CommitPayload.TreePayload,
                    verification: Components.Schemas.Verification? = nil
                ) {
                    self.url = url
                    self.author = author
                    self.committer = committer
                    self.message = message
                    self.commentCount = commentCount
                    self.tree = tree
                    self.verification = verification
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case author
                    case committer
                    case message
                    case commentCount = "comment_count"
                    case tree
                    case verification
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/commit`.
            public var commit: Components.Schemas.Commit.CommitPayload
            /// - Remark: Generated from `#/components/schemas/commit/author`.
            @frozen public enum AuthorPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/author/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/commit/author/case2`.
                case EmptyObject(Components.Schemas.EmptyObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .EmptyObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .EmptyObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/author`.
            public var author: Components.Schemas.Commit.AuthorPayload?
            /// - Remark: Generated from `#/components/schemas/commit/committer`.
            @frozen public enum CommitterPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/committer/case1`.
                case SimpleUser(Components.Schemas.SimpleUser)
                /// - Remark: Generated from `#/components/schemas/commit/committer/case2`.
                case EmptyObject(Components.Schemas.EmptyObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .SimpleUser(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .EmptyObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .SimpleUser(value):
                        try value.encode(to: encoder)
                    case let .EmptyObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/committer`.
            public var committer: Components.Schemas.Commit.CommitterPayload?
            /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload`.
            public struct ParentsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/sha`.
                public var sha: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/commit/ParentsPayload/html_url`.
                public var htmlUrl: Swift.String?
                /// Creates a new `ParentsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - sha:
                ///   - url:
                ///   - htmlUrl:
                public init(
                    sha: Swift.String,
                    url: Swift.String,
                    htmlUrl: Swift.String? = nil
                ) {
                    self.sha = sha
                    self.url = url
                    self.htmlUrl = htmlUrl
                }
                public enum CodingKeys: String, CodingKey {
                    case sha
                    case url
                    case htmlUrl = "html_url"
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/parents`.
            public typealias ParentsPayload = [Components.Schemas.Commit.ParentsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/commit/parents`.
            public var parents: Components.Schemas.Commit.ParentsPayload
            /// - Remark: Generated from `#/components/schemas/commit/stats`.
            public struct StatsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/commit/stats/additions`.
                public var additions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/commit/stats/deletions`.
                public var deletions: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/commit/stats/total`.
                public var total: Swift.Int?
                /// Creates a new `StatsPayload`.
                ///
                /// - Parameters:
                ///   - additions:
                ///   - deletions:
                ///   - total:
                public init(
                    additions: Swift.Int? = nil,
                    deletions: Swift.Int? = nil,
                    total: Swift.Int? = nil
                ) {
                    self.additions = additions
                    self.deletions = deletions
                    self.total = total
                }
                public enum CodingKeys: String, CodingKey {
                    case additions
                    case deletions
                    case total
                }
            }
            /// - Remark: Generated from `#/components/schemas/commit/stats`.
            public var stats: Components.Schemas.Commit.StatsPayload?
            /// - Remark: Generated from `#/components/schemas/commit/files`.
            public var files: [Components.Schemas.DiffEntry]?
            /// Creates a new `Commit`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - sha:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - commentsUrl:
            ///   - commit:
            ///   - author:
            ///   - committer:
            ///   - parents:
            ///   - stats:
            ///   - files:
            public init(
                url: Swift.String,
                sha: Swift.String,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                commentsUrl: Swift.String,
                commit: Components.Schemas.Commit.CommitPayload,
                author: Components.Schemas.Commit.AuthorPayload? = nil,
                committer: Components.Schemas.Commit.CommitterPayload? = nil,
                parents: Components.Schemas.Commit.ParentsPayload,
                stats: Components.Schemas.Commit.StatsPayload? = nil,
                files: [Components.Schemas.DiffEntry]? = nil
            ) {
                self.url = url
                self.sha = sha
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.commentsUrl = commentsUrl
                self.commit = commit
                self.author = author
                self.committer = committer
                self.parents = parents
                self.stats = stats
                self.files = files
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case sha
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case commentsUrl = "comments_url"
                case commit
                case author
                case committer
                case parents
                case stats
                case files
            }
        }
        /// Branch With Protection
        ///
        /// - Remark: Generated from `#/components/schemas/branch-with-protection`.
        public struct BranchWithProtection: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/commit`.
            public var commit: Components.Schemas.Commit
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/branch-with-protection/_links/html`.
                public var html: Swift.String
                /// - Remark: Generated from `#/components/schemas/branch-with-protection/_links/self`.
                public var _self: Swift.String
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - html:
                ///   - _self:
                public init(
                    html: Swift.String,
                    _self: Swift.String
                ) {
                    self.html = html
                    self._self = _self
                }
                public enum CodingKeys: String, CodingKey {
                    case html
                    case _self = "self"
                }
            }
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/_links`.
            public var _links: Components.Schemas.BranchWithProtection._LinksPayload
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/protected`.
            public var protected: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/protection`.
            public var protection: Components.Schemas.BranchProtection
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/protection_url`.
            public var protectionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/pattern`.
            public var pattern: Swift.String?
            /// - Remark: Generated from `#/components/schemas/branch-with-protection/required_approving_review_count`.
            public var requiredApprovingReviewCount: Swift.Int?
            /// Creates a new `BranchWithProtection`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - commit:
            ///   - _links:
            ///   - protected:
            ///   - protection:
            ///   - protectionUrl:
            ///   - pattern:
            ///   - requiredApprovingReviewCount:
            public init(
                name: Swift.String,
                commit: Components.Schemas.Commit,
                _links: Components.Schemas.BranchWithProtection._LinksPayload,
                protected: Swift.Bool,
                protection: Components.Schemas.BranchProtection,
                protectionUrl: Swift.String,
                pattern: Swift.String? = nil,
                requiredApprovingReviewCount: Swift.Int? = nil
            ) {
                self.name = name
                self.commit = commit
                self._links = _links
                self.protected = protected
                self.protection = protection
                self.protectionUrl = protectionUrl
                self.pattern = pattern
                self.requiredApprovingReviewCount = requiredApprovingReviewCount
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case commit
                case _links
                case protected
                case protection
                case protectionUrl = "protection_url"
                case pattern
                case requiredApprovingReviewCount = "required_approving_review_count"
            }
        }
        /// Status Check Policy
        ///
        /// - Remark: Generated from `#/components/schemas/status-check-policy`.
        public struct StatusCheckPolicy: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/status-check-policy/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/status-check-policy/strict`.
            public var strict: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/status-check-policy/contexts`.
            public var contexts: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/status-check-policy/ChecksPayload`.
            public struct ChecksPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/status-check-policy/ChecksPayload/context`.
                public var context: Swift.String
                /// - Remark: Generated from `#/components/schemas/status-check-policy/ChecksPayload/app_id`.
                public var appId: Swift.Int?
                /// Creates a new `ChecksPayloadPayload`.
                ///
                /// - Parameters:
                ///   - context:
                ///   - appId:
                public init(
                    context: Swift.String,
                    appId: Swift.Int? = nil
                ) {
                    self.context = context
                    self.appId = appId
                }
                public enum CodingKeys: String, CodingKey {
                    case context
                    case appId = "app_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/status-check-policy/checks`.
            public typealias ChecksPayload = [Components.Schemas.StatusCheckPolicy.ChecksPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/status-check-policy/checks`.
            public var checks: Components.Schemas.StatusCheckPolicy.ChecksPayload
            /// - Remark: Generated from `#/components/schemas/status-check-policy/contexts_url`.
            public var contextsUrl: Swift.String
            /// Creates a new `StatusCheckPolicy`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - strict:
            ///   - contexts:
            ///   - checks:
            ///   - contextsUrl:
            public init(
                url: Swift.String,
                strict: Swift.Bool,
                contexts: [Swift.String],
                checks: Components.Schemas.StatusCheckPolicy.ChecksPayload,
                contextsUrl: Swift.String
            ) {
                self.url = url
                self.strict = strict
                self.contexts = contexts
                self.checks = checks
                self.contextsUrl = contextsUrl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case strict
                case contexts
                case checks
                case contextsUrl = "contexts_url"
            }
        }
        /// Branch protections protect branches
        ///
        /// - Remark: Generated from `#/components/schemas/protected-branch`.
        public struct ProtectedBranch: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/protected-branch/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_status_checks`.
            public var requiredStatusChecks: Components.Schemas.StatusCheckPolicy?
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews`.
            public struct RequiredPullRequestReviewsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismiss_stale_reviews`.
                public var dismissStaleReviews: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/require_code_owner_reviews`.
                public var requireCodeOwnerReviews: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/required_approving_review_count`.
                public var requiredApprovingReviewCount: Swift.Int?
                /// Whether the most recent push must be approved by someone other than the person who pushed it.
                ///
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/require_last_push_approval`.
                public var requireLastPushApproval: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions`.
                public struct DismissalRestrictionsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/url`.
                    public var url: Swift.String
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/users_url`.
                    public var usersUrl: Swift.String
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/teams_url`.
                    public var teamsUrl: Swift.String
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/users`.
                    public var users: [Components.Schemas.SimpleUser]
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/teams`.
                    public var teams: [Components.Schemas.Team]
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions/apps`.
                    public var apps: [Components.Schemas.Integration]?
                    /// Creates a new `DismissalRestrictionsPayload`.
                    ///
                    /// - Parameters:
                    ///   - url:
                    ///   - usersUrl:
                    ///   - teamsUrl:
                    ///   - users:
                    ///   - teams:
                    ///   - apps:
                    public init(
                        url: Swift.String,
                        usersUrl: Swift.String,
                        teamsUrl: Swift.String,
                        users: [Components.Schemas.SimpleUser],
                        teams: [Components.Schemas.Team],
                        apps: [Components.Schemas.Integration]? = nil
                    ) {
                        self.url = url
                        self.usersUrl = usersUrl
                        self.teamsUrl = teamsUrl
                        self.users = users
                        self.teams = teams
                        self.apps = apps
                    }
                    public enum CodingKeys: String, CodingKey {
                        case url
                        case usersUrl = "users_url"
                        case teamsUrl = "teams_url"
                        case users
                        case teams
                        case apps
                    }
                }
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/dismissal_restrictions`.
                public var dismissalRestrictions: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload.DismissalRestrictionsPayload?
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/bypass_pull_request_allowances`.
                public struct BypassPullRequestAllowancesPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/bypass_pull_request_allowances/users`.
                    public var users: [Components.Schemas.SimpleUser]
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/bypass_pull_request_allowances/teams`.
                    public var teams: [Components.Schemas.Team]
                    /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/bypass_pull_request_allowances/apps`.
                    public var apps: [Components.Schemas.Integration]?
                    /// Creates a new `BypassPullRequestAllowancesPayload`.
                    ///
                    /// - Parameters:
                    ///   - users:
                    ///   - teams:
                    ///   - apps:
                    public init(
                        users: [Components.Schemas.SimpleUser],
                        teams: [Components.Schemas.Team],
                        apps: [Components.Schemas.Integration]? = nil
                    ) {
                        self.users = users
                        self.teams = teams
                        self.apps = apps
                    }
                    public enum CodingKeys: String, CodingKey {
                        case users
                        case teams
                        case apps
                    }
                }
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews/bypass_pull_request_allowances`.
                public var bypassPullRequestAllowances: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload.BypassPullRequestAllowancesPayload?
                /// Creates a new `RequiredPullRequestReviewsPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - dismissStaleReviews:
                ///   - requireCodeOwnerReviews:
                ///   - requiredApprovingReviewCount:
                ///   - requireLastPushApproval: Whether the most recent push must be approved by someone other than the person who pushed it.
                ///   - dismissalRestrictions:
                ///   - bypassPullRequestAllowances:
                public init(
                    url: Swift.String,
                    dismissStaleReviews: Swift.Bool? = nil,
                    requireCodeOwnerReviews: Swift.Bool? = nil,
                    requiredApprovingReviewCount: Swift.Int? = nil,
                    requireLastPushApproval: Swift.Bool? = nil,
                    dismissalRestrictions: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload.DismissalRestrictionsPayload? = nil,
                    bypassPullRequestAllowances: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload.BypassPullRequestAllowancesPayload? = nil
                ) {
                    self.url = url
                    self.dismissStaleReviews = dismissStaleReviews
                    self.requireCodeOwnerReviews = requireCodeOwnerReviews
                    self.requiredApprovingReviewCount = requiredApprovingReviewCount
                    self.requireLastPushApproval = requireLastPushApproval
                    self.dismissalRestrictions = dismissalRestrictions
                    self.bypassPullRequestAllowances = bypassPullRequestAllowances
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case dismissStaleReviews = "dismiss_stale_reviews"
                    case requireCodeOwnerReviews = "require_code_owner_reviews"
                    case requiredApprovingReviewCount = "required_approving_review_count"
                    case requireLastPushApproval = "require_last_push_approval"
                    case dismissalRestrictions = "dismissal_restrictions"
                    case bypassPullRequestAllowances = "bypass_pull_request_allowances"
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_pull_request_reviews`.
            public var requiredPullRequestReviews: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_signatures`.
            public struct RequiredSignaturesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_signatures/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_signatures/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `RequiredSignaturesPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - enabled:
                public init(
                    url: Swift.String,
                    enabled: Swift.Bool
                ) {
                    self.url = url
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case enabled
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_signatures`.
            public var requiredSignatures: Components.Schemas.ProtectedBranch.RequiredSignaturesPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/enforce_admins`.
            public struct EnforceAdminsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/enforce_admins/url`.
                public var url: Swift.String
                /// - Remark: Generated from `#/components/schemas/protected-branch/enforce_admins/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `EnforceAdminsPayload`.
                ///
                /// - Parameters:
                ///   - url:
                ///   - enabled:
                public init(
                    url: Swift.String,
                    enabled: Swift.Bool
                ) {
                    self.url = url
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.url = try container.decode(
                        Swift.String.self,
                        forKey: .url
                    )
                    self.enabled = try container.decode(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "url",
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/enforce_admins`.
            public var enforceAdmins: Components.Schemas.ProtectedBranch.EnforceAdminsPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_linear_history`.
            public struct RequiredLinearHistoryPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_linear_history/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `RequiredLinearHistoryPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decode(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_linear_history`.
            public var requiredLinearHistory: Components.Schemas.ProtectedBranch.RequiredLinearHistoryPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_force_pushes`.
            public struct AllowForcePushesPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/allow_force_pushes/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `AllowForcePushesPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decode(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_force_pushes`.
            public var allowForcePushes: Components.Schemas.ProtectedBranch.AllowForcePushesPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_deletions`.
            public struct AllowDeletionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/allow_deletions/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `AllowDeletionsPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decode(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_deletions`.
            public var allowDeletions: Components.Schemas.ProtectedBranch.AllowDeletionsPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/restrictions`.
            public var restrictions: Components.Schemas.BranchRestrictionPolicy?
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_conversation_resolution`.
            public struct RequiredConversationResolutionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/required_conversation_resolution/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `RequiredConversationResolutionPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decodeIfPresent(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/required_conversation_resolution`.
            public var requiredConversationResolution: Components.Schemas.ProtectedBranch.RequiredConversationResolutionPayload?
            /// - Remark: Generated from `#/components/schemas/protected-branch/block_creations`.
            public struct BlockCreationsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/block_creations/enabled`.
                public var enabled: Swift.Bool
                /// Creates a new `BlockCreationsPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decode(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// - Remark: Generated from `#/components/schemas/protected-branch/block_creations`.
            public var blockCreations: Components.Schemas.ProtectedBranch.BlockCreationsPayload?
            /// Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch/lock_branch`.
            public struct LockBranchPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/lock_branch/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `LockBranchPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decodeIfPresent(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch/lock_branch`.
            public var lockBranch: Components.Schemas.ProtectedBranch.LockBranchPayload?
            /// Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_fork_syncing`.
            public struct AllowForkSyncingPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/protected-branch/allow_fork_syncing/enabled`.
                public var enabled: Swift.Bool?
                /// Creates a new `AllowForkSyncingPayload`.
                ///
                /// - Parameters:
                ///   - enabled:
                public init(enabled: Swift.Bool? = nil) {
                    self.enabled = enabled
                }
                public enum CodingKeys: String, CodingKey {
                    case enabled
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.enabled = try container.decodeIfPresent(
                        Swift.Bool.self,
                        forKey: .enabled
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "enabled"
                    ])
                }
            }
            /// Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            ///
            /// - Remark: Generated from `#/components/schemas/protected-branch/allow_fork_syncing`.
            public var allowForkSyncing: Components.Schemas.ProtectedBranch.AllowForkSyncingPayload?
            /// Creates a new `ProtectedBranch`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - requiredStatusChecks:
            ///   - requiredPullRequestReviews:
            ///   - requiredSignatures:
            ///   - enforceAdmins:
            ///   - requiredLinearHistory:
            ///   - allowForcePushes:
            ///   - allowDeletions:
            ///   - restrictions:
            ///   - requiredConversationResolution:
            ///   - blockCreations:
            ///   - lockBranch: Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
            ///   - allowForkSyncing: Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
            public init(
                url: Swift.String,
                requiredStatusChecks: Components.Schemas.StatusCheckPolicy? = nil,
                requiredPullRequestReviews: Components.Schemas.ProtectedBranch.RequiredPullRequestReviewsPayload? = nil,
                requiredSignatures: Components.Schemas.ProtectedBranch.RequiredSignaturesPayload? = nil,
                enforceAdmins: Components.Schemas.ProtectedBranch.EnforceAdminsPayload? = nil,
                requiredLinearHistory: Components.Schemas.ProtectedBranch.RequiredLinearHistoryPayload? = nil,
                allowForcePushes: Components.Schemas.ProtectedBranch.AllowForcePushesPayload? = nil,
                allowDeletions: Components.Schemas.ProtectedBranch.AllowDeletionsPayload? = nil,
                restrictions: Components.Schemas.BranchRestrictionPolicy? = nil,
                requiredConversationResolution: Components.Schemas.ProtectedBranch.RequiredConversationResolutionPayload? = nil,
                blockCreations: Components.Schemas.ProtectedBranch.BlockCreationsPayload? = nil,
                lockBranch: Components.Schemas.ProtectedBranch.LockBranchPayload? = nil,
                allowForkSyncing: Components.Schemas.ProtectedBranch.AllowForkSyncingPayload? = nil
            ) {
                self.url = url
                self.requiredStatusChecks = requiredStatusChecks
                self.requiredPullRequestReviews = requiredPullRequestReviews
                self.requiredSignatures = requiredSignatures
                self.enforceAdmins = enforceAdmins
                self.requiredLinearHistory = requiredLinearHistory
                self.allowForcePushes = allowForcePushes
                self.allowDeletions = allowDeletions
                self.restrictions = restrictions
                self.requiredConversationResolution = requiredConversationResolution
                self.blockCreations = blockCreations
                self.lockBranch = lockBranch
                self.allowForkSyncing = allowForkSyncing
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case requiredStatusChecks = "required_status_checks"
                case requiredPullRequestReviews = "required_pull_request_reviews"
                case requiredSignatures = "required_signatures"
                case enforceAdmins = "enforce_admins"
                case requiredLinearHistory = "required_linear_history"
                case allowForcePushes = "allow_force_pushes"
                case allowDeletions = "allow_deletions"
                case restrictions
                case requiredConversationResolution = "required_conversation_resolution"
                case blockCreations = "block_creations"
                case lockBranch = "lock_branch"
                case allowForkSyncing = "allow_fork_syncing"
            }
        }
        /// A list of errors found in a repo's CODEOWNERS file
        ///
        /// - Remark: Generated from `#/components/schemas/codeowners-errors`.
        public struct CodeownersErrors: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// The line number where this errors occurs.
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/line`.
                public var line: Swift.Int
                /// The column number where this errors occurs.
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/column`.
                public var column: Swift.Int
                /// The contents of the line where the error occurs.
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/source`.
                public var source: Swift.String?
                /// The type of error.
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/kind`.
                public var kind: Swift.String
                /// Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/suggestion`.
                public var suggestion: Swift.String?
                /// A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).
                ///
                /// - Remark: Generated from `#/components/schemas/codeowners-errors/ErrorsPayload/message`.
                public var message: Swift.String
                /// 