// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List organization migrations
    ///
    /// Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).
    ///
    /// A list of `repositories` is only returned for export migrations.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/get(migrations/list-for-org)`.
    func migrationsListForOrg(_ input: Operations.MigrationsListForOrg.Input) async throws -> Operations.MigrationsListForOrg.Output
    /// Start an organization migration
    ///
    /// Initiates the generation of a migration archive.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)`.
    func migrationsStartForOrg(_ input: Operations.MigrationsStartForOrg.Input) async throws -> Operations.MigrationsStartForOrg.Output
    /// Get an organization migration status
    ///
    /// Fetches the status of a migration.
    ///
    /// The `state` of a migration can be one of the following values:
    ///
    /// *   `pending`, which means the migration hasn't started yet.
    /// *   `exporting`, which means the migration is in progress.
    /// *   `exported`, which means the migration finished successfully.
    /// *   `failed`, which means the migration failed.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/get(migrations/get-status-for-org)`.
    func migrationsGetStatusForOrg(_ input: Operations.MigrationsGetStatusForOrg.Input) async throws -> Operations.MigrationsGetStatusForOrg.Output
    /// Download an organization migration archive
    ///
    /// Fetches the URL to a migration archive.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)`.
    func migrationsDownloadArchiveForOrg(_ input: Operations.MigrationsDownloadArchiveForOrg.Input) async throws -> Operations.MigrationsDownloadArchiveForOrg.Output
    /// Delete an organization migration archive
    ///
    /// Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)`.
    func migrationsDeleteArchiveForOrg(_ input: Operations.MigrationsDeleteArchiveForOrg.Input) async throws -> Operations.MigrationsDeleteArchiveForOrg.Output
    /// Unlock an organization repository
    ///
    /// Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)`.
    func migrationsUnlockRepoForOrg(_ input: Operations.MigrationsUnlockRepoForOrg.Input) async throws -> Operations.MigrationsUnlockRepoForOrg.Output
    /// List repositories in an organization migration
    ///
    /// List all the repositories for this organization migration.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repositories/get(migrations/list-repos-for-org)`.
    func migrationsListReposForOrg(_ input: Operations.MigrationsListReposForOrg.Input) async throws -> Operations.MigrationsListReposForOrg.Output
    /// Get an import status
    ///
    /// View the progress of an import.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// **Import status**
    ///
    /// This section includes details about the possible values of the `status` field of the Import Progress response.
    ///
    /// An import that does not have errors will progress through these steps:
    ///
    /// *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
    /// *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
    /// *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
    /// *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
    /// *   `complete` - the import is complete, and the repository is ready on GitHub.
    ///
    /// If there are problems, you will see one of these in the `status` field:
    ///
    /// *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
    /// *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/migrations/source-imports#cancel-an-import) and [retry](https://docs.github.com/rest/migrations/source-imports#start-an-import) with the correct URL.
    /// *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    ///
    /// **The project_choices field**
    ///
    /// When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
    ///
    /// **Git LFS related fields**
    ///
    /// This section includes details about Git LFS related fields that may be present in the Import Progress response.
    ///
    /// *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
    /// *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
    /// *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
    /// *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)`.
    @available(*, deprecated)
    func migrationsGetImportStatus(_ input: Operations.MigrationsGetImportStatus.Input) async throws -> Operations.MigrationsGetImportStatus.Output
    /// Update an import
    ///
    /// An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
    /// request. If no parameters are provided, the import will be restarted.
    ///
    /// Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
    /// have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
    /// You can select the project to import by providing one of the objects in the `project_choices` array in the update request.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/patch(migrations/update-import)`.
    @available(*, deprecated)
    func migrationsUpdateImport(_ input: Operations.MigrationsUpdateImport.Input) async throws -> Operations.MigrationsUpdateImport.Output
    /// Start an import
    ///
    /// Start a source import to a GitHub repository using GitHub Importer.
    /// Importing into a GitHub repository with GitHub Actions enabled is not supported and will
    /// return a status `422 Unprocessable Entity` response.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)`.
    @available(*, deprecated)
    func migrationsStartImport(_ input: Operations.MigrationsStartImport.Input) async throws -> Operations.MigrationsStartImport.Output
    /// Cancel an import
    ///
    /// Stop an import for a repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)`.
    @available(*, deprecated)
    func migrationsCancelImport(_ input: Operations.MigrationsCancelImport.Input) async throws -> Operations.MigrationsCancelImport.Output
    /// Get commit authors
    ///
    /// Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
    ///
    /// This endpoint and the [Map a commit author](https://docs.github.com/rest/migrations/source-imports#map-a-commit-author) endpoint allow you to provide correct Git author information.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/authors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)`.
    @available(*, deprecated)
    func migrationsGetCommitAuthors(_ input: Operations.MigrationsGetCommitAuthors.Input) async throws -> Operations.MigrationsGetCommitAuthors.Output
    /// Map a commit author
    ///
    /// Update an author's identity for the import. Your application can continue updating authors any time before you push
    /// new commits to the repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/authors/{author_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)`.
    @available(*, deprecated)
    func migrationsMapCommitAuthor(_ input: Operations.MigrationsMapCommitAuthor.Input) async throws -> Operations.MigrationsMapCommitAuthor.Output
    /// Get large files
    ///
    /// List files larger than 100MB found during the import
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/large_files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/large_files/get(migrations/get-large-files)`.
    @available(*, deprecated)
    func migrationsGetLargeFiles(_ input: Operations.MigrationsGetLargeFiles.Input) async throws -> Operations.MigrationsGetLargeFiles.Output
    /// Update Git LFS preference
    ///
    /// You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability
    /// is powered by [Git LFS](https://git-lfs.com).
    ///
    /// You can learn more about our LFS feature and working with large files [on our help
    /// site](https://docs.github.com/repositories/working-with-files/managing-large-files).
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/lfs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)`.
    @available(*, deprecated)
    func migrationsSetLfsPreference(_ input: Operations.MigrationsSetLfsPreference.Input) async throws -> Operations.MigrationsSetLfsPreference.Output
    /// List user migrations
    ///
    /// Lists all migrations a user has started.
    ///
    /// - Remark: HTTP `GET /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)`.
    func migrationsListForAuthenticatedUser(_ input: Operations.MigrationsListForAuthenticatedUser.Input) async throws -> Operations.MigrationsListForAuthenticatedUser.Output
    /// Start a user migration
    ///
    /// Initiates the generation of a user migration archive.
    ///
    /// - Remark: HTTP `POST /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)`.
    func migrationsStartForAuthenticatedUser(_ input: Operations.MigrationsStartForAuthenticatedUser.Input) async throws -> Operations.MigrationsStartForAuthenticatedUser.Output
    /// Get a user migration status
    ///
    /// Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
    ///
    /// *   `pending` - the migration hasn't started yet.
    /// *   `exporting` - the migration is in progress.
    /// *   `exported` - the migration finished successfully.
    /// *   `failed` - the migration failed.
    ///
    /// Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/migrations/users#download-a-user-migration-archive).
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)`.
    func migrationsGetStatusForAuthenticatedUser(_ input: Operations.MigrationsGetStatusForAuthenticatedUser.Input) async throws -> Operations.MigrationsGetStatusForAuthenticatedUser.Output
    /// Download a user migration archive
    ///
    /// Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
    ///
    /// *   attachments
    /// *   bases
    /// *   commit\_comments
    /// *   issue\_comments
    /// *   issue\_events
    /// *   issues
    /// *   milestones
    /// *   organizations
    /// *   projects
    /// *   protected\_branches
    /// *   pull\_request\_reviews
    /// *   pull\_requests
    /// *   releases
    /// *   repositories
    /// *   review\_comments
    /// *   schema
    /// *   users
    ///
    /// The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)`.
    func migrationsGetArchiveForAuthenticatedUser(_ input: Operations.MigrationsGetArchiveForAuthenticatedUser.Input) async throws -> Operations.MigrationsGetArchiveForAuthenticatedUser.Output
    /// Delete a user migration archive
    ///
    /// Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/migrations/users#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/migrations/users#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)`.
    func migrationsDeleteArchiveForAuthenticatedUser(_ input: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input) async throws -> Operations.MigrationsDeleteArchiveForAuthenticatedUser.Output
    /// Unlock a user repository
    ///
    /// Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/migrations/users#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/repos/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)`.
    func migrationsUnlockRepoForAuthenticatedUser(_ input: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input) async throws -> Operations.MigrationsUnlockRepoForAuthenticatedUser.Output
    /// List repositories for a user migration
    ///
    /// Lists all the repositories for this user migration.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repositories/get(migrations/list-repos-for-authenticated-user)`.
    func migrationsListReposForAuthenticatedUser(_ input: Operations.MigrationsListReposForAuthenticatedUser.Input) async throws -> Operations.MigrationsListReposForAuthenticatedUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List organization migrations
    ///
    /// Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).
    ///
    /// A list of `repositories` is only returned for export migrations.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/get(migrations/list-for-org)`.
    public func migrationsListForOrg(
        path: Operations.MigrationsListForOrg.Input.Path,
        query: Operations.MigrationsListForOrg.Input.Query = .init(),
        headers: Operations.MigrationsListForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsListForOrg.Output {
        try await migrationsListForOrg(Operations.MigrationsListForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Start an organization migration
    ///
    /// Initiates the generation of a migration archive.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)`.
    public func migrationsStartForOrg(
        path: Operations.MigrationsStartForOrg.Input.Path,
        headers: Operations.MigrationsStartForOrg.Input.Headers = .init(),
        body: Operations.MigrationsStartForOrg.Input.Body
    ) async throws -> Operations.MigrationsStartForOrg.Output {
        try await migrationsStartForOrg(Operations.MigrationsStartForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get an organization migration status
    ///
    /// Fetches the status of a migration.
    ///
    /// The `state` of a migration can be one of the following values:
    ///
    /// *   `pending`, which means the migration hasn't started yet.
    /// *   `exporting`, which means the migration is in progress.
    /// *   `exported`, which means the migration finished successfully.
    /// *   `failed`, which means the migration failed.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/get(migrations/get-status-for-org)`.
    public func migrationsGetStatusForOrg(
        path: Operations.MigrationsGetStatusForOrg.Input.Path,
        query: Operations.MigrationsGetStatusForOrg.Input.Query = .init(),
        headers: Operations.MigrationsGetStatusForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetStatusForOrg.Output {
        try await migrationsGetStatusForOrg(Operations.MigrationsGetStatusForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Download an organization migration archive
    ///
    /// Fetches the URL to a migration archive.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)`.
    public func migrationsDownloadArchiveForOrg(
        path: Operations.MigrationsDownloadArchiveForOrg.Input.Path,
        headers: Operations.MigrationsDownloadArchiveForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsDownloadArchiveForOrg.Output {
        try await migrationsDownloadArchiveForOrg(Operations.MigrationsDownloadArchiveForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete an organization migration archive
    ///
    /// Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)`.
    public func migrationsDeleteArchiveForOrg(
        path: Operations.MigrationsDeleteArchiveForOrg.Input.Path,
        headers: Operations.MigrationsDeleteArchiveForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsDeleteArchiveForOrg.Output {
        try await migrationsDeleteArchiveForOrg(Operations.MigrationsDeleteArchiveForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unlock an organization repository
    ///
    /// Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)`.
    public func migrationsUnlockRepoForOrg(
        path: Operations.MigrationsUnlockRepoForOrg.Input.Path,
        headers: Operations.MigrationsUnlockRepoForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsUnlockRepoForOrg.Output {
        try await migrationsUnlockRepoForOrg(Operations.MigrationsUnlockRepoForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories in an organization migration
    ///
    /// List all the repositories for this organization migration.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repositories/get(migrations/list-repos-for-org)`.
    public func migrationsListReposForOrg(
        path: Operations.MigrationsListReposForOrg.Input.Path,
        query: Operations.MigrationsListReposForOrg.Input.Query = .init(),
        headers: Operations.MigrationsListReposForOrg.Input.Headers = .init()
    ) async throws -> Operations.MigrationsListReposForOrg.Output {
        try await migrationsListReposForOrg(Operations.MigrationsListReposForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an import status
    ///
    /// View the progress of an import.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// **Import status**
    ///
    /// This section includes details about the possible values of the `status` field of the Import Progress response.
    ///
    /// An import that does not have errors will progress through these steps:
    ///
    /// *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
    /// *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
    /// *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
    /// *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
    /// *   `complete` - the import is complete, and the repository is ready on GitHub.
    ///
    /// If there are problems, you will see one of these in the `status` field:
    ///
    /// *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
    /// *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/migrations/source-imports#cancel-an-import) and [retry](https://docs.github.com/rest/migrations/source-imports#start-an-import) with the correct URL.
    /// *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    ///
    /// **The project_choices field**
    ///
    /// When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
    ///
    /// **Git LFS related fields**
    ///
    /// This section includes details about Git LFS related fields that may be present in the Import Progress response.
    ///
    /// *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
    /// *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
    /// *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
    /// *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)`.
    @available(*, deprecated)
    public func migrationsGetImportStatus(
        path: Operations.MigrationsGetImportStatus.Input.Path,
        headers: Operations.MigrationsGetImportStatus.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetImportStatus.Output {
        try await migrationsGetImportStatus(Operations.MigrationsGetImportStatus.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update an import
    ///
    /// An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
    /// request. If no parameters are provided, the import will be restarted.
    ///
    /// Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
    /// have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
    /// You can select the project to import by providing one of the objects in the `project_choices` array in the update request.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/patch(migrations/update-import)`.
    @available(*, deprecated)
    public func migrationsUpdateImport(
        path: Operations.MigrationsUpdateImport.Input.Path,
        headers: Operations.MigrationsUpdateImport.Input.Headers = .init(),
        body: Operations.MigrationsUpdateImport.Input.Body? = nil
    ) async throws -> Operations.MigrationsUpdateImport.Output {
        try await migrationsUpdateImport(Operations.MigrationsUpdateImport.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Start an import
    ///
    /// Start a source import to a GitHub repository using GitHub Importer.
    /// Importing into a GitHub repository with GitHub Actions enabled is not supported and will
    /// return a status `422 Unprocessable Entity` response.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)`.
    @available(*, deprecated)
    public func migrationsStartImport(
        path: Operations.MigrationsStartImport.Input.Path,
        headers: Operations.MigrationsStartImport.Input.Headers = .init(),
        body: Operations.MigrationsStartImport.Input.Body
    ) async throws -> Operations.MigrationsStartImport.Output {
        try await migrationsStartImport(Operations.MigrationsStartImport.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Cancel an import
    ///
    /// Stop an import for a repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)`.
    @available(*, deprecated)
    public func migrationsCancelImport(
        path: Operations.MigrationsCancelImport.Input.Path,
        headers: Operations.MigrationsCancelImport.Input.Headers = .init()
    ) async throws -> Operations.MigrationsCancelImport.Output {
        try await migrationsCancelImport(Operations.MigrationsCancelImport.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get commit authors
    ///
    /// Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
    ///
    /// This endpoint and the [Map a commit author](https://docs.github.com/rest/migrations/source-imports#map-a-commit-author) endpoint allow you to provide correct Git author information.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/authors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)`.
    @available(*, deprecated)
    public func migrationsGetCommitAuthors(
        path: Operations.MigrationsGetCommitAuthors.Input.Path,
        query: Operations.MigrationsGetCommitAuthors.Input.Query = .init(),
        headers: Operations.MigrationsGetCommitAuthors.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetCommitAuthors.Output {
        try await migrationsGetCommitAuthors(Operations.MigrationsGetCommitAuthors.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Map a commit author
    ///
    /// Update an author's identity for the import. Your application can continue updating authors any time before you push
    /// new commits to the repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/authors/{author_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)`.
    @available(*, deprecated)
    public func migrationsMapCommitAuthor(
        path: Operations.MigrationsMapCommitAuthor.Input.Path,
        headers: Operations.MigrationsMapCommitAuthor.Input.Headers = .init(),
        body: Operations.MigrationsMapCommitAuthor.Input.Body? = nil
    ) async throws -> Operations.MigrationsMapCommitAuthor.Output {
        try await migrationsMapCommitAuthor(Operations.MigrationsMapCommitAuthor.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Get large files
    ///
    /// List files larger than 100MB found during the import
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/large_files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/large_files/get(migrations/get-large-files)`.
    @available(*, deprecated)
    public func migrationsGetLargeFiles(
        path: Operations.MigrationsGetLargeFiles.Input.Path,
        headers: Operations.MigrationsGetLargeFiles.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetLargeFiles.Output {
        try await migrationsGetLargeFiles(Operations.MigrationsGetLargeFiles.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update Git LFS preference
    ///
    /// You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability
    /// is powered by [Git LFS](https://git-lfs.com).
    ///
    /// You can learn more about our LFS feature and working with large files [on our help
    /// site](https://docs.github.com/repositories/working-with-files/managing-large-files).
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/lfs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)`.
    @available(*, deprecated)
    public func migrationsSetLfsPreference(
        path: Operations.MigrationsSetLfsPreference.Input.Path,
        headers: Operations.MigrationsSetLfsPreference.Input.Headers = .init(),
        body: Operations.MigrationsSetLfsPreference.Input.Body
    ) async throws -> Operations.MigrationsSetLfsPreference.Output {
        try await migrationsSetLfsPreference(Operations.MigrationsSetLfsPreference.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List user migrations
    ///
    /// Lists all migrations a user has started.
    ///
    /// - Remark: HTTP `GET /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)`.
    public func migrationsListForAuthenticatedUser(
        query: Operations.MigrationsListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.MigrationsListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsListForAuthenticatedUser.Output {
        try await migrationsListForAuthenticatedUser(Operations.MigrationsListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Start a user migration
    ///
    /// Initiates the generation of a user migration archive.
    ///
    /// - Remark: HTTP `POST /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)`.
    public func migrationsStartForAuthenticatedUser(
        headers: Operations.MigrationsStartForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.MigrationsStartForAuthenticatedUser.Input.Body
    ) async throws -> Operations.MigrationsStartForAuthenticatedUser.Output {
        try await migrationsStartForAuthenticatedUser(Operations.MigrationsStartForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Get a user migration status
    ///
    /// Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
    ///
    /// *   `pending` - the migration hasn't started yet.
    /// *   `exporting` - the migration is in progress.
    /// *   `exported` - the migration finished successfully.
    /// *   `failed` - the migration failed.
    ///
    /// Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/migrations/users#download-a-user-migration-archive).
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)`.
    public func migrationsGetStatusForAuthenticatedUser(
        path: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Path,
        query: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetStatusForAuthenticatedUser.Output {
        try await migrationsGetStatusForAuthenticatedUser(Operations.MigrationsGetStatusForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Download a user migration archive
    ///
    /// Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
    ///
    /// *   attachments
    /// *   bases
    /// *   commit\_comments
    /// *   issue\_comments
    /// *   issue\_events
    /// *   issues
    /// *   milestones
    /// *   organizations
    /// *   projects
    /// *   protected\_branches
    /// *   pull\_request\_reviews
    /// *   pull\_requests
    /// *   releases
    /// *   repositories
    /// *   review\_comments
    /// *   schema
    /// *   users
    ///
    /// The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)`.
    public func migrationsGetArchiveForAuthenticatedUser(
        path: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Path,
        headers: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsGetArchiveForAuthenticatedUser.Output {
        try await migrationsGetArchiveForAuthenticatedUser(Operations.MigrationsGetArchiveForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Delete a user migration archive
    ///
    /// Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/migrations/users#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/migrations/users#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)`.
    public func migrationsDeleteArchiveForAuthenticatedUser(
        path: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Path,
        headers: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsDeleteArchiveForAuthenticatedUser.Output {
        try await migrationsDeleteArchiveForAuthenticatedUser(Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Unlock a user repository
    ///
    /// Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/migrations/users#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/repos/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)`.
    public func migrationsUnlockRepoForAuthenticatedUser(
        path: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Path,
        headers: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsUnlockRepoForAuthenticatedUser.Output {
        try await migrationsUnlockRepoForAuthenticatedUser(Operations.MigrationsUnlockRepoForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List repositories for a user migration
    ///
    /// Lists all the repositories for this user migration.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repositories/get(migrations/list-repos-for-authenticated-user)`.
    public func migrationsListReposForAuthenticatedUser(
        path: Operations.MigrationsListReposForAuthenticatedUser.Input.Path,
        query: Operations.MigrationsListReposForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.MigrationsListReposForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.MigrationsListReposForAuthenticatedUser.Output {
        try await migrationsListReposForAuthenticatedUser(Operations.MigrationsListReposForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A migration.
        ///
        /// - Remark: Generated from `#/components/schemas/migration`.
        public struct Migration: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/migration/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/migration/owner`.
            public var owner: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/migration/guid`.
            public var guid: Swift.String
            /// - Remark: Generated from `#/components/schemas/migration/state`.
            public var state: Swift.String
            /// - Remark: Generated from `#/components/schemas/migration/lock_repositories`.
            public var lockRepositories: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/exclude_metadata`.
            public var excludeMetadata: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/exclude_git_data`.
            public var excludeGitData: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/exclude_attachments`.
            public var excludeAttachments: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/exclude_releases`.
            public var excludeReleases: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/exclude_owner_projects`.
            public var excludeOwnerProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/migration/org_metadata_only`.
            public var orgMetadataOnly: Swift.Bool
            /// The repositories included in the migration. Only returned for export migrations.
            ///
            /// - Remark: Generated from `#/components/schemas/migration/repositories`.
            public var repositories: [Components.Schemas.Repository]
            /// - Remark: Generated from `#/components/schemas/migration/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/migration/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/migration/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/migration/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/migration/archive_url`.
            public var archiveUrl: Swift.String?
            /// Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`.
            ///
            /// - Remark: Generated from `#/components/schemas/migration/exclude`.
            public var exclude: [Swift.String]?
            /// Creates a new `Migration`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - owner:
            ///   - guid:
            ///   - state:
            ///   - lockRepositories:
            ///   - excludeMetadata:
            ///   - excludeGitData:
            ///   - excludeAttachments:
            ///   - excludeReleases:
            ///   - excludeOwnerProjects:
            ///   - orgMetadataOnly:
            ///   - repositories: The repositories included in the migration. Only returned for export migrations.
            ///   - url:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - nodeId:
            ///   - archiveUrl:
            ///   - exclude: Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`.
            public init(
                id: Swift.Int64,
                owner: Components.Schemas.NullableSimpleUser? = nil,
                guid: Swift.String,
                state: Swift.String,
                lockRepositories: Swift.Bool,
                excludeMetadata: Swift.Bool,
                excludeGitData: Swift.Bool,
                excludeAttachments: Swift.Bool,
                excludeReleases: Swift.Bool,
                excludeOwnerProjects: Swift.Bool,
                orgMetadataOnly: Swift.Bool,
                repositories: [Components.Schemas.Repository],
                url: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                nodeId: Swift.String,
                archiveUrl: Swift.String? = nil,
                exclude: [Swift.String]? = nil
            ) {
                self.id = id
                self.owner = owner
                self.guid = guid
                self.state = state
                self.lockRepositories = lockRepositories
                self.excludeMetadata = excludeMetadata
                self.excludeGitData = excludeGitData
                self.excludeAttachments = excludeAttachments
                self.excludeReleases = excludeReleases
                self.excludeOwnerProjects = excludeOwnerProjects
                self.orgMetadataOnly = orgMetadataOnly
                self.repositories = repositories
                self.url = url
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.nodeId = nodeId
                self.archiveUrl = archiveUrl
                self.exclude = exclude
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case owner
                case guid
                case state
                case lockRepositories = "lock_repositories"
                case excludeMetadata = "exclude_metadata"
                case excludeGitData = "exclude_git_data"
                case excludeAttachments = "exclude_attachments"
                case excludeReleases = "exclude_releases"
                case excludeOwnerProjects = "exclude_owner_projects"
                case orgMetadataOnly = "org_metadata_only"
                case repositories
                case url
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case nodeId = "node_id"
                case archiveUrl = "archive_url"
                case exclude
            }
        }
        /// A repository import from an external source.
        ///
        /// - Remark: Generated from `#/components/schemas/import`.
        public struct Import: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/import/vcs`.
            public var vcs: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/use_lfs`.
            public var useLfs: Swift.Bool?
            /// The URL of the originating repository.
            ///
            /// - Remark: Generated from `#/components/schemas/import/vcs_url`.
            public var vcsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/import/svc_root`.
            public var svcRoot: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/tfvc_project`.
            public var tfvcProject: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/status`.
            @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case auth = "auth"
                case error = "error"
                case none = "none"
                case detecting = "detecting"
                case choose = "choose"
                case authFailed = "auth_failed"
                case importing = "importing"
                case mapping = "mapping"
                case waitingToPush = "waiting_to_push"
                case pushing = "pushing"
                case complete = "complete"
                case setup = "setup"
                case unknown = "unknown"
                case detectionFoundMultiple = "detection_found_multiple"
                case detectionFoundNothing = "detection_found_nothing"
                case detectionNeedsAuth = "detection_needs_auth"
            }
            /// - Remark: Generated from `#/components/schemas/import/status`.
            public var status: Components.Schemas.Import.StatusPayload
            /// - Remark: Generated from `#/components/schemas/import/status_text`.
            public var statusText: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/failed_step`.
            public var failedStep: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/error_message`.
            public var errorMessage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/import_percent`.
            public var importPercent: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/commit_count`.
            public var commitCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/push_percent`.
            public var pushPercent: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/has_large_files`.
            public var hasLargeFiles: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/import/large_files_size`.
            public var largeFilesSize: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/large_files_count`.
            public var largeFilesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/ProjectChoicesPayload`.
            public struct ProjectChoicesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/import/ProjectChoicesPayload/vcs`.
                public var vcs: Swift.String?
                /// - Remark: Generated from `#/components/schemas/import/ProjectChoicesPayload/tfvc_project`.
                public var tfvcProject: Swift.String?
                /// - Remark: Generated from `#/components/schemas/import/ProjectChoicesPayload/human_name`.
                public var humanName: Swift.String?
                /// Creates a new `ProjectChoicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - vcs:
                ///   - tfvcProject:
                ///   - humanName:
                public init(
                    vcs: Swift.String? = nil,
                    tfvcProject: Swift.String? = nil,
                    humanName: Swift.String? = nil
                ) {
                    self.vcs = vcs
                    self.tfvcProject = tfvcProject
                    self.humanName = humanName
                }
                public enum CodingKeys: String, CodingKey {
                    case vcs
                    case tfvcProject = "tfvc_project"
                    case humanName = "human_name"
                }
            }
            /// - Remark: Generated from `#/components/schemas/import/project_choices`.
            public typealias ProjectChoicesPayload = [Components.Schemas.Import.ProjectChoicesPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/import/project_choices`.
            public var projectChoices: Components.Schemas.Import.ProjectChoicesPayload?
            /// - Remark: Generated from `#/components/schemas/import/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/import/authors_count`.
            public var authorsCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/import/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/import/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/import/authors_url`.
            public var authorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/import/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/import/svn_root`.
            public var svnRoot: Swift.String?
            /// Creates a new `Import`.
            ///
            /// - Parameters:
            ///   - vcs:
            ///   - useLfs:
            ///   - vcsUrl: The URL of the originating repository.
            ///   - svcRoot:
            ///   - tfvcProject:
            ///   - status:
            ///   - statusText:
            ///   - failedStep:
            ///   - errorMessage:
            ///   - importPercent:
            ///   - commitCount:
            ///   - pushPercent:
            ///   - hasLargeFiles:
            ///   - largeFilesSize:
            ///   - largeFilesCount:
            ///   - projectChoices:
            ///   - message:
            ///   - authorsCount:
            ///   - url:
            ///   - htmlUrl:
            ///   - authorsUrl:
            ///   - repositoryUrl:
            ///   - svnRoot:
            public init(
                vcs: Swift.String? = nil,
                useLfs: Swift.Bool? = nil,
                vcsUrl: Swift.String,
                svcRoot: Swift.String? = nil,
                tfvcProject: Swift.String? = nil,
                status: Components.Schemas.Import.StatusPayload,
                statusText: Swift.String? = nil,
                failedStep: Swift.String? = nil,
                errorMessage: Swift.String? = nil,
                importPercent: Swift.Int? = nil,
                commitCount: Swift.Int? = nil,
                pushPercent: Swift.Int? = nil,
                hasLargeFiles: Swift.Bool? = nil,
                largeFilesSize: Swift.Int? = nil,
                largeFilesCount: Swift.Int? = nil,
                projectChoices: Components.Schemas.Import.ProjectChoicesPayload? = nil,
                message: Swift.String? = nil,
                authorsCount: Swift.Int? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                authorsUrl: Swift.String,
                repositoryUrl: Swift.String,
                svnRoot: Swift.String? = nil
            ) {
                self.vcs = vcs
                self.useLfs = useLfs
                self.vcsUrl = vcsUrl
                self.svcRoot = svcRoot
                self.tfvcProject = tfvcProject
                self.status = status
                self.statusText = statusText
                self.failedStep = failedStep
                self.errorMessage = errorMessage
                self.importPercent = importPercent
                self.commitCount = commitCount
                self.pushPercent = pushPercent
                self.hasLargeFiles = hasLargeFiles
                self.largeFilesSize = largeFilesSize
                self.largeFilesCount = largeFilesCount
                self.projectChoices = projectChoices
                self.message = message
                self.authorsCount = authorsCount
                self.url = url
                self.htmlUrl = htmlUrl
                self.authorsUrl = authorsUrl
                self.repositoryUrl = repositoryUrl
                self.svnRoot = svnRoot
            }
            public enum CodingKeys: String, CodingKey {
                case vcs
                case useLfs = "use_lfs"
                case vcsUrl = "vcs_url"
                case svcRoot = "svc_root"
                case tfvcProject = "tfvc_project"
                case status
                case statusText = "status_text"
                case failedStep = "failed_step"
                case errorMessage = "error_message"
                case importPercent = "import_percent"
                case commitCount = "commit_count"
                case pushPercent = "push_percent"
                case hasLargeFiles = "has_large_files"
                case largeFilesSize = "large_files_size"
                case largeFilesCount = "large_files_count"
                case projectChoices = "project_choices"
                case message
                case authorsCount = "authors_count"
                case url
                case htmlUrl = "html_url"
                case authorsUrl = "authors_url"
                case repositoryUrl = "repository_url"
                case svnRoot = "svn_root"
            }
        }
        /// Porter Author
        ///
        /// - Remark: Generated from `#/components/schemas/porter-author`.
        public struct PorterAuthor: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/porter-author/id`.
            public var id: Swift.Int
            /// - Remark: Generated from `#/components/schemas/porter-author/remote_id`.
            public var remoteId: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-author/remote_name`.
            public var remoteName: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-author/email`.
            public var email: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-author/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-author/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-author/import_url`.
            public var importUrl: Swift.String
            /// Creates a new `PorterAuthor`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - remoteId:
            ///   - remoteName:
            ///   - email:
            ///   - name:
            ///   - url:
            ///   - importUrl:
            public init(
                id: Swift.Int,
                remoteId: Swift.String,
                remoteName: Swift.String,
                email: Swift.String,
                name: Swift.String,
                url: Swift.String,
                importUrl: Swift.String
            ) {
                self.id = id
                self.remoteId = remoteId
                self.remoteName = remoteName
                self.email = email
                self.name = name
                self.url = url
                self.importUrl = importUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case remoteId = "remote_id"
                case remoteName = "remote_name"
                case email
                case name
                case url
                case importUrl = "import_url"
            }
        }
        /// Porter Large File
        ///
        /// - Remark: Generated from `#/components/schemas/porter-large-file`.
        public struct PorterLargeFile: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/porter-large-file/ref_name`.
            public var refName: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-large-file/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-large-file/oid`.
            public var oid: Swift.String
            /// - Remark: Generated from `#/components/schemas/porter-large-file/size`.
            public var size: Swift.Int
            /// Creates a new `PorterLargeFile`.
            ///
            /// - Parameters:
            ///   - refName:
            ///   - path:
            ///   - oid:
            ///   - size:
            public init(
                refName: Swift.String,
                path: Swift.String,
                oid: Swift.String,
                size: Swift.Int
            ) {
                self.refName = refName
                self.path = path
                self.oid = oid
                self.size = size
            }
            public enum CodingKeys: String, CodingKey {
                case refName = "ref_name"
                case path
                case oid
                case size
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The unique identifier of the migration.
        ///
        /// - Remark: Generated from `#/components/parameters/migration-id`.
        public typealias MigrationId = Swift.Int
        /// repo_name parameter
        ///
        /// - Remark: Generated from `#/components/parameters/repo-name`.
        public typealias RepoName = Swift.String
        /// A user ID. Only return users with an ID greater than this ID.
        ///
        /// - Remark: Generated from `#/components/parameters/since-user`.
        public typealias SinceUser = Swift.Int
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct PorterMaintenance: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/porter_maintenance/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/porter_maintenance/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.PorterMaintenance.Body
            /// Creates a new `PorterMaintenance`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.PorterMaintenance.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List organization migrations
    ///
    /// Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).
    ///
    /// A list of `repositories` is only returned for export migrations.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/get(migrations/list-for-org)`.
    public enum MigrationsListForOrg {
        public static let id: Swift.String = "migrations/list-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.MigrationsListForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Allowed values that can be passed to the exclude param.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query/ExcludePayload`.
                @frozen public enum ExcludePayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case repositories = "repositories"
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query/exclude`.
                public typealias ExcludePayload = [Operations.MigrationsListForOrg.Input.Query.ExcludePayloadPayload]
                /// Exclude attributes from the API response to improve performance
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/query/exclude`.
                public var exclude: Operations.MigrationsListForOrg.Input.Query.ExcludePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - exclude: Exclude attributes from the API response to improve performance
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    exclude: Operations.MigrationsListForOrg.Input.Query.ExcludePayload? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                    self.exclude = exclude
                }
            }
            public var query: Operations.MigrationsListForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsListForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsListForOrg.Input.Path,
                query: Operations.MigrationsListForOrg.Input.Query = .init(),
                headers: Operations.MigrationsListForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MigrationsListForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Migration])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Migration] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsListForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MigrationsListForOrg.Output.Ok.Headers = .init(),
                    body: Operations.MigrationsListForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/get(migrations/list-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsListForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsListForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Start an organization migration
    ///
    /// Initiates the generation of a migration archive.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/migrations`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)`.
    public enum MigrationsStartForOrg {
        public static let id: Swift.String = "migrations/start-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.MigrationsStartForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsStartForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A list of arrays indicating which repositories should be migrated.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/repositories`.
                    public var repositories: [Swift.String]
                    /// Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/lock_repositories`.
                    public var lockRepositories: Swift.Bool?
                    /// Indicates whether metadata should be excluded and only git source should be included for the migration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude_metadata`.
                    public var excludeMetadata: Swift.Bool?
                    /// Indicates whether the repository git data should be excluded from the migration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude_git_data`.
                    public var excludeGitData: Swift.Bool?
                    /// Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude_attachments`.
                    public var excludeAttachments: Swift.Bool?
                    /// Indicates whether releases should be excluded from the migration (to reduce migration archive file size).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude_releases`.
                    public var excludeReleases: Swift.Bool?
                    /// Indicates whether projects owned by the organization or users should be excluded. from the migration.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude_owner_projects`.
                    public var excludeOwnerProjects: Swift.Bool?
                    /// Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/org_metadata_only`.
                    public var orgMetadataOnly: Swift.Bool?
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/ExcludePayload`.
                    @frozen public enum ExcludePayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case repositories = "repositories"
                    }
                    /// Exclude related items from being returned in the response in order to improve performance of the request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude`.
                    public typealias ExcludePayload = [Operations.MigrationsStartForOrg.Input.Body.JsonPayload.ExcludePayloadPayload]
                    /// Exclude related items from being returned in the response in order to improve performance of the request.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/json/exclude`.
                    public var exclude: Operations.MigrationsStartForOrg.Input.Body.JsonPayload.ExcludePayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - repositories: A list of arrays indicating which repositories should be migrated.
                    ///   - lockRepositories: Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
                    ///   - excludeMetadata: Indicates whether metadata should be excluded and only git source should be included for the migration.
                    ///   - excludeGitData: Indicates whether the repository git data should be excluded from the migration.
                    ///   - excludeAttachments: Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
                    ///   - excludeReleases: Indicates whether releases should be excluded from the migration (to reduce migration archive file size).
                    ///   - excludeOwnerProjects: Indicates whether projects owned by the organization or users should be excluded. from the migration.
                    ///   - orgMetadataOnly: Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).
                    ///   - exclude: Exclude related items from being returned in the response in order to improve performance of the request.
                    public init(
                        repositories: [Swift.String],
                        lockRepositories: Swift.Bool? = nil,
                        excludeMetadata: Swift.Bool? = nil,
                        excludeGitData: Swift.Bool? = nil,
                        excludeAttachments: Swift.Bool? = nil,
                        excludeReleases: Swift.Bool? = nil,
                        excludeOwnerProjects: Swift.Bool? = nil,
                        orgMetadataOnly: Swift.Bool? = nil,
                        exclude: Operations.MigrationsStartForOrg.Input.Body.JsonPayload.ExcludePayload? = nil
                    ) {
                        self.repositories = repositories
                        self.lockRepositories = lockRepositories
                        self.excludeMetadata = excludeMetadata
                        self.excludeGitData = excludeGitData
                        self.excludeAttachments = excludeAttachments
                        self.excludeReleases = excludeReleases
                        self.excludeOwnerProjects = excludeOwnerProjects
                        self.orgMetadataOnly = orgMetadataOnly
                        self.exclude = exclude
                    }
                    public enum CodingKeys: String, CodingKey {
                        case repositories
                        case lockRepositories = "lock_repositories"
                        case excludeMetadata = "exclude_metadata"
                        case excludeGitData = "exclude_git_data"
                        case excludeAttachments = "exclude_attachments"
                        case excludeReleases = "exclude_releases"
                        case excludeOwnerProjects = "exclude_owner_projects"
                        case orgMetadataOnly = "org_metadata_only"
                        case exclude
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/requestBody/content/application\/json`.
                case json(Operations.MigrationsStartForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsStartForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.MigrationsStartForOrg.Input.Path,
                headers: Operations.MigrationsStartForOrg.Input.Headers = .init(),
                body: Operations.MigrationsStartForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Migration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Migration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsStartForOrg.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsStartForOrg.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.MigrationsStartForOrg.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.MigrationsStartForOrg.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/post(migrations/start-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization migration status
    ///
    /// Fetches the status of a migration.
    ///
    /// The `state` of a migration can be one of the following values:
    ///
    /// *   `pending`, which means the migration hasn't started yet.
    /// *   `exporting`, which means the migration is in progress.
    /// *   `exported`, which means the migration finished successfully.
    /// *   `failed`, which means the migration failed.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/get(migrations/get-status-for-org)`.
    public enum MigrationsGetStatusForOrg {
        public static let id: Swift.String = "migrations/get-status-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - migrationId: The unique identifier of the migration.
                public init(
                    org: Components.Parameters.Org,
                    migrationId: Components.Parameters.MigrationId
                ) {
                    self.org = org
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsGetStatusForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Allowed values that can be passed to the exclude param.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/query/ExcludePayload`.
                @frozen public enum ExcludePayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case repositories = "repositories"
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/query/exclude`.
                public typealias ExcludePayload = [Operations.MigrationsGetStatusForOrg.Input.Query.ExcludePayloadPayload]
                /// Exclude attributes from the API response to improve performance
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/query/exclude`.
                public var exclude: Operations.MigrationsGetStatusForOrg.Input.Query.ExcludePayload?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - exclude: Exclude attributes from the API response to improve performance
                public init(exclude: Operations.MigrationsGetStatusForOrg.Input.Query.ExcludePayload? = nil) {
                    self.exclude = exclude
                }
            }
            public var query: Operations.MigrationsGetStatusForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetStatusForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetStatusForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetStatusForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetStatusForOrg.Input.Path,
                query: Operations.MigrationsGetStatusForOrg.Input.Query = .init(),
                headers: Operations.MigrationsGetStatusForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Migration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Migration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsGetStatusForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsGetStatusForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// *   `pending`, which means the migration hasn't started yet.
            /// *   `exporting`, which means the migration is in progress.
            /// *   `exported`, which means the migration finished successfully.
            /// *   `failed`, which means the migration failed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/get(migrations/get-status-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsGetStatusForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsGetStatusForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/get(migrations/get-status-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Download an organization migration archive
    ///
    /// Fetches the URL to a migration archive.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)`.
    public enum MigrationsDownloadArchiveForOrg {
        public static let id: Swift.String = "migrations/download-archive-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - migrationId: The unique identifier of the migration.
                public init(
                    org: Components.Parameters.Org,
                    migrationId: Components.Parameters.MigrationId
                ) {
                    self.org = org
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsDownloadArchiveForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDownloadArchiveForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDownloadArchiveForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsDownloadArchiveForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsDownloadArchiveForOrg.Input.Path,
                headers: Operations.MigrationsDownloadArchiveForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Found: Sendable, Hashable {
                /// Creates a new `Found`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            case found(Operations.MigrationsDownloadArchiveForOrg.Output.Found)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            public static var found: Self {
                .found(.init())
            }
            /// The associated value of the enum case if `self` is `.found`.
            ///
            /// - Throws: An error if `self` is not `.found`.
            /// - SeeAlso: `.found`.
            public var found: Operations.MigrationsDownloadArchiveForOrg.Output.Found {
                get throws {
                    switch self {
                    case let .found(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "found",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/get(migrations/download-archive-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an organization migration archive
    ///
    /// Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)`.
    public enum MigrationsDeleteArchiveForOrg {
        public static let id: Swift.String = "migrations/delete-archive-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/DELETE/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - migrationId: The unique identifier of the migration.
                public init(
                    org: Components.Parameters.Org,
                    migrationId: Components.Parameters.MigrationId
                ) {
                    self.org = org
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsDeleteArchiveForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/archive/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDeleteArchiveForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDeleteArchiveForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsDeleteArchiveForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsDeleteArchiveForOrg.Input.Path,
                headers: Operations.MigrationsDeleteArchiveForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.MigrationsDeleteArchiveForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.MigrationsDeleteArchiveForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unlock an organization repository
    ///
    /// Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)`.
    public enum MigrationsUnlockRepoForOrg {
        public static let id: Swift.String = "migrations/unlock-repo-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// repo_name parameter
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path/repo_name`.
                public var repoName: Components.Parameters.RepoName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - migrationId: The unique identifier of the migration.
                ///   - repoName: repo_name parameter
                public init(
                    org: Components.Parameters.Org,
                    migrationId: Components.Parameters.MigrationId,
                    repoName: Components.Parameters.RepoName
                ) {
                    self.org = org
                    self.migrationId = migrationId
                    self.repoName = repoName
                }
            }
            public var path: Operations.MigrationsUnlockRepoForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUnlockRepoForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUnlockRepoForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsUnlockRepoForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsUnlockRepoForOrg.Input.Path,
                headers: Operations.MigrationsUnlockRepoForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.MigrationsUnlockRepoForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.MigrationsUnlockRepoForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories in an organization migration
    ///
    /// List all the repositories for this organization migration.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repositories/get(migrations/list-repos-for-org)`.
    public enum MigrationsListReposForOrg {
        public static let id: Swift.String = "migrations/list-repos-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - migrationId: The unique identifier of the migration.
                public init(
                    org: Components.Parameters.Org,
                    migrationId: Components.Parameters.MigrationId
                ) {
                    self.org = org
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsListReposForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.MigrationsListReposForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListReposForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListReposForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsListReposForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsListReposForOrg.Input.Path,
                query: Operations.MigrationsListReposForOrg.Input.Query = .init(),
                headers: Operations.MigrationsListReposForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MigrationsListReposForOrg.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/migrations/{migration_id}/repositories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsListReposForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MigrationsListReposForOrg.Output.Ok.Headers = .init(),
                    body: Operations.MigrationsListReposForOrg.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repositories/get(migrations/list-repos-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsListReposForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsListReposForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/migrations/{migration_id}/repositories/get(migrations/list-repos-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an import status
    ///
    /// View the progress of an import.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// **Import status**
    ///
    /// This section includes details about the possible values of the `status` field of the Import Progress response.
    ///
    /// An import that does not have errors will progress through these steps:
    ///
    /// *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
    /// *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
    /// *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
    /// *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
    /// *   `complete` - the import is complete, and the repository is ready on GitHub.
    ///
    /// If there are problems, you will see one of these in the `status` field:
    ///
    /// *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
    /// *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    /// *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/migrations/source-imports#cancel-an-import) and [retry](https://docs.github.com/rest/migrations/source-imports#start-an-import) with the correct URL.
    /// *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
    ///
    /// **The project_choices field**
    ///
    /// When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
    ///
    /// **Git LFS related fields**
    ///
    /// This section includes details about Git LFS related fields that may be present in the Import Progress response.
    ///
    /// *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
    /// *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
    /// *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
    /// *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)`.
    public enum MigrationsGetImportStatus {
        public static let id: Swift.String = "migrations/get-import-status"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsGetImportStatus.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetImportStatus.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetImportStatus.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetImportStatus.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetImportStatus.Input.Path,
                headers: Operations.MigrationsGetImportStatus.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Import)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Import {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsGetImportStatus.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsGetImportStatus.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsGetImportStatus.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsGetImportStatus.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/get(migrations/get-import-status)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update an import
    ///
    /// An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
    /// request. If no parameters are provided, the import will be restarted.
    ///
    /// Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
    /// have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
    /// You can select the project to import by providing one of the objects in the `project_choices` array in the update request.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/patch(migrations/update-import)`.
    public enum MigrationsUpdateImport {
        public static let id: Swift.String = "migrations/update-import"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsUpdateImport.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUpdateImport.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUpdateImport.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsUpdateImport.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The username to provide to the originating repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json/vcs_username`.
                    public var vcsUsername: Swift.String?
                    /// The password to provide to the originating repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json/vcs_password`.
                    public var vcsPassword: Swift.String?
                    /// The type of version control system you are migrating from.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json/vcs`.
                    @frozen public enum VcsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case subversion = "subversion"
                        case tfvc = "tfvc"
                        case git = "git"
                        case mercurial = "mercurial"
                    }
                    /// The type of version control system you are migrating from.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json/vcs`.
                    public var vcs: Operations.MigrationsUpdateImport.Input.Body.JsonPayload.VcsPayload?
                    /// For a tfvc import, the name of the project that is being imported.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/json/tfvc_project`.
                    public var tfvcProject: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - vcsUsername: The username to provide to the originating repository.
                    ///   - vcsPassword: The password to provide to the originating repository.
                    ///   - vcs: The type of version control system you are migrating from.
                    ///   - tfvcProject: For a tfvc import, the name of the project that is being imported.
                    public init(
                        vcsUsername: Swift.String? = nil,
                        vcsPassword: Swift.String? = nil,
                        vcs: Operations.MigrationsUpdateImport.Input.Body.JsonPayload.VcsPayload? = nil,
                        tfvcProject: Swift.String? = nil
                    ) {
                        self.vcsUsername = vcsUsername
                        self.vcsPassword = vcsPassword
                        self.vcs = vcs
                        self.tfvcProject = tfvcProject
                    }
                    public enum CodingKeys: String, CodingKey {
                        case vcsUsername = "vcs_username"
                        case vcsPassword = "vcs_password"
                        case vcs
                        case tfvcProject = "tfvc_project"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/requestBody/content/application\/json`.
                case json(Operations.MigrationsUpdateImport.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsUpdateImport.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.MigrationsUpdateImport.Input.Path,
                headers: Operations.MigrationsUpdateImport.Input.Headers = .init(),
                body: Operations.MigrationsUpdateImport.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Import)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Import {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsUpdateImport.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsUpdateImport.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/patch(migrations/update-import)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsUpdateImport.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsUpdateImport.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/patch(migrations/update-import)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Start an import
    ///
    /// Start a source import to a GitHub repository using GitHub Importer.
    /// Importing into a GitHub repository with GitHub Actions enabled is not supported and will
    /// return a status `422 Unprocessable Entity` response.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)`.
    public enum MigrationsStartImport {
        public static let id: Swift.String = "migrations/start-import"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsStartImport.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartImport.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartImport.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsStartImport.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The URL of the originating repository.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/vcs_url`.
                    public var vcsUrl: Swift.String
                    /// The originating VCS type. Without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/vcs`.
                    @frozen public enum VcsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case subversion = "subversion"
                        case git = "git"
                        case mercurial = "mercurial"
                        case tfvc = "tfvc"
                    }
                    /// The originating VCS type. Without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/vcs`.
                    public var vcs: Operations.MigrationsStartImport.Input.Body.JsonPayload.VcsPayload?
                    /// If authentication is required, the username to provide to `vcs_url`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/vcs_username`.
                    public var vcsUsername: Swift.String?
                    /// If authentication is required, the password to provide to `vcs_url`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/vcs_password`.
                    public var vcsPassword: Swift.String?
                    /// For a tfvc import, the name of the project that is being imported.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/json/tfvc_project`.
                    public var tfvcProject: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - vcsUrl: The URL of the originating repository.
                    ///   - vcs: The originating VCS type. Without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
                    ///   - vcsUsername: If authentication is required, the username to provide to `vcs_url`.
                    ///   - vcsPassword: If authentication is required, the password to provide to `vcs_url`.
                    ///   - tfvcProject: For a tfvc import, the name of the project that is being imported.
                    public init(
                        vcsUrl: Swift.String,
                        vcs: Operations.MigrationsStartImport.Input.Body.JsonPayload.VcsPayload? = nil,
                        vcsUsername: Swift.String? = nil,
                        vcsPassword: Swift.String? = nil,
                        tfvcProject: Swift.String? = nil
                    ) {
                        self.vcsUrl = vcsUrl
                        self.vcs = vcs
                        self.vcsUsername = vcsUsername
                        self.vcsPassword = vcsPassword
                        self.tfvcProject = tfvcProject
                    }
                    public enum CodingKeys: String, CodingKey {
                        case vcsUrl = "vcs_url"
                        case vcs
                        case vcsUsername = "vcs_username"
                        case vcsPassword = "vcs_password"
                        case tfvcProject = "tfvc_project"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/requestBody/content/application\/json`.
                case json(Operations.MigrationsStartImport.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsStartImport.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.MigrationsStartImport.Input.Path,
                headers: Operations.MigrationsStartImport.Input.Headers = .init(),
                body: Operations.MigrationsStartImport.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/responses/201/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/responses/201/headers/Location`.
                    public var location: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - location:
                    public init(location: Swift.String? = nil) {
                        self.location = location
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MigrationsStartImport.Output.Created.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.Import)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Import {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsStartImport.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MigrationsStartImport.Output.Created.Headers = .init(),
                    body: Operations.MigrationsStartImport.Output.Created.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.MigrationsStartImport.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.MigrationsStartImport.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/put(migrations/start-import)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Cancel an import
    ///
    /// Stop an import for a repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/import`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)`.
    public enum MigrationsCancelImport {
        public static let id: Swift.String = "migrations/cancel-import"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsCancelImport.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsCancelImport.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsCancelImport.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsCancelImport.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsCancelImport.Input.Path,
                headers: Operations.MigrationsCancelImport.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.MigrationsCancelImport.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.MigrationsCancelImport.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/delete(migrations/cancel-import)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get commit authors
    ///
    /// Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
    ///
    /// This endpoint and the [Map a commit author](https://docs.github.com/rest/migrations/source-imports#map-a-commit-author) endpoint allow you to provide correct Git author information.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/authors`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)`.
    public enum MigrationsGetCommitAuthors {
        public static let id: Swift.String = "migrations/get-commit-authors"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsGetCommitAuthors.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A user ID. Only return users with an ID greater than this ID.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/query/since`.
                public var since: Components.Parameters.SinceUser?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - since: A user ID. Only return users with an ID greater than this ID.
                public init(since: Components.Parameters.SinceUser? = nil) {
                    self.since = since
                }
            }
            public var query: Operations.MigrationsGetCommitAuthors.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetCommitAuthors.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetCommitAuthors.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetCommitAuthors.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetCommitAuthors.Input.Path,
                query: Operations.MigrationsGetCommitAuthors.Input.Query = .init(),
                headers: Operations.MigrationsGetCommitAuthors.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PorterAuthor])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PorterAuthor] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsGetCommitAuthors.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsGetCommitAuthors.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsGetCommitAuthors.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsGetCommitAuthors.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/get(migrations/get-commit-authors)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Map a commit author
    ///
    /// Update an author's identity for the import. Your application can continue updating authors any time before you push
    /// new commits to the repository.
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/authors/{author_id}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)`.
    public enum MigrationsMapCommitAuthor {
        public static let id: Swift.String = "migrations/map-commit-author"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/path/author_id`.
                public var authorId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - authorId:
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    authorId: Swift.Int
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.authorId = authorId
                }
            }
            public var path: Operations.MigrationsMapCommitAuthor.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsMapCommitAuthor.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsMapCommitAuthor.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsMapCommitAuthor.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The new Git author email.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/requestBody/json/email`.
                    public var email: Swift.String?
                    /// The new Git author name.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/requestBody/json/name`.
                    public var name: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - email: The new Git author email.
                    ///   - name: The new Git author name.
                    public init(
                        email: Swift.String? = nil,
                        name: Swift.String? = nil
                    ) {
                        self.email = email
                        self.name = name
                    }
                    public enum CodingKeys: String, CodingKey {
                        case email
                        case name
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.email = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .email
                        )
                        self.name = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .name
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "email",
                            "name"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/requestBody/content/application\/json`.
                case json(Operations.MigrationsMapCommitAuthor.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsMapCommitAuthor.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.MigrationsMapCommitAuthor.Input.Path,
                headers: Operations.MigrationsMapCommitAuthor.Input.Headers = .init(),
                body: Operations.MigrationsMapCommitAuthor.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/authors/{author_id}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.PorterAuthor)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.PorterAuthor {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsMapCommitAuthor.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsMapCommitAuthor.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsMapCommitAuthor.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsMapCommitAuthor.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/authors/{author_id}/patch(migrations/map-commit-author)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get large files
    ///
    /// List files larger than 100MB found during the import
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/import/large_files`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/large_files/get(migrations/get-large-files)`.
    public enum MigrationsGetLargeFiles {
        public static let id: Swift.String = "migrations/get-large-files"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsGetLargeFiles.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetLargeFiles.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetLargeFiles.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetLargeFiles.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetLargeFiles.Input.Path,
                headers: Operations.MigrationsGetLargeFiles.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/large_files/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.PorterLargeFile])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.PorterLargeFile] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsGetLargeFiles.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsGetLargeFiles.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/large_files/get(migrations/get-large-files)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsGetLargeFiles.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsGetLargeFiles.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/large_files/get(migrations/get-large-files)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update Git LFS preference
    ///
    /// You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability
    /// is powered by [Git LFS](https://git-lfs.com).
    ///
    /// You can learn more about our LFS feature and working with large files [on our help
    /// site](https://docs.github.com/repositories/working-with-files/managing-large-files).
    ///
    /// > [!WARNING]
    /// > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/import/lfs`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)`.
    public enum MigrationsSetLfsPreference {
        public static let id: Swift.String = "migrations/set-lfs-preference"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.MigrationsSetLfsPreference.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsSetLfsPreference.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsSetLfsPreference.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsSetLfsPreference.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Whether to store large files during the import. `opt_in` means large files will be stored using Git LFS. `opt_out` means large files will be removed during the import.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/requestBody/json/use_lfs`.
                    @frozen public enum UseLfsPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case optIn = "opt_in"
                        case optOut = "opt_out"
                    }
                    /// Whether to store large files during the import. `opt_in` means large files will be stored using Git LFS. `opt_out` means large files will be removed during the import.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/requestBody/json/use_lfs`.
                    public var useLfs: Operations.MigrationsSetLfsPreference.Input.Body.JsonPayload.UseLfsPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - useLfs: Whether to store large files during the import. `opt_in` means large files will be stored using Git LFS. `opt_out` means large files will be removed during the import.
                    public init(useLfs: Operations.MigrationsSetLfsPreference.Input.Body.JsonPayload.UseLfsPayload) {
                        self.useLfs = useLfs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case useLfs = "use_lfs"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/requestBody/content/application\/json`.
                case json(Operations.MigrationsSetLfsPreference.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsSetLfsPreference.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.MigrationsSetLfsPreference.Input.Path,
                headers: Operations.MigrationsSetLfsPreference.Input.Headers = .init(),
                body: Operations.MigrationsSetLfsPreference.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/import/lfs/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Import)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Import {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsSetLfsPreference.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsSetLfsPreference.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsSetLfsPreference.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsSetLfsPreference.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Unavailable due to service under maintenance.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/import/lfs/patch(migrations/set-lfs-preference)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.PorterMaintenance)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.PorterMaintenance {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List user migrations
    ///
    /// Lists all migrations a user has started.
    ///
    /// - Remark: HTTP `GET /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)`.
    public enum MigrationsListForAuthenticatedUser {
        public static let id: Swift.String = "migrations/list-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/migrations/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/migrations/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.MigrationsListForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/migrations/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsListForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.MigrationsListForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.MigrationsListForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MigrationsListForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/migrations/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.Migration])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.Migration] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsListForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MigrationsListForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.MigrationsListForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsListForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsListForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/get(migrations/list-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Start a user migration
    ///
    /// Initiates the generation of a user migration archive.
    ///
    /// - Remark: HTTP `POST /user/migrations`.
    /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)`.
    public enum MigrationsStartForAuthenticatedUser {
        public static let id: Swift.String = "migrations/start-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsStartForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsStartForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Lock the repositories being migrated at the start of the migration
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/lock_repositories`.
                    public var lockRepositories: Swift.Bool?
                    /// Indicates whether metadata should be excluded and only git source should be included for the migration.
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude_metadata`.
                    public var excludeMetadata: Swift.Bool?
                    /// Indicates whether the repository git data should be excluded from the migration.
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude_git_data`.
                    public var excludeGitData: Swift.Bool?
                    /// Do not include attachments in the migration
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude_attachments`.
                    public var excludeAttachments: Swift.Bool?
                    /// Do not include releases in the migration
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude_releases`.
                    public var excludeReleases: Swift.Bool?
                    /// Indicates whether projects owned by the organization or users should be excluded.
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude_owner_projects`.
                    public var excludeOwnerProjects: Swift.Bool?
                    /// Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/org_metadata_only`.
                    public var orgMetadataOnly: Swift.Bool?
                    /// Allowed values that can be passed to the exclude param.
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/ExcludePayload`.
                    @frozen public enum ExcludePayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case repositories = "repositories"
                    }
                    /// Exclude attributes from the API response to improve performance
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude`.
                    public typealias ExcludePayload = [Operations.MigrationsStartForAuthenticatedUser.Input.Body.JsonPayload.ExcludePayloadPayload]
                    /// Exclude attributes from the API response to improve performance
                    ///
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/exclude`.
                    public var exclude: Operations.MigrationsStartForAuthenticatedUser.Input.Body.JsonPayload.ExcludePayload?
                    /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/json/repositories`.
                    public var repositories: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - lockRepositories: Lock the repositories being migrated at the start of the migration
                    ///   - excludeMetadata: Indicates whether metadata should be excluded and only git source should be included for the migration.
                    ///   - excludeGitData: Indicates whether the repository git data should be excluded from the migration.
                    ///   - excludeAttachments: Do not include attachments in the migration
                    ///   - excludeReleases: Do not include releases in the migration
                    ///   - excludeOwnerProjects: Indicates whether projects owned by the organization or users should be excluded.
                    ///   - orgMetadataOnly: Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).
                    ///   - exclude: Exclude attributes from the API response to improve performance
                    ///   - repositories:
                    public init(
                        lockRepositories: Swift.Bool? = nil,
                        excludeMetadata: Swift.Bool? = nil,
                        excludeGitData: Swift.Bool? = nil,
                        excludeAttachments: Swift.Bool? = nil,
                        excludeReleases: Swift.Bool? = nil,
                        excludeOwnerProjects: Swift.Bool? = nil,
                        orgMetadataOnly: Swift.Bool? = nil,
                        exclude: Operations.MigrationsStartForAuthenticatedUser.Input.Body.JsonPayload.ExcludePayload? = nil,
                        repositories: [Swift.String]
                    ) {
                        self.lockRepositories = lockRepositories
                        self.excludeMetadata = excludeMetadata
                        self.excludeGitData = excludeGitData
                        self.excludeAttachments = excludeAttachments
                        self.excludeReleases = excludeReleases
                        self.excludeOwnerProjects = excludeOwnerProjects
                        self.orgMetadataOnly = orgMetadataOnly
                        self.exclude = exclude
                        self.repositories = repositories
                    }
                    public enum CodingKeys: String, CodingKey {
                        case lockRepositories = "lock_repositories"
                        case excludeMetadata = "exclude_metadata"
                        case excludeGitData = "exclude_git_data"
                        case excludeAttachments = "exclude_attachments"
                        case excludeReleases = "exclude_releases"
                        case excludeOwnerProjects = "exclude_owner_projects"
                        case orgMetadataOnly = "org_metadata_only"
                        case exclude
                        case repositories
                    }
                }
                /// - Remark: Generated from `#/paths/user/migrations/POST/requestBody/content/application\/json`.
                case json(Operations.MigrationsStartForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.MigrationsStartForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.MigrationsStartForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.MigrationsStartForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Migration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Migration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsStartForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsStartForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.MigrationsStartForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.MigrationsStartForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/post(migrations/start-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a user migration status
    ///
    /// Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
    ///
    /// *   `pending` - the migration hasn't started yet.
    /// *   `exporting` - the migration is in progress.
    /// *   `exported` - the migration finished successfully.
    /// *   `failed` - the migration failed.
    ///
    /// Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/migrations/users#download-a-user-migration-archive).
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)`.
    public enum MigrationsGetStatusForAuthenticatedUser {
        public static let id: Swift.String = "migrations/get-status-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - migrationId: The unique identifier of the migration.
                public init(migrationId: Components.Parameters.MigrationId) {
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/query/exclude`.
                public var exclude: [Swift.String]?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - exclude:
                public init(exclude: [Swift.String]? = nil) {
                    self.exclude = exclude
                }
            }
            public var query: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetStatusForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetStatusForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Path,
                query: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.MigrationsGetStatusForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Migration)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Migration {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsGetStatusForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MigrationsGetStatusForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsGetStatusForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsGetStatusForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/get(migrations/get-status-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Download a user migration archive
    ///
    /// Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
    ///
    /// *   attachments
    /// *   bases
    /// *   commit\_comments
    /// *   issue\_comments
    /// *   issue\_events
    /// *   issues
    /// *   milestones
    /// *   organizations
    /// *   projects
    /// *   protected\_branches
    /// *   pull\_request\_reviews
    /// *   pull\_requests
    /// *   releases
    /// *   repositories
    /// *   review\_comments
    /// *   schema
    /// *   users
    ///
    /// The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)`.
    public enum MigrationsGetArchiveForAuthenticatedUser {
        public static let id: Swift.String = "migrations/get-archive-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - migrationId: The unique identifier of the migration.
                public init(migrationId: Components.Parameters.MigrationId) {
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetArchiveForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsGetArchiveForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Path,
                headers: Operations.MigrationsGetArchiveForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Found: Sendable, Hashable {
                /// Creates a new `Found`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            case found(Operations.MigrationsGetArchiveForAuthenticatedUser.Output.Found)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/302`.
            ///
            /// HTTP response code: `302 found`.
            public static var found: Self {
                .found(.init())
            }
            /// The associated value of the enum case if `self` is `.found`.
            ///
            /// - Throws: An error if `self` is not `.found`.
            /// - SeeAlso: `.found`.
            public var found: Operations.MigrationsGetArchiveForAuthenticatedUser.Output.Found {
                get throws {
                    switch self {
                    case let .found(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "found",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/get(migrations/get-archive-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a user migration archive
    ///
    /// Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/migrations/users#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/migrations/users#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/archive`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)`.
    public enum MigrationsDeleteArchiveForAuthenticatedUser {
        public static let id: Swift.String = "migrations/delete-archive-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/DELETE/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - migrationId: The unique identifier of the migration.
                public init(migrationId: Components.Parameters.MigrationId) {
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/archive/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDeleteArchiveForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsDeleteArchiveForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Path,
                headers: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.MigrationsDeleteArchiveForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.MigrationsDeleteArchiveForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/archive/delete(migrations/delete-archive-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Unlock a user repository
    ///
    /// Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/migrations/users#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/repos/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
    ///
    /// - Remark: HTTP `DELETE /user/migrations/{migration_id}/repos/{repo_name}/lock`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)`.
    public enum MigrationsUnlockRepoForAuthenticatedUser {
        public static let id: Swift.String = "migrations/unlock-repo-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// repo_name parameter
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/path/repo_name`.
                public var repoName: Components.Parameters.RepoName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - migrationId: The unique identifier of the migration.
                ///   - repoName: repo_name parameter
                public init(
                    migrationId: Components.Parameters.MigrationId,
                    repoName: Components.Parameters.RepoName
                ) {
                    self.migrationId = migrationId
                    self.repoName = repoName
                }
            }
            public var path: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repos/{repo_name}/lock/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUnlockRepoForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsUnlockRepoForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Path,
                headers: Operations.MigrationsUnlockRepoForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.MigrationsUnlockRepoForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.MigrationsUnlockRepoForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repos/{repo_name}/lock/delete(migrations/unlock-repo-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repositories for a user migration
    ///
    /// Lists all the repositories for this user migration.
    ///
    /// - Remark: HTTP `GET /user/migrations/{migration_id}/repositories`.
    /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repositories/get(migrations/list-repos-for-authenticated-user)`.
    public enum MigrationsListReposForAuthenticatedUser {
        public static let id: Swift.String = "migrations/list-repos-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The unique identifier of the migration.
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/path/migration_id`.
                public var migrationId: Components.Parameters.MigrationId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - migrationId: The unique identifier of the migration.
                public init(migrationId: Components.Parameters.MigrationId) {
                    self.migrationId = migrationId
                }
            }
            public var path: Operations.MigrationsListReposForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.MigrationsListReposForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListReposForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MigrationsListReposForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MigrationsListReposForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.MigrationsListReposForAuthenticatedUser.Input.Path,
                query: Operations.MigrationsListReposForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.MigrationsListReposForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MigrationsListReposForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/migrations/{migration_id}/repositories/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.MinimalRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.MinimalRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MigrationsListReposForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MigrationsListReposForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.MigrationsListReposForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repositories/get(migrations/list-repos-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MigrationsListReposForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MigrationsListReposForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/migrations/{migration_id}/repositories/get(migrations/list-repos-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
