// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// GitHub API Root
    ///
    /// Get Hypermedia links to resources accessible in GitHub's REST API
    ///
    /// - Remark: HTTP `GET /`.
    /// - Remark: Generated from `#/paths///get(meta/root)`.
    func metaRoot(_ input: Operations.MetaRoot.Input) async throws -> Operations.MetaRoot.Output
    /// Get GitHub meta information
    ///
    /// Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/articles/about-github-s-ip-addresses/)."
    ///
    /// The API's response also includes a list of GitHub's domain names.
    ///
    /// The values shown in the documentation's response are example values. You must always query the API directly to get the latest values.
    ///
    /// > [!NOTE]
    /// > This endpoint returns both IPv4 and IPv6 addresses. However, not all features support IPv6. You should refer to the specific documentation for each feature to determine if IPv6 is supported.
    ///
    /// - Remark: HTTP `GET /meta`.
    /// - Remark: Generated from `#/paths//meta/get(meta/get)`.
    func metaGet(_ input: Operations.MetaGet.Input) async throws -> Operations.MetaGet.Output
    /// Get Octocat
    ///
    /// Get the octocat as ASCII art
    ///
    /// - Remark: HTTP `GET /octocat`.
    /// - Remark: Generated from `#/paths//octocat/get(meta/get-octocat)`.
    func metaGetOctocat(_ input: Operations.MetaGetOctocat.Input) async throws -> Operations.MetaGetOctocat.Output
    /// Get all API versions
    ///
    /// Get all supported GitHub API versions.
    ///
    /// - Remark: HTTP `GET /versions`.
    /// - Remark: Generated from `#/paths//versions/get(meta/get-all-versions)`.
    func metaGetAllVersions(_ input: Operations.MetaGetAllVersions.Input) async throws -> Operations.MetaGetAllVersions.Output
    /// Get the Zen of GitHub
    ///
    /// Get a random sentence from the Zen of GitHub
    ///
    /// - Remark: HTTP `GET /zen`.
    /// - Remark: Generated from `#/paths//zen/get(meta/get-zen)`.
    func metaGetZen(_ input: Operations.MetaGetZen.Input) async throws -> Operations.MetaGetZen.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// GitHub API Root
    ///
    /// Get Hypermedia links to resources accessible in GitHub's REST API
    ///
    /// - Remark: HTTP `GET /`.
    /// - Remark: Generated from `#/paths///get(meta/root)`.
    public func metaRoot(headers: Operations.MetaRoot.Input.Headers = .init()) async throws -> Operations.MetaRoot.Output {
        try await metaRoot(Operations.MetaRoot.Input(headers: headers))
    }
    /// Get GitHub meta information
    ///
    /// Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/articles/about-github-s-ip-addresses/)."
    ///
    /// The API's response also includes a list of GitHub's domain names.
    ///
    /// The values shown in the documentation's response are example values. You must always query the API directly to get the latest values.
    ///
    /// > [!NOTE]
    /// > This endpoint returns both IPv4 and IPv6 addresses. However, not all features support IPv6. You should refer to the specific documentation for each feature to determine if IPv6 is supported.
    ///
    /// - Remark: HTTP `GET /meta`.
    /// - Remark: Generated from `#/paths//meta/get(meta/get)`.
    public func metaGet(headers: Operations.MetaGet.Input.Headers = .init()) async throws -> Operations.MetaGet.Output {
        try await metaGet(Operations.MetaGet.Input(headers: headers))
    }
    /// Get Octocat
    ///
    /// Get the octocat as ASCII art
    ///
    /// - Remark: HTTP `GET /octocat`.
    /// - Remark: Generated from `#/paths//octocat/get(meta/get-octocat)`.
    public func metaGetOctocat(
        query: Operations.MetaGetOctocat.Input.Query = .init(),
        headers: Operations.MetaGetOctocat.Input.Headers = .init()
    ) async throws -> Operations.MetaGetOctocat.Output {
        try await metaGetOctocat(Operations.MetaGetOctocat.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get all API versions
    ///
    /// Get all supported GitHub API versions.
    ///
    /// - Remark: HTTP `GET /versions`.
    /// - Remark: Generated from `#/paths//versions/get(meta/get-all-versions)`.
    public func metaGetAllVersions(headers: Operations.MetaGetAllVersions.Input.Headers = .init()) async throws -> Operations.MetaGetAllVersions.Output {
        try await metaGetAllVersions(Operations.MetaGetAllVersions.Input(headers: headers))
    }
    /// Get the Zen of GitHub
    ///
    /// Get a random sentence from the Zen of GitHub
    ///
    /// - Remark: HTTP `GET /zen`.
    /// - Remark: Generated from `#/paths//zen/get(meta/get-zen)`.
    public func metaGetZen(headers: Operations.MetaGetZen.Input.Headers = .init()) async throws -> Operations.MetaGetZen.Output {
        try await metaGetZen(Operations.MetaGetZen.Input(headers: headers))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// - Remark: Generated from `#/components/schemas/root`.
        public struct Root: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/root/current_user_url`.
            public var currentUserUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/current_user_authorizations_html_url`.
            public var currentUserAuthorizationsHtmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/authorizations_url`.
            public var authorizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/code_search_url`.
            public var codeSearchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/commit_search_url`.
            public var commitSearchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/emails_url`.
            public var emailsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/emojis_url`.
            public var emojisUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/feeds_url`.
            public var feedsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/hub_url`.
            @available(*, deprecated)
            public var hubUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/root/issue_search_url`.
            public var issueSearchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/label_search_url`.
            public var labelSearchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/organization_url`.
            public var organizationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/organization_repositories_url`.
            public var organizationRepositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/organization_teams_url`.
            public var organizationTeamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/public_gists_url`.
            public var publicGistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/rate_limit_url`.
            public var rateLimitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/repository_url`.
            public var repositoryUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/repository_search_url`.
            public var repositorySearchUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/current_user_repositories_url`.
            public var currentUserRepositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/starred_gists_url`.
            public var starredGistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/topic_search_url`.
            public var topicSearchUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/root/user_url`.
            public var userUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/user_organizations_url`.
            public var userOrganizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/user_repositories_url`.
            public var userRepositoriesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/root/user_search_url`.
            public var userSearchUrl: Swift.String
            /// Creates a new `Root`.
            ///
            /// - Parameters:
            ///   - currentUserUrl:
            ///   - currentUserAuthorizationsHtmlUrl:
            ///   - authorizationsUrl:
            ///   - codeSearchUrl:
            ///   - commitSearchUrl:
            ///   - emailsUrl:
            ///   - emojisUrl:
            ///   - eventsUrl:
            ///   - feedsUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - hubUrl:
            ///   - issueSearchUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelSearchUrl:
            ///   - notificationsUrl:
            ///   - organizationUrl:
            ///   - organizationRepositoriesUrl:
            ///   - organizationTeamsUrl:
            ///   - publicGistsUrl:
            ///   - rateLimitUrl:
            ///   - repositoryUrl:
            ///   - repositorySearchUrl:
            ///   - currentUserRepositoriesUrl:
            ///   - starredUrl:
            ///   - starredGistsUrl:
            ///   - topicSearchUrl:
            ///   - userUrl:
            ///   - userOrganizationsUrl:
            ///   - userRepositoriesUrl:
            ///   - userSearchUrl:
            public init(
                currentUserUrl: Swift.String,
                currentUserAuthorizationsHtmlUrl: Swift.String,
                authorizationsUrl: Swift.String,
                codeSearchUrl: Swift.String,
                commitSearchUrl: Swift.String,
                emailsUrl: Swift.String,
                emojisUrl: Swift.String,
                eventsUrl: Swift.String,
                feedsUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                hubUrl: Swift.String? = nil,
                issueSearchUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelSearchUrl: Swift.String,
                notificationsUrl: Swift.String,
                organizationUrl: Swift.String,
                organizationRepositoriesUrl: Swift.String,
                organizationTeamsUrl: Swift.String,
                publicGistsUrl: Swift.String,
                rateLimitUrl: Swift.String,
                repositoryUrl: Swift.String,
                repositorySearchUrl: Swift.String,
                currentUserRepositoriesUrl: Swift.String,
                starredUrl: Swift.String,
                starredGistsUrl: Swift.String,
                topicSearchUrl: Swift.String? = nil,
                userUrl: Swift.String,
                userOrganizationsUrl: Swift.String,
                userRepositoriesUrl: Swift.String,
                userSearchUrl: Swift.String
            ) {
                self.currentUserUrl = currentUserUrl
                self.currentUserAuthorizationsHtmlUrl = currentUserAuthorizationsHtmlUrl
                self.authorizationsUrl = authorizationsUrl
                self.codeSearchUrl = codeSearchUrl
                self.commitSearchUrl = commitSearchUrl
                self.emailsUrl = emailsUrl
                self.emojisUrl = emojisUrl
                self.eventsUrl = eventsUrl
                self.feedsUrl = feedsUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.hubUrl = hubUrl
                self.issueSearchUrl = issueSearchUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelSearchUrl = labelSearchUrl
                self.notificationsUrl = notificationsUrl
                self.organizationUrl = organizationUrl
                self.organizationRepositoriesUrl = organizationRepositoriesUrl
                self.organizationTeamsUrl = organizationTeamsUrl
                self.publicGistsUrl = publicGistsUrl
                self.rateLimitUrl = rateLimitUrl
                self.repositoryUrl = repositoryUrl
                self.repositorySearchUrl = repositorySearchUrl
                self.currentUserRepositoriesUrl = currentUserRepositoriesUrl
                self.starredUrl = starredUrl
                self.starredGistsUrl = starredGistsUrl
                self.topicSearchUrl = topicSearchUrl
                self.userUrl = userUrl
                self.userOrganizationsUrl = userOrganizationsUrl
                self.userRepositoriesUrl = userRepositoriesUrl
                self.userSearchUrl = userSearchUrl
            }
            public enum CodingKeys: String, CodingKey {
                case currentUserUrl = "current_user_url"
                case currentUserAuthorizationsHtmlUrl = "current_user_authorizations_html_url"
                case authorizationsUrl = "authorizations_url"
                case codeSearchUrl = "code_search_url"
                case commitSearchUrl = "commit_search_url"
                case emailsUrl = "emails_url"
                case emojisUrl = "emojis_url"
                case eventsUrl = "events_url"
                case feedsUrl = "feeds_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case hubUrl = "hub_url"
                case issueSearchUrl = "issue_search_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelSearchUrl = "label_search_url"
                case notificationsUrl = "notifications_url"
                case organizationUrl = "organization_url"
                case organizationRepositoriesUrl = "organization_repositories_url"
                case organizationTeamsUrl = "organization_teams_url"
                case publicGistsUrl = "public_gists_url"
                case rateLimitUrl = "rate_limit_url"
                case repositoryUrl = "repository_url"
                case repositorySearchUrl = "repository_search_url"
                case currentUserRepositoriesUrl = "current_user_repositories_url"
                case starredUrl = "starred_url"
                case starredGistsUrl = "starred_gists_url"
                case topicSearchUrl = "topic_search_url"
                case userUrl = "user_url"
                case userOrganizationsUrl = "user_organizations_url"
                case userRepositoriesUrl = "user_repositories_url"
                case userSearchUrl = "user_search_url"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Api Overview
        ///
        /// - Remark: Generated from `#/components/schemas/api-overview`.
        public struct ApiOverview: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/api-overview/verifiable_password_authentication`.
            public var verifiablePasswordAuthentication: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints`.
            public struct SshKeyFingerprintsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints/SHA256_RSA`.
                public var sha256Rsa: Swift.String?
                /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints/SHA256_DSA`.
                public var sha256Dsa: Swift.String?
                /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints/SHA256_ECDSA`.
                public var sha256Ecdsa: Swift.String?
                /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints/SHA256_ED25519`.
                public var sha256Ed25519: Swift.String?
                /// Creates a new `SshKeyFingerprintsPayload`.
                ///
                /// - Parameters:
                ///   - sha256Rsa:
                ///   - sha256Dsa:
                ///   - sha256Ecdsa:
                ///   - sha256Ed25519:
                public init(
                    sha256Rsa: Swift.String? = nil,
                    sha256Dsa: Swift.String? = nil,
                    sha256Ecdsa: Swift.String? = nil,
                    sha256Ed25519: Swift.String? = nil
                ) {
                    self.sha256Rsa = sha256Rsa
                    self.sha256Dsa = sha256Dsa
                    self.sha256Ecdsa = sha256Ecdsa
                    self.sha256Ed25519 = sha256Ed25519
                }
                public enum CodingKeys: String, CodingKey {
                    case sha256Rsa = "SHA256_RSA"
                    case sha256Dsa = "SHA256_DSA"
                    case sha256Ecdsa = "SHA256_ECDSA"
                    case sha256Ed25519 = "SHA256_ED25519"
                }
            }
            /// - Remark: Generated from `#/components/schemas/api-overview/ssh_key_fingerprints`.
            public var sshKeyFingerprints: Components.Schemas.ApiOverview.SshKeyFingerprintsPayload?
            /// - Remark: Generated from `#/components/schemas/api-overview/ssh_keys`.
            public var sshKeys: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/hooks`.
            public var hooks: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/github_enterprise_importer`.
            public var githubEnterpriseImporter: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/web`.
            public var web: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/api`.
            public var api: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/git`.
            public var git: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/packages`.
            public var packages: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/pages`.
            public var pages: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/importer`.
            public var importer: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/actions`.
            public var actions: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/actions_macos`.
            public var actionsMacos: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/codespaces`.
            public var codespaces: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/dependabot`.
            public var dependabot: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/copilot`.
            public var copilot: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/api-overview/domains`.
            public struct DomainsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/website`.
                public var website: [Swift.String]?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/codespaces`.
                public var codespaces: [Swift.String]?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/copilot`.
                public var copilot: [Swift.String]?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/packages`.
                public var packages: [Swift.String]?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/actions`.
                public var actions: [Swift.String]?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/actions_inbound`.
                public struct ActionsInboundPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/api-overview/domains/actions_inbound/full_domains`.
                    public var fullDomains: [Swift.String]?
                    /// - Remark: Generated from `#/components/schemas/api-overview/domains/actions_inbound/wildcard_domains`.
                    public var wildcardDomains: [Swift.String]?
                    /// Creates a new `ActionsInboundPayload`.
                    ///
                    /// - Parameters:
                    ///   - fullDomains:
                    ///   - wildcardDomains:
                    public init(
                        fullDomains: [Swift.String]? = nil,
                        wildcardDomains: [Swift.String]? = nil
                    ) {
                        self.fullDomains = fullDomains
                        self.wildcardDomains = wildcardDomains
                    }
                    public enum CodingKeys: String, CodingKey {
                        case fullDomains = "full_domains"
                        case wildcardDomains = "wildcard_domains"
                    }
                }
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/actions_inbound`.
                public var actionsInbound: Components.Schemas.ApiOverview.DomainsPayload.ActionsInboundPayload?
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/artifact_attestations`.
                public struct ArtifactAttestationsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/api-overview/domains/artifact_attestations/trust_domain`.
                    public var trustDomain: Swift.String?
                    /// - Remark: Generated from `#/components/schemas/api-overview/domains/artifact_attestations/services`.
                    public var services: [Swift.String]?
                    /// Creates a new `ArtifactAttestationsPayload`.
                    ///
                    /// - Parameters:
                    ///   - trustDomain:
                    ///   - services:
                    public init(
                        trustDomain: Swift.String? = nil,
                        services: [Swift.String]? = nil
                    ) {
                        self.trustDomain = trustDomain
                        self.services = services
                    }
                    public enum CodingKeys: String, CodingKey {
                        case trustDomain = "trust_domain"
                        case services
                    }
                }
                /// - Remark: Generated from `#/components/schemas/api-overview/domains/artifact_attestations`.
                public var artifactAttestations: Components.Schemas.ApiOverview.DomainsPayload.ArtifactAttestationsPayload?
                /// Creates a new `DomainsPayload`.
                ///
                /// - Parameters:
                ///   - website:
                ///   - codespaces:
                ///   - copilot:
                ///   - packages:
                ///   - actions:
                ///   - actionsInbound:
                ///   - artifactAttestations:
                public init(
                    website: [Swift.String]? = nil,
                    codespaces: [Swift.String]? = nil,
                    copilot: [Swift.String]? = nil,
                    packages: [Swift.String]? = nil,
                    actions: [Swift.String]? = nil,
                    actionsInbound: Components.Schemas.ApiOverview.DomainsPayload.ActionsInboundPayload? = nil,
                    artifactAttestations: Components.Schemas.ApiOverview.DomainsPayload.ArtifactAttestationsPayload? = nil
                ) {
                    self.website = website
                    self.codespaces = codespaces
                    self.copilot = copilot
                    self.packages = packages
                    self.actions = actions
                    self.actionsInbound = actionsInbound
                    self.artifactAttestations = artifactAttestations
                }
                public enum CodingKeys: String, CodingKey {
                    case website
                    case codespaces
                    case copilot
                    case packages
                    case actions
                    case actionsInbound = "actions_inbound"
                    case artifactAttestations = "artifact_attestations"
                }
            }
            /// - Remark: Generated from `#/components/schemas/api-overview/domains`.
            public var domains: Components.Schemas.ApiOverview.DomainsPayload?
            /// Creates a new `ApiOverview`.
            ///
            /// - Parameters:
            ///   - verifiablePasswordAuthentication:
            ///   - sshKeyFingerprints:
            ///   - sshKeys:
            ///   - hooks:
            ///   - githubEnterpriseImporter:
            ///   - web:
            ///   - api:
            ///   - git:
            ///   - packages:
            ///   - pages:
            ///   - importer:
            ///   - actions:
            ///   - actionsMacos:
            ///   - codespaces:
            ///   - dependabot:
            ///   - copilot:
            ///   - domains:
            public init(
                verifiablePasswordAuthentication: Swift.Bool,
                sshKeyFingerprints: Components.Schemas.ApiOverview.SshKeyFingerprintsPayload? = nil,
                sshKeys: [Swift.String]? = nil,
                hooks: [Swift.String]? = nil,
                githubEnterpriseImporter: [Swift.String]? = nil,
                web: [Swift.String]? = nil,
                api: [Swift.String]? = nil,
                git: [Swift.String]? = nil,
                packages: [Swift.String]? = nil,
                pages: [Swift.String]? = nil,
                importer: [Swift.String]? = nil,
                actions: [Swift.String]? = nil,
                actionsMacos: [Swift.String]? = nil,
                codespaces: [Swift.String]? = nil,
                dependabot: [Swift.String]? = nil,
                copilot: [Swift.String]? = nil,
                domains: Components.Schemas.ApiOverview.DomainsPayload? = nil
            ) {
                self.verifiablePasswordAuthentication = verifiablePasswordAuthentication
                self.sshKeyFingerprints = sshKeyFingerprints
                self.sshKeys = sshKeys
                self.hooks = hooks
                self.githubEnterpriseImporter = githubEnterpriseImporter
                self.web = web
                self.api = api
                self.git = git
                self.packages = packages
                self.pages = pages
                self.importer = importer
                self.actions = actions
                self.actionsMacos = actionsMacos
                self.codespaces = codespaces
                self.dependabot = dependabot
                self.copilot = copilot
                self.domains = domains
            }
            public enum CodingKeys: String, CodingKey {
                case verifiablePasswordAuthentication = "verifiable_password_authentication"
                case sshKeyFingerprints = "ssh_key_fingerprints"
                case sshKeys = "ssh_keys"
                case hooks
                case githubEnterpriseImporter = "github_enterprise_importer"
                case web
                case api
                case git
                case packages
                case pages
                case importer
                case actions
                case actionsMacos = "actions_macos"
                case codespaces
                case dependabot
                case copilot
                case domains
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {}
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// GitHub API Root
    ///
    /// Get Hypermedia links to resources accessible in GitHub's REST API
    ///
    /// - Remark: HTTP `GET /`.
    /// - Remark: Generated from `#/paths///get(meta/root)`.
    public enum MetaRoot {
        public static let id: Swift.String = "meta/root"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaRoot.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaRoot.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MetaRoot.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.MetaRoot.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Root)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Root {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MetaRoot.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MetaRoot.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths///get(meta/root)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MetaRoot.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MetaRoot.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get GitHub meta information
    ///
    /// Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/articles/about-github-s-ip-addresses/)."
    ///
    /// The API's response also includes a list of GitHub's domain names.
    ///
    /// The values shown in the documentation's response are example values. You must always query the API directly to get the latest values.
    ///
    /// > [!NOTE]
    /// > This endpoint returns both IPv4 and IPv6 addresses. However, not all features support IPv6. You should refer to the specific documentation for each feature to determine if IPv6 is supported.
    ///
    /// - Remark: HTTP `GET /meta`.
    /// - Remark: Generated from `#/paths//meta/get(meta/get)`.
    public enum MetaGet {
        public static let id: Swift.String = "meta/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/meta/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MetaGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.MetaGet.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/meta/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/meta/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ApiOverview)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ApiOverview {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MetaGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MetaGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//meta/get(meta/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MetaGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MetaGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//meta/get(meta/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//meta/get(meta/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get Octocat
    ///
    /// Get the octocat as ASCII art
    ///
    /// - Remark: HTTP `GET /octocat`.
    /// - Remark: Generated from `#/paths//octocat/get(meta/get-octocat)`.
    public enum MetaGetOctocat {
        public static let id: Swift.String = "meta/get-octocat"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/octocat/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The words to show in Octocat's speech bubble
                ///
                /// - Remark: Generated from `#/paths/octocat/GET/query/s`.
                public var s: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - s: The words to show in Octocat's speech bubble
                public init(s: Swift.String? = nil) {
                    self.s = s
                }
            }
            public var query: Operations.MetaGetOctocat.Input.Query
            /// - Remark: Generated from `#/paths/octocat/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetOctocat.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetOctocat.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MetaGetOctocat.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.MetaGetOctocat.Input.Query = .init(),
                headers: Operations.MetaGetOctocat.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/octocat/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/octocat/GET/responses/200/content/application\/octocat-stream`.
                    case applicationOctocatStream(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.applicationOctocatStream`.
                    ///
                    /// - Throws: An error if `self` is not `.applicationOctocatStream`.
                    /// - SeeAlso: `.applicationOctocatStream`.
                    public var applicationOctocatStream: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .applicationOctocatStream(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MetaGetOctocat.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MetaGetOctocat.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//octocat/get(meta/get-octocat)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MetaGetOctocat.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MetaGetOctocat.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case applicationOctocatStream
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/octocat-stream":
                    self = .applicationOctocatStream
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .applicationOctocatStream:
                    return "application/octocat-stream"
                }
            }
            public static var allCases: [Self] {
                [
                    .applicationOctocatStream
                ]
            }
        }
    }
    /// Get all API versions
    ///
    /// Get all supported GitHub API versions.
    ///
    /// - Remark: HTTP `GET /versions`.
    /// - Remark: Generated from `#/paths//versions/get(meta/get-all-versions)`.
    public enum MetaGetAllVersions {
        public static let id: Swift.String = "meta/get-all-versions"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/versions/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetAllVersions.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetAllVersions.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MetaGetAllVersions.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.MetaGetAllVersions.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/versions/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/versions/GET/responses/200/content/application\/json`.
                    case json([Swift.String])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Swift.String] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MetaGetAllVersions.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MetaGetAllVersions.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//versions/get(meta/get-all-versions)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MetaGetAllVersions.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MetaGetAllVersions.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//versions/get(meta/get-all-versions)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get the Zen of GitHub
    ///
    /// Get a random sentence from the Zen of GitHub
    ///
    /// - Remark: HTTP `GET /zen`.
    /// - Remark: Generated from `#/paths//zen/get(meta/get-zen)`.
    public enum MetaGetZen {
        public static let id: Swift.String = "meta/get-zen"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/zen/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetZen.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MetaGetZen.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MetaGetZen.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.MetaGetZen.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/zen/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/zen/GET/responses/200/content/text\/plain`.
                    case plainText(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.plainText`.
                    ///
                    /// - Throws: An error if `self` is not `.plainText`.
                    /// - SeeAlso: `.plainText`.
                    public var plainText: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .plainText(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MetaGetZen.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.MetaGetZen.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//zen/get(meta/get-zen)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MetaGetZen.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MetaGetZen.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case plainText
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "text/plain":
                    self = .plainText
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .plainText:
                    return "text/plain"
                }
            }
            public static var allCases: [Self] {
                [
                    .plainText
                ]
            }
        }
    }
}
