// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Render a Markdown document
    ///
    /// Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.
    ///
    /// - Remark: HTTP `POST /markdown`.
    /// - Remark: Generated from `#/paths//markdown/post(markdown/render)`.
    func markdownRender(_ input: Operations.MarkdownRender.Input) async throws -> Operations.MarkdownRender.Output
    /// Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    ///
    /// - Remark: HTTP `POST /markdown/raw`.
    /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)`.
    func markdownRenderRaw(_ input: Operations.MarkdownRenderRaw.Input) async throws -> Operations.MarkdownRenderRaw.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Render a Markdown document
    ///
    /// Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.
    ///
    /// - Remark: HTTP `POST /markdown`.
    /// - Remark: Generated from `#/paths//markdown/post(markdown/render)`.
    public func markdownRender(
        headers: Operations.MarkdownRender.Input.Headers = .init(),
        body: Operations.MarkdownRender.Input.Body
    ) async throws -> Operations.MarkdownRender.Output {
        try await markdownRender(Operations.MarkdownRender.Input(
            headers: headers,
            body: body
        ))
    }
    /// Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    ///
    /// - Remark: HTTP `POST /markdown/raw`.
    /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)`.
    public func markdownRenderRaw(
        headers: Operations.MarkdownRenderRaw.Input.Headers = .init(),
        body: Operations.MarkdownRenderRaw.Input.Body? = nil
    ) async throws -> Operations.MarkdownRenderRaw.Output {
        try await markdownRenderRaw(Operations.MarkdownRenderRaw.Input(
            headers: headers,
            body: body
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {}
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {}
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/content-type`.
        public typealias ContentType = Swift.String
        /// - Remark: Generated from `#/components/headers/x-common-marker-version`.
        public typealias XCommonMarkerVersion = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Render a Markdown document
    ///
    /// Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.
    ///
    /// - Remark: HTTP `POST /markdown`.
    /// - Remark: Generated from `#/paths//markdown/post(markdown/render)`.
    public enum MarkdownRender {
        public static let id: Swift.String = "markdown/render"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/markdown/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MarkdownRender.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MarkdownRender.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MarkdownRender.Input.Headers
            /// - Remark: Generated from `#/paths/markdown/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/markdown/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The Markdown text to render in HTML.
                    ///
                    /// - Remark: Generated from `#/paths/markdown/POST/requestBody/json/text`.
                    public var text: Swift.String
                    /// The rendering mode.
                    ///
                    /// - Remark: Generated from `#/paths/markdown/POST/requestBody/json/mode`.
                    @frozen public enum ModePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case markdown = "markdown"
                        case gfm = "gfm"
                    }
                    /// The rendering mode.
                    ///
                    /// - Remark: Generated from `#/paths/markdown/POST/requestBody/json/mode`.
                    public var mode: Operations.MarkdownRender.Input.Body.JsonPayload.ModePayload?
                    /// The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository.
                    ///
                    /// - Remark: Generated from `#/paths/markdown/POST/requestBody/json/context`.
                    public var context: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - text: The Markdown text to render in HTML.
                    ///   - mode: The rendering mode.
                    ///   - context: The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository.
                    public init(
                        text: Swift.String,
                        mode: Operations.MarkdownRender.Input.Body.JsonPayload.ModePayload? = nil,
                        context: Swift.String? = nil
                    ) {
                        self.text = text
                        self.mode = mode
                        self.context = context
                    }
                    public enum CodingKeys: String, CodingKey {
                        case text
                        case mode
                        case context
                    }
                }
                /// - Remark: Generated from `#/paths/markdown/POST/requestBody/content/application\/json`.
                case json(Operations.MarkdownRender.Input.Body.JsonPayload)
            }
            public var body: Operations.MarkdownRender.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.MarkdownRender.Input.Headers = .init(),
                body: Operations.MarkdownRender.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/markdown/POST/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/markdown/POST/responses/200/headers/Content-Type`.
                    public var contentType: Components.Headers.ContentType?
                    /// - Remark: Generated from `#/paths/markdown/POST/responses/200/headers/Content-Length`.
                    public var contentLength: Swift.String?
                    /// - Remark: Generated from `#/paths/markdown/POST/responses/200/headers/X-CommonMarker-Version`.
                    public var xCommonMarkerVersion: Components.Headers.XCommonMarkerVersion?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - contentType:
                    ///   - contentLength:
                    ///   - xCommonMarkerVersion:
                    public init(
                        contentType: Components.Headers.ContentType? = nil,
                        contentLength: Swift.String? = nil,
                        xCommonMarkerVersion: Components.Headers.XCommonMarkerVersion? = nil
                    ) {
                        self.contentType = contentType
                        self.contentLength = contentLength
                        self.xCommonMarkerVersion = xCommonMarkerVersion
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MarkdownRender.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/markdown/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/markdown/POST/responses/200/content/text\/html`.
                    case html(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.html`.
                    ///
                    /// - Throws: An error if `self` is not `.html`.
                    /// - SeeAlso: `.html`.
                    public var html: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .html(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MarkdownRender.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MarkdownRender.Output.Ok.Headers = .init(),
                    body: Operations.MarkdownRender.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//markdown/post(markdown/render)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MarkdownRender.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MarkdownRender.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//markdown/post(markdown/render)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//markdown/post(markdown/render)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case html
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "text/html":
                    self = .html
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .html:
                    return "text/html"
                }
            }
            public static var allCases: [Self] {
                [
                    .html
                ]
            }
        }
    }
    /// Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    ///
    /// - Remark: HTTP `POST /markdown/raw`.
    /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)`.
    public enum MarkdownRenderRaw {
        public static let id: Swift.String = "markdown/render-raw"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/markdown/raw/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MarkdownRenderRaw.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.MarkdownRenderRaw.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.MarkdownRenderRaw.Input.Headers
            /// - Remark: Generated from `#/paths/markdown/raw/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/markdown/raw/POST/requestBody/content/text\/plain`.
                case plainText(OpenAPIRuntime.HTTPBody)
                /// - Remark: Generated from `#/paths/markdown/raw/POST/requestBody/content/text\/x-markdown`.
                case textXMarkdown(OpenAPIRuntime.HTTPBody)
            }
            public var body: Operations.MarkdownRenderRaw.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.MarkdownRenderRaw.Input.Headers = .init(),
                body: Operations.MarkdownRenderRaw.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/markdown/raw/POST/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/markdown/raw/POST/responses/200/headers/X-CommonMarker-Version`.
                    public var xCommonMarkerVersion: Components.Headers.XCommonMarkerVersion?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - xCommonMarkerVersion:
                    public init(xCommonMarkerVersion: Components.Headers.XCommonMarkerVersion? = nil) {
                        self.xCommonMarkerVersion = xCommonMarkerVersion
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.MarkdownRenderRaw.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/markdown/raw/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/markdown/raw/POST/responses/200/content/text\/html`.
                    case html(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.html`.
                    ///
                    /// - Throws: An error if `self` is not `.html`.
                    /// - SeeAlso: `.html`.
                    public var html: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .html(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.MarkdownRenderRaw.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.MarkdownRenderRaw.Output.Ok.Headers = .init(),
                    body: Operations.MarkdownRenderRaw.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.MarkdownRenderRaw.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.MarkdownRenderRaw.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case html
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "text/html":
                    self = .html
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .html:
                    return "text/html"
                }
            }
            public static var allCases: [Self] {
                [
                    .html
                ]
            }
        }
    }
}
