// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// GitHub's v3 REST API.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// Render a Markdown document
    ///
    /// Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.
    ///
    /// - Remark: HTTP `POST /markdown`.
    /// - Remark: Generated from `#/paths//markdown/post(markdown/render)`.
    public func markdownRender(_ input: Operations.MarkdownRender.Input) async throws -> Operations.MarkdownRender.Output {
        try await client.send(
            input: input,
            forOperation: Operations.MarkdownRender.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/markdown",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.MarkdownRender.Output.Ok.Headers = .init(
                        contentType: try converter.getOptionalHeaderFieldAsURI(
                            in: response.headerFields,
                            name: "Content-Type",
                            as: Components.Headers.ContentType.self
                        ),
                        contentLength: try converter.getOptionalHeaderFieldAsURI(
                            in: response.headerFields,
                            name: "Content-Length",
                            as: Swift.String.self
                        ),
                        xCommonMarkerVersion: try converter.getOptionalHeaderFieldAsURI(
                            in: response.headerFields,
                            name: "X-CommonMarker-Version",
                            as: Components.Headers.XCommonMarkerVersion.self
                        )
                    )
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.MarkdownRender.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "text/html"
                        ]
                    )
                    switch chosenContentType {
                    case "text/html":
                        body = try converter.getResponseBodyAsBinary(
                            OpenAPIRuntime.HTTPBody.self,
                            from: responseBody,
                            transforming: { value in
                                .html(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Render a Markdown document in raw mode
    ///
    /// You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
    ///
    /// - Remark: HTTP `POST /markdown/raw`.
    /// - Remark: Generated from `#/paths//markdown/raw/post(markdown/render-raw)`.
    public func markdownRenderRaw(_ input: Operations.MarkdownRenderRaw.Input) async throws -> Operations.MarkdownRenderRaw.Output {
        try await client.send(
            input: input,
            forOperation: Operations.MarkdownRenderRaw.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/markdown/raw",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .plainText(value):
                    body = try converter.setOptionalRequestBodyAsBinary(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "text/plain"
                    )
                case let .textXMarkdown(value):
                    body = try converter.setOptionalRequestBodyAsBinary(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "text/x-markdown"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.MarkdownRenderRaw.Output.Ok.Headers = .init(xCommonMarkerVersion: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "X-CommonMarker-Version",
                        as: Components.Headers.XCommonMarkerVersion.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.MarkdownRenderRaw.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "text/html"
                        ]
                    )
                    switch chosenContentType {
                    case "text/html":
                        body = try converter.getResponseBodyAsBinary(
                            OpenAPIRuntime.HTTPBody.self,
                            from: responseBody,
                            transforming: { value in
                                .html(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                case 304:
                    return .notModified(.init())
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
