// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get all commonly used licenses
    ///
    /// Lists the most commonly used licenses on GitHub. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses`.
    /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)`.
    func licensesGetAllCommonlyUsed(_ input: Operations.LicensesGetAllCommonlyUsed.Input) async throws -> Operations.LicensesGetAllCommonlyUsed.Output
    /// Get a license
    ///
    /// Gets information about a specific license. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses/{license}`.
    /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)`.
    func licensesGet(_ input: Operations.LicensesGet.Input) async throws -> Operations.LicensesGet.Output
    /// Get the license for a repository
    ///
    /// This method returns the contents of the repository's license file, if one is detected.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw contents of the license.
    /// - **`application/vnd.github.html+json`**: Returns the license contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/license`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/license/get(licenses/get-for-repo)`.
    func licensesGetForRepo(_ input: Operations.LicensesGetForRepo.Input) async throws -> Operations.LicensesGetForRepo.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get all commonly used licenses
    ///
    /// Lists the most commonly used licenses on GitHub. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses`.
    /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)`.
    public func licensesGetAllCommonlyUsed(
        query: Operations.LicensesGetAllCommonlyUsed.Input.Query = .init(),
        headers: Operations.LicensesGetAllCommonlyUsed.Input.Headers = .init()
    ) async throws -> Operations.LicensesGetAllCommonlyUsed.Output {
        try await licensesGetAllCommonlyUsed(Operations.LicensesGetAllCommonlyUsed.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get a license
    ///
    /// Gets information about a specific license. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses/{license}`.
    /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)`.
    public func licensesGet(
        path: Operations.LicensesGet.Input.Path,
        headers: Operations.LicensesGet.Input.Headers = .init()
    ) async throws -> Operations.LicensesGet.Output {
        try await licensesGet(Operations.LicensesGet.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get the license for a repository
    ///
    /// This method returns the contents of the repository's license file, if one is detected.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw contents of the license.
    /// - **`application/vnd.github.html+json`**: Returns the license contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/license`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/license/get(licenses/get-for-repo)`.
    public func licensesGetForRepo(
        path: Operations.LicensesGetForRepo.Input.Path,
        query: Operations.LicensesGetForRepo.Input.Query = .init(),
        headers: Operations.LicensesGetForRepo.Input.Headers = .init()
    ) async throws -> Operations.LicensesGetForRepo.Output {
        try await licensesGetForRepo(Operations.LicensesGetForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/license-simple`.
        public struct LicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `LicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// License
        ///
        /// - Remark: Generated from `#/components/schemas/license`.
        public struct License: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/license/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/description`.
            public var description: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/implementation`.
            public var implementation: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/permissions`.
            public var permissions: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/license/conditions`.
            public var conditions: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/license/limitations`.
            public var limitations: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/license/body`.
            public var body: Swift.String
            /// - Remark: Generated from `#/components/schemas/license/featured`.
            public var featured: Swift.Bool
            /// Creates a new `License`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - spdxId:
            ///   - url:
            ///   - nodeId:
            ///   - htmlUrl:
            ///   - description:
            ///   - implementation:
            ///   - permissions:
            ///   - conditions:
            ///   - limitations:
            ///   - body:
            ///   - featured:
            public init(
                key: Swift.String,
                name: Swift.String,
                spdxId: Swift.String? = nil,
                url: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String,
                description: Swift.String,
                implementation: Swift.String,
                permissions: [Swift.String],
                conditions: [Swift.String],
                limitations: [Swift.String],
                body: Swift.String,
                featured: Swift.Bool
            ) {
                self.key = key
                self.name = name
                self.spdxId = spdxId
                self.url = url
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
                self.description = description
                self.implementation = implementation
                self.permissions = permissions
                self.conditions = conditions
                self.limitations = limitations
                self.body = body
                self.featured = featured
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case spdxId = "spdx_id"
                case url
                case nodeId = "node_id"
                case htmlUrl = "html_url"
                case description
                case implementation
                case permissions
                case conditions
                case limitations
                case body
                case featured
            }
        }
        /// The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`,
        /// `refs/heads/<branch name>` or simply `<branch name>`.
        ///
        /// - Remark: Generated from `#/components/schemas/code-scanning-ref`.
        public typealias CodeScanningRef = Swift.String
        /// License Content
        ///
        /// - Remark: Generated from `#/components/schemas/license-content`.
        public struct LicenseContent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/license-content/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/path`.
            public var path: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/sha`.
            public var sha: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/size`.
            public var size: Swift.Int
            /// - Remark: Generated from `#/components/schemas/license-content/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/html_url`.
            public var htmlUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license-content/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license-content/download_url`.
            public var downloadUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/license-content/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/content`.
            public var content: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/encoding`.
            public var encoding: Swift.String
            /// - Remark: Generated from `#/components/schemas/license-content/_links`.
            public struct _LinksPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/license-content/_links/git`.
                public var git: Swift.String?
                /// - Remark: Generated from `#/components/schemas/license-content/_links/html`.
                public var html: Swift.String?
                /// - Remark: Generated from `#/components/schemas/license-content/_links/self`.
                public var _self: Swift.String
                /// Creates a new `_LinksPayload`.
                ///
                /// - Parameters:
                ///   - git:
                ///   - html:
                ///   - _self:
                public init(
                    git: Swift.String? = nil,
                    html: Swift.String? = nil,
                    _self: Swift.String
                ) {
                    self.git = git
                    self.html = html
                    self._self = _self
                }
                public enum CodingKeys: String, CodingKey {
                    case git
                    case html
                    case _self = "self"
                }
            }
            /// - Remark: Generated from `#/components/schemas/license-content/_links`.
            public var _links: Components.Schemas.LicenseContent._LinksPayload
            /// - Remark: Generated from `#/components/schemas/license-content/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// Creates a new `LicenseContent`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - path:
            ///   - sha:
            ///   - size:
            ///   - url:
            ///   - htmlUrl:
            ///   - gitUrl:
            ///   - downloadUrl:
            ///   - _type:
            ///   - content:
            ///   - encoding:
            ///   - _links:
            ///   - license:
            public init(
                name: Swift.String,
                path: Swift.String,
                sha: Swift.String,
                size: Swift.Int,
                url: Swift.String,
                htmlUrl: Swift.String? = nil,
                gitUrl: Swift.String? = nil,
                downloadUrl: Swift.String? = nil,
                _type: Swift.String,
                content: Swift.String,
                encoding: Swift.String,
                _links: Components.Schemas.LicenseContent._LinksPayload,
                license: Components.Schemas.NullableLicenseSimple? = nil
            ) {
                self.name = name
                self.path = path
                self.sha = sha
                self.size = size
                self.url = url
                self.htmlUrl = htmlUrl
                self.gitUrl = gitUrl
                self.downloadUrl = downloadUrl
                self._type = _type
                self.content = content
                self.encoding = encoding
                self._links = _links
                self.license = license
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case path
                case sha
                case size
                case url
                case htmlUrl = "html_url"
                case gitUrl = "git_url"
                case downloadUrl = "download_url"
                case _type = "type"
                case content
                case encoding
                case _links
                case license
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
        ///
        /// - Remark: Generated from `#/components/parameters/git-ref`.
        public typealias GitRef = Components.Schemas.CodeScanningRef
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get all commonly used licenses
    ///
    /// Lists the most commonly used licenses on GitHub. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses`.
    /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)`.
    public enum LicensesGetAllCommonlyUsed {
        public static let id: Swift.String = "licenses/get-all-commonly-used"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/licenses/GET/query`.
            public struct Query: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/licenses/GET/query/featured`.
                public var featured: Swift.Bool?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/licenses/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/licenses/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - featured:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    featured: Swift.Bool? = nil,
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.featured = featured
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.LicensesGetAllCommonlyUsed.Input.Query
            /// - Remark: Generated from `#/paths/licenses/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGetAllCommonlyUsed.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGetAllCommonlyUsed.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.LicensesGetAllCommonlyUsed.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.LicensesGetAllCommonlyUsed.Input.Query = .init(),
                headers: Operations.LicensesGetAllCommonlyUsed.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/licenses/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/licenses/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.LicenseSimple])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.LicenseSimple] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.LicensesGetAllCommonlyUsed.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.LicensesGetAllCommonlyUsed.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.LicensesGetAllCommonlyUsed.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.LicensesGetAllCommonlyUsed.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//licenses/get(licenses/get-all-commonly-used)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a license
    ///
    /// Gets information about a specific license. For more information, see "[Licensing a repository ](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository)."
    ///
    /// - Remark: HTTP `GET /licenses/{license}`.
    /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)`.
    public enum LicensesGet {
        public static let id: Swift.String = "licenses/get"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/licenses/{license}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/licenses/{license}/GET/path/license`.
                public var license: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - license:
                public init(license: Swift.String) {
                    self.license = license
                }
            }
            public var path: Operations.LicensesGet.Input.Path
            /// - Remark: Generated from `#/paths/licenses/{license}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGet.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGet.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.LicensesGet.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.LicensesGet.Input.Path,
                headers: Operations.LicensesGet.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/licenses/{license}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/licenses/{license}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.License)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.License {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.LicensesGet.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.LicensesGet.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.LicensesGet.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.LicensesGet.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//licenses/{license}/get(licenses/get)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get the license for a repository
    ///
    /// This method returns the contents of the repository's license file, if one is detected.
    ///
    /// This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."
    ///
    /// - **`application/vnd.github.raw+json`**: Returns the raw contents of the license.
    /// - **`application/vnd.github.html+json`**: Returns the license contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/license`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/license/get(licenses/get-for-repo)`.
    public enum LicensesGetForRepo {
        public static let id: Swift.String = "licenses/get-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.LicensesGetForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/query/ref`.
                public var ref: Components.Parameters.GitRef?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - ref: The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`.
                public init(ref: Components.Parameters.GitRef? = nil) {
                    self.ref = ref
                }
            }
            public var query: Operations.LicensesGetForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGetForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.LicensesGetForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.LicensesGetForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.LicensesGetForRepo.Input.Path,
                query: Operations.LicensesGetForRepo.Input.Query = .init(),
                headers: Operations.LicensesGetForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/license/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.LicenseContent)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.LicenseContent {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.LicensesGetForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.LicensesGetForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/license/get(licenses/get-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.LicensesGetForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.LicensesGetForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/license/get(licenses/get-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
