// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Get interaction restrictions for an organization
    ///
    /// Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/get(interactions/get-restrictions-for-org)`.
    func interactionsGetRestrictionsForOrg(_ input: Operations.InteractionsGetRestrictionsForOrg.Input) async throws -> Operations.InteractionsGetRestrictionsForOrg.Output
    /// Set interaction restrictions for an organization
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/put(interactions/set-restrictions-for-org)`.
    func interactionsSetRestrictionsForOrg(_ input: Operations.InteractionsSetRestrictionsForOrg.Input) async throws -> Operations.InteractionsSetRestrictionsForOrg.Output
    /// Remove interaction restrictions for an organization
    ///
    /// Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/delete(interactions/remove-restrictions-for-org)`.
    func interactionsRemoveRestrictionsForOrg(_ input: Operations.InteractionsRemoveRestrictionsForOrg.Input) async throws -> Operations.InteractionsRemoveRestrictionsForOrg.Output
    /// Get interaction restrictions for a repository
    ///
    /// Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/get(interactions/get-restrictions-for-repo)`.
    func interactionsGetRestrictionsForRepo(_ input: Operations.InteractionsGetRestrictionsForRepo.Input) async throws -> Operations.InteractionsGetRestrictionsForRepo.Output
    /// Set interaction restrictions for a repository
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)`.
    func interactionsSetRestrictionsForRepo(_ input: Operations.InteractionsSetRestrictionsForRepo.Input) async throws -> Operations.InteractionsSetRestrictionsForRepo.Output
    /// Remove interaction restrictions for a repository
    ///
    /// Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)`.
    func interactionsRemoveRestrictionsForRepo(_ input: Operations.InteractionsRemoveRestrictionsForRepo.Input) async throws -> Operations.InteractionsRemoveRestrictionsForRepo.Output
    /// Get interaction restrictions for your public repositories
    ///
    /// Shows which type of GitHub user can interact with your public repositories and when the restriction expires.
    ///
    /// - Remark: HTTP `GET /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)`.
    func interactionsGetRestrictionsForAuthenticatedUser(_ input: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Input) async throws -> Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output
    /// Set interaction restrictions for your public repositories
    ///
    /// Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
    ///
    /// - Remark: HTTP `PUT /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/put(interactions/set-restrictions-for-authenticated-user)`.
    func interactionsSetRestrictionsForAuthenticatedUser(_ input: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input) async throws -> Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output
    /// Remove interaction restrictions from your public repositories
    ///
    /// Removes any interaction restrictions from your public repositories.
    ///
    /// - Remark: HTTP `DELETE /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/delete(interactions/remove-restrictions-for-authenticated-user)`.
    func interactionsRemoveRestrictionsForAuthenticatedUser(_ input: Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Input) async throws -> Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Get interaction restrictions for an organization
    ///
    /// Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/get(interactions/get-restrictions-for-org)`.
    public func interactionsGetRestrictionsForOrg(
        path: Operations.InteractionsGetRestrictionsForOrg.Input.Path,
        headers: Operations.InteractionsGetRestrictionsForOrg.Input.Headers = .init()
    ) async throws -> Operations.InteractionsGetRestrictionsForOrg.Output {
        try await interactionsGetRestrictionsForOrg(Operations.InteractionsGetRestrictionsForOrg.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set interaction restrictions for an organization
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/put(interactions/set-restrictions-for-org)`.
    public func interactionsSetRestrictionsForOrg(
        path: Operations.InteractionsSetRestrictionsForOrg.Input.Path,
        headers: Operations.InteractionsSetRestrictionsForOrg.Input.Headers = .init(),
        body: Operations.InteractionsSetRestrictionsForOrg.Input.Body
    ) async throws -> Operations.InteractionsSetRestrictionsForOrg.Output {
        try await interactionsSetRestrictionsForOrg(Operations.InteractionsSetRestrictionsForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove interaction restrictions for an organization
    ///
    /// Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/delete(interactions/remove-restrictions-for-org)`.
    public func interactionsRemoveRestrictionsForOrg(path: Operations.InteractionsRemoveRestrictionsForOrg.Input.Path) async throws -> Operations.InteractionsRemoveRestrictionsForOrg.Output {
        try await interactionsRemoveRestrictionsForOrg(Operations.InteractionsRemoveRestrictionsForOrg.Input(path: path))
    }
    /// Get interaction restrictions for a repository
    ///
    /// Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/get(interactions/get-restrictions-for-repo)`.
    public func interactionsGetRestrictionsForRepo(
        path: Operations.InteractionsGetRestrictionsForRepo.Input.Path,
        headers: Operations.InteractionsGetRestrictionsForRepo.Input.Headers = .init()
    ) async throws -> Operations.InteractionsGetRestrictionsForRepo.Output {
        try await interactionsGetRestrictionsForRepo(Operations.InteractionsGetRestrictionsForRepo.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set interaction restrictions for a repository
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)`.
    public func interactionsSetRestrictionsForRepo(
        path: Operations.InteractionsSetRestrictionsForRepo.Input.Path,
        headers: Operations.InteractionsSetRestrictionsForRepo.Input.Headers = .init(),
        body: Operations.InteractionsSetRestrictionsForRepo.Input.Body
    ) async throws -> Operations.InteractionsSetRestrictionsForRepo.Output {
        try await interactionsSetRestrictionsForRepo(Operations.InteractionsSetRestrictionsForRepo.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove interaction restrictions for a repository
    ///
    /// Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)`.
    public func interactionsRemoveRestrictionsForRepo(path: Operations.InteractionsRemoveRestrictionsForRepo.Input.Path) async throws -> Operations.InteractionsRemoveRestrictionsForRepo.Output {
        try await interactionsRemoveRestrictionsForRepo(Operations.InteractionsRemoveRestrictionsForRepo.Input(path: path))
    }
    /// Get interaction restrictions for your public repositories
    ///
    /// Shows which type of GitHub user can interact with your public repositories and when the restriction expires.
    ///
    /// - Remark: HTTP `GET /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)`.
    public func interactionsGetRestrictionsForAuthenticatedUser(headers: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Input.Headers = .init()) async throws -> Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output {
        try await interactionsGetRestrictionsForAuthenticatedUser(Operations.InteractionsGetRestrictionsForAuthenticatedUser.Input(headers: headers))
    }
    /// Set interaction restrictions for your public repositories
    ///
    /// Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
    ///
    /// - Remark: HTTP `PUT /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/put(interactions/set-restrictions-for-authenticated-user)`.
    public func interactionsSetRestrictionsForAuthenticatedUser(
        headers: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Body
    ) async throws -> Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output {
        try await interactionsSetRestrictionsForAuthenticatedUser(Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// Remove interaction restrictions from your public repositories
    ///
    /// Removes any interaction restrictions from your public repositories.
    ///
    /// - Remark: HTTP `DELETE /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/delete(interactions/remove-restrictions-for-authenticated-user)`.
    public func interactionsRemoveRestrictionsForAuthenticatedUser() async throws -> Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Output {
        try await interactionsRemoveRestrictionsForAuthenticatedUser(Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Input())
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.
        ///
        /// - Remark: Generated from `#/components/schemas/interaction-group`.
        @frozen public enum InteractionGroup: String, Codable, Hashable, Sendable, CaseIterable {
            case existingUsers = "existing_users"
            case contributorsOnly = "contributors_only"
            case collaboratorsOnly = "collaborators_only"
        }
        /// Interaction limit settings.
        ///
        /// - Remark: Generated from `#/components/schemas/interaction-limit-response`.
        public struct InteractionLimitResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/interaction-limit-response/limit`.
            public var limit: Components.Schemas.InteractionGroup
            /// - Remark: Generated from `#/components/schemas/interaction-limit-response/origin`.
            public var origin: Swift.String
            /// - Remark: Generated from `#/components/schemas/interaction-limit-response/expires_at`.
            public var expiresAt: Foundation.Date
            /// Creates a new `InteractionLimitResponse`.
            ///
            /// - Parameters:
            ///   - limit:
            ///   - origin:
            ///   - expiresAt:
            public init(
                limit: Components.Schemas.InteractionGroup,
                origin: Swift.String,
                expiresAt: Foundation.Date
            ) {
                self.limit = limit
                self.origin = origin
                self.expiresAt = expiresAt
            }
            public enum CodingKeys: String, CodingKey {
                case limit
                case origin
                case expiresAt = "expires_at"
            }
        }
        /// The duration of the interaction restriction. Default: `one_day`.
        ///
        /// - Remark: Generated from `#/components/schemas/interaction-expiry`.
        @frozen public enum InteractionExpiry: String, Codable, Hashable, Sendable, CaseIterable {
            case oneDay = "one_day"
            case threeDays = "three_days"
            case oneWeek = "one_week"
            case oneMonth = "one_month"
            case sixMonths = "six_months"
        }
        /// Limit interactions to a specific type of user for a specified duration
        ///
        /// - Remark: Generated from `#/components/schemas/interaction-limit`.
        public struct InteractionLimit: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/interaction-limit/limit`.
            public var limit: Components.Schemas.InteractionGroup
            /// - Remark: Generated from `#/components/schemas/interaction-limit/expiry`.
            public var expiry: Components.Schemas.InteractionExpiry?
            /// Creates a new `InteractionLimit`.
            ///
            /// - Parameters:
            ///   - limit:
            ///   - expiry:
            public init(
                limit: Components.Schemas.InteractionGroup,
                expiry: Components.Schemas.InteractionExpiry? = nil
            ) {
                self.limit = limit
                self.expiry = expiry
            }
            public enum CodingKeys: String, CodingKey {
                case limit
                case expiry
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Get interaction restrictions for an organization
    ///
    /// Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/get(interactions/get-restrictions-for-org)`.
    public enum InteractionsGetRestrictionsForOrg {
        public static let id: Swift.String = "interactions/get-restrictions-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.InteractionsGetRestrictionsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsGetRestrictionsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.InteractionsGetRestrictionsForOrg.Input.Path,
                headers: Operations.InteractionsGetRestrictionsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content/json/value1`.
                        public var value1: Components.Schemas.InteractionLimitResponse?
                        /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content/json/value2`.
                        public struct Value2Payload: Codable, Hashable, Sendable {
                            /// Creates a new `Value2Payload`.
                            public init() {}
                            public init(from decoder: any Decoder) throws {
                                try decoder.ensureNoAdditionalProperties(knownKeys: [])
                            }
                        }
                        /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content/json/value2`.
                        public var value2: Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body.JsonPayload.Value2Payload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: Components.Schemas.InteractionLimitResponse? = nil,
                            value2: Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body.JsonPayload.Value2Payload? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try self.value1?.encode(to: encoder)
                            try self.value2?.encode(to: encoder)
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/GET/responses/200/content/application\/json`.
                    case json(Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsGetRestrictionsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/get(interactions/get-restrictions-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsGetRestrictionsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsGetRestrictionsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set interaction restrictions for an organization
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/put(interactions/set-restrictions-for-org)`.
    public enum InteractionsSetRestrictionsForOrg {
        public static let id: Swift.String = "interactions/set-restrictions-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.InteractionsSetRestrictionsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsSetRestrictionsForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.InteractionLimit)
            }
            public var body: Operations.InteractionsSetRestrictionsForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.InteractionsSetRestrictionsForOrg.Input.Path,
                headers: Operations.InteractionsSetRestrictionsForOrg.Input.Headers = .init(),
                body: Operations.InteractionsSetRestrictionsForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.InteractionLimitResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.InteractionLimitResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsSetRestrictionsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsSetRestrictionsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/put(interactions/set-restrictions-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsSetRestrictionsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsSetRestrictionsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/put(interactions/set-restrictions-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove interaction restrictions for an organization
    ///
    /// Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/interaction-limits`.
    /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/delete(interactions/remove-restrictions-for-org)`.
    public enum InteractionsRemoveRestrictionsForOrg {
        public static let id: Swift.String = "interactions/remove-restrictions-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/interaction-limits/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.InteractionsRemoveRestrictionsForOrg.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.InteractionsRemoveRestrictionsForOrg.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/delete(interactions/remove-restrictions-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.InteractionsRemoveRestrictionsForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/interaction-limits/delete(interactions/remove-restrictions-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.InteractionsRemoveRestrictionsForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get interaction restrictions for a repository
    ///
    /// Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/get(interactions/get-restrictions-for-repo)`.
    public enum InteractionsGetRestrictionsForRepo {
        public static let id: Swift.String = "interactions/get-restrictions-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.InteractionsGetRestrictionsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsGetRestrictionsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.InteractionsGetRestrictionsForRepo.Input.Path,
                headers: Operations.InteractionsGetRestrictionsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content/json/value1`.
                        public var value1: Components.Schemas.InteractionLimitResponse?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content/json/value2`.
                        public struct Value2Payload: Codable, Hashable, Sendable {
                            /// Creates a new `Value2Payload`.
                            public init() {}
                            public init(from decoder: any Decoder) throws {
                                try decoder.ensureNoAdditionalProperties(knownKeys: [])
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content/json/value2`.
                        public var value2: Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body.JsonPayload.Value2Payload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: Components.Schemas.InteractionLimitResponse? = nil,
                            value2: Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body.JsonPayload.Value2Payload? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try self.value1?.encode(to: encoder)
                            try self.value2?.encode(to: encoder)
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/GET/responses/200/content/application\/json`.
                    case json(Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsGetRestrictionsForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/get(interactions/get-restrictions-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsGetRestrictionsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsGetRestrictionsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set interaction restrictions for a repository
    ///
    /// Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)`.
    public enum InteractionsSetRestrictionsForRepo {
        public static let id: Swift.String = "interactions/set-restrictions-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.InteractionsSetRestrictionsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsSetRestrictionsForRepo.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.InteractionLimit)
            }
            public var body: Operations.InteractionsSetRestrictionsForRepo.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.InteractionsSetRestrictionsForRepo.Input.Path,
                headers: Operations.InteractionsSetRestrictionsForRepo.Input.Headers = .init(),
                body: Operations.InteractionsSetRestrictionsForRepo.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.InteractionLimitResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.InteractionLimitResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsSetRestrictionsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsSetRestrictionsForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsSetRestrictionsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsSetRestrictionsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.InteractionsSetRestrictionsForRepo.Output.Conflict)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/put(interactions/set-restrictions-for-repo)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.InteractionsSetRestrictionsForRepo.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove interaction restrictions for a repository
    ///
    /// Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/interaction-limits`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)`.
    public enum InteractionsRemoveRestrictionsForRepo {
        public static let id: Swift.String = "interactions/remove-restrictions-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/interaction-limits/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.InteractionsRemoveRestrictionsForRepo.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.InteractionsRemoveRestrictionsForRepo.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.InteractionsRemoveRestrictionsForRepo.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.InteractionsRemoveRestrictionsForRepo.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.InteractionsRemoveRestrictionsForRepo.Output.Conflict)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/interaction-limits/delete(interactions/remove-restrictions-for-repo)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.InteractionsRemoveRestrictionsForRepo.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Get interaction restrictions for your public repositories
    ///
    /// Shows which type of GitHub user can interact with your public repositories and when the restriction expires.
    ///
    /// - Remark: HTTP `GET /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)`.
    public enum InteractionsGetRestrictionsForAuthenticatedUser {
        public static let id: Swift.String = "interactions/get-restrictions-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/interaction-limits/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsGetRestrictionsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content/json/value1`.
                        public var value1: Components.Schemas.InteractionLimitResponse?
                        /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content/json/value2`.
                        public struct Value2Payload: Codable, Hashable, Sendable {
                            /// Creates a new `Value2Payload`.
                            public init() {}
                            public init(from decoder: any Decoder) throws {
                                try decoder.ensureNoAdditionalProperties(knownKeys: [])
                            }
                        }
                        /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content/json/value2`.
                        public var value2: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body.JsonPayload.Value2Payload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: Components.Schemas.InteractionLimitResponse? = nil,
                            value2: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body.JsonPayload.Value2Payload? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try .init(from: decoder)
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try self.value1?.encode(to: encoder)
                            try self.value2?.encode(to: encoder)
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/interaction-limits/GET/responses/200/content/application\/json`.
                    case json(Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Default response
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when there are no restrictions
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.NoContent)
            /// Response when there are no restrictions
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/get(interactions/get-restrictions-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.InteractionsGetRestrictionsForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set interaction restrictions for your public repositories
    ///
    /// Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
    ///
    /// - Remark: HTTP `PUT /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/put(interactions/set-restrictions-for-authenticated-user)`.
    public enum InteractionsSetRestrictionsForAuthenticatedUser {
        public static let id: Swift.String = "interactions/set-restrictions-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/interaction-limits/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.InteractionsSetRestrictionsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/interaction-limits/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/interaction-limits/PUT/requestBody/content/application\/json`.
                case json(Components.Schemas.InteractionLimit)
            }
            public var body: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/interaction-limits/PUT/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/interaction-limits/PUT/responses/200/content/application\/json`.
                    case json(Components.Schemas.InteractionLimitResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.InteractionLimitResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/put(interactions/set-restrictions-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.InteractionsSetRestrictionsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/put(interactions/set-restrictions-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove interaction restrictions from your public repositories
    ///
    /// Removes any interaction restrictions from your public repositories.
    ///
    /// - Remark: HTTP `DELETE /user/interaction-limits`.
    /// - Remark: Generated from `#/paths//user/interaction-limits/delete(interactions/remove-restrictions-for-authenticated-user)`.
    public enum InteractionsRemoveRestrictionsForAuthenticatedUser {
        public static let id: Swift.String = "interactions/remove-restrictions-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// Creates a new `Input`.
            public init() {}
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/delete(interactions/remove-restrictions-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/interaction-limits/delete(interactions/remove-restrictions-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.InteractionsRemoveRestrictionsForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
}
