// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List Dependabot alerts for an enterprise
    ///
    /// Lists Dependabot alerts for repositories that are owned by the specified enterprise.
    ///
    /// The authenticated user must be a member of the enterprise to use this endpoint.
    ///
    /// Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)`.
    func dependabotListAlertsForEnterprise(_ input: Operations.DependabotListAlertsForEnterprise.Input) async throws -> Operations.DependabotListAlertsForEnterprise.Output
    /// Lists the repositories Dependabot can access in an organization
    ///
    /// Lists repositories that organization admins have allowed Dependabot to access when updating dependencies.
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// - Remark: HTTP `GET /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)`.
    func dependabotRepositoryAccessForOrg(_ input: Operations.DependabotRepositoryAccessForOrg.Input) async throws -> Operations.DependabotRepositoryAccessForOrg.Output
    /// Updates Dependabot's repository access list for an organization
    ///
    /// Updates repositories according to the list of repositories that organization admins have given Dependabot access to when they've updated dependencies.
    ///
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// **Example request body:**
    /// ```json
    /// {
    ///   "repository_ids_to_add": [123, 456],
    ///   "repository_ids_to_remove": [789]
    /// }
    /// ```
    ///
    /// - Remark: HTTP `PATCH /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)`.
    func dependabotUpdateRepositoryAccessForOrg(_ input: Operations.DependabotUpdateRepositoryAccessForOrg.Input) async throws -> Operations.DependabotUpdateRepositoryAccessForOrg.Output
    /// Set the default repository access level for Dependabot
    ///
    /// Sets the default level of repository access Dependabot will have while performing an update.  Available values are:
    /// - 'public' - Dependabot will only have access to public repositories, unless access is explicitly granted to non-public repositories.
    /// - 'internal' - Dependabot will only have access to public and internal repositories, unless access is explicitly granted to private repositories.
    ///
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// This operation supports both server-to-server and user-to-server access.
    ///
    /// - Remark: HTTP `PUT /organizations/{org}/dependabot/repository-access/default-level`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)`.
    func dependabotSetRepositoryAccessDefaultLevel(_ input: Operations.DependabotSetRepositoryAccessDefaultLevel.Input) async throws -> Operations.DependabotSetRepositoryAccessDefaultLevel.Output
    /// List Dependabot alerts for an organization
    ///
    /// Lists Dependabot alerts for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)`.
    func dependabotListAlertsForOrg(_ input: Operations.DependabotListAlertsForOrg.Input) async throws -> Operations.DependabotListAlertsForOrg.Output
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/get(dependabot/list-org-secrets)`.
    func dependabotListOrgSecrets(_ input: Operations.DependabotListOrgSecrets.Input) async throws -> Operations.DependabotListOrgSecrets.Output
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/public-key/get(dependabot/get-org-public-key)`.
    func dependabotGetOrgPublicKey(_ input: Operations.DependabotGetOrgPublicKey.Input) async throws -> Operations.DependabotGetOrgPublicKey.Output
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/get(dependabot/get-org-secret)`.
    func dependabotGetOrgSecret(_ input: Operations.DependabotGetOrgSecret.Input) async throws -> Operations.DependabotGetOrgSecret.Output
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)`.
    func dependabotCreateOrUpdateOrgSecret(_ input: Operations.DependabotCreateOrUpdateOrgSecret.Input) async throws -> Operations.DependabotCreateOrUpdateOrgSecret.Output
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/delete(dependabot/delete-org-secret)`.
    func dependabotDeleteOrgSecret(_ input: Operations.DependabotDeleteOrgSecret.Input) async throws -> Operations.DependabotDeleteOrgSecret.Output
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/get(dependabot/list-selected-repos-for-org-secret)`.
    func dependabotListSelectedReposForOrgSecret(_ input: Operations.DependabotListSelectedReposForOrgSecret.Input) async throws -> Operations.DependabotListSelectedReposForOrgSecret.Output
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/put(dependabot/set-selected-repos-for-org-secret)`.
    func dependabotSetSelectedReposForOrgSecret(_ input: Operations.DependabotSetSelectedReposForOrgSecret.Input) async throws -> Operations.DependabotSetSelectedReposForOrgSecret.Output
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. The visibility is set when you [Create or
    /// update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)`.
    func dependabotAddSelectedRepoToOrgSecret(_ input: Operations.DependabotAddSelectedRepoToOrgSecret.Input) async throws -> Operations.DependabotAddSelectedRepoToOrgSecret.Output
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)`.
    func dependabotRemoveSelectedRepoFromOrgSecret(_ input: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Input) async throws -> Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output
    /// List Dependabot alerts for a repository
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)`.
    func dependabotListAlertsForRepo(_ input: Operations.DependabotListAlertsForRepo.Input) async throws -> Operations.DependabotListAlertsForRepo.Output
    /// Get a Dependabot alert
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)`.
    func dependabotGetAlert(_ input: Operations.DependabotGetAlert.Input) async throws -> Operations.DependabotGetAlert.Output
    /// Update a Dependabot alert
    ///
    /// The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)`.
    func dependabotUpdateAlert(_ input: Operations.DependabotUpdateAlert.Input) async throws -> Operations.DependabotUpdateAlert.Output
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/get(dependabot/list-repo-secrets)`.
    func dependabotListRepoSecrets(_ input: Operations.DependabotListRepoSecrets.Input) async throws -> Operations.DependabotListRepoSecrets.Output
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets. Anyone with read access
    /// to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/public-key/get(dependabot/get-repo-public-key)`.
    func dependabotGetRepoPublicKey(_ input: Operations.DependabotGetRepoPublicKey.Input) async throws -> Operations.DependabotGetRepoPublicKey.Output
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/get(dependabot/get-repo-secret)`.
    func dependabotGetRepoSecret(_ input: Operations.DependabotGetRepoSecret.Input) async throws -> Operations.DependabotGetRepoSecret.Output
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)`.
    func dependabotCreateOrUpdateRepoSecret(_ input: Operations.DependabotCreateOrUpdateRepoSecret.Input) async throws -> Operations.DependabotCreateOrUpdateRepoSecret.Output
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/delete(dependabot/delete-repo-secret)`.
    func dependabotDeleteRepoSecret(_ input: Operations.DependabotDeleteRepoSecret.Input) async throws -> Operations.DependabotDeleteRepoSecret.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List Dependabot alerts for an enterprise
    ///
    /// Lists Dependabot alerts for repositories that are owned by the specified enterprise.
    ///
    /// The authenticated user must be a member of the enterprise to use this endpoint.
    ///
    /// Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)`.
    public func dependabotListAlertsForEnterprise(
        path: Operations.DependabotListAlertsForEnterprise.Input.Path,
        query: Operations.DependabotListAlertsForEnterprise.Input.Query = .init(),
        headers: Operations.DependabotListAlertsForEnterprise.Input.Headers = .init()
    ) async throws -> Operations.DependabotListAlertsForEnterprise.Output {
        try await dependabotListAlertsForEnterprise(Operations.DependabotListAlertsForEnterprise.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Lists the repositories Dependabot can access in an organization
    ///
    /// Lists repositories that organization admins have allowed Dependabot to access when updating dependencies.
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// - Remark: HTTP `GET /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)`.
    public func dependabotRepositoryAccessForOrg(
        path: Operations.DependabotRepositoryAccessForOrg.Input.Path,
        query: Operations.DependabotRepositoryAccessForOrg.Input.Query = .init(),
        headers: Operations.DependabotRepositoryAccessForOrg.Input.Headers = .init()
    ) async throws -> Operations.DependabotRepositoryAccessForOrg.Output {
        try await dependabotRepositoryAccessForOrg(Operations.DependabotRepositoryAccessForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Updates Dependabot's repository access list for an organization
    ///
    /// Updates repositories according to the list of repositories that organization admins have given Dependabot access to when they've updated dependencies.
    ///
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// **Example request body:**
    /// ```json
    /// {
    ///   "repository_ids_to_add": [123, 456],
    ///   "repository_ids_to_remove": [789]
    /// }
    /// ```
    ///
    /// - Remark: HTTP `PATCH /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)`.
    public func dependabotUpdateRepositoryAccessForOrg(
        path: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Path,
        headers: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Headers = .init(),
        body: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Body
    ) async throws -> Operations.DependabotUpdateRepositoryAccessForOrg.Output {
        try await dependabotUpdateRepositoryAccessForOrg(Operations.DependabotUpdateRepositoryAccessForOrg.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Set the default repository access level for Dependabot
    ///
    /// Sets the default level of repository access Dependabot will have while performing an update.  Available values are:
    /// - 'public' - Dependabot will only have access to public repositories, unless access is explicitly granted to non-public repositories.
    /// - 'internal' - Dependabot will only have access to public and internal repositories, unless access is explicitly granted to private repositories.
    ///
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// This operation supports both server-to-server and user-to-server access.
    ///
    /// - Remark: HTTP `PUT /organizations/{org}/dependabot/repository-access/default-level`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)`.
    public func dependabotSetRepositoryAccessDefaultLevel(
        path: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Path,
        headers: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Headers = .init(),
        body: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body
    ) async throws -> Operations.DependabotSetRepositoryAccessDefaultLevel.Output {
        try await dependabotSetRepositoryAccessDefaultLevel(Operations.DependabotSetRepositoryAccessDefaultLevel.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List Dependabot alerts for an organization
    ///
    /// Lists Dependabot alerts for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)`.
    public func dependabotListAlertsForOrg(
        path: Operations.DependabotListAlertsForOrg.Input.Path,
        query: Operations.DependabotListAlertsForOrg.Input.Query = .init(),
        headers: Operations.DependabotListAlertsForOrg.Input.Headers = .init()
    ) async throws -> Operations.DependabotListAlertsForOrg.Output {
        try await dependabotListAlertsForOrg(Operations.DependabotListAlertsForOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/get(dependabot/list-org-secrets)`.
    public func dependabotListOrgSecrets(
        path: Operations.DependabotListOrgSecrets.Input.Path,
        query: Operations.DependabotListOrgSecrets.Input.Query = .init(),
        headers: Operations.DependabotListOrgSecrets.Input.Headers = .init()
    ) async throws -> Operations.DependabotListOrgSecrets.Output {
        try await dependabotListOrgSecrets(Operations.DependabotListOrgSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/public-key/get(dependabot/get-org-public-key)`.
    public func dependabotGetOrgPublicKey(
        path: Operations.DependabotGetOrgPublicKey.Input.Path,
        headers: Operations.DependabotGetOrgPublicKey.Input.Headers = .init()
    ) async throws -> Operations.DependabotGetOrgPublicKey.Output {
        try await dependabotGetOrgPublicKey(Operations.DependabotGetOrgPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/get(dependabot/get-org-secret)`.
    public func dependabotGetOrgSecret(
        path: Operations.DependabotGetOrgSecret.Input.Path,
        headers: Operations.DependabotGetOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.DependabotGetOrgSecret.Output {
        try await dependabotGetOrgSecret(Operations.DependabotGetOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)`.
    public func dependabotCreateOrUpdateOrgSecret(
        path: Operations.DependabotCreateOrUpdateOrgSecret.Input.Path,
        headers: Operations.DependabotCreateOrUpdateOrgSecret.Input.Headers = .init(),
        body: Operations.DependabotCreateOrUpdateOrgSecret.Input.Body
    ) async throws -> Operations.DependabotCreateOrUpdateOrgSecret.Output {
        try await dependabotCreateOrUpdateOrgSecret(Operations.DependabotCreateOrUpdateOrgSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/delete(dependabot/delete-org-secret)`.
    public func dependabotDeleteOrgSecret(path: Operations.DependabotDeleteOrgSecret.Input.Path) async throws -> Operations.DependabotDeleteOrgSecret.Output {
        try await dependabotDeleteOrgSecret(Operations.DependabotDeleteOrgSecret.Input(path: path))
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/get(dependabot/list-selected-repos-for-org-secret)`.
    public func dependabotListSelectedReposForOrgSecret(
        path: Operations.DependabotListSelectedReposForOrgSecret.Input.Path,
        query: Operations.DependabotListSelectedReposForOrgSecret.Input.Query = .init(),
        headers: Operations.DependabotListSelectedReposForOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.DependabotListSelectedReposForOrgSecret.Output {
        try await dependabotListSelectedReposForOrgSecret(Operations.DependabotListSelectedReposForOrgSecret.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/put(dependabot/set-selected-repos-for-org-secret)`.
    public func dependabotSetSelectedReposForOrgSecret(
        path: Operations.DependabotSetSelectedReposForOrgSecret.Input.Path,
        body: Operations.DependabotSetSelectedReposForOrgSecret.Input.Body
    ) async throws -> Operations.DependabotSetSelectedReposForOrgSecret.Output {
        try await dependabotSetSelectedReposForOrgSecret(Operations.DependabotSetSelectedReposForOrgSecret.Input(
            path: path,
            body: body
        ))
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. The visibility is set when you [Create or
    /// update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)`.
    public func dependabotAddSelectedRepoToOrgSecret(path: Operations.DependabotAddSelectedRepoToOrgSecret.Input.Path) async throws -> Operations.DependabotAddSelectedRepoToOrgSecret.Output {
        try await dependabotAddSelectedRepoToOrgSecret(Operations.DependabotAddSelectedRepoToOrgSecret.Input(path: path))
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)`.
    public func dependabotRemoveSelectedRepoFromOrgSecret(path: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Input.Path) async throws -> Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output {
        try await dependabotRemoveSelectedRepoFromOrgSecret(Operations.DependabotRemoveSelectedRepoFromOrgSecret.Input(path: path))
    }
    /// List Dependabot alerts for a repository
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)`.
    public func dependabotListAlertsForRepo(
        path: Operations.DependabotListAlertsForRepo.Input.Path,
        query: Operations.DependabotListAlertsForRepo.Input.Query = .init(),
        headers: Operations.DependabotListAlertsForRepo.Input.Headers = .init()
    ) async throws -> Operations.DependabotListAlertsForRepo.Output {
        try await dependabotListAlertsForRepo(Operations.DependabotListAlertsForRepo.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a Dependabot alert
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)`.
    public func dependabotGetAlert(
        path: Operations.DependabotGetAlert.Input.Path,
        headers: Operations.DependabotGetAlert.Input.Headers = .init()
    ) async throws -> Operations.DependabotGetAlert.Output {
        try await dependabotGetAlert(Operations.DependabotGetAlert.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a Dependabot alert
    ///
    /// The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)`.
    public func dependabotUpdateAlert(
        path: Operations.DependabotUpdateAlert.Input.Path,
        headers: Operations.DependabotUpdateAlert.Input.Headers = .init(),
        body: Operations.DependabotUpdateAlert.Input.Body
    ) async throws -> Operations.DependabotUpdateAlert.Output {
        try await dependabotUpdateAlert(Operations.DependabotUpdateAlert.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/get(dependabot/list-repo-secrets)`.
    public func dependabotListRepoSecrets(
        path: Operations.DependabotListRepoSecrets.Input.Path,
        query: Operations.DependabotListRepoSecrets.Input.Query = .init(),
        headers: Operations.DependabotListRepoSecrets.Input.Headers = .init()
    ) async throws -> Operations.DependabotListRepoSecrets.Output {
        try await dependabotListRepoSecrets(Operations.DependabotListRepoSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets. Anyone with read access
    /// to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/public-key/get(dependabot/get-repo-public-key)`.
    public func dependabotGetRepoPublicKey(
        path: Operations.DependabotGetRepoPublicKey.Input.Path,
        headers: Operations.DependabotGetRepoPublicKey.Input.Headers = .init()
    ) async throws -> Operations.DependabotGetRepoPublicKey.Output {
        try await dependabotGetRepoPublicKey(Operations.DependabotGetRepoPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/get(dependabot/get-repo-secret)`.
    public func dependabotGetRepoSecret(
        path: Operations.DependabotGetRepoSecret.Input.Path,
        headers: Operations.DependabotGetRepoSecret.Input.Headers = .init()
    ) async throws -> Operations.DependabotGetRepoSecret.Output {
        try await dependabotGetRepoSecret(Operations.DependabotGetRepoSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)`.
    public func dependabotCreateOrUpdateRepoSecret(
        path: Operations.DependabotCreateOrUpdateRepoSecret.Input.Path,
        headers: Operations.DependabotCreateOrUpdateRepoSecret.Input.Headers = .init(),
        body: Operations.DependabotCreateOrUpdateRepoSecret.Input.Body
    ) async throws -> Operations.DependabotCreateOrUpdateRepoSecret.Output {
        try await dependabotCreateOrUpdateRepoSecret(Operations.DependabotCreateOrUpdateRepoSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/delete(dependabot/delete-repo-secret)`.
    public func dependabotDeleteRepoSecret(path: Operations.DependabotDeleteRepoSecret.Input.Path) async throws -> Operations.DependabotDeleteRepoSecret.Output {
        try await dependabotDeleteRepoSecret(Operations.DependabotDeleteRepoSecret.Input(path: path))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// - Remark: Generated from `#/components/schemas/cvss-severities`.
        public struct CvssSeverities: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3`.
            public struct CvssV3Payload: Codable, Hashable, Sendable {
                /// The CVSS 3 vector string.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS 3 score.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssV3Payload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS 3 vector string.
                ///   - score: The CVSS 3 score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v3`.
            public var cvssV3: Components.Schemas.CvssSeverities.CvssV3Payload?
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4`.
            public struct CvssV4Payload: Codable, Hashable, Sendable {
                /// The CVSS 4 vector string.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4/vector_string`.
                public var vectorString: Swift.String?
                /// The CVSS 4 score.
                ///
                /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4/score`.
                public var score: Swift.Double?
                /// Creates a new `CvssV4Payload`.
                ///
                /// - Parameters:
                ///   - vectorString: The CVSS 4 vector string.
                ///   - score: The CVSS 4 score.
                public init(
                    vectorString: Swift.String? = nil,
                    score: Swift.Double? = nil
                ) {
                    self.vectorString = vectorString
                    self.score = score
                }
                public enum CodingKeys: String, CodingKey {
                    case vectorString = "vector_string"
                    case score
                }
            }
            /// - Remark: Generated from `#/components/schemas/cvss-severities/cvss_v4`.
            public var cvssV4: Components.Schemas.CvssSeverities.CvssV4Payload?
            /// Creates a new `CvssSeverities`.
            ///
            /// - Parameters:
            ///   - cvssV3:
            ///   - cvssV4:
            public init(
                cvssV3: Components.Schemas.CvssSeverities.CvssV3Payload? = nil,
                cvssV4: Components.Schemas.CvssSeverities.CvssV4Payload? = nil
            ) {
                self.cvssV3 = cvssV3
                self.cvssV4 = cvssV4
            }
            public enum CodingKeys: String, CodingKey {
                case cvssV3 = "cvss_v3"
                case cvssV4 = "cvss_v4"
            }
        }
        /// The EPSS scores as calculated by the [Exploit Prediction Scoring System](https://www.first.org/epss).
        ///
        /// - Remark: Generated from `#/components/schemas/security-advisory-epss`.
        public struct SecurityAdvisoryEpss: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/security-advisory-epss/percentage`.
            public var percentage: Swift.Double?
            /// - Remark: Generated from `#/components/schemas/security-advisory-epss/percentile`.
            public var percentile: Swift.Double?
            /// Creates a new `SecurityAdvisoryEpss`.
            ///
            /// - Parameters:
            ///   - percentage:
            ///   - percentile:
            public init(
                percentage: Swift.Double? = nil,
                percentile: Swift.Double? = nil
            ) {
                self.percentage = percentage
                self.percentile = percentile
            }
            public enum CodingKeys: String, CodingKey {
                case percentage
                case percentile
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Validation Error Simple
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error-simple`.
        public struct ValidationErrorSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error-simple/errors`.
            public var errors: [Swift.String]?
            /// Creates a new `ValidationErrorSimple`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-repository`.
        public struct SimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `SimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// The security alert number.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-number`.
        public typealias AlertNumber = Swift.Int
        /// Details for the vulnerable package.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-alert-package`.
        public struct DependabotAlertPackage: Codable, Hashable, Sendable {
            /// The package's language or package management ecosystem.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-package/ecosystem`.
            public var ecosystem: Swift.String
            /// The unique package name within its ecosystem.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-package/name`.
            public var name: Swift.String
            /// Creates a new `DependabotAlertPackage`.
            ///
            /// - Parameters:
            ///   - ecosystem: The package's language or package management ecosystem.
            ///   - name: The unique package name within its ecosystem.
            public init(
                ecosystem: Swift.String,
                name: Swift.String
            ) {
                self.ecosystem = ecosystem
                self.name = name
            }
            public enum CodingKeys: String, CodingKey {
                case ecosystem
                case name
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.ecosystem = try container.decode(
                    Swift.String.self,
                    forKey: .ecosystem
                )
                self.name = try container.decode(
                    Swift.String.self,
                    forKey: .name
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "ecosystem",
                    "name"
                ])
            }
        }
        /// Details pertaining to one vulnerable version range for the advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability`.
        public struct DependabotAlertSecurityVulnerability: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/package`.
            public var package: Components.Schemas.DependabotAlertPackage
            /// The severity of the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case low = "low"
                case medium = "medium"
                case high = "high"
                case critical = "critical"
            }
            /// The severity of the vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/severity`.
            public var severity: Components.Schemas.DependabotAlertSecurityVulnerability.SeverityPayload
            /// Conditions that identify vulnerable versions of this vulnerability's package.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/vulnerable_version_range`.
            public var vulnerableVersionRange: Swift.String
            /// Details pertaining to the package version that patches this vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/first_patched_version`.
            public struct FirstPatchedVersionPayload: Codable, Hashable, Sendable {
                /// The package version that patches this vulnerability.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/first_patched_version/identifier`.
                public var identifier: Swift.String
                /// Creates a new `FirstPatchedVersionPayload`.
                ///
                /// - Parameters:
                ///   - identifier: The package version that patches this vulnerability.
                public init(identifier: Swift.String) {
                    self.identifier = identifier
                }
                public enum CodingKeys: String, CodingKey {
                    case identifier
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.identifier = try container.decode(
                        Swift.String.self,
                        forKey: .identifier
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "identifier"
                    ])
                }
            }
            /// Details pertaining to the package version that patches this vulnerability.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-vulnerability/first_patched_version`.
            public var firstPatchedVersion: Components.Schemas.DependabotAlertSecurityVulnerability.FirstPatchedVersionPayload?
            /// Creates a new `DependabotAlertSecurityVulnerability`.
            ///
            /// - Parameters:
            ///   - package:
            ///   - severity: The severity of the vulnerability.
            ///   - vulnerableVersionRange: Conditions that identify vulnerable versions of this vulnerability's package.
            ///   - firstPatchedVersion: Details pertaining to the package version that patches this vulnerability.
            public init(
                package: Components.Schemas.DependabotAlertPackage,
                severity: Components.Schemas.DependabotAlertSecurityVulnerability.SeverityPayload,
                vulnerableVersionRange: Swift.String,
                firstPatchedVersion: Components.Schemas.DependabotAlertSecurityVulnerability.FirstPatchedVersionPayload? = nil
            ) {
                self.package = package
                self.severity = severity
                self.vulnerableVersionRange = vulnerableVersionRange
                self.firstPatchedVersion = firstPatchedVersion
            }
            public enum CodingKeys: String, CodingKey {
                case package
                case severity
                case vulnerableVersionRange = "vulnerable_version_range"
                case firstPatchedVersion = "first_patched_version"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.package = try container.decode(
                    Components.Schemas.DependabotAlertPackage.self,
                    forKey: .package
                )
                self.severity = try container.decode(
                    Components.Schemas.DependabotAlertSecurityVulnerability.SeverityPayload.self,
                    forKey: .severity
                )
                self.vulnerableVersionRange = try container.decode(
                    Swift.String.self,
                    forKey: .vulnerableVersionRange
                )
                self.firstPatchedVersion = try container.decodeIfPresent(
                    Components.Schemas.DependabotAlertSecurityVulnerability.FirstPatchedVersionPayload.self,
                    forKey: .firstPatchedVersion
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "package",
                    "severity",
                    "vulnerable_version_range",
                    "first_patched_version"
                ])
            }
        }
        /// Details for the GitHub Security Advisory.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory`.
        public struct DependabotAlertSecurityAdvisory: Codable, Hashable, Sendable {
            /// The unique GitHub Security Advisory ID assigned to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/ghsa_id`.
            public var ghsaId: Swift.String
            /// The unique CVE ID assigned to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cve_id`.
            public var cveId: Swift.String?
            /// A short, plain text summary of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/summary`.
            public var summary: Swift.String
            /// A long-form Markdown-supported description of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/description`.
            public var description: Swift.String
            /// Vulnerable version range information for the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/vulnerabilities`.
            public var vulnerabilities: [Components.Schemas.DependabotAlertSecurityVulnerability]
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/severity`.
            @frozen public enum SeverityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case low = "low"
                case medium = "medium"
                case high = "high"
                case critical = "critical"
            }
            /// The severity of the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/severity`.
            public var severity: Components.Schemas.DependabotAlertSecurityAdvisory.SeverityPayload
            /// Details for the advisory pertaining to the Common Vulnerability Scoring System.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cvss`.
            public struct CvssPayload: Codable, Hashable, Sendable {
                /// The overall CVSS score of the advisory.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cvss/score`.
                public var score: Swift.Double
                /// The full CVSS vector string for the advisory.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cvss/vector_string`.
                public var vectorString: Swift.String?
                /// Creates a new `CvssPayload`.
                ///
                /// - Parameters:
                ///   - score: The overall CVSS score of the advisory.
                ///   - vectorString: The full CVSS vector string for the advisory.
                public init(
                    score: Swift.Double,
                    vectorString: Swift.String? = nil
                ) {
                    self.score = score
                    self.vectorString = vectorString
                }
                public enum CodingKeys: String, CodingKey {
                    case score
                    case vectorString = "vector_string"
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.score = try container.decode(
                        Swift.Double.self,
                        forKey: .score
                    )
                    self.vectorString = try container.decodeIfPresent(
                        Swift.String.self,
                        forKey: .vectorString
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "score",
                        "vector_string"
                    ])
                }
            }
            /// Details for the advisory pertaining to the Common Vulnerability Scoring System.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cvss`.
            public var cvss: Components.Schemas.DependabotAlertSecurityAdvisory.CvssPayload
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cvss_severities`.
            public var cvssSeverities: Components.Schemas.CvssSeverities?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/epss`.
            public var epss: Components.Schemas.SecurityAdvisoryEpss?
            /// A CWE weakness assigned to the advisory.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/CwesPayload`.
            public struct CwesPayloadPayload: Codable, Hashable, Sendable {
                /// The unique CWE ID.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/CwesPayload/cwe_id`.
                public var cweId: Swift.String
                /// The short, plain text name of the CWE.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/CwesPayload/name`.
                public var name: Swift.String
                /// Creates a new `CwesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - cweId: The unique CWE ID.
                ///   - name: The short, plain text name of the CWE.
                public init(
                    cweId: Swift.String,
                    name: Swift.String
                ) {
                    self.cweId = cweId
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case cweId = "cwe_id"
                    case name
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.cweId = try container.decode(
                        Swift.String.self,
                        forKey: .cweId
                    )
                    self.name = try container.decode(
                        Swift.String.self,
                        forKey: .name
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "cwe_id",
                        "name"
                    ])
                }
            }
            /// Details for the advisory pertaining to Common Weakness Enumeration.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cwes`.
            public typealias CwesPayload = [Components.Schemas.DependabotAlertSecurityAdvisory.CwesPayloadPayload]
            /// Details for the advisory pertaining to Common Weakness Enumeration.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/cwes`.
            public var cwes: Components.Schemas.DependabotAlertSecurityAdvisory.CwesPayload
            /// An advisory identifier.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/IdentifiersPayload`.
            public struct IdentifiersPayloadPayload: Codable, Hashable, Sendable {
                /// The type of advisory identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/IdentifiersPayload/type`.
                @frozen public enum _TypePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case cve = "CVE"
                    case ghsa = "GHSA"
                }
                /// The type of advisory identifier.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/IdentifiersPayload/type`.
                public var _type: Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayloadPayload._TypePayload
                /// The value of the advisory identifer.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/IdentifiersPayload/value`.
                public var value: Swift.String
                /// Creates a new `IdentifiersPayloadPayload`.
                ///
                /// - Parameters:
                ///   - _type: The type of advisory identifier.
                ///   - value: The value of the advisory identifer.
                public init(
                    _type: Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayloadPayload._TypePayload,
                    value: Swift.String
                ) {
                    self._type = _type
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case value
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self._type = try container.decode(
                        Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayloadPayload._TypePayload.self,
                        forKey: ._type
                    )
                    self.value = try container.decode(
                        Swift.String.self,
                        forKey: .value
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "type",
                        "value"
                    ])
                }
            }
            /// Values that identify this advisory among security information sources.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/identifiers`.
            public typealias IdentifiersPayload = [Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayloadPayload]
            /// Values that identify this advisory among security information sources.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/identifiers`.
            public var identifiers: Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayload
            /// A link to additional advisory information.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/ReferencesPayload`.
            public struct ReferencesPayloadPayload: Codable, Hashable, Sendable {
                /// The URL of the reference.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/ReferencesPayload/url`.
                public var url: Swift.String
                /// Creates a new `ReferencesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - url: The URL of the reference.
                public init(url: Swift.String) {
                    self.url = url
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                }
                public init(from decoder: any Decoder) throws {
                    let container = try decoder.container(keyedBy: CodingKeys.self)
                    self.url = try container.decode(
                        Swift.String.self,
                        forKey: .url
                    )
                    try decoder.ensureNoAdditionalProperties(knownKeys: [
                        "url"
                    ])
                }
            }
            /// Links to additional advisory information.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/references`.
            public typealias ReferencesPayload = [Components.Schemas.DependabotAlertSecurityAdvisory.ReferencesPayloadPayload]
            /// Links to additional advisory information.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/references`.
            public var references: Components.Schemas.DependabotAlertSecurityAdvisory.ReferencesPayload
            /// The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/published_at`.
            public var publishedAt: Foundation.Date
            /// The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/updated_at`.
            public var updatedAt: Foundation.Date
            /// The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-security-advisory/withdrawn_at`.
            public var withdrawnAt: Foundation.Date?
            /// Creates a new `DependabotAlertSecurityAdvisory`.
            ///
            /// - Parameters:
            ///   - ghsaId: The unique GitHub Security Advisory ID assigned to the advisory.
            ///   - cveId: The unique CVE ID assigned to the advisory.
            ///   - summary: A short, plain text summary of the advisory.
            ///   - description: A long-form Markdown-supported description of the advisory.
            ///   - vulnerabilities: Vulnerable version range information for the advisory.
            ///   - severity: The severity of the advisory.
            ///   - cvss: Details for the advisory pertaining to the Common Vulnerability Scoring System.
            ///   - cvssSeverities:
            ///   - epss:
            ///   - cwes: Details for the advisory pertaining to Common Weakness Enumeration.
            ///   - identifiers: Values that identify this advisory among security information sources.
            ///   - references: Links to additional advisory information.
            ///   - publishedAt: The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - updatedAt: The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            ///   - withdrawnAt: The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
            public init(
                ghsaId: Swift.String,
                cveId: Swift.String? = nil,
                summary: Swift.String,
                description: Swift.String,
                vulnerabilities: [Components.Schemas.DependabotAlertSecurityVulnerability],
                severity: Components.Schemas.DependabotAlertSecurityAdvisory.SeverityPayload,
                cvss: Components.Schemas.DependabotAlertSecurityAdvisory.CvssPayload,
                cvssSeverities: Components.Schemas.CvssSeverities? = nil,
                epss: Components.Schemas.SecurityAdvisoryEpss? = nil,
                cwes: Components.Schemas.DependabotAlertSecurityAdvisory.CwesPayload,
                identifiers: Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayload,
                references: Components.Schemas.DependabotAlertSecurityAdvisory.ReferencesPayload,
                publishedAt: Foundation.Date,
                updatedAt: Foundation.Date,
                withdrawnAt: Foundation.Date? = nil
            ) {
                self.ghsaId = ghsaId
                self.cveId = cveId
                self.summary = summary
                self.description = description
                self.vulnerabilities = vulnerabilities
                self.severity = severity
                self.cvss = cvss
                self.cvssSeverities = cvssSeverities
                self.epss = epss
                self.cwes = cwes
                self.identifiers = identifiers
                self.references = references
                self.publishedAt = publishedAt
                self.updatedAt = updatedAt
                self.withdrawnAt = withdrawnAt
            }
            public enum CodingKeys: String, CodingKey {
                case ghsaId = "ghsa_id"
                case cveId = "cve_id"
                case summary
                case description
                case vulnerabilities
                case severity
                case cvss
                case cvssSeverities = "cvss_severities"
                case epss
                case cwes
                case identifiers
                case references
                case publishedAt = "published_at"
                case updatedAt = "updated_at"
                case withdrawnAt = "withdrawn_at"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.ghsaId = try container.decode(
                    Swift.String.self,
                    forKey: .ghsaId
                )
                self.cveId = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .cveId
                )
                self.summary = try container.decode(
                    Swift.String.self,
                    forKey: .summary
                )
                self.description = try container.decode(
                    Swift.String.self,
                    forKey: .description
                )
                self.vulnerabilities = try container.decode(
                    [Components.Schemas.DependabotAlertSecurityVulnerability].self,
                    forKey: .vulnerabilities
                )
                self.severity = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.SeverityPayload.self,
                    forKey: .severity
                )
                self.cvss = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.CvssPayload.self,
                    forKey: .cvss
                )
                self.cvssSeverities = try container.decodeIfPresent(
                    Components.Schemas.CvssSeverities.self,
                    forKey: .cvssSeverities
                )
                self.epss = try container.decodeIfPresent(
                    Components.Schemas.SecurityAdvisoryEpss.self,
                    forKey: .epss
                )
                self.cwes = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.CwesPayload.self,
                    forKey: .cwes
                )
                self.identifiers = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.IdentifiersPayload.self,
                    forKey: .identifiers
                )
                self.references = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.ReferencesPayload.self,
                    forKey: .references
                )
                self.publishedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .publishedAt
                )
                self.updatedAt = try container.decode(
                    Foundation.Date.self,
                    forKey: .updatedAt
                )
                self.withdrawnAt = try container.decodeIfPresent(
                    Foundation.Date.self,
                    forKey: .withdrawnAt
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "ghsa_id",
                    "cve_id",
                    "summary",
                    "description",
                    "vulnerabilities",
                    "severity",
                    "cvss",
                    "cvss_severities",
                    "epss",
                    "cwes",
                    "identifiers",
                    "references",
                    "published_at",
                    "updated_at",
                    "withdrawn_at"
                ])
            }
        }
        /// The REST API URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-url`.
        public typealias AlertUrl = Swift.String
        /// The GitHub URL of the alert resource.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-html-url`.
        public typealias AlertHtmlUrl = Swift.String
        /// The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-created-at`.
        public typealias AlertCreatedAt = Foundation.Date
        /// The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-updated-at`.
        public typealias AlertUpdatedAt = Foundation.Date
        /// The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-dismissed-at`.
        public typealias AlertDismissedAt = Foundation.Date
        /// The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-fixed-at`.
        public typealias AlertFixedAt = Foundation.Date
        /// The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
        ///
        /// - Remark: Generated from `#/components/schemas/alert-auto-dismissed-at`.
        public typealias AlertAutoDismissedAt = Foundation.Date
        /// A Dependabot alert.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository`.
        public struct DependabotAlertWithRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/number`.
            public var number: Components.Schemas.AlertNumber
            /// The state of the Dependabot alert.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case autoDismissed = "auto_dismissed"
                case dismissed = "dismissed"
                case fixed = "fixed"
                case open = "open"
            }
            /// The state of the Dependabot alert.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/state`.
            public var state: Components.Schemas.DependabotAlertWithRepository.StatePayload
            /// Details for the vulnerable dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency`.
            public struct DependencyPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/package`.
                public var package: Components.Schemas.DependabotAlertPackage?
                /// The full path to the dependency manifest file, relative to the root of the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/manifest_path`.
                public var manifestPath: Swift.String?
                /// The execution scope of the vulnerable dependency.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/scope`.
                @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case development = "development"
                    case runtime = "runtime"
                }
                /// The execution scope of the vulnerable dependency.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/scope`.
                public var scope: Components.Schemas.DependabotAlertWithRepository.DependencyPayload.ScopePayload?
                /// The vulnerable dependency's relationship to your project.
                ///
                /// > [!NOTE]
                /// > We are rolling out support for dependency relationship across ecosystems. This value will be "unknown" for all dependencies in unsupported ecosystems.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/relationship`.
                @frozen public enum RelationshipPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case unknown = "unknown"
                    case direct = "direct"
                    case transitive = "transitive"
                }
                /// The vulnerable dependency's relationship to your project.
                ///
                /// > [!NOTE]
                /// > We are rolling out support for dependency relationship across ecosystems. This value will be "unknown" for all dependencies in unsupported ecosystems.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency/relationship`.
                public var relationship: Components.Schemas.DependabotAlertWithRepository.DependencyPayload.RelationshipPayload?
                /// Creates a new `DependencyPayload`.
                ///
                /// - Parameters:
                ///   - package:
                ///   - manifestPath: The full path to the dependency manifest file, relative to the root of the repository.
                ///   - scope: The execution scope of the vulnerable dependency.
                ///   - relationship: The vulnerable dependency's relationship to your project.
                public init(
                    package: Components.Schemas.DependabotAlertPackage? = nil,
                    manifestPath: Swift.String? = nil,
                    scope: Components.Schemas.DependabotAlertWithRepository.DependencyPayload.ScopePayload? = nil,
                    relationship: Components.Schemas.DependabotAlertWithRepository.DependencyPayload.RelationshipPayload? = nil
                ) {
                    self.package = package
                    self.manifestPath = manifestPath
                    self.scope = scope
                    self.relationship = relationship
                }
                public enum CodingKeys: String, CodingKey {
                    case package
                    case manifestPath = "manifest_path"
                    case scope
                    case relationship
                }
            }
            /// Details for the vulnerable dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dependency`.
            public var dependency: Components.Schemas.DependabotAlertWithRepository.DependencyPayload
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/security_advisory`.
            public var securityAdvisory: Components.Schemas.DependabotAlertSecurityAdvisory
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/security_vulnerability`.
            public var securityVulnerability: Components.Schemas.DependabotAlertSecurityVulnerability
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/url`.
            public var url: Components.Schemas.AlertUrl
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/updated_at`.
            public var updatedAt: Components.Schemas.AlertUpdatedAt
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dismissed_at`.
            public var dismissedAt: Components.Schemas.AlertDismissedAt?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dismissed_by`.
            public var dismissedBy: Components.Schemas.NullableSimpleUser?
            /// The reason that the alert was dismissed.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dismissed_reason`.
            @frozen public enum DismissedReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case fixStarted = "fix_started"
                case inaccurate = "inaccurate"
                case noBandwidth = "no_bandwidth"
                case notUsed = "not_used"
                case tolerableRisk = "tolerable_risk"
            }
            /// The reason that the alert was dismissed.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dismissed_reason`.
            public var dismissedReason: Components.Schemas.DependabotAlertWithRepository.DismissedReasonPayload?
            /// An optional comment associated with the alert's dismissal.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/dismissed_comment`.
            public var dismissedComment: Swift.String?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/fixed_at`.
            public var fixedAt: Components.Schemas.AlertFixedAt?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/auto_dismissed_at`.
            public var autoDismissedAt: Components.Schemas.AlertAutoDismissedAt?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert-with-repository/repository`.
            public var repository: Components.Schemas.SimpleRepository
            /// Creates a new `DependabotAlertWithRepository`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - state: The state of the Dependabot alert.
            ///   - dependency: Details for the vulnerable dependency.
            ///   - securityAdvisory:
            ///   - securityVulnerability:
            ///   - url:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - dismissedAt:
            ///   - dismissedBy:
            ///   - dismissedReason: The reason that the alert was dismissed.
            ///   - dismissedComment: An optional comment associated with the alert's dismissal.
            ///   - fixedAt:
            ///   - autoDismissedAt:
            ///   - repository:
            public init(
                number: Components.Schemas.AlertNumber,
                state: Components.Schemas.DependabotAlertWithRepository.StatePayload,
                dependency: Components.Schemas.DependabotAlertWithRepository.DependencyPayload,
                securityAdvisory: Components.Schemas.DependabotAlertSecurityAdvisory,
                securityVulnerability: Components.Schemas.DependabotAlertSecurityVulnerability,
                url: Components.Schemas.AlertUrl,
                htmlUrl: Components.Schemas.AlertHtmlUrl,
                createdAt: Components.Schemas.AlertCreatedAt,
                updatedAt: Components.Schemas.AlertUpdatedAt,
                dismissedAt: Components.Schemas.AlertDismissedAt? = nil,
                dismissedBy: Components.Schemas.NullableSimpleUser? = nil,
                dismissedReason: Components.Schemas.DependabotAlertWithRepository.DismissedReasonPayload? = nil,
                dismissedComment: Swift.String? = nil,
                fixedAt: Components.Schemas.AlertFixedAt? = nil,
                autoDismissedAt: Components.Schemas.AlertAutoDismissedAt? = nil,
                repository: Components.Schemas.SimpleRepository
            ) {
                self.number = number
                self.state = state
                self.dependency = dependency
                self.securityAdvisory = securityAdvisory
                self.securityVulnerability = securityVulnerability
                self.url = url
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.dismissedAt = dismissedAt
                self.dismissedBy = dismissedBy
                self.dismissedReason = dismissedReason
                self.dismissedComment = dismissedComment
                self.fixedAt = fixedAt
                self.autoDismissedAt = autoDismissedAt
                self.repository = repository
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case state
                case dependency
                case securityAdvisory = "security_advisory"
                case securityVulnerability = "security_vulnerability"
                case url
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case dismissedAt = "dismissed_at"
                case dismissedBy = "dismissed_by"
                case dismissedReason = "dismissed_reason"
                case dismissedComment = "dismissed_comment"
                case fixedAt = "fixed_at"
                case autoDismissedAt = "auto_dismissed_at"
                case repository
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.number = try container.decode(
                    Components.Schemas.AlertNumber.self,
                    forKey: .number
                )
                self.state = try container.decode(
                    Components.Schemas.DependabotAlertWithRepository.StatePayload.self,
                    forKey: .state
                )
                self.dependency = try container.decode(
                    Components.Schemas.DependabotAlertWithRepository.DependencyPayload.self,
                    forKey: .dependency
                )
                self.securityAdvisory = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.self,
                    forKey: .securityAdvisory
                )
                self.securityVulnerability = try container.decode(
                    Components.Schemas.DependabotAlertSecurityVulnerability.self,
                    forKey: .securityVulnerability
                )
                self.url = try container.decode(
                    Components.Schemas.AlertUrl.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Components.Schemas.AlertHtmlUrl.self,
                    forKey: .htmlUrl
                )
                self.createdAt = try container.decode(
                    Components.Schemas.AlertCreatedAt.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decode(
                    Components.Schemas.AlertUpdatedAt.self,
                    forKey: .updatedAt
                )
                self.dismissedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertDismissedAt.self,
                    forKey: .dismissedAt
                )
                self.dismissedBy = try container.decodeIfPresent(
                    Components.Schemas.NullableSimpleUser.self,
                    forKey: .dismissedBy
                )
                self.dismissedReason = try container.decodeIfPresent(
                    Components.Schemas.DependabotAlertWithRepository.DismissedReasonPayload.self,
                    forKey: .dismissedReason
                )
                self.dismissedComment = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .dismissedComment
                )
                self.fixedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertFixedAt.self,
                    forKey: .fixedAt
                )
                self.autoDismissedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertAutoDismissedAt.self,
                    forKey: .autoDismissedAt
                )
                self.repository = try container.decode(
                    Components.Schemas.SimpleRepository.self,
                    forKey: .repository
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "number",
                    "state",
                    "dependency",
                    "security_advisory",
                    "security_vulnerability",
                    "url",
                    "html_url",
                    "created_at",
                    "updated_at",
                    "dismissed_at",
                    "dismissed_by",
                    "dismissed_reason",
                    "dismissed_comment",
                    "fixed_at",
                    "auto_dismissed_at",
                    "repository"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A GitHub repository.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-repository`.
        public struct NullableSimpleRepository: Codable, Hashable, Sendable {
            /// A unique identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/id`.
            public var id: Swift.Int64
            /// The GraphQL identifier of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/name`.
            public var name: Swift.String
            /// The full, globally unique, name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/private`.
            public var _private: Swift.Bool
            /// The URL to view the repository on GitHub.com.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/html_url`.
            public var htmlUrl: Swift.String
            /// The repository description.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/description`.
            public var description: Swift.String?
            /// Whether the repository is a fork.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/fork`.
            public var fork: Swift.Bool
            /// The URL to get more information about the repository from the GitHub API.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/url`.
            public var url: Swift.String
            /// A template for the API URL to download the repository as an archive.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// A template for the API URL to list the available assignees for issues in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// A template for the API URL to get information about branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// A template for the API URL to get information about collaborators of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// A template for the API URL to get information about comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// A template for the API URL to get information about commits on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// A template for the API URL to compare two commits or refs.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/compare_url`.
            public var compareUrl: Swift.String
            /// A template for the API URL to get the contents of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// A template for the API URL to list the contributors to the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// The API URL to list the deployments of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// The API URL to list the downloads on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// The API URL to list the events of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/events_url`.
            public var eventsUrl: Swift.String
            /// The API URL to list the forks of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/forks_url`.
            public var forksUrl: Swift.String
            /// A template for the API URL to get information about Git commits of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// A template for the API URL to get information about Git refs of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// A template for the API URL to get information about Git tags of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// A template for the API URL to get information about issue comments on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// A template for the API URL to get information about issue events on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// A template for the API URL to get information about issues on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// A template for the API URL to get information about deploy keys on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/keys_url`.
            public var keysUrl: Swift.String
            /// A template for the API URL to get information about labels of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// The API URL to get information about the languages of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// The API URL to merge branches in the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// A template for the API URL to get information about milestones of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// A template for the API URL to get information about notifications on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// A template for the API URL to get information about pull requests on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// A template for the API URL to get information about releases on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// The API URL to list the stargazers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// A template for the API URL to get information about statuses of a commit.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// The API URL to list the subscribers on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// The API URL to subscribe to notifications for this repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// The API URL to get information about tags on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// The API URL to list the teams on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/trees_url`.
            public var treesUrl: Swift.String
            /// The API URL to list the hooks on the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-simple-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// Creates a new `NullableSimpleRepository`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier of the repository.
            ///   - nodeId: The GraphQL identifier of the repository.
            ///   - name: The name of the repository.
            ///   - fullName: The full, globally unique, name of the repository.
            ///   - owner:
            ///   - _private: Whether the repository is private.
            ///   - htmlUrl: The URL to view the repository on GitHub.com.
            ///   - description: The repository description.
            ///   - fork: Whether the repository is a fork.
            ///   - url: The URL to get more information about the repository from the GitHub API.
            ///   - archiveUrl: A template for the API URL to download the repository as an archive.
            ///   - assigneesUrl: A template for the API URL to list the available assignees for issues in the repository.
            ///   - blobsUrl: A template for the API URL to create or retrieve a raw Git blob in the repository.
            ///   - branchesUrl: A template for the API URL to get information about branches in the repository.
            ///   - collaboratorsUrl: A template for the API URL to get information about collaborators of the repository.
            ///   - commentsUrl: A template for the API URL to get information about comments on the repository.
            ///   - commitsUrl: A template for the API URL to get information about commits on the repository.
            ///   - compareUrl: A template for the API URL to compare two commits or refs.
            ///   - contentsUrl: A template for the API URL to get the contents of the repository.
            ///   - contributorsUrl: A template for the API URL to list the contributors to the repository.
            ///   - deploymentsUrl: The API URL to list the deployments of the repository.
            ///   - downloadsUrl: The API URL to list the downloads on the repository.
            ///   - eventsUrl: The API URL to list the events of the repository.
            ///   - forksUrl: The API URL to list the forks of the repository.
            ///   - gitCommitsUrl: A template for the API URL to get information about Git commits of the repository.
            ///   - gitRefsUrl: A template for the API URL to get information about Git refs of the repository.
            ///   - gitTagsUrl: A template for the API URL to get information about Git tags of the repository.
            ///   - issueCommentUrl: A template for the API URL to get information about issue comments on the repository.
            ///   - issueEventsUrl: A template for the API URL to get information about issue events on the repository.
            ///   - issuesUrl: A template for the API URL to get information about issues on the repository.
            ///   - keysUrl: A template for the API URL to get information about deploy keys on the repository.
            ///   - labelsUrl: A template for the API URL to get information about labels of the repository.
            ///   - languagesUrl: The API URL to get information about the languages of the repository.
            ///   - mergesUrl: The API URL to merge branches in the repository.
            ///   - milestonesUrl: A template for the API URL to get information about milestones of the repository.
            ///   - notificationsUrl: A template for the API URL to get information about notifications on the repository.
            ///   - pullsUrl: A template for the API URL to get information about pull requests on the repository.
            ///   - releasesUrl: A template for the API URL to get information about releases on the repository.
            ///   - stargazersUrl: The API URL to list the stargazers on the repository.
            ///   - statusesUrl: A template for the API URL to get information about statuses of a commit.
            ///   - subscribersUrl: The API URL to list the subscribers on the repository.
            ///   - subscriptionUrl: The API URL to subscribe to notifications for this repository.
            ///   - tagsUrl: The API URL to get information about tags on the repository.
            ///   - teamsUrl: The API URL to list the teams on the repository.
            ///   - treesUrl: A template for the API URL to create or retrieve a raw Git tree of the repository.
            ///   - hooksUrl: The API URL to list the hooks on the repository.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                hooksUrl: Swift.String
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.hooksUrl = hooksUrl
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case hooksUrl = "hooks_url"
            }
        }
        /// Information about repositories that Dependabot is able to access in an organization
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-repository-access-details`.
        public struct DependabotRepositoryAccessDetails: Codable, Hashable, Sendable {
            /// The default repository access level for Dependabot updates.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-repository-access-details/default_level`.
            @frozen public enum DefaultLevelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case _public = "public"
                case _internal = "internal"
            }
            /// The default repository access level for Dependabot updates.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-repository-access-details/default_level`.
            public var defaultLevel: Components.Schemas.DependabotRepositoryAccessDetails.DefaultLevelPayload?
            /// - Remark: Generated from `#/components/schemas/dependabot-repository-access-details/accessible_repositories`.
            public var accessibleRepositories: [Components.Schemas.NullableSimpleRepository]?
            /// Creates a new `DependabotRepositoryAccessDetails`.
            ///
            /// - Parameters:
            ///   - defaultLevel: The default repository access level for Dependabot updates.
            ///   - accessibleRepositories:
            public init(
                defaultLevel: Components.Schemas.DependabotRepositoryAccessDetails.DefaultLevelPayload? = nil,
                accessibleRepositories: [Components.Schemas.NullableSimpleRepository]? = nil
            ) {
                self.defaultLevel = defaultLevel
                self.accessibleRepositories = accessibleRepositories
            }
            public enum CodingKeys: String, CodingKey {
                case defaultLevel = "default_level"
                case accessibleRepositories = "accessible_repositories"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.defaultLevel = try container.decodeIfPresent(
                    Components.Schemas.DependabotRepositoryAccessDetails.DefaultLevelPayload.self,
                    forKey: .defaultLevel
                )
                self.accessibleRepositories = try container.decodeIfPresent(
                    [Components.Schemas.NullableSimpleRepository].self,
                    forKey: .accessibleRepositories
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "default_level",
                    "accessible_repositories"
                ])
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// Secrets for GitHub Dependabot for an organization.
        ///
        /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret`.
        public struct OrganizationDependabotSecret: Codable, Hashable, Sendable {
            /// The name of the secret.
            ///
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// Visibility of a secret
            ///
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// Visibility of a secret
            ///
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/visibility`.
            public var visibility: Components.Schemas.OrganizationDependabotSecret.VisibilityPayload
            /// - Remark: Generated from `#/components/schemas/organization-dependabot-secret/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// Creates a new `OrganizationDependabotSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - visibility: Visibility of a secret
            ///   - selectedRepositoriesUrl:
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                visibility: Components.Schemas.OrganizationDependabotSecret.VisibilityPayload,
                selectedRepositoriesUrl: Swift.String? = nil
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.visibility = visibility
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case visibility
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// The public key used for setting Dependabot Secrets.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-public-key`.
        public struct DependabotPublicKey: Codable, Hashable, Sendable {
            /// The identifier for the key.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-public-key/key_id`.
            public var keyId: Swift.String
            /// The Base64 encoded public key.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-public-key/key`.
            public var key: Swift.String
            /// Creates a new `DependabotPublicKey`.
            ///
            /// - Parameters:
            ///   - keyId: The identifier for the key.
            ///   - key: The Base64 encoded public key.
            public init(
                keyId: Swift.String,
                key: Swift.String
            ) {
                self.keyId = keyId
                self.key = key
            }
            public enum CodingKeys: String, CodingKey {
                case keyId = "key_id"
                case key
            }
        }
        /// A Dependabot alert.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-alert`.
        public struct DependabotAlert: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/number`.
            public var number: Components.Schemas.AlertNumber
            /// The state of the Dependabot alert.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case autoDismissed = "auto_dismissed"
                case dismissed = "dismissed"
                case fixed = "fixed"
                case open = "open"
            }
            /// The state of the Dependabot alert.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/state`.
            public var state: Components.Schemas.DependabotAlert.StatePayload
            /// Details for the vulnerable dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency`.
            public struct DependencyPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/package`.
                public var package: Components.Schemas.DependabotAlertPackage?
                /// The full path to the dependency manifest file, relative to the root of the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/manifest_path`.
                public var manifestPath: Swift.String?
                /// The execution scope of the vulnerable dependency.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/scope`.
                @frozen public enum ScopePayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case development = "development"
                    case runtime = "runtime"
                }
                /// The execution scope of the vulnerable dependency.
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/scope`.
                public var scope: Components.Schemas.DependabotAlert.DependencyPayload.ScopePayload?
                /// The vulnerable dependency's relationship to your project.
                ///
                /// > [!NOTE]
                /// > We are rolling out support for dependency relationship across ecosystems. This value will be "unknown" for all dependencies in unsupported ecosystems.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/relationship`.
                @frozen public enum RelationshipPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case unknown = "unknown"
                    case direct = "direct"
                    case transitive = "transitive"
                }
                /// The vulnerable dependency's relationship to your project.
                ///
                /// > [!NOTE]
                /// > We are rolling out support for dependency relationship across ecosystems. This value will be "unknown" for all dependencies in unsupported ecosystems.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency/relationship`.
                public var relationship: Components.Schemas.DependabotAlert.DependencyPayload.RelationshipPayload?
                /// Creates a new `DependencyPayload`.
                ///
                /// - Parameters:
                ///   - package:
                ///   - manifestPath: The full path to the dependency manifest file, relative to the root of the repository.
                ///   - scope: The execution scope of the vulnerable dependency.
                ///   - relationship: The vulnerable dependency's relationship to your project.
                public init(
                    package: Components.Schemas.DependabotAlertPackage? = nil,
                    manifestPath: Swift.String? = nil,
                    scope: Components.Schemas.DependabotAlert.DependencyPayload.ScopePayload? = nil,
                    relationship: Components.Schemas.DependabotAlert.DependencyPayload.RelationshipPayload? = nil
                ) {
                    self.package = package
                    self.manifestPath = manifestPath
                    self.scope = scope
                    self.relationship = relationship
                }
                public enum CodingKeys: String, CodingKey {
                    case package
                    case manifestPath = "manifest_path"
                    case scope
                    case relationship
                }
            }
            /// Details for the vulnerable dependency.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dependency`.
            public var dependency: Components.Schemas.DependabotAlert.DependencyPayload
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/security_advisory`.
            public var securityAdvisory: Components.Schemas.DependabotAlertSecurityAdvisory
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/security_vulnerability`.
            public var securityVulnerability: Components.Schemas.DependabotAlertSecurityVulnerability
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/url`.
            public var url: Components.Schemas.AlertUrl
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/html_url`.
            public var htmlUrl: Components.Schemas.AlertHtmlUrl
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/created_at`.
            public var createdAt: Components.Schemas.AlertCreatedAt
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/updated_at`.
            public var updatedAt: Components.Schemas.AlertUpdatedAt
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dismissed_at`.
            public var dismissedAt: Components.Schemas.AlertDismissedAt?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dismissed_by`.
            public var dismissedBy: Components.Schemas.NullableSimpleUser?
            /// The reason that the alert was dismissed.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dismissed_reason`.
            @frozen public enum DismissedReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case fixStarted = "fix_started"
                case inaccurate = "inaccurate"
                case noBandwidth = "no_bandwidth"
                case notUsed = "not_used"
                case tolerableRisk = "tolerable_risk"
            }
            /// The reason that the alert was dismissed.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dismissed_reason`.
            public var dismissedReason: Components.Schemas.DependabotAlert.DismissedReasonPayload?
            /// An optional comment associated with the alert's dismissal.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/dismissed_comment`.
            public var dismissedComment: Swift.String?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/fixed_at`.
            public var fixedAt: Components.Schemas.AlertFixedAt?
            /// - Remark: Generated from `#/components/schemas/dependabot-alert/auto_dismissed_at`.
            public var autoDismissedAt: Components.Schemas.AlertAutoDismissedAt?
            /// Creates a new `DependabotAlert`.
            ///
            /// - Parameters:
            ///   - number:
            ///   - state: The state of the Dependabot alert.
            ///   - dependency: Details for the vulnerable dependency.
            ///   - securityAdvisory:
            ///   - securityVulnerability:
            ///   - url:
            ///   - htmlUrl:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - dismissedAt:
            ///   - dismissedBy:
            ///   - dismissedReason: The reason that the alert was dismissed.
            ///   - dismissedComment: An optional comment associated with the alert's dismissal.
            ///   - fixedAt:
            ///   - autoDismissedAt:
            public init(
                number: Components.Schemas.AlertNumber,
                state: Components.Schemas.DependabotAlert.StatePayload,
                dependency: Components.Schemas.DependabotAlert.DependencyPayload,
                securityAdvisory: Components.Schemas.DependabotAlertSecurityAdvisory,
                securityVulnerability: Components.Schemas.DependabotAlertSecurityVulnerability,
                url: Components.Schemas.AlertUrl,
                htmlUrl: Components.Schemas.AlertHtmlUrl,
                createdAt: Components.Schemas.AlertCreatedAt,
                updatedAt: Components.Schemas.AlertUpdatedAt,
                dismissedAt: Components.Schemas.AlertDismissedAt? = nil,
                dismissedBy: Components.Schemas.NullableSimpleUser? = nil,
                dismissedReason: Components.Schemas.DependabotAlert.DismissedReasonPayload? = nil,
                dismissedComment: Swift.String? = nil,
                fixedAt: Components.Schemas.AlertFixedAt? = nil,
                autoDismissedAt: Components.Schemas.AlertAutoDismissedAt? = nil
            ) {
                self.number = number
                self.state = state
                self.dependency = dependency
                self.securityAdvisory = securityAdvisory
                self.securityVulnerability = securityVulnerability
                self.url = url
                self.htmlUrl = htmlUrl
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.dismissedAt = dismissedAt
                self.dismissedBy = dismissedBy
                self.dismissedReason = dismissedReason
                self.dismissedComment = dismissedComment
                self.fixedAt = fixedAt
                self.autoDismissedAt = autoDismissedAt
            }
            public enum CodingKeys: String, CodingKey {
                case number
                case state
                case dependency
                case securityAdvisory = "security_advisory"
                case securityVulnerability = "security_vulnerability"
                case url
                case htmlUrl = "html_url"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case dismissedAt = "dismissed_at"
                case dismissedBy = "dismissed_by"
                case dismissedReason = "dismissed_reason"
                case dismissedComment = "dismissed_comment"
                case fixedAt = "fixed_at"
                case autoDismissedAt = "auto_dismissed_at"
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                self.number = try container.decode(
                    Components.Schemas.AlertNumber.self,
                    forKey: .number
                )
                self.state = try container.decode(
                    Components.Schemas.DependabotAlert.StatePayload.self,
                    forKey: .state
                )
                self.dependency = try container.decode(
                    Components.Schemas.DependabotAlert.DependencyPayload.self,
                    forKey: .dependency
                )
                self.securityAdvisory = try container.decode(
                    Components.Schemas.DependabotAlertSecurityAdvisory.self,
                    forKey: .securityAdvisory
                )
                self.securityVulnerability = try container.decode(
                    Components.Schemas.DependabotAlertSecurityVulnerability.self,
                    forKey: .securityVulnerability
                )
                self.url = try container.decode(
                    Components.Schemas.AlertUrl.self,
                    forKey: .url
                )
                self.htmlUrl = try container.decode(
                    Components.Schemas.AlertHtmlUrl.self,
                    forKey: .htmlUrl
                )
                self.createdAt = try container.decode(
                    Components.Schemas.AlertCreatedAt.self,
                    forKey: .createdAt
                )
                self.updatedAt = try container.decode(
                    Components.Schemas.AlertUpdatedAt.self,
                    forKey: .updatedAt
                )
                self.dismissedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertDismissedAt.self,
                    forKey: .dismissedAt
                )
                self.dismissedBy = try container.decodeIfPresent(
                    Components.Schemas.NullableSimpleUser.self,
                    forKey: .dismissedBy
                )
                self.dismissedReason = try container.decodeIfPresent(
                    Components.Schemas.DependabotAlert.DismissedReasonPayload.self,
                    forKey: .dismissedReason
                )
                self.dismissedComment = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .dismissedComment
                )
                self.fixedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertFixedAt.self,
                    forKey: .fixedAt
                )
                self.autoDismissedAt = try container.decodeIfPresent(
                    Components.Schemas.AlertAutoDismissedAt.self,
                    forKey: .autoDismissedAt
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "number",
                    "state",
                    "dependency",
                    "security_advisory",
                    "security_vulnerability",
                    "url",
                    "html_url",
                    "created_at",
                    "updated_at",
                    "dismissed_at",
                    "dismissed_by",
                    "dismissed_reason",
                    "dismissed_comment",
                    "fixed_at",
                    "auto_dismissed_at"
                ])
            }
        }
        /// Set secrets for Dependabot.
        ///
        /// - Remark: Generated from `#/components/schemas/dependabot-secret`.
        public struct DependabotSecret: Codable, Hashable, Sendable {
            /// The name of the secret.
            ///
            /// - Remark: Generated from `#/components/schemas/dependabot-secret/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/dependabot-secret/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/dependabot-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `DependabotSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret.
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-before`.
        public typealias PaginationBefore = Swift.String
        /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-after`.
        public typealias PaginationAfter = Swift.String
        /// The direction to sort the results by.
        ///
        /// - Remark: Generated from `#/components/parameters/direction`.
        @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
            case asc = "asc"
            case desc = "desc"
        }
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The slug version of the enterprise name.
        ///
        /// - Remark: Generated from `#/components/parameters/enterprise`.
        public typealias Enterprise = Swift.String
        /// A comma-separated list of states. If specified, only alerts with these states will be returned.
        ///
        /// Can be: `auto_dismissed`, `dismissed`, `fixed`, `open`
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-states`.
        public typealias DependabotAlertCommaSeparatedStates = Swift.String
        /// A comma-separated list of severities. If specified, only alerts with these severities will be returned.
        ///
        /// Can be: `low`, `medium`, `high`, `critical`
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-severities`.
        public typealias DependabotAlertCommaSeparatedSeverities = Swift.String
        /// A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
        ///
        /// Can be: `composer`, `go`, `maven`, `npm`, `nuget`, `pip`, `pub`, `rubygems`, `rust`
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-ecosystems`.
        public typealias DependabotAlertCommaSeparatedEcosystems = Swift.String
        /// A comma-separated list of package names. If specified, only alerts for these packages will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-packages`.
        public typealias DependabotAlertCommaSeparatedPackages = Swift.String
        /// CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
        /// - An exact number (`n`)
        /// - Comparators such as `>n`, `<n`, `>=n`, `<=n`
        /// - A range like `n..n`, where `n` is a number from 0.0 to 1.0
        ///
        /// Filters the list of alerts based on EPSS percentages. If specified, only alerts with the provided EPSS percentages will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-epss`.
        public typealias DependabotAlertCommaSeparatedEpss = Swift.String
        /// Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
        /// Multiple `has` filters can be passed to filter for alerts that have all of the values. Currently, only `patch` is supported.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has`.
        @frozen public enum DependabotAlertCommaSeparatedHas: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case1`.
            case case1(Swift.String)
            /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/Case2Payload`.
            @frozen public enum Case2PayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case patch = "patch"
            }
            /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
            public typealias Case2Payload = [Components.Parameters.DependabotAlertCommaSeparatedHas.Case2PayloadPayload]
            /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
            case case2(Components.Parameters.DependabotAlertCommaSeparatedHas.Case2Payload)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .case2(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .case2(value):
                    try encoder.encodeToSingleValueContainer(value)
                }
            }
        }
        /// The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-scope`.
        @frozen public enum DependabotAlertScope: String, Codable, Hashable, Sendable, CaseIterable {
            case development = "development"
            case runtime = "runtime"
        }
        /// The property by which to sort the results.
        /// `created` means when the alert was created.
        /// `updated` means when the alert's state last changed.
        /// `epss_percentage` sorts alerts by the Exploit Prediction Scoring System (EPSS) percentage.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-sort`.
        @frozen public enum DependabotAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
            case created = "created"
            case updated = "updated"
            case epssPercentage = "epss_percentage"
        }
        /// **Deprecated**. The number of results per page (max 100), starting from the first matching result.
        /// This parameter must not be used in combination with `last`.
        /// Instead, use `per_page` in combination with `after` to fetch the first page of results.
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-first`.
        public typealias PaginationFirst = Swift.Int
        /// **Deprecated**. The number of results per page (max 100), starting from the last matching result.
        /// This parameter must not be used in combination with `first`.
        /// Instead, use `per_page` in combination with `before` to fetch the last page of results.
        ///
        /// - Remark: Generated from `#/components/parameters/pagination-last`.
        public typealias PaginationLast = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The name of the secret.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-name`.
        public typealias SecretName = Swift.String
        /// A comma-separated list of artifact registry URLs. If specified, only alerts for repositories with storage records matching these URLs will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-artifact-registry-urls`.
        public typealias DependabotAlertCommaSeparatedArtifactRegistryUrls = Swift.String
        /// A comma-separated list of Artifact Registry name strings. If specified, only alerts for repositories with storage records matching these registries will be returned.
        ///
        /// Can be: `jfrog-artifactory`
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-artifact-registry`.
        public typealias DependabotAlertCommaSeparatedArtifactRegistry = Swift.String
        /// A comma-separated list of full manifest paths. If specified, only alerts for these manifests will be returned.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-manifests`.
        public typealias DependabotAlertCommaSeparatedManifests = Swift.String
        /// The number that identifies a Dependabot alert in its repository.
        /// You can find this at the end of the URL for a Dependabot alert within GitHub,
        /// or in `number` fields in the response from the
        /// `GET /repos/{owner}/{repo}/dependabot/alerts` operation.
        ///
        /// - Remark: Generated from `#/components/parameters/dependabot-alert-number`.
        public typealias DependabotAlertNumber = Components.Schemas.AlertNumber
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct ValidationFailedSimple: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed_simple/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed_simple/content/application\/json`.
                case json(Components.Schemas.ValidationErrorSimple)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationErrorSimple {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailedSimple.Body
            /// Creates a new `ValidationFailedSimple`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailedSimple.Body) {
                self.body = body
            }
        }
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List Dependabot alerts for an enterprise
    ///
    /// Lists Dependabot alerts for repositories that are owned by the specified enterprise.
    ///
    /// The authenticated user must be a member of the enterprise to use this endpoint.
    ///
    /// Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /enterprises/{enterprise}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)`.
    public enum DependabotListAlertsForEnterprise {
        public static let id: Swift.String = "dependabot/list-alerts-for-enterprise"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The slug version of the enterprise name.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/path/enterprise`.
                public var enterprise: Components.Parameters.Enterprise
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - enterprise: The slug version of the enterprise name.
                public init(enterprise: Components.Parameters.Enterprise) {
                    self.enterprise = enterprise
                }
            }
            public var path: Operations.DependabotListAlertsForEnterprise.Input.Path
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///
                /// Can be: `auto_dismissed`, `dismissed`, `fixed`, `open`
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/state`.
                public var state: Components.Parameters.DependabotAlertCommaSeparatedStates?
                /// A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///
                /// Can be: `low`, `medium`, `high`, `critical`
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/severity`.
                public var severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities?
                /// A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///
                /// Can be: `composer`, `go`, `maven`, `npm`, `nuget`, `pip`, `pub`, `rubygems`, `rust`
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/ecosystem`.
                public var ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems?
                /// A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/package`.
                public var package: Components.Parameters.DependabotAlertCommaSeparatedPackages?
                /// CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                /// - An exact number (`n`)
                /// - Comparators such as `>n`, `<n`, `>=n`, `<=n`
                /// - A range like `n..n`, where `n` is a number from 0.0 to 1.0
                ///
                /// Filters the list of alerts based on EPSS percentages. If specified, only alerts with the provided EPSS percentages will be returned.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/epss_percentage`.
                public var epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has`.
                @frozen public enum DependabotAlertCommaSeparatedHas: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case1`.
                    case case1(Swift.String)
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/Case2Payload`.
                    @frozen public enum Case2PayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case patch = "patch"
                    }
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    public typealias Case2Payload = [Components.Parameters.DependabotAlertCommaSeparatedHas.Case2PayloadPayload]
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    case case2(Components.Parameters.DependabotAlertCommaSeparatedHas.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                /// Multiple `has` filters can be passed to filter for alerts that have all of the values. Currently, only `patch` is supported.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/has`.
                public var has: Components.Parameters.DependabotAlertCommaSeparatedHas?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-scope`.
                @frozen public enum DependabotAlertScope: String, Codable, Hashable, Sendable, CaseIterable {
                    case development = "development"
                    case runtime = "runtime"
                }
                /// The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/scope`.
                public var scope: Components.Parameters.DependabotAlertScope?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-sort`.
                @frozen public enum DependabotAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case epssPercentage = "epss_percentage"
                }
                /// The property by which to sort the results.
                /// `created` means when the alert was created.
                /// `updated` means when the alert's state last changed.
                /// `epss_percentage` sorts alerts by the Exploit Prediction Scoring System (EPSS) percentage.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/sort`.
                public var sort: Components.Parameters.DependabotAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                /// This parameter must not be used in combination with `last`.
                /// Instead, use `per_page` in combination with `after` to fetch the first page of results.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/first`.
                public var first: Components.Parameters.PaginationFirst?
                /// **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                /// This parameter must not be used in combination with `first`.
                /// Instead, use `per_page` in combination with `before` to fetch the last page of results.
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/last`.
                public var last: Components.Parameters.PaginationLast?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///   - severity: A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///   - ecosystem: A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///   - package: A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///   - epssPercentage: CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                ///   - has: Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                ///   - scope: The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///   - sort: The property by which to sort the results.
                ///   - direction: The direction to sort the results by.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - first: **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                ///   - last: **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Components.Parameters.DependabotAlertCommaSeparatedStates? = nil,
                    severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities? = nil,
                    ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems? = nil,
                    package: Components.Parameters.DependabotAlertCommaSeparatedPackages? = nil,
                    epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss? = nil,
                    has: Components.Parameters.DependabotAlertCommaSeparatedHas? = nil,
                    scope: Components.Parameters.DependabotAlertScope? = nil,
                    sort: Components.Parameters.DependabotAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    first: Components.Parameters.PaginationFirst? = nil,
                    last: Components.Parameters.PaginationLast? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.state = state
                    self.severity = severity
                    self.ecosystem = ecosystem
                    self.package = package
                    self.epssPercentage = epssPercentage
                    self.has = has
                    self.scope = scope
                    self.sort = sort
                    self.direction = direction
                    self.before = before
                    self.after = after
                    self.first = first
                    self.last = last
                    self.perPage = perPage
                }
            }
            public var query: Operations.DependabotListAlertsForEnterprise.Input.Query
            /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForEnterprise.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForEnterprise.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListAlertsForEnterprise.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListAlertsForEnterprise.Input.Path,
                query: Operations.DependabotListAlertsForEnterprise.Input.Query = .init(),
                headers: Operations.DependabotListAlertsForEnterprise.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/enterprises/{enterprise}/dependabot/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.DependabotAlertWithRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.DependabotAlertWithRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListAlertsForEnterprise.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotListAlertsForEnterprise.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListAlertsForEnterprise.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListAlertsForEnterprise.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//enterprises/{enterprise}/dependabot/alerts/get(dependabot/list-alerts-for-enterprise)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Lists the repositories Dependabot can access in an organization
    ///
    /// Lists repositories that organization admins have allowed Dependabot to access when updating dependencies.
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// - Remark: HTTP `GET /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)`.
    public enum DependabotRepositoryAccessForOrg {
        public static let id: Swift.String = "dependabot/repository-access-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotRepositoryAccessForOrg.Input.Path
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of results to fetch.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/query/page`.
                public var page: Swift.Int?
                /// Number of results per page.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/query/per_page`.
                public var perPage: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of results to fetch.
                ///   - perPage: Number of results per page.
                public init(
                    page: Swift.Int? = nil,
                    perPage: Swift.Int? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.DependabotRepositoryAccessForOrg.Input.Query
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotRepositoryAccessForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotRepositoryAccessForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotRepositoryAccessForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotRepositoryAccessForOrg.Input.Path,
                query: Operations.DependabotRepositoryAccessForOrg.Input.Query = .init(),
                headers: Operations.DependabotRepositoryAccessForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotRepositoryAccessDetails)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotRepositoryAccessDetails {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotRepositoryAccessForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotRepositoryAccessForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotRepositoryAccessForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotRepositoryAccessForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/get(dependabot/repository-access-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Updates Dependabot's repository access list for an organization
    ///
    /// Updates repositories according to the list of repositories that organization admins have given Dependabot access to when they've updated dependencies.
    ///
    /// > [!NOTE]
    /// >    This operation supports both server-to-server and user-to-server access.
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// **Example request body:**
    /// ```json
    /// {
    ///   "repository_ids_to_add": [123, 456],
    ///   "repository_ids_to_remove": [789]
    /// }
    /// ```
    ///
    /// - Remark: HTTP `PATCH /organizations/{org}/dependabot/repository-access`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)`.
    public enum DependabotUpdateRepositoryAccessForOrg {
        public static let id: Swift.String = "dependabot/update-repository-access-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Path
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotUpdateRepositoryAccessForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotUpdateRepositoryAccessForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Headers
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// List of repository IDs to add.
                    ///
                    /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/requestBody/json/repository_ids_to_add`.
                    public var repositoryIdsToAdd: [Swift.Int]?
                    /// List of repository IDs to remove.
                    ///
                    /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/requestBody/json/repository_ids_to_remove`.
                    public var repositoryIdsToRemove: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - repositoryIdsToAdd: List of repository IDs to add.
                    ///   - repositoryIdsToRemove: List of repository IDs to remove.
                    public init(
                        repositoryIdsToAdd: [Swift.Int]? = nil,
                        repositoryIdsToRemove: [Swift.Int]? = nil
                    ) {
                        self.repositoryIdsToAdd = repositoryIdsToAdd
                        self.repositoryIdsToRemove = repositoryIdsToRemove
                    }
                    public enum CodingKeys: String, CodingKey {
                        case repositoryIdsToAdd = "repository_ids_to_add"
                        case repositoryIdsToRemove = "repository_ids_to_remove"
                    }
                }
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/PATCH/requestBody/content/application\/json`.
                case json(Operations.DependabotUpdateRepositoryAccessForOrg.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Path,
                headers: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Headers = .init(),
                body: Operations.DependabotUpdateRepositoryAccessForOrg.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotUpdateRepositoryAccessForOrg.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotUpdateRepositoryAccessForOrg.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/patch(dependabot/update-repository-access-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set the default repository access level for Dependabot
    ///
    /// Sets the default level of repository access Dependabot will have while performing an update.  Available values are:
    /// - 'public' - Dependabot will only have access to public repositories, unless access is explicitly granted to non-public repositories.
    /// - 'internal' - Dependabot will only have access to public and internal repositories, unless access is explicitly granted to private repositories.
    ///
    /// Unauthorized users will not see the existence of this endpoint.
    ///
    /// This operation supports both server-to-server and user-to-server access.
    ///
    /// - Remark: HTTP `PUT /organizations/{org}/dependabot/repository-access/default-level`.
    /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)`.
    public enum DependabotSetRepositoryAccessDefaultLevel {
        public static let id: Swift.String = "dependabot/set-repository-access-default-level"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Path
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotSetRepositoryAccessDefaultLevel.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotSetRepositoryAccessDefaultLevel.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Headers
            /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The default repository access level for Dependabot updates.
                    ///
                    /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/requestBody/json/default_level`.
                    @frozen public enum DefaultLevelPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case _public = "public"
                        case _internal = "internal"
                    }
                    /// The default repository access level for Dependabot updates.
                    ///
                    /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/requestBody/json/default_level`.
                    public var defaultLevel: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body.JsonPayload.DefaultLevelPayload
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - defaultLevel: The default repository access level for Dependabot updates.
                    public init(defaultLevel: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body.JsonPayload.DefaultLevelPayload) {
                        self.defaultLevel = defaultLevel
                    }
                    public enum CodingKeys: String, CodingKey {
                        case defaultLevel = "default_level"
                    }
                }
                /// - Remark: Generated from `#/paths/organizations/{org}/dependabot/repository-access/default-level/PUT/requestBody/content/application\/json`.
                case json(Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Path,
                headers: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Headers = .init(),
                body: Operations.DependabotSetRepositoryAccessDefaultLevel.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotSetRepositoryAccessDefaultLevel.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotSetRepositoryAccessDefaultLevel.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//organizations/{org}/dependabot/repository-access/default-level/put(dependabot/set-repository-access-default-level)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List Dependabot alerts for an organization
    ///
    /// Lists Dependabot alerts for an organization.
    ///
    /// The authenticated user must be an owner or security manager for the organization to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)`.
    public enum DependabotListAlertsForOrg {
        public static let id: Swift.String = "dependabot/list-alerts-for-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotListAlertsForOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///
                /// Can be: `auto_dismissed`, `dismissed`, `fixed`, `open`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/state`.
                public var state: Components.Parameters.DependabotAlertCommaSeparatedStates?
                /// A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///
                /// Can be: `low`, `medium`, `high`, `critical`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/severity`.
                public var severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities?
                /// A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///
                /// Can be: `composer`, `go`, `maven`, `npm`, `nuget`, `pip`, `pub`, `rubygems`, `rust`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/ecosystem`.
                public var ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems?
                /// A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/package`.
                public var package: Components.Parameters.DependabotAlertCommaSeparatedPackages?
                /// CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                /// - An exact number (`n`)
                /// - Comparators such as `>n`, `<n`, `>=n`, `<=n`
                /// - A range like `n..n`, where `n` is a number from 0.0 to 1.0
                ///
                /// Filters the list of alerts based on EPSS percentages. If specified, only alerts with the provided EPSS percentages will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/epss_percentage`.
                public var epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss?
                /// A comma-separated list of artifact registry URLs. If specified, only alerts for repositories with storage records matching these URLs will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/artifact_registry_url`.
                public var artifactRegistryUrl: Components.Parameters.DependabotAlertCommaSeparatedArtifactRegistryUrls?
                /// A comma-separated list of Artifact Registry name strings. If specified, only alerts for repositories with storage records matching these registries will be returned.
                ///
                /// Can be: `jfrog-artifactory`
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/artifact_registry`.
                public var artifactRegistry: Components.Parameters.DependabotAlertCommaSeparatedArtifactRegistry?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has`.
                @frozen public enum DependabotAlertCommaSeparatedHas: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case1`.
                    case case1(Swift.String)
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/Case2Payload`.
                    @frozen public enum Case2PayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case patch = "patch"
                    }
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    public typealias Case2Payload = [Components.Parameters.DependabotAlertCommaSeparatedHas.Case2PayloadPayload]
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    case case2(Components.Parameters.DependabotAlertCommaSeparatedHas.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                /// Multiple `has` filters can be passed to filter for alerts that have all of the values. Currently, only `patch` is supported.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/has`.
                public var has: Components.Parameters.DependabotAlertCommaSeparatedHas?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-scope`.
                @frozen public enum DependabotAlertScope: String, Codable, Hashable, Sendable, CaseIterable {
                    case development = "development"
                    case runtime = "runtime"
                }
                /// The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/scope`.
                public var scope: Components.Parameters.DependabotAlertScope?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-sort`.
                @frozen public enum DependabotAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case epssPercentage = "epss_percentage"
                }
                /// The property by which to sort the results.
                /// `created` means when the alert was created.
                /// `updated` means when the alert's state last changed.
                /// `epss_percentage` sorts alerts by the Exploit Prediction Scoring System (EPSS) percentage.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/sort`.
                public var sort: Components.Parameters.DependabotAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                /// This parameter must not be used in combination with `last`.
                /// Instead, use `per_page` in combination with `after` to fetch the first page of results.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/first`.
                public var first: Components.Parameters.PaginationFirst?
                /// **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                /// This parameter must not be used in combination with `first`.
                /// Instead, use `per_page` in combination with `before` to fetch the last page of results.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/last`.
                public var last: Components.Parameters.PaginationLast?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///   - severity: A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///   - ecosystem: A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///   - package: A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///   - epssPercentage: CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                ///   - artifactRegistryUrl: A comma-separated list of artifact registry URLs. If specified, only alerts for repositories with storage records matching these URLs will be returned.
                ///   - artifactRegistry: A comma-separated list of Artifact Registry name strings. If specified, only alerts for repositories with storage records matching these registries will be returned.
                ///   - has: Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                ///   - scope: The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///   - sort: The property by which to sort the results.
                ///   - direction: The direction to sort the results by.
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - first: **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                ///   - last: **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    state: Components.Parameters.DependabotAlertCommaSeparatedStates? = nil,
                    severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities? = nil,
                    ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems? = nil,
                    package: Components.Parameters.DependabotAlertCommaSeparatedPackages? = nil,
                    epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss? = nil,
                    artifactRegistryUrl: Components.Parameters.DependabotAlertCommaSeparatedArtifactRegistryUrls? = nil,
                    artifactRegistry: Components.Parameters.DependabotAlertCommaSeparatedArtifactRegistry? = nil,
                    has: Components.Parameters.DependabotAlertCommaSeparatedHas? = nil,
                    scope: Components.Parameters.DependabotAlertScope? = nil,
                    sort: Components.Parameters.DependabotAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    first: Components.Parameters.PaginationFirst? = nil,
                    last: Components.Parameters.PaginationLast? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.state = state
                    self.severity = severity
                    self.ecosystem = ecosystem
                    self.package = package
                    self.epssPercentage = epssPercentage
                    self.artifactRegistryUrl = artifactRegistryUrl
                    self.artifactRegistry = artifactRegistry
                    self.has = has
                    self.scope = scope
                    self.sort = sort
                    self.direction = direction
                    self.before = before
                    self.after = after
                    self.first = first
                    self.last = last
                    self.perPage = perPage
                }
            }
            public var query: Operations.DependabotListAlertsForOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListAlertsForOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListAlertsForOrg.Input.Path,
                query: Operations.DependabotListAlertsForOrg.Input.Query = .init(),
                headers: Operations.DependabotListAlertsForOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.DependabotAlertWithRepository])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.DependabotAlertWithRepository] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListAlertsForOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotListAlertsForOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListAlertsForOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListAlertsForOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/alerts/get(dependabot/list-alerts-for-org)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List organization secrets
    ///
    /// Lists all secrets available in an organization without revealing their
    /// encrypted values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/get(dependabot/list-org-secrets)`.
    public enum DependabotListOrgSecrets {
        public static let id: Swift.String = "dependabot/list-org-secrets"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotListOrgSecrets.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.DependabotListOrgSecrets.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListOrgSecrets.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListOrgSecrets.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListOrgSecrets.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListOrgSecrets.Input.Path,
                query: Operations.DependabotListOrgSecrets.Input.Query = .init(),
                headers: Operations.DependabotListOrgSecrets.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.DependabotListOrgSecrets.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/content/json/secrets`.
                        public var secrets: [Components.Schemas.OrganizationDependabotSecret]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - secrets:
                        public init(
                            totalCount: Swift.Int,
                            secrets: [Components.Schemas.OrganizationDependabotSecret]
                        ) {
                            self.totalCount = totalCount
                            self.secrets = secrets
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case secrets
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/GET/responses/200/content/application\/json`.
                    case json(Operations.DependabotListOrgSecrets.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.DependabotListOrgSecrets.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListOrgSecrets.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.DependabotListOrgSecrets.Output.Ok.Headers = .init(),
                    body: Operations.DependabotListOrgSecrets.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/get(dependabot/list-org-secrets)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListOrgSecrets.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListOrgSecrets.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/public-key/get(dependabot/get-org-public-key)`.
    public enum DependabotGetOrgPublicKey {
        public static let id: Swift.String = "dependabot/get-org-public-key"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/public-key/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/public-key/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.DependabotGetOrgPublicKey.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetOrgPublicKey.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetOrgPublicKey.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotGetOrgPublicKey.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependabotGetOrgPublicKey.Input.Path,
                headers: Operations.DependabotGetOrgPublicKey.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/public-key/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotPublicKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotPublicKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotGetOrgPublicKey.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotGetOrgPublicKey.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/public-key/get(dependabot/get-org-public-key)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotGetOrgPublicKey.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotGetOrgPublicKey.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization secret
    ///
    /// Gets a single organization secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/get(dependabot/get-org-secret)`.
    public enum DependabotGetOrgSecret {
        public static let id: Swift.String = "dependabot/get-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotGetOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotGetOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependabotGetOrgSecret.Input.Path,
                headers: Operations.DependabotGetOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OrganizationDependabotSecret)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OrganizationDependabotSecret {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotGetOrgSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotGetOrgSecret.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/get(dependabot/get-org-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotGetOrgSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotGetOrgSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)`.
    public enum DependabotCreateOrUpdateOrgSecret {
        public static let id: Swift.String = "dependabot/create-or-update-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotCreateOrUpdateOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotCreateOrUpdateOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotCreateOrUpdateOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotCreateOrUpdateOrgSecret.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json/key_id`.
                    public var keyId: Swift.String?
                    /// Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case _private = "private"
                        case selected = "selected"
                    }
                    /// Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json/visibility`.
                    public var visibility: Operations.DependabotCreateOrUpdateOrgSecret.Input.Body.JsonPayload.VisibilityPayload
                    /// An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - encryptedValue: Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key) endpoint.
                    ///   - keyId: ID of the key you used to encrypt the secret.
                    ///   - visibility: Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///   - selectedRepositoryIds: An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    public init(
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String? = nil,
                        visibility: Operations.DependabotCreateOrUpdateOrgSecret.Input.Body.JsonPayload.VisibilityPayload,
                        selectedRepositoryIds: [Swift.String]? = nil
                    ) {
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                        self.visibility = visibility
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                        case visibility
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/requestBody/content/application\/json`.
                case json(Operations.DependabotCreateOrUpdateOrgSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotCreateOrUpdateOrgSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependabotCreateOrUpdateOrgSecret.Input.Path,
                headers: Operations.DependabotCreateOrUpdateOrgSecret.Input.Headers = .init(),
                body: Operations.DependabotCreateOrUpdateOrgSecret.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotCreateOrUpdateOrgSecret.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotCreateOrUpdateOrgSecret.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when creating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.DependabotCreateOrUpdateOrgSecret.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.DependabotCreateOrUpdateOrgSecret.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotCreateOrUpdateOrgSecret.Output.NoContent)
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotCreateOrUpdateOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an organization secret
    ///
    /// Deletes a secret in an organization using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/delete(dependabot/delete-org-secret)`.
    public enum DependabotDeleteOrgSecret {
        public static let id: Swift.String = "dependabot/delete-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotDeleteOrgSecret.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.DependabotDeleteOrgSecret.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/delete(dependabot/delete-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotDeleteOrgSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/delete(dependabot/delete-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotDeleteOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/get(dependabot/list-selected-repos-for-org-secret)`.
    public enum DependabotListSelectedReposForOrgSecret {
        public static let id: Swift.String = "dependabot/list-selected-repos-for-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotListSelectedReposForOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.DependabotListSelectedReposForOrgSecret.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListSelectedReposForOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListSelectedReposForOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListSelectedReposForOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListSelectedReposForOrgSecret.Input.Path,
                query: Operations.DependabotListSelectedReposForOrgSecret.Input.Query = .init(),
                headers: Operations.DependabotListSelectedReposForOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.MinimalRepository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Int,
                            repositories: [Components.Schemas.MinimalRepository]
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.DependabotListSelectedReposForOrgSecret.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.DependabotListSelectedReposForOrgSecret.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListSelectedReposForOrgSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotListSelectedReposForOrgSecret.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/get(dependabot/list-selected-repos-for-org-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListSelectedReposForOrgSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListSelectedReposForOrgSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/put(dependabot/set-selected-repos-for-org-secret)`.
    public enum DependabotSetSelectedReposForOrgSecret {
        public static let id: Swift.String = "dependabot/set-selected-repos-for-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotSetSelectedReposForOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    public init(selectedRepositoryIds: [Swift.Int]) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/PUT/requestBody/content/application\/json`.
                case json(Operations.DependabotSetSelectedReposForOrgSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotSetSelectedReposForOrgSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - body:
            public init(
                path: Operations.DependabotSetSelectedReposForOrgSecret.Input.Path,
                body: Operations.DependabotSetSelectedReposForOrgSecret.Input.Body
            ) {
                self.path = path
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/put(dependabot/set-selected-repos-for-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotSetSelectedReposForOrgSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/put(dependabot/set-selected-repos-for-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotSetSelectedReposForOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization secret when the `visibility` for
    /// repository access is set to `selected`. The visibility is set when you [Create or
    /// update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)`.
    public enum DependabotAddSelectedRepoToOrgSecret {
        public static let id: Swift.String = "dependabot/add-selected-repo-to-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.org = org
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.DependabotAddSelectedRepoToOrgSecret.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.DependabotAddSelectedRepoToOrgSecret.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotAddSelectedRepoToOrgSecret.Output.NoContent)
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotAddSelectedRepoToOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Conflict when visibility type is not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.DependabotAddSelectedRepoToOrgSecret.Output.Conflict)
            /// Conflict when visibility type is not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/put(dependabot/add-selected-repo-to-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.DependabotAddSelectedRepoToOrgSecret.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)`.
    public enum DependabotRemoveSelectedRepoFromOrgSecret {
        public static let id: Swift.String = "dependabot/remove-selected-repo-from-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.org = org
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output.NoContent)
            /// Response when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output.Conflict)
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}/delete(dependabot/remove-selected-repo-from-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.DependabotRemoveSelectedRepoFromOrgSecret.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List Dependabot alerts for a repository
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)`.
    public enum DependabotListAlertsForRepo {
        public static let id: Swift.String = "dependabot/list-alerts-for-repo"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.DependabotListAlertsForRepo.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///
                /// Can be: `auto_dismissed`, `dismissed`, `fixed`, `open`
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/state`.
                public var state: Components.Parameters.DependabotAlertCommaSeparatedStates?
                /// A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///
                /// Can be: `low`, `medium`, `high`, `critical`
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/severity`.
                public var severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities?
                /// A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///
                /// Can be: `composer`, `go`, `maven`, `npm`, `nuget`, `pip`, `pub`, `rubygems`, `rust`
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/ecosystem`.
                public var ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems?
                /// A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/package`.
                public var package: Components.Parameters.DependabotAlertCommaSeparatedPackages?
                /// A comma-separated list of full manifest paths. If specified, only alerts for these manifests will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/manifest`.
                public var manifest: Components.Parameters.DependabotAlertCommaSeparatedManifests?
                /// CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                /// - An exact number (`n`)
                /// - Comparators such as `>n`, `<n`, `>=n`, `<=n`
                /// - A range like `n..n`, where `n` is a number from 0.0 to 1.0
                ///
                /// Filters the list of alerts based on EPSS percentages. If specified, only alerts with the provided EPSS percentages will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/epss_percentage`.
                public var epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has`.
                @frozen public enum DependabotAlertCommaSeparatedHas: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case1`.
                    case case1(Swift.String)
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/Case2Payload`.
                    @frozen public enum Case2PayloadPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case patch = "patch"
                    }
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    public typealias Case2Payload = [Components.Parameters.DependabotAlertCommaSeparatedHas.Case2PayloadPayload]
                    /// - Remark: Generated from `#/components/parameters/dependabot-alert-comma-separated-has/case2`.
                    case case2(Components.Parameters.DependabotAlertCommaSeparatedHas.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                /// Multiple `has` filters can be passed to filter for alerts that have all of the values. Currently, only `patch` is supported.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/has`.
                public var has: Components.Parameters.DependabotAlertCommaSeparatedHas?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-scope`.
                @frozen public enum DependabotAlertScope: String, Codable, Hashable, Sendable, CaseIterable {
                    case development = "development"
                    case runtime = "runtime"
                }
                /// The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/scope`.
                public var scope: Components.Parameters.DependabotAlertScope?
                /// - Remark: Generated from `#/components/parameters/dependabot-alert-sort`.
                @frozen public enum DependabotAlertSort: String, Codable, Hashable, Sendable, CaseIterable {
                    case created = "created"
                    case updated = "updated"
                    case epssPercentage = "epss_percentage"
                }
                /// The property by which to sort the results.
                /// `created` means when the alert was created.
                /// `updated` means when the alert's state last changed.
                /// `epss_percentage` sorts alerts by the Exploit Prediction Scoring System (EPSS) percentage.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/sort`.
                public var sort: Components.Parameters.DependabotAlertSort?
                /// - Remark: Generated from `#/components/parameters/direction`.
                @frozen public enum Direction: String, Codable, Hashable, Sendable, CaseIterable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// The direction to sort the results by.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/direction`.
                public var direction: Components.Parameters.Direction?
                /// **Closing down notice**. Page number of the results to fetch. Use cursor-based pagination with `before` or `after` instead.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/page`.
                @available(*, deprecated)
                public var page: Swift.Int?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/per_page`.
                @available(*, deprecated)
                public var perPage: Swift.Int?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/before`.
                public var before: Components.Parameters.PaginationBefore?
                /// A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/after`.
                public var after: Components.Parameters.PaginationAfter?
                /// **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                /// This parameter must not be used in combination with `last`.
                /// Instead, use `per_page` in combination with `after` to fetch the first page of results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/first`.
                public var first: Components.Parameters.PaginationFirst?
                /// **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                /// This parameter must not be used in combination with `first`.
                /// Instead, use `per_page` in combination with `before` to fetch the last page of results.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/query/last`.
                public var last: Components.Parameters.PaginationLast?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - state: A comma-separated list of states. If specified, only alerts with these states will be returned.
                ///   - severity: A comma-separated list of severities. If specified, only alerts with these severities will be returned.
                ///   - ecosystem: A comma-separated list of ecosystems. If specified, only alerts for these ecosystems will be returned.
                ///   - package: A comma-separated list of package names. If specified, only alerts for these packages will be returned.
                ///   - manifest: A comma-separated list of full manifest paths. If specified, only alerts for these manifests will be returned.
                ///   - epssPercentage: CVE Exploit Prediction Scoring System (EPSS) percentage. Can be specified as:
                ///   - has: Filters the list of alerts based on whether the alert has the given value. If specified, only alerts meeting this criterion will be returned.
                ///   - scope: The scope of the vulnerable dependency. If specified, only alerts with this scope will be returned.
                ///   - sort: The property by which to sort the results.
                ///   - direction: The direction to sort the results by.
                ///   - page: **Closing down notice**. Page number of the results to fetch. Use cursor-based pagination with `before` or `after` instead.
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - before: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results before this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - after: A cursor, as given in the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers). If specified, the query only searches for results after this cursor. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - first: **Deprecated**. The number of results per page (max 100), starting from the first matching result.
                ///   - last: **Deprecated**. The number of results per page (max 100), starting from the last matching result.
                public init(
                    state: Components.Parameters.DependabotAlertCommaSeparatedStates? = nil,
                    severity: Components.Parameters.DependabotAlertCommaSeparatedSeverities? = nil,
                    ecosystem: Components.Parameters.DependabotAlertCommaSeparatedEcosystems? = nil,
                    package: Components.Parameters.DependabotAlertCommaSeparatedPackages? = nil,
                    manifest: Components.Parameters.DependabotAlertCommaSeparatedManifests? = nil,
                    epssPercentage: Components.Parameters.DependabotAlertCommaSeparatedEpss? = nil,
                    has: Components.Parameters.DependabotAlertCommaSeparatedHas? = nil,
                    scope: Components.Parameters.DependabotAlertScope? = nil,
                    sort: Components.Parameters.DependabotAlertSort? = nil,
                    direction: Components.Parameters.Direction? = nil,
                    page: Swift.Int? = nil,
                    perPage: Swift.Int? = nil,
                    before: Components.Parameters.PaginationBefore? = nil,
                    after: Components.Parameters.PaginationAfter? = nil,
                    first: Components.Parameters.PaginationFirst? = nil,
                    last: Components.Parameters.PaginationLast? = nil
                ) {
                    self.state = state
                    self.severity = severity
                    self.ecosystem = ecosystem
                    self.package = package
                    self.manifest = manifest
                    self.epssPercentage = epssPercentage
                    self.has = has
                    self.scope = scope
                    self.sort = sort
                    self.direction = direction
                    self.page = page
                    self.perPage = perPage
                    self.before = before
                    self.after = after
                    self.first = first
                    self.last = last
                }
            }
            public var query: Operations.DependabotListAlertsForRepo.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForRepo.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListAlertsForRepo.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListAlertsForRepo.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListAlertsForRepo.Input.Path,
                query: Operations.DependabotListAlertsForRepo.Input.Query = .init(),
                headers: Operations.DependabotListAlertsForRepo.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/GET/responses/200/content/application\/json`.
                    case json([Components.Schemas.DependabotAlert])
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: [Components.Schemas.DependabotAlert] {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListAlertsForRepo.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotListAlertsForRepo.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListAlertsForRepo.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListAlertsForRepo.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/get(dependabot/list-alerts-for-repo)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Get a Dependabot alert
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)`.
    public enum DependabotGetAlert {
        public static let id: Swift.String = "dependabot/get-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies a Dependabot alert in its repository.
                /// You can find this at the end of the URL for a Dependabot alert within GitHub,
                /// or in `number` fields in the response from the
                /// `GET /repos/{owner}/{repo}/dependabot/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/path/alert_number`.
                public var alertNumber: Components.Parameters.DependabotAlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies a Dependabot alert in its repository.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.DependabotAlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.DependabotGetAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotGetAlert.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependabotGetAlert.Input.Path,
                headers: Operations.DependabotGetAlert.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotGetAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotGetAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotGetAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotGetAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/get(dependabot/get-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a Dependabot alert
    ///
    /// The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.
    ///
    /// - Remark: HTTP `PATCH /repos/{owner}/{repo}/dependabot/alerts/{alert_number}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)`.
    public enum DependabotUpdateAlert {
        public static let id: Swift.String = "dependabot/update-alert"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies a Dependabot alert in its repository.
                /// You can find this at the end of the URL for a Dependabot alert within GitHub,
                /// or in `number` fields in the response from the
                /// `GET /repos/{owner}/{repo}/dependabot/alerts` operation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/path/alert_number`.
                public var alertNumber: Components.Parameters.DependabotAlertNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - alertNumber: The number that identifies a Dependabot alert in its repository.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    alertNumber: Components.Parameters.DependabotAlertNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.alertNumber = alertNumber
                }
            }
            public var path: Operations.DependabotUpdateAlert.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotUpdateAlert.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotUpdateAlert.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotUpdateAlert.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The state of the Dependabot alert.
                    /// A `dismissed_reason` must be provided when setting the state to `dismissed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json/state`.
                    @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case dismissed = "dismissed"
                        case open = "open"
                    }
                    /// The state of the Dependabot alert.
                    /// A `dismissed_reason` must be provided when setting the state to `dismissed`.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json/state`.
                    public var state: Operations.DependabotUpdateAlert.Input.Body.JsonPayload.StatePayload
                    /// **Required when `state` is `dismissed`.** A reason for dismissing the alert.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json/dismissed_reason`.
                    @frozen public enum DismissedReasonPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case fixStarted = "fix_started"
                        case inaccurate = "inaccurate"
                        case noBandwidth = "no_bandwidth"
                        case notUsed = "not_used"
                        case tolerableRisk = "tolerable_risk"
                    }
                    /// **Required when `state` is `dismissed`.** A reason for dismissing the alert.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json/dismissed_reason`.
                    public var dismissedReason: Operations.DependabotUpdateAlert.Input.Body.JsonPayload.DismissedReasonPayload?
                    /// An optional comment associated with dismissing the alert.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/json/dismissed_comment`.
                    public var dismissedComment: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - state: The state of the Dependabot alert.
                    ///   - dismissedReason: **Required when `state` is `dismissed`.** A reason for dismissing the alert.
                    ///   - dismissedComment: An optional comment associated with dismissing the alert.
                    public init(
                        state: Operations.DependabotUpdateAlert.Input.Body.JsonPayload.StatePayload,
                        dismissedReason: Operations.DependabotUpdateAlert.Input.Body.JsonPayload.DismissedReasonPayload? = nil,
                        dismissedComment: Swift.String? = nil
                    ) {
                        self.state = state
                        self.dismissedReason = dismissedReason
                        self.dismissedComment = dismissedComment
                    }
                    public enum CodingKeys: String, CodingKey {
                        case state
                        case dismissedReason = "dismissed_reason"
                        case dismissedComment = "dismissed_comment"
                    }
                    public init(from decoder: any Decoder) throws {
                        let container = try decoder.container(keyedBy: CodingKeys.self)
                        self.state = try container.decode(
                            Operations.DependabotUpdateAlert.Input.Body.JsonPayload.StatePayload.self,
                            forKey: .state
                        )
                        self.dismissedReason = try container.decodeIfPresent(
                            Operations.DependabotUpdateAlert.Input.Body.JsonPayload.DismissedReasonPayload.self,
                            forKey: .dismissedReason
                        )
                        self.dismissedComment = try container.decodeIfPresent(
                            Swift.String.self,
                            forKey: .dismissedComment
                        )
                        try decoder.ensureNoAdditionalProperties(knownKeys: [
                            "state",
                            "dismissed_reason",
                            "dismissed_comment"
                        ])
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/requestBody/content/application\/json`.
                case json(Operations.DependabotUpdateAlert.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotUpdateAlert.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependabotUpdateAlert.Input.Path,
                headers: Operations.DependabotUpdateAlert.Input.Headers = .init(),
                body: Operations.DependabotUpdateAlert.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/alerts/{alert_number}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotAlert)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotAlert {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotUpdateAlert.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotUpdateAlert.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotUpdateAlert.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotUpdateAlert.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/alerts/{alert_number}/patch(dependabot/update-alert)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailedSimple)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailedSimple {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List repository secrets
    ///
    /// Lists all secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/get(dependabot/list-repo-secrets)`.
    public enum DependabotListRepoSecrets {
        public static let id: Swift.String = "dependabot/list-repo-secrets"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.DependabotListRepoSecrets.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.DependabotListRepoSecrets.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListRepoSecrets.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotListRepoSecrets.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotListRepoSecrets.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.DependabotListRepoSecrets.Input.Path,
                query: Operations.DependabotListRepoSecrets.Input.Query = .init(),
                headers: Operations.DependabotListRepoSecrets.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.DependabotListRepoSecrets.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/content/json/secrets`.
                        public var secrets: [Components.Schemas.DependabotSecret]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - secrets:
                        public init(
                            totalCount: Swift.Int,
                            secrets: [Components.Schemas.DependabotSecret]
                        ) {
                            self.totalCount = totalCount
                            self.secrets = secrets
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case secrets
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/GET/responses/200/content/application\/json`.
                    case json(Operations.DependabotListRepoSecrets.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.DependabotListRepoSecrets.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotListRepoSecrets.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.DependabotListRepoSecrets.Output.Ok.Headers = .init(),
                    body: Operations.DependabotListRepoSecrets.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/get(dependabot/list-repo-secrets)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotListRepoSecrets.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotListRepoSecrets.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets. Anyone with read access
    /// to the repository can use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/public-key/get(dependabot/get-repo-public-key)`.
    public enum DependabotGetRepoPublicKey {
        public static let id: Swift.String = "dependabot/get-repo-public-key"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.DependabotGetRepoPublicKey.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetRepoPublicKey.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetRepoPublicKey.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotGetRepoPublicKey.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependabotGetRepoPublicKey.Input.Path,
                headers: Operations.DependabotGetRepoPublicKey.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/public-key/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotPublicKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotPublicKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotGetRepoPublicKey.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotGetRepoPublicKey.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/public-key/get(dependabot/get-repo-public-key)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotGetRepoPublicKey.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotGetRepoPublicKey.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository secret
    ///
    /// Gets a single repository secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/get(dependabot/get-repo-secret)`.
    public enum DependabotGetRepoSecret {
        public static let id: Swift.String = "dependabot/get-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotGetRepoSecret.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetRepoSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotGetRepoSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotGetRepoSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.DependabotGetRepoSecret.Input.Path,
                headers: Operations.DependabotGetRepoSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.DependabotSecret)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DependabotSecret {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotGetRepoSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotGetRepoSecret.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/get(dependabot/get-repo-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.DependabotGetRepoSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.DependabotGetRepoSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)`.
    public enum DependabotCreateOrUpdateRepoSecret {
        public static let id: Swift.String = "dependabot/create-or-update-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotCreateOrUpdateRepoSecret.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotCreateOrUpdateRepoSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.DependabotCreateOrUpdateRepoSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.DependabotCreateOrUpdateRepoSecret.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/dependabot/secrets#get-a-repository-public-key) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/requestBody/json/key_id`.
                    public var keyId: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - encryptedValue: Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/dependabot/secrets#get-a-repository-public-key) endpoint.
                    ///   - keyId: ID of the key you used to encrypt the secret.
                    public init(
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String? = nil
                    ) {
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/requestBody/content/application\/json`.
                case json(Operations.DependabotCreateOrUpdateRepoSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.DependabotCreateOrUpdateRepoSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.DependabotCreateOrUpdateRepoSecret.Input.Path,
                headers: Operations.DependabotCreateOrUpdateRepoSecret.Input.Headers = .init(),
                body: Operations.DependabotCreateOrUpdateRepoSecret.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.DependabotCreateOrUpdateRepoSecret.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.DependabotCreateOrUpdateRepoSecret.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when creating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.DependabotCreateOrUpdateRepoSecret.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.DependabotCreateOrUpdateRepoSecret.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotCreateOrUpdateRepoSecret.Output.NoContent)
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/put(dependabot/create-or-update-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotCreateOrUpdateRepoSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a repository secret
    ///
    /// Deletes a secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/dependabot/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/delete(dependabot/delete-repo-secret)`.
    public enum DependabotDeleteRepoSecret {
        public static let id: Swift.String = "dependabot/delete-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/dependabot/secrets/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.DependabotDeleteRepoSecret.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.DependabotDeleteRepoSecret.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/delete(dependabot/delete-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.DependabotDeleteRepoSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/dependabot/secrets/{secret_name}/delete(dependabot/delete-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.DependabotDeleteRepoSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
}
