// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// List codespaces for the organization
    ///
    /// Lists the codespaces associated to a specified organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)`.
    func codespacesListInOrganization(_ input: Operations.CodespacesListInOrganization.Input) async throws -> Operations.CodespacesListInOrganization.Output
    /// Manage access control for organization codespaces
    ///
    /// Sets which users can access codespaces in an organization. This is synonymous with granting or revoking codespaces access permissions for users according to the visibility.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/access`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)`.
    @available(*, deprecated)
    func codespacesSetCodespacesAccess(_ input: Operations.CodespacesSetCodespacesAccess.Input) async throws -> Operations.CodespacesSetCodespacesAccess.Output
    /// Add users to Codespaces access for an organization
    ///
    /// Codespaces for the specified users will be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)`.
    @available(*, deprecated)
    func codespacesSetCodespacesAccessUsers(_ input: Operations.CodespacesSetCodespacesAccessUsers.Input) async throws -> Operations.CodespacesSetCodespacesAccessUsers.Output
    /// Remove users from Codespaces access for an organization
    ///
    /// Codespaces for the specified users will no longer be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)`.
    @available(*, deprecated)
    func codespacesDeleteCodespacesAccessUsers(_ input: Operations.CodespacesDeleteCodespacesAccessUsers.Input) async throws -> Operations.CodespacesDeleteCodespacesAccessUsers.Output
    /// List organization secrets
    ///
    /// Lists all Codespaces development environment secrets available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/get(codespaces/list-org-secrets)`.
    func codespacesListOrgSecrets(_ input: Operations.CodespacesListOrgSecrets.Input) async throws -> Operations.CodespacesListOrgSecrets.Output
    /// Get an organization public key
    ///
    /// Gets a public key for an organization, which is required in order to encrypt secrets. You need to encrypt the value of a secret before you can create or update secrets.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/public-key/get(codespaces/get-org-public-key)`.
    func codespacesGetOrgPublicKey(_ input: Operations.CodespacesGetOrgPublicKey.Input) async throws -> Operations.CodespacesGetOrgPublicKey.Output
    /// Get an organization secret
    ///
    /// Gets an organization development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/get(codespaces/get-org-secret)`.
    func codespacesGetOrgSecret(_ input: Operations.CodespacesGetOrgSecret.Input) async throws -> Operations.CodespacesGetOrgSecret.Output
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)`.
    func codespacesCreateOrUpdateOrgSecret(_ input: Operations.CodespacesCreateOrUpdateOrgSecret.Input) async throws -> Operations.CodespacesCreateOrUpdateOrgSecret.Output
    /// Delete an organization secret
    ///
    /// Deletes an organization development environment secret using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)`.
    func codespacesDeleteOrgSecret(_ input: Operations.CodespacesDeleteOrgSecret.Input) async throws -> Operations.CodespacesDeleteOrgSecret.Output
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-selected-repos-for-org-secret)`.
    func codespacesListSelectedReposForOrgSecret(_ input: Operations.CodespacesListSelectedReposForOrgSecret.Input) async throws -> Operations.CodespacesListSelectedReposForOrgSecret.Output
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)`.
    func codespacesSetSelectedReposForOrgSecret(_ input: Operations.CodespacesSetSelectedReposForOrgSecret.Input) async throws -> Operations.CodespacesSetSelectedReposForOrgSecret.Output
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization development environment secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)`.
    func codespacesAddSelectedRepoToOrgSecret(_ input: Operations.CodespacesAddSelectedRepoToOrgSecret.Input) async throws -> Operations.CodespacesAddSelectedRepoToOrgSecret.Output
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)`.
    func codespacesRemoveSelectedRepoFromOrgSecret(_ input: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input) async throws -> Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output
    /// List codespaces for a user in organization
    ///
    /// Lists the codespaces that a member of an organization has for repositories in that organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)`.
    func codespacesGetCodespacesForUserInOrg(_ input: Operations.CodespacesGetCodespacesForUserInOrg.Input) async throws -> Operations.CodespacesGetCodespacesForUserInOrg.Output
    /// Delete a codespace from the organization
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)`.
    func codespacesDeleteFromOrganization(_ input: Operations.CodespacesDeleteFromOrganization.Input) async throws -> Operations.CodespacesDeleteFromOrganization.Output
    /// Stop a codespace for an organization user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/members/{username}/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)`.
    func codespacesStopInOrganization(_ input: Operations.CodespacesStopInOrganization.Input) async throws -> Operations.CodespacesStopInOrganization.Output
    /// List codespaces in a repository for the authenticated user
    ///
    /// Lists the codespaces associated to a specified repository and the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)`.
    func codespacesListInRepositoryForAuthenticatedUser(_ input: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input) async throws -> Operations.CodespacesListInRepositoryForAuthenticatedUser.Output
    /// Create a codespace in a repository
    ///
    /// Creates a codespace owned by the authenticated user in the specified repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)`.
    func codespacesCreateWithRepoForAuthenticatedUser(_ input: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input) async throws -> Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output
    /// List devcontainer configurations in a repository for the authenticated user
    ///
    /// Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
    /// specify launchpoint configurations for codespaces created within the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/devcontainers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)`.
    func codespacesListDevcontainersInRepositoryForAuthenticatedUser(_ input: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input) async throws -> Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output
    /// List available machine types for a repository
    ///
    /// List the machine types available for a given repository based on its configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/machines`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)`.
    func codespacesRepoMachinesForAuthenticatedUser(_ input: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input) async throws -> Operations.CodespacesRepoMachinesForAuthenticatedUser.Output
    /// Get default attributes for a codespace
    ///
    /// Gets the default attributes for codespaces created by the user with the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/new`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)`.
    func codespacesPreFlightWithRepoForAuthenticatedUser(_ input: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input) async throws -> Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output
    /// Check if permissions defined by a devcontainer have been accepted by the authenticated user
    ///
    /// Checks whether the permissions defined by a given devcontainer configuration have been accepted by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/permissions_check`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)`.
    func codespacesCheckPermissionsForDevcontainer(_ input: Operations.CodespacesCheckPermissionsForDevcontainer.Input) async throws -> Operations.CodespacesCheckPermissionsForDevcontainer.Output
    /// List repository secrets
    ///
    /// Lists all development environment secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/get(codespaces/list-repo-secrets)`.
    func codespacesListRepoSecrets(_ input: Operations.CodespacesListRepoSecrets.Input) async throws -> Operations.CodespacesListRepoSecrets.Output
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// If the repository is private, OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/public-key/get(codespaces/get-repo-public-key)`.
    func codespacesGetRepoPublicKey(_ input: Operations.CodespacesGetRepoPublicKey.Input) async throws -> Operations.CodespacesGetRepoPublicKey.Output
    /// Get a repository secret
    ///
    /// Gets a single repository development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/get(codespaces/get-repo-secret)`.
    func codespacesGetRepoSecret(_ input: Operations.CodespacesGetRepoSecret.Input) async throws -> Operations.CodespacesGetRepoSecret.Output
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)`.
    func codespacesCreateOrUpdateRepoSecret(_ input: Operations.CodespacesCreateOrUpdateRepoSecret.Input) async throws -> Operations.CodespacesCreateOrUpdateRepoSecret.Output
    /// Delete a repository secret
    ///
    /// Deletes a development environment secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/delete(codespaces/delete-repo-secret)`.
    func codespacesDeleteRepoSecret(_ input: Operations.CodespacesDeleteRepoSecret.Input) async throws -> Operations.CodespacesDeleteRepoSecret.Output
    /// Create a codespace from a pull request
    ///
    /// Creates a codespace owned by the authenticated user for the specified pull request.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)`.
    func codespacesCreateWithPrForAuthenticatedUser(_ input: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input) async throws -> Operations.CodespacesCreateWithPrForAuthenticatedUser.Output
    /// List codespaces for the authenticated user
    ///
    /// Lists the authenticated user's codespaces.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)`.
    func codespacesListForAuthenticatedUser(_ input: Operations.CodespacesListForAuthenticatedUser.Input) async throws -> Operations.CodespacesListForAuthenticatedUser.Output
    /// Create a codespace for the authenticated user
    ///
    /// Creates a new codespace, owned by the authenticated user.
    ///
    /// This endpoint requires either a `repository_id` OR a `pull_request` but not both.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)`.
    func codespacesCreateForAuthenticatedUser(_ input: Operations.CodespacesCreateForAuthenticatedUser.Input) async throws -> Operations.CodespacesCreateForAuthenticatedUser.Output
    /// List secrets for the authenticated user
    ///
    /// Lists all development environment secrets available for a user's codespaces without revealing their
    /// encrypted values.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/get(codespaces/list-secrets-for-authenticated-user)`.
    func codespacesListSecretsForAuthenticatedUser(_ input: Operations.CodespacesListSecretsForAuthenticatedUser.Input) async throws -> Operations.CodespacesListSecretsForAuthenticatedUser.Output
    /// Get public key for the authenticated user
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/public-key/get(codespaces/get-public-key-for-authenticated-user)`.
    func codespacesGetPublicKeyForAuthenticatedUser(_ input: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Input) async throws -> Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output
    /// Get a secret for the authenticated user
    ///
    /// Gets a development environment secret available to a user's codespaces without revealing its encrypted value.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/get(codespaces/get-secret-for-authenticated-user)`.
    func codespacesGetSecretForAuthenticatedUser(_ input: Operations.CodespacesGetSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesGetSecretForAuthenticatedUser.Output
    /// Create or update a secret for the authenticated user
    ///
    /// Creates or updates a development environment secret for a user's codespace with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)`.
    func codespacesCreateOrUpdateSecretForAuthenticatedUser(_ input: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output
    /// Delete a secret for the authenticated user
    ///
    /// Deletes a development environment secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/delete(codespaces/delete-secret-for-authenticated-user)`.
    func codespacesDeleteSecretForAuthenticatedUser(_ input: Operations.CodespacesDeleteSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesDeleteSecretForAuthenticatedUser.Output
    /// List selected repositories for a user secret
    ///
    /// List the repositories that have been granted the ability to use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)`.
    func codespacesListRepositoriesForSecretForAuthenticatedUser(_ input: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output
    /// Set selected repositories for a user secret
    ///
    /// Select the repositories that will use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)`.
    func codespacesSetRepositoriesForSecretForAuthenticatedUser(_ input: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Output
    /// Add a selected repository to a user secret
    ///
    /// Adds a repository to the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)`.
    func codespacesAddRepositoryForSecretForAuthenticatedUser(_ input: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Output
    /// Remove a selected repository from a user secret
    ///
    /// Removes a repository from the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)`.
    func codespacesRemoveRepositoryForSecretForAuthenticatedUser(_ input: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input) async throws -> Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Output
    /// Get a codespace for the authenticated user
    ///
    /// Gets information about a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)`.
    func codespacesGetForAuthenticatedUser(_ input: Operations.CodespacesGetForAuthenticatedUser.Input) async throws -> Operations.CodespacesGetForAuthenticatedUser.Output
    /// Update a codespace for the authenticated user
    ///
    /// Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.
    ///
    /// If you specify a new machine type it will be applied the next time your codespace is started.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)`.
    func codespacesUpdateForAuthenticatedUser(_ input: Operations.CodespacesUpdateForAuthenticatedUser.Input) async throws -> Operations.CodespacesUpdateForAuthenticatedUser.Output
    /// Delete a codespace for the authenticated user
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)`.
    func codespacesDeleteForAuthenticatedUser(_ input: Operations.CodespacesDeleteForAuthenticatedUser.Input) async throws -> Operations.CodespacesDeleteForAuthenticatedUser.Output
    /// Export a codespace for the authenticated user
    ///
    /// Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.
    ///
    /// If changes cannot be pushed to the codespace's repository, they will be pushed to a new or previously-existing fork instead.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/exports`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)`.
    func codespacesExportForAuthenticatedUser(_ input: Operations.CodespacesExportForAuthenticatedUser.Input) async throws -> Operations.CodespacesExportForAuthenticatedUser.Output
    /// Get details about a codespace export
    ///
    /// Gets information about an export of a codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/exports/{export_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/{export_id}/get(codespaces/get-export-details-for-authenticated-user)`.
    func codespacesGetExportDetailsForAuthenticatedUser(_ input: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input) async throws -> Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output
    /// List machine types for a codespace
    ///
    /// List the machine types a codespace can transition to use.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/machines`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)`.
    func codespacesCodespaceMachinesForAuthenticatedUser(_ input: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input) async throws -> Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output
    /// Create a repository from an unpublished codespace
    ///
    /// Publishes an unpublished codespace, creating a new repository and assigning it to the codespace.
    ///
    /// The codespace's token is granted write permissions to the repository, allowing the user to push their changes.
    ///
    /// This will fail for a codespace that is already published, meaning it has an associated repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/publish`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)`.
    func codespacesPublishForAuthenticatedUser(_ input: Operations.CodespacesPublishForAuthenticatedUser.Input) async throws -> Operations.CodespacesPublishForAuthenticatedUser.Output
    /// Start a codespace for the authenticated user
    ///
    /// Starts a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/start`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)`.
    func codespacesStartForAuthenticatedUser(_ input: Operations.CodespacesStartForAuthenticatedUser.Input) async throws -> Operations.CodespacesStartForAuthenticatedUser.Output
    /// Stop a codespace for the authenticated user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)`.
    func codespacesStopForAuthenticatedUser(_ input: Operations.CodespacesStopForAuthenticatedUser.Input) async throws -> Operations.CodespacesStopForAuthenticatedUser.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// List codespaces for the organization
    ///
    /// Lists the codespaces associated to a specified organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)`.
    public func codespacesListInOrganization(
        path: Operations.CodespacesListInOrganization.Input.Path,
        query: Operations.CodespacesListInOrganization.Input.Query = .init(),
        headers: Operations.CodespacesListInOrganization.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListInOrganization.Output {
        try await codespacesListInOrganization(Operations.CodespacesListInOrganization.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Manage access control for organization codespaces
    ///
    /// Sets which users can access codespaces in an organization. This is synonymous with granting or revoking codespaces access permissions for users according to the visibility.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/access`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)`.
    @available(*, deprecated)
    public func codespacesSetCodespacesAccess(
        path: Operations.CodespacesSetCodespacesAccess.Input.Path,
        headers: Operations.CodespacesSetCodespacesAccess.Input.Headers = .init(),
        body: Operations.CodespacesSetCodespacesAccess.Input.Body
    ) async throws -> Operations.CodespacesSetCodespacesAccess.Output {
        try await codespacesSetCodespacesAccess(Operations.CodespacesSetCodespacesAccess.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add users to Codespaces access for an organization
    ///
    /// Codespaces for the specified users will be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)`.
    @available(*, deprecated)
    public func codespacesSetCodespacesAccessUsers(
        path: Operations.CodespacesSetCodespacesAccessUsers.Input.Path,
        headers: Operations.CodespacesSetCodespacesAccessUsers.Input.Headers = .init(),
        body: Operations.CodespacesSetCodespacesAccessUsers.Input.Body
    ) async throws -> Operations.CodespacesSetCodespacesAccessUsers.Output {
        try await codespacesSetCodespacesAccessUsers(Operations.CodespacesSetCodespacesAccessUsers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Remove users from Codespaces access for an organization
    ///
    /// Codespaces for the specified users will no longer be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)`.
    @available(*, deprecated)
    public func codespacesDeleteCodespacesAccessUsers(
        path: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Path,
        headers: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Headers = .init(),
        body: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Body
    ) async throws -> Operations.CodespacesDeleteCodespacesAccessUsers.Output {
        try await codespacesDeleteCodespacesAccessUsers(Operations.CodespacesDeleteCodespacesAccessUsers.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List organization secrets
    ///
    /// Lists all Codespaces development environment secrets available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/get(codespaces/list-org-secrets)`.
    public func codespacesListOrgSecrets(
        path: Operations.CodespacesListOrgSecrets.Input.Path,
        query: Operations.CodespacesListOrgSecrets.Input.Query = .init(),
        headers: Operations.CodespacesListOrgSecrets.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListOrgSecrets.Output {
        try await codespacesListOrgSecrets(Operations.CodespacesListOrgSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get an organization public key
    ///
    /// Gets a public key for an organization, which is required in order to encrypt secrets. You need to encrypt the value of a secret before you can create or update secrets.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/public-key/get(codespaces/get-org-public-key)`.
    public func codespacesGetOrgPublicKey(
        path: Operations.CodespacesGetOrgPublicKey.Input.Path,
        headers: Operations.CodespacesGetOrgPublicKey.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetOrgPublicKey.Output {
        try await codespacesGetOrgPublicKey(Operations.CodespacesGetOrgPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get an organization secret
    ///
    /// Gets an organization development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/get(codespaces/get-org-secret)`.
    public func codespacesGetOrgSecret(
        path: Operations.CodespacesGetOrgSecret.Input.Path,
        headers: Operations.CodespacesGetOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetOrgSecret.Output {
        try await codespacesGetOrgSecret(Operations.CodespacesGetOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)`.
    public func codespacesCreateOrUpdateOrgSecret(
        path: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Path,
        headers: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Headers = .init(),
        body: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body
    ) async throws -> Operations.CodespacesCreateOrUpdateOrgSecret.Output {
        try await codespacesCreateOrUpdateOrgSecret(Operations.CodespacesCreateOrUpdateOrgSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete an organization secret
    ///
    /// Deletes an organization development environment secret using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)`.
    public func codespacesDeleteOrgSecret(
        path: Operations.CodespacesDeleteOrgSecret.Input.Path,
        headers: Operations.CodespacesDeleteOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesDeleteOrgSecret.Output {
        try await codespacesDeleteOrgSecret(Operations.CodespacesDeleteOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-selected-repos-for-org-secret)`.
    public func codespacesListSelectedReposForOrgSecret(
        path: Operations.CodespacesListSelectedReposForOrgSecret.Input.Path,
        query: Operations.CodespacesListSelectedReposForOrgSecret.Input.Query = .init(),
        headers: Operations.CodespacesListSelectedReposForOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListSelectedReposForOrgSecret.Output {
        try await codespacesListSelectedReposForOrgSecret(Operations.CodespacesListSelectedReposForOrgSecret.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)`.
    public func codespacesSetSelectedReposForOrgSecret(
        path: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Path,
        headers: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Headers = .init(),
        body: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Body
    ) async throws -> Operations.CodespacesSetSelectedReposForOrgSecret.Output {
        try await codespacesSetSelectedReposForOrgSecret(Operations.CodespacesSetSelectedReposForOrgSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization development environment secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)`.
    public func codespacesAddSelectedRepoToOrgSecret(
        path: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Path,
        headers: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesAddSelectedRepoToOrgSecret.Output {
        try await codespacesAddSelectedRepoToOrgSecret(Operations.CodespacesAddSelectedRepoToOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)`.
    public func codespacesRemoveSelectedRepoFromOrgSecret(
        path: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Path,
        headers: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output {
        try await codespacesRemoveSelectedRepoFromOrgSecret(Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// List codespaces for a user in organization
    ///
    /// Lists the codespaces that a member of an organization has for repositories in that organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)`.
    public func codespacesGetCodespacesForUserInOrg(
        path: Operations.CodespacesGetCodespacesForUserInOrg.Input.Path,
        query: Operations.CodespacesGetCodespacesForUserInOrg.Input.Query = .init(),
        headers: Operations.CodespacesGetCodespacesForUserInOrg.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetCodespacesForUserInOrg.Output {
        try await codespacesGetCodespacesForUserInOrg(Operations.CodespacesGetCodespacesForUserInOrg.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Delete a codespace from the organization
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)`.
    public func codespacesDeleteFromOrganization(
        path: Operations.CodespacesDeleteFromOrganization.Input.Path,
        headers: Operations.CodespacesDeleteFromOrganization.Input.Headers = .init()
    ) async throws -> Operations.CodespacesDeleteFromOrganization.Output {
        try await codespacesDeleteFromOrganization(Operations.CodespacesDeleteFromOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// Stop a codespace for an organization user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/members/{username}/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)`.
    public func codespacesStopInOrganization(
        path: Operations.CodespacesStopInOrganization.Input.Path,
        headers: Operations.CodespacesStopInOrganization.Input.Headers = .init()
    ) async throws -> Operations.CodespacesStopInOrganization.Output {
        try await codespacesStopInOrganization(Operations.CodespacesStopInOrganization.Input(
            path: path,
            headers: headers
        ))
    }
    /// List codespaces in a repository for the authenticated user
    ///
    /// Lists the codespaces associated to a specified repository and the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)`.
    public func codespacesListInRepositoryForAuthenticatedUser(
        path: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Path,
        query: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListInRepositoryForAuthenticatedUser.Output {
        try await codespacesListInRepositoryForAuthenticatedUser(Operations.CodespacesListInRepositoryForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Create a codespace in a repository
    ///
    /// Creates a codespace owned by the authenticated user in the specified repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)`.
    public func codespacesCreateWithRepoForAuthenticatedUser(
        path: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output {
        try await codespacesCreateWithRepoForAuthenticatedUser(Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List devcontainer configurations in a repository for the authenticated user
    ///
    /// Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
    /// specify launchpoint configurations for codespaces created within the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/devcontainers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)`.
    public func codespacesListDevcontainersInRepositoryForAuthenticatedUser(
        path: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Path,
        query: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output {
        try await codespacesListDevcontainersInRepositoryForAuthenticatedUser(Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List available machine types for a repository
    ///
    /// List the machine types available for a given repository based on its configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/machines`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)`.
    public func codespacesRepoMachinesForAuthenticatedUser(
        path: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Path,
        query: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesRepoMachinesForAuthenticatedUser.Output {
        try await codespacesRepoMachinesForAuthenticatedUser(Operations.CodespacesRepoMachinesForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get default attributes for a codespace
    ///
    /// Gets the default attributes for codespaces created by the user with the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/new`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)`.
    public func codespacesPreFlightWithRepoForAuthenticatedUser(
        path: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Path,
        query: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output {
        try await codespacesPreFlightWithRepoForAuthenticatedUser(Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Check if permissions defined by a devcontainer have been accepted by the authenticated user
    ///
    /// Checks whether the permissions defined by a given devcontainer configuration have been accepted by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/permissions_check`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)`.
    public func codespacesCheckPermissionsForDevcontainer(
        path: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Path,
        query: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Query,
        headers: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Headers = .init()
    ) async throws -> Operations.CodespacesCheckPermissionsForDevcontainer.Output {
        try await codespacesCheckPermissionsForDevcontainer(Operations.CodespacesCheckPermissionsForDevcontainer.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// List repository secrets
    ///
    /// Lists all development environment secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/get(codespaces/list-repo-secrets)`.
    public func codespacesListRepoSecrets(
        path: Operations.CodespacesListRepoSecrets.Input.Path,
        query: Operations.CodespacesListRepoSecrets.Input.Query = .init(),
        headers: Operations.CodespacesListRepoSecrets.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListRepoSecrets.Output {
        try await codespacesListRepoSecrets(Operations.CodespacesListRepoSecrets.Input(
            path: path,
            query: query,
            headers: headers
        ))
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// If the repository is private, OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/public-key/get(codespaces/get-repo-public-key)`.
    public func codespacesGetRepoPublicKey(
        path: Operations.CodespacesGetRepoPublicKey.Input.Path,
        headers: Operations.CodespacesGetRepoPublicKey.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetRepoPublicKey.Output {
        try await codespacesGetRepoPublicKey(Operations.CodespacesGetRepoPublicKey.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a repository secret
    ///
    /// Gets a single repository development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/get(codespaces/get-repo-secret)`.
    public func codespacesGetRepoSecret(
        path: Operations.CodespacesGetRepoSecret.Input.Path,
        headers: Operations.CodespacesGetRepoSecret.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetRepoSecret.Output {
        try await codespacesGetRepoSecret(Operations.CodespacesGetRepoSecret.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)`.
    public func codespacesCreateOrUpdateRepoSecret(
        path: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Path,
        headers: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Headers = .init(),
        body: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Body
    ) async throws -> Operations.CodespacesCreateOrUpdateRepoSecret.Output {
        try await codespacesCreateOrUpdateRepoSecret(Operations.CodespacesCreateOrUpdateRepoSecret.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a repository secret
    ///
    /// Deletes a development environment secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/delete(codespaces/delete-repo-secret)`.
    public func codespacesDeleteRepoSecret(path: Operations.CodespacesDeleteRepoSecret.Input.Path) async throws -> Operations.CodespacesDeleteRepoSecret.Output {
        try await codespacesDeleteRepoSecret(Operations.CodespacesDeleteRepoSecret.Input(path: path))
    }
    /// Create a codespace from a pull request
    ///
    /// Creates a codespace owned by the authenticated user for the specified pull request.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)`.
    public func codespacesCreateWithPrForAuthenticatedUser(
        path: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesCreateWithPrForAuthenticatedUser.Output {
        try await codespacesCreateWithPrForAuthenticatedUser(Operations.CodespacesCreateWithPrForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// List codespaces for the authenticated user
    ///
    /// Lists the authenticated user's codespaces.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)`.
    public func codespacesListForAuthenticatedUser(
        query: Operations.CodespacesListForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesListForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListForAuthenticatedUser.Output {
        try await codespacesListForAuthenticatedUser(Operations.CodespacesListForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Create a codespace for the authenticated user
    ///
    /// Creates a new codespace, owned by the authenticated user.
    ///
    /// This endpoint requires either a `repository_id` OR a `pull_request` but not both.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)`.
    public func codespacesCreateForAuthenticatedUser(
        headers: Operations.CodespacesCreateForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesCreateForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesCreateForAuthenticatedUser.Output {
        try await codespacesCreateForAuthenticatedUser(Operations.CodespacesCreateForAuthenticatedUser.Input(
            headers: headers,
            body: body
        ))
    }
    /// List secrets for the authenticated user
    ///
    /// Lists all development environment secrets available for a user's codespaces without revealing their
    /// encrypted values.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/get(codespaces/list-secrets-for-authenticated-user)`.
    public func codespacesListSecretsForAuthenticatedUser(
        query: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Query = .init(),
        headers: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListSecretsForAuthenticatedUser.Output {
        try await codespacesListSecretsForAuthenticatedUser(Operations.CodespacesListSecretsForAuthenticatedUser.Input(
            query: query,
            headers: headers
        ))
    }
    /// Get public key for the authenticated user
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/public-key/get(codespaces/get-public-key-for-authenticated-user)`.
    public func codespacesGetPublicKeyForAuthenticatedUser(headers: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Input.Headers = .init()) async throws -> Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output {
        try await codespacesGetPublicKeyForAuthenticatedUser(Operations.CodespacesGetPublicKeyForAuthenticatedUser.Input(headers: headers))
    }
    /// Get a secret for the authenticated user
    ///
    /// Gets a development environment secret available to a user's codespaces without revealing its encrypted value.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/get(codespaces/get-secret-for-authenticated-user)`.
    public func codespacesGetSecretForAuthenticatedUser(
        path: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetSecretForAuthenticatedUser.Output {
        try await codespacesGetSecretForAuthenticatedUser(Operations.CodespacesGetSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create or update a secret for the authenticated user
    ///
    /// Creates or updates a development environment secret for a user's codespace with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)`.
    public func codespacesCreateOrUpdateSecretForAuthenticatedUser(
        path: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output {
        try await codespacesCreateOrUpdateSecretForAuthenticatedUser(Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a secret for the authenticated user
    ///
    /// Deletes a development environment secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/delete(codespaces/delete-secret-for-authenticated-user)`.
    public func codespacesDeleteSecretForAuthenticatedUser(path: Operations.CodespacesDeleteSecretForAuthenticatedUser.Input.Path) async throws -> Operations.CodespacesDeleteSecretForAuthenticatedUser.Output {
        try await codespacesDeleteSecretForAuthenticatedUser(Operations.CodespacesDeleteSecretForAuthenticatedUser.Input(path: path))
    }
    /// List selected repositories for a user secret
    ///
    /// List the repositories that have been granted the ability to use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)`.
    public func codespacesListRepositoriesForSecretForAuthenticatedUser(
        path: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output {
        try await codespacesListRepositoriesForSecretForAuthenticatedUser(Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Set selected repositories for a user secret
    ///
    /// Select the repositories that will use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)`.
    public func codespacesSetRepositoriesForSecretForAuthenticatedUser(
        path: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Output {
        try await codespacesSetRepositoriesForSecretForAuthenticatedUser(Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Add a selected repository to a user secret
    ///
    /// Adds a repository to the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)`.
    public func codespacesAddRepositoryForSecretForAuthenticatedUser(
        path: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Output {
        try await codespacesAddRepositoryForSecretForAuthenticatedUser(Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Remove a selected repository from a user secret
    ///
    /// Removes a repository from the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)`.
    public func codespacesRemoveRepositoryForSecretForAuthenticatedUser(
        path: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Output {
        try await codespacesRemoveRepositoryForSecretForAuthenticatedUser(Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get a codespace for the authenticated user
    ///
    /// Gets information about a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)`.
    public func codespacesGetForAuthenticatedUser(
        path: Operations.CodespacesGetForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesGetForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetForAuthenticatedUser.Output {
        try await codespacesGetForAuthenticatedUser(Operations.CodespacesGetForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Update a codespace for the authenticated user
    ///
    /// Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.
    ///
    /// If you specify a new machine type it will be applied the next time your codespace is started.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)`.
    public func codespacesUpdateForAuthenticatedUser(
        path: Operations.CodespacesUpdateForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesUpdateForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesUpdateForAuthenticatedUser.Input.Body? = nil
    ) async throws -> Operations.CodespacesUpdateForAuthenticatedUser.Output {
        try await codespacesUpdateForAuthenticatedUser(Operations.CodespacesUpdateForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Delete a codespace for the authenticated user
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)`.
    public func codespacesDeleteForAuthenticatedUser(
        path: Operations.CodespacesDeleteForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesDeleteForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesDeleteForAuthenticatedUser.Output {
        try await codespacesDeleteForAuthenticatedUser(Operations.CodespacesDeleteForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Export a codespace for the authenticated user
    ///
    /// Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.
    ///
    /// If changes cannot be pushed to the codespace's repository, they will be pushed to a new or previously-existing fork instead.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/exports`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)`.
    public func codespacesExportForAuthenticatedUser(
        path: Operations.CodespacesExportForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesExportForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesExportForAuthenticatedUser.Output {
        try await codespacesExportForAuthenticatedUser(Operations.CodespacesExportForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Get details about a codespace export
    ///
    /// Gets information about an export of a codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/exports/{export_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/{export_id}/get(codespaces/get-export-details-for-authenticated-user)`.
    public func codespacesGetExportDetailsForAuthenticatedUser(
        path: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output {
        try await codespacesGetExportDetailsForAuthenticatedUser(Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// List machine types for a codespace
    ///
    /// List the machine types a codespace can transition to use.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/machines`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)`.
    public func codespacesCodespaceMachinesForAuthenticatedUser(
        path: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output {
        try await codespacesCodespaceMachinesForAuthenticatedUser(Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Create a repository from an unpublished codespace
    ///
    /// Publishes an unpublished codespace, creating a new repository and assigning it to the codespace.
    ///
    /// The codespace's token is granted write permissions to the repository, allowing the user to push their changes.
    ///
    /// This will fail for a codespace that is already published, meaning it has an associated repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/publish`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)`.
    public func codespacesPublishForAuthenticatedUser(
        path: Operations.CodespacesPublishForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesPublishForAuthenticatedUser.Input.Headers = .init(),
        body: Operations.CodespacesPublishForAuthenticatedUser.Input.Body
    ) async throws -> Operations.CodespacesPublishForAuthenticatedUser.Output {
        try await codespacesPublishForAuthenticatedUser(Operations.CodespacesPublishForAuthenticatedUser.Input(
            path: path,
            headers: headers,
            body: body
        ))
    }
    /// Start a codespace for the authenticated user
    ///
    /// Starts a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/start`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)`.
    public func codespacesStartForAuthenticatedUser(
        path: Operations.CodespacesStartForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesStartForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesStartForAuthenticatedUser.Output {
        try await codespacesStartForAuthenticatedUser(Operations.CodespacesStartForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
    /// Stop a codespace for the authenticated user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)`.
    public func codespacesStopForAuthenticatedUser(
        path: Operations.CodespacesStopForAuthenticatedUser.Input.Path,
        headers: Operations.CodespacesStopForAuthenticatedUser.Input.Headers = .init()
    ) async throws -> Operations.CodespacesStopForAuthenticatedUser.Output {
        try await codespacesStopForAuthenticatedUser(Operations.CodespacesStopForAuthenticatedUser.Input(
            path: path,
            headers: headers
        ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public enum Server1 {
        public static func url() throws -> Foundation.URL {
            try Foundation.URL(
                validatingOpenAPIServerURL: "https://api.github.com",
                variables: []
            )
        }
    }
    @available(*, deprecated, renamed: "Servers.Server1.url")
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.github.com",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/simple-user`.
        public struct SimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `SimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// Basic Error
        ///
        /// - Remark: Generated from `#/components/schemas/basic-error`.
        public struct BasicError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/basic-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/basic-error/status`.
            public var status: Swift.String?
            /// Creates a new `BasicError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - url:
            ///   - status:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                url: Swift.String? = nil,
                status: Swift.String? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.url = url
                self.status = status
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case url
                case status
            }
        }
        /// Scim Error
        ///
        /// - Remark: Generated from `#/components/schemas/scim-error`.
        public struct ScimError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/scim-error/message`.
            public var message: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/documentation_url`.
            public var documentationUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/detail`.
            public var detail: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/status`.
            public var status: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/scim-error/scimType`.
            public var scimType: Swift.String?
            /// - Remark: Generated from `#/components/schemas/scim-error/schemas`.
            public var schemas: [Swift.String]?
            /// Creates a new `ScimError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - detail:
            ///   - status:
            ///   - scimType:
            ///   - schemas:
            public init(
                message: Swift.String? = nil,
                documentationUrl: Swift.String? = nil,
                detail: Swift.String? = nil,
                status: Swift.Int? = nil,
                scimType: Swift.String? = nil,
                schemas: [Swift.String]? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.detail = detail
                self.status = status
                self.scimType = scimType
                self.schemas = schemas
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case detail
                case status
                case scimType
                case schemas
            }
        }
        /// Validation Error
        ///
        /// - Remark: Generated from `#/components/schemas/validation-error`.
        public struct ValidationError: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/validation-error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/documentation_url`.
            public var documentationUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload`.
            public struct ErrorsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/resource`.
                public var resource: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/field`.
                public var field: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/message`.
                public var message: Swift.String?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/code`.
                public var code: Swift.String
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/index`.
                public var index: Swift.Int?
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                @frozen public enum ValuePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case1`.
                    case case1(Swift.String?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case2`.
                    case case2(Swift.Int?)
                    /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value/case3`.
                    case case3([Swift.String]?)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case3(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case3(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/validation-error/ErrorsPayload/value`.
                public var value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload?
                /// Creates a new `ErrorsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - resource:
                ///   - field:
                ///   - message:
                ///   - code:
                ///   - index:
                ///   - value:
                public init(
                    resource: Swift.String? = nil,
                    field: Swift.String? = nil,
                    message: Swift.String? = nil,
                    code: Swift.String,
                    index: Swift.Int? = nil,
                    value: Components.Schemas.ValidationError.ErrorsPayloadPayload.ValuePayload? = nil
                ) {
                    self.resource = resource
                    self.field = field
                    self.message = message
                    self.code = code
                    self.index = index
                    self.value = value
                }
                public enum CodingKeys: String, CodingKey {
                    case resource
                    case field
                    case message
                    case code
                    case index
                    case value
                }
            }
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public typealias ErrorsPayload = [Components.Schemas.ValidationError.ErrorsPayloadPayload]
            /// - Remark: Generated from `#/components/schemas/validation-error/errors`.
            public var errors: Components.Schemas.ValidationError.ErrorsPayload?
            /// Creates a new `ValidationError`.
            ///
            /// - Parameters:
            ///   - message:
            ///   - documentationUrl:
            ///   - errors:
            public init(
                message: Swift.String,
                documentationUrl: Swift.String,
                errors: Components.Schemas.ValidationError.ErrorsPayload? = nil
            ) {
                self.message = message
                self.documentationUrl = documentationUrl
                self.errors = errors
            }
            public enum CodingKeys: String, CodingKey {
                case message
                case documentationUrl = "documentation_url"
                case errors
            }
        }
        /// A GitHub user.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-simple-user`.
        public struct NullableSimpleUser: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/name`.
            public var name: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/email`.
            public var email: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/login`.
            public var login: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/avatar_url`.
            public var avatarUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gravatar_id`.
            public var gravatarId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/followers_url`.
            public var followersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/following_url`.
            public var followingUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/gists_url`.
            public var gistsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_url`.
            public var starredUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/subscriptions_url`.
            public var subscriptionsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/organizations_url`.
            public var organizationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/repos_url`.
            public var reposUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/received_events_url`.
            public var receivedEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/type`.
            public var _type: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/site_admin`.
            public var siteAdmin: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/starred_at`.
            public var starredAt: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-simple-user/user_view_type`.
            public var userViewType: Swift.String?
            /// Creates a new `NullableSimpleUser`.
            ///
            /// - Parameters:
            ///   - name:
            ///   - email:
            ///   - login:
            ///   - id:
            ///   - nodeId:
            ///   - avatarUrl:
            ///   - gravatarId:
            ///   - url:
            ///   - htmlUrl:
            ///   - followersUrl:
            ///   - followingUrl:
            ///   - gistsUrl:
            ///   - starredUrl:
            ///   - subscriptionsUrl:
            ///   - organizationsUrl:
            ///   - reposUrl:
            ///   - eventsUrl:
            ///   - receivedEventsUrl:
            ///   - _type:
            ///   - siteAdmin:
            ///   - starredAt:
            ///   - userViewType:
            public init(
                name: Swift.String? = nil,
                email: Swift.String? = nil,
                login: Swift.String,
                id: Swift.Int64,
                nodeId: Swift.String,
                avatarUrl: Swift.String,
                gravatarId: Swift.String? = nil,
                url: Swift.String,
                htmlUrl: Swift.String,
                followersUrl: Swift.String,
                followingUrl: Swift.String,
                gistsUrl: Swift.String,
                starredUrl: Swift.String,
                subscriptionsUrl: Swift.String,
                organizationsUrl: Swift.String,
                reposUrl: Swift.String,
                eventsUrl: Swift.String,
                receivedEventsUrl: Swift.String,
                _type: Swift.String,
                siteAdmin: Swift.Bool,
                starredAt: Swift.String? = nil,
                userViewType: Swift.String? = nil
            ) {
                self.name = name
                self.email = email
                self.login = login
                self.id = id
                self.nodeId = nodeId
                self.avatarUrl = avatarUrl
                self.gravatarId = gravatarId
                self.url = url
                self.htmlUrl = htmlUrl
                self.followersUrl = followersUrl
                self.followingUrl = followingUrl
                self.gistsUrl = gistsUrl
                self.starredUrl = starredUrl
                self.subscriptionsUrl = subscriptionsUrl
                self.organizationsUrl = organizationsUrl
                self.reposUrl = reposUrl
                self.eventsUrl = eventsUrl
                self.receivedEventsUrl = receivedEventsUrl
                self._type = _type
                self.siteAdmin = siteAdmin
                self.starredAt = starredAt
                self.userViewType = userViewType
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case email
                case login
                case id
                case nodeId = "node_id"
                case avatarUrl = "avatar_url"
                case gravatarId = "gravatar_id"
                case url
                case htmlUrl = "html_url"
                case followersUrl = "followers_url"
                case followingUrl = "following_url"
                case gistsUrl = "gists_url"
                case starredUrl = "starred_url"
                case subscriptionsUrl = "subscriptions_url"
                case organizationsUrl = "organizations_url"
                case reposUrl = "repos_url"
                case eventsUrl = "events_url"
                case receivedEventsUrl = "received_events_url"
                case _type = "type"
                case siteAdmin = "site_admin"
                case starredAt = "starred_at"
                case userViewType = "user_view_type"
            }
        }
        /// License Simple
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-license-simple`.
        public struct NullableLicenseSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/spdx_id`.
            public var spdxId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-license-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `NullableLicenseSimple`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - spdxId:
            ///   - nodeId:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String? = nil,
                spdxId: Swift.String? = nil,
                nodeId: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.spdxId = spdxId
                self.nodeId = nodeId
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case spdxId = "spdx_id"
                case nodeId = "node_id"
                case htmlUrl = "html_url"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/repository`.
        public struct Repository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/repository/permissions`.
            public var permissions: Components.Schemas.Repository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload?
            /// Creates a new `Repository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.Repository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.Repository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.Repository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.Repository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.Repository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.Repository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code Of Conduct
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct`.
        public struct CodeOfConduct: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/body`.
            public var body: Swift.String?
            /// - Remark: Generated from `#/components/schemas/code-of-conduct/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConduct`.
            ///
            /// - Parameters:
            ///   - key:
            ///   - name:
            ///   - url:
            ///   - body:
            ///   - htmlUrl:
            public init(
                key: Swift.String,
                name: Swift.String,
                url: Swift.String,
                body: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.key = key
                self.name = name
                self.url = url
                self.body = body
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case key
                case name
                case url
                case body
                case htmlUrl = "html_url"
            }
        }
        /// - Remark: Generated from `#/components/schemas/security-and-analysis`.
        public struct SecurityAndAnalysis: Codable, Hashable, Sendable {
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public struct AdvancedSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload?
                /// Creates a new `AdvancedSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable GitHub Advanced Security for the repository.
            ///
            /// For standalone Code Scanning or Secret Protection products, this parameter cannot be used.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/advanced_security`.
            public var advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public struct CodeSecurityPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload?
                /// Creates a new `CodeSecurityPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/code_security`.
            public var codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload?
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public struct DependabotSecurityUpdatesPayload: Codable, Hashable, Sendable {
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// The enablement status of Dependabot security updates for the repository.
                ///
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload?
                /// Creates a new `DependabotSecurityUpdatesPayload`.
                ///
                /// - Parameters:
                ///   - status: The enablement status of Dependabot security updates for the repository.
                public init(status: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// Enable or disable Dependabot security updates for the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/dependabot_security_updates`.
            public var dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public struct SecretScanningPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload?
                /// Creates a new `SecretScanningPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning`.
            public var secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public struct SecretScanningPushProtectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload?
                /// Creates a new `SecretScanningPushProtectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_push_protection`.
            public var secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public struct SecretScanningNonProviderPatternsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload?
                /// Creates a new `SecretScanningNonProviderPatternsPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_non_provider_patterns`.
            public var secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload?
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public struct SecretScanningAiDetectionPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                @frozen public enum StatusPayload: String, Codable, Hashable, Sendable, CaseIterable {
                    case enabled = "enabled"
                    case disabled = "disabled"
                }
                /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection/status`.
                public var status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload?
                /// Creates a new `SecretScanningAiDetectionPayload`.
                ///
                /// - Parameters:
                ///   - status:
                public init(status: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload.StatusPayload? = nil) {
                    self.status = status
                }
                public enum CodingKeys: String, CodingKey {
                    case status
                }
            }
            /// - Remark: Generated from `#/components/schemas/security-and-analysis/secret_scanning_ai_detection`.
            public var secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload?
            /// Creates a new `SecurityAndAnalysis`.
            ///
            /// - Parameters:
            ///   - advancedSecurity: Enable or disable GitHub Advanced Security for the repository.
            ///   - codeSecurity:
            ///   - dependabotSecurityUpdates: Enable or disable Dependabot security updates for the repository.
            ///   - secretScanning:
            ///   - secretScanningPushProtection:
            ///   - secretScanningNonProviderPatterns:
            ///   - secretScanningAiDetection:
            public init(
                advancedSecurity: Components.Schemas.SecurityAndAnalysis.AdvancedSecurityPayload? = nil,
                codeSecurity: Components.Schemas.SecurityAndAnalysis.CodeSecurityPayload? = nil,
                dependabotSecurityUpdates: Components.Schemas.SecurityAndAnalysis.DependabotSecurityUpdatesPayload? = nil,
                secretScanning: Components.Schemas.SecurityAndAnalysis.SecretScanningPayload? = nil,
                secretScanningPushProtection: Components.Schemas.SecurityAndAnalysis.SecretScanningPushProtectionPayload? = nil,
                secretScanningNonProviderPatterns: Components.Schemas.SecurityAndAnalysis.SecretScanningNonProviderPatternsPayload? = nil,
                secretScanningAiDetection: Components.Schemas.SecurityAndAnalysis.SecretScanningAiDetectionPayload? = nil
            ) {
                self.advancedSecurity = advancedSecurity
                self.codeSecurity = codeSecurity
                self.dependabotSecurityUpdates = dependabotSecurityUpdates
                self.secretScanning = secretScanning
                self.secretScanningPushProtection = secretScanningPushProtection
                self.secretScanningNonProviderPatterns = secretScanningNonProviderPatterns
                self.secretScanningAiDetection = secretScanningAiDetection
            }
            public enum CodingKeys: String, CodingKey {
                case advancedSecurity = "advanced_security"
                case codeSecurity = "code_security"
                case dependabotSecurityUpdates = "dependabot_security_updates"
                case secretScanning = "secret_scanning"
                case secretScanningPushProtection = "secret_scanning_push_protection"
                case secretScanningNonProviderPatterns = "secret_scanning_non_provider_patterns"
                case secretScanningAiDetection = "secret_scanning_ai_detection"
            }
        }
        /// Minimal Repository
        ///
        /// - Remark: Generated from `#/components/schemas/minimal-repository`.
        public struct MinimalRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/minimal-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/minimal-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/minimal-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/minimal-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/git_url`.
            public var gitUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/ssh_url`.
            public var sshUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/clone_url`.
            public var cloneUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/minimal-repository/svn_url`.
            public var svnUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks_count`.
            public var forksCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/stargazers_count`.
            public var stargazersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers_count`.
            public var watchersCount: Swift.Int?
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/size`.
            public var size: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/default_branch`.
            public var defaultBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_issues`.
            public var hasIssues: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_projects`.
            public var hasProjects: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_wiki`.
            public var hasWiki: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_pages`.
            public var hasPages: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/archived`.
            public var archived: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/disabled`.
            public var disabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/admin`.
                public var admin: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/push`.
                public var push: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions/pull`.
                public var pull: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool? = nil,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool? = nil,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/permissions`.
            public var permissions: Components.Schemas.MinimalRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/role_name`.
            public var roleName: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/subscribers_count`.
            public var subscribersCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/network_count`.
            public var networkCount: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConduct?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public struct LicensePayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/key`.
                public var key: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/name`.
                public var name: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/spdx_id`.
                public var spdxId: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/url`.
                public var url: Swift.String?
                /// - Remark: Generated from `#/components/schemas/minimal-repository/license/node_id`.
                public var nodeId: Swift.String?
                /// Creates a new `LicensePayload`.
                ///
                /// - Parameters:
                ///   - key:
                ///   - name:
                ///   - spdxId:
                ///   - url:
                ///   - nodeId:
                public init(
                    key: Swift.String? = nil,
                    name: Swift.String? = nil,
                    spdxId: Swift.String? = nil,
                    url: Swift.String? = nil,
                    nodeId: Swift.String? = nil
                ) {
                    self.key = key
                    self.name = name
                    self.spdxId = spdxId
                    self.url = url
                    self.nodeId = nodeId
                }
                public enum CodingKeys: String, CodingKey {
                    case key
                    case name
                    case spdxId = "spdx_id"
                    case url
                    case nodeId = "node_id"
                }
            }
            /// - Remark: Generated from `#/components/schemas/minimal-repository/license`.
            public var license: Components.Schemas.MinimalRepository.LicensePayload?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/forks`.
            public var forks: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/open_issues`.
            public var openIssues: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/watchers`.
            public var watchers: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/minimal-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/minimal-repository/custom_properties`.
            public var customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload?
            /// Creates a new `MinimalRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled:
            ///   - visibility:
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - roleName:
            ///   - tempCloneToken:
            ///   - deleteBranchOnMerge:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - codeOfConduct:
            ///   - license:
            ///   - forks:
            ///   - openIssues:
            ///   - watchers:
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String? = nil,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String? = nil,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String? = nil,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String? = nil,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int? = nil,
                stargazersCount: Swift.Int? = nil,
                watchersCount: Swift.Int? = nil,
                size: Swift.Int? = nil,
                defaultBranch: Swift.String? = nil,
                openIssuesCount: Swift.Int? = nil,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool? = nil,
                hasProjects: Swift.Bool? = nil,
                hasWiki: Swift.Bool? = nil,
                hasPages: Swift.Bool? = nil,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool? = nil,
                disabled: Swift.Bool? = nil,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                permissions: Components.Schemas.MinimalRepository.PermissionsPayload? = nil,
                roleName: Swift.String? = nil,
                tempCloneToken: Swift.String? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                subscribersCount: Swift.Int? = nil,
                networkCount: Swift.Int? = nil,
                codeOfConduct: Components.Schemas.CodeOfConduct? = nil,
                license: Components.Schemas.MinimalRepository.LicensePayload? = nil,
                forks: Swift.Int? = nil,
                openIssues: Swift.Int? = nil,
                watchers: Swift.Int? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.MinimalRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.roleName = roleName
                self.tempCloneToken = tempCloneToken
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.codeOfConduct = codeOfConduct
                self.license = license
                self.forks = forks
                self.openIssues = openIssues
                self.watchers = watchers
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case roleName = "role_name"
                case tempCloneToken = "temp_clone_token"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case codeOfConduct = "code_of_conduct"
                case license
                case forks
                case openIssues = "open_issues"
                case watchers
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// An object without any properties.
        ///
        /// - Remark: Generated from `#/components/schemas/empty-object`.
        public struct EmptyObject: Codable, Hashable, Sendable {
            /// Creates a new `EmptyObject`.
            public init() {}
            public init(from decoder: any Decoder) throws {
                try decoder.ensureNoAdditionalProperties(knownKeys: [])
            }
        }
        /// A description of the machine powering a codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine`.
        public struct NullableCodespaceMachine: Codable, Hashable, Sendable {
            /// The name of the machine.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/name`.
            public var name: Swift.String
            /// The display name of the machine includes cores, memory, and storage.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/display_name`.
            public var displayName: Swift.String
            /// The operating system of the machine.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/operating_system`.
            public var operatingSystem: Swift.String
            /// How much storage is available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/storage_in_bytes`.
            public var storageInBytes: Swift.Int
            /// How much memory is available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/memory_in_bytes`.
            public var memoryInBytes: Swift.Int
            /// How many cores are available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/cpus`.
            public var cpus: Swift.Int
            /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/prebuild_availability`.
            @frozen public enum PrebuildAvailabilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case ready = "ready"
                case inProgress = "in_progress"
            }
            /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-codespace-machine/prebuild_availability`.
            public var prebuildAvailability: Components.Schemas.NullableCodespaceMachine.PrebuildAvailabilityPayload?
            /// Creates a new `NullableCodespaceMachine`.
            ///
            /// - Parameters:
            ///   - name: The name of the machine.
            ///   - displayName: The display name of the machine includes cores, memory, and storage.
            ///   - operatingSystem: The operating system of the machine.
            ///   - storageInBytes: How much storage is available to the codespace.
            ///   - memoryInBytes: How much memory is available to the codespace.
            ///   - cpus: How many cores are available to the codespace.
            ///   - prebuildAvailability: Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            public init(
                name: Swift.String,
                displayName: Swift.String,
                operatingSystem: Swift.String,
                storageInBytes: Swift.Int,
                memoryInBytes: Swift.Int,
                cpus: Swift.Int,
                prebuildAvailability: Components.Schemas.NullableCodespaceMachine.PrebuildAvailabilityPayload? = nil
            ) {
                self.name = name
                self.displayName = displayName
                self.operatingSystem = operatingSystem
                self.storageInBytes = storageInBytes
                self.memoryInBytes = memoryInBytes
                self.cpus = cpus
                self.prebuildAvailability = prebuildAvailability
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case displayName = "display_name"
                case operatingSystem = "operating_system"
                case storageInBytes = "storage_in_bytes"
                case memoryInBytes = "memory_in_bytes"
                case cpus
                case prebuildAvailability = "prebuild_availability"
            }
        }
        /// A codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/codespace`.
        public struct Codespace: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/codespace/id`.
            public var id: Swift.Int64
            /// Automatically generated name of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/name`.
            public var name: Swift.String
            /// Display name for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/display_name`.
            public var displayName: Swift.String?
            /// UUID identifying this codespace's environment.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/environment_id`.
            public var environmentId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespace/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/codespace/billable_owner`.
            public var billableOwner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/codespace/repository`.
            public var repository: Components.Schemas.MinimalRepository
            /// - Remark: Generated from `#/components/schemas/codespace/machine`.
            public var machine: Components.Schemas.NullableCodespaceMachine?
            /// Path to devcontainer.json from repo root used to create Codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/devcontainer_path`.
            public var devcontainerPath: Swift.String?
            /// Whether the codespace was created from a prebuild.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/prebuild`.
            public var prebuild: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/codespace/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/codespace/updated_at`.
            public var updatedAt: Foundation.Date
            /// Last known time this codespace was started.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/last_used_at`.
            public var lastUsedAt: Foundation.Date
            /// State of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case unknown = "Unknown"
                case created = "Created"
                case queued = "Queued"
                case provisioning = "Provisioning"
                case available = "Available"
                case awaiting = "Awaiting"
                case unavailable = "Unavailable"
                case deleted = "Deleted"
                case moved = "Moved"
                case shutdown = "Shutdown"
                case archived = "Archived"
                case starting = "Starting"
                case shuttingDown = "ShuttingDown"
                case failed = "Failed"
                case exporting = "Exporting"
                case updating = "Updating"
                case rebuilding = "Rebuilding"
            }
            /// State of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/state`.
            public var state: Components.Schemas.Codespace.StatePayload
            /// API URL for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/url`.
            public var url: Swift.String
            /// Details about the codespace's git repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/git_status`.
            public struct GitStatusPayload: Codable, Hashable, Sendable {
                /// The number of commits the local repository is ahead of the remote.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/git_status/ahead`.
                public var ahead: Swift.Int?
                /// The number of commits the local repository is behind the remote.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/git_status/behind`.
                public var behind: Swift.Int?
                /// Whether the local repository has unpushed changes.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/git_status/has_unpushed_changes`.
                public var hasUnpushedChanges: Swift.Bool?
                /// Whether the local repository has uncommitted changes.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/git_status/has_uncommitted_changes`.
                public var hasUncommittedChanges: Swift.Bool?
                /// The current branch (or SHA if in detached HEAD state) of the local repository.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/git_status/ref`.
                public var ref: Swift.String?
                /// Creates a new `GitStatusPayload`.
                ///
                /// - Parameters:
                ///   - ahead: The number of commits the local repository is ahead of the remote.
                ///   - behind: The number of commits the local repository is behind the remote.
                ///   - hasUnpushedChanges: Whether the local repository has unpushed changes.
                ///   - hasUncommittedChanges: Whether the local repository has uncommitted changes.
                ///   - ref: The current branch (or SHA if in detached HEAD state) of the local repository.
                public init(
                    ahead: Swift.Int? = nil,
                    behind: Swift.Int? = nil,
                    hasUnpushedChanges: Swift.Bool? = nil,
                    hasUncommittedChanges: Swift.Bool? = nil,
                    ref: Swift.String? = nil
                ) {
                    self.ahead = ahead
                    self.behind = behind
                    self.hasUnpushedChanges = hasUnpushedChanges
                    self.hasUncommittedChanges = hasUncommittedChanges
                    self.ref = ref
                }
                public enum CodingKeys: String, CodingKey {
                    case ahead
                    case behind
                    case hasUnpushedChanges = "has_unpushed_changes"
                    case hasUncommittedChanges = "has_uncommitted_changes"
                    case ref
                }
            }
            /// Details about the codespace's git repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/git_status`.
            public var gitStatus: Components.Schemas.Codespace.GitStatusPayload
            /// The initally assigned location of a new codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/location`.
            @frozen public enum LocationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case eastUs = "EastUs"
                case southEastAsia = "SouthEastAsia"
                case westEurope = "WestEurope"
                case westUs2 = "WestUs2"
            }
            /// The initally assigned location of a new codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/location`.
            public var location: Components.Schemas.Codespace.LocationPayload
            /// The number of minutes of inactivity after which this codespace will be automatically stopped.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/idle_timeout_minutes`.
            public var idleTimeoutMinutes: Swift.Int?
            /// URL to access this codespace on the web.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/web_url`.
            public var webUrl: Swift.String
            /// API URL to access available alternate machine types for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/machines_url`.
            public var machinesUrl: Swift.String
            /// API URL to start this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/start_url`.
            public var startUrl: Swift.String
            /// API URL to stop this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/stop_url`.
            public var stopUrl: Swift.String
            /// API URL to publish this codespace to a new repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/publish_url`.
            public var publishUrl: Swift.String?
            /// API URL for the Pull Request associated with this codespace, if any.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/pulls_url`.
            public var pullsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespace/recent_folders`.
            public var recentFolders: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/codespace/runtime_constraints`.
            public struct RuntimeConstraintsPayload: Codable, Hashable, Sendable {
                /// The privacy settings a user can select from when forwarding a port.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace/runtime_constraints/allowed_port_privacy_settings`.
                public var allowedPortPrivacySettings: [Swift.String]?
                /// Creates a new `RuntimeConstraintsPayload`.
                ///
                /// - Parameters:
                ///   - allowedPortPrivacySettings: The privacy settings a user can select from when forwarding a port.
                public init(allowedPortPrivacySettings: [Swift.String]? = nil) {
                    self.allowedPortPrivacySettings = allowedPortPrivacySettings
                }
                public enum CodingKeys: String, CodingKey {
                    case allowedPortPrivacySettings = "allowed_port_privacy_settings"
                }
            }
            /// - Remark: Generated from `#/components/schemas/codespace/runtime_constraints`.
            public var runtimeConstraints: Components.Schemas.Codespace.RuntimeConstraintsPayload?
            /// Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/pending_operation`.
            public var pendingOperation: Swift.Bool?
            /// Text to show user when codespace is disabled by a pending operation
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/pending_operation_disabled_reason`.
            public var pendingOperationDisabledReason: Swift.String?
            /// Text to show user when codespace idle timeout minutes has been overriden by an organization policy
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/idle_timeout_notice`.
            public var idleTimeoutNotice: Swift.String?
            /// Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/retention_period_minutes`.
            public var retentionPeriodMinutes: Swift.Int?
            /// When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/retention_expires_at`.
            public var retentionExpiresAt: Foundation.Date?
            /// The text to display to a user when a codespace has been stopped for a potentially actionable reason.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace/last_known_stop_notice`.
            public var lastKnownStopNotice: Swift.String?
            /// Creates a new `Codespace`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - name: Automatically generated name of this codespace.
            ///   - displayName: Display name for this codespace.
            ///   - environmentId: UUID identifying this codespace's environment.
            ///   - owner:
            ///   - billableOwner:
            ///   - repository:
            ///   - machine:
            ///   - devcontainerPath: Path to devcontainer.json from repo root used to create Codespace.
            ///   - prebuild: Whether the codespace was created from a prebuild.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - lastUsedAt: Last known time this codespace was started.
            ///   - state: State of this codespace.
            ///   - url: API URL for this codespace.
            ///   - gitStatus: Details about the codespace's git repository.
            ///   - location: The initally assigned location of a new codespace.
            ///   - idleTimeoutMinutes: The number of minutes of inactivity after which this codespace will be automatically stopped.
            ///   - webUrl: URL to access this codespace on the web.
            ///   - machinesUrl: API URL to access available alternate machine types for this codespace.
            ///   - startUrl: API URL to start this codespace.
            ///   - stopUrl: API URL to stop this codespace.
            ///   - publishUrl: API URL to publish this codespace to a new repository.
            ///   - pullsUrl: API URL for the Pull Request associated with this codespace, if any.
            ///   - recentFolders:
            ///   - runtimeConstraints:
            ///   - pendingOperation: Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
            ///   - pendingOperationDisabledReason: Text to show user when codespace is disabled by a pending operation
            ///   - idleTimeoutNotice: Text to show user when codespace idle timeout minutes has been overriden by an organization policy
            ///   - retentionPeriodMinutes: Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
            ///   - retentionExpiresAt: When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
            ///   - lastKnownStopNotice: The text to display to a user when a codespace has been stopped for a potentially actionable reason.
            public init(
                id: Swift.Int64,
                name: Swift.String,
                displayName: Swift.String? = nil,
                environmentId: Swift.String? = nil,
                owner: Components.Schemas.SimpleUser,
                billableOwner: Components.Schemas.SimpleUser,
                repository: Components.Schemas.MinimalRepository,
                machine: Components.Schemas.NullableCodespaceMachine? = nil,
                devcontainerPath: Swift.String? = nil,
                prebuild: Swift.Bool? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                lastUsedAt: Foundation.Date,
                state: Components.Schemas.Codespace.StatePayload,
                url: Swift.String,
                gitStatus: Components.Schemas.Codespace.GitStatusPayload,
                location: Components.Schemas.Codespace.LocationPayload,
                idleTimeoutMinutes: Swift.Int? = nil,
                webUrl: Swift.String,
                machinesUrl: Swift.String,
                startUrl: Swift.String,
                stopUrl: Swift.String,
                publishUrl: Swift.String? = nil,
                pullsUrl: Swift.String? = nil,
                recentFolders: [Swift.String],
                runtimeConstraints: Components.Schemas.Codespace.RuntimeConstraintsPayload? = nil,
                pendingOperation: Swift.Bool? = nil,
                pendingOperationDisabledReason: Swift.String? = nil,
                idleTimeoutNotice: Swift.String? = nil,
                retentionPeriodMinutes: Swift.Int? = nil,
                retentionExpiresAt: Foundation.Date? = nil,
                lastKnownStopNotice: Swift.String? = nil
            ) {
                self.id = id
                self.name = name
                self.displayName = displayName
                self.environmentId = environmentId
                self.owner = owner
                self.billableOwner = billableOwner
                self.repository = repository
                self.machine = machine
                self.devcontainerPath = devcontainerPath
                self.prebuild = prebuild
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.lastUsedAt = lastUsedAt
                self.state = state
                self.url = url
                self.gitStatus = gitStatus
                self.location = location
                self.idleTimeoutMinutes = idleTimeoutMinutes
                self.webUrl = webUrl
                self.machinesUrl = machinesUrl
                self.startUrl = startUrl
                self.stopUrl = stopUrl
                self.publishUrl = publishUrl
                self.pullsUrl = pullsUrl
                self.recentFolders = recentFolders
                self.runtimeConstraints = runtimeConstraints
                self.pendingOperation = pendingOperation
                self.pendingOperationDisabledReason = pendingOperationDisabledReason
                self.idleTimeoutNotice = idleTimeoutNotice
                self.retentionPeriodMinutes = retentionPeriodMinutes
                self.retentionExpiresAt = retentionExpiresAt
                self.lastKnownStopNotice = lastKnownStopNotice
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case displayName = "display_name"
                case environmentId = "environment_id"
                case owner
                case billableOwner = "billable_owner"
                case repository
                case machine
                case devcontainerPath = "devcontainer_path"
                case prebuild
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case lastUsedAt = "last_used_at"
                case state
                case url
                case gitStatus = "git_status"
                case location
                case idleTimeoutMinutes = "idle_timeout_minutes"
                case webUrl = "web_url"
                case machinesUrl = "machines_url"
                case startUrl = "start_url"
                case stopUrl = "stop_url"
                case publishUrl = "publish_url"
                case pullsUrl = "pulls_url"
                case recentFolders = "recent_folders"
                case runtimeConstraints = "runtime_constraints"
                case pendingOperation = "pending_operation"
                case pendingOperationDisabledReason = "pending_operation_disabled_reason"
                case idleTimeoutNotice = "idle_timeout_notice"
                case retentionPeriodMinutes = "retention_period_minutes"
                case retentionExpiresAt = "retention_expires_at"
                case lastKnownStopNotice = "last_known_stop_notice"
            }
        }
        /// Secrets for a GitHub Codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/codespaces-org-secret`.
        public struct CodespacesOrgSecret: Codable, Hashable, Sendable {
            /// The name of the secret
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/name`.
            public var name: Swift.String
            /// The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// The type of repositories in the organization that the secret is visible to
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// The type of repositories in the organization that the secret is visible to
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/visibility`.
            public var visibility: Components.Schemas.CodespacesOrgSecret.VisibilityPayload
            /// The API URL at which the list of repositories this secret is visible to can be retrieved
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-org-secret/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String?
            /// Creates a new `CodespacesOrgSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret
            ///   - createdAt: The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - visibility: The type of repositories in the organization that the secret is visible to
            ///   - selectedRepositoriesUrl: The API URL at which the list of repositories this secret is visible to can be retrieved
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                visibility: Components.Schemas.CodespacesOrgSecret.VisibilityPayload,
                selectedRepositoriesUrl: Swift.String? = nil
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.visibility = visibility
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case visibility
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// The public key used for setting Codespaces secrets.
        ///
        /// - Remark: Generated from `#/components/schemas/codespaces-public-key`.
        public struct CodespacesPublicKey: Codable, Hashable, Sendable {
            /// The identifier for the key.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/key_id`.
            public var keyId: Swift.String
            /// The Base64 encoded public key.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/id`.
            public var id: Swift.Int?
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/url`.
            public var url: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/title`.
            public var title: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespaces-public-key/created_at`.
            public var createdAt: Swift.String?
            /// Creates a new `CodespacesPublicKey`.
            ///
            /// - Parameters:
            ///   - keyId: The identifier for the key.
            ///   - key: The Base64 encoded public key.
            ///   - id:
            ///   - url:
            ///   - title:
            ///   - createdAt:
            public init(
                keyId: Swift.String,
                key: Swift.String,
                id: Swift.Int? = nil,
                url: Swift.String? = nil,
                title: Swift.String? = nil,
                createdAt: Swift.String? = nil
            ) {
                self.keyId = keyId
                self.key = key
                self.id = id
                self.url = url
                self.title = title
                self.createdAt = createdAt
            }
            public enum CodingKeys: String, CodingKey {
                case keyId = "key_id"
                case key
                case id
                case url
                case title
                case createdAt = "created_at"
            }
        }
        /// A repository on GitHub.
        ///
        /// - Remark: Generated from `#/components/schemas/nullable-repository`.
        public struct NullableRepository: Codable, Hashable, Sendable {
            /// Unique identifier of the repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/nullable-repository/node_id`.
            public var nodeId: Swift.String
            /// The name of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - pull:
                ///   - triage:
                ///   - push:
                ///   - maintain:
                public init(
                    admin: Swift.Bool,
                    pull: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    push: Swift.Bool,
                    maintain: Swift.Bool? = nil
                ) {
                    self.admin = admin
                    self.pull = pull
                    self.triage = triage
                    self.push = push
                    self.maintain = maintain
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case pull
                    case triage
                    case push
                    case maintain
                }
            }
            /// - Remark: Generated from `#/components/schemas/nullable-repository/permissions`.
            public var permissions: Components.Schemas.NullableRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// Whether the repository is private or public.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/size`.
            public var size: Swift.Int
            /// The default branch of the repository.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// Whether this repository acts as a template that can be used to generate new repositories.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/topics`.
            public var topics: [Swift.String]?
            /// Whether issues are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// Whether projects are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// Whether the wiki is enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// Whether downloads are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_downloads`.
            @available(*, deprecated)
            public var hasDownloads: Swift.Bool
            /// Whether discussions are enabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool?
            /// Whether the repository is archived.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/pushed_at`.
            public var pushedAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/created_at`.
            public var createdAt: Foundation.Date?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/updated_at`.
            public var updatedAt: Foundation.Date?
            /// Whether to allow rebase merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// Whether to allow squash merges for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// Whether to allow Auto-merge to be used on pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// Whether to delete head branches when pull requests are merged
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/use_squash_pr_title_as_default`.
            @available(*, deprecated)
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload?
            /// Whether to allow merge commits for pull requests.
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// Whether to allow forking this repo
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// Whether to require contributors to sign off on web-based commits
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/watchers`.
            public var watchers: Swift.Int
            /// - Remark: Generated from `#/components/schemas/nullable-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/nullable-repository/starred_at`.
            public var starredAt: Swift.String?
            /// Whether anonymous git access is enabled for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public struct CodeSearchIndexStatusPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_search_ok`.
                public var lexicalSearchOk: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status/lexical_commit_sha`.
                public var lexicalCommitSha: Swift.String?
                /// Creates a new `CodeSearchIndexStatusPayload`.
                ///
                /// - Parameters:
                ///   - lexicalSearchOk:
                ///   - lexicalCommitSha:
                public init(
                    lexicalSearchOk: Swift.Bool? = nil,
                    lexicalCommitSha: Swift.String? = nil
                ) {
                    self.lexicalSearchOk = lexicalSearchOk
                    self.lexicalCommitSha = lexicalCommitSha
                }
                public enum CodingKeys: String, CodingKey {
                    case lexicalSearchOk = "lexical_search_ok"
                    case lexicalCommitSha = "lexical_commit_sha"
                }
            }
            /// The status of the code search index for this repository
            ///
            /// - Remark: Generated from `#/components/schemas/nullable-repository/code_search_index_status`.
            public var codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload?
            /// Creates a new `NullableRepository`.
            ///
            /// - Parameters:
            ///   - id: Unique identifier of the repository
            ///   - nodeId:
            ///   - name: The name of the repository.
            ///   - fullName:
            ///   - license:
            ///   - forks:
            ///   - permissions:
            ///   - owner:
            ///   - _private: Whether the repository is private or public.
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch: The default branch of the repository.
            ///   - openIssuesCount:
            ///   - isTemplate: Whether this repository acts as a template that can be used to generate new repositories.
            ///   - topics:
            ///   - hasIssues: Whether issues are enabled.
            ///   - hasProjects: Whether projects are enabled.
            ///   - hasWiki: Whether the wiki is enabled.
            ///   - hasPages:
            ///   - hasDownloads: Whether downloads are enabled.
            ///   - hasDiscussions: Whether discussions are enabled.
            ///   - archived: Whether the repository is archived.
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - allowRebaseMerge: Whether to allow rebase merges for pull requests.
            ///   - tempCloneToken:
            ///   - allowSquashMerge: Whether to allow squash merges for pull requests.
            ///   - allowAutoMerge: Whether to allow Auto-merge to be used on pull requests.
            ///   - deleteBranchOnMerge: Whether to delete head branches when pull requests are merged
            ///   - allowUpdateBranch: Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
            ///   - useSquashPrTitleAsDefault: Whether a squash merge commit can use the pull request title as default. **This property is closing down. Please use `squash_merge_commit_title` instead.
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowMergeCommit: Whether to allow merge commits for pull requests.
            ///   - allowForking: Whether to allow forking this repo
            ///   - webCommitSignoffRequired: Whether to require contributors to sign off on web-based commits
            ///   - openIssues:
            ///   - watchers:
            ///   - masterBranch:
            ///   - starredAt:
            ///   - anonymousAccessEnabled: Whether anonymous git access is enabled for this repository
            ///   - codeSearchIndexStatus: The status of the code search index for this repository
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                forks: Swift.Int,
                permissions: Components.Schemas.NullableRepository.PermissionsPayload? = nil,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool,
                hasDiscussions: Swift.Bool? = nil,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date? = nil,
                createdAt: Foundation.Date? = nil,
                updatedAt: Foundation.Date? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.NullableRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.NullableRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.NullableRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.NullableRepository.MergeCommitMessagePayload? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                masterBranch: Swift.String? = nil,
                starredAt: Swift.String? = nil,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeSearchIndexStatus: Components.Schemas.NullableRepository.CodeSearchIndexStatusPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.license = license
                self.forks = forks
                self.permissions = permissions
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.allowRebaseMerge = allowRebaseMerge
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowMergeCommit = allowMergeCommit
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.openIssues = openIssues
                self.watchers = watchers
                self.masterBranch = masterBranch
                self.starredAt = starredAt
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeSearchIndexStatus = codeSearchIndexStatus
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case license
                case forks
                case permissions
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case allowRebaseMerge = "allow_rebase_merge"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowMergeCommit = "allow_merge_commit"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case openIssues = "open_issues"
                case watchers
                case masterBranch = "master_branch"
                case starredAt = "starred_at"
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeSearchIndexStatus = "code_search_index_status"
            }
        }
        /// Code of Conduct Simple
        ///
        /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple`.
        public struct CodeOfConductSimple: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/key`.
            public var key: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/code-of-conduct-simple/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodeOfConductSimple`.
            ///
            /// - Parameters:
            ///   - url:
            ///   - key:
            ///   - name:
            ///   - htmlUrl:
            public init(
                url: Swift.String,
                key: Swift.String,
                name: Swift.String,
                htmlUrl: Swift.String? = nil
            ) {
                self.url = url
                self.key = key
                self.name = name
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case url
                case key
                case name
                case htmlUrl = "html_url"
            }
        }
        /// Full Repository
        ///
        /// - Remark: Generated from `#/components/schemas/full-repository`.
        public struct FullRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/full-repository/id`.
            public var id: Swift.Int64
            /// - Remark: Generated from `#/components/schemas/full-repository/node_id`.
            public var nodeId: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/full_name`.
            public var fullName: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/full-repository/private`.
            public var _private: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/html_url`.
            public var htmlUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/description`.
            public var description: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/fork`.
            public var fork: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/url`.
            public var url: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/archive_url`.
            public var archiveUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/assignees_url`.
            public var assigneesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/blobs_url`.
            public var blobsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/branches_url`.
            public var branchesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/collaborators_url`.
            public var collaboratorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/comments_url`.
            public var commentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/commits_url`.
            public var commitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/compare_url`.
            public var compareUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contents_url`.
            public var contentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/contributors_url`.
            public var contributorsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/deployments_url`.
            public var deploymentsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/downloads_url`.
            public var downloadsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/events_url`.
            public var eventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_url`.
            public var forksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_commits_url`.
            public var gitCommitsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_refs_url`.
            public var gitRefsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_tags_url`.
            public var gitTagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/git_url`.
            public var gitUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_comment_url`.
            public var issueCommentUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issue_events_url`.
            public var issueEventsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/issues_url`.
            public var issuesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/keys_url`.
            public var keysUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/labels_url`.
            public var labelsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/languages_url`.
            public var languagesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/merges_url`.
            public var mergesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/milestones_url`.
            public var milestonesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/notifications_url`.
            public var notificationsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/pulls_url`.
            public var pullsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/releases_url`.
            public var releasesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/ssh_url`.
            public var sshUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_url`.
            public var stargazersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/statuses_url`.
            public var statusesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_url`.
            public var subscribersUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/subscription_url`.
            public var subscriptionUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/tags_url`.
            public var tagsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/teams_url`.
            public var teamsUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/trees_url`.
            public var treesUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/clone_url`.
            public var cloneUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/mirror_url`.
            public var mirrorUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/hooks_url`.
            public var hooksUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/svn_url`.
            public var svnUrl: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/homepage`.
            public var homepage: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/language`.
            public var language: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks_count`.
            public var forksCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/stargazers_count`.
            public var stargazersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers_count`.
            public var watchersCount: Swift.Int
            /// The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/size`.
            public var size: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/default_branch`.
            public var defaultBranch: Swift.String
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues_count`.
            public var openIssuesCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/is_template`.
            public var isTemplate: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/topics`.
            public var topics: [Swift.String]?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_issues`.
            public var hasIssues: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_projects`.
            public var hasProjects: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_wiki`.
            public var hasWiki: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_pages`.
            public var hasPages: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/has_downloads`.
            public var hasDownloads: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/has_discussions`.
            public var hasDiscussions: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/full-repository/archived`.
            public var archived: Swift.Bool
            /// Returns whether or not this repository disabled.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/disabled`.
            public var disabled: Swift.Bool
            /// The repository visibility: public, private, or internal.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/visibility`.
            public var visibility: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/pushed_at`.
            public var pushedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/updated_at`.
            public var updatedAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public struct PermissionsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/admin`.
                public var admin: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/maintain`.
                public var maintain: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/push`.
                public var push: Swift.Bool
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/triage`.
                public var triage: Swift.Bool?
                /// - Remark: Generated from `#/components/schemas/full-repository/permissions/pull`.
                public var pull: Swift.Bool
                /// Creates a new `PermissionsPayload`.
                ///
                /// - Parameters:
                ///   - admin:
                ///   - maintain:
                ///   - push:
                ///   - triage:
                ///   - pull:
                public init(
                    admin: Swift.Bool,
                    maintain: Swift.Bool? = nil,
                    push: Swift.Bool,
                    triage: Swift.Bool? = nil,
                    pull: Swift.Bool
                ) {
                    self.admin = admin
                    self.maintain = maintain
                    self.push = push
                    self.triage = triage
                    self.pull = pull
                }
                public enum CodingKeys: String, CodingKey {
                    case admin
                    case maintain
                    case push
                    case triage
                    case pull
                }
            }
            /// - Remark: Generated from `#/components/schemas/full-repository/permissions`.
            public var permissions: Components.Schemas.FullRepository.PermissionsPayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_rebase_merge`.
            public var allowRebaseMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/template_repository`.
            public var templateRepository: Components.Schemas.NullableRepository?
            /// - Remark: Generated from `#/components/schemas/full-repository/temp_clone_token`.
            public var tempCloneToken: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_squash_merge`.
            public var allowSquashMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_auto_merge`.
            public var allowAutoMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/delete_branch_on_merge`.
            public var deleteBranchOnMerge: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_merge_commit`.
            public var allowMergeCommit: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_update_branch`.
            public var allowUpdateBranch: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/use_squash_pr_title_as_default`.
            public var useSquashPrTitleAsDefault: Swift.Bool?
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            @frozen public enum SquashMergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case commitOrPrTitle = "COMMIT_OR_PR_TITLE"
            }
            /// The default value for a squash merge commit title:
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_title`.
            public var squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload?
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            @frozen public enum SquashMergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case commitMessages = "COMMIT_MESSAGES"
                case blank = "BLANK"
            }
            /// The default value for a squash merge commit message:
            ///
            /// - `PR_BODY` - default to the pull request's body.
            /// - `COMMIT_MESSAGES` - default to the branch's commit messages.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/squash_merge_commit_message`.
            public var squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload?
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            @frozen public enum MergeCommitTitlePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prTitle = "PR_TITLE"
                case mergeMessage = "MERGE_MESSAGE"
            }
            /// The default value for a merge commit title.
            ///
            ///   - `PR_TITLE` - default to the pull request's title.
            ///   - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_title`.
            public var mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload?
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            @frozen public enum MergeCommitMessagePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case prBody = "PR_BODY"
                case prTitle = "PR_TITLE"
                case blank = "BLANK"
            }
            /// The default value for a merge commit message.
            ///
            /// - `PR_TITLE` - default to the pull request's title.
            /// - `PR_BODY` - default to the pull request's body.
            /// - `BLANK` - default to a blank commit message.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/merge_commit_message`.
            public var mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload?
            /// - Remark: Generated from `#/components/schemas/full-repository/allow_forking`.
            public var allowForking: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/web_commit_signoff_required`.
            public var webCommitSignoffRequired: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/subscribers_count`.
            public var subscribersCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/network_count`.
            public var networkCount: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/license`.
            public var license: Components.Schemas.NullableLicenseSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/organization`.
            public var organization: Components.Schemas.NullableSimpleUser?
            /// - Remark: Generated from `#/components/schemas/full-repository/parent`.
            public var parent: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/source`.
            public var source: Components.Schemas.Repository?
            /// - Remark: Generated from `#/components/schemas/full-repository/forks`.
            public var forks: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/master_branch`.
            public var masterBranch: Swift.String?
            /// - Remark: Generated from `#/components/schemas/full-repository/open_issues`.
            public var openIssues: Swift.Int
            /// - Remark: Generated from `#/components/schemas/full-repository/watchers`.
            public var watchers: Swift.Int
            /// Whether anonymous git access is allowed.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/anonymous_access_enabled`.
            public var anonymousAccessEnabled: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/full-repository/code_of_conduct`.
            public var codeOfConduct: Components.Schemas.CodeOfConductSimple?
            /// - Remark: Generated from `#/components/schemas/full-repository/security_and_analysis`.
            public var securityAndAnalysis: Components.Schemas.SecurityAndAnalysis?
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public struct CustomPropertiesPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
                /// Creates a new `CustomPropertiesPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            ///
            /// - Remark: Generated from `#/components/schemas/full-repository/custom_properties`.
            public var customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload?
            /// Creates a new `FullRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - nodeId:
            ///   - name:
            ///   - fullName:
            ///   - owner:
            ///   - _private:
            ///   - htmlUrl:
            ///   - description:
            ///   - fork:
            ///   - url:
            ///   - archiveUrl:
            ///   - assigneesUrl:
            ///   - blobsUrl:
            ///   - branchesUrl:
            ///   - collaboratorsUrl:
            ///   - commentsUrl:
            ///   - commitsUrl:
            ///   - compareUrl:
            ///   - contentsUrl:
            ///   - contributorsUrl:
            ///   - deploymentsUrl:
            ///   - downloadsUrl:
            ///   - eventsUrl:
            ///   - forksUrl:
            ///   - gitCommitsUrl:
            ///   - gitRefsUrl:
            ///   - gitTagsUrl:
            ///   - gitUrl:
            ///   - issueCommentUrl:
            ///   - issueEventsUrl:
            ///   - issuesUrl:
            ///   - keysUrl:
            ///   - labelsUrl:
            ///   - languagesUrl:
            ///   - mergesUrl:
            ///   - milestonesUrl:
            ///   - notificationsUrl:
            ///   - pullsUrl:
            ///   - releasesUrl:
            ///   - sshUrl:
            ///   - stargazersUrl:
            ///   - statusesUrl:
            ///   - subscribersUrl:
            ///   - subscriptionUrl:
            ///   - tagsUrl:
            ///   - teamsUrl:
            ///   - treesUrl:
            ///   - cloneUrl:
            ///   - mirrorUrl:
            ///   - hooksUrl:
            ///   - svnUrl:
            ///   - homepage:
            ///   - language:
            ///   - forksCount:
            ///   - stargazersCount:
            ///   - watchersCount:
            ///   - size: The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.
            ///   - defaultBranch:
            ///   - openIssuesCount:
            ///   - isTemplate:
            ///   - topics:
            ///   - hasIssues:
            ///   - hasProjects:
            ///   - hasWiki:
            ///   - hasPages:
            ///   - hasDownloads:
            ///   - hasDiscussions:
            ///   - archived:
            ///   - disabled: Returns whether or not this repository disabled.
            ///   - visibility: The repository visibility: public, private, or internal.
            ///   - pushedAt:
            ///   - createdAt:
            ///   - updatedAt:
            ///   - permissions:
            ///   - allowRebaseMerge:
            ///   - templateRepository:
            ///   - tempCloneToken:
            ///   - allowSquashMerge:
            ///   - allowAutoMerge:
            ///   - deleteBranchOnMerge:
            ///   - allowMergeCommit:
            ///   - allowUpdateBranch:
            ///   - useSquashPrTitleAsDefault:
            ///   - squashMergeCommitTitle: The default value for a squash merge commit title:
            ///   - squashMergeCommitMessage: The default value for a squash merge commit message:
            ///   - mergeCommitTitle: The default value for a merge commit title.
            ///   - mergeCommitMessage: The default value for a merge commit message.
            ///   - allowForking:
            ///   - webCommitSignoffRequired:
            ///   - subscribersCount:
            ///   - networkCount:
            ///   - license:
            ///   - organization:
            ///   - parent:
            ///   - source:
            ///   - forks:
            ///   - masterBranch:
            ///   - openIssues:
            ///   - watchers:
            ///   - anonymousAccessEnabled: Whether anonymous git access is allowed.
            ///   - codeOfConduct:
            ///   - securityAndAnalysis:
            ///   - customProperties: The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.
            public init(
                id: Swift.Int64,
                nodeId: Swift.String,
                name: Swift.String,
                fullName: Swift.String,
                owner: Components.Schemas.SimpleUser,
                _private: Swift.Bool,
                htmlUrl: Swift.String,
                description: Swift.String? = nil,
                fork: Swift.Bool,
                url: Swift.String,
                archiveUrl: Swift.String,
                assigneesUrl: Swift.String,
                blobsUrl: Swift.String,
                branchesUrl: Swift.String,
                collaboratorsUrl: Swift.String,
                commentsUrl: Swift.String,
                commitsUrl: Swift.String,
                compareUrl: Swift.String,
                contentsUrl: Swift.String,
                contributorsUrl: Swift.String,
                deploymentsUrl: Swift.String,
                downloadsUrl: Swift.String,
                eventsUrl: Swift.String,
                forksUrl: Swift.String,
                gitCommitsUrl: Swift.String,
                gitRefsUrl: Swift.String,
                gitTagsUrl: Swift.String,
                gitUrl: Swift.String,
                issueCommentUrl: Swift.String,
                issueEventsUrl: Swift.String,
                issuesUrl: Swift.String,
                keysUrl: Swift.String,
                labelsUrl: Swift.String,
                languagesUrl: Swift.String,
                mergesUrl: Swift.String,
                milestonesUrl: Swift.String,
                notificationsUrl: Swift.String,
                pullsUrl: Swift.String,
                releasesUrl: Swift.String,
                sshUrl: Swift.String,
                stargazersUrl: Swift.String,
                statusesUrl: Swift.String,
                subscribersUrl: Swift.String,
                subscriptionUrl: Swift.String,
                tagsUrl: Swift.String,
                teamsUrl: Swift.String,
                treesUrl: Swift.String,
                cloneUrl: Swift.String,
                mirrorUrl: Swift.String? = nil,
                hooksUrl: Swift.String,
                svnUrl: Swift.String,
                homepage: Swift.String? = nil,
                language: Swift.String? = nil,
                forksCount: Swift.Int,
                stargazersCount: Swift.Int,
                watchersCount: Swift.Int,
                size: Swift.Int,
                defaultBranch: Swift.String,
                openIssuesCount: Swift.Int,
                isTemplate: Swift.Bool? = nil,
                topics: [Swift.String]? = nil,
                hasIssues: Swift.Bool,
                hasProjects: Swift.Bool,
                hasWiki: Swift.Bool,
                hasPages: Swift.Bool,
                hasDownloads: Swift.Bool? = nil,
                hasDiscussions: Swift.Bool,
                archived: Swift.Bool,
                disabled: Swift.Bool,
                visibility: Swift.String? = nil,
                pushedAt: Foundation.Date,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                permissions: Components.Schemas.FullRepository.PermissionsPayload? = nil,
                allowRebaseMerge: Swift.Bool? = nil,
                templateRepository: Components.Schemas.NullableRepository? = nil,
                tempCloneToken: Swift.String? = nil,
                allowSquashMerge: Swift.Bool? = nil,
                allowAutoMerge: Swift.Bool? = nil,
                deleteBranchOnMerge: Swift.Bool? = nil,
                allowMergeCommit: Swift.Bool? = nil,
                allowUpdateBranch: Swift.Bool? = nil,
                useSquashPrTitleAsDefault: Swift.Bool? = nil,
                squashMergeCommitTitle: Components.Schemas.FullRepository.SquashMergeCommitTitlePayload? = nil,
                squashMergeCommitMessage: Components.Schemas.FullRepository.SquashMergeCommitMessagePayload? = nil,
                mergeCommitTitle: Components.Schemas.FullRepository.MergeCommitTitlePayload? = nil,
                mergeCommitMessage: Components.Schemas.FullRepository.MergeCommitMessagePayload? = nil,
                allowForking: Swift.Bool? = nil,
                webCommitSignoffRequired: Swift.Bool? = nil,
                subscribersCount: Swift.Int,
                networkCount: Swift.Int,
                license: Components.Schemas.NullableLicenseSimple? = nil,
                organization: Components.Schemas.NullableSimpleUser? = nil,
                parent: Components.Schemas.Repository? = nil,
                source: Components.Schemas.Repository? = nil,
                forks: Swift.Int,
                masterBranch: Swift.String? = nil,
                openIssues: Swift.Int,
                watchers: Swift.Int,
                anonymousAccessEnabled: Swift.Bool? = nil,
                codeOfConduct: Components.Schemas.CodeOfConductSimple? = nil,
                securityAndAnalysis: Components.Schemas.SecurityAndAnalysis? = nil,
                customProperties: Components.Schemas.FullRepository.CustomPropertiesPayload? = nil
            ) {
                self.id = id
                self.nodeId = nodeId
                self.name = name
                self.fullName = fullName
                self.owner = owner
                self._private = _private
                self.htmlUrl = htmlUrl
                self.description = description
                self.fork = fork
                self.url = url
                self.archiveUrl = archiveUrl
                self.assigneesUrl = assigneesUrl
                self.blobsUrl = blobsUrl
                self.branchesUrl = branchesUrl
                self.collaboratorsUrl = collaboratorsUrl
                self.commentsUrl = commentsUrl
                self.commitsUrl = commitsUrl
                self.compareUrl = compareUrl
                self.contentsUrl = contentsUrl
                self.contributorsUrl = contributorsUrl
                self.deploymentsUrl = deploymentsUrl
                self.downloadsUrl = downloadsUrl
                self.eventsUrl = eventsUrl
                self.forksUrl = forksUrl
                self.gitCommitsUrl = gitCommitsUrl
                self.gitRefsUrl = gitRefsUrl
                self.gitTagsUrl = gitTagsUrl
                self.gitUrl = gitUrl
                self.issueCommentUrl = issueCommentUrl
                self.issueEventsUrl = issueEventsUrl
                self.issuesUrl = issuesUrl
                self.keysUrl = keysUrl
                self.labelsUrl = labelsUrl
                self.languagesUrl = languagesUrl
                self.mergesUrl = mergesUrl
                self.milestonesUrl = milestonesUrl
                self.notificationsUrl = notificationsUrl
                self.pullsUrl = pullsUrl
                self.releasesUrl = releasesUrl
                self.sshUrl = sshUrl
                self.stargazersUrl = stargazersUrl
                self.statusesUrl = statusesUrl
                self.subscribersUrl = subscribersUrl
                self.subscriptionUrl = subscriptionUrl
                self.tagsUrl = tagsUrl
                self.teamsUrl = teamsUrl
                self.treesUrl = treesUrl
                self.cloneUrl = cloneUrl
                self.mirrorUrl = mirrorUrl
                self.hooksUrl = hooksUrl
                self.svnUrl = svnUrl
                self.homepage = homepage
                self.language = language
                self.forksCount = forksCount
                self.stargazersCount = stargazersCount
                self.watchersCount = watchersCount
                self.size = size
                self.defaultBranch = defaultBranch
                self.openIssuesCount = openIssuesCount
                self.isTemplate = isTemplate
                self.topics = topics
                self.hasIssues = hasIssues
                self.hasProjects = hasProjects
                self.hasWiki = hasWiki
                self.hasPages = hasPages
                self.hasDownloads = hasDownloads
                self.hasDiscussions = hasDiscussions
                self.archived = archived
                self.disabled = disabled
                self.visibility = visibility
                self.pushedAt = pushedAt
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.permissions = permissions
                self.allowRebaseMerge = allowRebaseMerge
                self.templateRepository = templateRepository
                self.tempCloneToken = tempCloneToken
                self.allowSquashMerge = allowSquashMerge
                self.allowAutoMerge = allowAutoMerge
                self.deleteBranchOnMerge = deleteBranchOnMerge
                self.allowMergeCommit = allowMergeCommit
                self.allowUpdateBranch = allowUpdateBranch
                self.useSquashPrTitleAsDefault = useSquashPrTitleAsDefault
                self.squashMergeCommitTitle = squashMergeCommitTitle
                self.squashMergeCommitMessage = squashMergeCommitMessage
                self.mergeCommitTitle = mergeCommitTitle
                self.mergeCommitMessage = mergeCommitMessage
                self.allowForking = allowForking
                self.webCommitSignoffRequired = webCommitSignoffRequired
                self.subscribersCount = subscribersCount
                self.networkCount = networkCount
                self.license = license
                self.organization = organization
                self.parent = parent
                self.source = source
                self.forks = forks
                self.masterBranch = masterBranch
                self.openIssues = openIssues
                self.watchers = watchers
                self.anonymousAccessEnabled = anonymousAccessEnabled
                self.codeOfConduct = codeOfConduct
                self.securityAndAnalysis = securityAndAnalysis
                self.customProperties = customProperties
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case nodeId = "node_id"
                case name
                case fullName = "full_name"
                case owner
                case _private = "private"
                case htmlUrl = "html_url"
                case description
                case fork
                case url
                case archiveUrl = "archive_url"
                case assigneesUrl = "assignees_url"
                case blobsUrl = "blobs_url"
                case branchesUrl = "branches_url"
                case collaboratorsUrl = "collaborators_url"
                case commentsUrl = "comments_url"
                case commitsUrl = "commits_url"
                case compareUrl = "compare_url"
                case contentsUrl = "contents_url"
                case contributorsUrl = "contributors_url"
                case deploymentsUrl = "deployments_url"
                case downloadsUrl = "downloads_url"
                case eventsUrl = "events_url"
                case forksUrl = "forks_url"
                case gitCommitsUrl = "git_commits_url"
                case gitRefsUrl = "git_refs_url"
                case gitTagsUrl = "git_tags_url"
                case gitUrl = "git_url"
                case issueCommentUrl = "issue_comment_url"
                case issueEventsUrl = "issue_events_url"
                case issuesUrl = "issues_url"
                case keysUrl = "keys_url"
                case labelsUrl = "labels_url"
                case languagesUrl = "languages_url"
                case mergesUrl = "merges_url"
                case milestonesUrl = "milestones_url"
                case notificationsUrl = "notifications_url"
                case pullsUrl = "pulls_url"
                case releasesUrl = "releases_url"
                case sshUrl = "ssh_url"
                case stargazersUrl = "stargazers_url"
                case statusesUrl = "statuses_url"
                case subscribersUrl = "subscribers_url"
                case subscriptionUrl = "subscription_url"
                case tagsUrl = "tags_url"
                case teamsUrl = "teams_url"
                case treesUrl = "trees_url"
                case cloneUrl = "clone_url"
                case mirrorUrl = "mirror_url"
                case hooksUrl = "hooks_url"
                case svnUrl = "svn_url"
                case homepage
                case language
                case forksCount = "forks_count"
                case stargazersCount = "stargazers_count"
                case watchersCount = "watchers_count"
                case size
                case defaultBranch = "default_branch"
                case openIssuesCount = "open_issues_count"
                case isTemplate = "is_template"
                case topics
                case hasIssues = "has_issues"
                case hasProjects = "has_projects"
                case hasWiki = "has_wiki"
                case hasPages = "has_pages"
                case hasDownloads = "has_downloads"
                case hasDiscussions = "has_discussions"
                case archived
                case disabled
                case visibility
                case pushedAt = "pushed_at"
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case permissions
                case allowRebaseMerge = "allow_rebase_merge"
                case templateRepository = "template_repository"
                case tempCloneToken = "temp_clone_token"
                case allowSquashMerge = "allow_squash_merge"
                case allowAutoMerge = "allow_auto_merge"
                case deleteBranchOnMerge = "delete_branch_on_merge"
                case allowMergeCommit = "allow_merge_commit"
                case allowUpdateBranch = "allow_update_branch"
                case useSquashPrTitleAsDefault = "use_squash_pr_title_as_default"
                case squashMergeCommitTitle = "squash_merge_commit_title"
                case squashMergeCommitMessage = "squash_merge_commit_message"
                case mergeCommitTitle = "merge_commit_title"
                case mergeCommitMessage = "merge_commit_message"
                case allowForking = "allow_forking"
                case webCommitSignoffRequired = "web_commit_signoff_required"
                case subscribersCount = "subscribers_count"
                case networkCount = "network_count"
                case license
                case organization
                case parent
                case source
                case forks
                case masterBranch = "master_branch"
                case openIssues = "open_issues"
                case watchers
                case anonymousAccessEnabled = "anonymous_access_enabled"
                case codeOfConduct = "code_of_conduct"
                case securityAndAnalysis = "security_and_analysis"
                case customProperties = "custom_properties"
            }
        }
        /// A description of the machine powering a codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/codespace-machine`.
        public struct CodespaceMachine: Codable, Hashable, Sendable {
            /// The name of the machine.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/name`.
            public var name: Swift.String
            /// The display name of the machine includes cores, memory, and storage.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/display_name`.
            public var displayName: Swift.String
            /// The operating system of the machine.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/operating_system`.
            public var operatingSystem: Swift.String
            /// How much storage is available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/storage_in_bytes`.
            public var storageInBytes: Swift.Int
            /// How much memory is available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/memory_in_bytes`.
            public var memoryInBytes: Swift.Int
            /// How many cores are available to the codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/cpus`.
            public var cpus: Swift.Int
            /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/prebuild_availability`.
            @frozen public enum PrebuildAvailabilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case none = "none"
                case ready = "ready"
                case inProgress = "in_progress"
            }
            /// Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-machine/prebuild_availability`.
            public var prebuildAvailability: Components.Schemas.CodespaceMachine.PrebuildAvailabilityPayload?
            /// Creates a new `CodespaceMachine`.
            ///
            /// - Parameters:
            ///   - name: The name of the machine.
            ///   - displayName: The display name of the machine includes cores, memory, and storage.
            ///   - operatingSystem: The operating system of the machine.
            ///   - storageInBytes: How much storage is available to the codespace.
            ///   - memoryInBytes: How much memory is available to the codespace.
            ///   - cpus: How many cores are available to the codespace.
            ///   - prebuildAvailability: Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
            public init(
                name: Swift.String,
                displayName: Swift.String,
                operatingSystem: Swift.String,
                storageInBytes: Swift.Int,
                memoryInBytes: Swift.Int,
                cpus: Swift.Int,
                prebuildAvailability: Components.Schemas.CodespaceMachine.PrebuildAvailabilityPayload? = nil
            ) {
                self.name = name
                self.displayName = displayName
                self.operatingSystem = operatingSystem
                self.storageInBytes = storageInBytes
                self.memoryInBytes = memoryInBytes
                self.cpus = cpus
                self.prebuildAvailability = prebuildAvailability
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case displayName = "display_name"
                case operatingSystem = "operating_system"
                case storageInBytes = "storage_in_bytes"
                case memoryInBytes = "memory_in_bytes"
                case cpus
                case prebuildAvailability = "prebuild_availability"
            }
        }
        /// Permission check result for a given devcontainer config.
        ///
        /// - Remark: Generated from `#/components/schemas/codespaces-permissions-check-for-devcontainer`.
        public struct CodespacesPermissionsCheckForDevcontainer: Codable, Hashable, Sendable {
            /// Whether the user has accepted the permissions defined by the devcontainer config
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-permissions-check-for-devcontainer/accepted`.
            public var accepted: Swift.Bool
            /// Creates a new `CodespacesPermissionsCheckForDevcontainer`.
            ///
            /// - Parameters:
            ///   - accepted: Whether the user has accepted the permissions defined by the devcontainer config
            public init(accepted: Swift.Bool) {
                self.accepted = accepted
            }
            public enum CodingKeys: String, CodingKey {
                case accepted
            }
        }
        /// Set repository secrets for GitHub Codespaces.
        ///
        /// - Remark: Generated from `#/components/schemas/repo-codespaces-secret`.
        public struct RepoCodespacesSecret: Codable, Hashable, Sendable {
            /// The name of the secret.
            ///
            /// - Remark: Generated from `#/components/schemas/repo-codespaces-secret/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/repo-codespaces-secret/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/repo-codespaces-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// Creates a new `RepoCodespacesSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret.
            ///   - createdAt:
            ///   - updatedAt:
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
            }
        }
        /// Secrets for a GitHub Codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/codespaces-secret`.
        public struct CodespacesSecret: Codable, Hashable, Sendable {
            /// The name of the secret
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/name`.
            public var name: Swift.String
            /// The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/created_at`.
            public var createdAt: Foundation.Date
            /// The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/updated_at`.
            public var updatedAt: Foundation.Date
            /// The type of repositories in the organization that the secret is visible to
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/visibility`.
            @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case all = "all"
                case _private = "private"
                case selected = "selected"
            }
            /// The type of repositories in the organization that the secret is visible to
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/visibility`.
            public var visibility: Components.Schemas.CodespacesSecret.VisibilityPayload
            /// The API URL at which the list of repositories this secret is visible to can be retrieved
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-secret/selected_repositories_url`.
            public var selectedRepositoriesUrl: Swift.String
            /// Creates a new `CodespacesSecret`.
            ///
            /// - Parameters:
            ///   - name: The name of the secret
            ///   - createdAt: The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - updatedAt: The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
            ///   - visibility: The type of repositories in the organization that the secret is visible to
            ///   - selectedRepositoriesUrl: The API URL at which the list of repositories this secret is visible to can be retrieved
            public init(
                name: Swift.String,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                visibility: Components.Schemas.CodespacesSecret.VisibilityPayload,
                selectedRepositoriesUrl: Swift.String
            ) {
                self.name = name
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.visibility = visibility
                self.selectedRepositoriesUrl = selectedRepositoriesUrl
            }
            public enum CodingKeys: String, CodingKey {
                case name
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case visibility
                case selectedRepositoriesUrl = "selected_repositories_url"
            }
        }
        /// The public key used for setting user Codespaces' Secrets.
        ///
        /// - Remark: Generated from `#/components/schemas/codespaces-user-public-key`.
        public struct CodespacesUserPublicKey: Codable, Hashable, Sendable {
            /// The identifier for the key.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-user-public-key/key_id`.
            public var keyId: Swift.String
            /// The Base64 encoded public key.
            ///
            /// - Remark: Generated from `#/components/schemas/codespaces-user-public-key/key`.
            public var key: Swift.String
            /// Creates a new `CodespacesUserPublicKey`.
            ///
            /// - Parameters:
            ///   - keyId: The identifier for the key.
            ///   - key: The Base64 encoded public key.
            public init(
                keyId: Swift.String,
                key: Swift.String
            ) {
                self.keyId = keyId
                self.key = key
            }
            public enum CodingKeys: String, CodingKey {
                case keyId = "key_id"
                case key
            }
        }
        /// An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest
        ///
        /// - Remark: Generated from `#/components/schemas/codespace-export-details`.
        public struct CodespaceExportDetails: Codable, Hashable, Sendable {
            /// State of the latest export
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/state`.
            public var state: Swift.String?
            /// Completion time of the last export operation
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/completed_at`.
            public var completedAt: Foundation.Date?
            /// Name of the exported branch
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/branch`.
            public var branch: Swift.String?
            /// Git commit SHA of the exported branch
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/sha`.
            public var sha: Swift.String?
            /// Id for the export details
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/id`.
            public var id: Swift.String?
            /// Url for fetching export details
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/export_url`.
            public var exportUrl: Swift.String?
            /// Web url for the exported branch
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-export-details/html_url`.
            public var htmlUrl: Swift.String?
            /// Creates a new `CodespaceExportDetails`.
            ///
            /// - Parameters:
            ///   - state: State of the latest export
            ///   - completedAt: Completion time of the last export operation
            ///   - branch: Name of the exported branch
            ///   - sha: Git commit SHA of the exported branch
            ///   - id: Id for the export details
            ///   - exportUrl: Url for fetching export details
            ///   - htmlUrl: Web url for the exported branch
            public init(
                state: Swift.String? = nil,
                completedAt: Foundation.Date? = nil,
                branch: Swift.String? = nil,
                sha: Swift.String? = nil,
                id: Swift.String? = nil,
                exportUrl: Swift.String? = nil,
                htmlUrl: Swift.String? = nil
            ) {
                self.state = state
                self.completedAt = completedAt
                self.branch = branch
                self.sha = sha
                self.id = id
                self.exportUrl = exportUrl
                self.htmlUrl = htmlUrl
            }
            public enum CodingKeys: String, CodingKey {
                case state
                case completedAt = "completed_at"
                case branch
                case sha
                case id
                case exportUrl = "export_url"
                case htmlUrl = "html_url"
            }
        }
        /// A codespace.
        ///
        /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository`.
        public struct CodespaceWithFullRepository: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/id`.
            public var id: Swift.Int64
            /// Automatically generated name of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/name`.
            public var name: Swift.String
            /// Display name for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/display_name`.
            public var displayName: Swift.String?
            /// UUID identifying this codespace's environment.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/environment_id`.
            public var environmentId: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/owner`.
            public var owner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/billable_owner`.
            public var billableOwner: Components.Schemas.SimpleUser
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/repository`.
            public var repository: Components.Schemas.FullRepository
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/machine`.
            public var machine: Components.Schemas.NullableCodespaceMachine?
            /// Path to devcontainer.json from repo root used to create Codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/devcontainer_path`.
            public var devcontainerPath: Swift.String?
            /// Whether the codespace was created from a prebuild.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/prebuild`.
            public var prebuild: Swift.Bool?
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/created_at`.
            public var createdAt: Foundation.Date
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/updated_at`.
            public var updatedAt: Foundation.Date
            /// Last known time this codespace was started.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/last_used_at`.
            public var lastUsedAt: Foundation.Date
            /// State of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/state`.
            @frozen public enum StatePayload: String, Codable, Hashable, Sendable, CaseIterable {
                case unknown = "Unknown"
                case created = "Created"
                case queued = "Queued"
                case provisioning = "Provisioning"
                case available = "Available"
                case awaiting = "Awaiting"
                case unavailable = "Unavailable"
                case deleted = "Deleted"
                case moved = "Moved"
                case shutdown = "Shutdown"
                case archived = "Archived"
                case starting = "Starting"
                case shuttingDown = "ShuttingDown"
                case failed = "Failed"
                case exporting = "Exporting"
                case updating = "Updating"
                case rebuilding = "Rebuilding"
            }
            /// State of this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/state`.
            public var state: Components.Schemas.CodespaceWithFullRepository.StatePayload
            /// API URL for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/url`.
            public var url: Swift.String
            /// Details about the codespace's git repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status`.
            public struct GitStatusPayload: Codable, Hashable, Sendable {
                /// The number of commits the local repository is ahead of the remote.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status/ahead`.
                public var ahead: Swift.Int?
                /// The number of commits the local repository is behind the remote.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status/behind`.
                public var behind: Swift.Int?
                /// Whether the local repository has unpushed changes.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status/has_unpushed_changes`.
                public var hasUnpushedChanges: Swift.Bool?
                /// Whether the local repository has uncommitted changes.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status/has_uncommitted_changes`.
                public var hasUncommittedChanges: Swift.Bool?
                /// The current branch (or SHA if in detached HEAD state) of the local repository.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status/ref`.
                public var ref: Swift.String?
                /// Creates a new `GitStatusPayload`.
                ///
                /// - Parameters:
                ///   - ahead: The number of commits the local repository is ahead of the remote.
                ///   - behind: The number of commits the local repository is behind the remote.
                ///   - hasUnpushedChanges: Whether the local repository has unpushed changes.
                ///   - hasUncommittedChanges: Whether the local repository has uncommitted changes.
                ///   - ref: The current branch (or SHA if in detached HEAD state) of the local repository.
                public init(
                    ahead: Swift.Int? = nil,
                    behind: Swift.Int? = nil,
                    hasUnpushedChanges: Swift.Bool? = nil,
                    hasUncommittedChanges: Swift.Bool? = nil,
                    ref: Swift.String? = nil
                ) {
                    self.ahead = ahead
                    self.behind = behind
                    self.hasUnpushedChanges = hasUnpushedChanges
                    self.hasUncommittedChanges = hasUncommittedChanges
                    self.ref = ref
                }
                public enum CodingKeys: String, CodingKey {
                    case ahead
                    case behind
                    case hasUnpushedChanges = "has_unpushed_changes"
                    case hasUncommittedChanges = "has_uncommitted_changes"
                    case ref
                }
            }
            /// Details about the codespace's git repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/git_status`.
            public var gitStatus: Components.Schemas.CodespaceWithFullRepository.GitStatusPayload
            /// The initally assigned location of a new codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/location`.
            @frozen public enum LocationPayload: String, Codable, Hashable, Sendable, CaseIterable {
                case eastUs = "EastUs"
                case southEastAsia = "SouthEastAsia"
                case westEurope = "WestEurope"
                case westUs2 = "WestUs2"
            }
            /// The initally assigned location of a new codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/location`.
            public var location: Components.Schemas.CodespaceWithFullRepository.LocationPayload
            /// The number of minutes of inactivity after which this codespace will be automatically stopped.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/idle_timeout_minutes`.
            public var idleTimeoutMinutes: Swift.Int?
            /// URL to access this codespace on the web.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/web_url`.
            public var webUrl: Swift.String
            /// API URL to access available alternate machine types for this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/machines_url`.
            public var machinesUrl: Swift.String
            /// API URL to start this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/start_url`.
            public var startUrl: Swift.String
            /// API URL to stop this codespace.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/stop_url`.
            public var stopUrl: Swift.String
            /// API URL to publish this codespace to a new repository.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/publish_url`.
            public var publishUrl: Swift.String?
            /// API URL for the Pull Request associated with this codespace, if any.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/pulls_url`.
            public var pullsUrl: Swift.String?
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/recent_folders`.
            public var recentFolders: [Swift.String]
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/runtime_constraints`.
            public struct RuntimeConstraintsPayload: Codable, Hashable, Sendable {
                /// The privacy settings a user can select from when forwarding a port.
                ///
                /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/runtime_constraints/allowed_port_privacy_settings`.
                public var allowedPortPrivacySettings: [Swift.String]?
                /// Creates a new `RuntimeConstraintsPayload`.
                ///
                /// - Parameters:
                ///   - allowedPortPrivacySettings: The privacy settings a user can select from when forwarding a port.
                public init(allowedPortPrivacySettings: [Swift.String]? = nil) {
                    self.allowedPortPrivacySettings = allowedPortPrivacySettings
                }
                public enum CodingKeys: String, CodingKey {
                    case allowedPortPrivacySettings = "allowed_port_privacy_settings"
                }
            }
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/runtime_constraints`.
            public var runtimeConstraints: Components.Schemas.CodespaceWithFullRepository.RuntimeConstraintsPayload?
            /// Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/pending_operation`.
            public var pendingOperation: Swift.Bool?
            /// Text to show user when codespace is disabled by a pending operation
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/pending_operation_disabled_reason`.
            public var pendingOperationDisabledReason: Swift.String?
            /// Text to show user when codespace idle timeout minutes has been overriden by an organization policy
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/idle_timeout_notice`.
            public var idleTimeoutNotice: Swift.String?
            /// Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/retention_period_minutes`.
            public var retentionPeriodMinutes: Swift.Int?
            /// When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
            ///
            /// - Remark: Generated from `#/components/schemas/codespace-with-full-repository/retention_expires_at`.
            public var retentionExpiresAt: Foundation.Date?
            /// Creates a new `CodespaceWithFullRepository`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - name: Automatically generated name of this codespace.
            ///   - displayName: Display name for this codespace.
            ///   - environmentId: UUID identifying this codespace's environment.
            ///   - owner:
            ///   - billableOwner:
            ///   - repository:
            ///   - machine:
            ///   - devcontainerPath: Path to devcontainer.json from repo root used to create Codespace.
            ///   - prebuild: Whether the codespace was created from a prebuild.
            ///   - createdAt:
            ///   - updatedAt:
            ///   - lastUsedAt: Last known time this codespace was started.
            ///   - state: State of this codespace.
            ///   - url: API URL for this codespace.
            ///   - gitStatus: Details about the codespace's git repository.
            ///   - location: The initally assigned location of a new codespace.
            ///   - idleTimeoutMinutes: The number of minutes of inactivity after which this codespace will be automatically stopped.
            ///   - webUrl: URL to access this codespace on the web.
            ///   - machinesUrl: API URL to access available alternate machine types for this codespace.
            ///   - startUrl: API URL to start this codespace.
            ///   - stopUrl: API URL to stop this codespace.
            ///   - publishUrl: API URL to publish this codespace to a new repository.
            ///   - pullsUrl: API URL for the Pull Request associated with this codespace, if any.
            ///   - recentFolders:
            ///   - runtimeConstraints:
            ///   - pendingOperation: Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
            ///   - pendingOperationDisabledReason: Text to show user when codespace is disabled by a pending operation
            ///   - idleTimeoutNotice: Text to show user when codespace idle timeout minutes has been overriden by an organization policy
            ///   - retentionPeriodMinutes: Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
            ///   - retentionExpiresAt: When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
            public init(
                id: Swift.Int64,
                name: Swift.String,
                displayName: Swift.String? = nil,
                environmentId: Swift.String? = nil,
                owner: Components.Schemas.SimpleUser,
                billableOwner: Components.Schemas.SimpleUser,
                repository: Components.Schemas.FullRepository,
                machine: Components.Schemas.NullableCodespaceMachine? = nil,
                devcontainerPath: Swift.String? = nil,
                prebuild: Swift.Bool? = nil,
                createdAt: Foundation.Date,
                updatedAt: Foundation.Date,
                lastUsedAt: Foundation.Date,
                state: Components.Schemas.CodespaceWithFullRepository.StatePayload,
                url: Swift.String,
                gitStatus: Components.Schemas.CodespaceWithFullRepository.GitStatusPayload,
                location: Components.Schemas.CodespaceWithFullRepository.LocationPayload,
                idleTimeoutMinutes: Swift.Int? = nil,
                webUrl: Swift.String,
                machinesUrl: Swift.String,
                startUrl: Swift.String,
                stopUrl: Swift.String,
                publishUrl: Swift.String? = nil,
                pullsUrl: Swift.String? = nil,
                recentFolders: [Swift.String],
                runtimeConstraints: Components.Schemas.CodespaceWithFullRepository.RuntimeConstraintsPayload? = nil,
                pendingOperation: Swift.Bool? = nil,
                pendingOperationDisabledReason: Swift.String? = nil,
                idleTimeoutNotice: Swift.String? = nil,
                retentionPeriodMinutes: Swift.Int? = nil,
                retentionExpiresAt: Foundation.Date? = nil
            ) {
                self.id = id
                self.name = name
                self.displayName = displayName
                self.environmentId = environmentId
                self.owner = owner
                self.billableOwner = billableOwner
                self.repository = repository
                self.machine = machine
                self.devcontainerPath = devcontainerPath
                self.prebuild = prebuild
                self.createdAt = createdAt
                self.updatedAt = updatedAt
                self.lastUsedAt = lastUsedAt
                self.state = state
                self.url = url
                self.gitStatus = gitStatus
                self.location = location
                self.idleTimeoutMinutes = idleTimeoutMinutes
                self.webUrl = webUrl
                self.machinesUrl = machinesUrl
                self.startUrl = startUrl
                self.stopUrl = stopUrl
                self.publishUrl = publishUrl
                self.pullsUrl = pullsUrl
                self.recentFolders = recentFolders
                self.runtimeConstraints = runtimeConstraints
                self.pendingOperation = pendingOperation
                self.pendingOperationDisabledReason = pendingOperationDisabledReason
                self.idleTimeoutNotice = idleTimeoutNotice
                self.retentionPeriodMinutes = retentionPeriodMinutes
                self.retentionExpiresAt = retentionExpiresAt
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case name
                case displayName = "display_name"
                case environmentId = "environment_id"
                case owner
                case billableOwner = "billable_owner"
                case repository
                case machine
                case devcontainerPath = "devcontainer_path"
                case prebuild
                case createdAt = "created_at"
                case updatedAt = "updated_at"
                case lastUsedAt = "last_used_at"
                case state
                case url
                case gitStatus = "git_status"
                case location
                case idleTimeoutMinutes = "idle_timeout_minutes"
                case webUrl = "web_url"
                case machinesUrl = "machines_url"
                case startUrl = "start_url"
                case stopUrl = "stop_url"
                case publishUrl = "publish_url"
                case pullsUrl = "pulls_url"
                case recentFolders = "recent_folders"
                case runtimeConstraints = "runtime_constraints"
                case pendingOperation = "pending_operation"
                case pendingOperationDisabledReason = "pending_operation_disabled_reason"
                case idleTimeoutNotice = "idle_timeout_notice"
                case retentionPeriodMinutes = "retention_period_minutes"
                case retentionExpiresAt = "retention_expires_at"
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {
        /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/per-page`.
        public typealias PerPage = Swift.Int
        /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
        ///
        /// - Remark: Generated from `#/components/parameters/page`.
        public typealias Page = Swift.Int
        /// The account owner of the repository. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/owner`.
        public typealias Owner = Swift.String
        /// The name of the repository without the `.git` extension. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/repo`.
        public typealias Repo = Swift.String
        /// The organization name. The name is not case sensitive.
        ///
        /// - Remark: Generated from `#/components/parameters/org`.
        public typealias Org = Swift.String
        /// The name of the secret.
        ///
        /// - Remark: Generated from `#/components/parameters/secret-name`.
        public typealias SecretName = Swift.String
        /// The handle for the GitHub user account.
        ///
        /// - Remark: Generated from `#/components/parameters/username`.
        public typealias Username = Swift.String
        /// The name of the codespace.
        ///
        /// - Remark: Generated from `#/components/parameters/codespace-name`.
        public typealias CodespaceName = Swift.String
        /// The number that identifies the pull request.
        ///
        /// - Remark: Generated from `#/components/parameters/pull-number`.
        public typealias PullNumber = Swift.Int
        /// ID of the Repository to filter on
        ///
        /// - Remark: Generated from `#/components/parameters/repository-id-in-query`.
        public typealias RepositoryIdInQuery = Swift.Int
        /// The ID of the export operation, or `latest`. Currently only `latest` is currently supported.
        ///
        /// - Remark: Generated from `#/components/parameters/export-id`.
        public typealias ExportId = Swift.String
    }
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {
        public struct NotFound: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/not_found/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/not_found/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.NotFound.Body
            /// Creates a new `NotFound`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.NotFound.Body) {
                self.body = body
            }
        }
        public struct BadRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/bad_request/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/json",
                                body: self
                            )
                        }
                    }
                }
                /// - Remark: Generated from `#/components/responses/bad_request/content/application\/scim+json`.
                case applicationScimJson(Components.Schemas.ScimError)
                /// The associated value of the enum case if `self` is `.applicationScimJson`.
                ///
                /// - Throws: An error if `self` is not `.applicationScimJson`.
                /// - SeeAlso: `.applicationScimJson`.
                public var applicationScimJson: Components.Schemas.ScimError {
                    get throws {
                        switch self {
                        case let .applicationScimJson(body):
                            return body
                        default:
                            try throwUnexpectedResponseBody(
                                expectedContent: "application/scim+json",
                                body: self
                            )
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.BadRequest.Body
            /// Creates a new `BadRequest`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.BadRequest.Body) {
                self.body = body
            }
        }
        public struct ValidationFailed: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/validation_failed/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/validation_failed/content/application\/json`.
                case json(Components.Schemas.ValidationError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.ValidationError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ValidationFailed.Body
            /// Creates a new `ValidationFailed`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ValidationFailed.Body) {
                self.body = body
            }
        }
        public struct Accepted: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/accepted/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/accepted/content/application\/json`.
                case json(OpenAPIRuntime.OpenAPIObjectContainer)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: OpenAPIRuntime.OpenAPIObjectContainer {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Accepted.Body
            /// Creates a new `Accepted`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Accepted.Body) {
                self.body = body
            }
        }
        public struct NotModified: Sendable, Hashable {
            /// Creates a new `NotModified`.
            public init() {}
        }
        public struct RequiresAuthentication: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/requires_authentication/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/requires_authentication/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.RequiresAuthentication.Body
            /// Creates a new `RequiresAuthentication`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.RequiresAuthentication.Body) {
                self.body = body
            }
        }
        public struct Forbidden: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/forbidden/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/forbidden/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Forbidden.Body
            /// Creates a new `Forbidden`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Forbidden.Body) {
                self.body = body
            }
        }
        public struct InternalError: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/internal_error/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/internal_error/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.InternalError.Body
            /// Creates a new `InternalError`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.InternalError.Body) {
                self.body = body
            }
        }
        public struct Conflict: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/conflict/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/conflict/content/application\/json`.
                case json(Components.Schemas.BasicError)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Schemas.BasicError {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.Conflict.Body
            /// Creates a new `Conflict`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.Conflict.Body) {
                self.body = body
            }
        }
        public struct ServiceUnavailable: Sendable, Hashable {
            /// - Remark: Generated from `#/components/responses/service_unavailable/content`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/code`.
                    public var code: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/message`.
                    public var message: Swift.String?
                    /// - Remark: Generated from `#/components/responses/service_unavailable/content/json/documentation_url`.
                    public var documentationUrl: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - code:
                    ///   - message:
                    ///   - documentationUrl:
                    public init(
                        code: Swift.String? = nil,
                        message: Swift.String? = nil,
                        documentationUrl: Swift.String? = nil
                    ) {
                        self.code = code
                        self.message = message
                        self.documentationUrl = documentationUrl
                    }
                    public enum CodingKeys: String, CodingKey {
                        case code
                        case message
                        case documentationUrl = "documentation_url"
                    }
                }
                /// - Remark: Generated from `#/components/responses/service_unavailable/content/application\/json`.
                case json(Components.Responses.ServiceUnavailable.Body.JsonPayload)
                /// The associated value of the enum case if `self` is `.json`.
                ///
                /// - Throws: An error if `self` is not `.json`.
                /// - SeeAlso: `.json`.
                public var json: Components.Responses.ServiceUnavailable.Body.JsonPayload {
                    get throws {
                        switch self {
                        case let .json(body):
                            return body
                        }
                    }
                }
            }
            /// Received HTTP response body
            public var body: Components.Responses.ServiceUnavailable.Body
            /// Creates a new `ServiceUnavailable`.
            ///
            /// - Parameters:
            ///   - body: Received HTTP response body
            public init(body: Components.Responses.ServiceUnavailable.Body) {
                self.body = body
            }
        }
    }
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {
        /// - Remark: Generated from `#/components/headers/link`.
        public typealias Link = Swift.String
    }
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// List codespaces for the organization
    ///
    /// Lists the codespaces associated to a specified organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)`.
    public enum CodespacesListInOrganization {
        public static let id: Swift.String = "codespaces/list-in-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesListInOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListInOrganization.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListInOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListInOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListInOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListInOrganization.Input.Path,
                query: Operations.CodespacesListInOrganization.Input.Query = .init(),
                headers: Operations.CodespacesListInOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/responses/200/content/json/codespaces`.
                        public var codespaces: [Components.Schemas.Codespace]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - codespaces:
                        public init(
                            totalCount: Swift.Int,
                            codespaces: [Components.Schemas.Codespace]
                        ) {
                            self.totalCount = totalCount
                            self.codespaces = codespaces
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case codespaces
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListInOrganization.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListInOrganization.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListInOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListInOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListInOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListInOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/get(codespaces/list-in-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Manage access control for organization codespaces
    ///
    /// Sets which users can access codespaces in an organization. This is synonymous with granting or revoking codespaces access permissions for users according to the visibility.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/access`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)`.
    public enum CodespacesSetCodespacesAccess {
        public static let id: Swift.String = "codespaces/set-codespaces-access"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesSetCodespacesAccess.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetCodespacesAccess.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetCodespacesAccess.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesSetCodespacesAccess.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Which users can access codespaces in the organization. `disabled` means that no users can access codespaces in the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case disabled = "disabled"
                        case selectedMembers = "selected_members"
                        case allMembers = "all_members"
                        case allMembersAndOutsideCollaborators = "all_members_and_outside_collaborators"
                    }
                    /// Which users can access codespaces in the organization. `disabled` means that no users can access codespaces in the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody/json/visibility`.
                    public var visibility: Operations.CodespacesSetCodespacesAccess.Input.Body.JsonPayload.VisibilityPayload
                    /// The usernames of the organization members who should have access to codespaces in the organization. Required when `visibility` is `selected_members`. The provided list of usernames will replace any existing value.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody/json/selected_usernames`.
                    public var selectedUsernames: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - visibility: Which users can access codespaces in the organization. `disabled` means that no users can access codespaces in the organization.
                    ///   - selectedUsernames: The usernames of the organization members who should have access to codespaces in the organization. Required when `visibility` is `selected_members`. The provided list of usernames will replace any existing value.
                    public init(
                        visibility: Operations.CodespacesSetCodespacesAccess.Input.Body.JsonPayload.VisibilityPayload,
                        selectedUsernames: [Swift.String]? = nil
                    ) {
                        self.visibility = visibility
                        self.selectedUsernames = selectedUsernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case visibility
                        case selectedUsernames = "selected_usernames"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesSetCodespacesAccess.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesSetCodespacesAccess.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesSetCodespacesAccess.Input.Path,
                headers: Operations.CodespacesSetCodespacesAccess.Input.Headers = .init(),
                body: Operations.CodespacesSetCodespacesAccess.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesSetCodespacesAccess.Output.NoContent)
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesSetCodespacesAccess.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// Creates a new `BadRequest`.
                public init() {}
            }
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CodespacesSetCodespacesAccess.Output.BadRequest)
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CodespacesSetCodespacesAccess.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/put(codespaces/set-codespaces-access)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add users to Codespaces access for an organization
    ///
    /// Codespaces for the specified users will be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)`.
    public enum CodespacesSetCodespacesAccessUsers {
        public static let id: Swift.String = "codespaces/set-codespaces-access-users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesSetCodespacesAccessUsers.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetCodespacesAccessUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetCodespacesAccessUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesSetCodespacesAccessUsers.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The usernames of the organization members whose codespaces be billed to the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/requestBody/json/selected_usernames`.
                    public var selectedUsernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedUsernames: The usernames of the organization members whose codespaces be billed to the organization.
                    public init(selectedUsernames: [Swift.String]) {
                        self.selectedUsernames = selectedUsernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedUsernames = "selected_usernames"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/POST/requestBody/content/application\/json`.
                case json(Operations.CodespacesSetCodespacesAccessUsers.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesSetCodespacesAccessUsers.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesSetCodespacesAccessUsers.Input.Path,
                headers: Operations.CodespacesSetCodespacesAccessUsers.Input.Headers = .init(),
                body: Operations.CodespacesSetCodespacesAccessUsers.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesSetCodespacesAccessUsers.Output.NoContent)
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesSetCodespacesAccessUsers.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// Creates a new `BadRequest`.
                public init() {}
            }
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CodespacesSetCodespacesAccessUsers.Output.BadRequest)
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CodespacesSetCodespacesAccessUsers.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/post(codespaces/set-codespaces-access-users)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove users from Codespaces access for an organization
    ///
    /// Codespaces for the specified users will no longer be billed to the organization.
    ///
    /// To use this endpoint, the access settings for the organization must be set to `selected_members`.
    /// For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/access/selected_users`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)`.
    public enum CodespacesDeleteCodespacesAccessUsers {
        public static let id: Swift.String = "codespaces/delete-codespaces-access-users"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteCodespacesAccessUsers.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteCodespacesAccessUsers.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The usernames of the organization members whose codespaces should not be billed to the organization.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/requestBody/json/selected_usernames`.
                    public var selectedUsernames: [Swift.String]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedUsernames: The usernames of the organization members whose codespaces should not be billed to the organization.
                    public init(selectedUsernames: [Swift.String]) {
                        self.selectedUsernames = selectedUsernames
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedUsernames = "selected_usernames"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/access/selected_users/DELETE/requestBody/content/application\/json`.
                case json(Operations.CodespacesDeleteCodespacesAccessUsers.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Path,
                headers: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Headers = .init(),
                body: Operations.CodespacesDeleteCodespacesAccessUsers.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesDeleteCodespacesAccessUsers.Output.NoContent)
            /// Response when successfully modifying permissions.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesDeleteCodespacesAccessUsers.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            public struct BadRequest: Sendable, Hashable {
                /// Creates a new `BadRequest`.
                public init() {}
            }
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Operations.CodespacesDeleteCodespacesAccessUsers.Output.BadRequest)
            /// Users are neither members nor collaborators of this organization.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            public static var badRequest: Self {
                .badRequest(.init())
            }
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Operations.CodespacesDeleteCodespacesAccessUsers.Output.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/access/selected_users/delete(codespaces/delete-codespaces-access-users)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List organization secrets
    ///
    /// Lists all Codespaces development environment secrets available at the organization-level without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/get(codespaces/list-org-secrets)`.
    public enum CodespacesListOrgSecrets {
        public static let id: Swift.String = "codespaces/list-org-secrets"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesListOrgSecrets.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListOrgSecrets.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListOrgSecrets.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListOrgSecrets.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListOrgSecrets.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListOrgSecrets.Input.Path,
                query: Operations.CodespacesListOrgSecrets.Input.Query = .init(),
                headers: Operations.CodespacesListOrgSecrets.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CodespacesListOrgSecrets.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/content/json/secrets`.
                        public var secrets: [Components.Schemas.CodespacesOrgSecret]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - secrets:
                        public init(
                            totalCount: Swift.Int,
                            secrets: [Components.Schemas.CodespacesOrgSecret]
                        ) {
                            self.totalCount = totalCount
                            self.secrets = secrets
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case secrets
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListOrgSecrets.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListOrgSecrets.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListOrgSecrets.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CodespacesListOrgSecrets.Output.Ok.Headers = .init(),
                    body: Operations.CodespacesListOrgSecrets.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/get(codespaces/list-org-secrets)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListOrgSecrets.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListOrgSecrets.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization public key
    ///
    /// Gets a public key for an organization, which is required in order to encrypt secrets. You need to encrypt the value of a secret before you can create or update secrets.
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/public-key/get(codespaces/get-org-public-key)`.
    public enum CodespacesGetOrgPublicKey {
        public static let id: Swift.String = "codespaces/get-org-public-key"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/public-key/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/public-key/GET/path/org`.
                public var org: Components.Parameters.Org
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                public init(org: Components.Parameters.Org) {
                    self.org = org
                }
            }
            public var path: Operations.CodespacesGetOrgPublicKey.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetOrgPublicKey.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetOrgPublicKey.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetOrgPublicKey.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetOrgPublicKey.Input.Path,
                headers: Operations.CodespacesGetOrgPublicKey.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/public-key/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesPublicKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesPublicKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetOrgPublicKey.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetOrgPublicKey.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/public-key/get(codespaces/get-org-public-key)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetOrgPublicKey.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetOrgPublicKey.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get an organization secret
    ///
    /// Gets an organization development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/get(codespaces/get-org-secret)`.
    public enum CodespacesGetOrgSecret {
        public static let id: Swift.String = "codespaces/get-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesGetOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetOrgSecret.Input.Path,
                headers: Operations.CodespacesGetOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CodespacesGetOrgSecret.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesOrgSecret)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesOrgSecret {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetOrgSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CodespacesGetOrgSecret.Output.Ok.Headers = .init(),
                    body: Operations.CodespacesGetOrgSecret.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/get(codespaces/get-org-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetOrgSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetOrgSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create or update an organization secret
    ///
    /// Creates or updates an organization development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)`.
    public enum CodespacesCreateOrUpdateOrgSecret {
        public static let id: Swift.String = "codespaces/create-or-update-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-public-key) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// The ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json/key_id`.
                    public var keyId: Swift.String?
                    /// Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json/visibility`.
                    @frozen public enum VisibilityPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case all = "all"
                        case _private = "private"
                        case selected = "selected"
                    }
                    /// Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json/visibility`.
                    public var visibility: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body.JsonPayload.VisibilityPayload
                    /// An array of repository IDs that can access the organization secret. You can only provide a list of repository IDs when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - encryptedValue: The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-public-key) endpoint.
                    ///   - keyId: The ID of the key you used to encrypt the secret.
                    ///   - visibility: Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.
                    ///   - selectedRepositoryIds: An array of repository IDs that can access the organization secret. You can only provide a list of repository IDs when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    public init(
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String? = nil,
                        visibility: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body.JsonPayload.VisibilityPayload,
                        selectedRepositoryIds: [Swift.Int]? = nil
                    ) {
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                        self.visibility = visibility
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                        case visibility
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Path,
                headers: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Headers = .init(),
                body: Operations.CodespacesCreateOrUpdateOrgSecret.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateOrUpdateOrgSecret.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateOrUpdateOrgSecret.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when creating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateOrUpdateOrgSecret.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateOrUpdateOrgSecret.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesCreateOrUpdateOrgSecret.Output.NoContent)
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesCreateOrUpdateOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-org-secret)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an organization secret
    ///
    /// Deletes an organization development environment secret using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)`.
    public enum CodespacesDeleteOrgSecret {
        public static let id: Swift.String = "codespaces/delete-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesDeleteOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesDeleteOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesDeleteOrgSecret.Input.Path,
                headers: Operations.CodespacesDeleteOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesDeleteOrgSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesDeleteOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/delete(codespaces/delete-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List selected repositories for an organization secret
    ///
    /// Lists all repositories that have been selected when the `visibility`
    /// for repository access to a secret is set to `selected`.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-selected-repos-for-org-secret)`.
    public enum CodespacesListSelectedReposForOrgSecret {
        public static let id: Swift.String = "codespaces/list-selected-repos-for-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesListSelectedReposForOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    page: Components.Parameters.Page? = nil,
                    perPage: Components.Parameters.PerPage? = nil
                ) {
                    self.page = page
                    self.perPage = perPage
                }
            }
            public var query: Operations.CodespacesListSelectedReposForOrgSecret.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListSelectedReposForOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListSelectedReposForOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListSelectedReposForOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListSelectedReposForOrgSecret.Input.Path,
                query: Operations.CodespacesListSelectedReposForOrgSecret.Input.Query = .init(),
                headers: Operations.CodespacesListSelectedReposForOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.MinimalRepository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Int,
                            repositories: [Components.Schemas.MinimalRepository]
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-selected-repos-for-org-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListSelectedReposForOrgSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-selected-repos-for-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set selected repositories for an organization secret
    ///
    /// Replaces all repositories for an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)`.
    public enum CodespacesSetSelectedReposForOrgSecret {
        public static let id: Swift.String = "codespaces/set-selected-repos-for-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.org = org
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetSelectedReposForOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetSelectedReposForOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Headers
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.
                    public init(selectedRepositoryIds: [Swift.Int]) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesSetSelectedReposForOrgSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Path,
                headers: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Headers = .init(),
                body: Operations.CodespacesSetSelectedReposForOrgSecret.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesSetSelectedReposForOrgSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesSetSelectedReposForOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.CodespacesSetSelectedReposForOrgSecret.Output.Conflict)
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-selected-repos-for-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.CodespacesSetSelectedReposForOrgSecret.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add selected repository to an organization secret
    ///
    /// Adds a repository to an organization development environment secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)`.
    public enum CodespacesAddSelectedRepoToOrgSecret {
        public static let id: Swift.String = "codespaces/add-selected-repo-to-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.org = org
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesAddSelectedRepoToOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesAddSelectedRepoToOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Path,
                headers: Operations.CodespacesAddSelectedRepoToOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesAddSelectedRepoToOrgSecret.Output.NoContent)
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesAddSelectedRepoToOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Conflict when visibility type is not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.CodespacesAddSelectedRepoToOrgSecret.Output.Conflict)
            /// Conflict when visibility type is not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.CodespacesAddSelectedRepoToOrgSecret.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-selected-repo-to-org-secret)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove selected repository from an organization secret
    ///
    /// Removes a repository from an organization development environment secret when the `visibility`
    /// for repository access is set to `selected`. The visibility is set when you [Create
    /// or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)`.
    public enum CodespacesRemoveSelectedRepoFromOrgSecret {
        public static let id: Swift.String = "codespaces/remove-selected-repo-from-org-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    org: Components.Parameters.Org,
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.org = org
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRemoveSelectedRepoFromOrgSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRemoveSelectedRepoFromOrgSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Path,
                headers: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output.NoContent)
            /// Response when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            public struct Conflict: Sendable, Hashable {
                /// Creates a new `Conflict`.
                public init() {}
            }
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output.Conflict)
            /// Conflict when visibility type not set to selected
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            public static var conflict: Self {
                .conflict(.init())
            }
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Operations.CodespacesRemoveSelectedRepoFromOrgSecret.Output.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-selected-repo-from-org-secret)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List codespaces for a user in organization
    ///
    /// Lists the codespaces that a member of an organization has for repositories in that organization.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /orgs/{org}/members/{username}/codespaces`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)`.
    public enum CodespacesGetCodespacesForUserInOrg {
        public static let id: Swift.String = "codespaces/get-codespaces-for-user-in-org"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/path/username`.
                public var username: Components.Parameters.Username
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username
                ) {
                    self.org = org
                    self.username = username
                }
            }
            public var path: Operations.CodespacesGetCodespacesForUserInOrg.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesGetCodespacesForUserInOrg.Input.Query
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetCodespacesForUserInOrg.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetCodespacesForUserInOrg.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetCodespacesForUserInOrg.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetCodespacesForUserInOrg.Input.Path,
                query: Operations.CodespacesGetCodespacesForUserInOrg.Input.Query = .init(),
                headers: Operations.CodespacesGetCodespacesForUserInOrg.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/responses/200/content/json/codespaces`.
                        public var codespaces: [Components.Schemas.Codespace]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - codespaces:
                        public init(
                            totalCount: Swift.Int,
                            codespaces: [Components.Schemas.Codespace]
                        ) {
                            self.totalCount = totalCount
                            self.codespaces = codespaces
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case codespaces
                        }
                    }
                    /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetCodespacesForUserInOrg.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/get(codespaces/get-codespaces-for-user-in-org)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a codespace from the organization
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /orgs/{org}/members/{username}/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)`.
    public enum CodespacesDeleteFromOrganization {
        public static let id: Swift.String = "codespaces/delete-from-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/DELETE/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/DELETE/path/username`.
                public var username: Components.Parameters.Username
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/DELETE/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                ///   - codespaceName: The name of the codespace.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username,
                    codespaceName: Components.Parameters.CodespaceName
                ) {
                    self.org = org
                    self.username = username
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesDeleteFromOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteFromOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteFromOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesDeleteFromOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesDeleteFromOrganization.Input.Path,
                headers: Operations.CodespacesDeleteFromOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/delete(codespaces/delete-from-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Stop a codespace for an organization user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /orgs/{org}/members/{username}/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)`.
    public enum CodespacesStopInOrganization {
        public static let id: Swift.String = "codespaces/stop-in-organization"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The organization name. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/path/org`.
                public var org: Components.Parameters.Org
                /// The handle for the GitHub user account.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/path/username`.
                public var username: Components.Parameters.Username
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - org: The organization name. The name is not case sensitive.
                ///   - username: The handle for the GitHub user account.
                ///   - codespaceName: The name of the codespace.
                public init(
                    org: Components.Parameters.Org,
                    username: Components.Parameters.Username,
                    codespaceName: Components.Parameters.CodespaceName
                ) {
                    self.org = org
                    self.username = username
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesStopInOrganization.Input.Path
            /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStopInOrganization.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStopInOrganization.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesStopInOrganization.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesStopInOrganization.Input.Path,
                headers: Operations.CodespacesStopInOrganization.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesStopInOrganization.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesStopInOrganization.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesStopInOrganization.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesStopInOrganization.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//orgs/{org}/members/{username}/codespaces/{codespace_name}/stop/post(codespaces/stop-in-organization)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List codespaces in a repository for the authenticated user
    ///
    /// Lists the codespaces associated to a specified repository and the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)`.
    public enum CodespacesListInRepositoryForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/list-in-repository-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListInRepositoryForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListInRepositoryForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Path,
                query: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesListInRepositoryForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/responses/200/content/json/codespaces`.
                        public var codespaces: [Components.Schemas.Codespace]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - codespaces:
                        public init(
                            totalCount: Swift.Int,
                            codespaces: [Components.Schemas.Codespace]
                        ) {
                            self.totalCount = totalCount
                            self.codespaces = codespaces
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case codespaces
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListInRepositoryForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/get(codespaces/list-in-repository-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a codespace in a repository
    ///
    /// Creates a codespace owned by the authenticated user in the specified repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)`.
    public enum CodespacesCreateWithRepoForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/create-with-repo-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateWithRepoForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateWithRepoForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Git ref (typically a branch name) for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/ref`.
                    public var ref: Swift.String?
                    /// The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/location`.
                    public var location: Swift.String?
                    /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/geo`.
                    @frozen public enum GeoPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case europeWest = "EuropeWest"
                        case southeastAsia = "SoutheastAsia"
                        case usEast = "UsEast"
                        case usWest = "UsWest"
                    }
                    /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/geo`.
                    public var geo: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body.JsonPayload.GeoPayload?
                    /// IP for location auto-detection when proxying a request
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/client_ip`.
                    public var clientIp: Swift.String?
                    /// Machine type to use for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/machine`.
                    public var machine: Swift.String?
                    /// Path to devcontainer.json config to use for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/devcontainer_path`.
                    public var devcontainerPath: Swift.String?
                    /// Whether to authorize requested permissions from devcontainer.json
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/multi_repo_permissions_opt_out`.
                    public var multiRepoPermissionsOptOut: Swift.Bool?
                    /// Working directory for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/working_directory`.
                    public var workingDirectory: Swift.String?
                    /// Time in minutes before codespace stops from inactivity
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/idle_timeout_minutes`.
                    public var idleTimeoutMinutes: Swift.Int?
                    /// Display name for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/display_name`.
                    public var displayName: Swift.String?
                    /// Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/json/retention_period_minutes`.
                    public var retentionPeriodMinutes: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - ref: Git ref (typically a branch name) for this codespace
                    ///   - location: The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                    ///   - geo: The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///   - clientIp: IP for location auto-detection when proxying a request
                    ///   - machine: Machine type to use for this codespace
                    ///   - devcontainerPath: Path to devcontainer.json config to use for this codespace
                    ///   - multiRepoPermissionsOptOut: Whether to authorize requested permissions from devcontainer.json
                    ///   - workingDirectory: Working directory for this codespace
                    ///   - idleTimeoutMinutes: Time in minutes before codespace stops from inactivity
                    ///   - displayName: Display name for this codespace
                    ///   - retentionPeriodMinutes: Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                    public init(
                        ref: Swift.String? = nil,
                        location: Swift.String? = nil,
                        geo: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body.JsonPayload.GeoPayload? = nil,
                        clientIp: Swift.String? = nil,
                        machine: Swift.String? = nil,
                        devcontainerPath: Swift.String? = nil,
                        multiRepoPermissionsOptOut: Swift.Bool? = nil,
                        workingDirectory: Swift.String? = nil,
                        idleTimeoutMinutes: Swift.Int? = nil,
                        displayName: Swift.String? = nil,
                        retentionPeriodMinutes: Swift.Int? = nil
                    ) {
                        self.ref = ref
                        self.location = location
                        self.geo = geo
                        self.clientIp = clientIp
                        self.machine = machine
                        self.devcontainerPath = devcontainerPath
                        self.multiRepoPermissionsOptOut = multiRepoPermissionsOptOut
                        self.workingDirectory = workingDirectory
                        self.idleTimeoutMinutes = idleTimeoutMinutes
                        self.displayName = displayName
                        self.retentionPeriodMinutes = retentionPeriodMinutes
                    }
                    public enum CodingKeys: String, CodingKey {
                        case ref
                        case location
                        case geo
                        case clientIp = "client_ip"
                        case machine
                        case devcontainerPath = "devcontainer_path"
                        case multiRepoPermissionsOptOut = "multi_repo_permissions_opt_out"
                        case workingDirectory = "working_directory"
                        case idleTimeoutMinutes = "idle_timeout_minutes"
                        case displayName = "display_name"
                        case retentionPeriodMinutes = "retention_period_minutes"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace was successfully created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace creation partially failed but is being retried in the background
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodespacesCreateWithRepoForAuthenticatedUser.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/post(codespaces/create-with-repo-for-authenticated-user)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List devcontainer configurations in a repository for the authenticated user
    ///
    /// Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
    /// specify launchpoint configurations for codespaces created within the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/devcontainers`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)`.
    public enum CodespacesListDevcontainersInRepositoryForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/list-devcontainers-in-repository-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Path,
                query: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/DevcontainersPayload`.
                        public struct DevcontainersPayloadPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/DevcontainersPayload/path`.
                            public var path: Swift.String
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/DevcontainersPayload/name`.
                            public var name: Swift.String?
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/DevcontainersPayload/display_name`.
                            public var displayName: Swift.String?
                            /// Creates a new `DevcontainersPayloadPayload`.
                            ///
                            /// - Parameters:
                            ///   - path:
                            ///   - name:
                            ///   - displayName:
                            public init(
                                path: Swift.String,
                                name: Swift.String? = nil,
                                displayName: Swift.String? = nil
                            ) {
                                self.path = path
                                self.name = name
                                self.displayName = displayName
                            }
                            public enum CodingKeys: String, CodingKey {
                                case path
                                case name
                                case displayName = "display_name"
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/devcontainers`.
                        public typealias DevcontainersPayload = [Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload.DevcontainersPayloadPayload]
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/json/devcontainers`.
                        public var devcontainers: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload.DevcontainersPayload
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - devcontainers:
                        public init(
                            totalCount: Swift.Int,
                            devcontainers: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload.DevcontainersPayload
                        ) {
                            self.totalCount = totalCount
                            self.devcontainers = devcontainers
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case devcontainers
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/devcontainers/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListDevcontainersInRepositoryForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/devcontainers/get(codespaces/list-devcontainers-in-repository-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// List available machine types for a repository
    ///
    /// List the machine types available for a given repository based on its configuration.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/machines`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)`.
    public enum CodespacesRepoMachinesForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/repo-machines-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The location to check for available machines. Assigned by IP if not provided.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/query/location`.
                public var location: Swift.String?
                /// IP for location auto-detection when proxying a request
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/query/client_ip`.
                public var clientIp: Swift.String?
                /// The branch or commit to check for prebuild availability and devcontainer restrictions.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/query/ref`.
                public var ref: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - location: The location to check for available machines. Assigned by IP if not provided.
                ///   - clientIp: IP for location auto-detection when proxying a request
                ///   - ref: The branch or commit to check for prebuild availability and devcontainer restrictions.
                public init(
                    location: Swift.String? = nil,
                    clientIp: Swift.String? = nil,
                    ref: Swift.String? = nil
                ) {
                    self.location = location
                    self.clientIp = clientIp
                    self.ref = ref
                }
            }
            public var query: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRepoMachinesForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRepoMachinesForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Path,
                query: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesRepoMachinesForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/responses/200/content/json/machines`.
                        public var machines: [Components.Schemas.CodespaceMachine]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - machines:
                        public init(
                            totalCount: Swift.Int,
                            machines: [Components.Schemas.CodespaceMachine]
                        ) {
                            self.totalCount = totalCount
                            self.machines = machines
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case machines
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/machines/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesRepoMachinesForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/machines/get(codespaces/repo-machines-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get default attributes for a codespace
    ///
    /// Gets the default attributes for codespaces created by the user with the repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/new`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)`.
    public enum CodespacesPreFlightWithRepoForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/pre-flight-with-repo-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The branch or commit to check for a default devcontainer path. If not specified, the default branch will be checked.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/query/ref`.
                public var ref: Swift.String?
                /// An alternative IP for default location auto-detection, such as when proxying a request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/query/client_ip`.
                public var clientIp: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - ref: The branch or commit to check for a default devcontainer path. If not specified, the default branch will be checked.
                ///   - clientIp: An alternative IP for default location auto-detection, such as when proxying a request.
                public init(
                    ref: Swift.String? = nil,
                    clientIp: Swift.String? = nil
                ) {
                    self.ref = ref
                    self.clientIp = clientIp
                }
            }
            public var query: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Path,
                query: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json/billable_owner`.
                        public var billableOwner: Components.Schemas.SimpleUser?
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json/defaults`.
                        public struct DefaultsPayload: Codable, Hashable, Sendable {
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json/defaults/location`.
                            public var location: Swift.String
                            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json/defaults/devcontainer_path`.
                            public var devcontainerPath: Swift.String?
                            /// Creates a new `DefaultsPayload`.
                            ///
                            /// - Parameters:
                            ///   - location:
                            ///   - devcontainerPath:
                            public init(
                                location: Swift.String,
                                devcontainerPath: Swift.String? = nil
                            ) {
                                self.location = location
                                self.devcontainerPath = devcontainerPath
                            }
                            public enum CodingKeys: String, CodingKey {
                                case location
                                case devcontainerPath = "devcontainer_path"
                            }
                        }
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/json/defaults`.
                        public var defaults: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body.JsonPayload.DefaultsPayload?
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - billableOwner:
                        ///   - defaults:
                        public init(
                            billableOwner: Components.Schemas.SimpleUser? = nil,
                            defaults: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body.JsonPayload.DefaultsPayload? = nil
                        ) {
                            self.billableOwner = billableOwner
                            self.defaults = defaults
                        }
                        public enum CodingKeys: String, CodingKey {
                            case billableOwner = "billable_owner"
                            case defaults
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/new/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when a user is able to create codespaces from the repository.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesPreFlightWithRepoForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/new/get(codespaces/pre-flight-with-repo-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Check if permissions defined by a devcontainer have been accepted by the authenticated user
    ///
    /// Checks whether the permissions defined by a given devcontainer configuration have been accepted by the authenticated user.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/permissions_check`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)`.
    public enum CodespacesCheckPermissionsForDevcontainer {
        public static let id: Swift.String = "codespaces/check-permissions-for-devcontainer"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The git reference that points to the location of the devcontainer configuration to use for the permission check. The value of `ref` will typically be a branch name (`heads/BRANCH_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/query/ref`.
                public var ref: Swift.String
                /// Path to the devcontainer.json configuration to use for the permission check.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/query/devcontainer_path`.
                public var devcontainerPath: Swift.String
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - ref: The git reference that points to the location of the devcontainer configuration to use for the permission check. The value of `ref` will typically be a branch name (`heads/BRANCH_NAME`). For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.
                ///   - devcontainerPath: Path to the devcontainer.json configuration to use for the permission check.
                public init(
                    ref: Swift.String,
                    devcontainerPath: Swift.String
                ) {
                    self.ref = ref
                    self.devcontainerPath = devcontainerPath
                }
            }
            public var query: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCheckPermissionsForDevcontainer.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCheckPermissionsForDevcontainer.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Path,
                query: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Query,
                headers: Operations.CodespacesCheckPermissionsForDevcontainer.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/permissions_check/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesPermissionsCheckForDevcontainer)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesPermissionsCheckForDevcontainer {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCheckPermissionsForDevcontainer.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCheckPermissionsForDevcontainer.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response when the permission check is successful
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesCheckPermissionsForDevcontainer.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesCheckPermissionsForDevcontainer.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/permissions_check/get(codespaces/check-permissions-for-devcontainer)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List repository secrets
    ///
    /// Lists all development environment secrets available in a repository without revealing their encrypted
    /// values.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/get(codespaces/list-repo-secrets)`.
    public enum CodespacesListRepoSecrets {
        public static let id: Swift.String = "codespaces/list-repo-secrets"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesListRepoSecrets.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListRepoSecrets.Input.Query
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListRepoSecrets.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListRepoSecrets.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListRepoSecrets.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.CodespacesListRepoSecrets.Input.Path,
                query: Operations.CodespacesListRepoSecrets.Input.Query = .init(),
                headers: Operations.CodespacesListRepoSecrets.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CodespacesListRepoSecrets.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/content/json/secrets`.
                        public var secrets: [Components.Schemas.RepoCodespacesSecret]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - secrets:
                        public init(
                            totalCount: Swift.Int,
                            secrets: [Components.Schemas.RepoCodespacesSecret]
                        ) {
                            self.totalCount = totalCount
                            self.secrets = secrets
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case secrets
                        }
                    }
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListRepoSecrets.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListRepoSecrets.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListRepoSecrets.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CodespacesListRepoSecrets.Output.Ok.Headers = .init(),
                    body: Operations.CodespacesListRepoSecrets.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/get(codespaces/list-repo-secrets)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListRepoSecrets.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListRepoSecrets.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository public key
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to
    /// encrypt a secret before you can create or update secrets.
    ///
    /// If the repository is private, OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/public-key/get(codespaces/get-repo-public-key)`.
    public enum CodespacesGetRepoPublicKey {
        public static let id: Swift.String = "codespaces/get-repo-public-key"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo
                ) {
                    self.owner = owner
                    self.repo = repo
                }
            }
            public var path: Operations.CodespacesGetRepoPublicKey.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetRepoPublicKey.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetRepoPublicKey.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetRepoPublicKey.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetRepoPublicKey.Input.Path,
                headers: Operations.CodespacesGetRepoPublicKey.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/public-key/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesPublicKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesPublicKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetRepoPublicKey.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetRepoPublicKey.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/public-key/get(codespaces/get-repo-public-key)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetRepoPublicKey.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetRepoPublicKey.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a repository secret
    ///
    /// Gets a single repository development environment secret without revealing its encrypted value.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/get(codespaces/get-repo-secret)`.
    public enum CodespacesGetRepoSecret {
        public static let id: Swift.String = "codespaces/get-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesGetRepoSecret.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetRepoSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetRepoSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetRepoSecret.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetRepoSecret.Input.Path,
                headers: Operations.CodespacesGetRepoSecret.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RepoCodespacesSecret)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RepoCodespacesSecret {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetRepoSecret.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetRepoSecret.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/get(codespaces/get-repo-secret)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetRepoSecret.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetRepoSecret.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create or update a repository secret
    ///
    /// Creates or updates a repository development environment secret with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `PUT /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)`.
    public enum CodespacesCreateOrUpdateRepoSecret {
        public static let id: Swift.String = "codespaces/create-or-update-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateRepoSecret.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateRepoSecret.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-public-key) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/requestBody/json/key_id`.
                    public var keyId: Swift.String?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - encryptedValue: Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-public-key) endpoint.
                    ///   - keyId: ID of the key you used to encrypt the secret.
                    public init(
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String? = nil
                    ) {
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                    }
                    public enum CodingKeys: String, CodingKey {
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateOrUpdateRepoSecret.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Path,
                headers: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Headers = .init(),
                body: Operations.CodespacesCreateOrUpdateRepoSecret.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateOrUpdateRepoSecret.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateOrUpdateRepoSecret.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when creating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateOrUpdateRepoSecret.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateOrUpdateRepoSecret.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesCreateOrUpdateRepoSecret.Output.NoContent)
            /// Response when updating a secret
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesCreateOrUpdateRepoSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a repository secret
    ///
    /// Deletes a development environment secret in a repository using the secret name.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.
    ///
    /// - Remark: HTTP `DELETE /repos/{owner}/{repo}/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/delete(codespaces/delete-repo-secret)`.
    public enum CodespacesDeleteRepoSecret {
        public static let id: Swift.String = "codespaces/delete-repo-secret"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/DELETE/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/DELETE/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/codespaces/secrets/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - secretName: The name of the secret.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    secretName: Components.Parameters.SecretName
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesDeleteRepoSecret.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.CodespacesDeleteRepoSecret.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/delete(codespaces/delete-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesDeleteRepoSecret.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/codespaces/secrets/{secret_name}/delete(codespaces/delete-repo-secret)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesDeleteRepoSecret.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// Create a codespace from a pull request
    ///
    /// Creates a codespace owned by the authenticated user for the specified pull request.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /repos/{owner}/{repo}/pulls/{pull_number}/codespaces`.
    /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)`.
    public enum CodespacesCreateWithPrForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/create-with-pr-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The account owner of the repository. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/path/owner`.
                public var owner: Components.Parameters.Owner
                /// The name of the repository without the `.git` extension. The name is not case sensitive.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/path/repo`.
                public var repo: Components.Parameters.Repo
                /// The number that identifies the pull request.
                ///
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/path/pull_number`.
                public var pullNumber: Components.Parameters.PullNumber
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - owner: The account owner of the repository. The name is not case sensitive.
                ///   - repo: The name of the repository without the `.git` extension. The name is not case sensitive.
                ///   - pullNumber: The number that identifies the pull request.
                public init(
                    owner: Components.Parameters.Owner,
                    repo: Components.Parameters.Repo,
                    pullNumber: Components.Parameters.PullNumber
                ) {
                    self.owner = owner
                    self.repo = repo
                    self.pullNumber = pullNumber
                }
            }
            public var path: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateWithPrForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateWithPrForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/location`.
                    public var location: Swift.String?
                    /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/geo`.
                    @frozen public enum GeoPayload: String, Codable, Hashable, Sendable, CaseIterable {
                        case europeWest = "EuropeWest"
                        case southeastAsia = "SoutheastAsia"
                        case usEast = "UsEast"
                        case usWest = "UsWest"
                    }
                    /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/geo`.
                    public var geo: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body.JsonPayload.GeoPayload?
                    /// IP for location auto-detection when proxying a request
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/client_ip`.
                    public var clientIp: Swift.String?
                    /// Machine type to use for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/machine`.
                    public var machine: Swift.String?
                    /// Path to devcontainer.json config to use for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/devcontainer_path`.
                    public var devcontainerPath: Swift.String?
                    /// Whether to authorize requested permissions from devcontainer.json
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/multi_repo_permissions_opt_out`.
                    public var multiRepoPermissionsOptOut: Swift.Bool?
                    /// Working directory for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/working_directory`.
                    public var workingDirectory: Swift.String?
                    /// Time in minutes before codespace stops from inactivity
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/idle_timeout_minutes`.
                    public var idleTimeoutMinutes: Swift.Int?
                    /// Display name for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/display_name`.
                    public var displayName: Swift.String?
                    /// Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                    ///
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/json/retention_period_minutes`.
                    public var retentionPeriodMinutes: Swift.Int?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - location: The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                    ///   - geo: The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                    ///   - clientIp: IP for location auto-detection when proxying a request
                    ///   - machine: Machine type to use for this codespace
                    ///   - devcontainerPath: Path to devcontainer.json config to use for this codespace
                    ///   - multiRepoPermissionsOptOut: Whether to authorize requested permissions from devcontainer.json
                    ///   - workingDirectory: Working directory for this codespace
                    ///   - idleTimeoutMinutes: Time in minutes before codespace stops from inactivity
                    ///   - displayName: Display name for this codespace
                    ///   - retentionPeriodMinutes: Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                    public init(
                        location: Swift.String? = nil,
                        geo: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body.JsonPayload.GeoPayload? = nil,
                        clientIp: Swift.String? = nil,
                        machine: Swift.String? = nil,
                        devcontainerPath: Swift.String? = nil,
                        multiRepoPermissionsOptOut: Swift.Bool? = nil,
                        workingDirectory: Swift.String? = nil,
                        idleTimeoutMinutes: Swift.Int? = nil,
                        displayName: Swift.String? = nil,
                        retentionPeriodMinutes: Swift.Int? = nil
                    ) {
                        self.location = location
                        self.geo = geo
                        self.clientIp = clientIp
                        self.machine = machine
                        self.devcontainerPath = devcontainerPath
                        self.multiRepoPermissionsOptOut = multiRepoPermissionsOptOut
                        self.workingDirectory = workingDirectory
                        self.idleTimeoutMinutes = idleTimeoutMinutes
                        self.displayName = displayName
                        self.retentionPeriodMinutes = retentionPeriodMinutes
                    }
                    public enum CodingKeys: String, CodingKey {
                        case location
                        case geo
                        case clientIp = "client_ip"
                        case machine
                        case devcontainerPath = "devcontainer_path"
                        case multiRepoPermissionsOptOut = "multi_repo_permissions_opt_out"
                        case workingDirectory = "working_directory"
                        case idleTimeoutMinutes = "idle_timeout_minutes"
                        case displayName = "display_name"
                        case retentionPeriodMinutes = "retention_period_minutes"
                    }
                }
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace was successfully created
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/repos/{owner}/{repo}/pulls/{pull_number}/codespaces/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace creation partially failed but is being retried in the background
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodespacesCreateWithPrForAuthenticatedUser.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//repos/{owner}/{repo}/pulls/{pull_number}/codespaces/post(codespaces/create-with-pr-for-authenticated-user)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List codespaces for the authenticated user
    ///
    /// Lists the authenticated user's codespaces.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)`.
    public enum CodespacesListForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/list-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// ID of the Repository to filter on
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/GET/query/repository_id`.
                public var repositoryId: Components.Parameters.RepositoryIdInQuery?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - repositoryId: ID of the Repository to filter on
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil,
                    repositoryId: Components.Parameters.RepositoryIdInQuery? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                    self.repositoryId = repositoryId
                }
            }
            public var query: Operations.CodespacesListForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/codespaces/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.CodespacesListForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesListForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/codespaces/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/codespaces/GET/responses/200/content/json/codespaces`.
                        public var codespaces: [Components.Schemas.Codespace]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - codespaces:
                        public init(
                            totalCount: Swift.Int,
                            codespaces: [Components.Schemas.Codespace]
                        ) {
                            self.totalCount = totalCount
                            self.codespaces = codespaces
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case codespaces
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/get(codespaces/list-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a codespace for the authenticated user
    ///
    /// Creates a new codespace, owned by the authenticated user.
    ///
    /// This endpoint requires either a `repository_id` OR a `pull_request` but not both.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces`.
    /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)`.
    public enum CodespacesCreateForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/create-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json`.
                @frozen public enum JsonPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1`.
                    public struct Case1Payload: Codable, Hashable, Sendable {
                        /// Repository id for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/repository_id`.
                        public var repositoryId: Swift.Int
                        /// Git ref (typically a branch name) for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/ref`.
                        public var ref: Swift.String?
                        /// The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/location`.
                        public var location: Swift.String?
                        /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/geo`.
                        @frozen public enum GeoPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case europeWest = "EuropeWest"
                            case southeastAsia = "SoutheastAsia"
                            case usEast = "UsEast"
                            case usWest = "UsWest"
                        }
                        /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/geo`.
                        public var geo: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case1Payload.GeoPayload?
                        /// IP for location auto-detection when proxying a request
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/client_ip`.
                        public var clientIp: Swift.String?
                        /// Machine type to use for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/machine`.
                        public var machine: Swift.String?
                        /// Path to devcontainer.json config to use for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/devcontainer_path`.
                        public var devcontainerPath: Swift.String?
                        /// Whether to authorize requested permissions from devcontainer.json
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/multi_repo_permissions_opt_out`.
                        public var multiRepoPermissionsOptOut: Swift.Bool?
                        /// Working directory for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/working_directory`.
                        public var workingDirectory: Swift.String?
                        /// Time in minutes before codespace stops from inactivity
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/idle_timeout_minutes`.
                        public var idleTimeoutMinutes: Swift.Int?
                        /// Display name for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/display_name`.
                        public var displayName: Swift.String?
                        /// Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1/retention_period_minutes`.
                        public var retentionPeriodMinutes: Swift.Int?
                        /// Creates a new `Case1Payload`.
                        ///
                        /// - Parameters:
                        ///   - repositoryId: Repository id for this codespace
                        ///   - ref: Git ref (typically a branch name) for this codespace
                        ///   - location: The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                        ///   - geo: The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///   - clientIp: IP for location auto-detection when proxying a request
                        ///   - machine: Machine type to use for this codespace
                        ///   - devcontainerPath: Path to devcontainer.json config to use for this codespace
                        ///   - multiRepoPermissionsOptOut: Whether to authorize requested permissions from devcontainer.json
                        ///   - workingDirectory: Working directory for this codespace
                        ///   - idleTimeoutMinutes: Time in minutes before codespace stops from inactivity
                        ///   - displayName: Display name for this codespace
                        ///   - retentionPeriodMinutes: Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
                        public init(
                            repositoryId: Swift.Int,
                            ref: Swift.String? = nil,
                            location: Swift.String? = nil,
                            geo: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case1Payload.GeoPayload? = nil,
                            clientIp: Swift.String? = nil,
                            machine: Swift.String? = nil,
                            devcontainerPath: Swift.String? = nil,
                            multiRepoPermissionsOptOut: Swift.Bool? = nil,
                            workingDirectory: Swift.String? = nil,
                            idleTimeoutMinutes: Swift.Int? = nil,
                            displayName: Swift.String? = nil,
                            retentionPeriodMinutes: Swift.Int? = nil
                        ) {
                            self.repositoryId = repositoryId
                            self.ref = ref
                            self.location = location
                            self.geo = geo
                            self.clientIp = clientIp
                            self.machine = machine
                            self.devcontainerPath = devcontainerPath
                            self.multiRepoPermissionsOptOut = multiRepoPermissionsOptOut
                            self.workingDirectory = workingDirectory
                            self.idleTimeoutMinutes = idleTimeoutMinutes
                            self.displayName = displayName
                            self.retentionPeriodMinutes = retentionPeriodMinutes
                        }
                        public enum CodingKeys: String, CodingKey {
                            case repositoryId = "repository_id"
                            case ref
                            case location
                            case geo
                            case clientIp = "client_ip"
                            case machine
                            case devcontainerPath = "devcontainer_path"
                            case multiRepoPermissionsOptOut = "multi_repo_permissions_opt_out"
                            case workingDirectory = "working_directory"
                            case idleTimeoutMinutes = "idle_timeout_minutes"
                            case displayName = "display_name"
                            case retentionPeriodMinutes = "retention_period_minutes"
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case1`.
                    case case1(Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case1Payload)
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2`.
                    public struct Case2Payload: Codable, Hashable, Sendable {
                        /// Pull request number for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/pull_request`.
                        public struct PullRequestPayload: Codable, Hashable, Sendable {
                            /// Pull request number
                            ///
                            /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/pull_request/pull_request_number`.
                            public var pullRequestNumber: Swift.Int
                            /// Repository id for this codespace
                            ///
                            /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/pull_request/repository_id`.
                            public var repositoryId: Swift.Int
                            /// Creates a new `PullRequestPayload`.
                            ///
                            /// - Parameters:
                            ///   - pullRequestNumber: Pull request number
                            ///   - repositoryId: Repository id for this codespace
                            public init(
                                pullRequestNumber: Swift.Int,
                                repositoryId: Swift.Int
                            ) {
                                self.pullRequestNumber = pullRequestNumber
                                self.repositoryId = repositoryId
                            }
                            public enum CodingKeys: String, CodingKey {
                                case pullRequestNumber = "pull_request_number"
                                case repositoryId = "repository_id"
                            }
                        }
                        /// Pull request number for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/pull_request`.
                        public var pullRequest: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case2Payload.PullRequestPayload
                        /// The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/location`.
                        public var location: Swift.String?
                        /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/geo`.
                        @frozen public enum GeoPayload: String, Codable, Hashable, Sendable, CaseIterable {
                            case europeWest = "EuropeWest"
                            case southeastAsia = "SoutheastAsia"
                            case usEast = "UsEast"
                            case usWest = "UsWest"
                        }
                        /// The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/geo`.
                        public var geo: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case2Payload.GeoPayload?
                        /// Machine type to use for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/machine`.
                        public var machine: Swift.String?
                        /// Path to devcontainer.json config to use for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/devcontainer_path`.
                        public var devcontainerPath: Swift.String?
                        /// Working directory for this codespace
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/working_directory`.
                        public var workingDirectory: Swift.String?
                        /// Time in minutes before codespace stops from inactivity
                        ///
                        /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2/idle_timeout_minutes`.
                        public var idleTimeoutMinutes: Swift.Int?
                        /// Creates a new `Case2Payload`.
                        ///
                        /// - Parameters:
                        ///   - pullRequest: Pull request number for this codespace
                        ///   - location: The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.
                        ///   - geo: The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is closing down.
                        ///   - machine: Machine type to use for this codespace
                        ///   - devcontainerPath: Path to devcontainer.json config to use for this codespace
                        ///   - workingDirectory: Working directory for this codespace
                        ///   - idleTimeoutMinutes: Time in minutes before codespace stops from inactivity
                        public init(
                            pullRequest: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case2Payload.PullRequestPayload,
                            location: Swift.String? = nil,
                            geo: Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case2Payload.GeoPayload? = nil,
                            machine: Swift.String? = nil,
                            devcontainerPath: Swift.String? = nil,
                            workingDirectory: Swift.String? = nil,
                            idleTimeoutMinutes: Swift.Int? = nil
                        ) {
                            self.pullRequest = pullRequest
                            self.location = location
                            self.geo = geo
                            self.machine = machine
                            self.devcontainerPath = devcontainerPath
                            self.workingDirectory = workingDirectory
                            self.idleTimeoutMinutes = idleTimeoutMinutes
                        }
                        public enum CodingKeys: String, CodingKey {
                            case pullRequest = "pull_request"
                            case location
                            case geo
                            case machine
                            case devcontainerPath = "devcontainer_path"
                            case workingDirectory = "working_directory"
                            case idleTimeoutMinutes = "idle_timeout_minutes"
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/json/case2`.
                    case case2(Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload.Case2Payload)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try value.encode(to: encoder)
                        case let .case2(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/paths/user/codespaces/POST/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.CodespacesCreateForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesCreateForAuthenticatedUser.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace was successfully created
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateForAuthenticatedUser.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateForAuthenticatedUser.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response when the codespace creation partially failed but is being retried in the background
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodespacesCreateForAuthenticatedUser.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodespacesCreateForAuthenticatedUser.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Service unavailable
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/post(codespaces/create-for-authenticated-user)/responses/503`.
            ///
            /// HTTP response code: `503 serviceUnavailable`.
            case serviceUnavailable(Components.Responses.ServiceUnavailable)
            /// The associated value of the enum case if `self` is `.serviceUnavailable`.
            ///
            /// - Throws: An error if `self` is not `.serviceUnavailable`.
            /// - SeeAlso: `.serviceUnavailable`.
            public var serviceUnavailable: Components.Responses.ServiceUnavailable {
                get throws {
                    switch self {
                    case let .serviceUnavailable(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "serviceUnavailable",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List secrets for the authenticated user
    ///
    /// Lists all development environment secrets available for a user's codespaces without revealing their
    /// encrypted values.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/get(codespaces/list-secrets-for-authenticated-user)`.
    public enum CodespacesListSecretsForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/list-secrets-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/query`.
            public struct Query: Sendable, Hashable {
                /// The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/query/per_page`.
                public var perPage: Components.Parameters.PerPage?
                /// The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/query/page`.
                public var page: Components.Parameters.Page?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - perPage: The number of results per page (max 100). For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                ///   - page: The page number of the results to fetch. For more information, see "[Using pagination in the REST API](https://docs.github.com/rest/using-the-rest-api/using-pagination-in-the-rest-api)."
                public init(
                    perPage: Components.Parameters.PerPage? = nil,
                    page: Components.Parameters.Page? = nil
                ) {
                    self.perPage = perPage
                    self.page = page
                }
            }
            public var query: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Query
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListSecretsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListSecretsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Query = .init(),
                headers: Operations.CodespacesListSecretsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/headers/Link`.
                    public var link: Components.Headers.Link?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - link:
                    public init(link: Components.Headers.Link? = nil) {
                        self.link = link
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/content/json/secrets`.
                        public var secrets: [Components.Schemas.CodespacesSecret]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - secrets:
                        public init(
                            totalCount: Swift.Int,
                            secrets: [Components.Schemas.CodespacesSecret]
                        ) {
                            self.totalCount = totalCount
                            self.secrets = secrets
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case secrets
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Headers = .init(),
                    body: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/get(codespaces/list-secrets-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListSecretsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get public key for the authenticated user
    ///
    /// Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/public-key`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/public-key/get(codespaces/get-public-key-for-authenticated-user)`.
    public enum CodespacesGetPublicKeyForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/get-public-key-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/public-key/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetPublicKeyForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetPublicKeyForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/public-key/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/public-key/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesUserPublicKey)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesUserPublicKey {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/public-key/get(codespaces/get-public-key-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetPublicKeyForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a secret for the authenticated user
    ///
    /// Gets a development environment secret available to a user's codespaces without revealing its encrypted value.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/get(codespaces/get-secret-for-authenticated-user)`.
    public enum CodespacesGetSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/get-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                public init(secretName: Components.Parameters.SecretName) {
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesGetSecretForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespacesSecret)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespacesSecret {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetSecretForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetSecretForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/get(codespaces/get-secret-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetSecretForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetSecretForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create or update a secret for the authenticated user
    ///
    /// Creates or updates a development environment secret for a user's codespace with an encrypted value. Encrypt your secret using
    /// [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)`.
    public enum CodespacesCreateOrUpdateSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/create-or-update-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                public init(secretName: Components.Parameters.SecretName) {
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get the public key for the authenticated user](https://docs.github.com/rest/codespaces/secrets#get-public-key-for-the-authenticated-user) endpoint.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/encrypted_value`.
                    public var encryptedValue: Swift.String?
                    /// ID of the key you used to encrypt the secret.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/key_id`.
                    public var keyId: Swift.String
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/SelectedRepositoryIdsPayload`.
                    public struct SelectedRepositoryIdsPayloadPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/SelectedRepositoryIdsPayload/value1`.
                        public var value1: Swift.Int?
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/SelectedRepositoryIdsPayload/value2`.
                        public var value2: Swift.String?
                        /// Creates a new `SelectedRepositoryIdsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - value1:
                        ///   - value2:
                        public init(
                            value1: Swift.Int? = nil,
                            value2: Swift.String? = nil
                        ) {
                            self.value1 = value1
                            self.value2 = value2
                        }
                        public init(from decoder: any Decoder) throws {
                            var errors: [any Error] = []
                            do {
                                self.value1 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            do {
                                self.value2 = try decoder.decodeFromSingleValueContainer()
                            } catch {
                                errors.append(error)
                            }
                            try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                                [
                                    self.value1,
                                    self.value2
                                ],
                                type: Self.self,
                                codingPath: decoder.codingPath,
                                errors: errors
                            )
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeFirstNonNilValueToSingleValueContainer([
                                self.value1,
                                self.value2
                            ])
                        }
                    }
                    /// An array of repository ids that can access the user secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Set selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/selected_repository_ids`.
                    public typealias SelectedRepositoryIdsPayload = [Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body.JsonPayload.SelectedRepositoryIdsPayloadPayload]
                    /// An array of repository ids that can access the user secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Set selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body.JsonPayload.SelectedRepositoryIdsPayload?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - encryptedValue: Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get the public key for the authenticated user](https://docs.github.com/rest/codespaces/secrets#get-public-key-for-the-authenticated-user) endpoint.
                    ///   - keyId: ID of the key you used to encrypt the secret.
                    ///   - selectedRepositoryIds: An array of repository ids that can access the user secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Set selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.
                    public init(
                        encryptedValue: Swift.String? = nil,
                        keyId: Swift.String,
                        selectedRepositoryIds: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body.JsonPayload.SelectedRepositoryIdsPayload? = nil
                    ) {
                        self.encryptedValue = encryptedValue
                        self.keyId = keyId
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case encryptedValue = "encrypted_value"
                        case keyId = "key_id"
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/PUT/responses/201/content/application\/json`.
                    case json(Components.Schemas.EmptyObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.EmptyObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response after successfully creating a secret
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response after successfully updating a secret
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.NoContent)
            /// Response after successfully updating a secret
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesCreateOrUpdateSecretForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/put(codespaces/create-or-update-secret-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a secret for the authenticated user
    ///
    /// Deletes a development environment secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/delete(codespaces/delete-secret-for-authenticated-user)`.
    public enum CodespacesDeleteSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/delete-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                public init(secretName: Components.Parameters.SecretName) {
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesDeleteSecretForAuthenticatedUser.Input.Path
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            public init(path: Operations.CodespacesDeleteSecretForAuthenticatedUser.Input.Path) {
                self.path = path
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/delete(codespaces/delete-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesDeleteSecretForAuthenticatedUser.Output.NoContent)
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/delete(codespaces/delete-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesDeleteSecretForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
    }
    /// List selected repositories for a user secret
    ///
    /// List the repositories that have been granted the ability to use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)`.
    public enum CodespacesListRepositoriesForSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/list-repositories-for-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                public init(secretName: Components.Parameters.SecretName) {
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/json/repositories`.
                        public var repositories: [Components.Schemas.MinimalRepository]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - repositories:
                        public init(
                            totalCount: Swift.Int,
                            repositories: [Components.Schemas.MinimalRepository]
                        ) {
                            self.totalCount = totalCount
                            self.repositories = repositories
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case repositories
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesListRepositoriesForSecretForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/get(codespaces/list-repositories-for-secret-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Set selected repositories for a user secret
    ///
    /// Select the repositories that will use a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)`.
    public enum CodespacesSetRepositoriesForSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/set-repositories-for-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                public init(secretName: Components.Parameters.SecretName) {
                    self.secretName = secretName
                }
            }
            public var path: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// An array of repository ids for which a codespace can access the secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Add a selected repository to a user secret](https://docs.github.com/rest/codespaces/secrets#add-a-selected-repository-to-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/json/selected_repository_ids`.
                    public var selectedRepositoryIds: [Swift.Int]
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - selectedRepositoryIds: An array of repository ids for which a codespace can access the secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Add a selected repository to a user secret](https://docs.github.com/rest/codespaces/secrets#add-a-selected-repository-to-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.
                    public init(selectedRepositoryIds: [Swift.Int]) {
                        self.selectedRepositoryIds = selectedRepositoryIds
                    }
                    public enum CodingKeys: String, CodingKey {
                        case selectedRepositoryIds = "selected_repository_ids"
                    }
                }
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/PUT/requestBody/content/application\/json`.
                case json(Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No Content when repositories were added to the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Output.NoContent)
            /// No Content when repositories were added to the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesSetRepositoriesForSecretForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/put(codespaces/set-repositories-for-secret-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Add a selected repository to a user secret
    ///
    /// Adds a repository to the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PUT /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)`.
    public enum CodespacesAddRepositoryForSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/add-repository-for-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/PUT/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Output.NoContent)
            /// No Content when repository was added to the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesAddRepositoryForSecretForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/put(codespaces/add-repository-for-secret-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Remove a selected repository from a user secret
    ///
    /// Removes a repository from the selected repositories for a user's development environment secret.
    ///
    /// The authenticated user must have Codespaces access to use this endpoint.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/secrets/{secret_name}/repositories/{repository_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)`.
    public enum CodespacesRemoveRepositoryForSecretForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/remove-repository-for-secret-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the secret.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/secret_name`.
                public var secretName: Components.Parameters.SecretName
                /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/path/repository_id`.
                public var repositoryId: Swift.Int
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - secretName: The name of the secret.
                ///   - repositoryId:
                public init(
                    secretName: Components.Parameters.SecretName,
                    repositoryId: Swift.Int
                ) {
                    self.secretName = secretName
                    self.repositoryId = repositoryId
                }
            }
            public var path: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/secrets/{secret_name}/repositories/{repository_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct NoContent: Sendable, Hashable {
                /// Creates a new `NoContent`.
                public init() {}
            }
            /// No Content when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            case noContent(Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Output.NoContent)
            /// No Content when repository was removed from the selected list
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/204`.
            ///
            /// HTTP response code: `204 noContent`.
            public static var noContent: Self {
                .noContent(.init())
            }
            /// The associated value of the enum case if `self` is `.noContent`.
            ///
            /// - Throws: An error if `self` is not `.noContent`.
            /// - SeeAlso: `.noContent`.
            public var noContent: Operations.CodespacesRemoveRepositoryForSecretForAuthenticatedUser.Output.NoContent {
                get throws {
                    switch self {
                    case let .noContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "noContent",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/secrets/{secret_name}/repositories/{repository_id}/delete(codespaces/remove-repository-for-secret-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get a codespace for the authenticated user
    ///
    /// Gets information about a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)`.
    public enum CodespacesGetForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/get-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/GET/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesGetForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesGetForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/get(codespaces/get-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Update a codespace for the authenticated user
    ///
    /// Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.
    ///
    /// If you specify a new machine type it will be applied the next time your codespace is started.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `PATCH /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)`.
    public enum CodespacesUpdateForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/update-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesUpdateForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesUpdateForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesUpdateForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesUpdateForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A valid machine to transition this codespace to.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody/json/machine`.
                    public var machine: Swift.String?
                    /// Display name for this codespace
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody/json/display_name`.
                    public var displayName: Swift.String?
                    /// Recently opened folders inside the codespace. It is currently used by the clients to determine the folder path to load the codespace in.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody/json/recent_folders`.
                    public var recentFolders: [Swift.String]?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - machine: A valid machine to transition this codespace to.
                    ///   - displayName: Display name for this codespace
                    ///   - recentFolders: Recently opened folders inside the codespace. It is currently used by the clients to determine the folder path to load the codespace in.
                    public init(
                        machine: Swift.String? = nil,
                        displayName: Swift.String? = nil,
                        recentFolders: [Swift.String]? = nil
                    ) {
                        self.machine = machine
                        self.displayName = displayName
                        self.recentFolders = recentFolders
                    }
                    public enum CodingKeys: String, CodingKey {
                        case machine
                        case displayName = "display_name"
                        case recentFolders = "recent_folders"
                    }
                }
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/requestBody/content/application\/json`.
                case json(Operations.CodespacesUpdateForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesUpdateForAuthenticatedUser.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesUpdateForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesUpdateForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesUpdateForAuthenticatedUser.Input.Body? = nil
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/PATCH/responses/200/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesUpdateForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesUpdateForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesUpdateForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesUpdateForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/patch(codespaces/update-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a codespace for the authenticated user
    ///
    /// Deletes a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `DELETE /user/codespaces/{codespace_name}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)`.
    public enum CodespacesDeleteForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/delete-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/DELETE/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesDeleteForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesDeleteForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesDeleteForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesDeleteForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesDeleteForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            /// Accepted
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Components.Responses.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Components.Responses.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/delete(codespaces/delete-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Export a codespace for the authenticated user
    ///
    /// Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.
    ///
    /// If changes cannot be pushed to the codespace's repository, they will be pushed to a new or previously-existing fork instead.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/exports`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)`.
    public enum CodespacesExportForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/export-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/POST/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesExportForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesExportForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesExportForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesExportForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesExportForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesExportForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Accepted: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/POST/responses/202/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/POST/responses/202/content/application\/json`.
                    case json(Components.Schemas.CodespaceExportDetails)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespaceExportDetails {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesExportForAuthenticatedUser.Output.Accepted.Body
                /// Creates a new `Accepted`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesExportForAuthenticatedUser.Output.Accepted.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/202`.
            ///
            /// HTTP response code: `202 accepted`.
            case accepted(Operations.CodespacesExportForAuthenticatedUser.Output.Accepted)
            /// The associated value of the enum case if `self` is `.accepted`.
            ///
            /// - Throws: An error if `self` is not `.accepted`.
            /// - SeeAlso: `.accepted`.
            public var accepted: Operations.CodespacesExportForAuthenticatedUser.Output.Accepted {
                get throws {
                    switch self {
                    case let .accepted(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "accepted",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/post(codespaces/export-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get details about a codespace export
    ///
    /// Gets information about an export of a codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/exports/{export_id}`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/{export_id}/get(codespaces/get-export-details-for-authenticated-user)`.
    public enum CodespacesGetExportDetailsForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/get-export-details-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// The ID of the export operation, or `latest`. Currently only `latest` is currently supported.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/path/export_id`.
                public var exportId: Components.Parameters.ExportId
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                ///   - exportId: The ID of the export operation, or `latest`. Currently only `latest` is currently supported.
                public init(
                    codespaceName: Components.Parameters.CodespaceName,
                    exportId: Components.Parameters.ExportId
                ) {
                    self.codespaceName = codespaceName
                    self.exportId = exportId
                }
            }
            public var path: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetExportDetailsForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesGetExportDetailsForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/exports/{export_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.CodespaceExportDetails)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespaceExportDetails {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/{export_id}/get(codespaces/get-export-details-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesGetExportDetailsForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/exports/{export_id}/get(codespaces/get-export-details-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List machine types for a codespace
    ///
    /// List the machine types a codespace can transition to use.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `GET /user/codespaces/{codespace_name}/machines`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)`.
    public enum CodespacesCodespaceMachinesForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/codespace-machines-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCodespaceMachinesForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesCodespaceMachinesForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/responses/200/content/json`.
                    public struct JsonPayload: Codable, Hashable, Sendable {
                        /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/responses/200/content/json/total_count`.
                        public var totalCount: Swift.Int
                        /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/responses/200/content/json/machines`.
                        public var machines: [Components.Schemas.CodespaceMachine]
                        /// Creates a new `JsonPayload`.
                        ///
                        /// - Parameters:
                        ///   - totalCount:
                        ///   - machines:
                        public init(
                            totalCount: Swift.Int,
                            machines: [Components.Schemas.CodespaceMachine]
                        ) {
                            self.totalCount = totalCount
                            self.machines = machines
                        }
                        public enum CodingKeys: String, CodingKey {
                            case totalCount = "total_count"
                            case machines
                        }
                    }
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/machines/GET/responses/200/content/application\/json`.
                    case json(Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok.Body.JsonPayload)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok.Body.JsonPayload {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesCodespaceMachinesForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/machines/get(codespaces/codespace-machines-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a repository from an unpublished codespace
    ///
    /// Publishes an unpublished codespace, creating a new repository and assigning it to the codespace.
    ///
    /// The codespace's token is granted write permissions to the repository, allowing the user to push their changes.
    ///
    /// This will fail for a codespace that is already published, meaning it has an associated repository.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/publish`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)`.
    public enum CodespacesPublishForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/publish-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesPublishForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesPublishForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesPublishForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesPublishForAuthenticatedUser.Input.Headers
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/requestBody/json`.
                public struct JsonPayload: Codable, Hashable, Sendable {
                    /// A name for the new repository.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/requestBody/json/name`.
                    public var name: Swift.String?
                    /// Whether the new repository should be private.
                    ///
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/requestBody/json/private`.
                    public var _private: Swift.Bool?
                    /// Creates a new `JsonPayload`.
                    ///
                    /// - Parameters:
                    ///   - name: A name for the new repository.
                    ///   - _private: Whether the new repository should be private.
                    public init(
                        name: Swift.String? = nil,
                        _private: Swift.Bool? = nil
                    ) {
                        self.name = name
                        self._private = _private
                    }
                    public enum CodingKeys: String, CodingKey {
                        case name
                        case _private = "private"
                    }
                }
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/requestBody/content/application\/json`.
                case json(Operations.CodespacesPublishForAuthenticatedUser.Input.Body.JsonPayload)
            }
            public var body: Operations.CodespacesPublishForAuthenticatedUser.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.CodespacesPublishForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesPublishForAuthenticatedUser.Input.Headers = .init(),
                body: Operations.CodespacesPublishForAuthenticatedUser.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Created: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/responses/201/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/publish/POST/responses/201/content/application\/json`.
                    case json(Components.Schemas.CodespaceWithFullRepository)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CodespaceWithFullRepository {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesPublishForAuthenticatedUser.Output.Created.Body
                /// Creates a new `Created`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesPublishForAuthenticatedUser.Output.Created.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)/responses/201`.
            ///
            /// HTTP response code: `201 created`.
            case created(Operations.CodespacesPublishForAuthenticatedUser.Output.Created)
            /// The associated value of the enum case if `self` is `.created`.
            ///
            /// - Throws: An error if `self` is not `.created`.
            /// - SeeAlso: `.created`.
            public var created: Operations.CodespacesPublishForAuthenticatedUser.Output.Created {
                get throws {
                    switch self {
                    case let .created(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "created",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Validation failed, or the endpoint has been spammed.
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/publish/post(codespaces/publish-for-authenticated-user)/responses/422`.
            ///
            /// HTTP response code: `422 unprocessableContent`.
            case unprocessableContent(Components.Responses.ValidationFailed)
            /// The associated value of the enum case if `self` is `.unprocessableContent`.
            ///
            /// - Throws: An error if `self` is not `.unprocessableContent`.
            /// - SeeAlso: `.unprocessableContent`.
            public var unprocessableContent: Components.Responses.ValidationFailed {
                get throws {
                    switch self {
                    case let .unprocessableContent(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unprocessableContent",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Start a codespace for the authenticated user
    ///
    /// Starts a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/start`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)`.
    public enum CodespacesStartForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/start-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesStartForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStartForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStartForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesStartForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesStartForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesStartForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesStartForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesStartForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesStartForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesStartForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            case notModified(Components.Responses.NotModified)
            /// Not modified
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/304`.
            ///
            /// HTTP response code: `304 notModified`.
            public static var notModified: Self {
                .notModified(.init())
            }
            /// The associated value of the enum case if `self` is `.notModified`.
            ///
            /// - Throws: An error if `self` is not `.notModified`.
            /// - SeeAlso: `.notModified`.
            public var notModified: Components.Responses.NotModified {
                get throws {
                    switch self {
                    case let .notModified(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notModified",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Bad Request
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/400`.
            ///
            /// HTTP response code: `400 badRequest`.
            case badRequest(Components.Responses.BadRequest)
            /// The associated value of the enum case if `self` is `.badRequest`.
            ///
            /// - Throws: An error if `self` is not `.badRequest`.
            /// - SeeAlso: `.badRequest`.
            public var badRequest: Components.Responses.BadRequest {
                get throws {
                    switch self {
                    case let .badRequest(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "badRequest",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            public struct Code402: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/responses/402/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/start/POST/responses/402/content/application\/json`.
                    case json(Components.Schemas.BasicError)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.BasicError {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesStartForAuthenticatedUser.Output.Code402.Body
                /// Creates a new `Code402`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesStartForAuthenticatedUser.Output.Code402.Body) {
                    self.body = body
                }
            }
            /// Payment required
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/402`.
            ///
            /// HTTP response code: `402 code402`.
            case code402(Operations.CodespacesStartForAuthenticatedUser.Output.Code402)
            /// The associated value of the enum case if `self` is `.code402`.
            ///
            /// - Throws: An error if `self` is not `.code402`.
            /// - SeeAlso: `.code402`.
            public var code402: Operations.CodespacesStartForAuthenticatedUser.Output.Code402 {
                get throws {
                    switch self {
                    case let .code402(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "code402",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Conflict
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/start/post(codespaces/start-for-authenticated-user)/responses/409`.
            ///
            /// HTTP response code: `409 conflict`.
            case conflict(Components.Responses.Conflict)
            /// The associated value of the enum case if `self` is `.conflict`.
            ///
            /// - Throws: An error if `self` is not `.conflict`.
            /// - SeeAlso: `.conflict`.
            public var conflict: Components.Responses.Conflict {
                get throws {
                    switch self {
                    case let .conflict(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "conflict",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case applicationScimJson
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                case "application/scim+json":
                    self = .applicationScimJson
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                case .applicationScimJson:
                    return "application/scim+json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json,
                    .applicationScimJson
                ]
            }
        }
    }
    /// Stop a codespace for the authenticated user
    ///
    /// Stops a user's codespace.
    ///
    /// OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.
    ///
    /// - Remark: HTTP `POST /user/codespaces/{codespace_name}/stop`.
    /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)`.
    public enum CodespacesStopForAuthenticatedUser {
        public static let id: Swift.String = "codespaces/stop-for-authenticated-user"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/stop/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The name of the codespace.
                ///
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/stop/POST/path/codespace_name`.
                public var codespaceName: Components.Parameters.CodespaceName
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - codespaceName: The name of the codespace.
                public init(codespaceName: Components.Parameters.CodespaceName) {
                    self.codespaceName = codespaceName
                }
            }
            public var path: Operations.CodespacesStopForAuthenticatedUser.Input.Path
            /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/stop/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStopForAuthenticatedUser.AcceptableContentType>]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(accept: [OpenAPIRuntime.AcceptHeaderContentType<Operations.CodespacesStopForAuthenticatedUser.AcceptableContentType>] = .defaultValues()) {
                    self.accept = accept
                }
            }
            public var headers: Operations.CodespacesStopForAuthenticatedUser.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.CodespacesStopForAuthenticatedUser.Input.Path,
                headers: Operations.CodespacesStopForAuthenticatedUser.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/stop/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/user/codespaces/{codespace_name}/stop/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.Codespace)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Codespace {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.CodespacesStopForAuthenticatedUser.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.CodespacesStopForAuthenticatedUser.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// Response
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.CodespacesStopForAuthenticatedUser.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.CodespacesStopForAuthenticatedUser.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Internal Error
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)/responses/500`.
            ///
            /// HTTP response code: `500 internalServerError`.
            case internalServerError(Components.Responses.InternalError)
            /// The associated value of the enum case if `self` is `.internalServerError`.
            ///
            /// - Throws: An error if `self` is not `.internalServerError`.
            /// - SeeAlso: `.internalServerError`.
            public var internalServerError: Components.Responses.InternalError {
                get throws {
                    switch self {
                    case let .internalServerError(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "internalServerError",
                            response: self
                        )
                    }
                }
            }
            /// Requires authentication
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)/responses/401`.
            ///
            /// HTTP response code: `401 unauthorized`.
            case unauthorized(Components.Responses.RequiresAuthentication)
            /// The associated value of the enum case if `self` is `.unauthorized`.
            ///
            /// - Throws: An error if `self` is not `.unauthorized`.
            /// - SeeAlso: `.unauthorized`.
            public var unauthorized: Components.Responses.RequiresAuthentication {
                get throws {
                    switch self {
                    case let .unauthorized(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "unauthorized",
                            response: self
                        )
                    }
                }
            }
            /// Forbidden
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)/responses/403`.
            ///
            /// HTTP response code: `403 forbidden`.
            case forbidden(Components.Responses.Forbidden)
            /// The associated value of the enum case if `self` is `.forbidden`.
            ///
            /// - Throws: An error if `self` is not `.forbidden`.
            /// - SeeAlso: `.forbidden`.
            public var forbidden: Components.Responses.Forbidden {
                get throws {
                    switch self {
                    case let .forbidden(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "forbidden",
                            response: self
                        )
                    }
                }
            }
            /// Resource not found
            ///
            /// - Remark: Generated from `#/paths//user/codespaces/{codespace_name}/stop/post(codespaces/stop-for-authenticated-user)/responses/404`.
            ///
            /// HTTP response code: `404 notFound`.
            case notFound(Components.Responses.NotFound)
            /// The associated value of the enum case if `self` is `.notFound`.
            ///
            /// - Throws: An error if `self` is not `.notFound`.
            /// - SeeAlso: `.notFound`.
            public var notFound: Components.Responses.NotFound {
                get throws {
                    switch self {
                    case let .notFound(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "notFound",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
